

class FeatureLibError(Exception):
    def __init__(self, message, location):
        Exception.__init__(self, message)
        self.location = location

    def __str__(self):
        message = Exception.__str__(self)
        if self.location:
            path, line, column = self.location
            return f"{path}:{line}:{column}: {message}"
        else:
            return message


class IncludedFeaNotFound(FeatureLibError):
    def __str__(self):
        assert self.location is not None

        message = (
            "The following feature file should be included but cannot be found: "
            f"{Exception.__str__(self)}"
        )
        path, line, column = self.location
        return f"{path}:{line}:{column}: {message}"
