/* $Id: networktest.c,v 1.5 2003/06/08 17:38:16 sjoerd Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>

#include <global.h>
#include <network.h>
#include <list.h>

#ifndef NDEBUG
int debugmask = DNETWORK;
#endif

int
main(int argc, char **argv) {
  Network_listener *l;
  Network_connection *c = NULL;
  Network_packet *p;
  List *list = new_list();
  char string[] = "aapnootmies";


  if (argc == 1) {
    l = new_network_listener(4321,AF_UNSPEC);
    if (l == NULL) {
      printf("Listening failed\n");
      exit(1);
    }
    list_append(list,l);
    while ((c = network_listener_pop(l)) == NULL) {
      network_update(list,NULL,0);
    }
    list_del(list,l);
    del_network_listener(l);
  } else if (argc == 2) {
    c = new_network_connection(argv[1],4321);
    if (c == NULL) {
      printf("connection failed\n");
      exit(1);
    }
  }
  list_append(list,c);
  p = new_network_packet(20);
  memcpy(p->data,string,sizeof(string));
  network_connection_sent(c,p);
  del_network_packet(p);
  while ((network_connection_state(c) == NW_OK) &&
         (p = network_connection_pop(c)) == NULL) {
      network_update(NULL,list,0);
  }
  if (p!=NULL)
    printf("-> %s\n",p->data);
  else
    printf("Connection closed to early\n");
  exit(0);
}

