/* $Id$ 
 * FAUmachine main simulation functionality (stripped to necessary parts)
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_MAIN_H_INCLUDED
#define __GLUE_MAIN_H_INCLUDED

#include <stdint.h>

/** Get virtual time.
 *  @return virtual time in TIME_HZ ticks.
 */
extern unsigned long long
fauhdli_time_virt(void);

/** Register a timer to call func with parameter data as soon as the
 *  simulation time tsc is reached.
 *  @param tsc virtual timestamp counter, 1 second == 1 * TIME_HZ.
 *  @param func callback that will be called.
 *  @param data parameter to the callback.
 */
extern void
fauhdli_time_call_at(unsigned long long tsc, void (*func)(void *data), void *data);

/** delete a registered timer from time_call_at.
 *  @param func callback that would have been called.
 *  @param data data that would have been the argument (must match
 *         data from time_call_at/time_call_after).
 *  @return 0 for success, 1 if the timer was not found.
 */
extern int
fauhdli_time_call_delete(void (*func)(void *), void *data);

/** Stop simulation node.
 */
extern void
fauhdli_simulation_quit(int status);

/** execute the main event loop
 *  @return exit status.
 */
extern int
fauhdli_main_event_loop(void);

#endif /* __GLUE_MAIN_H_INCLUDED */
