# Generated by Django 3.2.19 on 2023-06-22 08:34

import django.db.models.deletion
from django.db import migrations, models

import taggit.managers


class Migration(migrations.Migration):
    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("tests", "0005_auto_20210713_2301"),
    ]

    operations = [
        migrations.CreateModel(
            name="TenantTag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("slug", models.SlugField(allow_unicode=True, max_length=100)),
                ("tenant_id", models.IntegerField()),
            ],
            options={
                "unique_together": {("name", "tenant_id"), ("slug", "tenant_id")},
            },
        ),
        migrations.AlterField(
            model_name="officialtag",
            name="slug",
            field=models.SlugField(
                allow_unicode=True, max_length=100, unique=True, verbose_name="slug"
            ),
        ),
        migrations.AlterField(
            model_name="trackedtag",
            name="slug",
            field=models.SlugField(
                allow_unicode=True, max_length=100, unique=True, verbose_name="slug"
            ),
        ),
        migrations.AlterField(
            model_name="uuidtag",
            name="slug",
            field=models.SlugField(
                allow_unicode=True, max_length=100, unique=True, verbose_name="slug"
            ),
        ),
        migrations.CreateModel(
            name="TenantTaggedItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "object_id",
                    models.IntegerField(db_index=True, verbose_name="object ID"),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tests_tenanttaggeditem_tagged_items",
                        to="contenttypes.contenttype",
                        verbose_name="content type",
                    ),
                ),
                (
                    "tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tests_tenanttaggeditem_items",
                        to="tests.tenanttag",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TenantModel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        help_text="A comma-separated list of tags.",
                        through="tests.TenantTaggedItem",
                        to="tests.TenantTag",
                        verbose_name="Tags",
                    ),
                ),
            ],
        ),
    ]
