
#ifndef UTIL_PDF_STRINGIZE_H
#define UTIL_PDF_STRINGIZE_H

#include <string>

// ---------------------------------------------------------------------
// To convert a string to a PDF string object.
// ---------------------------------------------------------------------

// Note: The function pdf_stringize( char c ) returns only the
// PDF-string representation of the character c; it does not enclose the
// result in parentheses as the other pdf_stringize() functions do.  For
// the latter effect, one can call pdf_stringize( string( 1, c ) ).
// [Arguably, pdf_stringize( char c ) might be given a separate name for
// this reason, such as pdf_stringcharize( char c ), but at present no
// separate name is given.]

namespace Util {
  std::string pdf_stringize( char c );
  std::string pdf_stringize( const std::string &s );
  std::string pdf_stringize( const char *s );
}

#endif

