#include "backenddef"

unsigned BackendDef::min_wt;
unsigned BackendDef::max_wt;
bool BackendDef::minmax_wt_set = false;

BackendDef::BackendDef (string server, string port,
			string maxclients, string w) :
    srv(server), prt(-1), max(0), host_match(""), url_match(""),
    wt(1), backend_check() {

    if (sscanf (port.c_str(), "%d", &prt) < 1)
	throw Error("Bad backend port specifier: '" + port +
		    "' is not a number");
    if (maxclients.size() &&
	sscanf (maxclients.c_str(), "%u", &max) < 1)
	throw Error("Bad maximum connections specifier: '" +
		    maxclients + "' is not a number");

    unsigned ww;
    if (sscanf(w.c_str(), "%u", &ww) < 1)
	throw Error("Bad backend weight specifier: '" + w +
		    "' is not a number");
    if (ww < 1)
	throw Error("Weights less than 1 are not supported");
    weight(ww);
}
