program t_cmor_fx_basin

  use cmor_users_functions

  implicit none

  !--- Cmor variable/axis ID's
  integer :: id_xaxis, id_yaxis, curr_vid
  integer, allocatable :: dimids(:)
  integer :: error_flag

  !--- Ocean grid
  integer, parameter :: nlat_o=192,  nlon_o=256
  double precision, dimension(nlat_o)   :: lat_o
  double precision, dimension(nlat_o+1) :: lat_o_bnds
  double precision, dimension(nlon_o)   :: lon_o
  double precision, dimension(nlon_o+1) :: lon_o_bnds
  integer, dimension(nlon_o,nlat_o) :: crap
  !--- Misc
!  character(256)  :: outpath = 'CMIP6'
!  character(1024) :: source = 'CanESM2 2010 atmosphere: CanAM4 (AGCM15i, T63L35)'
!  character(1024) :: global_comment = ' '
!  character(1024) :: references = 'http://www.cccma.ec.gc.ca/models'
!  character(1024) :: history = ' '
!  character(256)  :: institution = &
!    'CCCma (Canadian Centre for Climate Modelling and Analysis, Victoria, BC, Canada)'
!  character(64)   :: institute_id = 'CCCma'
!  character(64)   :: experiment_id = 'piControl'
!  character(64)   :: contact = 'cccma_info@ec.gc.ca'
!  character(64)   :: time_units = 'days since 1850-1-1'
!  character(64)   :: calendar = '365_day'
!  character(64)   :: model_id = 'CanESM2'
!  character(1024) :: forcing = 'N/A'
!  character(64)   :: parent_experiment_id = 'N/A'
!  character(64)   :: parent_experiment_rip = 'N/A'
!  character(64)   :: mip_table = 'CMIP5_Amon'
  character(128)  :: var_name = ' '
  character(128)  :: var_units = 'K'
  character(512)  :: var_history = ' '
  character(512)  :: var_comment = ' '
  character(512)  :: var_positive = ' '
  double precision :: branch_time=0.d0

  !===============================================================================
  !===============================================================================

  error_flag = cmor_setup(inpath='Tables',     &
                 netcdf_file_action=CMOR_REPLACE,    &
                 exit_control=CMOR_EXIT_ON_MAJOR,  &
                 create_subdirectories=1)

  if (error_flag.ne.0) then
    write(6,*)'Error in cmor_setup: ',error_flag
    stop
  endif

  error_flag = cmor_dataset_json("Test/CMOR_input_example.json")

  if (error_flag.ne.0) then
    write(6,*)"Error in cmor_dataset: ",error_flag
    stop
  endif

  call def_ogrid(nlon_o, nlat_o, lon_o, lon_o_bnds, lat_o, lat_o_bnds)

  id_yaxis = cmor_axis(        &
       table="CMIP6_Ofx.json",    &
       table_entry='latitude',   &
       units='degrees_north',    &  
       length=nlat_o,            &
       coord_vals=lat_o,         & 
       cell_bounds=lat_o_bnds)

  id_xaxis = cmor_axis(  &
       table="CMIP6_Ofx.json",    &
       table_entry='longitude',  &
       length=nlon_o,            &
       units='degrees_east',     &
       coord_vals=lon_o,         &
       cell_bounds=lon_o_bnds)

  var_name = "basin"
  ! var_name = "areacello"

  curr_vid = cmor_variable(              &
      table="CMIP6_Ofx.json",                  &
      table_entry=trim(var_name),        &
      units="1",                         &
      axis_ids=(/ id_xaxis, id_yaxis /), &
      missing_value=2333,              &
      positive=trim(var_positive),       &
      original_name="BASIN",             &
      history=trim(var_history),         &
      comment=trim(var_comment) )


  error_flag = cmor_write(curr_vid,crap)

  error_flag = cmor_close()

  if (error_flag.ne.0) then
    write(6,*)"Error in cmor_close: ",error_flag
    stop
  endif

end program t_cmor_fx_basin

subroutine def_ogrid(nlon_o, nlat_o, lon_o, lon_o_bnds, lat_o, lat_o_bnds)
  integer :: nlon_o, nlat_o
  double precision :: lon_o(nlon_o), lon_o_bnds(nlon_o+1), lat_o(nlat_o), lat_o_bnds(nlat_o+1)

  lon_o = (/ & 
 -7.0313D-01, 7.0313D-01, 2.1094D+00, 3.5156D+00, 4.9219D+00, 6.3281D+00, 7.7344D+00, 9.1406D+00, 1.0547D+01, 1.1953D+01 &
, 1.3359D+01, 1.4766D+01, 1.6172D+01, 1.7578D+01, 1.8984D+01, 2.0391D+01, 2.1797D+01, 2.3203D+01, 2.4609D+01, 2.6016D+01 &
, 2.7422D+01, 2.8828D+01, 3.0234D+01, 3.1641D+01, 3.3047D+01, 3.4453D+01, 3.5859D+01, 3.7266D+01, 3.8672D+01, 4.0078D+01 &
, 4.1484D+01, 4.2891D+01, 4.4297D+01, 4.5703D+01, 4.7109D+01, 4.8516D+01, 4.9922D+01, 5.1328D+01, 5.2734D+01, 5.4141D+01 &
, 5.5547D+01, 5.6953D+01, 5.8359D+01, 5.9766D+01, 6.1172D+01, 6.2578D+01, 6.3984D+01, 6.5391D+01, 6.6797D+01, 6.8203D+01 &
, 6.9609D+01, 7.1016D+01, 7.2422D+01, 7.3828D+01, 7.5234D+01, 7.6641D+01, 7.8047D+01, 7.9453D+01, 8.0859D+01, 8.2266D+01 &
, 8.3672D+01, 8.5078D+01, 8.6484D+01, 8.7891D+01, 8.9297D+01, 9.0703D+01, 9.2109D+01, 9.3516D+01, 9.4922D+01, 9.6328D+01 &
, 9.7734D+01, 9.9141D+01, 1.0055D+02, 1.0195D+02, 1.0336D+02, 1.0477D+02, 1.0617D+02, 1.0758D+02, 1.0898D+02, 1.1039D+02 &
, 1.1180D+02, 1.1320D+02, 1.1461D+02, 1.1602D+02, 1.1742D+02, 1.1883D+02, 1.2023D+02, 1.2164D+02, 1.2305D+02, 1.2445D+02 &
, 1.2586D+02, 1.2727D+02, 1.2867D+02, 1.3008D+02, 1.3148D+02, 1.3289D+02, 1.3430D+02, 1.3570D+02, 1.3711D+02, 1.3852D+02 &
, 1.3992D+02, 1.4133D+02, 1.4273D+02, 1.4414D+02, 1.4555D+02, 1.4695D+02, 1.4836D+02, 1.4977D+02, 1.5117D+02, 1.5258D+02 &
, 1.5398D+02, 1.5539D+02, 1.5680D+02, 1.5820D+02, 1.5961D+02, 1.6102D+02, 1.6242D+02, 1.6383D+02, 1.6523D+02, 1.6664D+02 &
, 1.6805D+02, 1.6945D+02, 1.7086D+02, 1.7227D+02, 1.7367D+02, 1.7508D+02, 1.7648D+02, 1.7789D+02, 1.7930D+02, 1.8070D+02 &
, 1.8211D+02, 1.8352D+02, 1.8492D+02, 1.8633D+02, 1.8773D+02, 1.8914D+02, 1.9055D+02, 1.9195D+02, 1.9336D+02, 1.9477D+02 &
, 1.9617D+02, 1.9758D+02, 1.9898D+02, 2.0039D+02, 2.0180D+02, 2.0320D+02, 2.0461D+02, 2.0602D+02, 2.0742D+02, 2.0883D+02 &
, 2.1023D+02, 2.1164D+02, 2.1305D+02, 2.1445D+02, 2.1586D+02, 2.1727D+02, 2.1867D+02, 2.2008D+02, 2.2148D+02, 2.2289D+02 &
, 2.2430D+02, 2.2570D+02, 2.2711D+02, 2.2852D+02, 2.2992D+02, 2.3133D+02, 2.3273D+02, 2.3414D+02, 2.3555D+02, 2.3695D+02 &
, 2.3836D+02, 2.3977D+02, 2.4117D+02, 2.4258D+02, 2.4398D+02, 2.4539D+02, 2.4680D+02, 2.4820D+02, 2.4961D+02, 2.5102D+02 &
, 2.5242D+02, 2.5383D+02, 2.5523D+02, 2.5664D+02, 2.5805D+02, 2.5945D+02, 2.6086D+02, 2.6227D+02, 2.6367D+02, 2.6508D+02 &
, 2.6648D+02, 2.6789D+02, 2.6930D+02, 2.7070D+02, 2.7211D+02, 2.7352D+02, 2.7492D+02, 2.7633D+02, 2.7773D+02, 2.7914D+02 &
, 2.8055D+02, 2.8195D+02, 2.8336D+02, 2.8477D+02, 2.8617D+02, 2.8758D+02, 2.8898D+02, 2.9039D+02, 2.9180D+02, 2.9320D+02 &
, 2.9461D+02, 2.9602D+02, 2.9742D+02, 2.9883D+02, 3.0023D+02, 3.0164D+02, 3.0305D+02, 3.0445D+02, 3.0586D+02, 3.0727D+02 &
, 3.0867D+02, 3.1008D+02, 3.1148D+02, 3.1289D+02, 3.1430D+02, 3.1570D+02, 3.1711D+02, 3.1852D+02, 3.1992D+02, 3.2133D+02 &
, 3.2273D+02, 3.2414D+02, 3.2555D+02, 3.2695D+02, 3.2836D+02, 3.2977D+02, 3.3117D+02, 3.3258D+02, 3.3398D+02, 3.3539D+02 &
, 3.3680D+02, 3.3820D+02, 3.3961D+02, 3.4102D+02, 3.4242D+02, 3.4383D+02, 3.4523D+02, 3.4664D+02, 3.4805D+02, 3.4945D+02 &
, 3.5086D+02, 3.5227D+02, 3.5367D+02, 3.5508D+02, 3.5648D+02, 3.5789D+02 /)
  lon_o_bnds = (/ &
 -1.4063D+00, 0.0000D+00, 1.4063D+00, 2.8125D+00, 4.2188D+00, 5.6250D+00, 7.0313D+00, 8.4375D+00, 9.8438D+00, 1.1250D+01 &
, 1.2656D+01, 1.4063D+01, 1.5469D+01, 1.6875D+01, 1.8281D+01, 1.9688D+01, 2.1094D+01, 2.2500D+01, 2.3906D+01, 2.5313D+01 &
, 2.6719D+01, 2.8125D+01, 2.9531D+01, 3.0938D+01, 3.2344D+01, 3.3750D+01, 3.5156D+01, 3.6563D+01, 3.7969D+01, 3.9375D+01 &
, 4.0781D+01, 4.2188D+01, 4.3594D+01, 4.5000D+01, 4.6406D+01, 4.7813D+01, 4.9219D+01, 5.0625D+01, 5.2031D+01, 5.3438D+01 &
, 5.4844D+01, 5.6250D+01, 5.7656D+01, 5.9063D+01, 6.0469D+01, 6.1875D+01, 6.3281D+01, 6.4688D+01, 6.6094D+01, 6.7500D+01 &
, 6.8906D+01, 7.0313D+01, 7.1719D+01, 7.3125D+01, 7.4531D+01, 7.5938D+01, 7.7344D+01, 7.8750D+01, 8.0156D+01, 8.1563D+01 &
, 8.2969D+01, 8.4375D+01, 8.5781D+01, 8.7188D+01, 8.8594D+01, 9.0000D+01, 9.1406D+01, 9.2813D+01, 9.4219D+01, 9.5625D+01 &
, 9.7031D+01, 9.8438D+01, 9.9844D+01, 1.0125D+02, 1.0266D+02, 1.0406D+02, 1.0547D+02, 1.0688D+02, 1.0828D+02, 1.0969D+02 &
, 1.1109D+02, 1.1250D+02, 1.1391D+02, 1.1531D+02, 1.1672D+02, 1.1813D+02, 1.1953D+02, 1.2094D+02, 1.2234D+02, 1.2375D+02 &
, 1.2516D+02, 1.2656D+02, 1.2797D+02, 1.2938D+02, 1.3078D+02, 1.3219D+02, 1.3359D+02, 1.3500D+02, 1.3641D+02, 1.3781D+02 &
, 1.3922D+02, 1.4063D+02, 1.4203D+02, 1.4344D+02, 1.4484D+02, 1.4625D+02, 1.4766D+02, 1.4906D+02, 1.5047D+02, 1.5188D+02 &
, 1.5328D+02, 1.5469D+02, 1.5609D+02, 1.5750D+02, 1.5891D+02, 1.6031D+02, 1.6172D+02, 1.6313D+02, 1.6453D+02, 1.6594D+02 &
, 1.6734D+02, 1.6875D+02, 1.7016D+02, 1.7156D+02, 1.7297D+02, 1.7438D+02, 1.7578D+02, 1.7719D+02, 1.7859D+02, 1.8000D+02 &
, 1.8141D+02, 1.8281D+02, 1.8422D+02, 1.8563D+02, 1.8703D+02, 1.8844D+02, 1.8984D+02, 1.9125D+02, 1.9266D+02, 1.9406D+02 &
, 1.9547D+02, 1.9688D+02, 1.9828D+02, 1.9969D+02, 2.0109D+02, 2.0250D+02, 2.0391D+02, 2.0531D+02, 2.0672D+02, 2.0813D+02 &
, 2.0953D+02, 2.1094D+02, 2.1234D+02, 2.1375D+02, 2.1516D+02, 2.1656D+02, 2.1797D+02, 2.1938D+02, 2.2078D+02, 2.2219D+02 &
, 2.2359D+02, 2.2500D+02, 2.2641D+02, 2.2781D+02, 2.2922D+02, 2.3063D+02, 2.3203D+02, 2.3344D+02, 2.3484D+02, 2.3625D+02 &
, 2.3766D+02, 2.3906D+02, 2.4047D+02, 2.4188D+02, 2.4328D+02, 2.4469D+02, 2.4609D+02, 2.4750D+02, 2.4891D+02, 2.5031D+02 &
, 2.5172D+02, 2.5313D+02, 2.5453D+02, 2.5594D+02, 2.5734D+02, 2.5875D+02, 2.6016D+02, 2.6156D+02, 2.6297D+02, 2.6438D+02 &
, 2.6578D+02, 2.6719D+02, 2.6859D+02, 2.7000D+02, 2.7141D+02, 2.7281D+02, 2.7422D+02, 2.7563D+02, 2.7703D+02, 2.7844D+02 &
, 2.7984D+02, 2.8125D+02, 2.8266D+02, 2.8406D+02, 2.8547D+02, 2.8688D+02, 2.8828D+02, 2.8969D+02, 2.9109D+02, 2.9250D+02 &
, 2.9391D+02, 2.9531D+02, 2.9672D+02, 2.9813D+02, 2.9953D+02, 3.0094D+02, 3.0234D+02, 3.0375D+02, 3.0516D+02, 3.0656D+02 &
, 3.0797D+02, 3.0938D+02, 3.1078D+02, 3.1219D+02, 3.1359D+02, 3.1500D+02, 3.1641D+02, 3.1781D+02, 3.1922D+02, 3.2063D+02 &
, 3.2203D+02, 3.2344D+02, 3.2484D+02, 3.2625D+02, 3.2766D+02, 3.2906D+02, 3.3047D+02, 3.3188D+02, 3.3328D+02, 3.3469D+02 &
, 3.3609D+02, 3.3750D+02, 3.3891D+02, 3.4031D+02, 3.4172D+02, 3.4313D+02, 3.4453D+02, 3.4594D+02, 3.4734D+02, 3.4875D+02 &
, 3.5016D+02, 3.5156D+02, 3.5297D+02, 3.5438D+02, 3.5578D+02, 3.5719D+02, 3.585937D+02 /)
  lat_o = (/ &
 -8.9430D+01,-8.8289D+01,-8.7148D+01,-8.6108D+01,-8.5167D+01,-8.4227D+01,-8.3290D+01,-8.2356D+01,-8.1422D+01,-8.0489D+01 &
,-7.9557D+01,-7.8624D+01,-7.7693D+01,-7.6761D+01,-7.5830D+01,-7.4898D+01,-7.3967D+01,-7.3036D+01,-7.2105D+01,-7.1174D+01 &
,-7.0244D+01,-6.9313D+01,-6.8382D+01,-6.7451D+01,-6.6521D+01,-6.5590D+01,-6.4660D+01,-6.3729D+01,-6.2798D+01,-6.1868D+01 &
,-6.0937D+01,-6.0007D+01,-5.9076D+01,-5.8146D+01,-5.7215D+01,-5.6285D+01,-5.5355D+01,-5.4424D+01,-5.3494D+01,-5.2563D+01 &
,-5.1633D+01,-5.0702D+01,-4.9772D+01,-4.8842D+01,-4.7911D+01,-4.6981D+01,-4.6051D+01,-4.5120D+01,-4.4190D+01,-4.3260D+01 &
,-4.2329D+01,-4.1399D+01,-4.0468D+01,-3.9538D+01,-3.8608D+01,-3.7677D+01,-3.6747D+01,-3.5817D+01,-3.4886D+01,-3.3956D+01 &
,-3.3026D+01,-3.2095D+01,-3.1165D+01,-3.0235D+01,-2.9305D+01,-2.8374D+01,-2.7444D+01,-2.6514D+01,-2.5583D+01,-2.4653D+01 &
,-2.3723D+01,-2.2792D+01,-2.1862D+01,-2.0932D+01,-2.0001D+01,-1.9071D+01,-1.8141D+01,-1.7211D+01,-1.6280D+01,-1.5350D+01 &
,-1.4420D+01,-1.3489D+01,-1.2559D+01,-1.1629D+01,-1.0698D+01,-9.7681D+00,-8.8378D+00,-7.9075D+00,-6.9772D+00,-6.0469D+00 &
,-5.1166D+00,-4.1863D+00,-3.2560D+00,-2.3257D+00,-1.3954D+00,-4.6515D-01, 4.6515D-01, 1.3954D+00, 2.3257D+00, 3.2560D+00 &
, 4.1863D+00, 5.1166D+00, 6.0469D+00, 6.9772D+00, 7.9075D+00, 8.8378D+00, 9.7681D+00, 1.0698D+01, 1.1629D+01, 1.2559D+01 &
, 1.3489D+01, 1.4420D+01, 1.5350D+01, 1.6280D+01, 1.7211D+01, 1.8141D+01, 1.9071D+01, 2.0001D+01, 2.0932D+01, 2.1862D+01 &
, 2.2792D+01, 2.3723D+01, 2.4653D+01, 2.5583D+01, 2.6514D+01, 2.7444D+01, 2.8374D+01, 2.9305D+01, 3.0235D+01, 3.1165D+01 &
, 3.2095D+01, 3.3026D+01, 3.3956D+01, 3.4886D+01, 3.5817D+01, 3.6747D+01, 3.7677D+01, 3.8608D+01, 3.9538D+01, 4.0468D+01 &
, 4.1399D+01, 4.2329D+01, 4.3260D+01, 4.4190D+01, 4.5120D+01, 4.6051D+01, 4.6981D+01, 4.7911D+01, 4.8842D+01, 4.9772D+01 &
, 5.0702D+01, 5.1633D+01, 5.2563D+01, 5.3494D+01, 5.4424D+01, 5.5355D+01, 5.6285D+01, 5.7215D+01, 5.8146D+01, 5.9076D+01 &
, 6.0007D+01, 6.0937D+01, 6.1868D+01, 6.2798D+01, 6.3729D+01, 6.4660D+01, 6.5590D+01, 6.6521D+01, 6.7451D+01, 6.8382D+01 &
, 6.9313D+01, 7.0244D+01, 7.1174D+01, 7.2105D+01, 7.3036D+01, 7.3967D+01, 7.4898D+01, 7.5830D+01, 7.6761D+01, 7.7693D+01 &
, 7.8624D+01, 7.9557D+01, 8.0489D+01, 8.1422D+01, 8.2356D+01, 8.3290D+01, 8.4227D+01, 8.5167D+01, 8.6108D+01, 8.7148D+01 &
, 8.8289D+01, 8.9430D+01 /)
  lat_o_bnds = (/ &
 -9.0000D+01,-8.8859D+01,-8.7718D+01,-8.6578D+01,-8.5638D+01,-8.4697D+01,-8.3757D+01,-8.2823D+01,-8.1889D+01,-8.0955D+01 &
,-8.0023D+01,-7.9091D+01,-7.8158D+01,-7.7227D+01,-7.6295D+01,-7.5364D+01,-7.4433D+01,-7.3502D+01,-7.2571D+01,-7.1640D+01 &
,-7.0709D+01,-6.9778D+01,-6.8847D+01,-6.7917D+01,-6.6986D+01,-6.6055D+01,-6.5125D+01,-6.4194D+01,-6.3264D+01,-6.2333D+01 &
,-6.1403D+01,-6.0472D+01,-5.9542D+01,-5.8611D+01,-5.7681D+01,-5.6750D+01,-5.5820D+01,-5.4889D+01,-5.3959D+01,-5.3028D+01 &
,-5.2098D+01,-5.1168D+01,-5.0237D+01,-4.9307D+01,-4.8377D+01,-4.7446D+01,-4.6516D+01,-4.5585D+01,-4.4655D+01,-4.3725D+01 &
,-4.2794D+01,-4.1864D+01,-4.0934D+01,-4.0003D+01,-3.9073D+01,-3.8143D+01,-3.7212D+01,-3.6282D+01,-3.5352D+01,-3.4421D+01 &
,-3.3491D+01,-3.2561D+01,-3.1630D+01,-3.0700D+01,-2.9770D+01,-2.8839D+01,-2.7909D+01,-2.6979D+01,-2.6048D+01,-2.5118D+01 &
,-2.4188D+01,-2.3258D+01,-2.2327D+01,-2.1397D+01,-2.0467D+01,-1.9536D+01,-1.8606D+01,-1.7676D+01,-1.6745D+01,-1.5815D+01 &
,-1.4885D+01,-1.3954D+01,-1.3024D+01,-1.2094D+01,-1.1164D+01,-1.0233D+01,-9.3030D+00,-8.3727D+00,-7.4424D+00,-6.5121D+00 &
,-5.5818D+00,-4.6515D+00,-3.7212D+00,-2.7909D+00,-1.8606D+00,-9.3030D-01, 2.8758D-08, 9.3030D-01, 1.8606D+00, 2.7909D+00 &
, 3.7212D+00, 4.6515D+00, 5.5818D+00, 6.5121D+00, 7.4424D+00, 8.3727D+00, 9.3030D+00, 1.0233D+01, 1.1164D+01, 1.2094D+01 &
, 1.3024D+01, 1.3954D+01, 1.4885D+01, 1.5815D+01, 1.6745D+01, 1.7676D+01, 1.8606D+01, 1.9536D+01, 2.0467D+01, 2.1397D+01 &
, 2.2327D+01, 2.3258D+01, 2.4188D+01, 2.5118D+01, 2.6048D+01, 2.6979D+01, 2.7909D+01, 2.8839D+01, 2.9770D+01, 3.0700D+01 &
, 3.1630D+01, 3.2561D+01, 3.3491D+01, 3.4421D+01, 3.5352D+01, 3.6282D+01, 3.7212D+01, 3.8143D+01, 3.9073D+01, 4.0003D+01 &
, 4.0934D+01, 4.1864D+01, 4.2794D+01, 4.3725D+01, 4.4655D+01, 4.5585D+01, 4.6516D+01, 4.7446D+01, 4.8377D+01, 4.9307D+01 &
, 5.0237D+01, 5.1168D+01, 5.2098D+01, 5.3028D+01, 5.3959D+01, 5.4889D+01, 5.5820D+01, 5.6750D+01, 5.7681D+01, 5.8611D+01 &
, 5.9542D+01, 6.0472D+01, 6.1403D+01, 6.2333D+01, 6.3264D+01, 6.4194D+01, 6.5125D+01, 6.6055D+01, 6.6986D+01, 6.7917D+01 &
, 6.8847D+01, 6.9778D+01, 7.0709D+01, 7.1640D+01, 7.2571D+01, 7.3502D+01, 7.4433D+01, 7.5364D+01, 7.6295D+01, 7.7227D+01 &
, 7.8158D+01, 7.9091D+01, 8.0023D+01, 8.0955D+01, 8.1889D+01, 8.2823D+01, 8.3757D+01, 8.4697D+01, 8.5638D+01, 8.6578D+01 &
, 8.7718D+01, 8.8859D+01, 9.0000D+01 /)
end subroutine def_ogrid
