//
// Copyright 2014 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Created by postproc-cld2 4.0 on 2014-02-04 09:06:59
// From command line:
//  --cld2 --cc --just_read_raw --delta_octa 
//  --wrt=cld2_generated_quad0122.bin --standard --minchars=5 --mincount=1 
//  --max_items_per_langscript=3000 --flatmap --rr_alloc --freq_alloc 
//  --boostcloseweakerpercent=00 --indirectbits=12 --thresh=240 --v25 
//  --kentries=256 --tablename=DeltaOcta0122 --suppress=bs-Cyrl sr-ME-Latn 
//  sh-Cyrl sh-Latn ce-Cyrl cv-Cyrl    az-Arab az-Cyrl bs-Cyrl kk-Latn 
//  ku-Latn my-Latn ru-Latn tg-Arab tk-Arab ug-Latn za-Hani zzb-Latn 
//  zze-Latn zzh-Latn --remap=xxx-Latn=>ut-Latn tw-Latn=>ak-Latn 
//  nd-Latn=>nr-Latn blu-Latn=>hmn-Latn  --ko_english --force_to_lang_soft 
//  --nosoft_cram2 --nomsidlevel --shapeflatprob --langpriorpercent=10 
//  --skipnuc --noshapeforcetop --noshapeeventop --noshapesteep2 --spread=15 
//  --nodoubleclose --langcounts --writebin --list_items=120 
//  /hdb1/cld2/probs/p90_raw_octagrams_2014.utf8 
// 
// CLD2_pslangs
// 
// See compact_lang_det.cc for usage
// 
#include "cld2tablesummary.h"
namespace CLD2 {

static const uint32 kDeltaOcta0122BuildDate = 20140204;    // yyyymmdd


// Of 406948 offered items into 262144 table entries:
// 248698 filled (61%), 124 merged (0%), 158126 dropped (38%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI 
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE 
//     SYRIAC LIMBU ORIYA INUKTITUT 

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT 

// Words/Quads: 144 languages in range ENGLISH..X_KLINGON:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN 
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH 
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN 
//     Unknown BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG 
//     TURKISH UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN LATIN 
//     MALAY WELSH NEPALI ALBANIAN BELARUSIAN JAVANESE OCCITAN URDU 
//     BIHARI ARABIC CATALAN ESPERANTO BASQUE INTERLINGUA 
//     SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE VIETNAMESE 
//     FRISIAN SLOVAK FAROESE SUNDANESE UZBEK AMHARIC AZERBAIJANI 
//     TIGRINYA PERSIAN BOSNIAN NORWEGIAN_N XHOSA ZULU GUARANI 
//     SESOTHO TURKMEN KYRGYZ BRETON YIDDISH SOMALI UIGHUR KURDISH 
//     MONGOLIAN SINDHI RHAETO_ROMANCE AFRIKAANS LUXEMBOURGISH 
//     TIBETAN ASSAMESE CORSICAN INTERLINGUE KAZAKH LINGALA PASHTO 
//     QUECHUA SHONA TAJIK TATAR TONGA YORUBA MAORI WOLOF ABKHAZIAN 
//     AFAR AYMARA BASHKIR BISLAMA DZONGKHA FIJIAN GREENLANDIC HAUSA 
//     HAITIAN_CREOLE INUPIAK KASHMIRI KINYARWANDA MALAGASY NAURU 
//     OROMO RUNDI SAMOAN SANGO SANSKRIT SISWANT TSONGA TSWANA 
//     VOLAPUK ZHUANG KHASI SCOTS GANDA MANX AKAN IGBO 
//     MAURITIAN_CREOLE HAWAIIAN CEBUANO HMONG NYANJA PEDI SESELWA 
//     VENDA WARAY_PHILIPPINES NDEBELE X_PIG_LATIN X_KLINGON 

// TopLanguage  TokenCount
//  ENGLISH 1521
//  DANISH 1757
//  DUTCH 1773
//  FINNISH 1757
//  FRENCH 1761
//  GERMAN 1727
//  HEBREW 1702
//  ITALIAN 1719
//  Japanese 3506
//  Korean 1878
//  NORWEGIAN 1763
//  POLISH 1758
//  PORTUGUESE 1748
//  RUSSIAN 1798
//  SPANISH 1748
//  SWEDISH 1726
//  Chinese 1795
//  CZECH 3545
//  ICELANDIC 1725
//  LATVIAN 1715
//  LITHUANIAN 1749
//  ROMANIAN 2683
//  HUNGARIAN 1766
//  ESTONIAN 1711
//  Unknown 1779
//  BULGARIAN 1741
//  CROATIAN 2000
//  SERBIAN 3499
//  IRISH 1732
//  GALICIAN 1754
//  TAGALOG 1733
//  TURKISH 1739
//  UKRAINIAN 1777
//  HINDI 1845
//  MACEDONIAN 1735
//  BENGALI 1738
//  INDONESIAN 3378
//  LATIN 1745
//  MALAY 1938
//  WELSH 1751
//  NEPALI 1760
//  ALBANIAN 1768
//  BELARUSIAN 1725
//  JAVANESE 1760
//  OCCITAN 1729
//  URDU 1455
//  BIHARI 1702
//  ARABIC 1843
//  CATALAN 1764
//  ESPERANTO 1768
//  BASQUE 1763
//  INTERLINGUA 1203
//  SCOTS_GAELIC 1749
//  SWAHILI 1754
//  SLOVENIAN 1731
//  MARATHI 1761
//  MALTESE 1749
//  VIETNAMESE 492
//  FRISIAN 1771
//  SLOVAK 1995
//  ChineseT 2135
//  FAROESE 1735
//  SUNDANESE 1736
//  UZBEK 3983
//  AMHARIC 1760
//  AZERBAIJANI 1787
//  TIGRINYA 1764
//  PERSIAN 1710
//  BOSNIAN 1701
//  NORWEGIAN_N 1737
//  XHOSA 3494
//  ZULU 1844
//  GUARANI 1742
//  SESOTHO 1743
//  TURKMEN 2780
//  KYRGYZ 3513
//  BRETON 1767
//  YIDDISH 1771
//  SOMALI 1727
//  UIGHUR 2979
//  KURDISH 1587
//  MONGOLIAN 1720
//  SINDHI 1637
//  RHAETO_ROMANCE 1780
//  AFRIKAANS 1777
//  LUXEMBOURGISH 1746
//  TIBETAN 30
//  ASSAMESE 1753
//  CORSICAN 1739
//  INTERLINGUE 1580
//  KAZAKH 3457
//  LINGALA 1764
//  PASHTO 1729
//  QUECHUA 1747
//  SHONA 1691
//  TAJIK 1771
//  TATAR 3518
//  TONGA 1745
//  YORUBA 1796
//  MAORI 1784
//  WOLOF 1754
//  ABKHAZIAN 1445
//  AFAR 1516
//  AYMARA 680
//  BASHKIR 1750
//  BISLAMA 1177
//  DZONGKHA 5
//  FIJIAN 1520
//  GREENLANDIC 1756
//  HAUSA 1744
//  HAITIAN_CREOLE 1733
//  INUPIAK 380
//  KASHMIRI 348
//  KINYARWANDA 2407
//  MALAGASY 1718
//  NAURU 873
//  OROMO 1740
//  RUNDI 1930
//  SAMOAN 1764
//  SANGO 267
//  SANSKRIT 3461
//  SISWANT 1762
//  TSONGA 1763
//  TSWANA 1707
//  VOLAPUK 1049
//  ZHUANG 192
//  KHASI 555
//  SCOTS 1756
//  GANDA 1702
//  MANX 1743
//  AKAN 729
//  IGBO 1076
//  MAURITIAN_CREOLE 1266
//  HAWAIIAN 1282
//  CEBUANO 1714
//  HMONG 260
//  NYANJA 1751
//  PEDI 374
//  SESELWA 926
//  VENDA 557
//  WARAY_PHILIPPINES 1740
//  NDEBELE 244
//  X_PIG_LATIN 1722
//  X_KLINGON 1768



// Recognized language-script combinations [180]:
static const char* const kDeltaOcta0122RecognizedLangScripts = 
  "aa-Latn ab-Cyrl af-Latn ak-Latn am-Ethi ar-Arab ar-Latn as-Beng "
  "ay-Latn az-Latn ba-Cyrl be-Cyrl bg-Cyrl bg-Latn bh-Deva bi-Latn "
  "bn-Beng bn-Latn bo-Cyrl bo-Tibt br-Latn bs-Latn ca-Latn ceb-Latn "
  "co-Latn crs-Latn cs-Latn cy-Latn da-Latn de-Latn dz-Tibt en-Arab "
  "en-Latn eo-Latn es-Cyrl es-Latn et-Latn eu-Latn fa-Arab fa-Latn "
  "fi-Latn fj-Latn fo-Latn fr-Arab fr-Latn fy-Latn ga-Latn gd-Latn "
  "gl-Latn gn-Latn gv-Latn ha-Latn haw-Latn hi-Deva hi-Latn hmn-Latn "
  "hr-Arab hr-Latn ht-Latn hu-Latn ia-Latn id-Arab id-Latn ie-Latn "
  "ig-Latn ik-Latn is-Latn it-Latn iw-Hebr iw-Latn ja-Hani ja-Latn "
  "jw-Latn kha-Latn kk-Arab kk-Cyrl kl-Latn ko-Hani ko-Latn ks-Arab "
  "ks-Deva ku-Arab ky-Arab ky-Cyrl la-Latn lb-Latn lg-Latn ln-Latn "
  "lt-Latn lv-Latn mfe-Latn mg-Latn mi-Latn mk-Cyrl mk-Latn mn-Cyrl "
  "mn-Latn mr-Deva mr-Latn ms-Latn mt-Latn na-Latn ne-Deva nl-Latn "
  "nn-Latn no-Latn nr-Latn nso-Latn ny-Latn oc-Arab oc-Latn om-Latn "
  "pl-Cyrl pl-Latn ps-Arab pt-Latn qu-Latn rm-Latn rn-Latn ro-Cyrl "
  "ro-Latn ru-Cyrl rw-Latn sa-Deva sa-Latn sco-Latn sd-Arab sg-Latn "
  "sk-Latn sl-Latn sm-Latn sn-Latn so-Latn sq-Latn sr-Cyrl sr-Latn "
  "ss-Latn st-Latn su-Latn sv-Cyrl sv-Latn sw-Latn tg-Cyrl ti-Ethi "
  "tk-Cyrl tk-Latn tl-Latn tlh-Latn tn-Latn to-Latn tr-Cyrl tr-Latn "
  "ts-Latn tt-Cyrl tt-Latn ug-Arab ug-Cyrl uk-Cyrl uk-Latn un-Cyrl "
  "un-Latn ur-Arab ur-Latn uz-Arab uz-Cyrl uz-Latn ve-Latn vi-Latn "
  "vo-Latn war-Latn wo-Latn xh-Latn yi-Hebr yo-Latn za-Latn zh-Hani "
  "zh-Hant-Hani zh-Hant-Latn zu-Latn zzp-Latn ";

static const uint32 kDeltaOcta0122Size = 65536;    // Bucket count
static const uint32 kDeltaOcta0122KeyMask = 0xffff0000;    // Mask hash key

static const IndirectProbBucket4 kDeltaOcta0122[kDeltaOcta0122Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0x0a710002,0x530a0003,0x83420004,0x1e9b0005}},	// [000] _ulaganja_, _frankrij, _anwetan_, _referats_, 
   {{0xc3f90006,0xa2fc0007,0xc2d90008,0xa2da0009}},	//   _suruh_, _imaga_, _ascens_, _obrnite_, 
   {{0x827f000a,0x0757000b,0xb081000c,0x825b000d}},	//   _maanna_, _malilieg, _aimcrack_, _ajaloo_, 
   {{0x8db9000e,0x4a3c000f,0x446c0010,0xfa0b0011}},	//   _cavalcat_, _makinası_, _ebafundz, _bagabula_, 
   {{0xae760012,0x7aa70013,0x33da0014,0x83f80015}},	//   _चाट्ी_, _ракаат_, _anglezët_, _aamusa_, 
   {{0x72d40016,0x3a960017,0xb3f80018,0x4f430019}},	//   _perdis_, _धर्ममा_, _samuta_, _антимити, 
   {{0x6cc0001a,0x49fe001b,0x751f001c,0x2e22001d}},	//   _شیرافگن_, _bafatoot, _darudako_, _inamicos_, 
   {{0x2290001e,0x527f001f,0x02fc0020,0x61d70021}},	//   _nijar_, _ahenni_, _omaga_, _ailednay_, 
   {{0xab180022,0xb2d80023,0xbfe30024,0x8af20025}},	//   _babapats, _планшетн, _skriveko, _atirohit, 
   {{0x2d5d0026,0x5a160027,0x82480028,0x2c530015}},	//   _북마크하기_, _propagid, _galmo_, _tartama_, 
   {{0x40b00029,0xf2de002a,0xc0d1002b,0x7ea4000d}},	//   _کامێرا_, _itenanị_, _হায়রে_, _kulukuse_, 
   {{0x5245002c,0x85fd002d,0xdfc2002e,0x29f8002f}},	//   _автомаши, _obtenció, _kupovino, _gamitana_, 
   {{0x3c740030,0x62900031,0xe1540032,0xc46d0033}},	//   _augusts_, _pijat_, _biyohlah_, _investiz, 
   {{0xf7740034,0x207d0035,0xea2e0036,0x32d70037}},	//   _virkileg, _фарсы_, _nascanna_, _የበይነመረብ_, 
   {{0x69080038,0xd15c0039,0x8200003a,0xf2950014}},	//   _чөнки_, _мухар_, _sening_, _ibrahimi_, 
   {{0x4207003b,0x1a3a003c,0xa7f5003d,0x668d003e}},	//   _akakwati_, _فردمنش_, _agrandig, _disetefi, 
   {{0xcd54003f,0xf8240040,0xb1360041,0xc2eb0042}},	// [010] _biyatlhq, _קרדשיאן_, _зыуацәа_, _abrindo_, 
   {{0x226d0043,0xd3f40044,0x34bd0045,0xc2920046}},	//   _abanonyi_, _mutter_, _сировина_, _agrari_, 
   {{0xc3f40047,0xa2fc0048,0xf2d80049,0xcbae004a}},	//   _lutter_, _amagi_, _kiheni_, _гимнының_, 
   {{0x02e3004b,0xda14004c,0xd3f9000e,0x3304004d}},	//   _bafihle_, _akwatula_, _struz_, _organum_, 
   {{0x32da004e,0xe387004f,0x62da0050,0x7232000e}},	//   _amplify_, _daaray_, _tetela_, _geomail_, 
   {{0x6cce0051,0xf4930052,0x73470053,0x00000000}},	//   _latvener, _schémata_, _makenya_, --, 
   {{0xf2910054,0xac170055,0x89f60056,0xddba0037}},	//   _kiran_, _bananier, _akusensu, _በማግኘታቸው_, 
   {{0xe2910057,0x06a90058,0x20380039,0xb5f50059}},	//   _jiran_, _saurisch, _lehendik_, _статуетк, 
   {{0x8290005a,0x92cb0043,0xa3f8005b,0xda14005c}},	//   _bibah_, _abaddu_, _tamura_, _atabarut, 
   {{0x92910033,0x8b43005d,0x4061005e,0x3e3a005f}},	//   _eiran_, _amoapatĩ_, _زۆھرە_, _recamara, 
   {{0x2fdd0060,0xc53c0061,0xa2900062,0xa1890063}},	//   _назарына_, _조심하세요_, _dibah_, _نقاطي_, 
   {{0xa2480047,0xe2da0064,0x63f40065,0xb9cb0052}},	//   _calme_, _neteja_, _futter_, _सिद्धनाथ_, 
   {{0xbffd0066,0x9d7c0067,0x545b0068,0xb9fb0035}},	//   _уралдана_, _ademsifa, _sandiego_, _айтугано, 
   {{0x02000069,0x7f3e004a,0x4f770037,0xc291006a}},	//   _runini_, _сайланып_, _mencadan, _hiran_, 
   {{0xe2f8006b,0xe254000d,0x99c3006c,0x21b2006d}},	//   _अर्धनग्न_, _arvestam, _ahambela_, _ахвяруюц, 
   {{0x24700016,0x7291006e,0x4d09006f,0x6b4a000c}},	//   _דאַװענען_, _ciran_, _شرمناڪ_, _хаматхан, 
   {{0x99ee0070,0x7fb50071,0xf2e90072,0x1a0d0073}},	// [020] _borgmest, _خوابه_, _sasinsa_, _dynamica_, 
   {{0xcfc70074,0x01320075,0x18440076,0x63ba0077}},	//   _дизайна_, _skattsto, _перверзн, _krevèt_, 
   {{0xe68a0078,0xc2fc0079,0xec73007a,0x68d5007b}},	//   _презимен, _smagi_, _saksama_, _gileynou, 
   {{0xdaff007c,0x0ed8007d,0x0c76007e,0x352e007f}},	//   _kunganab, _menyumba, _bharani_, _llanarth, 
   {{0xf27f0080,0x12250081,0x5a8e0082,0x6fa70083}},	//   _taanna_, _feykir_, _fannonin_, _delectar_, 
   {{0xa30e0073,0x9e5f0084,0xd9fb0085,0xd24f0086}},	//   _essayos_, _tribunja, _vulaibat, _külhoni_, 
   {{0x1db90067,0x3c760087,0x1aec0088,0xbdb00089}},	//   _aannicha, _eharani_, _manualit, _gönahlar, 
   {{0x63ea008a,0x64fa0052,0xf224008b,0x72e7008c}},	//   _afatu_, _किराती_, _awoka_, _bienton_, 
   {{0x1897008d,0x52d9008e,0xf957008f,0x6f150090}},	//   _اریبا_, _asyee_, _remondit, _handifan, 
   {{0xef120091,0x621d0089,0x0fe00092,0xfb5e0093}},	//   _tautukta, _мамут_, _ヴィンチ編集部_, _урана_, 
   {{0x3daa0039,0x8ac00094,0xcdb70095,0x22b20012}},	//   _argitara, _تىلدەرىن_, _angrungu_, _बिदुक_, 
   {{0x6a6c0096,0xe40b0097,0x13660059,0xd3490098}},	//   _abaminis, _akakọgbọ, _leggero_, _landsby_, 
   {{0xc1b10024,0xb4e3002b,0xec240099,0x00000000}},	//   _তাতেই_, _হাছান_, _ashandir, --, 
   {{0xc7160041,0x82cb009a,0xe291009b,0xac69009c}},	//   _ақәхарџь, _akulali_, _ziran_, _antuchi_, 
   {{0x22da009d,0x1511009e,0x4291009f,0x43ec00a0}},	//   _beteja_, _correndo_, _piran_, _danmalik, 
   {{0x13f900a1,0x298400a2,0x6b0b00a3,0x99c7006c}},	//   _kuruu_, _wakisema_, _påskedag_, _каратаи_, 
   {{0x034000a4,0x4a790041,0x92310099,0x62da00a5}},	// [030] _admeten_, _гәыҩбара_, _chimaso_, _setema_, 
   {{0xcc4400a6,0x2ede00a7,0xbb4300a8,0x0373000b}},	//   _abawela_, _римде_, _sinceres, _lemalie_, 
   {{0x027f00a9,0x82fd00aa,0xf95800ab,0xcc5300ac}},	//   _ibanza_, _davinos_, _tahorait, _jastuka_, 
   {{0x33f900ad,0xcb9400ae,0xb6a800af,0x72dd0062}},	//   _nurut_, _babikwir, _цифровог, _jiqondi_, 
   {{0xa28c00b0,0xb97700b1,0xa7260061,0x2e3a00b2}},	//   _dagaalam, _kojiblee, _여의도자이_, _gabaarra, 
   {{0xca8d00b3,0xdc6800b4,0xd23000b5,0xffe000b6}},	//   _батырлык_, _ciprian_, _ikamisa_, _sidicamo, 
   {{0x7eae00b7,0x37aa00b8,0xe882008e,0xd47400b9}},	//   _milletin, _iyarampi, _alminahu, _diberlak, 
   {{0x401c0078,0x0dee00ba,0x525a00a5,0xff4b00bb}},	//   _просвете_, _رداگرتنی_, _itele_, _جنرلوں_, 
   {{0x020100bc,0x1f35008d,0x4fc300bd,0x4e8100be}},	//   _diaiup_, _kitoblar_, _chairter_, _جەڭىشدى_, 
   {{0x8da300bf,0x9ae10009,0xc3ea00c0,0x146000c1}},	//   _ходить_, _modelars, _ngiti_, _menetesk, 
   {{0x73ea00c2,0x83f400c3,0x7e6900c4,0x038000c5}},	//   _igiti_, _hostis_, _ايڪتا_, _appris_, 
   {{0x588800c6,0x998e00c7,0xf42a00c8,0xdae700c9}},	//   _тексту_, _шакир_, _бригадал, _vietfone, 
   {{0x5d2900ca,0x47e40012,0xdc8700cb,0x00000000}},	//   _respondr, _चिउरवा_, _гармтар_, --, 
   {{0xa13600cc,0x9a7f00cd,0x1fa4005b,0xcd8f009a}},	//   _middelal, _agradora_, _patenter_, _دماتی_, 
   {{0x159300ce,0xe28e00cf,0x83e500d0,0x614600d1}},	//   _terorizm_, _bosheet_, _deklaraz, _ডায়েলগ_, 
   {{0xd7ed00d2,0xeb2c00d3,0xe2b200c7,0xe25a00d4}},	//   _dibareng, _pacientů_, _авазы_, _steld_, 
   {{0xd25a000b,0x9db600d5,0x2e6c0033,0x620000d6}},	// [040] _atele_, _rasiliga, _parcella, _ndoire_, 
   {{0xf3ea00d7,0x4f2e00d8,0x81f300d9,0x4a6600da}},	//   _ngata_, _castanha, _нарушает_, _терминат_, 
   {{0x13f900db,0xa3ea00dc,0x6f3600dd,0x4af50061}},	//   _turul_, _igata_, _brastera, _그러고보니_, 
   {{0x3cde00de,0xa30d00df,0x329100ca,0x1af300e0}},	//   _alikhulu_, _engager_, _airal_, _hearrige, 
   {{0x429100e1,0x33f9003d,0xc290008d,0x6b1700e2}},	//   _biral_, _arruc_, _yaratilm, _lokaalts, 
   {{0xa50100e3,0x67ce00e4,0x908700e5,0x249a002b}},	//   _materjal_, _भूमिकाएं_, _арнолд_, _নিশ্চুপ_, 
   {{0xf291004e,0x5e8500ba,0x075400e6,0xc64100e7}},	//   _mabati_, _فستیڤاڵی_, _城市公交线路变更_, _astoriaw, 
   {{0x7cde00e8,0x33ac00e9,0x927e00ea,0xe2910085}},	//   _elikhulu_, _soupir_, _mainka_, _labati_, 
   {{0xa30600eb,0x3682006b,0x13ea005b,0xd3f400ec}},	//   _akropong_, _श्राप_, _ogata_, _uostas_, 
   {{0x029100ed,0x726e00ee,0xa2c200ef,0xdbca0046}},	//   _nabati_, _euroko_, _مصريان_, _كۉنكۅي_, 
   {{0xcffa0017,0xf2da00f0,0x5afd00f1,0xe00200f2}},	//   _राजाहरू_, _vpredu_, _reperkis, _tipogrāf, 
   {{0x7553006c,0x723f00f3,0x63f900f4,0x81c70052}},	//   _abakhoth, _basempum, _arzur_, _धर्मशीला_, 
   {{0xe21700f5,0x717c00f6,0xbaae00f7,0x75c600f8}},	//   _аранда_, _bacarmal, _brakumon_, _কোনরকম_, 
   {{0x223700f9,0x62fc00ed,0x064000fa,0xf2c300fb}},	//   _ngombwa_, _bangko_, _pakigami, _abulala_, 
   {{0xf3f900c3,0xa1a900fc,0xbc020073,0xd26e005b}},	//   _aurum_, _birmohwi_, _blasmar_, _kuroko_, 
   {{0xc34100fd,0x63ea00fe,0x49b600ff,0x0cbd0040}},	//   _aigesan_, _egata_, _ליצמאן_, _דיויד_, 
   {{0xb7b10100,0xf25a0101,0x82d50102,0x4f5d0103}},	// [050] _izostavi, _stele_, _seromba_, _achaupon, 
   {{0x32c30104,0xa6a500a2,0xa7ce0105,0x19160092}},	//   _ebulala_, _پئماني_, _भूमिकाओं_, _リンク先の更新状, 
   {{0x84d60106,0x32910107,0x9a740108,0x6ee90109}},	//   _बिकिनी_, _kirab_, _tangtuna_, _अप्ठेरो_, 
   {{0xa248010a,0xa0300040,0xb349010b,0x56ab0019}},	//   _galma_, _במהדורה_, _bosenyi_, _ездра_, 
   {{0xc29100ce,0x83e8010c,0xac67010d,0x5f27010e}},	//   _dirab_, _सप्ताहां, _lalunya_, _depekton, 
   {{0xc02e010f,0xec660110,0x43f90111,0x1e1a0112}},	//   _маҳви_, _centies_, _ambutu_, _keremaja, 
   {{0xc5030113,0xe2b50114,0xf3170115,0xae3b0116}},	//   _مانجا_, _studied_, _aircond_, _mainners_, 
   {{0x5f6a00ec,0x1b3400cf,0x52d80117,0x03070118}},	//   _pagalbos_, _agaarsis, _praes_, _bamanyi_, 
   {{0x92920119,0x1228011a,0x02e5011b,0x00000000}},	//   _hitaas_, _העמדות_, _omonaka_, --, 
   {{0xfffc004d,0x354d011c,0x6db3011d,0x00000000}},	//   _中國新聞週刊_, _fiksiyoŋ_, _domnisoa, --, 
   {{0xdae4011e,0x13f9011f,0xb2920120,0x82d80121}},	//   _disterbe, _arrua_, _heraki_, _traer_, 
   {{0x1db40122,0x11cf00e6,0x8e3500e7,0x026d0123}},	//   _بوجود_, _市环境保护局_, _ariantva, _logoer_, 
   {{0xd3f90124,0xe5040125,0xeb760061,0x9604003a}},	//   _buruj_, _amallary, _경시대회를_, _amallari, 
   {{0x12d9011e,0xf0f000c1,0x4c8c0126,0xc7af0127}},	//   _aryer_, _समोरचा_, _факторів_, _bolontez_, 
   {{0x02000128,0x93700129,0x87b5005a,0x2b24012a}},	//   _kamida_, _anwansị_, _greeceng, _kompozyt, 
   {{0xec6a012b,0x12ba012c,0x93f9012d,0x0f9e012e}},	//   _systemy_, _bandari_, _muruk_, _بحثوں_, 
   {{0x56b50091,0xac67012f,0xa26c0130,0x83430131}},	// [060] _aglakuvi, _zentner_, _hemon_, _viveiro_, 
   {{0x79c80132,0xf4040107,0x32920133,0x925b0134}},	//   _automata_, _adatipun_, _bitaas_, _iwulo_, 
   {{0x73db0135,0x1c520136,0xf2fc003b,0xc7080137}},	//   _операсын_, _svetoga_, _idigri_, _шантидэв, 
   {{0xf3f90138,0x43b600ac,0x95010139,0x6abb013a}},	//   _huzur_, _kreveta_, _प्रथमचित, _besonësc, 
   {{0x56e5013b,0xfb14005e,0xc305012d,0xbc23005d}},	//   _ciechoci, _ﻳﯜﺳﯜﭖ_, _ngwanem_, _embojahu_, 
   {{0x3a76013c,0xe791013d,0xddfe013e,0x1ae700f2}},	//   _apellyas, _kontenti, _savetova, _energore, 
   {{0x5d83013f,0xd2b4001c,0xbc910140,0x82630141}},	//   _འབྱོན_, _lecce_, _mabuting_, _mohiyati_, 
   {{0x0b490142,0xf2870143,0xef430144,0xf2900014}},	//   _वर्षाणि_, _фирмени_, _cinsirea, _majat_, 
   {{0x346e0145,0x73780082,0x22920146,0xaf9b00bc}},	//   _храме_, _kimanin_, _berahi_, _ableiter_, 
   {{0x71db0147,0x1d770148,0x02240149,0xf71b00d9}},	//   _ارنبەك_, _得獎名單公佈_, _nwoke_, _опоры_, 
   {{0x4d8c00a4,0x93f4005f,0xb79c00ee,0xbab3014a}},	//   _اڭگەمەلە, _costos_, _sentsazi, _amelyből_, 
   {{0x23f9014b,0x858b014c,0x52d6014d,0xabab014e}},	//   _amburu_, _basebukh, _verlust_, _околини_, 
   {{0xcd6b0071,0xdd9e014f,0x26220150,0x2c9e0045}},	//   _لرزاند_, _poseduje_, _poromani, _poseduju_, 
   {{0xd8910151,0x93ea0076,0x91880152,0xa0da0153}},	//   _purveyor_, _egito_, _жибэреге, _リュステム_, 
   {{0x437e0154,0xd9410155,0xe3c40156,0x11cb0157}},	//   _моноксид, _bedriver_, _באלפור_, _algorytm, 
   {{0xac770158,0x7b55001a,0xa9e30159,0xc387015a}},	//   _damskie_, _rendesen_, _конана_, _ejersa_, 
   {{0xf27f015b,0x0da1015c,0x33f90107,0x5e12009b}},	// [070] _ejensi_, _infokana, _wuruk_, _больжээ_, 
   {{0xf373015d,0x19d0015e,0xd300015f,0x33060160}},	//   _temacie_, _тегин_, _adwaith_, _izbornog_, 
   {{0x3b8a0161,0xa7250162,0x18e70058,0x52ca0163}},	//   _волос_, _گۈلىستان_, _därlinge, _kedden_, 
   {{0x92520164,0x069900da,0xa3ea0014,0x32920165}},	//   _адвокатл, _регларя_, _afati_, _peraki_, 
   {{0xb2ca0166,0x6d090166,0xc6ad0167,0x2e8d0168}},	//   _melden_, _verlinkt_, _ditectif, _motvirke_, 
   {{0x68200169,0x3b83016a,0x5200016b,0x626c013d}},	//   _কতিপয়_, _komitato_, _iznin_, _temon_, 
   {{0xaf91016c,0x8f3d015d,0xe6bf0143,0xd8450156}},	//   _condenar_, _गिरिडीह_, _порталът_, _סטאָרי_, 
   {{0x03f90141,0xdc96016d,0x23d4016e,0x762a016f}},	//   _guruh_, _شاھمات_, _hatalı_, _налагоди, 
   {{0x141800ff,0x52190170,0x2ca50171,0x52120172}},	//   _געהרגעט_, _akukakam, _promiču_, _wonhu_, 
   {{0xf387006f,0x4bbe0173,0x33470174,0xa2c50175}},	//   _sheria_, _বিশ্বব্য, _bulelwa_, _egalite_, 
   {{0x99c30176,0x91060177,0x9d460178,0xe4a300d1}},	//   _nameplat, _ирдыруа_, _apāniti_, _দেৱতাসকল, 
   {{0x42910120,0x32900179,0xd1c9017a,0x9290017b}},	//   _miraa_, _bibas_, _росто_, _najam_, 
   {{0x0851017c,0xa3ce0176,0xea71017d,0xc8fb0072}},	//   _sveriges_, _palvon_, _たかじんのそこま, _pasajeru, 
   {{0x3290014a,0x23f8017e,0x26c5017f,0x0d8d0004}},	//   _hajam_, _chiuj_, _appaaffi, _enkoyera, 
   {{0x82b60101,0xd2d90180,0xd69a00b7,0xe3da0158}},	//   _fructe_, _kuyer_, _dorediji, _zapasów_, 
   {{0x13460181,0xa2d80182,0x51310183,0x2e990184}},	//   _genders_, _kadesa_, _bandikel, _kantwaye_, 
   {{0x134d0185,0x5a2a015e,0x00000000,0x00000000}},	// [080] _cimerek_, _desconne, --, --, 
   {{0x627f0186,0xa8f20187,0x00000000,0x00000000}},	//   _ebanda_, _петрушев, --, --, 
   {{0x3b590188,0xf2910189,0x22d7018a,0x00000000}},	//   _нимчамул, _mizah_, _deallus_, --, 
   {{0xdfd5018b,0x48dc0088,0xf9dc018c,0xb7880014}},	//   _internaţ, _objectiu, _objectie, _norvegji, 
   {{0x42900127,0x52ab018d,0x33f90013,0x6a110105}},	//   _dibar_, _ንምጭባጥ_, _quruq_, _poradnia_, 
   {{0x528c018e,0xfdd500bc,0xa196018f,0x00000000}},	//   _emakaya_, _اسلامشهر_, _neschugh_, --, 
   {{0x0aee0190,0x499a0191,0x63400192,0xdaf600e6}},	//   _fortgehe, _grekiska_, _gemeten_, _annuelle, 
   {{0x12910108,0x149c0193,0x7bef0194,0xddb70195}},	//   _sirah_, _उत्पादने_, _corectur, _eiginnea, 
   {{0xb2d80196,0xf2ea0197,0x42da0198,0x1c6b00aa}},	//   _madera_, _majnèt_, _kopeli_, _manukut_, 
   {{0x43af0199,0x22fc017e,0xc984019a,0x129100a0}},	//   _caovang_, _imagi_, _faciltie, _birai_, 
   {{0x43b4014a,0xced0019b,0x1da4019c,0x6200019d}},	//   _ڈنمارک_, _planetos_, _kutukutu_, _chiipa_, 
   {{0xbe86019e,0xb3f9019f,0xc34a0161,0x059401a0}},	//   _трафік_, _shauri_, _кронштей, _kulekeny, 
   {{0x43fa01a1,0xca7a01a2,0x40f601a3,0x2290005f}},	//   _natuur_, _neizmant, _ڏاڙهون_, _jajaj_, 
   {{0x227f01a4,0x7f4a01a5,0x92910130,0xb6b801a6}},	//   _abanda_, _langesun, _gizah_, _wawatati, 
   {{0xbc6600c8,0x43ce01a7,0x5f900041,0xab61016a}},	//   _намыҫын_, _talven_, _шарктәу_, _asertita_, 
   {{0xea64014e,0x52900013,0xb37c01a8,0x12da01a9}},	//   _иновацио, _lajak_, _spravne_, _retomar_, 
   {{0x27c101aa,0x257601ab,0x00000000,0x00000000}},	// [090] _insteadw, _मिलऽता_, --, --, 
   {{0x52a801ac,0x9f3501ad,0xc1630059,0x00000000}},	//   _يتلقى_, _asistera, _nutrizio, --, 
   {{0x551101ae,0x838601af,0xf3880082,0x41550153}},	//   _cobrando_, _ýerde_, _biyyaya_, _ジを作成する方法_, 
   {{0x8ed800ca,0x586d0139,0x43f801b0,0x21fa005a}},	//   _indianas_, _व्यवलोकय, _bubuy_, _nguntahm, 
   {{0xed1401b1,0x9c6101b2,0x415c01b3,0x00000000}},	//   _स्वर्णिम_, _peerage_, _часткове_, --, 
   {{0xcd8100a3,0x62f60057,0x00000000,0x00000000}},	//   _hyllesta, _arkitek_, --, --, 
   {{0xed09012b,0x4057004e,0x5b1901b4,0x61d900f4}},	//   _terminie_, _galamito, _karavaan_, _diwiskañ_, 
   {{0x12d80073,0x52d801b5,0x59cd01b6,0xfd360138}},	//   _cadera_, _balesa_, _paternit, _gündeme_, 
   {{0x215101b7,0xb0aa008d,0xa2ba00da,0xfc1401b8}},	//   _अभाषत_, _армиясин, _ganduri_, _शुक्रास्, 
   {{0xae4f0114,0x029001b9,0xe3ba01ba,0xf9490064}},	//   _happened_, _gajak_, _ranvers_, _капачылы, 
   {{0xcb990024,0x82d80005,0xe30c01bb,0x1af301bc}},	//   _চুক্তিসম, _falera_, _almarys_, _feardige, 
   {{0xca7901aa,0x627601bd,0x526c00d3,0xd947018f}},	//   _esponsib, _ءﺗﯘﺑﯩﺮﻟﻰ_, _nemoc_, _chomupme, 
   {{0x5eda01be,0x58dd01bf,0x02d80155,0x949901c0}},	//   _zachycen, _forutsig, _radera_, _ganawark, 
   {{0x329001c1,0xda7d01c2,0xad6001ab,0x834e01c3}},	//   _jajak_, _sinatura_, _चढ़ैत_, _anleigh_, 
   {{0xd2d800ee,0x126c01c4,0x72ca01c5,0x1b0f01c6}},	//   _kalera_, _sinode_, _booday_, _joostema_, 
   {{0x1f5501c7,0x87ac0126,0x88b701c8,0xa7db01c9}},	//   _тутмуш_, _søtstoff, _kultivov, _kajastav, 
   {{0x326401ca,0xcf2001cb,0x729000f7,0xe2900112}},	// [0a0] _betleh_, _nokudosa, _alkape_, _hajah_, 
   {{0x728e0171,0x1c6001cc,0x98680066,0x818700a6}},	//   _svakako_, _abhuvan_, _penintsu, _bayaphul, 
   {{0xd6ba01b6,0x641a0094,0x4379017f,0x0cbc01cd}},	//   _javascri, _بىردەڭە_, _appaasa_, _ақали_, 
   {{0xc39f01ce,0x1d9f01cf,0x2d1900ce,0xb2d401d0}},	//   _اصناف_, _mangiate_, _dinnyite_, _myrdet_, 
   {{0x88d501d1,0xfd0b0077,0x632801a3,0xeea401d2}},	//   _לאנדרואי, _boulchit_, _ٽونيءَ_, _derechus_, 
   {{0x6c980195,0x8b2f0192,0xe5900019,0x1fe40188}},	//   _tarraing_, _확인해주세요_, _сериясын_, _шумурда_, 
   {{0xf99201d3,0x9bed0153,0x62d80020,0x4c0001c4}},	//   _verklige, _お支払い方法につ, _salesa_, _kunsmis_, 
   {{0x22eb0071,0x32d801d4,0xf090003c,0x52f301d5}},	//   _آثاری_, _palesa_, _اکوسیستم_, _بطوطہ_, 
   {{0x01ad00b4,0xd2c301d6,0x4eb701d7,0x905800c8}},	//   _вагабонд_, _skylden_, _admessas_, _hlaselan, 
   {{0x829001d8,0x7d5a00c7,0x515c01d9,0x95dc0092}},	//   _bajah_, _ролен_, _jangdebl, _困っています_, 
   {{0x529001da,0xf9370039,0x9b4d01db,0x72b30107}},	//   _babai_, _бамбар_, _ирандағы_, _نیاکان_, 
   {{0xaf3c01dc,0xc4f60037,0x15f201dd,0xebf601bd}},	//   _annunzia, _ፍርስራሽ_, _agambiri, _жайтты_, 
   {{0x6d070036,0xa36401de,0x9290010d,0xb4d700d3}},	//   _عضومهوبج, _انتانتا_, _wabah_, _विधिको_, 
   {{0x1ae30122,0xf2d001df,0xdf410092,0x09ef0132}},	//   _cuplikan_, _flattery_, _申し訳ございませ, _forintra_, 
   {{0x123c0003,0xce4700c3,0x5cb801e0,0x8d910040}},	//   _감사합니다_, _隱私權政策_, _گزینگ_, _nonlinea, 
   {{0x15b501e1,0x468201e2,0x03e4004d,0x1ed601e3}},	//   _февралдә_, _परसाई_, _誰推薦這篇文章_, _fižol_, 
   {{0x348001e4,0xa77301e5,0x805001e6,0x531301e7}},	// [0b0] _सेनाको_, _akáríayé_, _maturitn, _definitv_, 
   {{0x6c5101e8,0x1d0101e9,0x00000000,0x00000000}},	//   _taktika_, _khampane_, --, --, 
   {{0xb2550173,0x925a013d,0x3c4d01ea,0xe34201eb}},	//   _হিন্দি_, _stelo_, _сигарета_, _copeton_, 
   {{0xfcdf014c,0x036401ec,0x629000b9,0xaa210080}},	//   _amakhulu_, _anggara_, _cabai_, _ajaperlu, 
   {{0x92900193,0xb2d801ed,0x33f9002f,0x9c7601d2}},	//   _pajak_, _kalepa_, _arrus_, _charini_, 
   {{0x608c00d6,0xa3430020,0x8b9701ee,0xd34e0151}},	//   _ɱęḏǭǭ_, _apreamo_, _файлам_, _aileagh_, 
   {{0x636e01ef,0x4fd801f0,0x729101f1,0x66d800ae}},	//   _maitinim, _badirabo, _mirat_, _bataratw, 
   {{0xfbb101d5,0xb43d002b,0x6e0f01f2,0xb5dd01f3}},	//   _مصطفوی_, _নাফিস_, _өзүклард, _kamerový, 
   {{0x4b1801f4,0x12310103,0x228d01f0,0x00000000}},	//   _tugatgan_, _chimiso_, _maokelo_, --, 
   {{0x533601d9,0xa7fa0169,0x12e901f5,0x53790119}},	//   _bäcker_, _উত্তীর্ণ_, _pipinya_, _bayawan_, 
   {{0xb7fa01f6,0x438701f7,0x124a01f4,0xf057016d}},	//   _উত্তীৰ্ণ_, _therma_, _истаклар, _синипий_, 
   {{0x827f01f8,0x59a9018d,0x4b4d0035,0x8db800e2}},	//   _abanza_, _ክኾነልና_, _apparatı_, _beliedsp, 
   {{0x517e008d,0x22910119,0x1eda01f9,0x623b01fa}},	//   _jarayonl, _razavi_, _emaheden, _meletoti_, 
   {{0xcd8e01fb,0x829001fc,0x9b9201fd,0xf9e6011b}},	//   _incontra, _gabaw_, _poniendo_, _kimobola_, 
   {{0xaa0d0196,0xf38000a8,0x729001fe,0x8d8c01ff}},	//   _anganene, _surren_, _tabai_, _premeria, 
   {{0xfd2301f1,0xb2900105,0x83e40024,0x130c0037}},	//   _familjet_, _zabaw_, _অনুকৰণ_, _በፈቃዳቸው_, 
   {{0xf25b0200,0x5ba200ff,0x484200db,0xd3b10062}},	// [0c0] _ewuli_, _אַדלער_, _rulluisu, _nisqu_, 
   {{0x12910201,0xf3f80202,0x59d401a3,0x9b210203}},	//   _girat_, _fenuko_, _تَهَجّد_, _proprime, 
   {{0x078b0156,0xf33200d3,0x320000a0,0x2da801c5}},	//   _קלינג_, _spekuluj, _damina_, _kirishta, 
   {{0xf5e0008f,0x9fa9002b,0xf27f00db,0x00000000}},	//   _कण्ट्रोल_, _সময়সূচী_, _haanja_, --, 
   {{0xd4790039,0x6c660204,0xe2cb0037,0x65970205}},	//   _польшийн_, _kenties_, _የሚገቡት_, _бандага_, 
   {{0x9c5f0189,0x23ac015d,0xd20000d2,0xec670206}},	//   _unuttum_, _grupie_, _namina_, _centier_, 
   {{0x725a0207,0x73f90084,0x2db40032,0x55c5004e}},	//   _jumla_, _burut_, _hurnajna, _kapaagih, 
   {{0xcde001a3,0x79f60208,0xca7e0209,0x27f0020a}},	//   _مسافرخان, _روسیا_, _akunnits, _классигі_, 
   {{0xf5b801c7,0x42e800be,0x79f701b5,0x150c002c}},	//   _belarusy, _perfet_, _nyenyana_, _баяннуур_, 
   {{0x83ea0196,0xc27f01dd,0xfd9c020b,0x00000000}},	//   _ngati_, _ubanza_, _gatelele_, --, 
   {{0x93f9020c,0x727f020d,0x33ea01b8,0x92ef017a}},	//   _turut_, _abanya_, _igati_, _akhipha_, 
   {{0xbb29020e,0x1c64020f,0x98430210,0x0fa90211}},	//   _водителе_, _babuhle_, _chemutau, _lammasko, 
   {{0x892901bd,0xed870212,0x9eed00ce,0xd53f005e}},	//   _дербес_, _oddworld_, _manholes_, _ﭘﻪﺧﯩﺮﻟﯩﻨ, 
   {{0xf3f90051,0xa2480132,0x12da0160,0x02920144}},	//   _kurus_, _semmit_, _opremu_, _murach_, 
   {{0x6acc0213,0x629101b7,0x43e60083,0x00000000}},	//   _обезвреж, _ciram_, _declaraz, --, 
   {{0x416e0214,0x130a0215,0x88af0041,0x3dcb0052}},	//   _abasenko, _statsråd_, _иьҩахан_, _मध्येका_, 
   {{0x82000216,0x1b8e0217,0x60390157,0x00000000}},	// [0d0] _yamina_, _cocinero_, _uaktualn, --, 
   {{0x22e80149,0x13f9018f,0xb0ea01cd,0x00000000}},	//   _spaiwia_, _nurur_, _захирахо, --, 
   {{0xd9580218,0xa2910139,0xdd890218,0x5a7600e0}},	//   _unplanne, _giram_, _actorswa, _evaluaas, 
   {{0x5eb60219,0xa605021a,0xcea000ba,0xa348018d}},	//   _outright_, _adamsani, _رپوول_, _ትሸባሸብ_, 
   {{0x6f95021b,0x22fb0195,0xe9d50065,0x656f013f}},	//   _близко_, _cathara_, _arbeitne, _apadravy, 
   {{0x9292021c,0xc258002f,0xde710086,0x43f4021d}},	//   _strany_, _tlatelol, _پرنریندر_, _rystet_, 
   {{0xd8380089,0xd25a01b9,0xdb0c021e,0x72c601b4}},	//   _башлангы, _cvilin_, _priserna_, _verlore_, 
   {{0x92910076,0x6eae021f,0x2290003d,0x528d01aa}},	//   _viram_, _americat_, _cabau_, _antsgray_, 
   {{0x12e900e9,0xe15c015e,0xf37f020e,0xa5190220}},	//   _bruneau_, _булак_, _dimalwa_, _acquario_, 
   {{0xa3f901b7,0xb683010d,0xa2da011b,0x00000000}},	//   _gurur_, _होकार_, _mipesi_, --, 
   {{0xfc070221,0x33550222,0xf7af0223,0x00a20224}},	//   _khasiat_, _ouverts_, _aportazi, _fornbíla, 
   {{0x43f90225,0x2c610087,0x0eea0226,0x8dc50227}},	//   _aurur_, _averiwe_, _amakagon, _perincia, 
   {{0x8eb1003b,0x1e8401be,0x3309020f,0xa0630064}},	//   _akulobun, _neskuteč, _اودخپلو_, _колодон_, 
   {{0xe2c30228,0x69600079,0xe291019f,0x32480020}},	//   _skalaen_, _ekspozīc, _mabasi_, _siomia_, 
   {{0xc8410174,0x73f90229,0xd25a022a,0x72b900e0}},	//   _kholaped, _durur_, _stels_, _handich_, 
   {{0x1230006c,0xd1470013,0x5388006c,0xa253022b}},	//   _abamisa_, _захира_, _abasoham, _akelduni_, 
   {{0x923f0061,0x42e6007b,0x6291000d,0x426c00fd}},	// [0e0] _신청합니다_, _spinnin_, _tabati_, _fanoid_, 
   {{0x3290022c,0x4292019b,0x92490095,0x42da0181}},	//   _mojang_, _kitais_, _adamel_, _assens_, 
   {{0x7b870204,0x52900120,0x952b0191,0x2d6b022d}},	//   _rekister, _gabat_, _underlät, _stampate_, 
   {{0xc0d2014a,0xc2910085,0x399d0041,0x89110009}},	//   _تمھارے_, _kabasi_, _ҳашыг_, _pojasnju, 
   {{0x073e00dc,0x8688022e,0x9fe0022f,0xd67f0120}},	//   _amalosig, _mundiali, _vadinamo, _sheekiti, 
   {{0xe2910230,0x43f90231,0x929000c7,0x8c440118}},	//   _mirak_, _purus_, _kabat_, _abawala_, 
   {{0x429100c7,0x02da0232,0xa967001a,0xebd20233}},	//   _tiraj_, _ripeti_, _mennyeze, _goldenbr, 
   {{0xa2910115,0xe2910119,0xc36c0234,0xb2f50235}},	//   _nizar_, _nabari_, _langidi_, _caritum_, 
   {{0xb2900054,0x5a7e0080,0x4c1d0236,0x68b40237}},	//   _dabam_, _ajungits, _stupaju_, _내부에서도_, 
   {{0xb9b70238,0x79aa00d7,0x00000000,0x00000000}},	//   _класифік, _содис_, --, --, 
   {{0x215b0218,0xf2b50230,0x3cf20239,0xbbc1023a}},	//   _allowway_, _eredite_, _arataher, _biskupic, 
   {{0x5291023b,0x103c0086,0x23800014,0x269c0204}},	//   _sabati_, _طغیانی_, _burrin_, _palestii, 
   {{0xdcb3023c,0xc2d7023d,0x825e00dc,0xb200023e}},	//   _abanomnq, _ritorno_, _aouliuli_, _puniki_, 
   {{0x52910130,0xd2da023f,0xa25a00b4,0x23f30240}},	//   _dirak_, _upsets_, _orele_, _veiraici_, 
   {{0xc3000067,0x83790241,0x0ad5007b,0x00000000}},	//   _arfanii_, _baqataa_, _murthere, --, 
   {{0x7a4d0242,0x829001f0,0x40290045,0xdc620152}},	//   _qondarma_, _bojang_, _реформе_, _baruın_, 
   {{0x34fb00e4,0xd2b5011d,0x92910243,0xd6770137}},	// [0f0] _कोठारी_, _credite_, _kirah_, _ухури_, 
   {{0x5d5d0244,0xdeb7010f,0x68bd0148,0xe0b20156}},	//   _гаранция_, _таманно_, _全國法規資料庫_, _מחוצפים_, 
   {{0xc3f90245,0x89b80246,0x9c1800bd,0xb2910247}},	//   _kurup_, _татуиров, _gospels_, _mirah_, 
   {{0xa29100e1,0x331c0036,0xb86400a4,0x829000b6}},	//   _jabari_, _bolcán_, _fernànde, _rabal_, 
   {{0x8c080040,0xf2650156,0xc2d800e1,0x770e0248}},	//   _הצטיינות_, _בולקע_, _lileen_, _austrohú, 
   {{0x6a0b020e,0x9201023b,0x0fc80249,0x3a5c015e}},	//   _bapatsoa_, _inaina_, _tikilaso, _داستانچى_, 
   {{0x2927024a,0x12e70129,0x20b400f3,0x3ffb005e}},	//   _ọpọlọpọ_, _filipaị_, _anemibal, _ئۆركەش_, 
   {{0x456d0163,0x425a0202,0x426e0107,0x79fc012e}},	//   _داستانیں_, _irele_, _asromo_, _engedmén, 
   {{0xa2ea024b,0x13f80195,0x59e000aa,0x13160039}},	//   _cuentas_, _chaum_, _gatugatu, _zuhaitz_, 
   {{0xcc7f01a3,0xf2900013,0x7637024c,0xe8ea00b6}},	//   _waislam_, _najas_, _disiandi, _seegondu, 
   {{0x60b4024d,0xd1c3024e,0x99f9024f,0xf25a023b}},	//   _enemibal, _postupak_, _damuvaku, _huelo_, 
   {{0xf34f0250,0x42d80251,0xa3dc00c2,0x73470252}},	//   _komenti_, _dileen_, _bwawo_, _vulelwa_, 
   {{0x53f90125,0x216c0093,0x197e0253,0x40730159}},	//   _durup_, _основанн, _sivisune, _пусты_, 
   {{0x529100b6,0x4d810235,0xfde000c5,0x731c0254}},	//   _girah_, _bhartṛ_, _affirmé_, _volcán_, 
   {{0x1201023b,0xe2900255,0x93480126,0x834700dc}},	//   _anaina_, _majas_, _монастир_, _fememea_, 
   {{0x83f900b7,0xf34700dc,0x7c4b00e6,0x12900256}},	//   _gurup_, _galeuga_, _港口物流对经济的, _labak_, 
   {{0x3ab40257,0x624f0258,0x72910259,0x50bf0050}},	// [100] _brasilíu_, _grifform, _hirai_, _ngamumul, 
   {{0xf8fc025a,0x329100ad,0x93b60100,0x568b00fb}},	//   _bakagend, _sabari_, _slavlja_, _nasekuzi, 
   {{0x6a9b0152,0x8076025b,0x8b1d025c,0x730e0008}},	//   _berençel, _skipanin, _anpassen_, _assajos_, 
   {{0xc291005b,0x6eae025d,0xf9e300fe,0x8409025e}},	//   _mirai_, _villrein, _molofaha_, _breiðskí, 
   {{0x57b401b6,0x1d8b025f,0x42010260,0x92900243}},	//   _filejung, _bakokuta, _chaira_, _rabam_, 
   {{0x5c0f002b,0x39fa0059,0x00000000,0x00000000}},	//   _চৌদ্দগ্র, _penisola_, --, --, 
   {{0x72ea0261,0x86180262,0xac5201b8,0xf29201b2}},	//   _atendas_, _begendim_, _जितेश_, _arragy_, 
   {{0x52ca0263,0xb500012c,0xd8fd0139,0x94680078}},	//   _gelden_, _akimvish, _chraddad, _ораторст, 
   {{0x82cc0012,0x2aed0264,0xc2ca0265,0xeb770196}},	//   _अकरबउअभक, _direktib, _redden_, _bamovwir, 
   {{0xaf3c0266,0x16b100c1,0x0f290037,0x52920267}},	//   _kesusaha, _गोपाळकाल, _የታወቀው_, _igraci_, 
   {{0xb291003e,0x00f2005e,0x2461010d,0xfc050268}},	//   _mabapi_, _ﺷﯩﻤﺎﻟﯩﻲ_, _mendetek, _adarray_, 
   {{0x925b00dc,0x3fc701ec,0x6e9c0092,0x79dc00f2}},	//   _itula_, _خاکستری_, _centralt_, _objektie, 
   {{0xb2d801e8,0xf2f700fc,0x42ca0265,0x32900269}},	//   _andean_, _bonejlaw_, _velden_, _bajas_, 
   {{0xf200026a,0x4290026b,0x5ae9005e,0x47cd026c}},	//   _kamica_, _cajas_, _ھۇزۇرۇڭل, _corporum_, 
   {{0xbe5d0238,0x13f800ad,0x9dc6026d,0x9ec10110}},	//   _матчу_, _shaum_, _mrakodra, _nikolajs_, 
   {{0x6986026e,0xb6b60213,0xd16e019a,0xa2c1026f}},	//   _बालकृष्ण_, _малышка_, _invintry_, _ىلىسىپ_, 
   {{0x22010270,0x00000000,0x00000000,0x00000000}},	// [110] _legite_, --, --, --, 
   {{0x6e9c0271,0x0dc3003e,0x856201f2,0xab200272}},	//   _sentralt_, _медиамаг, _җуңголуқ_, _babayamb, 
   {{0xc26c0160,0xa25a0273,0xafb70274,0x19a5022f}},	//   _nemoj_, _suelo_, _helgadót, _алмазаў_, 
   {{0x925b007f,0x72ef010d,0xb7b1002b,0x34ca0110}},	//   _baglor_, _syafii_, _ভূঁইয়া_, _patruļku, 
   {{0x125b0275,0xcb770276,0xa29000d2,0xae3b001b}},	//   _atula_, _راستلا_, _jajar_, _garaarra, 
   {{0xf8430026,0x82900201,0xd2070205,0xb2960277}},	//   _되었습니다_, _cabak_, _терговчи_, _figgalow_, 
   {{0x82370055,0xc02a0037,0xa31a00ad,0x163300a8}},	//   _stimata_, _ጂዮግራፊ_, _hariwang_, _abunamai, 
   {{0x01db0017,0x3581005e,0xf3430026,0xc2900278}},	//   _majitelé_, _мәнилик_, _ongeval_, _wabak_, 
   {{0x525b01a4,0x66b900ae,0xae470279,0x228d027a}},	//   _etula_, _kikaziri, _semblera, _raskida_, 
   {{0x43f50092,0x7b040043,0x934301c4,0x27a20257}},	//   _実施形態の変形形, _amasaafa_, _ingeval_, _brauðris, 
   {{0x70b4027b,0x72900201,0x1291016b,0x63eb019d}},	//   _शुशुभे_, _rabak_, _bazai_, _choonjez, 
   {{0x22a600c7,0x2290026b,0x4ac90126,0x215b0092}},	//   _sember_, _bajar_, _пропоную, _じゃなくて_, 
   {{0x12900005,0x3fcd0144,0x329000a0,0xe3dc01a3}},	//   _pajas_, _chinnteo, _cajar_, _atiwa_, 
   {{0x9759010d,0xe455027c,0xaef700cb,0x7c5000e0}},	//   _निर्बंध_, _bendisaz, _гармихо_, _plechtic, 
   {{0x92900120,0xeae2027d,0xc740013d,0x42ea027e}},	//   _gabah_, _umetnost, _signifoj_, _tacnost_, 
   {{0x128801fb,0xac30009a,0x67ae002f,0x0640027f}},	//   _pesantem, _abasisis, _amutachi, _baciyami, 
   {{0x24a5004e,0x51690013,0x23dc0149,0xc0c6003a}},	// [120] _klinikal_, _мелодий_, _etiwa_, _millionl, 
   {{0x9e1c0218,0x60e40280,0x44650151,0xd9e301c0}},	//   _oragesta, _थ्रीडी_, _airwoman_, _godiyata_, 
   {{0xb283017e,0x68f60281,0xd2e801ad,0xe2900085}},	//   _מרידה_, _innarluu, _diliman_, _kabai_, 
   {{0x28c70184,0xa005007e,0x82e801da,0x42020282}},	//   _agatweng, _bhasmasā, _dominon_, _poriro_, 
   {{0x7f5700b3,0xd2780076,0xc5c601f9,0xc25a024c}},	//   _sungatyn, _jornal_, _atibhubh, _armla_, 
   {{0xf2900159,0x02fc0283,0x23cf0284,0x57e30061}},	//   _labai_, _demgya_, _slavie_, _과기대학은_, 
   {{0x3ae50285,0x227e006d,0x22870162,0x1e4200de}},	//   _itsembab, _zmones_, _пахтикар, _angabaza, 
   {{0x12e8022a,0x967a0188,0xb8560231,0x00000000}},	//   _hiliman_, _методӣ_, _mensibus_, --, 
   {{0x5c5b0286,0xd1730287,0x8e28020f,0x42e8008b}},	//   _waguare_, _उडीसा_, _bangayip, _kiliman_, 
   {{0xe89b0288,0xbaaa00b5,0xb1de0075,0x6f8001cd}},	//   _kamwarar_, _arevéta_, _tunnilsm, _масеҳӣ_, 
   {{0x92ba0168,0x8ba101b5,0x9255002b,0x131801f4}},	//   _koselig_, _hinhlayo_, _শার্শা_, _fanining_, 
   {{0x827f0289,0x02900005,0xc2900242,0x228e0166}},	//   _abanja_, _pajar_, _qabaq_, _richtet_, 
   {{0xa98b002e,0x59f9012f,0x2d120126,0x1278028a}},	//   _mlađi_, _kamarare, _добрий_, _raundi_, 
   {{0x3906028b,0x8c560243,0x7a61003e,0x00000000}},	//   _airamogu, _dattowe_, _артһын_, --, 
   {{0x7e4d0026,0xf35f0021,0x9c5c00d7,0x225a028c}},	//   _대학보고서_, _achecay_, _boltril_, _uuele_, 
   {{0xd2a7028d,0x96680092,0x1200028e,0x5d0d004d}},	//   _alabaz_, _百科事典で調べる, _yunien_, _在下載使用時必須, 
   {{0xa23d00f5,0x1140026c,0x9a01028f,0xb26e0290}},	// [130] _гөрүҗили, _accusato, _hunaonga_, _aprovo_, 
   {{0xb3f0017e,0x237801f1,0x90bc0291,0x4bf200d1}},	//   _corsetti_, _namazin_, _إيميلك_, _নাৰায়ণ_, 
   {{0xd97a00df,0x79c70145,0xa29200b3,0xf14f0287}},	//   _souhaite, _шагала_, _turany_, _आयोगलाई_, 
   {{0x340f0121,0x33ea00d9,0xee54010d,0x7c6a0061}},	//   _cargando_, _laite_, _ketagiha, _계획이라고_, 
   {{0x32f70243,0x981b0148,0x6c03003c,0xf0c00156}},	//   _arkiseh_, _台鐵網路訂票_, _رصدخانه_, _טערקישער_, 
   {{0xebea0029,0xe3410292,0x65f00142,0x00000000}},	//   _پلاتفۆرم, _ɛremma_, _chandāṃs, --, 
   {{0x0ed9000a,0xf2ca019a,0x9bb20293,0x52ca022b}},	//   _aalisarn, _beddin_, _abazimis, _keldan_, 
   {{0x50090244,0x0fa70181,0xa3950116,0x723700df}},	//   _занимава, _lasvegas_, _merse_, _trajet_, 
   {{0x9d760210,0x0320022b,0x00000000,0x00000000}},	//   _chamunop, _floytu_, --, --, 
   {{0x0320015e,0x5e6d0294,0x0a570295,0xc52b0296}},	//   _buscant_, _carcelma, _palemiaa_, _underläg, 
   {{0x6cef0039,0xa3ea0144,0x85c000d1,0x8661021c}},	//   _болдоггү, _daite_, _উদ্দীপদা, _optická_, 
   {{0x4200005b,0x00000000,0x00000000,0x00000000}},	//   _aojiru_, --, --, --, 
   {{0x12fc0270,0x13720195,0x8d1a01fd,0x430a0297}},	//   _feminas_, _armachd_, _reconoce_, _açalar_, 
   {{0xc3ce0074,0x37650148,0x99190060,0x025a006d}},	//   _halvin_, _邀請成為朋友_, _миналаға, _brolis_, 
   {{0xecbf0298,0x65b60177,0x4ad50299,0x684e0241}},	//   _tapatoru_, _сыҧсҭаза, _ئىقدىدار, _duroomsu, 
   {{0x02e2029a,0xf3a8029b,0x89f9020f,0x37360040}},	//   _andomaz_, _béppu_, _anyanise, _סימפסון_, 
   {{0x9c7d029c,0xd4e9018d,0x6743029d,0xa387029e}},	// [140] _akusowa_, _ስርሖያት_, _сурсэ_, _dabreg_, 
   {{0xd1b10024,0x0e670019,0xfb1b029f,0xf36402a0}},	//   _তাকেই_, _рахмат_, _zaplatiť_, _elegún_, 
   {{0x4da20029,0xd495004b,0x00000000,0x00000000}},	//   _ناچنه_, _гвардияһ, --, --, 
   {{0x639502a1,0x8c6e0084,0xe81c0109,0xc25a00fd}},	//   _ierse_, _acarana_, _cukrářsk, _polloi_, 
   {{0xab19021a,0x98fd0028,0xaf0b005e,0x13640258}},	//   _barataan_, _danahood, _ھەمسۆھبە, _hingjen_, 
   {{0x3e4602a2,0x7861019b,0xf5da0291,0x839502a3}},	//   _matangga, _aktoriau, _معظمهم_, _kerse_, 
   {{0x15290175,0x69f802a4,0x7b9a00e6,0xb4780041}},	//   _apropriy, _movablet, _社会事业类_, _ҟаҳамҵар, 
   {{0x8e170047,0x72910287,0xef0000da,0xaa6e0037}},	//   _中华人民共和国商, _mazat_, _редакцие_, _በብቸኝነት_, 
   {{0x70f502a5,0x927e00ef,0x72910080,0x62910278}},	//   _अप्रेल_, _acinga_, _niras_, _lazat_, 
   {{0xfc84007b,0x3dbd0282,0x94bf0160,0xe77201ee}},	//   _interred_, _kahakore_, _slovačko, _пурăнака, 
   {{0x3dc50291,0xb68101c9,0xfa8e001e,0xe35e02a6}},	//   _ابراج_, _सईयां_, _kwanakin_, _confusi_, 
   {{0xe398018d,0x72b80093,0x12fb00bc,0x9bf102a7}},	//   _ሰለስቲኡ_, _саратовс, _bathara_, _raitsits, 
   {{0x116f0089,0x726e00a4,0xe27e00ef,0x00000000}},	//   _cimergän_, _imposa_, _ecinga_, --, 
   {{0xe80b01db,0xd2b50017,0xb29100a1,0x23ea0050}},	//   _ءتاۋىپتى_, _desce_, _pirau_, _waktos_, 
   {{0xd159014a,0x5380028f,0x029101f7,0xf00b014e}},	//   _ہوشیار_, _ahurei_, _virat_, _спасе_, 
   {{0xe25a0003,0xa29000e4,0x1ea50249,0x22cb011f}},	//   _stelt_, _jakaś_, _jenuware_, _evedoo_, 
   {{0x2ede0089,0x83bc00bc,0x2c290037,0x4e4602a2}},	// [150] _нинди_, _الانم_, _ሊበራሊዝም_, _natangga, 
   {{0x81550162,0x308a00ff,0xe61d00f2,0x436502a8}},	//   _ناتونۇش_, _אינדאסטר, _nenotici, _disgħa_, 
   {{0xc2000053,0x9be40038,0xa19a005e,0xc3dd0116}},	//   _hunian_, _waşingto, _پىنيىن_, _chawed_, 
   {{0xa3ea0184,0x1bd102a9,0xc3eb02a6,0xba9100a9}},	//   _agati_, _klientų_, _oretta_, _karisimb, 
   {{0x33dc019c,0x3d7a0258,0x00000000,0x00000000}},	//   _awawi_, _hiemside_, --, --, 
   {{0xd291017e,0x037300ac,0x290b026f,0x3fc302aa}},	//   _diras_, _zadatke_, _الجىعاند, _dokonalo, 
   {{0x225b02ab,0x08cc02ac,0xa13102ad,0xa2470274}},	//   _ntule_, _لقبيلة_, _zviditel, _fallegri_, 
   {{0x553c0278,0xd25b0129,0x4fb200d6,0x39990074}},	//   _sekirany, _itule_, _هداوه_, _антенны_, 
   {{0x89120163,0xd3d0018b,0xde960123,0x01e10153}},	//   _fanatiku, _меканизм_, _letteste_, _おすすめの関連商, 
   {{0x1ad80229,0x89e302a4,0x0291001e,0x9b1900ad}},	//   _filminin_, _fratribu, _hirar_, _rarasaan_, 
   {{0xafc2028a,0xb19f0132,0xf249028c,0xf4ad0065}},	//   _بارود_, _استقبالی, _teemat_, _vollstän, 
   {{0xa2010087,0xe1d102ae,0x4c6d004c,0x62000115}},	//   _anyika_, _doručak_, _abirina_, _bunian_, 
   {{0xa29100ce,0xde9f0226,0x053a01ed,0xa3450258}},	//   _pirat_, _adamuzun, _hoopoino_, _mindert_, 
   {{0x2f320072,0x628c02af,0x3dc3020e,0x929000f2}},	//   _ikirasip, _arekura_, _fanitjha, _allaž_, 
   {{0xee5101ef,0xe5d302b0,0xe291021e,0xd55102b1}},	//   _patarima, _manchmal_, _firar_, _bishiyoy, 
   {{0x834902b2,0x5c7a015e,0xb27e00bd,0x3202001d}},	//   _героїв_, _بۇياعىنا, _coonts_, _morito_, 
   {{0x525b002a,0xef7d02b3,0xe9ec002b,0x49cb02b4}},	// [160] _atule_, _ámbalas_, _রহিমা_, _kulesaye, 
   {{0xbb9f02b5,0x26630017,0x434f0042,0xc4fa02b6}},	//   _ngozlozs, _पोलिटब्य, _comecei_, _роликтың_, 
   {{0x827f02b7,0x329102b1,0xaa9102b8,0x00000000}},	//   _mbanna_, _kirar_, _karirimb, --, 
   {{0x9b2a006c,0x773102b9,0x7d070094,0xd14700bf}},	//   _ababesab, _پھنسی_, _артисі_, _рашида_, 
   {{0xc46e0217,0x194c0187,0x79c702ba,0xe38a02bb}},	//   _fardello_, _потрошув, _дарачае_, _górna_, 
   {{0xfe6b00a2,0xc2d80074,0x45c80285,0x04f101db}},	//   _حيسڪو_, _videon_, _ushakish, _ورلەۋدەي_, 
   {{0x139602bc,0x62dd02bd,0x72aa012e,0x976401f4}},	//   _narsaw_, _goroesi_, _اریتریا_, _kelishig, 
   {{0xae4602be,0xc25b01bb,0xfb360156,0x0bca00d1}},	//   _tatangga, _daglar_, _בייעסד_, _কেন্দ্ৰব, 
   {{0x23dc02bf,0xca5a0188,0xe667027b,0x83180155}},	//   _atiwe_, _нобиноён_, _रेफस्य_, _socialtj, 
   {{0x0b5e02c0,0x77420240,0x834100b3,0x90ac0079}},	//   _храна_, _johnsonv, _koreýa_, _nemaksāj, 
   {{0xc1fd012b,0xdce80177,0xdc5002ac,0x1a9102c1}},	//   _tematach_, _ишәыднаг, _síciatra, _baririmb, 
   {{0x92910217,0x531c02c2,0xe2920008,0xa29102c3}},	//   _piras_, _verbaas_, _agradi_, _odchody_, 
   {{0x4c080013,0x731802c4,0xf290001c,0x8a4200ba}},	//   _قوتاردی_, _западнат, _aabat_, _زێکیت_, 
   {{0x229002c5,0x87c70141,0xc2d80065,0xebe00148}},	//   _sabau_, _масиҳий_, _andern_, _obtemper, 
   {{0x645a02b6,0x525601db,0x5d520061,0xff2002c6}},	//   _айырылад, _سۇيتسەم_, _결정짓는가_, _divelfen, 
   {{0xd0150212,0xcb4400ff,0xa90901cd,0x646602c7}},	//   _muiderpo, _מעכאניזם_, _мехарад_, _rundfunk, 
   {{0x53b00044,0x8ccb00be,0x69bb0257,0x00000000}},	// [170] _בממוצע_, _بئيىكە_, _ómenntað_, --, 
   {{0x42900082,0x09cd0212,0xfd9a0028,0xd30f003d}},	//   _gabas_, _norewrit, _danowada, _apraiar_, 
   {{0x975900e4,0x062b01ef,0x862c02c8,0x3b2000cb}},	//   _मित्रवत_, _susitari, _arbitrax, _bababamb, 
   {{0xd2da02c9,0x972102ca,0x83050262,0x57c702cb}},	//   _cateva_, _riarachá, _гыргын_, _napravim_, 
   {{0xf2e7019e,0xc29100a6,0x4b670035,0x00000000}},	//   _kainavo_, _eiraq_, _кабере_, --, 
   {{0xd33d00ba,0x22c50195,0x4d9c01b5,0x00000000}},	//   _ئیزاک_, _fhillte_, _matekele_, --, 
   {{0x12900030,0x827300e6,0xc2e90155,0xd7dc0055}},	//   _dabas_, _提高企业经济效益_, _bebisen_, _abbastav, 
   {{0xe2910140,0xc27f0011,0x4a6500bb,0x00000000}},	//   _hirap_, _abanna_, _تھکاوٹ_, --, 
   {{0x96cd0183,0x285a0190,0xadc602cc,0x12910249}},	//   _mampalah, _entrails_, _drakidra, _kirap_, 
   {{0x684a018d,0xe25b02cd,0x4860018a,0xe36902ce}},	//   _ቅዋማውን_, _kwalen_, _ariannir_, _lengser_, 
   {{0x429001af,0x61b0014a,0xd5f5018d,0xad290203}},	//   _habar_, _زرمبادلہ_, _ፖለቲከኛታትን_, _sibilant_, 
   {{0xf5f900da,0x12900250,0x250a02cf,0x32a702d0}},	//   _декатэ_, _tokave_, _certinho_, _neebor_, 
   {{0x12900117,0x528e00d5,0xf29002c2,0x3b730156}},	//   _sabat_, _apostoly_, _babas_, _לעזביאַנ, 
   {{0xf3f802d1,0x9ebe02d2,0x709602d3,0x22480272}},	//   _khaus_, _esandlen, _членовит, _akomya_, 
   {{0xb5b401bc,0x030d012c,0xf29000c7,0x63b60235}},	//   _sympatyk, _kumbuka_, _qabat_, _asevata_, 
   {{0x23780082,0xd2fd02d4,0x8ae600bf,0x50f60156}},	//   _zamanin_, _adegna_, _стеклопо, _עבֿירות_, 
   {{0x329000b0,0x7f3902d5,0x12900255,0x55110076}},	// [180] _gabar_, _बालिवुड_, _tabas_, _sorrindo_, 
   {{0x827a0061,0x38410126,0x4d86003c,0x818f0243}},	//   _persoonl, _екологія_, _anglampa, _manannay_, 
   {{0x475001b2,0x8dc80025,0x39c702d6,0x560602d7}},	//   _counterv, _उद्यानं_, _далалар_, _harmónic, 
   {{0x427800a9,0x26c600ad,0xb9790177,0xc52c00ba}},	//   _ubundi_, _kapanggi, _рартистк, _ناشێت_, 
   {{0xd6b7012b,0x629002d8,0xdc5202d9,0x375902bb}},	//   _obserwow, _jabar_, _amatala_, _दिर्हाम_, 
   {{0x0290022f,0x512d0076,0x1dbc02da,0xd29102db}},	//   _dabar_, _расте_, _картичка_, _girap_, 
   {{0xd31a0040,0x8d230018,0x00000000,0x00000000}},	//   _dividing_, _torocake_, --, --, 
   {{0xf3f101e8,0x2291009b,0xe73001ec,0x82d80261}},	//   _layering_, _garai_, _میدانید_, _acheti_, 
   {{0x392c0060,0x358000e6,0x44f40299,0xf16f00d1}},	//   _تارتىمدى_, _上海市卫生局_, _تىرشچانل, _শিলপূজা_, 
   {{0x326c02dc,0x3ae60105,0x2fb301f4,0xb60201f4}},	//   _lemos_, _एव्यूज_, _mustahab_, _adolatsi, 
   {{0x31ef0024,0x099a02dd,0x629002b1,0xd291022f}},	//   _উন্মুক্ত, _albaniża_, _zabar_, _barai_, 
   {{0xe2900247,0xe40702de,0x63ea0176,0xca7600cb}},	//   _babar_, _महादशा_, _saita_, _авиатсио, 
   {{0x33ea01a7,0xc2830268,0xf29002df,0xda380122}},	//   _paita_, _ailstray_, _cabar_, _تونستی_, 
   {{0xe29102a8,0xa2c200b3,0xda7d0039,0xa34902e0}},	//   _tarah_, _adalata_, _sinadura_, _disenyi_, 
   {{0x227202e1,0x129102c5,0x88430079,0x7292001d}},	//   _محافظة_, _farai_, _partijas_, _karavi_, 
   {{0xa5020148,0x41240071,0x02d802e2,0x8c1500d3}},	//   _空想科學大戰_, _گنجينه_, _ashely_, _राज्यशक्, 
   {{0x8297018f,0xae39027f,0x47a200d1,0x4291006e}},	// [190] _blogalác, _bakarara, _বজালৈ_, _karaw_, 
   {{0x7291001a,0x8e0002e3,0x11fa0160,0x329102e4}},	//   _hazai_, _landtoda, _radnicim, _jaraw_, 
   {{0x92e9015b,0x625b02ab,0x327202e5,0x72ad023e}},	//   _didiman_, _ntuli_, _claronil, _دلمان_, 
   {{0x3c180145,0x031402e6,0x529102e7,0x3625009f}},	//   _dizainer, _henblik_, _laraw_, _radovlji, 
   {{0xc29102e8,0x4290003a,0x23bb0128,0xb6af01aa}},	//   _mazai_, _xabar_, _اسمار_, _enteredw, 
   {{0xf26c02e9,0x227e029c,0x42240238,0xa4060024}},	//   _hemos_, _imene_, _справ_, _প্ৰজন্মৰ_, 
   {{0xd0e700a6,0xe6f60094,0xe2e50153,0x00890119}},	//   _achithel, _بارلعىن_, _うううううううう, _niechano, 
   {{0x12ca02dd,0x531202b9,0xb26d00da,0x00000000}},	//   _cahda_, _robbant_, _divort_, --, 
   {{0x83bf0148,0x344d010f,0xfa62015e,0xf3f80277}},	//   _個股資料首度公開_, _корношоя, _алгылары_, _maiuli_, 
   {{0x0bd602ea,0x18d702eb,0xdc5a002e,0x725b000b}},	//   _permesso_, _витафит_, _šetnji_, _otuli_, 
   {{0xe24102da,0x1d3c00aa,0xb2910282,0x2680000d}},	//   _дестинац, _klondike_, _parai_, _लिपाई_, 
   {{0x76c60084,0x642002ec,0x004d00bb,0x8d9e02ed}},	//   _papanggi, _garanayo_, _الٹرا_, _abondosa, 
   {{0xd29002ee,0x318900ed,0x4ca802ef,0xe3ea0204}},	//   _qabar_, _finaworl, _detektè_, _maito_, 
   {{0xcb8d0163,0x1a1e0013,0x02aa0053,0x22910085}},	//   _وزارتوں_, _битим_, _उद्देशून_, _warai_, 
   {{0x527f02f0,0xe7de00da,0xa29202b3,0xb2870291}},	//   _ejenyi_, _campioni, _españ_, _تعتذر_, 
   {{0x69af0037,0x596502a5,0x592300b9,0x326c02a4}},	//   _በመደወል_, _stupňů_, _सिंहासना, _memor_, 
   {{0xa1d201d8,0x7ae0003e,0x226c028d,0xd25b01a4}},	// [1a0] _solemnly_, _badulase, _lemor_, _etuli_, 
   {{0x498a00c7,0xfdf90211,0x9d3800c7,0x98fb0064}},	//   _sanın_, _преодоле, _кадырова, _malaurad, 
   {{0xb26c02f1,0xc3ea005b,0xf9a700c5,0xba7e00f3}},	//   _temos_, _kaito_, _如对稿件内容有疑, _hlolisis, 
   {{0x9d2c00da,0xc29101fe,0x7ebc0046,0x12cf013b}},	//   _subiecte_, _qarai_, _obesitat_, _sadowne_, 
   {{0x33010061,0xf3f402f2,0x1410012a,0x53ea0176}},	//   _피임효과가_, _listos_, _bogactwo_, _daito_, 
   {{0xed5f0156,0xca220244,0xdca202f3,0x5b790145}},	//   _עמדין_, _строи_, _körning_, _gaminių_, 
   {{0x92900163,0x0291025b,0x2b6e0087,0x00000000}},	//   _abban_, _harav_, _kwetsima_, --, 
   {{0xd292026a,0xf3ea005b,0x7c5d02f4,0xf3eb0102}},	//   _qaravi_, _naito_, _vistazo_, _atetea_, 
   {{0x429101fe,0x16430074,0x1bc101db,0xd26c02f5}},	//   _marau_, _musiikki, _ءﭘﯩﺸﯩﻦ_, _vemos_, 
   {{0x629002f6,0xfbdc02f7,0x348f02f8,0x07e300fc}},	//   _sabay_, _barweets, _hanganak, _didatahv, 
   {{0x69690113,0x77400043,0xb3eb02f9,0x648f0010}},	//   _finnéith, _bakolang, _kretwa_, _kanganak, 
   {{0xa66f01d5,0x627802fa,0xeaf70039,0xf20f00be}},	//   _کوالٹی_, _abunzi_, _далдын_, _كوپلىت_, 
   {{0xa3dc0050,0xdc5a0286,0x436a002b,0x89e901f1}},	//   _atawa_, _abotiri_, _অনুষ্টিত_, _pergatit, 
   {{0x026d0203,0x225b0095,0x826c01f4,0x8d2b0274}},	//   _sinistri_, _ndandosi_, _bemor_, _opinbert_, 
   {{0x73ea02fb,0x26a50091,0x1b7702fc,0x82fd00c5}},	//   _faito_, _oktuktah, _akarenga_, _racines_, 
   {{0x34ef0192,0xc2d802fd,0xa278020f,0x00000000}},	//   _관련사이트_, _didean_, _ebunzi_, --, 
   {{0xe0a30148,0x82e90067,0xb2910145,0x435f02fe}},	// [1b0] _最高出價者_, _bitimaa_, _darau_, _مزاکره_, 
   {{0x3a6a0066,0xe2910191,0x0f2b02ff,0x00000000}},	//   _харамсал, _varav_, _lestonma, --, 
   {{0x96820255,0xa8e9027f,0x3ca10024,0xf387013b}},	//   _भुलाई_, _arashing, _যাত্ৰীবা, _pogram_, 
   {{0xd3f90300,0xcdad0064,0x4ca100d1,0x826c0064}},	//   _nebudu_, _гүлнара_, _যাত্ৰীভা, _remor_, 
   {{0xbc620140,0x32910262,0x52920216,0x1b1a0082}},	//   _lipunan_, _abzal_, _karati_, _gazawars, 
   {{0x67cc0026,0x9c5f0301,0x56e702eb,0xfe5c00ca}},	//   _노튼주니어_, _unutdum_, _файлыг_, _probabla, 
   {{0xd3200273,0xa60701cd,0xea870126,0x926c0080}},	//   _apoyo_, _такдири_, _бахчисар, _demoq_, 
   {{0x2a870302,0xa2910235,0x9bfd0303,0x0395017f}},	//   _amazwibe, _carau_, _lemorago_, _igasak_, 
   {{0x229101b9,0x72e90304,0x3deb0305,0xe07f0145}},	//   _larat_, _didikan_, _bakkebø_, _вопратку_, 
   {{0xc9da0177,0xfa02000e,0x304c020a,0xc2d501c0}},	//   _аспектқә, _sambahsa_, _сарсенов_, _horonsa_, 
   {{0xe3dc0107,0xfc9d0037,0x229002cd,0x2bbf0306}},	//   _utawa_, _peneraju_, _bokaye_, _chérifie, 
   {{0xf2e70307,0x28020128,0xee0f01a3,0x9ecf0308}},	//   _asinawo_, _сноуденд, _وڌيڪَ_, _diintern, 
   {{0x4c170145,0x7df50309,0x5aee00a3,0x8387030a}},	//   _buhalter, _davudoğl, _fosterhe, _medrar_, 
   {{0x9d85030b,0xb4190064,0x82910119,0x57d901f6}},	//   _makerere_, _кескен_, _aarau_, _সাহিত্যত_, 
   {{0x5aee00ca,0xd26c0220,0x6292006e,0x9586029e}},	//   _vandalis, _sportell, _desatu_, _barregez, 
   {{0xf7d6030c,0x867f0060,0x135400e3,0xde46030d}},	//   _pimaklug, _اساتار_, _assedju_, _camaatda, 
   {{0x22dc02db,0xb6b402bf,0x71dc01d1,0x71ee0243}},	// [1c0] _assembli_, _ahlukuny, _assembly_, _tangaluh_, 
   {{0x39ad030e,0x93ea0063,0xb2da0085,0x5a7d02b6}},	//   _تجربو_, _caite_, _sipeni_, _манчетти_, 
   {{0xd29100b6,0xb291030f,0xe3af02f3,0x720100cf}},	//   _garat_, _tarau_, _undantag_, _asrii_, 
   {{0xe292003a,0xe96c01e9,0x22300226,0x828e02ac}},	//   _kurash_, _bodiphat, _amamera_, _وصوله_, 
   {{0xb20e0056,0x52d80310,0xeb180311,0x048c0312}},	//   _тараф_, _ailein_, _ተነጺሎም_, _drugarek, 
   {{0xfdcd0152,0xad3c005e,0x64e90161,0x5a470313}},	//   _солдатла, _ﮬﺎﻟﻪﺗﺘﻪ_, _участках_, _malengpa_, 
   {{0x541d02c2,0xd99d0314,0x46cf00b6,0xb29101a6}},	//   _verstaan_, _намыҫ_, _kalaanam_, _kūkupa_, 
   {{0x5c89013c,0xe4960315,0x0a740039,0xf320018a}},	//   _bildirmə, _angahluk, _менежери, _fynych_, 
   {{0x5291006e,0x83ea0288,0xa2260017,0x32910316}},	//   _waral_, _baite_, _poukaz_, _daram_, 
   {{0xc1bc00da,0xf3f40064,0xda850317,0xc3ea028b}},	//   _дистинже_, _vistes_, _anoniman_, _jaate_, 
   {{0x42b6012f,0x328c01d2,0x5291029b,0x842f02f9}},	//   _frucht_, _cacahuam, _faram_, _maspinen_, 
   {{0xd2910025,0xd00d01e6,0x04d70188,0xdedb0073}},	//   _naram_, _propagač, _шаҳлои_, _scriptos_, 
   {{0x2b670013,0x0bda01aa,0xa4b4000d,0x6ea00224}},	//   _وبرکه_, _ackwardb, _कत्तहु_, _septembe_, 
   {{0x83170045,0xcc1601b1,0xcc2c00bf,0x57030061}},	//   _тренера_, _मुद्रास्, _головокр, _네트워크를_, 
   {{0x074400da,0xa8d1027b,0xcb060203,0x6c7c0258}},	//   _цэранило, _मासषोडशय, _reprocha_, _learaar_, 
   {{0x20f5006b,0x6fd80040,0x6ca7018e,0xa3ea0318}},	//   _अप्रिल_, _מעריצים_, _eliyezer, _haate_, 
   {{0x8b950319,0xb598015e,0xb25b031a,0xe65c00de}},	// [1d0] _অভিজ্ঞতা_, _recordem_, _cealso_, _awayenay, 
   {{0x2f38031b,0xedbf018d,0xfae202fd,0x1a89031c}},	//   _क्रिकेट_, _ንተጋዳላይ_, _cuileinn_, _empiezan_, 
   {{0xa85f0054,0x354a031d,0x00000000,0x00000000}},	//   _mujallar_, _bisheydy, --, --, 
   {{0xbc0b005d,0x1c8e031e,0x1f600198,0x6c820140}},	//   _amasíy_, _podržava_, _napajaln, _kimerald_, 
   {{0xe47b0287,0xe6b9012c,0x392e0063,0x00000000}},	//   _seminář_, _makadiri, _مثلثات_, --, 
   {{0x2c20031f,0xe29100a4,0x96a3004d,0xf2dd018d}},	//   _læringsm, _paral_, _優質服務標準_, _ኣፍቅደለይ_, 
   {{0xb2480320,0xa50200d6,0x93ea0144,0x82910077}},	//   _akomba_, _bunleibh, _raite_, _laraj_, 
   {{0xa3ea0030,0xafa90148,0x22910278,0x52ea02f2}},	//   _saite_, _課程改革及調整前, _faraj_, _prendas_, 
   {{0x91d10268,0x6b1800ce,0xab2d0095,0x826200ec}},	//   _acredsay_, _regardan_, _balbalan_, _aplinkui_, 
   {{0xba4101b7,0x03690168,0x0a830321,0x37f50217}},	//   _सानुबन्ध, _mengder_, _odličen_, _inscibev, 
   {{0x3c200215,0xb53902fa,0x3a7e0322,0x1387020a}},	//   _næringsl, _bagilish, _babahora_, _руханилы, 
   {{0xd37c012a,0xee4002af,0x57280092,0x496d02e4}},	//   _zawarte_, _basamaye_, _と異なっている_, _disinjat, 
   {{0xbc1e018d,0xeb30004a,0x00000000,0x00000000}},	//   _መንግስቲን_, _герое_, --, --, 
   {{0x637c00e1,0x5c7d007b,0xc291018b,0xf2490323}},	//   _cawarte_, _blessin_, _bazat_, _hatma_, 
   {{0x8291006e,0xf529016d,0x3c7c0144,0x4a6c0128}},	//   _yaram_, _байлиқла, _seisean_, _ялтир_, 
   {{0x02910243,0x628500e4,0x9291028d,0x170f0095}},	//   _qaram_, _अभ्यारण्, _larak_, _ممیزی_, 
   {{0xc25a0324,0x900600e6,0x53550325,0x2c60022c}},	// [1e0] _asele_, _中国石油天然气股, _beledir_, _buyutna_, 
   {{0xce450326,0xf3880096,0x8b250064,0x5fa50327}},	//   _achaunga, _abayaya_, _мурасы_, _strekker_, 
   {{0xdb770328,0xc76d0255,0x0e330329,0x827e0045}},	//   _akaranga_, _बन्धा_, _langazma, _smena_, 
   {{0x252a0188,0x5866032a,0xe291011d,0x2bd7032b}},	//   _abanesih, _alcoakku, _baraj_, _ئوپراتور_, 
   {{0x76b602e0,0xbb9e02c9,0x7b1200d1,0x42910256}},	//   _dumelelw, _lichidar, _নব্বৈ_, _kazas_, 
   {{0xb46801bd,0x156902ce,0x32c2003d,0xf2d60265}},	//   _ءبىركۇن_, _ngawengk, _avalida_, _verlost_, 
   {{0xf291007e,0xa2910120,0xa631011d,0x048b0143}},	//   _param_, _marak_, _petrolul_, _стилна_, 
   {{0xc6610052,0x229102a7,0xe25b015c,0x2a6c00af}},	//   _परास्त_, _earak_, _stull_, _живопису_, 
   {{0xcea400a4,0x29ca0035,0x1567010f,0x73c700be}},	//   _novetats_, _sıltama_, _тиллои_, _алдыбызд, 
   {{0x9b6e02ea,0xf31b0025,0x0f5c032c,0xbc800185}},	//   _cartella_, _apsarā_, _allaninn, _телең_, 
   {{0x100301b6,0x57400222,0x02910262,0x2c600294}},	//   _הנמען_, _accompag, _hazar_, _achuwan_, 
   {{0x52cb01c2,0x9d8f000e,0x00000000,0x00000000}},	//   _acadou_, _risotera, --, --, 
   {{0xe237032d,0xb18f032e,0x1fdc032f,0x1b6d02d5}},	//   _arajwe_, _manqanak_, _cachorro, _तहिना_, 
   {{0xc2910005,0xf2800139,0x64cf004d,0xaaf40147}},	//   _cazas_, _anindā_, _依照消費者保護法, _dissabte, 
   {{0xb3dc00a9,0xa3690247,0x129101f4,0x73100100}},	//   _ntawe_, _tengger_, _darak_, _kaznenog_, 
   {{0x52790330,0x6d86003e,0x48600258,0x08d90331}},	//   _hamanirm, _basentse_, _schotanu, _tilgongd, 
   {{0xcdf9008d,0xd2910332,0xc8550247,0xec650333}},	// [1f0] _термаси_, _tazas_, _مگاوات_, _bartulu_, 
   {{0x13ea0165,0xa36f02f3,0x98d90094,0x2dcd0130}},	//   _naita_, _fingret_, _ғайбатта, _euskarat_, 
   {{0x6aa7015e,0xd2d70094,0x038f0334,0x227e02e4}},	//   _манасты_, _باقتتى_, _banyana_, _emmnu_, 
   {{0x03a90037,0x54120095,0x21440307,0x6e1a0092}},	//   _ተግባራቸውን_, _mbenakak, _babenjal, _少年マガジンコミ, 
   {{0x9e720335,0x9f4f012d,0x00000000,0x00000000}},	//   _आगत्य_, _konggres_, --, --, 
   {{0xc2b20200,0x96680223,0x8d3a0030,0x19ec0336}},	//   _iwedata_, _альбумин, _filiāles_, _ingebjør, 
   {{0x5b850021,0x37f10092,0xf01701de,0x00000000}},	//   _abbinggr, _この商品のカスタ, _лаңкес_, --, 
   {{0xb2e80337,0x327e00e9,0xf3ea0074,0x9e3c0338}},	//   _içinde_, _amenn_, _laita_, _tableros_, 
   {{0x329001fc,0x82000339,0x82ea02c8,0xa098003c}},	//   _abbah_, _ihiihi_, _quendas_, _پنسیلوان, 
   {{0x1c600057,0xc29102df,0x78d50053,0x439400e3}},	//   _mahukan_, _barah_, _मानसोपचा, _bojsi_, 
   {{0xe96b0166,0xf1c50073,0xb9cb00e2,0xbae902d8}},	//   _meinunge, _formicam, _fellinga_, _तत्वावर_, 
   {{0xe5fc0254,0xf628033a,0x615001c8,0xf2e00086}},	//   _selecció, _rikonoxx, _hydroizo, _elindul_, 
   {{0x43ea002c,0xdd74019e,0xebfd033b,0x9c80018b}},	//   _baita_, _пустым_, _lemogago_, _мереу_, 
   {{0x5f25033c,0xf8e8018d,0x4c43033d,0x6744021c}},	//   _offerynn, _ጸምቢሎማ_, _béthie_, _oranžový, 
   {{0xd51000c5,0x6a5c033e,0xe37a0067,0x2a000163}},	//   _出口许可证管理分, _araóna_, _baqatan_, _javasolt, 
   {{0x22c3014e,0xf2d80151,0xc2910175,0xf6a50162}},	//   _користи_, _afield_, _tazar_, _туралғу_, 
   {{0x83ea033f,0x42910057,0xc2fc005b,0x83ce0325}},	// [200] _faita_, _zarah_, _agmgwa_, _anivle_, 
   {{0x32910340,0x1254010d,0xc389005b,0xb78900c7}},	//   _harai_, _श्रेयस_, _amoyamo_, _даирәсен, 
   {{0x6291011f,0xaa550059,0x00000000,0x00000000}},	//   _karai_, _federica_, --, --, 
   {{0x12910341,0xcc93016d,0x00000000,0x00000000}},	//   _yazar_, _تامام_, --, --, 
   {{0x73f40342,0x4f520343,0xc2c400bc,0x5c000204}},	//   _jistis_, _amapalit_, _nyambut_, _hauskat_, 
   {{0xbe950276,0xa2f7010d,0xbcb9015e,0x3194004d}},	//   _кубаниң_, _arsitek_, _abraçada_, _不講比較對象車種, 
   {{0x93f80318,0x2163023d,0x029000ce,0x66520344}},	//   _akauu_, _istruzio, _labaz_, _ajukkugi, 
   {{0x8af401f9,0x97540345,0x00000000,0x00000000}},	//   _bahlukun_, _genética_, --, --, 
   {{0x947b0273,0x32fe0185,0x97e301cd,0x00000000}},	//   _campeón_, _bibinur_, _ботинии_, --, 
   {{0x50c30207,0x7d8b019f,0x83f10179,0xb64a018d}},	//   _مدرسا_, _halmasha, _genealog_, _ኣፍረይቲ_, 
   {{0x73f40346,0x595b01e4,0x63400347,0x04b20348}},	//   _zistis_, _जीवनभर_, _sakeman_, _bakatikk, 
   {{0xecb10029,0x43810014,0x4b8f0349,0x5562034a}},	//   _زمانێک_, _arrijnë_, _ansistor, _antolóxi, 
   {{0xf27e004f,0xfacb0012,0xdb1a01c0,0x00000000}},	//   _coonab_, _पादरीया_, _dabarars, --, 
   {{0x3f890205,0x43950220,0x3b68007b,0x5cf900ba}},	//   _берамиз_, _borse_, _affectin_, _مێزۆپۆتا, 
   {{0x4295019a,0x91f5022f,0xe06200e4,0xc3ea019d}},	//   _polanski_, _суровая_, _zrealizo, _izitu_, 
   {{0xd2e3034b,0xa2a60080,0x3add00d0,0x04b5034c}},	//   _filipae_, _alibak_, _martitze, _илбашы_, 
   {{0xd166010c,0xf75c034d,0x52910140,0xfdb90039}},	// [210] _प्रतिबंध_, _kehilang, _sarap_, _кардашья, 
   {{0x1983004a,0x5d3a034e,0x8dee034f,0xbd8e0350}},	//   _элеккеге_, _casarasq, _candelwa, _ማስተጋባት_, 
   {{0x29e6016e,0x32910135,0x34b502b6,0xe23600d3}},	//   _durumund, _qarap_, _алдады_, _prijde_, 
   {{0x5f2d02f6,0x1c750109,0x900601cc,0x627700e7}},	//   _kahuluga, _दोब्बर_, _bhasmarā, _argaretm, 
   {{0xbadb00c1,0x8dbd027b,0x7ab70351,0xec1d0064}},	//   _मॅकरिची_, _पीड्यमान, _авракăш_, _arquebis, 
   {{0x62910262,0x885801bb,0xd1f00126,0x0afa019b}},	//   _tarap_, _alyarlar_, _обіцяє_, _siandien_, 
   {{0xc99500e6,0x9ec60237,0xd15600d6,0x5b55020f}},	//   _农用地转用和土地, _verzocht_, _سارونه_, _ekumodar, 
   {{0xa29002f6,0xcc200352,0x16a000dd,0xf6970347}},	//   _gabay_, _næringsu, _chrefftw, _sekondêr, 
   {{0xd2b7019b,0x42d90013,0xc34b0035,0x00000000}},	//   _другім_, _bahodir_, _икәнсез_, --, 
   {{0x374a0353,0xf4230354,0xa4340212,0xe25b0355}},	//   _upozorni, _گرامماتى, _diapason_, _krule_, 
   {{0xdbda0046,0x529000c7,0x23200203,0x52b901b0}},	//   _базарынд, _babay_, _marchat_, _beledug_, 
   {{0xa25b030b,0x420002be,0x23ea0255,0xe2b50256}},	//   _kuulo_, _ganito_, _saata_, _piecus_, 
   {{0x5f96031f,0xdb6e0204,0xd2bc01dd,0x64d40109}},	//   _studerer_, _kartalla_, _akadomo_, _जनजिवन_, 
   {{0x59e30356,0x82260274,0x23950014,0xfa4001ee}},	//   _fotonaka_, _merkta_, _porse_, _официала, 
   {{0xa27e019d,0x32b40176,0x32fe026c,0x540b0096}},	//   _amene_, _cocco_, _viribus_, _bahimbaz, 
   {{0x6d8c02dd,0xa3b80100,0x22fc0067,0x2625005e}},	//   _རྒྱོབ_, _pohvalu_, _aliinis_, _ﺳﻪﻟﻠﻪﻟﻼﻫ, 
   {{0x83f00340,0x6e1a0048,0x32ea0032,0xe7b40265}},	// [220] _taurangi_, _abafirip, _dadisqo_, _tekening, 
   {{0xebf7034a,0x2e950040,0x4d8400ff,0x8e950040}},	//   _desemboc, _מוסרי_, _אנטדעקט_, _מוקרן_, 
   {{0xa26e0255,0xa2ca020b,0x00000000,0x00000000}},	//   _parool_, _molekodi_, --, --, 
   {{0x3c840094,0x125b02ec,0x125a0044,0x71570012}},	//   _بىرىنشىس, _buulo_, _fuels_, _नहेलाक_, 
   {{0x42c20196,0x4169033c,0x8e380357,0x236b013f}},	//   _ndalama_, _pennaeth_, _lawakita, _arigrap_, 
   {{0xc23600e5,0x4e3d0128,0x160d0155,0x7d05030d}},	//   _beijos_, _долларга, _pålitlig, _casuslar, 
   {{0x877f0192,0xc1630040,0xb40d019c,0x9aeb017e}},	//   _서울대학교_, _humidity_, _iporogan_, _asertant, 
   {{0x9c5a023d,0x037c0358,0xd7250156,0x41ca00d1}},	//   _ipotesi_, _antanke_, _חוֹדש_, _পাছফালে_, 
   {{0x32da0264,0x13dc00f9,0xb2df0013,0xfb4a010c}},	//   _matera_, _ariwe_, _kamolot_, _दृष्टिही, 
   {{0x751002b7,0xbf2d001c,0x22da02a4,0x02360359}},	//   _sarrango_, _kahubuga, _latera_, _krijst_, 
   {{0xc3b60348,0x8b9d0021,0xceb10059,0x5b00011b}},	//   _abavuma_, _actisepr, _spostare_, _mozindó_, 
   {{0xd2da005c,0x51f20176,0xc68f000f,0x83050276}},	//   _gatera_, _pranayam, _inceledi, _ئوسال_, 
   {{0xc2400163,0x1aee00fa,0x096e00e3,0x8465011f}},	//   _menedzsm, _bandalis, _gabillot, _jetepyso_, 
   {{0xb51002b7,0x38c00287,0xdad8002e,0x05b00017}},	//   _warrango_, _मालपोत_, _pošalje_, _pákistán, 
   {{0x061002ee,0x8510035a,0x12da035b,0x7c20035c}},	//   _tajlandi, _tarrango_, _katera_, _læringsr, 
   {{0x9d8501d9,0x2ff0032d,0x00000000,0x00000000}},	//   _jidderee_, _беткә_, --, --, 
   {{0x22e202e7,0x0e420253,0x3d9a020f,0xf2ca0022}},	// [230] _kalidad_, _qulaanut_, _akanakwa, _bolekodi_, 
   {{0xa413023b,0x9c0e033c,0x8d3d00af,0xf21c035d}},	//   _kaunakak, _digonedd_, _itromsø_, _neshto_, 
   {{0x0897034f,0x1e9e01d5,0xcd810258,0xd27e00e1}},	//   _خرابه_, _کےچھٹے_, _taaldata, _coonob_, 
   {{0xfb02015c,0x7a7f00ce,0x579e035e,0x0db90268}},	//   _samschde, _linondas, _stidljiv, _attingba, 
   {{0x9f3d035f,0xd2d501d7,0xaa7102cb,0xde5f019d}},	//   _क्षितिज_, _deponia_, _obična_, _apabanja, 
   {{0xd20800ff,0xa2cb016a,0xb0680161,0xd8aa020f}},	//   _דעסקטאפ_, _svedio_, _журнальн, _پوهېدلو_, 
   {{0x82da00ee,0x2c83003e,0x865c00e6,0x73160360}},	//   _batera_, _dietsang_, _转让标的企业涉及, _jenze_, 
   {{0x0987024c,0x325b02ec,0xc5650361,0x7dc301a6}},	//   _adekwata_, _tuulo_, _алалай_, _pupirika, 
   {{0x0a760039,0x729200d2,0x2b19028d,0x4ef70155}},	//   _африкийн_, _narasi_, _lafaminn_, _musklern, 
   {{0xa2e2026b,0x505a0053,0xb9980137,0xba9c02c2}},	//   _calidad_, _citilink_, _үхэртэй_, _keniaans, 
   {{0x3c090362,0x4ba701af,0xf6d90322,0xb316014c}},	//   _bampaya_, _alahöwre, _bahanirw, _nenze_, 
   {{0xfae802bb,0xb292004f,0x82c2019d,0xcb8b01db}},	//   _अनुवादक_, _aarati_, _adalota_, _امانشىلى, 
   {{0xc2920303,0xc39400e4,0xd378010e,0x00000000}},	//   _barati_, _widzisz_, _hamakin_, --, 
   {{0xd29201cc,0xac200363,0x0977011d,0x65d90309}},	//   _carati_, _næringss, _avantaje, _bombalay, 
   {{0x44e50039,0xea8800a4,0xfeb00364,0x581d021b}},	//   _туркийн_, _توولۇق_, _entsteet_, _накладка_, 
   {{0x10f4010d,0xf292028a,0x1eb4003e,0x4c0400d9}},	//   _आक्रमक_, _farasi_, _апалы_, _уточняйт, 
   {{0x3e5502b9,0xc25a00a8,0x328f0261,0x02920031}},	// [240] _دوستی_, _quels_, _diskuto_, _garasi_, 
   {{0x3ea6023d,0x22f00288,0x474a02bb,0x8c6f0090}},	//   _направо_, _korinth_, _क्रमबद्ध_, _akurova_, 
   {{0xcc5200da,0x72e302e5,0x00000000,0x00000000}},	//   _десчифря, _indiape_, --, --, 
   {{0x9ea6008a,0xe6650365,0x9d9d01a3,0xeda10366}},	//   _fatupese_, _लोकदोहोर, _پهچڻو_, _атăлалла_, 
   {{0xe9c90119,0x568d0037,0xad9d00e6,0x6c75008e}},	//   _bilogora_, _ተናገረዋል_, _李白诗论丛_, _emisong_, 
   {{0xe39a01bd,0x43950033,0x32010367,0x1545004a}},	//   _шілде_, _forsa_, _aceita_, _avtornıñ_, 
   {{0x93d30206,0x82e101ad,0x8c350061,0x56d80219}},	//   _podobnú_, _balibag_, _게임가중계_, _ibhalisw, 
   {{0xa2e9005b,0x48fa034e,0xce8a010d,0xc4ad0368}},	//   _bientot_, _camataqu, _पहाताना_, _заробили_, 
   {{0xc2da01e9,0xc6cb00aa,0x59ef01d7,0xc16d002b}},	//   _bapedi_, _biopsych, _posteriu, _আ্যপলের_, 
   {{0x83f9005b,0xc29701ff,0xcc4b00d1,0xd6bb00ae}},	//   _mayumi_, _velkost_, _আধাৰশিলা_, _insamiri, 
   {{0x9af70033,0xc4250369,0x830d02a4,0xc6b5006c}},	//   _annualme, _bipikeik, _apparet_, _abasembh, 
   {{0xb292036a,0x9b2c02ac,0xfe3b0183,0xa291030d}},	//   _barasi_, _ماتريدين_, _ampandra, _abzas_, 
   {{0xec6b0357,0xd36f01e6,0x67d80058,0x576c0139}},	//   _isausau_, _investuj, _subsataf, _भारतदेशे_, 
   {{0xf2170162,0x2e8b0060,0xe6230038,0xeaf10066}},	//   _орунда_, _اساتۋ_, _alkogoli, _jorratze, 
   {{0xbd8c02e1,0xf197036b,0x00000000,0x00000000}},	//   _اشتهر_, _напорен_, --, --, 
   {{0x427e036c,0xc2910051,0xc2b502ca,0xd6d802bf}},	//   _omena_, _varat_, _bosca_, _abhalisw, 
   {{0xb291017e,0xebcb0234,0x5145036d,0x5ddf001b}},	// [250] _faras_, _olóòótó, _pherceto, _hiikudha, 
   {{0xda82006d,0x2ed4036e,0x54970253,0x00000000}},	//   _элементу_, _allinnin, _attartuk, --, 
   {{0xbb880148,0x32920298,0xbaa4002f,0xd1a1015e}},	//   _resister, _karari_, _achillis, _دەرىنە_, 
   {{0x86a90064,0xe1e801f1,0x477201a3,0xcb21034e}},	//   _الاقاندى, _informim, _سنڌالاجي_, _carabamb, 
   {{0x95510192,0xd47b02c8,0xab7e014d,0xe285018c}},	//   _자동로그인_, _campión_, _identisc, _michiel_, 
   {{0x97a8036f,0x0c0201cf,0x00000000,0x00000000}},	//   _nastavni, _chassar_, --, --, 
   {{0xf4400010,0x296b0119,0xe9d8033e,0x5a08006a}},	//   _alikabik, _meininge, _apenóva_, _hijanona_, 
   {{0xc27f0370,0x6f650080,0x8b7600a0,0x00000000}},	//   _acanna_, _assammin, _faffadan_, --, 
   {{0x43ea015a,0xe5cc0054,0x07c7006c,0xb7de007b}},	//   _baate_, _dabaibay, _бақияи_, _scapegai, 
   {{0x09d60203,0xd3700179,0x2292008d,0xb2130062}},	//   _scheffle, _monadef_, _zarari_, _pivha_, 
   {{0xc291015a,0x2ce90371,0x00000000,0x00000000}},	//   _harar_, _поканата_, --, --, 
   {{0xa95d00c6,0xfb300126,0x22e000dd,0xc1ad026f}},	//   _sannhete, _немов_, _dunnell_, _قستىرۋ_, 
   {{0xc3eb0172,0x194b0372,0x12df0153,0x217e02ba}},	//   _asetra_, _etholaet, _件の検索結果を表, _гарбу_, 
   {{0x129100b0,0x825b02ad,0xde4c02ef,0x4c7a0373}},	//   _marar_, _protiskl, _depannde_, _versioj_, 
   {{0x2cd301f6,0x227e024f,0x15b502ea,0x5b1b011c}},	//   _লেখকৰ_, _emeni_, _composiz, _desaloon_, 
   {{0xa2910054,0x525a005b,0x303100db,0xc3ea0374}},	//   _farar_, _villy_, _मुरही_, _исканжас, 
   {{0x2a360169,0x286602b9,0xbc5e007e,0x598b020a}},	// [260] _ক্লিকে_, _نکلوا_, _bhettum_, _еселенге, 
   {{0x795e00da,0xa1940185,0xdc64000d,0x3b8901a3}},	//   _cheltuie, _agrariyl, _kipuvad_, _ليکجڻ_, 
   {{0x6057010b,0x9ff700f3,0xdf2e0040,0xf2b6001d}},	//   _akhaonto, _abayifun, _מורפולוג, _descri_, 
   {{0x94ae017d,0x83ea0375,0x63f00376,0x00000000}},	//   _ショップで確認_, _aziti_, _hamrandi_, --, 
   {{0x7e3d0024,0x6e4b018d,0xe9e101cf,0x7261025f}},	//   _সাতটা_, _ከተኣታቱ_, _oblidava_, _maponami_, 
   {{0xc26c0176,0xd2ea0377,0x36d1010d,0xc0d70161}},	//   _sanoku_, _aruncat_, _लवचिक_, _мировом_, 
   {{0x920200d7,0xea5d0160,0x00000000,0x00000000}},	//   _corido_, _potezima_, --, --, 
   {{0x63ea0255,0x552202e0,0x72650229,0x00000000}},	//   _saate_, _karogany, _butulkal, --, 
   {{0x3f070013,0xd9e400ad,0xc4230110,0xdfd5034a}},	//   _دانیشیر_, _lolobana_, _aizkrauk, _lanzamen, 
   {{0xc9e50071,0xa48a0092,0x68c20378,0xa56e006d}},	//   _disutrad, _クライスラ_, _apoteksv, _азэрбайд, 
   {{0x44f70163,0xba690379,0xe14600a7,0xa2b600cb}},	//   _نورالدین_, _शिवशंकर_, _инсандар_, _abadume_, 
   {{0x92c300ef,0xa2a7002c,0x00000000,0x00000000}},	//   _asoloko_, _alabek_, --, --, 
   {{0x529102df,0xc47b0192,0x4c260099,0xe5b90087}},	//   _paras_, _제휴사이트_, _ashandur, _makalich, 
   {{0x857e011e,0x990600d6,0xfcf201d5,0x32ca006e}},	//   _viktimiz, _أفغانستا, _عالمِ_, _amalati_, 
   {{0xc7730220,0xcab702a5,0x57dd0160,0xe2e900d6}},	//   _направих_, _neobyčej, _opravdav, _لاندكروز, 
   {{0x0c61037a,0x1477006d,0x8291001e,0x1f3500d1}},	//   _intumwa_, _пакетах_, _tarar_, _অমিয়া_, 
   {{0xa9cf013b,0xf0710193,0xa29201f1,0xe61d0374}},	// [270] _nordfrie, _berjuluk_, _saraqi_, _atalishi, 
   {{0xb29000cf,0x7a06011b,0xf9dd037b,0xd29102fd}},	//   _sanaan_, _ethambut, _aprendie, _mbran_, 
   {{0xf4f40039,0x136600c1,0x33660116,0x43900272}},	//   _имейлээр_, _tangsel_, _gangrel_, _banyani_, 
   {{0x569c01a7,0xa26d033f,0x81aa0008,0xd291016e}},	//   _достаточ, _aeuoa_, _fundació_, _yarar_, 
   {{0x11f200f5,0xae9e0013,0x4ee901f5,0x3c0a0233}},	//   _клетканы_, _калла_, _perhitun, _regretab, 
   {{0x9d0a02e4,0x247d0162,0x92010334,0xd29202a7}},	//   _segretar, _رايوننىڭ_, _akaidi_, _garapi_, 
   {{0x2346037c,0xb2910068,0xc29000cf,0x5518037d}},	//   _finders_, _warar_, _tanaan_, _suprotno_, 
   {{0xc2b4004f,0xf395022e,0xb291037e,0xd5e9037f}},	//   _bocci_, _morse_, _iarap_, _yeraltı_, 
   {{0xa2910140,0xc79b0380,0xad1d01f1,0xaaa100ef}},	//   _harap_, _lwglungz_, _raportit_, _انتظاميې_, 
   {{0x725b010a,0xd2910135,0x434600bd,0x18b80109}},	//   _fuula_, _karap_, _hinders_, _ostrovů_, 
   {{0x73460347,0x428502b7,0x67350177,0xfa2400b0}},	//   _kinders_, _bithiro_, _алалара_, _dhabarka_, 
   {{0xbb51006f,0x4f1a0311,0x72240381,0xd20100c4}},	//   _اَندر_, _ጽሕፍትኻ_, _eenkay_, _ukaidi_, 
   {{0x22e60044,0x52910135,0x7a0f0295,0x2b510382}},	//   _משפחתו_, _qarar_, _angalele, _atithopa_, 
   {{0xb27c011b,0x47e302dd,0xd4080383,0xb25b0253}},	//   _afandaki_, _drappiji, _dirobohk, _buuli_, 
   {{0x325b0012,0x65cf018d,0xa274015e,0x5b830053}},	//   _juuli_, _ማይክሮፎን_, _اۋدەۋ_, _bernegar, 
   {{0x436e0384,0x72900230,0x2fa601d2,0x91a40385}},	//   _njegovu_, _banann_, _anularqo, _vuković_, 
   {{0x274f035a,0x4f7502d3,0x934702d4,0xccc80092}},	// [280] _muzzammi, _nascimen, _genevra_, _記事をリスト形式, 
   {{0x8170004b,0x53660122,0x00000000,0x00000000}},	//   _экрандар_, _anggoro_, --, --, 
   {{0xb7a10253,0x369c0386,0x039500bd,0xe27e0387}},	//   _januaari, _menghasi, _norse_, _emenu_, 
   {{0x63ea0133,0xc3f0030f,0x029200ac,0x1a5c00ec}},	//   _haata_, _haurangi_, _izradi_, _kolegija_, 
   {{0x075d00fd,0x0a0f003b,0x77d901ff,0x152100b2}},	//   _chriomag, _ingamele, _titulná_, _haromaay, 
   {{0xd39500b6,0xf2ca00dc,0x2db600af,0x315c0361}},	//   _korse_, _apoliki_, _tilskudd_, _вузах_, 
   {{0x63bf0388,0xa9e1025f,0x79320208,0x73f800c5}},	//   _servizi_, _balobaka_, _جۆریک_, _annuel_, 
   {{0x22f50274,0x18e70299,0xa3ea004f,0x00000000}},	//   _skrifum_, _ئۇۋۇلاپ_, _laata_, --, 
   {{0xd29100ad,0x6d7c0060,0x65b90322,0x2473019d}},	//   _raray_, _تەربەيتى, _bakabiry, _kumenyak, 
   {{0x4b9c023c,0x6c39010d,0xf29102a4,0x53ea0389}},	//   _ميانمر_, _विषयाला_, _vocant_, _gaata_, 
   {{0xb291038a,0x92e6004d,0x22ca00e0,0x00000000}},	//   _paray_, _您即將永久刪除此, _opslach_, --, 
   {{0xbd3102ac,0x1f560083,0xdc1c038b,0xf2bb038c}},	//   _اووووووو, _aunghels_, _mimpiku_, _neobjašn, 
   {{0x88ac01a7,0x2da902f3,0x7c580059,0xdb68004d}},	//   _поставщи, _redigera, _останало_, _登上城巴機場快線_, 
   {{0x429000d2,0x4ddb02e2,0x22910119,0x5e3101cf}},	//   _nanaon_, _backache_, _waray_, _cellulas_, 
   {{0xc61a006a,0xd64a01f4,0x324801a7,0x5919013c}},	//   _manodidi, _yashaydi, _teemme_, _xoşagəlm, 
   {{0x9ef102bb,0xc3780318,0x81b7002b,0x89f70278}},	//   _शिक्षावि, _avaavaa_, _চলছেই_, _ainunlmu, 
   {{0xe366038d,0x9dc3038e,0x6c5b0073,0xbb7702c5}},	// [290] _lantrenm, _disiapka, _immunde_, _akaronga_, 
   {{0x627e015c,0x72ca022a,0xd25b00d9,0x5e3e0210}},	//   _kleng_, _geiloti_, _tuuli_, _anyatsop, 
   {{0xc2a6033c,0xf3ea038f,0x12a50034,0x593900ba}},	//   _talbot_, _mentel_, _höktir_, _اڵاکی_, 
   {{0x5d4b014b,0x22c1005f,0x1e0c01eb,0x7b4300f8}},	//   _ganaasaq, _follada_, _nahembip, _ডুবোজাহা, 
   {{0x550b012e,0xeaf10333,0x616902bd,0xa09c0187}},	//   _شکارپور_, _spezzata_, _bennaeth_, _планирам_, 
   {{0xa27e01e9,0x78030390,0x00000000,0x00000000}},	//   _oleng_, _basmış_, --, --, 
   {{0x617b00d1,0x8c750022,0x3ffc00af,0x00000000}},	//   _আৱিস্কৃত_, _emisang_, _спасибі_, --, 
   {{0x427e0391,0xd30e0222,0x8d6201c1,0x636801da}},	//   _ileng_, _espaces_, _लढाईत_, _mengjes_, 
   {{0xff5c0344,0x427f00bc,0xc17501aa,0x8cdc0134}},	//   _allaminn, _amung_, _amingnay_, _laipẹ_, 
   {{0xcc4101ab,0xb2840183,0xd39e0144,0xbae30392}},	//   _चहुँप_, _arahiko_, _مسؤلية_, _gualainn_, 
   {{0xb29100b0,0xaa1602cb,0x3c3b0393,0x00000000}},	//   _qarax_, _ostavlja_, _ljubimac, --, 
   {{0xc850008a,0x95540394,0x6d0102c5,0x00000000}},	//   _hydroids_, _akukhuth, _bhatafur, --, 
   {{0x694600de,0x8d880395,0x7c6d0396,0xc25a01da}},	//   _عبدالولی_, _celebrit_, _bikrija_, _stilin_, 
   {{0xae160188,0x3fe30008,0xb5cc0397,0xd8d302aa}},	//   _биёрад_, _زاتتى_, _кофтуков, _superhrd, 
   {{0x4c710398,0xa3f40215,0xedac02f3,0x0c7e0047}},	//   _apartat_, _hytter_, _språklig, _coussin_, 
   {{0xb344005d,0x438001ec,0xf6700021,0xf50f01bb}},	//   _bowerpe_, _petruk_, _algherow, _almagül_, 
   {{0x7e5d00da,0xb85f0203,0x00000000,0x00000000}},	// [2a0] _маракуца_, _inmanuar_, --, --, 
   {{0x186e0034,0x99e402c1,0x53790399,0xe883039a}},	//   _inniheld, _atangira_, _mamamio_, _meringku, 
   {{0x430000b6,0xc01a02c6,0x815c039b,0x02b5020f}},	//   _dananow_, _geodediz_, _дирижёрĕ_, _لږېدله_, 
   {{0xf291008d,0xe2ac00d0,0x92ea023e,0xe2a60089}},	//   _ibrat_, _багавтар_, _cerigen_, _gomboc_, 
   {{0x5a08000b,0x125a011d,0x89e30220,0xbad20333}},	//   _augatuaa_, _scolar_, _indicata_, _sottinte, 
   {{0x230e0039,0xb25b0120,0x027b01c8,0xf4f80060}},	//   _arabera_, _fuulu_, _videozáz, _شارالارى, 
   {{0xf5ae00e3,0xe56201c2,0x62eb039c,0x00000000}},	//   _freskezz, _mitolóxi, _asentar_, --, 
   {{0xf387023e,0xb3ea039d,0x56d90210,0x52e40037}},	//   _amargi_, _nyito_, _achatirw, _የዲፕሎማቲክ_, 
   {{0x4b0c039e,0xd3dc033c,0x2dee012e,0x49d0039f}},	//   _personle, _brawd_, _امرود_, _unaffect, 
   {{0xc25a03a0,0x238701f1,0x22750164,0xddfc012a}},	//   _tsela_, _ndersa_, _гуруһлар, _generowa, 
   {{0x4f0f0178,0x39c80092,0x33ea02dd,0x12d9038e}},	//   _amitrava, _primedia_, _ezatt_, _puyeng_, 
   {{0xa2da00ce,0xe3eb030d,0x03dc01fe,0x25370092}},	//   _lapolis_, _sayta_, _drawe_, _岡山県岡山市浜_, 
   {{0x32da001d,0x1b180049,0xfec40311,0xe6210291}},	//   _antean_, _langifis, _ደቂተባዕትዮ_, _أوتوماتي, 
   {{0x917d0036,0x4eb0007f,0x241b004d,0x72d800e2}},	//   _متخصصون_, _colomenn, _第五週課後討論主, _stjert_, 
   {{0x4163007b,0x12f2005a,0x450703a1,0x3c7a00c5}},	//   _humility_, _bidilqu_, _средата_, _没有相关信息_, 
   {{0x8356026c,0xa9d300c4,0xde0300a4,0xcd5703a2}},	//   _ceteris_, _سئيڊن_, _мынчалык_, _मौदगिल_, 
   {{0xaa0a014b,0x728f019a,0x00000000,0x00000000}},	// [2b0] _korsoonu, _dothers_, --, --, 
   {{0x725b0202,0x3caf0060,0x4dbd007b,0xeb1301de}},	//   _buulu_, _دەستى_, _inshuira, _синонимі_, 
   {{0x037a00a1,0xbcbe022f,0x5d2c0121,0xb96d004a}},	//   _aperaham, _далей_, _reciente_, _зарипова_, 
   {{0xc0300040,0x36cf016b,0x1a860308,0x0e30011a}},	//   _המהדורה_, _alkawali, _luangkan_, _המאשימה_, 
   {{0x72920212,0xec0103a3,0x3bb103a4,0xda03016e}},	//   _amsale_, _acessar_, _fiskavir, _piyasada_, 
   {{0xc3eb0374,0xe2bd03a5,0xea7f03a6,0x59a40087}},	//   _qayta_, _पुरुश_, _barakora_, _chukucha_, 
   {{0xc1eb0251,0xfb01038a,0x837e03a7,0x34fc009b}},	//   _وفادارن_, _abusupit, _gajdoš_, _обамагий, 
   {{0x529202df,0xf80a02d3,0xf53300ff,0x60f60071}},	//   _korang_, _струга_, _רעפבאַקק, _بادوام_, 
   {{0xe70802d3,0x739501f1,0xcc360373,0xb3560231}},	//   _expressã, _borsh_, _prenzlau_, _veteris_, 
   {{0x36340169,0x82ee013a,0x332203a8,0x420d03a9}},	//   _অত্যাচার_, _deift_, _তথ্যভঁৰা, _заманахь_, 
   {{0x4d850238,0x65fb018d,0x820e0064,0xfd9a0240}},	//   _diskutér_, _ምርብራብ_, _манаш_, _savusavu_, 
   {{0x82eb0024,0x00000000,0x00000000,0x00000000}},	//   _trendar_, --, --, --, 
   {{0x46e80092,0x3bf5012e,0x5dd50099,0xa1130061}},	//   _アカウント_, _kistérsé, _aibhabha, _찾아주셔서_, 
   {{0x6b7d00a8,0x628c0261,0x2d130145,0x00000000}},	//   _beinsper, _asekura_, _бытча_, --, 
   {{0x6c0501c3,0xdc5e00d7,0x13b60385,0x3c790177}},	//   _chorley_, _bottril_, _spavala_, _панкисит, 
   {{0xd34300e4,0xed3403aa,0x32df00e4,0x76450019}},	//   _तटबंध_, _रामराज्य_, _samolot_, _جىلنااما, 
   {{0xfc7301cd,0x62d90010,0xe39503ab,0x43060052}},	// [2c0] _alisona_, _kubete_, _horsi_, _okresů_, 
   {{0xde4d0318,0x139500ad,0xa8740039,0x9f4102b9}},	//   _akapuluu_, _korsi_, _baliokid, _کھلتی_, 
   {{0xffc60113,0x0be303ac,0x225a017e,0x4ffe0213}},	//   _shanntar_, _dilempar, _stilon_, _набегами_, 
   {{0xe11a02a9,0x3cb803ad,0x00000000,0x00000000}},	//   _торбу_, _imbaghad_, --, --, 
   {{0xb58d0093,0x1723005e,0x163f007b,0xdcef03ae}},	//   _постройк, _خۇيزۇ_, _blainsli, _doktorgr, 
   {{0xe8ff00e7,0x1fc6000e,0xb183014e,0x276701f2}},	//   _adapting, _changear_, _елите_, _әрикәт_, 
   {{0xb41c01bb,0x83870039,0x8f5600e6,0x80f70118}},	//   _турме_, _ederra_, _税收减免管理办法_, _babituul, 
   {{0xcb2503af,0x7ee50178,0x67a7004d,0xcc7200e6}},	//   _montréal_, _बुक्क्या, _中壢市仁美郵政_, _生态创意家饰逼你, 
   {{0x3e92020a,0x129d01b7,0x47b602a3,0x369003b0}},	//   _порталы_, _hetoḥ_, _besering, _enkeltbi, 
   {{0x980603b1,0xa3c803b2,0x2ddd02d8,0x93eb00ee}},	//   _décembre_, _server_, _puskesma, _aretoa_, 
   {{0x625a03b3,0x7b4a0244,0x7292007b,0xad4b032c}},	//   _gilly_, _зареждан, _bewail_, _allangaq, 
   {{0xae3d03b4,0xab680282,0x72910107,0x6c530053}},	//   _achangop, _anatioka_, _ancase_, _मॅरेज_, 
   {{0xa30c015c,0x9a8603b5,0xfb2500d9,0xcacb03b6}},	//   _gerannt_, _tuangkan_, _пушкина_, _lẹsẹkẹsẹ_, 
   {{0x42a700fa,0xafd501be,0xd6c40311,0x92c600de}},	//   _alabok_, _pronajmo, _ከፍልጠካ_, _ebulele_, 
   {{0x0c7d038d,0xf98700ff,0x4b010223,0x48800281}},	//   _pourdir_, _adekvata_, _османы_, _atsiullu, 
   {{0x9c610178,0x7dfd0218,0xfdfc03b7,0x663c00be}},	//   _ajarād_, _absentwa, _accentwa, _بۇسۇلباي_, 
   {{0x42da032d,0xf67f0026,0x1395014a,0x205a026a}},	// [2d0] _bapeli_, _bedenkti, _sorsa_, _matabiso, 
   {{0xbee20193,0xc201012d,0x72640242,0x1c0803b8}},	//   _दुर्दैवा, _epril_, _varlı_, _تاپتاستى, 
   {{0x52900274,0xde630154,0xb3f9002a,0xe37301c4}},	//   _bankans_, _респинӂе, _tebulu_, _tamatie_, 
   {{0xc95c019a,0xf7e60061,0xc7ba0019,0xe642028f}},	//   _colonist, _신문스크랩_, _нормадан_, _hakinaki, 
   {{0xa20203ac,0x69fd0145,0xc24e0148,0x00000000}},	//   _diakhiri_, _pakartot, _duodecim, --, 
   {{0xc25a02b2,0xd6eb03b9,0x0ecd006c,0x0a1c023e}},	//   _оригінал, _sumaspaw, _abazidla, _حجازیموض, 
   {{0xc3f400e2,0x52b100c1,0xb6fc0156,0xe218021b}},	//   _sluten_, _ग्रँम_, _הלמאַי_, _племянни, 
   {{0x1a1100fc,0x4c0c010d,0x84050061,0x396e022f}},	//   _bivangme, _serpong_, _청소년들이_, _rafinuot, 
   {{0xcd5a02e5,0x02d801d9,0x17e40061,0xd2260040}},	//   _боден_, _schneid_, _강남제니스공_, _אימהות_, 
   {{0x32e70318,0x67a80333,0x02900251,0xda720354}},	//   _apinofo_, _castagni, _hanaan_, _بەكلام_, 
   {{0xbfa403ba,0x471a0274,0x68fd0085,0x43780133}},	//   _deceiver_, _tegundum_, _taladrod, _eyyamaa_, 
   {{0x87ec02a2,0x2ed70361,0x00000000,0x00000000}},	//   _tumatang, _матвеев_, --, --, 
   {{0x295902dc,0x4dfb00cc,0xae3702ee,0x849a00f2}},	//   _quilómet, _kameraet_, _akkawnta, _karalisk, 
   {{0x820101d1,0xba270074,0x934303bb,0x77a7021c}},	//   _april_, _средний_, _arteixo_, _patentov, 
   {{0x6af30038,0x53f800ae,0x6aaf0359,0x8c7803a2}},	//   _алдыннан_, _dukure_, _elektrys, _prostej_, 
   {{0x1e4a019e,0x21b400ff,0x729000c8,0xa2b503bc}},	//   _статуй_, _ראדזין_, _bokane_, _piecas_, 
   {{0xcdc303bd,0xc08a0276,0x225b0066,0xce3a0011}},	// [2e0] _gikinaha, _كىنوچى_, _atalen_, _bagabira, 
   {{0x93950329,0xbdb3017d,0xe2790181,0xe7e403a2}},	//   _morso_, _udlandet_, _foreslå_, _जेवरात_, 
   {{0xa29001c5,0xc84500a4,0x93780193,0xbc7c024c}},	//   _banaan_, _pintures_, _nyiakan_, _espress_, 
   {{0x7b09017d,0xffe300b3,0x5d6b033d,0x57ed03be}},	//   _サインイン_, _lezzetin, _agimante_, _babahung, 
   {{0xa37700a4,0x8f360061,0x926400f2,0x00000000}},	//   _جىراق_, _사실이지만_, _stulbi_, --, 
   {{0x09560287,0x54000108,0x9917014e,0x6b6503ab}},	//   _प्रश्नहर, _ciburuan_, _средини_, _hellshar, 
   {{0xe290004f,0xf4d501b7,0xe2d40009,0x8291028d}},	//   _fanaan_, _देहिनः_, _podobna_, _laraz_, 
   {{0x22910035,0x3aec03bf,0x0f5d0220,0xc3f80230}},	//   _faraz_, _basedsys, _colazion, _lekurs_, 
   {{0x32910125,0xfd2d03c0,0xa8a8004b,0x2c7a004d}},	//   _garaz_, _designet_, _шахтерҙа, _臺北市立兒童育樂, 
   {{0x2c67006f,0x6c5b03c1,0x7a41020f,0x8225011c}},	//   _kununua_, _ставам_, _basekapa_, _jefkay_, 
   {{0xd7070314,0xdd1103c2,0x5b770210,0xe236005b}},	//   _лагеры_, _parlance_, _akaringa_, _adgjm_, 
   {{0x4ebe033f,0xcb97010e,0xa9ff03a8,0xeee10113}},	//   _fauniten, _pakisuyo_, _একাংশহে_, _cruinnis_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x22e000dd,0x727600c5,0x35170126,0x1edc0211}},	//   _tunnell_, _rassembl, _наталя_, _осложнен, 
   {{0x027600c4,0xf48402eb,0x62d803c3,0xc03000c1}},	//   _مهاراج_, _trafikok, _uzmemo_, _वेळही_, 
   {{0x05bc026f,0xe8f80044,0x6ef80184,0x00000000}},	//   _ءﺷﺎﺷﯩﻦ_, _arranged, _tukwatse_, --, 
   {{0xf3950244,0xafea0205,0x225b02d9,0x425b0026}},	// [2f0] _corso_, _жалолобо, _lealao_, _stalen_, 
   {{0x329101c5,0x5c5d028d,0x00000000,0x00000000}},	//   _haray_, _kantmem_, --, --, 
   {{0x62910105,0x3f3703c4,0xedbf025f,0x0b0c00b3}},	//   _zaraz_, _мустәқил, _bituluku_, _bersinle, 
   {{0x92ea029a,0x8c6c01d9,0x137903c5,0x132d02cf}},	//   _aeriyen_, _grausam_, _syaaban_, _запросил_, 
   {{0x829101c5,0x130c0297,0xf29101d2,0x0e5b02fc}},	//   _maray_, _barunıñ_, _caraz_, _atabanje_, 
   {{0xf2920331,0x428c0362,0x72910119,0xd3f402b0}},	//   _alsamt_, _ezakaka_, _laray_, _routen_, 
   {{0x335400be,0x28b80055,0xb3a20364,0x0d130342}},	//   _отрядыны, _studiend, _cropen_, _favorize_, 
   {{0x9af50193,0xab330095,0xa1340234,0x00000000}},	//   _laporkan_, _bancakan_, _sàlàkó_, --, 
   {{0xa98a000c,0x525b00d9,0x72ee0095,0xa3ac034b}},	//   _akatuágo, _luuli_, _afiff_, _yaupas_, 
   {{0x094701d1,0x4ebd018e,0xba8303c6,0xf4a701ac}},	//   _explanat, _eyinhlen, _dejingen_, _sabóide_, 
   {{0x56e903c7,0xd2910125,0xa6b600ca,0xb9c30122}},	//   _pracowni, _baray_, _monarqui, _صاحبش_, 
   {{0x529101c5,0xd9690098,0x2369021e,0x1d8702ba}},	//   _jaray_, _definere, _diagnos_, _метарсад_, 
   {{0xf29101c5,0x757200c4,0xbecc03c8,0x162b00ee}},	//   _daray_, _مارٽم_, _tulisann, _musikari, 
   {{0xb6340212,0x4f3600bb,0xd27a0049,0xc0c40156}},	//   _thinkbli, _دھڑکتے_, _senituli_, _צעקנייטש, 
   {{0xd54c0016,0x584c018a,0x129101c5,0x57af03c9}},	//   _קלינטאן_, _dangosir_, _faray_, _underteg, 
   {{0xad890074,0xefbd0040,0xda6700be,0x5457019b}},	//   _reseptit_, _ביקשו_, _تويعۇزات_, _katalikų_, 
   {{0x294e0374,0x65520046,0x147c0321,0x9143007a}},	// [300] _shartlar_, _сентябры, _pomenijo_, _maslahah_, 
   {{0xbf62002b,0xe2b502cf,0x42da0046,0x8bda03ca}},	//   _আইনমন্ত্, _fosco_, _entorns_, _filmando_, 
   {{0xd7ba0322,0xa2a501de,0x4291024c,0x6a2b0153}},	//   _bakuliki, _еңкейіп_, _jarax_, _カリビアン_, 
   {{0x73ea033d,0xf6320005,0x3c1801ea,0xc291028d}},	//   _ayiti_, _evenimai, _dizayner, _paraz_, 
   {{0x6e570328,0x8c2d0040,0xaf9a0061,0x7c6f022f}},	//   _cambodge_, _resigned_, _대학레포트_, _адбору_, 
   {{0x6eab01aa,0x86100210,0xe9fd00a1,0x4d87011c}},	//   _alloween, _anomutsw, _mataarat, _keemtala, 
   {{0x6b0d0273,0x82d20194,0xe887006c,0x6302028f}},	//   _función_, _estonaj_, _басанда_, _tamahau_, 
   {{0xc3ea0134,0x92ee00dc,0x84380126,0x412d021c}},	//   _eyiti_, _leafa_, _версією_, _nylonové_, 
   {{0x13dc00a6,0x558f01a0,0x21c3016f,0xa7610074}},	//   _asiwe_, _enseledy, _говорив_, _звери_, 
   {{0xa29600ce,0xb3e402ce,0x7a9101b5,0x39cf017e}},	//   _kilpabil, _modulasi_, _hanyanga_, _nordorie, 
   {{0x53be003b,0xd2f60025,0xa76b0045,0x2be1013d}},	//   _akavumi_, _चक्री_, _merkelov, _antioĥo_, 
   {{0x326f006c,0x7a0b0095,0x12e703cb,0xfc6803cc}},	//   _abaningi_, _surakart, _carnota_, _sufrido_, 
   {{0x345e02a4,0x473700d6,0x83fe01ef,0x33950192}},	//   _agovirin_, _duilleog, _smarkiai_, _borst_, 
   {{0x2ee20106,0xb7da03cd,0x2e4a0004,0x16a3023b}},	//   _हिम्मतवा, _प्रकिया_, _demantle_, _pukuniah, 
   {{0xa34103ce,0xfc920187,0xf14502e4,0xf625020f}},	//   _یۆنان_, _инфекциј, _essenzal, _ekholeji, 
   {{0x0224022b,0xd2ee006e,0x52b10066,0x741e0233}},	//   _nokkso_, _barilub_, _soldata_, _japaneso_, 
   {{0xad3403ae,0xb3b3023c,0xd0490137,0xcde50311}},	// [310] _avansert_, _سمادول_, _agenteek_, _ዘቐመጥክዎም_, 
   {{0x9a8a0130,0xa20c03cf,0x82da0175,0x240803d0}},	//   _éditions_, _herhangi_, _entern_, _izbornik, 
   {{0xa2550198,0xe34800e1,0x25030203,0xca1403d1}},	//   _svetoval, _baleegi_, _hyperbol_, _jamaikie, 
   {{0x7c72008e,0xc73103d2,0x112a0238,0x43c50156}},	//   _asiraas_, _celoslov, _припусти, _סאקפאפעט, 
   {{0x220001a7,0xe8fd004c,0x4b6c02d5,0x00000000}},	//   _omiin_, _anaasind, _विधना_, --, 
   {{0x5bb60208,0x7a0900e6,0x00000000,0x00000000}},	//   _ۆبایل_, _géométri, --, --, 
   {{0x52da000c,0x928301a6,0xfa8501ef,0x034f018a}},	//   _azteca_, _taikaha_, _бурлака_, _annerch_, 
   {{0x2bf602d8,0x995d03d3,0x91e100db,0x58cd024f}},	//   _प्रथमच_, _mislykke, _गुजरल_, _naqumuiv, 
   {{0x74110046,0x3f6603d4,0xe6510061,0xc9790166}},	//   _اڭعىچا_, _умели_, _예수님께서_, _namhafte, 
   {{0x17c702e0,0x946f0107,0x415f028d,0x1b670129}},	//   _akaretsw, _استعلام_, _konsesyo, _meputara_, 
   {{0x9b7000bc,0x4ce90223,0x79ef034e,0x4fb80162}},	//   _ayushita_, _бикинитэ, _danielpa_, _توركەش_, 
   {{0x9fd7023a,0x738203d5,0x140802f6,0x83dc0157}},	//   _pretože_, _burying_, _tanungin_, _brawo_, 
   {{0x26fd02fe,0x0397005b,0xf96101d2,0xc6a702b6}},	//   _سیاسي_, _medarbej, _arininat, _يۇنشان_, 
   {{0xfbed03d6,0x237900ac,0xdda50192,0x1dd70115}},	//   _महाप्रभु_, _porasla_, _schoolja, _berkasut_, 
   {{0x11870061,0xfb5a0115,0x1b0f00e0,0x16f0014a}},	//   _소비자보호에관한, _ciptanya_, _emigraas, _bevallás_, 
   {{0xa532020f,0xd3f403d7,0x42d6019a,0x0b87030d}},	//   _abazisik, _foutan_, _forlost_, _bakinter, 
   {{0xc27f012f,0xc7970022,0x12ef01c4,0x32d80388}},	// [320] _amuno_, _октябргә_, _pornstêr_, _schemi_, 
   {{0x8b67002a,0x2c2503d8,0xe387016e,0x92cc0109}},	//   _deputara_, _trgovinu_, _atarak_, _ledvinky_, 
   {{0x92c801c6,0x4c8403c2,0xac8f0040,0xc21c0144}},	//   _feroare_, _bereaved_, _מצוקת_, _meckpomm, 
   {{0x77f80144,0x4d9d018e,0x126c03d9,0x226001e8}},	//   _ببرنامج_, _balekeke_, _molony_, _ipaminaw_, 
   {{0xa5a9000c,0x63860160,0x29cd0089,0x0411009f}},	//   _абардырр, _uporno_, _почтасын, _bogastvo_, 
   {{0xec070089,0xf5ee00d1,0x00000000,0x00000000}},	//   _sistemas, _তালিকাৰে_, --, --, 
   {{0xb201038c,0x92090287,0x92a20153,0x00000000}},	//   _dobiju_, _motorkář, _幹部対象に_, --, 
   {{0x9b5c03c3,0xb2d901d3,0x5d860074,0xfb6703da}},	//   _političk, _arbete_, _награды_, _keputara_, 
   {{0x8c600133,0xa27e02ba,0x52710205,0x087603b8}},	//   _achuman_, _adinga_, _нурчилар_, _شىرقالعا, 
   {{0xaa2400bc,0x1dfc0218,0xd2da0172,0x89720210}},	//   _stockist, _acceptwa, _twreye_, _asingane, 
   {{0x0ffe0375,0xc27b01c8,0x0a7d0322,0x00000000}},	//   _amakaiko, _komediál, _bagahera_, --, 
   {{0x925b0111,0xec310092,0xb44a0311,0xbbdf0326}},	//   _isula_, _本実施形態では_, _ምፍንቓል_, _chiender, 
   {{0xe27e03db,0x1217004d,0x62bb01c7,0x13e80009}},	//   _edinga_, _接受中國信託等_, _belende_, _testerji_, 
   {{0xe65f02c2,0x13690157,0xaf790109,0x00000000}},	//   _beskikki, _bartłomi, _děsivé_, --, 
   {{0x28e803a8,0x927e03dc,0xc3ea0170,0xe23c0350}},	//   _অসংলগ্ন_, _beinta_, _iyitu_, _በፓኪስታን_, 
   {{0x530c007f,0x727302a4,0x0ca902eb,0x9bb903dd}},	//   _geraint_, _questhel, _фэнблог_, _frekuenc, 
   {{0xf26d021c,0x631601c8,0x105201df,0x22c9018d}},	// [330] _kandidát, _honza_, _blessedn, _ዘይመስል_, 
   {{0x032003de,0xb2bb01bb,0xaf7601f7,0x726d005d}},	//   _omnye_, _gelende_, _efectius_, _candidát, 
   {{0xf11c002e,0x7daa017f,0x063a00f2,0xf5580158}},	//   _održala_, _assilisa, _radiācij, _unikalny, 
   {{0xb316013b,0x08c90192,0x525b03df,0xfa750036}},	//   _monza_, _입체평면도_, _truls_, _blaganna_, 
   {{0x9ea001b2,0x025b0043,0x39fd01c5,0x5abe026f}},	//   _distrust_, _asula_, _ilaalint, _اجىۋا_, 
   {{0xd16803e0,0x43f403e1,0xdc810012,0x2dd6017f}},	//   _langweil, _rytter_, _छ्ोलकट्उ_, _bankimut_, 
   {{0xcb5c035b,0x4e100185,0x326d00a1,0xe2a600d6}},	//   _političn, _семантик_, _huaota_, _ailbhe_, 
   {{0x3f660125,0x62ca03ba,0x69780092,0x5424016b}},	//   _амала_, _geidet_, _目のつけ所が名無, _akasarin_, 
   {{0x098702d1,0xf9ec039e,0xe27e00f3,0x54e80178}},	//   _jacintha_, _ক্ষুদ্ৰ_, _abonwe_, _amarṣād_, 
   {{0x4fd2028c,0x2fe30163,0x3c6f03e2,0xa3ea0181}},	//   _सारगर्भि, _جانتی_, _cloruro_, _ayato_, 
   {{0xf7b50013,0x8b9d0268,0xcc1102fd,0xe2b50111}},	//   _tekshiri, _acticepr, _barganac, _acidume_, 
   {{0x42e301d1,0x8979004d,0x8ea703e3,0xaa1700be}},	//   _derived_, _具特色古舊建築_, _sipleman, _جىيەنلىب, 
   {{0xd3dc03e4,0xf63e0265,0xe1010008,0x2b1d03e5}},	//   _asiwa_, _koninkli, _юнескону, _waiparae, 
   {{0xfb5c024e,0xa29c005b,0x71c303e6,0x610b0213}},	//   _političa, _mixiペ_, _vollform, _иваном_, 
   {{0x227f012f,0xd41d01c4,0x93030080,0x22b4037c}},	//   _amune_, _verslaan_, _anaanat_, _sicca_, 
   {{0x7c5e03a7,0xbf7002d3,0x42500244,0xd2ea0125}},	//   _portál_, _infantis_, _режат_, _berilen_, 
   {{0x6a1402ee,0xbc050158,0xfea9004a,0x00000000}},	// [340] _benefiċj, _gruszki_, _ихласи_, --, 
   {{0x2c6b03e7,0x3c7c001d,0x426c0183,0x9da90077}},	//   _braunau_, _egardar_, _polony_, _belijera, 
   {{0xbaa403e8,0xa03e022e,0x53a10145,0xa341028f}},	//   _društev_, _abitutin, _актуальн_, _materoa_, 
   {{0x19c901e9,0x827e03dc,0x00000000,0x00000000}},	//   _didolora_, _reinsa_, --, --, 
   {{0xec25003c,0x0a1201db,0x8176032b,0x00000000}},	//   _رنگدانه_, _флипчарт_, _راستمۇ_, --, 
   {{0xae7a03e9,0x620002fd,0x230e00d1,0xcf3c038a}},	//   _байлыгын, _amaid_, _কথ্যভাষা, _caruncha, 
   {{0xd395021a,0x02b603ea,0x82fc00fc,0xf40f027b}},	//   _gorsi_, _soucis_, _lengqo_, _दुरभिसंभ, 
   {{0x135503ce,0x03740365,0xd8cd03eb,0x00000000}},	//   _عاشقێکی_, _जेभियर्स_, _geldenhu, --, 
   {{0xb54f0008,0x00000000,0x00000000,0x00000000}},	//   _корсонор_, --, --, --, 
   {{0x199101cb,0x3c040211,0xfb6903ec,0x3b1900db}},	//   _likhetha_, _tiistai_, _kuvendin_, _propagee, 
   {{0x8c88019e,0xe6e201eb,0x92ff00e6,0xbc72023e}},	//   _трансліт, _arecondi, _挽救血液病患儿慈, _دوستانتو, 
   {{0x263503ed,0x69d203ee,0xa3950181,0x368c0287}},	//   _econômic, _omiljena_, _dorsi_, _भूषाल_, 
   {{0x02fd01c6,0x65ed00ff,0x686e0076,0x4bd00065}},	//   _ekonomy_, _טינעק_, _сообразн, _vordergr, 
   {{0xc39502ee,0x2df30132,0x4f1d011d,0x59fb0092}},	//   _forsi_, _gyülekez, _полисема, _kamisama_, 
   {{0x54ad00d1,0xda020251,0x7386018a,0x00000000}},	//   _চেম্বাৰ_, _jamacada_, _meirch_, --, 
   {{0x10b80040,0x0e0000e6,0xcda2006d,0xd6f601b3}},	//   _התאורה_, _按文章内容_, _аляўціна_, _натуралі, 
   {{0x73b00044,0x00000000,0x00000000,0x00000000}},	// [350] _הממוצע_, --, --, --, 
   {{0x98c10132,0x18f70084,0xdd9d0173,0x24d50128}},	//   _keresked, _nazarudd, _buenasta, _ўқийди_, 
   {{0x0d0a00db,0x8b8d0247,0xe67f0119,0x631e020e}},	//   _तत्वाधान_, _maliobor, _eskwelah, _boncril_, 
   {{0xcc4603ef,0x42000219,0xeb2902b9,0x527e0015}},	//   _abapolis, _baniyo_, _یزیدی_, _adinba_, 
   {{0x2be60137,0x32b5013a,0x4eb200d8,0xe25b021c}},	//   _живцийн_, _rosch_, _esperons_, _nealko_, 
   {{0x511c004a,0xed8901df,0x070b03f0,0x00000000}},	//   _сайттагы_, _desertit_, _brautryð, --, 
   {{0x12b503f1,0xbbfc0107,0x1a4b02d3,0x5c6300ec}},	//   _posch_, _مدریت_, _évetada_, _ritulio_, 
   {{0x5ba901a7,0x60e703f2,0x730100da,0x2e340011}},	//   _laskuvar, _внесении_, _probele_, _banaakwa, 
   {{0x4f39029e,0x939503ad,0xc3ea012c,0x57d700ba}},	//   _stankter_, _sorsi_, _urithi_, _مۆنۆدرام, 
   {{0x08510025,0xd1a60149,0x28e4002b,0x03f1020e}},	//   _विद्वान्_, _ebenrụọr, _শিক্ষিকা_, _dibeteng_, 
   {{0x0faa033a,0xe1be02fe,0x65bf003f,0x662b01e9}},	//   _selettur_, _سیاستونو_, _diyajmoh, _hisitori, 
   {{0x884a028b,0x13f403f3,0x552703d4,0x5ec601b3}},	//   _дамардеи, _fouten_, _zapretio_, _часток_, 
   {{0x322a00af,0xc22703f4,0x02e20251,0xb277039e}},	//   _порад_, _парней_, _hadiyad_, _avisspal, 
   {{0xac6001c5,0xedba033d,0x7c5a010b,0xba7e003d}},	//   _daarood_, _bignonia, _dipuong_, _alentiss, 
   {{0x33f40237,0x9cd0011a,0xefa7002b,0x00000000}},	//   _houten_, _במפשעה_, _calentar_, --, 
   {{0x9c4a0212,0x7a450353,0xf570017a,0x2d9c004d}},	//   _leucoenc, _diskrétn, _abawunak, _玩酷版傳遞愛心起, 
   {{0x0294030b,0x84a300e4,0xb00e002b,0x56cd03db}},	// [360] _abakazi_, _ज्ञानदत्, _ইমোটিকন_, _bayakuni, 
   {{0xea8c03db,0x6c7d01e5,0x22d8028a,0xd2d90030}},	//   _azinakub, _ifisipo_, _acheni_, _debess_, 
   {{0xe85c0192,0xe2830040,0xc49502b6,0x00000000}},	//   _반품배송비는_, _ארקדי_, _гвардиял, --, 
   {{0x92ca0359,0x47cf0192,0x937b03f5,0x8ab20126}},	//   _neidat_, _슈퍼주니어_, _levando_, _невизнач, 
   {{0x4c82001f,0x1431012c,0xfeb70148,0x4feb0012}},	//   _beresosɛ, _pembejeo_, _kalendas_, _बउखाउएक_, 
   {{0xaa9e013b,0x030203f6,0x0f350191,0x6c6202ff}},	//   _cathleen_, _kamakau_, _existera, _bourade_, 
   {{0x8e970074,0xc29102ff,0x647100e9,0x9e290188}},	//   _рецензии_, _savann_, _kontstan_, _беҷавоб_, 
   {{0xa31a01b7,0x8ee601d2,0x930302bf,0x00000000}},	//   _tejasā_, _anchurin, _bunyenti_, --, 
   {{0x60fd0142,0xc38a03f7,0x324803f8,0x788700bb}},	//   _मानवा_, _hörpu_, _denmar_, _ذرےعے_, 
   {{0x25fa0037,0xb39d00ae,0x43460075,0x00000000}},	//   _በመተካት_, _kamparam, _hindurs_, --, 
   {{0x5d1e0326,0x4200000b,0x60930122,0x3f4403f9}},	//   _monoxide_, _manino_, _چطوره_, _jésuites_, 
   {{0x3773020e,0x430b0102,0x8edc0203,0x14520299}},	//   _серверҙа, _uchimbaj, _scriptes_, _تەگمەي_, 
   {{0x93dc00ab,0x89ec0040,0x90600397,0x00000000}},	//   _arawa_, _שהחברה_, _anesidin, --, 
   {{0x7cda0314,0xaf9e02ac,0x7b11018b,0xe26300de}},	//   _авгусҡа_, _بحدود_, _garsonie, _balubhal, 
   {{0xecaf03fa,0x422300bb,0xd86e02a3,0x0e7800be}},	//   _ब्लीडिंग_, _المکان_, _apostels_, _ساحنالار, 
   {{0x12920064,0xffab0105,0x4f8b00c7,0xb26300dc}},	//   _posant_, _रस्तोगी_, _яныңда_, _kilikiti_, 
   {{0x4fc2014a,0xd3dc036a,0x585d0011,0x0af300aa}},	// [370] _باذوق_, _erawa_, _abonered, _goeringe, 
   {{0xa0bc0036,0x829003b0,0x1fd50281,0x7b8401fe}},	//   _ايميلك_, _rikare_, _allinngo, _vonovono_, 
   {{0xe27f0196,0xb6cd036c,0x85920040,0x6863000c}},	//   _amuna_, _ampangai, _יחצנים_, _ҷолариа_, 
   {{0xf2c60119,0x00000000,0x00000000,0x00000000}},	//   _gorlice_, --, --, --, 
   {{0x7e3d0169,0xaf74012a,0x44a30255,0xe2b503fb}},	//   _সাতটি_, _katarzyn, _ज्ञानदर्, _ubacim_, 
   {{0xb1b002ec,0x30d00002,0x2ed40326,0xdab701ab}},	//   _پۯژھاں_, _radoznal, _avaizvin, _मुअड़ी_, 
   {{0x040c03fc,0xf2d803a4,0x42910310,0x00000000}},	//   _terningk, _avlesa_, _scran_, --, 
   {{0x49320352,0xd3ea00cd,0x52920334,0x4c97006c}},	//   _ঘটায়_, _spitex_, _duwalo_, _бетарафи_, 
   {{0x620103ab,0xe7cf0276,0x52d80241,0x46bd0060}},	//   _mobilu_, _амалисз_, _adhee_, _күресу_, 
   {{0xc26c00ac,0xc655016d,0x1dc400aa,0x1618026f}},	//   _samog_, _бушниң_, _bisitaha, _بەرۇىڭدى_, 
   {{0xf38703b5,0x02830282,0x426c03fd,0x524800ae}},	//   _kearah_, _kaikaha_, _mamoe_, _idomwa_, 
   {{0x727e00a1,0xfdb400bc,0xc7e802d3,0xf2fd0148}},	//   _meinga_, _نوموس_, _recarreg, _genitor_, 
   {{0xec4f024f,0x171a03fe,0x49c700be,0x83fa020e}},	//   _ikawalu_, _спиртные_, _далалат_, _furung_, 
   {{0xc8dc023d,0xd31600e9,0xac4f0053,0xc08b0109}},	//   _купих_, _konze_, _जीवनावर_, _holící_, 
   {{0xfe1d02bc,0xf38703ff,0x290500a6,0xa20e000c}},	//   _jeremaia, _mokré_, _akwanefu, _иараа_, 
   {{0x93dc00a6,0x934f0400,0x4311019a,0x69ec03eb}},	//   _isiwe_, _rimetti_, _dooblet_, _buurland, 
   {{0xc56102ac,0x00000000,0x00000000,0x00000000}},	// [380] _مشاجرة_, --, --, --, 
   {{0xe8750091,0x92e90285,0xb6450076,0x12e6007b}},	//   _frenchlu, _kurinda_, _плодови_, _swingin_, 
   {{0xe29000cf,0x0e5103b5,0x1298004d,0xc43400cb}},	//   _ummata_, _hilangka, _高雄市政府_, _akakubek, 
   {{0x1375005e,0xa26c00c0,0x3f0d037b,0xb3e001a3}},	//   _ﭘﯘﺭﺳﻪﺕ_, _tamod_, _cercanas_, _ضياءُالح, 
   {{0x6c7c0245,0x0f5b0386,0x3d1a02ac,0x82ca0057}},	//   _agarkar_, _memandan, _معتمدة_, _realiti_, 
   {{0xb2ca0286,0x874c023c,0x19e60111,0x01bf0064}},	//   _adidie_, _دترهګرو_, _allocala_, _immersió_, 
   {{0xcdbc0104,0x2e430401,0x7ba40092,0xd3420278}},	//   _sikayise_, _युद्धविर, _発明が解決しよう, _kasehan_, 
   {{0x92a70065,0x69c1002c,0x487d011a,0x70e300d0}},	//   _lieber_, _bereizte, _complies_, _aliatuek_, 
   {{0x016f0402,0x7a110040,0x1f05038a,0x6f510234}},	//   _wajiblah_, _impairme, _brujokun, _olówò_, 
   {{0xa2e30126,0x8d3102ac,0x6f5c0403,0xd2e400f4}},	//   _нормами_, _الجحيم_, _andanian, _buannic_, 
   {{0xe3f900a4,0xbcbe0404,0xd0630405,0x169700b7}},	//   _recurs_, _megabaru_, _подорож_, _bejerili, 
   {{0x427e01e6,0xb3410220,0xb3ea01d2,0x22da02a1}},	//   _podnik_, _esterna_, _ayata_, _strepe_, 
   {{0x73c700d6,0xc65001a3,0x4dc400ed,0x7b7500ee}},	//   _corparái, _الھندي_, _gisiraha, _удбэт_, 
   {{0x937f00d1,0x12c602bf,0x52000226,0xfe510197}},	//   _স্বত্ত্ব, _abulale_, _ajiili_, _deranjma, 
   {{0xb86c0197,0x32000318,0xb3ef0153,0x434200c0}},	//   _asistans_, _keniā_, _julebryg_, _basehan_, 
   {{0x1dd00406,0x2a9302c9,0x12ee000b,0x00000000}},	//   _तुर्कमेन, _доведит_, _leafi_, --, 
   {{0x1bd90192,0xaf4f032b,0x52a601b6,0x9c02019e}},	// [390] _지식전문가_, _قورقۇش_, _timber_, _jausmas_, 
   {{0x306001c5,0x2e480037,0x9097004d,0xbda60407}},	//   _الانزٕ_, _እውነታው_, _會像汽油彈似的立, _zaposlja, 
   {{0x6ec80256,0x3f820157,0xec920338,0xb2000408}},	//   _eksemplā, _मक्के_, _augsborg_, _fanilo_, 
   {{0x09db0409,0x125a03eb,0xb59502af,0xc4720074}},	//   _japonica_, _vallei_, _jururyak, _saatanan_, 
   {{0xf2da040a,0x209f0061,0x4290029b,0x7eb10408}},	//   _titeln_, _지방자치단체_, _dolaar_, _antontan, 
   {{0x2e4e040b,0x524a0158,0x596c0312,0xedd4000c}},	//   _ramabula, _firmą_, _stankade, _геликоно, 
   {{0x13990017,0xd9c001d4,0x6d0301cd,0x3af40322}},	//   _lásce_, _interdet, _суғуртаи_, _ariruhut, 
   {{0xd28701bd,0x285402ac,0xc7ce02ba,0x199c0082}},	//   _ءومىردىڭ_, _طوكيو_, _alotshiw, _bankwana_, 
   {{0xf9fe02da,0x6ce20052,0x19e802e5,0x3d7e00dd}},	//   _casament, _रिपोर्टर, _camiónpe_, _deimlada, 
   {{0x3200002e,0xddfd040c,0xdcc802da,0xefd6002b}},	//   _knjigu_, _generova, _заложнич, _সৌন্দর্, 
   {{0x59bf0170,0x2c7e007b,0xf2480176,0x2b9c00da}},	//   _akavumbu, _blushin_, _fremad_, _centrală_, 
   {{0x2bc4017d,0x7f3d01c7,0xa53e0227,0xc2900068}},	//   _この記事のトラッ, _башламак_, _karierny, _inkale_, 
   {{0x8a340247,0xe29501b5,0x39ce029e,0x00000000}},	//   _تسلیت_, _efrayimi_, _eveldomp_, --, 
   {{0x1f620105,0xa941040d,0x9a10003b,0x889700d6}},	//   _संस्थाएं_, _kholofet, _angameme, _ترتبط_, 
   {{0x1e530002,0xeeac01ff,0x5c29040e,0xbe9700e0}},	//   _hrabrost_, _postovne_, _årsklass, _fertriet_, 
   {{0x45a3000c,0x1d160025,0x58b80040,0x638001c4}},	//   _ajesarek, _ahorātrā, _מתורגם_, _betrek_, 
   {{0x55de040f,0x6e3c00da,0x7b910410,0x4d1d02a3}},	// [3a0] _военачал, _ачяста_, _lokilego_, _onnodige_, 
   {{0xf1e10255,0x030302a2,0xea2602eb,0xd2940156}},	//   _हमारो_, _pamagat_, _ярихыг_, _זנוויל_, 
   {{0x92da02c2,0x70ba0109,0xb5870411,0x00000000}},	//   _strewe_, _šuplíku_, _балету_, --, 
   {{0xc63b032e,0x8aea00ae,0x2c7c034a,0xfa5f0288}},	//   _lakirapx, _ararifat, _terreos_, _rangaeta_, 
   {{0x3049014f,0xc8000199,0x0c7d0222,0x766700ee}},	//   _периоду_, _danchoiv, _fournir_, _биберт_, 
   {{0x562401ef,0x27ba023e,0xd6890045,0xd3f4025e}},	//   _слушна_, _تفکرات_, _кадровск, _bettý_, 
   {{0x27cb0359,0xc3ea0412,0x11be0230,0xbc620057}},	//   _hearrenf, _esithi_, _lanmerdm, _sapukan_, 
   {{0xe38b0060,0xffab02e4,0xa50b004d,0x861e03ab}},	//   _апаратын_, _detentur_, _閱讀排行榜_, _pranosti, 
   {{0x627e0172,0x33c500bb,0x561d0013,0xdf550013}},	//   _mpontu_, _کارندے_, _aralashi, _булмиш_, 
   {{0x5f620157,0xe61e0258,0xdd6d0413,0xf294023b}},	//   _संस्थाओं_, _ferneati, _crustáce, _paakiki_, 
   {{0x52f0029c,0x984702ba,0x014501ab,0x0a07003c}},	//   _danieli_, _раками_, _खोईंछा_, _antarkut, 
   {{0x0bb7032d,0x3d1701a3,0xc23a0414,0x65850107}},	//   _маршрутт, _لنگھيو_, _kwamutu_, _critakak, 
   {{0x67f8020a,0x83f903b4,0x00000000,0x00000000}},	//   _زارلىسىن, _ayeuka_, --, --, 
   {{0x42d90073,0xc0630211,0x02be02e1,0x00000000}},	//   _arbores_, _потеря_, _بالادارة_, --, 
   {{0x227f004f,0xfb8701e9,0x4815003e,0x00000000}},	//   _amunu_, _dikokelo_, _буласає_, --, 
   {{0x53870191,0xe15b0277,0x12b402ee,0x2a9d01fe}},	//   _undrar_, _sportboo, _bicca_, _qorinias, 
   {{0x8abc00c5,0x7cf40060,0xa05a0291,0x947b0166}},	// [3b0] _如何贡献知识_, _جىينالىس, _يسافر_, _befunden_, 
   {{0x6af901cd,0x1f3403b0,0x0d8700aa,0x00000000}},	//   _abashint, _svarteda, _hellicop, --, 
   {{0xf27e000e,0x12d802d5,0x223a00a1,0xfa7d0156}},	//   _abonat_, _mehed_, _awamutu_, _מיטעלסטע_, 
   {{0x02d80255,0x8486006f,0xd56500b7,0x07060156}},	//   _lehed_, _اطالوي_, _artjakdy, _הילאַרי_, 
   {{0x29560211,0x8a6b01f0,0xe1500060,0x129103ee}},	//   _sellaine, _bommagis, _بىلوگتار_, _manjine_, 
   {{0xe47b0415,0x1f720147,0x00000000,0x00000000}},	//   _gefunden_, _انىعىراق_, --, --, 
   {{0x724503ff,0x1e950416,0x83eb00a6,0xb21503b6}},	//   _rámci_, _contenet_, _esathi_, _ló̟wó̟_, 
   {{0xd27f01d2,0xa3fd0371,0xfbec00ed,0xe33702d6}},	//   _adanna_, _априлци_, _inhenyir, _минора_, 
   {{0x526d019d,0x94a50147,0x89c40417,0x00000000}},	//   _ataona_, _قوچەگارگ, _geadvert, --, 
   {{0x13160362,0xfa920172,0xa584007e,0xa2910148}},	//   _konzi_, _nsonsons, _नियोगतः_, _dicant_, 
   {{0x29490265,0xaf620139,0x617c011a,0xa21f0255}},	//   _kenmerke, _संस्थानं_, _diminish_, _nähes_, 
   {{0x23f40077,0x17a7014a,0xde450196,0x747b0227}},	//   _mouton_, _سفاری_, _angawaga, _meneguhk, 
   {{0x2a0d020d,0x727e02ec,0x12ef0165,0x92900076}},	//   _kubasaba_, _idinla_, _taniela_, _aikade_, 
   {{0xcb0302a9,0xae20005e,0xf01601e6,0xa9f600bb}},	//   _моздок_, _ﺧﺎﻟﯩﻐﺎﻥ_, _židovské_, _روٹین_, 
   {{0xc20e01f4,0x42ff00f1,0x83ea01fe,0x3f6b0222}},	//   _караб_, _lasiyer_, _iyatu_, _densité_, 
   {{0x7249034e,0xc8320041,0xd2c40187,0x38470041}},	//   _amamá_, _иҭҵаатәу, _недозвол, _саҭааит_, 
   {{0xdb88036d,0x2e3b0343,0x592003f8,0xcc14027b}},	// [3c0] _bacioter, _makapapa, _paschohd, _शुक्लधर्, 
   {{0x12ea03cf,0xc73c0076,0x18a3034c,0x625100c1}},	//   _verilen_, _фокусира, _русларга_, _माळेचे_, 
   {{0x62910010,0x19870418,0x4a5f01a0,0x1c2c0333}},	//   _ancabe_, _çikolata, _maveleka_, _assitatu_, 
   {{0x1be5017e,0x07910244,0xd7ee020d,0x22d8002a}},	//   _interpar, _costitui, _barahung, _mehee_, 
   {{0xf28702ac,0x24cb0419,0x4a6202ea,0xa4730308}},	//   _عفواً_, _टोकियो_, _esigenza_, _tertelan_, 
   {{0xbda9036f,0xf95b02a5,0xb20200a1,0x368f03bf}},	//   _nastavku_, _होमस्टे_, _kauika_, _disebedi, 
   {{0x0493041a,0x726c02fb,0xf1ef0352,0x79c70064}},	//   _стратегі, _atiola_, _দিশবিন্য, _бабажан_, 
   {{0x5fbd0097,0xb34b038f,0x72b4004f,0x92b30326}},	//   _abaniṣer, _kemeret_, _picci_, _abudisa_, 
   {{0xf27c01a4,0x847100ee,0xe27e00cb,0xd3dc00bd}},	//   _agangaki_, _kontutan_, _abonge_, _craws_, 
   {{0x079102ea,0x621d00c7,0xe9950362,0x73010089}},	//   _sostitui, _намус_, _konkanga_, _gafarov_, 
   {{0x29640244,0xb99d0125,0x48fb005e,0x7d93000d}},	//   _coinvolt, _халыс_, _بىگۇناھ_, _paberile_, 
   {{0xe28702e2,0xcf5b02f6,0xe75100bb,0x00000000}},	//   _ciliary_, _palagian, _اجوائن_, --, 
   {{0x93dc0140,0x5356029a,0x5c5c0142,0x15d800b0}},	//   _asawa_, _detenir_, _देवेश_, _saacadah, 
   {{0x327f01d2,0x3eea02ac,0x6d0a0028,0x29270033}},	//   _adanda_, _أستون_, _sharmaar, _calculau, 
   {{0x79e300c1,0x2fe80059,0xac6e0046,0x30380061}},	//   _kalibata_, _метрото_, _aporten_, _나타납니다_, 
   {{0x7572001c,0x10050291,0xfef10331,0x00000000}},	//   _lietavsk, _اخواتى_, _elskarin, --, 
   {{0xf37a041b,0xa7cf0061,0xfc5603b2,0x632200a8}},	// [3d0] _tamabil_, _사용편의성에_, _wartime_, _barchas_, 
   {{0x9f960044,0x82a6041c,0xd8e3032d,0xc287028e}},	//   _איילון_, _cimbir_, _сумып_, _wilkere_, 
   {{0x344202b9,0xb2ca018b,0x84870211,0xf74c0313}},	//   _محافظوں_, _ovidiu_, _билета_, _qavitbej_, 
   {{0x8fae0397,0xc1ed03f0,0x97ae00c7,0xbc6603fb}},	//   _балке_, _fullorði, _билге_, _sastaju_, 
   {{0x1a73041d,0xb23803e5,0xcf4f0143,0x6d3b00b4}},	//   _obično_, _gramati_, _proporre_, _paginile_, 
   {{0x1ae302a2,0x134f0032,0xa8e9041e,0xc20002ea}},	//   _talumpat, _damevdi_, _agrestì_, _panico_, 
   {{0xdb2b0107,0x40d60236,0x00000000,0x00000000}},	//   _adhaptas, _čarolija_, --, --, 
   {{0x22fd0306,0x02e601d2,0x60ee0213,0x75da02fe}},	//   _purge_, _adaneva_, _названий_, _نصیراحمد_, 
   {{0x7aa6041f,0xd06e02b7,0xfb1a005e,0x8271012b}},	//   _yebhayib, _tagaaboo, _ﻳﯧﻨﯩﻐﺎ_, _opiniami_, 
   {{0x823801b9,0xc29100b7,0x99c6013d,0x02d90003}},	//   _dramati_, _abray_, _posedant, _lezers_, 
   {{0xc35f02a3,0xa2d502fd,0xf2fc0420,0x38360205}},	//   _langste_, _chromba_, _meninos_, _мушкулку, 
   {{0xfe480037,0xe62c0141,0xa63e013a,0x00000000}},	//   _በጥንታዊ_, _ittifoqi, _kinneksw, --, 
   {{0x11ed03f0,0x7ae001bf,0xfae00153,0xf9e300b4}},	//   _fullorðn, _forutset, _forudbet, _ridicata_, 
   {{0xbadf0089,0x89e50397,0x53b503ee,0xe0d10227}},	//   _delegats, _indodana_, _imovina_, _menonjol, 
   {{0xe26c02e7,0xfc1b02a9,0xdbb0000d,0xc727004d}},	//   _namon_, _verslą_, _elektrir, _臺灣學生書局_, 
   {{0x12e20148,0xe2f50094,0x5cbe002b,0x0cb402c1}},	//   _皆為部落長個人提, _сыймай_, _ভাবগাম্ভ, _babyakir, 
   {{0x77d100be,0x72ea033d,0xd9f002a8,0x79ea0038}},	// [3e0] _اشىشىن_, _meriken_, _kannella_, _итэргэ_, 
   {{0xeb8b01d2,0xafdb0162,0xcdbf0282,0xd3940421}},	//   _akunapir, _киләдурм, _mauritau_, _gibst_, 
   {{0x6d2b0169,0xa1cc033e,0xf3010422,0xeecd0297}},	//   _প্লাজার_, _сымам_, _odpadki_, _башланса_, 
   {{0xbd89026f,0x5aa60104,0x10c1005b,0x22f500d2}},	//   _ءبادىك_, _webhayib, _tilladel, _ngintip_, 
   {{0xfb03013a,0xa34200c1,0x9628006f,0x00000000}},	//   _bauschut, _एकसंध_, _خوشنصيب_, --, 
   {{0x8a600212,0xdaec01d1,0x829002d5,0x026402e7}},	//   _jailhous, _accessib, _pikalt_, _isulti_, 
   {{0x22da02f3,0x1f5d0301,0x127f03cf,0x37b90150}},	//   _adress_, _kitabxan, _zeynep_, _sakrifai, 
   {{0x037802b6,0x8ec60046,0x2296028f,0x4958021a}},	//   _мәтел_, _таптык_, _maikuku_, _diilalle, 
   {{0xe25600d1,0x552c0360,0x335600c5,0x9ea600f4}},	//   _মাম্বা_, _मुरारकाक, _retenir_, _bublikan, 
   {{0x7a5f0245,0x9d2c00ba,0xeef30037,0xa2dc02ea}},	//   _dangstep_, _بدۆزرێته_, _ታዛቢዎችን_, _laterali_, 
   {{0xc26c004b,0xcc74018d,0x3d9b0108,0x72c70423}},	//   _kamoo_, _ምስምሳት_, _mangpaat_, _produkci_, 
   {{0x43e5012b,0x2a090073,0x42e90424,0x77ff0040}},	//   _wątek_, _megahert, _cercetăr, _המחדל_, 
   {{0xf2dc00ec,0x526c00e1,0xea14002e,0x1e050119}},	//   _vadovai_, _damoo_, _izjavama_, _nordvorp, 
   {{0x937b00c3,0xef8b0425,0xb2ca0116,0x64890019}},	//   _senatum_, _شساغی_, _heidit_, _бизнесиб, 
   {{0x2504036d,0x89600426,0x552f01f0,0x00000000}},	//   _ciallach, _माउन्ट_, _ipapatso_, --, 
   {{0xe3030427,0x22e2028e,0x32360428,0x21370161}},	//   _ahianit_, _kaunsol_, _alojz_, _камнями_, 
   {{0xa26c008d,0xe42100a5,0xe18900b3,0xf3f101f0}},	// [3f0] _zamon_, _fakalogo_, _рахманбе, _dibeseng_, 
   {{0x529003cf,0xc2c60405,0xeaa801a3,0x86c800de}},	//   _hikaye_, _skammer_, _جياپو_, _قبیلوي_, 
   {{0x5aca004a,0xfbf502c7,0xce520429,0x5dff00ec}},	//   _atlanıp_, _immernoc, _hidangka, _atleista, 
   {{0x816301db,0xead3031e,0x00000000,0x00000000}},	//   _сұңқар_, _pretvore, --, --, 
   {{0xae4302af,0xc26c01d9,0x13dc0294,0x9557030d}},	//   _bakanaya, _namol_, _arawi_, _jurnalın_, 
   {{0xf224036c,0x19a9005e,0x945000bf,0x00000000}},	//   _azoko_, _ئىپلاس_, _вступят_, --, 
   {{0x12fc0270,0x0ff30157,0x20e4026c,0xe959018d}},	//   _camisas_, _कलाकारों_, _fringill, _ኣርሒቖም_, 
   {{0xdbc20128,0x115d03bf,0x229200bc,0x5f040164}},	//   _عبداللطی, _adiology_, _kirang_, _сүрди_, 
   {{0xdc670120,0x12920245,0xe3200112,0xc22a0040}},	//   _addunya_, _jirang_, _amnya_, _ודמיון_, 
   {{0xb292010b,0xb3e502dd,0x226c005a,0x58e0042a}},	//   _dirang_, _modulari_, _damol_, _bangumnd, 
   {{0x84440037,0xe2e300e7,0x9302033f,0x00000000}},	//   _ማጎልመሻ_, _arutonay_, _tanatou_, --, 
   {{0xedda026c,0x32d5041c,0x3b6a0034,0x7c530255}},	//   _鋼筋混凝土造_, _dollent_, _afneitun_, _बारेन_, 
   {{0x6d9103e0,0x42ef002f,0x122a0213,0x1f1d02e9}},	//   _fotograp, _alhirya_, _досай_, _destroza, 
   {{0xa31e0254,0xd6bf01c9,0xe30502df,0xf292042b}},	//   _fracaso_, _geograaf, _diaorang_, _posade_, 
   {{0x1c760087,0x8ca903d4,0x1905041c,0xf3ee0294}},	//   _emirini_, _пречисти, _latajjid, _huertapi_, 
   {{0x2b63042c,0x926c008d,0x548e01be,0x5b6f0350}},	//   _javnošću_, _kamol_, _okouzluj, _ለማደናገር_, 
  
   {{0x339c00d5,0x327e02fd,0xd2d800bc,0xedc0009a}},	// [400] _fanatanj, _beinna_, _adhem_, _andikuma, 
   {{0x22890298,0x48f802af,0xb6ab012a,0x4b25028d}},	//   _marangai_, _barawutu, _selektyw, _propriyt, 
   {{0x30020036,0x92cc029b,0xca9200a6,0xdd9400da}},	//   _استراتيج, _fullaal_, _banyanze, _continuu_, 
   {{0x4c2503ba,0xadac00aa,0x9d0e0162,0x539c042d}},	//   _akaberer, _aronmada, _مۇشەررەپ_, _hanatanj, 
   {{0x3f2b01cc,0xa27f019d,0x1a6a0122,0xcc91017f}},	//   _manushya, _adanka_, _وفناوری_, _dollareq, 
   {{0x29e70145,0xfe9b042e,0xf8590420,0x7f780311}},	//   _басейне_, _sekundet_, _aguardar_, _ብዘጽደቖ_, 
   {{0xaac9001d,0x96cd00bc,0xd2e50321,0xaf4d0156}},	//   _verworfe, _budayani, _vrhnika_, _סיורא_, 
   {{0xf9fc042f,0xec7502f6,0xe70203a2,0x00000000}},	//   _hiqiniup_, _klaseng_, _मिदनापुर_, --, 
   {{0x7a5d034d,0xa6bc0249,0x8754034d,0x06d9005b}},	//   _diterima_, _bagarapi, _keuntung, _simpelth, 
   {{0x570c0061,0x904601b3,0xd27e0211,0x26440396}},	//   _레저스포츠_, _тематику_, _keinoa_, _edukatti, 
   {{0x4adf0089,0x3be501a1,0x3200002c,0x1a9801e7}},	//   _federats, _uiteraar, _amaia_, _artistes, 
   {{0x0d260430,0x02fc008d,0xf80d0086,0x041d03b4}},	//   _yorodane_, _samarasi_, _interjúj, _govaniso_, 
   {{0x39f602e3,0x5ef902c0,0x49530155,0xdc450244}},	//   _khuân_, _легално_, _emellert, _еврейска, 
   {{0x3e4701f9,0x6c710431,0x996a0432,0x9b1f0115}},	//   _bayahlup, _akersgt_, _revidere, _jimatkan_, 
   {{0x527f00dc,0x08620170,0x73b502c3,0x79e30205}},	//   _afanua_, _achosalu, _slovana_, _ботаман_, 
   {{0xc1890433,0x126c003f,0xc36f0084,0x00000000}},	//   _barangay_, _mamob_, _cangcut_, --, 
   {{0x29f50434,0x3ae902c9,0x324803ae,0xb15f0230}},	// [410] _comienza_, _невастэ_, _rammet_, _savreemo, 
   {{0xfc0a0342,0x515601d5,0x35c501f6,0x42480130}},	//   _ekipman_, _رائٹرز_, _আধাৰিত_, _sammet_, 
   {{0x088700ff,0xe9f90226,0x00000000,0x00000000}},	//   _זענטס_, _kukapere, --, --, 
   {{0x17090331,0x322d0397,0x76af020f,0x26820168}},	//   _skattaló, _abavusel, _baluluth, _lovendri, 
   {{0x815902c0,0xeaec029a,0x1a970435,0x637802e7}},	//   _насилств, _toulmonn_, _иринеј_, _kuwarta_, 
   {{0x225a038c,0xc27e00a9,0x8ea9032b,0x3341004b}},	//   _zemlju_, _mbonye_, _һәрмиллә, _lateloa_, 
   {{0x049b0037,0xa331000c,0x22f802dd,0x00000000}},	//   _ተስፋፍቶ_, _mosusũmb, _iskontij, --, 
   {{0x427e0034,0x32ee03da,0xf2fa0291,0x1e6d032d}},	//   _seinna_, _agafe_, _dhílseac, _болғана_, 
   {{0x214b002b,0x00000000,0x00000000,0x00000000}},	//   _এমপিথ্রি_, --, --, --, 
   {{0xde9b00ed,0x00000000,0x00000000,0x00000000}},	//   _bindings_, --, --, --, 
   {{0xa43a018d,0x22e5006f,0x027e0069,0xe83e0220}},	//   _ብወተሃደራዊ_, _kuingia_, _abonye_, _линка_, 
   {{0xec820265,0x23160436,0x63400058,0x723600d1}},	//   _lovefund_, _izaberi_, _eblebon_, _সন্দেহযু, 
   {{0x243d03d0,0x8ae7002b,0x3f2302e0,0x0ac901d9}},	//   _اسكندر_, _প্লাবন_, _bonelwan, _verwerfe, 
   {{0x1e9b0044,0x02d90415,0x275500d1,0x7c810167}},	//   _findings_, _lebens_, _অনুভূতিৰ_, _cardbord_, 
   {{0xa2b502d8,0x19d600c7,0xe20e0188,0xff140437}},	//   _sisca_, _басудан_, _нарав_, _hormoner_, 
   {{0x13eb023d,0xdbe000b3,0x00000000,0x00000000}},	//   _dietro_, _borekber, --, --, 
   {{0xedcd0092,0x83f8041e,0x00000000,0x00000000}},	// [420] _みんなの評価_, _beauf_, --, --, 
   {{0xb2d5036c,0x72bc00bd,0x196b0315,0xd2b50008}},	//   _fotoana_, _disdain_, _balinyat, _visca_, 
   {{0x42d50438,0x7d7b0439,0x0975003f,0x127f012a}},	//   _kuponya_, _anamanya, _chonobme, _zdania_, 
   {{0x13f4013f,0xc407006c,0xefd0002b,0xfc5c00bd}},	//   _boutin_, _баркро_, _শারফুদ্দ, _littlin_, 
   {{0xa9a60144,0xf2ea013f,0xe30200ab,0xe267002c}},	//   _اوريفليم_, _berniet_, _manapou_, _дебут_, 
   {{0x7f4f029c,0x526d013f,0x589301bd,0xc2130115}},	//   _chipolop, _aguok_, _батырлық_, _loghat_, 
   {{0x3290023b,0x938a00dd,0xfc7600b4,0x7cf30422}},	//   _aikane_, _annynol_, _lacrimi_, _ventilov_, 
   {{0x550701b2,0xc46c0024,0xfd790234,0x530e001e}},	//   _dihedral_, _বিপদত_, _kórogún_, _dubatar_, 
   {{0x427e020d,0xf2300316,0x2966008c,0x32a903e7}},	//   _ubonye_, _anambra_, _alpinave, _inowrocå_, 
   {{0xf27e0272,0x007e043a,0x2d8b0211,0x319f0061}},	//   _munne_, _eleblimo, _sekoitta, _엔지니스트_, 
   {{0x85f9018d,0xeb20023c,0x09f00204,0xb6260397}},	//   _ንሓባራዊ_, _angakumb, _rannalla_, _akholeki, 
   {{0x02fd0059,0xe341009a,0x02a700cd,0xf1c9004d}},	//   _viaggi_, _دنیاو_, _sieber_, _小宇同學就是我_, 
   {{0x91c60321,0x6c1f02bc,0x51d100e7,0xfc5100d3}},	//   _postopek_, _serampor, _agueplay_, _उपवेद_, 
   {{0xa27f01ac,0x4bd50046,0x62450299,0x9fd0043b}},	//   _teanga_, _музейге_, _تۆشەكتە_, _phaipeir_, 
   {{0xdc71003d,0xf96c043c,0x2f910005,0x23f400db}},	//   _avertit_, _brincade, _bandunar_, _kerttu_, 
   {{0x187d02d9,0xb248017c,0xd2fd0341,0x00000000}},	//   _agaifanu, _jimmie_, _kurgu_, --, 
   {{0x9c7d03f2,0x4aa20311,0xcee6005b,0xec5c00bd}},	// [430] _viestin_, _ስነፍልጠት_, _bodymake_, _kittlin_, 
   {{0xed0d026b,0x623a02b2,0x627e03f3,0xa30d004c}},	//   _нaвιт_, _прогнозо, _dunne_, _asibira_, 
   {{0xe788005e,0x5f3b038f,0x9f370416,0x1c2a0061}},	//   _مەھبۇبۇل_, _ankounac_, _georgica, _인천광역시의회_, 
   {{0x8d3c0365,0x827e03b0,0x4ae40165,0x138703ad}},	//   _velikost_, _funne_, _draunipe, _amerka_, 
   {{0x337200c0,0x00000000,0x00000000,0x00000000}},	//   _bayaang_, --, --, --, 
   {{0x1e45043d,0x60ae0040,0x6e46019b,0xc98a03ff}},	//   _melangga, _יורוליג_, _муніцыпа, _simča_, 
   {{0x437f018e,0x63050208,0x32ea01b4,0x529000e9}},	//   _arhamba_, _سوعاد_, _verniet_, _sikane_, 
   {{0xd27e042e,0x050d0013,0x42fd01f1,0x0b7f0080}},	//   _kunne_, _germaniy, _burgu_, _ecogreen_, 
   {{0xd3a203b6,0x0e48009a,0x650d004d,0x94760022}},	//   _aropin_, _شيمون_, _將貨品運送到其他, _процесы_, 
   {{0x0249001f,0xeda800ee,0x6c6602cb,0x8bf5043e}},	//   _atemmu_, _arriskua, _nastaju_, _excedenc, 
   {{0xd2ed031f,0x3d1800a4,0x5a9500bf,0xefe5041c}},	//   _typiske_, _جالبىراق, _десятках_, _elektoro, 
   {{0x0ea60388,0x3c7c03ba,0x03a20259,0x5c720287}},	//   _направи_, _oppress_, _dropin_, _चितुवाले_, 
   {{0x219500e8,0x51f7002b,0x3e3b00af,0xe27f0198}},	//   _ababekul, _উত্তোলনে, _kvinners_, _zmenki_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9f5d00d5,0xd3160396,0xcdd20297,0xcecd0187}},	//   _fitafian, _gonzi_, _balkanda, _autorais_, 
   {{0xf8450143,0xdc8a002b,0xfc7c02c9,0x56a8020f}},	//   _възторже, _নামধারী_, _chestia_, _دژغورنې_, 
   {{0x02920061,0x9a460135,0xec8a00d1,0xb6690013}},	// [440] _의미합니다_, _atletiqa_, _নামধাৰী_, _даргоҳид, 
   {{0xe3940240,0x18640161,0x8d1e0271,0xaed9010d}},	//   _monson_, _сервисам, _infoside_, _berimbas_, 
   {{0x5613035d,0xd287039f,0xdd9801c4,0x62d900cd}},	//   _narednom_, _biliary_, _seleksie_, _debels_, 
   {{0x19cc00a6,0xb8490037,0x205d02c0,0xb281000d}},	//   _ذهنیت_, _ክፍልፍል_, _правните_, _kuskile_, 
   {{0x83e700d3,0x247f01dd,0xfcbc03b0,0x8292043f}},	//   _výtok_, _bagezeho_, _ব্লগৰ_, _štali_, 
   {{0x7b150148,0x2277012b,0xf24800c3,0x6e1a0227}},	//   _地圖放大檢視_, _maksymal, _animam_, _kegemuka, 
   {{0xc8b900c5,0x726c0172,0x011c02d3,0x9a7e00e6}},	//   _第四十一条_, _damoa_, _куманово_, _还没有评论_, 
   {{0xfcb50440,0x73f80298,0x1224009b,0xee400441}},	//   _yaryakir, _kukume_, _azoka_, _uplatnit_, 
   {{0xbe450442,0xc2200010,0x02010016,0xdc1c0119}},	//   _gelangga, _atikasim, _vizitu_, _abaracos, 
   {{0x8a45004c,0x03f80099,0xd7e7014e,0xba7b01de}},	//   _ajeemera_, _eliud_, _хитлера_, _сәдібеко, 
   {{0x47090331,0x5e180185,0x6189014a,0xb9b40035}},	//   _skattalæ, _aspektla, _önbizalo, _алырбыз_, 
   {{0xf2ee0118,0xebe101d9,0xd40a0037,0x5a3e0089}},	//   _agafa_, _gewerksc, _የባለሙያ_, _башлаган_, 
   {{0x3d8300d6,0xe22b0177,0xbe170443,0x82e30158}},	//   _gaileara, _актиор_, _dipersoa, _reformy_, 
   {{0x9d4d0427,0x2899017d,0xc60f02ac,0x139501df}},	//   _aupayaaq, _インフォメ_, _ملتميديا_, _birse_, 
   {{0xd3f800ab,0x39e20148,0x9483002c,0x22910434}},	//   _aukume_, _matthaeu, _гепатиты, _encaje_, 
   {{0x2976042f,0x365e01cb,0xb34500e6,0xc7520444}},	//   _nalipkut, _yanikelw, _天津农业信息网_, _берлинер, 
   {{0x0aa60104,0xe2cb00fe,0x8c070170,0x62910040}},	// [450] _bebhayib, _aololoa_, _amathans, _scrap_, 
   {{0xb2f500d6,0xf35702cb,0x3acb023d,0x40440010}},	//   _laistigh_, _parfema_, _евгени_, _ingumfan, 
   {{0x02b000d9,0x6292039f,0x827e0022,0x8f860040}},	//   _здравоох, _dosage_, _econet_, _לסגירת_, 
   {{0x4e45034d,0x72b50445,0xbb1d00b8,0x925a0446}},	//   _pelangga, _risco_, _mantaña_, _prelog_, 
   {{0xcd3401f2,0xbe17038b,0x037f02d4,0x6b5c004c}},	//   _نېفىت_, _menerima, _fidanza_, _alimalir, 
   {{0xc3f8026c,0xd2c90265,0xa7890076,0x4c3400da}},	//   _aliud_, _tpholic_, _некого_, _localnic, 
   {{0x33fa014f,0x9333004d,0x43800037,0x00000000}},	//   _veruju_, _只有換個情人這件, _letrik_, --, 
   {{0xa27a02a2,0x7216003e,0x5b1f033d,0xadb9031a}},	//   _pamimili_, _террорға_, _eklatman_, _imrichea, 
   {{0x2d57027e,0xc3870044,0x308e00ff,0xc00c0074}},	//   _назван_, _nearby_, _טולבאקס_, _ускорени, 
   {{0xb340032d,0x89050006,0x33f2004b,0x8832005e}},	//   _akgelwa_, _menanggu, _boreneng_, _داخىل_, 
   {{0x80ce00b3,0x58e10447,0x9e5c0037,0x00000000}},	//   _bellenil, _azigogod, _የማሰልጠኛ_, --, 
   {{0xeb4203ab,0x1b0d0420,0xdc6d01a6,0x04400282}},	//   _doporuču, _производ_, _huirapa_, _kaikutik, 
   {{0x968f016e,0x905f0153,0xfeaa0147,0x5023020e}},	//   _istemedi, _一言メッセ_, _شىبىرت_, _kasetoro, 
   {{0x17ae0448,0xe9da018d,0x637902d4,0x127e0211}},	//   _forebygg, _ዝተታሕዘ_, _avantatg_, _meinaa_, 
   {{0x375d020f,0x6c7301d7,0x97eb0131,0x79fc008e}},	//   _andicing, _spartas_, _cristián_, _jamasant, 
   {{0x426e005b,0xe200005b,0xd5790041,0x32920449}},	//   _espoir_, _qmail_, _iñoficín, _dosade_, 
   {{0x79440151,0xb46b0074,0x52b500e2,0x6dad01c8}},	// [460] _adultere, _menestyk, _ansck_, _postavou_, 
   {{0x928b00a7,0xe2710046,0x319b0055,0x79b20291}},	//   _абамайда, _divideix_, _barcaiol, _ومتنوعة_, 
   {{0xa8470276,0xf440044a,0xa63f0144,0x7d9d019d}},	//   _паналиқ_, _elakisik, _cloisimi, _chilikha, 
   {{0x41c50190,0x95bf00f5,0x809100e6,0x00000000}},	//   _allegory_, _эсери_, _成龙获封韩流宣传, --, 
   {{0x325b0159,0xce0d0065,0xaa190187,0x00000000}},	//   _maloniai_, _vereinfa, _затајува, --, 
   {{0x28450299,0xa3ce0077,0x00000000,0x00000000}},	//   _ئۆتمەكچى, _ledven_, --, --, 
   {{0x451d01b7,0xbb0e025d,0xe9ef0416,0x3640000d}},	//   _upalabhy, _bergensb, _scritura_, _tekitami, 
   {{0x40dd0163,0x02900321,0xe6e60040,0xda190046}},	//   _گیلری_, _dejal_, _practici, _disculpe, 
   {{0x0032026f,0x165900b9,0xb15400ef,0xb27e0007}},	//   _ءقاۋىمدا, _प्रशासकी, _قراردادو, _afinga_, 
   {{0x9d2602fe,0xfb030361,0x42d40423,0x24a700e4}},	//   _akhokele_, _ветерана, _tvrdit_, _विभागाध्, 
   {{0x8bb8009a,0x730f0217,0x5c1f00ce,0x9dbd01bd}},	//   _abakumac, _apparer_, _konprir_, _باستاعان_, 
   {{0xf73002a0,0xcb9203a9,0x00000000,0x00000000}},	//   _iṣeyemej, _бортные_, --, --, 
   {{0x82f00142,0xab630034,0xb26c00bb,0xfc61003f}},	//   _श््री_, _andrifra_, _izmos_, _spirine_, 
   {{0x8ad401d8,0x84da0211,0x7923003d,0x00000000}},	//   _flattere, _войны_, _annadièr, --, 
   {{0x1952044b,0x31c503c2,0x029701f0,0x40bf0204}},	//   _billigst, _asperity_, _kerafiki_, _вставать_, 
   {{0x2b660322,0xb7f70397,0xdd17001c,0xaef5004a}},	//   _akorerwa_, _таппак_, _inprastr, _альбек_, 
   {{0x4b8b02fd,0x264c0381,0x00000000,0x00000000}},	// [470] _chunnair, _amendedw, --, --, 
   {{0x858e0135,0xef680420,0xa2870188,0x00000000}},	//   _predpriy, _medalhas_, _asikaze_, --, 
   {{0x5e03044c,0xee170006,0x67b100bf,0xb658021f}},	//   _foreldra, _penerima, _умственн, _ayikooni, 
   {{0xc3aa00bf,0xb3a301eb,0xe4b8020f,0x8eba0234}},	//   _второй_, _ipspe_, _توکمونو_, _owóyè_, 
   {{0x72d9025c,0x737a0306,0xa7b200c7,0x95030210}},	//   _arbeit_, _charinam, _алтайлар_, _chirairo_, 
   {{0x75e80242,0xf2d800c5,0xdb230138,0x2290044d}},	//   _dekabrın_, _publiez_, _yazamazs, _dikart_, 
   {{0x53030243,0x00000000,0x00000000,0x00000000}},	//   _tamahat_, --, --, --, 
   {{0x992700ba,0x81390060,0x19f80084,0x388d0177}},	//   _راپێچی_, _сайманда, _dibakute, _ndovalev, 
   {{0x80900125,0x6884006c,0x02480071,0x62f4026c}},	//   _азалдылм, _abakwaed, _رادیولوژ, _debitum_, 
   {{0x99f800bc,0xae6a0073,0xc2000275,0x66420280}},	//   _localset, _circumna, _femisa_, _गरुड़_, 
   {{0x36340176,0x73dc024a,0x50960220,0x8b38044e}},	//   _kvindeli, _asawo_, _членовет, _процесса, 
   {{0xe0280320,0x5c680059,0x557f024a,0xb3e500f8}},	//   _ekhwatin, _seguici_, _fọmula_, _অঙ্কুর_, 
   {{0xe378044f,0xf4100190,0x127e0082,0x0927034c}},	//   _manapun_, _itirurun_, _cunna_, _бирдең_, 
   {{0xac7c0066,0x33a900d7,0x22e20280,0xb5a80076}},	//   _abestia_, _embasing_, _दाधीच_, _загарант, 
   {{0xb88201ac,0x549301c8,0x9ec90046,0x3d8403db}},	//   _محبوبة_, _položil_, _branques_, _ukulwisa, 
   {{0x12ee02d0,0xe8cf041e,0xcb0c023d,0x82010288}},	//   _leafy_, _électeur, _consegna_, _edairi_, 
   {{0x4c740364,0xe2790024,0xe2df01da,0xc3fd0060}},	// [480] _bezuelt_, _পঠিয়াই_, _rajonet_, _мардымды_, 
   {{0xc7ee0091,0x1c71003d,0x9c6f03b4,0x027e0257}},	//   _atuagang, _exercit_, _amurova_, _runna_, 
   {{0xbbfc0028,0x7532027b,0x7296005e,0x1a080331}},	//   _گۯایل_, _amantray, _قانخور_, _neistanu, 
   {{0x7b7b034d,0xb9bf003b,0xda850060,0x42920450}},	//   _biasanya_, _bamemete, _تۇرمىس_, _boskjes_, 
   {{0x7e340451,0xb99703a4,0xbfe90452,0x00000000}},	//   _belaelwa, _herheima_, _चाणाक्ष_, --, 
   {{0xc2b50197,0xc24a02d9,0x256d01d2,0xb620019b}},	//   _koodone_, _atumau_, _atijkamy, _senovini, 
   {{0xec6a02d5,0xed8800c3,0x4a6f003e,0x720002d9}},	//   _गुड्डू_, _ascendit_, _disfajia_, _pemita_, 
   {{0x0e440315,0xc6280044,0xc4b900d7,0x730100ad}},	//   _angakafa, _derivati, _магазины, _kosambi_, 
   {{0xb35d016e,0x8bdf00a4,0x5cfc0152,0xed970045}},	//   _dileriz_, _cohesió_, _каберенә_, _verenice_, 
   {{0x330802a0,0xfc31002b,0xde4d0353,0x00e802c9}},	//   _adebayo_, _একাউন্টে_, _golfové_, _parintel, 
   {{0x204a0080,0x629101cd,0xb29100a9,0x8780005b}},	//   _akornann, _encane_, _bicaye_, _lykkelig, 
   {{0x82da018b,0xa4010453,0xd9bf02b0,0x1f7e0256}},	//   _curent_, _pronalaz, _bundesge, _kombains_, 
   {{0xf30d012d,0xd50800e6,0x42ff009a,0x427f025f}},	//   _imobeta_, _创新发展模式_, _استعفي_, _elengi_, 
   {{0x524a0454,0xa3780285,0x29940082,0x02ee002a}},	//   _agumye_, _ingamba_, _turkiyya_, _ngafe_, 
   {{0x12920252,0xb2da0455,0x637b014b,0x1c51008b}},	//   _tswayo_, _furent_, _tamahim_, _kontara_, 
   {{0x92b50092,0x97ed0134,0xb224019e,0x92000049}},	//   _bisca_, _lọwọlọwọ_, _šokis_, _omaii_, 
   {{0xf27f0291,0x16870260,0x38610061,0xa7c801ff}},	// [490] _beanna_, _anteprox, _국가를당사자로하, _zaisteni, 
   {{0x42900456,0x55830067,0x7eb0010d,0x00000000}},	//   _rejab_, _haadhash, _catridge_, --, 
   {{0x38880245,0xb36401d4,0x6dc60457,0xa2920455}},	//   _bakhatdu, _aragona_, _fokkaaqa, _lisant_, 
   {{0x697a024c,0x0b7d0313,0x2e3a0261,0x00000000}},	//   _ghandnie, _ngillahc, _briletis_, --, 
   {{0x77840193,0x1b0d0309,0xa8c400d1,0xdf390458}},	//   _प्रासंगि, _verginin_, _eikeland, _granater_, 
   {{0x067b0037,0x45120062,0x56c000e1,0x00000000}},	//   _መናኸሪያ_, _ludoqmoh, _mbebetum_, --, 
   {{0x4f050459,0x237800ea,0xaf86000c,0x9542003b}},	//   _प्रेमचंद_, _angamba_, _ajánte_, _alikabuy, 
   {{0x37bc02c7,0xd813004a,0x00000000,0x00000000}},	//   _beleidig, _berlinğa_, --, --, 
   {{0xfaf30169,0x12fc025c,0x332e0156,0x4f2c0347}},	//   _ক্ষেত্র_, _jungen_, _מוזיעם_, _allermin, 
   {{0x51cf00da,0xe69d045a,0x22920047,0xb28300fe}},	//   _адаптат_, _langvari, _disant_, _kaikoaa_, 
   {{0xcc000036,0x384a045b,0xa29e02d6,0x97a50156}},	//   _feistis_, _бочки_, _чилар_, _וואלאווע_, 
   {{0x45a500c4,0x75b50162,0x8be801cd,0x46f2004b}},	//   _منصوبابن, _отурисид, _abawagib, _diraftjw, 
   {{0x28320192,0x0a2001f7,0xc2900392,0xb7200061}},	//   _잊으셨나요_, _eficacit, _dolair_, _신고하기를_, 
   {{0x14450162,0x95b40163,0xe18c00cb,0x688d0032}},	//   _باشقىچە_, _techniká, _ababehol, _chavchug, 
   {{0x820e0066,0x9a76045c,0x83110199,0xe27f01da}},	//   _бараг_, _značne_, _topcare_, _blendi_, 
   {{0x9f2a00b5,0x22fc0155,0xa97a0142,0x488703b8}},	//   _amerikap, _kungen_, _avaivart, _таразда_, 
   {{0xef3c00aa,0x295c0194,0x6349045d,0xf2ca0311}},	// [4a0] _basuraha, _galogist, _poreski_, _ክተምስዩ_, 
   {{0xf43901b3,0xef250310,0x91b900da,0x00000000}},	//   _наприкін, _characta, _термень_, --, 
   {{0x23f100ee,0xc8b7045e,0x82fc0195,0x5c790053}},	//   _мөртлөө_, _призна_, _bhagh_, _prospek_, 
   {{0x0a6c02e2,0xf292045f,0x424a0460,0x60f50235}},	//   _aramaais, _insatt_, _केनेडी_, _असुराः_, 
   {{0x7f480340,0x99090024,0x12f302e4,0x92c902d5}},	//   _ringarin, _সৰলীকৰণ_, _ilbistu_, _praegugi_, 
   {{0x51a500b6,0xe0c10206,0x3c070461,0xf06e02c0}},	//   _fereeytá_, _mikrofón, _bóstia_, _хронични_, 
   {{0x664400ff,0xee3601d8,0xf5bd0076,0xe5cb0010}},	//   _קאָסטן_, _sangakka, _encaminh, _iphasiph, 
   {{0xe2920009,0xbc5101ab,0x7a58033f,0xe5210462}},	//   _pisave_, _चलतइन_, _kelesiia_, _autoplay, 
   {{0x6bb201f0,0xaf1900e6,0xd2d8010d,0xa35f0035}},	//   _bothitho_, _尚不构成犯罪的_, _sohee_, _афинага_, 
   {{0xb2e60239,0x640a01d3,0x429200e6,0x8e4803dc}},	//   _huangia_, _syriansk, _visant_, _avlamisp, 
   {{0xf7e50463,0x53f80275,0x651c023e,0x02c1030a}},	//   _पर्यावरण_, _alaua_, _ازجمله_, _silleda_, 
   {{0xeb420300,0x769e0013,0x37680212,0xcd03034f}},	//   _doporuče, _мовароун, _winxmedi, _ahambile_, 
   {{0x34130162,0xd9dd0178,0x6c1702c4,0xccc60291}},	//   _ماڭدى_, _amitadyu, _правел_, _بانفجار_, 
   {{0x9242009a,0x52d5006a,0xd3890037,0xd619005d}},	//   _سهیلی_, _potoana_, _አፍጋኒስታን_, _анииҭоз_, 
   {{0x79d20074,0xc27f0233,0xff9d01f3,0x00000000}},	//   _tallenna_, _plendi_, _borelióz, --, 
   {{0xd33d03ce,0x8af201c5,0x8afa0208,0x4312019a}},	//   _هیشام_, _horreeye, _بونیادی_, _doobles_, 
   {{0x5c5a018b,0x51e901f7,0x5605012c,0xf6d100ea}},	// [4b0] _sunteti_, _arrondim, _inamaani, _fambolem_, 
   {{0xbc4c00da,0x02da0055,0x927f01ac,0x43fa01f1}},	//   _комитету, _turnate_, _meanma_, _mesues_, 
   {{0x727300be,0x67dc01ad,0x40130178,0x32920464}},	//   _اتەيىست_, _hydropow, _anunayām, _gisate_, 
   {{0xdc590212,0xf57202e7,0x68f60014,0x7cbe006c}},	//   _menumsg_, _ebidensy, _kompaniv, _кашем_, 
   {{0xab6b01b4,0xcda300da,0x013503a4,0x00000000}},	//   _renoster, _формаря_, _gandakal, --, 
   {{0x06950126,0x8a1e00cf,0x1e390343,0x4e95002f}},	//   _чудово_, _baaburaa_, _kahawura, _furmayan, 
   {{0xcdc8029d,0xb3950079,0x3f7f02d7,0x56460465}},	//   _викиману, _mirst_, _ámbolos_, _užitkom_, 
   {{0x338702ce,0x865f03db,0xbfc80466,0x28020361}},	//   _ngarah_, _bafikelw, _knjižara_, _редакцис, 
   {{0x322a02cf,0xe3000369,0x3a2002c6,0x4c51023a}},	//   _домат_, _makalei_, _atabaske, _dietata_, 
   {{0xd1540467,0xf224021c,0xdeb003b4,0x73e40083}},	//   _kristoso, _kroky_, _amboshan, _pretendi_, 
   {{0x33f4037c,0xdb7b00f3,0x62f9036e,0x1b2d012c}},	//   _icstis_, _bamshiya_, _askhata_, _kinachos, 
   {{0xad3b018b,0x0fe400d1,0xd2260418,0xf8530230}},	//   _vehicule_, _আইনমতে_, _katkı_, _komanter_, 
   {{0xa2fc010d,0xf91200b2,0xf4b10195,0x8290009b}},	//   _chagi_, _dabaanku, _litireil_, _neban_, 
   {{0x22da030f,0xe2c903dd,0x3e480282,0x381600ec}},	//   _aurere_, _sondazhi_, _kamapene_, _гатэлі_, 
   {{0x530b0178,0x725b00cd,0x1290028a,0xfe860013}},	//   _aśanir_, _amalà_, _sakafu_, _кетказиш_, 
   {{0x427e0174,0xc2da012e,0x32fc00bc,0x459d005a}},	//   _bunne_, _keress_, _mengko_, _dangepch, 
   {{0xeb9d0468,0xb33a00da,0x52da018b,0x40d80361}},	// [4c0] _akanakho_, _провинчи, _durere_, _араяьлле, 
   {{0x744c019c,0x7323033c,0x22fc001d,0x0bf50434}},	//   _alajumok, _carchar_, _anighi_, _excelenc, 
   {{0xe49a0169,0x730000a5,0xe2bb033f,0x69880137}},	//   _নিশ্চয়ই_, _fakalei_, _kumetee_, _мэдхэд_, 
   {{0x627e00db,0xcdf4029d,0x2949032d,0x3058025e}},	//   _tunne_, _класикэ_, _ватаныбы, _unnarsso, 
   {{0x12900027,0x77a302c3,0xc20e0137,0x00000000}},	//   _geban_, _žarnovic, _тарах_, --, 
   {{0x74860105,0x22130205,0x904701d4,0xb32302bd}},	//   _घटनाओं_, _водийси_, _acqualon, _garchar_, 
   {{0x323d0125,0x82c201a4,0xe3f401fe,0xe99802ce}},	//   _бөлүмиди, _amelisa_, _drutia_, _ngayakeu, 
   {{0x31a9011d,0x62da02c3,0x44d7034c,0x3aca016f}},	//   _аранжаме, _strede_, _табасың_, _кадастро, 
   {{0x82000245,0x0dc300ad,0x897c028a,0x53f201bc}},	//   _iwbih_, _kawijaka, _آزمائڻ_, _bibletek, 
   {{0xe8fb0178,0xe55601c7,0xfe630089,0x00000000}},	//   _agrapuru, _гутулмаг, _ихтиозав, --, 
   {{0x282e00bf,0x8e5203e4,0x52da00f9,0x12fc02fa}},	//   _условиях_, _aqhanaka, _turere_, _akaga_, 
   {{0xba2d02fe,0x43ba03ea,0x73ea0148,0x5aef0223}},	//   _ولیده_, _brevets_, _exitu_, _ardoaren_, 
   {{0x6eaf034b,0x00000000,0x00000000,0x00000000}},	//   _kalomuan, --, --, --, 
   {{0x43ea0125,0xc2ea033d,0x82fc00e9,0xdc1f01c4}},	//   _wektor_, _afriken_, _bengko_, _gerappor, 
   {{0x55340469,0x7cc601b3,0x230c008a,0x28b7023a}},	//   _छन्दशास्, _вибране_, _morakot_, _smotanov, 
   {{0xbc5a00b8,0xdf8a041a,0x596e03f1,0xeff200ba}},	//   _muntati_, _заборони, _spresňuj, _لێدانێکی_, 
   {{0x37e800a4,0x731d046a,0x72f50148,0x69730258}},	// [4d0] _encarreg, _seccion_, _meritum_, _aktifykt, 
   {{0x1f550299,0x00000000,0x00000000,0x00000000}},	//   _ئېدىرلىق_, --, --, --, 
   {{0xb47e01c5,0x82ef0365,0x43ea026c,0xb2fe01cf}},	//   _agagaark, _užijte_, _montem_, _occider_, 
   {{0x1c6b0057,0x99a600ff,0xb2ee006a,0xbe9f015e}},	//   _በአባቶች_, _טשעכאסלא, _afify_, _cerimòni, 
   {{0x436c042a,0x6e9e0211,0x84b5028a,0x00000000}},	//   _bengati_, _балла_, _kusanyik, --, 
   {{0xb249041c,0x84030090,0x9fcd0086,0x03f80034}},	//   _anamam_, _akandinz, _tutilapo, _flaug_, 
   {{0xb35100f1,0x7690046b,0xa10802b4,0xa27d0318}},	//   _konfirm_, _integrei, _bakhulul, _ngangahi_, 
   {{0xb8fb0058,0x12da02ee,0x593a0075,0x32fd0349}},	//   _donaklad, _peress_, _tilmelda_, _avorflay_, 
   {{0x42da00e1,0x26c600ff,0x16a9022b,0x76270113}},	//   _adrees_, _זינקאוו_, _byggingi, _ambasadó, 
   {{0x5dd701ea,0xb24d0017,0x279e0014,0xc55f02b9}},	//   _матбуот_, _बिमला_, _forumivi, _postaköl, 
   {{0x0e8b0036,0x0bfa020f,0x93ea01bf,0xda170137}},	//   _لستتي_, _akunanto_, _vekter_, _баазтай_, 
   {{0xc0b9032b,0x00000000,0x00000000,0x00000000}},	//   _دۇردانىل, --, --, --, 
   {{0xf9600158,0x730c00a7,0x5b7e021b,0xcc7403e6}},	//   _मायनों_, _gegants_, _energiaa_, _gerullt_, 
   {{0xcbe40059,0xd28e016a,0xb4d7027b,0xef22022c}},	//   _affermar, _asekuro_, _गरुडध्वज, _digusura, 
   {{0xd2ba0132,0x2f230243,0xa9f90025,0x840e0371}},	//   _eredeti_, _celeeman, _arcimena_, _orificio_, 
   {{0x2d8b01bb,0x815e00ce,0x2b7a018d,0x8f2e02c7}},	//   _meselede_, _vwazinaz_, _ዘጸናናዕኩሙና_, _scheidun, 
   {{0x71d10381,0x70eb0086,0x23ea0157,0x00000000}},	// [4e0] _arvelmay_, _strandok_, _kontem_, --, 
   {{0x8dfe014e,0x712901e0,0xe2a20040,0x2631008b}},	//   _neverova, _بولبولی_, _אקוסטי_, _callalew, 
   {{0x32d401df,0xd4690388,0x8c280420,0xdfbf0349}},	//   _feudal_, _логиката_, _monetári, _eculatio, 
   {{0x0f270101,0x0b7f0061,0x00000000,0x00000000}},	//   _corespon, _인정한다면_, --, --, 
   {{0x62990409,0xb2ba00b4,0xad200307,0xaf500234}},	//   _アウトドア_, _credeti_, _iphindwe_, _olókó_, 
   {{0xdc770060,0x604c02ab,0x28f50041,0xd6ce0462}},	//   _ءبىرىمىن_, _amaramon, _ифҩыс_, _ampaigni, 
   {{0xb1870299,0x81b50147,0xeb6b013b,0x0ad90156}},	//   _гуантама, _primària_, _affolter, _אינדיאַנ, 
   {{0x0364013e,0x84fb00db,0x9b94004c,0x0aee02c6}},	//   _dragana_, _किरानी_, _anjiggir, _breutade, 
   {{0x827c01a4,0x2e45032c,0x4c9b01e8,0x00000000}},	//   _azangaki_, _angalaga, _hinganad_, --, 
   {{0x056d0163,0xf387022e,0x5af4023e,0x00000000}},	//   _داستانوں_, _aleria_, _boyongan_, --, 
   {{0xf6ce02fa,0x0d770285,0x9319046c,0xb4100437}},	//   _rutagani, _ifumbire_, _hübsch_, _fryseren_, 
   {{0xdebe023e,0xf2fd0120,0x92e902ec,0x0da40205}},	//   _pangurus_, _liqinit_, _marinta_, _havolala, 
   {{0x94250192,0xbe430061,0x527f03dd,0xf0200005}},	//   _반도보라스카이뷰_, _실험보고서_, _seanca_, _dapertuo, 
   {{0xb27e046d,0x47cd00d9,0x51770093,0xe3bc0405}},	//   _munna_, _helsinki, _черты_, _потребую, 
   {{0x8d850310,0x02c30272,0x2b7702c1,0x484002fd}},	//   _chultara, _amulaba_, _amarenga_, _fairleus_, 
   {{0x86a6041e,0x27730056,0xf202013f,0xbf5f0349}},	//   _ringrazi, _доллари_, _tiriad_, _antation, 
   {{0xab1802e1,0x5c5c046e,0x527e0036,0x74170066}},	// [4f0] _هههههههه, _बिशेष_, _gunna_, _definitz, 
   {{0x45d3046f,0x3eb601f1,0x360501e1,0x00000000}},	//   _clickety, _mbarimit_, _khampani, --, 
   {{0x8b1201e1,0x3bb900d9,0x213f0365,0x6a520414}},	//   _эммануэл, _железа_, _कमिटीमा_, _komemela_, 
   {{0xd0bf018d,0x4e970207,0x027e00b2,0xc50a006e}},	//   _ተገይርሉ_, _سانجهه_, _bunna_, _ganeegul_, 
   {{0xe27e0107,0x46b9006a,0x49d703bf,0x95b901b9}},	//   _nginep_, _kalandri, _behehile, _kalandry, 
   {{0x227e01d7,0x2f95029a,0xe05202ac,0x42cb0321}},	//   _dunna_, _konvenab_, _hidrigin, _sledim_, 
   {{0xdc430282,0x19900094,0xd288000a,0x434d00d8}},	//   _hāwini_, _تەلەديدا, _ammanani_, _asperam_, 
   {{0x97de028b,0xea400080,0x427e0305,0xa3f80166}},	//   _cemproni, _algeriap_, _funna_, _blaue_, 
   {{0x32fd043b,0xf26c0226,0x727f004c,0x986c0372}},	//   _thairis_, _symon_, _afanga_, _aseiniad, 
   {{0x1b02037c,0xc3f8014d,0x5d5a014e,0xff070026}},	//   _prosolut, _glaub_, _дочек_, _functies_, 
   {{0xb9d2008f,0xa49d00d5,0x39cd028d,0xf2540167}},	//   _tallinna_, _fanavaoz, _leternit, _atalnodi_, 
   {{0x2c7e02e7,0x9ef90145,0x827e021a,0xa387000a}},	//   _bersyon_, _задымлен, _bunni_, _anersa_, 
   {{0xd27e004e,0xd38703f7,0x629201b6,0xa2e9000b}},	//   _sconce_, _snerta_, _unsafe_, _mariota_, 
   {{0xe7a30235,0x4bfc0347,0xb7d6004b,0x527f0156}},	//   _gandharv, _vergader, _елкендер, _aganta_, 
   {{0x0962020a,0x86d3026e,0x801b03cf,0x82900386}},	//   _деректер, _स्लिम_, _girdiniz_, _kejam_, 
   {{0xc5a20038,0x80a0015e,0xc27e019c,0x2b420300}},	//   _başlığı_, _адамзатт, _funni_, _doporuči, 
   {{0x80200375,0xe2ea017e,0xc9690299,0xb3470059}},	// [500] _agawiran, _opiniis_, _تذرسذن_, _ginevra_, 
   {{0xc27e0470,0x52cb001d,0x77c900dd,0x9f9c0139}},	//   _nginza_, _ifadvt_, _brasluni, _ayoniśom, 
   {{0x12900471,0xdab8034c,0x5e95026c,0x82e9000b}},	//   _sebab_, _allahunı_, _continet_, _kariota_, 
   {{0xcc7c022c,0x437c039e,0xfb7400b5,0xa2da0198}},	//   _biasana_, _levande_, _añorairõ, _strehe_, 
   {{0x52920472,0xcc93005e,0xc2010341,0x0e440322}},	//   _disaat_, _تامان_, _gidiş_, _bakanafa, 
   {{0x13e80026,0xa3f802a9,0xf2b50119,0x921c01db}},	//   _태터데스크_, _plius_, _aisch_, _جياباۋ_, 
   {{0x52d6035b,0xa60d02bf,0x40b200f8,0xb3b1013a}},	//   _podobno_, _kubomasi, _বাড়লো_, _mouveco_, 
   {{0xfc6c02da,0x937f0135,0xd30200f6,0x0c7c00d5}},	//   _компилац, _almania_, _cavadov_, _fiasana_, 
   {{0x22b50083,0x32900076,0xe316028a,0xa25a01e7}},	//   _disch_, _vejam_, _sinza_, _hallew_, 
   {{0x323801b8,0x3f37006c,0x55b301f4,0x69830234}},	//   _inimesi_, _akhulula, _қондаги_, _o̟wó̟_, 
   {{0xd2000189,0x9047006c,0x42b50473,0x1ba902d5}},	//   _makine_, _юшенко_, _fisch_, _matkatar, 
   {{0x4c5201e7,0xaeff00fa,0x52fa0170,0x00000000}},	//   _contern_, _balwarte_, _kuchita_, --, 
   {{0x5f7400d1,0xcc6e00fd,0xd2920222,0xcdb20094}},	//   _অনুযায়ী, _beirinn_, _disait_, _تەنتەگى_, 
   {{0xd37f0474,0xd6b800c4,0x424801eb,0x5b7d003d}},	//   _ishamba_, _سبجيڪٽ_, _imomba_, _barròca_, 
   {{0xa9c7022f,0x01ca01b3,0x99da0170,0x00000000}},	//   _лапата_, _принижен, _kubereke, --, 
   {{0xe2ea02db,0xa27e01c9,0xd6ce0475,0xe2d9002b}},	//   _agrimen_, _tunni_, _подведом, _arboles_, 
   {{0xa37c0059,0x00000000,0x00000000,0x00000000}},	// [510] _bevande_, --, --, --, 
   {{0x6dbd018d,0x929002a5,0x5a5000d7,0x12800077}},	//   _ብተጋዳላይ_, _nejak_, _айтуған_, _fleksib_, 
   {{0x9aa70148,0x04a80169,0x7b7a019d,0x23eb007f}},	//   _民俗扯鈴小舞臺_, _সমস্যায়_, _akasanza_, _apathi_, 
   {{0xd28300cf,0x52d901fc,0xb053037c,0xdc750066}},	//   _bekkama_, _maaluuy_, _appropin, _gaurtik_, 
   {{0x6c060241,0x6290017d,0xf2900304,0xe5a80187}},	//   _biissau_, _oplagt_, _rejam_, _развивањ, 
   {{0x02900076,0x037b016e,0xb60f01a3,0xb5d400f8}},	//   _sejam_, _ayarlanm, _وڻجارن_, _স্তনবোমা_, 
   {{0x805f00ee,0x4aa7010d,0xfd3f03d5,0x00000000}},	//   _poliziak_, _पृथ्वीला_, _cabhorse_, --, 
   {{0x7db90133,0x2c29004c,0x3f4c0421,0x437601e1}},	//   _beenisha, _alupakus, _neuseela, _блоггерҙ, 
   {{0xfdaa03ef,0xa2d8025c,0xdff102f9,0x1b5e021c}},	//   _mudugudu_, _hohem_, _direktč_, _depilačn, 
   {{0xe2f10244,0xe3000476,0xa2ff02ca,0xcb530187}},	//   _diritti_, _nemazai_, _radharc_, _генерале, 
   {{0xfc1e018d,0x4d020477,0x8d990478,0x4321005b}},	//   _መንግስቶም_, _shalawat_, _autocefa, _eigyou_, 
   {{0x0279045a,0x1ea100db,0xf3d401fd,0x6b010166}},	//   _foreslår_, _sportnet_, _reemplaz, _geistige, 
   {{0xd29e02c5,0xf18403db,0x7169041e,0x7486008f}},	//   _akajeka_, _bayabahl, _physiono, _दुखावल_, 
   {{0xd5d5009c,0x220003e6,0x49f3013f,0x62d10479}},	//   _altarniy, _kuliss_, _borujerd, _kétágyas_, 
   {{0x9ef4018d,0x3292019a,0x57de0157,0x43550222}},	//   _ላዕላዋይ_, _biskets_, _दिनदहाड़े_, _emmener_, 
   {{0x14a801f6,0xd29500a9,0xa10200d9,0xd4130105}},	//   _সমস্যাৰ_, _turashim, _страшный_, _logistyk, 
   {{0x072a0238,0xe3450034,0xf28d0235,0xe394005b}},	// [520] _приватни, _myndast_, _anipphal, _vokset_, 
   {{0xa2d9047a,0xf69500b3,0x627e024a,0x22da0217}},	//   _egzers_, _gazetini, _dunnu_, _furnate_, 
   {{0x2291038d,0x9353004d,0xeb770322,0x52fc010d}},	//   _lezan_, _其實人生本是一種, _amaranga_, _keriput_, 
   {{0xaf0f0319,0x827e047b,0xaab30025,0x7d7c0296}},	//   _cercanos_, _funnu_, _ज्योतिश्, _formellt_, 
   {{0xbab30025,0xeb9a012b,0x027e000d,0x9268003a}},	//   _ज्योतिष्, _ओर्गास्म_, _nunnu_, _дебюти_, 
   {{0x3b9e03f6,0x2392004d,0x63ea0187,0xe379037b}},	//   _keoneoio_, _我走上同一條街_, _contam_, _ganando_, 
   {{0x7ee7003a,0xd2e7047c,0x8b750041,0x22ee0210}},	//   _маматов_, _granvin_, _лызлак_, _atendai_, 
   {{0xd27e03a4,0xc290047d,0x5d910101,0x727e00ae}},	//   _kunnu_, _gebai_, _utilizea, _iconge_, 
   {{0x4262004b,0xe98902ea,0x47e30188,0x61700203}},	//   _bayoloji_, _richiede, _мобилии_, _opositio, 
   {{0x32790024,0xcab30025,0x11e0008b,0x020100ac}},	//   _পঠিয়াব_, _ज्योतिस्, _infirmié_, _kacige_, 
   {{0xc29101c2,0xad8403a2,0x5231027f,0x5ad103fb}},	//   _ameaza_, _लिथोग्रा, _inimero_, _formiran_, 
   {{0xaef20219,0x2343023d,0x9daa019c,0xbae50166}},	//   _akakavun, _esterno_, _gudugudu_, _heiligen_, 
   {{0x4dc00292,0xe598018d,0xe06d01a6,0xd1610478}},	//   _teokrase_, _ተገንዘቡ_, _matawhao, _arbrilho, 
   {{0xc9d4047e,0x32e600bd,0xff38047f,0xd2da02be}},	//   _umiestne, _stinkin_, _वाहियात_, _bernabe_, 
   {{0x63ca0229,0xb3050156,0x519e0021,0xd2780397}},	//   _atları_, _albanoj_, _asebosay_, _домангир_, 
   {{0xc2b30016,0x015b0360,0x1dfb0422,0x00000000}},	//   _soldato_, _agentury_, _čudovit_, --, 
   {{0x0e5902ec,0x3ff30160,0x1316030a,0xb3200316}},	// [530] _shabelle_, _predlaže_, _xinzo_, _awoyi_, 
   {{0x827e03a4,0xcf3b01db,0xadff00ba,0x62010014}},	//   _vunnu_, _اتاۋلارى_, _بدۆڕحمان_, _emaili_, 
   {{0x643603b4,0x21470244,0x305302ca,0xe84700e5}},	//   _akahusik, _написах_, _لانسر_, _намалиш_, 
   {{0xe290043d,0x61ba035f,0xbd2902f0,0x627e021b}},	//   _sejak_, _मध्यकाली, _asesemnc, _tunnu_, 
   {{0x123a02c3,0xc9e602f3,0x75200421,0x8d9f027f}},	//   _dôjde_, _kidnappa_, _brandsch, _ndongora, 
   {{0xcb880125,0xcb5901ad,0x785c0230,0x62000320}},	//   _аладалан, _havlíčků, _latanier_, _hakile_, 
   {{0x7fba037c,0x00000000,0x00000000,0x00000000}},	//   _tumultus_, --, --, --, 
   {{0x0368028b,0x500902ea,0x4ec10229,0xb47703f3}},	//   _абаза_, _заминава, _brazilya, _waterkok, 
   {{0x451d0480,0x44380061,0xd15c004b,0x99dc02c7}},	//   _akunakuy, _상하수도사업소_, _аулай_, _alufelge, 
   {{0x18430192,0x8bce02ec,0xa94200c4,0x8a640193}},	//   _하였습니다_, _یۅہَے_, _بحيثيت_, _टेक्निकल_, 
   {{0xb3660016,0x02ea0288,0x739e027f,0x2aea03a4}},	//   _אינדעקס_, _burioun_, _birarinj, _vesturle, 
   {{0xdd3901ef,0xf9530022,0x72410041,0xc1a40376}},	//   _папулярн, _аждаһа_, _hĩlandia_, _barndóms, 
   {{0xac37002b,0x126e00ea,0xca8d019b,0xb2e701df}},	//   _হৃদয়ের_, _hitory_, _спатрэбі, _grantin_, 
   {{0x21e100d6,0x91750268,0xac5a013d,0xe2920464}},	//   _cruinniú_, _agentway_, _pretigi_, _bisate_, 
   {{0xa0b70022,0x0287034f,0x020002f7,0xb26c0217}},	//   _инвалиды_, _دفساد_, _bakile_, _penose_, 
   {{0x426102ee,0xb2ee0316,0x00000000,0x00000000}},	//   _additivi_, _haife_, --, --, 
   {{0x5fd5040b,0x59e601a7,0xe201037f,0x23ce013f}},	// [540] _ndangulo, _мастера_, _meyiti_, _delvan_, 
   {{0x30600390,0xb2ed01ec,0xc3f80481,0xad3001c2}},	//   _prosesin, _استودیو_, _blauw_, _subscric, 
   {{0x47df0100,0xee950094,0xc3ea0482,0x827e024a}},	//   _ponašaju_, _ادامنڭ_, _kontom_, _iponju_, 
   {{0x53dd0242,0xeec4004a,0xb04d0118,0xf2fc01b6}},	//   _qulluqçu, _alınu_, _amagombo, _extinct_, 
   {{0xde0e00e5,0x9f520017,0x49840012,0x915f013b}},	//   _verdinha, _प्रकाशनह, _कलामंच_, _asosasyo, 
   {{0xab0d034a,0x84c50483,0xe98901af,0x00000000}},	//   _funcións_, _híbridos_, _dmitriý_, --, 
   {{0x2f7903b2,0x48630192,0x4e0e013d,0x7ea00259}},	//   _problems_, _문화관광과_, _tradicia, _bortvist_, 
   {{0x22ef0085,0xc4860255,0xb282019d,0x00000000}},	//   _sakiusa_, _प्राते_, _kakhumi_, --, 
   {{0x00e801c4,0x87cc0326,0xdf3500a3,0xc2760226}},	//   _skriftel, _evashumi, _brosjyra, _kumanyum, 
   {{0x52da03ba,0xd3f902d9,0x1c1800d9,0xc487004d}},	//   _orreat_, _feausi_, _произвес, _香港服務提供者和, 
   {{0x2d4e003a,0xc2d90119,0xf5cc010b,0x28a30089}},	//   _самарали_, _deped_, _dikakany, _русларда_, 
   {{0xdc610313,0x23dc0202,0x53230046,0x00000000}},	//   _narurma_, _rilwan_, _delcamp_, --, 
   {{0xcfa50205,0x0290009d,0x464b0193,0x8d3d00f5}},	//   _موقعی_, _islame_, _menyerah, _сайлайшы_, 
   {{0x7d900294,0x3c5103b0,0x159a021c,0xee6803f4}},	//   _alituyqu_, _samtida_, _schránko, _снасти_, 
   {{0xf5290014,0xb5e90135,0x728c00f4,0x00000000}},	//   _eksploro_, _garantı_, _fonkion_, --, 
   {{0x04fb0255,0xc2c20102,0x82ea0064,0xa53c026b}},	//   _किसानी_, _taaluma_, _айлампас, _dispongo_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [550] --, --, --, --, 
   {{0xf34802e4,0xa3220278,0x4d1f012c,0xe5aa018d}},	//   _lineari_, _opsyen_, _مسجدون_, _ሽቱትጋርትን_, 
   {{0x0d850484,0x331c0035,0x8604007e,0xf29c004d}},	//   _अलौकिक_, _adresı_, _ayamihai, _半年聚集過億人氣_, 
   {{0x9d2702ca,0x74260331,0x72e901a6,0xdaa7019b}},	//   _مهرجان_, _torshavn_, _hariata_, _занадта_, 
   {{0x725a0485,0x0d870180,0x97ab00b5,0x9aec0138}},	//   _fortælle, _akselere_, _акризис_, _neredeys, 
   {{0x635401d1,0x3b9701fb,0xa40402a6,0x684600af}},	//   _moments_, _filiastr, _abundanz, _рисунку_, 
   {{0x2abe018b,0xc1500040,0x6ef8018d,0x68950064}},	//   _диалогэм_, _הצבאית_, _ተጸንቂቑ_, _conjuntu, 
   {{0xbfd80092,0xb7a100bb,0xe63000b4,0x6c010486}},	//   _セキセイインコの, _اشکبار_, _aparatul_, _cemstar_, 
   {{0x3e77016d,0x7c550487,0x03900061,0x80c50061}},	//   _ساندان_, _voltage_, _반품규정이_, _공급업체의_, 
   {{0x857502df,0x8d5300df,0x636e0208,0xa9890039}},	//   _mendedah, _romantiq, _فڕینی_, _хазаарла, 
   {{0x58b100b7,0x424601c9,0xee6e0488,0xe29002ff}},	//   _sözdür_, _कटाले_, _manipulā, _nebat_, 
   {{0x7b2402ec,0x4fcd009a,0x00000000,0x00000000}},	//   _garanays, _المالیکي_, --, --, 
   {{0x3b0a0489,0x7e440140,0x23e60107,0x694101c4}},	//   _iexpecte, _kasanaya, _ditugasi_, _saamgest, 
   {{0xf2d8001d,0xca6700af,0x9c8c02e0,0x00000000}},	//   _lohen_, _utgått_, _khutlang_, --, 
   {{0xc6070162,0x5d930147,0xcf8e00a6,0x43aa02ee}},	//   _ашулар_, _بئلچۉ_, _میکانیزم_, _ekwatorj, 
   {{0x8ae003a0,0x9f2e0076,0x6a890288,0xd29e0092}},	//   _netefats, _модифици, _antioran_, _ルパン三世_, 
   {{0x66480047,0x9057014e,0x0b6b00f0,0x00000000}},	// [560] _concerné, _прикачи_, _priveľa_, --, 
   {{0x58f6018d,0xa3f90212,0xab1b02b9,0x00000000}},	//   _ደፓርትመንት_, _meque_, _dokkoló_, --, 
   {{0xab8f0124,0xf68b0040,0x5c0002e4,0xd292024a}},	//   _tennengo_, _אליאב_, _fasslet_, _sisare_, 
   {{0x99e4008e,0x262800cf,0x825b003a,0x72ee036c}},	//   _abduxaad, _accounii, _портловч, _afafy_, 
   {{0xad7c00d1,0x5b0c0029,0x22240044,0xdb090279}},	//   _গাফিলতি_, _فۆلکلۆری_, _spoke_, _adaptate, 
   {{0x925a014b,0xa2010020,0x543f0148,0xd2e70225}},	//   _mallow_, _alaiti_, _多瓦娜線上家具購, _etangin_, 
   {{0x56510089,0x8d42022e,0x00000000,0x00000000}},	//   _baykalfi, _alabastu_, --, --, 
   {{0x7a5e0360,0x9be80299,0x5e33000a,0xac2a0322}},	//   _अमेरिकाम, _алдамчил, _amigarma, _atababar, 
   {{0x7f8f048a,0x02cb018d,0x0f660080,0x882701bd}},	//   _اسسيميلي, _ምኒስትሪ_, _esmariun, _مارتەبە_, 
   {{0xc2900227,0x728b00c1,0xb4a601da,0x12000274}},	//   _tebal_, _स्वछंदी_, _gjeneral_, _takist_, 
   {{0x1557048b,0xac030034,0x77a1025c,0x26b4010e}},	//   _ninjasch, _norskur_, _gottesdi, _apostasy, 
   {{0xe385032e,0xdbc300bf,0xa03d0416,0x2b880092}},	//   _churapki_, _передвиж, _aprensio, _最新トラックバッ, 
   {{0x62d4039e,0x22eb013d,0x625a0102,0x4fd10206}},	//   _utforma_, _atribuo_, _jallow_, _platiteľ, 
   {{0x9fae032d,0x09460061,0x7da50117,0x1537048c}},	//   _шашка_, _한국에서는_, _tingbaot_, _broighey, 
   {{0xd85303c2,0x66f80012,0xf2c4046b,0xf7660025}},	//   _endanger_, _दबिलाउगं, _collodd_, _अनुशासनी, 
   {{0x00b8011a,0xa2d8047d,0x00000000,0x00000000}},	//   _בתצוגה_, _gohen_, --, --, 
   {{0x378402ea,0x00000000,0x00000000,0x00000000}},	// [570] _слушат_, --, --, --, 
   {{0x995100d9,0x0eb001a3,0x614f01d0,0x01390350}},	//   _kiellett, _رائچند_, _firehjul, _ማረፊያው_, 
   {{0x82fd0065,0x3a8003d0,0x6aa8048d,0x345102c6}},	//   _liegen_, _domovins, _inexecut, _broderez, 
   {{0x8ee00212,0x0290048e,0xd03f0151,0xb63a0162}},	//   _lightzon, _gebam_, _barterin, _қисмәтли, 
   {{0xb3f8026c,0x920102a0,0xca7500ac,0xf2ef03ee}},	//   _alius_, _alaisi_, _obične_, _putnici_, 
   {{0x1231014e,0x63fe0061,0x33f9048f,0x52e900ee}},	//   _септембр, _현공인중개사사무, _kibuku_, _baziren_, 
   {{0xf37c0151,0x2316005b,0x4fcf0094,0x9d080206}},	//   _caulking_, _ginza_, _адаммын_, _pretekoc, 
   {{0xd3a602af,0x43ef02a0,0x225a019a,0x505b022a}},	//   _ababijej, _adetunji_, _fallow_, _padakipo, 
   {{0xbe2e0040,0xf5bb003f,0xf5ad0486,0x3ddb0043}},	//   _שומשום_, _boharlah, _बबिता_, _agakuula, 
   {{0xd31601a4,0xec0a01ca,0x79660237,0x00000000}},	//   _binza_, _manongqu_, _면개발자문위원회, --, 
   {{0xb501031a,0xdc53001d,0x88e300d0,0x926c0343}},	//   _amalaidh, _oration_, _торгох_, _kalooy_, 
   {{0x2ab6013c,0x64850490,0x228b0224,0x00000000}},	//   _blokunun_, _acordeón_, _afkastam, --, 
   {{0xa61e0491,0x325a01b2,0x2b2d039a,0x06ac012a}},	//   _reconoci, _sunlit_, _sepantas, _detektyw, 
   {{0x20eb019d,0x525b0396,0xcf490269,0xf408018d}},	//   _achikhal, _afelju_, _apasiona, _ከነጽንዖ_, 
   {{0x1ff701db,0x9f47020f,0xcaa700b9,0x97f5027b}},	//   _резервке_, _نورګل_, _पृथ्वीचा_, _कषुरप्रे, 
   {{0x329000ad,0x7594014f,0xa00e0147,0x8d520492}},	//   _lebak_, _студенат, _امىقب_, _voucheru_, 
   {{0xee630036,0x43160493,0x46d003db,0xba8302e2}},	// [580] _محاضرة_, _ainzi_, _bayakuli, _asboonyn_, 
   {{0xc3bb0147,0x1e46036a,0x87f0008f,0xd7aa0244}},	//   _ئسلام_, _ciwasaga, _खिसियासु_, _castigli, 
   {{0xaeb30494,0x3354019b,0x03920167,0x33ca00c7}},	//   _upoznava, _lyderis_, _allyrru_, _bulamı_, 
   {{0x92010495,0x47e900e4,0x9e3f0211,0x3b0502af}},	//   _baciye_, _luksusow, _sängyssä_, _kunsanga_, 
   {{0x53fa0496,0x436c0040,0x8eb30009,0xf36500ca}},	//   _jesuis_, _מהנחות_, _spoznava, _alugada_, 
   {{0xec7f046d,0xd2900278,0x106c0107,0x124700be}},	//   _mitsiko_, _jejas_, _ايروني_, _دئلىبىزد, 
   {{0xd50601cc,0x6df5001a,0x9fc20107,0x82e702d0}},	//   _बन्धमोक्, _rendelet_, _کارون_, _standin_, 
   {{0xb2fc0454,0x32ee03be,0x4ae60075,0x9e910497}},	//   _ijigo_, _agafu_, _andrease, _obstruct_, 
   {{0x43c00169,0x43460061,0xfb8a01c7,0x45820065}},	//   _ক্ষতিপূর, _하이페리온_, _таланчыл, _livesuch, 
   {{0x0e33042f,0xb26d030d,0xcf360039,0x03950015}},	//   _takunnaq, _defolt_, _масстай_, _aarsi_, 
   {{0x5daf0039,0xb41d02ac,0x0fc20208,0x1b340498}},	//   _argitalp, _صآحبهآ_, _رازوی_, _medailis, 
   {{0xd3000316,0x629001da,0x02240207,0xc98a0037}},	//   _talauci_, _rejat_, _mpoki_, _የወሰኑት_, 
   {{0x2a870035,0x9e8b0092,0xf97500fb,0xb78b0126}},	//   _nominats, _エリザベス_, _azenzile, _студія_, 
   {{0x7b5a0250,0x1f370021,0x00000000,0x00000000}},	//   _vendosin_, _anishspa, --, --, 
   {{0x0ad500b3,0xd9240419,0xf2ec00e2,0xa3ea0499}},	//   _аңласа_, _साम्यवाद_, _berikte_, _ivitu_, 
   {{0x59c20146,0x49310453,0x5e4502e7,0x00000000}},	//   _bermakna_, _osamdese, _makagaga, --, 
   {{0x32ee006f,0x9626049a,0x6316049b,0x52f00041}},	// [590] _taifa_, _josipovi, _sinzi_, _адыҕа_, 
   {{0xb44f0335,0x614a01e8,0x7360026f,0xff0400ff}},	//   _पाचत्तिक, _gumuguyo, _كىشرەيتۋ_, _balanciĝ, 
   {{0xa3d801db,0x71880286,0x2fcd00d6,0x13f4012d}},	//   _ойлаймын_, _comapany_, _seinnteo, _mauten_, 
   {{0x23eb015f,0xd29000c1,0x8af30034,0xe70702d8}},	//   _hectar_, _kejar_, _sameinas, _बादशहा_, 
   {{0x029000ad,0x0cbc026f,0x82240157,0x17740088}},	//   _lebah_, _ءدورتۋىل_, _epoki_, _алдырма_, 
   {{0x629002e9,0x692300da,0x22b601be,0xd04d01dd}},	//   _dejar_, _поезией_, _जन्मजयन्, _amagambo, 
   {{0x7230049c,0xa6fc0178,0xe5d6023c,0xf29000d8}},	//   _diujuj_, _amarṣita, _کراټې_, _aplant_, 
   {{0xa2b502d4,0xc67a026c,0xfa6d00d7,0x09f5049d}},	//   _pasch_, _argentum_, _boqolots, _sobretud, 
   {{0x4c6f036d,0xa85400bc,0xb2900193,0x89640081}},	//   _fearann_, _اوليه_, _tebak_, _kristnir_, 
   {{0x48b5003a,0xd2e602a0,0xaad00274,0x00000000}},	//   _mintaqav, _esinsin_, _austurve, --, 
   {{0xb5fb0057,0xf9d103a0,0xcfdd0185,0x72bb0026}},	//   _የመብራት_, _baeteled, _базарына_, _breedte_, 
   {{0xcc6d018e,0xb27f0011,0x283d01db,0xde760007}},	//   _andriya_, _aganza_, _арсыз_, _bamumpɛ́_, 
   {{0x424900b0,0x12b50243,0x126c029c,0xf2e60378}},	//   _maamul_, _fasci_, _akhoza_, _grindin_, 
   {{0xfa030039,0x462301ff,0xc7050014,0x9519028a}},	//   _soraluze, _synonymi, _padrejtë, _رومانيت_, 
   {{0x30e30161,0x649f0173,0x33950145,0x29ec002b}},	//   _рекоменд, _মৃত্যুর_, _tarsi_, _ঠিকমত_, 
   {{0x32d801f1,0xb3ea0411,0x440102f6,0x00000000}},	//   _kohes_, _kvitt_, _kasuutan_, --, 
   {{0xb8ed0013,0xc74400bb,0x62240030,0xdf26003f}},	// [5a0] _болалард, _کنجاہی_, _spoki_, _dirropta, 
   {{0x3a250157,0x07b102ac,0xd04c0312,0xc3540086}},	//   _ओमप्रकाश_, _الضعيف_, _steredon, _مفتیان_, 
   {{0xb354049a,0xa694047b,0x29c70088,0x7a540291}},	//   _povežu_, _birmavej_, _баланар_, _مضيفاً_, 
   {{0x9f720307,0x009902fe,0x829103b6,0xf30603bf}},	//   _ababanin, _اتلسو_, _feran_, _borobong_, 
   {{0x92910057,0x08c101f5,0x00000000,0x00000000}},	//   _geran_, _ditelusu, --, --, 
   {{0xe2ca0107,0xf2d80065,0x129003ac,0xab6903d5}},	//   _stidiu_, _hoher_, _lebai_, _cabdilyn_, 
   {{0xfece0428,0x488402eb,0x31660040,0x32910261}},	//   _varnostn, _админаар_, _הידועים_, _aeran_, 
   {{0x1d6102d8,0x1eda0092,0x6c0700a9,0x1ef2020f}},	//   _आकडेवारी_, _楽天トラベル_, _urusaku_, _ayikufun, 
   {{0xb2b502a6,0x70ef01e8,0xf8c40139,0x6c0a049e}},	//   _pasci_, _kasimbol, _cedipuṅg, _vírusy_, 
   {{0xd3fa005b,0x59da00f5,0x6b9801c7,0x00000000}},	//   _musume_, _никалашм, _dikeldiş_, --, 
   {{0xa27f02af,0x40c100ba,0x72910183,0x1cb702b6}},	//   _aganya_, _هیتۆتی_, _derao_, _قاپاستا_, 
   {{0x918a016f,0x2264001d,0x1fc501ac,0x6aae01b7}},	//   _матеріал, _intlaw_, _deintear_, _केवलस्य_, 
   {{0x7c2d039f,0xf2b200e0,0x729503ac,0x8cd60060}},	//   _depicted_, _foldien_, _syukuri_, _қаршыға_, 
   {{0xe0fb0037,0x10050059,0xc197021c,0x7f7d0234}},	//   _መዘግየት_, _огромно_, _keramiky_, _ikọni_, 
   {{0x3c680343,0x5f3f0320,0xe86c0033,0x42f1024a}},	//   _belushi_, _hingakan, _affittad, _kiristi_, 
   {{0xe6bd049f,0x229201d3,0x9c6700bb,0xd09a00ff}},	//   _kwesitjh, _visade_, _قرطاس_, _דיסקוטיר, 
   {{0xc291028d,0xe3ff0052,0x924800a2,0x51f90321}},	// [5b0] _leral_, _malotrak, _chembe_, _poslabša, 
   {{0x1be004a0,0xf29100d4,0x86c50060,0xae530036}},	//   _aprender, _oeral_, _بولسن_, _monarcha, 
   {{0xdc7c0144,0x22900453,0xe29101b9,0xc6a80311}},	//   _shasana_, _uplate_, _neral_, _በብዘመኑ_, 
   {{0x547c0213,0xd94101df,0xabee0029,0x71c900f8}},	//   _допускаю, _coortier_, _هیدبوونی_, _এলিসিয়াম_, 
   {{0xea3901c7,0x93ea005c,0x70d100fc,0xca0903db}},	//   _терези_, _kwita_, _chalvetl, _bawasebe, 
   {{0x0a1504a1,0x565701b8,0x131601b5,0x5e2400db}},	//   _forbinde, _कांधे_, _binzu_, _tellimus_, 
   {{0x5291015e,0xb3ea03ef,0x0bd20105,0x9a1100be}},	//   _seran_, _mwita_, _गठिया_, _сөөктү_, 
   {{0xaa11004f,0x29600053,0x714602ac,0x9c63036e}},	//   _espaceme, _महानोर_, _وفقكم_, _arrullo_, 
   {{0x2d3801d5,0x00000000,0x00000000,0x00000000}},	//   _ووٹروں_, --, --, --, 
   {{0x9af801de,0x00000000,0x00000000,0x00000000}},	//   _валентті, --, --, --, 
   {{0x729100e5,0x6e610147,0xe224013d,0x52da02fc}},	//   _geral_, _الىحان_, _epoko_, _turebe_, 
   {{0xd34101fb,0xea34013c,0x8c6f00ee,0xe543016f}},	//   _duressa_, _rusiyalı_, _atarian_, _воском_, 
   {{0x57a704a2,0x4b8c02af,0x6d0201a2,0x6a1300cf}},	//   _festivai, _bayishar, _vīlandes_, _darbanit, 
   {{0xbd800029,0x19f904a3,0xee6a00c7,0x427e03a4}},	//   _زیزپوور_, _डिप्रेशन_, _корды_, _runnu_, 
   {{0x5d5000e6,0x828d00f4,0x527e0034,0xdd8d016b}},	//   _省地方税务局转发, _besketa_, _sunnu_, _dimokara, 
   {{0xfc9d02ec,0x012d03ab,0xb6b800f5,0x25260299}},	//   _ؤٹتھ_, _kokosové_, _bayramcy, _بوپقاپتۇ_, 
   {{0xe291041c,0xc2240044,0x00000000,0x00000000}},	// [5c0] _meram_, _looked_, --, --, 
   {{0x0ae0021b,0xa1890066,0x72cf0003,0x2e010184}},	//   _varustet, _элементү, _getoond_, _bakegera, 
   {{0x065500fb,0xf2e30025,0xe9e10317,0x727e005b}},	//   _elenzelw, _मारीच_, _metodama_, _gunns_, 
   {{0x090e017d,0x0c670257,0x7b0e01eb,0x82d50040}},	//   _はじめまして_, _frettir_, _aropúta_, _ואסטרטגי, 
   {{0xae410327,0x93cd02b6,0x5349001d,0xfc560272}},	//   _symbolet_, _поштаңыз, _differe_, _amatale_, 
   {{0xba07042f,0x229100e1,0x97ed023e,0x09fa0378}},	//   _munaritt, _beral_, _bebareng, _haraldse, 
   {{0x69c70088,0xc22402bb,0x9985034d,0x4d25006c}},	//   _бабадан_, _spoko_, _diekspre, _babonane_, 
   {{0x963900a4,0x4eb001f0,0x92c501d3,0x42f00219}},	//   _палатасы, _apesitse_, _kollade_, _bakitsi_, 
   {{0x154b016d,0xe23f0109,0x1e8c01f6,0x739e0242}},	//   _ﻣﻪﺷﮭﯘﺭ_, _jarmark_, _medverke_, _həyati_, 
   {{0x7d8d02ef,0xd45d023a,0x98ae00ec,0xac0100c1}},	//   _dekontra, _zaoberať_, _ўмеюць_, _elastis_, 
   {{0x12ee042c,0x5c510066,0x88cf01f4,0x62ea044d}},	//   _planovi_, _kontura_, _tartibig, _farisen_, 
   {{0xd30501ea,0x805301ce,0x42b4013b,0x76310125}},	//   _سوراق_, _رامسر_, _chocó_, _gündelig, 
   {{0xe2240340,0xbe3e0095,0xe9280444,0x9c7d0139}},	//   _upoko_, _رادیاتور_, _рейтерс_, _caurair_, 
   {{0xfb7500b5,0xf5da0227,0x7e350222,0xc5f000ec}},	//   _aposéva_, _timbulny, _cellules_, _старанна_, 
   {{0xa2c9031a,0x230d0054,0x9fd7003a,0x5c20005b}},	//   _poblach_, _tambaya_, _зарарли_, _jernmand_, 
   {{0x136500e0,0xd20104a4,0x72ee0049,0xabd1027b}},	//   _bergsma_, _cacile_, _haafe_, _ह्ययं_, 
   {{0x5bee03f4,0x0f25014d,0xc26701ed,0x1f580247}},	// [5d0] _самом_, _auseinan, _hopunaol, _bacutké_, 
   {{0x25e80105,0x9d0901c5,0x3d98007a,0x3ea10338}},	//   _पर्यटकों_, _پرانى۪ن_, _berlaina, _refusant_, 
   {{0x2c430016,0xc2930316,0x00000000,0x00000000}},	//   _malproks, _banbanci_, --, --, 
   {{0xc798025b,0x0cab0320,0x32000014,0x77620486}},	//   _motorsúk, _eliyazar, _takime_, _बन्धक_, 
   {{0x969803cf,0x029102eb,0x92d90040,0x02d90151}},	//   _verebili, _австрийн_, _dozens_, _agonize_, 
   {{0x6f240075,0xdd1601ac,0x6b9401a3,0xe2e60059}},	//   _tráin_, _foroinnt_, _ڪنسلٽنٽ_, _arancia_, 
   {{0x03490364,0x2291001f,0xd53a010d,0x4e9304a5}},	//   _sauerei_, _yerae_, _फ्रान्सच, _ngomhlan, 
   {{0xb0e802c2,0x3c7c04a6,0x3e31002b,0x0c4003eb}},	//   _christel, _časova_, _পঞ্চগড়_, _bekwaam_, 
   {{0x22df0044,0xa6fb008d,0x240f034a,0x36dd00f5}},	//   _evening_, _умумхалқ_, _bergondo_, _atabegli, 
   {{0xca1503b0,0xd93102ae,0x3fe90109,0x8266002b}},	//   _forbunde, _primjere, _बसपार्क_, _সীতাকুন্, 
   {{0x2849004d,0x3d190244,0xbd4b04a7,0xf78703c4}},	//   _我會說什麼人才跟, _безброй_, _aguantou_, _جانابىي_, 
   {{0xbc710212,0x3be801bd,0xd9df008d,0x922a0045}},	//   _oportet_, _тренингт, _dasturid, _бобан_, 
   {{0x16f100be,0xaa07001b,0x723602ce,0xcd1a014e}},	//   _اشتادىم_, _alaalatt, _nanjak_, _ispovest_, 
   {{0x1e0f0193,0xcf2d0386,0x4128018d,0x827e0450}},	//   _पार्श्वभ, _kepentin, _ህዝብኹምን_, _aginda_, 
   {{0x835e01da,0xbd14018c,0x9df30086,0xfdd7033e}},	//   _inteligj, _doorstur, _اینگلو_, _kangymím, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x659701ef,0x52e60097,0xa938023e,0x498e004b}},	// [5e0] _службовы, _isinwin_, _موسویان_, _ҡадир_, 
   {{0xd27c048a,0xe7b304a8,0xe3be02e5,0x0e7c04a9}},	//   _шаралары_, _podsjeti, _қьырала_, _येस्स_, 
   {{0x32f300af,0x327f04aa,0xd2d5045d,0xe200035e}},	//   _iнiцi_, _enenei_, _polovno_, _rakije_, 
   {{0x14b70031,0xe9810176,0xc79f0037,0xa3660140}},	//   _आघाडी_, _kishimot, _አይገርምም_, _arugain_, 
   {{0xf2410256,0x696f0197,0xef260372,0x1b8f019c}},	//   _neveiksm, _antibyot, _broteina, _owongogo_, 
   {{0x22d5008e,0xa5f40065,0x6e8d0093,0x00000000}},	//   _estomaa_, _gemeinnü, _вайша_, --, 
   {{0x7c0102c3,0x02ea0223,0xe2e30167,0xe9cb0125}},	//   _classis_, _parisen_, _abersoch_, _berdirme, 
   {{0x27890276,0xdee9014d,0xd9f600ba,0xb46e014e}},	//   _карачиди, _sicherun, _خۆشکرد_, _бреме_, 
   {{0x52780295,0x73950359,0x77620187,0x6fa1040f}},	//   _afungi_, _farsk_, _легендат, _analizuo, 
   {{0xb0c701e5,0x73f104ab,0x62d901d7,0x03940202}},	//   _amulumal, _njezine_, _libers_, _isosro_, 
   {{0x5d9a04ac,0x02d90040,0x45980143,0x00000000}},	//   _статьи_, _fibers_, _карбурат, --, 
   {{0xa3ea03f2,0xa7220391,0x5200005b,0xce1c023e}},	//   _avata_, _фулбрайт_, _fujie_, _dirganta, 
   {{0x03f40429,0xcedd0156,0x855200d3,0xe1b80088}},	//   _pautan_, _סבֿרא_, _bramborá, _алайкуун, 
   {{0x9c2a03ba,0x4f6501fc,0xd13a0362,0x469802ef}},	//   _ngabarar, _fitamiin, _ebongisá_, _dezekili, 
   {{0x23f80117,0x7c7e0271,0xd620029f,0x53bd004b}},	//   _klaut_, _versjon_, _ochoreni, _angwang_, 
   {{0x62d40105,0x2c2a02af,0x958302d3,0xdca90022}},	//   _trudno_, _atabibar, _corrupçã, _ҡырғыҙст, 
   {{0x43f40193,0xb9de04a7,0xcc610425,0x09c3003c}},	// [5f0] _tautan_, _valorada_, _کانگاس_, _شائبه_, 
   {{0x976f0135,0x079704ac,0x62900179,0xd2de0052}},	//   _форумнар_, _лидеры_, _gebas_, _nemohou_, 
   {{0xc1cb0227,0xee4404ad,0x5b2002f0,0xf2b20183}},	//   _tertarik_, _balatofa, _bebabamb, _dradama_, 
   {{0x6202026a,0x7387010d,0x385f01f7,0x82c50132}},	//   _eyring_, _ngaruh_, _coloniau, _kuplung_, 
   {{0xbd7602ac,0x1b350180,0x32d90148,0xb2eb0291}},	//   _جرحني_, _letablis, _imper_, _يرغبون_, 
   {{0xc3ea0178,0x0fef0136,0xec5200d8,0x00000000}},	//   _cvata_, _prehrano, _contorn_, --, 
   {{0x6249004f,0x5a5001eb,0x477403f0,0xf2f604a4}},	//   _kaamil_, _абатут_, _merkileg, _baistidh_, 
   {{0xf4930037,0x238701a1,0x00000000,0x00000000}},	//   _በዲሞክራሲያዊ_, _hierop_, --, --, 
   {{0xd94e02e2,0x98540060,0xe52200c7,0x222c0040}},	//   _swallowt, _توليك_, _агымдагы_, _ולמנוע_, 
   {{0xe291016e,0x429201ec,0x3f37006c,0x07f804ae}},	//   _idrar_, _altaic_, _akhuluma, _наелектр, 
   {{0x72da0151,0x1984004c,0x031002a5,0x0c5103fd}},	//   _egress_, _abakyawa_, _sluzby_, _faitala_, 
   {{0x4f650211,0x13ec0226,0x5200035d,0xec090289}},	//   _vitamiin, _asamafik, _hemija_, _chopita_, 
   {{0xe3f804af,0x720204b0,0x22830242,0x87180302}},	//   _hlaus_, _fyring_, _inamlı_, _забҳи_, 
   {{0x971e0223,0x2c6601e1,0xb2d901b4,0xdf4004b1}},	//   _дарга_, _батыры_, _amper_, _blogginn, 
   {{0x348f03db,0xf2000020,0x593e01f0,0x7da90296}},	//   _bengenak, _pemila_, _khompiut, _cylindra, 
   {{0x43090060,0x469c0073,0xc2c8012a,0x4290011c}},	//   _болуымен_, _diffundi, _pokazać_, _febar_, 
   {{0xc31001b9,0xa87001a9,0xffca0147,0x32000014}},	// [600] _burzwa_, _físicas_, _تاكبىرىڭ, _femija_, 
   {{0x19a60305,0xb23002f9,0x9ab400c1,0x00000000}},	//   _miljøsta, _chemaja_, _उजाडला_, --, 
   {{0x2f4901cd,0xf3a60037,0x42370130,0xc9ed0239}},	//   _кириллик, _ውዝግቦች_, _alkmena_, _himipora_, 
   {{0x92900172,0x62780102,0x496b0340,0xc2e60011}},	//   _kebar_, _ufundi_, _mamingat, _atanywa_, 
   {{0x73f801ef,0x1ce70076,0xc1140271,0x82000446}},	//   _alaus_, _решавање_, _klokkesl, _kemija_, 
   {{0xb2e10160,0xa9fc02fc,0x12d801ea,0xb6090047}},	//   _obrnuto_, _abandika_, _bmtning_, _compréhe, 
   {{0x3b8d009d,0x723601eb,0x1058034b,0x113d0077}},	//   _besimtar, _ahoja_, _givimbak_, _ajitasyo, 
   {{0x42910145,0x226d0077,0xd2da01b4,0xca7d0131}},	//   _gerai_, _devore_, _vereis_, _xefatura_, 
   {{0x32d8044d,0xcaea0019,0x41d00462,0xd07503c1}},	//   _amleen_, _testicle, _angedhay_, _духови_, 
   {{0x3c760305,0xe36a018f,0x32000167,0xc3f80116}},	//   _moisund_, _dungluq_, _dalier_, _glaur_, 
   {{0x4c7303d9,0xbc1c02da,0x614d00e6,0xe3a701aa}},	//   _raisina_, _процесот_, _破坏民族团结_, _annyday_, 
   {{0xef2a0204,0xba440439,0x72910429,0x338c016f}},	//   _банковск, _basemata_, _jerai_, _душею_, 
   {{0xfdee003a,0x86610013,0x7305028a,0x01df0178}},	//   _яраланди_, _خبرنگارل, _توتان_, _anenāsmi, 
   {{0x4ccd03e9,0x92b50148,0xbc7402a5,0xaf5d013c}},	//   _макалада_, _nasci_, _प्रेमदिव, _yataqxan, 
   {{0xe5d20169,0x6c7500c1,0xb387031c,0x9c67014a}},	//   _সাহিত্যে_, _प्रॅक्टि, _cierta_, _pintér_, 
   {{0xd07300cb,0x92fa0187,0x829200bc,0x2290010d}},	//   _ababengo, _тренерск, _bisane_, _tebar_, 
   {{0x72ef03f0,0x7c5902d6,0xa1dc0059,0xa26d03b7}},	// [610] _stefna_, _مکتوبی_, _глоба_, _apervill, 
   {{0x0c520007,0xbf5f039f,0x49580312,0x226d0347}},	//   _akatela_, _citation, _belleile, _tevore_, 
   {{0x4cc40396,0x82b5022d,0x72f002f6,0x22d0003f}},	//   _kapitolu_, _masci_, _lumitaw_, _foglayr_, 
   {{0xc25a0388,0x061b002f,0x03fe0052,0xb71c0094}},	//   _delle_, _lycopodi, _penzion_, _тәржімал, 
   {{0x0e4d0405,0x537800ef,0x29cd02b6,0x02df0360}},	//   _доводить, _زيرمه_, _поштасын, _malovat_, 
   {{0xe61e015e,0xfaa300be,0x82550128,0x22de00af}},	//   _laboraci, _инженерд, _швайншта, _подоланн, 
   {{0x104000d1,0x13f901cf,0xe2d403f7,0xd34801be}},	//   _সহানুভুত, _alque_, _ballinu_, _infekci_, 
   {{0x1e7a0302,0xf40d02ab,0xf39b021c,0x0e000151}},	//   _октябр_, _ebenchek, _sekundár, _balderda, 
   {{0xf3ea021b,0xeea804b2,0x1dce04b3,0xb26e0134}},	//   _avatv_, _publikon, _diskiant_, _praimari_, 
   {{0x425a02d5,0x657f01b5,0xd29101aa,0x09d30302}},	//   _kelle_, _afidhavh, _adray_, _новбари_, 
   {{0xd4ad02c1,0x59cf017c,0x969a019e,0x00000000}},	//   _barashak, _beteende, _бялынічы_, --, 
   {{0x1c7c02d8,0xa2e2017d,0xe7270313,0xe2ee033f}},	//   _pensiun_, _ejendom_, _mamejjaj_, _saafa_, 
   {{0x7b640328,0xa8de0072,0x4bf800d1,0x7a5c004d}},	//   _aratinda_, _stefansd, _পঠিয়াওক_, _一個小小的檔案館, 
   {{0xf3b80494,0x360f004d,0x82c2003b,0x662801c4}},	//   _imovinu_, _三代之中國歷史人, _dzalula_, _normaalw, 
   {{0x9d6b02e8,0x43cd0311,0x00000000,0x00000000}},	//   _chimbote_, _ንመዓስከር_, --, --, 
   {{0xe3000452,0x5c7c008c,0xfc35039c,0x80520350}},	//   _memakai_, _tensiun_, _impartic, _cheratin, 
   {{0x13190271,0x4291001f,0x7150040f,0xa0c702fe}},	// [620] _definisj, _yeraw_, _адамовіч, _معاملاتو_, 
   {{0xa8ec019e,0xbe13004f,0x22000124,0x29580312}},	//   _законных_, _suleymaa, _temika_, _pelleile, 
   {{0x0f3503c6,0x6394017c,0x5a5d032d,0x62920138}},	//   _autodoar_, _fansen_, _барларға_, _nickler_, 
   {{0xe3000054,0xf96d02b4,0x2f2c0147,0x790900c7}},	//   _halarci_, _batiphat, _ققاندا_, _берара_, 
   {{0x6c530026,0x289f0235,0x9383028b,0x1b5b0415}},	//   _fietsen_, _anulbaṇa, _рыҟаҵара_, _erneuten_, 
   {{0x841c02f7,0x833101a6,0x824e039e,0x00000000}},	//   _kanamiso_, _rakapī_, _båtsamli, --, 
   {{0xc2f50046,0x599303ff,0xb3940003,0x00000000}},	//   _apuntar_, _snažili_, _kansen_, --, 
   {{0xe3ea02d9,0xc29201a0,0xce370307,0xd4ea0092}},	//   _avatu_, _dickler_, _bangakha, _万円から始める投, 
   {{0x52b40497,0x5a0c03dd,0x63f40421,0x1257039e}},	//   _baccy_, _gjibralt, _bauten_, _baselkom, 
   {{0xbc4903e0,0xedec006f,0x7ed4031a,0xc402002b}},	//   _ronderëm_, _تابعداري_, _claistin, _করুণা_, 
   {{0x7d9b0300,0x35e5023c,0xa34101d4,0x00000000}},	//   _autoseda, _مېدوېدېف_, _arremba_, --, 
   {{0x0e940277,0xfb2402ec,0xc1520062,0x3d7801ce}},	//   _browbone_, _barakays, _ghalilay_, _ونوجوانا, 
   {{0x586600d6,0x66530045,0x9387031c,0x68ff04b4}},	//   _استايلات_, _trajkovi, _cierra_, _dataprod, 
   {{0x8f060188,0xa602024c,0x22d90049,0x81770315}},	//   _мизроб_, _inklussi, _topee_, _kumakhel, 
   {{0x837c03ba,0x797504b5,0x1d8c015e,0xf94a0151}},	//   _koralle_, _periclit, _aprofita, _diatomic_, 
   {{0xbbb80094,0xd3bb00a2,0x00000000,0x00000000}},	//   _анашым_, _kumwita_, --, --, 
   {{0x22e604b6,0xc0900151,0xc2cd024e,0xf2ba0220}},	// [630] _itangwa_, _precocio, _učenici_, _crediti_, 
   {{0xcf4b0175,0xf1e401db,0xe1b10488,0x00000000}},	//   _senserma, _педиатрл, _premjerm, --, 
   {{0xe17500e7,0x9ee10329,0x9ea101c4,0x27a60087}},	//   _econdsay_, _lazistis_, _sterkste_, _mindyang, 
   {{0xe015035b,0xca9701a3,0xa2f1008d,0x52dd012a}},	//   _zdravniš, _اونھو_, _tarildi_, _japonii_, 
   {{0x001a0258,0x22f10331,0x45f4029b,0xe20200f4}},	//   _staverin, _høgra_, _lëmoodik, _girieu_, 
   {{0xc387023e,0xdfc300c5,0x57400278,0x80f602df}},	//   _vierra_, _indiquer_, _kelowong, _cencaluk_, 
   {{0xc2010091,0x6aca029f,0x732502c3,0xf2ba03fb}},	//   _ilaini_, _pravidie, _slobody_, _srediti_, 
   {{0x98960013,0xb44c006c,0x73f4028e,0x784100e1}},	//   _тартиби_, _қубодиён_, _sauten_, _faaleetu, 
   {{0xa667027e,0x3ee90331,0x96b70434,0x6db50102}},	//   _радимо_, _fiskiran, _cadáver_, _msongama, 
   {{0x57120255,0x40bf00e6,0x12cf042c,0x89f80359}},	//   _मर्दे_, _中华人民共和国中, _redovne_, _fraachte, 
   {{0x7f3c0456,0x0afc0074,0x1c6404b7,0x17750157}},	//   _dikurnia, _onnellis, _geruime_, _प्रभाकरण_, 
   {{0x02910005,0x96ea00f2,0x08940078,0x99030156}},	//   _gerau_, _atraduši_, _пустите_, _דאפלט_, 
   {{0x966802c0,0xceb302d9,0xa34302ed,0x00000000}},	//   _глобални, _fitoiton, _accegal_, --, 
   {{0x130002d8,0x0f4102fb,0x3e59009c,0x6ea20059}},	//   _pemakai_, _kongokon, _chuchupa, _potreste_, 
   {{0x539601b8,0xb291009b,0x8201036f,0x74d70064}},	//   _varsti_, _berau_, _nedovrše, _дарагын_, 
   {{0x42010202,0x72d9021c,0xac6001df,0xef2503b0}},	//   _alaini_, _kopec_, _alludin_, _medlemer_, 
   {{0xb1fd0148,0x5b4001e6,0xd28303a0,0xa2db0027}},	// [640] _行政院公報資訊網_, _dekoračn, _baranodi_, _stromer_, 
   {{0x4f21033e,0x72da0069,0x7bfe009e,0xd6990211}},	//   _orquesta, _mureke_, _namorado_, _добиться_, 
   {{0x54a602a5,0x23ea0176,0x59ee03da,0x1a5e03a2}},	//   _पुरातात्, _iwata_, _ifunanya_, _ऐसेसरीज_, 
   {{0xb3fa005b,0x2c590347,0x7a080294,0x84390045}},	//   _haruru_, _gedurig_, _funavist, _проглаша, 
   {{0x24190013,0x43ea001e,0xddff0268,0x13f4018d}},	//   _байрамин, _kwata_, _aplessta, _portit_, 
   {{0x1c2101d7,0x560304b8,0x3dae0019,0xc2e704b9}},	//   _perquai_, _handloom_, _crítique, _granein_, 
   {{0xb2fc0193,0xbf910204,0x22910308,0x012d004b}},	//   _nongol_, _активная_, _jerat_, _ҡапты_, 
   {{0x629102a3,0xa34400ac,0xb2910071,0x79df0162}},	//   _veral_, _istekne_, _jeram_, _لەردە_, 
   {{0xf05f018d,0x72cb043a,0x529100e5,0x53ea0157}},	//   _ተንሲኦም_, _onedom_, _deram_, _plotek_, 
   {{0x5a67048a,0x030d0285,0xf2e200c7,0x0201026c}},	//   _прозасы_, _zambiya_, _artığın_, _accipe_, 
   {{0x634a014a,0x1ba7019b,0x5ecf0067,0x21c303ea}},	//   _kipufogó_, _susitiko_, _fariison, _apprenez_, 
   {{0xd49e0169,0x93ff023d,0x427f012c,0xcdff0462}},	//   _ফোল্ডার_, _giardini_, _mganga_, _aplersta, 
   {{0xe51e0187,0xfd710378,0x73050356,0x29c203e6}},	//   _балотели_, _svimjara, _tamanak_, _vegetare, 
   {{0xc395025e,0xe3f9037f,0x9d250137,0xc35a01df}},	//   _barst_, _boyuk_, _худгаас_, _puffies_, 
   {{0x829104ba,0x134503dd,0x89df0162,0x13b8021c}},	//   _xeral_, _sigurisë_, _پەندى_, _slovanu_, 
   {{0xc74804bb,0x72b501b4,0x03950274,0x42910110}},	//   _zoonkauj_, _soldate_, _varst_, _ceram_, 
   {{0x139500bd,0xf7e30141,0x6f4a00d8,0x8261040b}},	// [650] _warst_, _номини_, _adoptant_, _polotiki_, 
   {{0x22d80369,0x2ecd0151,0xa99302f0,0xd2d800e2}},	//   _kihee_, _antimoan, _enchutje, _sijens_, 
   {{0x82d90211,0xe95604bc,0x57220265,0x6291018f}},	//   _nopea_, _sørover_, _ingredië, _heraj_, 
   {{0x117d00ff,0x0c740037,0x33800312,0xe2da04bd}},	//   _נילוס_, _መነሳሳት_, _bitrak_, _tureke_, 
   {{0x3291029b,0x19a500ec,0x22d90211,0x0c7300e9}},	//   _seral_, _купалу_, _hopea_, _uvertir_, 
   {{0x120004be,0x52cc0247,0x90dd00bc,0x93fa02fe}},	//   _tubig_, _antlion_, _میارن_, _kusuke_, 
   {{0x527f011b,0x66a80064,0xe248011b,0x1f770161}},	//   _nganga_, _الاقاچتى, _kukwikil, _кремля_, 
   {{0x43ea02e0,0xda5d03d4,0xb04003b2,0x7ab60141}},	//   _barutegi_, _galenika_, _resuspen, _kuchayis, 
   {{0x127f029c,0x727f0007,0xa26e02ab,0x72910231}},	//   _mganda_, _aganga_, _ikpowa_, _veram_, 
   {{0x1372049c,0x990a024a,0x1378031a,0x620104bf}},	//   _bangfuz_, _alabapad, _breagha_, _nacije_, 
   {{0x2eb3005b,0x90d403d0,0xe25e030c,0xaab60087}},	//   _appstore_, _poručuju_, _kitunigl, _anghenis, 
   {{0xe99f02ec,0xa3f904c0,0xa7c20116,0x364a03b4}},	//   _وُپھوارس_, _baguam_, _flurishi, _chihumbi, 
   {{0xfea40235,0xd2ea04c1,0x920000b9,0x1ff501e8}},	//   _पूर्णत्व, _ekriven_, _nubie_, _boryatin, 
   {{0x2364030d,0x00000000,0x00000000,0x00000000}},	//   _brifinq_, --, --, --, 
   {{0x72cb0006,0x32fe0381,0x221303f3,0x33f402be}},	//   _berlari_, _alarmway_, _kachel_, _dautan_, 
   {{0x9e9c00d6,0x11a3004d,0xaf3100f1,0xd280012a}},	//   _ltltltlt_, _戶政博物館_, _spiritya, _papiery_, 
   {{0xd25a0167,0xf5fb0326,0x3fe100ff,0xa75a0350}},	// [660] _clllc_, _chemunyi, _babilejo, _ማክበርና_, 
   {{0x20c000e7,0x3aa60040,0x159100fb,0x531302c6}},	//   _abelledl, _השגריר_, _nasekuth, _eskimoeg_, 
   {{0x8ce5005e,0x639a0107,0xa14101eb,0xfa4f0227}},	//   _پاھىشە_, _اسامي_, _castígop, _lehernya_, 
   {{0x33eb046d,0x46f40092,0x093c04c2,0x01630187}},	//   _phetho_, _人のお友達がいま, _primetit, _поминат_, 
   {{0xb3050243,0x00000000,0x00000000,0x00000000}},	//   _ramadak_, --, --, --, 
   {{0x73fa005b,0xc3a90271,0xa224024f,0x42d00235}},	//   _yusuke_, _øyvind_, _oqoka_, _avatīrya_, 
   {{0xf659019b,0x920602e1,0x62a60025,0xef48023e}},	//   _настольк, _ناروتو_, _alobho_, _anggrain, 
   {{0x5387005f,0x3c680125,0x6dc803fe,0xb3f40296}},	//   _mierda_, _онаран_, _центро_, _alster_, 
   {{0xd27e04c3,0x4e950194,0x00000000,0x00000000}},	//   _gunny_, _mantenet_, --, --, 
   {{0x525103f1,0xef2801e7,0x15580242,0xec0b0032}},	//   _čitateli, _doropper_, _alırdıla, _manongpu_, 
   {{0x12fc04c4,0x115303b0,0xcd400177,0x12b103b4}},	//   _ajaga_, _konserto, _иҟаларан, _dundira_, 
   {{0x6380038a,0xf3e1029f,0xaa910019,0xc9d00162}},	//   _fourmi_, _objektov_, _студияда_, _шерин_, 
   {{0xa2910013,0xcf3900a8,0xd2f20198,0x14860109}},	//   _kerak_, _spengler_, _užitek_, _दोहामा_, 
   {{0x6575023d,0x4ae902d3,0x44ab025f,0x4291013d}},	//   _contatto_, _позиција_, _bakangak, _veraj_, 
   {{0x10d00334,0xc508003e,0xe2ea03cf,0x00000000}},	//   _ingokhal, _беѓѓеѕ_, _biriken_, --, 
   {{0xf86302af,0xdfea00c5,0x0d0800ac,0xb1a50105}},	//   _abandond, _参与本评论即表明, _otvorite_, _chronić_, 
   {{0x2c250245,0xe2da02f9,0xb2ad0012,0x1291013f}},	// [670] _husbandr, _deperi_, _बालमीकीज, _gezar_, 
   {{0xae4a00cb,0x6bec0061,0x72e901c8,0x00000000}},	//   _ababelap, _내비게이션_, _historky_, --, 
   {{0x54a4002f,0x0cbe0046,0x19d1000b,0xba8c03f3}},	//   _akrakiyk, _калем_, _faitautu, _tarieven_, 
   {{0x23ea011f,0xe75f00bb,0x42da047d,0xb99101b3}},	//   _avati_, _موزمبیق_, _dorems_, _bakhjule, 
   {{0x12910039,0xa77801f4,0xd31c0163,0x5a1a00bc}},	//   _berak_, _اوراقی_, _پیرما_, _مزایا_, 
   {{0xf3f402d0,0x455b006d,0xf2900082,0x84bc00c1}},	//   _ulster_, _квадра_, _nunawa_, _परवडत_, 
   {{0x625a015f,0xd21500bb,0x327701ea,0x00000000}},	//   _waelod_, _روپئے_, _вазмин_, --, 
   {{0x044f0287,0x40370156,0xb2da02d9,0x4ae700d0}},	//   _आर्यघाटम, _שייַעך_, _pepesi_, _andreare, 
   {{0xb2ea039e,0x949b0157,0x9ee00486,0xb3f90416}},	//   _skriven_, _ostatecz, _जँड्याहा, _alquo_, 
   {{0x6dbc0203,0x40330059,0x151e0040,0x5a35002b}},	//   _orthogra, _моторни_, _שובבות_, _নিমজ্জিত_, 
   {{0x0dfb0422,0x0fcd002b,0x034d012e,0x73370205}},	//   _čudovito_, _বকেয়া_, _lemezek_, _кинога_, 
   {{0xb362029e,0xa2c70057,0x626d00d7,0xc59b0400}},	//   _mangeek_, _disedari_, _fefole_, _astutezz, 
   {{0x3bee0159,0x92f70059,0xdd25002b,0x9aaa0299}},	//   _вадою_, _ораново_, _কাঁচের_, _بەيھەقىي_, 
   {{0x64680046,0xa0fb0092,0xfef60156,0x938702dd}},	//   _айтор_, _エスニック_, _עבֿריתּ_, _bierda_, 
   {{0x587001d1,0x329101ec,0xa2770188,0xbb8100c1}},	//   _standard, _gerah_, _паймони_, _एकदमच_, 
   {{0x60d802ba,0xf6860127,0x02c30121,0x00000000}},	//   _душманон, _gondaoni, _pillado_, --, 
   {{0xf5470191,0xb2ec0148,0x468702c8,0xd1f50152}},	// [680] _tingsrät, _subinde_, _verdegai, _ауропа_, 
   {{0x92eb02ad,0x19fb0244,0xc2ee00bc,0x5a9d0405}},	//   _majitel_, _martedì_, _ngenani_, _повертаю, 
   {{0xd29101b9,0x199d004b,0xd5c200b3,0x44b40075}},	//   _sezar_, _ғанын_, _онармаса, _undantik, 
   {{0x8bed03cf,0x02920392,0x0da901fe,0x09ea0210}},	//   _gerektir, _casaid_, _konitara, _akarigad, 
   {{0x734200ec,0x85b20139,0x0c630309,0x4334020f}},	//   _elgesio_, _apohyajñ, _avtomaşı, _ورنږدې_, 
   {{0x77420066,0x840e01b5,0x8c6f038b,0x03940160}},	//   _морьтон_, _chunchek, _ataukah_, _proslo_, 
   {{0x53200343,0x82ee019f,0x62b10066,0xbf2a0095}},	//   _ariyos_, _maafa_, _mundura_, _dattulla, 
   {{0xa9dd0244,0x72d5007b,0x9d85034f,0x00000000}},	//   _толерира, _callant_, _ebambana, --, 
   {{0x235b0216,0x8c52004b,0x539402f9,0x2a13007b}},	//   _hunguta_, _ikatela_, _kanson_, _ingaithe, 
   {{0x60570125,0x02fe01d1,0xee350498,0x323000ec}},	//   _динидир_, _periods_, _oslavova, _chemija_, 
   {{0xf3eb00fe,0xc9e700d9,0xbead02eb,0x43f2019e}},	//   _eletā_, _заметно_, _хүрвэл_, _чешуекры, 
   {{0xe841033e,0xa27f0011,0x5344029e,0xd6e50073}},	//   _астено_, _aganja_, _astenne_, _preconci, 
   {{0xe22f00d7,0x5f660276,0x00a702ad,0x422500be}},	//   _абруй_, _پروگىرام, _šatičky_, _كىنەماتو, 
   {{0xa29004c5,0x82830410,0x5051013f,0x89f801d3}},	//   _debaz_, _thekgwa_, _abugidao, _kraschad, 
   {{0xd8c401eb,0x25e8013c,0x0a2b00c1,0x63ea0176}},	//   _endeudad, _manatlıq_, _गुळगुळीत_, _iwate_, 
   {{0x234c0158,0x7fe2015e,0xd15b0405,0x4b4500bb}},	//   _महबूब_, _جەمئىش_, _околиці_, _ناخنوں_, 
   {{0xd3190040,0x72020260,0x13f9004f,0x00000000}},	// [690] _defining_, _maside_, _doyul_, --, 
   {{0x24a2016e,0xdea2004b,0x0ba802d5,0x76690156}},	//   _başladım_, _botlasen, _गुरुँये_, _העפֿלעך_, 
   {{0x5452017d,0x6a010499,0xd2fd04c6,0x9f2e0414}},	//   _brodersk, _femalaga_, _alvhild_, _mbatasia, 
   {{0xd2e90141,0xe8e9027f,0xdc7e0034,0x6278012a}},	//   _oldidan_, _bwashing, _lausnin_, _grunty_, 
   {{0x7ddb022b,0x432003b6,0xa22601d5,0x59c10253}},	//   _endurnýg, _aroye_, _آخرکار_, _sandgree, 
   {{0x12900193,0xd3bb00ef,0xa2c701e4,0xde4a0361}},	//   _lebay_, _مکتبونه_, _vídni_, _вариантн, 
   {{0xe34f04b8,0x33160099,0x52f20040,0x2c5601b8}},	//   _asherah_, _tanzi_, _manually_, _teatele_, 
   {{0x5f3701e6,0x427704c7,0x85ef031f,0xfd3700d9}},	//   _poslanec_, _батман_, _ordforrå, _бизнесе_, 
   {{0xcf7e026c,0xb269032e,0x242800d7,0x5c6d0039}},	//   _中國經濟網_, _sutinkax_, _болоттар_, _савандаж_, 
   {{0x4eac0055,0xa3250120,0x9ccc0094,0x8863030d}},	//   _castagne_, _babbaay_, _العاشىند, _alfonslu, 
   {{0x89f000c4,0x693b0039,0xfa9904c8,0x68b50251}},	//   _kuungana_, _eramatea_, _diverġen, _mandaqad, 
   {{0x503601cd,0xc2a604c9,0xbb8000bb,0xfc920333}},	//   _duterono, _biobã_, _پلانٹس_, _avvecanu_, 
   {{0x7e50018f,0x0ba50321,0x731e01db,0x929000b9}},	//   _bisaghla, _zanimajo_, _армандап_, _debay_, 
   {{0x72fc0193,0xd3500064,0xeeaf00df,0x91620061}},	//   _berikut_, _انگلىسچە_, _nautisme_, _인디펜던스_, 
   {{0x371302e5,0x5d8f00d6,0xcfa104ca,0x6c5e0176}},	//   _evusukué, _bunleaga, _atelosto, _cattail_, 
   {{0xd22b0219,0x96ca00a8,0xecbd0040,0xc4160137}},	//   _avamise_, _chapital_, _גימיק_, _эгчтэйгэ, 
   {{0x59f600bb,0xb1b900da,0x9462022f,0x00000000}},	// [6a0] _futár_, _терминэ_, _moterisk, --, 
   {{0xfaad0052,0x7ab800b4,0x0c730046,0xd3eb007b}},	//   _zasedání_, _нормелор_, _exercir_, _cwyte_, 
   {{0xb27f02f8,0x9b7f01d2,0xe3f901cf,0x257102ba}},	//   _anenai_, _achuqcha_, _loque_, _халқҳои_, 
   {{0xf9e400ea,0xd3e100d1,0x729204cb,0xa2d5029e}},	//   _namorona_, _আম্বেদকা, _nasaud_, _hallont_, 
   {{0x3af700c7,0x375d0022,0x92d90428,0x00000000}},	//   _berrättä, _норвегта, _topel_, --, 
   {{0x9f3b0008,0xe38000f1,0x3f19020f,0x99e40183}},	//   _francesc_, _pourki_, _ویبلاګون, _hamorona_, 
   {{0x3f4d0040,0xc39402f9,0x13050243,0x00000000}},	//   _גיורא_, _ranson_, _tamahak_, --, 
   {{0x9bf10265,0xb39c0076,0x73450192,0x00000000}},	//   _auteursr, _secundár, _lopende_, --, 
   {{0xe27f0251,0x48f900dc,0xe9e40183,0xaca603b0}},	//   _maanta_, _apopoleg, _mamorona_, _mangfald_, 
   {{0xd27f0015,0xc9340274,0x22bb02c2,0x92000269}},	//   _laanta_, _klambrat, _hemelse_, _rubia_, 
   {{0x9dfc0021,0xe94d0064,0x5cff0296,0xbfd903ab}},	//   _annealwa, _demostre, _flyttfir, _avizovan, 
   {{0x32d804cc,0x5dce027b,0x02c70188,0x0200012b}},	//   _cihen_, _निष्पन्न, _тармим_, _lubin_, 
   {{0x91fd0366,0x120001df,0xf97500a6,0x116d002b}},	//   _ежемесяч, _irbid_, _ayenzile, _গাছপালা_, 
   {{0x829b015e,0xdf0e01cc,0x13940359,0xc0190244}},	//   _اكبار_, _alabhamā, _aansen_, _борса_, 
   {{0xcb180125,0xf6320189,0xcd8c0291,0x63160102}},	//   _вакитлер, _gündemin, _تشتهر_, _kanzu_, 
   {{0xfd1401c2,0x541300ba,0x62f30095,0x00000000}},	//   _divulgac, _ماڵدا_, _dijiret_, --, 
   {{0x3d7b0210,0xb2ef0242,0x0db4003c,0x72c10289}},	// [6b0] _akamonya, _tayfa_, _bagianip, _chilima_, 
   {{0xe878030c,0x13960075,0x616b018f,0x2e1c02e4}},	//   _frenchku, _fyrsti_, _birinmoh_, _hibernia, 
   {{0xac8800e6,0x23660156,0x735800c7,0x00000000}},	//   _各级行业管理部门, _aragono_, _басылырг, --, 
   {{0x87690147,0x43bd00d0,0x0c5900e6,0x4b890291}},	//   _жанданды, _баталдаг_, _一心一意谋发展_, _ابشركم_, 
   {{0xc3f800bc,0x6c8000ac,0xd37b02f6,0x71470152}},	//   _anius_, _pokušava_, _kuwarto_, _фаҗига_, 
   {{0x0ed30047,0x4b630255,0xdea30035,0xcea703fb}},	//   _familles_, _tartumaa_, _alınsa_, _neslagan, 
   {{0x53f404cd,0x84f6014a,0xae9001b5,0x62ca019d}},	//   _mostar_, _کامریڈ_, _enambyen, _amodzi_, 
   {{0x1f5f023d,0x9200005b,0x9a4400ff,0xe31601d9}},	//   _citazion, _fujii_, _דאללאר_, _danzt_, 
   {{0x1d5a0076,0x92e700dc,0x114501db,0xe8d9009a}},	//   _моден_, _clendon_, _تۇتىنۋ_, _بڅرکی_, 
   {{0xf2ec03e3,0xf3f40042,0xe2e8001d,0xe10102f7}},	//   _egziste_, _gostar_, _holigan_, _diphekol, 
   {{0x03f80231,0x8248021e,0x03260349,0xfe9302ee}},	//   _unius_, _blomma_, _airblay_, _dottorat_, 
   {{0x49c5041e,0xba530102,0x826c02be,0x00000000}},	//   _tagliata_, _limesema_, _damong_, --, 
   {{0xbbad00bb,0x3c7d0144,0x00000000,0x00000000}},	//   _ایکدوسرے_, _chasann_, --, --, 
   {{0x69e4027c,0x7c710113,0x3f6e00d3,0xee0c01f0}},	//   _buffaloe, _starsat_, _दुष्टहरू_, _dibebofa, 
   {{0x9ee202ec,0x835e018b,0xfc880187,0x6242003b}},	//   _وۅلسنہ_, _варзэ_, _радиодиф, _isimbuli_, 
   {{0xac17017f,0xf1ad01aa,0x756200b3,0xcc9103a2}},	//   _tamakker, _educeray_, _тержимеч, _कंसोल_, 
   {{0xc39e035b,0x436d0265,0xa6f2014b,0xf2d401ff}},	// [6c0] _izvajanj, _levertij, _hortitté, _prudko_, 
   {{0x635c02ec,0x6426013d,0x451602eb,0xe5810267}},	//   _وتھى۪ن_, _organizo_, _ленинээс_, _filmskom_, 
   {{0x32910171,0x5213018f,0x5394002e,0xcd290193}},	//   _stvara_, _dachol_, _prosao_, _अधिकाराच, 
   {{0x9200026c,0x2d57016d,0x6cae0089,0x10000030}},	//   _dubio_, _туридиға, _табарсың_, _demontāž, 
   {{0xb9da014e,0xddbf01fc,0x322e0484,0xc9c70450}},	//   _osvetlje, _dikilila, _कामचलाउ_, _aldeholt, 
   {{0xf63c048a,0x62790333,0x0f570151,0x3c57021b}},	//   _египетте_, _massimal, _amiablen, _kastike_, 
   {{0x1a09028a,0x4cef0153,0x34040296,0x624102d5}},	//   _ستابا_, _ほうれん草_, _inbunden_, _धूसली_, 
   {{0xd39401ad,0x00c1027b,0xf2d5033c,0xa7080461}},	//   _krosno_, _अजुगुप्स, _gallent_, _complèxe, 
   {{0x9db300ee,0x67a5034a,0x88e800ff,0x9b65030a}},	//   _hilabete_, _instruci, _אמבאסאדא, _cataláns_, 
   {{0xe22601c6,0xdd06008b,0x468300e4,0x683a005e}},	//   _tusken_, _charnier, _संकाय_, _ظىرىمحع_, 
   {{0xf6890309,0xce4100ea,0x52d9007b,0x61b1013f}},	//   _bildirmi, _besalamp, _foxer_, _dihelloù_, 
   {{0xe23804ce,0x9a3c022f,0x9c73005d,0xfccf0037}},	//   _khamusi_, _куток_, _ahesyva_, _የአፈጻጸም_, 
   {{0x5dad00bb,0xef8d04ca,0x9bf30137,0x00000000}},	//   _باؤچر_, _adaptèt_, _aireberr, --, 
   {{0x441e019b,0xc2910165,0x00000000,0x00000000}},	//   _savinink, _serau_, --, --, 
   {{0xbed40016,0xfa090281,0xc7160155,0x298c0291}},	//   _אנטייל_, _alianart, _personsö, _ازدياد_, 
   {{0xd26c04cf,0x3ca2002b,0xbc6001a0,0x4afa0374}},	//   _ikhona_, _মেক্সিকা, _illumin_, _соппа_, 
   {{0x720101b2,0xb99c00a7,0xd69300b3,0x7da801e0}},	// [6d0] _strig_, _грецияда_, _җеделлеш, _فدراسیۆن, 
   {{0x1ae2048c,0xe29101ef,0xd17e0091,0x17cf017d}},	//   _careless, _geras_, _kamagill, _サイト内検索_, 
   {{0xac1e0245,0x769600ff,0x062100f2,0xb39403c9}},	//   _gospelu_, _אביוזן_, _asinsspi, _fikset_, 
   {{0xa34403e8,0x987b00ff,0xd36500e6,0x40cd0145}},	//   _predelu_, _פלעשל_, _房地产抵押_, _балгарыя_, 
   {{0xa37803ac,0xbf3401d7,0x0ae303b7,0xc336004d}},	//   _semakin_, _passenta, _aperingt, _文字方塊工具_, 
   {{0xe27f02a9,0x3de90037,0x796f02e4,0x1d000156}},	//   _vienai_, _ጦርነቱን_, _granmast, _centrour, 
   {{0xb291017c,0xad8101d4,0xaf2200d1,0xbc800035}},	//   _deras_, _sagement_, _খৰিচা_, _безем_, 
   {{0xd7b5007b,0xf800000c,0x42ce046b,0xf27c017a}},	//   _disengag, _agaguáre_, _ailosod_, _аҳсан_, 
   {{0x526c02b4,0xfdab03b0,0xec6d00af,0x03950108}},	//   _akhona_, _bygninga, _московсь, _ijasah_, 
   {{0x623e0378,0xa2e902fd,0xfaf60092,0x50f6020f}},	//   _álvarsli, _chrimea_, _forurene, _balinqul, 
   {{0x53f90242,0x3ff3015e,0x62eb006a,0x73940204}},	//   _soyuq_, _banyoles_, _fariseo_, _kansan_, 
   {{0x719504d0,0x3eba02c2,0xaddb03f0,0xd26401fe}},	//   _gancengh_, _toerisme_, _endurnýj, _domomuni_, 
   {{0x929100bc,0xe0ef0482,0x299a018e,0xe349015e}},	//   _beras_, _asmaraak_, _cityssbu, _بەدەرلۉۉ_, 
   {{0x6363008d,0x9262021b,0x73470071,0x83940004}},	//   _термизли, _postikul, _delenga_, _lansan_, 
   {{0xd9170015,0x927e01a6,0x428a0047,0x6bdf04d1}},	//   _رِنگا_, _akene_, _comptabl, _cohesión_, 
   {{0x7292042b,0xf04d00da,0x515f002e,0xffab042a}},	//   _ostaje_, _врутэ_, _sportsko, _alamakho, 
   {{0xb4300445,0xa5a700f7,0xd291043c,0x70cd00d1}},	// [6e0] _desconto_, _לגנאי_, _gerar_, _কমিছনাৰ_, 
   {{0x37090078,0x837304d2,0xd9f80211,0xa7d40021}},	//   _великим_, _einaste_, _ilmianna_, _alarmedw, 
   {{0x8939003e,0x93730191,0x364403bf,0x5c890040}},	//   _профорие, _finaste_, _boyitshi, _לחצתי_, 
   {{0xa12700da,0x7aac01c2,0x427e01d2,0x4a0604b3}},	//   _британич, _deberán_, _cainpa_, _gamalade, 
   {{0x525a0450,0xaae7049e,0xb67f048a,0xb2fd0260}},	//   _wolle_, _videoalb, _اۋدانى_, _chegan_, 
   {{0xfad1020b,0xd883025b,0xdbdc0291,0xc21800ae}},	//   _baithute, _blokkstu, _يقتلون_, _iyakoram, 
   {{0x926c010f,0xe4060103,0x5c5600bd,0x00000000}},	//   _ukhona_, _chaitadz, _pottage_, --, 
   {{0x92f402cb,0xf2b6016d,0x4c6b0233,0x898300af}},	//   _dobijem_, _турсунҗа, _georock_, _переписа, 
   {{0x0c230203,0x97920092,0x3b0002e0,0xf8d102eb}},	//   _astralis, _テキストのお求め, _diartike, _швейцарь_, 
   {{0x74110072,0x667c02ec,0xc29004d3,0xf3f400aa}},	//   _asinarak, _مٔہِس_, _oblats_, _abuton_, 
   {{0x63f802f8,0xc83c04d2,0xd6150040,0x69f002af}},	//   _anaua_, _heimesid, _הובאו_, _kumugabu, 
   {{0x1c050021,0x453c034c,0x829101f4,0x011c0299}},	//   _acerray_, _arxangel_, _berar_, _زەنجىۋىل, 
   {{0x62f001ef,0x78990287,0x63870258,0xd27e0327}},	//   _greitai_, _silvestr_, _baarch_, _ukene_, 
   {{0xb26c0174,0x32d90003,0x00000000,0x00000000}},	//   _ikhola_, _lopen_, --, --, 
   {{0xa2c20338,0xb5600188,0x3c30023e,0x4f5d01dd}},	//   _apelada_, _шимиёӣ_, _apachefr, _batarwan, 
   {{0x62650377,0x5f48008e,0xeab302d3,0xc340000e}},	//   _anunturi_, _coosaana, _интелеге, _gogelia_, 
   {{0x125a03e0,0xde680206,0x52df0064,0xac7c006c}},	// [6f0] _solle_, _aktivít_, _valorat_, _akasona_, 
   {{0x427e033f,0x10760147,0xf36c0435,0xe2d900a1}},	//   _iheni_, _جۉۅگۉمدۉ, _формирај, _topea_, 
   {{0x22d9018c,0xbc74013c,0x729102e4,0x3cea0452}},	//   _kopen_, _asanlaşd, _beraq_, _द्रौपदीच, 
   {{0x43030242,0xf77c0156,0xd2e700b5,0xb0c2004b}},	//   _neqativ_, _קאָשמאַר_, _kapupyry_, _khalemel, 
   {{0x45ac003a,0x94700008,0xcc730034,0x9d53030a}},	//   _ўлими_, _استايئدى, _sverrir_, _bilingüe, 
   {{0x121201f7,0x518401d5,0x2c6a0158,0x3aed00bb}},	//   _lenha_, _بھيجيں_, _गुत्थी_, _فلسفیانہ_, 
   {{0x61ea0294,0xae2b0235,0x52660357,0xe20002a3}},	//   _allitaqm, _राजीवस्य_, _sitokini_, _subie_, 
   {{0x62d9044a,0x8fef0311,0xbe7600e6,0x0903038e}},	//   _cybert_, _ምስትንፋስ_, _地震最新报道_, _cibaduyu, 
   {{0xac630313,0xacaf02f9,0x00000000,0x00000000}},	//   _darurmo_, _enjenyè_, --, --, 
   {{0xf29100b9,0xf2d903f3,0xe365013d,0x52c600ba}},	//   _kerap_, _hopen_, _origino_, _فۆلکلۆر_, 
   {{0x4340038e,0x439400c0,0x584a021b,0x0ac30012}},	//   _telepon_, _pansin_, _дочки_, _तऽआपन_, 
   {{0x329004c9,0x9e5103e7,0xa2d90176,0xd6dc0109}},	//   _trnava_, _vaucluse_, _copen_, _सिभिल_, 
   {{0xc6e5024d,0x9c800125,0x927e0234,0x3ee9018a}},	//   _asebantw, _мерет_, _eyinwa_, _anthracs_, 
   {{0xa3f4026c,0x4c8b04d4,0x647b0165,0xc2260082}},	//   _noster_, _haremgud_, _wirthlin_, _fuskan_, 
   {{0x1d9304d5,0x47c10021,0x77640347,0xc2d4000e}},	//   _jikelele_, _acetatew, _oneindig, _torder_, 
   {{0x520c0207,0xf2e8013b,0xe6d60233,0x90d00447}},	//   _ديندار_, _soliman_, _clarità_, _angokhal, 
   {{0x73f4044b,0x185604d6,0x8f3d04d7,0xac620098}},	// [700] _koster_, _प्रसूतिश, _stafsetn, _svarene_, 
   {{0x0c650386,0xb8980092,0x5f590311,0x12e80042}},	//   _bertemu_, _役にたった_, _ንምዕዳግ_, _atingiu_, 
   {{0x9879017d,0x68470024,0x879f0093,0x3abc0061}},	//   _ジャンル別_, _সংস্কৃতৰ_, _африкан_, _한화꿈에그린_, 
   {{0x070600bf,0xc3a801f0,0xa8d100da,0xc70e0061}},	//   _отдаленн, _bonalang_, _bulevard, _당사자에게_, 
   {{0x0b090249,0x112801eb,0xb90904d8,0x00000000}},	//   _anastane, _anamariá_, _dembiyad, --, 
   {{0x0f3e04d9,0xdcbe006c,0x89cf010f,0x00000000}},	//   _क्रिसमस_, _дареғ_, _amamitha_, --, 
   {{0x32910133,0x9a1000f0,0xe9ef034c,0x437d04da}},	//   _afran_, _percenta_, _arendaga_, _kupače_, 
   {{0x9f2804ab,0xb2b60090,0x61d700e7,0x1afa022c}},	//   _također_, _abudise_, _ashedhay_, _dibukuke, 
   {{0x5ae501e7,0x620201c0,0xab10014a,0x0248000b}},	//   _sendemas, _basine_, _versenyt, _moomia_, 
   {{0xc11f017e,0xd27e04db,0x86cf00a2,0x9e960019}},	//   _ממשות_, _ikena_, _kulalami, _زىۋىز_, 
   {{0xba730435,0x96df038e,0xd3870269,0x00000000}},	//   _mladožen, _membloki, _hierba_, --, 
   {{0x838201a3,0x7121000c,0x69c700be,0x0acc0061}},	//   _ٽائلٽ_, _javorái_, _баратам_, _전화주세요_, 
   {{0xa37b0107,0x4a8301db,0x1b2001cd,0x92010408}},	//   _organel_, _جۇلدىزدى_, _охани_, _atrik_, 
   {{0x525a0296,0xecd90156,0xdf16009b,0xe28b01a4}},	//   _kolla_, _מחריב_, _завтай_, _bakateli_, 
   {{0x5e350393,0xd9f800c6,0x36480268,0x00000000}},	//   _uzgajiva, _моторику_, _eddingsw, --, 
   {{0x852702ec,0xdd23005b,0x5f5d0318,0xfb6600ec}},	//   _پھۆلراوا, _matsumur, _mataafan, _kitokių_, 
   {{0xecf20024,0xa8370177,0xe33200bc,0x6c2302fb}},	// [710] _kultursc, _лахьыҭар, _فیتیله_, _takilotu_, 
   {{0x28cb008d,0xf2d9011f,0x4c75020b,0x24df004d}},	//   _اعتراضی_, _ikangue_, _gaisang_, _業者研發水代汽油, 
   {{0x85a102ec,0x8366016a,0x9a900092,0xfa090348}},	//   _زمانٕچ_, _uragano_, _taliesin_, _alaajana_, 
   {{0x42f20003,0xecf60235,0x441d00f7,0x268902c0}},	//   _archief_, _anativar, _virginio_, _трагична, 
   {{0x441f02e0,0x82c20149,0xfb010195,0x5e8c01d6}},	//   _barataro_, _nbelata_, _clasaige, _medvirke_, 
   {{0x222603f2,0x02d80074,0x32c20200,0x83020159}},	//   _tuskin_, _olleen_, _ibelata_, _nemanau_, 
   {{0x32000033,0x927e00d5,0x93ee0198,0xdb560055}},	//   _lubia_, _ekena_, _kratkimi_, _aritrosa_, 
   {{0x473e0040,0x5437018e,0xb940004d,0x00000000}},	//   _עומדות_, _kokkinak, _以免遭人盜用_, --, 
   {{0xbba20126,0x6dfb0422,0x1b3504dc,0x02d90465}},	//   _lenkeadr, _čudovite_, _کێشراوه_, _kopel_, 
   {{0x72c2002a,0xe2cb012b,0x9def006e,0xa129021b}},	//   _mbelata_, _siedem_, _jàddantu_, _калибров, 
   {{0x22fc00b0,0x0a5103bf,0xf20100d2,0x4c6004dd}},	//   _adiga_, _bamemuoa_, _jurig_, _milutin_, 
   {{0x2c2704de,0x1b3e0271,0x6cfa0161,0x43ea01d3}},	//   _زندگانی_, _fotballs, _видеорег, _siktar_, 
   {{0xe26303c2,0xeccc014a,0x5e56047a,0x05c304df}},	//   _sparingl, _شیرنگ_, _reabilit_, _хассалар_, 
   {{0x631f01cb,0x923700a9,0xe287020d,0x2c2a0123}},	//   _okuyikom, _ikimasa_, _murabizi_, _sovevære, 
   {{0x92d10020,0xdc7204e0,0x6c04014d,0xc4680425}},	//   _feteenai_, _aportes_, _oberhaus, _میلیۆنان_, 
   {{0xe27e0086,0xa2d80028,0xc53700a6,0x1e9500df}},	//   _benned_, _illeen_, _bhayisek, _nautique_, 
   {{0xbecd0241,0x620203b6,0xe28d027a,0x0d930147}},	// [720] _miliyoon, _dasile_, _parkova_, _قىسچۇمۇن_, 
   {{0x820102c3,0x366603a2,0x00000000,0x00000000}},	//   _strih_, _एयरसेल_, --, --, 
   {{0x92e501b5,0xf2c20129,0xe38701ca,0xc2d404e1}},	//   _alingua_, _ebelata_, _gherta_, _osudio_, 
   {{0xe7ba0091,0x77730188,0x027e0163,0x81810040}},	//   _taalamik_, _меоварда, _tenned_, _מדבקה_, 
   {{0x3b5c0375,0x8d0600e3,0x92000176,0xa20100dd}},	//   _anamalir, _baumbast_, _jubii_, _eurig_, 
   {{0x0af003b7,0x128201eb,0x3c6d02af,0x704800f8}},	//   _accesses, _michimi_, _ndorera_, _নিউজরুম_, 
   {{0xa922026c,0x0ecd00cf,0xcdbd033d,0x3e540066}},	//   _所需人才條件說明_, _biliyoon, _demanbre_, _bonbarda, 
   {{0x327e0151,0xe90d0024,0x380d0126,0xd639030a}},	//   _shenn_, _অৱতীৰ্ণ_, _командув, _apróbans, 
   {{0x22d8018c,0xa2d40055,0xf3f40233,0x60c301ea}},	//   _alleen_, _cadorna_, _fortie_, _манучеҳр_, 
   {{0xf2db0092,0xa0b90244,0x5d0d00b5,0xda330299}},	//   _初めまして_, _католиче, _ekatupyr, _ئادةم_, 
   {{0x72ee013a,0xe27e0145,0x1a0e02d3,0x9fda0210}},	//   _fernseh_, _skonis_, _грбот_, _akazodan, 
   {{0x687801db,0x69e60087,0x9e530033,0xb20102c2}},	//   _كادىمگىد, _matomana_, _conburga, _vurig_, 
   {{0x1bf40037,0x2b2b01a7,0x463203db,0x9d0d0177}},	//   _የከተሞች_, _tilaamas, _isingeni, _ikatupyr, 
   {{0xa29001ef,0x7b240099,0xcc240099,0x049002c3}},	//   _punktas_, _angandib, _angandir, _porušujú, 
   {{0xe476041a,0xacc50256,0xa3870313,0x8c71017c}},	//   _процесі_, _notikumu_, _cherta_, _startat_, 
   {{0x5c6e001c,0xd94900da,0x08430117,0x4f270129}},	//   _isernia_, _комитеря_, _pentikos_, _ọmalicha_, 
   {{0xe68e00c5,0x83b20213,0xaf5f01f7,0xbc73008c}},	// [730] _国家税务总局_, _необязат, _citacion, _clostra_, 
   {{0x82910047,0x235b01da,0x52000189,0xc8c70081}},	//   _radars_, _pengesa_, _erbil_, _evitadog, 
   {{0xfa1004e2,0x3a650139,0xf74c0189,0x00000000}},	//   _bercinta_, _anumodas, _benzerli, --, 
   {{0xc3f400df,0xec8000b5,0x92d9013a,0x203504e3}},	//   _sortie_, _иегер_, _noper_, _emitiran, 
   {{0x655101d7,0x22830292,0xbdee0071,0x2d070040}},	//   _provocaz, _nkekewa_, _همتون_, _האקסקלוס, 
   {{0x8c1d0060,0xbe020111,0x00000000,0x00000000}},	//   _بابىردىڭ_, _accetera, --, --, 
   {{0x56aa033b,0x77950073,0x9729006d,0x520203db}},	//   _bongwadi, _postmeri, _архаічны, _masibe_, 
   {{0x54850139,0xa61c04e4,0xa7ac04e5,0x3a850013}},	//   _आस्थाय_, _usporedi, _amatikki, _tonnadan_, 
   {{0xc5ed008d,0xc58701db,0xf2d9015e,0xd20103eb}},	//   _خانخانان_, _ارسەنالد, _copes_, _jurie_, 
   {{0xc27e0314,0x68480163,0x22000145,0xb125032d}},	//   _bkeng_, _الاحادیث_, _teniso_, _илмира_, 
   {{0x56b502a6,0x8d7c0203,0x89610291,0x921301ca}},	//   _andatevi, _vúlnere_, _بإنهاء_, _sighbe_, 
   {{0x6c51016e,0x13f404e6,0xfa640420,0x0795027b}},	//   _noktaya_, _abutan_, _веренико, _candanav, 
   {{0xe2ec0410,0x6e8b04e7,0x48910094,0x07cf0156}},	//   _agribee_, _neskutoč, _الداۋعا_, _מִצְרַיִ, 
   {{0x6ec6019b,0x09a200d1,0x83f9000c,0x00000000}},	//   _кантакт_, _ইচ্ছামতে_, _krauch_, --, 
   {{0xe2ca042b,0x6f3a0080,0xb42b0014,0x00000000}},	//   _prolazi_, _aperilaa, _kompozon_, --, 
   {{0xe201022f,0x0f720299,0xf31d0220,0xf34600bd}},	//   _kurie_, _تېمپۇرات, _miscela_, _puddins_, 
   {{0x72da0437,0x775402cf,0xcea80160,0xf2d90238}},	// [740] _dyrere_, _легализи, _austrije_, _doper_, 
   {{0x4b0a0132,0x467b0082,0x52d10083,0x30f10209}},	//   _okostele, _kwakwalw, _attempai_, _atungarl, 
   {{0x8c36000c,0x68c10128,0x02da023a,0xc37c02a1}},	//   _алидерцә, _аёлдан_, _myseľ_, _gewasse_, 
   {{0x9329004d,0xbe55023e,0x429001d5,0x2e060257}},	//   _完忘扶折批扶抆扼, _bilangke_, _balazs_, _bundinna, 
   {{0xc3e90076,0x2e030073,0x83f800ed,0xf643021c}},	//   _resoluçã, _assecura, _anaus_, _bezbarié, 
   {{0xf9cb0101,0xb27f0159,0xa3f40064,0xa22600ee}},	//   _serviciu, _dienai_, _costar_, _parkea_, 
   {{0xc2d50169,0x7a650076,0x3fca00f4,0xbc1604df}},	//   _রূপকথা_, _criminos, _diziorro, _borsuň_, 
   {{0x502400ff,0x8da80075,0x32920308,0x00000000}},	//   _דראביטש_, _fonglast_, _jasamu_, --, 
   {{0x5ea8018d,0xa19a00ff,0x43a90311,0xf29200e1}},	//   _ንተኻፈልቲ_, _וואלדמאן_, _ተግባራቶምን_, _estale_, 
   {{0x986e003b,0x32fa01e1,0x00000000,0x00000000}},	//   _asengibu, _dichesa_, --, --, 
   {{0x8601017f,0xe29203ea,0xd12e01f3,0x1176038e}},	//   _aallarti, _hasard_, _lososová_, _विषयांच्, 
   {{0x9a5201d5,0xd14500e3,0xb2f002b1,0x26af0291}},	//   _بریڈفورڈ_, _esternal, _muminai_, _gclúdóid, 
   {{0x985f0338,0xa67a02a4,0x2a4d0057,0xa563017d}},	//   _demandar_, _remedium_, _menderma_, _asylansø, 
   {{0x63ea00f5,0x684e0334,0x581102eb,0x570803a8}},	//   _wiktor_, _amalimid, _нөхдөө_, _klarsprå, 
   {{0x42920172,0x2ea100e4,0xe4000244,0x9b95036c}},	//   _kasamu_, _nadmiern, _нейна_, _hiringir, 
   {{0x137a030b,0x10b80040,0x1573018d,0x728a012b}},	//   _kigambo_, _התצוגה_, _ኣዲስኣበባ_, _niskiej_, 
   {{0x2fc201c5,0x218a0162,0x7e5d01db,0x124a00b5}},	// [750] _والون_, _дослуқни_, _таратуға_, _chumbe_, 
   {{0x82fd002a,0x00000000,0x00000000,0x00000000}},	//   _abaghi_, --, --, --, 
   {{0x8ae9041e,0x9da900b8,0xd27e0387,0xcd7e0177}},	//   _intrapre, _kusisita, _ekene_, _anamanda, 
   {{0xceba0023,0x450e014a,0xa5e80163,0x6c1304e8}},	//   _пошли_, _percről_, _kandalló, _amassats, 
   {{0x727e0380,0x620600da,0xb2920165,0x00000000}},	//   _mienx_, _интернац_, _sasalu_, --, 
   {{0xad2a0205,0xc86302c0,0x00000000,0x00000000}},	//   _саиджаҳо, _новаци_, --, --, 
   {{0x7dfd0462,0x8c530046,0xc25a02a4,0xb2d9009f}},	//   _agreedwa, _montoro_, _nolle_, _poper_, 
   {{0x82ec01f7,0xe66a02eb,0x1d5603c3,0x38780311}},	//   _civisme_, _соронзон_, _ispadaju_, _ኣተረጓጒማ_, 
   {{0xb98b0244,0xa3860210,0x5af50211,0xaf210024}},	//   _richiest, _abirwa_, _operaatt, _avstanda, 
   {{0x58890058,0x805300ce,0x22f30008,0x70db03a2}},	//   _boekhand, _konstren, _pirineu_, _आफरीदी_, 
   {{0x33560286,0xecbb04e9,0x43eb007f,0x3a2a018d}},	//   _aspenas_, _maliruaq, _dicter_, _ኣብክንዲ_, 
   {{0x434402a6,0x1f3602ea,0x960904c7,0x00000000}},	//   _cruelle_, _пресата_, _западноб, --, 
   {{0xd3be0220,0xae4a018d,0xbdaa02f3,0xb7cc0142}},	//   _giovani_, _ልፍንታዊ_, _aktivera, _asappuri, 
   {{0x0ede037f,0xf26d0075,0xe3ee0166,0x835b0362}},	//   _milyonla, _amboð_, _qualifiz, _bengisa_, 
   {{0xa6b403c1,0x9c5a04ea,0xe2480275,0x229201fe}},	//   _отстране, _pyntrei_, _onomea_, _yasamu_, 
   {{0x2b17019c,0x62900062,0xc3ce008d,0xc4ce0078}},	//   _alábàási, _dajad_, _талабини_, _талибани_, 
   {{0x9c750193,0x1ea80135,0x82350136,0xea8002be}},	// [760] _शिक्षण_, _премодер, _pasmine_, _daantaon_, 
   {{0x6fba0013,0x903b0372,0x00000000,0x00000000}},	//   _фаровонл, _graffego, --, --, 
   {{0xb81304eb,0x211901db,0x06990008,0xb143005b}},	//   _हरिओम_, _بالگەرلە, _гэсинин_, _besutaro, 
   {{0xcc66007b,0xc3b40152,0xbd8102e2,0xca380364}},	//   _britons_, _птерозав, _alembica, _ozonwäer, 
   {{0x62d80415,0x139404c0,0x2b1804ec,0xa2900163}},	//   _allein_, _mansin_, _ayiguris, _hajad_, 
   {{0xc13602fa,0x9201018c,0x840404df,0xea3c0040}},	//   _amadoral, _ruzie_, _başlajak_, _ומקפיאים_, 
   {{0x58d500c1,0x8fc500c1,0x10520033,0xae4e009a}},	//   _आशुचँप_, _गलिच्छ_, _charplin, _ekwafana, 
   {{0xd27e02fe,0x7c75027b,0xe43500d1,0x035301ec}},	//   _izinga_, _सहस्रं_, _এক্সপ্লে, _پهلان_, 
   {{0x42e903f2,0x61eb00bb,0x60e500c7,0xa8e5004a}},	//   _kotimaa_, _اندوزی_, _aradaşlı, _aralaşuı, 
   {{0x5c75045f,0x43f900b3,0xac750255,0xb27f00ad}},	//   _minuter_, _soyup_, _चुक्का_, _baengi_, 
   {{0x8964009a,0x27af04ed,0x0a7d0315,0x64d70205}},	//   _abangoot, _देवस्थान, _ayanyats, _маскани_, 
   {{0x835b040b,0x6aa8006c,0xc20000ed,0x5ec1005b}},	//   _rengisa_, _abakujab, _gamita_, _banneran, 
   {{0xfc0201df,0x32fd00dd,0xf7ad0187,0x4fd00192}},	//   _cassies_, _chegin_, _ерусалим_, _culinair_, 
   {{0x62ee005c,0xf0360007,0x52d900cf,0xd2000408}},	//   _irindwi_, _dutelono, _fixee_, _hamita_, 
   {{0x4e03037a,0x69260074,0xc77b0133,0x02c6008a}},	//   _masezera, _причины_, _akawunti, _atalale_, 
   {{0xc6b7021a,0xe98f002b,0x529102f3,0x00000000}},	//   _allaatti, _বিবেচনায, _befann_, --, 
   {{0xab8e04ee,0xf27b01f4,0xb85804ef,0xbc760335}},	// [770] _kuzigwor, _temuriyl, _amarelos_, _cśrīc_, 
   {{0x920104af,0x6fd100d1,0xc4350169,0xbac00367}},	//   _isdias_, _নিউজপেপা, _এক্সপ্রে, _análise_, 
   {{0xb6d30034,0x32fd01b2,0x01ac0060,0x7c1102ef}},	//   _tungumál_, _shegin_, _аянышты_, _kompayi_, 
   {{0x13970056,0xcc0202a1,0x00000000,0x00000000}},	//   _турсунзо, _passies_, --, --, 
   {{0xce5600d9,0xeea4011d,0x9b060204,0x225a03f0}},	//   _простая_, _distruge_, _hauskast, _felldi_, 
   {{0xbc3502c3,0x3c63022b,0xe85003ec,0x7341013a}},	//   _topartic, _limunum_, _hollivud, _logelin_, 
   {{0xc23b0025,0xa0490265,0xdcc6010d,0xdbcb01c7}},	//   _नारायणाय_, _doorgaan, _vaginaku_, _balkanyň_, 
   {{0x2291049e,0xb7c40367,0x126700e6,0xc2c80148}},	//   _teraz_, _brasilei, _树立和落实科学发, _incolae_, 
   {{0x127f011b,0x0c380177,0xa62401a4,0x852701f3}},	//   _azanga_, _рықәҵара, _nakokomi, _prozaick, 
   {{0x12d804f0,0xa3e000ee,0x627701a4,0xddb10021}},	//   _dihek_, _медалийн_, _asangani_, _acticump, 
   {{0x969b0440,0x62d802e7,0x99ca0240,0x620000c4}},	//   _baseruki, _golean_, _rokowaqa_, _arbia_, 
   {{0x998e00af,0x904100bc,0x4c000143,0x4c7a0244}},	//   _таких_, _رئیسه_, _viaggiar, _зверски_, 
   {{0x3fa90019,0x527f048f,0xdd5e00f8,0x82fe018e}},	//   _crític_, _ezanga_, _করুণাময়_, _novhele_, 
   {{0x787a04f1,0xa2770414,0xa17c0014,0x075c0462}},	//   _dionysiu, _esangani_, _avantazh_, _eclining, 
   {{0x32910230,0xd7470162,0x33000399,0x6200012d}},	//   _feray_, _пикирни_, _kamatai_, _subim_, 
   {{0x093a0125,0x2b5c0350,0x99c50148,0xefa3004d}},	//   _гадаганл, _ኮምፕሌክስ_, _aspernat, _中國新聞簡訊_, 
   {{0x6e0300ca,0x03bd04f2,0x0c2803ae,0x8c0a00de}},	// [780] _assegura, _chovinh_, _innebære, _amathams, 
   {{0xf26201c5,0x0c6200f6,0xafbf007f,0x00000000}},	//   _عاشقا_, _prosesə_, _hocedwyr_, --, 
   {{0x92010066,0x42fc0062,0xc25a024c,0x00000000}},	//   _zuria_, _jingol_, _godla_, --, 
   {{0xc6c90194,0x559100d6,0x249b0088,0x4f9200a1}},	//   _incapabi, _التالى_, _түркияны_, _hāereere_, 
   {{0x37d701f4,0xf317012a,0x3425027b,0xd9e70420}},	//   _سارانول_, _straży_, _ऋषीणां_, _паметни_, 
   {{0x1c680037,0x464f00de,0x50b504f3,0x00000000}},	//   _ተደራዳሪ_, _elikumyi, _गुरुची_, --, 
   {{0x898f0135,0xdb64032e,0xb4ac0147,0xd2020338}},	//   _убликасы_, _uchumasa_, _دەۋۇشكا_, _arties_, 
   {{0x805a008d,0x22900275,0x6a040143,0x8341014b}},	//   _عرفانی_, _aunaga_, _акцентир, _tajeero_, 
   {{0x123901f2,0x498702f0,0xdae4002b,0xa20002c7}},	//   _қобул_, _bayifaka_, _কাহালু_, _urbia_, 
   {{0x99e2020d,0xf277033d,0x33f80195,0x494100ec}},	//   _haboneka_, _byenvini_, _comunn_, _атлетыка_, 
   {{0x088a026f,0x220102df,0x8c8a00a4,0x06460242}},	//   _ارپىندە_, _suria_, _زدۇلانعا, _bashlayi, 
   {{0xc26e019c,0x2e5504f4,0x369400e6,0x82ee017a}},	//   _ekpoma_, _graciosa, _留言板管理人员有, _ayafa_, 
   {{0xd2fc031e,0xfda400e7,0x10b10153,0xdbc60185}},	//   _ističu_, _allieswa, _窓口一本化_, _автойөре, 
   {{0xc34b0473,0xe27f0175,0x3b9a015e,0x0a1f0297}},	//   _scheint_, _azanda_, _بىلمەك_, _айсыз_, 
   {{0x162102bd,0x43ea01f6,0xf8970075,0x6a5901a3}},	//   _annuwiol_, _diktar_, _bókhaldi, _ڊوائيسز_, 
   {{0xa21c033e,0x7ae20096,0xbcb201de,0x12d000d1}},	//   _itakarai_, _babukere, _янушкеви, _সঠিককৈ_, 
   {{0xa33a0361,0xe91e00bb,0x0c180074,0x00000000}},	// [790] _надгроби, _مستحقین_, _syntyä_, --, 
   {{0x2be3013c,0xbc580168,0xd2360157,0x3c3504f5}},	//   _teleapar, _taktikk_, _uboju_, _rasadnic, 
   {{0xb55700bf,0x02010116,0x098e00d7,0x94d50012}},	//   _выравнив, _durin_, _закир_, _घुसिआय_, 
   {{0x941500eb,0x09a701ee,0xc5830166,0x65a90311}},	//   _anonsemk, _закаев_, _supersch, _ከብጽሓና_, 
   {{0xfc4e02ec,0x127e02a3,0x02da01ed,0x329204f6}},	//   _زمانچ_, _skenk_, _pepehi_, _optage_, 
   {{0xa29e0041,0xcfcc0037,0x12d40289,0xb2010014}},	//   _véase_, _ዴቨሎፐሮች_, _analitu_, _anaidi_, 
   {{0x94ab029f,0x12fe0263,0x01c30255,0xb2d9005b}},	//   _nastaviť_, _serieus_, _lammutam, _baworks_, 
   {{0x628b0075,0x13b50016,0xbb0700ee,0x0333018a}},	//   _bilafram, _solvita_, _hausnart, _catholig_, 
   {{0xe20100a0,0xc2c30281,0x3127010f,0xca6700cb}},	//   _burin_, _abelsen_, _панохи_, _кунҷора_, 
   {{0x62ea0156,0xbb3a00a6,0xe20101b2,0x080c0361}},	//   _ekzisto_, _کلاشينکو, _atrip_, _блокĕ_, 
   {{0x3200024b,0x4e5d0037,0x9a1f00a4,0x4d2f0170}},	//   _tenido_, _ለማሰልጠን_, _conscièn, _hisitore_, 
   {{0xf3eb00c8,0x7a390046,0x427e0494,0x085b00bb}},	//   _barupedi_, _берели_, _samnji_, _اٹھہتر_, 
   {{0xbecd01e7,0x48af02ac,0x90400156,0x22010068}},	//   _verzerrt_, _تحدثت_, _קעסיידער_, _furin_, 
   {{0x42d904f7,0xa11a00e5,0x3201001e,0x2e940226}},	//   _gopet_, _борба_, _gurin_, _adamuyan, 
   {{0x5a6b01e1,0xb202013f,0xd79f005b,0x2fc804f8}},	//   _bafosets, _hatier_, _bekendtg, _lexingto, 
   {{0x3fbb01d3,0xbdac0219,0x932002a0,0xa4b300a3}},	//   _fungerar_, _alinakup, _isoya_, _romarrik, 
   {{0x395c02c9,0x9698006c,0x3c680162,0xc29001a3}},	// [7a0] _понегрир, _abawaziy, _таможнис, _matamshi_, 
   {{0x400f035b,0x820101ef,0x3c4b0166,0xd0b801fc}},	//   _priporoč, _kurio_, _achtung_, _moominih_, 
   {{0x8ea6046d,0xe0610206,0x727e01f1,0xc26c02c5}},	//   _ndalukan, _nepriazn, _skena_, _chiono_, 
   {{0xc3ea0142,0xe2ef0251,0x22ee00c1,0x4bf70105}},	//   _siktir_, _dejinta_, _syafi_, _मान्यताए, 
   {{0x12ce049e,0x4727003c,0xa1e900bb,0x47bc001c}},	//   _akadémia_, _تراست_, _کےنام_, _kalundii, 
   {{0xd6f800c8,0xa25a0332,0x64e80094,0x181501cd}},	//   _тракторс, _polla_, _تاماشامو, _муқарар_, 
   {{0x7c8a002c,0xa27802a2,0x6183027e,0x78970075}},	//   _уралдаан, _kaunti_, _алати_, _bókhalda, 
   {{0xec4e01c5,0x0316005e,0x025a0055,0xb9af01a0}},	//   _زمانن_, _ﻗﯧﭽﯩﭗ_, _volla_, _foodlove, 
   {{0xc201005b,0x54ab0206,0xb26d02c2,0x031c0156}},	//   _purin_, _zastaviť_, _regoor_, _פלאקערט_, 
   {{0x1e8801ea,0xa24f00d9,0x78090223,0x033801de}},	//   _یوناما_, _remontti_, _тандалты, _айлардың_, 
   {{0xe2fc04aa,0xf6b604f9,0x39e90333,0x03f4015e}},	//   _adaga_, _allattui, _antipapa_, _virtut_, 
   {{0xb9d90016,0x825a00bc,0x7e820299,0x6ae700df}},	//   _אינדרויס, _makluk_, _ئوغوللار, _bretonne, 
   {{0x027e04fa,0x836f0274,0x5eb2004d,0x96ce004d}},	//   _okenn_, _byggist_, _你以為你是誰_, _凡本網註明_, 
   {{0x526502d3,0x00bc0448,0xe34a02ba,0x1fd803cf}},	//   _агенции_, _fremstil, _abafile_, _kartınız, 
   {{0x79ca0144,0xab1f004e,0xd3870144,0xc2950235}},	//   _khaliefa_, _dinalian_, _mbarra_, _प्रोतं_, 
   {{0x927e0018,0x62910009,0x7e400109,0x2201009f}},	//   _bhenu_, _igrah_, _घोर्लिखर, _utrip_, 
   {{0xb4f70005,0x8202018b,0x59dc014d,0xc6df0122}},	// [7b0] _communal_, _vasile_, _hergeste, _pembloki, 
   {{0x029e00b3,0xf7d00145,0x68e30094,0x98af0087}},	//   _дилар_, _многа_, _бурын_, _mindhavu, 
   {{0xe27e00ab,0x12fc01f6,0x44e904fb,0x921003c3}},	//   _whenu_, _leige_, _pantalón_, _psihicki_, 
   {{0x49df04fc,0x129101fc,0x32910103,0x0e0f02cf}},	//   _বিলুপ্ত_, _agrak_, _kufara_, _arrecada, 
   {{0x7abe0037,0x62e80037,0x74400002,0x72ec030d}},	//   _በዋነኝነት_, _hiliran_, _svekolik, _erzinde_, 
   {{0x525a004b,0x2ad40435,0x4dd00242,0x53cf0453}},	//   _mollo_, _đoković_, _sarkisya, _odavde_, 
   {{0xce5101ba,0x8d3a038e,0x12e802be,0x95490143}},	//   _lavansma, _shahabat_, _bilisan_, _мездра_, 
   {{0xe80a023d,0xaa39015e,0x048600c1,0x7dba02ac}},	//   _струва_, _денеси_, _माघारी_, _يساهم_, 
   {{0x634101e0,0xe2910243,0x07af0005,0xe3f9016b}},	//   _بۆتان_, _agrah_, _fuormazi, _biyun_, 
   {{0xffda0437,0xac0701dd,0x34a203f8,0x16e30187}},	//   _forhisto, _tharciss, _hornbill_, _олимпија_, 
   {{0x774500e5,0x3bab04d8,0x623f0132,0xe2900277}},	//   _владата_, _گردابس_, _bankszám, _mabag_, 
   {{0xefc80220,0x7be30227,0x729102e2,0x94a3047d}},	//   _visitato, _melempar, _anaash_, _breissel_, 
   {{0xeab604fd,0x32fc03ea,0x127e00a0,0x2344008e}},	//   _हावड़ा_, _neige_, _ayinsa_, _gendiku_, 
   {{0x17910231,0xa30501ac,0xc25a0058,0x72d4041b}},	//   _sententi, _رويال_, _dollo_, _sordar_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2bc0277,0x2a080189,0x02fc0020,0xfb2701c4}},	//   _kredito_, _yunanist, _keige_, _dinamies, 
   {{0xc29002e7,0xe15c010d,0x00000000,0x00000000}},	// [7c0] _kabag_, _एअरपोर्ट, --, --, 
   {{0x620000c3,0x478800ff,0x035d0312,0x12a60223}},	//   _orbis_, _װײַבער_, _arnevez_, _proban_, 
   {{0x07de0187,0x4b07015e,0xeba402f6,0x00000000}},	//   _законски_, _билемин_, _disipulo_, --, 
   {{0x93f404b2,0x38b901f4,0x0a9e0082,0xa25a0220}},	//   _abutin_, _қарасанг, _barikins, _bollo_, 
   {{0xac1d0325,0xb25a01cf,0xb2120172,0xbd2f0155}},	//   _insanlar, _collo_, _renhu_, _skrivare_, 
   {{0xf3f903e6,0x530003ba,0x46e800da,0x02e80119}},	//   _brauch_, _catarrh_, _трактоар, _biliran_, 
   {{0x420104b9,0xbbf502b9,0x58670279,0xd6160075}},	//   _aurie_, _اوردوسرے_, _cuisines_, _innlogni, 
   {{0x8c5501b2,0x9f000169,0xe25a01bf,0x2e920128}},	//   _mouthed_, _যাবজ্জীব, _follo_, _порталш_, 
   {{0x3290004e,0xff5602a6,0xf2de0177,0xa2900251}},	//   _babag_, _guignols_, _мацароуп_, _labad_, 
   {{0xfb3e045f,0x1d780164,0x48c500d8,0x327f0418}},	//   _fotbolls, _елментли, _acordatg, _inanan_, 
   {{0xc2900015,0x4ae7041f,0xc2fe023c,0x7a1501c2}},	//   _nabad_, _siprofet, _atshate_, _barbanza_, 
   {{0x465b006c,0x626e0130,0x995303b3,0x89c202b0}},	//   _abakholi, _ratozh_, _monstrar_, _bundesst, 
   {{0xa290022c,0x827e046b,0x92dd04fe,0x59e600d5}},	//   _najan_, _rhent_, _ritorni_, _natokana_, 
   {{0x2f240089,0x5202026c,0x4ef9044a,0xd2cb021e}},	//   _вятка_, _istius_, _diswaswa, _skadat_, 
   {{0x429002d4,0xad9c020f,0x7981008a,0x5b70001c}},	//   _hajan_, _basendle_, _peritome, _maglasur, 
   {{0xdf680041,0x9e3504ff,0x371000ff,0x0290029b}},	//   _cabañas_, _sigaigva, _נאכקוקען_, _galaas_, 
   {{0x22bc023d,0x5c550220,0xa2fc0108,0xb14600d1}},	// [7d0] _credito_, _montare_, _ningal_, _ঘৰলৈকো_, 
   {{0x563903a0,0xf2560499,0x2d2a00da,0x71cd02a5}},	//   _akantshi, _agalelei_, _статале_, _afričtí_, 
   {{0xb29000e1,0xb27f006a,0x3715022b,0x34ff00a1}},	//   _balaas_, _ananan_, _partinum_, _haumapuh, 
   {{0xd2b0039f,0xa439006f,0x71b80141,0x00000000}},	//   _proclaim, _عبارتن_, _биргалаш, --, 
   {{0x929104da,0xc06d0044,0xd2d402bc,0xca0700b0}},	//   _hrvata_, _הסלבס_, _kordor_, _cambaare, 
   {{0x7c530043,0x41ef020f,0x828a028f,0x92900277}},	//   _akitalo_, _دبېلګې_, _kuratini_, _kabad_, 
   {{0x67530016,0xd5cb03cf,0x762001c3,0xf290029b}},	//   _לאנדא_, _tamamlay, _annooini, _falaas_, 
   {{0x8de8002b,0x340f005e,0x72d50126,0xc573015e}},	//   _শক্তিকে_, _ﺧﺎﺗﯩﺮﻩ_, _кліпів_, _adolescè, 
   {{0x4201003a,0xa27e0247,0x7b020347,0xdb350313}},	//   _turib_, _ajeng_, _weerspie, _dasawnis, 
   {{0x6a16023e,0x729001aa,0xe5d600e7,0x935b0087}},	//   _minangka_, _agbay_, _alibutsh, _khigela_, 
   {{0x529000bc,0x796400b9,0x29ec0288,0xa8cf0252}},	//   _iclass_, _जीवनात_, _buriouta_, _zwiendeu, 
   {{0xd26e02aa,0xe2490343,0xb2020005,0xfb5703d4}},	//   _batohy_, _angmga_, _butias_, _pritvora_, 
   {{0xe4b4009b,0xbf5a033e,0x4c6b0193,0x229101b8}},	//   _didaktik, _scipione_, _कुत्रा_, _arvata_, 
   {{0x514500f5,0x9696029f,0x32020307,0xf4180038}},	//   _душманы_, _posedeni, _basike_, _месхет_, 
   {{0x127e02b2,0x6b5c0196,0xb96d00cd,0x8c0200bd}},	//   _gjeng_, _chimalir, _biancott, _lassies_, 
   {{0xc29000a8,0x7c6f03ac,0x6af301db,0xaa6d01dd}},	//   _pajan_, _ukhuwah_, _алдымнан_, _ayigenga_, 
   {{0xe29203e6,0x7ed6031e,0xf191031a,0xe95f00a6}},	// [7e0] _optakt_, _držao_, _dunbeath_, _پېغمبر_, 
   {{0x9ee20246,0xffbf02ac,0x3c070500,0x00000000}},	//   _стоки_, _رحمتك_, _bamugamb, --, 
   {{0x52fc02fd,0x7917014e,0x95ab00be,0x08ba0220}},	//   _aingil_, _средине_, _دىنامو_, _двореца_, 
   {{0x1d3000a6,0xe430006c,0x6151032d,0x2c530255}},	//   _abasesic, _abakubiz, _һәммәһе_, _nautida_, 
   {{0x777c02ac,0x330d02d0,0x03eb0060,0xf18c003c}},	//   _زيزووم_, _depairt_, _айдынынд, _نادرترین_, 
   {{0x2c2601a3,0x22c601b9,0x027e021f,0x00000000}},	//   _راڻيپور_, _realime_, _diinan_, --, 
   {{0xf2900005,0x02e9033d,0x13fd0315,0x62900068}},	//   _sajan_, _andidan_, _akunendz, _xabad_, 
   {{0x2a6c03bf,0xb2fd02e6,0x53f90185,0x25120147}},	//   _вагондар_, _arkiver_, _biyue_, _كەيئگەن_, 
   {{0x66d30501,0xef1f00c9,0x25a3017f,0x253d01a3}},	//   _साहिब_, _santaiga, _astridik, _چيڀاٽي_, 
   {{0xb0ab0109,0xa52402e7,0xf2fa02c9,0x6bc50502}},	//   _टुहुरा_, _kutsilyo_, _inchisa_, _miscawin_, 
   {{0x05ff018d,0x620002d3,0xc14800de,0x19530128}},	//   _ብሓባራዊ_, _menino_, _angenaml, _сўздан_, 
   {{0x5b430061,0x52640277,0x7506011a,0x2a3600be}},	//   _국회의원선거_, _ihulad_, _ובטוחה_, _бекмамат_, 
   {{0xd3f900b1,0xac600503,0x703201ab,0x8d0a0177}},	//   _nique_, _styring_, _मुँहे_, _embopore_, 
   {{0xb3340016,0x7d5e0504,0xe6960024,0x00000000}},	//   _סאציאלע_, _विम्बल्ड, _সাঙুৰি_, --, 
   {{0x85810088,0x856c0335,0x73640367,0xd2910002}},	//   _депутатт, _प्रसज्ये, _chegada_, _igrao_, 
   {{0x025a0505,0xe9eb002c,0x01d1011c,0x426c0055}},	//   _sollt_, _langilee, _attekaay_, _arnoud_, 
   {{0xbedc0194,0x9da600ac,0x535d0033,0x247100a6}},	// [7f0] _juristes_, _navikava, _lungatg_, _تجاران_, 
   {{0xdfca0366,0xf3a902ac,0x7226030d,0x14e10142}},	//   _принимал, _جزءاً_, _petkim_, _रामभद्रा, 
   {{0x5da901ef,0x72fc04b2,0xb27e0506,0x325a03e6}},	//   _atsiliep, _singil_, _ukens_, _wolls_, 
   {{0x0d9401a2,0x2df10059,0xf7ad02be,0x00000000}},	//   _finanšu_, _studiare_, _dudurugi, --, 
   {{0xa9db0485,0x32da0448,0x82640145,0x00000000}},	//   _forelske, _dyrene_, _siulau_, --, 
   {{0xc20101fe,0x429000bc,0x89e502ac,0xe294011b}},	//   _muria_, _xclass_, _كنترول_, _bisaleli_, 
   {{0xe2ca0195,0xdbfa0196,0xc03d0151,0xeb6e0260}},	//   _chidhe_, _amenenso_, _aragatso, _senlleir, 
   {{0xe9fc0191,0xf26103fd,0x926c0099,0x12000439}},	//   _tekniska_, _polokiki_, _chioko_, _mamisa_, 
   {{0xbbfd026c,0x6201015b,0xdc060156,0xb20000f7}},	//   _被引用次數_, _guria_, _בשלימות_, _benino_, 
   {{0x3f2e0044,0xb24802f3,0x8c230450,0x02da0014}},	//   _editoria, _hemmet_, _ferneamd_, _biznese_, 
   {{0x359300de,0x4f370013,0x1dab031a,0x3ad404b9}},	//   _zaseburh, _uskunala, _connraga, _chattere, 
   {{0x120104b8,0xbebb00df,0x5edc00a4,0x02010139}},	//   _buria_, _tourisme_, _turistes_, _atrir_, 
   {{0xaebf0037,0x22e101ab,0x92770507,0xfae90039}},	//   _አገላለፅ_, _बूझीं_, _bernilai_, _польш_, 
   {{0x43b6029f,0x2740011b,0x23060057,0xbd9f0076}},	//   _dievča_, _bakowang, _samalah_, _pingente_, 
   {{0xf25a015c,0xa03f01d1,0xe3420193,0x42010066}},	//   _solls_, _listenin, _gesekan_, _euria_, 
   {{0x9aec0357,0xcb4001be,0xc25a01d1,0xebba019b}},	//   _bubuluit, _celoročn, _polls_, _аварыі_, 
  
   {{0x93cc00f5,0x847001db,0x9a830184,0x18f601de}},	// [800] _башланяр_, _ұйытқы_, _domitien_, _секциясы_, 
   {{0xe5670061,0x13f004ad,0x543e045e,0xdb9502e1}},	//   _일본직수입구제티_, _dumelang_, _фаянс_, _fisiteir, 
   {{0x9b8c0040,0xe73b0071,0x4dd60025,0x32d80342}},	//   _ולהבין_, _فیروزآبا, _apānau_, _kodenn_, 
   {{0x820102da,0x58fc012f,0x6271022e,0x9201000c}},	//   _atriz_, _karaququ, _frastagl, _heviro_, 
   {{0x1ca1014e,0x72e9031c,0xa2900015,0xcac00260}},	//   _особом_, _indican_, _jajab_, _diálise_, 
   {{0x82000499,0x6d600128,0xc3a201bf,0x6aea0344}},	//   _samita_, _هاویلند_, _kamper_, _atatsime, 
   {{0xa2840166,0x1af501a3,0xc16c0147,0x258904fb}},	//   _einkauf_, _فرقيوارا, _سلىكپ_, _comisarí, 
   {{0xe2ec00bc,0xd20100cf,0xc4ea0095,0x63040203}},	//   _aabiete_, _furii_, _تعالیم_, _miracul_, 
   {{0x669c0372,0x6e9604a7,0xdb8f009a,0x116b0255}},	//   _arteithi, _mantense_, _besigeor, _kutsekoo, 
   {{0xa51b0508,0xe2880497,0x8200046d,0xc2ca022a}},	//   _kholidzh, _derangem, _tamisa_, _neodoy_, 
   {{0x038704b7,0x3b280008,0xb2ca0509,0xaba80181}},	//   _daarna_, _ئۇللىنىش, _produz_, _babychan_, 
   {{0x5ea800db,0x19cd02ff,0xa0660147,0xb6d10449}},	//   _kindlaks_, _lezekrit, _مۉچۉلۉشت, _metalnim_, 
   {{0x50f103dc,0x22c5045f,0x9c550098,0x7d2701da}},	//   _grundarl, _gillade_, _montere_, _rajonale_, 
   {{0xb1770368,0x910d00a7,0x9278031a,0x1a310024}},	//   _месту_, _замандаш_, _bàigheil_, _দেখিছো_, 
   {{0xf2c8018b,0x07f20192,0xd1270013,0xb27e02ae}},	//   _nicolae_, _일간스포츠_, _газовик_, _sjene_, 
   {{0x5c750007,0x82900369,0xe95800da,0xcea704ae}},	//   _ennuyer_, _punana_, _calorife, _разводу_, 
   {{0x05ae045e,0x237f038b,0x7c2001bd,0x729000b0}},	// [810] _позволен, _penanda_, _توبەمنەن_, _fajac_, 
   {{0xe2fc0499,0x92da042b,0x4c1d0185,0x757e03a4}},	//   _iliga_, _štene_, _ekrannar, _evolutió, 
   {{0x329000db,0x52eb038f,0x00000000,0x00000000}},	//   _sajab_, _fizikel_, --, --, 
   {{0xe27f040b,0xa437011b,0x92d700ec,0xd2ef0227}},	//   _khuni_, _ebikisak, _klientai_, _dahinya_, 
   {{0xeafb0241,0x5200027f,0x47580287,0x38520059}},	//   _afarsine, _bamira_, _सिग्देल_, _реставри, 
   {{0x625a02c3,0x620002af,0xf91200ba,0x4291050a}},	//   _podla_, _camira_, _مڕاستی_, _duvara_, 
   {{0x83f00108,0x3dc0050b,0x2d6d00f8,0x00000000}},	//   _sumedang_, _disinila, _বোরখা_, --, 
   {{0xf598025b,0xae470040,0xc9ba003c,0x43f401df}},	//   _monnunum_, _מעטפת_, _فرايند_, _kirtle_, 
   {{0xdb82012e,0xe75a00bc,0xd2ef008b,0x1ccc0343}},	//   _تجلیات_, _اقداماتی_, _kilimaa_, _maihatud_, 
   {{0x4c760282,0x05c8028a,0x29ca005b,0x00000000}},	//   _haironi_, _ushawish, _cococara_, --, 
   {{0xd27e0320,0x925a0372,0xd3fd042a,0xec780037}},	//   _akeni_, _golli_, _akunandz, _ትምህርቶችን_, 
   {{0x338702c2,0x8afa0076,0x929101c7,0x606a004d}},	//   _waarna_, _предаден, _agras_, _討論進行中_, 
   {{0xac5a0245,0xa48b0092,0x1270025b,0x8fcd008d}},	//   _syntiew_, _パティスリ_, _byggisam, _файласуф_, 
   {{0xa2910034,0xf9ee000f,0x0dd00241,0x00000000}},	//   _punktar_, _iktidara_, _harkisee_, --, 
   {{0x127e0262,0xe20e0056,0xd3fa01e6,0x9dfa0238}},	//   _ekeni_, _насаб_, _okruhu_, _лінки_, 
   {{0x625a006e,0xe387003f,0xfe4f0357,0x98480226}},	//   _dolli_, _cherdi_, _semasema, _bvumbulu, 
   {{0xa4200192,0x6f0c050c,0x8b520405,0xec0e004d}},	// [820] _개인정보의_, _प्रखर_, _аналогіч, _台灣師大環保中心_, 
   {{0x825a00e1,0x534b0277,0xdc550060,0xdaee007b}},	//   _folli_, _lineart_, _яланған_, _gratifie, 
   {{0x720200a5,0x00000000,0x00000000,0x00000000}},	//   _teuila_, --, --, --, 
   {{0x5e340021,0x6eea01ec,0x1c6002ea,0xbd9f008e}},	//   _anagerma, _چسبون_, _fiducia_, _dingante_, 
   {{0xc42c0071,0x6a7b0041,0xbf69050d,0xcb07007f}},	//   _خاکسپاری_, _ишақәиҭы, _armarios_, _gorsedda_, 
   {{0x1400022a,0x51e104f3,0x0e390022,0x00000000}},	//   _nebundan_, _अविरत_, _legalfra, --, 
   {{0x525a018a,0xbf9f03b8,0xb5380075,0x14320121}},	//   _colli_, _بوينشا_, _fyritrey, _descenso_, 
   {{0x70be0037,0xaf030188,0xe201001b,0x00000000}},	//   _ለማግባባት_, _хобгоҳи_, _flyiif_, --, 
   {{0x473b00c4,0x127e025b,0x2eb1005b,0x00000000}},	//   _ايماندار_, _stongt_, _buosyare_, --, 
   {{0x396e0074,0x527f0049,0x085502d3,0xe2fc01f4}},	//   _kiinnost, _ikuna_, _competên, _idagi_, 
   {{0x627f0128,0xdf3001df,0x904800cb,0xf34b045b}},	//   _shuni_, _rosemoun, _даснигар, _fineart_, 
   {{0x03eb0412,0x159c016e,0x425a01b8,0x9f520060}},	//   _kwathi_, _koleksiy, _rolli_, _بولساڭىز, 
   {{0x72d303b5,0x53e60022,0x12900015,0x0d4400dc}},	//   _ikutilah_, _секундҡа_, _sunada_, _tāpenaga_, 
   {{0x52940148,0x836b0208,0x587b040f,0x07d10191}},	//   _在這個版面刪除文, _ئاپارتما, _страта_, _helsingf, 
   {{0xc1b00061,0x2245018d,0x7ac000a6,0x727f019d}},	//   _일부상품은_, _ዝበለጸት_, _avakalis, _dzanja_, 
   {{0x17550378,0xb1800207,0x3ecd00db,0x5c17005b}},	//   _postrúm_, _مجموعن_, _silikoon, _kofanger, 
   {{0xf201011d,0xd2900015,0x14e600ba,0xfa450111}},	// [830] _murit_, _rabaa_, _ئاژانس_, _ripetuta_, 
   {{0xddb2014a,0xe290015a,0x0290000a,0x18b60149}},	//   _براڈکاسٹ_, _sabaa_, _aajaa_, _kọvadel_, 
   {{0xc19a03c4,0xd27f0294,0xc45501d7,0x5c6e00cf}},	//   _مىليون_, _akuna_, _ponderaz, _biiroon_, 
   {{0xc266002f,0x593801db,0x720103ec,0x6f2a02aa}},	//   _achupall, _دانىشپان, _arrij_, _sharerap, 
   {{0x82d902db,0x62fc050e,0x12ce004d,0x5e3303d1}},	//   _dipen_, _uloguj_, _工作勝任愉快_, _friziere_, 
   {{0xc83d006c,0x7c7403ac,0xb3a8010e,0x3db702e2}},	//   _додарзод, _musuhmu_, _dinalang_, _boliveea, 
   {{0xe2d40013,0x861100f5,0xfc000024,0xe346013b}},	//   _bordir_, _berlendi, _হিন্দুধৰ, _figueirã_, 
   {{0xdfd501f4,0xc2de012d,0x58c300d3,0x874f00e6}},	//   _курашда_, _streteji_, _gamelead, _本站拒绝色情小说, 
   {{0xe3870122,0xa833008d,0xa343000c,0x22900251}},	//   _nyerah_, _дўзахга_, _косован_, _jaban_, 
   {{0xc290016b,0x4dd90036,0x73ee02e1,0xe711010d}},	//   _daban_, _اتخاذ_, _استفتاء_, _दर्दी_, 
   {{0x49810004,0xc3860348,0xa27f0172,0x00000000}},	//   _dominike, _abirya_, _nyansa_, --, 
   {{0x72010145,0x58f6000a,0x1281015a,0x1ac000c1}},	//   _turiu_, _affaaluu, _bombiiti_, _काळपट_, 
   {{0xad7c007e,0x629001a6,0x62d5021e,0x40bf0056}},	//   _anirvācy, _atoato_, _gatorna_, _amamojul, 
   {{0xd380000c,0xd0770143,0xa2db0361,0xfb270137}},	//   _амонахцә, _френска_, _подребер, _равжаа_, 
   {{0x8273003f,0x1c68003c,0x02900183,0x51b700e6}},	//   _botichdi_, _baluchi_, _haban_, _快捷的投稿平台_, 
   {{0x6e4801cd,0x17e50452,0x5ed203f2,0x00000000}},	//   _angacaba, _गदारोळ_, _шведский_, --, 
   {{0x5158023c,0x62310020,0x00000000,0x00000000}},	// [840] _لوړرتبه_, _vaimoso_, --, --, 
   {{0xf20103dd,0x03f9005b,0x1b6c0476,0xef4300a4}},	//   _durim_, _miyuu_, _akaroora_, _чехиядаг, 
   {{0x629000a2,0x994c0116,0x963f015f,0xff77042a}},	//   _mabao_, _faimilie, _ethnigrw, _icocisan, 
   {{0x420e0039,0xd4c300c8,0xd75802bb,0x8d03006d}},	//   _шавар_, _алтындан_, _बदस्तूर_, _ажывілі_, 
   {{0xf29000a0,0x5fa70147,0x47900034,0x59d701cd}},	//   _gaban_, _ادبئيات_, _sundlaug, _amathend, 
   {{0x92d90303,0xc26c04a6,0xae96023c,0x3a270012}},	//   _dipeo_, _osnovu_, _خرڅوي_, _पुरबिओ_, 
   {{0xfb080087,0x86d00061,0xc2e900d2,0x00000000}},	//   _chaptara_, _지난해보다_, _arindit_, --, 
   {{0x62010245,0x6c0103fc,0x2d090352,0x84270068}},	//   _kurim_, _samsvar_, _বাহিৰলৈ_, _qabanayo_, 
   {{0xb27f025f,0x22d901dd,0x53a80119,0x6c6101da}},	//   _abengi_, _aboneke_, _hinabang_, _dituria_, 
   {{0x925a0396,0xd84100dd,0xe297011f,0x5dbe005f}},	//   _kollu_, _scarlets_, _asegurád, _pelicula, 
   {{0x0394017d,0x22d800dd,0x125a041e,0x60100040}},	//   _件を表示していま, _fodern_, _collu_, _למטופל_, 
   {{0x827e0043,0xccfa00bf,0x17570135,0x7fe30074}},	//   _ayinza_, _предател, _минемчә_, _marimeko, 
   {{0xe486050f,0xe29e0071,0xadc20074,0x8dec0299}},	//   _परदादा_, _امامی_, _ensisija, _ئاققۇزۇپ_, 
   {{0xf00b0125,0x7162007f,0x9c0102ca,0x00000000}},	//   _атанак_, _canghell, _hamstar_, --, 
   {{0x22e801c0,0xa3eb0399,0x304b0107,0x7b120023}},	//   _miliyan_, _itatui_, _معاشقه_, _собчак_, 
   {{0x523701a4,0xd20103dd,0xd347023b,0xf3e302ac}},	//   _abimisa_, _burim_, _kuleana_, _ومحركات_, 
   {{0x9290021f,0x92bc04ac,0x4a0b020f,0xf90b0188}},	// [850] _qaban_, _ассортим, _amabhant, _amabhand, 
   {{0x13100462,0xb162046b,0x534000ff,0x7a5c02ea}},	//   _arrayay_, _ganghell, _belecon_, _medesima_, 
   {{0xe1900352,0x7939009b,0x8621012a,0x22ea0160}},	//   _জানুৱাৰী_, _бактерий, _infolini, _podigao_, 
   {{0xc2900120,0xe3640113,0xf2010159,0xfa410510}},	//   _taban_, _forfás_, _turim_, _ойланаш_, 
   {{0xbeab0147,0xa57403ce,0xd22d015e,0x72e80082}},	//   _dimecres_, _خوپاراست, _امداشتىر, _biliyan_, 
   {{0x120103ad,0x72010377,0x8b44034c,0xef67010d}},	//   _ambitu_, _auzit_, _aksakalı_, _sahabatn, 
   {{0xc2d903d7,0x4c7503ea,0xc2970122,0x493201d5}},	//   _anpes_, _annuler_, _kanjeng_, _باسٹھ_, 
   {{0xc20100ee,0xa29000b6,0x525a0034,0x004a033c}},	//   _orria_, _dabal_, _hollt_, _cloriann, 
   {{0xf2d8018f,0x72010367,0x83f102ee,0xe2500060}},	//   _andeen_, _devido_, _tassisti_, _بىلەك_, 
   {{0xd7250040,0x67450271,0xc290008e,0xab2400e2}},	//   _נועדו_, _grunnlov, _fabal_, _gryptsje, 
   {{0xd29000b6,0xd2e7005c,0xe2fc0173,0xee490305}},	//   _gabal_, _urunana_, _elige_, _eigarane_, 
   {{0x95b5027f,0x3ecc020f,0x00000000,0x00000000}},	//   _bidatevy, _bayintan, --, --, 
   {{0x8f1d02c3,0x5a0701cf,0x551a016d,0xec0301d7}},	//   _vykurova, _cambiava_, _пәйзиват, _cassier_, 
   {{0x1d2c0073,0x1c7d0085,0x12fc0255,0x427f0159}},	//   _meritate_, _dausiwa_, _mingil_, _naminiai_, 
   {{0x575e0021,0x293c0075,0x67fc03d4,0xf413004a}},	//   _acticing, _framleit, _полумесе, _алышачак_, 
   {{0xc2900087,0xe55c0156,0xbc550059,0x0e3a0051}},	//   _sabao_, _גלוגעוו_, _contare_, _pianists_, 
   {{0xdf8e0017,0x6cbf01a3,0x08da040e,0x327e002b}},	// [860] _पक्कि_, _پينگهي_, _bibelsku, _ajeno_, 
   {{0xe6b900b0,0x329003d1,0x12910511,0x00000000}},	//   _dooranay, _labam_, _mufana_, --, 
   {{0x46e20019,0x87f00153,0x4e690177,0x029104cf}},	//   _بوقتوپسۇ, _満足度ランキング_, _ҳаирцәаҳ, _lufana_, 
   {{0x3a9402f3,0x98070512,0xe76201be,0x72620297}},	//   _artikeln_, _नसरुद्दी, _इन्धन_, _izraelgä_, 
   {{0xe25a0513,0x737a0128,0x96d5028e,0x302f0086}},	//   _endle_, _سوریله_, _korporol_, _نحوست_, 
   {{0xb815020e,0x82aa03c2,0x829000cf,0xd27f0145}},	//   _буласаҡ_, _concealm, _babal_, _gaminiai_, 
   {{0xc4ff00be,0x13ea0286,0x6e9a0378,0x82ef0096}},	//   _اشىرابەر_, _mpotam_, _veruligt_, _bahisha_, 
   {{0x9ec50062,0x99c80049,0xa7ed03d5,0x43eb0148}},	//   _brazilda, _fotofota_, _aaraueag, _statui_, 
   {{0x22010066,0xef2f030a,0xe3df0163,0xe2e00086}},	//   _urria_, _altermun, _fantázia_, _alufelni_, 
   {{0x8adf025c,0x229000a1,0x2f200312,0x379f0514}},	//   _bildungs, _punaha_, _adtermen, _diftongi, 
   {{0x884d02d4,0x73a2021e,0x92d600a8,0x757f0121}},	//   _formaziu, _lampor_, _balluns_, _hortaliz, 
   {{0x60dd03a1,0xf8f8042f,0x029001d8,0x63f202d8}},	//   _положите, _pitaaqtu, _rabad_, _frustasi_, 
   {{0xdc55046d,0x029a00cb,0xa70a01eb,0xc3f4040e}},	//   _maitele_, _ababezam, _castellá, _puttar_, 
   {{0x58d2000a,0xa2cb0128,0x28f701c8,0x6fc300a5}},	//   _ajeraliv, _sirlari_, _punčochy_, _lamolemo, 
   {{0x129000fa,0xa25a00bc,0x936c01d8,0xf29002ee}},	//   _babae_, _rndld_, _dingiei_, _qabad_, 
   {{0xb2dd018b,0x685a04d2,0x38e803a8,0xa6de0153}},	//   _europei_, _nedanfor_, _brisling, _まっぷるの宿泊予, 
   {{0x4f4d01fb,0x62da0392,0xde68028a,0x46a7046c}},	// [870] _adoptate_, _eireas_, _ulichona, _ehrgeizi, 
   {{0x5a6001c3,0x02480034,0x22d40138,0xa44700c7}},	//   _blameles, _vélinni_, _zordur_, _алдыгызм, 
   {{0xcba401e8,0x8b9202f4,0x398e0205,0x87b502e7}},	//   _artikulo_, _teniendo_, _калит_, _indsutri, 
   {{0x34c50367,0x729000f1,0x7c670190,0x7eba02b6}},	//   _trabalho_, _kabab_, _iriring_, _تالابىڭد, 
   {{0x92010151,0x23f400b4,0x3f420343,0xc04c0420}},	//   _orrin_, _partid_, _ginsakup, _мигранти_, 
   {{0xc379005a,0xc27f0204,0x00000000,0x00000000}},	//   _jiharqo_, _dianan_, --, --, 
   {{0x1c4a0055,0x52550049,0xbae70024,0x6c55000b}},	//   _bétail_, _failelei_, _প্লাৱন_, _faitele_, 
   {{0xd20100bc,0x06bf018d,0xd64e0060,0x537f000b}},	//   _gurih_, _ተስፋናን_, _тарифтік_, _samania_, 
   {{0x68e000f7,0x3c4a00c5,0x52d900d8,0x52ec0515}},	//   _malgrand, _détail_, _topex_, _pariete_, 
   {{0x986a0196,0x99ee0145,0xc8780090,0xa84a0161}},	//   _amangofu, _sektoriu, _asingaku, _водки_, 
   {{0x1449017d,0x127e03ba,0xd5c800a2,0x8349018a}},	//   _ドを忘れた_, _atonit_, _kuhamish, _enwebai_, 
   {{0xcd7e0430,0xf42e0143,0x52700220,0xa981009a}},	//   _khalanwa, _издателс, _preghiam, _baphicot, 
   {{0x2e5c0516,0xc201028e,0x5e0400ba,0xb5930257}},	//   _auncient_, _surik_, _پرنێوه_, _barnsfað, 
   {{0xd3010316,0xc9cd03ec,0x00000000,0x00000000}},	//   _gatanci_, _sondazhe, --, --, 
   {{0x814c00f2,0xc0370066,0xccf50376,0xe8720137}},	//   _pietieko, _bulegoak_, _doktarar, _хотруу_, 
   {{0xb20103dd,0xcdc001dd,0x3c6a018d,0x90a900cb}},	//   _arrin_, _hakizima, _ብካሕሳይ_, _ашрофзод, 
   {{0x3c67012f,0x587d0092,0xd8060517,0xa7590311}},	// [880] _eriring_, _文字以内で入力く, _cúpulas_, _ነንበይኑ_, 
   {{0x28e600d0,0x52d20009,0x5f25004f,0x6927015f}},	//   _африк_, _spremeni_, _elpensan, _carchard, 
   {{0x36990039,0xd3030008,0xa23f0138,0xbc7600e4}},	//   _мэрилин_, _demanat_, _bülten_, _pierogi_, 
   {{0x4e960518,0xff9b0089,0xfc2901db,0x229104e3}},	//   _براون_, _евразия_, _دانەكەرل, _igrat_, 
   {{0xd0970046,0xcba702a3,0x2c3c0297,0xb1e90169}},	//   _армиясы_, _dankbaar, _basunı_, _indicarm, 
   {{0x82d801d8,0x0b2f029e,0x158f014e,0x4a0c02af}},	//   _baheh_, _disadorn_, _поступку_, _bagateba_, 
   {{0x2c5502a4,0x37840008,0x1a13001e,0xe75a00cb}},	//   _pietate_, _терапиял, _bahaushe, _домодҳои_, 
   {{0xf3f9005b,0x5a51027b,0x320101d7,0x421c0162}},	//   _pique_, _apadeśen, _arriv_, _хоронъғу, 
   {{0x1adf0258,0x5a280311,0x530f029c,0xf2e8036e}},	//   _briedgeb, _ወድሸሪፈይ_, _bamboyo_, _coendou_, 
   {{0xcc710519,0xd2360148,0xa6050178,0x69da0297}},	//   _मोर्चे_, _設定查詢條件_, _avaśenāp, _biznesta_, 
   {{0x46b803a0,0x997100c4,0x429101b9,0x270d022b}},	//   _bakatisi, _الڪرام_, _laraf_, _skattahæ, 
   {{0xe27f04cf,0xceea0421,0x82010102,0xb7480223}},	//   _abenzi_, _fraktion, _shairi_, _alhondig, 
   {{0x8ce7016d,0x0bb70360,0x0c56006f,0x526c0369}},	//   _قۇدرەتلى, _programů_, _عبدالعلي_, _lehova_, 
   {{0xd291019d,0x00000000,0x00000000,0x00000000}},	//   _kufala_, --, --, --, 
   {{0x1ad500c7,0x6ec302c9,0x93ca0242,0xbc750203}},	//   _аңлата_, _интимита, _ayları_, _amputat_, 
   {{0x33410122,0xfec400af,0xd21c017c,0x00000000}},	//   _پنجاه_, _нескладн, _mathem_, --, 
   {{0xf39600af,0xc20004d3,0xac0d00f2,0x42d800fe}},	// [890] _авторськ, _thaij_, _visbiežā, _mahei_, 
   {{0x13eb0360,0xebed0192,0x7f250130,0x157101c8}},	//   _historii_, _네비게이션_, _advezian, _sledoval_, 
   {{0x22e9051a,0x37ae0162,0xeb9902a5,0x54fa0365}},	//   _ditimpa_, _кимгә_, _पाइँदैन_, _किटाणु_, 
   {{0x932f0057,0xac75007b,0xca860167,0x3c2f0111}},	//   _በእንደዚህ_, _acquant_, _garndolb, _bisidoru_, 
   {{0x3a16045d,0xe67a01c5,0x308701f4,0x5db700e7}},	//   _saradnja_, _caleykum_, _нахотки_, _ancingda, 
   {{0x125a005b,0x63670220,0x8fb301db,0x22d900a1}},	//   _fille_, _bergamo_, _ақиық_, _kipea_, 
   {{0x521c0212,0xfa910172,0x22010338,0x9294049e}},	//   _sophos_, _anyinyin_, _arriu_, _fotkach_, 
   {{0x226c01ed,0xd22b051b,0xb2e803ba,0x0be902ea}},	//   _iehova_, _animace_, _rrufen_, _pomodoro_, 
   {{0x4cad025e,0xe54400a7,0xee4e0455,0xee9a02c7}},	//   _byggingu_, _بىلەمىن_, _semblent_, _beruhigt_, 
   {{0x625a02f3,0xdb22032e,0x90fe0297,0xf41c01b3}},	//   _kille_, _paypacha_, _аһәңе_, _прогресу_, 
   {{0xc2ba02bd,0x629102ec,0x00000000,0x00000000}},	//   _academi_, _marag_, --, --, 
   {{0x6e7300ff,0xa1c90126,0x4d9c018b,0x026402a3}},	//   _מעדעצינע, _сорти_, _cererile_, _misluk_, 
   {{0xf3ff01f6,0x12d8051c,0x52d8011d,0x0d0c037c}},	//   _তালিকাসম, _sahep_, _clientii_, _sepulchr, 
   {{0x57b40415,0x8b690211,0x3d410079,0xe2d8051c}},	//   _mittlerw, _treffien_, _pedagogu_, _pahep_, 
   {{0xa3880384,0x728f01e8,0xe1bc0361,0x626c01fa}},	//   _unutrašn, _techies_, _листинге_, _sanitesi_, 
   {{0xc15b0138,0x2290015a,0x2438044a,0xcfd6020f}},	//   _nedeniyl, _gabaa_, _abakisak, _تفخيم_, 
   {{0x0291051d,0x592e0046,0x1873051e,0x20630103}},	// [8a0] _xaraf_, _палестин_, _físicos_, _avasunun, 
   {{0x129101c0,0x469b00a6,0x3c430061,0xa2fc0343}},	//   _mazan_, _سرکاڼو_, _밤새안녕님_, _ilaga_, 
   {{0xd2900172,0xfe4b0318,0xe280023e,0xd29101ad}},	//   _babaa_, _angavale_, _anakane_, _darag_, 
   {{0xe72d0063,0x72cb020e,0x0dc20312,0x00000000}},	//   _inspiorá, _ithopia_, _enskriva, --, 
   {{0x4c6f00dc,0xf290002a,0xae12025c,0x00000000}},	//   _sharron_, _dabaa_, _vereinba, --, 
   {{0x7da0002e,0xb276029f,0xa27e01e5,0x31560244}},	//   _ravnopra, _stredošk, _ayinla_, _детските_, 
   {{0x72ee0040,0x32fc0416,0x16fc0030,0x70bc0396}},	//   _נוירולוג, _singul_, _piereģis, _jimmobil, 
   {{0xf2910038,0x32910163,0xa9db00a9,0x68550131}},	//   _kazan_, _marad_, _ahindura_, _naqueles_, 
   {{0xe3860102,0xb291011c,0x78d4018d,0xfb770282}},	//   _شاندار_, _barag_, _መዋእላት_, _tairanga_, 
   {{0x3d8500de,0x5272014f,0xd9320071,0xb25b00fc}},	//   _annexure_, _географс, _انجین_, _chellu_, 
   {{0x326c03f1,0xf3800434,0x6c680119,0x0c3c0185}},	//   _lehota_, _actriz_, _guarino_, _basulı_, 
   {{0x220004ea,0x9b5800d3,0xaee10148,0xbaad0053}},	//   _khaii_, _अक्षरको_, _scriptis_, _seukuran_, 
   {{0xa59f0252,0x4eb7051f,0xc20002a3,0x4fe102f1}},	//   _linganah, _وروتر_, _shaik_, _amizades_, 
   {{0xbfba01f4,0xabfc006d,0xc4780156,0xa4d60012}},	//   _аралашти, _трамваях_, _amnestio_, _मउगियो_, 
   {{0x11eb02b9,0x02240116,0x9c4e023c,0x56a201ac}},	//   _وفاداری_, _choked_, _زاخېلوال_, _gortaith, 
   {{0x83780082,0xc4450247,0xc0040134,0xa2900191}},	//   _lamarin_, _فرماندار, _atilẹyin_, _bekant_, 
   {{0x32cb0028,0x3c6f01df,0x35120153,0x17320396}},	// [8b0] _ethopia_, _befreen_, _ポリエステル縮緬, _infushom_, 
   {{0x2e990077,0x3b7d03e9,0x7d9901b0,0xf3600372}},	//   _kontinye_, _çylşyrym, _kontinyu_, _blygell_, 
   {{0x03fd030b,0x2291019f,0xfc6d0520,0x0ec50059}},	//   _abinywez, _mazao_, _relatóri, _климата_, 
   {{0x473c00ee,0x2b2c0159,0x6d1f0445,0xb6930205}},	//   _олимпийн_, _pacientų_, _síntese_, _десятчик, 
   {{0x86060126,0xf29001c4,0x00000000,0x00000000}},	//   _квартирі_, _gekant_, --, --, 
   {{0x59f200e6,0x8f67015e,0x67e40094,0xe30b0521}},	//   _以信息化带动工业, _байгеге_, _قىرقىسۋع, _alibeaj_, 
   {{0xf5ac0522,0x61f80060,0x6a140181,0x7a97019d}},	//   _वीरता_, _تەرىستەپ_, _buiberut, _kanyenya_, 
   {{0xd29103cf,0xaeea0107,0x5d9d016e,0xe28802a3}},	//   _yazan_, _تساوی_, _erteleme_, _veralgem, 
   {{0x42910282,0x73410088,0x02910160,0x92910433}},	//   _marae_, _اندان_, _kazao_, _parag_, 
   {{0x057000ba,0x83a201f6,0xaf9b00be,0x457502ac}},	//   _دیلمان_, _kampar_, _تۉيۉنگۅ_, _شاكيرا_, 
   {{0x12e702ef,0xe6c20008,0x1b0600ec,0xc53b014e}},	//   _flatbush_, _بەيىشكە_, _растуць_, _атеизма_, 
   {{0x54720523,0x8d1b02b9,0x373a01ea,0x42470023}},	//   _प्रभू_, _mennyire_, _вояга_, _группу_, 
   {{0x56a9015c,0xa2000294,0x7e5400a0,0xaca90161}},	//   _betruech, _chaii_, _bamaguje_, _доставим_, 
   {{0xacb60277,0x4dc001d4,0x829002c3,0x7ae0011a}},	//   _polyneur, _reliquie_, _dunaja_, _saturate, 
   {{0x1f930126,0x02ca034b,0x92910144,0xed8a0418}},	//   _реформув, _prodak_, _carad_, _trafikte_, 
   {{0x52fc023e,0x9bd5002c,0x5c0f04a7,0x6387000d}},	//   _tlaga_, _рублийн_, _costumis, _kaarma_, 
   {{0xd9f2020e,0xb46903f5,0x18df0265,0xf80800e7}},	// [8c0] _amahngwa_, _prefeito_, _hergebru, _aunching, 
   {{0xd18903b0,0x832700dd,0x5212018f,0x32d0028a}},	//   _নিবনুৱা_, _barciau_, _lomhey_, _sulemani_, 
   {{0x92c300af,0x8ec100c7,0x0f910524,0x829101b5}},	//   _модний_, _келәм_, _baldasar_, _luvana_, 
   {{0xf3a902f3,0x420e00c7,0x82910183,0xe31600df}},	//   _helvete_, _карар_, _tazan_, _engagez_, 
   {{0x929b0206,0x0291014e,0xcc2302dd,0xf2910094}},	//   _izbový_, _zarad_, _appredis, _ولگەندى_, 
   {{0x357b02c1,0x99e100a6,0x9eb90177,0xda0102a0}},	//   _imitungo_, _نیازمن_, _рбаҟақәа_, _nguanamt, 
   {{0x538701b8,0x029d035b,0x4d3d0226,0x82d5006e}},	//   _maarja_, _gnojila_, _asanathe_, _doroora_, 
   {{0x827e032d,0xa27f00b8,0x4eea0139,0xe201026c}},	//   _tjena_, _khunu_, _प्रथमम्_, _muris_, 
   {{0x23f8026c,0x42fc017e,0x62910115,0x00000000}},	//   _maius_, _aligo_, _juvana_, --, 
   {{0x312501ea,0x23130184,0x0291050e,0x56a000e7}},	//   _قانونچی_, _aricara_, _duvana_, _eekendsw, 
   {{0x23fe0369,0xd1020148,0x527e0197,0x6201022f}},	//   _akelanik, _無標題文件_, _djenn_, _turit_, 
   {{0x26ad01eb,0x666d0147,0x6b730196,0x4341030a}},	//   _agureroh, _بلەسز_, _atauyala_, _obreira_, 
   {{0x3a5f0033,0x5c820276,0xbd300019,0x2ab50147}},	//   _dumengia_, _بوستانلى, _эмоциясы, _رومكادان_, 
   {{0xc201022f,0x15930096,0x8200005b,0xb3a2018a}},	//   _kuris_, _aseserez, _beniko_, _fampir_, 
   {{0xb2010488,0xbbb900da,0xca1604dd,0x55ff032e}},	//   _juris_, _десенат_, _španija_, _paylliwi, 
   {{0x729301db,0xfe9a023d,0x923801a4,0x52010145}},	//   _ﻛﻪﺗﺴﻪ_, _comunque_, _abimisi_, _duris_, 
   {{0x030d0190,0x157b027f,0x2ce101a7,0x5e430243}},	// [8d0] _bagawer_, _amatongo_, _основы_, _cabaarut_, 
   {{0x127f03ef,0x0a080095,0xddbe02f6,0x632702bd}},	//   _nyanza_, _ramayana_, _pelikula, _parciau_, 
   {{0x92ad00e6,0xd35e0436,0x59870007,0x00000000}},	//   _河北农业信息网_, _anadolij, _nayikaka_, --, 
   {{0x1f4101d7,0xde0902b2,0x527e021e,0x00000000}},	//   _fabricha, _воріт_, _kunnig_, --, 
   {{0x47b600d7,0x2e660040,0xf2970115,0xe27f04c9}},	//   _bolumeli, _לספטמבר_, _tanjong_, _hajnã_, 
   {{0x9e500328,0x10c802f7,0x00000000,0x00000000}},	//   _kigahama, _kwalolol, --, --, 
   {{0x82fc040f,0x8b8a018c,0x2d180168,0xfac90093}},	//   _smagu_, _juridisc, _favoritt_, _миллиона, 
   {{0xa27f0344,0x38cd011a,0x43a70052,0xb8fb004d}},	//   _akunn_, _stressfu, _त्रिपाठी, _並非依固定之百分, 
   {{0x62010230,0x18fd0255,0x560d029a,0xbc76006d}},	//   _furir_, _parandad, _promouvw, _sparnai_, 
   {{0x080a0525,0xec0a02d9,0xf2da0180,0x44b00456}},	//   _इन्द्री_, _anapapa_, _direks_, _difahamk, 
   {{0x72900285,0xc22f027b,0x6409036e,0x386302c0}},	//   _runaka_, _कामचारः_, _chinpayk, _несекојд, 
   {{0xc7e00410,0x71b301d5,0xd7530399,0x82d802d5}},	//   _ditsenyw, _کامرس_, _avangong, _vahet_, 
   {{0x020004b8,0xd3f402ec,0x7d930046,0x59cd03e6}},	//   _thain_, _kartid_, _dèficit_, _verdecke, 
   {{0xaae200b3,0xf2d90050,0x2f780008,0x5ff702eb}},	//   _делиллер, _tipeu_, _cambrils_, _махбодь_, 
   {{0x8c7300ec,0xf576003d,0x92cb008d,0x00000000}},	//   _startas_, _brilhanç, _birlari_, --, 
   {{0xf27f04f2,0xf96701a6,0xed83031a,0x7291018e}},	//   _phunu_, _kahikate, _peileara, _muvala_, 
   {{0xb27f0226,0xd2b40160,0x70e10010,0xef260526}},	// [8e0] _akuno_, _pricam_, _ekonakal, _digendon, 
   {{0x43bc0113,0xb29004bd,0x38d500e6,0x92ec01f3}},	//   _علمني_, _hunaia_, _此地空余黄鹤楼_, _cisterny_, 
   {{0x6d390222,0xa1cc00a4,0x9f44012c,0x77730258}},	//   _ancienne_, _сымал_, _اسلاميءَ_, _folksheg, 
   {{0x1b7201e5,0x925a0181,0x83be00ac,0x625b0527}},	//   _elerugba_, _rilla_, _kreveti_, _dotle_, 
   {{0x13860358,0x99210397,0x627e035e,0x326d0338}},	//   _cherif_, _ababechu, _njenu_, _lafont_, 
   {{0xf27f0069,0xe20004ee,0xe379033f,0xf3460235}},	//   _myanya_, _shiiti_, _mataika_, _dhuraṃdh, 
   {{0x129701fe,0x871f010f,0x1604019b,0x02f10275}},	//   _josateki_, _убури_, _olimpini, _masiasi_, 
   {{0x8c600528,0x9200013f,0x52e504d8,0xa2010326}},	//   _diluain_, _chiit_, _miinada_, _chaiti_, 
   {{0xbd9d0449,0x62cb01fc,0x058501eb,0x796300b5}},	//   _jednosta, _akadde_, _agronomí, _ахрархәа, 
   {{0xb25a01da,0x959d0263,0x15b30250,0x0548002e}},	//   _tilla_, _belgisch, _qëndrimi_, _uništiti_, 
   {{0x424303db,0x07640147,0x52d50529,0x9066004a}},	//   _abammeli_, _انىبار_, _formiraj, _анысында_, 
   {{0x83b00285,0x32010230,0x629001da,0x6c630110}},	//   _amavuko_, _surir_, _bekare_, _mirušo_, 
   {{0xb3f80066,0xf2ec018b,0x8a9a00cb,0x3df6018d}},	//   _метронд_, _fisiere_, _abanezis, _መሳለጥያታት_, 
   {{0x330a004d,0x7495012e,0xc2e900d5,0x324901da}},	//   _不用穿西裝_, _motorral_, _fidinan_, _ademit_, 
   {{0x7f020371,0xb28602ec,0x049b012b,0x8b2d0037}},	//   _около_, _وگنى۪ن_, _ceramicz, _የመፈንቅለ_, 
   {{0x0f48032f,0xfad7048c,0x669c01bd,0x5e4b0499}},	//   _páginas_, _inattent, _бизнесті_, _fogafale_, 
   {{0x9b270211,0x4bb7019b,0x802a0060,0x22d90117}},	// [8f0] _selaimes, _programų_, _تارتىنات, _pipel_, 
   {{0x729203e5,0x736f010d,0x5b34015f,0x231000ad}},	//   _matans_, _lengket_, _drachefn_, _burahay_, 
   {{0xd292052a,0xd07a00be,0xdad000db,0x4374008e}},	//   _pataas_, _принципк, _ekstrave, _ewestism, 
   {{0x82010245,0x73a20147,0xe3f1029e,0x4eba02cf}},	//   _jurip_, _tampoc_, _freelang_, _дошле_, 
   {{0x7cbc0162,0xd2b40333,0xc36b005b,0x62fc0079}},	//   _алғандин_, _recco_, _topgear_, _smags_, 
   {{0x225a0260,0x7c2b009b,0x9a50052b,0xef720296}},	//   _millo_, _zoragarr, _विषुववृत, _stackars_, 
   {{0x11b6052c,0xf9df03f3,0x0d800212,0x62fc0272}},	//   _رۆژگار_, _structuu, _venerunt_, _alage_, 
   {{0x0962033b,0x620004d3,0xc5830435,0x734400c7}},	//   _bolokile, _khaim_, _москви_, _kertergä_, 
   {{0xf3d001db,0xab19018d,0x3601010d,0x48d904c7}},	//   _اتويشىلا, _ድሕንነት_, _ngeliati, _приходим, 
   {{0x7ecc023c,0x49da00e2,0x94cb01be,0x5caf0208}},	//   _abenelun, _direksje, _किरिया_, _ڵماشی_, 
   {{0xe8970247,0xbc5200d1,0x262d0224,0x797b0097}},	//   _مرتبه_, _লুপ্ত_, _ofangrei, _iṣẹgun_, 
   {{0x42d80245,0xfc6d032e,0x53ec027e,0xfaf30158}},	//   _taher_, _ayirina_, _таксиста_, _najskute, 
   {{0x2163017d,0x227e02af,0x6c4a0434,0x239602f3}},	//   _円以上ご注文頂き, _aronse_, _increíbl, _missat_, 
   {{0x6304051c,0x327e03ae,0xafea00bb,0x6c7602ee}},	//   _jasabel_, _bronse_, _کرڈالا_, _iparlaw_, 
   {{0x2ad50204,0x1afe0190,0xb38002e2,0xd7d600bb}},	//   _tuntemat, _einsalze, _sorrel_, _یادرہے_, 
   {{0xb8590527,0x09980453,0x337f0239,0x8570004d}},	//   _doprinos_, _bliži_, _hunanga_, _上班甘苦談_, 
   {{0xe387036e,0x030e0044,0x00000000,0x00000000}},	// [900] _abaroa_, _repairs_, --, --, 
   {{0x8c5e0024,0x6da30156,0x200800e6,0x371b02ac}},	//   _সম্বন্ধ_, _שנאפס_, _社会主义市场经济, _astralaí, 
   {{0x229000ac,0x64dc0105,0x0c6104bd,0x134802e2}},	//   _ionako_, _द्विलिंग, _bitunia_, _screech_, 
   {{0xd28e01db,0x34a8036e,0xa25a01e5,0x66240185}},	//   _ءتاۋىر_, _alcaldek, _didle_, _bryussel_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x6f4000a7,0x92de0009,0x70ad0488,0x0b0c0338}},	//   _dissenya, _strojev_, _pasargāt, _classame, 
   {{0xca970477,0xfb190228,0x9b2f014e,0xa6950116}},	//   _tanyanya_, _uorganis, _изненађе, _disestai, 
   {{0x30ce0410,0xb25a01c2,0x203200ee,0x52da02ea}},	//   _ditlhohl, _fillo_, _sustapen, _avrete_, 
   {{0x0af10003,0xc25a0119,0x727e0099,0x09e0020e}},	//   _opdracht, _gillo_, _atonge_, _kaholima_, 
   {{0x73ea041e,0xd7d90024,0x19c70376,0xe290011b}},	//   _dritti_, _শ্ৰীৰামক, _býlingar_, _sekaye_, 
   {{0x694901a7,0xc2910068,0xed560306,0x2f2c043a}},	//   _мастерск, _yaraa_, _aqhanaku_, _padeklin, 
   {{0x12900223,0x437900ec,0x17a400d1,0xe2b5013e}},	//   _honako_, _palaiko_, _ইনফৰ্মেশ, _sledece_, 
   {{0x0e0100c4,0x21e80014,0x1c7d051e,0x7b280023}},	//   _ٻانھون_, _reformim, _cansado_, _значок_, 
   {{0xa6920175,0x722b0194,0x471c002e,0x14eb0060}},	//   _lentansy, _chimere_, _srednjoj_, _شىرايلى_, 
   {{0xe68b002b,0xd07c0101,0x7c5f0372,0xd5c8045a}},	//   _নবীগঞ্জ_, _membrilo, _deuthum_, _rambølls_, 
   {{0xdad100bc,0xe49c01bb,0xe34301eb,0x316d0403}},	//   _tuttnaue, _барысыны_, _bareiro_, _manirery_, 
   {{0x2a970321,0x6e980061,0x83a6004d,0xc416006d}},	// [910] _količino_, _브라우저가_, _電子化政府_, _альгарыт, 
   {{0xf2ef0387,0xa18201be,0x80d80037,0xf22e0107}},	//   _chefuo_, _उर्वर_, _ንብረትነቱ_, _ناکارآمد_, 
   {{0x825a0124,0x22d90479,0xb3f4021c,0xc74c023c}},	//   _sillo_, _videó_, _kartou_, _دترهګرۍ_, 
   {{0x9ad0001f,0xcfd9018d,0x037f02b1,0xe26c00e2}},	//   _ntamadan_, _ዳሕረዎት_, _samarwa_, _gedoch_, 
   {{0x92910211,0x0e8f02d5,0xb29002f7,0x723e0038}},	//   _varaa_, _अनितहुँ_, _bonako_, _джомолун, 
   {{0xc7690025,0x120004af,0x2afa017d,0x243700b4}},	//   _शिक्षते_, _phais_, _branchen_, _недоринд_, 
   {{0xd37f00a1,0xee9300be,0xb37f01fe,0xdc1700e2}},	//   _runanga_, _легитимд, _mamajia_, _opblaasd_, 
   {{0xc290005b,0x29ea02b1,0x9e48012b,0x33b50446}},	//   _minato_, _gwargwad, _zakazane_, _zahvala_, 
   {{0xe2e80058,0xa2910247,0x3d800060,0x62d80083}},	//   _balidan_, _jaran_, _ازيالىقت, _sched_, 
   {{0xd8cb00c4,0x00000000,0x00000000,0x00000000}},	//   _اعتراضن_, --, --, --, 
   {{0xb2d801c5,0x08290147,0x366b0061,0x584500d1}},	//   _tahey_, _үстөк_, _저지방우유_, _সমন্বয়ৰ_, 
   {{0xf38002d5,0x0d3d0135,0x33510199,0x83ea0230}},	//   _korral_, _популярл, _blueftp_, _ezite_, 
   {{0x525a0087,0xca57052d,0xa27f031a,0x8b790044}},	//   _solly_, _प्रकाशीत_, _chanan_, _umbrella_, 
   {{0xa2e80073,0x53160312,0x12da02e1,0x427e0272}},	//   _affirma_, _digarez_, _phreas_, _atonde_, 
   {{0x225a0195,0xbdcb0060,0x13960204,0x0957004d}},	//   _gille_, _шалқарды, _tissit_, _不能太多次_, 
   {{0xd6ae01a0,0x00000000,0x00000000,0x00000000}},	//   _makunguh, --, --, --, 
   {{0x32910528,0x4c700053,0x026d028d,0x0295013d}},	// [920] _caran_, _मार्को_, _lafore_, _diskuti_, 
   {{0x02ea0261,0xcc5a013c,0xac030264,0x7fe7002b}},	//   _atingis_, _faktiki_, _mattersb, _তোমার_, 
   {{0x81880243,0x9af702b2,0x00000000,0x00000000}},	//   _mayanaay_, _forskere, --, --, 
   {{0x4044007c,0x120e00a7,0xab7d01d6,0xb22a00b9}},	//   _kubumban, _барат_, _tegneser, _सदिच्छा_, 
   {{0xf5c903a6,0xe9ec00dc,0xd4ea0350,0x00000000}},	//   _bagafash, _lolovaia_, _የሚለያይ_, --, 
   {{0xf25a01da,0x125b0009,0x034400fc,0x84d5014d}},	//   _tille_, _kotli_, _nubejbe_, _aktionär, 
   {{0x129100cf,0x2e460528,0x03b002f3,0xe20203d1}},	//   _aaran_, _alabasta, _felaktig_, _satiec_, 
   {{0x92910054,0x4c3602b4,0x3e5f0037,0x8809028a}},	//   _yaran_, _alabacec, _ያስችለናል_, _inachang, 
   {{0xa25a0513,0x93df02ac,0x87b5012d,0x022500f7}},	//   _endla_, _فأكثروا_, _matuguai, _atakas_, 
   {{0x22fc02d9,0x52fc031a,0xe9e9019e,0x00000000}},	//   _ilagi_, _hoigh_, _арашэньн, --, 
   {{0x03f404c5,0x729100b0,0x09680417,0x0f4701fb}},	//   _partou_, _waran_, _aktiwite, _estranie_, 
   {{0x92b4005b,0x33eb023d,0xe6c200ea,0xee580311}},	//   _lecca_, _tratti_, _ankafizi, _ንባህልናን_, 
   {{0x5cd701cd,0xa010004d,0xb8430332,0xf2e2008f}},	//   _мехаранд_, _禁毒工作形勢依然, _carteras_, _valivad_, 
   {{0xb94a0256,0x3eea0161,0xd3f900e1,0xbfa90147}},	//   _labsajūt, _радиальн, _layuw_, _químic_, 
   {{0x834102d4,0x1e2001b8,0x2d1502dd,0xb9d70431}},	//   _dependa_, _खदरौन_, _esportat_, _badeanle, 
   {{0xb29100b6,0x42f302e4,0x5c550003,0xafc60013}},	//   _maral_, _kumitat_, _grotere_, _grantlar_, 
   {{0x12910068,0xe24701bd,0xa29101b9,0xaa880241}},	// [930] _qaran_, _шекарасы_, _laral_, _bayinaan_, 
   {{0x1201052e,0x07be0208,0x1f6d0092,0x92900414}},	//   _affixo_, _ئسلامی_, _チェックイン_, _monano_, 
   {{0xa52b005c,0xc4550269,0x56ef052f,0x428c051b}},	//   _munyakaz, _producto_, _nezabelw, _soupravy_, 
   {{0x4364041c,0xf2910013,0x03f8015e,0xab5601a3}},	//   _dangeen_, _izzat_, _senzill_, _ٻاروچا_, 
   {{0x99510527,0xdc6701eb,0x786b029b,0xb5a6034f}},	//   _nepoznat, _achuapa_, _alhibaad, _بازمحمد_, 
   {{0xd7300071,0x1ab9013c,0x5b3703f2,0x00000000}},	//   _هیتاچی_, _medvedye, _надежду_, --, 
   {{0x08fd0134,0xe35500bd,0x03f400ef,0xc8dd00a8}},	//   _babatund, _cheeper_, _evutha_, _agressiu, 
   {{0xdeaf01e6,0xf2fc015d,0x20cc00f6,0x12e10299}},	//   _nedostan, _flagi_, _böyrək_, _دوۋزاققا_, 
   {{0x66740113,0x327e01da,0x35070062,0xead20163}},	//   _rankousf, _gjeni_, _irnehnal_, _rettenet, 
   {{0x4291004f,0x12ec0230,0x33eb02a4,0x8aaa006d}},	//   _faral_, _ekziste_, _fratri_, _аўторкам_, 
   {{0xb3f404c4,0x527f0382,0xa28501e8,0x78820157}},	//   _vastus_, _akuni_, _archill_, _छात्रसंघ_, 
   {{0x46c503ce,0xa6f20220,0x0e4b024f,0x43f9005b}},	//   _یویست_, _интериор, _sigawale_, _dayuv_, 
   {{0xab760040,0xd3960004,0xc3e4010d,0x3da40462}},	//   _בשומרון_, _dossie_, _melunasi_, _armieswa, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x99740307,0xfa4d0107,0xe60003d5,0x8291008b}},	//   _asondele, _baadilla_, _bailliui, _jaral_, 
   {{0x739600af,0x58bc0156,0x02a000cb,0xeb330222}},	//   _visste_, _פלעשער_, _бронхҳо_, _spacieus, 
   {{0xd3a203ac,0x12910340,0xba150103,0x0240003b}},	// [940] _hampir_, _parao_, _anochere, _etimweni_, 
   {{0xa4d701ef,0x1a3e01db,0x03a20205,0x00000000}},	//   _канады_, _ءتىرشىلى, _kampir_, --, 
   {{0x3c6b0052,0xc2fc022b,0x4b550121,0x1a080530}},	//   _कुल्ला_, _slagi_, _producen_, _ramazana_, 
   {{0x26b60303,0xf6d40092,0x00000000,0x00000000}},	//   _bolelelw, _あなたもガ_, --, --, 
   {{0x137f00b3,0x6aba03a2,0x32fd003c,0x53a804e6}},	//   _kenarda_, _रिऐलिटी_, _babirus_, _banalang_, 
   {{0x77ed0108,0x00cf01f3,0xd5cb0095,0x00000000}},	//   _babareng, _zaplavil, _dananjay, --, 
   {{0x92ea04b3,0x613101eb,0x934e00e6,0x223f02f3}},	//   _asantit_, _findshel, _请自觉遵守互联网, _fälten_, 
   {{0x281c02e5,0x54ed008d,0x51c800d3,0xd22a0156}},	//   _лонднотә, _холмирза, _विभागबाट_, _הכּתוב_, 
   {{0x76df015e,0x5ff8017d,0xaf3d0193,0x15f0022d}},	//   _اساباعا_, _北海道大学大学院, _निर्माते_, _permetti, 
   {{0x5fed0047,0xfce502ac,0x220000fe,0xadc9001a}},	//   _百度知道投诉吧_, _مظلات_, _ikaii_, _وفروخت_, 
   {{0xc386019f,0xc2bb02ac,0x2b21027f,0x32d900b4}},	//   _abiria_, _ونغمات_, _harasamb, _taxei_, 
   {{0x29de014d,0x7c77023e,0xe291028e,0x85100251}},	//   _vergesse, _saisine_, _garae_, _shirkado_, 
   {{0x83160031,0xb62300af,0x22ed048c,0x65cb0010}},	//   _diobati_, _коваль_, _barratry_, _ithayiph, 
   {{0x225a002f,0xc2e80107,0xb27f02a6,0x5906047b}},	//   _killa_, _kaliyan_, _scendi_, _kropslig, 
   {{0x6079011d,0x42c70019,0x10fc0255,0x7291018f}},	//   _промулга, _дистантт, _नछावर_, _qarad_, 
   {{0x647f023d,0xc62600a4,0x026d0018,0x401400c1}},	//   _progetto_, _بالالۇۇ_, _ikaono_, _चळवळीत_, 
   {{0xb2910201,0xf1330145,0x141800ba,0x7ad201d2}},	// [950] _garab_, _vakarėli, _شۆڤینیست, _ejemplon_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd25a017c,0xad7b036e,0x52910396,0x213101eb}},	//   _gilla_, _alimanya, _azzar_, _bindshel, 
   {{0xc640022b,0x00000000,0x00000000,0x00000000}},	//   _fiskinum_, --, --, --, 
   {{0xc4300055,0x26e300dd,0xe25a03db,0x927e016b}},	//   _endémiqu, _barchedi, _endlu_, _ayinka_, 
   {{0x82910163,0x7b19028d,0x20680261,0xddee0153}},	//   _darab_, _lafarinn_, _aerarmeo, _みんなの感想_, 
   {{0x22990013,0x8e4d0040,0x2c7a0274,0x8e1300d1}},	//   _خاندانین, _אינטל_, _ögmundur_, _ছাত্ৰজনক_, 
   {{0x225a00f3,0xa25a01d4,0xad0d01c7,0xdd3d01db}},	//   _indlu_, _dilla_, _какасыны_, _сайлайды_, 
   {{0x64230164,0xfa8e0286,0xf20600c7,0xe35e02e2}},	//   _ﺋﻪﺩﻩﺑﯩﻴﺎ, _omansies, _сатылса_, _bungled_, 
   {{0x4bca006f,0xc25a0008,0x25bc0210,0xdf640344}},	//   _مراقبي_, _filla_, _achadonh, _allaniin, 
   {{0xe38600c3,0x42c60020,0x5d11012a,0xdc4a032d}},	//   _amoris_, _asalele_, _teoretyc, _азатлығы_, 
   {{0x6291004f,0xe7300061,0xf27f0172,0x124600db}},	//   _barab_, _남자친구가_, _okunu_, _छोडले_, 
   {{0xa29204e6,0x152902a2,0x729101c5,0x522a008d}},	//   _mataas_, _nabigasy, _carab_, _зотан_, 
   {{0x125a02ee,0x6aba00c5,0xa2910152,0xed850061}},	//   _billi_, _双色球霸主_, _sarae_, _카테고리에_, 
   {{0x93800165,0x757b03ef,0x72910298,0x4904020f}},	//   _laurai_, _amatungo_, _parae_, _انګولا_, 
   {{0x17d60022,0xadc20071,0xc38601df,0xd33d0291}},	//   _некролог_, _wikifika, _coorts_, _لتدريب_, 
   {{0x7aef0329,0xbedd02eb,0x5fc40053,0x00000000}},	// [960] _enformen_, _нямбай_, _करमचंद_, --, 
   {{0xa0750079,0x12d80321,0x40f80022,0x2be30192}},	//   _inventār, _rumeno_, _трамвайҙ, _wederpar, 
   {{0x3c5b02c1,0xfc8a0195,0x1ee7040f,0x277b0322}},	//   _bakunze_, _bhictòri, _дарагой_, _amavangi, 
   {{0x027f028d,0x7d4d0205,0xe2fb044a,0x52fc0422}},	//   _thanen_, _баравари_, _kishasa_, _vlago_, 
   {{0x82000531,0xd3790246,0x32240134,0x437900ff}},	//   _thaiv_, _palazzo_, _awoku_, _arbaron_, 
   {{0x34ac0386,0x927f033a,0xd0470076,0x85780037}},	//   _kebanyak, _ikunu_, _законот_, _የተጋነነ_, 
   {{0x225a014b,0x8a970532,0xd3f9005b,0x9af9017e}},	//   _cilli_, _količinu_, _mayuri_, _kreskant, 
   {{0x5f3b00fb,0xc3f801e1,0x6bfa00d9,0x338003eb}},	//   _bangazen, _borutehi_, _лицензио, _korrel_, 
   {{0x82e5031d,0x8622023a,0x5b2e00ad,0xcc6203bd}},	//   _impunity_, _darovani, _bagbagan_, _kaputan_, 
   {{0x83cf0249,0x93860067,0x21470060,0x00000000}},	//   _ataveu_, _medrek_, _шариғат_, --, 
   {{0xb2c2019d,0xce900148,0x37af018d,0xb52f03f8}},	//   _adaluma_, _法人團購更多優惠_, _ሰብአይን_, _nitivmoh, 
   {{0x429100d2,0x262301d7,0xda080156,0xa5850130}},	//   _parab_, _taylorsw, _געװיסע_, _difrouez, 
   {{0x52910201,0x312d00b4,0xea3a002b,0x6b02011a}},	//   _qarab_, _парте_, _সিদ্ধিরগ, _clarifie, 
   {{0xdc950213,0x364c0113,0xdd980299,0x00000000}},	//   _квалифиц, _theileaf, _سۈركەپ_, --, 
   {{0xd4870287,0xb851005e,0xc2b604b9,0x08e90022}},	//   _रेखाको_, _ﻳﺎﭘﻮﻧﯩﻴﻪ_, _doucer_, _газетаһы, 
   {{0x026d0010,0x2d2d0016,0x00000000,0x00000000}},	//   _bavote_, _aranĝita_, --, --, 
   {{0x6c6d0478,0x2e660097,0x8e4a00c8,0x82fe0148}},	// [970] _teorica_, _gẹṣin_, _itlamile_, _maritus_, 
   {{0xf7af03b0,0x539402d4,0x1ec502d0,0x4a16042a}},	//   _rettleii, _glisch_, _haunders_, _ingabeka_, 
   {{0x92d80194,0x98c601b2,0x9fbc028b,0x5e450029}},	//   _astonat_, _antemund, _спорттә_, _مێدیای_, 
   {{0x5d2d02ac,0x8ac70302,0x19c10105,0xa0b1020a}},	//   _leanacht_, _такзиб_, _teleadre, _амандасы, 
   {{0x926c00a7,0x425a01c5,0xdf330061,0xd06d0040}},	//   _alhora_, _cidlo_, _무엇인가를_, _וסלבס_, 
   {{0x19e401f6,0xb31802c4,0x00000000,0x00000000}},	//   _শিক্ষাৰ্, _западнит, --, --, 
   {{0xf283011d,0x3fc20163,0x4b250064,0xf47301b7}},	//   _romaniei_, _ڈائون_, _сурады_, _अमुना_, 
   {{0x520002fd,0x2d0e03ef,0xbf660178,0x00000000}},	//   _chait_, _bafungur, _durbalen, --, 
   {{0x45ba0037,0xa62201ff,0xd2840109,0x6c2d03c2}},	//   _አንድምታ_, _varovani, _alergiky_, _beanachd_, 
   {{0x82100041,0x3abd0094,0x63140156,0x00000000}},	//   _рдиаспор, _سيىمدىلى, _מאָושע_, --, 
   {{0xe291021f,0x82d801d7,0xca160315,0x620004b8}},	//   _karaa_, _schef_, _angabeka_, _thait_, 
   {{0xd2d90338,0x7a5d0369,0x33f9005b,0xb2ef001f}},	//   _tipes_, _hamepuka_, _sayuri_, _woniema_, 
   {{0x861903f2,0x00000000,0x00000000,0x00000000}},	//   _нападающ, --, --, --, 
   {{0xc20004d3,0x2d62020f,0xb999004d,0xd3f400cd}},	//   _khais_, _محرميت_, _水質代驗收費服務_, _cartiu_, 
   {{0xa3160397,0xa131005b,0xfb3201e1,0xa668017a}},	//   _imizwa_, _meddelel, _кескәйҙә, _барангех, 
   {{0x726f006c,0xa291001b,0x120104cc,0x1b2a02af}},	//   _eziningi_, _garaa_, _liyiz_, _akabirab, 
   {{0x3f6c00a7,0x2e4800a9,0xfce101b5,0xd5b90094}},	// [980] _paraules_, _bakababa, _entwanar, _карзайды, 
   {{0x92eb0533,0x0e6401da,0xf273045f,0xa06300d9}},	//   _muintir_, _procesit_, _hänga_, _половой_, 
   {{0x425a0219,0x3e4601ef,0x89c500c7,0xd9e20107}},	//   _sidlo_, _kataloga, _кулдан_, _واگير_, 
   {{0xd2910015,0xe3640288,0xf25a03f8,0xdb6704b3}},	//   _jaraa_, _rangaen_, _dillu_, _boulouar, 
   {{0xe20e01cd,0x6c76012c,0x2aa7028b,0x00000000}},	//   _шараф_, _mbaroni_, _далагт_, --, 
   {{0xf3440129,0x520001d8,0x8e5f00c8,0x1027008e}},	//   _dabeere_, _shait_, _конкурсҡ, _bindewoo, 
   {{0x9911027b,0xcf8e0092,0x626d01da,0xdccc013c}},	//   _स्वरार्थ, _ドランキング_, _javore_, _nöqtə_, 
   {{0x3a490049,0xb25a0534,0xc24804f2,0xf2e9008d}},	//   _puleanga_, _daklak_, _phomai_, _tadigan_, 
   {{0x81400169,0x3dbb017f,0xae500166,0x35ef012e}},	//   _মালিকানা_, _akmissaa, _leuchtet_, _merevedé, 
   {{0xc1ca0247,0x73860535,0x67da0208,0xddd20147}},	//   _مراقبت_, _mmere_, _سعودیا_, _جۅتكۅپ_, 
   {{0x62d90466,0x27f80037,0x2372003a,0x00000000}},	//   _stanove_, _ደጋግመን_, _osilsang_, --, 
   {{0xdfbd0164,0x320004bb,0x80ca009b,0x938602ab}},	//   _جەريانىد, _rhais_, _сорви_, _omere_, 
   {{0x930501e0,0x2107009a,0x6e4e0125,0x626d0009}},	//   _خوتان_, _ngokumal, _даргашып_, _zavore_, 
   {{0x8303036d,0x673604dc,0x3395021c,0x4aa1005b}},	//   _malairt_, _بالنده_, _plasty_, _beskeden_, 
   {{0x446602f1,0xcd9d005f,0x302c0364,0x9abb0188}},	//   _novembro_, _guanajua, _nordbank_, _akukabos, 
   {{0xe2cb0536,0x4b270163,0xfeb802d5,0x00000000}},	//   _ccedil_, _kápolna_, _fototehn, --, 
   {{0x928600a2,0x42560185,0xf0710537,0x93b10242}},	// [990] _mabalozi_, _cimerelm, _levaremo, _basqa_, 
   {{0x2db60036,0x246d03d9,0xd25a014b,0xcb660133}},	//   _cuirimid_, _tandremo_, _billu_, _baruumsa_, 
   {{0xf3860129,0x734200c3,0xc2fe0073,0x82e801c0}},	//   _emere_, _ingenio_, _fusiles_, _dalilan_, 
   {{0x274d00de,0x492302ac,0x2aa4034b,0x823002fe}},	//   _abanoluv, _لاتفوتكم_, _obligeis, _amemeza_, 
   {{0x156e0156,0x1f2003d1,0x93d70046,0x20c10538}},	//   _מומביי_, _pavedien, _سۉيگانوش, _celledel, 
   {{0x7aad0036,0x33860200,0x5200000a,0xf7790299}},	//   _حزيران_, _imere_, _akait_, _دوستوم_, 
   {{0x29c301e0,0xc27302f3,0x82c9022a,0x33a901ac}},	//   _کاربه_, _hända_, _notodob_, _ازهار_, 
   {{0x027e015c,0x547900be,0x823203e6,0xf3a304be}},	//   _stonne_, _програмд, _ausmaan_, _ihapak_, 
   {{0xebb201cb,0x525a00bd,0xa7c003be,0x147c0156}},	//   _omthetho_, _killt_, _bakubisw, _פּושינג_, 
   {{0xfcd90199,0x8e2b0113,0xb8360539,0xb0aa02d3}},	//   _alivethr, _chigirea, _sølvmeda, _навивачк, 
   {{0x71460357,0x0ad30192,0x5c770065,0x63eb0220}},	//   _clarksto, _opstarte, _riesige_, _eletto_, 
   {{0xbf24053a,0x4846037b,0x00000000,0x00000000}},	//   _višak_, _frutales_, --, --, 
   {{0xe290011f,0x52c5023e,0x52b502a6,0x0d1c0060}},	//   _nekane_, _vegetasi_, _greche_, _өлсем_, 
   {{0xb2040240,0x328f0171,0xce7e0076,0x77110109}},	//   _basikeli_, _najpovol, _спринтер, _हँुदै_, 
   {{0xa2d90062,0x9a9900d1,0x18fb037f,0x8ece0223}},	//   _dipep_, _কালছোৱাত_, _vahabzad, _задарсан_, 
   {{0x23ea006f,0x39d702c9,0xd17f023e,0x12ea036e}},	//   _uzito_, _horoscop_, _خسارات_, _antiman_, 
   {{0xb7e300b5,0x846e0092,0x883f0037,0xcae700df}},	// [9a0] _алорд_, _ランキングを詳し, _ተቀብሏል_, _embrasse, 
   {{0x2e000179,0xbc2d011a,0xf5c00378,0x325a0115}},	//   _wereldta, _imbalanc, _blokknið, _taklik_, 
   {{0xc2d401ec,0x8afe0288,0x634a02fb,0x6ee5004d}},	//   _kardus_, _ausgiess, _angefau_, _觀看報紙版_, 
   {{0xfbc403dd,0xa01701b3,0xe8a301db,0xf45e0350}},	//   _kancerin_, _районне_, _سەكۋند_, _መዛሙርትህ_, 
   {{0x227f036e,0xa35b0103,0x34a80060,0x5487019b}},	//   _chanin_, _azogara_, _قارامايل, _keturkoj, 
   {{0x4e2802ac,0x63690331,0xd6ba02d9,0x5f2e01d2}},	//   _لبوابة_, _fregnir_, _overstay, _indexmun, 
   {{0xd332015e,0xb2940274,0xd3ea028d,0x6b57019b}},	//   _baixos_, _frekari_, _ciltra_, _базару_, 
   {{0xd355053b,0x1a0901a3,0xdf4200d6,0x1c43037c}},	//   _confira_, _اڪابر_, _barracha, _barbaric, 
   {{0x72e80140,0xa0120092,0x637b006a,0x1d8000ee}},	//   _maliban_, _タイで見る_, _hataoko_, _normalea, 
   {{0xa3f90467,0xf3170064,0xb2cb0035,0x9c5d0251}},	//   _fufuro_, _carboni_, _baedı_, _tartamo_, 
   {{0xa4d40139,0x1b750193,0x349d0039,0xcb620162}},	//   _विविधा_, _कार्पोरे, _berariaz, _шериклиш, 
   {{0x648400ac,0x2e5700b4,0x43ea01a4,0x6acc004d}},	//   _pokušajt, _concerte_, _ezate_, _異議受理單位_, 
   {{0x052702ba,0xddb602c6,0x22ef044a,0x39f8019a}},	//   _валенса_, _andifeda, _boniama_, _forgethe, 
   {{0x8d8504df,0x26230008,0x5d490235,0xb2fe009d}},	//   _adamdana, _создор_, _bandheṣu_, _habitur_, 
   {{0xc37b006a,0x8fc000ce,0x03c70089,0xe9ab01ef}},	//   _nataoko_, _lakomino, _мухаметш, _апаненты_, 
   {{0xa1570277,0xe7860102,0xa2e000d6,0x02da03dd}},	//   _sourcebo, _باشندن_, _domnall_, _evropes_, 
   {{0xd51700f5,0x939500ce,0xea0800d5,0xe2e8001e}},	// [9b0] _сайлады_, _berso_, _manatona_, _daliban_, 
   {{0x5408029e,0x6c35003d,0x00000000,0x00000000}},	//   _chauffin_, _bipartic, --, --, 
   {{0x45d600d6,0x022b03ea,0xad7f0348,0x8d050209}},	//   _forbarth, _chambre_, _akimanye_, _attuisar, 
   {{0x7854018d,0xfa08006a,0xf2d80342,0x6c0104df}},	//   _ሃልሃልታ_, _nanatona_, _echek_, _bergidar, 
   {{0xad890098,0x8ef101a3,0x23400371,0xfc63016a}},	//   _rimelige_, _نگاھون_, _modella_, _beaupol_, 
   {{0xb1f200fd,0x00000000,0x00000000,0x00000000}},	//   _breabadh_, --, --, --, 
   {{0x9052013b,0x33f90367,0xdeb1004b,0xac330222}},	//   _podravin, _daqui_, _difumane_, _descendr, 
   {{0x932b0497,0x195c01b2,0x820e0039,0xc4280061}},	//   _chicory_, _impounde, _тахал_, _필수적이다_, 
   {{0x008c01d5,0xf2d80465,0x3c93026f,0xe30100cf}},	//   _بیہقی_, _spleta_, _تاڭات_, _bayanii_, 
   {{0xc0d101eb,0x13d30061,0xeb67026e,0x42c70101}},	//   _асамбои_, _기획예산과_, _जोडने_, _hoteluri_, 
   {{0x726e0198,0x37e20061,0x48470374,0x00000000}},	//   _lepota_, _헌법재판관_, _манави_, --, 
   {{0xd7920220,0x00f80168,0x2396004c,0x5f3a0171}},	//   _интересу, _samhandl, _amussa_, _posumnja, 
   {{0xed85052e,0x63dd007f,0x7c8002b6,0xd4650066}},	//   _sinecure_, _chawod_, _кесер_, _landutak, 
   {{0x0a6d04ad,0x9a08006a,0x9ff900b7,0x4332015e}},	//   _boporaeb, _hanatona_, _җайындак, _caixes_, 
   {{0xd9d80094,0xb15102ec,0x83900062,0x77e90076}},	//   _алдарасп, _yeelatay_, _chuydah_, _валандов, 
   {{0x462c00ee,0xf0f000b3,0xa263004a,0xf429003b}},	//   _египетэд_, _ahtimall, _izraildä_, _kukhonek, 
   {{0x5344053c,0xab220321,0xc3f002d8,0x727f0127}},	// [9c0] _ourense_, _ljubezen_, _konsumsi_, _ahanon_, 
   {{0x127f019d,0x2758012a,0x5c510290,0x00000000}},	//   _nyanja_, _मुद्दों_, _apoteca_, --, 
   {{0xbc7f02af,0xbc73001d,0x200202ac,0x945c0040}},	//   _akamanyu_, _guarras_, _إستراتيج, _ולהמשיך_, 
   {{0x322b0387,0xa2b5001d,0x727e01da,0x5a760078}},	//   _akamere_, _gesco_, _pronat_, _сегменту_, 
   {{0x0c6f0217,0x3332015e,0x82d80304,0x210c016e}},	//   _pharaon_, _baixes_, _acheh_, _anahtarl, 
   {{0x6fe70411,0x966703bf,0xce4a0216,0x1e6b00e6}},	//   _utfyllen, _ҡадиров_, _lulamile_, _依法从重处罚_, 
   {{0x3cfa0133,0xc2e80151,0x26c00262,0x864200a1}},	//   _akkeesuu_, _aalican_, _aýyplaýa, _pakipaki, 
   {{0xdc6903f5,0xd2b80092,0x5fec00de,0x724803ec}},	//   _dourado_, _参議院議員_, _awayefan, _kulmin_, 
   {{0xa889053d,0x627e0090,0x2c88013c,0x926d01ac}},	//   _abakwand, _aronge_, _bildiklə, _rindreái, 
   {{0xa3a302c3,0x727e01e7,0xdef30350,0x2c580299}},	//   _prepis_, _bronge_, _ታዛቢዎችና_, _ساداقىتى, 
   {{0x622400ec,0xa3f60265,0xf2240464,0x4fe90053}},	//   _etikos_, _vanzelf_, _ntoke_, _मेगावॉट_, 
   {{0x874c0220,0xd5f204e5,0x43950116,0x6f110147}},	//   _растения_, _agumansi, _gerse_, _كۉلجىگىت_, 
   {{0x564c029f,0x5d8702a9,0xd9f6029b,0xe60300b9}},	//   _psycholó, _мармур_, _bouño_, _ngeluari, 
   {{0x00c10156,0xc25a00fd,0xbe290019,0x0908013b}},	//   _לאביונים_, _bidli_, _байларыб, _pamakabu, 
   {{0xf39500c7,0x6df40302,0xac7f0321,0x293c002b}},	//   _berse_, _экунумис, _prostem_, _নিবেদিতপ, 
   {{0x62fd0218,0xf37f0528,0xe7090008,0x5c090326}},	//   _ivengay_, _chiadna_, _сеники_, _chipepa_, 
   {{0xc355023b,0x034100ec,0xd76f053e,0x00000000}},	// [9d0] _raifela_, _sviesto_, _tolvårin, --, 
   {{0xe34c034b,0x72da025c,0x00000000,0x00000000}},	//   _auteuil_, _eltern_, --, --, 
   {{0xa2000369,0x139501c2,0x0ec400c4,0x4201021f}},	//   _akaii_, _terse_, _wanyarwa, _fayiliii_, 
   {{0xa29100c7,0x214e00f7,0xd936011a,0x7e920161}},	//   _azrak_, _anatomio, _וסאטירה_, _постель_, 
   {{0xf4890095,0x725a01bb,0x33bb00d7,0x72da0362}},	//   _روزانه_, _hilli_, _росстатт, _napesi_, 
   {{0x4af70262,0xc95e043f,0x17550376,0x0c3a0365}},	//   _машкың_, _poznajet, _farstøði, _पुरयाउन_, 
   {{0x93f40331,0x052d005e,0x9302026a,0x43860192}},	//   _stutta_, _ﺋﺎﺩﺩﻯ_, _mamarau_, _koorts_, 
   {{0x8af4007e,0xdf33053f,0x7f2e020a,0x1f330156}},	//   _श्रीलक्ष, _tukstata, _қиялы_, _ראָשי_, 
   {{0x70dd00bb,0xc41c01ef,0xb2a6002a,0x2b84006a}},	//   _عیاری_, _meninink, _obobdo_, _afangaro_, 
   {{0x79e3033a,0x98e70052,0xd2da0290,0xbae30147}},	//   _dedikata_, _zásobová, _capeti_, _كۅدۅۅسۉ_, 
   {{0xb2ef0540,0x11640287,0x9cd20061,0xc2640541}},	//   _þeirra_, _poloviny_, _누군가에게_, _polovini_, 
   {{0xa2d90031,0x629002c6,0x3d2900e1,0x44220066}},	//   _dapet_, _bekabe_, _doonadee_, _haratago_, 
   {{0x2a8e001b,0xd94e014b,0xf25a0294,0xeff90350}},	//   _amantiin_, _kiilomit, _huttayll, _ያስብላል_, 
   {{0x40070162,0x03950180,0x5fd303f0,0xe6ab0184}},	//   _دىلىمدىن_, _serse_, _aukakrón, _nkurirah, 
   {{0x7f250455,0x4a0502a4,0xf25a00ec,0x02d90270}},	//   _utiliser_, _butalbit, _арыгінал, _planate_, 
   {{0x2bc90147,0xbaa801bd,0x82c602d8,0xff24022f}},	//   _грузияда, _кредитті, _bereaksi_, _nyderlan, 
   {{0x6270004f,0xe2d901f1,0x51f3008b,0x575c0308}},	// [9e0] _benneeli_, _hapet_, _dinañuy_, _keliling, 
   {{0x425b0062,0x5e710052,0x6f48014b,0xef20025e}},	//   _botlu_, _कमन्स_, _maksaana, _birtinga, 
   {{0x02d901b7,0xfee3010d,0x522c02fe,0x8d8102a4}},	//   _japet_, _दाक्षिणा, _فیصلی_, _referunt_, 
   {{0xeaac004b,0x02f301d8,0xf5c70381,0x1f4201ad}},	//   _быков_, _kumapati_, _ailandth, _fabricia, 
   {{0x427f0184,0xc83202ac,0xb42901f0,0xa2d2034e}},	//   _ayanka_, _شاطىء_, _kabalano_, _imatatah_, 
   {{0xdb74051c,0x49c000f8,0x00000000,0x00000000}},	//   _manshuwa_, _শেরেবাংল, --, --, 
   {{0xd2b00542,0x928a0163,0x52eb027a,0xc2da0239}},	//   _कुरुप_, _grafikák, _citirao_, _rapeti_, 
   {{0x06150020,0x05350342,0x30fb0010,0x4b0902c3}},	//   _apologai, _aktyaliz, _baphekel, _vulgárne_, 
   {{0xfaf2024b,0xb4f900ba,0x61c70425,0x0302028f}},	//   _presupue, _پرۆپاگه_, _کارتۆن_, _tamarau_, 
   {{0xd7620388,0x18340543,0x13780415,0x0f63014f}},	//   _става_, _клаудио_, _monaten_, _персијск, 
   {{0x8a740135,0xe2e200a7,0x042204f9,0xdb590205}},	//   _элитасы_, _энергоба, _annikikk, _миссияси, 
   {{0x42d8019a,0xaf280187,0xd2e10450,0x43f900b9}},	//   _saloons_, _impressa, _feinsum_, _gayus_, 
   {{0x92b503a1,0x913601e0,0x22ea00ec,0x00000000}},	//   _pesce_, _بریقه_, _grindis_, --, 
   {{0xe752019c,0x72d40098,0xeddf0193,0x58cb0311}},	//   _adanilag, _husdyr_, _berjabat_, _ዝተሳዕረ_, 
   {{0x2d4a01b6,0x49de0169,0xdb0b014e,0x031100ec}},	//   _لسانك_, _সুকুমার_, _стални_, _debesų_, 
   {{0x02d9038d,0xd3870465,0xc9570041,0x7a93027b}},	//   _rapel_, _pogreb_, _туаҧсе_, _गोपीजनवल, 
   {{0xa0590140,0xeaed0264,0x13f90115,0x72f200d9}},	// [9f0] _diksiyon, _wolfrats, _dayus_, _энергосб, 
   {{0x20860148,0x02da01ab,0xd66702cf,0x8f0e0095}},	//   _金管證四字第_, _tänava_, _трикови_, _adityawa, 
   {{0x227f0288,0x06820179,0xf2900274,0x00000000}},	//   _ekanen_, _nerekosi, _rekast_, --, 
   {{0x025a02e7,0xe119026f,0x24400018,0xa2ea00d5}},	//   _bellow_, _ءنۇسىپحا, _itikotik, _didinao_, 
   {{0xe3a90066,0xd5b30148,0x227e00d9,0x91b803a4}},	//   _онигоо_, _regionem_, _tuonne_, _elkervið_, 
   {{0x9e74003a,0x23f40274,0x6343035b,0x617700da}},	//   _чемпионл, _ingibjör, _telesom_, _finantel, 
   {{0x527e0544,0x853a0226,0x32eb02fd,0x43ea015a}},	//   _edena_, _akanasiy, _braisil_, _asitti_, 
   {{0xb9f300d0,0xc2fc01e1,0x12fc004d,0xf18803b0}},	//   _prestatu, _boigu_, _水瓶月座的人_, _alvanutl, 
   {{0x24a80024,0xa87b0213,0x50dd0374,0x47e501b7}},	//   _মুদ্ৰকৰ_, _ытларах_, _depozitl, _cetasaiv, 
   {{0xfc3500d2,0x98f10065,0x00000000,0x00000000}},	//   _ngabubur, _versteig, --, --, 
   {{0x43950247,0x741703ad,0x527e0101,0x00000000}},	//   _kersa_, _barranin_, _lemne_, --, 
   {{0x79650194,0x56a5009a,0x5807011a,0x00000000}},	//   _notorime, _bentsaph, _שתגיע_, --, 
   {{0x8f9e00bc,0xb0370227,0x23170067,0xcc0e00ec}},	//   _محسوب_, _semenjak_, _darbani_, _nepagrįs, 
   {{0xe2d9043a,0x52d401c5,0x00000000,0x00000000}},	//   _taxet_, _gogosha_, --, --, 
   {{0x13780515,0x9e7203aa,0x9c39048c,0xb9dd01c4}},	//   _novanta_, _वाह्य_, _asschaar, _forensie, 
   {{0x2200008b,0x98c50034,0x7b060435,0x00000000}},	//   _ajiin_, _afgerand, _картица_, --, 
   {{0x029101ac,0x97b90261,0x60450159,0x92790031}},	// [a00] _cheana_, _altfrekv, _skersmen, _bergelim, 
   {{0xd27e001b,0x6ad50288,0x00000000,0x00000000}},	//   _demne_, _erstarre, --, --, 
   {{0x2ed603b9,0xb3950013,0x4a7c0126,0x96030161}},	//   _camillun, _bersa_, _принципі_, _логином_, 
   {{0x86a503f8,0xd30102fe,0x652b0135,0x00000000}},	//   _datuqtah, _eerandi_, _kaderlär, --, 
   {{0x9386012f,0x84e6016d,0x6c6201b2,0x41fa0322}},	//   _emero_, _урушқа_, _antraie_, _aranshim, 
   {{0xdc8202d5,0xb9ce004d,0x042200be,0x00000000}},	//   _perekond_, _國三生身高_, _قامپا_, --, 
   {{0x638101f0,0xcf530156,0xcf4b0545,0x82da00d9}},	//   _enayang_, _סטארי_, _artsrike_, _paperi_, 
   {{0x03ea00b2,0xf76d00be,0x839500b6,0xb22b009a}},	//   _asitt_, _апалар_, _gersi_, _azimase_, 
   {{0xda0a0224,0x429002a2,0x09c700d7,0xbf2e0166}},	//   _persónul, _binago_, _маташа_, _anmerkun, 
   {{0x727e019a,0xe1630013,0x62fe033c,0x3cba0037}},	//   _manned_, _мушук_, _bargod_, _ሳይንሶች_, 
   {{0x63ea03b4,0xceaf02e2,0x8f570188,0xff360205}},	//   _tsitsi_, _adultrin, _ahlangen, _шахсдан_, 
   {{0x9d1d0152,0x7c0c0080,0xde690256,0xb3950304}},	//   _igelekle_, _alaskap_, _modificē, _jersi_, 
   {{0x92120211,0x3ee7008d,0x53950138,0x1c4401d7}},	//   _vanha_, _саратон_, _dersi_, _carvers_, 
   {{0x37a703b9,0x184c00b4,0xfb7d00bb,0x186d0010}},	//   _mistsupx, _контрази, _مؤرخہ_, _belibhod, 
   {{0x721200bc,0x8f4102c5,0x3be7026f,0xe3660042}},	//   _tanha_, _akarisha, _қисаюуы_, _chegado_, 
   {{0x0b670546,0xccc3019e,0xae00022f,0x00000000}},	//   _आगजनी_, _šokolado_, _surengta, --, 
   {{0x56b50044,0xb7b502a3,0x33570185,0xd9f80157}},	// [a10] _saturday, _saterdag, _cimerep_, _kamienna_, 
   {{0xa2bf0122,0x430300d6,0x46fb0205,0x229201f5}},	//   _سمنان_, _raidió_, _строкой_, _sesaat_, 
   {{0xe3010075,0x959b00c5,0x323e0127,0x1d6b0041}},	//   _verandi_, _胡锦涛强调_, _arameek_, _ихәҭоу_, 
   {{0x4e36030c,0x027e0116,0x23f40415,0xca340046}},	//   _kalallua, _fanned_, _leuten_, _قىيباعان, 
   {{0x34480128,0x0b0c02c2,0x5d6000e6,0xb9700259}},	//   _کوملگن_, _klaskame, _出入境管理局_, _fornemst, 
   {{0x030700e4,0x328b019f,0x125b02c3,0x2ac700c1}},	//   _nibandh_, _kujadili_, _kotly_, _टोणपे_, 
   {{0x52500444,0x6d0d03ce,0x0c460362,0x5817020a}},	//   _левая_, _سزادان_, _esepelis, _سىيونيزم_, 
   {{0x5396046d,0x97ba0285,0x90ed000e,0xa33c01a3}},	//   _aluswa_, _hakuriki, _christal, _ريمارڪس_, 
   {{0xae48046d,0x7e4e002b,0x10b5012b,0x23ea00ea}},	//   _makahane_, _হায়দার_, _premiery_, _izato_, 
   {{0xc93504ab,0x73ac0547,0xcae4019b,0x53570053}},	//   _primjera_, _chupar_, _kreipęsi, _आपुले_, 
   {{0xbc640095,0xa3f40065,0x00000000,0x00000000}},	//   _diculke_, _deuten_, --, --, 
   {{0xabff0225,0xf0fb02b4,0x93950015,0x52010087}},	//   _austreib, _baphakel, _xersi_, _layini_, 
   {{0xeb91024b,0xb25b03b0,0x18480061,0x35aa0211}},	//   _duración_, _litle_, _바르셀로나_, _спасения_, 
   {{0x53f8049a,0x72cb0139,0xee96014a,0x905703c6}},	//   _pljuje_, _adadat_, _پرغور_, _longerho, 
   {{0xa10b00c5,0x62d902fb,0x42910155,0x53950138}},	//   _座落于胜利油田发, _kapei_, _hyran_, _tersi_, 
   {{0xac61027b,0xa9f70314,0xb25a048c,0x2e0d01a3}},	//   _acirād_, _менњн_, _aillt_, _سُهڻا_, 
   {{0x5ebb02e6,0xf5e500e6,0x1df80177,0x3b060059}},	// [a20] _overveje_, _邮箱大奖等你拿_, _лыцәгьар, _частици_, 
   {{0xf4910139,0x7ebf00bc,0xbd7a036c,0x8aff006c}},	//   _दम्मी_, _جومونگ_, _tsimbaza, _abashiye, 
   {{0x4fd50287,0x49c503fe,0x5f07007e,0x6af8006c}},	//   _पारिएको_, _гулдан_, _damayatā, _azishint, 
   {{0xa6080177,0xcd9c02f7,0xcec6034c,0xb2fc00ea}},	//   _аиустици, _berekile_, _фактик_, _blagy_, 
   {{0x025a005b,0x8db80381,0x79e601b0,0x00000000}},	//   _gills_, _ankingba, _carogena_, --, 
   {{0x2a060334,0x64c90078,0xf7ee03ef,0x00000000}},	//   _ankatsut, _догодила_, _barareng, --, 
   {{0xd18d0444,0x4dbd015a,0x1d350029,0x8c02008c}},	//   _писатель_, _afriikaa, _پۆڵیڤیا_, _caussas_, 
   {{0x363700bc,0x46080503,0xc1840145,0xb7ba01dd}},	//   _khoshgel_, _formidli, _няхай_, _zakuriki, 
   {{0x37ba0440,0xae2e0040,0xc9c8035e,0xd2b50220}},	//   _bakuriki, _חוששים_, _potvrdju, _pesci_, 
   {{0xa2240264,0xc250021b,0xea920210,0xa25b0138}},	//   _trikes_, _делал_, _ananiyas, _kitle_, 
   {{0xb2fc01ad,0xf2d80177,0x8ab0020f,0x3c730189}},	//   _enage_, _проекҭқә, _فلوریډا_, _türkan_, 
   {{0xe2fe007f,0x27430092,0x820a00af,0x587400d6}},	//   _targed_, _クに登録されてい, _симоненк, _indibhid, 
   {{0xf27f0377,0xf20101b5,0x8c640017,0xf386028f}},	//   _ajuns_, _fayini_, _libuše_, _umere_, 
   {{0x6b2c00e9,0x8e3d00be,0xdc1b02cd,0xc22400fe}},	//   _devalyas, _долларла, _aljannar, _kuoke_, 
   {{0xd3860206,0xa471007a,0xc99600c6,0x273000d6}},	//   _smere_, _rentetan_, _brukerst, _fhisiciú, 
   {{0x12df015e,0xb25a0044,0xae5301c5,0xbcbc0064}},	//   _europeu_, _bills_, _qafaasha, _апасын_, 
   {{0xa7ba0440,0x285600c4,0x6947026b,0x0a010043}},	// [a30] _yakuriki, _سنڌڙيءَ_, _cremalle, _bebafuga_, 
   {{0xf3ea01d9,0x89e600dc,0xced60078,0x25150322}},	//   _fritzi_, _fiatauau, _идола_, _ataricyo_, 
   {{0x32fc01b8,0x1498042a,0x3dce01de,0x6ed8019d}},	//   _liige_, _banganik, _жирен_, _kunyumba, 
   {{0xd25a01d3,0xdb0c0125,0xa2020265,0x87ba01dd}},	//   _tills_, _бурны_, _opties_, _wakuriki, 
   {{0xc8270060,0x3c6e0365,0x29b503dc,0x9ed400ec}},	//   _قاراشا_, _refrén_, _fundarpe, _kelionin, 
   {{0x2d6f0147,0x5af50271,0xfea402e2,0xeaf4029e}},	//   _ئحسان_, _overnatt, _ableness_, _atersade, 
   {{0xb3a90404,0x0dbe02f6,0x625a003f,0x71760139}},	//   _magatong_, _katipuna, _jedlaw_, _प्रयतात्, 
   {{0xa2900285,0x1224007b,0xc8e5002b,0x00000000}},	//   _bukavu_, _daiker_, _শিক্ষামূ, --, 
   {{0x937c00f9,0x32ee0220,0x161000c1,0xb86800b7}},	//   _yatanze_, _tecnici_, _वेलदोड्य, _berilmed, 
   {{0xad5a019e,0xc2a30270,0xc1a0004d,0xd1f70077}},	//   _штатам_, _precisem, _加入行事曆_, _enjistem, 
   {{0x8dd9034f,0xa8ce00c3,0x7eb8033f,0x02240181}},	//   _دتخار_, _perfectu, _kolokein, _etoko_, 
   {{0xde69018b,0xb291002f,0xc98704d7,0x52010087}},	//   _modifică, _bifaro_, _útiloka_, _nayili_, 
   {{0x8a080282,0xf4ee0097,0x4344044d,0xa7390062}},	//   _akiakina_, _hìnkùlé_, _gindiku_, _netlhlog, 
   {{0x696a0003,0x0d9703f2,0xce3600d2,0x7c1e0311}},	//   _advisere, _listattu_, _dihaleua, _መንግስተይ_, 
   {{0xe3ea000b,0xf5f30548,0xf2fd0151,0x8db50381}},	//   _aitulagi_, _krumspri, _beagli_, _egendsla, 
   {{0xbec40096,0x22fd0211,0x8fae002b,0x9d0a02ca}},	//   _banyarwa, _reagoi_, _অযৌক্তিক_, _diallait_, 
   {{0x32d801eb,0x03f40030,0x3395022e,0xef21004b}},	// [a40] _blanked_, _kastes_, _versu_, _bosehlen, 
   {{0x55be013c,0x42d8019a,0x81b301ac,0x8c65018a}},	//   _döydülər_, _clanked_, _خاطرك_, _brotest_, 
   {{0x3f6b0273,0x3395047b,0xfb8c0040,0x0ac60187}},	//   _usuarios_, _gerst_, _ההנדסה_, _афион_, 
   {{0x32ec02ff,0xf291016a,0xac7202ed,0x728e02b6}},	//   _otantik_, _invado_, _arasaac_, _ғаламнан_, 
   {{0x2c6700d7,0xfc020249,0x43ea009c,0xd5870185}},	//   _aparang_, _mauspas_, _asiti_, _никколо_, 
   {{0xf5d8037c,0xb65d00d9,0x73950003,0x53ea0066}},	//   _glickenh, _tarkemmi, _kerst_, _aritz_, 
   {{0x92fc002e,0x6c1802da,0x8fe201e9,0xdfed0191}},	//   _snage_, _текстот_, _badirako, _riskerar_, 
   {{0x153200db,0x7d8703d0,0x425a0062,0xa2f4007b}},	//   _नब्बे_, _sjednice_, _dellaw_, _bruital_, 
   {{0x225b00f3,0x0a2d00af,0x3729034c,0xa30100b2}},	//   _entla_, _покращен, _arslanov, _baqanii_, 
   {{0xb2c1004b,0xe73001e0,0xf38600ae,0xc7e402ff}},	//   _mohlala_, _دیبانی_, _imera_, _laperèz_, 
   {{0xa1c700bc,0xe45e00ff,0xb2f5043b,0x9c73004a}},	//   _جاستین_, _אוגאנדע_, _gàrradh_, _därman_, 
   {{0x30fe02b4,0xe2900176,0x89810234,0x83b60188}},	//   _babhadal, _afkast_, _onikunra_, _ayavuma_, 
   {{0x75e2027f,0xfdd80297,0xcc1904df,0x00000000}},	//   _atibagiy, _balkonna, _barỳan_, --, 
   {{0xbb49030d,0x12900181,0x00000000,0x00000000}},	//   _cabbarlı_, _dfkaze_, --, --, 
   {{0xf2e102ac,0x727f02a8,0x12d80230,0x3f580216}},	//   _اضغطي_, _tkunx_, _lalenn_, _entangen, 
   {{0xfaf901b1,0x3c9200c1,0x02900549,0xf3c80163}},	//   _कृष्णदास_, _अंघोळ_, _seljord_, _tervez_, 
   {{0x7065053e,0x7e3302ac,0xd2b5026d,0x39b5001b}},	// [a50] _politikk_, _بنطلونات_, _tescu_, _fundurat, 
   {{0x48b90244,0x5c51004c,0x93200119,0x00000000}},	//   _последни_, _alituma_, _canchis_, --, 
   {{0x3dd0023d,0x039e002f,0xf2d20439,0x1afc017f}},	//   _остров_, _dasypus_, _mutekani_, _immernis, 
   {{0x50e50142,0x72780374,0x8e4c021f,0x7a08042d}},	//   _देवीम्_, _фғонисто, _gabaajee_, _hanarona_, 
   {{0x4d29015e,0x2d6d0040,0xae0003b5,0x4bb601f4}},	//   _suspendr, _ניסתה_, _perebuta, _врачлар_, 
   {{0x1d920251,0xbb1700d9,0xffb301db,0x7889006e}},	//   _puntland_, _вниманию_, _оқиық_, _daakaand, 
   {{0x472a0092,0xa42d00a8,0x363b00d1,0x5941002b}},	//   _読み込んでいます_, _stoppien_, _কালীয়_, _স্তনে_, 
   {{0xe4a501a3,0x77760052,0x6c7602c3,0x7b5600d1}},	//   _انڌاڌنڌ_, _pružinov, _záruke_, _সংকটৰপৰা_, 
   {{0x5ae201d3,0xe6ac0156,0xb43603d9,0xfc9e00ab}},	//   _studentb, _publikoj_, _ambarako_, _kakepuku_, 
   {{0x0fc30132,0xbb9d0234,0x00000000,0x00000000}},	//   _aggodalo, _werinipr, --, --, 
   {{0xcd5a0444,0x3f58012f,0xa1860061,0x5f4902a1}},	//   _почек_, _erbarmen, _스와로브스키_, _bakplaat_, 
   {{0x777600ef,0x3cef00e6,0xc2da032d,0xfda800fe}},	//   _abayindw, _万元以下罚款_, _bopeng_, _kafukafu_, 
   {{0xca270012,0x7da1003e,0x00000000,0x00000000}},	//   _बिसबास_, _екатерин_, --, --, 
   {{0xa6410071,0xf20e01cd,0x6fe40244,0xcf8701ea}},	//   _کارکنان_, _назан_, _великден, _маҳзун_, 
   {{0x12e803de,0x8e1b003d,0xb30000d7,0x6964020f}},	//   _umzimba_, _normands_, _bofalli_, _andisiwe, 
   {{0x33070304,0xe200015e,0xdd8a0299,0x26d30028}},	//   _dibasuh_, _conill_, _ئىشكاپ_, _xabaashi, 
   {{0x52ef003d,0xf25a01d4,0x16790152,0x22010416}},	// [a60] _empiric_, _dalli_, _beryulı_, _novial_, 
   {{0x03e50014,0xc2c502c7,0xdff301ac,0x4dfe0017}},	//   _celulari_, _sammler_, _muiscíte_, _जन्मन्छ_, 
   {{0x927e01c5,0xc3950258,0xf20101cd,0xe38602c6}},	//   _sannad_, _iersk_, _anezinhl, _enorus_, 
   {{0x3c0a012d,0xbd2c054a,0x9b9f0187,0xf2fc008d}},	//   _adopsen_, _dobijate_, _acrilico_, _yniga_, 
   {{0x8d210321,0x51900299,0x152a0259,0x00000000}},	//   _zanimive_, _ئولۇمپىك_, _babydark, --, 
   {{0xd75d0016,0x7b70019d,0x3b770081,0x85b301db}},	//   _רבונו_, _nyirenda_, _kolbrún_, _تەڭدەپ_, 
   {{0x22ef00b3,0x058303ac,0x425a054b,0x00000000}},	//   _ahundow_, _dimeriah, _yalli_, --, 
   {{0xe25a00b6,0x73150126,0x29670288,0x808e01db}},	//   _calli_, _включенн, _obaiwote, _бизнеске_, 
   {{0x837c01db,0xb2f100a2,0x1bff0059,0x3ae2004c}},	//   _اتقوشى_, _mapishi_, _singolar, _atategee, 
   {{0x82fc01ea,0xa167019e,0xd6b40342,0x42da02ae}},	//   _rniga_, _храмам_, _anbochaj_, _poreč_, 
   {{0x13860321,0x22d9015e,0x82ef0358,0x83ea0211}},	//   _smeri_, _mapes_, _dekouraj, _esitti_, 
   {{0x32c101b8,0x64ba0362,0xb343030a,0x83090195}},	//   _tellida_, _ebebisak, _obreiro_, _phabail_, 
   {{0x7f1001db,0x5c25014d,0xce1700c1,0x831e0364}},	//   _ءبورىنىڭ_, _verbrauc, _जगभरच्या_, _obschon_, 
   {{0x20500178,0x5077006d,0x92e900c5,0xc2d9007b}},	//   _aparāhna, _хронік_, _prenant_, _gapes_, 
   {{0xf3ea040b,0xd296005b,0x00000000,0x00000000}},	//   _dzata_, _takayuki_, --, --, 
   {{0xb41601b7,0xc2fc0318,0x6ec1012b,0x4e440315}},	//   _हीदमायुष, _feigai_, _niedostę, _ingasifa, 
   {{0x82cc01f9,0x02190166,0x426101e5,0x02d90017}},	// [a70] _ayidluli_, _markenam, _kaloliki_, _kapes_, 
   {{0x227e00bd,0x127e0129,0xe96a054c,0xe6390350}},	//   _keeng_, _isonye_, _aktivise, _ከታሰበው_, 
   {{0x0a650041,0x6f5b004c,0x0c5203d1,0xdc4001ac}},	//   _рмшын_, _bakankan, _platuma_, _wyspians, 
   {{0xa1c90074,0xf7800177,0x52eb00e9,0x19e9010f}},	//   _почте_, _арабтә_, _nsansis_, _amathulu, 
   {{0x625b022a,0xf2900219,0x62eb0403,0x00000000}},	//   _stelav_, _bekake_, _entinao_, --, 
   {{0x72a70145,0x380f00d1,0xf7ab0158,0xb95e018c}},	//   _такога_, _উপসৰ্গই_, _kuchnią_, _kennisse, 
   {{0x00530204,0x9b9b0012,0x025a02c2,0xca610123}},	//   _mangosmo, _टिमटिमात_, _kollig_, _caféer_, 
   {{0xbdd200bf,0x9b03000b,0x12da0312,0x2c8201fe}},	//   _доступа_, _coastwee, _asteca_, _waidranu_, 
   {{0x013f046d,0xa27700d0,0x225a02a1,0xe0ef0055}},	//   _tshengel, _таемин_, _mollig_, _addivall, 
   {{0x8ef1010c,0x03ea013d,0x35730004,0x9f7200fb}},	//   _तुमको_, _uzata_, _gradyasy, _ngabanin, 
   {{0x3147003a,0xe49b015d,0x927e0048,0x7c7300d6}},	//   _камида_, _ogranicz, _adeni_, _muirear_, 
   {{0x36c901ea,0x71fe0078,0xb3f40220,0x20070205}},	//   _тасарруф, _кризу_, _frutta_, _замирда_, 
   {{0x8d1e0285,0x6c66004a,0x0bce01db,0x49db054d}},	//   _jenoside_, _балыгым_, _كەلەشەكت, _solfange, 
   {{0xc881054e,0x5de30061,0x627e021e,0xe8b001c5}},	//   _naminiku, _한나라당의_, _tvinga_, _xudduudd, 
   {{0xd27e0200,0x166500d7,0xa28d0211,0x730502a5}},	//   _esonye_, _украинда, _olekaan_, _panelů_, 
   {{0x8b600139,0x45b500ec,0xd7f9027e,0x6c0a019e}},	//   _वाहनं_, _пунктаў_, _знакова_, _аргентын, 
   {{0x9c240476,0xe37f00d6,0xce44042a,0x334901df}},	// [a80] _achaitir, _thiarna_, _angasifa, _basebaw_, 
   {{0x8bcd054f,0x939500b7,0x01340060,0x7bb400d9}},	//   _chivkeeb, _hersi_, _алаштың_, _лесбиянк, 
   {{0x23160307,0x62370119,0x31b7028a,0x5dce0255}},	//   _yenza_, _coimbra_, _الملوڪ_, _vaikselt_, 
   {{0x125a03b9,0x5bae01ab,0xd86c001c,0xc31602cd}},	//   _jallu_, _कवाँड़ी_, _fuentidu, _cenza_, 
   {{0x78f802ec,0x00000000,0x00000000,0x00000000}},	//   _gobaleed, --, --, --, 
   {{0xaf270087,0x4c7d023d,0xf28b00a2,0xec560043}},	//   _factiona, _massima_, _kubadili_, _akatale_, 
   {{0xd25a022d,0xa88e014e,0x1224002f,0xec2303ef}},	//   _fallu_, _холандск, _arikos_, _abasores, 
   {{0x32d801c5,0xe29201d9,0x81e303ff,0x2dac01c2}},	//   _galeen_, _gesait_, _parfémy_, _linguaxe_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xd2d80241,0x02b502d4,0x0cbd00ec,0xa39a0311}},	//   _aaleen_, _desch_, _наведаць_, _ምርጭኦም_, 
   {{0x9316048f,0x33f401ef,0xf6cf043d,0x1813027e}},	//   _penza_, _rastas_, _perpecah, _подвиге_, 
   {{0x210f031e,0x69d00074,0xc26c0233,0xf3cf0407}},	//   _značajan_, _серий_, _iumori_, _pravnu_, 
   {{0x1a860281,0xb26c01da,0x6e39028b,0x8a7e01da}},	//   _angissus, _humori_, _copaltep, _pavarura_, 
   {{0x0316014c,0xadc30285,0xec1e0258,0x72640229}},	//   _wenza_, _gisirika, _kuipers_, _pislik_, 
   {{0x72d90550,0x73f402d5,0x934702fb,0xb3860348}},	//   _saper_, _vastas_, _faleloa_, _ameru_, 
   {{0xe25a007f,0xc386000f,0x00000000,0x00000000}},	//   _gallu_, _fikrim_, --, --, 
   {{0x32900226,0xa3a3033e,0x3f4f0212,0x8c7300fe}},	// [a90] _linalo_, _acepar_, _adoptare_, _teisina_, 
   {{0x129200b9,0xf2c601f9,0x00000000,0x00000000}},	//   _dhuafa_, _iyalele_, --, --, 
   {{0xba87002f,0xd1c901b3,0x28bc00c7,0xda280145}},	//   _akunawan_, _поета_, _заводлар_, _piniginė_, 
   {{0x75f20209,0x4f7d019b,0xb75e01b7,0x1ae2001c}},	//   _sermitsi, _ажыццяўл, _जुह्वति_, _miltenbe, 
   {{0x828e01b4,0x76ed0125,0x7ecf03f7,0x00000000}},	//   _miskien_, _görünýär_, _bringurn, --, 
   {{0xe25a004f,0x92ad0247,0x02010256,0x03960475}},	//   _wallu_, _بلوار_, _nezinu_, _просим_, 
   {{0x63f402e7,0xd27e01fa,0xcd9c0092,0x231c017a}},	//   _brutsa_, _heene_, _雑誌に出ていない, _abeyozam, 
   {{0x73ea030b,0x65d40092,0x03940072,0x92ea01ba}},	//   _mpita_, _チエンジン_, _munsta_, _fatigan_, 
   {{0xf3940192,0xf3960176,0xe1ac0138,0xe25a007f}},	//   _mensen_, _passwd_, _rahatlık, _hallt_, 
   {{0x125a02f3,0x1c6e0160,0x69cc047d,0x94f30093}},	//   _kallt_, _navrata_, _chrescht, _тоскана_, 
   {{0x025a032e,0x4e6b0013,0x00000000,0x00000000}},	//   _jallt_, _دیوانیمد, --, --, 
   {{0xc95d0545,0x8170011a,0x72f0027f,0x904700af}},	//   _minneste, _הרייטינג_, _mubindi_, _бароко_, 
   {{0xdf2e0135,0xd29100ec,0x03cf02a5,0xf278002e}},	//   _бирле_, _vyrai_, _pravou_, _desnoj_, 
   {{0x912303c7,0x9c1c004a,0x32d40551,0xe7d000a2}},	//   _stanisła, _albannar, _féodal_, _mapunguf, 
   {{0xb3f103a2,0x29380037,0x1dd80297,0x55cc01af}},	//   _एंटीबॉडी_, _rasminya_, _balkanna, _ankarany, 
   {{0xc2cb02ee,0x33c8011a,0x804a0144,0x00000000}},	//   _kwadru_, _מתגעגע_, _siorcann, --, 
   {{0x2316005b,0xcc8200ee,0xcb300475,0x15bd007f}},	// [aa0] _kenzo_, _студи_, _уполномо, _technium_, 
   {{0xbc1800c9,0x29c30113,0x4c330224,0xe274047d}},	//   _vbbanner, _طالبه_, _aukaspyr, _entschel, 
   {{0xe997011f,0x4161030b,0x0b820408,0x085701a3}},	//   _бузуртан, _aligolol, _anananar, _هولڊر_, 
   {{0x7e600552,0x14d500d3,0x00000000,0x00000000}},	//   _hemphuhu_, _संचिता_, --, --, 
   {{0x4b670172,0x9b9d028b,0x8a630272,0xea3c0013}},	//   _mekenkan_, _иҧшаауп_, _ataganya_, _сурон_, 
   {{0x30c40534,0x13d501e9,0x13040012,0x12fe01c9}},	//   _kẹosao_, _baithuti_, _खोदियवला_, _kirikus_, 
   {{0x86cc003c,0x95fe01c5,0x00000000,0x00000000}},	//   _ساماندهي_, _allmuqdi, --, --, 
   {{0x6e5f0057,0xbae00347,0x5d0900c4,0x1194020f}},	//   _ስላልሆነ_, _terugbet, _دردناڪ_, _انګستان_, 
   {{0x26860147,0x4ee000ff,0xe18f0153,0x927e0553}},	//   _اچىىشبىز, _baziĝis_, _サイト名カナ_, _zdeno_, 
   {{0x8aae0159,0xfa4901dd,0x52ea00bd,0x4e4701dd}},	//   _смерцю_, _bakekaga_, _ratigan_, _batakoze_, 
   {{0xbbd301d5,0x03be0272,0xf3ea0554,0x82f4004a}},	//   _بمطابق_, _abavumi_, _upita_, _ermitaj_, 
   {{0xd3480065,0x00000000,0x00000000,0x00000000}},	//   _krefeld_, --, --, --, 
   {{0x3c000113,0xaf5d023d,0x502e009b,0x234c002b}},	//   _تختلف_, _relazion, _fundazio, _গৃহবধুর_, 
   {{0xa4ce008d,0x3eea003c,0xcd030061,0x00000000}},	//   _хакидаги_, _آستون_, _사도세자의_, --, 
   {{0xcee60087,0x0b0c0039,0xed9603f7,0x3306022c}},	//   _enghozin, _бууна_, _bollurna, _dibabuk_, 
   {{0x3b9e049a,0x1b3602b1,0xc27800b9,0x756404c7}},	//   _podnosio_, _asibitin_, _hyunmi_, _злостављ, 
   {{0xb5ae02c4,0x475201a4,0x5f4b00fd,0x00000000}},	// [ab0] _дозволен, _akontang, _siostama, --, 
   {{0x7f890148,0x39b00132,0xdb2201d7,0x125b004a}},	//   _公開所有人_, _مانگنے_, _sanaziun_, _bitle_, 
   {{0x46280218,0xb3fe0226,0x5f0d00bd,0x8d7a00a2}},	//   _abricati, _akaziwa_, _clachans_, _usambaza, 
   {{0xb7a102bf,0xa9950555,0xb3840156,0xaa03004d}},	//   _babukisi, _bakhjula_, _כנבוזי_, _patriciu, 
   {{0xb20c04cc,0xc5980331,0x78a7023d,0x1b0202c4}},	//   _hoihlaux_, _manninum_, _класиран, _којшто_, 
   {{0xdda7017a,0x89a40113,0x95c10037,0x73eb03d4}},	//   _раббонӣ_, _twojanut, _membebel_, _uleteo_, 
   {{0x12f40256,0xa2ea03d1,0x42f40261,0x3ab100dc}},	//   _stundas_, _princis_, _armitaj_, _sogasogā_, 
   {{0xd3f9041e,0x189100b0,0xa31601cd,0xf29101bb}},	//   _acque_, _ڈى۪کس_, _senzo_, _myrat_, 
   {{0x92e9043d,0xdd5a01cd,0x847601db,0x3b4202c3}},	//   _jadikan_, _додем_, _гаухар_, _odporučt, 
   {{0x28d10192,0x9e7102ac,0xc84400c4,0x56960352}},	//   _버전에서만_, _رخيصة_, _بريڪنگ_, _স্কুলত_, 
   {{0xbc810428,0xb261015d,0xa5490125,0x4de500e6}},	//   _storitev_, _मताधिकार_, _bashlady, _汽车电子制动系统, 
   {{0xdcf2004c,0xf24c0125,0x1d87030f,0x35ac0126}},	//   _agatager, _кувватың_, _hinerupe_, _трагедії_, 
   {{0xbb8a0064,0x8a390220,0x49230178,0x147a0299}},	//   _корот_, _весели_, _doṣaśca_, _سۈمەييە_, 
   {{0xddda0262,0x53ea012c,0xcb240137,0x19c00092}},	//   _tolkunla, _mpito_, _буучид_, _hedehuse, 
   {{0x6a4600b4,0x2b1601c9,0xf70001f9,0x3b770195}},	//   _necesara_, _vigastus, _ekubanjw, _muslamac, 
   {{0x82010124,0x43010416,0x249a00f5,0x4f5e004d}},	//   _mbaiki_, _strangi_, _богоскоп_, _評價與意見_, 
   {{0x039603f5,0xe17700f0,0xe27e01b4,0x7c0500e7}},	// [ac0] _passou_, _spravodl, _bronne_, _aferway_, 
   {{0x3561026f,0xaa8c03db,0x880e0147,0x00000000}},	//   _ءراببمىز_, _asinakub, _مۅلۅنكۅن, --, 
   {{0x4340018b,0xcae10288,0xb75f03a2,0x1f2a021a}},	//   _prieten_, _giddines, _एंज्वॉय_, _carraaqa, 
   {{0x14580235,0x1ae20223,0xc202014b,0x2ddd0094}},	//   _viditvā_, _naturare, _waqini_, _كەسىلمەگ, 
   {{0xfa280145,0x47e50037,0x16460255,0xf2cb0108}},	//   _piniginę_, _ለማውራት_, _maakleri, _dikompa_, 
   {{0x0dc304bd,0xd998034c,0x25ac0153,0x00000000}},	//   _iwakalua, _баруыгыз, _お試しあれ_, --, 
   {{0x5037040b,0x31ed00b7,0xf31603db,0x46fd01f4}},	//   _doiteron, _базарова_, _benze_, _بیرسی_, 
   {{0x4afd0473,0x2ac002bb,0x3060033f,0x660b0109}},	//   _münchen_, _विसंगतिय, _inisulin, _nečekaně_, 
   {{0xa68e03a0,0x53f8008e,0x7f5202a5,0x794c003b}},	//   _dikemedi, _dunuko_, _जाँगर_, _kulosise, 
   {{0xa73f018d,0x4316014c,0x2ffe053e,0x36f3025d}},	//   _ተሞክሮና_, _wenze_, _diskusjo, _kulturrå, 
   {{0x2ed40347,0x96f6052b,0x4f1401fb,0x27c70371}},	//   _bedienin, _एकलव्य_, _permaner_, _банкови_, 
   {{0x80fe0114,0xc2b203a6,0xa139012e,0xf26f00db}},	//   _אוגוסט_, _amaduka_, _linkgyűj, _langetam, 
   {{0x478e046d,0x6625028b,0xae7800c1,0xd2f1016a}},	//   _muitazwi, _алитерат, _खरडींतून_, _rezisti_, 
   {{0x1291013d,0xbaa70300,0xe3950034,0x0c9502c1}},	//   _infano_, _potrubí_, _berst_, _asezerer, 
   {{0x63160556,0x825a01a0,0xd395022d,0xa386007b}},	//   _yenze_, _badli_, _persu_, _boords_, 
   {{0x3b980047,0x27b0009a,0xa1e90178,0x527f0105}},	//   _visiteur, _amawakaw, _balikarm, _tkanin_, 
   {{0x621303e6,0xe62400d1,0xa25a0242,0xed9a0557}},	// [ad0] _mechel_, _স্মৃতিহী, _dadli_, _abanakwa, 
   {{0x73860558,0xc74f01b7,0x1cb201e5,0x6c7f033a}},	//   _imeri_, _क्रियाभि, _bibajẹ_, _twassal_, 
   {{0x25ce010f,0x90e200be,0x869400d8,0xc2a70144}},	//   _гармо_, _بەيىشى_, _albergai, _دائرية_, 
   {{0x854e02ba,0xaf3a01aa,0x6acb00bf,0xa437009a}},	//   _abaholay, _acquesja, _введены_, _ayokufak, 
   {{0x03ea0326,0x99fb00b5,0xe5fa0059,0x00000000}},	//   _asati_, _jahaikat, _premiazi, --, 
   {{0x03160559,0x9da900dc,0x8b6101be,0xb3860129}},	//   _senze_, _banimara, _थालनी_, _mmeri_, 
   {{0x625a00a0,0x105303ab,0x4a0b046b,0xc3be0499}},	//   _kalli_, _potravin, _hunaniae, _asavili_, 
   {{0xd38604bd,0xfc790008,0x00000000,0x00000000}},	//   _omeri_, _безгек_, --, --, 
   {{0x43cf031e,0xda0100ad,0x53f40046,0xb52c04d7}},	//   _pravcu_, _bujangga_, _pastes_, _breiðahv, 
   {{0x474f01b7,0x02010488,0x397d0153,0xacb603f8}},	//   _क्रियावि, _nebiju_, _北海道大学_, _lungorlu_, 
   {{0x8df801c9,0x00000000,0x00000000,0x00000000}},	//   _शर्मशार_, --, --, --, 
   {{0xd1400374,0x2ae6002b,0x986f055a,0x02300362}},	//   _герби_, _ভাসানী_, _abusivos_, _ememaka_, 
   {{0x3ba80365,0x11260162,0x72910089,0xbb1900bb}},	//   _न्यूनतम_, _بىلگەندى, _ayzat_, _سولہویں_, 
   {{0x807c0044,0x56e50008,0xde500227,0x22f4055b}},	//   _הרפתקאות_, _passarà_, _datangla, _områdere, 
   {{0xb48602b9,0x159002e0,0xd4b80061,0xc7ed0011}},	//   _عادتیں_, _deseketh, _구월롯데캐슬_, _awaaling, 
   {{0x5fbf055c,0x73ea0375,0x9c430111,0x00000000}},	//   _fungerer_, _ipite_, _barwick_, --, 
   {{0x725b0034,0x6e3d055d,0xcdc1019f,0x9c180192}},	// [ae0] _litla_, _kewajipa, _rasilima, _dynamisc, 
   {{0x1065055e,0xb2fc04de,0x2291012c,0xd8590352}},	//   _danskern, _inaga_, _mifano_, _straumar_, 
   {{0x53ea03b4,0x4eb903d9,0xb0db00cd,0x830501e0}},	//   _usati_, _votoatin, _beinvugl, _کوتان_, 
   {{0xa0aa00bf,0xdd8001bc,0xd30202c2,0xc389001c}},	//   _животным, _formulea, _verbode_, _rbaycan_, 
   {{0x6b5400e6,0x3c76003d,0xf59000de,0x02e703ac}},	//   _土地使用权出让_, _barralh_, _beseketh, _bunuhlah_, 
   {{0x4b7e00b0,0x8e7a03c1,0x950e00e6,0x3beb01a6}},	//   _iskuulka_, _шампиони, _道路运输证_, _werowero_, 
   {{0xb88900c5,0x1d7e041a,0xe49902da,0xb1100198}},	//   _您当前位置_, _моментам, _говориме_, _znižana_, 
   {{0x27f301db,0x0e9b01b4,0x12fc008d,0x67c5008f}},	//   _тексеріл, _rondings_, _onaga_, _जलुहार_, 
   {{0xf3ea029c,0xd8620013,0xbaf10147,0x0f200476}},	//   _apite_, _llanilad, _تۉنگۅ_, _handifun, 
   {{0x52ba00ec,0xb8d402e7,0x5ae2005e,0x3e52019b}},	//   _старым_, _bulutang, _ئەجداد_, _autorinė, 
   {{0xc2da02cf,0x430f01fd,0xc9ec0102,0x1234005e}},	//   _esteja_, _probado_, _kuingiza_, _سىمۋولى_, 
   {{0x93f9045e,0x93940095,0x1653005e,0xe6cc0133}},	//   _acqua_, _sungsang_, _ئىملاسىن, _cokamani, 
   {{0x725a03a0,0xf5100089,0x81cc00bb,0xc8d30244}},	//   _emelle_, _бекмә_, _testünk_, _товарен_, 
   {{0xf3780038,0x9f9a0055,0x525b036d,0x12c9022c}},	//   _дәрес_, _poète_, _bitli_, _sapopoe_, 
   {{0x6496015e,0x62ea0342,0x12da00ac,0x19ea04a2}},	//   _اندەلىس_, _patizan_, _isteka_, _claridad, 
   {{0x6c1800bd,0x62d1006a,0xdf270156,0xa7da0139}},	//   _coppers_, _antokom_, _מאַקעדאָ, _पत्र्चमु, 
   {{0x20210147,0x52b40199,0xf4ca00d9,0xd5fb0212}},	// [af0] _ازىتقىلا, _meocon_, _магнитол, _communem_, 
   {{0x8f97032e,0x1394001f,0xc039005d,0x275a018d}},	//   _chikayaņ, _sensan_, _castanon, _ኣፍቀርቲ_, 
   {{0x431602e8,0x38e003b0,0xe39401f7,0x719501db}},	//   _kenza_, _fylgjand, _pensan_, _актобеде, 
   {{0x1b5b01d9,0xd2da0039,0x93eb04a8,0xd3250403}},	//   _galerien_, _esteka_, _sletio_, _drabiby_, 
   {{0x320002e1,0x1c510069,0x9340027f,0xdd9901af}},	//   _innill_, _imitima_, _bagenwa_, _ahallyla, 
   {{0x32240097,0x531604cf,0x254a0475,0xd297017c}},	//   _iroko_, _lenza_, _провозгл, _godkort_, 
   {{0xf2fc028c,0xc97a0166,0x42c50220,0x647d00a6}},	//   _liiga_, _verhalte, _inseriti_, _emifanek, 
   {{0x2f2d0349,0x426400e2,0x125a005a,0x82fc0294}},	//   _actualfa, _mislik_, _nadlu_, _hapinku_, 
   {{0xee18019c,0x0e390273,0x6987032d,0x00000000}},	//   _apópo_, _soportes_, _hookobat, --, 
   {{0xf2d402cb,0xb25a0062,0x9292055f,0x00000000}},	//   _redovna_, _hadlu_, _mesafe_, --, 
   {{0xb3160560,0x52fc002e,0xc20e0046,0x227e003f}},	//   _benza_, _snaga_, _жагат_, _homna_, 
   {{0xd1e70561,0x343e0388,0x0ce60061,0xbbe50061}},	//   _kliknutí_, _даяна_, _엘리자베스_, _telespor, 
   {{0xa03d0026,0x0b170375,0xe9290083,0x234c002b}},	//   _degelijk_, _angalets, _hansjörg_, _গৃহবধূর_, 
   {{0xb192006c,0x62ea0373,0x57410045,0x22250079}},	//   _ababehil, _latinan_, _источне_, _trakas_, 
   {{0x1c73004f,0xd3870409,0x43860359,0xf9140477}},	//   _asistaa_, _angreb_, _akkrum_, _tercantu, 
   {{0x02c401a2,0x08540299,0x52500361,0x50050188}},	//   _pēdas_, _ئوقوغۇچى_, _дехар_, _дуюним_, 
   {{0x32d40159,0xc37a01ce,0xc30100c1,0x10a30156}},	// [b00] _vardas_, _éwahan_, _kurangi_, _שאַצט_, 
   {{0x2dad01e0,0x4340026b,0x286a033e,0x00000000}},	//   _مانچه_, _quieren_, _iconocid, --, 
   {{0xb62a0562,0xc92a02b6,0xd9eb00e2,0x0eb101a3}},	//   _babibari, _күнкөріс_, _boergond, _رامچند_, 
   {{0x3db804ca,0x968102d8,0xf991011f,0xb34b03e6}},	//   _solament_, _गेलास_, _истепен_, _bedengt_, 
   {{0xab650202,0x82ea0183,0x06290062,0xe3790373}},	//   _awadanun_, _vadinao_, _hajimari, _agrabla_, 
   {{0x33f40150,0x6d5b01ef,0x59db0153,0x6cbc02e4}},	//   _jastis_, _авансу_, _キャメロン_, _innaqqsu_, 
   {{0x777f047f,0xb9e001d9,0x329e049a,0xe9190109}},	//   _क्रान्ति, _ochiniwa_, _krajnja_, _व्यहोरा_, 
   {{0xcf3401d4,0x17b20193,0x4a080176,0xe2d4018f}},	//   _sessanta, _रक्तवाहि, _dorakuee, _qardas_, 
   {{0xb37f02d9,0x1876017f,0x3eeb000e,0xd3ea030b}},	//   _manatua_, _avannamu, _flexione_, _asatu_, 
   {{0x626e02a5,0x82e700a8,0x722500e1,0x6a220244}},	//   _metody_, _chantun_, _baakar_, _отвор_, 
   {{0xa29201a4,0x21c7012c,0xc195005e,0x8637027b}},	//   _mesage_, _داستانن_, _يېراق_, _महाहवे_, 
   {{0x05e600df,0x00000000,0x00000000,0x00000000}},	//   _condamné, --, --, --, 
   {{0xb25b03f0,0x069d0255,0xfcb102e1,0xad62004d}},	//   _litlu_, _intensii, _تنتشر_, _七二大隊救援乙隻, 
   {{0x2d0000ef,0xc27f01a4,0x3d0f0181,0xe47f03bd}},	//   _سپيني_, _avanda_, _ankommet_, _mangadto_, 
   {{0x48450083,0x349e03a8,0x721802ee,0x00000000}},	//   _abilitad, _মুক্তিত_, _jeditjaw_, --, 
   {{0x730c00e0,0x368a02f0,0x79cc0158,0x57d40347}},	//   _ornaris_, _ekudzili, _kolorowa_, _wetsontw, 
   {{0x796702ec,0x81f40060,0x66840060,0x5a4a0348}},	// [b10] _نہناوِہے_, _тырысты_, _түрме_, _akwesiga_, 
   {{0xa88301f0,0xac6900b2,0x3504014b,0xd29d00f5}},	//   _baikoped, _bituufi_, _maddurul_, _açary_, 
   {{0x927f029b,0x8c7d0292,0x13160102,0xa56d0037}},	//   _aduna_, _amisano_, _penzi_, _ተፈጻሚነት_, 
   {{0xd76e02e2,0x019f01e6,0x91e502f9,0xb3fa00ab}},	//   _aigharag, _šablony_, _dedomajm, _korupe_, 
   {{0xca030088,0x2c61005e,0xf2180276,0x827e025b}},	//   _igualada_, _ھېسداشلى, _باشقلارن, _flenn_, 
   {{0xc27f00e1,0xa2740119,0x294600e2,0x00000000}},	//   _dduna_, _nagresul, _taalstat, --, 
   {{0x531602e8,0x269c04ca,0x00000000,0x00000000}},	//   _tenzi_, _congensi, --, --, 
   {{0x47be01f4,0x327e013f,0xcb7f01b5,0x8be000db}},	//   _مصافه_, _alenn_, _ivangabr, _arreteer, 
   {{0xca70010f,0x46d20334,0xb27e03e6,0x55c70219}},	//   _тиллоӣ_, _aphatiki, _aleng_, _ibhaloth, 
   {{0x60480094,0x627e0083,0xb07f005e,0x2e4f0456}},	//   _بالدىزىم, _omens_, _ئەلبەتتە_, _kegatala, 
   {{0x719502b5,0xb292028d,0x72c602f0,0x0b760291}},	//   _yencangh_, _extans_, _ayalele_, _باهتمام_, 
   {{0xf2fc022d,0xe4c30396,0x3aec03d1,0xffcd00f4}},	//   _piaga_, _approċċ_, _eksterje, _dupitier_, 
   {{0xf27e020b,0x5cf0026c,0x6f5e023d,0x2ff70156}},	//   _eleng_, _三天就成交_, _redazion, _צעטיל_, 
   {{0x927e013a,0xb1660040,0xffc30093,0xc28d00a6}},	//   _ament_, _טיקוטין_, _антонови, _asikuko_, 
   {{0x32cb0172,0x46a20013,0x44a7010f,0x53820163}},	//   _adadam_, _чеченист, _техникаи_, _نابلد_, 
   {{0x5b6b01b8,0xc1c301f2,0xab1b022f,0x20f20417}},	//   _renoveer, _гобияв_, _успенска, _verbreek_, 
   {{0x1977001b,0xa7e201cd,0x2e2e036b,0x00000000}},	// [b20] _ministee, _мукаддас_, _полигоно, --, 
   {{0x49170078,0xeb190191,0x8f6304f8,0x3d110061}},	//   _далеком_, _varannan_, _galaxies_, _프로이트의_, 
   {{0xf49e0173,0x7d980003,0x26190563,0x55630075}},	//   _মুক্তির_, _licentie_, _narednim_, _kollfirð, 
   {{0x020e01db,0xc2d50130,0x4f4e00d9,0x15c00065}},	//   _барар_, _hellont_, _naisille_, _gruppenk, 
   {{0x09b6026f,0x27cd0023,0xe364008a,0x33ea00a1}},	//   _ادۋىندى_, _родствен, _atagana_, _apiti_, 
   {{0x325b018b,0xb20202d8,0x9e28023e,0xaa37014e}},	//   _titlu_, _terigu_, _biomedis_, _никакву_, 
   {{0x72fc01c5,0x0c7701b4,0x526c0403,0x246100d1}},	//   _anagu_, _kwessie_, _bohoka_, _বিভিন্নৰ, 
   {{0xe249019a,0x3b5103ce,0x3a0704c8,0x7eee02b0}},	//   _clamps_, _سێزده_, _dekċer_, _sicheres_, 
   {{0x229d00a6,0x5e3a0142,0x53ee02d9,0x00000000}},	//   _دزرداري_, _apsarasa, _ovataimi_, --, 
   {{0x257d0364,0x26b00193,0xcae2002b,0xa2ef01c0}},	//   _identité, _आहेत्_, _পাহাড়ী_, _bajinta_, 
   {{0xdf690145,0xe3860195,0x685b00bf,0xfc1401bf}},	//   _komandos_, _athris_, _обострен, _terrengs, 
   {{0x5a8c0125,0x00000000,0x00000000,0x00000000}},	//   _bezirgen_, --, --, --, 
   {{0x73ea03b6,0xca790276,0xd290005a,0x00000000}},	//   _apata_, _نادانلىق, _najang_, --, 
   {{0x9da50021,0x6e9602ac,0xb27e0372,0xd6280210}},	//   _activewa, _نرجوا_, _sment_, _angondii, 
   {{0x927e047d,0xf84d019b,0xef20025b,0xe86c0222}},	//   _blend_, _partijos_, _landsfun, _poissons_, 
   {{0x215c0088,0x146401c2,0x17b9031a,0x00000000}},	//   _сураш_, _antedito_, _saoranai, --, 
   {{0x06d50047,0xcdd00263,0xe25b029b,0xc852008e}},	// [b30] _与本站立场无关_, _toekomst_, _amalul_, _beelsebu, 
   {{0x628d000c,0xffd603db,0x22ff0046,0xd7b80135}},	//   _arahaku_, _ekuzalen, _كەلەجاتا, _kiterelg, 
   {{0x469801aa,0xc27e00cd,0x0f46030b,0x73ea02cb}},	//   _unsettli, _umens_, _asasudde_, _upiti_, 
   {{0xb3f902d4,0xc317000e,0xdc530298,0x6f3400e7}},	//   _spezial_, _grazer_, _apotoro_, _abasesta, 
   {{0xc58a0564,0x833201b5,0x753a02f7,0x6d710132}},	//   _dientifü, _byoxe_, _betheleh, _útmutató_, 
   {{0xdeaf0565,0x3b2a024f,0x7a31028a,0x0c5d02c0}},	//   _takozvan, _icabocab, _مشترڪه_, _пирамиди_, 
   {{0x934f041e,0xa3c304bc,0xc6970204,0xbb8b0251}},	//   _lamenti_, _låven_, _integroi, _siminaar, 
   {{0x428d0552,0x9dad01fb,0x263c0195,0x8292012a}},	//   _boekfan_, _linguage_, _droighni, _sprawi_, 
   {{0x328a000d,0x828f0085,0xbe4c0344,0x027f0084}},	//   _maratoni_, _nasareci_, _angalapp, _adung_, 
   {{0xd3f900e9,0x644c01bb,0x034c0079,0x95da028b}},	//   _dibute_, _гурлушык_, _rudenim_, _шәабдуцә, 
   {{0xb25a041e,0xf9ce0166,0xfb78019b,0xaf630047}},	//   _valls_, _produzie, _konkreči, _maladies_, 
   {{0x1373031f,0x62d90203,0xfca201c8,0xaf960366}},	//   _omfatte_, _exposit_, _konvenčn, _ханства_, 
   {{0x06d00002,0x9c5d00e6,0x22e502c5,0x07d80045}},	//   _igračima_, _爱心涌三秦_, _anonaka_, _unapredi, 
   {{0xa7a80037,0x5394005b,0x711f0291,0x228301cd}},	//   _የማዕረግ_, _sensen_, _كثيييييي, _сурху_, 
   {{0x927e0566,0x2e39009b,0x23940008,0x619500ba}},	//   _alene_, _topaketa, _pensen_, _ڕێکبخه_, 
   {{0x6c340014,0xf20000b2,0xd947005e,0xf2900193}},	//   _ዝተኸስተ_, _adiin_, _ﺋﯩﺪﯗﻕ_, _pajang_, 
   {{0x9bdf02ea,0xf3cf0488,0x12d901e8,0xbf3801f0}},	// [b40] _спектакъ, _dievam_, _greeno_, _dipuotla, 
   {{0xd27c0567,0x8d6d005e,0x425a017c,0xa57d014a}},	//   _чаралары_, _арсланға_, _emelie_, _identitá, 
   {{0x6c480287,0x526701ea,0x65c700be,0x4fc600ab}},	//   _काउन्टर_, _هیدوچی_, _арийне_, _kokotiko, 
   {{0x9f2402a5,0x92330061,0x2e2500ec,0xf27002f8}},	//   _zdálo_, _오세아니아_, _derliaus_, _tufitufi_, 
   {{0xa77d02ac,0xd4b901f2,0x13ea0235,0xf197000c}},	//   _الرزق_, _телегр_, _asaty_, _магомеҭ_, 
   {{0xb22403d9,0x75950122,0x00000000,0x00000000}},	//   _oroka_, _diperjay, --, --, 
   {{0x24460047,0x79dc026f,0x631702f1,0xd27f0286}},	//   _信息产业部_, _ءﺗﺎﺑﻴﻌﻲ_, _prazer_, _nwanwa_, 
   {{0xe8660074,0x23fb03ce,0x13430220,0xd29200a3}},	//   _kotisivu, _پرنسیپ_, _disegno_, _lesast_, 
   {{0x6c14001a,0x4d4c032c,0xe58f0037,0x564900ac}},	//   _verseny_, _angalaaq, _ያጋጠመውን_, _rashladi, 
   {{0xe224002a,0xe7ed038b,0xc3ce0017,0x12910059}},	//   _broka_, _didatang, _stovek_, _divano_, 
   {{0x1799005e,0xa3140429,0x0b370397,0x00000000}},	//   _زەرەپشان_, _berzanji_, _махалхо_, --, 
   {{0xd7220037,0x52eb036d,0xc6b6012c,0x6378016a}},	//   _ተፈጥሮአዊ_, _aranais_, _عدالتون_, _vivanta_, 
   {{0x60840044,0x32910135,0x48b30148,0x63240125}},	//   _באזזזזז_, _ayrat_, _反折射超硬藍寶石, _кызыны_, 
   {{0x6eb50148,0x22e00568,0x429200af,0xe09f00ba}},	//   _無苦集滅道_, _turneen_, _besatt_, _فیڕۆدانی_, 
   {{0x1ae800bd,0x9f6c018d,0x426c01ed,0x61690569}},	//   _cautione, _ዓቃባውያን_, _nohona_, _kompjuto, 
   {{0x927e0261,0x7dc40040,0xed280024,0x219402fd}},	//   _plene_, _הנקסוס_, _বিচাৰিব_, _forargyl, 
   {{0xa38603a4,0x99d602d5,0x30530109,0x6a0c004d}},	// [b50] _teirra_, _ettepane, _startovn, _台北市蘭雅國中_, 
   {{0x81020028,0xe9ed00ca,0xb59c00ff,0x96f800da}},	//   _زمینہِ_, _militara_, _פלאנצן_, _ынтылни_, 
   {{0xdc7f019d,0x7035056a,0xc12f0095,0x4699020f}},	//   _abusawo_, _bontshan, _مارکتینگ_, _bangangx, 
   {{0xdc01054d,0xf51b0146,0x00000000,0x00000000}},	//   _næsten_, _mengawal_, --, --, 
   {{0xdb0600d6,0xd2d40041,0xe3010205,0x9e910059}},	//   _clasaice, _añeha_, _berardi_, _mestiere_, 
   {{0x737c03a6,0xe3030290,0x0d2800d1,0xbc5b0362}},	//   _kumushim, _camarat_, _বিচাৰিম_, _molunge_, 
   {{0x9b550117,0xdd8d03b7,0x9cb401a3,0xf30a0076}},	//   _fandesen_, _andoncra, _پنجٽيهه_, _возврати_, 
   {{0x8aee0190,0x67410040,0x3c550286,0x17ed000c}},	//   _ansteche, _אדידס_, _nantese_, _сангәлиа_, 
   {{0x7bd70013,0x85ab0311,0x32e70313,0xb2ab0311}},	//   _نگاریم_, _ንምጽናት_, _lunuqlah_, _ንምጽኣት_, 
   {{0xd0390125,0x59ed003e,0x5c4f0147,0x92fc03b3}},	//   _yeterlik_, _dilitara_, _جەڭشى_, _viage_, 
   {{0x671603ab,0x9e3b0176,0x9db50065,0x00000000}},	//   _mramorov, _kvinders_, _abendbla, --, 
   {{0xb3f801d1,0xc84e00ec,0x8f1c0376,0x00000000}},	//   _unjust_, _бізантый, _handtikn, --, 
   {{0x90b8005e,0xed030029,0xb4ee0125,0x4b3a002b}},	//   _ئەخەت_, _نگمان_, _дилинден_, _উজ্জীবিত_, 
   {{0x5e1f036b,0xc65a02b6,0x82f503d4,0xbd13021e}},	//   _здраво_, _нашақорл, _kreiraj_, _konstver, 
   {{0xb25a0005,0xf2fd056b,0xfd7e0349,0x625b032d}},	//   _pally_, _elegan_, _angleswa, _ditlh_, 
   {{0x2f920360,0xc4320169,0x49f702cb,0xc27e04ad}},	//   _receptů_, _সাদিক_, _dijabete, _boene_, 
   {{0x5fac00ec,0x4b3b00ba,0x00000000,0x00000000}},	// [b60] _абскардз, _کۆشنێر_, --, --, 
   {{0x126c0174,0x8b4202c3,0xf19d0040,0xa2fc02e2}},	//   _mohola_, _odporuči, _אביהו_, _anagh_, 
   {{0x56f60162,0x127e0450,0x4aa70238,0x3c540040}},	//   _قازاقچە_, _woene_, _занадто_, _texting_, 
   {{0x73ea025f,0x320e00ee,0x02a00135,0x05e80006}},	//   _mpate_, _хавар_, _zavodı_, _munculny, 
   {{0xe75b018d,0xa058001d,0x09ec02ac,0x52240004}},	//   _ኣልበርት_, _elfstran, _لتبليغ_, _konkli_, 
   {{0xd928010f,0x32ff013f,0x43d701e6,0xab5404df}},	//   _ректори_, _skritur_, _ploché_, _adamalar, 
   {{0x729100ec,0x802900c5,0x22dc0321,0x6da80066}},	//   _vyras_, _返回河北主站_, _podobni_, _kolonbia, 
   {{0x68990092,0x614b009a,0xaa75017a,0x3c450096}},	//   _インフォカ_, _angekahl, _аллбата_, _barwara_, 
   {{0x1c5d0223,0x68110276,0xf25b03f0,0x05f300d8}},	//   _hasteko_, _иммунитл, _litli_, _permetri, 
   {{0x4b5c056c,0x73870234,0x63f9024e,0x97c90024}},	//   _delimičn, _imura_, _pobune_, _প্লেটফৰ্, 
   {{0xdecb0544,0x1135004d,0x00000000,0x00000000}},	//   _hikinaan, _我是艾艾艾_, --, --, 
   {{0x42d403d1,0x6ad70177,0x22920400,0xa0e201c4}},	//   _gardas_, _рыцхараж, _aprasi_, _transval, 
   {{0xfed604eb,0x00000000,0x00000000,0x00000000}},	//   _विंटेज_, --, --, --, 
   {{0x497b032e,0x83eb025c,0x36340061,0x24e80156}},	//   _qamiript, _treten_, _하기스골드_, _בעהמען_, 
   {{0xd27e0258,0xc26c04bd,0x5bae00be,0x00000000}},	//   _soene_, _hohola_, _دەلەبەرب, --, 
   {{0x530002d5,0xf26c0544,0xb0dd0071,0x298000cf}},	//   _finaali_, _kohola_, _اینرو_, _firiille, 
   {{0xa20200d2,0x7f5a003d,0x00000000,0x00000000}},	// [b70] _kuring_, _comprene_, --, --, 
   {{0x0291003f,0x62eb00b2,0xe206034c,0x0ef10265}},	//   _ayraq_, _amannus_, _беатриче_, _verklein, 
   {{0x320203b2,0x8d260136,0x62d801b4,0xde7300bb}},	//   _during_, _napomene_, _kameel_, _رداؤں_, 
   {{0x83eb0240,0x327f02f7,0x12770344,0x8f700138}},	//   _imatau_, _gwanta_, _avanaani_, _alçak_, 
   {{0xfdd5056d,0x9853024b,0x542400f6,0x2455031c}},	//   _abakhuba, _estudios_, _bürosuna_, _provocan_, 
   {{0xb2f30386,0xccf804b1,0xd54e0334,0x00000000}},	//   _dilihat_, _ukategor, _khekhekh, --, 
   {{0x52b402fd,0x727f02b1,0xd2ea0061,0x6d89017f}},	//   _stocha_, _kwanta_, _충청투데이_, _husfeldt_, 
   {{0x0f3e00ff,0x84d90178,0xc2f50194,0x00000000}},	//   _בוזשעט_, _arājakam_, _pruntar_, --, 
   {{0xdc6702c2,0xc0450134,0x03ea056e,0xb3ea00a2}},	//   _hanteer_, _finunkon, _emitiu_, _apate_, 
   {{0x93940418,0x92650045,0xbd270139,0x3a090026}},	//   _sensin_, _игуман_, _darbhaṃ_, _geparkee, 
   {{0x075b0025,0x0fc60345,0x2a8301c0,0xc2b50362}},	//   _मार्गेण_, _positivo, _aziyyata_, _precé_, 
   {{0x69ec041e,0x762f0103,0x47b0018e,0x369c03eb}},	//   _ritirata_, _aipomerw, _emasikwi, _vergifti, 
   {{0xa3ce051b,0x827f002e,0x03eb0020,0xe7a1056f}},	//   _provoz_, _šanse_, _amatau_, _svedectv, 
   {{0xb224012b,0xa00502ba,0x153d04df,0x9b3f0274}},	//   _kroku_, _дурнамо_, _таймдакы_, _leiguíbú, 
   {{0x227e0372,0x72d70029,0xb3870357,0xce95015e}},	//   _eleni_, _ۆکاری_, _emuri_, _pendents_, 
   {{0x0b19038f,0xf973033c,0x2e9e02c7,0x9b7a0145}},	//   _vogalenn_, _frenhine, _verteilt_, _sovietų_, 
   {{0xd2fc0266,0x5c700570,0xca3d020f,0xe866023e}},	// [b80] _niaga_, _मार्क्_, _کاشکې_, _نکسوس_, 
   {{0x82880369,0xaf0f00dc,0x569003f2,0xb99c0156}},	//   _ainapuni_, _leatuava, _marengei, _בלוטיק_, 
   {{0xac6601bd,0x1d2c0352,0xda7a00f1,0x1d760371}},	//   _санының_, _জ্ঞানগত_, _konzwent, _stampare_, 
   {{0x6e53005c,0x09c20315,0x023100e5,0xcfc50311}},	//   _amabombe_, _basemise, _единицит, _ብዘይቀልዓለም_, 
   {{0xbe6a02b7,0x97190092,0xd15c00fb,0x427f0163}},	//   _katikâti_, _スキンケア_, _amagalel, _adunk_, 
   {{0xc3cf0377,0x899f0335,0x44f10166,0x1dfd0268}},	//   _servicii_, _apāṃsi_, _werkstät, _arietyva, 
   {{0xd249015b,0xdc2e000c,0xf3ea00c4,0x394200a4}},	//   _amamas_, _ainupä_, _upate_, _esplugue, 
   {{0x92a7032e,0xb9ca00a8,0x90b700c1,0x8a7f0331}},	//   _sullsuńa, _bagliafa_, _ह्युएन_, _ivingars, 
   {{0xd3ea00b4,0x1232034e,0x0d0d0125,0x77cc01b4}},	//   _spate_, _adambro_, _даналыгы_, _dissipli, 
   {{0x08c002c3,0x17c10040,0xcbfa016a,0x829201ec}},	//   _predsedu, _הֶחָפֵץ_, _analogio_, _desane_, 
   {{0x125001cd,0xfc080257,0xf64000b3,0x82b4033e}},	//   _бешак_, _skagafir, _berişlik, _katakuáp, 
   {{0x127e0571,0x602a00a3,0x726f0399,0x2b8901a3}},	//   _koena_, _vindafjo, _hangatam, _خوشبوئن_, 
   {{0x21d10381,0xcf630455,0x3a840148,0x0d3e0064}},	//   _upperway_, _demandes_, _比利討論區_, _кризиске_, 
   {{0x327e01e1,0x0dfc0462,0x0c8301b2,0x6e1800b3}},	//   _moena_, _exceptwa, _abetting_, _гөвек_, 
   {{0x009102ac,0x37e30262,0xbaa7030d,0xacae00e6}},	//   _الزغبي_, _almaklyg, _valideyn_, _仅搜索标题_, 
   {{0xa7310410,0x61010572,0x54960013,0x30cc00de}},	//   _laolegeg, _तलाशे_, _алмашину, _akrokrel, 
   {{0x3eac00e0,0xf27f046d,0x7ee70368,0x15d90573}},	// [b90] _sintrale_, _nduni_, _замало_, _dalbanay, 
   {{0x454301ef,0xfc1204a4,0x627f0148,0x09cb0109}},	//   _pasisaky, _chargaib, _dignus_, _अझैपनि_, 
   {{0x927f0551,0x82da0194,0x139600ff,0xd27e0155}},	//   _jeung_, _astonar_, _מיאוסע_, _somna_, 
   {{0xf3ea026c,0xfc510057,0x827e004b,0x8ea90037}},	//   _mentem_, _jentera_, _boena_, _ከባልንጀሮቻች, 
   {{0xb2900127,0x1168044a,0x49d300ac,0x69c002e0}},	//   _addalc_, _congobil, _udaljena_, _dumelese, 
   {{0x537802e1,0xb82a01a3,0xb77c0040,0x16b90251}},	//   _theanga_, _تبرڪات_, _ההסדרים_, _milateri, 
   {{0xd9520026,0xa340014d,0x7e0c0046,0x187500f6}},	//   _veelgest, _frieden_, _رجانا_, _radıyall, 
   {{0x827f0265,0x3d510088,0x1c770026,0xba8601b0}},	//   _ieung_, _امىنىدا_, _kwestie_, _didiskus, 
   {{0x52910107,0xe52b0157,0x5e3400a0,0x6f2002c3}},	//   _jabang_, _marynark, _askarawa, _nezvyčaj, 
   {{0xa2130233,0x6599025b,0xb603006c,0xb395015f}},	//   _amcham_, _savninum_, _косимов_, _asesir_, 
   {{0xdc0800a5,0x89950315,0x42d901c8,0xce1b00f2}},	//   _asomaliu_, _benkinga_, _bojlery_, _normunds_, 
   {{0xea150103,0xfafc0287,0x93630161,0x00000000}},	//   _kurarama_, _obvinění_, _карточку_, --, 
   {{0x35ad0244,0x47a70071,0xf27e024b,0x290a0121}},	//   _работата_, _غفاری_, _lleno_, _cambiand, 
   {{0xa3340218,0x69e20574,0x00000000,0x00000000}},	//   _osscray_, _napolija_, --, --, 
   {{0x329102f6,0xb5d9014f,0x43b800ff,0x0846006c}},	//   _habang_, _анализе_, _אזערבייד, _abalitad, 
   {{0xd2910022,0x033d0029,0xbb1903fb,0xf290046f}},	//   _babang_, _ڕیوان_, _detaljan_, _jackett_, 
   {{0x227e0004,0x0a2f01c8,0xc34f00b4,0xaf7b01c0}},	// [ba0] _plenn_, _fenomén_, _camerei_, _bercelon, 
   {{0x93a700e4,0xd40802e7,0xea0b023c,0x4a970418}},	//   _त्रिविमी, _bibuguin_, _bamagama_, _metrobüs_, 
   {{0xb5c70125,0xff6904d1,0x63400258,0x4c7e02fc}},	//   _utgaşdyr, _murallas_, _brieden_, _amasano_, 
   {{0xb2ab0003,0x3acf0235,0xf57804e5,0x627e0028}},	//   _vandaag_, _aghaṭana_, _abawanik, _yoonis_, 
   {{0xeb20051f,0xafa90061,0x3f3b000f,0x00000000}},	//   _تائیستا_, _하지정맥류의_, _belgelen, --, 
   {{0xd94e0170,0x6b1f04dc,0x967a0212,0x7e270575}},	//   _abalalit, _بڵندی_, _honestum_, _هومایوون_, 
   {{0x50bc02ec,0xd53202d3,0xc29102a2,0xbbef0244}},	//   _گاسہٕ_, _телефонс, _aabang_, _colorato_, 
   {{0x6a2900ff,0xc3f903f1,0xc9230153,0x627f004f}},	//   _ספרעדשיט_, _pegudj_, _チャットレディ_, _jeund_, 
   {{0xd3040227,0xfbed0099,0x6d020050,0xc2d804ca}},	//   _menolong_, _aitovawo_, _ngaliwat_, _calern_, 
   {{0x9386008d,0xb889006c,0x7ae10227,0xee3200e6}},	//   _iborat_, _abakhand, _keilmuan_, _最近播放器增加了, 
   {{0x5d1900f4,0x0efe0444,0xcc7e0499,0xc5ab0220}},	//   _kinniget_, _среднего_, _amasino_, _гърдите_, 
   {{0xb2240360,0x39ed01fe,0xb9f301c8,0x2d630162}},	//   _řekla_, _didivara_, _exprezid, _بىلوگىڭى, 
   {{0xefd701ac,0x87ab02ca,0x12240022,0x29da0137}},	//   _chainteo, _وردشان_, _esoka_, _объектуу, 
   {{0x32980019,0x6ec20135,0x0c93015e,0x53940064}},	//   _каббалис, _byudjetı, _قازات_, _salses_, 
   {{0x33870129,0x875c00c5,0xdd9702cf,0xe4da0094}},	//   _amuru_, _政府信息公开_, _месеците_, _мойны_, 
   {{0xcb92041f,0x02870576,0x1c75001d,0xd0e60012}},	//   _okunjalo_, _دفعات_, _sequent_, _आदमीके_, 
   {{0x727f0222,0xdb1c01d9,0xb2ff022b,0xdd940166}},	// [bb0] _jeune_, _dobannen_, _eirikur_, _bewältig, 
   {{0xd97e003a,0xa2020577,0xa6bc00de,0x11230143}},	//   _чораларн, _musiet_, _kukushiy, _клинична_, 
   {{0xc8b80044,0xaf3c00da,0xc646009a,0x1746009a}},	//   _ותתפרסם_, _колорату, _abaneemf, _abaneemv, 
   {{0x88380220,0xec7302e0,0xc3c1020a,0x3589039e}},	//   _проектир, _agisana_, _амандығы, _austblok, 
   {{0xf3ea0358,0x9aeb0145,0x88a700b3,0xc6f902ac}},	//   _apati_, _столькі_, _урушмаяр, _وبعضهم_, 
   {{0xd2f70193,0x856c0483,0xd18d008d,0x60f700d9}},	//   _अरेरे_, _antigüid, _kuzatish_, _таблице_, 
   {{0x89f60131,0x13640287,0xb355015e,0xdeae0014}},	//   _xesús_, _उचाईमा_, _superat_, _rubrikat_, 
   {{0x644b018d,0xafa50217,0xebac017a,0xe3870140}},	//   _መኮነናት_, _expeller_, _abayijab, _adarna_, 
   {{0xc01a0148,0x75ca018d,0xe2b800cb,0xcfe0025e}},	//   _子類股相對成長狀, _ምምንዛዕ_, _бармехӯр, _bíltúr_, 
   {{0xdb76005e,0xddfb015d,0x8fe50488,0x7163011a}},	//   _دۇككان_, _अनेकता_, _partnerī, _salinity_, 
   {{0xeb9204cf,0xdf2f01a6,0x441100b5,0xd9ed003a}},	//   _akunjalo_, _heretaun, _асекциа_, _fransiya_, 
   {{0xf2e301f0,0x5ecc0115,0x0a0702ea,0xd3ac0325}},	//   _bilione_, _fikirann, _sembrava_, _tövhid_, 
   {{0xd387006e,0x2943004b,0x3a020107,0x64ad00ba}},	//   _alersi_, _гектарын, _turangga_, _رۆککۆمار_, 
   {{0xa2ff0578,0x27ed0060,0x72450486,0xd91900cb}},	//   _sibhlub_, _قالدىرىپ_, _čelisti_, _бекзода_, 
   {{0x638701ac,0xe6dd0579,0x63860198,0x88a20045}},	//   _bearta_, _नितिश_, _spored_, _студирао_, 
   {{0x9c66019a,0x92920064,0x00000000,0x00000000}},	//   _dafties_, _secretàr, --, --, 
   {{0x5c710235,0x0e9203d4,0x38a30093,0xeeef0059}},	// [bc0] _मार्गो_, _потребу_, _северног, _здравна_, 
   {{0xdb7002fe,0xb2ea0230,0xaa8c012a,0x827e042b}},	//   _الجزایر_, _batiman_, _kolekcję_, _pomno_, 
   {{0x04540468,0x1d9c00af,0x674d00ac,0x2986027b}},	//   _اختلاس_, _споруди_, _zbrinjav, _उपगम्य_, 
   {{0x1f6f000e,0x22cb0117,0x23480230,0x799300bb}},	//   _mudanzas_, _keadem_, _lenerzi_, _بھرکم_, 
   {{0x3cbb002f,0xc29000b5,0xa89d01c8,0xd30e0185}},	//   _allintaq, _hakate_, _prémiové_, _cimerä_, 
   {{0x290f011f,0x6a420208,0x325a0125,0xa91e0126}},	//   _аппаратз, _ئێریک_, _hally_, _обіцяють_, 
   {{0x533401b7,0x625a00ea,0xd31102ff,0x00000000}},	//   _सिडनीनगर, _kally_, _dezakň_, --, 
   {{0x9a020024,0x41470161,0x975a0291,0x9378042d}},	//   _মাইবং_, _машинах_, _وسلّم_, _hazaela_, 
   {{0xb0c70141,0x0303009b,0xe1a504c7,0x98ef02f8}},	//   _туркияда, _berandu_, _mirović_, _tangilau, 
   {{0xc27e053e,0xf224012a,0x03780133,0x727e0295}},	//   _poeng_, _kroki_, _daballa_, _moene_, 
   {{0x82130062,0x129100dd,0x9a150455,0xf9e5015e}},	//   _bavha_, _bedair_, _appartie, _телеберү, 
   {{0x03eb00f4,0x9527032b,0xb27e04c5,0x09dc00d1}},	//   _breton_, _далйән_, _pyonye_, _কাপুৰুষ_, 
   {{0x96730212,0x6066033a,0xff2c0331,0xa63001ab}},	//   _hendreri, _indirizz_, _avhendin, _पुछहीं_, 
   {{0x42e301ad,0xec53024c,0x03ea0103,0xb6880156}},	//   _lapinig_, _huttafa_, _epatv_, _cindruli, 
   {{0x51f800bc,0xf22600be,0x1aba0041,0x725a0486}},	//   _عقيلي_, _بوشقولۇم_, _ратәамба, _padly_, 
   {{0x52420025,0xb200018a,0x530001b8,0x815d01d9}},	//   _कपिला_, _adain_, _sajandi_, _öffentle, 
   {{0xb3440515,0xcc6801e8,0xde4d0326,0x2392025e}},	// [bd0] _acresce_, _alfreso_, _angadana, _afbragðs, 
   {{0x012d000c,0x42ea034d,0x6f33002b,0x06070265}},	//   _ханты_, _matikan_, _অতিচঞ্চল, _ademhali, 
   {{0x125a011b,0x4c4800ff,0x775a02bf,0xc3640334}},	//   _fally_, _לעסאָף_, _baphendv, _atagona_, 
   {{0x49c701bd,0x61550452,0x4d0003c6,0x557d0374}},	//   _салада_, _कल्लोळ_, _beslisse_, _фармонга_, 
   {{0x93420244,0x720003eb,0x6cf802f3,0x72fc02c2}},	//   _modello_, _gekies_, _okategor, _snags_, 
   {{0x82a60247,0x0fd4021f,0x60ed00e6,0x4b0901f9}},	//   _tumbas_, _amanitoo, _版权均属于新华社_, _eceshane, 
   {{0xf7150073,0x4ff40235,0xa2a90311,0x1a65026f}},	//   _terminav, _निशाचरः_, _ብጎነጽን_, _ندىلىعى_, 
   {{0xe37800d7,0x2178020e,0x052b03b9,0x4e83015e}},	//   _baballa_, _baballel, _marimach, _келишимг, 
   {{0x2993017d,0xc3860476,0x3306023e,0xf3ea0142}},	//   _ソフトウェア_, _afirwa_, _pemanah_, _apitu_, 
   {{0x40f502a5,0xb2ea03e5,0x417000ff,0x931502e1}},	//   _अप्रील_, _datikan_, _סעליולער_, _arabach_, 
   {{0xf29100dd,0xdeaf02ac,0x15ea0244,0xe2770370}},	//   _pedair_, _مساحتها_, _приготве, _allahhtm, 
   {{0xb0470023,0x9307022c,0xb9d1004d,0x8851030a}},	//   _самого_, _sakabeh_, _新華網版權與免責, _queredes_, 
   {{0xdaf401eb,0x241d023c,0xa0f00040,0x8a8c00a6}},	//   _aserrade, _وغورځول_, _ומפגשי_, _nezingab, 
   {{0x727e0008,0xa6f603f2,0xc38600e6,0x9aec02eb}},	//   _plens_, _научить_, _aborde_, _adjektib, 
   {{0x93ea01fa,0x62c60333,0xcdcc005f,0x00000000}},	//   _epato_, _aculate_, _michoaca, --, 
   {{0x4faa027b,0x34850276,0x68c80212,0xdf1e01f5}},	//   _adhokṣaj, _гугулашт, _adstring, _mendefin, 
   {{0x0666028b,0xe16501e8,0x792200be,0x23710127}},	// [be0] _страничк, _motorway_, _теорияла, _defakeg_, 
   {{0x9987013d,0x52900028,0xe9a70060,0xc9ec03ef}},	//   _elektita_, _aynaan_, _تۇرمايمى, _arangiza_, 
   {{0x13810334,0x138601fb,0x095b0126,0xec6501ab}},	//   _akayang_, _eboree_, _tallrike, _filtrit_, 
   {{0xb575023d,0xcc690151,0xa8d601a6,0xfe9601db}},	//   _trattato_, _baarool_, _mututang, _شىبىق_, 
   {{0x1c730073,0x8e720025,0x4cc80064,0x06350012}},	//   _pensata_, _तिष्ठ_, _الاقانعا_, _उतरहीं_, 
   {{0x385d008f,0x22cf00ce,0x83b0028b,0x03d8021c}},	//   _kinnistu, _negosye_, _иззеиқәм, _plochá_, 
   {{0x07b301c2,0x5544018d,0xaa8902ef,0xb7ed027f}},	//   _próximos_, _ዘምህረት_, _babilonn_, _bidasang, 
   {{0x095d01c6,0x00000000,0x00000000,0x00000000}},	//   _minniste, --, --, --, 
   {{0x2e900147,0x93720151,0x6d1a0061,0x9d0e00a7}},	//   _بۉچۉر_, _defaced_, _민원처리공개_, _моментте, 
   {{0x5c030107,0x90640142,0xd27f008b,0x6fc903c2}},	//   _rimpang_, _वर्षति_, _beengi_, _aahidoor_, 
   {{0x56c901af,0xfe3600e6,0x00000000,0x00000000}},	//   _alsaňam_, _拆迁人应当对被拆, --, --, 
   {{0xe03300f4,0x00000000,0x00000000,0x00000000}},	//   _distroen, --, --, --, 
   {{0xcd15033e,0xdc6202f6,0x00000000,0x00000000}},	//   _europape_, _batuhin_, --, --, 
   {{0xb97501d4,0xf4be0297,0x246c01f9,0x5f61037c}},	//   _antichit, _бюросынд, _balebhiz, _diabolus_, 
   {{0xe8790211,0x738600cc,0x81fe057a,0x92d602d7}},	//   _maahantu, _scoret_, _арканман_, _aproben_, 
   {{0x3073002b,0x3a9700da,0xe909014e,0x42d50086}},	//   _আত্মশুদ্, _dumitres, _ценама_, _sarokba_, 
   {{0x22d400a8,0x9202008b,0x234103dd,0xec0b0156}},	// [bf0] _mardis_, _afrigu_, _distancë_, _אמענדמענ, 
   {{0x23950076,0x14ac01fc,0x6c05005b,0x608b01e0}},	//   _apesar_, _anfakaak, _matsuri_, _بریتانی_, 
   {{0xec3103c7,0xee7000f2,0x9d7b0192,0xbcc70161}},	//   _osobowyc, _ugunsgrē, _vermelde_, _трибуны_, 
   {{0x02f20261,0xa402011e,0x5c83012d,0x22eb029d}},	//   _informoj, _eparnyen_, _laetning_, _emailul_, 
   {{0xe3eb055d,0x73cc0185,0x49ec0043,0x77370488}},	//   _umatku_, _башланыр_, _asinziza_, _frizieri, 
   {{0x49490061,0xfb6b012a,0x528201a6,0xc3f400b6}},	//   _학창시절을_, _brytania_, _miihini_, _uguten_, 
   {{0xb94201eb,0xb26e0487,0x3a1b057b,0x3c0003e6}},	//   _aislante, _scroll_, _bloquead, _ausseet_, 
   {{0xa37b04df,0xe16f003f,0x27810409,0xe41700b3}},	//   _armanym_, _majijlah_, _kirkelig, _bilinjek, 
   {{0x9f54048c,0x021b002f,0x9f300092,0x5257014f}},	//   _supplant_, _ayakachi_, _プレミアム会員規, _жестоком_, 
   {{0x82da018c,0xe2d80027,0x4b8a018d,0x7c1b000a}},	//   _nateon_, _kniele_, _ekuilibr, _annaavar, 
   {{0xfb880450,0x9deb0002,0xb77b01db,0x8cd70271}},	//   _gelokkic, _grejanje_, _спортпен_, _buskerud_, 
   {{0x286e0076,0xaa8c0037,0x6c2b057c,0xf2070156}},	//   _adesivos_, _አውቶማቲክ_, _banegård, _יעדנס_, 
   {{0x4f110148,0xc9f3019f,0xc3b002e5,0x3a150415}},	//   _vantagep, _jitihada_, _balque_, _verbande, 
   {{0xac280121,0x21db0025,0x52c60129,0x2e1a01c5}},	//   _establec, _aligatah_, _ibulite_, _habeenka, 
   {{0x33dd026f,0x220e015e,0x6f5001d7,0x5c6600c8}},	//   _ءتەمۇجين, _матай_, _presidia, _барышы_, 
   {{0x49bf01fe,0xa30803bf,0x7b7c00d1,0x1bfa0087}},	//   _sekerite, _фразалар, _ভাষণত_, _nyingiso_, 
  
   {{0x44fb0255,0xcd4c0040,0xf9eb01ab,0x32d50138}},	// [c00] _किसाने_, _ורעיונות_, _पिटववले_, _tablosu_, 
   {{0xda4f0163,0x372c03a2,0x00000000,0x00000000}},	//   _الانبیاء_, _बेग़म_, --, --, 
   {{0x127e0241,0x32cb01f0,0xdda60020,0xff37021e}},	//   _amananii_, _bokolwa_, _fefinaua, _vägledni, 
   {{0x58c702b2,0x2e640164,0x22c3034a,0xa08c01cd}},	//   _районі_, _бурунму_, _tellado_, _қаландар_, 
   {{0x2c85026c,0x095901b8,0x617e0428,0x92fc0051}},	//   _個搜尋結果_, _प्रकाशनक_, _kadarkol, _baigi_, 
   {{0xf6c4004b,0x6979057d,0x03ea01d9,0xebc9002b}},	//   _отставка, _povijest, _dentom_, _আয়োজনে_, 
   {{0x4e3a02ce,0x19c604b3,0x92900418,0x03eb01e6}},	//   _biologis_, _landerne, _kumaş_, _platbu_, 
   {{0xa2fc02fd,0x333203db,0xeb1a0126,0xdb250026}},	//   _taigh_, _axoxa_, _фірма_, _gesproke, 
   {{0x42cb01e5,0xd94b0035,0x221301ac,0x20a9017a}},	//   _akadá_, _уйлаганд, _dochum_, _ҳоугленд_, 
   {{0x627f03f6,0x5b69028e,0xcb780139,0x454b03d5}},	//   _iluna_, _konfusen_, _वार्ष्णे, _aachlash, 
   {{0x82c90037,0x12c60387,0x00000000,0x00000000}},	//   _በትህትና_, _ebulite_, --, --, 
   {{0xf349033a,0x79fe00ff,0x5f2603ae,0x4387018b}},	//   _esterni_, _גוטמאן_, _hovedinn, _mearga_, 
   {{0xf12d0397,0x9f2b0108,0xc993008b,0x08d800d9}},	//   _дасти_, _kabudaya, _dekkitee, _секунду_, 
   {{0xf0fb0311,0xa6f001fc,0x33dc0053,0x8264034c}},	//   _ዓንገረር_, _tabantá_, _polwan_, _kaplap_, 
   {{0xfec0035f,0xc9d20255,0x2ee1019b,0x927f00a7}},	//   _सर्वोपरि_, _perearst, _turintis_, _lluna_, 
   {{0xc27f0309,0x2d66057e,0x161904e5,0x4341023e}},	//   _oluna_, _इतिहासमा_, _amalwali, _قنداق_, 
   {{0x1c6b02af,0x86b6017f,0x9264015b,0x12bb0044}},	// [c10] _atamuntu_, _aamarsui, _laplap_, _altered_, 
   {{0xc2120129,0x67480386,0x1f4b018d,0x13e10102}},	//   _ahihia_, _menyaksi, _ምቅንጃው_, _kielelez, 
   {{0xd27f02d3,0x8b250265,0x60ba012a,0x9ad1034c}},	//   _aluna_, _besproke, _modlitwy_, _folklorı_, 
   {{0x927e0049,0xa387031a,0x00000000,0x00000000}},	//   _koeni_, _dearga_, --, --, 
   {{0x45730037,0xf25b013d,0xb2a7057f,0xc7c10196}},	//   _በቫንኩቨር_, _italio_, _huebes_, _chosungi, 
   {{0x63ea012f,0x6bc10192,0xc20102e7,0x4290024f}},	//   _spitz_, _세금계산서_, _ascite_, _takape_, 
   {{0xd0e903b7,0x485302d6,0x00000000,0x00000000}},	//   _acticabl, _деразада, --, --, 
   {{0xd2ca019d,0x88490311,0x43d50153,0x42000318}},	//   _abodza_, _ክንቃወሞ_, _この商品は他のサ_, _oliia_, 
   {{0xb2fc022f,0x4c010230,0x93eb02c2,0x79600038}},	//   _taigi_, _awtsors_, _spyte_, _лэкин_, 
   {{0xd1e70223,0xcc7a005d,0x00000000,0x00000000}},	//   _barrutik_, _naimandu_, --, --, 
   {{0x527e015e,0x0b8a0322,0x625b00f2,0xee3800f4}},	//   _somni_, _abanyair, _katlu_, _dalgalia, 
   {{0x6fb00040,0xb8760289,0x034c0077,0x58980350}},	//   _mattress_, _atanyamu, _footbalè_, _ተሸንፈው_, 
   {{0x63f8019d,0x00000000,0x00000000,0x00000000}},	//   _fanuel_, --, --, --, 
   {{0x037802a6,0x538702ec,0x72da01c5,0x4236028a}},	//   _rifatta_, _afarta_, _wateen_, _ngoja_, 
   {{0xa2d80039,0xe6a80233,0x235600aa,0xffff03f7}},	//   _lehen_, _ultrasch, _josephs_, _dýrmætan_, 
   {{0xe3390525,0xd8c80039,0x06bf01c7,0xbb9700af}},	//   _जनकपुरी_, _testuing, _bayrammy, _дискримі, 
   {{0xca110169,0x3b2200ff,0x22d80357,0x01f20025}},	// [c20] _repairme, _טיקקלינג_, _iiieee_, _अधिवर्षः_, 
   {{0xa3790291,0x0f4e00f4,0xa69002ae,0x00000000}},	//   _dialóige_, _erspizet_, _večernje, --, 
   {{0x1a15018c,0x81df014b,0xe27e0045,0xd5f00207}},	//   _verbonde, _gorrisak_, _elenu_, _پڌرنامي_, 
   {{0xe7fa03da,0xe2a1022b,0xfb070421,0x70760237}},	//   _anabigag, _veljast_, _passiert, _블로그검색_, 
   {{0xc95702a4,0xab250272,0x83c80005,0x73540580}},	//   _whistler_, _ababereb, _nouvas_, _cements_, 
   {{0x20260156,0xc2a10034,0xc30002fa,0x22d803ad}},	//   _אינסייד_, _teljast_, _nabandi_, _dehen_, 
   {{0x9c510429,0x1ec300c3,0x013e01bf,0x93ea026c}},	//   _tentera_, _facilius_, _legemidl, _gentem_, 
   {{0x83770148,0x74c9023d,0xe2e800e6,0xa3100059}},	//   _廚房與廚房用品_, _догодина_, _采矿工程师_, _siccome_, 
   {{0x0300025f,0x544600be,0x28070148,0x8201042a}},	//   _babandi_, _تاعىنا_, _nascitur_, _bucine_, 
   {{0xfab0014a,0xda8b029b,0xda0b0020,0xcad30065}},	//   _keresünk_, _bariwoon_, _lamalama_, _editiere, 
   {{0x77bb019b,0x2c5902b9,0x53eb009b,0xd72c02af}},	//   _kolektyv, _kaptunk_, _uretan_, _ikamurig, 
   {{0x02d80250,0xeafe003d,0x66b9003d,0x00000000}},	//   _behen_, _agarrime, _bilateri, --, 
   {{0xa5990220,0xfc050040,0x42cf0044,0x17ed0084}},	//   _крастави, _clarify_, _chimney_, _didagang, 
   {{0xf4b4038b,0xae5e0311,0x00000000,0x00000000}},	//   _pelantik, _ንኽትወጽእ_, --, --, 
   {{0x7f6404bd,0xce45012f,0x7f6d04b9,0xe0490103}},	//   _baharain, _doganiga, _asmatics_, _amirisan, 
   {{0x653401cd,0xff26020e,0x334003e6,0x227f026c}},	//   _abayibiz, _ferekann, _friemen_, _pignus_, 
   {{0x93200219,0xe39501b0,0x02e301e9,0x7b710403}},	// [c30] _lenye_, _diasuh_, _gidione_, _hamongor, 
   {{0x21bc0025,0x82ca033f,0xd2920524,0x00000000}},	//   _व्यवहारे_, _ifalemi_, _trsatu_, --, 
   {{0x3a440119,0xe27e0581,0x517601fc,0x327f002c}},	//   _macerata_, _flent_, _fransaay_, _emanen_, 
   {{0xd0570046,0x951400ca,0x72000241,0x00000000}},	//   _курманбе, _arrocalh, _eliin_, --, 
   {{0x22fc01f4,0x7a1201e9,0xb2020003,0x39970513}},	//   _chaga_, _dibayoke, _syrië_, _jackbuda_, 
   {{0x6c7501b2,0x62740207,0x2ae50220,0xb5180059}},	//   _ceasing_, _سورلي_, _pasticce, _простата, 
   {{0xd88a0147,0x92000138,0xd2ef02a8,0xaa1400a8}},	//   _ارچىندى_, _eskiye_, _ġlieda_, _percunte, 
   {{0x13200582,0x86b40004,0x22470203,0xd2150135}},	//   _denye_, _asosyasy, _mondokom, _игәнәй_, 
   {{0x7f660435,0x3df00132,0x46800105,0x92fd01bc}},	//   _имала_, _اندوز_, _लाराः_, _joegen_, 
   {{0xc2900242,0x928a022d,0x332002e0,0x00000000}},	//   _vakant_, _paragoni_, _fenye_, --, 
   {{0x10ad008d,0x9288025b,0x6d9b02d0,0xf277019f}},	//   _хотираси, _finaluni_, _beguiled_, _uwanjani_, 
   {{0x72f00583,0xb9ad0271,0xd6a3015f,0x00000000}},	//   _delovanj, _miljømes, _diffinni, --, 
   {{0xe2260075,0x937b0117,0xbc910584,0x5b0f0163}},	//   _merkja_, _honarem_, _celebrou_, _párommal_, 
   {{0x3679037c,0xf29500de,0x97ea0261,0x63e6022d}},	//   _bookbrow, _منتظري_, _לכתחלה_, _bastardi_, 
   {{0x2380003c,0xe218016f,0x0e0100be,0x00000000}},	//   _بادگیر_, _обрав_, _كونراددى, --, 
   {{0xeb210418,0x56d501c5,0xd2fc00ee,0x320000cf}},	//   _itibaren_, _faransii, _zaigu_, _aliin_, 
   {{0xb57b0119,0x2524021b,0x222403f3,0xa30c0169}},	// [c40] _bertulfo_, _афоризмы_, _lukken_, _mamadas_, 
   {{0x52a600f2,0xdc4a003c,0x1945004d,0x00000000}},	//   _bumbas_, _دارچیننو, _白點病的原因與治, --, 
   {{0xfd0001aa,0x4b0c0041,0xa2dc0585,0xb29103d1}},	//   _encumber, _ahypyiva_, _polovni_, _vingroša, 
   {{0xf2e80222,0x425900e4,0x38c6049e,0x5169045e}},	//   _objectif_, _त्रिलोचन_, _cibulkov, _хелоуин_, 
   {{0xf2b40025,0xa297005b,0xcd9f0241,0x00000000}},	//   _tacca_, _masayuki_, _giloobaa, --, 
   {{0xd2920377,0xec5a030b,0x72d903c2,0x26310153}},	//   _mesaje_, _agatali_, _anility_, _三島水辺の散歩道_, 
   {{0xf5c1031a,0x6f5701db,0x929000ec,0x02d4005b}},	//   _artaigil_, _арабша_, _sakant_, _ertdna_, 
   {{0x1d080039,0x00000000,0x00000000,0x00000000}},	//   _мухлагий, --, --, --, 
   {{0xec7b0457,0x401f018b,0x627f00bd,0xa2380250}},	//   _asisnah_, _referito, _slung_, _flamuri_, 
   {{0xc2fe04c3,0xefbc02da,0x66c4018e,0x8fc10372}},	//   _exciter_, _историск, _disayiyi, _brunstro, 
   {{0xc2a600e1,0x729202a3,0x7ddc02bb,0x00000000}},	//   _cambar_, _tesame_, _spokojne_, --, 
   {{0xdcef045f,0x4fda01cb,0xd8250299,0xd3490207}},	//   _ansvarig_, _ngezilan, _تېىخى_, _sipendi_, 
   {{0xf2f10016,0xba940031,0xb3bd01f0,0xffc3005b}},	//   _atribui_, _akuntans, _gogwang_, _biginner_, 
   {{0xc373020f,0x5ef90126,0x122403e6,0x2201026c}},	//   _kumazwe_, _негайно_, _kukken_, _habitu_, 
   {{0x827e0004,0x3f620060,0xdd6900da,0x03040227}},	//   _plent_, _толуына_, _монетарэ_, _penolong_, 
   {{0xc26f00e6,0xbdc4011a,0x50de0350,0x00000000}},	//   _中国中小企业信息, _לנקסוס_, _ወደምትባል_, --, 
   {{0x1cf70250,0x662200da,0x046b0219,0xb29c0322}},	// [c50] _kulturor, _непревэз, _atawuntj, _ababakom, 
   {{0xa8f70060,0xb224038e,0x362801a3,0xe2d8010d}},	//   _تويتارىس_, _psikis_, _ٽوئنٽي_, _behel_, 
   {{0x324900db,0x47ee0376,0xec22024c,0x6c4d03d4}},	//   _asemel_, _allahalg, _gustuż_, _цигарета_, 
   {{0xb9dc0488,0xd202036f,0xd667046b,0xbc4e005a}},	//   _klientie, _seriju_, _ganiatáu_, _chuvmey_, 
   {{0xf9c40586,0xdb940222,0xec7702ef,0xe2900165}},	//   _kweentat, _similair, _abitrč_, _kakase_, 
   {{0x322400c2,0x87690044,0xe71101db,0x3e5802eb}},	//   _isoko_, _אחסנה_, _депутатқ, _үбтдс_, 
   {{0xa20000d4,0x81a80302,0x2f9c0139,0xb2240181}},	//   _bliid_, _ngamazwi_, _ayoniśov, _asoko_, 
   {{0xa2480326,0x92ef0342,0x41e1032d,0xa23f0040}},	//   _dzimwe_, _ankouraj, _уйынын_, _רמיקס_, 
   {{0x58730097,0x02900184,0x3245020f,0x925b034a}},	//   _fàgbèrè_, _nakare_, _تربګني_, _atallo_, 
   {{0x727e011e,0xda0402d9,0x40d00115,0xa26d03b4}},	//   _iminan_, _faeasait, _lailatul, _emaoko_, 
   {{0x25bf00fc,0xec17012b,0x53ea008b,0xd3f0003d}},	//   _dayajmoh, _kąpiel_, _gentam_, _barsotti_, 
   {{0x800500ff,0x82000028,0xa091006d,0x1a720411}},	//   _רופסט_, _amiir_, _адаптара, _samlivsb, 
   {{0x05850312,0x927e0265,0x027e00ad,0x59ec0103}},	//   _energiez, _klenz_, _eneng_, _aitibata_, 
   {{0xaa1300c5,0xc6a00163,0xacbf0130,0xdb390019}},	//   _您的身份为游客_, _الباری_, _echedoù_, _ракетада, 
   {{0xbef80309,0x91fe029f,0x0fec00c7,0xb27e00f4}},	//   _quraşdır, _diskusné_, _хакимият_, _boent_, 
   {{0xd9fc0152,0xdeb90265,0xc2b40230,0xc50301f6}},	//   _машинасы_, _situatie_, _cacco_, _দিয়ক_, 
   {{0xf27e038f,0xc200046b,0x2db3001d,0x39f30119}},	// [c60] _voent_, _ddail_, _redactet_, _konsumed, 
   {{0x738701f1,0x9fa40156,0x56240009,0x757103a4}},	//   _ndarja_, _ברעיקט_, _navodili, _gundadal_, 
   {{0x3db902f6,0xf27e00a0,0x82d40258,0x5d7a0260}},	//   _maghinta, _aminan_, _efternei_, _baamonde_, 
   {{0x28c5003d,0x13f904c3,0xe9e700da,0xdfc30007}},	//   _vicesind, _acquy_, _медикалэ_, _bakomilo, 
   {{0x32920219,0xc290000c,0xfb0e027c,0x6f110437}},	//   _besake_, _jakare_, _eliphant, _mandagen, 
   {{0x694c0258,0x997a0168,0xb248003a,0x230503ce}},	//   _dakleaze, _invitert, _imomi_, _ڕوبار_, 
   {{0x851f00d1,0x025a00b4,0xa25b00f2,0x96fd003c}},	//   _অতিসংবেদ, _unelte_, _katli_, _چیپست_, 
   {{0x72bb0233,0x10320158,0xf34f02ac,0x0b7a024f}},	//   _volente_, _दुख़दायी_, _بمرضى_, _eparaama_, 
   {{0x89e601aa,0xbb0c0013,0xd683010d,0x113502e5}},	//   _escribed, _نازیک_, _विरार_, _кындыҕ_, 
   {{0xbc63019f,0x727e01cd,0x8ee401b7,0x329200da}},	//   _matukio_, _mnene_, _सनत्कुमा, _повязкэ_, 
   {{0x32a604ea,0xe2fc0113,0x727e02f6,0x3d9e0436}},	//   _lambor_, _haigh_, _aminin_, _agresije_, 
   {{0x42900120,0x8fe50073,0xc3960587,0xfb4300b4}},	//   _bakare_, _scriptio, _èsser_, _fotbalis, 
   {{0x93f9005c,0x126e005b,0x2d6f00bb,0x23ce00f1}},	//   _kibuye_, _istock_, _وحرام_, _provok_, 
   {{0x935302c4,0x32fc0113,0x13f900ae,0x21b2002b}},	//   _слабеење_, _maigh_, _bibuze_, _তাতেও_, 
   {{0x63870353,0x927e013f,0xf3790321,0x6412004d}},	//   _zdarma_, _poent_, _cesarja_, _權利金報價單位_, 
   {{0x6c6700b4,0xcdb20094,0xd6ed0141,0x629001a6}},	//   _solutia_, _قىزىعۋشى, _моделлаш, _takare_, 
   {{0x4d760247,0x62fc005b,0x00000000,0x00000000}},	// [c70] _پرينت_, _chage_, --, --, 
   {{0x4cd6022f,0x424804b9,0xa84801e1,0x23f800e1}},	//   _забрала_, _climbs_, _рәшит_, _alluwa_, 
   {{0x9d66026e,0x6ec40483,0x076d0139,0x583f004c}},	//   _इतिहासका_, _redondas_, _दग्धा_, _asumulud, 
   {{0x226c0261,0xdaf10373,0xe2af00fc,0xa29401e3}},	//   _denove_, _imperies, _daharlaw_, _opravili_, 
   {{0x23f900de,0x16cd0227,0xdafb018d,0x72e8017f}},	//   _sibuze_, _disampai, _ሓንጎለይ_, _aarfit_, 
   {{0x72d2013d,0xa57b0257,0x2bae02eb,0x82900145}},	//   _titoloj_, _grindaví, _физикийн_, _vakare_, 
   {{0xf2cb04bd,0xfa8f01d2,0xce4d00fb,0xa2900227}},	//   _kolopua_, _ashinman_, _ingakana, _mukaku_, 
   {{0xc2fc0195,0x3a8e0250,0xf62b00ab,0x451300ec}},	//   _faigh_, _françesk, _harihari, _тэўтонск, 
   {{0xe9dc02d8,0x37250170,0xed110242,0x39ec020a}},	//   _motornya_, _akumakag, _vurduğu_, _جانباسام_, 
   {{0x2dba00d8,0xa54e02cf,0xf3c800bd,0xa2d6001c}},	//   _notament_, _видни_, _dauvit_, _habombo_, 
   {{0x3263032e,0xab1c03e6,0xdab80045,0x720e0361}},	//   _walikiti_, _ausprobe, _формулар_, _канаш_, 
   {{0xd27e0052,0x025a00af,0xfe510050,0xd29001f0}},	//   _pleny_, _drillo_, _kalangka, _makape_, 
   {{0x2036013b,0x7200028a,0xd5b9020f,0x150000e6}},	//   _kaatuban, _kajiru_, _اوتاسو_, _拍卖出让起始价为, 
   {{0x4373017c,0x93cf0543,0x42a7023e,0x0a7e0375}},	//   _senaste_, _aceval_, _brebes_, _afundits, 
   {{0xd3e000da,0x7d71036e,0xf64700de,0x42fc04b2}},	//   _медалион_, _chimbora, _abazitsh, _maigi_, 
   {{0x3c6500a1,0xb2f300e3,0x00000000,0x00000000}},	//   _tapuwae_, _jezistu_, --, --, 
   {{0xf98e0219,0x29e701e9,0x32f00272,0x8263012c}},	// [c80] _lomhlaba_, _babolela_, _abaingi_, _katoliki_, 
   {{0xd78101d0,0x72cb0564,0x62000212,0xd1bb01ab}},	//   _virkelig, _deadam_, _mulier_, _चहुँपे_, 
   {{0xd69602d4,0x7ad30152,0x80be0161,0x6f480244}},	//   _suverani, _рекламаг, _киева_, _sessuale_, 
   {{0x9d79003b,0xc8770177,0x7daf01bf,0x8c9d01ac}},	//   _abamange_, _аграната, _undertøy_, _الوشم_, 
   {{0x0915014d,0xba1502c7,0x4ae10065,0x532802d6}},	//   _verbindu, _verbinde, _arbeitss, _прозелит, 
   {{0xb25a02ec,0x92d800fe,0xdc9e0153,0x16c500c7}},	//   _sahlan_, _hehea_, _前記管状体の近位, _беттеләр_, 
   {{0x49e7044a,0xc2d800fe,0x00000000,0x00000000}},	//   _bazobela_, _kehea_, --, --, 
   {{0x4bfc00ef,0xf2ca018d,0x00000000,0x00000000}},	//   _عدلیې_, _ምምላስን_, --, --, 
   {{0x72fc0588,0xdb0d0589,0x123a023c,0x3535021b}},	//   _ibigo_, _gretzkéh, _bakwandl, _mainosmy, 
   {{0xd2d80410,0x156b012b,0xdd23041e,0x6b650121}},	//   _lehea_, _napisała_, _tirrenic, _catalán_, 
   {{0x479601fb,0xc9670373,0x12d60170,0xe2d20071}},	//   _predicav, _alligite, _kajombo_, _didokok_, 
   {{0xdc5b0101,0x94940255,0x28210092,0x6ba703a2}},	//   _noutati_, _उपेन्दरव, _取り扱いジャンル_, _तरणताल_, 
   {{0x73ea03e4,0x080103d0,0x16b9006a,0xaed4003c}},	//   _aqata_, _العسلي_, _hitantsi, _آبرنگ_, 
   {{0x52900312,0xa17f0218,0xe202001e,0xb9d60235}},	//   _lakaat_, _admitway_, _afrilu_, _विषयैः_, 
   {{0x32d80039,0x2c65000b,0xde4201ef,0x00000000}},	//   _behea_, _tapuvae_, _будуюцца_, --, 
   {{0x2ea101bf,0xf8120207,0xc3a80456,0xb84b022e}},	//   _fullsten, _دُنيا_, _senapang_, _bastiais_, 
   {{0x025b001d,0xb73c00bf,0x02d90372,0xea910050}},	// [c90] _araldo_, _спешите_, _anaele_, _caringin_, 
   {{0x64da0371,0x026c04f8,0xd1d1006d,0xa9ee000b}},	//   _помни_, _denote_, _андэграў, _potifara_, 
   {{0x2307031a,0x85670089,0x59f60152,0xdc61033c}},	//   _ardaibh_, _синаның_, _borçu_, _gatrawd_, 
   {{0xfb8a0187,0x8be80057,0x05760177,0x9cfb03da}},	//   _помош_, _ይሰማኛል_, _агранатр, _hortativ_, 
   {{0x52fc01e9,0x438704b9,0x43db017a,0x83490318}},	//   _baagi_, _fearna_, _amathegi_, _mateloi_, 
   {{0x1f50058a,0xf205058b,0x598e03de,0xf4bf0188}},	//   _consocia, _splitski_, _bomhlaba_, _африқо_, 
   {{0x3868009a,0xa26c03f6,0x741703ba,0x62490255}},	//   _خيريه_, _gihona_, _frisiren_, _enamus_, 
   {{0x934103ad,0xe4130220,0x6f0200ec,0x532303b2}},	//   _privatam, _chiamato_, _pusmetį_, _lanclip_, 
   {{0x72900301,0xdd58034c,0xa9630154,0x032103b6}},	//   _olmasa_, _ләйлә_, _поезий_, _gbayì_, 
   {{0x554c02c1,0xbc260258,0x46920192,0x00000000}},	//   _mashyash, _omnamwur, _letterty, --, 
   {{0x875a008d,0x90f60035,0x2a91003c,0x6eb80037}},	//   _васаллам, _kulların, _waringin_, _በመሰለፍ_, 
   {{0xf0b801de,0x4de10287,0x027e00dd,0xc3e10102}},	//   _بەسەۋ_, _turisté_, _boeni_, _vielelez, 
   {{0x4ce20041,0x1556058c,0x3f6702e2,0xca9d0281}},	//   _аҽалархә, _प्रणालील, _aggairys_, _atsiugas, 
   {{0x1fb90071,0x9a0e004d,0x835a0416,0x33eb02ef}},	//   _هلیکوپتر_, _桃園停水公告_, _touflet_, _kretin_, 
   {{0xf2020286,0xeb1f02df,0x70170126,0x938600ea}},	//   _afrimu_, _penafian_, _районна_, _endrik_, 
   {{0xf7b40515,0xb27f0027,0x1213013b,0x32e803ad}},	//   _aggrandi, _fluni_, _cochem_, _abbilta_, 
   {{0x6e730406,0x5bc30071,0x8e670164,0xae52022f}},	// [ca0] _बौद्ध_, _تهاجم_, _байлиқи_, _istorinė, 
   {{0x6c510318,0x704600c4,0x24b8002c,0x822b051a}},	//   _anitema_, _ڇائنجي_, _витаминт, _qardhawi_, 
   {{0x139404b8,0xaffd0361,0x86f000c1,0x0aa501a3}},	//   _babsa_, _военкома, _पायवाट_, _اڻسڌي_, 
   {{0x62fc01b8,0x82c1035e,0xae5b0177,0x56c00155}},	//   _saagi_, _okolina_, _убриалаг, _hässleho, 
   {{0x32fc04be,0x8ebd01cb,0x535f006c,0xa9cf0165}},	//   _paagi_, _ukuzibop, _singase_, _cokovata_, 
   {{0xbc7f023d,0x23ea047d,0x5d480060,0xee5500e7}},	//   _massimo_, _spatz_, _клиентте, _adicalra, 
   {{0x1bd8058d,0x2c95016d,0x89470259,0x3fbd0097}},	//   _अमेरिकन_, _атаңниң_, _afslappe, _iyàrá_, 
   {{0x794703db,0xa38603f1,0xa07d00a7,0xdeb50043}},	//   _abambele, _kufre_, _батса_, _alkright_, 
   {{0x72fc0129,0x7a150166,0xd3eb0288,0x23410208}},	//   _taagi_, _verbunde, _eretin_, _دۆغان_, 
   {{0x73480274,0x646a004d,0x00000000,0x00000000}},	//   _áfengi_, _台灣大學藝術史研, --, --, 
   {{0xb9bb0066,0xec04023c,0x22000039,0x6088040f}},	//   _moldatze, _asisayi_, _alaia_, _burokėli, 
   {{0xe27e033c,0x72b40082,0xb94700f3,0x927f033f}},	//   _poeni_, _lacca_, _ebambele, _kouna_, 
   {{0x7a890253,0xf01501ef,0x17f900be,0xe2130313}},	//   _sivisuss, _merginą_, _базардаг, _jeghbe_, 
   {{0xc95802a5,0xb1de008d,0x22b40120,0xe6630078}},	//   _जुनसुकै_, _birlashm, _gacca_, _ментално, 
   {{0xc2550008,0x05fd0113,0xe32704b9,0x10e9050a}},	//   _ensenyam, _chreidiú, _conceit_, _yuvarlak_, 
   {{0x2ff601e5,0xd2020291,0x823b0294,0x3e450119}},	//   _ifamọra_, _impigh_, _fulllog_, _nakataga, 
   {{0x52a700c8,0xf9cf030a,0x757700d6,0x40640119}},	// [cb0] _лауреатт, _aquelout, _steiréit, _papatayo, 
   {{0x0341019f,0xb9fb04da,0x9ae40109,0x5b83016e}},	//   _napenda_, _mobitela_, _चट्याङ_, _pornolar, 
   {{0x417e02ee,0x8290001e,0xe0f600f6,0x144a0478}},	//   _madankol, _almara_, _pulların, _anglofòn_, 
   {{0x1cf202a8,0xaa5f022b,0xe6550311,0x82d90320}},	//   _lecturer, _ringasta_, _እናንቆልቆለ_, _maendle_, 
   {{0x827f03d7,0xd94901af,0x22d80369,0xf7e502fb}},	//   _jouna_, _терзде_, _meheu_, _matavaiv, 
   {{0x1300003a,0x7d3200c5,0x0b5b0026,0xdda5010b}},	//   _sifatli_, _wikicode_, _momenten_, _dirisiwa, 
   {{0xe41304dc,0x4c6704dc,0xbe4500a5,0xac2400a0}},	//   _واندا_, _ترسام_, _fakataga, _fabarair, 
   {{0xeb2203d5,0x39790281,0xa449002b,0x427f00d7}},	//   _dispelle, _arsimmee, _ঘটনাপ্রব, _founa_, 
   {{0xd3860120,0x6635031c,0x425b0079,0x00000000}},	//   _agirwa_, _atracció, _katls_, --, 
   {{0x356b02bb,0xe43c0153,0x42f00243,0x99760137}},	//   _kapitału_, _その他レディ_, _wariseh_, _никхүн_, 
   {{0x4fd2048a,0xc155058e,0xe3f401da,0x62b200b0}},	//   _اماندا_, _जल्लाद_, _vertet_, _muddada_, 
   {{0xfebc03af,0x235a011a,0xb297011d,0x62a600e1}},	//   _sexuelle_, _confers_, _grupuril, _mambar_, 
   {{0x52a60082,0x7da00007,0x7907020f,0x6bf50040}},	//   _lambar_, _bakotuna, _تعصبه_, _חוכמה_, 
   {{0xb7280128,0xc290003b,0xeab80037,0xb3ab0064}},	//   _موضوعلر_, _bomata_, _ክፍያውን_, _píxels_, 
   {{0xf79301b5,0x2f600047,0x426c0343,0x4b6500a8}},	//   _cheddarg, _relatifs_, _calory_, _èquesta_, 
   {{0xa49c032e,0xe84602c8,0xdf25003d,0x934100c4}},	//   _inamayäk, _partires_, _annexion, _wapenda_, 
   {{0xf395058f,0x43f901e6,0xc27f02d3,0x686d003c}},	// [cc0] _darse_, _cibule_, _aluno_, _ذیربط_, 
   {{0x164f007f,0xc96c0224,0x22c904a4,0x8bd80109}},	//   _phenderf, _brennide, _millidh_, _अमेरिकि_, 
   {{0x990a0037,0x67bb005b,0xe2dd0372,0x6f670234}},	//   _የሚፈፀሙ_, _indretni, _chroesi_, _oníṣeẹ̀d, 
   {{0x12d80163,0x2369040a,0x2efa01d5,0x00000000}},	//   _mehet_, _ångrar_, _szüzessé, --, 
   {{0x749301ec,0x13d70052,0x70950041,0x776c0060}},	//   _سخنگو_, _शाकाहारी, _афабрика_, _монтажда, 
   {{0x325a013a,0x439502e7,0x9e93040a,0xe9a6027b}},	//   _wahlen_, _giasoy_, _thailänd, _तत्फलं_, 
   {{0xc7280037,0x84cf0476,0x00000000,0x00000000}},	//   _ይፈጽማል_, _chichemo_, --, --, 
   {{0x3369018a,0xdb6202d3,0xc2df02c7,0x00000000}},	//   _aneglur_, _jeferson_, _gehofft_, --, 
   {{0x02000270,0x313e0145,0x3d89038b,0x43290153}},	//   _blain_, _reguliuo, _memotiva, _チした商品はあり, 
   {{0xe2b101eb,0x309400ff,0xf290000f,0xf02b0420}},	//   _sandía_, _סאציאלאג, _almaya_, _допринес, 
   {{0xb2550193,0x127e0158,0x00000000,0x00000000}},	//   _सिनेमे_, _zimna_, --, --, 
   {{0xca1701ef,0x4c090100,0x9b5f0037,0xd8520237}},	//   _феномены_, _propala_, _ይጠቅመናል_, _공고문보기_, 
   {{0x977a018d,0x7f2b00f5,0x130e00b7,0x0fbc011f}},	//   _ብመዝሙር_, _partlama, _alyalar_, _маскевич_, 
   {{0x2bcc0220,0x897601a4,0x32900185,0x644e009b}},	//   _комисият, _etangame, _elmaya_, _доройтло, 
   {{0x19d00162,0xd692016d,0xe27e0528,0x9c08004c}},	//   _бейиш_, _штабиниң_, _lionas_, _bakulemb, 
   {{0xe3f802fd,0x6c67008c,0x82110122,0x00000000}},	//   _beaul_, _adattos_, _بدلکار_, --, 
   {{0xe27f012d,0x42c1011b,0x731c0262,0xd2b50220}},	// [cd0] _egensi_, _ekolona_, _ayechka_, _fasce_, 
   {{0x52b503f9,0x6dbc032e,0x72ee008e,0x335f03d8}},	//   _nasce_, _jakirina, _atangii_, _parfemi_, 
   {{0xfb9000ee,0x6ef101b6,0x89b70148,0x5213015d}},	//   _мэднэ_, _marketin, _請看影片說明_, _kocham_, 
   {{0x398a0092,0x329000ad,0xa7090137,0x234000ee}},	//   _ジアドレス_, _komara_, _дөхөмтэй_, _legeria_, 
   {{0x779c02b7,0x9d93007b,0x530e01e7,0xf17703a4}},	//   _gobongö_, _shetland_, _albator_, _allarhel, 
   {{0xf694018d,0xde9e00c7,0x00000000,0x00000000}},	//   _መፈጸምታ_, _сайла_, --, --, 
   {{0xc2250190,0x93f80044,0x62cc019d,0x19ed00dc}},	//   _jucken_, _manual_, _adalimo_, _fitugafu, 
   {{0xac4c000e,0x622502a7,0x79ea0590,0x527e02e0}},	//   _mulching_, _ducken_, _чацарган, _ineng_, 
   {{0x6e1b0251,0xc57d01a3,0x7e6a00c7,0x92cb0235}},	//   _dareenka, _پيڙائن_, _бозда_, _dagdha_, 
   {{0xb50b018b,0xa2d80244,0x627f0140,0x00000000}},	//   _guvernul_, _chiese_, _boung_, --, 
   {{0xbc9b0041,0xff430156,0x1c5b0207,0x31ac0242}},	//   _аҵаҳҩит_, _געװײנטלע, _kapteni_, _düşünmür, 
   {{0x8b35002b,0x98740013,0xaab20043,0x106d0321}},	//   _অক্টোবার_, _nalishid, _alikukub, _skopiran, 
   {{0xa9f70151,0x0290036c,0xb303012d,0x009700ec}},	//   _demagnet, _adiady_, _turangu_, _арастові, 
   {{0x896e01e5,0xcace005d,0x57ed0090,0x24630524}},	//   _alaisoot, _angapýpe_, _andakang, _predivno_, 
   {{0xb27f03e0,0x74560061,0x8aef0591,0x00000000}},	//   _goung_, _기독교사의_, _etiopien_, --, 
   {{0x8e320531,0x2a1401f1,0x9b5000e6,0xc2900592}},	//   _amelikas_, _miratohe, _原中国人民银行河, _tomara_, 
   {{0xc1b00297,0xe34b0061,0xda230333,0x00000000}},	// [ce0] _belemenä_, _geneukt_, _banchitt, --, 
   {{0x85ee03f0,0x7e8902ec,0xf2070012,0xc53d003c}},	//   _landslið, _نوبہارس_, _बतिआवत_, _شيرخوار_, 
   {{0x3db30593,0xd1fe0360,0xd85700c4,0x9ec200ab}},	//   _utlandet_, _diskusní_, _فولڊر_, _erenatan, 
   {{0xb4ec002b,0x47790045,0x12360193,0x0201010e}},	//   _সিহাব_, _парамета, _sekjen_, _habiru_, 
   {{0x520002fd,0xec6200fe,0x709901c7,0xe26e01d4}},	//   _amais_, _aufuato_, _кемпуды_, _riposa_, 
   {{0xba0b0282,0xec7100df,0xe82e0374,0xd2fc0278}},	//   _kamakama_, _chariot_, _урсин_, _cengal_, 
   {{0x6200033c,0x93860264,0x52ef02db,0xa3560373}},	//   _blaid_, _leiria_, _misnari_, _superas_, 
   {{0x9db1026b,0x6c880162,0xbc7f03ed,0xd2b4003a}},	//   _lenguaje_, _билишимч, _versão_, _pincha_, 
   {{0x21e70079,0xeece0029,0x6fc30203,0xe7f40291}},	//   _spriedum, _کڵتور_, _admisser_, _chladaig, 
   {{0xf27f033d,0x28600012,0xe2240107,0x1f2d0326}},	//   _moune_, _पीठेश्वर_, _binkai_, _chaticha, 
   {{0xc31601c8,0x627f005b,0x05240037,0xd9090350}},	//   _krabici_, _amuny_, _ፊሊፒንስ_, _በሚጠቅም_, 
   {{0x889c00be,0x627e048b,0xd2fc051a,0xae4603ad}},	//   _ئزىلدۅچۉ, _mieng_, _sengal_, _diossidu_, 
   {{0x97f202c3,0x696c0036,0x6b1101bd,0x526e0544}},	//   _možnosť_, _eilimint, _جىيعىزىپ_, _zipora_, 
   {{0xf50604d8,0x4c1401aa,0x02910101,0x9dde01d0}},	//   _جانانہ_, _ourshay_, _pacate_, _tyskerne_, 
   {{0xf63002ef,0xbb9c00a4,0xeea40200,0x7387024a}},	//   _biyograf, _ئزىلدەنۉ, _marelius_, _elerii_, 
   {{0xbfed0238,0x742d0352,0x8dbe002e,0x947601b4}},	//   _ознаки_, _স্মাৰকসম, _oduševil, _brittanj, 
   {{0x0c7c00e0,0xec5c0594,0xf3940117,0x2387006e}},	// [cf0] _frisian_, _slutten_, _longlong_, _enersi_, 
   {{0x029200bc,0x02d802ee,0x427e04c3,0xe79900be}},	//   _marang_, _sehem_, _kieng_, _талантты, 
   {{0xb27f015a,0xe386024c,0x653200c4,0x00000000}},	//   _amanan_, _sufra_, _mwanasay, --, 
   {{0x32240119,0xba6b0595,0xea030263,0x7eb1004b}},	//   _dinky_, _यौनशोषण_, _verbouwe, _hatsetse_, 
   {{0x527e0245,0x92870596,0x3e520456,0xd79b0061}},	//   _lieng_, _bouazizi_, _cadangka, _김치볶음밥_, 
   {{0xa1ac0242,0x7b090149,0x3386024a,0x72000304}},	//   _düşündür, _futubọọl, _dunra_, _slaid_, 
   {{0x727e00c9,0x92b904d2,0x6b1b02ac,0xf893007e}},	//   _nieng_, _endeleg_, _وفنادق_, _दस्सेन्त, 
   {{0xf868017f,0x63e5004d,0xb94103ec,0xeb5f022c}},	//   _maniitsu, _salutari_, _kualitet, _darmamur, 
   {{0x7c75020e,0xf27e012a,0x038e01cf,0xf44e0009}},	//   _ofising_, _zimno_, _rompiasi_, _veljavno_, 
   {{0x62160041,0x467e00e6,0xb09702cf,0xe86c01af}},	//   _apararä_, _放射性同位素与射, _техничка_, _bilimind, 
   {{0xd7a60326,0x6f98026f,0xf29103f0,0x00000000}},	//   _chatakai, _كەسۋى_, _evran_, --, 
   {{0xe2c40331,0x14330202,0x8e4d014c,0xe26c02d9}},	//   _ongland_, _ikimọlẹ_, _engakana, _lomitusi_, 
   {{0x5c800368,0xed0a00f3,0x0a010184,0xd830007e}},	//   _десет_, _ihardwar, _nkurunku, _सिंहवर्म, 
   {{0xe22a014f,0x69fa02af,0x7e3d002f,0xda9102d0}},	//   _досад_, _kibarere, _hawapipa, _scrievin_, 
   {{0xeb6c00da,0x186703e2,0xd60301d5,0x027e04f2}},	//   _министру_, _solicitu, _gondolom_, _gieng_, 
   {{0xebd2020f,0x33ba01d3,0x8e4c01e8,0x95550597}},	//   _مینځنی_, _elevers_, _makagana, _бухахь_, 
   {{0xe2b60005,0x0d4102a4,0x44fb0501,0x629200ad}},	// [d00] _paucas_, _cappadoc, _किनारी_, _carang_, 
   {{0x126c0304,0x616c0300,0x794d0073,0xa25b00de}},	//   _aktiviti_, _aktivity_, _removere, _agalel_, 
   {{0x127e0531,0x632c0013,0x9353020f,0xa4190046}},	//   _xieng_, _шулардан_, _تهداب_, _медалын_, 
   {{0xf27e04bb,0x7b55029f,0xa998016d,0xdfeb02ac}},	//   _vieng_, _dostávať_, _تەدرىجىي_, _إرشادات_, 
   {{0xb38700bc,0xd2480020,0xc8c7001c,0xa97503dc}},	//   _ngarep_, _amomoi_, _oberberg, _grindame, 
   {{0x4320020b,0xfc1c03da,0x386d0099,0x00000000}},	//   _bonye_, _wentị_, _hatichad, --, 
   {{0xbcd00169,0xa45f0037,0x820902b9,0xb2910290}},	//   _লেখকঃ_, _በመራጭነት_, _marosvás, _avran_, 
   {{0x4e4d00cb,0x00000000,0x00000000,0x00000000}},	//   _angakana, --, --, --, 
   {{0xb307017d,0xc27e02b5,0xebe30246,0x5f9d030a}},	//   _aalborg_, _sieng_, _гоблени_, _agresión, 
   {{0x427e01bc,0x4c19009a,0xeb8400da,0xe8c80244}},	//   _miene_, _amalaphu_, _ӂенераци, _costring, 
   {{0x3dc00272,0x8ed6014d,0x7d99011d,0x47460144}},	//   _abakumwa, _bedienun, _повестит_, _caipitiú, 
   {{0x23980510,0xbd6a0013,0x524503ff,0x6a3e0185}},	//   _трагичес, _کروانگه_, _kámen_, _сайлаган_, 
   {{0x112d0444,0x59250052,0x358c02a9,0x57b40297}},	//   _марте_, _भविष्यदर, _нясуць_, _bedretdi, 
   {{0xd27e04c3,0x325a054b,0x087f00e4,0x1f3600d2}},	//   _tieng_, _sahlin_, _शब्दयोग_, _susugana, 
   {{0xe29401ff,0x59f9038e,0x02fc0264,0x1b6402ef}},	//   _spravili_, _मौल्यवान_, _maagi_, _katezien_, 
   {{0x87e60598,0x329202f6,0xb27e04f2,0xae6f0255}},	//   _अनार्य_, _parang_, _rieng_, _गम्भीरत_, 
   {{0x42920013,0xbc6802ac,0x7a7e0133,0x14f90093}},	// [d10] _qarang_, _corrán_, _gallakis, _герзаца_, 
   {{0x1e4b0281,0x326c003a,0x3b0801c8,0x88f60281}},	//   _qularnaa, _sahifasi_, _neuprave, _atuagagd, 
   {{0x1eb0033d,0x259a0396,0xc011011e,0xd1fe023a}},	//   _konesans_, _sikurezz, _providan, _diskusný_, 
   {{0x729200ad,0x8291002e,0x60c3027e,0x031a040e}},	//   _tarang_, _pucaju_, _уцинака_, _avvising_, 
   {{0xd39503cf,0xa27e04ff,0x53200387,0x098302e5}},	//   _varsa_, _moenx_, _sonye_, _ргәыҧ_, 
   {{0xe2d900d6,0xeac600e6,0xe39500bc,0x85cc0060}},	//   _diyene_, _篇推荐文章_, _warsa_, _барғаным, 
   {{0x05e300af,0xf27e0359,0x04070076,0x527e012a}},	//   _культури_, _hiene_, _градови_, _zimne_, 
   {{0x9b7b0515,0xb32f00c7,0x424b003e,0x00000000}},	//   _longitan_, _адәмнең_, _бошҡанда_, --, 
   {{0x9fe700dd,0x8b190159,0x00000000,0x00000000}},	//   _archesgo, _камфортн, --, --, 
   {{0x62d604a6,0x62240120,0x3eca0119,0x1053018a}},	//   _redovno_, _tokkel_, _mrinalin, _henseren, 
   {{0x9cfe0440,0xf386004c,0xed8d00ba,0xcbf501d2}},	//   _aritahir, _agirya_, _پاشڤه_, _creenanc, 
   {{0x4eca00ba,0x32ca013f,0xc2d90107,0x017a00d9}},	//   _باپیرئاغ, _bridel_, _biyene_, _самоделк, 
   {{0xccdd002b,0xd356019d,0xc200007a,0x3e41018d}},	//   _ঢেঁকি_, _idafala_, _alaik_, _grabitet_, 
   {{0xaa070338,0xc26c024f,0x438601f3,0xe31103f0}},	//   _semblava_, _tilomi_, _oporou_, _enskumæl, 
   {{0x32c801b2,0x9d9a0041,0xa25a00ad,0x5b9e0041}},	//   _expound_, _иаҳдыруе, _doeloe_, _рышҟа_, 
   {{0x8c680067,0xca27014e,0x74770026,0x62ef025e}},	//   _aanutti_, _уредник_, _systemen_, _krafti_, 
   {{0xaf670033,0x8b860183,0xc7fc0314,0xe3160262}},	// [d20] _votaziun, _beronono_, _лотфулли, _bujagaz_, 
   {{0xe49900bf,0x92000227,0x1c1d00e0,0x62900185}},	//   _претендо, _alaih_, _kloppet_, _elmaep_, 
   {{0x4c710599,0x4b5500bb,0x00000000,0x00000000}},	//   _पुल्टा_, _اختےار_, --, --, 
   {{0x0b3500cb,0xa39f02ac,0x9db50002,0x2edd0128}},	//   _ababeses, _أصناف_, _proslavu_, _ташланиб_, 
   {{0xe6730139,0x7ff400bb,0xceae0037,0x825a0359}},	//   _प्रतिमास, _پرتھوی_, _እስካለፈው_, _boeloe_, 
   {{0xcfeb010d,0xf39400e2,0x9bda0253,0x4c1b03a4}},	//   _kenyaman, _kinsto_, _brewhous, _innangar, 
   {{0x9e0a01d5,0x165203a2,0x1c6d0373,0x947e027e}},	//   _دہرایا_, _चारदीवार, _aliuloj_, _официра_, 
   {{0x2769004d,0xf2ee03dd,0x973000a7,0x3f2a0068}},	//   _全文接近率_, _prifti_, _эмиратта, _bastoola, 
   {{0x997104cc,0xe29102d4,0x7ea000de,0xee6d0256}},	//   _nyinhnae, _ovras_, _چپاول_, _nodibinā, 
   {{0xfdb200fe,0xb3dc0288,0x0300023b,0xf26c021c}},	//   _fulufulu_, _schwe_, _leialii_, _jahoda_, 
   {{0x82900117,0x939502ce,0x22d004a4,0xd810004d}},	//   _nomata_, _darso_, _chalder_, _巴西塔姆航空公司, 
   {{0xe35a00bd,0x884d0260,0xa5fe0309,0x72bf01ac}},	//   _coffers_, _ópticos_, _bombanı_, _أمجاد_, 
   {{0x0bfe040f,0x12910128,0xc3fb050a,0x00000000}},	//   _skrandži, _avrat_, _portatif_, --, 
   {{0xfb8f02fd,0xfc2a0148,0x421c01f1,0x12ec02a4}},	//   _glengarr, _全民最大黨_, _kushdo_, _latinae_, 
   {{0xdc5a037c,0x59c403d5,0xf20204f8,0x58370137}},	//   _montgri_, _adeeabat, _resins_, _жинлүүр_, 
   {{0x527e00ee,0x3054018b,0x0fb7005d,0x2f4c001d}},	//   _onena_, _clasamen, _exalumno, _págines_, 
   {{0xb34c027b,0x9a370235,0xf1bd00e6,0x3daf0429}},	// [d30] _राजंस_, _bahiddhā_, _申银万国预计_, _bergayut_, 
   {{0x93200138,0x16b80249,0x929701ba,0x3631005b}},	//   _konya_, _kalabusi, _senkant_, _månedlig, 
   {{0x627e007e,0x54da01a7,0x637c0423,0x22da01ad}},	//   _anena_, _ровно_, _pergoly_, _eatern_, 
   {{0xfa2800ba,0xb7a60092,0x80dd009a,0x68d000d2}},	//   _خولقێنه_, _個人情報について_, _ibonakel, _cibeureu, 
   {{0xe26c023b,0xed9c03a0,0xebf3005d,0xfbdf0121}},	//   _kilohi_, _hosetele_, _irresurr, _adhesión_, 
   {{0xc395019b,0x5290011b,0x4b630244,0x5cc90297}},	//   _garso_, _komata_, _bretagna_, _kardäşle, 
   {{0x038700fd,0xc628037c,0xd2560193,0x3699000d}},	//   _lawrie_, _veritati, _प्रांतात_, _sisenemi, 
   {{0x68460595,0xb35e027f,0x63790046,0xc981021c}},	//   _डायस्पोर, _gakunkum, _baralla_, _cyrilome, 
   {{0x3a8f033c,0x7b08042c,0xa5160156,0xbd810222}},	//   _llundain_, _vlastima_, _ביעלסקי_, _jugement_, 
   {{0x0320020b,0x4dd4004c,0x30650183,0x804c0350}},	//   _bonya_, _amukemye_, _antanifo, _የአልሸባብ_, 
   {{0xc7b60032,0x358900e6,0x9f5b02a2,0x4f4f0251}},	//   _biruchni, _劳动教养试行办法_, _silangan, _nooshaha, 
   {{0x2fe102d4,0xd2cb0004,0x125b01f1,0x352701e1}},	//   _turistic_, _pradel_, _komentim, _галстукт, 
   {{0x69240126,0x00dd017a,0x59870261,0x42b6003d}},	//   _власну_, _abonakel, _aneksita_, _bauces_, 
   {{0x53f90028,0x337c012e,0x939603c9,0x428c0521}},	//   _درامٕژ_, _gergely_, _satses_, _bankën_, 
   {{0xb52501cb,0x32b50461,0xd2f50024,0x23860269}},	//   _ukuzizuz, _basco_, _grunnar_, _sufre_, 
   {{0x2581047d,0xf20201ce,0x337902fb,0x9e6f0109}},	//   _begeesch, _asring_, _ikuanga_, _hodoníns, 
   {{0x6e350462,0x2fd50013,0xc5d5020a,0x2b7503da}},	// [d40] _impactwa, _турарди_, _алакөл_, _ogaranya_, 
   {{0x0ece0046,0xc1830142,0xfda70188,0x1cf80045}},	//   _таластык_, _सर्वत_, _унсурҳои_, _исламске_, 
   {{0x579e03c2,0x06f60287,0x827f033d,0xa6730235}},	//   _certifyi, _कतिवटा_, _mounn_, _प्रथमानि, 
   {{0xb2640319,0x4f3b0322,0xe27f03f6,0x1e45001c}},	//   _বিনামূল্, _amageren, _pouna_, _makasaga, 
   {{0x92ca023e,0xe2d401c8,0x80ce0060,0x33780128}},	//   _ngalami_, _realitu_, _пошталық_, _safarda_, 
   {{0x2905042f,0xd05b018d,0x22a704a8,0x603c00f7}},	//   _ahiatigu, _ኣልጀሪስ_, _trebas_, _amatoroj_, 
   {{0xcdbd00c7,0x0e50030c,0x3e6001d5,0xb758012e}},	//   _arasında_, _kaasiliq, _بیرسٹر_, _prohardv, 
   {{0xec7503b2,0x1ef100ec,0x00000000,0x00000000}},	//   _herself_, _narkotin, --, --, 
   {{0x5be7034f,0x40f903e6,0x31cd0538,0x11cd0086}},	//   _ارادې_, _barbudok_, _godtfolk_, _akadály_, 
   {{0xc3480494,0xc2d704ec,0x36af034e,0xf37e0156}},	//   _kineski_, _impongo_, _chutariy, _אויוונס_, 
   {{0x5dc3009a,0xef1700c1,0x00000000,0x00000000}},	//   _bemitsha, _perdanan, --, --, 
   {{0x2a0603a2,0x06300188,0xbf3e047b,0x149d0011}},	//   _एयरएशिया_, _забонӣ_, _avhongur_, _babasinz, 
   {{0x6c9600c5,0x839502c3,0x33eb0020,0xee180137}},	//   _重要思想为指导_, _opasok_, _soatau_, _хониноос_, 
   {{0x6202053f,0x03280125,0x119c0107,0x58c700d1}},	//   _kusist_, _халычыла, _دلالی_, _তকৈয়ো_, 
   {{0x32d60116,0x239500fa,0xa788021b,0x674e0092}},	//   _ottoman_, _ipasok_, _запланир, _関連リンク_, 
   {{0xde1b0158,0x6ac6016a,0x19f6043e,0xc6b002c7}},	//   _पैकेजिंग_, _הימלער_, _abuín_, _gerechtf, 
   {{0x4f640482,0xa06b020f,0x0436012c,0x364401f9}},	// [d50] _madabiin, _معاصرو_, _kuchapik, _etikwesi, 
   {{0xf64a01aa,0x4a4400ee,0x4ce80129,0x7ea20120}},	//   _optionsw, _diseinua_, _tukwasir, _marrowte_, 
   {{0x65f600c5,0x25ce01ea,0x1694033b,0x927e003a}},	//   _sélectio, _хамма_, _sekereni, _zimni_, 
   {{0xc2e803ee,0x0a4704bd,0x424a009b,0xcdb0006d}},	//   _odlican_, _kekemapa_, _дийлдэшг, _бажнiцу_, 
   {{0x62bb0044,0xce8f0148,0xe35d0059,0x91b40126}},	//   _entered_, _路透社圖片_, _посолств, _автобусі, 
   {{0xf5cf01a9,0xbb570217,0x79aa0204,0xd5670053}},	//   _líquido_, _septanta_, _пошив_, _इतिहाससं, 
   {{0x675a0037,0x3e520135,0xdc7c008d,0x12ef000d}},	//   _አደቆርሳ_, _remontlı, _asarlar_, _sündis_, 
   {{0xa2f30478,0x76730235,0x00000000,0x00000000}},	//   _apareish_, _प्रथमावि, --, --, 
   {{0xc1590052,0x00000000,0x00000000,0x00000000}},	//   _kroužkov, --, --, --, 
   {{0x62d8009d,0x91df01b9,0x430f0184,0xeac00255}},	//   _behet_, _biznessm, _arubaka_, _vaikimis, 
   {{0x524801ec,0xa7de004d,0x2f610033,0x00000000}},	//   _dekorasi_, _本站最佳分辨率_, _chapella, --, 
   {{0x42310041,0xd35401dc,0x8a8c01d9,0x7f3e00f5}},	//   _jazmín_, _maletgs_, _burnings, _сайламак_, 
   {{0xcf23020e,0x4ce9027e,0x0ca7006c,0xcd8f013a}},	//   _bokellan, _вечност_, _ahiyezer, _vileicht_, 
   {{0x02ba04f8,0x625e0061,0xe3950243,0x7d29019e}},	//   _modeled_, _우리결혼했어요_, _sarse_, _анёлаў_, 
   {{0x60860041,0xac2d03e4,0x125b0125,0xfd7e00c1}},	//   _алингвис, _maratpac, _batly_, _alamenda, 
   {{0x9c7202ac,0x5be70364,0xea590144,0x3b660137}},	//   _ودخلت_, _asselbor, _chugatsa_, _ширтэх_, 
   {{0x4c040285,0xd3640043,0x2b9d04ae,0x657702cf}},	// [d60] _kubungab, _alagula_, _транзита_, _фантазиј, 
   {{0x918204fd,0x762202c3,0x133002d5,0xb2c100a8}},	//   _एआईसीटीई_, _kanalizá, _निकम्माप, _vallada_, 
   {{0xa8dc009b,0x22000116,0xf22f059a,0x19cd000c}},	//   _хуний_, _flail_, _câmbio_, _enteroit, 
   {{0x87c90092,0xf27f0127,0x8bb60019,0x00000000}},	//   _明けましておめで, _bignas_, _жикчил_, --, 
   {{0x4c3201f4,0xea5a02ac,0x726d01d9,0x635502c6}},	//   _гўштини_, _éagórach_, _gevote_, _gemerer_, 
   {{0xb815032d,0x71c20462,0x047d01b7,0x227f02f7}},	//   _булараҡ_, _oredstay_, _मधुना_, _founo_, 
   {{0x92fc0118,0xef030079,0xe30c0249,0x0291005b}},	//   _mbaga_, _emocijas_, _hamamas_, _ameana_, 
   {{0x429b006a,0x417f0021,0xf0b502ac,0x6ccb0291}},	//   _nankany_, _adminway_, _tromlach_, _لعائلة_, 
   {{0x60dd0382,0x1512001b,0xdc7302ae,0x29f000d9}},	//   _khonkhel, _gugurdoo_, _jamstva_, _pannulla_, 
   {{0x3f27012a,0x584c0192,0xf2d80251,0x62910388}},	//   _सरबजीत_, _이었습니다_, _meher_, _avrai_, 
   {{0x6cdf04cf,0x43860288,0x826d00e4,0x36a402fd}},	//   _ikakhulu_, _aufri_, _ozdoby_, _carraigh, 
   {{0x23ea0119,0xeffe003a,0xa9d001f4,0xd2fc02e7}},	//   _poitou_, _газетаси_, _шерик_, _abaga_, 
   {{0xd386059b,0x329b0183,0x3eb701ac,0xb2fc003a}},	//   _jufri_, _mankany_, _براتز_, _yengil_, 
   {{0xed620073,0x720503b9,0xcebc0206,0xd32200a4}},	//   _diaboliq, _kamisaki_, _vodotesn, _fiscals_, 
   {{0xcc660077,0xc3340268,0x3e6b0050,0x3dce0040}},	//   _anatòt_, _airchay_, _abdoménn, _סוככים_, 
   {{0x827e013f,0x9b3c004d,0x036f0585,0x24fb0235}},	//   _hienn_, _台北市文山區興隆, _nastojim, _कौमारी_, 
   {{0x60110238,0xd3110073,0x7497005e,0x60ef0418}},	// [d70] _неподалі, _mascule_, _чақмақ_, _muhakkak_, 
   {{0x2ed101af,0x62d802a8,0xcb7b01f0,0x2c2a0153}},	//   _arazmuha, _deher_, _gaisanya_, _passions, 
   {{0xd69a02ba,0xb36c034b,0xa2c90037,0x636801df}},	//   _хатарнок, _nuigini_, _ከእርስዋ_, _mangles_, 
   {{0x727e0023,0x56fb032c,0x87ba00d1,0x9361029e}},	//   _toinen_, _specialf, _উত্তাপিত_, _dargemm_, 
   {{0x820000c3,0xada60076,0x1ae500ea,0xc7a5030a}},	//   _aliis_, _планинат, _aterinet, _destruci, 
   {{0xd24a00b4,0x89aa0244,0x2b7b0455,0xc0ec03f2}},	//   _drumul_, _топик_, _covoitur, _radikaal, 
   {{0x429001bb,0x9b380022,0xdc0700a4,0x658a010f}},	//   _almana_, _процеста, _cadascú_, _babelokh, 
   {{0x53950141,0x208b022a,0x0c740025,0xd29000b7}},	//   _narsa_, _tuscaloo, _शास्ता_, _almaga_, 
   {{0x927e01a7,0x527f04b2,0x38630405,0x0d0c03f7}},	//   _hieno_, _anung_, _водами_, _borðplöt, 
   {{0x17b203bf,0xf2d80312,0x48c700f0,0x7c600006}},	//   _этабы_, _aprouet_, _skrutkov, _sedunia_, 
   {{0xf42e029d,0x23950122,0x927f04f1,0x00e70132}},	//   _епископи, _karsa_, _signis_, _کانشانہ_, 
   {{0xcc40006d,0x526e0514,0xf6d900fa,0xcd1c0046}},	//   _абурана_, _ripoza_, _gambalai, _recollit_, 
   {{0x9b840145,0x4a0e037b,0xfb610209,0x42ba0166}},	//   _апроч_, _corazone, _aqiliner, _lagernd_, 
   {{0xd32004ee,0xa27e04b9,0xf302013c,0x037a0127}},	//   _konye_, _anent_, _musayev_, _binarel_, 
   {{0xe20003d9,0x8c3f0037,0xd39b036c,0xe8740096}},	//   _alaim_, _ተቀላቀሉ_, _hijangaj, _batishyu, 
   {{0xd67b0019,0xd2f401af,0xf2000334,0xa2e30012}},	//   _تىزەدەن_, _ahtimal_, _blaim_, _लेतीह_, 
   {{0xb4b00185,0x24c10041,0x66c30196,0x830d02cd}},	// [d80] _başlawın_, _ҟәшахьы_, _chosinth, _gamayar_, 
   {{0xa2f00393,0x22ca02fb,0x29ec01d4,0x930e051a}},	//   _bolovanj, _isileli_, _acconcia_, _munafiq_, 
   {{0x0a2000d7,0x27f3033a,0x49c8025f,0x727f007b}},	//   _темпы_, _maħżen_, _kokotisa_, _gouns_, 
   {{0x3f2f0377,0x1d5800d7,0xedfc0021,0xb39b0403}},	//   _corespun, _сәсле_, _albeitwa, _fijangaj, 
   {{0x35850312,0xb39500a2,0xf2e6015e,0x137a0084}},	//   _tierniez, _darsa_, _amanida_, _amparan_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x127f015e,0x951f018d,0x004602a4,0x741700c6}},	//   _lluny_, _ተጠቂሙሉ_, _sarracen, _frisyren_, 
   {{0x127f01b2,0xb59402c0,0xcc4a0052,0x1f350156}},	//   _drench_, _студенит, _भावनामा_, _װעבזײַטל_, 
   {{0x22ca00bd,0x177f014f,0x73f100d7,0xe2f5007a}},	//   _gilded_, _поправку_, _dibekeng_, _ditikam_, 
   {{0xbc4402d4,0x02f102c9,0x7292018d,0x7a6c0022}},	//   _inscuntr, _parinti_, _masave_, _уллин_, 
   {{0x7c140223,0xd9f601aa,0xbfa10189,0xb95504b4}},	//   _segurtas, _istrictd, _aksesuar_, _kollegae, 
   {{0x724602af,0x727e022f,0x4200012d,0x3108009a}},	//   _yémen_, _vieno_, _ilaik_, _amakrwal, 
   {{0x4da70205,0x4cc703f8,0x7cb10357,0xa34701fa}},	//   _والدیه_, _danidchu_, _monasavu_, _meletoa_, 
   {{0x5af60305,0x839402ca,0xd3dc033d,0x4d81008f}},	//   _sterkast, _annseo_, _echwe_, _avaldata, 
   {{0x366701cd,0x4d8b0510,0xf43c002b,0x00000000}},	//   _артиши_, _аппетита_, _নিবিড়_, --, 
   {{0xefa00191,0xd2000249,0x32c400ca,0xa17d059c}},	//   _underbar_, _plaim_, _bellaud_, _olivenöl_, 
   {{0x52b50478,0x7edb0433,0x6eb20364,0x94e4011a}},	// [d90] _basca_, _aguillos_, _autobunn, _ראומטולו, 
   {{0x127e01ef,0x52e900a0,0x427f0564,0x2c3400d9}},	//   _pieno_, _addinan_, _touns_, _тянет_, 
   {{0x1290044d,0xf30c027b,0xc3010331,0x8c1d013c}},	//   _tombeaux_, _amanāpāṃ_, _varandi_, _hesablar, 
   {{0xc23701c5,0xe9b701d5,0x9297038e,0x89c30059}},	//   _waajib_, _باآسانی_, _jenjang_, _aumentat, 
   {{0xd84a00be,0xf92e0148,0x4d2c02ea,0xde4c001c}},	//   _сотко_, _隱私權保護政策_, _caricate_, _makalana, 
   {{0x2f920191,0x927f0124,0xf3f9034e,0x52000455}},	//   _ungdomar_, _youns_, _adyus_, _clair_, 
   {{0x13070179,0x33470049,0x2f0401d7,0xf9a401c8}},	//   _aalburg_, _feletoa_, _survegna, _povinnéh, 
   {{0x6e060012,0x95a700e7,0x8d2500e6,0x3f3e059d}},	//   _आनकरउदूस_, _anishkak, _黑道女友i_, _kharisma, 
   {{0x7ef001b2,0x230200fb,0xae720178,0x469b0037}},	//   _bickerin, _akubone_, _ananyopā, _መመካከር_, 
   {{0x52ba018b,0x7f090128,0x72d80151,0x9f1100fa}},	//   _inteleg_, _бюджетга_, _aghee_, _alitapta, 
   {{0xb356013d,0x9297003c,0x5b8702c7,0x00000000}},	//   _esperas_, _benjing_, _dominier, --, 
   {{0xa5f50420,0xd76a01be,0xe37903c3,0x3265019b}},	//   _lideranç, _मिश्रले_, _disanja_, _patogiai_, 
   {{0xe27e0450,0x9648017a,0x70f601db,0x02e90251}},	//   _giene_, _abangezw, _балтық_, _gedisan_, 
   {{0x46550285,0x122a006d,0xa0370155,0xb71e009b}},	//   _amakimbi, _ботам_, _bukefalo, _чавга_, 
   {{0x717f0238,0x3544004d,0x3d3c052b,0x0202018b}},	//   _останній_, _地理資訊系統_, _फ्रॉम_, _rusine_, 
   {{0x8cc2003a,0x052c02ec,0x4288031a,0xe9c10066}},	//   _عبدالودو, _wabilaah, _leahbar_, _desegite, 
   {{0xa2670318,0xbb77040e,0x6a02005c,0x90940234}},	// [da0] _holomimi_, _feiringa_, _baravuga_, _àbòsí_, 
   {{0xd27e0244,0xda160044,0xc990027f,0x99e10476}},	//   _viene_, _purchase, _arakazit, _adhonija_, 
   {{0xe27e01c6,0x0f810255,0x7d7f042a,0xd2d00085}},	//   _wiene_, _मक्की_, _alamanye_, _joketani_, 
   {{0xb27e024b,0xab9102ac,0x5c3a0274,0x70e600c1}},	//   _tiene_, _الشئون_, _alfreð_, _उंचीची_, 
   {{0x0c9304dc,0xbf380041,0x2ac100b4,0x8ebf014a}},	//   _داماو_, _atãva_, _ынтылнир, _adásvéte, 
   {{0xb29702c2,0xa6b3059e,0xb2040148,0x52d803b0}},	//   _eenkant_, _kulendaw, _periculi_, _avleia_, 
   {{0x6fae0074,0xe0e80409,0xe7a80416,0xcb76002f}},	//   _совершен, _oprindel, _centupli, _atillanc, 
   {{0x36440061,0x00000000,0x00000000,0x00000000}},	//   _필수자료실_, --, --, --, 
   {{0x5c2704f2,0x126c00ea,0x124f0357,0xc9580350}},	//   _vinaviec, _rahona_, _sogolati_, _ማቅለምምን_, 
   {{0x82e301d1,0x8c7e005b,0xdbd600cb,0xa2020577}},	//   _arrived_, _ageshio_, _amametro_, _musime_, 
   {{0x271200ff,0x3d830109,0xd2f10037,0xde5d03fe}},	//   _פֿרױען_, _बोलउनुपर, _varieti_, _бахча_, 
   {{0x42e20218,0x2ead059f,0x1e4d0151,0xd2cb0275}},	//   _anetplay_, _januzajt_, _bigamist_, _solofua_, 
   {{0x6d440379,0x26ac004d,0xbc5501eb,0x8c39008d}},	//   _अतिरिक्त_, _二十四詩品_, _imitame_, _ҳайкалта, 
   {{0x73790359,0xb1e305a0,0x927e0176,0x05d8004d}},	//   _televyzj, _साधरण_, _riene_, _電腦軟硬體_, 
   {{0xfda302c4,0xe2d900bc,0xb61000dd,0xd89103d5}},	//   _формира_, _lepen_, _cholledi, _basketfu, 
   {{0x727e022d,0x42d701e0,0x4dd70291,0x8efc0143}},	//   _piene_, _دکارن_, _افدتك_, _архитект_, 
   {{0x5d760251,0x85ee0371,0x923500ba,0x8316028d}},	// [db0] _ترانا_, _апартаме, _خۆسووتان, _manze_, 
   {{0x73160190,0xf29203bf,0x430f03ef,0x4b6d0272}},	//   _lanze_, _assaad_, _asubiza_, _aliroopa_, 
   {{0xf348035b,0xc2f900ba,0x1248033e,0x00000000}},	//   _besedah_, _ستۆری_, _maimbe_, --, 
   {{0xe82c05a1,0x8b0e035b,0xa23b033f,0x892e016f}},	//   _སྒྲིལ_, _čistila_, _koheleti_, _покатати, 
   {{0x03860082,0x8e4f033f,0x7cbc015e,0x12250415}},	//   _afirka_, _angapala, _алтайдан_, _sockel_, 
   {{0xb2fc02fd,0x892a0207,0x3e4300dd,0x00000000}},	//   _dcigh_, _فرمائڻ_, _deisebau_, --, 
   {{0x8ecf024e,0x1a6302ac,0x857e00e6,0x44870143}},	//   _socijaln, _ليفينج_, _优化发展环境_, _дизела_, 
   {{0xaafd01d9,0x652700d9,0x0b0204b9,0x07a10071}},	//   _usergale, _кажется_, _chestnut, _خشکبار_, 
   {{0x7b0202f0,0x52e300d9,0xd27f0077,0x29a201d7}},	//   _akusonge, _kimille_, _gouni_, _brüngger_, 
   {{0x641d010e,0x1d4d0311,0x23f90007,0x0e5402fd}},	//   _akusahan_, _ዝመለለይኡ_, _mabulu_, _phoblada, 
   {{0xe1b000d4,0xbd850338,0xe27e0210,0x43430078}},	//   _riemersm, _defendre_, _aneni_, _домова_, 
   {{0x91790059,0x959500b5,0x529102c9,0x0f240026}},	//   _триъгълн, _jesuitak, _aleasa_, _instelba, 
   {{0xef3e007e,0x6a6c05a2,0x752b0203,0x027f0211}},	//   _क्रियाः_, _देवघर_, _scrimach, _jouni_, 
   {{0x340000b9,0x9e920126,0xa1480009,0x729101ac}},	//   _नामदेव_, _порталі_, _nestrpno, _cleasa_, 
   {{0x546a013d,0x907504e3,0x22da0075,0xbdb20399}},	//   _televido_, _doživio_, _umseta_, _lulululu_, 
   {{0x7ac200c4,0x82ca0099,0x629001c5,0x609d019c}},	//   _عبدالقدي, _bildad_, _ilmaha_, _fifaṣẹfu, 
   {{0xc9a500f5,0x2ecb040b,0xe5b00343,0x55c100d1}},	// [dc0] _алдаҗак_, _tshinnan, _giestrik, _আইৰিছ_, 
   {{0xe3580226,0xf953029c,0x693b0311,0x00000000}},	//   _akagule_, _analembe, _ዝተሰነደ_, --, 
   {{0x9e83002a,0x3bd4027e,0xa74300c5,0x053a0142}},	//   _akawanye_, _федералн, _公安消防机构应当, _anindriy, 
   {{0x81a502b7,0xdf3e01b7,0x46f101be,0x2f35032b}},	//   _danzapä_, _क्रियां_, _सातवटा_, _ئۆتسەم_, 
   {{0x32f2014e,0xe75905a3,0xe3100021,0x226c01f7}},	//   _letovanj, _मात्रिक_, _anyatay_, _arioan_, 
   {{0xda1b0037,0xc290008d,0x5d7501db,0x00000000}},	//   _መድረሳቸውን_, _kuzatilm, _سوزشى_, --, 
   {{0xc75e0255,0x6319028a,0xc4ea018d,0xf14e02a2}},	//   _कम्पनियन_, _بيتاب_, _ብኢሰያስ_, _sigurado, 
   {{0x56c30040,0x9e4c009b,0xa9da0139,0x00000000}},	//   _biosynth, _sakabana, _प्रवहति_, --, 
   {{0x3397022f,0x2e0200ec,0x42900312,0xdeb200f6}},	//   _renginyj, _pabendra, _endalc_, _diplomun, 
   {{0x202a00bf,0xf27e0585,0xfa7d0210,0xc365031c}},	//   _наполнен, _radnik_, _asingats, _dragón_, 
   {{0xcc5b0315,0x30a9027e,0x05850362,0x7193019f}},	//   _ahlunge_, _мирослав, _akotisak, _وحشتون_, 
   {{0x42fc0046,0x2f61006c,0xa7290149,0x23f90079}},	//   _camions_, _abaphola, _nkanụzụ_, _labumu_, 
   {{0x0459018d,0x5320001f,0x00000000,0x00000000}},	//   _ካርቱምን_, _wonya_, --, --, 
   {{0xdcd600da,0xba850162,0x2d0302ea,0x37790157}},	//   _патруля_, _турлук_, _annullar, _विजयनगरम_, 
   {{0x7a8b0321,0x02910342,0x29fe009b,0x63200004}},	//   _maribors, _eleaza_, _esanahia_, _konyn_, 
   {{0x723d03c4,0x527e0044,0x55e30092,0x7c1f0185}},	//   _бөлүмини, _phones_, _白石麻梨子_, _başlíça_, 
   {{0xac4f0193,0x0c5500d7,0x9c75027b,0xd8b8004d}},	// [dd0] _कंपनीला_, _bultswe_, _समर्थो_, _第四十一條_, 
   {{0xfc040105,0x5cd70163,0xfe560235,0x54070004}},	//   _konsoli_, _وعیال_, _athopakā, _ekoulman_, 
   {{0xe30e0054,0x26ea00bf,0x377c01ef,0x7c67030a}},	//   _ziyarar_, _подписки_, _кантакты_, _teatros_, 
   {{0x830e0054,0x05440094,0xa20703ab,0x4eab01c4}},	//   _siyasar_, _تىلەيىك_, _demontáž, _kolossen, 
   {{0x9313022e,0xaf980019,0xd27e0396,0x8f3502e0}},	//   _mancava_, _петуния_, _jiena_, _dibukana, 
   {{0x727e0145,0xf30f0233,0x02570156,0xf2130062}},	//   _diena_, _borator_, _װײַסן_, _lughqu_, 
   {{0x139d0071,0x63ac05a4,0xe6560196,0x00000000}},	//   _کتابچه_, _hospod_, _kuphiphi, --, 
   {{0xbe4e0238,0xd34a00cd,0x79f300ca,0x715200be}},	//   _морально, _abstrahà_, _apareigu, _سەرتكە_, 
   {{0x227e02e4,0xf99c03bf,0x7dc50400,0x00000000}},	//   _gieni_, _грецияла_, _artisgia, --, 
   {{0x9da900f1,0xf27f033f,0x9fa80052,0xcb7801f3}},	//   _ladifera, _mounu_, _prumyslo, _evakuačn, 
   {{0x23c90272,0xafa5014d,0xec97000e,0xa29e0211}},	//   _akawumbi_, _sprecher_, _obtrusiv_, _силах_, 
   {{0x929204c0,0xcee70250,0xe1d60040,0x430d0040}},	//   _aduasa_, _dashurin, _השמאלית_, _פייפל_, 
   {{0x2a8002e7,0x8a0500a6,0xbfb501b2,0x15f700c7}},	//   _atensyon_, _bayazife, _barleyco, _eskertlä, 
   {{0x192a0148,0x95900113,0x18f500e2,0x30c503b0}},	//   _隱私權聲明_, _litearth, _ferantwu, _velledal, 
   {{0xae8c017d,0x6ef40074,0xa60c017f,0xa7c50026}},	//   _ウェブ検索_, _merkitys_, _akimmiff, _overleef, 
   {{0xd2ca05a5,0x4ed10203,0x288a009a,0xd63e0315}},	//   _pridal_, _cornicos_, _bakhumbu, _bhalisiw, 
   {{0x83080046,0x1f2001fb,0x3eb203b4,0x6200008c}},	// [de0] _исламдын_, _devenien, _amborion, _plaiv_, 
   {{0x726800a2,0x7af0016a,0xf5c40235,0x00000000}},	//   _صوبدار_, _allogajn_, _digbandh, --, 
   {{0x6369055c,0xee3f0024,0xe3f801fe,0x4200038e}},	//   _mangler_, _মেৰামতি_, _lumuta_, _doain_, 
   {{0x8f770461,0x73730455,0x827f032d,0xdc5301c5}},	//   _tractats_, _arnaque_, _founu_, _guutada_, 
   {{0x806100cb,0xec5301c9,0x00000000,0x00000000}},	//   _akusadin, _rattaga_, --, --, 
   {{0xe25a0258,0x294700be,0x89020486,0x8f920450}},	//   _fielde_, _دۇۇماندۇ, _startér_, _needwaar_, 
   {{0x552b0041,0x81ae018d,0x7c5c0040,0x634e02a1}},	//   _анҧҵара_, _ከይንኸውን_, _ולעתים_, _ongemak_, 
   {{0x2d0c031f,0x23e50100,0x091d0137,0x63f80184}},	//   _formidle_, _napuniti_, _уяраав_, _rumuva_, 
   {{0x625a0192,0xb7ec033f,0xf2d001d6,0x8b660272}},	//   _snelle_, _halamang, _skylder_, _antumira_, 
   {{0xd27e018a,0xd01e044b,0x7db20240,0x7d3d05a6}},	//   _rieni_, _forventn, _bulubulu_, _kopirett_, 
   {{0x93000139,0x2c93040b,0xa200047d,0xb2510333}},	//   _aagaami_, _mukegulu_, _flait_, _tintarel, 
   {{0xb12c0156,0x6d50027e,0xe33b0398,0x57e80235}},	//   _מלבושים_, _зборник_, _donarà_, _cetanatv, 
   {{0x65370199,0xded10044,0xeb7e004a,0xd15d011a}},	//   _anninhth, _channels_, _avgustka_, _etiology_, 
   {{0x8c0904dc,0xc73a03c4,0xa6d800e6,0xf34e0179}},	//   _بوودنه_, _мәһкимис, _上海市公安局杨浦, _tudelik_, 
   {{0xa2c100fb,0x2daa0446,0x30e60299,0x9b710291}},	//   _esilula_, _debitira, _بۆشۈكى_, _التذكير_, 
   {{0xf27e03ad,0x6773008d,0xf26c0318,0x9a3e0156}},	//   _tieni_, _моллари_, _mahoaa_, _יוניאָן_, 
   {{0x6eb50168,0x814501f4,0x96d001c0,0x6e1a0187}},	// [df0] _redusert_, _суонси_, _alkalami, _романски_, 
   {{0xb0d20148,0xceb0010f,0x74c10227,0x53eb0105}},	//   _已經本網授權使用, _ahlukene_, _membisik, _wiatru_, 
   {{0xc2da0244,0x727f01b2,0x0af20005,0xbb7a0204}},	//   _tornare_, _fount_, _mazzetta_, _varrella_, 
   {{0xc5c80076,0x85f90178,0x9230040f,0x427e011a}},	//   _нареднат, _avaniṃ_, _sumušė_, _מושקעת_, 
   {{0xf38c012c,0x38cc0325,0x63790360,0x23ea0397}},	//   _maishani_, _birdənəm_, _ukradla_, _махмудчо, 
   {{0x82d9018c,0x02fe03a8,0xd3030147,0x858201d9}},	//   _texel_, _avsides_, _كۅردۉك_, _gewensch, 
   {{0x7ebc043a,0x1e4b020f,0x3abb018d,0x6109002b}},	//   _lotedels_, _alibabop, _ህግድፍን_, _কলকাতায়_, 
   {{0xc3200176,0xbd3401fb,0x4c7c02f3,0x1ef200a6}},	//   _ponyo_, _evanesce_, _konsten_, _anokukun, 
   {{0x637a026b,0x83f401fb,0x2ae40109,0xfebb00f0}},	//   _caballo_, _tertie_, _पाउरोटी_, _potrieme_, 
   {{0x427e001f,0xee68004b,0x235500ce,0x9266026c}},	//   _mienu_, _табиптар, _lemeyer_, _antonini_, 
   {{0xf2820242,0x1da70349,0x1c760305,0x77ee01e8}},	//   _şahidi_, _acticedp, _draumar_, _gitabang, 
   {{0x12dd00ab,0xee1a0452,0x15b1027b,0x506802f9}},	//   _popongi_, _मनूबाबा_, _नरकतिर्य, _mwayenaj_, 
   {{0xb2000578,0xf2e501b8,0x7233035b,0x3cc40087}},	//   _hlais_, _erineva_, _spomnim_, _letikulu_, 
   {{0x59e70234,0x0e960162,0x3300023d,0xcc060265}},	//   _adegboye, _مىتىر_, _ricambi_, _tentoons, 
   {{0x1c7d0089,0xc26e0076,0x00000000,0x00000000}},	//   _apastan_, _pipoca_, --, --, 
   {{0x52bb041e,0x8bd20452,0xd42d0010,0x6dba0153}},	//   _agguantà_, _छोटया_, _kukhonak, _なんですね_, 
   {{0x62f40249,0x274102d3,0xecae002b,0x2387044d}},	// [e00] _merikel_, _источна_, _আমন্ত্রি, _enerci_, 
   {{0xb27e03d1,0x5f55019b,0xe34f0243,0x52d80120}},	//   _dienu_, _становіш, _ittenik_, _lehey_, 
   {{0x69e20069,0x40530264,0xf8100373,0x699a021b}},	//   _kuboneka_, _preseden, _precizig, _бисеропл, 
   {{0xa316016b,0xa3050060,0x00000000,0x00000000}},	//   _canza_, _موشان_, --, --, 
   {{0x41c50338,0x1f930191,0xfdff00db,0x3c750222}},	//   _florença_, _vardagar_, _aksessua, _refuser_, 
   {{0x125b0206,0xcaba0311,0x531703c6,0xab5e0022}},	//   _umelé_, _ዝውዕልን_, _monargy_, _ораны_, 
   {{0x52070160,0x5b87032d,0x42000279,0x2f4b0285}},	//   _istinski_, _bomolimo_, _plait_, _amasashe_, 
   {{0xde5002c3,0xc03c000a,0x5320018a,0x2e7801e1}},	//   _financie_, _amigarso, _ennyd_, _блокадаһ, 
   {{0xe4e10287,0xa61d01a3,0x327e01bc,0xd9e600c3}},	//   _राजभण्डा, _سهاڳڻ_, _mient_, _maturand, 
   {{0x227e009a,0xc27e0079,0xa316044a,0x431c00ca}},	//   _lient_, _ikonas_, _sanza_, _carbons_, 
   {{0xd9e202c1,0x22910200,0xba7800dc,0x93dd029b}},	//   _buboneka_, _umeala_, _mualepos, _itewoo_, 
   {{0xd5a50169,0x6396001d,0xe145005d,0x52f40064}},	//   _গুগলের_, _cessat_, _мурман_, _spanair_, 
   {{0x8f2d03b2,0x69fa019b,0xd36803c2,0x75930204}},	//   _determin, _svarbiau, _tangles_, _itsemurh, 
   {{0x7f9605a6,0x1654034f,0x497f007f,0x068201b5}},	//   _nordover_, _afunyenw, _breichle, _huweleri, 
   {{0xb757000c,0x9d8f01c2,0x2ead02cf,0xa3f801f5}},	//   _даниель_, _homenaxe_, _мотивира, _bajuku_, 
   {{0x15c10242,0x22d703ce,0x0abb018d,0xdb7b00e6}},	//   _sevirəm_, _تکاره_, _ህግዲፍን_, _公房承租人_, 
   {{0xa27e03f3,0x3d06016d,0x0aa50360,0x689e0172}},	// [e10] _dient_, _شوپۇر_, _cukroví_, _wonkunku, 
   {{0xd27e05a7,0x5e480219,0x82d901be,0x5654034f}},	//   _vienu_, _bekacaba, _sexem_, _efunyenw, 
   {{0x5c2d00b2,0x467a020e,0xe379008c,0x563c011a}},	//   _barabaac, _dinkutlw, _cafanun_, _ואוזניות_, 
   {{0x263c03f5,0xf1cd0041,0xfea3029f,0xd81f0156}},	//   _nacionai, _дшьуп_, _doprajte_, _נוטריקול, 
   {{0x968f002b,0x5a020343,0x67ba0161,0xd28b0299}},	//   _টিপাইমুখ_, _igbalukt, _развивал, _رىتسىپى_, 
   {{0x6a060416,0x718e01b2,0xb41300ba,0x655102ea}},	//   _camarade, _arramish_, _یاڵدا_, _convocaz, 
   {{0x525b0396,0x83ea001d,0xecb80155,0x3db80155}},	//   _tielet_, _geotek_, _begagnad_, _begagnat_, 
   {{0xedb4024c,0x7de300c7,0xe75c05a8,0x32d101f3}},	//   _antiċipa, _аллаһыны_, _komibeng, _postrach_, 
   {{0xbc710163,0x42cb00b4,0xe2950043,0x3ad20168}},	//   _دھیان_, _gradul_, _arrahiim, _skatteet, 
   {{0x05020220,0xea8f0002,0xa20002bd,0x703b014a}},	//   _iscritto_, _odličan_, _enaid_, _jégkoron, 
   {{0x23160082,0xdd70002b,0x9aed0022,0x427f0370}},	//   _manzo_, _কাশ্মীরে_, _башлауға_, _ciung_, 
   {{0x92f10453,0x9105023a,0x00000000,0x00000000}},	//   _navikli_, _guličky_, --, --, 
   {{0x05180220,0xc2e6008a,0xc2e90175,0xd6bb012a}},	//   _verranno_, _atanaga_, _mazinen_, _zidentyf, 
   {{0xe9fc05a9,0xfca90078,0x054102fe,0x37b4015c}},	//   _iyandika_, _поставим_, _بیکاره_, _mettlerw, 
   {{0x3c060064,0xd1050365,0x42d402ef,0x1dba0119}},	//   _майрам_, _kuličky_, _boudam_, _katiguba, 
   {{0xe063018b,0x9248005e,0xb3470095,0xd42d0059}},	//   _молотов_, _قەلىپداش_, _قادرند_, _dinamico_, 
   {{0x2c7c00b0,0xd9e202c1,0x5cf900ba,0x03160342}},	// [e20] _taasina_, _ruboneka_, _باوباپیر, _kanzo_, 
   {{0x7951009a,0x8f6705aa,0xd2300310,0x32f30155}},	//   _abalulut, _tropiske_, _chamara_, _logiskt_, 
   {{0x829401e9,0xd20004a4,0x0c710421,0x6a150326}},	//   _bookami_, _ciiig_, _bedroht_, _chichava_, 
   {{0xa5440156,0xfe5d0350,0x00000000,0x00000000}},	//   _ראמאעלד_, _አልታወቁም_, --, --, 
   {{0x2320001f,0x52d8019b,0x22f2044a,0x00000000}},	//   _annye_, _kelionę_, _kiniamu_, --, 
   {{0x620003ec,0x06cc00e2,0x93b50299,0x82ea0011}},	//   _anaid_, _eksplisy, _ئىلھامى_, _babiito_, 
   {{0xe80000c5,0x227f0017,0x9c120421,0xa9980050}},	//   _胶南市安监局_, _louny_, _teppich_, _arboréal_, 
   {{0x25b90291,0xce530084,0xebbc0156,0x17860235}},	//   _فودافون_, _tatangka, _נינדזשאַ_, _पर्वता_, 
   {{0x8cc004d8,0xd290035b,0xbae6016d,0x92fe024c}},	//   _دیوانگی_, _pomaga_, _قۇملۇق_, _debitur_, 
   {{0xb1450373,0x82c70242,0x12020044,0xa50300bb}},	//   _distanco, _azalıb_, _varied_, _امرےکی_, 
   {{0xe84401d1,0x48f10360,0xfbe6035d,0x5557041e}},	//   _listings_, _inspirov, _gledalac, _ammintà_, 
   {{0xcc73029a,0x227f01da,0x827f00bc,0x02e900b4}},	//   _chargos_, _planin_, _ngendi_, _marimea_, 
   {{0x287502eb,0x41de0185,0x00000000,0x00000000}},	//   _олимпын_, _ivanoviç_, --, --, 
   {{0xb3870105,0xdee9004d,0x00000000,0x00000000}},	//   _piersi_, _真希望往後不要再, --, --, 
   {{0xbe4b0381,0x86440080,0xa9f60119,0xe426025a}},	//   _aptainca, _atikitsi, _pumakadt, _ubahiriz, 
   {{0x22f9033e,0x3db60381,0x00000000,0x00000000}},	//   _анимам_, _afghanwa, --, --, 
   {{0x4e510059,0x4f69021e,0x00000000,0x00000000}},	// [e30] _bloccare_, _kanalern, --, --, 
   {{0xbc52044a,0xc9fd0362,0x03ea030a,0xe29005ab}},	//   _abatela_, _asungaka_, _ventá_, _tomada_, 
   {{0x997302ec,0x9e4c03cf,0x00000000,0x00000000}},	//   _یێہکھ_, _yakalana, --, --, 
   {{0xa72c0076,0xbc6f033e,0x0ea20110,0xae130265}},	//   _suspensã, _chororo_, _šarlote_, _oldenzaa, 
   {{0x9dba026c,0x4f18014f,0x450d002f,0xbe6e0061}},	//   _司法人員研習所_, _сестре_, _agnococh, _증권거래세_, 
   {{0x66270285,0xa70f0061,0xedcf027b,0xfda6006a}},	//   _minisiti, _자연스러운_, _कूटकोष्ठ, _hazofija, 
   {{0x328f0384,0x72360265,0xf0710184,0xd9f20260}},	//   _stranici_, _dagje_, _icabunyo, _recrecid, 
   {{0x80350392,0x82ea0243,0x00000000,0x00000000}},	//   _santayan, _tarigen_, --, --, 
   {{0xa3b6045b,0x737800f5,0x03790403,0xb590012e}},	//   _жертвами_, _allanyn_, _ankanjo_, _elmulasz, 
   {{0xfd09033e,0xdc870125,0x3dbb005d,0x7ed304f8}},	//   _гергиев_, _дындарла, _colectív, _achieves_, 
   {{0xda79005a,0x2226023e,0xed6000bb,0x6a800096}},	//   _botaghpa_, _warkop_, _مسلمانوں, _amazinda_, 
   {{0x526c0085,0x7290018a,0xc2fc023e,0x319500f2}},	//   _domomu_, _afiach_, _afngal_, _rezervēj, 
   {{0x125a0300,0x2c1f03bf,0x6976018b,0xd26e006a}},	//   _okolí_, _аманов_, _aranjame, _hatory_, 
   {{0xa2920270,0xdf5f03cf,0x4c5c00ce,0xb290000e}},	//   _basate_, _istasyon, _soutyen_, _homama_, 
   {{0x3a160154,0xb2920055,0x22740037,0x23ec00be}},	//   _патрия_, _casate_, _ገብረመድኅን_, _куйбогон_, 
   {{0x226e00ea,0x2387008c,0xf2020010,0x3d8b0259}},	//   _matory_, _ouvra_, _busime_, _bellezza, 
   {{0x7e550014,0xdea800e3,0x00000000,0x00000000}},	// [e40] _islamike_, _hallieln, --, --, 
   {{0xf06c0099,0xdea5009b,0xe292027f,0x03f800a1}},	//   _achavano, _partaide_, _gasase_, _ngaua_, 
   {{0x0e38034e,0x9f5f0077,0xcc520272,0xeb9603fb}},	//   _arcatata, _estasyon, _baatula_, _poznavao_, 
   {{0xec71010d,0x00000000,0x00000000,0x00000000}},	//   _पुष्कळ_, --, --, --, 
   {{0xe9a90037,0xd34301f0,0x037c016a,0xf2d8016b}},	//   _በየክፍለ_, _ditetlo_, _agrable_, _budewa_, 
   {{0x58760019,0x3a430009,0x11370022,0x1056011a}},	//   _اندانكىي, _gradbena_, _ирәмәл_, _בבודפשט_, 
   {{0x494303ea,0x5290048f,0xaf5d00a8,0x4266008d}},	//   _scolaire, _bomama_, _apparats_, _kitobini_, 
   {{0xd7c701a7,0xa94d0416,0xe38700e6,0x20120235}},	//   _наличии_, _absorpte, _版权和其它问题需, _atonidān, 
   {{0xae5f0256,0xd26c0369,0x1316028d,0xdb6b0153}},	//   _velosipē, _pahola_, _vanze_, _タ生成手段によっ, 
   {{0xfedc001d,0x847b013a,0xd2670223,0x12da029e}},	//   _nationes_, _minutten_, _салонд_, _chaoser_, 
   {{0x42c50387,0x6f5b0056,0x22480204,0x49e60403}},	//   _ewelite_, _ahlangan, _saimme_, _fatorana_, 
   {{0xf27e0258,0x4937015e,0xa1420059,0x3c6801a2}},	//   _rienk_, _камбар_, _оттам_, _miruši_, 
   {{0xd1b20024,0x23470055,0x8dab00aa,0x537800ba}},	//   _ব্লেক_, _finezza_, _gisigura, _مۆنیمێنت, 
   {{0x226c00d6,0x8e93031a,0x42e80156,0x4292008f}},	//   _tahoma_, _celtscot_, _admiron_, _issand_, 
   {{0x43160285,0x61f20148,0xfdf2005e,0x6315001e}},	//   _yanze_, _新加坡大紀元_, _سەنشىڭ_, _tambayi_, 
   {{0x8be1026c,0x22f70243,0x116a01f1,0x5c7e00ed}},	//   _本站使用正體字_, _acrimuk_, _respekto, _burston_, 
   {{0x633d01ce,0xb1220092,0xe4a300d6,0xd77800e5}},	// [e50] _میثاق_, _注文を確認または, _stráice_, _фантазии, 
   {{0xdd78012f,0x23ea020d,0x721300d4,0xa2fc008c}},	//   _adamonit_, _twita_, _lichem_, _camiuns_, 
   {{0x543b018d,0x327e03ad,0x0e99019e,0xcb870239}},	//   _መንግስትናን_, _hieni_, _брактэац, _timotimo_, 
   {{0x93f90030,0xfb010119,0x00000000,0x00000000}},	//   _tabulu_, _pagsimba_, --, --, 
   {{0x8b220169,0x27b1025c,0x8373019a,0xd3160230}},	//   _অধিবেশনে_, _verschwi, _beggary_, _ranze_, 
   {{0xaa1203a6,0xf91202af,0xe3160175,0xda9e0046}},	//   _bagateke, _bagateku, _sanze_, _сириянын_, 
   {{0xb31602e8,0x197b02fe,0x2f2800ca,0xdb8e0041}},	//   _panze_, _کړیده_, _représai, _иҧшӡоу_, 
   {{0xcb34003a,0xa3f40422,0xd4f700af,0x894f00c6}},	//   _muhandis, _sester_, _китайці_, _nedlegge, 
   {{0x3878034e,0x9e4c02f6,0xf3e705ac,0x11d701d4}},	//   _atinnaku, _makahana, _løtan_, _abandunà_, 
   {{0x06d90128,0x00000000,0x00000000,0x00000000}},	//   _وحیدالله_, --, --, --, 
   {{0x4a9e009a,0xec93012c,0x19180061,0xa38700ee}},	//   _مستقله_, _واتان_, _추가자가진단_, _afaria_, 
   {{0xd6c701d8,0xf5fe0238,0x6380015d,0x6d2c0095}},	//   _cicadidi, _позначен, _patryk_, _barokahe_, 
   {{0xe354058a,0x99e700be,0x7dfc0349,0x42910377}},	//   _numerus_, _بىلبۅۅسۉ_, _albertwa, _pleaca_, 
   {{0x321300e2,0x6bd6019c,0x9e9c0147,0x00000000}},	//   _hichem_, _eledumar, _مازۇت_, --, 
   {{0xa29004ca,0x729f0274,0x81460299,0x0aeb0403}},	//   _aimava_, _áttaði_, _بالاغەت_, _famonoan_, 
   {{0xc30b0192,0x76cd0040,0x967b0148,0x284d0291}},	//   _업체등록안내_, _איקאה_, _inventum_, _وجدته_, 
   {{0xe5f2038c,0xdc040148,0x00000000,0x00000000}},	// [e60] _razmotri, _consuli_, --, --, 
   {{0x421c035a,0x56720117,0xc27f01eb,0xa6d4003e}},	//   _harhan_, _fandresi, _erendy_, _ditabohi, 
   {{0xfd3b00d6,0x22d90250,0x835b00a9,0xffd800d0}},	//   _ǁǁǁ҈ǁ_, _jepet_, _bongera_, _хёмин_, 
   {{0x6b8100d2,0xe24a01cc,0x296601ee,0x0ac60368}},	//   _gatotkac, _क्रेता_, _хĕрарăм_, _стокхолм, 
   {{0xac260193,0x814300e7,0x329001a4,0x5c06000a}},	//   _भविष्यात_, _upheaval, _bomaka_, _igerlass, 
   {{0xf3dc0288,0x95b90066,0x8b790156,0x00000000}},	//   _schwi_, _campusek, _הקרעטשמע_, --, 
   {{0x877f020e,0xb7b50178,0x00000000,0x00000000}},	//   _спортсыл, _avaśyāya, --, --, 
   {{0x5ff90037,0x228d0450,0xe62902c7,0x00000000}},	//   _እነዚሁም_, _baakman_, _staatsbü, --, 
   {{0xd2d804c3,0xc84602fe,0xc26b0133,0x39db02c0}},	//   _nghen_, _بډايو_, _harrumal, _страста_, 
   {{0xc25a00dd,0x0d04018d,0xe85d0444,0xe9ea0128}},	//   _wella_, _ዘመተታት_, _оплатил_, _талайгин, 
   {{0x3da40268,0xf35b0069,0x62da0244,0x1cf40181}},	//   _orkingwa, _yongera_, _fornire_, _vesterbr, 
   {{0x3c61002e,0xbc0b05ad,0x820102a0,0x22900373}},	//   _odlucio_, _propalo_, _loyin_, _aneksas_, 
   {{0x127702c1,0xe29b02d0,0x3288027b,0xfb2100be}},	//   _indishyi_, _rickety_, _जज्ञिरे_, _айланта_, 
   {{0x538701c2,0x5581034c,0x625a00e0,0xd8d60156}},	//   _agarda_, _европача_, _fielle_, _אבֿיבֿ_, 
   {{0x7d0d0425,0x371a00f4,0xbc7300ec,0x00000000}},	//   _سزادانی_, _digustum_, _skardos_, --, 
   {{0xb7950065,0xa37f01fc,0x71b202f8,0xc29600a6}},	//   _testberi, _halanka_, _kelekelé_, _ayikoku_, 
   {{0xa6280037,0x8c590153,0x129101c1,0x00000000}},	// [e70] _perihati, _しょこたん_, _didaur_, --, 
   {{0x537f01c5,0xc373042f,0x94d30374,0x620101e5}},	//   _calanka_, _uyarangm, _мексикал, _joyin_, 
   {{0xe52f023d,0x72da01fb,0x327e03d9,0xdf93022b}},	//   _prossimo_, _fornace_, _ahena_, _bardagar_, 
   {{0x43fa0265,0xb3f400a3,0xc14b01c8,0x9b190108}},	//   _marufu_, _hestar_, _dalekohl, _romadhon_, 
   {{0x431602c1,0xcad1002a,0x553300d1,0x407e03dd}},	//   _manza_, _kromozon_, _নায়িকাৰ, _perballo, 
   {{0x9b380238,0x326e0014,0x4a890014,0xa56b0251}},	//   _процесуа, _aktori_, _komision_, _tarjumay, 
   {{0x03f402df,0x02da018b,0x42ef0388,0x00000000}},	//   _mestar_, _pornire_, _graffi_, --, 
   {{0x8f3505ae,0x99d00220,0x5a870061,0x0261002b}},	//   _reportar_, _тенис_, _보내시겠습니까_, _কামারুজ্, 
   {{0x53f80240,0xb0ed007d,0x846f01cc,0xda5804e0}},	//   _cumuta_, _jadikanl, _अन्यॊन्य, _urgencia_, 
   {{0xe2d804c3,0x49ee0229,0x02a40284,0x902505af}},	//   _ngheo_, _intihara_, _beskydy_, _prodavao, 
   {{0x13870062,0x9db201fa,0x6e9c04a5,0x62ec006e}},	//   _cherwi_, _kulukulu_, _kwamazin, _jëful_, 
   {{0x968e00b5,0x83950067,0x3c000151,0x127f03da}},	//   _irreligi, _ajessa_, _draughts, _onunu_, 
   {{0x8df0046a,0xe25a0211,0xb2cb0037,0x960f0080}},	//   _traduire_, _kello_, _ውዝግቡን_, _anillagi, 
   {{0x22d401bb,0x727c014e,0xc4ba004d,0x32010358}},	//   _serdar_, _играч_, _尺仿石紋面晚碟櫃_, _goyin_, 
   {{0x86bc05b0,0x3db20369,0x1292006e,0x04f300c8}},	//   _सत्तर_, _huluhulu_, _bawaul_, _энергияһ, 
   {{0x93870242,0x461f031a,0x717f0086,0xe37300bd}},	//   _enerji_, _dunomhai, _استادِ_, _gangwey_, 
   {{0x173205b1,0x93f40024,0x250d04df,0xf3fa012c}},	// [e80] _nezodpov, _festar_, _abulgazy, _harufu_, 
   {{0x5fae0016,0x23f40257,0x92d8012c,0x62d800b0}},	//   _שווייץ_, _gestir_, _kuleta_, _heleen_, 
   {{0xc32d018d,0x299c0274,0xe3f80256,0x149b03d9}},	//   _ንማእሰርቲ_, _bankanna_, _numura_, _ankabeaz, 
   {{0xa365035b,0x420001c6,0x92300562,0x0fa101fb}},	//   _drugega_, _noait_, _akamuca_, _appellar_, 
   {{0x22900120,0x83f800f9,0xf38f0075,0x9e380094}},	//   _akkale_, _humura_, _ímynda_, _سابىرلىل, 
   {{0xa35600a6,0x9378001b,0x00000000,0x00000000}},	//   _amafama_, _hawassa_, --, --, 
   {{0x23da053f,0x5f4002c1,0xea1a034e,0x735700d8}},	//   _khatatix_, _akagaban, _bracerot, _asperar_, 
   {{0x7c02002b,0x3ef002a3,0xd3f8030f,0xe27e01c6}},	//   _টাট্টুহর, _prakties_, _mumura_, _kninen_, 
   {{0x2fb402a5,0x437f01c5,0xf1520268,0x13f4025b}},	//   _říjen_, _dalalka_, _obalglay_, _festir_, 
   {{0x185c02c9,0x13ea0286,0x9ba400b4,0x31a5012a}},	//   _romanesc_, _tintimii_, _continuă_, _zarobić_, 
   {{0x03200043,0xda410177,0x1ad1015b,0x58060019}},	//   _ennyo_, _гәндеи_, _protekte, _клеткада, 
   {{0xd9c80007,0xd3da024c,0xa99d0094,0x00000000}},	//   _kokomisa_, _intrużjo, _уакыт_, --, 
   {{0x0da1012c,0x852703a2,0xbbc1020f,0x02010134}},	//   _بارگاهن_, _सरफ़ेस_, _دايکندي_, _toyin_, 
   {{0x55580037,0x67e20105,0xcb8602eb,0x00000000}},	//   _ያሳየናል_, _cierpliw, _шархыг_, --, 
   {{0x46830523,0xda9f03ab,0x327f0399,0xcaeb018d}},	//   _विशाल_, _povinnos, _anunu_, _ዲክታተርነት_, 
   {{0x60770016,0x6279000b,0xef4a032d,0xd3800288}},	//   _מערבֿ_, _aposetol, _baipitsa, _oturay_, 
   {{0xfe5100e1,0x50a70092,0xea340125,0x5dc1002c}},	// [e90] _aymatuka, _最も参考になった, _мекежинл, _авралгүй_, 
   {{0x327e0497,0x23fa0278,0x9ec5003d,0x307300a6}},	//   _chenn_, _marudu_, _jacobins_, _ayabongo, 
   {{0x520000aa,0xfb5902da,0x1212007d,0x0f960156}},	//   _diiin_, _сензори_, _bakhil_, _זידלען_, 
   {{0xf7c701c9,0xa501044a,0x8ec202d4,0x00000000}},	//   _उन्हकर_, _bokristo_, _decisivs_, --, 
   {{0xd9430497,0x176d025a,0x325a0223,0x25cf051e}},	//   _approver_, _arihanag, _pello_, _líquidos_, 
   {{0x35a20579,0xc42c0060,0xb87e0125,0x93f8033a}},	//   _पराते_, _ايالاي_, _kümüş_, _agius_, 
   {{0x80380176,0x00000000,0x00000000,0x00000000}},	//   _softphon, --, --, --, 
   {{0x02bb0217,0x09c00211,0xa4e900f2,0x727e00bd}},	//   _vidente_, _tekemise, _parastā_, _kenned_, 
   {{0x057302f3,0x927e00ad,0x08fd0029,0x62f60016}},	//   _hantverk, _aheng_, _دهوکێ_, _aktivaj_, 
   {{0x0d2e02b3,0x62c10275,0x00000000,0x00000000}},	//   _abrirase_, _vailima_, --, --, 
   {{0x14b502af,0x540e0456,0x00000000,0x00000000}},	//   _barashik, _syarahan_, --, --, 
   {{0x9a5900d1,0xa47301d2,0x8f9d00d1,0x93200151}},	//   _সংস্থাপক, _asutiwan_, _অনুসৰ্গ_, _annyl_, 
   {{0x2a2f00a4,0x312702d3,0x73160038,0x4ca3027c}},	//   _دوكىلات_, _заболи_, _гакрәп_, _عارضې_, 
   {{0xce850125,0x227f0101,0x1b8d00fb,0xa39403fe}},	//   _тургут_, _anunt_, _abandayo_, _недопуще, 
   {{0x64a8039e,0xa27e0256,0x0aa3018d,0x027e0528}},	//   _মৃত্যুৰ_, _sienu_, _እንፈልጦም_, _gheng_, 
   {{0x727e0111,0xde170060,0x230d041e,0x126e0453}},	//   _pienu_, _калмауы_, _albanus_, _napona_, 
   {{0x6ab9017d,0xc27e0222,0x426e005b,0xfa8e01e5}},	// [ea0] _陽気なギャングが, _vient_, _hitomi_, _daindain_, 
   {{0x3024026f,0x14870019,0x6af4018c,0x00000000}},	//   _алдымен_, _байлайт_, _verslete, --, 
   {{0xa93c00b4,0xc27e04bb,0xe249039d,0xa27e0222}},	//   _популаци, _giens_, _mbambe_, _tient_, 
   {{0xb28b00b6,0x8290024f,0x3958037c,0xc2bb0515}},	//   _binaadam, _tomana_, _ultravnc_, _ridente_, 
   {{0x1fc300d4,0x040f04a4,0x413600a6,0xc51e012c}},	//   _kalinder_, _charrann_, _طريقې_, _mafuriko_, 
   {{0x730c00b4,0xb0220092,0xa2000281,0xb6040299}},	//   _sanatos_, _この項目を引用_, _aniit_, _ئۆڭكۈرلە, 
   {{0x70a3016d,0xa2ef0067,0xc6c20347,0xeb0500cf}},	//   _техникид, _bilisaa_, _zimbabwi, _faashist, 
   {{0x927e0347,0x9cdb033c,0x7fd6015e,0x224902ba}},	//   _diens_, _anawster, _ordinado, _abambe_, 
   {{0xbef202f0,0x904700a6,0x822c0156,0x03e500c4}},	//   _bankulun, _ادعاوو_, _חפֿצים_, _mahubiri_, 
   {{0x952d0297,0x59d6057c,0xb9c8025f,0x4b5305b2}},	//   _betermäs, _julekale, _kokokisa_, _каланă_, 
   {{0xf4b50250,0x97580193,0xdd040350,0x00000000}},	//   _parashik, _दुर्दैव_, _ለመቅዳት_, --, 
   {{0x838705b3,0x624904cf,0x038702ec,0x444d0035}},	//   _daarop_, _ebambe_, _naarta_, _бирэм_, 
   {{0xd2d40250,0x1c6b02bb,0x0dc103d9,0x49680168}},	//   _perdor_, _खात्मा_, _besinima, _modifise, 
   {{0xf226045a,0x727e00df,0xef5d038b,0xb177017a}},	//   _kirken_, _biens_, _ditangan, _несту_, 
   {{0xa16a01ea,0x0a1704bf,0x1a7d030f,0xf49902c0}},	//   _самарқан, _stranaka_, _apiatara_, _моторите_, 
   {{0x4f3f0559,0xc32001b9,0xf2fc0455,0xa75b0235}},	//   _kangakan, _minye_, _robinet_, _bahirnag, 
   {{0xb2e90223,0x7adc026c,0x3dbb0206,0xb396018f}},	// [eb0] _hasiera_, _並給作者一個通告_, _kolektív, _dessut_, 
   {{0xc25a00db,0xa27e018d,0x32020227,0x030001ed}},	//   _selle_, _dhene_, _dirimu_, _kahaoki_, 
   {{0xb9eb0033,0x2fe4003e,0xff9103a4,0x817c00b9}},	//   _correspu, _dimillio, _biddarar_, _मत्सर_, 
   {{0xd02501d5,0xbce803a2,0x72fe0130,0x250802eb}},	//   _گوارا_, _जगनमोहन_, _brugha_, _zentroko_, 
   {{0x9344031e,0xc2e901c3,0x978801a3,0x00000000}},	//   _gledaju_, _aarnieu_, _فوٽوُن_, --, 
   {{0xe3f40540,0x027e02c1,0x684a018d,0x105b02fb}},	//   _gestur_, _ihene_, _ሃገርውን_, _hiusiton, 
   {{0xfda80257,0x2ec101a6,0xce9d022f,0x1a10000d}},	//   _tengjast_, _hainaman, _kosmetin, _trepikod, 
   {{0xb27e0051,0xa37800ec,0xec11005a,0xd2300322}},	//   _viens_, _pagalba_, _chopmeh_, _akamara_, 
   {{0xd3780272,0x93f4025e,0xf50f005f,0x8ed802e9}},	//   _bagamba_, _bestur_, _forococh, _medianas_, 
   {{0xbc450410,0x3201011f,0x47e601ec,0xd26c0160}},	//   _dikwano_, _agaipi_, _رهروان_, _skloni_, 
   {{0x4053038f,0x4e92010f,0xba910497,0xa3f900b3}},	//   _tresaden, _бонувон_, _iconclas, _хозурини_, 
   {{0x92ab0435,0x230e018d,0xba36014e,0x7d2604eb}},	//   _dinkić_, _ክንቀሳቐሱ_, _мрачни_, _सांवरिया_, 
   {{0x92d40265,0x56d6014a,0x5ca70238,0x8a8702e9}},	//   _verder_, _ناممکن_, _редакція_, _anuncian_, 
   {{0x527e0079,0x7297017a,0xfb4b0185,0x91200135}},	//   _piens_, _кампири_, _аспектла, _ашханә_, 
   {{0x727e0292,0xf200036d,0x029202be,0x4a2703c7}},	//   _ahene_, _anaim_, _kisame_, _देवबंद_, 
   {{0xa7e80061,0x7f63015d,0xcc0600bd,0xe86c011b}},	//   _노출됩니다_, _संख्याओं_, _daursay_, _komikund, 
   {{0x7eaf0173,0x02510287,0x66940085,0x726c030f}},	// [ec0] _আমন্ত্রণ_, _डिआइजी_, _relearni, _maioro_, 
   {{0xc3950075,0x3b87025d,0x00000000,0x00000000}},	//   _fyrst_, _verneomr, --, --, 
   {{0xd94e02eb,0x617c02e1,0xed9e033c,0x48f70100}},	//   _хакерууд_, _cheangal, _curlyhyp, _raspisiv, 
   {{0xb27e009d,0x63ee0092,0x3347018a,0x0436018d}},	//   _thene_, _講談社文庫_, _barbeciw_, _መንግስታዊት_, 
   {{0xb38702c2,0x48b90159,0x022c014a,0x77fd0037}},	//   _waarop_, _заставал, _کیپلر_, _አባሎቻቸው_, 
   {{0xdc6f0195,0x014e01b2,0xcf2a0258,0x598300ae}},	//   _clarion_, _buttonho, _bertepla, _ikizungu, 
   {{0x02f500df,0xbe6b01a3,0xf30601e7,0x4bda027e}},	//   _dernier_, _بيرڪن_, _berodung_, _приложни, 
   {{0xc380047d,0x9c6500a5,0x3119005b,0x00000000}},	//   _duurch_, _toatolu_, _guavacuz_, --, 
   {{0xe32001cc,0x47e202f7,0x326e01e9,0x3e390099}},	//   _samyak_, _akarediw, _bapola_, _acharura, 
   {{0xfc6e0411,0xfdbd009a,0xc3ea0438,0x6c5202b0}},	//   _досконал, _andisena, _fwiti_, _hintern_, 
   {{0x8a160494,0x910c01ac,0xa57501a3,0x00000000}},	//   _ugradnja_, _scimeáil_, _جاڙيجا_, --, 
   {{0xa2790018,0x3bee02be,0xc24804d7,0x52920160}},	//   _apositol, _aramaiko_, _blommi_, _arapskih_, 
   {{0x7e9600ec,0x75b301f4,0xa3ea0289,0x556701c7}},	//   _čempiona, _сондаги_, _hwati_, _diliniñ_, 
   {{0x3c55038d,0xb17e00c5,0x82d7008c,0x2be40156}},	//   _lentere_, _compagno, _amalats_, _טריטיס_, 
   {{0x317701a7,0x025a01b8,0x5ae4036d,0x97ca01d2}},	//   _тесты_, _kella_, _chluinnt, _hampitsi, 
   {{0x72e8010d,0x035f0167,0x5a8a0465,0xbdab00b2}},	//   _belikan_, _brigâd_, _magistrs, _eeritira, 
   {{0x5d6f02ac,0x736f02f6,0x7341020e,0xebee0145}},	// [ed0] _أحرار_, _benguet_, _ipuella_, _бамон_, 
   {{0x3df000a2,0xea0e020f,0x00000000,0x00000000}},	//   _ونڊوز_, _bamagale, --, --, 
   {{0xaec701e1,0xb1cc00d0,0x00000000,0x00000000}},	//   _behiloen, _багажаар_, --, --, 
   {{0x6e1301a7,0xe38601e4,0x72fe0256,0x46b90085}},	//   _ollenkaa, _kufry_, _norises_, _salamuri, 
   {{0x654b0287,0xd2ee03b4,0xd20402a6,0x146c0219}},	//   _विवेकको_, _asafi_, _agriculi_, _esifundz, 
   {{0xd0ee0330,0x820201c9,0xb5340040,0xe38b00f2}},	//   _maligall, _kiriku_, _הטעויות_, _divpadsm, 
   {{0x886101b2,0x796d033a,0x506101a3,0x803d016a}},	//   _feloniou, _antikwat, _ڀنڀرو_, _bastonoj_, 
   {{0xb2f10231,0x9a6c00ee,0x12020006,0x435b00a9}},	//   _christi_, _өлзий_, _diriku_, _nongera_, 
   {{0x825a0220,0x82f0042c,0x159d03b9,0xe3200176}},	//   _della_, _silovanj, _siqichañ, _annya_, 
   {{0x0c66030e,0xe35b019f,0x8b610161,0x24d7034c}},	//   _عبدالطيف_, _hongera_, _paremman_, _басабыз_, 
   {{0x135b05b4,0xb6e701f4,0x9723013d,0x648902cb}},	//   _kongera_, _tasarruf, _aspektoj_, _započeli_, 
   {{0xda7c028a,0xa54400a4,0x00000000,0x00000000}},	//   _zingatia_, _куршаб_, --, --, 
   {{0x26000255,0x626e029d,0xdd370135,0xaf68021c}},	//   _शायदे_, _napoca_, _теориясе_, _totalitn, 
   {{0xbf7c05b5,0xd363008d,0x134f028d,0xf38703ba}},	//   _poderás_, _kengash_, _isterik_, _ogaroa_, 
   {{0xa3860369,0xc793020e,0x56830074,0x7a370142}},	//   _akere_, _bakwetli, _коллеги_, _bahirdhā_, 
   {{0x9ad900c5,0xdbc302a9,0x69ba0053,0x4b4200e6}},	//   _justacot, _kreditų_, _ridertua_, _名英语学不会者_, 
   {{0x0a6e0464,0xd46c01f9,0x2af500d8,0x624b0510}},	// [ee0] _aragenda_, _asifundz, _afrontan_, _свиньи_, 
   {{0xb5770212,0x1b7f011f,0x00000000,0x00000000}},	//   _xsitepro_, _ifunción_, --, --, 
   {{0x7981005b,0xdb810119,0x32ee05b6,0x1e47044a}},	//   _hashimot, _neunkirc, _grafy_, _bakataye_, 
   {{0xf2d90032,0x429201fa,0xa0690047,0x58cc00c4}},	//   _angegh_, _aisake_, _proposen, _واندڪائي_, 
   {{0x2f6f03d4,0x7ce7022b,0x00000000,0x00000000}},	//   _спровође, _happað_, --, --, 
   {{0xe4fb0013,0x6ca40045,0x582400bf,0x126d033f}},	//   _دارالحفا, _густина_, _утилизир, _ngaolo_, 
   {{0xd3f80288,0xe7a00148,0x6e020211,0xc64c005b}},	//   _ngaun_, _contendi, _безналич, _aminasuf, 
   {{0x025a0120,0x30ea01cd,0x6f6a02db,0x690a009e}},	//   _celli_, _захираҳо, _gavanens_, _lembrand, 
   {{0xdc620331,0xdc5c02ea,0x127f0322,0x696a0265}},	//   _veturin_, _vietato_, _azanwa_, _navigere, 
   {{0x42b7033e,0xd29f0193,0x6087003d,0x0d5a0078}},	//   _министр_, _berjiwa_, _agachatz_, _волео_, 
   {{0xb2d90095,0x5ea3033e,0x36520268,0x72c401f1}},	//   _cepet_, _cañada_, _opinionw, _premtes_, 
   {{0x23410459,0x12340169,0x13490148,0x38d30312}},	//   _कैमूर_, _বৈচিত্র্, _externi_, _arafound, 
   {{0x47d90108,0x332d034c,0x421e00a1,0x522001e0}},	//   _kulawarg, _проезжая_, _möhio_, _وینداری_, 
   {{0x0de60255,0x43650449,0x4a930204,0xb885022b}},	//   _miljonit_, _drugoga_, _комедии_, _munkagru, 
   {{0x32a601d1,0x327e0415,0x996400aa,0x82d80073}},	//   _global_, _abend_, _hypokale, _ardera_, 
   {{0x80b0009a,0x32f000d6,0x45940007,0x559400fb}},	//   _abamajel, _eisiach_, _babungak, _babengay, 
   {{0x875e0031,0x51f300c7,0xa3860231,0x325a0274}},	// [ef0] _अवस्थेत_, _sabantuy_, _nheri_, _velli_, 
   {{0x996e04d7,0x82c202f7,0xf320018a,0xcf2000de}},	//   _brennist, _ipalela_, _ennyn_, _bendifun, 
   {{0x125a02d5,0xe36602a0,0xe48902cb,0x29ec0242}},	//   _telli_, _alagolo_, _započela_, _sınaqdan_, 
   {{0x33ea02b4,0x827e0065,0x11690584,0x738600a2}},	//   _kwato_, _ebene_, _proposto, _kheri_, 
   {{0x42d901f1,0x2594016d,0xb12201db,0x30190374}},	//   _neper_, _ﺭﻩﻫﻤﻪﺕ_, _تەڭدەسە_, _чорсу_, 
   {{0xf27f024f,0x47c902f1,0x225a05b7,0x00000000}},	//   _diuna_, _manterá_, _stolac_, --, 
   {{0xc104042a,0x92470297,0x8aa90061,0x79c8020e}},	//   _akukenel, _aşmas_, _브라우징은_, _fokolisa_, 
   {{0xc2da031d,0x5afc005b,0xa8d003d4,0x389c0193}},	//   _bowery_, _samfunds, _издавачк, _मनुष्याच, 
   {{0xa43f002f,0xdbbd00d1,0xc1cc01de,0xcaf300f8}},	//   _chakishk, _তাত্পয্য, _сызат_, _ক্ষেতের_, 
   {{0x82d901ec,0x962c03b7,0x5e650017,0x2b8d0142}},	//   _pepet_, _acrobatw, _वर्गमा_, _प्रमा_, 
   {{0xda5f00ea,0x8d4a0013,0xac1c0040,0x22c7040a}},	//   _matetika_, _اسکنه_, _ולבחור_, _lådan_, 
   {{0x2daf0272,0x2f5a0013,0xf27e02d5,0x82960126}},	//   _abatujju_, _тааллуқл, _laenu_, _beskrev_, 
   {{0xd2fe0168,0x5b020066,0x01f20151,0xbe3a000a}},	//   _torget_, _adiskide, _altaragh_, _asaanera, 
   {{0xf427014e,0x39b600c5,0x3c8c05b8,0xbb3c00f8}},	//   _мислим_, _云南电子政务门户_, _njutning_, _সচিবালয়ে_, 
   {{0x9c070103,0x92d900d8,0x2f7400d1,0x0a250137}},	//   _kamutamb, _sabers_, _চিৰযুগমী, _клубууд_, 
   {{0x03fa0044,0xea280326,0x0b09027e,0x427e0322}},	//   _assume_, _achchema_, _берлина_, _abene_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [f00] --, --, --, --, 
   {{0xb290030f,0xb37d00cf,0xc33b0055,0xb22800c7}},	//   _timata_, _baqanne_, _annasà_, _биргәннә, 
   {{0x3e830187,0x49330299,0x727e018a,0x93fa0569}},	//   _романот_, _ئىچمەكلە, _daenu_, _jarunu_, 
   {{0x22d801f0,0x239400b9,0x09ea05b9,0x72fb02fe}},	//   _atlega_, _singkong_, _nedgrade, _مسئولانو_, 
   {{0xd25a029b,0xa19a02e7,0x23f90014,0xbdf80025}},	//   _dellu_, _blackhol, _hequr_, _अनुमानं_, 
   {{0xc5380013,0x07f300da,0x2a060117,0x8c5a025f}},	//   _انکارایت, _райсобес_, _rimaende, _ekateli_, 
   {{0xc96901a7,0xa4400315,0x02d901bb,0x13e40192}},	//   _ajankoht, _akakabik, _zeper_, _바이올린의_, 
   {{0x7eb603f2,0x52680156,0xe24c038e,0x00000000}},	//   _системы_, _בייַשפּי, _मंगलम_, --, 
   {{0xfa1700b8,0xa3820092,0x7f6a0092,0xd2d4029a}},	//   _quranaka_, _滋賀県近江八幡市, _返品について_, _verdir_, 
   {{0xf27e00dd,0x52f000ad,0xa2cb0445,0x33e10291}},	//   _maent_, _dititah_, _moedas_, _إضراب_, 
   {{0x425a02dd,0x2ab4034b,0x827e01c2,0x327f00b3}},	//   _kellu_, _blakskin_, _iconas_, _alanyn_, 
   {{0xa2d901f1,0x02900119,0xad1300e2,0x72b50488}},	//   _teper_, _bujari_, _brosjuer, _sveces_, 
   {{0x5b2a02b6,0x7ff70044,0xa290054e,0x22e70119}},	//   _пайдалан, _מעניק_, _simata_, _aminado_, 
   {{0x03980013,0x21f60291,0x3967015e,0x00000000}},	//   _حقانی_, _تفعله_, _алмайынч, --, 
   {{0x8c57011f,0x8dc70025,0x63e20344,0x422500e6}},	//   _sudaméri, _avikalpa, _ikittuni_, _雪灾紧急救援行动_, 
   {{0x7b060188,0x92260211,0x32d80170,0x00000000}},	//   _хамсоя_, _kirkon_, _kudera_, --, 
   {{0x15bb019b,0x22bb0040,0x4c6e033e,0x634e0153}},	// [f10] _атлеты_, _שהופך_, _catafóri, _を住居侵入容疑で, 
   {{0xc55b0170,0xeb710187,0xc2d9059f,0x22b60031}},	//   _akaweluk, _emissora_, _veper_, _netcut_, 
   {{0xfe4e02be,0x63860369,0x927e02d5,0xb25a041e}},	//   _kasalana, _akera_, _vaenu_, _bellu_, 
   {{0x5d740064,0xa2c200cf,0xc2000399,0x00000000}},	//   _атрибутт, _faalama_, _piiii_, --, 
   {{0x6270025b,0xef2f013a,0x4e460168,0x78f70241}},	//   _grundini_, _beweegun, _ultralyd_, _eebantuu, 
   {{0x9290023b,0xe25a04d7,0xf9ab0291,0x82d904e5}},	//   _dimara_, _fellt_, _واحتياجا, _aveeyo_, 
   {{0x508c00bf,0x5c6e0195,0xdf790162,0xae9a0361}},	//   _главе_, _cuirinn_, _әйләп_, _радиокал, 
   {{0x62d901b4,0xb80c05ba,0x8c340198,0x00000000}},	//   _peper_, _अंगरक्षक, _izkaznic, --, 
   {{0x08ea0037,0x386300d9,0x3d350388,0x00000000}},	//   _በማቴዎስ_, _годами_, _елените_, --, 
   {{0xf5190037,0x58370204,0xa15603bf,0x89e30397}},	//   _እስፓንያ_, _батареи_, _малына_, _доданаш_, 
   {{0xa8270046,0x3ef504b1,0x87c9018d,0x827400be}},	//   _تارتىبى_, _desverre_, _ኣቐሚጥዎ_, _كۉچسۉزۉن, 
   {{0xed93009a,0x63cf0255,0x82aa00ef,0x12d90082}},	//   _amaesile_, _odavam_, _مسئلی_, _hudowar_, 
   {{0xd3ea02f8,0xc6ae01db,0x92bd00d9,0xd9ed037f}},	//   _atita_, _اتاۋدان_, _косметич, _zengimce, 
   {{0xd9e0016d,0xc5ef01c6,0x205302dd,0xfc6b050a}},	//   _ақсүңәк_, _grimmiti, _familtek_, _huzurlu_, 
   {{0x53940230,0x220000e2,0xc5940011,0xa62200e6}},	//   _belser_, _iiiiv_, _babeegay, _太平洋汽车网_, 
   {{0x72d80196,0xd25b033f,0x9da005bb,0x33f80119}},	//   _kulera_, _alelé_, _finínfin, _lumuya_, 
   {{0x13ea0049,0x23fa0051,0x6212009a,0x00000000}},	// [f20] _etita_, _sarunu_, _emihla_, --, 
   {{0xc2f20428,0x910800cb,0x3ca300e6,0xf479001c}},	//   _potovanj, _amakhwal, _héritage_, _langkuro_, 
   {{0x53860326,0xd5440285,0x2381019d,0x379f0148}},	//   _chero_, _ishingiy, _amayang_, _contingi, 
   {{0xc99d023d,0x97730052,0x763701e4,0x4c5b0013}},	//   _дискусия_, _बिहानैबा, _भयरहित_, _истилоҳи, 
   {{0x3c770270,0x73200140,0xbc280272,0x5264034c}},	//   _pensate_, _ninyo_, _abaperus, _agulau_, 
   {{0x0f670177,0xe36200d9,0xb24b0169,0x71ee016d}},	//   _христопу, _одноврем, _আনন্দে_, _позитсий, 
   {{0x8af7005e,0x93860074,0x90400306,0xf8110291}},	//   _كىتدۇ_, _hiiren_, _cantokun, _تشارجر_, 
   {{0xef5e017e,0x3b09006c,0xf68b00de,0xfb0b03cf}},	//   _komprena, _махалчиг, _babemoyi, _taksitle, 
   {{0x99090276,0xb8b701c8,0x9c2a02c1,0x00000000}},	//   _һесабат_, _protipov, _arababar, --, 
   {{0xa0660401,0x41530026,0x73c502b2,0x43f800b9}},	//   _लक्षित_, _kunststo, _турнір_, _nemuin_, 
   {{0xbb370360,0x24fd0420,0xdb9a048c,0x5d8d0037}},	//   _बसोबास_, _законите_, _pachyder, _ስኮትላንድ_, 
   {{0x3ab80148,0x9d7b00f3,0x82690288,0xaf4f00db}},	//   _元以限時掛號印刷, _abaminya, _mwinenei_, _meestele_, 
   {{0x92d405bc,0xe2000249,0x8d8701a6,0xbd670077}},	//   _verdur_, _inait_, _herekore_, _demandè_, 
   {{0x92000359,0x165a020a,0x5dc50439,0xbbae0144}},	//   _kriich_, _фирмасын, _kumiweke_, _ilchodac, 
   {{0x82010062,0x26cd0222,0x89f8005e,0x00000000}},	//   _boqil_, _rapproch, _әслимиси_, --, 
   {{0xe200005b,0x7852020e,0xcf7800e6,0xc0460158}},	//   _aiain_, _diushers_, _取得经济学_, _zagubion, 
   {{0xd86a00df,0xb2fe019a,0x6f5e0455,0x727e012f}},	// [f30] _politiqu, _forgat_, _comprena, _tsinya_, 
   {{0xc27f0199,0x02c302b7,0xae4003d5,0x00000000}},	//   _khung_, _suellen_, _broachit_, --, 
   {{0x6916053f,0x4889004a,0x00000000,0x00000000}},	//   _chacharu, _заманада, --, --, 
   {{0xee5d0037,0xe2c302c7,0x428d0241,0xe28f02ac}},	//   _አልታወቀም_, _quellen_, _bekkamo_, _تساريح_, 
   {{0x938600ab,0x4317023e,0xeed80311,0x00000000}},	//   _whero_, _dhanyang_, _እንብህጎ_, --, 
   {{0x6386046d,0x520101eb,0x4c660488,0x622605bd}},	//   _thero_, _araity_, _baltais_, _birken_, 
   {{0xf27f0199,0xc41301e0,0x2afe0333,0x02d800bd}},	//   _nhung_, _لاندا_, _apertame, _bedein_, 
   {{0xf5b901d9,0x4c35003d,0xa3d10366,0xcfba0160}},	//   _speziell_, _repartic, _тинĕс_, _krevetić, 
   {{0x5c3500a8,0x8c1e03ba,0x5ea200d9,0x8bc8004d}},	//   _separtic, _gogoredu_, _laadukas_, _按平日每小時工資, 
   {{0x6ed40487,0x9ae4000d,0x5db300f6,0x5e2e01fc}},	//   _achievin, _otstarbe, _ambisiya, _yintifiq, 
   {{0x9303011f,0xd3d7019e,0x328b00cb,0x00000000}},	//   _marandu_, _адзiн_, _babaholi_, --, 
   {{0xb2b50270,0xc02204e8,0x727e0156,0x74b300a6}},	//   _svedese_, _acceloro, _abonis_, _bematrik, 
   {{0x45270091,0x4215003b,0x191501cd,0x1f3200ea}},	//   _karitauy, _akahlali_, _худамро_, _fiafaran, 
   {{0x4192006c,0xce4d00d6,0x0e250243,0x0d2d020f}},	//   _abobulil, _calafort_, _tantafaq, _bazimase_, 
   {{0xaee00162,0x4c0b02d0,0x23200316,0x1c120176}},	//   _مۆمىن_, _flappin_, _cinye_, _deepchi_, 
   {{0x13160464,0xb7a1014d,0x63200127,0x32d0013d}},	//   _akizwa_, _verteidi, _aonyx_, _koloroj_, 
   {{0x5a9103df,0x96030211,0xf2000144,0xddbd0370}},	// [f40] _kringkas, _новинок_, _diail_, _bagianna, 
   {{0x75d20046,0xd36e012a,0x73f80085,0x1c3a04eb}},	//   _ئشتەتىپ_, _perfumy_, _kumuna_, _ईडियट्स_, 
   {{0xadc2038f,0x737f00ad,0x038600a4,0x6f780296}},	//   _deskriva, _kalahka_, _aniran_, _grabbarn, 
   {{0x752a05be,0xecc8020f,0x72d102c7,0x00000000}},	//   _žestoko_, _دتېلو_, _postfach_, --, 
   {{0xc32600c5,0x133d01e0,0x16f600c1,0x85830403}},	//   _图片和音视频稿件_, _جیراد_, _सँडविच_, _fanendah, 
   {{0x436e017e,0x0972013d,0x8c26012a,0x9386023a}},	//   _הוספות_, _kopirajt, _wersję_, _miery_, 
   {{0x225a041f,0xcd160208,0x1c2704ac,0x58580374}},	//   _bedla_, _حکومی_, _примеру_, _safarbar_, 
   {{0xa25a029f,0x42eb023e,0x92d90497,0xd0d902c6}},	//   _jedla_, _chairul_, _abbess_, _barabbaz_, 
   {{0x835f0035,0x13860005,0xc1e70151,0xd84e0290}},	//   _valeriy_, _tierz_, _accouchm, _castials_, 
   {{0x78aa00bc,0xb2d7023e,0x33200129,0x127e030b}},	//   _نکردنی_, _شکاری_, _tinye_, _asinga_, 
   {{0xb2da0050,0xac04025f,0x02d803e6,0xdd2d00a0}},	//   _puseur_, _ekeseni_, _betount_, _gajimare_, 
   {{0x46280047,0x9403002e,0xa35b02b9,0x52d80198}},	//   _habitati, _utvrđen_, _zongora_, _hudega_, 
   {{0xd2a101ba,0x42ea013f,0xf8830159,0x00000000}},	//   _intansif_, _carnoet_, _bankrutu, --, 
   {{0x40f503c7,0x038605bf,0x4c5c0047,0xa1f80071}},	//   _अनुरूप_, _diery_, _soutien_, _مقوله_, 
   {{0x622e041f,0xd9a0004c,0x331a0488,0x33c90163}},	//   _ukuvikel, _abakozie, _labajā_, _fakadó_, 
   {{0xf2f0034b,0xd7a90145,0x459d00ae,0xdd340333}},	//   _filipai_, _захворва, _birungik, _svanisce_, 
   {{0x0a12002a,0x82f4008c,0x262b04f9,0x00000000}},	// [f50] _amachara_, _turnaus_, _nerisari, --, 
   {{0xe37800a0,0x7f3902a6,0x00000000,0x00000000}},	//   _bawansa_, _annuchja, --, --, 
   {{0xe3860558,0x93ea04ec,0xc7a80306,0xd6b90096}},	//   _ekere_, _gwati_, _charikri, _badakuri, 
   {{0x43ea01b2,0x4c550322,0xb6260318,0x227e032d}},	//   _swath_, _sentore_, _havilivi, _eneneg_, 
   {{0x4c520191,0xcec701c9,0x23ea016b,0xe9a90037}},	//   _vintern_, _इन्टेकचु, _awati_, _በየክፍሉ_, 
   {{0x23960132,0x8290003a,0xf3200200,0xb36c006e}},	//   _messze_, _nimaga_, _pinye_, _dieggui_, 
   {{0x825a05c0,0xd8c8017c,0xcb9002b9,0x827201f4}},	//   _kelli_, _avstängn, _atlétika, _kelishdi_, 
   {{0x6d60023e,0xae4400ee,0x7f4103b4,0xbcd900f4}},	//   _کامیونت_, _pribatua, _bharabha, _gelveneg_, 
   {{0xcb810169,0xb2da055c,0x463601f7,0xbece033e}},	//   _লাগতে_, _spredt_, _apoiridi, _шраку_, 
   {{0x925a00fc,0x98f20253,0xb43000c5,0x231a0126}},	//   _lelli_, _nangillu, _polémiqu, _прикріпл, 
   {{0xdba902c1,0x209800ff,0xfc6f001d,0xa18b025b}},	//   _ubukerar, _געשװיגן_, _centvez_, _finalupl, 
   {{0x53bb006f,0xcf0b01b6,0x3aa300bc,0x66cf019f}},	//   _وستار_, _אלירן_, _rashedin_, _kikamili, 
   {{0xccda0126,0x073a0444,0x937c0077,0xeea3001c}},	//   _наскільк, _зорге_, _envante_, _lañada_, 
   {{0xab0a02ee,0xcc07000a,0xfb8c00ee,0xe29104ec}},	//   _klassika_, _agerlars, _nazinoar, _bubati_, 
   {{0x2ece03a2,0x79c50032,0xecd30060,0xdb13014f}},	//   _कार्यवाह, _cholonta_, _بارىلادى_, _послао_, 
   {{0xaae4002b,0xc3f003bf,0x327e020e,0x8292018c}},	//   _কাতারে_, _bolelang_, _bonnte_, _gitaar_, 
   {{0x63200132,0x487b030c,0xcc9f003e,0x8a9a0358}},	// [f60] _annyi_, _ministau, _опрессов, _akonplis, 
   {{0x1b8c053f,0xd36f04b3,0x0320051a,0xc94f01da}},	//   _marimoto_, _prigent_, _kunyah_, _mjeshtër, 
   {{0x0d78038a,0xcdfe0360,0x0eca01db,0x08c70126}},	//   _arampamp, _कलाकारित, _جەتپىستە, _законі_, 
   {{0x22d80499,0x83860250,0xa6d7040f,0x99690008}},	//   _aulega_, _sherr_, _празаік_, _proposar_, 
   {{0xa3200163,0x1b7100b0,0x23ea028b,0x32d801e9}},	//   _ennyi_, _guurtida_, _avaty_, _bulega_, 
   {{0x83770164,0xc532014e,0x327e0073,0x62c80037}},	//   _بىراق_, _септемба, _ebeno_, _አገሪትዋ_, 
   {{0x02ea0249,0xde1b00a7,0x86b604ad,0x4f5d02b6}},	//   _hariken_, _primeres_, _belegelw, _минуттай_, 
   {{0x13ea001d,0x0910019b,0x6f5d000a,0x00000000}},	//   _bontá_, _ўзнагаро, _appakaan, --, 
   {{0x203501b6,0xfe320307,0xc4f7014e,0xbaf500e0}},	//   _אומגה_, _bengahla, _мислили_, _ferriede, 
   {{0x6c6000c5,0x0c7b00a7,0x1e4804a4,0x00000000}},	//   _中国视觉网_, _баянкүйү, _marairea, --, 
   {{0xc236042b,0x0303021a,0x326e0074,0xe56300be}},	//   _manjih_, _garasuu_, _tapoja_, _كەچەدە_, 
   {{0x120002ce,0x3b3d0396,0x00000000,0x00000000}},	//   _azmira_, _franċiż_, --, --, 
   {{0x5a710122,0x8290003d,0xafa4017f,0x00000000}},	//   _معرکه_, _aimada_, _atulerso, --, 
   {{0xe2bb0270,0xd52d0297,0xe6ef0105,0x725501be}},	//   _funebre_, _betermäg, _zapachow, _प्रदेशीय_, 
   {{0x020e032b,0x1f630026,0x69d80306,0x917b05c1}},	//   _капал_, _relaties_, _asterale, _marhalah_, 
   {{0xd1bd0093,0x0c850130,0xf5380397,0xd9e2020f}},	//   _каталоге_, _okitaneg_, _abayibek, _راټيټ_, 
   {{0x946c0219,0xa14a0061,0x9af60007,0x2cf5039f}},	// [f70] _asafundz, _새집증후군_, _deboston_, _spawning_, 
   {{0xa89e0302,0xbe38048c,0x6320048f,0x936e0020}},	//   _зарафшон_, _anvashta, _kinya_, _osiganu_, 
   {{0xe0ea0071,0xce00027c,0x9b1800ae,0x430c01f5}},	//   _فرگوسن_, _aludinga, _buzayats, _depanku_, 
   {{0x4f38006c,0x3fb604b9,0x3479013a,0x259301e5}},	//   _abasespa, _beltless_, _grotéin_, _takuntak, 
   {{0x73200277,0xa20e015e,0x12d8000b,0xa89601ec}},	//   _linya_, _талаш_, _pulega_, _سخنگوی_, 
   {{0x72a70244,0x00a701cd,0x92e9004f,0x3e4f02fb}},	//   _такова_, _биринҷӣ_, _basiira_, _fematema, 
   {{0xcfed018d,0x223101fb,0x1d3d0010,0x438601b4}},	//   _ምስትንታን_, _inimico_, _bakhonte_, _skerm_, 
   {{0x62e90111,0x8f4d03c4,0x39a002f9,0x1a090277}},	//   _scritta_, _башланди_, _konjonkt, _blaauwbe, 
   {{0x2d1901f6,0x97c3013a,0x838603b4,0xd24501d9}},	//   _personar, _bestriew, _atorwe_, _dämpt_, 
   {{0x9c7100ef,0x52000092,0x1b8100d1,0xc657040f}},	//   _دپلار_, _iiiii_, _লাজতে_, _важкае_, 
   {{0xd95b03f3,0x6396005a,0x53200316,0x5723002b}},	//   _dienstve, _chusha_, _jinya_, _অনীহা_, 
   {{0xf320022c,0x19c802fe,0x7c6602b6,0xaf790137}},	//   _dinya_, _نظرياتو_, _сауығып_, _фосфорын_, 
   {{0x3dc4007f,0xf0060153,0x9200003c,0xf5cb034e}},	//   _breintia, _月発売予定_, _cuiiih_, _hamawtay, 
   {{0x2017019e,0x4f8200da,0x21c10156,0xc4e20352}},	//   _законна_, _afectiun, _סוּווערע, _চেডাৰ_, 
   {{0x497c000b,0x5b0403ba,0x030f0252,0x06130163}},	//   _ainitene, _einsalbe, _tambaho_, _kollekci, 
   {{0x2d2f0024,0x820104d7,0xae0602f9,0x92b20297}},	//   _বিধায়ক_, _aleinn_, _fondalna, _fondtan_, 
   {{0x82000257,0x2984002e,0x93f90338,0xf69c00d7}},	// [f80] _kominn_, _pružiti_, _ateuna_, _institjh, 
   {{0x11fb041b,0x72c30132,0x8f38027b,0x63860116}},	//   _nanpalok_, _nyelven_, _देहिनां_, _sherp_, 
   {{0xa76502fe,0x72a7010f,0x00000000,0x00000000}},	//   _دوامداره_, _панохаш_, --, --, 
   {{0x02c300b5,0x2c330328,0xe2260331,0x0c6b018d}},	//   _tallado_, _agacerer, _virkin_, _ከበሳታት_, 
   {{0x9876016a,0x135100c5,0xca0f0388,0x7b20003c}},	//   _משניות_, _consacré_, _chiarame, _درآستانه_, 
   {{0x9c730461,0xbacb0243,0x83790313,0x00000000}},	//   _cabrils_, _rammiten_, _pehajqo_, --, 
   {{0x806601ab,0x3e3d002f,0x00000000,0x00000000}},	//   _कातसँ_, _estadopa, --, --, 
   {{0x126c0270,0x32ea0152,0xbfc3034c,0xf601040e}},	//   _schola_, _аттранж_, _asrauçıl, _fiskebåt, 
   {{0x63960550,0x4a7f02e3,0xf3ea0196,0xb2a90037}},	//   _shusha_, _thuế_, _awatu_, _አገሪቷን_, 
   {{0xd5d203d4,0x427f02ab,0x8ffd0202,0x530001ab}},	//   _железниц, _ihuna_, _erunwọ̀n_, _romaani_, 
   {{0x1c1401aa,0xee330132,0x825b0369,0x2fcc01ac}},	//   _udystay_, _villamos_, _kaeleu_, _مزدوجة_, 
   {{0x837c00f7,0x05810003,0xd24a037c,0x1da1012c}},	//   _vivante_, _eigensch, _turmas_, _بارگاهه_, 
   {{0x9398022f,0x495a0287,0xdfbe01b6,0xf1b901db}},	//   _рассыпае, _हिंसाको_, _pollutio, _термині_, 
   {{0x59170371,0x567e016d,0x56ff003c,0x5b7900be}},	//   _призова_, _җавгониң_, _دستامو_, _ونۋەرىست, 
   {{0x92c7057c,0xc47902ce,0x7171020f,0xc68f0139}},	//   _sådan_, _protéin_, _دبېلابېل, _chettavy, 
   {{0x22da0258,0x256f00e4,0xbd0a000a,0x228c02b4}},	//   _sprekt_, _प्रताड़न, _alarniar, _bukhulu_, 
   {{0xb64b018d,0x15330238,0x6f2503a2,0xa422033a}},	// [f90] _ንዓሰርተ_, _погляди_, _खनिजों_, _definizz, 
   {{0x531d00b4,0x57830092,0x6386002a,0xd3bb00ef}},	//   _sarcina_, _総スクラップ数_, _ikeri_, _مکتبونو_, 
   {{0xb27f05c2,0x7ee300b7,0xd2450241,0x43160043}},	//   _ahuna_, _hoşniýet, _atileeti_, _akizza_, 
   {{0xfae70320,0xa9c70145,0x66040026,0x020102a0}},	//   _blueglob, _чакала_, _beslissi, _enyin_, 
   {{0xb2d80511,0x62da04d8,0xbb3c00bf,0x38270061}},	//   _etlela_, _mareeb_, _хлопонин_, _열렸습니다_, 
   {{0xe27f0014,0xb702005e,0x42bc0296,0x5c6103f1}},	//   _dhuna_, _ﺑﯩﺰﻣﯘ_, _bildfel_, _rakusko_, 
   {{0x6c160125,0x5c5503a8,0xb2eb0062,0x00000000}},	//   _berseň_, _bentare_, _qeliqam_, --, 
   {{0x74f7023c,0xb5ea004a,0xf2cb0456,0x99d100c1}},	//   _ښاپېرۍ_, _astağı_, _khadam_, _नौदलाच्य, 
   {{0x15440094,0x92ab018d,0x2c1b016e,0x89b4015e}},	//   _بىلەيىن_, _ንምጽኣቱ_, _makamlar, _бугунун_, 
   {{0x141603cc,0x92d50329,0x00000000,0x00000000}},	//   _এক্সক্লু, _adjourn_, --, --, 
   {{0x12ca0052,0xc1560038,0x27a6036e,0x00000000}},	//   _akademii_, _башыма_, _churaqti, --, 
   {{0xa25a03f8,0x72c602ec,0xe37f0340,0x33bb014c}},	//   _qellu_, _بدلنہٕ_, _hamaria_, _akhwela_, 
   {{0xc03602bb,0xf2570022,0x0d5803bf,0xd27f0176}},	//   _छमाही_, _алтынсыл, _сымдарын, _chuna_, 
   {{0xfc65033a,0xecaa00f2,0x4ffb0074,0xf2e5009f}},	//   _kuntatt_, _asociāci, _ставить_, _prilagaj, 
   {{0xae9f0079,0x00000000,0x00000000,0x00000000}},	//   _ekskluzī, --, --, --, 
   {{0xc2010077,0x427e018a,0xdfa700e6,0xb291031e}},	//   _anyin_, _baent_, _等额本金还款法_, _drzati_, 
   {{0xf29000a5,0x9c05022f,0xfd4e0092,0x527e018a}},	// [fa0] _aonapo_, _verslui_, _地球の歩き方_, _caent_, 
   {{0x9420016d,0x42900119,0x19c3028a,0x6278018f}},	//   _نىمانداق_, _himaya_, _طالبن_, _jitney_, 
   {{0x8d810212,0x029402d8,0x83860257,0x9fb60226}},	//   _truetype_, _sukabumi_, _skera_, _angolozo, 
   {{0x9e8d028b,0x12d500ab,0xc3a9005e,0x547b0294}},	//   _иамшы_, _kaponga_, _سېكۇنت_, _cartolin_, 
   {{0x94cc03b8,0xf276003c,0x036f00a3,0xb6570297}},	//   _магмалық_, _diingoni_, _byggast_, _ишәйде_, 
   {{0x62ca0203,0x736502f7,0x00000000,0x00000000}},	//   _mundes_, _mengobo_, --, --, 
   {{0x6b7b031a,0xc27e048e,0x3730001a,0x305401b2}},	//   _ainglean_, _kaens_, _تیراکی_, _brusquen, 
   {{0x64d7048a,0xc29002d8,0xba270109,0x1372017f}},	//   _санаты_, _kejang_, _ढंगबाट_, _eigaard_, 
   {{0xf46e04c7,0x5f8d02d5,0x93ea0558,0xdb52020f}},	//   _према_, _सलीका_, _etiti_, _عبدالمعي, 
   {{0xb30d046f,0x73ea012f,0x402c004e,0xf379010d}},	//   _geparkt_, _otata_, _impeksyo, _kotanya_, 
   {{0x70d5034d,0xf99603de,0xbaa4015f,0x5f5c01b2}},	//   _bergerak_, _ukuhlala_, _ardystie, _asianonn, 
   {{0x13dc02bd,0xfbb2017e,0xeb0301c6,0x420e01cd}},	//   _talwrn_, _subjekto_, _barradie, _малах_, 
   {{0x28860178,0xb59002c2,0x93ea00b4,0xaabb01b2}},	//   _akhaṇḍaṃ_, _teruggek, _atata_, _bunkeryn_, 
   {{0x68ab01ce,0xec550244,0x1379036e,0x4a7901d2}},	//   _برجسته_, _sentire_, _antacha_, _antachap_, 
   {{0x9d29042f,0x84cb0220,0x24af0003,0x6927005e}},	//   _enmikkot_, _контрапр, _minimaal_, _ھۇرەيرە_, 
   {{0x9d5c029d,0x00000000,0x00000000,0x00000000}},	//   _комисару, --, --, --, 
   {{0x13f403ae,0xd047041a,0x00000000,0x00000000}},	// [fb0] _kartet_, _базової_, --, --, 
   {{0xd68301be,0x3984027f,0x9c0d033e,0x00000000}},	//   _संभार_, _ikazindu, _langdocc, --, 
   {{0x59c70205,0x878a016d,0xf2a202ac,0xb59c02d3}},	//   _малака_, _заманиди, _لمنطقة_, _legislaç, 
   {{0x0af60016,0x027e00aa,0xb1b30204,0xe364008e}},	//   _informon_, _abena_, _моложе_, _dungeen_, 
   {{0xc29d0183,0xce4f0125,0xac7c0371,0x034700d7}},	//   _tanjona_, _makalala, _чистката_, _lelekoa_, 
   {{0xe4b50118,0x3a2d012e,0x2c390077,0xfedb0350}},	//   _kutandik, _الادا_, _epicstor, _ለፍትህና_, 
   {{0xe0dd0219,0xf5c90125,0xa9d501f4,0xbe18018f}},	//   _ngendlel, _киргизле, _yerlarda_, _mimechja, 
   {{0x2d8c02dd,0x63fa01a6,0x035f005e,0x629003b4}},	//   _འཁྱོར_, _harumu_, _سەيپىدىن_, _aonawo_, 
   {{0x7c7e0119,0xb2010313,0xa2cf01ae,0x12ae00a4}},	//   _opisyal_, _biyin_, _coloque_, _previsió_, 
   {{0x03bc0013,0xb671004b,0x0d5b02a0,0x785c0098}},	//   _товарлар, _акинфеев_, _ifisilẹ_, _strammer_, 
   {{0xd3ea00b8,0x427f00c9,0xd2660466,0x8200051a}},	//   _utata_, _chung_, _otvoreni_, _dhaif_, 
   {{0x50bf02ac,0x3f380041,0x3301009a,0x00000000}},	//   _أصدرت_, _isãva_, _bombane_, --, 
   {{0xb3ea0388,0x07f40020,0x594f0305,0x00d80453}},	//   _stata_, _felauaig, _gullinge, _najozbil, 
   {{0x63ea05c3,0xf27f04f1,0x427e0117,0xbfa4017d}},	//   _fuite_, _aiunt_, _saens_, _opslagso, 
   {{0x474a01f4,0xdb0c051a,0x322e0010,0xedfc0161}},	//   _ускунала, _keistime, _cámelo_, _водонепр, 
   {{0x523002e8,0x9dbc0388,0x8f2905c4,0x79fd02d7}},	//   _akamira_, _milanese_, _napoleón, _alzament, 
   {{0x2201005a,0x438601e5,0x52bc01b4,0x627e0269}},	// [fc0] _yiyin_, _akero_, _verdwyn_, _iconos_, 
   {{0xcc7c02f3,0x12820014,0xe2f4008b,0x00000000}},	//   _vinsten_, _radhazi_, _metital_, --, 
   {{0xf37a0285,0x00000000,0x00000000,0x00000000}},	//   _magambo_, --, --, --, 
   {{0xd2b9046a,0x6e96017a,0xe18701c8,0xa2470022}},	//   _lúcia_, _abamkhon, _levandul, _декадаһы_, 
   {{0xa8d40148,0xcaee0269,0x33320077,0x057f022b}},	//   _天生成腔子_, _sentimie, _annafè_, _etingaró, 
   {{0x127f0184,0x646e00ec,0x32900122,0xb5cb0306}},	//   _aranka_, _драмы_, _rejang_, _andahuay, 
   {{0x784700b7,0x59fe02e5,0x6108004c,0xe51900b4}},	//   _захария_, _apuntaha_, _anakuwal, _traficul_, 
   {{0x22da023d,0xd49101ab,0xf7cf0159,0x72fc0119}},	//   _attesa_, _करीमन_, _rūpestin, _nanhold_, 
   {{0x989500a4,0xbb8800ff,0xd37602b2,0x51af00e6}},	//   _resistèn, _העסליכע_, _крісло_, _险胜中国女排_, 
   {{0x5290038e,0x52d802e7,0x127f04f2,0xd28e014d}},	//   _dimana_, _kahel_, _phung_, _muskeln_, 
   {{0x9f5500d1,0xf9fb018b,0x339501b2,0xc04202ac}},	//   _সংগঠনসমূ, _maramure, _omasex_, _رووووووع, 
   {{0xd14500a7,0xa34700de,0xab7e0183,0x00000000}},	//   _курман_, _athenga_, _asiriana_, --, 
   {{0x82d8003f,0x743b0311,0x53f90040,0x00000000}},	//   _mahem_, _ንወትሃደራዊ_, _לקסוס_, --, 
   {{0x527f02bc,0x24420287,0x05160039,0xa3860230}},	//   _thung_, _katalogů_, _навчаа_, _shert_, 
   {{0xd28d019d,0x93860047,0x50e70262,0xfef60299}},	//   _akukuwa_, _chers_, _almaklyk_, _ئۇپرىشى_, 
   {{0x1e49007c,0xa2b205c5,0x9a5502bb,0xba3d0089}},	//   _angaziba, _तालुक_, _यथार्थवा, _auditorı_, 
   {{0xb345034b,0x26db04f8,0x8fc601ce,0xb05602eb}},	// [fd0] _graduet_, _lymphocy, _تهاجمی_, _agenteak_, 
   {{0xeb95012c,0x2317020b,0x35fe0209,0x6ffb000d}},	//   _mazingir, _akanyang_, _hammondi, _tööohutu, 
   {{0xc3870183,0xe2d00467,0xec910040,0x2e3f01e7}},	//   _anaran_, _ankonam_, _הכניס_, _detailop, 
   {{0xb77c02c1,0xfe1c0235,0xeda803b7,0xb02300c5}},	//   _abavandi, _alpeccha, _actileta, _专业游泳教练一对, 
   {{0x8aea0124,0x82900031,0x1cbb0142,0x9445002b}},	//   _barthele, _gimana_, _उत्सृज्य_, _গেমসের_, 
   {{0x94d000a6,0xa5270427,0x1f4a0148,0x2d3a0158}},	//   _البلاوي_, _qaritauy, _epistula, _jesienne_, 
   {{0x6b720148,0xb4d70185,0x23800387,0x920004a4}},	//   _從之前的文章開始, _барасыз_, _latrik_, _ciiis_, 
   {{0xd3450305,0xf29000f7,0x09ac037f,0x31c900d9}},	//   _tildelt_, _monato_, _dostluğu_, _магнитны, 
   {{0xe290003b,0x627f0464,0x09cd04ad,0xa0f9018d}},	//   _lonato_, _isanga_, _baperofe, _ተጸንቢሩ_, 
   {{0xd27f00a9,0xb990002a,0x126c0170,0x814701cd}},	//   _asanga_, _chekwaba_, _achona_, _қасида_, 
   {{0x41b303ce,0x73ce0276,0x8af703e0,0x52d8015a}},	//   _کافری_, _жамаъити_, _saxophon_, _bahee_, 
   {{0xe656003b,0xcc5a012c,0x0a390019,0x3e1503d4}},	//   _afungelw, _ukatili_, _бегдин_, _империје_, 
   {{0xd20000d6,0xd43e0126,0x330e0121,0x4eab0279}},	//   _riail_, _гарне_, _cambian_, _palettes_, 
   {{0xa3860202,0x3290019f,0x6fa50277,0x8ef70025}},	//   _miiran_, _kujali_, _bulletpo, _करटको_, 
   {{0x42ea0231,0xf27e02e4,0xfdfe0162,0xefb80524}},	//   _helical_, _spinta_, _تەمىن_, _poslovno, 
   {{0xe3000090,0xf9240478,0x64ab038b,0x265604cf}},	//   _achanzi_, _cavalièr, _menampak, _efungelw, 
   {{0x427f0382,0xf230005b,0xbf7a02e1,0x2dbe0025}},	// [fe0] _frania_, _okamura_, _إفتتاح_, _पूर्वजान, 
   {{0xd4ed002b,0xb8dc0205,0x21fa002c,0x00000000}},	//   _পেপাল_, _бувим_, _подволко_, --, 
   {{0xe27f00ee,0xc06b01f2,0xf2830028,0xc04b00d6}},	//   _esanda_, _көчишими, _aansaday_, _faighteo, 
   {{0xb46d00e1,0xee9a0162,0xa2c504bf,0x4a9100a9}},	//   _baadoolo_, _затларни, _okoline_, _kuririmb, 
   {{0xcc1b0312,0x6e1d0265,0x00000000,0x00000000}},	//   _bourchas, _hooglera, --, --, 
   {{0x59410352,0x138600b0,0x227f03db,0xcc2302eb}},	//   _সযতনে_, _diiran_, _isanda_, _inprobis, 
   {{0x99200109,0xe820023a,0x6af901d4,0x761f00a4}},	//   _mobilní_, _mobilný_, _pressant, _aprovaci, 
   {{0x22d8010b,0x50730046,0xde1d00e6,0x421c02ee}},	//   _baheb_, _اڭگەمە_, _聚丙烯增强纤维防, _arthom_, 
   {{0x62b40067,0x13f403ee,0x2c2f02a0,0xf2f003f6}},	//   _chocho_, _žrtva_, _apopọ_, _hilinai_, 
   {{0xc3870417,0x322600bd,0xd9330035,0x00000000}},	//   _namibië_, _kirkin_, _дейтером, --, 
   {{0x984c0125,0xc71a008d,0xb26c0245,0x32d8023b}},	//   _моллалар, _закачкал, _ymdon_, _pahee_, 
   {{0xb30d01fd,0xcfc105c6,0x42c203fb,0x3f2d0277}},	//   _ganador_, _barnekor_, _obalama_, _makuyoga, 
   {{0xe27f03ec,0xf40700bc,0x13ea0270,0x729002f6}},	//   _prania_, _kejuruan_, _etate_, _himala_, 
   {{0x628e00c9,0xb3860081,0xa26d02f3,0xaea7005b}},	//   _parkson_, _skert_, _hofors_, _harunire_, 
   {{0xd23c0026,0xa3ea01e1,0x8e280268,0xc9cd01e9}},	//   _환영합니다_, _ntate_, _uestionq, _alefabet, 
   {{0x227f05c7,0x88470040,0x527e00cb,0x22d40127}},	//   _usanga_, _peptides_, _abenu_, _cerdic_, 
   {{0xb65600cb,0xeb3804df,0xf2eb02f9,0x8bc104df}},	// [ff0] _afundelw, _arbitraž_, _deliram_, _bitirdiň_, 
   {{0xf99702fa,0x00000000,0x00000000,0x00000000}},	//   _abayahud, --, --, --, 
   {{0xd3860558,0x2dad0257,0x094b006c,0x41380092}},	//   _ejere_, _landspít, _abamethe, _シンビデュ_, 
   {{0x8527030c,0xa2d80022,0xa2fc04b2,0x00000000}},	//   _qarirauy, _dulela_, _abuhing_, --, 
   {{0x7386019d,0xac1b013f,0x7c140013,0x5d2d0155}},	//   _njere_, _pourchas, _کورنر_, _brännpun, 
   {{0x2386002a,0x935e01c8,0xaa0a01d9,0xf85f05c8}},	//   _ijere_, _momenty_, _mataarbe, _entregas_, 
   {{0x13200207,0x31f600bc,0x957f02fe,0x00000000}},	//   _ninyi_, _مفصلی_, _ehluphez, --, 
   {{0x6968028b,0x932e0040,0x694a00e4,0xeae40040}},	//   _antilite, _קונצרני_, _यथासंभव_, _אנתרופול, 
   {{0x5c270344,0xd3ea0289,0x38c80077,0xe2d8003e}},	//   _alcoallu_, _atate_, _gwadelou, _hulela_, 
   {{0xf5d102bb,0xe3a9036f,0x369c046b,0x5f4b0144}},	//   _produktó, _previse_, _allgyrsi, _maisithe_, 
   {{0xf4070477,0xc2cb02bc,0x0f6a00d2,0x37e50014}},	//   _merinduk, _shadem_, _antawisn, _simbolev, 
   {{0xf89000c7,0xfd9c0189,0xf37801f6,0x7b4a00c8}},	//   _авторлар_, _inceleme_, _omfatta_, _башланам, 
   {{0xf386044c,0x0b68019b,0xd8f90067,0x3c170046}},	//   _gjere_, _atitinka_, _basaastu, _geganter, 
   {{0xe36b041b,0x73f402cf,0x755a042d,0x00000000}},	//   _nangdep_, _curtiu_, _hahalāla_, --, 
   {{0xfa1d01cd,0x8a0e015e,0x3c790089,0x8990004c}},	//   _томактаб, _ормон_, _belsäk_, _baakuyit, 
   {{0xe0df0057,0xec30004c,0x33200096,0x00000000}},	//   _ለክርስቶስ_, _akasiris, _banywi_, --, 
  
   {{0x541a053e,0xebf80041,0xacc30405,0x45d5002b}},	// [1000] _frankrik, _еициелах, _населені_, _রোজনামচা_, 
   {{0x5701015d,0x959501c5,0x82d80303,0xe22702b6}},	//   _रविन्द्र_, _wareegay, _bulela_, _хадисті_, 
   {{0x00940040,0x00000000,0x00000000,0x00000000}},	//   _ונהנים_, --, --, --, 
   {{0x54fb0273,0x8c52023d,0x42da035d,0x25f30034}},	//   _práctica_, _scatola_, _puteva_, _sameinað, 
   {{0x1d7c0044,0xf2da0265,0x717d0040,0x25bf038a}},	//   _במתמטיקה_, _meteen_, _בימוי_, _allintam_, 
   {{0xcaee0256,0xaaa4004b,0xd9f6005d,0xebdf0138}},	//   _pretinie, _сетерекл, _jahayhue, _temeller, 
   {{0xc183014e,0x139504cd,0x165d0040,0xf2ef01c5}},	//   _плате_, _pjesma_, _יבואו_, _waligaa_, 
   {{0x511803b8,0x0a71017c,0x2d0f004b,0x33070308}},	//   _заңға_, _kreativa_, _hamonate_, _merasuk_, 
   {{0x950200d1,0x1b640163,0x47a80344,0xca0e03db}},	//   _মায়ে_, _آذربائیج, _atominik_, _lamakale, 
   {{0xc12f0203,0x0c070166,0x73960192,0x23dc030e}},	//   _minorité_, _wörter_, _sessie_, _samwel_, 
   {{0x127f001e,0x87230434,0xd29200b4,0x67bb04ca}},	//   _rauni_, _impresió, _strazi_, _aperteni, 
   {{0x227f03fd,0x306102d8,0xd85601db,0xd6b4008a}},	//   _sauni_, _विकसक_, _اۋدارۋعا_, _islandwi, 
   {{0x490901f4,0xf25a04ca,0x827e010b,0x28a90076}},	//   _бераман_, _isolar_, _bonnye_, _брадавиц, 
   {{0x0ae703d0,0x71f701a2,0x7d79002b,0x2f21014d}},	//   _završeta, _uzklikšķ, _তালিকার_, _experten, 
   {{0x72fc01c2,0x427f0010,0xae960046,0x52f000aa}},	//   _veiga_, _ayenti_, _تىعىز_, _gilinaw_, 
   {{0x02da03ba,0x1c3b0316,0x034700d9,0xa06e00e6}},	//   _neteen_, _asibitoc, _надпись_, _发展规划论证会举, 
   {{0xf27e0157,0x174d0409,0x327f019d,0x00000000}},	// [1010] _ocena_, _バックナンバ_, _tauni_, --, 
   {{0x59ee00ab,0xf3080156,0x1352045b,0x13ea0318}},	//   _matikara_, _צעלזיוס_, _петриків, _tuita_, 
   {{0xd54a0113,0xee520010,0x1db90166,0x84f80274}},	//   _labharth, _angavaka, _gewinnsp, _sigurjón_, 
   {{0x127f0225,0xbda70061,0xdb0a01af,0x7386013a}},	//   _ebune_, _국가종합전자조달, _barlagyň_, _fiirun_, 
   {{0x020005c9,0x3eda040f,0xbaea0122,0x14ad034d}},	//   _phaib_, _medienos_, _angrikat, _disabdak, 
   {{0x138702e8,0xafa602ba,0xc3f40039,0xdcbe0145}},	//   _mhuri_, _хайрат_, _уулсын_, _абалонкі_, 
   {{0x5dd40003,0x84cf0111,0x00000000,0x00000000}},	//   _verkocht_, _bischizz, --, --, 
   {{0x037c004b,0x28cd05ca,0xb25b0052,0x00000000}},	//   _baballe_, _entendid, _nocleh_, --, 
   {{0x4c5e0013,0xad8f00fd,0xb2e80023,0x9fa80128}},	//   _اسقامت_, _caileaga, _планшето, _турисбек, 
   {{0x4b7c0430,0x0eca02ee,0xa6a1017d,0x5a5c0060}},	//   _divulela_, _mannarin, _kontanth, _داستاندى_, 
   {{0x02e005cb,0xceec0148,0xe3860077,0xd908036a}},	//   _तुलनात्म, _金門縣文化局_, _akeri_, _tamatabu, 
   {{0xfe520122,0x33ea03dd,0xb38a0144,0x220100bd}},	//   _sutawija, _drite_, _ترافيان_, _graith_, 
   {{0x43ea0387,0xf3f8023b,0x5f25029e,0x3be8028f}},	//   _erite_, _paaua_, _diseblan, _patopato_, 
   {{0x63250486,0x53ea0203,0x63870203,0x4db502a2}},	//   _tiscali_, _frite_, _acusticm, _pakingga, 
   {{0xa7fa02ec,0x77b700a4,0x42800096,0xe239000f}},	//   _گى۪وُن_, _imprimei, _asukuye_, _resmini_, 
   {{0x827e018a,0x7a7d05cc,0x52ca05cd,0x83ea0129}},	//   _eginyn_, _abanents, _fulde_, _irite_, 
   {{0x5f3f0205,0xadf5014a,0x7b370061,0xe31001ad}},	// [1020] _belgilan, _hardvera, _가맹점추가매물보, _maundang_, 
   {{0x527f0580,0x455300a6,0xa3ea00d4,0x1bc5019b}},	//   _jaunu_, _abakuluh, _krite_, _neleidži, 
   {{0x08450040,0xc2da00ca,0xa26d0109,0x08b500e2}},	//   _statutes_, _aprene_, _chladicí_, _kwetsber_, 
   {{0xa2ca045a,0x54a600be,0x71f202e2,0x2ae8002c}},	//   _kulde_, _جالقوو_, _altaiagh_, _naturalt, 
   {{0x7387032e,0xb996023c,0x3d2d00da,0x12f200dc}},	//   _churi_, _akuhlala_, _професие_, _lilivau_, 
   {{0xb2fc022a,0xa27e03f2,0x41660044,0x6f6400a4}},	//   _leigo_, _nainen_, _חילופי_, _экспертт, 
   {{0x04dd00ec,0x139403ec,0x8262056c,0x065500d3}},	//   _французы_, _taksat_, _metohiji_, _प्रदेशहर, 
   {{0x6c6f013b,0x23f8000e,0x1292018d,0x00000000}},	//   _dourada_, _mziuri_, _murati_, --, 
   {{0xfcac0193,0xb7f9015e,0xd6570137,0x7cf70365}},	//   _भास्कराच, _дегидей_, _файлтай_, _वैठकका_, 
   {{0x8a57014e,0x8b6b0099,0x7fe30291,0x3e49017a}},	//   _милана_, _aikonzer, _لافتا_, _angaliba, 
   {{0x73870069,0xf0f902f0,0x76190092,0x3e900237}},	//   _shuri_, _bakhosel, _aurorafi, _vermogen, 
   {{0x325a05ce,0x2e550140,0x22e9026c,0xae150281}},	//   _çelik_, _katangia, _scripta_, _kisermaa, 
   {{0x76a705c2,0xe7a80047,0xfb3402c5,0x33020009}},	//   _linganyi, _librairi, _ashandis, _kuharju_, 
   {{0xc65a0253,0x83ce03ff,0xe20900ef,0x63330017}},	//   _akikilli, _podvod_, _amahlwem, _konané_, 
   {{0x8ec203db,0xf13301b3,0x00000000,0x00000000}},	//   _abanaman, _непопуля, --, --, 
   {{0x827e0318,0x93c200a7,0x7c070222,0xc3870176}},	//   _esinia_, _ажарын_, _faisait_, _okura_, 
   {{0xea9705cf,0x52240271,0x9e3a026c,0x496b025d}},	// [1030] _veličinu_, _lenke_, _publicis_, _politiat, 
   {{0x32bd00bf,0xa3f90044,0x5394011f,0x3573017a}},	//   _позволяю, _occurs_, _hérib_, _зуровари_, 
   {{0xe38702e8,0x4f3a02c2,0xf25b0107,0x024a0456}},	//   _akura_, _spandeer_, _betle_, _syumul_, 
   {{0x1291010b,0x8646026f,0xc2990077,0x23ea02fd}},	//   _tebang_, _تۇننەن_, _jenjanm_, _stath_, 
   {{0xf27f05d0,0x13ea03b9,0x1ba70261,0x3d2f02ea}},	//   _taunu_, _atati_, _baziliko_, _caricare_, 
   {{0xe31c01dd,0x62e0025e,0x437b03a4,0x4c090392}},	//   _amacupa_, _botninn_, _fananum_, _mallachd_, 
   {{0x227f0516,0xe292041c,0xc2d805d1,0x23870292}},	//   _haunt_, _jurati_, _nyhed_, _ekura_, 
   {{0xd2240166,0x9d0503e8,0xde5501fa,0x7c5e023e}},	//   _denke_, _poglejte_, _fatangia, _وسلامت_, 
   {{0x2bdf055f,0x16e60156,0xeb8a021b,0x94c400e6}},	//   _yemekler, _חשובֿן_, _армейски, _旅行社审批_, 
   {{0xf9df0315,0xbeca0074,0x727e022c,0xf224029b}},	//   _afunelwa_, _раскраск, _aceng_, _fenke_, 
   {{0xef4a027a,0xd3f40130,0x17570162,0x22cb00dc}},	//   _besplata, _dister_, _тайлор_, _pokotia_, 
   {{0xa49802b2,0x16f000d6,0x9258023d,0xa29e0164}},	//   _тексті_, _الوندوز_, _colleghi_, _шикар_, 
   {{0x0dd60278,0x67b501d5,0xb2f400d8,0xd264005a}},	//   _berkorba, _عاشورہ_, _barnats_, _sorlij_, 
   {{0x73f401b9,0x085d00d9,0x3103004b,0xfe5c006d}},	//   _nister_, _opintotu, _ipokelel, _баніфацы_, 
   {{0x2b63022f,0x1294027b,0xce540537,0x6d0603c6}},	//   _роздум_, _विरोधो_, _presidiu_, _kaartfer, 
   {{0x6b92020e,0xe8e2019b,0x72d6006a,0x444e00ba}},	//   _dientapr, _ўнітарна, _antokon_, _میشێل_, 
   {{0xb8670163,0x3a620381,0x727e02a7,0x92920155}},	// [1040] _katoliku, _ainlesss, _tsinia_, _gitarr_, 
   {{0x2fe9010c,0x5850004d,0xe37b001c,0xec1b0390}},	//   _भावार्थ_, _removend, _pananum_, _ehkamlar, 
   {{0x1f3b017e,0xd387007f,0x33ea00e6,0x92010107}},	//   _apartena, _churo_, _cuite_, _diqin_, 
   {{0x8ac70590,0x6c5d04c3,0xdb0c015e,0x09790145}},	//   _талаар_, _viettel_, _possible, _motinyst, 
   {{0x4c6a0287,0x5b56007e,0x9c6b02fd,0xa5d00051}},	//   _गुल्मी_, _abcdphen_, _altraim_, _manuprāt_, 
   {{0x10770059,0x2fe80401,0x32010120,0x1ea80255}},	//   _френски_, _देहान्त_, _niqin_, _sekundit_, 
   {{0x07940138,0x7c600040,0xe3f400dd,0x23600040}},	//   _ekstresi, _המעסיק_, _cartre_, _המעיין_, 
   {{0xc97901a6,0xa1890037,0xa894019d,0x50ef00d0}},	//   _erihapet, _የአጭርና_, _chokumbu, _aliatuak_, 
   {{0xe2000063,0xe0760350,0x00000000,0x00000000}},	//   _bhain_, _በየወገናቸው_, --, --, 
   {{0x23ea01b4,0x026c023b,0xdecb0416,0xd2910318}},	//   _buite_, _maioko_, _samidean, _oofato_, 
   {{0xf2f50288,0x18b601ec,0xcfd905d2,0xfedc0067}},	//   _burioum_, _گرديد_, _barnesko, _faayidaa, 
   {{0x947205d3,0x8a1300b4,0x3c750193,0xf25f00da}},	//   _प्रभो_, _elicopte, _manuver_, _noutatil, 
   {{0x327e0465,0xebf40040,0x7001020f,0x00000000}},	//   _ocene_, _לאכלוס_, _وروځو_, --, 
   {{0x742301bb,0x344f018d,0x19e002d9,0x29da0037}},	//   _radiomyz, _ተጽዕኖን_, _alagatat, _የሚቀንስ_, 
   {{0x1b0b0088,0x531d0417,0x78420074,0xa6f501b7}},	//   _аттанып_, _kopiereg_, _teollisu, _शतावरी_, 
   {{0x42d7024f,0x5cfa0135,0x00000000,0x00000000}},	//   _idrodro_, _галлодак, --, --, 
   {{0xd30702ce,0xa6d005d4,0x8a74022c,0x00000000}},	// [1050] _nimbang_, _खंडित_, _bangetna_, --, 
   {{0x99d000b9,0xcac0040f,0x65aa0024,0x428e00b2}},	//   _सहाय्य_, _techniką_, _forseink, _gabaroom, 
   {{0x325a018a,0x20ad0576,0xab8c01f7,0xf034004d}},	//   _felly_, _اشاره_, _oscillar, _三民學習網_, 
   {{0x2eb100ce,0xdea302f3,0xbc6505d5,0xe1930061}},	//   _diferans_, _intresse_, _bentost_, _대한민국의_, 
   {{0x6d620092,0x523603fb,0x039600ac,0x00000000}},	//   _読み込み中_, _boljem_, _ukusna_, --, 
   {{0xefc500f5,0xc01b0184,0x22e90304,0x23f402b2}},	//   _аграмлы_, _atawuren, _istisqa_, _østen_, 
   {{0x16d00031,0xd41301e0,0xf9cd0222,0xe85c019c}},	//   _क्विझ_, _ماندا_, _interdit, _alábó_, 
   {{0x423200f9,0xfc7c012b,0x0bf40044,0x495f020f}},	//   _akamaro_, _kwestia_, _relevanc, _نیپکو_, 
   {{0xc0d905d6,0xabe70095,0x62000144,0x56cf0041}},	//   _autodail, _ارشدی_, _dhaid_, _шьакуа_, 
   {{0xce390326,0xd2b4011d,0x32ba000d,0x140e0234}},	//   _achakura, _calcat_, _tugevad_, _nijẹr_, 
   {{0x43020322,0x70290224,0x00000000,0x00000000}},	//   _atabaye_, _danstónl, --, --, 
   {{0x13070402,0x8f7b04d8,0x243b018d,0x83870288}},	//   _bimbang_, _غنیمتھ_, _ንወተሃደራዊ_, _oberei_, 
   {{0x5aff05d7,0x78370435,0x6b8d00b4,0x79210167}},	//   _boroatun_, _параде_, _scrisoar, _benblwyd, 
   {{0xc4b50216,0x1f440311,0x959e02b6,0x00000000}},	//   _basangik, _ዚመላለስ_, _әпербақа, --, 
   {{0xcd34012a,0x7d9f002b,0x52a301c7,0x23e0011a}},	//   _kompozyc, _চৌধুরী_, _bereniň_, _שמטרתה_, 
   {{0x330d0187,0x114a03bf,0x00000000,0x00000000}},	//   _cavalos_, _викиһаҡл, --, --, 
   {{0x05f000b6,0xfaef047a,0x35f701c2,0x30bb03c2}},	// [1060] _ellecabó, _renonmen_, _interpoñ, _ballaugh_, 
   {{0x220203bf,0x00000000,0x00000000,0x00000000}},	//   _fisiks_, --, --, --, 
   {{0x2c7103b5,0xd6170147,0x00000000,0x00000000}},	//   _istriku_, _دارجىدا_, --, --, 
   {{0x615c004f,0x93070031,0x00000000,0x00000000}},	//   _gaaraloo, _bimbing_, --, --, 
   {{0xb17b000d,0xa099016d,0xa60700ec,0xd3f4021b}},	//   _pikaajal, _франкфор, _чакаць_, _kartat_, 
   {{0x42000587,0x827f021b,0x4c650074,0xf2da0342}},	//   _biais_, _tsanna_, _tunteet_, _detenn_, 
   {{0x612d01ef,0xa25b02f7,0xa2da021c,0x978a0202}},	//   _часта_, _betla_, _spreje_, _ipanilẹr, 
   {{0x6c3202af,0xf6c700c4,0x0f4102be,0x3d9c00c4}},	//   _akibarir, _مورڳو_, _pangakon, _فيڪٽري_, 
   {{0x6f710342,0x4c7003f5,0xe2ec01d4,0xb0d300d1}},	//   _advantis_, _afirmou_, _abbiete_, _পত্ৰও_, 
   {{0x8c610003,0xbc4602ac,0x995d013a,0x464b01b8}},	//   _overige_, _حريمى_, _honnerte, _kahurväe, 
   {{0x93ea0371,0x2c0501cd,0xec930029,0x5278042c}},	//   _stato_, _ekuseni_, _چاوان_, _ratnih_, 
   {{0x183c0187,0xbe4f001c,0x595f02b0,0xfa5703b0}},	//   _прочитав_, _makakala, _franzose, _binære_, 
   {{0xd38c04cb,0xb27f0380,0x61af0226,0xfef402f4}},	//   _лутер_, _mbung_, _adamukum, _ficheros_, 
   {{0x2ee202d8,0x238001fc,0x405e0179,0xf2e7020e}},	//   _मुद्द्या, _cerral_, _lienetik_, _founela_, 
   {{0x8184018f,0x4d5e0109,0x1d810176,0x57f3020f}},	//   _biratlhl, _किशोरावस, _skolesta, _دليږلو_, 
   {{0x92ea007a,0x4ac705d8,0x36b90067,0xa24a0331}},	//   _petikan_, _pohvalje, _afgaansi, _karmar_, 
   {{0x4b5503ad,0x5fec0169,0xe8510073,0xff08005e}},	// [1070] _adottata_, _ইঞ্জিনিয, _astutias_, _بېىشغا_, 
   {{0x836005d9,0x32820464,0x59d3027b,0xa2d7008d}},	//   _aluguel_, _imihini_, _bhallena_, _dilorom_, 
   {{0x5f280266,0x66e90410,0x434800c3,0xf7560299}},	//   _cintaila, _tlhagišo_, _ingenii_, _تاڭنامە_, 
   {{0xfed9015d,0x07bc015d,0xb2ca05da,0xe2f00054}},	//   _kulinarn, _zatrudni, _fundas_, _baligai_, 
   {{0x43ea0182,0xc46e00ff,0xf29d042c,0x46b3028d}},	//   _huita_, _וואלקער_, _manjina_, _konsepty, 
   {{0x83ea0326,0x5d7f0315,0x204a054d,0x6f070092}},	//   _kuita_, _ngamunye_, _parforho, _お客様の自由な投, 
   {{0x33790189,0xe2de0162,0xa52600d6,0x20c205db}},	//   _antalya_, _جەرىمانە_, _ghriangh, _abalimel, 
   {{0xa3ea0023,0xd2fc025b,0xaae70160,0x79f6000b}},	//   _muita_, _leiga_, _završetk, _apineina_, 
   {{0x0bd8027b,0x2abd00e6,0xe28b012a,0x32b20297}},	//   _विलीयते_, _事业单位招聘_, _nabiał_, _bizniñ_, 
   {{0xbd7901f6,0x6c1d034c,0x11a90234,0x4c6102a2}},	//   _তালিকাত_, _fasadlar, _réfùrè_, _esturya_, 
   {{0x72900087,0x9bc400e1,0x00000000,0x00000000}},	//   _timali_, _anayejis, --, --, 
   {{0xd9d103d8,0x2290020e,0xd287029b,0x33870193}},	//   _kolovoza_, _bonabo_, _deniouy_, _biarin_, 
   {{0xb20005c9,0xd22a01c7,0xaa970002,0xae2c02cf}},	//   _khaib_, _ковал_, _veličina_, _владо_, 
   {{0xe3ea01fe,0x15290381,0x627c021b,0xba9a0176}},	//   _buita_, _achinery, _играх_, _bunntais, 
   {{0x1b53007c,0xe91b009b,0x68790148,0x188302c9}},	//   _kukwakha_, _аврага_, _升級個人空間_, _мунитатя_, 
   {{0xcd9e0233,0xf29001fe,0xe3bb0163,0x63a301b4}},	//   _dicoteca, _kimami_, _دسواں_, _dorpe_, 
   {{0xea9703d8,0x72fc01fa,0x2c3b0059,0xf44a0064}},	// [1080] _veličine_, _feiga_, _издаване_, _ажыны_, 
   {{0x59d30066,0x1cbb002b,0xed0d0390,0xafaa0153}},	//   _ahalmena_, _ফেরদৌসী_, _aviadaşı, _プエラリア_, 
   {{0x5a0b046d,0x0d16022b,0xb292029b,0x4790004d}},	//   _takalela_, _skiljast_, _buraax_, _裕隆集團不落人後_, 
   {{0xc2d80430,0xa73b0374,0x48fb02fc,0x43ea00ec}},	//   _vulela_, _акалари_, _barahuru, _krito_, 
   {{0x32a304df,0xd0f10425,0xb271033a,0x80350061}},	//   _bereliň_, _پێشره_, _glandoli_, _폭파시키겠다_, 
   {{0x94ab0031,0x482700be,0x7a13048c,0xe2260168}},	//   _penampak, _اشىنعان_, _emaciate, _tyrkia_, 
   {{0xe3570176,0x22e901f1,0x5290013d,0x3a020348}},	//   _cakephp_, _ideologj, _donaco_, _amusungu, 
   {{0x96d002a2,0xc5bd003f,0xbfe4016a,0x82c505b3}},	//   _magagami, _bitahtah, _verkisto, _ateljee_, 
   {{0x42000531,0x3c7d00f6,0x22b202f9,0xa9c8017e}},	//   _thaib_, _ziddiyyə, _fondman_, _belorusa_, 
   {{0xeb7e0524,0x23ea0087,0x00000000,0x00000000}},	//   _cooleric, _irito_, --, --, 
   {{0xc2f200dc,0x6f6f0256,0x730d0177,0x39de05dc}},	//   _molimau_, _komandas_, _изхыжьтә, _borgerse, 
   {{0x6c3a05dd,0xc2a300b3,0xe27f02d8,0x3f0c002b}},	//   _मधेपुरा_, _serediň_, _apanya_, _পরাজয়_, 
   {{0x896b05de,0x3bb301d9,0xedc7020f,0xc3ea01ec}},	//   _tannlege, _biekerec, _basinike_, _crito_, 
   {{0xe25501be,0xcc5d029a,0x695c00ba,0x83250059}},	//   _स्पेनी_, _lonterm_, _بگوازێته_, _fiscali_, 
   {{0x02da0066,0xd2d60156,0x21dc011a,0xa93e0320}},	//   _artera_, _aktoron_, _מלכודת_, _mihletwe, 
   {{0xd2600125,0x12480178,0x4e160139,0x6a71012e}},	//   _еврейлер_, _bhomi_, _chabdaḥ_, _semleges, 
   {{0x7acd00bf,0xc2ea0203,0xa23a040a,0xcfac02ea}},	// [1090] _поселени, _acrimen_, _nöjda_, _animazio, 
   {{0x232005df,0xcb920334,0xa7cb01c4,0xb3f00031}},	//   _sanyi_, _asanakac, _inspuiti, _dilelang_, 
   {{0x799500e8,0xd3500147,0x78ac01f4,0xb0390322}},	//   _amakrist, _تىلۅۅ_, _спортчи_, _assetamo, 
   {{0x752302da,0x62ca02c2,0x7d2d03dd,0x37b40037}},	//   _поздрав_, _kudde_, _opsionet_, _የኮምፒየተር_, 
   {{0xb3860074,0x10ef0530,0x61360107,0x5c300241}},	//   _nuoret_, _radijall, _هروقت_, _garagalc, 
   {{0xad9b044a,0x6518012b,0xb1b003f1,0x00000000}},	//   _bakulutu_, _podjął_, _sklenený_, --, 
   {{0xff5c005a,0x3380053c,0xab5600e4,0x82910059}},	//   _sugarcan, _ferrol_, _हेर्नुहु, _alfano_, 
   {{0x020101d8,0x42230071,0x97fa0152,0xfccf004d}},	//   _bleiun_, _تدارک_, _alabugag, _十八世紀中日文化, 
   {{0x727e0465,0xf1d0012b,0x71ac00f6,0x0b8a0089}},	//   _oceni_, _polecony_, _bulandır, _гонококк_, 
   {{0x01250059,0x2d5a0420,0x53ea0176,0x00000000}},	//   _икономед, _подем_, _biotek_, --, 
   {{0x3226018d,0x4ca402f3,0xd09000e6,0x21c1014b}},	//   _ውልቀምልካዊ_, _bakgrund_, _内蒙古自治区_, _lootanak_, 
   {{0xc8680011,0x00000000,0x00000000,0x00000000}},	//   _baligisu, --, --, --, 
   {{0x948a02d5,0xc2e800d5,0x694c00d9,0x69880153}},	//   _energiaj, _andiana_, _испанско, _といっても_, 
   {{0xd1370259,0x73a90144,0x6e2a018d,0xf47702c4}},	//   _landshol, _تزداد_, _ከይወደኣ_, _натера_, 
   {{0xc200029b,0x4ad8044b,0xfa1e0223,0xd2da05e0}},	//   _abiil_, _umiddelb, _битий_, _autoras_, 
   {{0x675b027b,0x00000000,0x00000000,0x00000000}},	//   _citrīkṛt, --, --, --, 
   {{0x6af702ee,0x19b4015e,0xc09a002b,0xdee500ec}},	// [10a0] _konsumat, _булуту_, _এমবিবিএস_, _блокаў_, 
   {{0x8bf70093,0xeaf70101,0xd31704bd,0xa2d80124}},	//   _жителей_, _consumat, _ahazia_, _sulema_, 
   {{0x32c50566,0xaf2b037f,0xad2c03fb,0x627e0211}},	//   _stemmer_, _qaytarma, _godište_, _painon_, 
   {{0x12fc04d7,0xa2880147,0x324804ce,0x68e8055a}},	//   _leigu_, _بئرۉگۉۉس, _thomi_, _ilegalid, 
   {{0x7c7504cc,0xaef104ac,0x84fa00c7,0x3a7d022d}},	//   _byasang_, _образом_, _mamadış_, _amparata_, 
   {{0x7fd7003a,0xe9f2036a,0xf3f40191,0x333501eb}},	//   _aksiyado, _guiguile, _listor_, _compañìa_, 
   {{0x02000195,0xe2ca0438,0x2287003a,0xb04a045b}},	//   _abaid_, _afodya_, _samimiy_, _холостяк_, 
   {{0xdeda00e6,0x52ca04df,0xe7f4036d,0x9d500126}},	//   _artisans_, _bibliki_, _polataig, _аборти_, 
   {{0x84100288,0x339500bd,0x9c740255,0xc2ec0337}},	//   _tauschen_, _odessa_, _vanuses_, _tarihte_, 
   {{0xd68c05e1,0xa69804b1,0xd7370071,0xc1630074}},	//   _सलवार_, _vesentli, _کاکتوس_, _ролика_, 
   {{0xc30d013a,0x433505e2,0xe46b0125,0xc9ce0041}},	//   _gepackt_, _compañía_, _айрылышм, _аиҟәшара_, 
   {{0x22900193,0x906600c1,0xe24a03dc,0x5c7c02f3}},	//   _cimahi_, _बालपणीच्, _karmur_, _önskan_, 
   {{0x72da00c2,0x827f04e5,0xb2b80071,0xf50300be}},	//   _gutera_, _mpanga_, _آموختگان_, _تااجى_, 
   {{0x327e04d0,0x7cef05e3,0xcc6b02c2,0x9393024c}},	//   _gainen_, _असामयिक_, _ontruim_, _esprimew_, 
   {{0xf42803d9,0xa062027b,0xee690046,0x3b55002f}},	//   _manadino_, _भाषसे_, _банктард, _bendicen_, 
   {{0x43ea01fb,0x1ee80092,0xeaf80200,0x6da700da}},	//   _irate_, _このブログをマイ, _jerusele, _infiinta, 
   {{0xb3860352,0xbd4b0045,0x93ea0049,0x02a70322}},	// [10b0] _gjera_, _станице_, _huitu_, _avebar_, 
   {{0x59e80075,0x6313032d,0xe3870165,0xc8ff0486}},	//   _kapteinu, _ремонтла, _ikuri_, _kamenný_, 
   {{0xfbd801a7,0x0b0a031e,0x8f2e02c7,0xb304005d}},	//   _сначала_, _vlasnika_, _bemerkun, _стамбулҟ, 
   {{0xdc80014f,0x5320026c,0xc3f901ad,0x23ea0062}},	//   _девет_, _sanctis_, _dayun_, _kuato_, 
   {{0x9a0803be,0x2c610055,0xf807002b,0x83eb04e3}},	//   _bamarana_, _amirale_, _বেগবান_, _sjetio_, 
   {{0x72fc033b,0x12f30170,0x92aa0037,0x86f60092}},	//   _leago_, _akristu_, _መገኛችን_, _クチコミ募集中_, 
   {{0xd32000bc,0x49cb0428,0xc9580037,0x32950145}},	//   _banyu_, _namestit, _ወልደገብርኤል_, _кургана_, 
   {{0xb3d4034c,0x735b0074,0xb2240347,0x3dbb0255}},	//   _yutazı_, _достоинс, _duiker_, _mugavalt_, 
   {{0x62ca01df,0x5053023c,0x226d00f5,0xc2e802a2}},	//   _gander_, _پاړسي_, _дүшйәр_, _palitan_, 
   {{0x232000a9,0x89950158,0xe20b0097,0xf0dd003c}},	//   _wanyu_, _ठेकेदारो, _didasilẹ_, _بیاری_, 
   {{0xd2fc0404,0xc8d1052c,0xf03b00e6,0xe2470135}},	//   _beago_, _ئیحسان_, _中国工商银行_, _енисейск_, 
   {{0x52f3041f,0xa4280403,0xd43e00d0,0x02ca0181}},	//   _ukristu_, _hanadino_, _магни_, _bander_, 
   {{0x6f35002b,0x28c50061,0x00000000,0x00000000}},	//   _উপায়ে_, _사이버민원실_, --, --, 
   {{0xdc0500e7,0x5320005c,0x02ee02d5,0x1a20033e}},	//   _overway_, _zanyu_, _tunneli_, _ҳәатышь_, 
   {{0x43200285,0x32da0227,0xd27e05e4,0xa3d70058}},	//   _yanyu_, _sutera_, _oceno_, _pikoupöl, 
   {{0x87cc033b,0xb05700b4,0x8a89043d,0x424c00c1}},	//   _phagameg, _синилие_, _aktifkan_, _बॅचलर_, 
   {{0x42a60177,0x627f02d4,0x7cb1057c,0xff8b0206}},	// [10c0] _аланархә, _mauns_, _læsning_, _semináre_, 
   {{0x13a30396,0x1c52004f,0x16f50012,0xbf1501a3}},	//   _korpi_, _amatuma_, _लटकवले_, _اسڪالرشپ_, 
   {{0xcfef01b2,0x53870282,0x4a170099,0xe6b10143}},	//   _playfuln, _ehuru_, _chichape, _ресурсит, 
   {{0xe27f00a8,0x1e7105e5,0x8d7d03db,0x1c1b0163}},	//   _taunt_, _जिल्द_, _abamanga, _elmagyar, 
   {{0x02e504df,0xb15800fd,0xfc750144,0xb2c503de}},	//   _afinyda_, _chonnadh_, _beorach_, _nihlale_, 
   {{0x03f405e6,0xfdd30301,0x9387002a,0x40e70262}},	//   _gister_, _moskvada, _ihuru_, _almazlyk_, 
   {{0x985700bc,0x085c00ff,0x4e4901cf,0x09e000f2}},	//   _کیانیان_, _אפעטיט_, _ligamine_, _planitop_, 
   {{0x327f0079,0xf8530008,0xcd7d02f0,0xeb7c0048}},	//   _jauns_, _financer_, _ebamanga, _bafuluma_, 
   {{0x2251044b,0x0201024c,0x338703b4,0x18cc0137}},	//   _deltagel, _debitu_, _churu_, _маркетер_, 
   {{0x52eb03b2,0xec44049f,0x0bd1019b,0xc7670013}},	//   _medical_, _isewula_, _projektų_, _халкка_, 
   {{0x92c505e7,0x93c801ca,0x3aa402c8,0x396b00e6}},	//   _lihlale_, _letvad_, _caciquis, _要学习红军长征中, 
   {{0x15770073,0x82f30393,0x9af70235,0xcb9f01b5}},	//   _sentiero_, _dodavati_, _aparaist, _gavhenar, 
   {{0x62fd00ce,0x72920226,0x698701d2,0xc19903b6}},	//   _manhole_, _surati_, _chikanta_, _ládélé_, 
   {{0x5e22025e,0xd2e80037,0x72010205,0x00000000}},	//   _formanns_, _saliran_, _hayiti_, --, 
   {{0x4ae7041f,0x138703da,0x527f0334,0x790f00b5}},	//   _waprofet, _ahuru_, _mbuna_, _апеллиац, 
   {{0x629000ff,0x3fef0178,0xe9ff0486,0x1f7b02a0}},	//   _donado_, _atithīnā, _ramenní_, _ríbiribi_, 
   {{0x727f0013,0xb26c02d8,0x6c4902ef,0x23100397}},	// [10d0] _obuna_, _politisi_, _antwòt_, _abuzwa_, 
   {{0x17a801b9,0xf2ec004f,0xa2d805e8,0x4d2403cc}},	//   _santrali, _addinab_, _polelo_, _চুপচাপ_, 
   {{0x09ec0051,0x6fcb0177,0xf98e0060,0x4bb603f8}},	//   _kabineta_, _асанитар, _қария_, _dachavmo_, 
   {{0x5863011d,0xb97001d5,0x827f01c7,0x62eb025b}},	//   _вокация_, _نہِیں_, _abuna_, _barnatæn, 
   {{0x8386057c,0xdf170272,0xac1b01fd,0xe68302d5}},	//   _fjern_, _akaddann, _acostumb, _पिताक_, 
   {{0xcbd10360,0x3c66023c,0x9f3101b3,0x00000000}},	//   _projektů_, _عبدالطیف_, _неприпус, --, 
   {{0xd2d503ab,0x52fc012d,0xeb6702d5,0xb15b0372}},	//   _kontakty_, _mangal_, _अयिनी_, _abenbury_, 
   {{0x73bb0216,0x1ebe0516,0x540a002b,0x34a90038}},	//   _akhwila_, _americae_, _অল্পক্ষণ_, _вәгъдәлә, 
   {{0xd9f801a4,0x88ce0092,0x00000000,0x00000000}},	//   _komimona_, _statslig, --, --, 
   {{0x8c000158,0x95a201b7,0x82ca01b8,0xa9e20113}},	//   _एएसआई_, _याचते_, _mulda_, _جاريث_, 
   {{0x43870369,0xb53d019c,0xe1d1042d,0xcc9304dc}},	//   _azaria_, _gbasiṣẹ_, _andevony_, _لاتان_, 
   {{0xa4a401db,0x6292008d,0x92fc02be,0x3ed605e9}},	//   _ءبىرتالا, _surasi_, _aangal_, _granadas_, 
   {{0x5387030e,0xbaa00122,0xe4d701bd,0x51fa019b}},	//   _uhuru_, _ریکاوری_, _баратын_, _planavim, 
   {{0xd3ea013d,0x93f802c2,0xeb2d0227,0x26220331}},	//   _brita_, _toernooi_, _tembakan_, _formansf, 
   {{0x67c40045,0x527e0227,0xf7720193,0xc2fc00c0}},	//   _инвалиди, _mainan_, _प्राणिजा, _dangal_, 
   {{0x53ea00f9,0xf3ea01da,0x727e02cb,0xac5d0039}},	//   _itatu_, _drita_, _scenu_, _gustuko_, 
   {{0x03ea0200,0x22af013e,0x83bf0061,0x00000000}},	// [10e0] _erita_, _birališt, _아름다운강산_, --, 
   {{0x9b3301de,0x094b0486,0x0f2301b9,0x61b002c3}},	//   _بۇرلەگەن_, _प्रसूति_, _patrimwa, _sklenené_, 
   {{0x5d990021,0x3387053f,0x79d301f2,0x179f02a2}},	//   _actorsfa, _thurt_, _ноябир_, _pantangi, 
   {{0xe6c90088,0x62b60450,0x5bdf013a,0x7ddf01f3}},	//   _мистикал, _joadske_, _kalenner, _klikneme_, 
   {{0x494e0020,0x729102f6,0xcf2d0159,0x730000ac}},	//   _amalosit, _subali_, _saldumyn, _nosači_, 
   {{0x2f6e0016,0x4f0000e4,0x237a01e8,0x00000000}},	//   _וועילס_, _कुल्हाड़, _kagarbo_, --, 
   {{0xe3ea023e,0xd2760044,0xee42006e,0x594f026b}},	//   _crita_, _מסודרים_, _alkaande_, _estrenar_, 
   {{0x62ca00ad,0x858d0326,0xa2cb0010,0x73a30261}},	//   _kandar_, _najehovh, _acedze_, _korpo_, 
   {{0xd3ea0196,0x58ea0037,0x92640339,0xf4760116}},	//   _atatu_, _የማቴዎስ_, _liuliu_, _northmen_, 
   {{0x0859036f,0x674b0041,0xcc7e03b0,0xdde70287}},	//   _upozorav, _акадртә_, _innspel_, _rodinném_, 
   {{0xc281042c,0x586a0262,0x5da50218,0x9d39036e}},	//   _izabrati_, _antiwiru, _artistwa, _eskaparq, 
   {{0xbe710335,0x537900b9,0x2b7f03d9,0xd46005c6}},	//   _काप्र_, _ditanya_, _asyriana_, _anleggsk, 
   {{0x39fd00c7,0x535f0040,0xf2e70517,0xcb980435}},	//   _вазифасы_, _plugged_, _afinado_, _odličnog_, 
   {{0x77ad0046,0x5f680198,0xc96d02ac,0x320005ea}},	//   _تااسئرىن_, _pohodniš, _وترتيب_, _xenial_, 
   {{0x42fc02e2,0x738c00dc,0xf264033c,0x48dd022b}},	//   _leigh_, _leasapai_, _carlam_, _forferdu, 
   {{0x22ca01c5,0x6e4e00bf,0x0c4a02ac,0xbb720185}},	//   _muddo_, _локально, _لأجلك_, _baruına_, 
   {{0x32910172,0x42b301c1,0x3c6e0139,0xa2fc0065}},	// [10f0] _enfato_, _berdaya_, _aparena_, _springt_, 
   {{0xb4570060,0x028c02d5,0x42910133,0xf3ea004d}},	//   _ادالدانى, _tagastam, _azzaa_, _trita_, 
   {{0x764901d5,0x138600ff,0x43790053,0x7d8400e2}},	//   _بیروزگار, _adoras_, _citanya_, _reedride_, 
   {{0x2ee70125,0x7dbd051a,0x13f9019d,0x4b4204cf}},	//   _mezhebin, _keridhaa, _ambuye_, _bokwenza_, 
   {{0x327f046d,0x058a021c,0x835f017d,0xc92c02b4}},	//   _mbuno_, _magistrá, _undervej, _etimiswe, 
   {{0x3e510386,0xc2fc036d,0x70620307,0xf0f800ec}},	//   _melangka, _deigh_, _kwesivun, _viduramž, 
   {{0x13ea02c5,0xad2c01fb,0xcc530031,0x8c00017e}},	//   _utatu_, _veritate_, _bintaro_, _kreskas_, 
   {{0x2c3203be,0xd320012c,0x9372006f,0x22670156}},	//   _akabarir, _nanyi_, _خودارادي, _ננננְנננ, 
   {{0xf3ea0333,0x853500ff,0x02ec01f0,0xa3ec00de}},	//   _statu_, _שוטעף_, _busitse_, _باروردار_, 
   {{0x732001b5,0xd9df035e,0xc85001a4,0xacf001a4}},	//   _hanyi_, _brendova_, _nakofand, _pretendr, 
   {{0x4bb2002f,0x6ad400d3,0x67520192,0x2f2500ff}},	//   _booksour, _blondýnu_, _toonaang, _aspektan, 
   {{0xbb4205eb,0x227f021c,0xcc7801c8,0xab7b023e}},	//   _yokwenza_, _sauny_, _opustil_, _adiningr, 
   {{0xaf1001dc,0x12e8029d,0x72f00140,0x7c53008c}},	//   _cuntinua, _craiova_, _malinaw_, _metteva_, 
   {{0xe8cd01e1,0x03ea030f,0x0c1e040f,0xf9df0100}},	//   _лоббиста, _kuiti_, _labainor, _trendova_, 
   {{0x3aef025c,0x44b7043a,0xdb1803bf,0x7a06003a}},	//   _genommen_, _neloveäd, _boramots, _арофат_, 
   {{0x23ea046d,0x84c8000c,0x717c034c,0xa26c005b}},	//   _muiti_, _гарвардт, _arxierey_, _aroots_, 
   {{0x5ab80135,0xce37004d,0x920100e4,0x9d890372}},	// [1100] _başlağan_, _有錯就要承認錯_, _krainy_, _hailwamp, 
   {{0xb0dc0013,0x95cf00e6,0x4940004d,0x00000000}},	//   _avtomatl, _备案证编号_, _也給自己多一個選, --, 
   {{0x71c700bc,0x12da0269,0x52f001c0,0x65f600bb}},	//   _داستانی_, _tareas_, _dalilai_, _ادکارہ_, 
   {{0xa2620193,0x047602d5,0x09e3014e,0xe3880108}},	//   _रक्षण_, _चट्नी_, _боравак_, _biayana_, 
   {{0x5264023b,0x807c0040,0x122e00e5,0xbc1d0284}},	//   _ahulau_, _להתווכח_, _проверив_, _shoptet_, 
   {{0x79d80092,0x49bb023f,0xf3b40238,0x1b5c0011}},	//   _eksemple, _lordship_, _власникі, _akamalir, 
   {{0xd2d1022a,0x690e0244,0xef4b021c,0x54b50153}},	//   _notodom_, _прекрати_, _muškátov, _ルでのお問い合わ, 
   {{0x92fc00a5,0x274e0075,0xb27f00cf,0xe3ea0415}},	//   _leaga_, _grundleg, _waanan_, _statt_, 
   {{0x3c140025,0x027e015d,0x03ea02bf,0x8afd0203}},	//   _विस्तीर्, _opinia_, _asite_, _direktis, 
   {{0xc2970265,0xb2d805ca,0x8eac025c,0xd16d0168}},	//   _bescherm, _pilotos_, _zentrale_, _konsesjo, 
   {{0x4f5f048b,0x229500e4,0xa27e0144,0x42bb04cb}},	//   _uppppppp, _redakcji_, _linnte_, _măcar_, 
   {{0x638c0017,0x13410220,0x7c7700b9,0xe3d10166}},	//   _अग्रगामी_, _insegna_, _शिट्टी_, _heimwerk, 
   {{0xf2fc00fd,0xb8b70148,0x8c50008d,0x9db10024}},	//   _beaga_, _未得標廠商代碼_, _dastlab_, _শঙ্কৰদেৱ, 
   {{0xe38b02ac,0x63400008,0x52fc0176,0x82c8005f}},	//   _víris_, _vedella_, _efigo_, _retoque_, 
   {{0x2a310169,0x062a0335,0x62c90063,0x35b80177}},	//   _দেখিয়ে_, _ग्रहणे_, _míonna_, _кремльтә, 
   {{0x2ec3013d,0x620c00e6,0xbc07021e,0x59ec0382}},	//   _באורד_, _互联网周刊_, _konsult_, _mariyeta_, 
   {{0xbc5e00ac,0x6a290434,0xec1c00d9,0x3af80089}},	// [1110] _kratkom_, _seccione, _участке_, _машинкас, 
   {{0x1eac053e,0x5a0f03db,0xe3ea0055,0x0b2a0060}},	//   _sentrale_, _akaphind, _fuata_, _بەلگىلەم_, 
   {{0x65c4004d,0x72fc0195,0xa6b80119,0x00000000}},	//   _頂救災帳篷_, _seagh_, _pinakasi, --, 
   {{0xa3870392,0xb197027e,0x62130009,0x00000000}},	//   _bharan_, _наступит, _zlahka_, --, 
   {{0xfc7d005b,0x1f5f0220,0x3a970299,0x00000000}},	//   _tetsuya_, _capannon, _سۈلھى_, --, 
   {{0xdd6f041e,0x48700076,0x5378034f,0xe2d8015e}},	//   _tramunta, _pernambu, _زيرمو_, _veient_, 
   {{0x22a1015e,0x81010399,0x4f4c008c,0xa7ec039a}},	//   _conjunt_, _ehhhhhhh_, _surpassa, _pelarang, 
   {{0xd2eb0244,0x2c770275,0x82d9054c,0x3f5601a3}},	//   _scritto_, _leitiō_, _ideell_, _لالٽين_, 
   {{0x03ea002c,0x12ca01d9,0x9f3f0017,0x30670143}},	//   _aritu_, _gudde_, _उपनिवेश_, _краткоср, 
   {{0x54860193,0x13ea0079,0xa2c801bc,0x6d3d02ea}},	//   _द्वारे_, _britu_, _metoade_, _cliniche_, 
   {{0x83860054,0x23ea033a,0x3387037c,0xcbac019b}},	//   _shirin_, _dritt_, _zharan_, _прасторы_, 
   {{0xc2ca03b0,0x0b620041,0xa2da037c,0x163e01b5}},	//   _budde_, _иҭылҵаау, _parens_, _hlaleriw, 
   {{0x43ea053e,0xd7b7020a,0x187b026f,0x52d902ff}},	//   _fritt_, _تابعاش_, _бекұлан_, _iminite_, 
   {{0x8d9204e8,0x48890333,0xd720014a,0xa90e02af}},	//   _montrond_, _chevrier_, _versenyé, _kirasunu, 
   {{0x6b9602c9,0x0c7801c8,0x437a0122,0xf2e9016b}},	//   _духовнич, _spustil_, _کوبیده_, _hadisan_, 
   {{0x63940541,0xb3ea013d,0x2bca0037,0xda140256}},	//   _utisak_, _frato_, _የሚከሰተውን_, _uzgaidie, 
   {{0x93ea046f,0x1b9e048a,0xb2f00054,0x3b9d00d6}},	// [1120] _kritt_, _бюджетте, _dalibai_, _fisiceac, 
   {{0xc9f60086,0xfc60019a,0x775d023e,0x696b0264}},	//   _اولیت_, _blutter_, _متقابلا_, _propesor_, 
   {{0x54880334,0xa291018b,0xc9680399,0x5a060281}},	//   _anaganiz, _gheata_, _palinise, _innarlut, 
   {{0x1290002a,0x28da0093,0x1a910304,0x44bf0060}},	//   _abiara_, _признако, _teringin_, _астыртын_, 
   {{0x0e500374,0x33e2005b,0x2c700497,0x7b7f00ee}},	//   _masalala, _hollansk, _arasane_, _blogaren_, 
   {{0x516600ff,0x026e01af,0xc34c0109,0xe5e80035}},	//   _חילוקי_, _avtory_, _odstraní_, _bodaynı_, 
   {{0x8403002e,0x4200037c,0x00000000,0x00000000}},	//   _utvrđeno_, _abiit_, --, --, 
   {{0x1c7601b7,0x7872013c,0x2f4205ec,0x5ba80320}},	//   _दिस्वा_, _klintonu, _avisreda, _mukhuvur, 
   {{0xc2fe007b,0x407a0074,0x92fc0255,0x00000000}},	//   _forgie_, _миноборо, _teagi_, --, 
   {{0x9bf10212,0x21dd00de,0x33860359,0x0ae80120}},	//   _filebarr, _abanedum, _tjerk_, _fiddinos, 
   {{0x765e0388,0x12d40208,0x92f302d5,0xf3490120}},	//   _филми_, _بخورێت_, _अद्रा_, _esseqqi_, 
   {{0x63ce0005,0xdd31003c,0x84b402be,0x25350137}},	//   _privel_, _جووووووو, _maharlik, _гуалиг_, 
   {{0xb7b70027,0x52d900a1,0x2c220435,0x23ea025c}},	//   _dedietön_, _rapea_, _добрим_, _tritt_, 
   {{0x937103e7,0xc7f900f5,0x16d600d1,0xf7490083}},	//   _pahayag_, _кесилен_, _উদ্ৰেক_, _bisignev, 
   {{0xb37b00e4,0x1a840267,0x93eb00b4,0x76b6003c}},	//   _क्षिप्रा_, _memorijs, _nasterii_, _chornoby, 
   {{0x87f900f5,0xb6d20320,0x77db0082,0xdd8b0046}},	//   _демирел_, _exigodlw, _jarrabaw, _comodita, 
   {{0xb3860014,0x0c60005b,0x396901b4,0x57b501d9}},	// [1130] _njeri_, _slutter_, _motorfie, _umbeding, 
   {{0x82920141,0x6386002a,0x9c00001d,0x137f01d2}},	//   _turadi_, _ijeri_, _corsett_, _bonanta_, 
   {{0x75fd0333,0x07a9024a,0xfede0089,0x36d00348}},	//   _forestiè, _asenusún, _римда_, _bagalami, 
   {{0x72240172,0xd79702e4,0x404901f4,0x010a01c5}},	//   _monka_, _netwerki, _кетибди_, _kadhacay_, 
   {{0x9c9c00a2,0x570803a2,0x6d6f01cc,0x5f130209}},	//   _دشمنن_, _कंसल्टें, _asamanta, _anittara, 
   {{0x7c53002e,0x5dcc037e,0xeeb100b2,0x60300452}},	//   _žrtava_, _shakhmat_, _angowonn, _एकआहे_, 
   {{0x833c0220,0x6b200188,0x129102e7,0x12240067}},	//   _протеста_, _ҷиликӯл_, _gubaon_, _gonka_, 
   {{0xa43203dc,0x62e8023b,0x85c80322,0xe200029b}},	//   _skiparin_, _midiana_, _bakayish, _mbiir_, 
   {{0xfea8018d,0x03ea0046,0x63a8001d,0x36d101e8}},	//   _ዘይንፈልጥ_, _crits_, _hépat_, _hisalami, 
   {{0x527f019d,0xa3e602f3,0xc27f019d,0xf39f0110}},	//   _mpanda_, _böter_, _apanga_, _savainoj, 
   {{0x82d90489,0x4224021b,0x63870216,0xc5b1023e}},	//   _hapen_, _jonka_, _akuri_, _margahay, 
   {{0xd5920089,0xe38601f1,0x5847041a,0x00000000}},	//   _автордан_, _bjeri_, _рабами_, --, 
   {{0x0ccc01d5,0x0ff9018d,0x327e027e,0x57a9028a}},	//   _لیجنڈ_, _ታሕተዋይ_, _ocenu_, _دولتانه_, 
   {{0x12a401e6,0x9b37021b,0xaea900a7,0x10e70017}},	//   _pracujem, _надежды_, _орбитада, _सीबीएम_, 
   {{0x8248019b,0xa38701eb,0xe94e01dd,0x18940078}},	//   _akimis_, _ekuri_, _amalisit, _пустити_, 
   {{0xbdb00240,0xd2e800d5,0x00000000,0x00000000}},	//   _manumanu_, _didiana_, --, --, 
   {{0x03ea020e,0xeae60388,0xe5eb00da,0x53ea0049}},	// [1140] _esita_, _strument, _докторат, _huatu_, 
   {{0x7b51045b,0x22b4023f,0x81220097,0x8e8000d1}},	//   _територі, _riddled_, _jélàdé_, _নগৈছিল_, 
   {{0xc2480087,0x7cb6019f,0xdeca0372,0x1fac00ff}},	//   _ahomu_, _حالانڪ_, _acenmewn, _advokato, 
   {{0x32c0011f,0xf20105ed,0xb34a05b6,0x3e16025c}},	//   _андаа_, _imbibe_, _zelenou_, _alleskla, 
   {{0x5c670141,0xd3ea0455,0xcc8c0274,0xd18b018d}},	//   _sentabr_, _nuits_, _flutning_, _ንብጻይካ_, 
   {{0x165400cb,0x93f800ad,0x47bf04ad,0x7a670019}},	//   _abanalow, _nyium_, _gaotingw, _бурканда, 
   {{0xc2d802f3,0x72d901b4,0xe3eb0305,0x768101a6}},	//   _nyhet_, _wapen_, _gryte_, _keneturi, 
   {{0x52c50098,0x2dd201f4,0x89db013a,0x0d80006c}},	//   _fremmer_, _rishtala, _geleenhe, _ихели_, 
   {{0xa38705ee,0x169b0015,0x0de8002b,0x5eea018d}},	//   _ukuri_, _maleeshi, _শক্তিতে_, _ብታህዋኽ_, 
   {{0x3bf40487,0x93eb0168,0xc2e5023e,0xe07101f0}},	//   _toleranc, _bryte_, _صبوری_, _dipalamo, 
   {{0x2648039f,0xd26c0240,0x864c0010,0x2cd500a4}},	//   _wikiansw, _lolosi_, _ekuhambi, _سۉيگۅن_, 
   {{0x7a4502ac,0xe25a0010,0xf04c019e,0xe3ae0156}},	//   _ورومنسيا, _amelwe_, _журба_, _חיסרונות_, 
   {{0xa2d904c5,0xd2ca00cf,0xf327015e,0xeea703b6}},	//   _lapel_, _gudda_, _арамза_, _àkọọ́lẹ̀_, 
   {{0xc2ac00a4,0x5c5500e9,0xa6c80111,0xf3a900be}},	//   _турмушун_, _lintere_, _accupià_, _سووزۇپ_, 
   {{0xd320015e,0xc2d9022c,0x5103044a,0x72ca04d7}},	//   _danys_, _napel_, _emekanel, _audda_, 
   {{0x328f005b,0xc30c05ca,0xb27f01ad,0x586c013c}},	//   _bonheur_, _semanas_, _saanen_, _polisind, 
   {{0xae56032d,0xb601004b,0xbe500315,0xcd09020f}},	// [1150] _юристар_, _communci, _basabala, _ښکیلاک_, 
   {{0xf6390037,0x33ea0481,0x6248023b,0x90df0350}},	//   _የታሰበው_, _duits_, _okomo_, _ለአምስተኛ_, 
   {{0x1995032d,0xf2f1009c,0x8da10144,0x5b0c0116}},	//   _bakhatla_, _antahawi_, _pornagra, _claggies, 
   {{0x22d900f1,0x726c011d,0x62e00097,0x052d0177}},	//   _dapel_, _folosi_, _asunwon_, _иҟаларц_, 
   {{0x62ca004f,0x409600ba,0x28600148,0x09d703db}},	//   _guddi_, _داماوی_, _francoru, _ephelile, 
   {{0xc320018a,0x14a30138,0x53ea0144,0x81160095}},	//   _canys_, _bilimsel_, _crith_, _کالباس_, 
   {{0x2af605ef,0xe98e015e,0x1201044a,0x8b7b0227}},	//   _ressurse, _назик_, _bayiti_, _pangkuan_, 
   {{0xc47701a7,0xc26c00fe,0x828e00d0,0x13ea00bd}},	//   _проекта_, _kolosi_, _тангараг_, _buits_, 
   {{0x83ea00d6,0x23ea00be,0xc2240374,0x32cc0013}},	//   _frith_, _cuits_, _salkam_, _chidamli_, 
   {{0x7edc0043,0xa9ee005e,0x03fe0090,0x95c8005b}},	//   _abayudaa, _خەلپە_, _akazova_, _nakanish, 
   {{0x1b550265,0x626d04dc,0xdea100f2,0xb34703bf}},	//   _kinderen_, _بیروباوه_, _londonas_, _bolella_, 
   {{0x32fc008a,0x12010180,0x33ea0008,0x6aee00d1}},	//   _afiga_, _fayit_, _tuits_, _উচ্চবৰ্গ_, 
   {{0x8c27028b,0x935400c5,0xd213006c,0xd6370258}},	//   _крамер_, _mineurs_, _alahla_, _keizerry, 
   {{0x5b6d020f,0xc3dd00af,0x40df00e2,0x13ea007b}},	//   _ليسانس_, _thawte_, _moannebl, _ruits_, 
   {{0x32010205,0x11a5002b,0x89e00087,0x82da02d9}},	//   _hayit_, _মিঠাপুকু, _hoyozela_, _lutena_, 
   {{0x6201011c,0xa24405a3,0xef4505f0,0xe691014d}},	//   _kayit_, _रामानन्द_, _božiji_, _lesermei, 
   {{0x2847006c,0x21470060,0xa2cc0077,0xf2d9046f}},	// [1160] _ханафи_, _ханифа_, _chalimo_, _aapel_, 
   {{0x337800c7,0xcf490009,0x625b0033,0x320004b2}},	//   _рәсем_, _dogodivš, _chalà_, _etniko_, 
   {{0x12d9007f,0x638703da,0x4326015e,0x78fe0184}},	//   _capel_, _ekuru_, _تاقىمىڭ_, _biragend, 
   {{0xab850041,0xe2da0066,0x5310022d,0xca4c01db}},	//   _акнферен, _ostera_, _bauzia_, _ۋاتىممەن_, 
   {{0xf38705f1,0x030d05f2,0xf34b02d3,0x7e6501df}},	//   _nkuru_, _rematar_, _detetou_, _cambodie_, 
   {{0x02010414,0xd248000c,0x550502d4,0x53ea01b8}},	//   _bayisi_, _thoms_, _insembel_, _briti_, 
   {{0x833c0220,0x23ea0044,0xd27e00b9,0x49f601df}},	//   _процента_, _suits_, _mainin_, _desairve, 
   {{0x922b01f0,0x73ea0085,0x5c7d0150,0x7afc00bd}},	//   _baamore_, _driti_, _kwestin_, _admeenis, 
   {{0x83ea008f,0x0b4200f3,0x72ca003a,0xa2da02c8}},	//   _eriti_, _nokwenza_, _xuddi_, _mareas_, 
   {{0xc201016e,0x4224028d,0x72830251,0x4e640038}},	//   _elbise_, _malkom_, _imikana_, _алоэның_, 
   {{0xb2920285,0x42cf03a7,0x471c0040,0xc24800a2}},	//   _burayi_, _stimuly_, _בהכנסת_, _ukomo_, 
   {{0x4fa90409,0xbd0301a0,0xdc050430,0x9d8200db}},	//   _インテリア_, _afambile_, _lupunjab, _दुर्गादत, 
   {{0x0da00153,0x19740335,0x62e700d0,0x00000000}},	//   _とは異なる場合が, _bdhātuḥ_, _arinago_, --, 
   {{0xe63e018a,0x22b2015e,0x5b050064,0xc0f6015d}},	//   _clasurol_, _tindran_, _алмашты_, _असुरों_, 
   {{0x62010342,0x23f80245,0xe41a01eb,0xe671001d}},	//   _sayil_, _lyiuh_, _асистема, _cuidanti, 
   {{0xc2640075,0x326c0244,0x226c0285,0xb3ea0085}},	//   _skuldu_, _colori_, _nanone_, _drata_, 
   {{0xa22403db,0x698c0037,0x62ec029b,0x89e70089}},	// [1170] _lonke_, _ከቴክኒክና_, _barilee_, _раббысы_, 
   {{0xe2e70055,0xc26302eb,0x7daf022f,0x00000000}},	//   _turnata_, _minusbal, _kostiumu_, --, 
   {{0xb5c80379,0x829003ba,0x427e0074,0x034303a2}},	//   _पंचवर्षी, _maiana_, _rinnat_, _निशंक_, 
   {{0xc387021a,0x4e830385,0xac510052,0x60e100f3}},	//   _axarra_, _plivanje_, _जानेर_, _ibonakal, 
   {{0x627f001f,0x65cc0472,0x39770176,0x7f64000a}},	//   _baanan_, _lokasiny, _fornemme, _annaasin, 
   {{0xa2d601ef,0x52e90193,0x33ea0321,0xd3a30541}},	//   _stilius_, _ngentot_, _priti_, _korpu_, 
   {{0x8224047d,0xbefb001e,0x7702003b,0x017a00d9}},	//   _jonke_, _makwabta, _elucingw, _пропускн, 
   {{0xc2f4012a,0xa4b501e1,0x86d30109,0x53f90201}},	//   _podstawy_, _алманым_, _राजिव_, _maqub_, 
   {{0xb7060192,0x2b300092,0x8d8b00fb,0xd2360076}},	//   _오스트리아_, _havemøbl, _ngamapha, _beijar_, 
   {{0x62e30437,0x70c60125,0xeeea0039,0xa0ee0466}},	//   _magiske_, _azaltmal, _моделийн_, _šetališt, 
   {{0x9386013d,0x42ab001c,0x22f00006,0xc22402fe}},	//   _adoris_, _maripã_, _matilah_, _nonke_, 
   {{0x73790397,0x59aa0037,0x429200ad,0x7a0700ec}},	//   _yilapho_, _መኪናውን_, _oerang_, _памерла_, 
   {{0x43ea0200,0x127f033a,0x928a01db,0x42e9019b}},	//   _esite_, _spanja_, _асырылад, _паспяхов, 
   {{0x922401cd,0x624205c5,0xf67e0295,0xa69c0369}},	//   _konke_, _केरला_, _finefeui, _kaseluhi, 
   {{0x3e2f05f3,0xe8fd0556,0x13730288,0xd29200ad}},	//   _células_, _nabafund, _cigarre_, _herang_, 
   {{0x93f40257,0x93ea0129,0x8f880060,0x287301b6}},	//   _listir_, _isite_, _سابىلىسق, _aliquots_, 
   {{0x20e103db,0x02d90488,0x32910067,0x00000000}},	// [1180] _ebonakal, _kapec_, _gubaan_, --, 
   {{0x28fd03de,0xcb600047,0x4c8d0061,0x362e00d8}},	//   _babafund, _soumettr, _뿌리깊은나무_, _abrabanè, 
   {{0xee5202f8,0xfd4d0243,0x33f2020e,0xf26c00da}},	//   _angafaka, _murabbaq, _entelang_, _manole_, 
   {{0xe2da02eb,0x62fc048c,0x9bf10173,0xb29202f7}},	//   _dutela_, _beagh_, _calefacc, _ferang_, 
   {{0xd20100b8,0xc30c0159,0x96810109,0x36b40197}},	//   _payiri_, _idealas_, _गफगाफ_, _konsepsy, 
   {{0xf236035b,0x82000005,0x404702f7,0x63f00007}},	//   _svojo_, _obain_, _dituelon, _kresansi_, 
   {{0xb1f20392,0xb12d0354,0xe07d0241,0x8a6f0311}},	//   _chlaradh_, _рафто_, _dabballo, _ብዝላዓለ_, 
   {{0xbb46027d,0x82e90321,0x929201f1,0xe3f905ca}},	//   _privatna_, _intimna_, _kurani_, _saque_, 
   {{0x0d86017d,0x02d80097,0x2e9301a7,0x53ea0113}},	//   _明日の日経平均を, _aileto_, _kertovat_, _fuath_, 
   {{0xc59502ea,0x1f9005f4,0x51c30456,0x12d80373}},	//   _attribuz, _campiñay, _mustahak_, _bileto_, 
   {{0x5e5203ac,0xa3840184,0x31fa0529,0xbc04025f}},	//   _sedangka, _amasinem, _planovim, _emeseni_, 
   {{0xbb0d045e,0x178500cb,0x21420361,0x0ce3002e}},	//   _приют_, _авиатсия, _аттал_, _vođena_, 
   {{0xa2fe0191,0x9fb30086,0x3c110062,0x3af804ca}},	//   _inrikes_, _مصلحتوں_, _junqang_, _apaurime, 
   {{0xebd205f5,0x0b9201f2,0xaf5f04aa,0x72900521}},	//   _पप्पू_, _جەزمەن_, _domaneab_, _bankës_, 
   {{0x32c705f6,0xa3070442,0x8af7027e,0x78700097}},	//   _fødde_, _merajuk_, _наредио_, _padabọ_, 
   {{0xe3a80479,0x00000000,0x00000000,0x00000000}},	//   _gépre_, --, --, --, 
   {{0xd3ea018b,0xbc530204,0x8d8900e6,0x8fa50116}},	// [1190] _luati_, _vartija_, _添加到豆单_, _hellispo, 
   {{0xf996026a,0x5901004d,0xe277006c,0x8359006c}},	//   _eucheuma_, _功能提供滑鼠經過, _сахнаи_, _amafemu_, 
   {{0x5da80243,0xadbc0010,0x4a4b0187,0xe290024c}},	//   _farinita, _batukulu_, _desejada_, _felaħ_, 
   {{0xdc93003a,0xd2e50085,0x4c2a0350,0x00000000}},	//   _هاوان_, _kainoda_, _መቀነስና_, --, 
   {{0xa25a0244,0x3984028b,0xc8fd00d1,0x00000000}},	//   _dalle_, _ихақәиҭр, _কনকলতাৰ_, --, 
   {{0x231c00ae,0xc5cd0227,0x616f00d1,0xdbfd0155}},	//   _aracura_, _negarany, _ইঞ্জিনৰ_, _gaffeltr, 
   {{0xf6640012,0x053701a0,0x92cc0042,0xa1ab0153}},	//   _अकाससँ_, _idayirek, _apelido_, _バイオハザ_, 
   {{0x65ff0429,0x32910261,0x7b1f0095,0x525a017c}},	//   _ተግባራዊ_, _movado_, _pinangan_, _nalle_, 
   {{0xd791016d,0xc3ea003b,0x02d90039,0x7ecb021f}},	//   _كوللېكتى, _asate_, _mapea_, _ayiislan, 
   {{0xd02e00dd,0xd65e003a,0x12fe029a,0x668c00c1}},	//   _angerddo, _зидми_, _viziter_, _सणवार_, 
   {{0x72d70191,0x07ec0084,0xfc510049,0x98e900da}},	//   _villkor_, _majaleng, _faktaha_, _причинуи, 
   {{0x5b3000b0,0x70470444,0xde630088,0x00000000}},	//   _garanayn_, _забором_, _курчалып_, --, 
   {{0x827e00bd,0x22c50195,0xc53a01a0,0x03ea0039}},	//   _bonnie_, _bremner_, _empiresh, _eratu_, 
   {{0x526c03ff,0x3fee00ff,0xe0f0000a,0xe30b0278}},	//   _nehoda_, _מוזשיי_, _affarmik_, _membiak_, 
   {{0x357d0242,0x3ea400da,0xa9830289,0x9c730157}},	//   _markalı_, _стандару, _amazungu, _siostra_, 
   {{0x9292022e,0x737205f7,0x4ea50177,0xdd980192}},	//   _murali_, _gadawyd_, _игәаан_, _receptie_, 
   {{0xcb2a02af,0x3d8904e7,0xc354033d,0xf2920309}},	// [11a0] _ababirab, _aaadopyt_, _atletis_, _qurani_, 
   {{0xf395045f,0x7a76039d,0xd3cc0044,0x0592019b}},	//   _flesta_, _hangwela_, _הלקחנים_, _ўнутраны, 
   {{0xacaf012c,0x228402c1,0xd4d700b7,0xcc56042e}},	//   _تماشو_, _amahano_, _гараны_, _fattige_, 
   {{0xd63200c1,0xa3780281,0xe9db0009,0xfec80064}},	//   _निवासस्थ, _affaata_, _kazenske, _шексиз_, 
   {{0x53f90353,0x491401ca,0xed9c0338,0x2c10040f}},	//   _nebude_, _bipaschu, _absoluda, _чэлес_, 
   {{0x127f041f,0x745d05f8,0x53ac04b3,0x222b018b}},	//   _iqanda_, _корректн, _albanieg_, _trimise_, 
   {{0x13ea0550,0x6c6101b2,0x09e0017d,0xe2cb044a}},	//   _usate_, _slurred_, _platitud, _tokolia_, 
   {{0xeb8b018d,0x21cd008d,0xe3490220,0x8b610065}},	//   _ክትገልጽ_, _азимжон_, _disegni_, _stellver, 
   {{0x9e6c0039,0xeab40072,0xd33e0187,0x62910119}},	//   _азарга_, _daikojin_, _приватен_, _mayada_, 
   {{0x1d6c00a4,0x2cfd018d,0xc2da0065,0xe2e10121}},	//   _партиясы_, _ንህሉዋትና_, _metern_, _plantel_, 
   {{0x516f0135,0x6850025f,0xe3ea053e,0xf3fd05ed}},	//   _kimendä_, _bakoland, _dratt_, _ikiziga_, 
   {{0xd2c30118,0x289901c6,0x4bda018b,0xfb350280}},	//   _okulaba_, _beskreau, _прилежуи, _कमोबेश_, 
   {{0xe3880087,0xe2940206,0x12d902ff,0xc96e00b2}},	//   _chayana_, _stratili_, _imanite_, _fayiloot, 
   {{0xb2910358,0xf3ea0066,0xc12d0302,0x33550372}},	//   _abyata_, _tratu_, _рабте_, _druenus_, 
   {{0x2248025f,0xd2d504ca,0xfa190137,0x55d10051}},	//   _akomi_, _alcoran_, _бэхжиж_, _tavuprāt_, 
   {{0x23ea0081,0x5559009b,0x139603e6,0x00000000}},	//   _hratt_, _харварды, _dasste_, --, 
   {{0xa48700c1,0x6bfd012a,0xbc750031,0x11bd03f2}},	// [11b0] _माझाही_, _kulturys, _टिक्का_, _диету_, 
   {{0xaede0164,0xc2ef0399,0xb20202ff,0xeaeb044d}},	//   _динда_, _fungalei_, _jouinn_, _melokaan_, 
   {{0xb38701b0,0x835f01a6,0x00000000,0x00000000}},	//   _akaran_, _pongere_, --, --, 
   {{0x33e10206,0x11ce005d,0x3200012b,0x229101fe}},	//   _klientov_, _ehaopavẽ_, _zamian_, _vayaga_, 
   {{0xfe300071,0x9c3d01bb,0x7ced0162,0x12f501be}},	//   _پروازهای_, _saklanýa, _سۇرايمەن_, _rizikem_, 
   {{0x929001ff,0x6fe80139,0x00000000,0x00000000}},	//   _najavo_, _विभावना_, --, --, 
   {{0x509600c5,0xc9430249,0xd3f8031a,0xa34001ab}},	//   _搜狗拼音输入法_, _evaluese, _chluba_, _दुनूं_, 
   {{0x6c6102f8,0x1815005b,0x811804df,0xd2b50347}},	//   _fotunga_, _darlinｇ_, _chykmaly_, _liedere_, 
   {{0xc3ea03fc,0x133c00ff,0x33fd025f,0x33ea01ad}},	//   _bratt_, _פּטירה_, _banzela_, _comtã_, 
   {{0xeaf10101,0x931300b4,0x3ba7027b,0x83410282}},	//   _prezenta_, _functia_, _ह्यत्र_, _koperea_, 
   {{0x43f901c4,0xf8e600d7,0xa5440219,0x7b9f0282}},	//   _debuut_, _тартма_, _emkhankh, _pokerehū_, 
   {{0x32fc000b,0x56b905f9,0xf2ff0516,0x425a001d}},	//   _agiga_, _críticas_, _lorimer_, _colleg_, 
   {{0x12270590,0xdb370426,0xa395025e,0x68370397}},	//   _магнай_, _यसैबीच_, _blessa_, _ватане_, 
   {{0x62e70321,0x1bd20206,0x03bb0092,0x722701f4}},	//   _prilagoj, _pochopiť_, _掲載情報について, _карнай_, 
   {{0xa6e90410,0x6509033f,0xb1750381,0x92c100f3}},	//   _tlhakišo_, _haateiho_, _agondray_, _behlola_, 
   {{0xd8c20192,0x88a70025,0xc7bb0245,0xb8f9026c}},	//   _자세히보기_, _adhoakṣa, _lamumshi, _romanoru, 
   {{0xc850048f,0x82ff01c8,0x3722004d,0xf5390126}},	// [11c0] _bakoband, _vitríny_, _航空公司拖欠機場, _прогляну, 
   {{0x88e90034,0xc36402ac,0x49d20487,0xe5f002d6}},	//   _tilgangu, _أوامر_, _notewort, _педиатри_, 
   {{0xe01401bb,0x99e600ac,0xeda80482,0xdd570040}},	//   _йыкылан_, _dovoljna_, _karibita, _preceded_, 
   {{0x3ea10003,0xe688008d,0xfd7e01f0,0x929101dd}},	//   _부동산써브_, _гипермар, _abalanwa, _abyara_, 
   {{0x0fc0032a,0x00000000,0x00000000,0x00000000}},	//   _ilungrso, --, --, --, 
   {{0x0af502c8,0x6e5301a6,0x00000000,0x00000000}},	//   _poderans, _tohatoha, --, --, 
   {{0x1f5700db,0x29a9005e,0xad340163,0x3e9a01cd}},	//   _जिंगी_, _ئىملاسى_, _نخواستہ_, _anqunywe_, 
   {{0xce5401d1,0x8d30002e,0xff27018c,0x00000000}},	//   _financia, _većem_, _geperson, --, 
   {{0xe6b800c7,0xf44803d4,0xe33800f5,0xdb6101ad}},	//   _redaktsi, _критиков, _болдулар_, _villaver, 
   {{0xc7950061,0x73ea0211,0x5a800109,0x326405f4}},	//   _전체의견보기_, _osata_, _kolegyně_, _chullu_, 
   {{0x13ea0499,0x2d480145,0x7dd90125,0xe4b101f4}},	//   _usita_, _pagaliau_, _билдирйа, _پیغاملر_, 
   {{0xb27703be,0x92eb0073,0x196801c9,0xd957048c}},	//   _akanyoni_, _scripto_, _valimise, _censurer_, 
   {{0xb62902f7,0x5bea01aa,0xc02b0244,0x87d00040}},	//   _bafilisi, _ackwards, _допринас, _המספקות_, 
   {{0x43950129,0x43f80480,0x284602d4,0xd54300b9}},	//   _emesia_, _ahluka_, _realisad, _ibuhamil_, 
   {{0x7c7c01f6,0x72ca008d,0xf754006c,0x99f900ea}},	//   _startar_, _huddi_, _akunjeng, _bilakare, 
   {{0x320e00ee,0x5eef0059,0xe9f302ff,0x9d9c0198}},	//   _санал_, _здравно_, _flurpoid, _obkljuka, 
   {{0xef1a05fa,0xc3ea005b,0x0300017f,0x9598019b}},	// [11d0] _ओरिजनल_, _esata_, _tamaani_, _нарачанс, 
   {{0x5fd4002a,0x3224003a,0x8ae0040e,0xd8bf021c}},	//   _ezinaulo, _balkim_, _বেতাঁৰ_, _homecred, 
   {{0xd38700b5,0x37470145,0xd0610086,0x2d950040}},	//   _ajura_, _белмузтв_, _بنارس_, _פורטו_, 
   {{0x33fb0091,0x91c600c5,0xf38604da,0x32900364}},	//   _aturiami_, _保持共产党员先进, _pokraj_, _opnam_, 
   {{0xc1880213,0xfc080488,0xe20002b4,0xce1d0059}},	//   _простейш, _nomainīt_, _buniyo_, _aspettia, 
   {{0x925b0116,0x4258004b,0x00000000,0x00000000}},	//   _hetly_, _khothall, --, --, 
   {{0xcfbc0037,0x9f2c0084,0x175c00e6,0xa5590133}},	//   _የሚዘወተሩ_, _perenahn, _从吻的部位看男人, _feekeeny, 
   {{0x8e4c021a,0xea48005e,0x02d50053,0x63fe00a6}},	//   _arrabsee_, _ﺭﺍﻳﯘﻧﻰ_, _bocoran_, _ezaziwa_, 
   {{0x03ea0386,0x20e90275,0xfd320066,0xf575030a}},	//   _suatu_, _kapiliel, _argibide_, _riotorto_, 
   {{0x9f6f05f4,0x8af205a6,0x4d0c00c8,0x1e7700a7}},	//   _achanpas_, _debutert, _ҡылды_, _داندان_, 
   {{0xb26c04d3,0xec9302b9,0x6ae104f9,0x82ce017a}},	//   _proofs_, _کانام_, _alaufese, _навалний_, 
   {{0x037d00ac,0xbda702af,0xec0a0143,0xf7950420}},	//   _disanje_, _butoseka, _включа_, _кутија_, 
   {{0x40680064,0xb1a70029,0xcd2701de,0x1068010e}},	//   _баяндалы, _نامۆیی_, _оранды_, _balahibo, 
   {{0x97d0017f,0xc18c006e,0xd25a01c0,0x6064033d}},	//   _itisilii, _cawartey_, _zalla_, _envansyo, 
   {{0xc25a0243,0x1ccd0374,0xd2910096,0x36f402d8}},	//   _yalla_, _даражага_, _abajepe_, _जनावरे_, 
   {{0x42f0008e,0x87d9040b,0xd3000179,0x198701eb}},	//   _abdulaay_, _mutahabv, _lefaili_, _hẽngue_, 
   {{0x035b0120,0x8b3f00ff,0x220202a3,0x74d00291}},	// [11e0] _mangaba_, _וווּהין_, _louisn_, _يشكلون_, 
   {{0x3347003d,0xeba7019b,0x075703b0,0x547304ae}},	//   _quadres_, _greičio_, _breiddeg, _клинтона_, 
   {{0x627f0244,0x97dc0128,0xfa87020f,0x1e4a005d}},	//   _eventi_, _талаблар_, _akazanga_, _ipbansca, 
   {{0xa3790193,0xaf6c0037,0x03f80203,0x00000000}},	//   _matanya_, _በመተግበር_, _nejust_, --, 
   {{0x42d80410,0x03ea00d6,0x927c002b,0xcb550259}},	//   _bilego_, _brath_, _কল্পনার_, _vinderen_, 
   {{0x726c02e7,0x13ea0195,0xb52a0235,0x5fe305fb}},	//   _dumog_, _crath_, _caritasy, _sirijsko, 
   {{0x8dfa008d,0xf76100e5,0x442a0183,0x52350458}},	//   _сайловчи, _кварт_, _fararano_, _jordvarm, 
   {{0x0c82048a,0x927803ef,0xd201041c,0xa224005b}},	//   _өлкетану_, _mpunzi_, _bayit_, _bonko_, 
   {{0x22910286,0x9d4b05fc,0xc97f0041,0x54440311}},	//   _abaawa_, _निरीक्षक_, _moõrupíp, _ዝዓለመት_, 
   {{0xa25a004f,0x837905fd,0x927704ce,0xbae60057}},	//   _walla_, _katanya_, _shangoni_, _berlesen_, 
   {{0x635e045d,0x5aa90187,0xb3ea027b,0x2c17011a}},	//   _fondacij, _печете_, _asito_, _לגביו_, 
   {{0xb317003a,0x647a0074,0x09370060,0x1379010d}},	//   _ommaviy_, _osittain_, _بىلسەڭدە_, _datanya_, 
   {{0x61890056,0x73400007,0xc7a2020e,0x69db05b9}},	//   _фармонде, _angenga_, _barutisi, _velfunge, 
   {{0xe3dd0375,0x7b180144,0x507e0260,0xf26e0449}},	//   _akumaliz, _bhialann_, _carballo, _letovi_, 
   {{0xf63902b1,0xf3ea0059,0xec0103f7,0x227f0059}},	//   _likitoci, _esito_, _breskar_, _aventi_, 
   {{0xf64800f9,0xa8e80061,0x425a014b,0xe74b00d1}},	//   _bishingi, _건축계약서_, _qalla_, _ডায়ৰেক্ট, 
   {{0xca150015,0xd16f002b,0x5aea019a,0x92000158}},	// [11f0] _islaamka_, _ইঞ্জিনে_, _gallopin_, _ramion_, 
   {{0x2c010073,0x14a80390,0x506a0433,0x32020089}},	//   _gentiles, _başlanıb_, _mapasabo, _ixtiar_, 
   {{0x23860226,0x1692008d,0x00000000,0x00000000}},	//   _adera_, _турсунов_, --, --, 
   {{0xc8cb0094,0xc7f90037,0x2e5f0037,0xf25b003f}},	//   _съезде_, _በማግኘቱ_, _ነግረውናል_, _javles_, 
   {{0x2581007d,0xb94e0396,0xc2780008,0x52fc0387}},	//   _bermalam_, _adoloxxe, _tornem_, _ogige_, 
   {{0x92e30288,0x7dd00189,0x21a002ed,0x227e00bd}},	//   _gehilfe_, _merkezde_, _aproxíma, _nowherex_, 
   {{0xe25a002d,0xf2cb0059,0x00000000,0x00000000}},	//   _mallo_, _manovra_, --, --, 
   {{0x4264025b,0x0e4c043a,0x82d502d9,0x00000000}},	//   _skullu_, _lekanana, _tosovaa_, --, 
   {{0x43ea01d4,0x09da02be,0xbf17023a,0xf37d0453}},	//   _erati_, _amandeep_, _dromedar_, _sisanje_, 
   {{0x53ea0111,0xd2010428,0xc74e01a5,0xd9ca0193}},	//   _frati_, _dobite_, _grunnleg, _संयोजकां, 
   {{0x0897028a,0xa3eb03b0,0xacfe0037,0xa2e90416}},	//   _مرتبي_, _gryta_, _ትፈልጋለች_, _exsicca_, 
   {{0x9d9b04bb,0xc224005b,0x74b8033e,0xd27e014b}},	//   _onionhea, _tonko_, _ливадиит, _sinnit_, 
   {{0xc25a016b,0x78b301d7,0x42d701e8,0x00000000}},	//   _kallo_, _festivar_, _govorko_, --, 
   {{0xc98e0391,0x53eb02f3,0x160d033a,0xd396001d}},	//   _фатир_, _bryta_, _assoluti, _lassat_, 
   {{0x525a0371,0x769d00a4,0x605201bc,0xe351009d}},	//   _dallo_, _preferei, _bedrigin, _sigurinë_, 
   {{0x416b0352,0x2d0700c8,0x969b0420,0x25200015}},	//   _অসমাপিকা_, _китапҡа_, _скриена_, _haboonay, 
   {{0x013b02eb,0xe84400c1,0x7afd04d7,0xd2cf0291}},	// [1200] _жигүүртэ, _लेखसंग्र, _sprengis, _folcadái, 
   {{0xaf6a028d,0x29620064,0x8dd303f1,0x3a4c03d8}},	//   _laparans_, _деректир, _posklada, _čudesna_, 
   {{0x8e54041e,0x8344019f,0xc3ab0405,0xa16903ac}},	//   _minaccia, _sanduku_, _уявлення_, _batiniah_, 
   {{0xb65a010f,0x5a9f04a6,0xa2e902d9,0x526002ee}},	//   _сарбалан, _zavisnos, _kitiona_, _bilingwi_, 
   {{0xf3ac024b,0x9379034c,0xc14105fe,0xbb690456}},	//   _grupos_, _natalya_, _बिरंगी_, _temuduga_, 
   {{0x725b014a,0x0b0600b3,0xf06200fb,0x9f690488}},	//   _emelet_, _awestada_, _kwesigun, _nemaldos_, 
   {{0x423605ff,0xcb060226,0x79460111,0xf200023a}},	//   _diljem_, _akusunga_, _agalabat, _ramien_, 
   {{0x5f07002f,0x2ac10010,0xd26b0128,0x77870060}},	//   _pinceles_, _abukisis, _ایشلیدیگ, _جاناسىڭ_, 
   {{0x5fc40553,0xe9e60099,0x725a02e9,0xb2000461}},	//   _šírenie_, _hurumend, _fallo_, _zunino_, 
   {{0x33ea01e6,0xa25a0120,0x35120297,0xb5ba02d6}},	//   _trati_, _hadle_, _başlaunı_, _ярмаркал, 
   {{0xf25a01e1,0x91d90065,0x268e0331,0xd5040011}},	//   _союзының_, _vollkomm, _spreingi, _amutango_, 
   {{0x923602d5,0x5c670095,0x04930135,0x14ba025f}},	//   _hiljem_, _حرکات_, _almagaçl, _eyebisak, 
   {{0x03ea0145,0x592b00e4,0xd6f7020f,0x7a3200f8}},	//   _esate_, _फलाहारी_, _برابرېږي_, _নলছিটি_, 
   {{0x6a8a0209,0x712d0013,0x86f5004a,0xfa0d01c9}},	//   _aaqitass, _матто_, _cirteträ, _klassiju, 
   {{0x23870387,0xe21902b2,0x725a0212,0x03ea04c8}},	//   _ajuru_, _режиму_, _vallo_, _qrati_, 
   {{0xa38102a2,0x6afd017d,0xa00e02c0,0x00000000}},	//   _ngayong_, _overhale, _холанѓан, --, 
   {{0xd20102bb,0xf86d00e4,0xa1e302d5,0xd2b20278}},	// [1210] _kobiet_, _आदिवासिय, _अधमरा_, _pindaan_, 
   {{0xb385032a,0x40520144,0x0200005b,0x626e02cb}},	//   _grønland, _phortain, _adoigj_, _setovi_, 
   {{0x02910439,0x89f60418,0x02f4004f,0xf283006f}},	//   _mayana_, _durumunu, _bidiwam_, _alikana_, 
   {{0x09c00120,0x7e5203c6,0x235f0192,0x1c030037}},	//   _haweenet, _belangha, _jongere_, _kompang_, 
   {{0x87a601c2,0x125a03f2,0xccff0037,0xdf1604c9}},	//   _estratex, _pallo_, _አይስላንድ_, _magtatap, 
   {{0x720005c9,0xc2f0007a,0xb9f1048a,0x00000000}},	//   _ncaim_, _fatimah_, _تىلشىلەر_, --, 
   {{0x4cb4004d,0x00000000,0x00000000,0x00000000}},	//   _健康美容交流_, --, --, --, 
   {{0x69e20303,0x635f00a9,0x72d102bd,0xc96e021b}},	//   _bapisiwa_, _nongere_, _bostiwch_, _mainiost, 
   {{0x82c200fa,0x86d20207,0x97db0357,0x5a140163}},	//   _bibliya_, _kuhakiki, _delainav, _خبريں_, 
   {{0x5ac200c1,0x035f0239,0x6201005b,0x0bab0273}},	//   _जाणीवपूर, _hongere_, _bseina_, _precisó_, 
   {{0x1593035e,0x8d3304cb,0xba15002e,0xc96f0272}},	//   _prilikom_, _теодоров, _stvarima_, _abangobe, 
   {{0xb27e02bb,0x42eb008d,0x8af701f7,0xc52d02a2}},	//   _sceny_, _dasturiy_, _consomat, _kapistah, 
   {{0xf47300e6,0x340100d0,0x4c970290,0x4f57032d}},	//   _农民专业合作社成, _foroetak, _celebrau_, _митингығ, 
   {{0xd9f2024f,0x462a008d,0x88b005cd,0x00000000}},	//   _daligada_, _tariqasi, _østerbro_, --, 
   {{0x53f80216,0xc347000e,0x02ca047d,0x22e80167}},	//   _ahlula_, _stadies_, _gudds_, _nerfus_, 
   {{0xc9a6003a,0xb291028a,0xe2920240,0x70cd0156}},	//   _амалдаги_, _hayana_, _taqaya_, _מיצװה_, 
   {{0x28bb0141,0x120201d4,0x17ed0011,0x130e0108}},	// [1220] _mirtohir_, _meritu_, _babaleng, _dibalur_, 
   {{0x725a014b,0x06a9031a,0x63a30521,0x1c0901e5}},	//   _aalle_, _barraich, _mirpo_, _isipaya_, 
   {{0xc30d015e,0x9baa02d6,0x9a070281,0x00000000}},	//   _demanar_, _қўлма_, _innarlee, --, 
   {{0x147a019d,0x002602e7,0xf6820097,0x1c06005b}},	//   _afafaniz, _magdadao, _pureposi, _harurunb, 
   {{0xf38700a4,0xfaec05b7,0x00000000,0x00000000}},	//   _negres_, _zastarje, --, --, 
   {{0x002b0363,0xd2fe023f,0x52ef045f,0x8429020e}},	//   _tradisjo, _thrives_, _gunilla_, _bokhelek, 
   {{0xb25a02d5,0x9b6504e5,0x224802e2,0x3560006c}},	//   _talle_, _addukira_, _acomax_, _кимиёӣ_, 
   {{0xeb0c052c,0x5f3d013c,0x2c260040,0x5f8600a7}},	//   _سابیر_, _aparatla, _אינטימי_, _агронасы, 
   {{0x5d890329,0x267f025e,0x69680499,0x31170061}},	//   _normalma, _eindregi, _iunivese, _고교등급제_, 
   {{0x98aa018d,0xcbc70137,0x9302018f,0xdf5c0255}},	//   _ብምግሃስ_, _сахлын_, _daladqu_, _kavatseb_, 
   {{0x617400ff,0x8292040f,0xd29000a5,0xea870234}},	//   _סטריזוב_, _nesate_, _taiala_, _sẹ́kún_, 
   {{0xc28300ec,0x825a0243,0x9fa200ba,0x99c504e5}},	//   _palaikym, _qalle_, _میزڵدان_, _baamemba_, 
   {{0x802e025c,0x2556032d,0xe2010211,0xa339020f}},	//   _kraftsto, _ынтылышы_, _upeita_, _دسړکونو_, 
   {{0xf387045f,0x7cf20122,0x32000082,0x31970204}},	//   _svarta_, _خاتمه_, _jamian_, _влагалищ, 
   {{0x12f30169,0x5c6a00e4,0xabf1009b,0x434101d7}},	//   _ড্রোন_, _laptopy_, _kalebarr, _basegna_, 
   {{0x6b20007e,0x53860121,0xa40e04ca,0xcfdd04df}},	//   _apragalb, _peores_, _amarnian_, _berersiň, 
   {{0x6db102d9,0x42f70281,0x0f7100fd,0x790b004a}},	// [1230] _lafumanu_, _aqqinik_, _iapanais_, _аягың_, 
   {{0xa25a0222,0x632005ce,0x89e300b3,0x9c7601eb}},	//   _salle_, _şeyin_, _ромада_, _deputas_, 
   {{0xa3860558,0x2a230060,0x169b02a4,0xfda50087}},	//   _edere_, _кішкене_, _suffragi, _herisiwa, 
   {{0x6b1e0064,0x137302be,0x0bc60100,0x634103bf}},	//   _جامعىردا_, _alalaong_, _deterdže, _kelello_, 
   {{0x43860099,0x63480244,0xe83e018d,0x7936002b}},	//   _ndere_, _modelli_, _ፋይናንሳዊ_, _নাস্তিকে, 
   {{0x038b00c3,0x954c003a,0x7e70030d,0xfe5701b2}},	//   _加入我的最愛_, _гулистон_, _kapitalı, _armbadge_, 
   {{0x8df10015,0x725a013a,0xc05f0378,0x00000000}},	//   _caddaata, _folleg_, _gimstein, --, 
   {{0xe3050113,0x129700f1,0x399c0072,0x29630015}},	//   _دورات_, _adekwat_, _munktana_, _minnisot, 
   {{0xb3860356,0x42da006f,0x3867034c,0xf395017a}},	//   _ukirin_, _kuteka_, _аркама_, _amesha_, 
   {{0x4c7c0074,0x5ff802a9,0xa35600c1,0xf160005a}},	//   _muistan_, _пацьверд, _कबुली_, _lomnitlh_, 
   {{0xc25a01d9,0xc5660156,0x22ca015f,0x46980153}},	//   _kolleg_, _אבסעסיע_, _erddi_, _アイちゃん_, 
   {{0x62cf033a,0xc301024a,0x9be50144,0x03be009a}},	//   _permezz_, _adobaje_, _randamac, _ayivumi_, 
   {{0x370700e6,0xcaaa04ca,0x62480014,0xca950373}},	//   _请输入关键字_, _archeves, _njoma_, _antitrib, 
   {{0xf396046f,0x92910170,0x5ba60299,0x00000000}},	//   _basste_, _hayala_, _تۇغلان_, --, 
   {{0xcfb90275,0x4d5000e6,0xb1d8020f,0x00000000}},	//   _logologo, _专题交流会_, _خوبياهم_, --, 
   {{0x829d03a7,0xa7d9008f,0x53f20308,0xa2ea00ee}},	//   _všade_, _लालकिला_, _ditebang_, _zatitan_, 
   {{0xa272001a,0x91540388,0xcd810115,0x120d0444}},	// [1240] _tűnik_, _difficol, _berlelua, _заданные_, 
   {{0xb9680003,0x6bb6028b,0xc2fc04aa,0x086d0287}},	//   _activite, _avaháich, _ngaga_, _procesů_, 
   {{0x2b8101ff,0xd3070195,0xe9470133,0x835402ed}},	//   _sledovať_, _agbaidh_, _atileeot, _empezou_, 
   {{0xe29202ee,0xdaaf0192,0x622401b5,0x341601cd}},	//   _rurali_, _원칙적으로_, _donki_, _дурандеш, 
   {{0x5a7b0600,0x34a80046,0x3d1c0033,0x03dd003e}},	//   _संवेदनाक, _paralitz, _brambrüe, _вакантлы_, 
   {{0x72d60601,0xec280036,0xe3ed02ee,0x06c50233}},	//   _negosyo_, _ديانا_, _barrieri_, _inusabil_, 
   {{0x08f6049f,0x626c013d,0x44f8028b,0x00000000}},	//   _kuzakuvu, _idioto_, _excursón_, --, 
   {{0x91440040,0x0a2702a6,0x12ea0408,0x12f50066}},	//   _הארצית_, _riscalda_, _batisan_, _politak_, 
   {{0x72f00350,0x625b0111,0x13150445,0x604b04a7}},	//   _fatihah_, _acellu_, _império_, _carrican, 
   {{0x19ed0077,0x12dc01e9,0x8d0a018c,0xf4330094}},	//   _majistra_, _babotsi_, _dierenar, _گرامماتي, 
   {{0x144b028a,0x92e5005b,0x33d5013d,0xd27f001c}},	//   _انگلنڊ_, _shinoda_, _protekti_, _ibanan_, 
   {{0x5d760207,0x22fa00f3,0x2db7004d,0x73bb00de}},	//   _گرانٽ_, _egehena_, _供應塑料桌子_, _معتبرو_, 
   {{0xe26c007f,0xee4900db,0xa8b8032d,0x66960307}},	//   _ormod_, _jagamine_, _нистрати, _kusekuni, 
   {{0xe6ad02a5,0x1f3803a2,0x62ed01cd,0xb395033d}},	//   _orgánů_, _लडकियों_, _тақаллуб_, _clesca_, 
   {{0x727e010b,0x13ac0488,0x279c00ee,0xe2c4013c}},	//   _dinnye_, _grupas_, _puntuazi, _hikmət_, 
   {{0x8bf101a3,0xdd4b0369,0xe5b8030b,0xcfb90004}},	//   _بروھي_, _makawalu_, _aligaziy, _cooloomo, 
   {{0x1154002e,0x9da8007f,0x2c620378,0xa3870051}},	// [1250] _budućnos, _recordia, _maturin_, _negrib_, 
   {{0xdd310195,0xa5680311,0x3d940008,0xc96003c2}},	//   _earsnaic, _ዝተተርጎመ_, _бездерди, _blundere, 
   {{0xa0940044,0x74b4034e,0xcc530541,0x787303b8}},	//   _פרידמן_, _achallik, _obrtaja_, _پروپەتسي, 
   {{0x2fb901e9,0xbc7f0095,0x5e4300da,0x527f01c7}},	//   _bogologo, _abimanyu_, _рничирил, _abanan_, 
   {{0x13f003bf,0x1c8602eb,0x726c0369,0xb17300d1}},	//   _balehang_, _эрдсийн_, _rehoba_, _দক্ষতাৰে_, 
   {{0x245503cb,0x226d02d5,0x225a00f0,0xf25b03fb}},	//   _convocan_, _बसेषा_, _sadla_, _hvalio_, 
   {{0x137301b4,0xa3ea0052,0x1abf018d,0x21ac0189}},	//   _stelling_, _bratr_, _ድልዱልን_, _yalattır, 
   {{0x273d0089,0xa13504a6,0x033b018d,0x7075000a}},	//   _afanasev, _portparo, _ዝተሓደሰ_, _assammio, 
   {{0x625a0005,0xe5ac0013,0xc378031c,0xf37f0333}},	//   _dalla_, _tenglash, _alcanza_, _annanta_, 
   {{0x92d3014a,0x177f032b,0x3c710486,0x00000000}},	//   _motorok_, _سەمرا_, _डेन्टल_, --, 
   {{0xd3ea0388,0x8a7f0299,0x00000000,0x00000000}},	//   _usata_, _ساداسىغا_, --, --, 
   {{0x62d503e9,0xe9470244,0x34d70060,0xc90502e0}},	//   _eýesi_, _писане_, _сарайы_, _baobamed, 
   {{0x8a1c046f,0xcb730287,0xd2c301cd,0xe2ff00e6}},	//   _verbanne, _jednolůž, _akuloba_, _diriger_, 
   {{0xf7a50211,0x479c01d7,0x422a0238,0x0e4d0347}},	//   _светодио, _sentenzi, _посад_, _paragraa, 
   {{0x963802f0,0x9795004d,0x59d40462,0xa45c0234}},	//   _akhlélwa, _廣告刊登連絡_, _atherine, _àgọ́_, 
   {{0x92360360,0x13a2005b,0x488a00ef,0x51670314}},	//   _svoji_, _ponpon_, _bekhumbu, _шатбыҙ_, 
   {{0x938701cc,0x87cd002b,0x831e0372,0x12da05f2}},	// [1260] _akaron_, _মহররম_, _anochel_, _sotelo_, 
   {{0xd2df05aa,0xf7890223,0x02000083,0x65b600d8}},	//   _ladning_, _гандантэ, _camiun_, _cachaviè, 
   {{0xa6320177,0x75ab032c,0x6c520365,0x0d69032b}},	//   _ахысбыжь, _gummibåd, _सिआइए_, _ساراڭلار, 
   {{0x8dbf01a4,0xc292030f,0xab3801bb,0x66250400}},	//   _andimela, _auraki_, _элъетерл, _affitivi, 
   {{0xc9a70088,0xe2780181,0xf6b80137,0xc2e80099}},	//   _алмашылы, _fornem_, _дээхнэ_, _edzimba_, 
   {{0x93a802f7,0x4d2c0202,0x82900340,0x4da70462}},	//   _etlareng_, _lonibise_, _paiaka_, _askingta, 
   {{0x96010006,0xa2e3012a,0x7493034c,0x1224005b}},	//   _mendalam_, _podobny_, _almayaça, _genkai_, 
   {{0x19800132,0x22240286,0x77e80255,0xd2550280}},	//   _kivitele, _donku_, _strateeg, _सौतेली_, 
   {{0x8290039e,0xf29200a1,0xd52f0062,0x40790137}},	//   _opnar_, _turaki_, _dativmoh, _янзлах_, 
   {{0x32910399,0xce820400,0x3fca0188,0x356c00a7}},	//   _iaaaaa_, _cervelle_, _пурқурбо, _داۋىنچىڭ_, 
   {{0x228701a6,0xfc760321,0x4d0503c9,0x041201d2}},	//   _arokite_, _izbrali_, _enkleste_, _chinpank, 
   {{0x787204ed,0x078b04e5,0xd9c10602,0xfade0296}},	//   _हरिश्चंद, _agajjang, _moderere, _auktorit, 
   {{0x3da3047d,0x727e046f,0x4b970156,0x9f35003d}},	//   _sonnenop, _demno_, _amantino_, _conclús_, 
   {{0x41ad0444,0x89020092,0xaf400479,0x985e00ff}},	//   _развитию_, _は参考になりまし, _térfogat, _aperigas_, 
   {{0x2a86024a,0x32fe01b8,0x6405015d,0xe9170061}},	//   _nítorí_, _haridus_, _गीताप्रे, _설문조사를_, 
   {{0x642b0603,0xc2800588,0x914b00de,0xbeaf0084}},	//   _कवितासंग, _abakene_, _angezihl, _cikondan, 
   {{0x97a400ff,0x83860014,0x00000000,0x00000000}},	// [1270] _באַסטי_, _nderi_, --, --, 
   {{0xf3870367,0x338602a0,0x529d0551,0x0294005b}},	//   _regras_, _ideri_, _amijaya_, _arakaki_, 
   {{0xe2d9045c,0xf986015b,0x0956004d,0x634100a8}},	//   _chcela_, _edukeise, _印尼蘇門答臘地震, _alpetta_, 
   {{0xe292013a,0x79fa00a1,0x1d8901b9,0xaefc00db}},	//   _suraki_, _pitihana_, _formelma, _leevenda, 
   {{0x7dbc01b8,0xa4a30265,0x50a80361,0x00000000}},	//   _regionaa, _schimmel_, _декъар_, --, 
   {{0x01570183,0xd4f000e5,0xd291015a,0x627e0092}},	//   _anarambo, _делимано_, _duraanii_, _clonic_, 
   {{0x20f00349,0x363f00b6,0xed0e0014,0xb943000a}},	//   _acticall, _daleelá_, _olimpike_, _avalatse, 
   {{0x34100437,0x2e6900be,0x70530126,0x63cf0465}},	//   _forsiden_, _ايىتپ_, _правової_, _pravil_, 
   {{0xbb6c00db,0x729100c5,0xd8550144,0x16df0037}},	//   _वामना_, _urbain_, _análú_, _እንደዛው_, 
   {{0x21380086,0xbe3b0326,0x234401cf,0x224f044a}},	//   _ابدالی_, _achakupa, _aquelle_, _balokoti_, 
   {{0x11b303ce,0x73ea0200,0xfab300da,0xd2a60077}},	//   _کابرا_, _asato_, _интележе, _chobal_, 
   {{0xf3f40261,0xd26c0119,0x24520374,0x434c0026}},	//   _ekster_, _ormoc_, _акром_, _wederom_, 
   {{0x526d043a,0x529202ec,0x234c01c8,0x85b90147}},	//   _dugons_, _quraan_, _odstupné_, _شومشەك_, 
   {{0x729a0188,0x7eda030b,0x0b2601ef,0x907d01b3}},	//   _ababeham, _amuyamba, _адток_, _спорткар, 
   {{0xe59f02f6,0xe23b0148,0xfc9301e0,0x00000000}},	//   _pangunah, _控制面板首頁_, _ئالای_, --, 
   {{0xb2a60033,0x57150017,0xe35f0203,0x1393013c}},	//   _dumber_, _chomutov, _longore_, _aktyoru_, 
   {{0x0f5d010e,0xed0d05fb,0x00000000,0x00000000}},	// [1280] _bokasyon, _opstrukc, --, --, 
   {{0xb2a600d6,0xf4c8010f,0x79850016,0x02d50045}},	//   _phobal_, _ватандор, _efektiva_, _пламена_, 
   {{0x6a1c046f,0x924002b6,0x64490153,0xcd1b0105}},	//   _verbonne, _ысырып_, _福袋気分で楽しめ, _berlinie_, 
   {{0x96fd05d7,0xcbfc00b0,0x1196003f,0xe38601ab}},	//   _lindolên, _گۯاین_, _muschugh_, _veerg_, 
   {{0x02d901d1,0x38fd00d9,0x23b5012b,0x8327023e}},	//   _reality_, _бюджетны, _koncepcj, _انباردار, 
   {{0xd3e100dc,0x2b7002d6,0xc6e200e6,0xd38600e0}},	//   _alititai_, _arboblar, _学生会名单_, _heerd_, 
   {{0x374f027b,0x31fb0212,0x6af20513,0x727e035b}},	//   _साहसदण्ड, _splitcam, _entshave, _temno_, 
   {{0x83530162,0xedd90025,0xed880013,0xec8802cf}},	//   _ئۇزاق_, _उद्याने_, _синовлар, _унеско_, 
   {{0xad400156,0x73b6002e,0xbafa02d4,0x5c000359}},	//   _ממשיכי_, _pravima_, _persuent, _paesens_, 
   {{0x33860558,0x22d6038a,0x6196003f,0xd2870229}},	//   _meere_, _mayoreo_, _buschugh_, _portalın, 
   {{0x6cce027f,0xb2f4029a,0x4f5d011e,0x0970023e}},	//   _akavumer, _fransir_, _vokasyon, _تفلیس_, 
   {{0xe14a050b,0xd3660083,0x314d02fe,0xc29204d8}},	//   _ऑब्जेक्ट, _aunghel_, _besempil, _baqaya_, 
   {{0xac700230,0x4b1500e2,0xca7d027f,0xa2f000d1}},	//   _asasine_, _baskelân_, _hanabura_, _খামোছ_, 
   {{0xc24c018d,0x618f00e7,0xe6ea027e,0x88460046}},	//   _ተስፋኣለም_, _aheadway_, _sataraš_, _سۉۉيۉ_, 
   {{0xf6440148,0x71650462,0x6abc007e,0x00000000}},	//   _參觀人氣統計_, _acrosmay_, _dagdhāni_, --, 
   {{0x57ec0472,0x87060024,0x89c7023a,0x127e0116}},	//   _belakang, _কুৰুক্ষে, _kreditne, _kinnle_, 
   {{0xb3ea0388,0x03860558,0x8dcb0061,0xb2ed0155}},	// [1290] _usato_, _jeere_, _스포츠조선_, _barnlek_, 
   {{0xdee004ac,0x8eb501d9,0x34280156,0x5e9c008a}},	//   _земле_, _hierscht_, _דעדליין_, _salmasin, 
   {{0x2b6501f2,0x1c0b02d9,0x8bbc00e6,0xd558010b}},	//   _ﭼﻮﻗﯘﻡ_, _laupepa_, _余忆童稚时_, _ikokoany, 
   {{0x378b0156,0xcb9a031a,0xa9c60092,0x2c7d02ea}},	//   _עלענד_, _gainmhic, _kunderne, _sposato_, 
   {{0x03170449,0x223602cb,0x284d00d1,0x5acc004d}},	//   _potiskuj, _biljem_, _নাটঘৰ_, _能力來自愛麗絲學, 
   {{0x179100e4,0xfa130148,0x2c000347,0x9a160322}},	//   _छायावादी_, _訂閱部落通知_, _gautengs, _bagateka_, 
   {{0x19960177,0xe41303ce,0x925a053e,0x93ea0075}},	//   _сантос_, _هاندا_, _fylle_, _gentum_, 
   {{0x3036023e,0xb29101c0,0x8c060094,0x1386024a}},	//   _anataran, _alfanu_, _دىننە_, _keere_, 
   {{0x985400bc,0x02f10145,0x0f150255,0x6d450126}},	//   _اولين_, _katilai_, _vihterpa, _рекламні_, 
   {{0xa29c0276,0x0ec801de,0x4917002b,0xb25a03ae}},	//   _قاسىمجان_, _ретсіз_, _সত্বেও_, _hylle_, 
   {{0x92540417,0x0f42005d,0x13ff0156,0x92f40233}},	//   _sogenaam, _бельгиаг, _וואלאזשי, _transir_, 
   {{0x323203f2,0x12ca01bb,0x56b5004e,0x429002fd}},	//   _varmaan_, _belledi_, _subseksy, _bonaid_, 
   {{0xbe470440,0x037802f3,0x8edc0092,0x245a0153}},	//   _bahavuye_, _utvalda_, _アメブロを書いて, _オオキンケイギク, 
   {{0xf167008d,0x31270076,0x99d5027b,0xf99201db}},	//   _kengashl, _барови_, _बोधयति_, _реактивт, 
   {{0x828701ec,0x32fd01d5,0xa2f70206,0xceaf01d4}},	//   _هفتاد_, _idegen_, _veciach_, _colomban, 
   {{0x6de702b6,0xbb71013f,0x872701a3,0x60e7014a}},	//   _қиянат_, _mouladur, _سگھاري_, _hívták_, 
   {{0xb3fa0604,0x6ad701d9,0x9c76003d,0x9c7c0274}},	// [12a0] _bituma_, _verwacke, _onorari_, _starfar_, 
   {{0xb3ea0172,0x3f250255,0x7dbf01b8,0xab2d01b4}},	//   _yentum_, _baltimaa, _hilisema, _gebalans, 
   {{0x13860190,0xfadf01b8,0xa27c044a,0x00000000}},	//   _arorae_, _korterit, _etindaki_, --, 
   {{0xb96d03ea,0x930d00ad,0x98bf026c,0x00000000}},	//   _proposer_, _réaksi_, _videretu, --, 
   {{0xb0ac0078,0x69da0151,0x7c2100c1,0x26d201cc}},	//   _планиран_, _autoharp_, _शुभसंदेश_, _शोणित_, 
   {{0x35be0037,0xbb2c0389,0x027b00bb,0x373101bb}},	//   _እንዳየነው_, _mayascas, _طرزعمل_, _bellemeg, 
   {{0x84a7010f,0x5bec02c3,0xa7f60094,0xa2010574}},	//   _техникии_, _nohavičk, _بىلەۋلەن, _bobice_, 
   {{0x0e4705a9,0x3993014a,0x7dfc00e6,0xa1b5022f}},	//   _wahavuye_, _بھوکا_, _etudiant_, _блонскі_, 
   {{0x23200058,0xfe8c00e6,0x43080258,0x00000000}},	//   _baryonyx_, _市合作交流办公室_, _symboal_, --, 
   {{0x034103ad,0xecb90187,0x53fe04ab,0xde730157}},	//   _koperta_, _поставен_, _njezina_, _फ़र्क_, 
   {{0xa301003b,0xad920515,0xb2f20178,0x3f9b021b}},	//   _bambone_, _sublinea, _balinau_, _авиации_, 
   {{0x0c7500a7,0xce39024b,0xc7d503bf,0xfaa801c9}},	//   _этникалы, _deportes_, _тусовка_, _उबिलाला_, 
   {{0x1177006a,0xd26d02c3,0x2d890196,0x00000000}},	//   _akanjony_, _obvode_, _chimanja, --, 
   {{0x71c70163,0xe4df026f,0xdeb003a0,0x268000d8}},	//   _دراندازی_, _تابباققا_, _dibokwan, _arrecoti, 
   {{0xaf650116,0x627c011b,0x5f070159,0x23bf00c5}},	//   _attachin, _atindaki_, _бровар_, _两会三人组_, 
   {{0xb8610042,0x2f300325,0x32a601ec,0xbc7c0046}},	//   _combater_, _cavabını, _dhobel_, _مەلدەشىن, 
   {{0x3b4d00c8,0x26d3015d,0x61640109,0x4ea2055f}},	// [12b0] _премьеры_, _दंडित_, _नपुग्दै_, _hurriyet_, 
   {{0x96600086,0x8fb404e3,0xbe9e038a,0x5a8c03b7}},	//   _antikvár_, _pravomoć, _chomolun, _econdeds, 
   {{0xa3000330,0xcd5d014e,0x656d0163,0xf3800059}},	//   _tamakni_, _читалаца_, _legolcsó, _terrà_, 
   {{0xf50a00d6,0xdaf80037,0x622400ea,0x5dfc0194}},	//   _gaillimh, _ግጥሚያዎች_, _donky_, _studiant_, 
   {{0x847300fc,0xef05014e,0x6fa7039a,0xf2d9007f}},	//   _daleghmo_, _чување_, _selembar_, _etholwr_, 
   {{0xd72900d1,0xeea70308,0x15ac019a,0x6fb2018f}},	//   _ব্যঞ্জন_, _pelembab_, _forgaith, _najlahbo, 
   {{0xb31104d3,0x4c660061,0x5dcc016b,0x92170024}},	//   _taubhau_, _puntjes_, _hanyarsu_, _সমুদ্ৰপৃ, 
   {{0xf8360061,0xae390169,0x00000000,0x00000000}},	//   _제공사선택_, _reportes_, --, --, 
   {{0x13800220,0x3cb101cd,0x53860099,0x827802cf}},	//   _verrà_, _яктарафа_, _awirwa_, _tornam_, 
   {{0x1e770323,0xa98f0258,0xfe720256,0x04360320}},	//   _خاندان_, _linkdump_, _modifikā, _ngaherik, 
   {{0x5ee303ab,0x39c602eb,0xa38601ba,0x3387001e}},	//   _spokojen, _биохими_, _lakrem_, _akarin_, 
   {{0x637900c5,0x3b450420,0x9c0600ff,0x54700595}},	//   _充值优惠标准_, _булевар_, _אױסזען_, _अमीनो_, 
   {{0x626d0119,0xf30001fe,0xed670342,0x590300d3}},	//   _savoie_, _kamaini_, _defansè_, _komorní_, 
   {{0x21d1026c,0xa8ea0253,0x53480094,0x622a03fe}},	//   _在此類別張貼免費, _pitsanng, _جالىنىشپ, _котам_, 
   {{0x438b015e,0x591305f4,0x0b00027b,0x1c1c017a}},	//   _спорттун_, _anyanaku, _गुणीभूतव, _amfungis, 
   {{0xb974036d,0x00000000,0x00000000,0x00000000}},	//   _lionacle, --, --, --, 
   {{0xd2830182,0xc25a02f6,0x7ee3035b,0xfc6e009b}},	// [12c0] _alikona_, _madla_, _upokojen, _modurik_, 
   {{0x72f1008e,0x35f60135,0xb3210005,0x3bb900ef}},	//   _matukaay_, _kiresenç, _blocher_, _وغنده_, 
   {{0x8fae035b,0x23260265,0x332c0311,0x308d0156}},	//   _odgovoro, _richtlij, _ብማእሰርቲ_, _לבֿוש_, 
   {{0x17a501fb,0x99750217,0x19f00074,0xb58100ef}},	//   _appellav, _utensile, _kunnolla_, _amodarey, 
   {{0x6aed00ee,0xaff200e6,0xbc93003c,0x149c0350}},	//   _lasterke, _六味地黄丸不是补, _بانام_, _አይጨምርም_, 
   {{0x2d06023c,0x7eb104cf,0xe21500bb,0xdfbc01db}},	//   _مبارزينو_, _bafumane_, _سورئہ_, _جۇقباسىن_, 
   {{0x025a00ef,0xc52e027b,0x72ba0244,0x03560145}},	//   _badla_, _नाधिगच्छ, _redditi_, _seserys_, 
   {{0x2de1016d,0x1c150021,0x8c4b0126,0xf58100de}},	//   _африқили, _alaropes, _епоху_, _emodarey, 
   {{0xb27e046a,0xf3190193,0x62da0373,0xaf17041e}},	//   _femna_, _cibinong_, _hotelo_, _ristampa, 
   {{0xab1403b9,0x895904ad,0xf297010b,0xa278023a}},	//   _arusakha_, _diporofe, _fakalthi_, _hornom_, 
   {{0xb4bd020e,0xed5701cd,0xa2d80062,0x87080144}},	//   _диагнозы_, _хайвон_, _fileio_, _baitsilé, 
   {{0xa5c70074,0xf64a018d,0x52ca005a,0x0c54020f}},	//   _германии_, _ኣእምርኡ_, _fuddy_, _دنيپال_, 
   {{0x06320223,0x239604ac,0xf2be002b,0x15a90126}},	//   _nabigazi, _alusta_, _বিনিয়োগক, _нарахова, 
   {{0x7f6501fe,0xa9940178,0x963d01f4,0x9ed702b3}},	//   _paraimin, _avaśyamb, _mushtari, _asinados_, 
   {{0xdd9c0141,0x14ac00f0,0x07c9018d,0x36a400d1}},	//   _munosaba, _vozidiel_, _እምበአር_, _চপোৱাৰ_, 
   {{0x73aa02be,0x6c1400ef,0xeda6013a,0x50e4004d}},	//   _maraming_, _ووینی_, _dergeint_, _普查指導員和普查, 
   {{0x015800be,0xf2d50605,0xbbb9021c,0x00000000}},	// [12d0] _pressupo, _birokra_, _maskovac, --, 
   {{0x0c8f01f2,0x0ff003c1,0x640001d5,0x02da016a}},	//   _түзәштүр, _сенка_, _kibontak, _botelo_, 
   {{0xc63b00b8,0xcdce015e,0x72e70032,0x314002af}},	//   _askitapx, _билек_, _lujustah_, _kudukoso, 
   {{0xda8300ee,0x63fe0557,0xbf570050,0x627f015b}},	//   _genituen_, _abaziwa_, _pamanten, _twenti_, 
   {{0xd9940178,0x45bf0313,0xe3870145,0x3e520322}},	//   _avaśyame, _luyajmoh, _indrė_, _bakanaka, 
   {{0xd2d30266,0x29530087,0x2c75050b,0x680002e1}},	//   _dikenali_, _emalembe, _alpukat_, _cúcamar_, 
   {{0xe321042e,0xf7b60024,0xa27f01da,0xdb2002a2}},	//   _babyen_, _মুখেৰে_, _mbanin_, _babaunin_, 
   {{0x3c280046,0xa2da0513,0x49f4033d,0x52ca00f5}},	//   _милицияс, _hiseka_, _fonèm_, _bellidi_, 
   {{0x9b470193,0xa26c01ed,0xed8300e0,0x00000000}},	//   _निर्मिती, _pololi_, _goadinne_, --, 
   {{0x91c901ef,0xc28d019f,0x80da0012,0x03410313}},	//   _тэрмін_, _ifikapo_, _किरीपा_, _marehqa_, 
   {{0x5340028e,0x8eaf018d,0xc3a401e4,0xc2920251}},	//   _bulekon_, _ቁምነገርን_, _हतियारहर, _huraan_, 
   {{0x867a02fe,0x813701bd,0xb35b018e,0x9bfe017a}},	//   _وکیلانو_, _клиникад, _gangisa_, _артишҳои_, 
   {{0xcb5b0153,0x239600a3,0x01e80161,0x398200bf}},	//   _modeugen_, _blussa_, _костюмов_, _достур_, 
   {{0x62910606,0xd101042f,0x27dd01ed,0x427e0457}},	//   _babaso_, _nguyunik_, _hoopihai, _ceena_, 
   {{0x5278023b,0x635b0362,0xf4d70046,0xc29e00a4}},	//   _kenikeni_, _bangisa_, _баратып_, _تۅكمۅ_, 
   {{0x2ccd0205,0x32da0103,0x728b028c,0x86b700d9}},	//   _даражада_, _aiseka_, _टिकोरा_, _salaatti, 
   {{0x0b630372,0xcbee03d9,0x11f3008b,0x7f590088}},	// [12e0] _materion_, _marozevo_, _danañuy_, _кимибизд, 
   {{0xc5880150,0xd39501b0,0x05fd02c8,0x6ba00452}},	//   _promotim_, _arasak_, _lémbrame_, _पैलतीर_, 
   {{0x9b63033c,0xd2e001a7,0x9290028d,0x834701d9}},	//   _faterion_, _asunnon_, _melanz_, _bridder_, 
   {{0xd3ea03b0,0x252e04a2,0xe41301a7,0x246a01c2}},	//   _midten_, _círculos_, _совета_, _falecido_, 
   {{0x394e015c,0x1e520072,0x17700139,0x8051008d}},	//   _stroosse, _pakanaka, _anekadiv, _машқлар_, 
   {{0xf0c30125,0xdc6202f9,0x73870097,0x2960007b}},	//   _кувватлы_, _antrave_, _ikarun_, _foundere, 
   {{0x74dc01f2,0x5c620100,0x00000000,0x00000000}},	//   _ﮔﯜﻟﺰﺍﺭﻯ_, _potrage_, --, --, 
   {{0x74b3030b,0x69e100d8,0xa29204d8,0x63f80258}},	//   _akubiriz, _aplicava_, _furaan_, _sekuer_, 
   {{0x527e00a5,0x7f29037f,0xde3202bf,0xc94a0153}},	//   _teena_, _avatarla, _bangahla, _富士フイルム_, 
   {{0x839600fe,0x906b019b,0xfe7c0420,0xc0d4000d}},	//   _amusia_, _станам_, _хормонит, _motoroll, 
   {{0x627e0076,0x09aa0420,0x234903da,0x3c040055}},	//   _memnu_, _почит_, _hoteeli_, _alesani_, 
   {{0x0b910607,0x79c002cb,0xd46d015e,0x6fae00b5}},	//   _abanjalo_, _početnic, _карындын_, _kálkulop, 
   {{0xf2f20193,0xcf3700d9,0x5f75033e,0x9a7b00f0}},	//   _पत्रे_, _грузии_, _interése_, _pouzivat, 
   {{0x9f3200af,0xf2f30429,0xde480155,0x626c04ee}},	//   _гостей_, _didapati_, _etablera, _nghota_, 
   {{0x72f10242,0x23f400ca,0x126c04ee,0x975900be}},	//   _ibtidai_, _mistic_, _yoloji_, _قوزدوپ_, 
   {{0x726e025f,0xe50b005b,0xd2870176,0x00000000}},	//   _botosi_, _dhaosidh, _bankede_, --, 
   {{0x146c0087,0x83790397,0xc8920092,0xc3880188}},	// [12f0] _swifundz, _nalapho_, _バからのお知らせ_, _akayona_, 
   {{0x161a0454,0x5f4400da,0x525b00a0,0x43ac025e}},	//   _ihimbazw, _индивизи, _kwallo_, _kaupir_, 
   {{0xb16103ff,0x63f404a0,0x63860011,0xf3950204}},	//   _ponožky_, _noutro_, _alera_, _unesta_, 
   {{0xc37900fb,0xfc610362,0xe2b20077,0x00000000}},	//   _balapho_, _bitunga_, _mandyan_, --, 
   {{0x03f9019a,0x97360035,0xc2c30305,0x339601a1}},	//   _rebuke_, _рептилия_, _svelgen_, _missie_, 
   {{0x8a7c02ec,0x2af1018b,0x22910007,0x45370189}},	//   _jawaabta_, _prezinta_, _bayaka_, _bilinmey, 
   {{0xf2d90181,0xc228014a,0xf26e005b,0x196d0059}},	//   _typem_, _címmel_, _kotori_, _poliziot, 
   {{0xb38602f3,0xa2fc04aa,0xc2020244,0xf47f0265}},	//   _flera_, _ngago_, _morire_, _hartelij, 
   {{0x32da0073,0x0c60003d,0xa4570153,0x31440421}},	//   _appeti_, _moutier_, _ナメント開催中_, _regelfal, 
   {{0x7cb90122,0x90480037,0x67a900bc,0x77df01fa}},	//   _pasargad_, _አይገኙም_, _مقارن_, _samuelá_, 
   {{0xa27e0068,0xe395012d,0xd3ac01d2,0xc26c0216}},	//   _keeno_, _plesia_, _chaqakam, _miloti_, 
   {{0xc26c0141,0xbade026c,0x62ca0151,0x2c180061}},	//   _lumot_, _auctorit, _bedded_, _이루어진다_, 
   {{0x414700c5,0x65f400ff,0x52e300fd,0x838600cd}},	//   _怒龙大都奢靡之始_, _ערקלער_, _chriosd_, _clera_, 
   {{0xd154018a,0xe3870054,0xe111009a,0xcb8802d7}},	//   _amhriodo, _awarta_, _سپيره_, _acendido_, 
   {{0x157d0169,0x543d0169,0x52e9017e,0x826c01be}},	//   _বন্দি_, _ফাহিম_, _strikta_, _gumou_, 
   {{0xe03c0073,0xc3f40608,0x00000000,0x00000000}},	//   _decennio, _doutro_, --, --, 
   {{0xcfb90609,0xb29201fe,0x00000000,0x00000000}},	// [1300] _métodos_, _waqaca_, --, --, 
   {{0x32d801da,0xe3a3030d,0xf8bb0095,0x00000000}},	//   _sidomos_, _kirpi_, _رکسانا_, --, 
   {{0x9d43018d,0x374d035d,0x81950488,0xe1520462}},	//   _ሰንሰለታዊ_, _izvinjav, _integrēt, _angleway_, 
   {{0x9d7d0226,0xe29001c5,0x1eaf018b,0xffd00418}},	//   _adamanga, _ummad_, _intrebat_, _silindir_, 
   {{0xdcfe018d,0x6e6000d3,0x32910409,0xf2d9030f}},	//   _ክትመላለስ_, _प्रकाशनम, _sayaka_, _ngaere_, 
   {{0xa2d902ff,0x26810360,0xaecc0180,0x426c01fe}},	//   _afinite_, _ल्याए_, _lepidous_, _lodoni_, 
   {{0xcae70024,0xe2da001d,0xdc7c0020,0x0bfe0062}},	//   _ভোগালি_, _inteco_, _measina_, _mohlahmo_, 
   {{0x9224005b,0x22da0333,0x1858060a,0x826c03bd}},	//   _rinka_, _appesi_, _queridos_, _humot_, 
   {{0x9dc6045a,0xcc5d01bf,0x4b1f019b,0xd3e40568}},	//   _beskrive_, _isoterm_, _paskolų_, _allmennk, 
   {{0x33870225,0x33fa017d,0xa34c0359,0x00000000}},	//   _idura_, _derude_, _oftewol_, --, 
   {{0x23e10041,0xe9f70133,0x115b0381,0x3e6f0144}},	//   _дауҭиеи_, _barnotaa_, _allongay_, _concubha, 
   {{0x830e0177,0xd2f2037f,0x4705038e,0xffad004d}},	//   _nasales_, _əzimov_, _दिशादर्श, _新增公告傳輸次數_, 
   {{0x564e009a,0x92010273,0xeabd0029,0x84b50139}},	//   _abakwezi, _éxito_, _تیشدا_, _anvavaik, 
   {{0xb2240145,0x76f60019,0xc6730025,0x00000000}},	//   _tinka_, _تاپانچا_, _प्रतिनिस, --, 
   {{0x545200ba,0x47b30258,0x499f0204,0x00000000}},	//   _رمۆردی_, _delsetti, _pikkutyt, --, 
   {{0xf75700ec,0x3b8e02a4,0xc13f00bc,0x1ae80026}},	//   _метры_, _magistro_, _دیکتاتور_, _verrasse, 
   {{0xd2b90130,0x42d60055,0x7e5201dd,0x63410110}},	// [1310] _nedeleg_, _apellos_, _bakabaka, _baseina_, 
   {{0xb5cd043d,0x7ab003b0,0xdf140235,0x234403f1}},	//   _segalany, _folkebib, _anatipra, _štetce_, 
   {{0xa3870234,0x96cd0164,0x0287029b,0xa3750074}},	//   _adura_, _аяллар_, _ajikane_, _клипарт_, 
   {{0xa5e80089,0xf2b20192,0x269903d4,0x820200a6}},	//   _almaslıq_, _vandaan_, _košarkaš_, _lenkulum, 
   {{0x1682028c,0x926c011b,0x2ca30135,0x00000000}},	//   _उदगार_, _moloni_, _гупче_, --, 
   {{0xe9910480,0xd2b200fa,0xa27e0184,0x00000000}},	//   _abahlale, _tandaan_, _aronke_, --, 
   {{0xcfcd026f,0x4319004f,0x3043039a,0x42d8017e}},	//   _الۋعا_, _beugué_, _twittern, _sidejo_, 
   {{0x32010160,0x199e00af,0x04140145,0xa0e100e6}},	//   _dobije_, _повернен, _выпускні, _商务部信息化司_, 
   {{0x2d8004aa,0x427b0035,0x00000000,0x00000000}},	//   _ponement_, _kertelä_, --, --, 
   {{0xb3480497,0x85ea022b,0xbb7202cf,0x226c0062}},	//   _stifled_, _filminum_, _песимист, _lumoj_, 
   {{0x726c00ef,0x87b40218,0x59f30079,0xfcf80037}},	//   _koloni_, _arketing, _francija_, _የአመጋገብ_, 
   {{0x56d8023c,0x3b610016,0xf24602eb,0x46b202a2}},	//   _مبارکی_, _komenton_, _удвал_, _tanggali, 
   {{0x056b015d,0xd36f0040,0x1291008d,0x00000000}},	//   _napisał_, _longest_, _okeani_, --, 
   {{0xed130003,0xd20101c0,0xc39501c8,0x82c801db}},	//   _kunstwer, _bozize_, _klesla_, _ластануы, 
   {{0x4f340462,0x00000000,0x00000000,0x00000000}},	//   _atoshisa, --, --, --, 
   {{0x0224024f,0x344f0092,0x31770092,0x4a8d0026}},	//   _kinko_, _ブリヂストン_, _ご注文方法_, _papieren_, 
   {{0xcc3b018d,0x0e6400e6,0x53470122,0x467b01a3}},	// [1320] _ኣብርሀት_, _唐海县人民政府信, _ariesta_, _ڇرڪائي_, 
   {{0x97dc0035,0x75dc0242,0x00000000,0x00000000}},	//   _малайлар_, _borçalın, --, --, 
   {{0xb39e002e,0xcdb403b9,0x229203ad,0x52a303c6}},	//   _stvaranj, _kusisiya, _fetaħ_, _karbrief_, 
   {{0x53f00340,0x6e37025a,0xf26c02a4,0x806d0279}},	//   _ipurangi_, _atagusha, _coloni_, _proposan, 
   {{0xc680004a,0x752d0036,0x4d76003c,0x4f09017e}},	//   _infektsi, _lonnaith, _ارژنگ_, _kombinaĵ, 
   {{0xaf4a010f,0x32910043,0x45e80089,0x173d047d}},	//   _пизишкон, _abyala_, _almaslık_, _besonneg, 
   {{0xa3a804ad,0x482900cb,0x5cad033e,0x6a0e00db}},	//   _atlageng_, _меҳвар_, _hendapýv, _plastiku, 
   {{0xa2d900c3,0x328a00a6,0x6c9e018d,0xe2d8009b}},	//   _quinque_, _اړینه_, _እንተዄንካ_, _hileko_, 
   {{0xddcc0166,0x763b012c,0x5b1d03c6,0x33dd047d}},	//   _richtige_, _bukhaari, _tapassen_, _mogway_, 
   {{0xfb5300f5,0xb2670013,0x746502dd,0xb2d700ba}},	//   _hemmetar, _нечун_, _assenjaz, _سکاری_, 
   {{0xd15a0288,0xab7c004d,0xd2da013d,0x7e4c001b}},	//   _astonish_, _中彰投區就業服務, _litero_, _dabarraa, 
   {{0xf739024b,0xb3f2017f,0x50d10410,0x0dc601c8}},	//   _deportiv, _matumani_, _kgothatš, _aktivuje_, 
   {{0xf9dc0166,0xc8d9023d,0x7e6c051e,0xf2fc0515}},	//   _dargeste, _наказате, _adicione_, _luminas_, 
   {{0x9c9201e5,0xf9a80097,0x00000000,0x00000000}},	//   _adahunṣe_, _fásitì_, --, --, 
   {{0x0d050305,0x00dc00f2,0xf26c0343,0xb1fa009d}},	//   _enklaste_, _autoratl, _humok_, _praktikë_, 
   {{0x2e5101c8,0x7970026d,0xaae802a3,0x7a0d002b}},	//   _nedokonč, _nominujt, _europeen_, _মজিবর_, 
   {{0x65620135,0x7bec01e6,0x8852031a,0xd9520195}},	// [1330] _сентябрь, _relaxačn, _cholaisd, _cholaist, 
   {{0x72360465,0xc5020244,0x09c701db,0x00000000}},	//   _svojci_, _corretto_, _كوڭىلسىڭ_, --, 
   {{0xe38603b6,0x78ef02aa,0xb0e101be,0xc26c03dd}},	//   _elere_, _neopakov, _doinstal, _poloni_, 
   {{0xf3860566,0xe1b900be,0x32e7031e,0x5e4102f8}},	//   _flere_, _сабырсыз, _gubljenj, _lakaange_, 
   {{0xc9170352,0x5c6b0320,0x05cd01b3,0xfd6b0300}},	//   _এনেবোৰ_, _keauhou_, _формують, _palisády_, 
   {{0xee030093,0x1ea4033a,0x17f400a5,0xb3670176}},	//   _формате_, _kontenut_, _tilafaig, _pengebæl, 
   {{0xf7b50156,0x0bdc05a3,0xf405031e,0x026c0085}},	//   _tierkrei, _हटिया_, _ispunjen_, _toloni_, 
   {{0x1b8b0212,0x53860417,0xbe11029a,0x32da0069}},	//   _aleinwar, _klere_, _formidab_, _bitero_, 
   {{0x329103a2,0x43ea0034,0x00000000,0x00000000}},	//   _फ्लाईओवर_, _beittu_, --, --, 
   {{0x2ff100bb,0xde4e0198,0x23f1038c,0x5156003e}},	//   _منقبت_, _nogavice_, _izazove_, _балына_, 
   {{0x5af3029a,0xa68d01db,0x934100c4,0x55f703b9}},	//   _underpas, _امانتايد, _هنڌان_, _ullarañ_, 
   {{0xa4bd00c5,0x9224009b,0x6f750147,0x1ea10287}},	//   _做别人没想到的生, _tinko_, _دىپوزىتت, _primární, 
   {{0xef2501ec,0x27530185,0x4da70297,0x5c21060b}},	//   _diperban, _метросын, _alıpsata, _मनमौजी_, 
   {{0xcb910217,0xbf250253,0x72240176,0xcd97021b}},	//   _scandalo_, _akornuta, _rinko_, _lastattu_, 
   {{0xf7870272,0x3b4f004d,0xd1eb0246,0x00000000}},	//   _akawunyi, _文化資產再利用技, _осиновяв, --, 
   {{0x843302af,0x1ca10100,0xe8fc0226,0x00000000}},	//   _akakirek, _prognozu_, _kumadand, --, 
   {{0x52240125,0xde4900ad,0xc2d503ae,0x526c033f}},	// [1340] _sonky_, _kawajiba, _skallet_, _kololi_, 
   {{0x6af50359,0xe67a00c3,0x2ccc0061,0x9013000a}},	//   _sitewaas, _effectum_, _단순변심으로_, _anaviann, 
   {{0x69850320,0x301d00be,0x9e47005c,0x00000000}},	//   _amahanye, _تۅمۅندۅك, _bahatuye_, --, 
   {{0x7e5702da,0x907700c5,0xf9c003d8,0x81f50272}},	//   _металург_, _国务院环境保护行, _početnik, _amunyoom, 
   {{0x1b0c0094,0xe2cf0396,0x00000000,0x00000000}},	//   _жуыну_, _gradilji_, --, --, 
   {{0xd8b9060c,0x881b01da,0x5f720255,0x1948060d}},	//   _nastavov, _domethën, _klubides_, _जनआस्था_, 
   {{0xa64a042a,0x847d027b,0x961f03b2,0xa55802c3}},	//   _atinatif, _बहुना_, _pioneeri, _prevadzk, 
   {{0x12ab00ad,0x12fd01dd,0xfba70132,0x2de403ee}},	//   _mindeng_, _uregwa_, _vízilabd, _rodjenda, 
   {{0x5eb80257,0x1f350291,0x695b0481,0xcf1d0144}},	//   _erlendis_, _lónadóir, _gemontee, _caoladói, 
   {{0xf2240359,0x23870225,0xa26c0374,0x4e0001ef}},	//   _tinke_, _ijaran_, _armon_, _naudinga, 
   {{0xe39903f0,0xf41201d5,0x2dbc02fd,0x00000000}},	//   _næstu_, _احمقانہ_, _reggenie_, --, 
   {{0x067f010f,0xfed5030d,0x12cb0052,0x87cc0204}},	//   _abadingi, _birincin, _zvedne_, _fossiili, 
   {{0xc27e023b,0xdf660033,0x1a96013c,0x53f9022d}},	//   _keena_, _relaziun, _milyarde, _arburu_, 
   {{0xf7e60040,0x4afd02aa,0x43a00465,0x00000000}},	//   _הביצים_, _nakresle, _pisatelj, --, 
   {{0xab61044b,0x37bb02a7,0x9a8e0079,0x65e602ac}},	//   _billiger, _ibugibug, _benzīna_, _نايلون_, 
   {{0x27f30174,0xadc20022,0xd58800a6,0x32360009}},	//   _ditabakg, _субъекты_, _مېلادی_, _dvojni_, 
   {{0xe37a0342,0x817101ac,0x68b2004b,0x0a0803f0}},	// [1350] _defakto_, _مشاعرك_, _столяров_, _aukagest, 
   {{0x80560107,0x0e6e0161,0x930c03d1,0x206201be}},	//   _blontank_, _горловин, _lamatas_, _poustevn, 
   {{0x22da0285,0x2db20028,0x00000000,0x00000000}},	//   _intego_, _xannaana, --, --, 
   {{0x13f205b4,0xf2120074,0x3feb060e,0xe86b0045}},	//   _amashuri_, _kunhan_, _दुराचार_, _обренова, 
   {{0xf202019b,0x445202ba,0xeca60274,0xe332002e}},	//   _norite_, _яксон_, _berglind_, _održanoj_, 
   {{0x539601cd,0x798900af,0xffae004a,0xec610453}},	//   _omusha_, _forholde, _хакка_, _sahrane_, 
   {{0xf3dc012e,0x55d700d9,0xff5f0340,0x604a0322}},	//   _félpanzi, _завести_, _kuraimon, _ataratan, 
   {{0x6e4c0125,0xf00d0074,0x13890350,0x00000000}},	//   _бөлүмлер, _talviren, _የዓመቱን_, --, 
   {{0x33870410,0x82900157,0x00000000,0x00000000}},	//   _swarwa_, _sciaga_, --, --, 
   {{0x427e02f3,0x827e02f7,0x2be300d9,0x196a02f0}},	//   _kvinna_, _afeng_, _neuvolas, _batimise, 
   {{0x543201b7,0xd42602b6,0xb26400ff,0xda06017f}},	//   _अपृच्छत्_, _ارمانداد, _דעליווער, _allaaqut, 
   {{0x2d7004a4,0x325a01b8,0x0f5c01d7,0x52f50242}},	//   _achmhasa, _meelde_, _arpagaus_, _intizam_, 
   {{0x3107005e,0xb27e03b6,0x59f20040,0x3c060044}},	//   _ئېلھامجا, _beeni_, _גינזבורג_, _enclosed_, 
   {{0x4c31008f,0xc27e00d7,0x244a020f,0x4db40305}},	//   _parimaid_, _efeng_, _ستړیا_, _fingrane_, 
   {{0xf38701fc,0x67ef0192,0xb61f025c,0x09170074}},	//   _adure_, _소요됩니다_, _angenehm_, _травмы_, 
   {{0xd38601b4,0x305401b2,0xc3c8000e,0xc20200e1}},	//   _boere_, _amassmen, _pruvat_, _korite_, 
   {{0xfb0a04a7,0xad070373,0x5ac000c1,0x93ab0099}},	// [1360] _conselle, _אינסולעי, _कुंपण_, _atsvage_, 
   {{0x42a6001b,0x93490204,0x5fa6022f,0xa2d50095}},	//   _bobba_, _hotelli_, _permaino, _cocokan_, 
   {{0xc2a601d3,0xc2f50242,0xf14f018f,0xb36100e7}},	//   _jobba_, _intiqam_, _dimojmeh_, _aneuverm, 
   {{0x4b4a0185,0x1a5201e8,0xf38602c2,0x09c10263}},	//   _грозныйд, _kasemana_, _toere_, _inlevere, 
   {{0x945d0057,0xea54017d,0xc84002ac,0x81520021}},	//   _መዛሙርቱም_, _検索オプション_, _بخطوة_, _angloway_, 
   {{0xe50101b5,0x6e0e0342,0x9c75015d,0x5ba60273}},	//   _byimbirh, _abòde_, _chorych_, _trabajó_, 
   {{0x32da027f,0xb2c5014c,0x406e0039,0x848701c9}},	//   _mitego_, _anelise_, _botazino, _दिसाईं_, 
   {{0x2ca30135,0x29cf014e,0x00000000,0x00000000}},	//   _анализла, _lekovita_, --, --, 
   {{0x03be0044,0x929000b0,0x4e9700e6,0x705a0039}},	//   _preview_, _annagu_, _中华人民共和国税, _доройтол_, 
   {{0x101a024e,0x833a018d,0x272302a4,0x1d1604fc}},	//   _životinj, _ኣካላተይ_, _fortunam_, _estremec, 
   {{0x9a0b0239,0x447f0253,0x00000000,0x00000000}},	//   _ramarama_, _heksejæg, --, --, 
   {{0x42ec0270,0x22920382,0x73cc0079,0xbc5b0453}},	//   _scripte_, _chuchisi_, _būves_, _umutiti_, 
   {{0x1a0100a0,0xcc8201e1,0xd2f40279,0x927e02f8}},	//   _bambanta_, _ipitsang_, _grandir_, _peeni_, 
   {{0x325a00e1,0xe38e0450,0xff2203bf,0xd0e40040}},	//   _leelee_, _reagearj, _busulosa, _באזורי_, 
   {{0xe50703d4,0x93fa0212,0x2ead012a,0x00000000}},	//   _продат_, _meruit_, _poronien, --, 
   {{0x22d0002a,0xe0da0297,0x93b70371,0xc9c80143}},	//   _achorom_, _талибанн, _salvato_, _циркуляр, 
   {{0xf2da030a,0x00000000,0x00000000,0x00000000}},	// [1370] _antelo_, --, --, --, 
   {{0x73860125,0x686f01f2,0xe9a40044,0xa649014a}},	//   _ileri_, _توققۇز_, _בטירוף_, _مقدسہ_, 
   {{0x235e0049,0x2a1e00bc,0x231a033d,0xfd1b0350}},	//   _ikafoli_, _ايتالياي, _chichak_, _ማሳሰባቸውን_, 
   {{0x39c701ea,0x529102e7,0x763c0141,0xcbfa013c}},	//   _талаба_, _kabayo_, _kuchlari, _möminlər, 
   {{0xa2fc000f,0xe85f02e1,0xb4890425,0xbd0701ac}},	//   _izinsiz_, _cheantar_, _خورافه_, _costasac, 
   {{0x82900482,0x100f0092,0x73f90134,0xa2000054}},	//   _umman_, _ガイドライン等に, _buburu_, _bijire_, 
   {{0x83870119,0x831603dd,0x22510178,0x05cb01b0}},	//   _kwarta_, _elizza_, _deseyyaṃ_, _dikaniay, 
   {{0x92910272,0x5395029f,0xbe54049a,0xeee803ff}},	//   _abaana_, _miesta_, _ostavile_, _opakovan, 
   {{0x60cb00c8,0x129101c5,0xf8dc0089,0x0aaa0044}},	//   _этапта_, _gabayo_, _ачарбыз_, _archives, 
   {{0x215c0152,0x9b2c00a0,0x22920082,0x2ae202c7}},	//   _кулай_, _annabins, _barawo_, _plaudere, 
   {{0x92c2025c,0xc1ac02ec,0x2ed00056,0x82e90054}},	//   _sollten_, _کٔرمے_, _асорати_, _burinta_, 
   {{0xa49a01f6,0x1ff6002f,0x00000000,0x00000000}},	//   _নিশ্চয়_, _cichorio, --, --, 
   {{0x648701b8,0x33db006d,0x2d9e021b,0x00000000}},	//   _दिशाईं_, _абурэньн, _повество, --, 
   {{0x623001ed,0x7888039e,0x957a00e6,0xdc150267}},	//   _kālele_, _sviktand, _问题排行榜_, _patuljas, 
   {{0x02b20241,0xf6c60175,0x9dc8032b,0x338600dd}},	//   _gandaan_, _mekanizm_, _маслашту, _eleri_, 
   {{0xb3890450,0xb586005d,0x43860004,0x23a80271}},	//   _argyven_, _delinkué, _fleri_, _ingvild_, 
   {{0x44be0040,0x763c0184,0x00000000,0x00000000}},	// [1380] _בוחבוט_, _mukigani, --, --, 
   {{0x727f03fd,0xba6e02c3,0x7c170039,0x4c600435}},	//   _avanoa_, _profesia_, _indarker, _buduća_, 
   {{0x07520169,0x92240193,0xd4ed02fe,0x409c0374}},	//   _বক্সে_, _jinki_, _نامعلومه_, _забардас_, 
   {{0x8823060f,0x63420285,0xd9c700ea,0x45710188}},	//   _སྒྲིམ_, _ingengo_, _tselatra_, _машқҳои_, 
   {{0x422403a4,0x73ea02d5,0x76a00177,0x07b70026}},	//   _einki_, _leitud_, _апактқәе, _verschri, 
   {{0x1f2d0265,0xd2920428,0xac7c025d,0x22fc0269}},	//   _maatscha, _naravo_, _styrkar_, _caiga_, 
   {{0xa3fb045f,0x225b0314,0x8e750193,0x72a60466}},	//   _människo, _matlo_, _विश्वकोश, _krajnji_, 
   {{0x739e002e,0x50e50309,0x49d90119,0x00000000}},	//   _otvaranj, _formasın, _gerterod, --, 
   {{0xa7f5023c,0xc2e90066,0x73ff02d6,0x5b1a04dc}},	//   _انستان_, _arrieta_, _tarzida_, _پروسکی_, 
   {{0x13a202bd,0x827e021a,0x127e018c,0x42fc00a5}},	//   _stopio_, _ceenu_, _meent_, _uaiga_, 
   {{0x03f80578,0x1f5f005b,0xa24801ed,0xa8d2004d}},	//   _txaus_, _onepiece_, _edoma_, _吳博仁整體造型工, 
   {{0x9fbc0238,0x238601b8,0x8d7e0092,0x2c18020f}},	//   _традиції_, _koera_, _過去の記事_, _اوسپنه_, 
   {{0x9abb0311,0x11420094,0x53e60109,0xdd960115}},	//   _ምጽንሖም_, _аттай_, _chaloupk, _muafakat_, 
   {{0x4d980441,0x796f0281,0x47b30074,0xc27e008b}},	//   _beletrie_, _manngert, _prosenti, _geenu_, 
   {{0x62da0610,0xbc7d0144,0x6f720139,0xe29001bb}},	//   _inteko_, _measann_, _संस्थितः_, _almaň_, 
   {{0xbb2801db,0xee0d00e7,0xa2a60563,0x2202006e}},	//   _تراگەديا, _ardensga, _priboj_, _loriye_, 
   {{0x626c005b,0x32fc005b,0x8b180370,0x00000000}},	// [1390] _midori_, _taiga_, _pagawean_, --, 
   {{0xb27e02a5,0xe38700b7,0xb3fa00e9,0xb38700d0}},	//   _denně_, _ederdi_, _derule_, _iduri_, 
   {{0x2f4f01f1,0x0c6505ac,0x7c69007b,0xf27e0077}},	//   _seksuale_, _giftast_, _anatoly_, _bannou_, 
   {{0xc4720066,0xfa8e0392,0x23a30371,0x00000000}},	//   _импортоо, _leannain_, _carpi_, --, 
   {{0x138600ee,0xbc2f00e6,0xf1f900c7,0x26dd010d}},	//   _joera_, _世纪中英创业计划, _berketmä_, _पैरिस_, 
   {{0xaaf50437,0x94ae0611,0x1e2a020f,0x00000000}},	//   _tilsvare, _stennsil_, _banguwup, --, 
   {{0x0ce40360,0xf34800f2,0x92fe0017,0xce52001c}},	//   _podobně_, _griesti_, _samotě_, _nakakaka, 
   {{0xf27f006f,0x675d00d9,0x9a580121,0xf27e047d}},	//   _mwanza_, _достойно, _tenencia_, _keent_, 
   {{0xc3fb0155,0x1dc30285,0x52e30024,0xe47e0444}},	//   _människa, _basirika, _stundom_, _битов_, 
   {{0x1ae802a5,0x33cd0154,0x23a3022d,0x19e201f7}},	//   _असुविधा_, _норведжь, _sarpi_, _claustru, 
   {{0x5fd602ac,0x288e02ad,0xdf3f0418,0x00000000}},	//   _تفحيط_, _zbohatnu, _dalgalan, --, 
   {{0x887700ad,0x78c30071,0xbe520119,0x00000000}},	//   _nuliskeu, _caketipu, _makakaka, --, 
   {{0xe83e0366,0xa26c0184,0x302a003c,0x534f0308}},	//   _бирки_, _eueom_, _برجستگی_, _dipeluk_, 
   {{0xd27f028a,0x55650137,0xe2d5022c,0xb0e500f6}},	//   _kwanza_, _аллерги_, _cocooan_, _formasıd, 
   {{0x02a6053e,0x026c04b9,0xd7d40156,0x9b93037b}},	//   _jobbe_, _aumos_, _כאפצעם_, _subiendo_, 
   {{0x6779009a,0xa2a600e2,0x2ba20153,0x22ab00c1}},	//   _داستخبار, _dobbe_, _広瀬町立比田中学, _rindang_, 
   {{0x9d0503ea,0x32ab0108,0x90330148,0xc2cd00da}},	// [13a0] _commence_, _sindang_, _sustinen, _jandarmi_, 
   {{0x637f047b,0xbe5200f2,0xc52e00c0,0xb984014d}},	//   _einasta_, _gatavoja, _persiano_, _typische, 
   {{0xf7970211,0xefc40092,0xdf48022a,0x18be00e9}},	//   _билеты_, _バイク用品_, _leigasin, _mpetitiv, 
   {{0xe4d7019e,0x7cdd0382,0x93050205,0x136f0288}},	//   _балконы_, _amakwenu_, _قوشان_, _rangaet_, 
   {{0x12fc005b,0x3ab602fe,0x56180061,0x00000000}},	//   _daigo_, _kubhekis, _전문자료홈_, --, 
   {{0xe40d0226,0x0d8a0031,0x7e8b003c,0x7e490311}},	//   _anandiuz, _diamanka, _سراشیبی_, _አርዓዶም_, 
   {{0xe27f005c,0x420101c8,0xd0cc00e6,0x254103bf}},	//   _mwanya_, _pozice_, _焦点装修家居网_, _diphetoh, 
   {{0xef5e00cd,0x841c00a7,0x822b0445,0x02b4003d}},	//   _campiuna, _сурма_, _promove_, _poncha_, 
   {{0x3c5303d8,0xfa0f0138,0x925b04b2,0x4fb80234}},	//   _nastupa_, _makalele, _tatlo_, _lilọsiwa, 
   {{0xa50f022f,0xb285004b,0x00000000,0x00000000}},	//   _orchidėj, _kathoko_, --, --, 
   {{0x80320222,0xa7a603f3,0xd6c402fe,0x2c6b003c}},	//   _nettemen, _uitrusti, _bukathix, _didulit_, 
   {{0xb6b502c1,0x625a018f,0xb060018b,0x626a0211}},	//   _ahererey, _cholup_, _consecin, _заморачи, 
   {{0xc2dd0172,0x08520564,0xef4f05db,0xfa0202f6}},	//   _farossi_, _patuvons_, _abaswele_, _pambansa_, 
   {{0x8571008b,0x17ec02be,0x3d050126,0x6f1f023e}},	//   _biddiwal_, _dalawang, _stillhet_, _digubeta, 
   {{0x530e000e,0xefc00047,0x526c00dc,0x226c019e}},	//   _masajes_, _提问者对于答案的, _fitifiti_, _sumos_, 
   {{0x87ee02af,0x9f2903bf,0x10d40449,0xa21401db}},	//   _barakeng, _банкирҙа, _okružuje_, _ۇستانعان_, 
   {{0x726401b9,0xe21603db,0xbf5800d8,0xb53d0141}},	// [13b0] _anplen_, _amakhadi_, _adoptada, _beshinch, 
   {{0xd2fd0069,0xdc800076,0x238701c4,0xb2fc02a3}},	//   _aregwa_, _течен_, _deure_, _maagd_, 
   {{0x79fb01e9,0xc386022c,0x00000000,0x00000000}},	//   _didimala_, _comro_, --, --, 
   {{0x89840041,0x59340090,0xcd4b03c1,0x229001b8}},	//   _аусуҩтә_, _akamurat, _станици_, _kuskilt_, 
   {{0xc3870066,0xfb36004d,0xf25e01b9,0xb27f042c}},	//   _neure_, _變更或換證_, _rantabil, _zvanja_, 
   {{0x23f90309,0x84570287,0x03f80127,0x33a3005a}},	//   _arzusu_, _koncertů_, _avius_, _harpu_, 
   {{0x638703ea,0x88d400a1,0x726c037f,0xc2c403f6}},	//   _heure_, _hikurang, _yumor_, _loomens_, 
   {{0x5e5302f6,0x6b7a03f6,0xf20202fe,0x00000000}},	//   _kakayaha, _eperaima_, _senkulum, --, 
   {{0xd8650187,0xc9db00e6,0x5dba0153,0xde530322}},	//   _близина_, _新农村商报_, _大きな写真_, _bakazaha, 
   {{0xf291009a,0x16430092,0x415c0008,0x82e90247}},	//   _abachasi_, _配送料と配送情報_, _мукам_, _aktifna_, 
   {{0xb9d70255,0x85bb019f,0x38590008,0x9213009c}},	//   _प्रयास_, _issamich, _aguantar_, _bozhao_, 
   {{0xd3fa0003,0xed46006c,0x15f80350,0x396c0444}},	//   _gerust_, _бруссел_, _ይሰበካል_, _дурдзуки_, 
   {{0xa3890202,0x82ee03ec,0x5d9c0386,0x522402aa}},	//   _arayín_, _stafa_, _dialihka, _zinku_, 
   {{0xfa0902fe,0xa9eb0061,0xb3eb0255,0x52900039}},	//   _عقيده_, _다이아몬드_, _teated_, _sinatu_, 
   {{0x9ecc030c,0x427e026c,0x56310036,0x0e1c03fe}},	//   _tikitinn, _sponte_, _miontuai, _канцлера_, 
   {{0x2eae0166,0xa90a008d,0xde4900d7,0xdc67026c}},	//   _vorteile_, _далалари, _bolailoe_, _diutius_, 
   {{0xd3640289,0x4a1100e6,0xc2b50014,0xba97041a}},	// [13c0] _amagula_, _应当按照国家有关, _kontratë_, _седокова_, 
   {{0x87e10038,0xcc0302c2,0x3cc5003b,0x9fc702fd}},	//   _зинһар_, _roeping_, _besikimu_, _greineto, 
   {{0x3fee035f,0xf3a302a9,0x736f0612,0xfc640169}},	//   _असमानता_, _tarpu_, _manglet_, _estuche_, 
   {{0x99fa009d,0x91c90405,0xdb130211,0x69d30361}},	//   _pershend, _кошти_, _punainen_, _алексеев_, 
   {{0xd9bf025e,0x19e20192,0xd378015e,0x00000000}},	//   _fundarge, _경상남도교육청_, _segarra_, --, 
   {{0x83a2023d,0x2c3603ff,0xa3ea00e9,0xa2fc0203}},	//   _troppo_, _minulý_, _biltin_, _gaige_, 
   {{0xcb4a0184,0x1202019b,0xf2910097,0xa5c60278}},	//   _adatabwa_, _norint_, _babalo_, _dimansuh, 
   {{0xc3cf01d7,0x0291034a,0x518300bf,0x3b220247}},	//   _previu_, _cabalo_, _елата_, _binangun_, 
   {{0xbb7801b2,0x68490037,0x5387009b,0x4f9c0156}},	//   _aaventyn_, _አይሻልም_, _ederki_, _פלייצעס_, 
   {{0x2eef0220,0x3c0302c2,0xd27e0007,0x00000000}},	//   _здравни_, _vorster_, _mwinda_, --, 
   {{0x8448048a,0xff0202c9,0xb29200ee,0xf3860011}},	//   _орналаст, _ефектуяз, _arrain_, _amery_, 
   {{0x6c3802c3,0xe61802e4,0xaae10223,0x95d9009f}},	//   _generáci, _immodifi, _unitatee, _peteršil, 
   {{0xa20005b1,0x0210005d,0xe2da012d,0x5aad018d}},	//   _upnito_, _акаталог_, _eksodas_, _ተዳጕኖምሉ_, 
   {{0x9202014a,0xc8b600c9,0xa0e40156,0x78970122}},	//   _forint_, _viettrav, _טאיאטע_, _سرابی_, 
   {{0x94da0159,0xe3eb0165,0xdb930173,0xc3860450}},	//   _бойня_, _edatou_, _arriendo_, _boerd_, 
   {{0x8aea013c,0x17c2017f,0x72640333,0x00000000}},	//   _millinin_, _aporaaff, _adultu_, --, 
   {{0x229001b4,0x0e51037f,0x1ef6019e,0x65750613}},	// [13d0] _bedank_, _tullantı, _партала_, _pretexto_, 
   {{0x8cd20156,0x00000000,0x00000000,0x00000000}},	//   _אַלבאָם_, --, --, --, 
   {{0xa24800eb,0x904b0058,0x12da0232,0xb3480041}},	//   _adome_, _lepradan, _anteno_, _маиромиа, 
   {{0x39c00614,0x4e6d00f6,0xd8c701f3,0x634c042b}},	//   _viderese, _apardıql, _ozvučova, _zelenoj_, 
   {{0x427e0068,0xf2fc00f2,0x30e4002b,0x5159006d}},	//   _keeni_, _armijas_, _জুবায়ের_, _арандата, 
   {{0x5b530044,0xfee300a6,0xf25a03f7,0x6e9804ac}},	//   _pulmonar, _aliyitha, _hylli_, _радиоупр, 
   {{0x5ae100b2,0x997a02fd,0xe7a802c0,0xf3060184}},	//   _ballinan_, _dèiligea, _настрада, _ntazohem, 
   {{0x5d6d0125,0x09680448,0xf3f90615,0x527e029b}},	//   _гарамаяк_, _gevinste, _vezuje_, _leeni_, 
   {{0xed23038a,0x82e901d9,0x2d4c006d,0x00000000}},	//   _abusakur, _schneit_, _волевыяў, --, 
   {{0x164a0251,0xc6170241,0x900e00d6,0x03250152}},	//   _مرکزٕے_, _amalaani, _gearmána, _borhanov_, 
   {{0xa7780320,0xbddb0548,0x22b40059,0x48ce0373}},	//   _ahikhong, _tyrkiske_, _blocco_, _akademiu, 
   {{0x53bf00de,0x4b3100f6,0x33420244,0x67d70307}},	//   _akhwele_, _futbolun_, _vederlo_, _kokuvalw, 
   {{0x0437036e,0x02f30101,0x5db904a6,0x12910373}},	//   _kathulik, _ridicat_, _proleće_, _bazaro_, 
   {{0xeae20171,0xf2a702e4,0xf25b0087,0x4f280350}},	//   _pretpost, _bebbux_, _hatla_, _በጠየቀው_, 
   {{0x225a0032,0x871c0022,0xfd2c0073,0xffce0476}},	//   _cholha_, _алынасаҡ_, _maritate_, _chinombo, 
   {{0x00f800a7,0xe25a0259,0xdf3702e7,0x12d70294}},	//   _informàt, _ludlow_, _guhukuma, _coroico_, 
   {{0x425b020e,0xfd0b031a,0x22a60132,0xb8d10092}},	// [13e0] _matla_, _caileige_, _hobbi_, _新感覚馬券術_, 
   {{0x127e0403,0x78730014,0x92ef0316,0x710b0014}},	//   _afeno_, _aktivizu, _bajimta_, _elementë_, 
   {{0x698b0087,0x44200094,0x42d902c2,0x2c05003a}},	//   _anakanya_, _استانانى, _toename_, _hissasi_, 
   {{0x7d7c0315,0xf94601eb,0x75f101f6,0x152c00b9}},	//   _abomasip, _adelánto, _নিয়মীয়, _प्रात्यक, 
   {{0x62490564,0x83860026,0x33f800a1,0xbdb601db}},	//   _gramat_, _nadruk_, _maruwehi_, _слайдтар, 
   {{0x5fa8023d,0xcbb90616,0x84870125,0xb9dc0115}},	//   _кулинарн, _स्वंयभू_, _килелап_, _imigrese, 
   {{0xe51c00e6,0x42f604e3,0xd84403d1,0xdcde0299}},	//   _秋天不回来_, _poticaj_, _hostings_, _تصزصملات, 
   {{0x5faa0047,0xa9f8013c,0xe7210192,0x129000b0}},	//   _字母不区分大小写_, _quruculu, _기술적분석_, _innagu_, 
   {{0x4c530072,0xf9ef02ac,0xda390074,0xb2b50553}},	//   _juttana_, _وأسرار_, _ведение_, _riziká_, 
   {{0x3249012a,0x935104c8,0xb0910352,0x4c6e0617}},	//   _dramat_, _devjazzj, _টেবুল_, _metamórf, 
   {{0x3d1b03b6,0xc248025c,0x97d9003c,0xf26c01c2}},	//   _afonrere_, _stimme_, _bergerig, _creou_, 
   {{0xbf2f01d9,0x60050040,0xc592021b,0x968a0334}},	//   _astellun, _בוקסר_, _raiskauk, _ayadzami, 
   {{0x331904bb,0xac6b00e6,0x85f20516,0xfa3401e1}},	//   _lijchoj_, _县级以上地方各级, _clamouri, _статьяла, 
   {{0x019c00bc,0x0ed402fd,0xb2ef042c,0x802d03f5}},	//   _جلالی_, _chriochn, _kazniti_, _conflito, 
   {{0x525a04d8,0x19fb01eb,0xa1930279,0x3ae700ca}},	//   _geelle_, _jerureku, _ponctuel, _cobrisse, 
   {{0xc31604ee,0x33b30145,0x42a6022e,0x5aee00f2}},	//   _ghozie_, _статкеві, _robba_, _faktorie, 
   {{0xbaf303b7,0xdede0162,0xf0590274,0xd290006e}},	// [13f0] _unprofit, _биздә_, _pressunn, _demati_, 
   {{0x82910345,0xb35f01fb,0xe9c100f2,0x00000000}},	//   _tabaco_, _suggere_, _komercre, --, 
   {{0xc0a5043b,0x60cb034a,0x62fc0051,0xc6be0444}},	//   _bhàrdach, _redondel, _gumijas_, _соратник, 
   {{0x237900fe,0x141c0297,0x00000000,0x00000000}},	//   _mauanga_, _зурмы_, --, --, 
   {{0xd38001eb,0x7b4c013c,0xa1f9001c,0x77490014}},	//   _parral_, _hesabatı_, _buraidah_, _aksionev, 
   {{0x529b04af,0x46660040,0x788302eb,0x150d014b}},	//   _khejdaj_, _ובגדול_, _konkretu, _mattacoo_, 
   {{0x721204bb,0xcc610409,0x47c900c5,0xd224005b}},	//   _neohom_, _bidrage_, _第四十九条_, _ninki_, 
   {{0x724804cb,0xfe4d023c,0x9cf30094,0x2d850109}},	//   _filmul_, _angabina, _قوشتاسار, _अड्काउ_, 
   {{0x98c70010,0x82e50322,0x66be004d,0x627f0344}},	//   _ayetseng, _aboneza_, _補領身分證查詢_, _avanna_, 
   {{0xdaf301d1,0x49df04a2,0x89320365,0xbc020277}},	//   _presente, _austerid, _kuchyní_, _gialagad_, 
   {{0xdc6600a7,0xc62d034e,0x33d600c1,0x2ad7005d}},	//   _últims_, _afrikapi, _proteksi_, _forticat, 
   {{0x240e035d,0x8779032d,0x73e500ba,0x43040035}},	//   _zadržana_, _сосновка_, _درۆکانی_, _açarga_, 
   {{0x453d013d,0x62ee0497,0x89fb0476,0x96d90037}},	//   _respondo_, _easterly_, _abhabhat, _አልዓዛር_, 
   {{0xe27f02fc,0x206d0002,0x22310075,0x5f990128}},	//   _rwanda_, _propisan, _marknaði, _битирувч, 
   {{0x407301a7,0x2b280157,0xea8e02d3,0x83f20227}},	//   _пусть_, _मूल्याकं, _опозициј, _madzhab_, 
   {{0xa225001e,0x53ea0240,0x4536047b,0xd518022f}},	//   _iyakar_, _veitau_, _familjuh, _rankovėm, 
  
   {{0x52fc000b,0xe6030125,0xc4dd0178,0x92b20066}},	// [1400] _faiga_, _белалары, _balavāha, _handian_, 
   {{0xb983002e,0xf31704bd,0x4da7024f,0xdb4a0350}},	//   _građani_, _amazia_, _rejisita, _አይጠፉም_, 
   {{0x26770409,0xd1970040,0xdea400b4,0xd61103b5}},	//   _高等専門学校_, _בתואר_, _continut_, _direndam_, 
   {{0xe2b2028d,0x6c530005,0xa27e00a0,0xba1101f2}},	//   _mandian_, _tuttina_, _adinan_, _чиңҗүн_, 
   {{0xa72c0618,0x22900080,0xf2f3015e,0xc2780100}},	//   _miloševi, _immat_, _oblidat_, _mirnom_, 
   {{0xe30c0203,0xf98302d5,0x4dfc0462,0xdaf60205}},	//   _camaras_, _konkreet, _accesswa, _بولسنگیز_, 
   {{0xa2020034,0xf248019b,0xf58d0263,0x12380128}},	//   _borist_, _seimas_, _vertrokk, _rahmati_, 
   {{0x97410045,0x6f25004b,0xfca900d8,0xa3280137}},	//   _источно_, _daerekta, _assetgèt_, _каприоги, 
   {{0x57bb0168,0x89e3003b,0xdc1f0037,0x03dc0062}},	//   _finnmark_, _emathebu, _drypers_, _mahwa_, 
   {{0xbaf30321,0xc9ee0075,0x0ed3003d,0x8fe800c1}},	//   _presenet, _bakteriu, _altituds_, _विशाळगड_, 
   {{0x92e101bc,0x9b060348,0xeabf0450,0x52cb036c}},	//   _toaniel_, _amusanga_, _gûverneu, _dakozia_, 
   {{0x8b4e00f5,0x174e0272,0x32ca01e5,0xb99d0125}},	//   _башласам_, _abanneeg, _biodun_, _чакыр_, 
   {{0xec0001c6,0x4313029b,0xce4c0322,0x42dd008f}},	//   _fansels_, _jambaar_, _bakavana, _betooni_, 
   {{0x832201a4,0xc52a0218,0xbdd90105,0x71f80308}},	//   _garcons_, _argingch, _traktuje_, _ingatkah_, 
   {{0x437a0371,0x179d0311,0xf16301a3,0xd86e01cc}},	//   _affatto_, _ተነጊርዎም_, _ٽارزن_, _पारलौकिक, 
   {{0x1d4e0220,0x2935035e,0x7e4d00cb,0xd38702a0}},	//   _задавани_, _krompira_, _angazina, _olura_, 
   {{0xbc7500c1,0xd48c0334,0xa67c003c,0xf2fe012c}},	// [1410] _ciputat_, _anagonek, _طالعبینی_, _kuugua_, 
   {{0x3a12019d,0x265000e6,0x7f260143,0x00000000}},	//   _akachira_, _企业经营管理人员, _affezion, --, 
   {{0xe38702d4,0xf9e10217,0x79c40037,0x739601b8}},	//   _alura_, _exhibiva_, _ለጦርነት_, _unusta_, 
   {{0x83ea0240,0xb2c8018d,0x31cd0041,0x3ad103b5}},	//   _keitou_, _ሽግራትና_, _мшыуп_, _termakan_, 
   {{0xcb7701c7,0x48d800d9,0xe99a02ac,0xa2180119}},	//   _арзасы_, _секунды_, _ترنيمة_, _magkatam, 
   {{0xa2310075,0xcdb4025f,0x937900a1,0x3b6f0209}},	//   _marknaða, _alongola, _tauanga_, _alloriar, 
   {{0x903700db,0xe7ec004e,0xf1ea03b7,0xd1ee0237}},	//   _अपनही_, _iglalang, _atricesm, _돌아갑니다_, 
   {{0xf76000ba,0xb4490166,0x02d80556,0x96f501d9}},	//   _سلاوله_, _privaten_, _ihlelo_, _eisterrä, 
   {{0xfe430003,0x0322040e,0x0854023e,0xdbf30161}},	//   _betaalde_, _baryon_, _سومين_, _планшеты_, 
   {{0xeb81002b,0x67720059,0x15b50045,0x66b602f0}},	//   _লাগতো_, _централа, _старосед, _ihlelelw, 
   {{0x369600c4,0xe5390008,0x52010007,0x33860619}},	//   _عالمگير_, _توپتور_, _docier_, _uzorke_, 
   {{0xf3170005,0x0c1c0093,0xda61023d,0x81170079}},	//   _plazza_, _участки_, _conferma_, _publicēš, 
   {{0x19f3015e,0xb2fc00a5,0x41ea01da,0xe2fd011d}},	//   _matinada_, _paaga_, _çiklizëm_, _lumanari_, 
   {{0xa461002c,0xd302015e,0x729400f3,0xa6980223}},	//   _hondartz, _интрузия, _kubalimi_, _оёдолчин_, 
   {{0x826c008d,0x0ee30238,0xc3170338,0x68460420}},	//   _osmon_, _plakaten, _amainatj, _analisad, 
   {{0x22fc054b,0x7eb300e4,0x419a0079,0xbeb40044}},	//   _waaga_, _chronion, _sekretār, _reserves_, 
   {{0xc2250429,0x006e006a,0x00000000,0x00000000}},	// [1420] _syakir_, _hanamelo, --, --, 
   {{0x1b4c0035,0x93860282,0x76d1028a,0xb1760021}},	//   _dekadası_, _roera_, _zitatumi, _eignsray_, 
   {{0x75160387,0x137f0062,0x927f018a,0xf29103d8}},	//   _olileany, _elladha_, _beuno_, _seljake_, 
   {{0xcea105ff,0xe38700c3,0x5795018b,0x1c210061}},	//   _posljedn, _plura_, _буридан_, _최종정보수정일_, 
   {{0xb2bb0515,0xc2350235,0x725a0296,0x99ca0109}},	//   _sedente_, _binduḥ_, _fylls_, _měkčí_, 
   {{0xf27b018d,0xe22400ec,0x00000000,0x00000000}},	//   _መተግበሪ_, _bankui_, --, --, 
   {{0xc2d80302,0x4458026c,0x2715022a,0x0d2c0073}},	//   _uhlelo_, _歷史人物故事_, _frutikum_, _dividite_, 
   {{0x53860396,0xb6d4003e,0xa7d704a5,0x27860235}},	//   _kleru_, _botabohi, _kokuzalw, _पर्वणि_, 
   {{0xcbfc00bb,0x7ed7002f,0x8c6200e6,0x00000000}},	//   _جگجیت_, _buwiskun, _vitrage_, --, 
   {{0x729101ba,0xd8760334,0xbd57005a,0x3fa1037b}},	//   _konkour_, _amangomu, _jinaschu_, _insertar_, 
   {{0xde51019b,0x5a2800ba,0x625a02fd,0x52fd0155}},	//   _ligoninė, _خولقێنێ_, _cholla_, _typiskt_, 
   {{0xe3af0181,0x4a910409,0x21eb0153,0x714e014c}},	//   _halvleg_, _babyyoga_, _キャプテン_, _sinenkul, 
   {{0x52b80418,0x036c0331,0x1af60077,0xc2ff01ad}},	//   _malesef_, _stigini_, _entevans, _saraburi_, 
   {{0xb3eb008f,0x8c8c01b2,0xa2bb024a,0xf3b900d9}},	//   _teatud_, _abutting_, _dededee_, _помечены_, 
   {{0xa57c017d,0xad13044b,0x527e02d0,0x9dc10020}},	//   _ジに対するお問い, _kunstner, _beens_, _fitisema, 
   {{0x929202fa,0xbbc9015e,0x21ff017a,0x0292027b}},	//   _maraso_, _барларды, _аминам_, _carato_, 
   {{0xd2ec00c7,0x7bb3030f,0xb2d80130,0x96740096}},	// [1430] _алман_, _manawatū_, _moneiz_, _arakenew, 
   {{0xa27e03eb,0x7b0c014a,0xe6f300b8,0x90060092}},	//   _weens_, _ناہید_, _satanakw, _小川明日香_, 
   {{0x1b8a0608,0x7da400e6,0x1ff600d9,0x7913004d}},	//   _fronteir, _人力资源管理_, _матрасы_, _處一年以上七年以, 
   {{0x535e041f,0xe9ee0183,0x227f0117,0x7842008c}},	//   _wokushum, _tetikasa_, _stanap_, _amaturas_, 
   {{0xd2ee0020,0xd2fc014b,0xcd38042a,0x92fd0064}},	//   _atafi_, _daago_, _baphetse_, _queixar_, 
   {{0x026c028d,0x8352061a,0x735d0291,0x52fc029b}},	//   _lemond_, _खल्ला_, _langmsg_, _laago_, 
   {{0xae1c00e5,0xa94e01f6,0x6e560244,0xc48601db}},	//   _pergunta, _নামনি_, _ареста_, _имани_, 
   {{0x2b42041f,0xf5ad01b7,0xacae039e,0x3c7201ef}},	//   _wakwenza_, _यावता_, _forsking_, _польшчы_, 
   {{0x7bad0561,0x02ab013b,0x88710093,0x824803bf}},	//   _karoséri, _lindung_, _ислама_, _edomo_, 
   {{0xc053003b,0x63660076,0x826c00d0,0xdd380169}},	//   _imiseben, _реалност_, _andoni_, _বিছানায়_, 
   {{0x621304bd,0x2ae7002b,0x92fa0205,0x1a8e019a}},	//   _akahai_, _ঘটনাটা_, _bechora_, _clungies, 
   {{0x6ba70193,0x9ca60125,0x3292013d,0xf9870303}},	//   _berisiko_, _чагыряр_, _hararo_, _diokobat, 
   {{0x55230277,0xefbf0268,0x24a50397,0x9ec8011a}},	//   _teknoloh, _opulatio, _ababekuk, _recipien, 
   {{0x059c0300,0x22900286,0xa12b027e,0x626c019d}},	//   _souhlasí, _emmah_, _оксида_, _biloyi_, 
   {{0xd29201b7,0x5c5800f2,0xab600435,0x327e01df}},	//   _parato_, _pietiek_, _амнестиј, _peens_, 
   {{0x0699045e,0x17630135,0x7b180274,0x030003f8}},	//   _несебър_, _alekseev, _dásamleg, _danabli_, 
   {{0xabfa04f2,0x331e017d,0x65ea00e2,0xb19a0061}},	// [1440] _vietcomb, _frankrig_, _himmelum_, _선생님들은_, 
   {{0x5c8c0093,0x3f2e018b,0x96d30255,0xc8dd03a2}},	//   _концерта, _conexiun, _देवानागर, _सिमटा_, 
   {{0x2067061b,0x82f5044d,0x4723061c,0x9da60064}},	//   _वर्षकी_, _bitigam_, _narednoj_, _لىمون_, 
   {{0x71d90166,0x227e0262,0x6ea700d0,0x6b5500ee}},	//   _willkomm, _edinen_, _villabon, _италичуу, 
   {{0x02ee01da,0x71f10011,0x935f0111,0x93170185}},	//   _stafi_, _adonikam, _rameaux_, _cimerü_, 
   {{0x22000130,0x28470205,0x47b200bb,0x64f80162}},	//   _seniñ_, _назария_, _سلیکٹر_, _қалаймиқ, 
   {{0x1d5701ca,0x7a3c0041,0xb2da02f6,0x99900166}},	//   _binaqchu_, _ауӡом_, _eksena_, _einkaufe, 
   {{0x4d8100a7,0xb3fa014f,0x2b88050a,0x02ee033e}},	//   _diferent_, _veruje_, _birimler, _delfia_, 
   {{0xe2240359,0xb2ea002f,0xce41017f,0xd2df00e4}},	//   _tinkt_, _arbieto_, _anpartit_, _szwedzki_, 
   {{0x4aad00a4,0x00000000,0x00000000,0x00000000}},	//   _previste, --, --, --, 
   {{0xb19c0113,0xdbfe00a2,0x0dd30099,0x00000000}},	//   _هلالي_, _makumbus, _ewikilea, --, 
   {{0x4fd502a2,0x4dba006c,0x4bef0109,0x00000000}},	//   _wikisago, _amahekta, _objektec, --, 
   {{0xa2020237,0xd292020b,0x83040012,0x68f20420}},	//   _vorige_, _bararo_, _झँझिरिया_, _уличната_, 
   {{0xf729009a,0x2dc30122,0x62ab02c7,0xe29204d8}},	//   _حيواناتو_, _bokongé_, _bindung_, _cararo_, 
   {{0x3ff90169,0xf27e05f4,0x3778014a,0x4a140281}},	//   _দাম্পত্য_, _atinta_, _چوراسی_, _anaanama_, 
   {{0x8c7c0359,0x92ca0087,0x737d0152,0x12cb044a}},	//   _huisman_, _fihleli_, _eşsezlär_, _nakolia_, 
   {{0xc01c007e,0x229201ac,0x4fc40040,0x972f0009}},	// [1450] _asminkār, _asraon_, _לנציגי_, _dimenzij_, 
   {{0x216f04ea,0x699a031e,0x99bb011a,0xb3bd0076}},	//   _prosesho, _sluša_, _hardship_, _засадени_, 
   {{0x4eb901b2,0x56960040,0x23a20040,0x726c009f}},	//   _absolvin, _היוקרה_, _לחיתוך_, _bidoni_, 
   {{0x125a0321,0x384d01e6,0x326c000b,0xd224014d}},	//   _okolja_, _nedoporu, _mitimiti_, _sinkt_, 
   {{0x3321055a,0x146400e6,0x8c7100d8,0xe2ee0325}},	//   _décima_, _中国中医药论坛_, _aparant_, _arifə_, 
   {{0x14fb02a5,0x706201c9,0xd7c901de,0xeb2b036c}},	//   _काहानी_, _enesetun, _таратуды, _hananias, 
   {{0xa33c0040,0x3fde01a7,0x14a202b6,0xc3e8005b}},	//   _ומתלבטים_, _irtisano, _эконо_, _akitsuki_, 
   {{0x62480250,0xfb2001c5,0x0291005c,0x8ff2055f}},	//   _krimit_, _macallin_, _babamo_, _faturası, 
   {{0x725704c9,0x1dc20092,0xe0f8032b,0x4b63000c}},	//   _westphal, _ご了承下さい_, _пүрстигә_, _cuarzosa_, 
   {{0x80f50459,0xf27f004c,0x2d36036e,0x6a320452}},	//   _अप्रैल_, _awanga_, _chipirir, _आल्हाददा, 
   {{0x06bb02a4,0x9c27018b,0x6ee300f4,0xd36600d1}},	//   _setattri, _примиря_, _blaketen, _গিৰ্জা_, 
   {{0xca0f0211,0x76b002b0,0x3a0800ff,0x2851061d}},	//   _rakastaa_, _hotelbew, _שעניצע_, _шәрбәт_, 
   {{0x804d008d,0x85b2061e,0x1302000a,0x62f50418}},	//   _خلقرا_, _alítuyqu_, _affarlu_, _intikam_, 
   {{0xc0e104f8,0x6bb0042c,0xb8f8033c,0x00000000}},	//   _uninstal, _šikanira, _isradded, --, 
   {{0x9e51015d,0x42ea02f3,0x7c6b004f,0x4b090079}},	//   _ostatnie_, _kuriren_, _geureum_, _karstuma_, 
   {{0x92b505f4,0x82c5000b,0x55ce006c,0xb47b0265}},	//   _addcat_, _kooline_, _назму_, _benutten_, 
   {{0x02d6045a,0x00000000,0x00000000,0x00000000}},	// [1460] _skilles_, --, --, --, 
   {{0x52e900b0,0xdb220176,0x6c6f00ee,0x00000000}},	//   _arrinta_, _afspille, _loturik_, --, 
   {{0xdf1602cf,0x52cb044a,0xc28c0334,0x9b2502b6}},	//   _илинденс, _bakolia_, _anakana_, _тумасы_, 
   {{0x116a0497,0xbcbe02d3,0x404600be,0x46b200c0}},	//   _kiangley_, _надеж_, _جۇڭحۇاا_, _pangkali, 
   {{0x6c6101c2,0xd29201e5,0xd3220028,0x7b1b014a}},	//   _daquela_, _darapo_, _maryan_, _funkciót_, 
   {{0x438601b4,0x2ca5025c,0x820200ec,0x79a90211}},	//   _koers_, _konzentr, _norime_, _родилась_, 
   {{0x12fc04de,0xfb9d0446,0x75ad0012,0x4a9d0541}},	//   _raage_, _sufinanc, _धारति_, _sufinans, 
   {{0x02f1030d,0x86c30017,0x0c6103ed,0xe0450192}},	//   _ictimai_, _volantem_, _naquela_, _begrafen, 
   {{0x03960180,0x0276003b,0x4c2f019c,0x4fdb018d}},	//   _dousma_, _angancum, _atopọ_, _መጽሓፎም_, 
   {{0x72e30242,0x1eb504b9,0x4ecf02a6,0xd9e200ba}},	//   _istinad_, _rooftops_, _bruyère_, _سۆفتوێره_, 
   {{0x8f1701bd,0xd2ba0255,0x0bef017e,0x00000000}},	//   _اناڭنىڭ_, _suletud_, _bajoneto_, --, 
   {{0x0e1a0238,0x7c370188,0x60d301da,0xedab022b}},	//   _юридично, _забону_, _holandez_, _vinninga, 
   {{0x427f0050,0x8c0b01ea,0xe2f302a2,0x226e0393}},	//   _keuna_, _maishiy_, _kalahati_, _mitovi_, 
   {{0x6b0301bb,0x89800362,0x00000000,0x00000000}},	//   _дореден_, _babiblia_, --, --, 
   {{0x020e0244,0xb56400d1,0xed74015e,0x327f012c}},	//   _капак_, _অকলশৰে_, _gramenet_, _twanga_, 
   {{0xb248018b,0xd2f702eb,0x5b510029,0x956e0046}},	//   _primit_, _кинонд_, _پێبده_, _ايگەرىم_, 
   {{0xb02a0092,0x1c5200c1,0xb27c004a,0x00a4015e}},	// [1470] _バンクディ_, _तरबेज_, _häryakla, _имаратты_, 
   {{0xa37801f7,0x12910285,0xbbc1000c,0x65fe03f4}},	//   _medalha_, _habaho_, _ambovóra, _подмоско, 
   {{0xd2c90037,0x926c041e,0xc3a20181,0x00000000}},	//   _በድርድሩ_, _piloni_, _panpan_, --, 
   {{0xe0fa00de,0xd2ba0213,0xbb9b01d9,0xf248011d}},	//   _افتخاري_, _втором_, _technesc, _trimit_, 
   {{0x4d5701bd,0x525b0034,0x02020225,0x831402ff}},	//   _кабинеті, _stelpu_, _obuien_, _chabrak_, 
   {{0x2e1f0057,0x4200044d,0xf065024a,0x89bb0137}},	//   _ተጠንቀቁ_, _adiis_, _alabaṣep, _gelditze, 
   {{0x025a0034,0xd3f90158,0xb169020b,0x00000000}},	//   _falleg_, _सीजफायर_, _matshwao, --, 
   {{0x42ee025c,0x1ece00ee,0xeaf90240,0x5a4f03ef}},	//   _griff_, _birzikla, _naisogot, _algeriya_, 
   {{0x8fe80426,0x13ec019d,0x62fc019b,0x6387015e}},	//   _लालायित_, _amamudik, _kilimas_, _coure_, 
   {{0xfdea018d,0x8cd6045b,0xa83b00c1,0xd2ee0037}},	//   _ሓድነቱን_, _забрали_, _उघडपणे_, _ariff_, 
   {{0x7d7b0025,0x0290008e,0xb29101dd,0x92f50023}},	//   _anumīyat, _dinanu_, _babaho_, _häihin_, 
   {{0x427e020d,0xfc890116,0x6b8805e2,0x124703c1}},	//   _atinya_, _profited_, _avanzado_, _разигра_, 
   {{0x2d980206,0x7e5a0235,0x239400ad,0x1b0502ba}},	//   _kolekcie_, _apacāyet_, _tonggong_, _алмаато_, 
   {{0x5c210240,0xe2a603a4,0x2248036a,0x33f80184}},	//   _bogilevu_, _tobbi_, _iloma_, _bujuju_, 
   {{0xb386015c,0x627e0127,0x854d0162,0x6dc002e7}},	//   _anere_, _afent_, _پارتىلاپ_, _katigula, 
   {{0xeb1b014a,0x7b400204,0x58440040,0x5387033d}},	//   _funkciók_, _halvalla_, _postings_, _boure_, 
   {{0xf2f50023,0x8292005b,0x4464028b,0xfb1a0067}},	// [1480] _näihin_, _harago_, _рзуны_, _dibamoon_, 
   {{0x73f4015c,0xc20202d0,0x483e0210,0x28d80137}},	//   _kruten_, _cosier_, _chemajud, _вакцинаа, 
   {{0x2c73006e,0x23200286,0x2b5d0045,0xe0580272}},	//   _arisona_, _yenya_, _дивизија_, _baasulan, 
   {{0x522400cd,0x0d7c023e,0x4dd9006f,0xa5020059}},	//   _janki_, _agamanip, _بڪواس_, _libretto_, 
   {{0x62fc0028,0xc9cb0274,0x9c5a050a,0x787401b5}},	//   _kaaga_, _unglinga_, _defteri_, _etiyuniv, 
   {{0x6b1700f5,0x8fb0026f,0x52480095,0xdc5c0109}},	//   _агитацио, _айшуак_, _rahmad_, _बालेर_, 
   {{0x4f4c0160,0x9e4c04a8,0x82fc02a2,0x62fa03da}},	//   _rasprave_, _raspravu_, _maaga_, _mechara_, 
   {{0x4b2300b0,0xddc30047,0xb2f701e6,0x220200de}},	//   _isbahays, _volonté_, _podstaty_, _azikufum, 
   {{0x0c550259,0x43ed061f,0xc8ec033e,0x534d00c3}},	//   _deltage_, _studenog_, _колумбиа, _impetum_, 
   {{0x230100bc,0x332002f3,0x02fc003a,0x4f3100b6}},	//   _piranti_, _menyn_, _uyiga_, _massoowa, 
   {{0x42240054,0x025a029f,0xe248026a,0x8a1e00ff}},	//   _yanki_, _okolia_, _eloma_, _זוטשקע_, 
   {{0x69f70300,0x031203d3,0x296c01cd,0x12ad00dd}},	//   _dodavate, _forbudt_, _саривақт_, _caribî_, 
   {{0xf2db0027,0x827e0321,0x689400b5,0x003200c1}},	//   _filosop_, _bolnih_, _бутруш_, _वसाहत_, 
   {{0x7ec301b7,0xccaf0238,0x538700a4,0xaa0803f3}},	//   _संस्कारस, _обставин_, _roure_, _garandee, 
   {{0x4e38038e,0x7af90220,0xfb61008b,0x00000000}},	//   _perawata, _социални_, _kontaraa_, --, 
   {{0x137f0544,0x27c90059,0xf26e00e3,0x43010202}},	//   _kanalua_, _tempesti, _intomx_, _riranti_, 
   {{0xe26c013d,0x00000000,0x00000000,0x00000000}},	// [1490] _memoru_, --, --, --, 
   {{0xe2240189,0x862600be,0x528c0349,0xe1b702da}},	//   _sanki_, _قامىلعا_, _asesphay_, _пинокио_, 
   {{0xf525016d,0x0c9202f6,0xb30500d9,0x47a40156}},	//   _ﺭﻩﺳﯩﻢ_, _marunong_, _maanvilj, _alstrebi, 
   {{0x32fa015d,0x327e04bd,0x46a502c1,0xf7a70255}},	//   _informuj, _agena_, _kurushah, _intressi, 
   {{0xdfcc01e8,0xfeee02ac,0x2dbd02eb,0xe29000fe}},	//   _pacifier_, _الخنازير_, _барагсад_, _imeat_, 
   {{0xaeb80261,0x925b004f,0x896f002b,0x0c6f04e8}},	//   _komencis_, _alalam_, _অসাংবিধা, _adarron_, 
   {{0xb7bb002e,0xd2ee0327,0x2d3b01da,0x727f00fb}},	//   _međutim_, _traff_, _tanishme_, _ifune_, 
   {{0x7b91004a,0xdd2c011a,0x92480046,0x1f1e014e}},	//   _фәрештә_, _minimise_, _ploma_, _упропаст, 
   {{0x32800032,0x75ba02e5,0xb27e012c,0xf2480259}},	//   _darkcle_, _иранашьо, _kuinua_, _grimme_, 
   {{0x89ee010f,0x29e40241,0xb7ab0253,0xd86d042d}},	//   _bacteriu, _amaneera_, _partiimi, _andinind, 
   {{0xb27e02b0,0x727f006f,0x213000be,0x12e900d8}},	//   _meinen_, _uwanja_, _اسمانداق, _seriosa_, 
   {{0xa27e0258,0xbc6b0157,0xb7d40156,0xc320007f}},	//   _leinen_, _कृप्या_, _לאָבזעג_, _fenyn_, 
   {{0x93860099,0x7dd40250,0xadd50344,0xd320046b}},	//   _joeri_, _ndikimit_, _biskopit_, _genyn_, 
   {{0xac800074,0x32820148,0xbdc90244,0xaa2503a4}},	//   _несет_, _門牌查詢系統_, _крепостт, _forbanka_, 
   {{0xfba5020f,0x227e033e,0x5a510156,0x8dcf006c}},	//   _abazokub, _aponde_, _מוסלמענע, _akahambe_, 
   {{0x31c5032d,0x03b6002e,0xf32001e8,0x920200e9}},	//   _планын_, _obavlja_, _henyo_, _kirite_, 
   {{0x09630083,0x42da02c0,0xd65703a4,0xd2e901f4}},	// [14a0] _suandont, _ítens_, _atlitið_, _berilsa_, 
   {{0x2394035d,0x53f00109,0xed9a018f,0x00000000}},	//   _spisak_, _चेलीबेटी_, _relobrup, --, 
   {{0x227e025c,0x764d0178,0x42d90073,0x86b901b5}},	//   _deinen_, _abrahmaṇ, _exper_, _halateri, 
   {{0xc4f20178,0x7834014e,0xe1da020f,0x00000000}},	//   _alamāryā, _културу_, _لکڼوال_, --, 
   {{0x27730440,0xd26e0092,0x4f3a00ba,0x82e700dd}},	//   _arayanyw, _motoni_, _بکێشێته_, _acenion_, 
   {{0x132802c9,0x94ea02ca,0x00000000,0x00000000}},	//   _тресэлта, _meatadón_, --, --, 
   {{0xb0170164,0x027e00ab,0x32da0620,0xb02e0100}},	//   _районни_, _otinga_, _vereor_, _desetogo, 
   {{0x579801bd,0x53f8003e,0xa24903b4,0x00000000}},	//   _исламның_, _barutehi_, _arambe_, --, 
   {{0x927e0421,0x86dc010c,0x09f90127,0xc2000262}},	//   _keinen_, _साहिर_, _adlavare, _meniñ_, 
   {{0x2be7012b,0xc45700ec,0xff0a033e,0xdfb900a7}},	//   _dyrektor, _koncertų_, _guàre_, _араптард, 
   {{0x42900233,0x32b5046f,0xaba7003c,0xb119004c}},	//   _ilmari_, _feldwee_, _گوشتخوار_, _banjagal, 
   {{0xa38700a1,0x638705d5,0x8a5100c8,0xa28c00d5}},	//   _koura_, _pluri_, _bademona_, _diakona_, 
   {{0xd290006e,0xca29004d,0x21cd0487,0x4b8e04e6}},	//   _almasi_, _歷年得獎專輯_, _textbook_, _anunsiyo_, 
   {{0x93ce0514,0x0d240420,0x71c3002b,0xdee70224}},	//   _vulve_, _аларми_, _কলকাত্তে, _bankaman, 
   {{0x79760076,0x22240306,0x42910198,0x18f701cf}},	//   _atendime, _kanku_, _kazalo_, _dispariv, 
   {{0x12cc034b,0xc3c6027b,0x429001d7,0x73ce034b}},	//   _paslain_, _परमतत्त्, _linard_, _tulve_, 
   {{0x3ecf0388,0x4ed30281,0xe2900203,0x4f6f009c}},	// [14b0] _posizion, _immitsin, _finard_, _canastas_, 
   {{0xe8fa0026,0x927e03d9,0x6e960334,0xe87d01b3}},	//   _verpleeg, _adinon_, _asamakon, _консерво, 
   {{0x226e036a,0x425a022a,0x025a02fb,0xa42304a7}},	//   _botoni_, _ililom_, _ikoloa_, _aprazado_, 
   {{0x93b00305,0x9349006e,0x292f0037,0xc29005c1}},	//   _halvdel_, _biteeli_, _ወንጀሎችን_, _almari_, 
   {{0xe3960163,0x72500397,0x531202e5,0x89f80282}},	//   _kissé_, _тесак_, _banbros_, _hararete, 
   {{0xcef2027b,0x325a019a,0xbaa90060,0x63860144}},	//   _गणिका_, _heelie_, _кешеге_, _áirne_, 
   {{0x00c6006c,0xf5940037,0x852b0144,0x069f0462}},	//   _abalimal, _ታንቀላፋለህ_, _ghrianch, _astenedf, 
   {{0x484d04b2,0x2936036d,0xd2570061,0xe2d901eb}},	//   _pigtails_, _chamorra_, _일부기능을_, _erangue_, 
   {{0xe5c1011d,0xf9c702d3,0x4988003b,0x927e0544}},	//   _истенцэ_, _самарас_, _ayokwent, _ofeni_, 
   {{0xe2e60051,0x927e023e,0x38d3002f,0x1f2c0145}},	//   _biznesa_, _ageng_, _aboutpag, _legendin, 
   {{0xe20200ea,0xe7a10372,0x397a01d7,0xe2da01e9}},	//   _corine_, _bostiedi, _equilibe, _diteko_, 
   {{0x1a1f00c7,0x439a0205,0x0c4a00cb,0x15150193}},	//   _yazarğa_, _нотариал_, _дипломҳо, _धर्माविष, 
   {{0x5b440590,0x41dd00b5,0xe2d900fd,0x92da01c4}},	//   _хүний_, _грызлови_, _cainnte_, _vereer_, 
   {{0xfb6e0075,0x936600c5,0x9b940119,0x00000000}},	//   _kollafir, _下属市县局_, _moniquir, --, 
   {{0x93fa0041,0x02a7012e,0x03870066,0xe96c0139}},	//   _kurusu_, _norbi_, _amaren_, _bahirant, 
   {{0x02010320,0xf27e003b,0xd9e000a6,0x3ab600f7}},	//   _bibile_, _efeni_, _بډایه_, _arbhakis, 
   {{0xc36500a6,0x6a170056,0x9d790311,0x94130291}},	// [14c0] _amarulum, _alabhast, _formimit_, _رايدر_, 
   {{0x78e7020f,0x91530156,0x54ac03f7,0x00000000}},	//   _دپلوماتا, _akordigo, _djöfulle, --, 
   {{0xd39f016a,0x53a202cb,0xc7ee0282,0x66a9045b}},	//   _חציצה_, _propao_, _kopaning, _заручник, 
   {{0xf2a7026c,0x394f018d,0x657c03bf,0xab630270}},	//   _morbi_, _ብምድግጋም_, _diadvokh, _reimplac, 
   {{0xb7e1053e,0x8af60009,0x0af5039f,0x4f260109}},	//   _forskrif, _videopos, _videoans, _भोलीदेखि_, 
   {{0x6ad6039f,0xc67b00a6,0x13fa00ab,0x400e05d2}},	//   _acetylat, _قربانيو_, _rurutu_, _matvaren, 
   {{0x89b90439,0xf320028d,0xb28e032e,0xbeb8004b}},	//   _ambexiwa_, _benye_, _laphiru_, _didomein, 
   {{0x8bc40222,0x16b5015a,0x37760025,0x12900226}},	//   _prochain_, _arkayivi, _प्राकृता, _domasi_, 
   {{0xca0e0041,0x1d060217,0x72d701c4,0x00000000}},	//   _арҭон_, _ululante_, _skilder_, --, 
   {{0x43200207,0x8e160156,0xf9e40155,0x62c80064}},	//   _wenye_, _ויסריכט_, _plantera_, _дастанчы, 
   {{0xbf1e0227,0xd0930169,0x52480087,0x132001b9}},	//   _pertanya, _রুহুল_, _hlome_, _tenye_, 
   {{0x126c023b,0x98c300be,0x51470297,0x18b20088}},	//   _nahora_, _сабырдуу_, _архивта_, _комурду_, 
   {{0x662404a7,0xd373023d,0xb345033d,0x527e04ee}},	//   _tecnolox, _domande_, _ansegne_, _ogene_, 
   {{0x732001a3,0x126c0120,0xa0bd0041,0x034101ec}},	//   _zenye_, _biloy_, _ирҿуп_, _ambegan_, 
   {{0x63200207,0x7c560621,0x427f0200,0x73490497}},	//   _yenye_, _partije_, _nwanna_, _aridity_, 
   {{0x26ba034e,0xca0a037f,0xc3e20498,0x32da0064}},	//   _amarakay, _konsullu, _kobercov_, _ítems_, 
   {{0x1b580125,0x7378002c,0x15fa004d,0xae2b0044}},	// [14d0] _барлагчы, _lanaren_, _處一年以下有期徒, _siblings_, 
   {{0x7fde0204,0xeda803c6,0x89e30022,0x00000000}},	//   _tulipalo, _ferreind_, _йомала_, --, 
   {{0x83020287,0x93a201a7,0x826c0318,0xa2920264}},	//   _orgasmu_, _kuopio_, _kalofi_, _harayo_, 
   {{0x5dab03f0,0x64510102,0x30660025,0xd29204d8}},	//   _minninga, _pendekez, _bindusār, _karayo_, 
   {{0x302a04b1,0xe65700d0,0x46950229,0x08470361}},	//   _sandefjo, _тийнхүү_, _muzeyini, _баварин_, 
   {{0xf29200b0,0x427e00bc,0x6292005d,0x584f0014}},	//   _marayo_, _ngene_, _carazo_, _burgosur_, 
   {{0x3d0f01ad,0x39e9014a,0x79fc0348,0xd60e012b}},	//   _sudoeste_, _keressük_, _asindika_, _मनोभावों_, 
   {{0x8afa0348,0x7597012a,0x0f400235,0xc248026c}},	//   _abafugib, _zaprojek, _apagatan, _primae_, 
   {{0x82f103f8,0x426c042b,0x92f4047b,0xe0550344}},	//   _biyitdi_, _nemogu_, _plantur_, _angalavo, 
   {{0x046d0064,0x89e30584,0xe38700c5,0x4df60021}},	//   _нарындан_, _salienta_, _lourd_, _aradoxpa, 
   {{0x611a019e,0xf30d04a2,0xe39500d3,0x6b0b0092}},	//   _бомбы_, _levamos_, _opasek_, _congoles, 
   {{0x09470076,0xe9f3003a,0x537803da,0x828801fe}},	//   _писател_, _natijada_, _zigaara_, _tinamuni_, 
   {{0x198e032d,0x3a49015e,0x00000000,0x00000000}},	//   _сабир_, _بەيتانىش_, --, --, 
   {{0x990803c7,0xcbb70158,0xb3f40343,0x70dd00e7}},	//   _pieniądz, _संस्कारो, _buutan_, _aminatel, 
   {{0x526c00a9,0xafe800e4,0x0201012a,0xb27f02f9}},	//   _bahora_, _देवानंद_, _kibice_, _atanta_, 
   {{0x3c44006c,0x718e01c7,0x626c0622,0x00000000}},	//   _abawisa_, _чоннелик, _cahora_, --, 
   {{0x09a1025c,0xca18004b,0x00000000,0x00000000}},	// [14e0] _diskutie, _khobotla_, --, --, 
   {{0x3b77005e,0x3c14027b,0x0c9b038e,0x00000000}},	//   _урулди_, _शुक्लवर्, _ringroad_, --, 
   {{0xd38603e6,0x626c007f,0x5e880177,0x8c090153}},	//   _dierf_, _halogi_, _принципқ, _本発明によれば_, 
   {{0x938700d6,0x6fcc0515,0xf29001f7,0x4110019b}},	//   _gourd_, _attinger_, _somari_, _pakeitė_, 
   {{0x32fd053d,0xc2b400b2,0x647b0211,0x92cb0196}},	//   _emzantsi_, _fincaa_, _fortumin_, _kulonga_, 
   {{0x1eb8012b,0x8b5c0169,0xf30d00b0,0x0de1019b}},	//   _lubuskie_, _বিশ্বকাপ, _samatar_, _laukelia, 
   {{0x395a0450,0xa2bc0244,0x8d91002b,0xc9f60414}},	//   _benoarde, _reddito_, _এক্কেবার, _kolukalu, 
   {{0x77ed027f,0x32a701ba,0x37530156,0x7dc4011d}},	//   _badasang, _korbo_, _האלדז_, _motivele_, 
   {{0xb3730083,0xa43c0008,0xa2ee0020,0xda4c03ba}},	//   _romande_, _الاسىزدا, _atafu_, _tagenimp_, 
   {{0x0387015e,0x1eb104ca,0xb5c903b5,0xd59601c8}},	//   _moure_, _dissoute_, _membasah, _miliardá, 
   {{0xd8880623,0x06ba0125,0x7e9004c7,0x037200fa}},	//   _स्वीकार्, _akwatori, _ranković, _dayalog_, 
   {{0x49f60231,0xc3440258,0xaf4c012d,0x127f01e5}},	//   _tristiqu, _betelle_, _risponsa, _itanra_, 
   {{0x530d02a7,0xfe0500c5,0x80f700af,0x6a50004b}},	//   _kamarar_, _combiné_, _будматер, _lekesana_, 
   {{0x4867017d,0x9967053e,0xaa0802ec,0xe2f5007e}},	//   _mulighed, _mulighet, _daraadee, _antikam_, 
   {{0x45010314,0x59c7017a,0x52d904ad,0x4387019a}},	//   _әйтергә_, _баракат_, _bonnake_, _bourd_, 
   {{0xbab600c1,0xa387012f,0x037b03b1,0x338602b6}},	//   _बडबडला_, _omaran_, _relevé_, _تاريعي_, 
   {{0x1ba50624,0xbc60007b,0x752701bc,0x262701d1}},	// [14f0] _abazakub, _pierced_, _definity, _definiti, 
   {{0x92d50169,0x00e0023d,0x73a300b3,0x4e0c00e6}},	//   _আশাকরি_, _онова_, _harpy_, _企业法人营业执照, 
   {{0x826c0198,0xe264017d,0xc38702df,0x4a90015f}},	//   _zalogi_, _boulet_, _amaran_, _gomisiwn_, 
   {{0x41d00218,0xac60033f,0x93870004,0x1c850156}},	//   _erversay_, _akauola_, _foure_, _יוליש_, 
   {{0x83fa0002,0x72300177,0x9fca015c,0x7c68005b}},	//   _struju_, _colmán_, _stengefo, _everevo_, 
   {{0x922601ad,0x7f09008d,0x00000000,0x00000000}},	//   _borken_, _razvedka, --, --, 
   {{0x3ec60011,0xe2cc0156,0x82cb01b8,0x4fec020f}},	//   _abizimba, _anglino_, _leedus_, _ډیرخطرنا, 
   {{0xf8020025,0x6c4700d1,0x439500e4,0xf631004d}},	//   _परिवारित, _আৰ্গছৰ_, _diesla_, _交通安全講習_, 
   {{0x0996048a,0x02d70566,0x9ed80126,0xa2fc008d}},	//   _картасы_, _skyldes_, _пропорці, _oyiga_, 
   {{0xb3170003,0x77120579,0xc38603e0,0x32240074}},	//   _functie_, _शब्दन_, _bierg_, _hanki_, 
   {{0xaec304bd,0x6224038a,0x4387016b,0xb32000eb}},	//   _oponopon, _kanki_, _amarin_, _benya_, 
   {{0xbc8400a6,0xca9b0321,0xd7c10299,0x824801fc}},	//   _قربانیان, _veličast, _ئەرقۇت_, _yoome_, 
   {{0xd37f042c,0x16280187,0xa7e804a8,0xc2ee00bd}},	//   _izlaska_, _климатск, _ribarstv, _draff_, 
   {{0x5836041e,0x4f090135,0x922b0279,0x378701db}},	//   _foncière_, _xäzrät_, _fromage_, _لاۋازىم_, 
   {{0x0a900372,0x83870225,0x8394002c,0x13780408}},	//   _comisiwn_, _emarin_, _abisua_, _angatra_, 
   {{0x82e500a9,0x77ed018f,0x85bf01fc,0xcf1d0085}},	//   _iboneka_, _dadaqang, _gamissam_, _kubunava, 
   {{0xd26c03bf,0xd3e50625,0xe26400ca,0x54af034d}},	// [1500] _balodi_, _januári_, _roulet_, _menanamk, 
   {{0x5c21048f,0x22f0016b,0xd39503d1,0x925401b5}},	//   _clergé_, _addinai_, _liesma_, _mutlangi_, 
   {{0x224801c9,0x38820134,0xe1b30576,0x891300de}},	//   _soome_, _ainipeku, _قاهره_, _استراليا, 
   {{0xcefd0444,0x260201d5,0xf2490282,0x88e8004d}},	//   _справок_, _تھرپارکر_, _iramoe_, _只要葉王高興就好, 
   {{0x2e3b04f9,0x00000000,0x00000000,0x00000000}},	//   _aporfioq, --, --, --, 
   {{0xfc560220,0xb9190066,0xad33012d,0xbf6502af}},	//   _здравето_, _биохимий, _karimaut_, _rutashin, 
   {{0x4b670137,0x59fa034e,0x72900133,0x285903d0}},	//   _галерей_, _agradese, _ammami_, _samoregu, 
   {{0xd13d02ef,0x557c015e,0x4f5100d3,0xdf570488}},	//   _abitasyo, _vendrell_, _सिंगो_, _financen, 
   {{0xad8004f2,0x02e500a9,0xe2fa00fe,0x085b00e2}},	//   _cafeluat_, _aboneka_, _faahiga_, _keunstwu, 
   {{0x53860206,0xb2d600ff,0xc2d8004b,0x0292022a}},	//   _miere_, _motoron_, _boketa_, _muskuls_, 
   {{0xfc03037e,0x7fe40195,0x1a170145,0x0b4000b5}},	//   _bampong_, _choithio, _пенья_, _inevujoa_, 
   {{0xf20000fe,0x1aca0132,0x2967011a,0x9c2a03b8}},	//   _aeaia_, _látogato, _delimite, _болдыңыз_, 
   {{0x327f0220,0x8da403bf,0x527e0054,0x902c0315}},	//   _stanza_, _bososela, _irinsa_, _banelifo, 
   {{0x312d0076,0x5d0f0333,0xe37800a0,0x5b5301a6}},	//   _масти_, _accultur, _alhasan_, _rāwinia_, 
   {{0x53950626,0x561f0162,0xe27e00b0,0x0691031a}},	//   _dneska_, _амиллар_, _arinta_, _eiseimei, 
   {{0x57b9021b,0x52ee0382,0xa07300a6,0xd9e300ff}},	//   _домашнюю_, _irifu_, _bayasoko, _aplikata_, 
   {{0x9b050627,0x9749053e,0xda8c03f3,0x1e35021c}},	// [1510] _krasnyst, _papirutg, _bevinden_, _inkasova, 
   {{0x3854019f,0xc3860347,0xa2900261,0x5a54005e}},	//   _ڪوريا_, _diere_, _elektis_, _ﺷﻪﻳﺘﺎﻥ_, 
   {{0x06a200b5,0x5fbf040d,0x17e201db,0xd3860506}},	//   _sinfónic, _dumeletš, _ابىزالدى, _eiere_, 
   {{0xd44600bc,0x127e03f5,0xfc2f003e,0x00000000}},	//   _سارقان_, _trinta_, _аҡбашева_, --, 
   {{0xa25b0140,0xc9c50037,0xdf21022d,0x00000000}},	//   _ilalim_, _ዋርካዎች_, _aspetten, --, 
   {{0x1c1c0092,0x9a1901cc,0x4c3400fd,0xfe3a003d}},	//   _ご利用規約_, _अवलोकिते, _cabadaic, _andromaq, 
   {{0x63eb007e,0x8e530122,0x00000000,0x00000000}},	//   _asatsv_, _anggawé_, --, --, 
   {{0xa38f033a,0x6c620007,0x44700137,0xd26d0527}},	//   _rapporti_, _tournee_, _мөлхөж_, _zapitati_, 
   {{0xb2ec0113,0x43400265,0x501e018c,0x00000000}},	//   _intinne_, _spieren_, _vereenvo, --, 
   {{0xd44f018d,0xdecf0268,0x42e202a4,0x10ab0061}},	//   _ታሪኽናን_, _ansition, _ioannem_, _웨딩드레스_, 
   {{0x461903f0,0x6ce80126,0xe9630217,0x803f018c}},	//   _vegagerð, _херсон_, _plenment, _schulden, 
   {{0x335f0010,0x03860585,0xc736040f,0xb69000ba}},	//   _nangabe_, _blizini_, _дыпламат, _هاوینان_, 
   {{0x874300be,0x9395004d,0x924802ec,0x4975013f}},	//   _ئزىلدەپ_, _我的想法是_, _nooma_, _erminige, 
   {{0x3037009a,0x72e3031a,0x62fd02c9,0xfaf90089}},	//   _lentshon, _glaiste_, _romilor_, _зиһенемд, 
   {{0x29a303db,0x4c76005b,0x00000000,0x00000000}},	//   _banjenge, _afesdvd_, --, --, 
   {{0xd27e00de,0xa24903b0,0x67c0034e,0x6a6a020f}},	//   _printa_, _framme_, _adoranki, _ډوبېدو_, 
   {{0xe2590004,0x92ee016a,0x32d90145,0xc8f80013}},	// [1520] _reflechi_, _grafo_, _viename_, _махкамас, 
   {{0x78630257,0x92020014,0x00000000,0x00000000}},	//   _straumur_, _lirise_, --, --, 
   {{0x72480028,0x2bb60148,0xe34100d7,0x8eda01a3}},	//   _looma_, _執行率占分配數_, _hatella_, _ڳراٽڙي_, 
   {{0xe2c104cf,0x631f0173,0x8d96038d,0xc2ca045d}},	//   _wahlala_, _cercano_, _konfront_, _okolini_, 
   {{0xab2d0281,0x7c07015f,0x82d40243,0xe9a00128}},	//   _qarasaas, _agosáu_, _mododda_, _masjidga_, 
   {{0x653c017d,0x2c84019a,0x286103e6,0xb387013f}},	//   _希望小売価格_, _rebelled_, _eroberer_, _bourk_, 
   {{0xdea80084,0x509c0141,0x00000000,0x00000000}},	//   _ngalakon, _убликаси, --, --, 
   {{0xf292033d,0xedbc04be,0x751c0628,0xe4750045}},	//   _aprann_, _ginikana, _командуу, _еулекс_, 
   {{0x3db802e7,0x63100270,0x8a6d0158,0x5f4b0060}},	//   _filament_, _nascite_, _अमेरिकिय, _اتاعىڭىز_, 
   {{0x72cc03b0,0x38c90037,0x0b340204,0x5b0f009f}},	//   _pølser_, _መሆንዋን_, _pelaamis, _glasbila_, 
   {{0x8a8700cb,0xf2a70033,0x69ed0291,0xd3e40238}},	//   _amazinga_, _sorbs_, _anlionra_, _сплатити_, 
   {{0xf26e0202,0x2b310376,0x3aed008a,0xd27e01a4}},	//   _nitori_, _absaloms, _satupait, _otinda_, 
   {{0x32010234,0xa3fa03e9,0x1c670086,0x3ead00a4}},	//   _leyin_, _tutuş_, _یرقان_, _ايشادان_, 
   {{0x510b0629,0x029204b2,0x520201ac,0x92ea015e}},	//   _owthgray_, _sarado_, _hirise_, _arriben_, 
   {{0x8f16002c,0xcbf70064,0x6f3701f6,0xa395008c}},	//   _настай_, _тиреген_, _forskara, _chesta_, 
   {{0xa40f001d,0xb7cd0040,0x3ba40139,0x6386004d}},	//   _beermann_, _מיונז_, _अनंतरं_, _onera_, 
   {{0xee010342,0x1202020b,0x027e014d,0xb9cb0170}},	// [1530] _anjenera, _dirise_, _beinen_, _cholinga_, 
   {{0x0c6701b4,0x21b904b3,0x624800f2,0xa2c60347}},	//   _bedreig_, _detektiñ_, _mammam_, _marlize_, 
   {{0xf512005e,0x429001b5,0x327e0007,0x702d02e4}},	//   _ﻫﺎﻛﯩﻤﯩﻴﯩ, _fomati_, _etinda_, _geddumho, 
   {{0x23870197,0x6b7d0226,0xd7d9034e,0x527e0421}},	//   _kouri_, _asanaper, _caquetá_, _weinen_, 
   {{0x66ba019e,0x65c60041,0xe43e01ec,0x629201e9}},	//   _разведан, _аҳкәажә_, _آسانتر_, _karabo_, 
   {{0x1af300d4,0x67f90238,0xc93302ac,0x31270374}},	//   _presinte, _признача, _خاضعة_, _мажозий_, 
   {{0xa2910148,0x326c019f,0x97c20024,0x92480108}},	//   _abramoff_, _balozi_, _মনবৰে_, _akhmad_, 
   {{0x82d8017e,0x997404e2,0x5395022c,0x93050374}},	//   _pokera_, _aidilfit, _kaasup_, _اوراب_, 
   {{0x35ec00bf,0x627f00a9,0x9aa60034,0x526e01e9}},	//   _приводит_, _itanga_, _markviss, _ditori_, 
   {{0x49590037,0x9201016e,0xb2d100bf,0x92de03fb}},	//   _ፓርቲውን_, _beyin_, _осмотру_, _redovnu_, 
   {{0x2c3102d5,0x7d3101b8,0x157b022b,0xd22401da}},	//   _artiklid_, _artiklit_, _brenniví, _floket_, 
   {{0x9387023e,0xe582017d,0xdb720205,0x82c603da}},	//   _ngerti_, _アフィリエイト_, _یئرین_, _ọdachi_, 
   {{0xd3f800e3,0x227f0007,0x6a9f01be,0x91fa015e}},	//   _allura_, _bwania_, _nevinnos, _билинген, 
   {{0x348d0040,0x822902f3,0x41cb01e4,0x00000000}},	//   _דיזינגוף_, _räkor_, _zánovní_, --, 
   {{0x6c660185,0x32bb0092,0xf27e02fc,0x025a03c2}},	//   _табышы_, _fedeste_, _atinda_, _ballig_, 
   {{0x127e02b0,0xe27e046d,0x19e1005d,0x52010264}},	//   _seinen_, _ngeno_, _аҭахрақә, _kabidu_, 
   {{0x5dc800d3,0x94850052,0x00000000,0x00000000}},	// [1540] _technice_, _शिवालय_, --, --, 
   {{0xe96602a9,0x4e54045b,0xef400044,0xb5d800ff}},	//   _простых_, _економіч, _subscrip, _סענעגאל_, 
   {{0x42fc001d,0x850701ea,0x025b0343,0x13950281}},	//   _arighi_, _қасддан_, _ilalom_, _asasaq_, 
   {{0x52120095,0xf06f0047,0xc2ec0240,0x72d30234}},	//   _omahe_, _proposon, _kitione_, _gálọ́ọ̀n, 
   {{0x8bcc0276,0xf2170074,0xa113004a,0x729a0164}},	//   _киродийә_, _klikkaam, _bankrotl, _хираҗәтн, 
   {{0x23570255,0x55b90113,0x6c6101ac,0xefc30243}},	//   _छल्लो_, _fillteán_, _storace_, _militeer_, 
   {{0x7f1e01ef,0x7b5e02eb,0xea0b0311,0x725a0013}},	//   _tradicin, _ираны_, _ሰክረታርያት_, _yallig_, 
   {{0x514c0410,0x0753025c,0x63f800ee,0x4ebc0020}},	//   _ithekgil, _grundlag, _modura_, _fetulele_, 
   {{0x6c230622,0x62f30110,0x3f5b0343,0x85670161}},	//   _imuryé_, _pamatoti_, _makaiyan, _терминов_, 
   {{0x235d0135,0x2e1b0148,0xf9a802b6,0xb18a0311}},	//   _фотопрое, _臺北市民e點通_, _ереймент, _ኣሸገርቲ_, 
   {{0xd3a2024b,0x6e24008f,0x54b0062a,0xa2b90127}},	//   _propio_, _koolitus_, _लंगडी_, _baleseg_, 
   {{0xb156009a,0x8b500359,0x8c1203ee,0xb365005f}},	//   _خاموشه_, _vaatstra_, _propali_, _últimame, 
   {{0x6501018f,0xa3f40281,0x1c760142,0x81420094}},	//   _bireqtal_, _aattaa_, _नेत्रा_, _оттай_, 
   {{0xe2120601,0x82a701d6,0x48f4024d,0x8eae0115}},	//   _imahe_, _forbi_, _wamavowu, _tharikat_, 
   {{0xbab102cf,0xf292022a,0x25e303c2,0x80610060}},	//   _активира_, _caraco_, _balcaney, _قىيالداپ_, 
   {{0x425b00df,0x1cb10038,0x0d2904c7,0x00000000}},	//   _quelqu_, _исэптэн_, _произила, --, 
   {{0xcc7100b4,0xf2d700cc,0x1bf70094,0x09fc0279}},	// [1550] _pierdut_, _skiller_, _بىلەسىڭد, _intempér, 
   {{0x8eb000ff,0xc4fa0255,0xd1d901ec,0xcd7b015c}},	//   _המספיק_, _खैराती_, _اعتنایی_, _ageloggt_, 
   {{0x52a7022d,0x832c0061,0x00000000,0x00000000}},	//   _corbi_, _키워드광고_, --, --, 
   {{0x44960060,0xf26c031a,0x9c7001c8,0x00000000}},	//   _تۇرمىن_, _ghlor_, _pokroku_, --, 
   {{0x767d02c2,0x35e900f6,0x56a101af,0xa6280014}},	//   _privaath, _dayandı_, _amatlydy, _ambienti, 
   {{0xdf46005b,0xc7a00089,0x00000000,0x00000000}},	//   _voksende_, _гербының_, --, --, 
   {{0xb2e300c7,0x0a0a0056,0x1bdc0157,0x65860128}},	//   _iqtisad_, _ababewat, _तकिया_, _ошишига_, 
   {{0x5f3a001b,0xab020168,0x896902d8,0xf27f0556}},	//   _cyclonic_, _samfunns, _denpasar_, _efuna_, 
   {{0x130500a4,0x1b75012b,0x37ae0448,0xd2780209}},	//   _پولات_, _okolicac, _foreligg, _ajunng_, 
   {{0x6c0301c1,0x4f9a0041,0x96b9013d,0x39f603fd}},	//   _gampang_, _agãite_, _malaperi, _atinoina_, 
   {{0x72d90067,0x026c01da,0x107402e7,0xc34f00f4}},	//   _bayeet_, _kaloni_, _kapanaho, _dinerzh_, 
   {{0xc2ba0558,0xad3000af,0xb37f0251,0x7248022b}},	//   _weediri_, _jernbane_, _nolasha_, _blomm_, 
   {{0x03430143,0x938704a2,0xcb27019b,0x7386003d}},	//   _посока_, _louro_, _senamies, _ciera_, 
   {{0xe27f0417,0x265302fe,0x00000000,0x00000000}},	//   _seuns_, _ekwilizw, --, --, 
   {{0xe15c027b,0xb9e90049,0x95ba0342,0x3bf800be}},	//   _हविषा_, _hepisipa_, _ekwatory, _سويموق_, 
   {{0xd84000c3,0x221304d3,0xa2e9038b,0x27220177}},	//   _spiritus_, _tobhau_, _periksa_, _рхатәгәа, 
   {{0xefe702d3,0x46e103dc,0xf5250187,0xc310019a}},	// [1560] _правата_, _avtalað_, _sobrinho_, _scraggy_, 
   {{0xf27f0219,0x63860147,0xfabb03f1,0x67a80044}},	//   _ufuna_, _riera_, _neuverit, _pertaini, 
   {{0x03870076,0xac0301d6,0xfd9a00b7,0x5ebf003a}},	//   _couro_, _forsker_, _barlagla, _قویولگن_, 
   {{0x43860403,0x0982017d,0x46b302ac,0xaf47003c}},	//   _piera_, _beskæfti, _ومعجنات_, _عیدفطر_, 
   {{0x92480122,0xa27f0320,0xa27e0312,0x42c1024d}},	//   _geomax_, _pfuna_, _ugent_, _yahlela_, 
   {{0xc7ee0140,0xe2ee0274,0xbb0a0074,0x142101d4}},	//   _natatang, _krafa_, _avustaja_, _ariberto_, 
   {{0x9ce30242,0xec12011b,0x02010229,0xe8cc00b7}},	//   _yarısı_, _asopeli_, _seyid_, _сырларың_, 
   {{0xc2d90129,0x110a00be,0xa9d6024f,0x330003be}},	//   _bayere_, _دۉيشەەۋ_, _solesole, _inganji_, 
   {{0x89f700c5,0x22cb015e,0x02ef053a,0x81770397}},	//   _爱情两好三坏片尾, _quedat_, _siniša_, _angancel, 
   {{0x167b00bf,0xadc10053,0xc2ed00e6,0x5704027b}},	//   _отличие_, _onlineka, _mariée_, _असंशयम_, 
   {{0x73870249,0x4f59028f,0x00000000,0x00000000}},	//   _aigris_, _taupatup, --, --, 
   {{0xc2c70092,0xbd3a028f,0x00000000,0x00000000}},	//   _予約受付中_, _kapitene_, --, --, 
   {{0xb8620241,0x8909002b,0x427e04d7,0x3ec804df}},	//   _baanglad, _অণুকাব্য_, _beinin_, _beýnisi_, 
   {{0x527e02d4,0xc6ba020f,0xcbf801a3,0xbfb301db}},	//   _agens_, _bakangqi, _نيوٽن_, _قيىنعا_, 
   {{0xc38600dc,0x6dc102e7,0x6db30087,0x6c040388}},	//   _aneru_, _katiguma, _lokukulu_, _mensili_, 
   {{0xc7bc002f,0xad2d018d,0x92cb057c,0xb487026f}},	//   _adurarni, _ተስፋስላሰ_, _fredet_, _жидебай_, 
   {{0x6cd50192,0x03940140,0xb2990238,0x67220434}},	// [1570] _페이지까지_, _naisip_, _заборгов, _aparició, 
   {{0x2c530169,0xae4e0020,0xffe6007e,0x8b510084}},	//   _শূন্য_, _felagola, _apasṛtya_, _mendakan_, 
   {{0xce5400ad,0xeaf50008,0xe20200c0,0x290000de}},	//   _kasalaha, _aleshore, _enrile_, _awuphang, 
   {{0x927e0259,0x6aa60052,0x32da01b8,0x77250187}},	//   _ugens_, _दिल्लीमा_, _maantee_, _contagem_, 
   {{0xe5fd037c,0xd2b4023e,0xa25b025b,0x62cb000e}},	//   _filmmagi, _lancip_, _frelsu_, _credet_, 
   {{0x7dac001e,0x06820139,0x63860310,0xf39402a2}},	//   _fabrairu_, _व्यान_, _dhoras_, _maisip_, 
   {{0x71580079,0x4c670122,0x42380256,0x80cf039f}},	//   _konkurēt, _برسان_, _dzimusi_, _nanoscal, 
   {{0x2c7703b2,0x142a0041,0x07bb0444,0x89f30087}},	//   _popular_, _дадгылои, _оставали, _hlahluva_, 
   {{0x3fc301e7,0x827f0011,0xd91e00e4,0x5b2700e6}},	//   _wikinger_, _afunn_, _नानीहरुक, _文字的真实性_, 
   {{0x7e1900e6,0xd9dd000b,0xaa4f0517,0xd386026b}},	//   _为贯彻落实_, _hikomaga_, _psicodél, _kiero_, 
   {{0xb05900ba,0x327f0258,0x93f8032d,0xdb57022f}},	//   _دابڕێژرێ, _reuny_, _koduwa_, _вашаму_, 
   {{0x903501e9,0xc9c2012d,0xc75e00da,0xf12c0040}},	//   _bantlhan, _intenese, _опрееешт, _גלגולים_, 
   {{0x40fc00c5,0xeda60420,0xc2f20193,0x49ed00c6}},	//   _胶南市交通局_, _планинит, _पत्री_, _lysegrøn, 
   {{0x02a705be,0xa1590185,0xaf7204ac,0x0b6600c7}},	//   _borbu_, _сигналла, _подруги_, _прошкин_, 
   {{0xc1630071,0xe37c02af,0x77590162,0x00000000}},	//   _فائزه_, _batashe_, _بويۇنچە_, --, 
   {{0xa2da001a,0x828300ab,0x4bd804c7,0x4e8302b2}},	//   _ferenc_, _amokura_, _значило_, _родичів_, 
   {{0x0cbe015e,0x92940272,0x627e0331,0x88c805a6}},	// [1580] _кажет_, _abakopi_, _teinin_, _festning, 
   {{0x6082004c,0x52fc0430,0x675e0143,0x22a7042b}},	//   _abacondo, _nyaga_, _гимназии_, _torbu_, 
   {{0x7545003a,0x395202ec,0xeaa001f6,0xb224005b}},	//   _اندیجان_, _گٔنڈتھ_, _brukaren_, _panky_, 
   {{0xfc03038e,0x23f003a0,0x6037003c,0xe3940318}},	//   _lampung_, _belegang_, _مهرزاد_, _maisoa_, 
   {{0xd46f02e7,0x85f80191,0xa6050141,0x0f3b00bb}},	//   _kolehiyo_, _direktlä, _usullari, _شہادتِ_, 
   {{0xbad600c5,0xa85d015a,0xc0ff005a,0x5b880541}},	//   _中国国际广播电台_, _amanamuu, _choyajmo, _artiljer, 
   {{0xb3870279,0xec7103cf,0xdd9303d4,0xb39a0247}},	//   _jours_, _şirket_, _подвала_, _yésus_, 
   {{0x928e00d5,0x838c0019,0xc291017c,0xb26e0403}},	//   _ofisialy_, _тузем_, _jagade_, _hitodi_, 
   {{0xe6e4046d,0x348a023e,0xa3540095,0xf3e502c3}},	//   _rembuluw, _geofisik, _kasebat_, _spolujaz, 
   {{0xdcea0142,0x3387002c,0x4b38005e,0x3db6031a}},	//   _प्रमाणं_, _ilaran_, _ئاۋىئاتس, _churachd_, 
   {{0x23e0000c,0x4d0d009f,0x66d204eb,0x721901ab}},	//   _létra_, _snemanje_, _दैहिक_, _taskulam, 
   {{0xcead0590,0xfab90173,0x82fc0068,0x020e0361}},	//   _хүсвэл_, _বিদ্যালয়, _ayaga_, _закат_, 
   {{0x1c200261,0x29f80360,0xa1af0090,0xa81f03a8}},	//   _priskrib, _licencí_, _akamukum, _কািৰকিৰ_, 
   {{0xc27f022d,0x5e8d048a,0x920903db,0x53a00066}},	//   _stanca_, _шаршы_, _abahlwem, _академич_, 
   {{0xb46b01eb,0x43870279,0x4c5f032b,0x429102cd}},	//   _obtenido_, _cours_, _قورقما_, _bagade_, 
   {{0x7c370169,0x06c60041,0xa20d0143,0x849c02e4}},	//   _সংকটের_, _насыҧны_, _японки_, _dekadenz, 
   {{0xd0360205,0x92c104cf,0xd0c10307,0x0b750348}},	// [1590] _алимкент, _bahlala_, _bahlalel, _aleruuya_, 
   {{0x64860105,0xb46f01bd,0x7c6701be,0xb75a0374}},	//   _बुझाने_, _سكريپتسي, _nakupka_, _ливаннин, 
   {{0x61e10193,0x001a01d1,0xf39400f2,0xed15004d}},	//   _हजारो_, _providin, _seksam_, _liquefac, 
   {{0xd2920286,0x42360562,0xfc8c0040,0xf27f00b4}},	//   _abrabo_, _azoje_, _מהארון_, _franta_, 
   {{0xe24f0532,0xdb750006,0x7bba01c8,0xf989003c}},	//   _dogoditi_, _suaranya_, _velkého_, _سورینت_, 
   {{0x601e0040,0x526e02c1,0xe4b400ea,0x08fd0075}},	//   _הונגריה_, _intoki_, _manakaik, _adrastad, 
   {{0x23dd062b,0x1dfc03f3,0x839400dc,0x479502aa}},	//   _kapwa_, _verdient_, _gaisoa_, _diagnóza_, 
   {{0x51ca022a,0x5ed80051,0xa32103c7,0x00000000}},	//   _kretatik_, _skaistas_, _zabawę_, --, 
   {{0x92ee032d,0xc3e301eb,0xf5d30148,0x5277004a}},	//   _asafe_, _amirĩri_, _藝術品會說話_, _бауман_, 
   {{0x733c02b6,0xcfb4037c,0xc4bd0400,0xe2830103}},	//   _ايماقتا_, _protinus_, _associà_, _haikona_, 
   {{0x5dc8000c,0xe302005e,0xc2920181,0x8c0700f4}},	//   _amohenda, _ﺋﯧﻬﺘﯩﻴﺎﺟ, _sprain_, _alesant_, 
   {{0x2b670255,0x60da0518,0xb38601a7,0x040d0223}},	//   _कारने_, _پارکینسو, _koiran_, _gainditz, 
   {{0x52ee0295,0x7c610129,0x0b83005b,0x4387011e}},	//   _akonaki_, _mberede_, _fujimoto_, _sours_, 
   {{0x7062003b,0x738e0244,0xca3502a6,0x69820420}},	//   _anesitun, _versioni_, _tuscania_, _костур_, 
   {{0x73860377,0x979f020f,0xcf3b006d,0x627e02fb}},	//   _pierd_, _bentengi, _бiлiтава, _tuinga_, 
   {{0x30450400,0x2d2f0147,0x933400f2,0x6fad01a3}},	//   _impurtan, _اۋگۇست_, _nozarē_, _بگاڙڻ_, 
   {{0x874a009d,0x47bf01b4,0xac4000e6,0xc29e0040}},	// [15a0] _prizreni, _fauresmi, _并不构成投资建议_, _לוינסקי_, 
   {{0x16540243,0x7a5f0568,0xcc5a0234,0x2d700187}},	//   _makkaabi, _allmuges, _senturi_, _promessa, 
   {{0xe27f0229,0xcdf50416,0x928c0285,0xb2ee00dd}},	//   _fransa_, _credente_, _ahakana_, _crafu_, 
   {{0x6a9800d7,0xc386025c,0x73a900b9,0xff220125}},	//   _antikres, _tiere_, _jejaring_, _azalýar_, 
   {{0xb2e6024a,0xcdbf0309,0x22d90119,0xb9d70255}},	//   _adanida_, _regionla, _nocera_, _धनियां_, 
   {{0x84b80255,0x6ce40061,0x1d1700bb,0x00000000}},	//   _सिनेमाई_, _황사주의보_, _رندھاوا_, --, 
   {{0x0999000c,0x425a01c3,0x00000000,0x00000000}},	//   _ребекка_, _badlag_, --, --, 
   {{0x23fa0418,0x02b90044,0x72ec0195,0x363a0203}},	//   _kurulu_, _swedish_, _ceairde_, _derivabi, 
   {{0x92ee0372,0xc2d90125,0x2ecb0043,0x8cda00f4}},	//   _arafu_, _azaltdy_, _bakirwan, _dravideg_, 
   {{0xa292024a,0x827f0117,0xbe37011a,0xb34d0370}},	//   _daramo_, _nguna_, _explodes_, _belekok_, 
   {{0x6c0b01d2,0x4ff60299,0x82b6002b,0x0f5d0439}},	//   _akupana_, _بىزھەققى, _রোজগার_, _masakhan, 
   {{0x529201fd,0x3cea015d,0xc292024a,0x79b9019f}},	//   _abrazo_, _प्रमाणन_, _faramo_, _madereva_, 
   {{0x239504e5,0xc5f700c8,0x006d006e,0x2d8300ab}},	//   _abassa_, _армияла_, _demandoo, _kaimanaa, 
   {{0x7ff4030b,0x539403e8,0x6bd6062c,0xa95d01f9}},	//   _benyamin, _česen_, _चप्पू_, _amenyete, 
   {{0xd9210035,0x52480191,0xb386002a,0x3e180060}},	//   _эстетик_, _zooma_, _siere_, _көсем_, 
   {{0x8386044a,0x71160094,0xe98b02ac,0x1b28020e}},	//   _piere_, _جالباس_, _وأكبر_, _конькиҙа_, 
   {{0xe3cd008d,0x398300fe,0x22ee014d,0x3e1b01d9}},	// [15b0] _ватанини_, _faahinga_, _kraft_, _jugendha, 
   {{0x37d9008a,0x2f7a00d1,0xea010043,0x63150115}},	//   _lausilaf, _চিষ্টেমত_, _babafuga_, _muncung_, 
   {{0xbada042f,0xfee20193,0xeb7f01a6,0x227f007f}},	//   _taimatun_, _युक्तिवा, _itariana_, _beynon_, 
   {{0x479f0209,0x4c75013a,0x0c06021c,0xd27f021b}},	//   _katersug, _prisong_, _papriky_, _uransa_, 
   {{0xde4d0120,0x82f602e1,0x6bae00a6,0xb15300a7}},	//   _nagayina, _حفرالباط, _ekayakob, _مونتسەرر, 
   {{0x84970326,0x70b8015e,0x043e010f,0xd24801c9}},	//   _kuratidz, _туристти, _паҳни_, _rooma_, 
   {{0x43dd0380,0x928a0287,0x729202a7,0xfc4a0046}},	//   _ndawde_, _stromů_, _essaal_, _дипломдо, 
   {{0x7ec5029b,0xe38603a1,0x668200cf,0xc56400be}},	//   _jacopins_, _oneri_, _hindeebi, _وركەني_, 
   {{0xe63b01a7,0x938602d0,0x8e51024c,0x527f0097}},	//   _введите_, _chores_, _finanzja, _atanna_, 
   {{0x42d902f8,0x898b002e,0xd98b03a0,0x4b24022c}},	//   _akanete_, _preći_, _ikakanya_, _carponna_, 
   {{0x43fa011c,0xfa890180,0xb2d8023d,0x72e90313}},	//   _gurubu_, _fasilman_, _chiede_, _danidmo_, 
   {{0x7da501b5,0x827f0053,0xe6cf002c,0x98470013}},	//   _barisiwa, _nuansa_, _израилий, _карами_, 
   {{0x0f680033,0x990701a3,0x3ba00208,0x5212004b}},	//   _vacanzas_, _تعصبي_, _زیادبکه_, _emaho_, 
   {{0x82a700bd,0xb2a60242,0x62300255,0xc27e0037}},	//   _forby_, _tibbi_, _kaamera_, _ለማስታረቅ_, 
   {{0x72920028,0x4fde0161,0x920f02b0,0x001700ec}},	//   _darajo_, _водоросл, _fakultät_, _бхута_, 
   {{0xb00300be,0x76b700fb,0x00000000,0x00000000}},	//   _жоокер_, _singaphi, --, --, 
   {{0x557f0181,0x3c3b00d3,0x00000000,0x00000000}},	// [15c0] _lagersty, _हृदयघात_, --, --, 
   {{0x0068008d,0xbaf0021b,0x0c0c0234,0x77df018f}},	//   _журналин, _varustee, _ijarọ_, _jinasjaj_, 
   {{0xc9d00388,0x4c130111,0x03880096,0x31130021}},	//   _медии_, _abelianu_, _amasanam, _anikiway_, 
   {{0x82d800ff,0xd8e8028b,0x02fc0212,0x2bb90207}},	//   _ערדציטער, _ацәнакит_, _longum_, _علاوالدي, 
   {{0x9a230051,0x9c6100e0,0xbc7e0528,0xb35c0109}},	//   _darbinie, _fierste_, _friseal_, _सक्ला_, 
   {{0x9f730095,0x2e5c02c9,0x025a040a,0x226c00fe}},	//   _purbalin, _autorită, _samlat_, _fklou_, 
   {{0xf4220026,0x8320015e,0x2e21062d,0xee0f004d}},	//   _개인정보를_, _menys_, _primeros_, _中文標的名稱及數, 
   {{0x62920142,0x8202029a,0xd2010054,0xcbed0387}},	//   _paramo_, _dirize_, _kabilu_, _nkwonkwo_, 
   {{0x0291041b,0x12ef02fb,0xe5360517,0x133d0246}},	//   _osward_, _felihaa_, _rústicos_, _противен_, 
   {{0x42d904fc,0x027f018b,0xb2e60129,0x6f4002c2}},	//   _mayores_, _stanga_, _omenala_, _subskrip, 
   {{0xe3000184,0xaa6e0285,0x720102c9,0xe99000e6}},	//   _makambi_, _ntaganda_, _fizice_, _国务院法制办公室_, 
   {{0x738701a6,0x0a52004b,0x979702c4,0x8ebb031e}},	//   _pouri_, _batemona_, _циклус_, _širenje_, 
   {{0x3241015d,0x124800fe,0xa9c20034,0x48d2020f}},	//   _दलाली_, _hoomo_, _tilvitnu, _bezenkcu, 
   {{0x015d0101,0x1d670012,0xb6420372,0x00000000}},	//   _ofertelo, _कियैक_, _glanyraf, --, 
   {{0xb27f013c,0x4da002e1,0x00000000,0x00000000}},	//   _atanda_, _اشتهرت_, --, --, 
   {{0x227f00a9,0x54530041,0x42010261,0x105303db}},	//   _utanga_, _оқәымтәи_, _babilu_, _oliseben, 
   {{0x52b90040,0x3b6f0118,0x8bcc003a,0xc5cc0227}},	// [15d0] _חחחחח_, _amutuuma_, _кобилият, _tulangny, 
   {{0x9d3505ba,0x42240116,0xc26e02c9,0xc201037f}},	//   _स्वर्गीय_, _looket_, _capota_, _yeqin_, 
   {{0x04440092,0xb27f020d,0x29870316,0x030f008b}},	//   _ファンタジ_, _ifuni_, _alakanta_, _ecsamer_, 
   {{0xd12d00c7,0xdf6f0057,0x533c00d1,0xd70001ce}},	//   _тарту_, _ለመተግበር_, _ছদ্মবেশ_, _بدلیجات_, 
   {{0x8264025f,0xe3fa03ba,0xeecc0019,0xbd600012}},	//   _boulot_, _metuwa_, _албайсыз_, _गोसईन_, 
   {{0x7aa700b7,0xc2130119,0x499c0306,0xf918023d}},	//   _сайлап_, _mughal_, _akujmant, _cliccand, 
   {{0x9d440409,0x6212032d,0x1300001e,0x8a0a02af}},	//   _最近の記事_, _amahe_, _bakassi_, _baratuna_, 
   {{0xa61e008d,0xa3870065,0xf2fd062e,0x02a60342}},	//   _gaplashi, _klaren_, _hidimar_, _monben_, 
   {{0x338601d7,0xa9b1033e,0xba660187,0x60930291}},	//   _gieri_, _hendapet, _терминот_, _تطورت_, 
   {{0x320101da,0x00000000,0x00000000,0x00000000}},	//   _peqin_, --, --, --, 
   {{0xee1a00cf,0x45460377,0x5d460368,0x535205a2}},	//   _ameerika, _брашов_, _братом_, _उभयलिंगी_, 
   {{0x2ea001f2,0x6c6d0058,0x4a64029a,0x72640343}},	//   _мәхсус_, _balugik_, _boulvers, _coulee_, 
   {{0xd38103c4,0x3da30085,0xeaca0460,0xe4d70297}},	//   _террорлу, _sikotela, _मीटरींग_, _барасын_, 
   {{0x0e350163,0xf4850154,0x428d034c,0x4f240291}},	//   _kellemes_, _фуратэ_, _ayaktan_, _divergan, 
   {{0xd27f047b,0x7292046d,0x39fe02dc,0xe99201c3}},	//   _standa_, _faraho_, _machista_, _aachumme, 
   {{0x23860231,0x582000ff,0x9983002e,0x3c030050}},	//   _fieri_, _סמעטענע_, _građanin_, _lamping_, 
   {{0xbfbd0156,0x0e53000c,0xa24a01b3,0x00000000}},	// [15e0] _היבשע_, _ijobliga, _стояти_, --, 
   {{0x37ba02ab,0xd1440265,0xc5b600a2,0x62d900f4}},	//   _chorioni, _gastenbo, _kukabidh, _diberc_, 
   {{0xe1970044,0x9ff1016d,0x692c012e,0x30530219}},	//   _התואר_, _ﺋﯚﻳﮕﻪ_, _دانشمندی_, _aliseben, 
   {{0x82910449,0xf5680299,0x00000000,0x00000000}},	//   _lagane_, _تۇترۇقسى, --, --, 
   {{0xde2e0094,0x6ca4028a,0xd20000da,0xfa0e008a}},	//   _الداعىنى_, _تخمينو_, _numita_, _tamavale, 
   {{0xa9fb0010,0x9c5f0004,0x421201f1,0xe2a60342}},	//   _achashat, _septanm_, _njihni_, _konben_, 
   {{0xf5440010,0x226e000f,0x17dd0311,0x00000000}},	//   _bakhonkh, _kapora_, _ኣይረሳዕኩኽን, --, 
   {{0x95120244,0xe3870282,0x494c0396,0xe27e007f}},	//   _possesso_, _kouru_, _fotoelet, _leinin_, 
   {{0x28e800a5,0xdaa700d9,0x639501dd,0xc92c013b}},	//   _avasegag, _honkanen_, _abaswa_, _coscollu, 
   {{0xf2ee03de,0x59bc0022,0xd27f009c,0x29b400e4}},	//   _isifo_, _советтар, _aranwa_, _पर्वतमाल, 
   {{0x0291039e,0x5f920361,0xc26d0175,0x5c8501a3}},	//   _dagane_, _однокомн, _oktob_, _ترڪمينست, 
   {{0x22500073,0x927501c7,0x00000000,0x00000000}},	//   _externem, _dilimizi_, --, --, 
   {{0x220003ed,0x59c70135,0xf27804bf,0x6ad90156}},	//   _reais_, _баралар_, _putnik_, _אקאדעמיע_, 
   {{0x126e0009,0xb6d6023e,0x0c61041a,0xc37a0031}},	//   _zapora_, _هارمونی_, _nyttår_, _megapro_, 
   {{0x32cd01e1,0x86300037,0xb2ee00de,0xf27e010e}},	//   _angoang_, _የጥፋተኝነት_, _esifo_, _asinta_, 
   {{0xa200004e,0xd170031d,0xbba8027b,0x89c70361}},	//   _kumita_, _solidify_, _साधूनां_, _барамах_, 
   {{0x626400d6,0x03fa00bb,0x734b02e4,0xf90c00ba}},	// [15f0] _roulee_, _تریسٹھ_, _brieret_, _ناپاکییه_, 
   {{0xbf23021c,0xda0203c3,0xad5b0144,0x00000000}},	//   _objednan, _dijalekt, _فأجاب_, --, 
   {{0x32ee01ba,0x213b003f,0x296d01eb,0x916e015d}},	//   _grafi_, _bilesmeh_, _bipinnat, _प्रसंगों_, 
   {{0xd386045f,0x1181004d,0xf85b02aa,0x0ac901b3}},	//   _gjorts_, _嚴格檢查入托幼兒_, _senzorov, _гнізда_, 
   {{0x4c7e01b9,0xd1470094,0x49bf03f3,0x5d7f0322}},	//   _krisyal_, _фариза_, _samenste, _atambaye_, 
   {{0x127e062f,0xc27f04aa,0xcb62034a,0xa26e01cf}},	//   _laeng_, _ngune_, _contorna_, _sapora_, 
   {{0x7d1f045f,0xd803021c,0xd3870180,0xe20d005e}},	//   _beroende_, _samotný_, _kourt_, _بەرھەق_, 
   {{0xbf7302a4,0x19db01eb,0x9e1a02ee,0xfd390587}},	//   _turbolin, _amenása_, _potenzja, _contràri, 
   {{0x1a130630,0x5322019a,0x0a1402b1,0x7b0a0420}},	//   _bancnote, _rascals_, _fafaroma_, _милениум, 
   {{0xa20203e9,0x53860625,0x20bd0012,0xa2b402ea}},	//   _birine_, _mieru_, _उपजितिऐक_, _pancia_, 
   {{0x727e010b,0x21560145,0xf697000d,0x724801eb}},	//   _baeng_, _машына_, _nimetami, _jooms_, 
   {{0x41c70060,0x05c80076,0xbd9b0037,0xf63c048c}},	//   _داستانى_, _нареднит, _የገባሁት_, _bichlori, 
   {{0x1fa301b2,0xdde40158,0x3e14018c,0x00000000}},	//   _bisector_, _balkonie_, _regelmaa, --, 
   {{0x622a003e,0xfaf80276,0x0dd90081,0x1b350322}},	//   _мотал_, _تارانچىل, _borgarís, _barampis, 
   {{0xc2d500a1,0xfda60465,0xe27e0322,0x00000000}},	//   _rotorua_, _tovornja, _arinda_, --, 
   {{0xd248036f,0xad9d0220,0x0ccf0297,0x9f7a0013}},	//   _onome_, _monoloca, _baksañ_, _динларин, 
   {{0x427f0526,0x8da600be,0x0d5c0132,0x93f800a0}},	// [1600] _tuanya_, _بالاڭدى_, _مجسمے_, _alluna_, 
   {{0x216c03b2,0xc38605bf,0x46a6038d,0x52ed0034}},	//   _activity_, _dieru_, _kontinny, _tilgangi_, 
   {{0xca4f0072,0x4b67003e,0x92fa02e7,0xd148006d}},	//   _warmirus, _хашеме_, _ipahawa_, _ажыўляць_, 
   {{0xc9ee002a,0xde540140,0x9cf003ae,0x00000000}},	//   _itunanya_, _kasamaha, _mastergr, --, 
   {{0x02910240,0xb27e04d0,0x024800c3,0xb3ae0089}},	//   _tagane_, _vaeng_, _animos_, _şaxmat_, 
   {{0xccf10119,0x76390088,0xa28000e0,0x0aea024a}},	//   _hartberg_, _саналары, _neakene_, _omoleyin_, 
   {{0x527e0317,0xfd840086,0x32ef018a,0xfe4d040f}},	//   _tamno_, _kereslet_, _cryfa_, _lagamina, 
   {{0x2adb01bd,0x2125053f,0xa27402c2,0x83410452}},	//   _колледжі, _puriyaña, _versamel, _raperda_, 
   {{0x62cd03eb,0xf02300ff,0x132200f1,0xc1fd0310}},	//   _stelsel_, _באקטעריע_, _rasyal_, _chladach_, 
   {{0x933d01ec,0xa27e0037,0xe68c010d,0x9825034c}},	//   _ویوان_, _camne_, _भिकार_, _europağa_, 
   {{0xdfea015d,0xef080274,0x2227017a,0x22120107}},	//   _विभागों_, _snúast_, _васияти_, _amaha_, 
   {{0x8b7d05e2,0x89090145,0xff7000be,0x23010225}},	//   _atención_, _лекара_, _ايروپىلا, _maranuw_, 
   {{0xa37303d7,0x3e4202f4,0xebb10011,0xb27f030f}},	//   _dimande_, _embaraza, _atukubir, _muanga_, 
   {{0xce1702da,0x36b7016d,0xf38600ac,0x00000000}},	//   _значи_, _иһсаноғл, _samrti_, --, 
   {{0xbc09015e,0x12d801f7,0x62010125,0x927e0053}},	//   _либералд, _ancorat_, _beyik_, _taeng_, 
   {{0x2274026f,0xe62802aa,0x130900cb,0x00000000}},	//   _قوسلۋ_, _netušili_, _махмадса, --, 
   {{0x6e02011e,0x826402e7,0x214702ba,0x92900564}},	// [1610] _anzenera, _daplin_, _қадимаи_, _yunaf_, 
   {{0x4dc4018b,0x425a03c0,0xf39501fc,0xc92b01c3}},	//   _ultimele_, _samlet_, _caasna_, _discolou, 
   {{0xb2d802d0,0xf24800b5,0xb3500272,0xd38602c9}},	//   _skinned_, _anome_, _abatutum, _fiert_, 
   {{0x07be0192,0x304c02a4,0xe23702d3,0x620e0052}},	//   _토지문학공원_, _moduslin, _британиј, _penziony_, 
   {{0x5ddf00f3,0xacdf03db,0x51b301a7,0xb27e0317}},	//   _abakhule_, _abakhulu_, _голове_, _tamne_, 
   {{0xfa100119,0xf386047d,0x984b018d,0xb63901b8}},	//   _calabria_, _hiert_, _ውሕሉልን_, _जमाएकेँ_, 
   {{0x035f006c,0xc29101f0,0xe2120318,0x13a901ac}},	//   _bangase_, _bagale_, _emahi_, _أزهار_, 
   {{0xc26e0318,0x0ae202ef,0x599a0089,0x00000000}},	//   _aitoli_, _chalatan_, _аптырады_, --, 
   {{0x4c21031d,0x727e04d0,0x003f0321,0x322400f4}},	//   _drapery_, _ngenx_, _testenin, _dinkeg_, 
   {{0x0291018e,0xa41e005e,0x7ddd0060,0x1e520006}},	//   _adyaha_, _принсипи_, _қайтарып_, _menaikka, 
   {{0xadb70050,0x4d3601a3,0xa9db02db,0x338703a4}},	//   _blogsome_, _مفھوم_, _oganaesa_, _alarin_, 
   {{0x8e5505c7,0xf2e9016e,0x7d9b0218,0x43070277}},	//   _bigamije_, _pornosu_, _acancyva, _bombang_, 
   {{0x4a9a015a,0xc307050b,0xcbf60251,0xac33038a}},	//   _amantiis, _jombang_, _billaabo_, _educakuc, 
   {{0xe0d50238,0xf81900b5,0x6201019b,0x82240116}},	//   _журналу_, _ахабар_, _sveika_, _lookit_, 
   {{0x3383011e,0x72bb00c5,0x93f80631,0xa47c032d}},	//   _dinyite_, _demeure_, _skjule_, _enyeholo_, 
   {{0x88830272,0xbc190521,0x5db80046,0x1979036b}},	//   _abakunuu, _komunë_, _فۇتبولدۇ, _концесии_, 
   {{0x65290077,0xf477035b,0x162901b4,0x5d1a02ea}},	// [1620] _definisy, _obstajaj, _definisi, _repliche_, 
   {{0xbc9a01ef,0x625a03f3,0x237f0193,0x00000000}},	//   _абслугоў, _erelid_, _bolanya_, --, 
   {{0x03330632,0x81b30107,0xec150239,0x03cf0436}},	//   _अशाप्रका, _حاضرم_, _koropupu_, _zrtve_, 
   {{0x4f5b040b,0xabd1044b,0x1b820173,0x047e00a9}},	//   _balangan, _kundeser, _আপাতত_, _afatanij, 
   {{0x039500b0,0xbfb7048e,0x948600b9,0xe51103f8}},	//   _taasna_, _ventürs_, _तुतारी_, _masoptah, 
   {{0x557e02e5,0x41bc0185,0xd06100dc,0x00000000}},	//   _violació, _beterelä_, _sausauin, --, 
   {{0x5c0300bc,0x9db4020f,0x8e92004d,0x00000000}},	//   _rampung_, _غوڅوی_, _權利金每日最大漲, --, 
   {{0x123702c1,0x6c0302f6,0x80ef00d9,0x662802aa}},	//   _akimara_, _sampung_, _inhimill, _netušila_, 
   {{0x1335053f,0xd44a0192,0x5fff0092,0x7b6800a0}},	//   _cusconx_, _prijzenk, _pakkesho, _betuliya_, 
   {{0x002d028b,0xfb2e002e,0x6ab7028d,0xbc0b0008}},	//   _кристиан_, _dijagnos, _cinkapas, _despesa_, 
   {{0xb7f70148,0xcd11014f,0x0f910014,0x38c60315}},	//   _學生學習與產業連, _осталог_, _prodhuar_, _basetind, 
   {{0x1beb00db,0x3a9a001b,0x2cf40102,0x43860364}},	//   _मद्रासी_, _amansiis, _اثناعشري_, _tierm_, 
   {{0xbeb6005a,0xbcf000d3,0x337200d9,0xcdbd0139}},	//   _maruchbe_, _svetandr, _seksikum, _dinakare_, 
   {{0x7223019b,0x3f5401c8,0x02ec034c,0xa24a00c1}},	//   _любога_, _režimy_, _алпар_, _murmer_, 
   {{0x2aa30082,0x9de000dc,0x739403c6,0x029000af}},	//   _bankunan_, _melkonia, _haisma_, _bunad_, 
   {{0x86b202bb,0x220104e3,0xf2e9014b,0x00000000}},	//   _खस्ता_, _razinu_, _kirissa_, --, 
   {{0x5a8102ac,0xa3870339,0x5c6801eb,0xf96f0515}},	// [1630] _اليرموك_, _jiure_, _curuñi_, _reinfort, 
   {{0x6c670415,0x6d93013f,0x9b4d0074,0x961d0170}},	//   _betreff_, _dastumad_, _прогнозы_, _chingati, 
   {{0x153a00c7,0xbcd6020a,0x3ec20183,0x29110016}},	//   _stantsiy, _патшаға_, _dranaman, _antaŭjuĝ, 
   {{0xb725037e,0xadbb02d8,0x36d600de,0x8993005b}},	//   _pyntriem_, _kemitraa, _ناممکنه_, _bmwkasut, 
   {{0x6adf02c2,0xbc0500aa,0x639400f2,0xc9a10128}},	//   _reddings, _bentilas, _gaisma_, _masjidda_, 
   {{0xb2020633,0xa8a50019,0x00000000,0x00000000}},	//   _thrift_, _дубалга_, --, --, 
   {{0x9aa30082,0x45d70405,0xa2f8020f,0x00000000}},	//   _yankunan_, _нарешті_, _وګرځېد_, --, 
   {{0xb3870339,0x6bec019d,0xa2d801f1,0x8a8900ff}},	//   _kiure_, _aphethir, _ankesa_, _demision_, 
   {{0x33fa03cf,0x75330193,0xcb9c012a,0x937c0004}},	//   _kurumu_, _seenakny, _kontrolę_, _devaste_, 
   {{0x127e012c,0xa7530634,0x62cc01ec,0x78890035}},	//   _namna_, _grunnlag, _مهارتهای_, _заманала, 
   {{0x4b730261,0x96aa006d,0x532b0109,0xaed100c5}},	//   _komunuma_, _корпусам_, _गाँउले_, _positifs_, 
   {{0x3c2a060c,0x8d7b0397,0x00000000,0x00000000}},	//   _bicyklov_, _ayiminya, --, --, 
   {{0xab5100cf,0xe27e0365,0xb2d80040,0x47b300b5}},	//   _daimlerc, _kamna_, _פלייבקים_, _aposenti, 
   {{0x788b01aa,0xc52e01b3,0xfa5502ed,0x00000000}},	//   _aughterd, _мінздоро, _carcacía_, --, 
   {{0x5b5c0244,0xc9df00dd,0xe2ec031a,0x6b9701f4}},	//   _публично_, _addurned, _frainge_, _даракчи_, 
   {{0xbb0b0008,0xf4c80064,0xc9fb027f,0x5e4f0119}},	//   _resposte, _абаны_, _karatere, _nakatala, 
   {{0xa3fa01fe,0xd37900a7,0xba15005b,0x8b87002b}},	// [1640] _burumu_, _paraula_, _yamanaka_, _চাটতে_, 
   {{0xf27f00b0,0x17d000bb,0x5b9c0096,0xa1af0128}},	//   _uguna_, _گاہکوں_, _abazayob, _иденти_, 
   {{0x5488029c,0x733300e6,0xe4270294,0xd13c021c}},	//   _amaganiz, _未经授权禁止复制, _causakun_, _neplatné_, 
   {{0x1ab20532,0xa1e8010d,0x8533008b,0x2be700f2}},	//   _stavljat, _सन्माननी, _fésaloon_, _laulāto_, 
   {{0xc5e50148,0x73ea01bf,0xa27c011d,0xf37b023e}},	//   _趕快來加入我們一, _lukter_, _revistei_, _dedegé_, 
   {{0xd27e02d4,0x07f600ec,0x77de0109,0xfdad0207}},	//   _jamna_, _зрэшты_, _चालकलाई_, _kingunge_, 
   {{0x799d0060,0xf2a701ce,0xc056017d,0xa7fa01d1}},	//   _санын_, _nyebar_, _betragtn, _respectf, 
   {{0xf7490635,0xf2d90153,0x7fb30203,0x1c62008e}},	//   _венеры_, _øjnene_, _mollusco, _jaarale_, 
   {{0x727f0191,0xfea8018d,0xadaf011f,0x8bc600c7}},	//   _stanna_, _ዘይንፈልጦ_, _arenisca, _кузьмины, 
   {{0x423b017d,0xa610004d,0x83870097,0xf98c00ed}},	//   _cykling_, _acceptam_, _inura_, _ihahanda_, 
   {{0x61580397,0x42e60002,0x12ea0007,0xa2c70258}},	//   _бармегар, _stanova_, _bayindo_, _earlike_, 
   {{0x02000020,0xd65101b7,0x02c20092,0x908a01ac}},	//   _agaia_, _समाधौ_, _をブラウズする_, _معروفه_, 
   {{0xd0f300ff,0x41e6032c,0xc2010126,0x4fe60037}},	//   _פאָון_, _ameralik_, _steira_, _ፈላስፎች_, 
   {{0x4eb30244,0x63f801d2,0x62a7012b,0x73fa01e5}},	//   _potrebbe_, _alluka_, _torby_, _buruju_, 
   {{0x0386022c,0xa1df0636,0x1c030153,0x00000000}},	//   _damri_, _popravak_, _korsør_, --, 
   {{0xa1f10047,0x937b005a,0xee66027b,0xe38702eb}},	//   _订阅该问题_, _biradmo_, _संस्कृतश, _onura_, 
   {{0x560d0014,0x281c0052,0x0afc00d1,0x129000fe}},	// [1650] _ዘይተኣደነ_, _एक्स्पोज, _নিয়মত_, _lomaki_, 
   {{0x304501aa,0x76980276,0x70b60012,0x5a2d02ac}},	//   _overnmen, _турмушни, _सिहुला_, _للجدل_, 
   {{0xa8b70181,0x099d00ec,0xaaa30258,0x57e70053}},	//   _vestager_, _набыў_, _folkerts, _देवराई_, 
   {{0xb2910036,0x63860304,0x1dae02fe,0xb8470013}},	//   _sagart_, _zamri_, _اسمبلې_, _набавий_, 
   {{0x7394028a,0xd35d0595,0x6d3a0278,0x232400ff}},	//   _maisha_, _पल्लव_, _fadhilat_, _morgaŭ_, 
   {{0xb2f5032e,0x8f700125,0xb3fa0279,0x5eb100e0}},	//   _walinak_, _biçak_, _parure_, _sternsee_, 
   {{0x3acb0037,0x07e20074,0xb2c4048e,0xac96004d}},	//   _ቪዲዮዎች_, _kaupalli, _milmets_, _近月契約為_, 
   {{0x52480295,0xc0670282,0x32c60151,0x00000000}},	//   _foomu_, _takaokeo, _bowline_, --, 
   {{0xdd410044,0x42b10158,0xeafa003a,0xc9f50193}},	//   _רכשתי_, _जटिलताओं_, _tafsilot, _परिश्रमा, 
   {{0x551600b0,0xc2b40269,0x89680165,0x7a850090}},	//   _siilaany, _cancha_, _melikise, _asingamb, 
   {{0xdc530582,0xc2cb0437,0xb31b01b2,0xc394003d}},	//   _erutala_, _bredde_, _bancagh_, _baisha_, 
   {{0x3d2c01b8,0x36a90415,0xedd300e2,0x352c0166}},	//   _ravimite_, _herrlich, _boekebea, _legendär, 
   {{0xf3bb0622,0x00b202ac,0x72240347,0x92c5004b}},	//   _bakwega_, _واغفر_, _blokke_, _fehlile_, 
   {{0x526d005a,0xd94f036f,0x24860052,0x452703b7}},	//   _bitoy_, _razlicit, _बुहारी_, _affinity, 
   {{0xf2cb00e0,0x9ff10029,0x83fa018e,0xc67f037c}},	//   _tredde_, _کۆچبه_, _buruku_, _quadragi, 
   {{0xead201e7,0xe7f700c4,0x62b902ef,0x00000000}},	//   _bildauss, _رنڊڪون_, _fondtah_, --, 
   {{0x50700387,0x93940211,0x7b610061,0x00000000}},	// [1660] _ensaiklo, _naisia_, _한국광학회_, --, 
   {{0x0c8205f6,0x1c260158,0xd73004dc,0x52ce010d}},	//   _inneheld_, _ब्यौरा_, _بیزانین_, _diklaim_, 
   {{0x7c67013a,0xaaed0193,0x82f100e0,0xf85001eb}},	//   _getraff_, _cileungs, _delslach_, _mazurcas_, 
   {{0x4e8304ee,0x60960040,0xc1c9041a,0xdd8d0268}},	//   _abawanye_, _בשלושה_, _пошти_, _adfordra, 
   {{0x4d160098,0x827e028d,0x2edb002b,0x0ccc004b}},	//   _venligst_, _laenn_, _স্পেনীয়_, _миссияһы_, 
   {{0x7b700637,0x10f60427,0x2c6703e6,0x3a440213}},	//   _kwirinda_, _maligaul, _betraff_, _алатырь_, 
   {{0x449f002b,0xa27a00fe,0x4e5a022d,0x738601d3}},	//   _সাপ্লাই_, _kaniseli_, _adopranu_, _tierp_, 
   {{0xf202003b,0x627e03f6,0xf38b03f1,0x00000000}},	//   _akakuvum, _waena_, _súrne_, --, 
   {{0x43960527,0x927e012c,0x3d8d019b,0xcc7d004f}},	//   _turski_, _iringa_, _normalia, _diissoo_, 
   {{0xdf2403ff,0x727f00a4,0x020d023b,0x78cc026d}},	//   _avšak_, _guanya_, _inehinei_, _šarapovo, 
   {{0xc8950272,0x89a40190,0x896b00b5,0xfc44010b}},	//   _abakyabu, _kankania_, _aremivév, _digwaga_, 
   {{0x7d8702ac,0x25270244,0x56a200a6,0xf3b900af}},	//   _لازالة_, _maurizio_, _amatshey, _sievert_, 
   {{0x3a9102f0,0x62900261,0xa3f802a6,0x90420311}},	//   _beyibamb, _aneksis_, _andura_, _ብዝረኸብዎ_, 
   {{0x82780101,0x6e7a0397,0x6257014a,0x95fb01eb}},	//   _atunci_, _синдурак, _válni_, _jererekó, 
   {{0x427f051a,0xd03101a4,0xe9ee0188,0x8f690005}},	//   _duanya_, _contuien, _далелхои_, _attachas_, 
   {{0x63aa0402,0x20d301e1,0x3d3a0139,0xf41d01d5}},	//   _terasing_, _власы_, _acchinat_, _واہگہ_, 
   {{0x9c650638,0xeea5042e,0x2fca00c8,0x427e01d9}},	// [1670] _slettet_, _fokusere_, _дивизияһ, _haenn_, 
   {{0xaa83006c,0xa2000018,0x00000000,0x00000000}},	//   _abazonge, _lumisa_, --, --, 
   {{0x95d30169,0x5c9600ec,0xee3a0238,0xeb9a0156}},	//   _বিনিময়ে_, _мальты_, _опозиції_, _admiralo_, 
   {{0x0cfc02fe,0x82490031,0xa14600a7,0x92cd0487}},	//   _اقتصادي_, _nyampe_, _escripto, _ongoing_, 
   {{0x31b90056,0xa323056e,0xa27f02a0,0xc5e200c1}},	//   _дермонӣ_, _décimo_, _itanka_, _रहाण्यास, 
   {{0x985d021a,0x4ee901cd,0xb249034e,0x7db6005e}},	//   _amanamtu, _зулқарна, _ayampe_, _گۈرۈچ_, 
   {{0x472d024e,0xdc8401d2,0xada90203,0x425102a5}},	//   _uostalom_, _apallarq, _debilisa, _skladové_, 
   {{0xbe860059,0xcb7b00ad,0xa27f0116,0x1a870088}},	//   _трафик_, _nungguan_, _leanin_, _бурулчан, 
   {{0xa9fa0100,0x63680093,0x00000000,0x00000000}},	//   _skrivena_, _кхерам_, --, --, 
   {{0x92e602f4,0x786301a7,0x00000000,0x00000000}},	//   _plantea_, _кодами_, --, --, 
   {{0x1d38018d,0xf248052e,0x4200018e,0xcfef0297}},	//   _ትሕዝትኡ_, _gnomo_, _fumisa_, _абзарына_, 
   {{0xd7dd04bf,0x11040035,0x827f0138,0x6e670022}},	//   _odražava, _artırga_, _oranda_, _саммиты_, 
   {{0x52ab02c3,0xfc750044,0x32ad0475,0x13790418}},	//   _káble_, _arising_, _граффити_, _parayla_, 
   {{0xdf970410,0xa1ac00be,0x127f0288,0xd5cb03e4}},	//   _ditheriš, _ايعىرى_, _eranga_, _sumaptay, 
   {{0x8a6c003a,0xb27f034e,0xe27f0148,0xc7e901f4}},	//   _россияда, _asanta_, _agunt_, _кўкалдош_, 
   {{0x384c0192,0x1a5500e6,0xb09d0213,0xbc2f03b6}},	//   _알았습니다_, _中国农业发展银行_, _новостну, _isopọ_, 
   {{0x0d850639,0x1fe800c1,0x612f02b6,0x336d02e7}},	// [1680] _permulaa, _थोडाफार_, _амалсыз_, _halumigm, 
   {{0x6364005e,0x253e010f,0x98600109,0x9d9e030f}},	//   _ئۈجمە_, _милисаҳо_, _बानेश्वर_, _pekepeke_, 
   {{0x5290063a,0xe27c008e,0x6112026f,0x584c0217}},	//   _munan_, _yëngu_, _اۋلداستا, _statutos_, 
   {{0xe68f0179,0xbc740523,0x693a0291,0xc3870319}},	//   _lezenodi, _होल्डर_, _معطيات_, _piura_, 
   {{0xd6140238,0x25080285,0x29480179,0x55070039}},	//   _складаєт, _agatsiko_, _seglofot, _хардаад_, 
   {{0x227f0390,0x330e0277,0xc3870387,0x4b4000d0}},	//   _iranda_, _heralds_, _inuru_, _шэрон_, 
   {{0x5cef003a,0x320003d5,0x2eb903c6,0xfdbd028b}},	//   _مسئوللری, _agaid_, _deromhin, _hetereív, 
   {{0x8c6e018a,0xb38d0465,0x71e601c9,0xaae00065}},	//   _meirion_, _časovni_, _गुलरी_, _geltende, 
   {{0x3290063b,0xc480012a,0x3602020a,0xdd2c0156}},	//   _kunan_, _सेनाओं_, _جولاۋشىل, _מפֿקיר_, 
   {{0x321200d6,0xda9801ba,0x22900074,0xc4970061}},	//   _zmahh_, _dezinves, _junan_, _그린페스티벌은_, 
   {{0xc290023d,0xc27f01da,0xa2f20388,0xc35b027e}},	//   _domani_, _pranga_, _скрап_, _kengura_, 
   {{0xc155042a,0xb9870420,0x63160222,0x226e0145}},	//   _basemapl, _приемен_, _sunnking_, _patogi_, 
   {{0xfc55001d,0x18750105,0x527e0048,0x8abd0208}},	//   _gemtime_, _धनकुबेरो, _asinza_, _ویندا_, 
   {{0x6290017e,0x2301028f,0x00000000,0x00000000}},	//   _nunan_, _taranui_, --, --, 
   {{0x82d80079,0x72f5045e,0x0c8801cd,0x4c5a0243}},	//   _hokeja_, _туризъм_, _мундариҷ, _baatili_, 
   {{0xdd9d014a,0x447a00e6,0x25f10038,0xc5ae0506}},	//   _receptje_, _中国文学艺术界联, _дәвләт_, _eggstokk, 
   {{0x7b5b016d,0x9e3c00d1,0xc6c4004c,0x63a102ff}},	// [1690] _ھەرۋاقىت_, _গ্ৰামীণ_, _bawaanyi, _paspouki_, 
   {{0x0fb400d9,0xb5ad019e,0x15b90059,0x727f02ac}},	//   _платье_, _арабская_, _нормална_, _buanna_, 
   {{0xc27e0006,0x06cf0244,0x1a4501db,0x79c70013}},	//   _isinya_, _изнасилв, _شعارۇلار, _пакана_, 
   {{0x1b23014f,0xff370187,0xd4e80178,0x127f0110}},	//   _простору_, _анкетата_, _amarṣī_, _uguns_, 
   {{0xf69700a6,0x74ad0037,0x00000000,0x00000000}},	//   _بدنامه_, _ፓንክረስት_, --, --, 
   {{0xeecd006f,0x62000528,0xae460220,0xe30e010d}},	//   _wasilian, _agiis_, _агенцият, _seratus_, 
   {{0xb30e0429,0xa3fe04bd,0xd16303c1,0x34b50059}},	//   _peratus_, _kumukahi_, _позира_, _страхоте, 
   {{0x377f016d,0x103e0272,0x95440060,0xe3700061}},	//   _ئەگرى_, _abatasin, _بىلەسىز_, _윗몸일으키기_, 
   {{0x01470368,0xc3bc01ee,0x27d00095,0x00000000}},	//   _забирай_, _губернии_, _بیلبورد_, --, 
   {{0xdf550276,0xdc4b0305,0xe27f01fa,0xa33d04dc}},	//   _турмуши_, _statleg_, _huanoa_, _دیبان_, 
   {{0x6a950053,0x257701a3,0x6b9c00f2,0xe2d60138}},	//   _स्वीकारल, _جهڙائي_, _kontrolē_, _motorun_, 
   {{0xa65802e8,0xde4f036c,0x63870054,0x00000000}},	//   _anokwani, _ampandoa, _izarsa_, --, 
   {{0x5ae602f1,0x0e9504f9,0x2721029e,0xdf5b0239}},	//   _estudant, _naammann, _arallrev, _mamaetan, 
   {{0xd2d8026a,0xfb5b00a8,0x42010318,0xd29801d9}},	//   _dikeva_, _defuncta_, _iteita_, _chancë_, 
   {{0x55770036,0x6b390135,0xc27f01e6,0x72da0450}},	//   _indinéis, _проектла, _sranda_, _auwerk_, 
   {{0xa75400d1,0x33860079,0x83860111,0x826f01d2}},	//   _অধ্যাপনা_, _miers_, _pieru_, _bilisipi_, 
   {{0x88fb0326,0xd9fb0326,0xc202001e,0xb3860347}},	// [16a0] _achanyad, _achanyat, _jaridu_, _eiers_, 
   {{0x6e430285,0xc38703c7,0xc3940321,0xfd49023c}},	//   _ambasade_, _biuro_, _obiska_, _همغږۍ_, 
   {{0x6c58053f,0x7ff10287,0x3ff30444,0xac60011b}},	//   _partejj_, _सिल्भीको_, _мельнико, _kafumba_, 
   {{0x6c090071,0xb2900456,0xa26c0487,0x32e1004f}},	//   _سوزاندن_, _arnab_, _venous_, _mbindum_, 
   {{0x434702ad,0x86430195,0xc2900018,0x43a7004a}},	//   _panenka_, _creidmhi, _tomani_, _балигъ_, 
   {{0xee5a0074,0xd89602cf,0x00000000,0x00000000}},	//   _варианто, _таксито_, --, --, 
   {{0xa2bf0265,0x697c0135,0x72d904e7,0x69ee01d2}},	//   _ramdisk_, _форумыны, _bojnice_, _ashishqa_, 
   {{0x5f3902d4,0xc24903af,0xa2a600b6,0x72fe0455}},	//   _actualma, _champs_, _gabbi_, _cerises_, 
   {{0x07f60036,0xcc2700d5,0xb99500ba,0xc4f80060}},	//   _تعبّر_, _fanatitr, _رووخا_, _جازالاسى, 
   {{0xbec9007b,0x9dca0066,0xa3ea007b,0x86b10093}},	//   _spindles_, _бичүүлэх, _baited_, _ивановна_, 
   {{0x8ae501cf,0x4951001c,0x538702eb,0xca5e0224}},	//   _claudent, _bayolent, _izarra_, _aftengja_, 
   {{0xf8c400bf,0xbd950240,0x8e35001e,0x738603da}},	//   _перевозк, _kailaaaa, _jarabawa, _ohere_, 
   {{0x825b015d,0xf239038a,0x72a603f0,0x00000000}},	//   _mialem_, _formapi_, _dabbi_, --, 
   {{0x0eb20191,0x25bb003f,0x6dd001b3,0x23890350}},	//   _leverans_, _daladtah, _острову_, _የአባቴን_, 
   {{0xc9fc003b,0xee96001d,0xa2d5011b,0xe27e0187}},	//   _buyakwat, _subtenet_, _motonda_, _brinca_, 
   {{0xffdd02b6,0xbdb80005,0xe95a009a,0x7f5304c8}},	//   _талабына_, _vinavant_, _ekulwele, _bengħisa_, 
   {{0xd3860116,0x327e026c,0x00000000,0x00000000}},	// [16b0] _wiers_, _paene_, --, --, 
   {{0x46ab02ec,0xabf601c5,0xcd86020e,0x00f6014a}},	//   _آفتابٕچ_, _tallaabo_, _шарындағ, _سٹیفن_, 
   {{0xe27f0194,0x027e022e,0x12ca00af,0xc3a90343}},	//   _franca_, _trinca_, _hunder_, _gitambag_, 
   {{0x98b30343,0x11630125,0x62a600cf,0xf27e013d}},	//   _diktador_, _сучун_, _cabbi_, _abonas_, 
   {{0xb3c40143,0x9d6c0381,0x82d5011b,0xab8901d2}},	//   _старозаг, _animalwa, _kotonda_, _hemicirc, 
   {{0xc2e300df,0x13860129,0xd5d80164,0x3af0025b}},	//   _famille_, _ihere_, _мәңгү_, _lærisvei, 
   {{0xf202011d,0x081601e0,0xf2d8059e,0x8290019d}},	//   _rutier_, _ئاندریا_, _etheni_, _bomali_, 
   {{0xc386008c,0x12130047,0x83ec03f1,0x26b7013a}},	//   _viers_, _poches_, _schodisk, _aussiich, 
   {{0xa38604ee,0x62fe02f3,0x79110071,0xd9ab00e6}},	//   _chere_, _berget_, _پیازچه_, _méditati, 
   {{0x4ea30101,0x527f033a,0x68ed0162,0xc7d202bd}},	//   _suplimen, _franza_, _болалайд, _aberteif, 
   {{0xd386005b,0xaa1e00c7,0xc4e50291,0x78c502dc}},	//   _iherb_, _диния_, _أوضحت_, _potestad, 
   {{0xa3f80353,0x0c0400a2,0xd9fa0003,0x00000000}},	//   _tomuto_, _hamsini_, _totstand, --, 
   {{0x8248001f,0x93860079,0xdef802e4,0x9c7500a8}},	//   _nnoma_, _siers_, _drawwiet_, _arquint_, 
   {{0x30fb063c,0x5388028b,0x2f2e020e,0x8ede030b}},	//   _उच्चाधिक, _bueycha_, _кисле_, _amuyambe_, 
   {{0x860b029a,0x32d5035b,0x12d901f7,0x296c022e}},	//   _rekonsti, _vrhovno_, _ancoras_, _affissat, 
   {{0xfb11063d,0x00000000,0x00000000,0x00000000}},	//   _klageins, --, --, --, 
   {{0xbe62014e,0xdd350277,0xb2910016,0x31020158}},	// [16c0] _регистру, _barnhart_, _debato_, _kulturą_, 
   {{0xb2610533,0xd177022c,0x11f500cb,0x3b5103b5}},	//   _cíosa_, _cihampel, _курона_, _rindukan_, 
   {{0xf38603b2,0xeb5a0041,0xec70063e,0x85ff0449}},	//   _where_, _аҩынтәтә, _uporabu_, _grmljavi, 
   {{0xd381019d,0xc06501e8,0xe57f004c,0x0ca900e6}},	//   _adayang_, _bilanggo, _alutagiz, _临沧就业论坛_, 
   {{0x94710485,0xd27802c1,0x96d60071,0xc3070057}},	//   _storebæl, _utundi_, _زايمان_, _lombong_, 
   {{0xdd90031a,0x95b10192,0x127f00b4,0x62ca03ae}},	//   _seallada, _제주특별자치도_, _branza_, _ryddig_, 
   {{0x8a0b00c8,0x4d9a0302,0xa71e0205,0x00000000}},	//   _baratuoa_, _абхозист, _оролбўйи_, --, 
   {{0x4d3a010b,0x6fe8004d,0x37a90299,0x126e011b}},	//   _boripane_, _密切觀察疫情進展_, _بوھتان_, _matoyi_, 
   {{0x9b13018b,0xa5cb028b,0xc3160059,0x03df049e}},	//   _антиромы, _астратег, _inizia_, _pátranie_, 
   {{0xbb7f02ce,0x4b2c03a1,0x94b500ee,0x42f50301}},	//   _ngaranna_, _количкат, _probintz, _treninq_, 
   {{0xd27e0160,0xe285040b,0x4c6e0028,0x829100ed}},	//   _radnih_, _mushumo_, _geerida_, _bagahe_, 
   {{0xeda401df,0x128e023b,0xfcb70205,0x93a20424}},	//   _insulted_, _diakono_, _قالدیق_, _cumpar_, 
   {{0xa27e0369,0xd386002a,0x88b9021b,0x53aa0347}},	//   _kaena_, _uhere_, _заставил, _berading_, 
   {{0xabb90037,0x1a23032d,0x13b402ac,0x23870046}},	//   _የገረመኝ_, _почетлы_, _منهارة_, _riure_, 
   {{0x127e0211,0x587901de,0xa38704ca,0xc317005b}},	//   _kuinka_, _بادىزدەگ, _quercy_, _tsubaki_, 
   {{0x9b700233,0xab96052c,0x551700b7,0xc7fc01a7}},	//   _illumina_, _عوبێد_, _ваклады_, _блоге_, 
   {{0x82610063,0xf31d005b,0xbec60119,0xdc92021c}},	// [16d0] _píosa_, _akachan_, _kasirign, _modelkou_, 
   {{0x8a990287,0xaf29014b,0x0bc60137,0x1ae00218}},	//   _situací_, _kaltamma, _лийртэй_, _attempts, 
   {{0x6de900e4,0x8eaa00e6,0x62d804b4,0x73950015}},	//   _आयुष्मान_, _大兴求真务实之风_, _skiene_, _naaska_, 
   {{0x727f0292,0x3e4f02f6,0x4c200396,0x6d9e01b5}},	//   _afanan_, _makasala, _appostlu_, _kekereke_, 
   {{0xf2a70128,0x727801e5,0xfd3e0024,0xcfa90297}},	//   _балога_, _atunbi_, _skrivast_, _арбитрла, 
   {{0xd99503db,0xd3660281,0xf236002e,0x127f0264}},	//   _abahlala_, _flugten_, _brojni_, _huanca_, 
   {{0xdf4b0025,0x9f5c02cd,0x526e009d,0x1f650033}},	//   _asipatra, _albarkan, _patozi_, _apparain, 
   {{0x88fb04ec,0x22a60241,0xb9830204,0x00000000}},	//   _caraseru, _cabbu_, _linkitet, --, 
   {{0xf533056d,0x945e0089,0x527e0121,0x00000000}},	//   _efunekay, _даниядән_, _faena_, --, 
   {{0xd26401b9,0xba790089,0xf3860176,0x00000000}},	//   _boulle_, _farazlap_, _gaeri_, --, 
   {{0xa9e700da,0x4f2d003d,0x9fc30437,0x5e730287}},	//   _матернэ_, _rosellin, _bilister_, _यसर्थ_, 
   {{0x3365013d,0xd8990037,0xc5040322,0x43790407}},	//   _komentoj, _አሸንፈው_, _ahamagay, _ostatka_, 
   {{0x6c0503f0,0x5a730041,0xfdb40144,0x634701f4}},	//   _forseti_, _aguĩva_, _لوجود_, _شاگرددن_, 
   {{0x73b00119,0x2a390444,0x66320315,0x12130195}},	//   _treviso_, _решении_, _aphindzi, _dochas_, 
   {{0x283e0037,0xa24800c3,0xa5dc0392,0xc0720453}},	//   _የደኅንነት_, _animis_, _bracadal_, _bugarsko, 
   {{0x43860382,0xa284013b,0xcb0b015e,0x027e0097}},	//   _acores_, _alghero_, _стилди_, _irinna_, 
   {{0xdd4e005a,0x427f01c2,0x3dca0291,0xb59400de}},	// [16e0] _dibahqoq, _granxa_, _شكشوك_, _babenoph, 
   {{0x1e0002b0,0xf2df045f,0x7a0c0096,0x927e0155}},	//   _gemeinsa, _ledning_, _abashimu, _brinna_, 
   {{0xe0e50178,0x37c50059,0x92e10092,0xac670227}},	//   _विभीषण_, _страдани, _sprintf_, _bulunya_, 
   {{0x62c20387,0x89750092,0x6a05019f,0xa2df03f8}},	//   _epelata_, _楽天ブログ_, _jambonet, _masotqu_, 
   {{0x626e046d,0xb533034f,0xec0502aa,0x154703d4}},	//   _matoni_, _afunekay, _dobroty_, _uračunat, 
   {{0xc1420211,0xfbe5038b,0xf50802ac,0x17350259}},	//   _утрам_, _dipengar, _هناااااا, _bellemag, 
   {{0xdcb40440,0xa20002a7,0x13f8025f,0x370701ee}},	//   _ndayakir, _ngain_, _koluka_, _кампани_, 
   {{0x95c604b6,0xf0bc02ec,0xbe530040,0xcb78004f}},	//   _abepisik, _کاسہِ_, _סטרטר_, _jingéen_, 
   {{0xd3fa0223,0x72920216,0x832403f8,0xa03801a9}},	//   _lotura_, _eswaku_, _huschoh_, _sugerimo, 
   {{0x527e0550,0x48990037,0x60ee013f,0xe9bf001a}},	//   _hymno_, _የሚከፈል_, _bouzello, _emlegete, 
   {{0x238603a6,0x99df0162,0x426e0165,0x1c1b000a}},	//   _mbere_, _سەندە_, _katoni_, _ammariar, 
   {{0x3860063f,0x23f401a6,0x5bfc003d,0x00000000}},	//   _बालेश्वर_, _rautao_, _congombr, --, 
   {{0x438603da,0xe2d8003e,0x750d001c,0x2919013a}},	//   _obere_, _lokela_, _rebolusy, _blackand, 
   {{0xbbaa02ec,0x9387005b,0x3ced0092,0xe7b503a4}},	//   _پروازس_, _miura_, _代表取締役_, _danskari, 
   {{0xaaab0026,0x42490292,0xf20100e3,0xec060203}},	//   _비밀번호를_, _ayamye_, _baziku_, _preskau_, 
   {{0x39f803dc,0xf290046b,0x00000000,0x00000000}},	//   _kristind, _arnaf_, --, --, 
   {{0x29f401d2,0x338702d4,0x34920145,0x37ef016d}},	// [16f0] _allín_, _giura_, _нейтрона, _пәстә_, 
   {{0x2324003f,0xcfdc0198,0x00000000,0x00000000}},	//   _buschoh_, _milijono, --, --, 
   {{0x2c77025c,0xf39504d8,0xa3450371,0x00000000}},	//   _falsche_, _yaasha_, _coperte_, --, 
   {{0x32350287,0x9aa40242,0x938604ee,0x5c5501ec}},	//   _olomouc_, _tikintis, _ebere_, _bentuke_, 
   {{0x32920087,0x4e650148,0x11dd0444,0x42e80403}},	//   _aswaku_, _只限在學生_, _прислали_, _hodiana_, 
   {{0xe8610092,0x0387020b,0x82d80022,0xcf1c00e7}},	//   _と思いました_, _diura_, _fokela_, _arguedwa, 
   {{0xb27f00a1,0x41c702fe,0xca090177,0x03710211}},	//   _oranga_, _داستاني_, _аиҕьтәра, _allekirj, 
   {{0xc3ee01ec,0xb20000a1,0x5a7703a2,0x18f5002b}},	//   _مسافران_, _ngaio_, _भीमभेर_, _বুদ্ধিবৃ, 
   {{0xbe39011e,0x3d1e0148,0xedee00c4,0x5c34058b}},	//   _anbarasa, _文化資產叢書_, _ڪمپوز_, _iskaznic, 
   {{0x82e9012b,0x687601bb,0x33ee0361,0x92910240}},	//   _biznesu_, _almandyr_, _ударени_, _wawale_, 
   {{0x5291033f,0x8b9d0059,0x2058018d,0x429002cd}},	//   _aeaaia_, _временна_, _ብምሉኦም_, _aunai_, 
   {{0x9202022d,0xa48003a2,0x7784027b,0xb2fe0046}},	//   _marinu_, _रेवाड़ी_, _विशरणगत्, _ferides_, 
   {{0x93770060,0x721502ec,0x1587029d,0x127f0290}},	//   _مىسال_, _صداقٔژ_, _дискул_, _buania_, 
   {{0x28a20205,0xc01b01b5,0x9a830066,0xe39501ef}},	//   _انتظارنی_, _enkwamen, _sinisten_, _амонаўцы_, 
   {{0xf26d0488,0x5e300305,0x326702f9,0x00000000}},	//   _aktos_, _pingvina, _finansyè_, --, 
   {{0x538604c0,0x020203da,0x7a9800b9,0xc2900028}},	//   _abere_, _ntukwasi_, _berinves, _hufan_, 
   {{0xec680174,0x590200e6,0xca9a0344,0x0e4f01e8}},	// [1700] _swerego_, _国务院建设行政主, _franskis, _makapala, 
   {{0x02ca0115,0xdc0c024a,0x9de9004d,0xa5b002e4}},	//   _dailami_, _idarọ_, _電話報案正確觀念_, _ghandkom_, 
   {{0xbc76011f,0x7d8d0087,0x9e500192,0xf290029c}},	//   _guarani_, _ahivanhu_, _오마이뉴스_, _timati_, 
   {{0xf51e00a9,0xc5060115,0x027f0138,0x1a650344}},	//   _birorosh, _hormatny, _oranla_, _clemmens, 
   {{0xaf640501,0x89c203f0,0x9291008e,0xb6490311}},	//   _प्रकाशना, _fundarst, _ifaada_, _ስፓርክስ_, 
   {{0x7a2800c4,0xac180153,0x29db0348,0x729501be}},	//   _ربطيات_, _アフィリエイトで, _asanyusa_, _deskami_, 
   {{0xb2e90313,0xf50f0054,0x607700e6,0x7eaf02fd}},	//   _danihmo_, _abdourah, _广西医科大学学报_, _safeways_, 
   {{0x0d3a0076,0xf1590366,0x6b000096,0x7e510074}},	//   _contrári, _самоучит, _amasegit, _особые_, 
   {{0x9c000005,0xac20014a,0x135e019d,0x29440153}},	//   _questas_, _versenys, _bakukhum, _ハンドクリ_, 
   {{0x92fc022a,0xe2da0541,0x2caf033d,0x592e0421}},	//   _avigo_, _poseta_, _enjeniè_, _firmenve, 
   {{0x5c0c03b6,0x549c0360,0x24a00418,0x9a91003b}},	//   _adarọ_, _natočil_, _kalması_, _beyihamb, 
   {{0xe9830184,0xda47022f,0xf40e0076,0x00000000}},	//   _abahinga_, _дружна_, _подновен, --, 
   {{0xa27f0108,0x56bb0097,0xa7d403b7,0xa200005b}},	//   _maung_, _lẹsẹsẹ_, _ariroluf, _eaiif_, 
   {{0x94e400bf,0xb5da0006,0x02960640,0xa27f0309}},	//   _случаев_, _akibatny, _suradnji_, _iranla_, 
   {{0x227e014a,0x8709015e,0xb05700da,0x6290050a}},	//   _szent_, _берилип_, _angajato, _mimari_, 
   {{0xb2e603ba,0x43f4033f,0x8bca0246,0x00000000}},	//   _blinzen_, _fautoo_, _павликен, --, 
   {{0x0de703ab,0x5f4503af,0x3bed05a6,0x0815020a}},	// [1710] _rodinné_, _période_, _kraftver, _бурабай_, 
   {{0xf2c402c2,0x433100bf,0x0ae6006e,0x17a101ad}},	//   _nommers_, _вторично_, _estraate, _nakukuri, 
   {{0x4290035e,0x4f6401be,0xc9bd01d5,0x249000f8}},	//   _dunav_, _प्रकाशला, _belekeve, _এগুতে_, 
   {{0x541e0046,0xb30502d3,0xdc6e0227,0xbe7300bb}},	//   _принциби_, _coragem_, _gemuruh_, _خداؤں_, 
   {{0x5e4e02f3,0xef4500e2,0xbec40019,0x00000000}},	//   _behandla, _fassinea, _бътъръъч, --, 
   {{0xd27e0474,0x9cae0310,0x6340038e,0xf985046f}},	//   _nyene_, _farsaing_, _tukeran_, _inviteie, 
   {{0x1363005a,0x985c042c,0x1ad603f2,0x00000000}},	//   _bongach_, _prezadov, _чистоты_, --, 
   {{0xc2bb01b8,0xa37b01b7,0x2b950125,0xe196020a}},	//   _ostetud_, _आर्याष्ट, _мыдарым_, _سۇننيتتە, 
   {{0x52490108,0xb2ca0068,0x4b6501c2,0x926e0362}},	//   _ciamis_, _caalami_, _villagar, _batoli_, 
   {{0x6d7801db,0x9c730119,0xd27e017d,0x67cc0166}},	//   _ءبىيدى_, _opisina_, _miinto_, _pressemi, 
   {{0x426d027e,0xc3f80076,0xf9a1003c,0xd1030414}},	//   _otvore_, _coluna_, _بلبرینگ_, _bankolel, 
   {{0x12fe0218,0x1fda0090,0x49e20086,0x59fd0223}},	//   _aapgay_, _akazotan, _نائيک_, _aparailu, 
   {{0xf2130269,0x77c2000d,0xb2900328,0xd3a20073}},	//   _noches_, _operatii, _bimari_, _rumper_, 
   {{0x83f700bf,0x02ea026d,0x7eb800e6,0xc958018d}},	//   _хранить_, _moznost_, _直辖市和计划单列, _ዝሰማምዕሉ_, 
   {{0x0d8e00c5,0xa3940210,0x3c2d0144,0x35a3006e}},	//   _可以并处罚款_, _amoses_, _chraenac, _jankonté, 
   {{0x330803bd,0xb9c50371,0xf848018d,0x8ea40017}},	//   _trabaho_, _riservat, _ብሄራውን_, _posunete_, 
   {{0x95440532,0xc9f700d1,0xb292010d,0x9c660181}},	// [1720] _poslužit, _ইঞ্জিনটো_, _espass_, _slettes_, 
   {{0x23f80242,0x69fa0168,0xe2d90160,0x9a170354}},	//   _yoluna_, _motstand, _pocela_, _териккәк_, 
   {{0x5e930087,0xc576022f,0xa238012c,0x73940294}},	//   _hlomisan, _трусаў_, _dhamiri_, _honsiu_, 
   {{0x91c1000d,0xc30703b2,0x384c0344,0xa7c70388}},	//   _गिरहस्थी_, _bombing_, _filmiliu, _реагират_, 
   {{0xed7700e1,0x87760025,0xc3c60076,0xb38a0350}},	//   _brumaire_, _प्राचीना, _фросина_, _መሠረቱን_, 
   {{0xa29203b9,0x32fc011c,0x1cdd0282,0x89870320}},	//   _jawart_, _congam_, _houkamau_, _mathikit, 
   {{0xbafc002b,0x03710264,0xa19f0234,0xb3f8020e}},	//   _বর্মন_, _ighatag_, _kòjòkú_, _hodula_, 
   {{0x7c140013,0x9fe6027d,0x4ee802e7,0x00000000}},	//   _شوونی_, _христу_, _magkakan, --, 
   {{0x62da04bd,0xeaa900c8,0xecae00db,0x70ec04ae}},	//   _losepa_, _теремек_, _hinganud_, _колоквиј, 
   {{0x027f00ad,0x02d00242,0x727e0138,0x22370388}},	//   _saung_, _azalır_, _cennet_, _chimica_, 
   {{0x9f0500d1,0xb5b80235,0xf8b004df,0xccf500b9}},	//   _উপযোগিতা_, _annadasy, _albaniýa_, _लिंकवर_, 
   {{0x9a9d0094,0x907100d1,0x727f02c7,0x19f60392}},	//   _اقىردىم_, _অনুসৰিহে_, _laune_, _ghròt_, 
   {{0x738702d4,0x00000000,0x00000000,0x00000000}},	//   _giuru_, --, --, --, 
   {{0x5248005b,0xee4c03c0,0xbd9f0152,0x00000000}},	//   _roomy_, _etablere_, _тәрбияче_, --, 
   {{0xbbd1019d,0x3c7d022b,0x127f02c2,0xb37802db}},	//   _wanderer, _spurdir_, _taung_, _sumatin_, 
   {{0x5df501f1,0xe2d203ac,0x03790244,0x303101a3}},	//   _mendimet_, _khatimah_, _istanza_, _ڪهاڙيون_, 
   {{0x5f6f00d1,0xf27f023e,0x82df00ad,0x86bb0097}},	// [1730] _হৃদপিণ্ড, _raung_, _bolokot_, _pẹrẹsẹ_, 
   {{0x520202bc,0x19b70153,0xbdb1010b,0x79b40350}},	//   _casius_, _から修正依頼を出, _gobadiwe_, _ለመድገም_, 
   {{0xd15003db,0x7db4005e,0xb54405ad,0xcf9400bc}},	//   _impendul, _سوغوق_, _posluživ, _aréal_, 
   {{0x6c3501b2,0xb27e01c6,0x331b007e,0xdb200594}},	//   _cowardic, _wennet_, _aurasā_, _symaskin_, 
   {{0x76720016,0xcdc0012a,0x4867001d,0xad2c029e}},	//   _פֿעלקער_, _regionie_, _enprenis_, _auxiette_, 
   {{0x071701cc,0x596b0347,0xb55400ff,0x5dad0462}},	//   _ahesuṃ_, _kennisge, _שטרײַמל_, _arsingpa, 
   {{0x89c3023b,0x3d7e01fe,0xa6cf0025,0x42c5000f}},	//   _isemaela_, _iseleiwa, _athainam_, _millete_, 
   {{0x325a0049,0xc2b20066,0x29df0334,0x00000000}},	//   _epiloo_, _mendean_, _amatsegu, --, 
   {{0x627f022f,0x866b02c0,0x98b2032d,0xc60200d9}},	//   _kaune_, _отплата_, _форсаты_, _ovulaati, 
   {{0x1d7f04cf,0xff4300fd,0xb290004f,0xe0530206}},	//   _ngamanye_, _coisirea, _dunam_, _presklen, 
   {{0x683f0162,0x1ff30321,0x02eb01e8,0x85460061}},	//   _قۇرامىغا_, _preseneč, _diritso_, _오즈천공의기사단_, 
   {{0x46b9001a,0xa30d0641,0x43c80130,0x16110290}},	//   _عبداللہ_, _alvorlig_, _barvek_, _ballarei, 
   {{0xfcfa0044,0x52000377,0x7f56042f,0xf66f0178}},	//   _חחחחחחחח, _lumina_, _nutaangn, _anivārya, 
   {{0xb20200a2,0x82cb01fb,0xf7ed012d,0x115c02dc}},	//   _karibu_, _credne_, _leranbag, _denuncio, 
   {{0x5956000a,0x6d420361,0x2b580087,0x627e0168}},	//   _sullinne, _токсины_, _huduriwa_, _rennet_, 
   {{0x93f800d7,0x7e50020f,0x5a7200ab,0x4d8902a1}},	//   _bolula_, _angazima, _mangaeka_, _olifante_, 
   {{0xc3d60052,0xe26c00a4,0x00000000,0x00000000}},	// [1740] _व्यापारी, _menors_, --, --, 
   {{0x7d0301bb,0x80c90056,0xdd5702e4,0x2290017e}},	//   _kanunlar, _таблиғот, _akwatiku_, _nunaj_, 
   {{0xb38004d0,0x042502ec,0x0a8c0415,0x25a30145}},	//   _dourug_, _پھێریُک_, _gewissen_, _колеру_, 
   {{0x37b100c5,0xc2d8034b,0x3a7d020f,0xab00017e}},	//   _对直接负责的主管, _kokonas_, _azinants, _amasigit, 
   {{0x77bf05bf,0x02480200,0x65b30039,0x2f2f0148}},	//   _cokolvek_, _nnomi_, _антверпэ, _inveniun, 
   {{0xcf2501b9,0xec2b0037,0x7e790135,0xb2480387}},	//   _angleter_, _ውድነትን_, _ministrı, _inomi_, 
   {{0x7341008c,0x72000148,0xa1ca0299,0x00000000}},	//   _mesemna_, _numina_, _ئىپىزوت_, --, 
   {{0x328b0025,0xcc5f015e,0xba00012d,0x348c01bb}},	//   _aanandam, _اسپاپتا_, _saksesfu, _ылымының_, 
   {{0x5c34019c,0x2243044a,0x6dfb0400,0xbcfb022e}},	//   _angbadur, _asambeli_, _allevate_, _allevatu_, 
   {{0x42d800e5,0x63dc0249,0x72d9041e,0x7213021a}},	//   _boleto_, _stiwud_, _riceva_, _dachee_, 
   {{0xae9a0325,0xff9a013c,0xd2d5006f,0xfda7026a}},	//   _bildirib_, _bildirir_, _مناظرن_, _tekivuta, 
   {{0x4a8300a6,0xe25b04a4,0xe3400082,0x4a1002fe}},	//   _abazinge, _chalum_, _bayelsa_, _anqabile, 
   {{0xd20005b1,0x95640061,0x830000a5,0x62430007}},	//   _asmira_, _진달래마을_, _lumanai_, _esambeli_, 
   {{0x4b0002e5,0x50f40040,0xda1f03f8,0x6f9b003c}},	//   _básicape_, _האוסקר_, _hesbelme, _سرازیر_, 
   {{0x0ccb009b,0xc21b021c,0x5c270161,0x3386015e}},	//   _гардаггү, _neutráln, _примеры_, _acords_, 
   {{0xbb770220,0xd6fa01ec,0xe3fa0007,0x4a3700d1}},	//   _crescita_, _کرامدور_, _kotuta_, _বিকিৰণ_, 
   {{0x129000bc,0xe2020076,0xc2d802c3,0xa2b501f3}},	// [1750] _lunak_, _assine_, _koleso_, _eviduje_, 
   {{0xfad80540,0xcf5d036d,0x32da0020,0xd6800178}},	//   _bíllinn_, _breatunn, _chankee_, _bāhyahiṃ, 
   {{0x3dbd03f8,0x9259018d,0x823200d7,0xffff0061}},	//   _dachavqa, _ንውድባዊ_, _bonmril_, _중소기업청_, 
   {{0x7e4e020e,0x92010288,0x508d0040,0x9d9b01c8}},	//   _bolaella, _oreita_, _רבעון_, _sponkova, 
   {{0x013500da,0x81b00287,0xfcda0141,0xcdb9056b}},	//   _економие, _nalezené_, _миллийли, _merakyat_, 
   {{0x42bb0261,0x92f0026a,0x63ea0151,0x81990145}},	//   _komence_, _maliwai_, _bantym_, _апаратаў_, 
   {{0x32f3033a,0x20050109,0x4cae03ae,0x72c3032d}},	//   _relatati_, _वरियतामा_, _varsling_, _kahlolo_, 
   {{0x1c500040,0xf0660107,0xef06023e,0x94c60332}},	//   _למטייל_, _ناموفق_, _دعاوی_, _asociado_, 
   {{0xdbb70307,0xd1b00287,0xc3a9015e,0x96a1013a}},	//   _akayikub, _nalezení_, _жаргылча, _matgespi, 
   {{0x58510101,0x73010467,0xcb690074,0x2d8f0013}},	//   _recomand, _adebone_, _paremmin_, _egallaga, 
   {{0x73eb01f1,0x52f3014a,0x1c0e0176,0x1b890013}},	//   _jepte_, _felirat_, _subpage_, _римликла, 
   {{0xd7300074,0x431201b6,0xcf090246,0x9eb0018f}},	//   _mielikuv, _alibris_, _техният_, _muvoqqan, 
   {{0x02010212,0xe22a019b,0x08f003d4,0x22fd0073}},	//   _facies_, _новай_, _stepanov, _rejicer_, 
   {{0x141401cd,0x029000c7,0xad2f0642,0x93fe0166}},	//   _kangcono_, _kunak_, _दुष्परिण, _qualifik, 
   {{0xb39402c2,0x826c013f,0xaa5004bd,0x32fd0089}},	//   _boosts_, _adloc_, _kelepona_, _açildi_, 
   {{0x5201017e,0x3291004c,0x2d840203,0x48b90109}},	//   _kreita_, _agaava_, _inventet_, _sestavov, 
   {{0xd26d006f,0x8c70003c,0xc2b60078,0x01c4011a}},	// [1760] _ufunguzi_, _خودگردان_, _северној_, _בטעינה_, 
   {{0xb50e02f8,0x00000000,0x00000000,0x00000000}},	//   _mailefih, --, --, --, 
   {{0x59960061,0xa059038f,0xffd800bf,0x448401ab}},	//   _남자친구잇는걸_, _ardivink_, _персов_, _झुलावऽ_, 
   {{0x3c79028e,0x582b0244,0xc62a0444,0x00000000}},	//   _trustim_, _украси_, _макарови, --, 
   {{0x4ef20193,0xc8c8031a,0xa355030a,0xad860170}},	//   _सिक्युरि, _casruisg, _valedor_, _imvekere_, 
   {{0x42d9013b,0xbc5a030b,0xfce100ff,0x09f700c0}},	//   _docena_, _abatali_, _בעיסוואט, _maligaya_, 
   {{0xd2f60449,0x730f00f2,0x00000000,0x00000000}},	//   _nadimak_, _ierindoj, --, --, 
   {{0xd20200ca,0x93130445,0x23f9000c,0xcd9c0382}},	//   _astier_, _lembrar_, _сангәлие, _masetele_, 
   {{0x683701f2,0xc1fb0344,0x52570100,0x00000000}},	//   _закайеф_, _barnetim, _nastupal, --, 
   {{0x5fa40203,0x05660061,0xf9f604f6,0xfc5a003b}},	//   _inserter_, _무료입니다_, _byråd_, _ebatali_, 
   {{0x615c01cd,0xa1030092,0xcdfe047d,0xe9a70126}},	//   _худам_, _をクリックします_, _verdeelt_, _класични, 
   {{0x69f80437,0x72d500b0,0xf8240125,0x8a270164}},	//   _tilstand, _intooda_, _шуурсыз_, _ғулҗида_, 
   {{0x5b2d0107,0xa6c5005e,0xc2e302e1,0xb6220147}},	//   _grobogan_, _ئونسۇ_, _chainte_, _دەيبىز_, 
   {{0xd2910357,0x4a090241,0xdda70087,0x52cb00cd}},	//   _keyaka_, _disaasaa_, _majisita, _calonda_, 
   {{0xb10700d6,0x61fc03f8,0x92430020,0x229001fc}},	//   _ضرورى_, _divaqmeh_, _isamaeli_, _tufah_, 
   {{0x335602ac,0xd6c5002b,0x9c6b0107,0x33d500b4}},	//   _bulfinn_, _কাঁঠালের_, _celurit_, _fratelui_, 
   {{0x0f020125,0xaa0000fe,0x7c6804ef,0xe38d00d0}},	// [1770] _акыла_, _aumanafa_, _amarelo_, _харандаа_, 
   {{0xa2e70265,0xc61e003d,0x9c77045a,0x03ea026c}},	//   _klanten_, _phonétiq, _prisene_, _tantam_, 
   {{0x725b0058,0x1c71015f,0x6c5b0172,0x302b0145}},	//   _phylum_, _gwarant_, _onnuare_, _bendrijo, 
   {{0x69eb02bd,0xe3790307,0x05ce00a4,0x00000000}},	//   _aberhond, _belapho_, _талма_, --, 
   {{0x042b00de,0x00000000,0x00000000,0x00000000}},	//   _مستجب_, --, --, --, 
   {{0x0dae04bb,0x32e1019c,0xc30e00cf,0xaf4e00ff}},	//   _tiffanie_, _ajunilo_, _abaadir_, _צוואנציג, 
   {{0xae3601ad,0xfb92001c,0x157a0277,0x00000000}},	//   _paranava, _komitido_, _martilyo_, --, 
   {{0x227801b8,0xb27e02aa,0x0dc80141,0xa9dc013a}},	//   _krundi_, _hymnu_, _kuchayga, _gezeeche, 
   {{0x622300af,0x427f01b0,0x43f10229,0xc2fb016b}},	//   _являютьс, _aranna_, _evezine_, _inshora_, 
   {{0xb6d601e0,0x697300d9,0x884901a3,0x622a006c}},	//   _سازمانه_, _огромная_, _ليکبي_, _комат_, 
   {{0xb9fe02da,0xcadd01db,0x4da60643,0xcaf2018a}},	//   _merament, _ايازدى_, _navodnja, _amhroffe, 
   {{0x99f60240,0x69a50053,0xb8b60155,0xd2dc0160}},	//   _malumalu, _janjinya_, _handland, _odbojci_, 
   {{0xa9730515,0xd2d80247,0xca110349,0xc31600d9}},	//   _diminuit, _solopos_, _inactive, _занятий_, 
   {{0x52cb0243,0x5be50074,0xd60d02fe,0xa27f0478}},	//   _balooda_, _hallinto_, _bezokusi, _cauna_, 
   {{0x99780073,0x42fc0620,0x98730390,0x26580268}},	//   _numinist, _habitet_, _faciədən_, _eelingsf, 
   {{0x4cfb03c2,0xa3a7030a,0xc2da0059,0xf27801a6}},	//   _panelled_, _despedim, _cornice_, _urungi_, 
   {{0x620101ef,0xc5320048,0x4fba0127,0x6f800061}},	// [1780] _ateina_, _agazirik, _amourous_, _누구보다도_, 
   {{0x64d70644,0x10bb03a2,0x80ea006d,0x72fa00ae}},	//   _дамады_, _खंडूरी_, _аўрал_, _ndahava_, 
   {{0xc3fa0041,0x927f01a6,0xde3c00c4,0x821301f7}},	//   _дидикыле, _rauna_, _گيسٽرو_, _archiu_, 
   {{0x42000135,0x22d903ab,0xc9cb027b,0x00000000}},	//   _armiya_, _docela_, _अपनयने_, --, 
   {{0xc2780069,0x51a700ba,0x6ef202d5,0xc0d5004d}},	//   _urundi_, _ساڵۆنی_, _डिप्थिरि, _戒快技抖快找把攸, 
   {{0xff0f0121,0x0a100059,0x9dcd0262,0x60170143}},	//   _mercados_, _chiarime, _baktriýa, _законни_, 
   {{0x28f90148,0xa0210031,0x86a900e6,0x56b900a0}},	//   _荖濃溪勤和段緊急, _berwenan, _农业新闻摘要_, _alfahari, 
   {{0x2dbf0052,0x22a70223,0x2250014a,0x97b001fe}},	//   _विज्ञापन, _garbi_, _télen_, _ikawakaw, 
   {{0x2f7701de,0x00000000,0x00000000,0x00000000}},	//   _физигі_, --, --, --, 
   {{0x42be0645,0x0f06015e,0x9f3801d3,0x00000000}},	//   _oženio_, _булгануу, _skyskrap, --, 
   {{0x5c4504ce,0x5c1c01b9,0xf9e2028a,0x4c3f004d}},	//   _maswina_, _lavangar, _راجيش_, _傳訊給朋友_, 
   {{0x720e040f,0xa8c50121,0x320002fb,0xf9c50212}},	//   _палац_, _intentad, _saiia_, _intentat, 
   {{0xf2a70079,0xd142018b,0xeeda01e6,0x5d9e0340}},	//   _darbi_, _атраг_, _pochopen, _nekeneke_, 
   {{0xea330060,0x65bb0028,0x00000000,0x00000000}},	//   _денелерд, _badantah, --, --, 
   {{0x8b65021e,0x7af6001e,0x56370296,0xe290015e}},	//   _billigar, _kalubale, _barnfami, _arnau_, 
   {{0x734103fd,0x3230023b,0xb3790322,0x2eb401d5}},	//   _aeseina_, _ikemaka_, _akoreram, _tükrében_, 
   {{0x2a140170,0xd3fa009b,0x27730371,0xe41e0321}},	// [1790] _adabwiza_, _altuna_, _бойлери_, _čistilna_, 
   {{0xd9730066,0x32d502b2,0x42f101ff,0x237e01f4}},	//   _teknikoe, _автопроб, _adminov_, _изистонд, 
   {{0x6de70395,0x94d10255,0x0c3801b3,0xf39402b9}},	//   _podivné_, _मानिजन_, _самопочу, _emese_, 
   {{0xe2d5005b,0xe2a70482,0x72d5005b,0x967e0247}},	//   _rollout_, _carbi_, _tilladt_, _akhdaafi, 
   {{0xe9440156,0x813400a7,0x712b04c7,0x19aa03f2}},	//   _ינפרינדז, _алдырат_, _поприлич, _полив_, 
   {{0x490f01cb,0xed3701f4,0x9e0e016f,0xcd6d0040}},	//   _nebandlu, _وکلات_, _вакансій_, _תינתן_, 
   {{0x82af03d8,0x067302c7,0x9300010e,0x00000000}},	//   _igrališt, _landgeri, _humalaw_, --, 
   {{0xf2d800eb,0x26b200bc,0x2195041a,0xbe3c00c4}},	//   _ashesi_, _penggali, _членом_, _مشڪوڪ_, 
   {{0xe978062d,0xa27100f0,0x3d9f05c3,0x5a9d0054}},	//   _suminist, _podeliť_, _vulnérab, _fifikons, 
   {{0x23f100e4,0x9e500010,0x894c01c4,0x0f7d03c1}},	//   _श्रीमाली_, _angalima, _dramatie, _комплика, 
   {{0x027f022f,0x2c6002f0,0x499405ac,0x22fc017d}},	//   _kauno_, _ancunya_, _tjeklist, _evigt_, 
   {{0xf27f01a2,0x42a604c0,0xf37401a3,0xab0e02ac}},	//   _jauno_, _brobro_, _جنڊيءَ_, _bhusanna_, 
   {{0x927f01fb,0x8e80033e,0x44080105,0xd692010d}},	//   _dauno_, _искужин_, _komornik, _विधिमंडळ, 
   {{0xd290017f,0x390a03c7,0xc996048a,0x86e000f3}},	//   _arnat_, _pieniędz, _тартыс_, _kwebhoki, 
   {{0x8e190148,0xaf9e00d1,0x52900170,0xe2d802ba}},	//   _中共煽動仇恨構陷, _চিৰসেউজ_, _dimazi_, _asheri_, 
   {{0xa95202c2,0x094c03eb,0x634f002b,0x934100a5}},	//   _publisee, _primitie, _আধাবেলা_, _seseina_, 
   {{0xa61003cc,0xabf000be,0x04c70156,0x127e03ae}},	// [17a0] _কুড়িগ্রা, _بىچاقتىن_, _כיפּור_, _byene_, 
   {{0xa2420255,0x9e1a0079,0x2c5d0066,0xef3600ad}},	//   _मँगले_, _āgenskal, _sortuko_, _tarumana, 
   {{0xa38603e0,0x4c71034e,0x51e0020f,0x9743025c}},	//   _waert_, _antroxu_, _angonyam, _krankenv, 
   {{0xd90f024d,0x3bf601be,0x37a00107,0x12900646}},	//   _webandlu, _studentů_, _dhampyak_, _lejano_, 
   {{0x303703c2,0xba94043f,0xb195018f,0x978603a4}},	//   _sustenan, _jednakos, _monchugh_, _ferjuleg, 
   {{0xc22402d8,0xd47600e3,0xa195003f,0xd340046b}},	//   _wookie_, _britannj, _lonchugh_, _difetha_, 
   {{0x4afe03e6,0x039801bb,0xb5e800c7,0xf3eb0099}},	//   _vergiess, _талаплар, _bolarnı_, _chatau_, 
   {{0xfe990014,0x634700cd,0x06350161,0x00000000}},	//   _komunave_, _avierta_, _алексея_, --, 
   {{0x78bf033f,0x4eb6026f,0x638d00b4,0xd5dd0486}},	//   _finematu, _بىىكتەتە_, _corpului_, _modelová, 
   {{0xd38702e0,0x327f025f,0x623802ea,0x730300c4}},	//   _aparwa_, _asengi_, _chimici_, _karafuu_, 
   {{0xd2cb0467,0x820101cf,0x32900075,0x00000000}},	//   _naadom_, _racias_, _irnar_, --, 
   {{0xe29103a8,0xb8fb0253,0x31cc0279,0xdfd801db}},	//   _utval_, _allaappu, _facilité_, _электрме, 
   {{0x4ded0039,0xc29000d0,0xebba005e,0x35a000c1}},	//   _сахаргүй_, _arnas_, _بىخلان_, _शोधतो_, 
   {{0x725b019b,0x3227003e,0x727f0362,0x922c0239}},	//   _spalio_, _фашисты_, _esengi_, _kämera_, 
   {{0x1a880238,0x220e0008,0xae3a0461,0x2bd20446}},	//   _основним_, _манап_, _annexèt_, _sanjaric, 
   {{0x6016015e,0xafe60162,0x982600a4,0xa43701dd}},	//   _касында_, _ئابونت_, _جانادا_, _babagaho_, 
   {{0xa3170188,0x427300b4,0x3d9e00a1,0x5b6c0046}},	// [17b0] _abezwa_, _politiei_, _mekemeke_, _catosfer, 
   {{0xf80600ef,0xe03b0039,0xc9be02ac,0x9c74027b}},	//   _ابراهيمي_, _papereko, _تحطيم_, _अशक्यः_, 
   {{0x925b029b,0x82da000e,0x82d201f9,0x15f10156}},	//   _baalul_, _alsena_, _bameleli_, _מוסלומענ, 
   {{0x1386020d,0xb29003f0,0xb227023d,0xe2fe0456}},	//   _abera_, _arnar_, _самият_, _iktibar_, 
   {{0x52fc0069,0xe89500be,0x29530135,0x4db1012b}},	//   _kwiga_, _convidar_, _сырып_, _zamierza, 
   {{0xa6ad018b,0x11300365,0x13270301,0x83650139}},	//   _autentif, _mladých_, _borcunu_, _anugata_, 
   {{0xd3a90203,0xa2010367,0x00000000,0x00000000}},	//   _convene_, _queira_, --, --, 
   {{0x75bd02bb,0x929000e9,0x5320001e,0xd60b00b7}},	//   _archiwum_, _anmani_, _janye_, _исламийе, 
   {{0xf32003da,0xd3050192,0xb26e005b,0x727f008f}},	//   _danye_, _두산벤처다임_, _satomi_, _rauno_, 
   {{0x7201017e,0x52010461,0xb7bb0223,0x92c204df}},	//   _kreiva_, _bacins_, _baloreak_, _chalaja_, 
   {{0x7c570023,0x132003da,0x13d50101,0xec7702ac}},	//   _машины_, _fanye_, _statului_, _عريضة_, 
   {{0x0d2a001a,0x93200180,0x48e90311,0x00000000}},	//   _mennyibe_, _nanye_, _ታሕተዎት_, --, 
   {{0x37f6004d,0xc23b01f4,0x6c76003c,0xe6d100a0}},	//   _運費及交貨方式_, _kunduzgi_, _شدیدتر_, _gangarow, 
   {{0x42a502ca,0x2ee9017d,0xe107003e,0x4b630338}},	//   _pointí_, _ありがとう_, _гидрокос, _obertura_, 
   {{0x63200010,0x33880212,0x3c740647,0x66ef00e2}},	//   _kanye_, _classnam, _प्रेमविव, _easterwâ, 
   {{0x12b3022c,0x84d700a4,0x547c025f,0xbc2f0037}},	//   _pendopo_, _талашып_, _aúgusto_, _አለመቅረባቸዉ_, 
   {{0xfe4900b9,0x74100169,0x8eb801f6,0xe92d0158}},	// [17c0] _kewajiba, _ফারহান_, _আমন্ত্ৰণ_, _बेवजह_, 
   {{0x7533002b,0x1ee903b0,0xc9e60405,0xd6130192}},	//   _স্বাক্ষা, _tyskaran, _шахтаря_, _neutraal_, 
   {{0xd2000359,0x2fcc0061,0xe64801aa,0x316d00e6}},	//   _maaie_, _백산공인중개사사, _ancientw, _赚钱有门道_, 
   {{0xb1cc000e,0xff4c002e,0x42900418,0x526c00cd}},	//   _facilitá_, _prisutne_, _esnaf_, _camond_, 
   {{0x0767019b,0xb5d2016d,0x6f3302d8,0x386d0163}},	//   _reikalav, _инсанийә, _beredarn, _dunaferr_, 
   {{0x82900648,0x499d0177,0x69d800fd,0x71850620}},	//   _kunas_, _напык_, _eisemple, _我的美女大小姐_, 
   {{0xd2740113,0xc09703c4,0xa8ff0037,0xda8501e0}},	//   _سوالف_, _иранниң_, _በውሳኔው_, _عوقده_, 
   {{0x27c7006c,0x7323022f,0x53f40256,0x3aff05b8}},	//   _тариқи_, _фоткаю_, _kautko_, _sovrumme, 
   {{0xe11a0037,0xd0660012,0x169105b7,0x00000000}},	//   _በቀጣዮቹ_, _खेतसँ_, _košnica_, --, 
   {{0x739501cd,0xa2900082,0xe42c02d7,0xf29002ef}},	//   _abasha_, _nunar_, _atraídos_, _jimani_, 
   {{0xb26c00d6,0x99d7019d,0xd9fa025c,0x3bac0359}},	//   _hamood_, _adalemba_, _entstand, _artysten_, 
   {{0x42900141,0x904a0144,0xc2bf0113,0xaa9a0074}},	//   _hunar_, _teorainn, _ومداد_, _olennais, 
   {{0x82e60125,0x59210193,0xf3f801f5,0x327e0176}},	//   _elinden_, _नाकर्तेप, _diduga_, _bennye_, 
   {{0xf29000cd,0x995f0464,0x3290003a,0x5a5400fb}},	//   _bunas_, _amenyere, _nimani_, _asemhlab, 
   {{0x4d990014,0x527e0077,0x1c4702e2,0xab1c013a}},	//   _trafikut_, _dennye_, _asscharr, _erwarden_, 
   {{0x0290059b,0x22580238,0x53840020,0x153d03b5}},	//   _asnaf_, _насампер, _boostrix_, _dagingny, 
   {{0x6b6302da,0xcf8e0013,0x3b5e0145,0xf6b802e2}},	// [17d0] _abertura_, _тарбияси_, _труну_, _divagati, 
   {{0x029d025b,0xe639019d,0x83e5002b,0x8d1f0476}},	//   _seljara_, _chinachi, _অনুকূল_, _chingave_, 
   {{0xf14402ec,0xcdce0060,0x2f5d04b9,0x1a540096}},	//   _پھرى۪م_, _билей_, _creaturs_, _anamusab, 
   {{0xf2900176,0x6fd90314,0x82910161,0x8213003f}},	//   _runas_, _урамында, _luvan_, _hachbe_, 
   {{0x4f3f0298,0x0201015e,0x19be00b7,0x72900082}},	//   _tangihan, _queixa_, _истигфар_, _kunar_, 
   {{0xb0030256,0x7ea1026b,0x12020031,0x69b7025b}},	//   _konsultā, _embrague_, _hariku_, _handfara_, 
   {{0x7db401a4,0x72cf01c3,0x758d012b,0x786e00af}},	//   _abongola, _cigogne_, _wizualiz, _пораненн, 
   {{0x93ea0356,0x027e0414,0xc213003f,0x5bcc036b}},	//   _mantam_, _eyena_, _lachbe_, _комисиит, 
   {{0x729101a7,0xf54700da,0xf1560649,0x00000000}},	//   _kuvan_, _белорушь_, _अमुल्य_, --, 
   {{0x0284004b,0x80310107,0x752e011a,0x52e60263}},	//   _habholo_, _bratasen, _רולדין_, _blinden_, 
   {{0x86cb020f,0x22900372,0x32ec0073,0x0290038e}},	//   _درستیز_, _arnai_, _seriose_, _prnah_, 
   {{0xaea70220,0x57590158,0x82ec00d2,0x962b022b}},	//   _интереси_, _इज़्ज़त_, _nganjuk_, _sokallað, 
   {{0xb2d80104,0x52480516,0xdc7302f7,0x1e0d0238}},	//   _nikeza_, _chimes_, _apesiwa_, _tusentip, 
   {{0xd29001b7,0x12910242,0xb27c0145,0x337a033d}},	//   _punas_, _arvad_, _зграя_, _anpasan_, 
   {{0x2a3900d9,0x9e6a015e,0x39c502ea,0xea4e00a8}},	//   _решений_, _созду_, _villetta_, _anceinza_, 
   {{0xe3e902ac,0x8ffc027b,0xa29a014a,0x0c3a04c7}},	//   _طبيعيه_, _अष्टाङ्ग, _fogpótlá, _покажемо_, 
   {{0xd3f80046,0xd28504e5,0xf2ec00b3,0x868b0423}},	// [17e0] _adjunt_, _baakung_, _berilse_, _nečekejt, 
   {{0x528d0298,0x6f6f0478,0x73870119,0xd111051f}},	//   _raukawa_, _galaxias_, _agaron_, _نیویۆرک_, 
   {{0x0a8f0221,0xf3870439,0xa7c3064a,0xd46a01db}},	//   _penipuan_, _esarda_, _берзалой, _وكىمەتكە_, 
   {{0x369c00e2,0xd9720203,0x4e500343,0x00000000}},	//   _fakentii, _proposir_, _makasama, --, 
   {{0x22130313,0x32b405ab,0xc4e602b0,0x994f0352}},	//   _bachbe_, _eficaz_, _orthopäd, _depotdre, 
   {{0x898203d8,0x00000000,0x00000000,0x00000000}},	//   _okrivlje, --, --, --, 
   {{0xba15027f,0x0e0b0021,0xf38001ad,0x1f910133}},	//   _biratuma_, _ankeesya, _inurug_, _egamaaso, 
   {{0x02f10430,0xf98300ee,0x329000cf,0x39c60488}},	//   _masiari_, _lankidet, _arfan_, _interent, 
   {{0x029000dd,0xe6cf0418,0x08820137,0xe27e011f}},	//   _arnaw_, _bakabili, _тодхон_, _iningo_, 
   {{0x92ff0203,0x0a830004,0xc59b04a4,0xd2480004}},	//   _derider_, _bolivyen_, _cilogram_, _danmak_, 
   {{0x83fa016a,0x53da00d1,0x00000000,0x00000000}},	//   _entuta_, _শব্দকেইট, --, --, 
   {{0xf27f02c5,0x87f301db,0x3386015e,0xc4470185}},	//   _hauna_, _тексерул, _obert_, _видеода_, 
   {{0xc290064b,0xf2fc00ee,0x885c01f3,0xbf1300e4}},	//   _punar_, _blogak_, _manažer_, _जिज्ञासु_, 
   {{0x28a300d0,0xcd38002b,0xa4860109,0x28630084}},	//   _кесерови, _বিদায়ী_, _बुबाले_, _dibanjur_, 
   {{0x427f03f6,0x7f3f04c3,0xb3870128,0xe1070144}},	//   _mauna_, _langthan, _asarda_, _غروري_, 
   {{0x327f023b,0x4f3b00ab,0x421301d9,0x2bfb0066}},	//   _launa_, _hengahen, _tschau_, _langiler, 
   {{0x904a04a4,0x76b702be,0x3f01049d,0x72ba0202}},	// [17f0] _charaban, _mananati, _fragrânc, _kiriyó_, 
   {{0xdf3601f6,0xb290034c,0xdbeb025d,0xe303015a}},	//   _এছিয়া_, _aunap_, _sorenskr, _dabaluu_, 
   {{0x82e302fd,0x028f02d8,0xaea800af,0x34bd0033}},	//   _cheille_, _menandai_, _корисних_, _absolvà_, 
   {{0x396c0333,0xf27e0046,0x9ce00156,0x00000000}},	//   _muniment, _adonar_, _צענליגער_, --, 
   {{0x3c02030a,0x42ca0117,0xc2d4041e,0xedb60087}},	//   _básico_, _gaidim_, _coudes_, _eswianga, 
   {{0xfb27029f,0x2f580039,0xb2f7005a,0x5c6a034a}},	//   _nespolie, _царнаевы, _hadibah_, _reduciu_, 
   {{0x0f9d028b,0x30fa01e9,0xf81d0452,0x00000000}},	//   _иаҳхысыз_, _dishirel, _पानगळीचे_, --, 
   {{0xa2f10111,0x1eaf02af,0xf29103d7,0x52d40205}},	//   _scritti_, _barugize_, _suvan_, _berdik_, 
   {{0xe291013f,0xe29e00d7,0x8a0a0462,0xdb0a0462}},	//   _duval_, _мираҫ_, _ansposed, _ansposet, 
   {{0x8a04041e,0x58fd0556,0xa65f014f,0x70eb006e}},	//   _dibattit, _kubafund, _контролу_, _cammooña, 
   {{0x0eca04a5,0xf2cb0084,0x029000a5,0x02360255}},	//   _abanemin, _nyedot_, _maiava_, _windowsi_, 
   {{0x58e20023,0x4cee0039,0x12000318,0xd26c014e}},	//   _форуме_, _америкт_, _aaiia_, _belog_, 
   {{0x126c00ce,0xe26c03d4,0x19ec0178,0x727f0390}},	//   _denons_, _celog_, _aparagod, _ozunu_, 
   {{0x322601c5,0xff870064,0x03f400f2,0xffb300c4}},	//   _warkan_, _дарбыз_, _tortes_, _کيڏندا_, 
   {{0x296d00a8,0xf9eb02d4,0x438702b1,0x66990078}},	//   _satisfat, _corrispu, _dauri_, _šumadija_, 
   {{0x22480320,0xfe96045a,0xa0bd0052,0x8c18033d}},	//   _khoma_, _bestemte_, _zdravého_, _duvalier, 
  
   {{0x498a019d,0xc62b004d,0x47b1002b,0x0fba0299}},	// [1800] _amakonza_, _本局相關申辦服務_, _বুঝেছি_, _ئەبلەخلە, 
   {{0x32a700a0,0xd38c016d,0x5a260092,0x00000000}},	//   _harbi_, _йөткәшти, _神戸コレクション_, --, 
   {{0x42fc0007,0x62a70054,0x8212018d,0xf35a03e1}},	//   _nazareti_, _karbi_, _shohim_, _skuffet_, 
   {{0xa3200088,0x13ae03f1,0x59c50148,0x00000000}},	//   _canya_, _dávate_, _viderent, --, 
   {{0xb3fa0286,0x8eaf028d,0xc5490013,0x92c50241}},	//   _kotuaa_, _rekondan, _рейдлар_, _fillate_, 
   {{0xbe9c047d,0x8cff01e8,0x33870079,0xe9bb0513}},	//   _erstaunt_, _adjuster, _cauri_, _ehleketa_, 
   {{0xd22b02ff,0xed850614,0xd3fa0049,0x751f0235}},	//   _akomode_, _kinesere_, _motuaa_, _chandasy, 
   {{0x7f5401d1,0x87d00174,0x863903b8,0xee920128}},	//   _תאילנד_, _kwagalag, _саналаты, _мосуво_, 
   {{0x4c7d057d,0xfe710156,0xf3f400c5,0x52e60192}},	//   _jamstvo_, _כוידעשלע, _sortes_, _klinken_, 
   {{0xa32001c0,0x4ed6029a,0xb2480250,0x1d5a0162}},	//   _sanya_, _abondans_, _dhoma_, _золек_, 
   {{0xf3050095,0xf21c00bc,0x2458003b,0xbd5a00b7}},	//   _خوراک_, _pisham_, _angenawo_, _чокен_, 
   {{0x28cd01d4,0xe53b012b,0x3fbd006c,0xd512064c}},	//   _prefettu, _korytarz, _amalekho, _apsurdno_, 
   {{0x40470220,0xa3f801b2,0x12c50032,0xe69a028e}},	//   _мерси_, _adjure_, _fillite_, _stretiji, 
   {{0xe68a0368,0x1f0e0510,0x430d033e,0x862a016e}},	//   _организо, _социальн, _михаилов_, _seviniri, 
   {{0x1ab702d6,0x2c7f0267,0xf27f00ff,0xdf7401de}},	//   _дақоиқ_, _spustio_, _anando_, _термиңде, 
   {{0xa2250558,0xb36600b3,0x2412038a,0xb26c01df}},	//   _amakwa_, _бердилер_, _alinnink, _arnott_, 
   {{0x4387024f,0x6dac0633,0x82010034,0xc26c0092}},	// [1810] _tauri_, _wednesda, _steina_, _mamoru_, 
   {{0x127f0053,0x09ba0321,0x32ca0148,0x2aa80060}},	//   _hyung_, _povezava_, _ibidem_, _турасынд, 
   {{0x49fe01d4,0xcea503ad,0xe21d02d8,0xe22602ff}},	//   _verament, _tolleran, _भोपळा_, _darkon_, 
   {{0x9fad00e6,0xa7a401db,0xecb1002b,0x75cb014e}},	//   _métiers_, _сталинні, _রগরগে_, _изговара_, 
   {{0x85e800b1,0x9a7100c7,0x68d7032d,0xf7300029}},	//   _thomkhwm_, _açılu_, _diselfou, _میراتی_, 
   {{0x9248050b,0x63eb0196,0xaa9201b0,0x6dad0381}},	//   _rhoma_, _chathu_, _bagikeun_, _assingpa, 
   {{0xa24802e8,0xbf5c02f7,0xfe21019b,0xc49f002b}},	//   _shoma_, _bobaakan, _terminas_, _মৃন্ময়_, 
   {{0xf48f02f8,0xe30c00f4,0xe5d502e7,0xaea700e6}},	//   _fungavak, _assavet_, _herarkiy, _全日本最靓的代言, 
   {{0xf2ec0152,0xac660187,0x2dd7032b,0x528702ef}},	//   _yubilee_, _огромнот, _نامزاتلى, _konkete_, 
   {{0xb292003e,0x22bf01be,0xf484015d,0x00000000}},	//   _lerato_, _oženil_, _आबकारी_, --, 
   {{0x2c8a0092,0xfdbf03ad,0xf8b101cd,0xcc1502be}},	//   _自己資本比率_, _addattat_, _эътикоди_, _manonood_, 
   {{0xb2480252,0x8e2d0059,0x95fd027b,0x00000000}},	//   _thoma_, _финансов_, _क्रोधेन_, --, 
   {{0x1aef02bd,0x1c650327,0x08150088,0x6f2d0313}},	//   _hystyrie, _montert_, _суранам_, _ravenwin, 
   {{0x548f0386,0x425a0014,0x02fe0189,0xf58a031c}},	//   _mengadak, _thelle_, _iktidar_, _identifí, 
   {{0x06ac04be,0xb48b01d1,0xea3b0025,0xecbc009b}},	//   _myoglobi, _memorial_, _अधिकृत्य_, _estatutu_, 
   {{0xff1e0093,0xccc5044b,0xdbcd0192,0x9b2102f6}},	//   _основных_, _forstå_, _영업소재지_, _kapansin_, 
   {{0x1bea0076,0xc20102a4,0xdd780060,0x0dbf0064}},	// [1820] _ориентал, _facias_, _ساربازىم, _redactat_, 
   {{0x425b004c,0xf320001e,0x7526024e,0xae52038b}},	//   _abagulum, _janyo_, _zabranio_, _dinaikka, 
   {{0x798f0087,0x7380014b,0x121c003f,0xfb760139}},	//   _anakanye, _derrel_, _dishom_, _विस्तारे, 
   {{0x26ca0386,0xc5080278,0x129204ca,0x1c0b00e6}},	//   _khususny, _አላልኩም_, _anuari_, _广东家丽石_, 
   {{0xe52800f3,0x77e50105,0xce8501cc,0x040e0445}},	//   _abuyekez, _शेवरले_, _antaḥpur, _chegando_, 
   {{0x2fe20307,0x59fa01d2,0xdc1502f6,0xbdb90086}},	//   _abazidin, _antisana_, _nanonood_, _maradhat_, 
   {{0x2e3802e7,0x00000000,0x00000000,0x00000000}},	//   _habagata, --, --, --, 
   {{0xd2490057,0xed9d02e3,0xa78800b3,0x54760061}},	//   _khamis_, _hellocha, _alamançy_, _과세표준금_, 
   {{0x73200138,0x531601a4,0x336500f0,0x73870239}},	//   _banyo_, _atoboli_, _strelmaj, _kauru_, 
   {{0xf9f900d5,0x2b15028f,0xd0d60299,0x8201011c}},	//   _fidirana_, _koropupū_, _توڭگۇزلا, _kayif_, 
   {{0xb25a054f,0xa613002e,0x565e0188,0x160502b2}},	//   _tajlaj_, _iskljuci, _филме_, _туалету_, 
   {{0x52e90150,0xbe500018,0xa65d01a3,0x51fc0105}},	//   _skripsa_, _siganima, _ويڪائو_, _parapety_, 
   {{0x97290388,0x0e3e038a,0x4472055a,0xd3270223}},	//   _добри_, _akrananp, _interino_, _урамтай_, 
   {{0xa3f40062,0x1af303c6,0x60400024,0xf20000bd}},	//   _bortas_, _delegaas, _গৱেষক_, _faain_, 
   {{0x339b0409,0xbb7400da,0x223801da,0xf27f0333}},	//   _こんばんは_, _реглемен, _mehmeti_, _apenti_, 
   {{0xe51405e5,0x320e01ef,0xbc520024,0x137f018f}},	//   _गर्दिश_, _раман_, _আৱদ্ধ_, _dalajha_, 
   {{0xbb8c007e,0xe4020153,0xe3870187,0x5c0f0064}},	// [1830] _anirjāta, _近畿日本ツ_, _bauru_, _congelac, 
   {{0xfcdf006d,0x6f8f0025,0x89db0318,0xcf8f02bb}},	//   _аспектах_, _अपेक्ष्य, _laufilit, _diamento, 
   {{0x23450233,0x24b40091,0x21520268,0x8f70003f}},	//   _caserne_, _nalautik, _abbleray_, _dihadnis_, 
   {{0xb8b603b0,0x32d8003e,0x8303021a,0xc37f016b}},	//   _landhand, _dikela_, _daranuu_, _halayya_, 
   {{0xa00902ea,0x66cf02e2,0xe17e0040,0x138601d9}},	//   _мерките_, _ardaggli, _קובייה_, _haerz_, 
   {{0xa29801b2,0x82e701c7,0x6e3f004d,0x335d0161}},	//   _purplish_, _altmyş_, _有馬的味道_, _воровств, 
   {{0x638603b4,0x831d017e,0x9f5c02a5,0x88cf00bc}},	//   _mberi_, _procedo_, _ब्लगर_, _الیکا_, 
   {{0xd47b00b5,0xd9b30066,0xdecb03c6,0x3eff03ec}},	//   _акалам_, _mendeare, _brazylje_, _servetit_, 
   {{0x62260191,0x620d0244,0xfc1502a2,0x825b00b0}},	//   _varken_, _позовава, _panonood_, _aqallo_, 
   {{0xbeb00029,0xa5be0137,0xc3f4008d,0xc67302fd}},	//   _ماشێنه_, _урагш_, _tortib_, _candleri, 
   {{0x12d8006a,0x4f6b0073,0x87a602d3,0x92d80087}},	//   _andevo_, _detalios_, _платежна, _jikela_, 
   {{0x938602e8,0x3ae50504,0x19e1003b,0x00000000}},	//   _aberi_, _अच्युत_, _kulofaka_, --, 
   {{0x12060156,0x7c1b0138,0x059900bb,0x22d80040}},	//   _פסיקתא_, _rakamlar, _یہوواہ_, _ההילוכים_, 
   {{0x6644020b,0xef30024f,0x27420052,0x3d9802fd}},	//   _dipolelw, _sinuniba, _स्थितिला, _phultana, 
   {{0x08db0032,0x127f025b,0x78fe0189,0x5fe80156}},	//   _bijeqchu, _spenti_, _perakend, _פערציק_, 
   {{0xf1fc0032,0x7dd20084,0x3d83008d,0x00000000}},	//   _bivalmeh_, _banjarwa, _жунбушга_, --, 
   {{0x99040203,0xddde0188,0x8dbc0176,0x838602e1}},	// [1840] _cavallyu, _талабҳои_, _genstand_, _tsiria_, 
   {{0x92da000b,0xc6450276,0x1bcd014f,0x12d8048f}},	//   _iosefa_, _електир_, _народног_, _bikela_, 
   {{0x13a300ce,0x9cdd0213,0x510300f3,0xfdf80333}},	//   _prepar_, _родитель, _abakhwel, _credenze_, 
   {{0xbc3303ed,0x232003da,0xc9520258,0xc00c0207}},	//   _benefíci, _ganye_, _besleatt, _سانجھيءَ_, 
   {{0x12fc0200,0xcb820044,0xdb0e036e,0x00000000}},	//   _kwaga_, _grandpar, _chupanta_, --, 
   {{0xea020080,0xd8bb0290,0x8b000184,0x00000000}},	//   _atussagu, _concepì_, _ugusenye, --, 
   {{0xd3200129,0xf271022e,0x02ff00ab,0xc2fc017d}},	//   _banye_, _mancherà_, _eriahipi_, _svagt_, 
   {{0xade50046,0x246c0061,0x42c500dd,0x00000000}},	//   _алынчу_, _카시오페아_, _moelfre_, --, 
   {{0x96f0004d,0x99c60217,0x10fa0235,0x425a00e0}},	//   _江課長長流_, _totement, _अपेक्षे_, _skelle_, 
   {{0x1f42036d,0xf06e042c,0x00000000,0x00000000}},	//   _cairibia, _državnoj_, --, --, 
   {{0x3f1f00a7,0x494b04e3,0xf3200037,0xa371018a}},	//   _segureta, _punoljet, _tanye_, _deialog_, 
   {{0xe2450366,0x8b80001a,0x937f0227,0x8200022a}},	//   _плотност, _قربانیاں_, _dadanya_, _nomiko_, 
   {{0xe248029e,0x7a7c000d,0x2f370056,0x00000000}},	//   _chome_, _kannatus, _babulala, --, 
   {{0x82a000fc,0xc10c01db,0x69c7034c,0xc2cf0395}},	//   _chijchu_, _базарлық_, _табалар_, _nedojde_, 
   {{0xf9ec0162,0x56c6002b,0xa2f30037,0x52da0198}},	//   _кичикинә_, _হ্নীলা_, _kelibat_, _dosega_, 
   {{0x22d80292,0xf2e7007b,0x09f80053,0x00000000}},	//   _ankeka_, _flannen_, _liliyana_, --, 
   {{0xe38600ed,0xc2000105,0x8162008d,0xfa1b00cb}},	// [1850] _faery_, _pomimo_, _mansabdo, _amabhane, 
   {{0xd4200192,0x92900281,0x09ab004d,0x918d0255}},	//   _개인정보는_, _arnap_, _文史哲出版社_, _बछ्वा_, 
   {{0x739400ef,0xc27e00b6,0x9e1a016f,0xa05701e8}},	//   _amesa_, _iyeni_, _nyhetska, _makabato, 
   {{0xe4f700a4,0x7e8e0061,0xec170013,0x729600cf}},	//   _بالاساعى, _안전검사를_, _forumdos, _bekkamu_, 
   {{0xd2780247,0x41410046,0x72f10331,0x00000000}},	//   _batnah_, _lustrado, _høgan_, --, 
   {{0x3ed30203,0xf277038e,0xfff10025,0x2d8f0071}},	//   _manieres_, _sahabatm, _निर्देशो_, _diilanga, 
   {{0x027e014c,0x3bd7003c,0x43790453,0xb32002f9}},	//   _myeni_, _غدیرخم_, _ustanka_, _panye_, 
   {{0xf24804ce,0x2b8a033e,0xf54d02ee,0x638000b6}},	//   _thome_, _зотов_, _privatez, _xayrâ_, 
   {{0x3c770538,0x429100a5,0x56f40132,0x6e7103d0}},	//   _kristne_, _agaaga_, _mestersé, _ročnik_, 
   {{0xe212023b,0xb96400ce,0xde560057,0x42ec0157}},	//   _dubhe_, _konstrir_, _membimba, _turniej_, 
   {{0x35860251,0x8a600223,0xaaf401bc,0xf41c00ff}},	//   _raadinay, _айхтар_, _federaas, _antarkto_, 
   {{0x94ae0012,0xf1bb0219,0x1c780100,0xa7c7006c}},	//   _चहुँदिस_, _bhóngwan, _ulaskom_, _баршумур, 
   {{0x327e03b4,0xe75300ef,0x3653017a,0x04b300ba}},	//   _bennie_, _abangeng, _abangenw, _زمزیران_, 
   {{0xec6600ed,0xa11d003c,0x00000000,0x00000000}},	//   _inetres_, _محلتبلیغ, --, --, 
   {{0x339402ab,0x4bdd015e,0x637a0547,0x69820153}},	//   _emesi_, _privades, _cigarro_, _お楽しみに_, 
   {{0xfd1305f1,0x66390176,0xeea601cc,0x8c690340}},	//   _bakomeye_, _shinichi, _avalokan, _mutuahi_, 
   {{0x206e042c,0x9d9e0282,0x93a3022b,0xe2da02fb}},	// [1860] _državnom_, _hekeheke_, _drepur_, _kupesi_, 
   {{0x55980046,0xd1580195,0x537f0006,0xa4030128}},	//   _саламатс, _aigneadh_, _padanya_, _سئچگی_, 
   {{0x52ba042b,0x83940553,0xea7d0184,0x637f0307}},	//   _ponekad_, _zmesi_, _kunagura_, _salapha_, 
   {{0x075b0091,0x66b9012c,0x528300db,0x8567002b}},	//   _ukunatig, _kukadiri, _hankida_, _জলাশয়ে_, 
   {{0x62310096,0x3373000b,0x19f4001a,0x75670019}},	//   _ahumeka_, _lanumeam, _humán_, _англияга_, 
   {{0x23f40417,0x52d80464,0x02fc0054,0xcb6a0332}},	//   _partye_, _indero_, _cingam_, _reducida_, 
   {{0x037f0402,0x82780274,0x355400de,0x2c0e033d}},	//   _galanya_, _grunni_, _azikatsh, _epapiye_, 
   {{0x8a5a002b,0x210b03f0,0x00000000,0x00000000}},	//   _বিশ্লেষক, _fiskibol, --, --, 
   {{0x674300ff,0xe4e700e6,0xa290037f,0x00000000}},	//   _טאלנא_, _闂傚倸鍊搁崐鎼佸, _gunay_, --, 
   {{0x67bc022a,0x1f63047d,0x8b1002e1,0x5a45018b}},	//   _badereig, _erwaards_, _rósanna_, _cladirea_, 
   {{0x514b018d,0x506f04bd,0x0a5f02a0,0xe2910062}},	//   _ንሓሙሽተ_, _kalanimo, _edegbeta_, _ervam_, 
   {{0x79d6039f,0xd2910296,0x02fc00d5,0xaaaa004d}},	//   _molecule, _urval_, _singam_, _本封感謝清清郵友, 
   {{0xec5d00c5,0xd26d0230,0x1553006c,0x76460095}},	//   _功成名就闯大都_, _defons_, _abakweth, _anginguw, 
   {{0x226c00f2,0x93870325,0x0e5f0429,0x0c750197}},	//   _nedod_, _aparsa_, _lembutka, _paquiot_, 
   {{0x83760368,0x8d17039e,0x6aa801ef,0xc27e0026}},	//   _простор_, _kunstnar, _mergaitė_, _avonds_, 
   {{0x5320022c,0xd387001c,0xac7d02dd,0x4bed0213}},	//   _nanya_, _agarun_, _chircop_, _районное_, 
   {{0x032004e2,0x5728023c,0xec740040,0x527e0163}},	// [1870] _ianya_, _اوژوبل_, _examined_, _tennie_, 
   {{0xc44601f6,0xf2a60095,0x6c220326,0xc373029b}},	//   _এক্সপ্ৰে, _aanjani_, _asiriris, _kanamee_, 
   {{0xc4b40250,0xe9ea01db,0x62d70244,0x435e00bc}},	//   _artikull_, _شىققام_, _rotondo_, _digunaké_, 
   {{0x4da50268,0x847d0219,0x9404023c,0x00000000}},	//   _insidewa, _ayifanek, _awunyanz, --, 
   {{0x938600ad,0x1e3d048a,0xd2fb03be,0x629001c5}},	//   _pairan_, _ازعىرۋىن, _bishira_, _cunay_, 
   {{0x04af01fc,0xf2d5012c,0x23b70059,0xbf63008a}},	//   _anninnal_, _maalumu_, _trovano_, _mamanuin, 
   {{0x2b170092,0x1c6502d8,0x9fab04a5,0x53f40005}},	//   _hamamats, _tertuju_, _ngamakho, _custab_, 
   {{0xf2900410,0xfc8004ac,0xcf3b033f,0x03860288}},	//   _mejako_, _однознач, _hengihen, _wairan_, 
   {{0x018703db,0xde8b0162,0xfc6701ac,0x00000000}},	//   _nezahlul, _زەنجىرسى, _خرفان_, --, 
   {{0x06370068,0x8c61013c,0xd2f10109,0x7af501d5}},	//   _barnaami, _yuxudan_, _zemanovi_, _koromban_, 
   {{0x22da00fe,0xaa8f009b,0xe437036c,0x00000000}},	//   _kosema_, _familian_, _faranako_, --, 
   {{0x5cba00bf,0x8202015e,0x6ac90211,0xf93600bb}},	//   _предприн, _fruita_, _parvekke, _لڑکپن_, 
   {{0xebe6022d,0x741b0010,0x253303f2,0x4a0200aa}},	//   _dialetto_, _bemikhak, _непредск, _macrobiu, 
   {{0x325a064d,0x76ef0040,0x49cf0220,0x8e0a0407}},	//   _hoolaa_, _ומטאל_, _violenza_, _tvrdogla, 
   {{0xa34700ee,0xdb8d0090,0xd3200102,0x7d020021}},	//   _bulegoa_, _akanunur, _fanya_, _apsulesc, 
   {{0xf8f905f8,0xcd87018b,0x11fc00bc,0xf2ff00b3}},	//   _многих_, _conectat_, _اقتداری_, _beriler_, 
   {{0x10d1028b,0xe3860309,0xee0103b7,0x00000000}},	// [1880] _acusatór, _faizini_, _eakerbra, --, 
   {{0x838701e5,0xc15401d3,0x00000000,0x00000000}},	//   _aburo_, _arbetspl, --, --, 
   {{0xdea402d0,0xb90a0037,0xc753023c,0xae530193}},	//   _likeness_, _የሚፈፀም_, _abaneeng, _kekalaha, 
   {{0x58e802b0,0xa04700ef,0x13f80220,0x02b20066}},	//   _leistung, _رفسنجاني_, _friuli_, _mendian_, 
   {{0x48c90137,0x4b6704fb,0xe2830334,0x00000000}},	//   _финлянды, _comentan_, _kuphiri_, --, 
   {{0x72fc006e,0x6f4f0026,0x00000000,0x00000000}},	//   _lingom_, _stappenp, --, --, 
   {{0xa0ea0056,0x7b37012b,0xc9aa00e6,0xdf2103ac}},	//   _вазифаҳо, _narciars, _在此基础上_, _tertinda, 
   {{0x86060458,0x6c6500c9,0x8a730039,0xe38702a0}},	//   _sammenli, _vietpet_, _banaketa_, _gburo_, 
   {{0x7224005b,0xa47d02d8,0x03fa024f,0xb2000318}},	//   _renka_, _diresmik, _votuka_, _oaaia_, 
   {{0xd2f702df,0x4cfc0037,0x8a8f0277,0xf721026c}},	//   _kalimah_, _ስለሌላቸው_, _namibian_, _extremum_, 
   {{0x9af40120,0xc41b014c,0x02e8036c,0xc21c003a}},	//   _abbootan_, _leminyak, _tahirin_, _yashil_, 
   {{0xd2000318,0xc5fb0615,0xb2ef0275,0x23fa02e4}},	//   _aaaia_, _karadžić, _piliona_, _intuza_, 
   {{0x9ec40190,0xd25a02b2,0x69c7043a,0x177b018d}},	//   _drunkenn, _hjelpe_, _hotentot, _ንመዝሙር_, 
   {{0x5bb600c5,0xdc6300d0,0x727e0120,0x6ecb024a}},	//   _如擅自篡改为_, _торгоны_, _liinoo_, _inunibin, 
   {{0x60ef0071,0xc2f00082,0xbeba0257,0x96850420}},	//   _دستتون_, _hadisai_, _einstakt_, _русите_, 
   {{0x9959040d,0xa92f02fe,0x204e0291,0x00000000}},	//   _boporofe, _استعمالې, _مسجّلة_, --, 
   {{0x40e700c7,0xc246007e,0x13f80377,0x00000000}},	// [1890] _агентлыг, _केवली_, _excursii_, --, 
   {{0x61860324,0x73100206,0x122b05f4,0x45e1020f}},	//   _ababonel, _kurzov_, _badmime_, _اشډاون_, 
   {{0xf0130532,0x6c0900b4,0xc2320159,0xd8d3026f}},	//   _zatvaran, _aluminiu_, _rotušės_, _سارنايدى_, 
   {{0x2ec700ec,0xb29203ad,0x01fc011f,0x00000000}},	//   _краязнаў, _ifakkar_, _karapety_, --, 
   {{0xc3030360,0x92f70227,0x984a0204,0xc30202cd}},	//   _hazardu_, _walimah_, _соски_, _hakarsu_, 
   {{0x930c028e,0x625b04bb,0x750f012b,0xec8000f5}},	//   _parasut_, _sablaj_, _agrotury, _җедел_, 
   {{0x274000c5,0xd33200c5,0x0efd02d3,0x42fc0344}},	//   _发言时请遵守注意, _中国轻工业网_, _позитиве, _allatasi_, 
   {{0x7bf6040f,0xf54b0035,0x82fb014d,0x5555033e}},	//   _studentų_, _marşrut_, _sichern_, _думахь_, 
   {{0xa472002c,0xe29200c9,0x357a005e,0x23cc0354}},	//   _импортло, _vitalk_, _ﺩﻩﺭﮬﺎﻝ_, _سەرسانلى, 
   {{0xd7c301b9,0x9c6f0243,0xd20204f8,0x00000000}},	//   _apersevw, _qalulih_, _basins_, --, 
   {{0x353400be,0xd2fc014a,0x724a000e,0x4c27006f}},	//   _اسماندان_, _blogok_, _elsman_, _خاطريءَ_, 
   {{0x45b003b5,0xf6b001b0,0xafb40478,0x790e00d1}},	//   _bangsany, _bangsani, _centraus_, _সুদীৰ্ঘ_, 
   {{0xdfd6016d,0x52910318,0x6c6004ca,0xf32702f3}},	//   _картнер_, _faaava_, _neutres_, _blocket_, 
   {{0xc61f002f,0x5fae00d9,0xf1bc0135,0x00000000}},	//   _chinkari, _autovero, _kiterelä_, --, 
   {{0x9f02023c,0x6a1e0164,0x12f10153,0xb96d0233}},	//   _ددوهم_, _чижин_, _nøgen_, _suficent, 
   {{0xa853011b,0xea4a00be,0x8da10111,0x37d000d7}},	//   _echanger_, _تىلككقە_, _affrontu_, _знагы_, 
   {{0x9de6015e,0x3f950152,0xe2240181,0xe778005e}},	// [18a0] _اعىنى_, _nindider_, _kenko_, _ﺋﻮﻟﯩﻤﭙﯩﻚ_, 
   {{0x49af0040,0xb975016e,0x73960416,0x227f0140}},	//   _גמילה_, _teknikle, _bussol_, _ayuno_, 
   {{0xec250028,0x837903e2,0x658700ff,0x73440129}},	//   _اخبارچھُ, _usuaria_, _נאכשרייע, _rubeere_, 
   {{0x4366033d,0x09d50497,0xe2990144,0x6b1802af}},	//   _brignol_, _antenupt, _fhinné_, _kunganis, 
   {{0xb1e30061,0x8c650367,0x92120315,0x93720432}},	//   _대전영어학원_, _daquele_, _cubha_, _aagaard_, 
   {{0x22ba0077,0x5974009b,0xf29000b7,0xf2bc054a}},	//   _annegad_, _албууд_, _ahmal_, _uradimo_, 
   {{0x738603a7,0x22260014,0xa3980374,0xed3e0061}},	//   _vcera_, _barkun_, _каналлар, _명품스타일_, 
   {{0xbab8046a,0x003a00e4,0xfe52021a,0x2c65036b}},	//   _paramètr, _wirtualn, _barbaree_, _naquele_, 
   {{0x15910003,0xe3ea0170,0x09fd0110,0x4773014e}},	//   _안녕하세요_, _anhtu_, _nesaprat, _игара_, 
   {{0xaba70092,0x90e7037f,0x3d9f0099,0x39f800d5}},	//   _時間以内に発送_, _istinadl, _chengara, _filibana_, 
   {{0x62e804e7,0x18dc02ac,0xa57502ea,0x372500f7}},	//   _milión_, _تشجيع_, _contesto_, _עובדא_, 
   {{0x6a0f0067,0xd9d90277,0x02d10059,0x220101f4}},	//   _abaabile, _espesime, _ветровит, _mayin_, 
   {{0xeb0f00bc,0x1201016b,0xc3c300bb,0xdecd007b}},	//   _waypoint, _layin_, _اُتار_, _dreiders_, 
   {{0x6ef00051,0x76f7046b,0xfc5a04ab,0xd81e02b6}},	//   _miljonus_, _pencampw, _sjetiti_, _маскүнем_, 
   {{0x2b820003,0xf27e045a,0x075302fc,0xaf3f00ad}},	//   _standaar, _byens_, _abanyeng, _sanghyan, 
   {{0xd7ba0440,0x7af00192,0xb2d80224,0x91280311}},	//   _rukuriki, _구매평가를_, _akkeri_, _ተኣኪብና_, 
   {{0x4cc00024,0xc2240172,0xea1502af,0xd3540014}},	// [18b0] _বিদ্যায়, _yenko_, _kiranuma_, _recetat_, 
   {{0x28f9019e,0x4b0100f7,0x71c700be,0x3a850195}},	//   _антоній_, _lipschit, _دارتىن_, _einnsean_, 
   {{0x16b703a1,0x32910275,0x0fd700f5,0xd2ea025e}},	//   _шампион_, _faaata_, _тапгыры_, _girnist_, 
   {{0x1dc601e5,0x92010028,0x72900230,0x69f2009a}},	//   _botileje_, _dayin_, _zimaz_, _beengoma_, 
   {{0xc53a02fe,0xec1c000d,0xd7e400c1,0x82780372}},	//   _تصویرونه_, _smartpos, _कोथरूड_, _eluned_, 
   {{0xb3950097,0x3779045b,0x49320291,0x8c6a03f1}},	//   _imuse_, _trekning, _بإرفاق_, _rakusku_, 
   {{0xb913001c,0xfa890171,0x6c53030b,0x82900119}},	//   _macarthu, _izazvala_, _akutama_, _limay_, 
   {{0x89590318,0xd2540209,0x62240259,0x31b200d1}},	//   _fetongit, _algeriam, _senko_, _ইয়েৰ_, 
   {{0x42fe019a,0x9fb000c5,0xf9fb022b,0xd2010054}},	//   _purged_, _lecteurs_, _starvinu, _hayin_, 
   {{0x0d5a023d,0x38630435,0x7201001e,0x962b03f0}},	//   _модел_, _додали_, _bayin_, _afmarkað, 
   {{0x335f0193,0xab6100aa,0x364000fe,0x0ecd0153}},	//   _अस्पृश्य, _rollover, _hisitoli, _リストに追加_, 
   {{0x03870286,0xc78a016d,0x2d2d016e,0xe290004f}},	//   _asaria_, _заманини, _bisiklet_, _bimay_, 
   {{0x5147010f,0xea2f0092,0x1a130244,0x29de008b}},	//   _васила_, _ドを忘れた方_, _maschera_, _fransuwa_, 
   {{0xe4130208,0x1b3501d1,0x99820101,0x460101f2}},	//   _بانده_, _establis, _постур_, _җимҗит_, 
   {{0xe387028f,0x5213033f,0x32910551,0x52240176}},	//   _rauru_, _eeehaa_, _irvan_, _renko_, 
   {{0x8d1d0025,0xd285004c,0x021700d9,0x827f0247}},	//   _वैयक्तिक, _abakung_, _сигнала_, _ayune_, 
   {{0xf037023d,0x937c00a5,0x922e0061,0x0c31014a}},	// [18c0] _settiman, _faraile_, _부탁합니다_, _tanuló_, 
   {{0xe2010054,0x82d60253,0x1278008d,0x1261010d}},	//   _yayin_, _villads_, _sahifani_, _प्राजक्त_, 
   {{0xe290033f,0xc9d900ee,0x12a6042b,0x5af901a1}},	//   _mamani_, _esperime, _probao_, _reinigen_, 
   {{0xb2cb02cb,0x48c501cd,0x2568032d,0xc15e0092}},	//   _razlozi_, _мукааб_, _регуляр_, _とネット長野_, 
   {{0x8290005b,0x4b6900bd,0xbb540285,0x713101db}},	//   _mimax_, _screamin_, _abamotar, _جەتپەس_, 
   {{0x12910189,0x3eae0125,0x3373026a,0xc2da02e7}},	//   _hayata_, _kellesin, _gagadre_, _dosena_, 
   {{0x429100bc,0xdaef005a,0x8db9010e,0xa8fa0137}},	//   _kayata_, _dilehnes, _dinampot_, _aitatasu, 
   {{0x3291064e,0xb29101b8,0x127f0207,0xbc7c0003}},	//   _jayata_, _arvan_, _mpenzi_, _janssen_, 
   {{0xf5f90037,0x7e54023d,0xeb5702a0,0xb4a002e5}},	//   _ኮንፌዴሬሽን_, _finanzia, _fátinipa_, _diezmado_, 
   {{0xb290012c,0x52010292,0x022402c2,0x9d3f021c}},	//   _jamani_, _payin_, _wenke_, _neplatít, 
   {{0x1e6c0207,0x52900312,0xe40e0090,0x00000000}},	//   _زینوا_, _damani_, _chegondo_, --, 
   {{0x249c02af,0xd38700ea,0x83fa033f,0xa2d8019b}},	//   _bakarenz, _asyria_, _lotuma_, _visokiu_, 
   {{0x3d9c015d,0xae1204dc,0x329504f2,0xbc010040}},	//   _kolekcje_, _بگرنه_, _vinaxuki_, _הכרזה_, 
   {{0xf17500ce,0x52a0012c,0xd4a702b2,0x4e3600a6}},	//   _konpasyo, _ukubwa_, _банками_, _angundoq, 
   {{0x42da0212,0x638700a9,0x7d0302ac,0x51bd028a}},	//   _altero_, _mbura_, _عدوان_, _ukombozi_, 
   {{0x027b01b8,0xac4d03ab,0xd387007b,0x5303004f}},	//   _mustamäe_, _kravaty_, _caurs_, _estaaru_, 
   {{0x8201019a,0xf2da0369,0x605402e2,0xa37800b7}},	// [18d0] _sayin_, _gosena_, _abysseen, _bahadan_, 
   {{0xfc710255,0x2a060071,0x662000ae,0x19fb0080}},	//   _मार्गी_, _ابراهیمی_, _akanyari, _allagaat, 
   {{0x52b901b2,0x9a0700b9,0x331f05f4,0x6f4600d9}},	//   _ainelag_, _jamannya_, _chicham_, _maksanut_, 
   {{0x93870292,0x62250243,0xc27f036e,0x86b20071}},	//   _abura_, _amaksa_, _ananao_, _bengkali, 
   {{0x0c780257,0x3501044a,0x27840156,0x9c680153}},	//   _flestum_, _bakristo_, _נאבעלע_, _terræn_, 
   {{0xf278014c,0x66b501a4,0x822403dd,0xbf21003d}},	//   _uluntu_, _botambwi, _shoket_, _apilerar_, 
   {{0x72fe02ff,0x2e28015e,0x73af00b5,0x2f6b0073}},	//   _dechire_, _favorits_, _consonán, _retalios_, 
   {{0x32c505ce,0xd27e0132,0xb291030b,0xabf6004b}},	//   _filmler_, _lennie_, _agaana_, _марттың_, 
   {{0x8646047b,0x97d5027e,0x2a140216,0xf4310193}},	//   _bakkanum_, _смеру_, _masalela_, _प्रयत्नह, 
   {{0x8b6b05b8,0xd26c0022,0xd2da0132,0x50640145}},	//   _annonser, _arnone_, _motoros_, _невельск, 
   {{0x32a6005b,0x526d01a0,0x5d19006e,0x52c50189}},	//   _kanban_, _exhikari_, _diangate_, _hileleri_, 
   {{0x1c66044a,0x92e70265,0x13860456,0xe2fc03d9}},	//   _miettes_, _plannen_, _hairan_, _aingam_, 
   {{0x23ea00fd,0xdc6d0270,0xba340273,0x6d3a02e0}},	//   _alltan_, _aperiva_, _eficacia_, _dirisane_, 
   {{0x64a900be,0x18c801db,0x56d0033f,0x72020344}},	//   _تىلمەچ_, _таратылу, _makamimi, _atukkasi_, 
   {{0xca180093,0x1291031c,0x7ec6001c,0xc3870163}},	//   _местах_, _debajo_, _colonels_, _nyerni_, 
   {{0xb290012c,0x02aa0418,0x251f0037,0x396003c2}},	//   _zamani_, _kapsamın, _የገበሬዎች_, _remotene, 
   {{0x02f700d2,0x204a038a,0xc2900049,0x23eb0574}},	// [18e0] _abdimah_, _charasan, _mamali_, _lopti_, 
   {{0x52910130,0x303b02c0,0x00000000,0x00000000}},	//   _ervat_, _станале_, --, --, 
   {{0xa2a6005b,0x38150037,0xe2c50418,0x00000000}},	//   _banban_, _ለመፈተሽ_, _aileleri_, --, 
   {{0x7044008a,0x92b30185,0x82f30003,0x46cf00e4}},	//   _agafesoo, _формаль_, _russisch_, _wyobrazi, 
   {{0x5290017f,0xa09a0061,0xe219002f,0xe34a064f}},	//   _tamani_, _진상규명법_, _chakranm, _panenku_, 
   {{0x475a0144,0xe307003c,0x2162064f,0x00000000}},	//   _tiontaig, _cambang_, _suprapho, --, 
   {{0x4ed605c1,0x3290019f,0x42fc003f,0x042f0189}},	//   _dilindun, _ramani_, _dangil_, _sosyoloj, 
   {{0xc2de02a5,0x43400087,0x80b6027b,0x3d3a004d}},	//   _ponorku_, _mafenya_, _ण्वुल्_, _係經斟酌年度_, 
   {{0x97b503f8,0xf26c0013,0x52ba0130,0x724804bd}},	//   _bolehbog, _olloh_, _annezad_, _kaomi_, 
   {{0xc2020650,0x12da0334,0xc22600bd,0x5ee70056}},	//   _nasiib_, _motero_, _harkin_, _табаров_, 
   {{0x93ba0132,0xb93e0040,0xcdc40095,0x8f260151}},	//   _privát_, _מוצלחים_, _جنگلهای_, _barranta, 
   {{0x4d16004b,0x92900456,0xd60d00ac,0xa29100a6}},	//   _минутҡа_, _cheah_, _školarin, _bezayo_, 
   {{0x88cc006d,0x2eac0016,0xf367014e,0x026c0195}},	//   _контурна, _mezorien, _керамике_, _sheoid_, 
   {{0x4b350106,0x34ab021c,0xbfb8029f,0x727e0407}},	//   _अब्बास_, _keramick, _posledno, _ukinuo_, 
   {{0xa290023b,0x7a14025f,0x2f4400e7,0x00000000}},	//   _kamali_, _basalela_, _arishesp, --, 
   {{0xd0dd0141,0x2e0501b4,0x527e042c,0x34b00297}},	//   _تیتره_, _handelaa, _skinuo_, _başlawğa_, 
   {{0x22b3034d,0xad7f0169,0xce230651,0x42910076}},	// [18f0] _saudara_, _হাবিবুর_, _प्रौढ_, _ervas_, 
   {{0x32a700b7,0xda4700cd,0xd5de021c,0x47be0207}},	//   _harby_, _alpestra_, _hotelový, _مصنفن_, 
   {{0xbc9603c2,0xcd6301d7,0xec0100a6,0x28480311}},	//   _confound_, _procurau_, _غلودانو_, _ክትሓልፎ_, 
   {{0xd3f90085,0x82bb0202,0xa3fa0251,0x73dd0119}},	//   _drauni_, _firipò_, _intuba_, _naawat_, 
   {{0x22240172,0xf2fc006f,0x02900262,0x32a60652}},	//   _menka_, _مشغلو_, _akmak_, _manjini_, 
   {{0x121a015d,0xbe140452,0x62720329,0xc69400b7}},	//   _एकदिवसीय_, _pemesana, _endividi_, _adatlary, 
   {{0x22ca0048,0x9c1400bd,0x43dd013b,0x5e9d019b}},	//   _abalimi_, _classix_, _kaawat_, _kasmetin, 
   {{0xf99803a7,0xa6390226,0x62000054,0x80f400d1}},	//   _akože_, _akanachi, _hidima_, _ককাদেউতা_, 
   {{0xa27201b9,0xaa8f0108,0xed00025c,0x2f9802ac}},	//   _individi_, _kuningan_, _herunter, _توتنهام_, 
   {{0x7ee70102,0x17050187,0x00000000,0x00000000}},	//   _alikutan, _ventilaç, --, --, 
   {{0x4cee014e,0x7b6100f1,0xc06e036f,0xd2910205}},	//   _америку_, _ansenyan_, _državnog_, _bebaho_, 
   {{0x05260076,0x1aef0176,0x12f0012c,0x1a450282}},	//   _carrinho_, _sleeples, _bilioni_, _ripeneta_, 
   {{0xc3870387,0x02910255,0xa80c0291,0x0d8f0289}},	//   _oburu_, _arvas_, _ويوفقك_, _chilanga, 
   {{0x5200039d,0x29f801fe,0x722a008d,0x6542020f}},	//   _gidima_, _daligana_, _мотам_, _لوکزامبو, 
   {{0x12a70206,0x069803b7,0x3dcb0559,0x56d70125}},	//   _farby_, _abitualh, _abahamba, _кувватда, 
   {{0x2e30023e,0xf4b8012a,0x01c80359,0x4224005b}},	//   _panggina, _proponuj, _republyk_, _genki_, 
   {{0x339501cd,0x62b301ac,0xbdf802ea,0xcc7600e4}},	// [1900] _umusa_, _cumarsái, _пенсии_, _szeregi_, 
   {{0xc8730269,0xd34003f3,0x297700e2,0x7394029e}},	//   _procesar_, _beheren_, _fernimme, _daosut_, 
   {{0xd08a01bb,0xf224006f,0x448802c2,0x0ec404c7}},	//   _принципл, _benki_, _vergelyk, _бескрајн, 
   {{0x838702ec,0xf29100f4,0x23870200,0xa6f201f2}},	//   _saaran_, _arvar_, _eburu_, _чоңрақи_, 
   {{0xa38704a8,0x12240176,0xf354011d,0xd8d601ad}},	//   _povrat_, _denki_, _decedat_, _kapunong, 
   {{0xe3ad0030,0xa2e8023b,0xdc1a030d,0x3394012d}},	//   _tāpat_, _heenalu_, _basqın_, _miksim_, 
   {{0xb276029c,0x8c710222,0xd3720230,0x63870129}},	//   _achikazi_, _endroit_, _dilapid_, _iburu_, 
   {{0x42da019d,0x8e1d0244,0xf723031c,0xd387005d}},	//   _potero_, _potenzia, _depresió, _emosaram, 
   {{0xaaea00c4,0xae370108,0x237c02ff,0xd2910076}},	//   _ٽيليويزن_, _kajahata, _detache_, _luvas_, 
   {{0x027f009c,0xc33d006d,0x7a880452,0x9387006e}},	//   _uyuni_, _ажыўленн, _webiklan_, _mburt_, 
   {{0xd19a00bf,0x3e380338,0x4355000b,0x7fe20553}},	//   _жизненно, _rivalita, _elifasa_, _zatepľov, 
   {{0xe6830105,0x3c6500d1,0x6348000f,0x032201d3}},	//   _मेवात_, _অনুশীলনৰ_, _bedelli_, _stryka_, 
   {{0xeae9007e,0xa40a02da,0x6abd0107,0xd2d701d9}},	//   _सर्वशूर_, _economiz, _لیندا_, _erklär_, 
   {{0x526c0049,0x417e022e,0xd88c012c,0xd032015d}},	//   _koloa_, _campagno, _mashambu, _बगाहे_, 
   {{0xadbd00b5,0xaf25033e,0x00000000,0x00000000}},	//   _aitereív, _casellan, --, --, 
   {{0xe38700b6,0x175305db,0x5e170362,0xfe5d01ef}},	//   _aburu_, _abanjeng, _bamemama, _матчы_, 
   {{0x626c023b,0x42000007,0x4eae017e,0xdc6803e0}},	// [1910] _loloa_, _bilima_, _anglalin, _boursen_, 
   {{0x022402b9,0x026c0465,0x7b500046,0xec68013a}},	//   _senki_, _celoti_, _disminuc, _coursen_, 
   {{0x4332002e,0x795404e5,0x07eb00e6,0x126c01f0}},	//   _održano_, _akulembe, _被拆迁人或者房屋, _goloa_, 
   {{0x939503bf,0xa1080318,0x82f00055,0x7c0b015e}},	//   _mmuso_, _anakival, _indiani_, _disposa_, 
   {{0x7778022f,0x0de40052,0xcc2800ba,0x27470364}},	//   _мансарда, _मध्येको_, _فێرخوازا, _faszinei, 
   {{0x2200006c,0x00000000,0x00000000,0x00000000}},	//   _simiso_, --, --, --, 
   {{0xd30300dc,0x4afd01f9,0x5a1402c9,0x00000000}},	//   _atuatau_, _atsetsis, _plictise, --, 
   {{0xb84a0014,0x130903cc,0x48140046,0x726c0058}},	//   _እናበለት_, _তথ্যকোষ_, _بئنادان_, _kelosi_, 
   {{0xe2fc01d3,0x8f32005c,0xef31020f,0x020001e9}},	//   _skrivet_, _abafaran, _akusakwa, _didika_, 
   {{0x4c4401f2,0x672e0040,0x52010445,0x00000000}},	//   _ﺳﻮﯞﯦﺖ_, _תובנות_, _queima_, --, 
   {{0xdc5200d1,0x7eac03ea,0x85c30092,0x9a8c0416}},	//   _বৃক্ক_, _certaine_, _今日の晩ごはん_, _facilmen_, 
   {{0xe87e00ff,0xb4f8014f,0x23f500e6,0x72d8041e}},	//   _סלאָװעני, _ђуканови, _董卿操劳过度脸被, _allevu_, 
   {{0x21b3014a,0x97b40639,0x33f40415,0x0e3b010b}},	//   _نادرا_, _menerang, _erstes_, _boramara, 
   {{0x59fb0080,0x96f702bd,0x59f900d5,0x9d2701de}},	//   _allakaat, _bencampw, _andikana_, _иранды_, 
   {{0xbaf801fe,0xd61b0080,0xbbc10109,0x837f003d}},	//   _katubale, _alannavi, _boskovic, _camarga_, 
   {{0x79c000de,0x29860219,0x026c0020,0xc760003e}},	//   _babephet, _ciniseka_, _seloti_, _бергє_, 
   {{0xc5780219,0xa7530397,0xbfe20271,0xc2da023e}},	// [1920] _atawunik, _abanceng, _variasjo, _gepeng_, 
   {{0xe543019b,0x2b000073,0x08e90094,0xc2b9005b}},	//   _atsisaky, _consumit, _қайтаруд, _kogebog_, 
   {{0x826c00bd,0x0290011f,0x52ae03d0,0x3a310208}},	//   _alloo_, _cheao_, _kazališn, _کیترین_, 
   {{0x33d80064,0xb76100ba,0x00000000,0x00000000}},	//   _дарбазас, _پڕشنگی_, --, --, 
   {{0x6e480122,0x068002d5,0xbaf20217,0x0e340544}},	//   _mohaseba, _krediidi, _ascribit, _kahalewa, 
   {{0x82ca0245,0xdc2b0037,0xed0001e1,0xcc2300f4}},	//   _mynder_, _ውድነትና_, _ditlhare_, _brastres, 
   {{0x42910418,0xe85d04c4,0xebea018d,0x684b023c}},	//   _duvar_, _tunnustu, _ንኣህዛብ_, _anamashu, 
   {{0x215801d1,0x064200cb,0x88fd0272,0x5200022f}},	//   _attorney_, _abanabaf, _babatend, _vilija_, 
   {{0xbd9d03b9,0x78cb018d,0x1913018f,0x4363012a}},	//   _millucha, _ንምእላዩ_, _daladchu, _drogach_, 
   {{0x6278014c,0xe5070238,0x84450204,0x73870128}},	//   _ilungu_, _кредиту_, _свободны, _hayron_, 
   {{0x26a7046d,0xd3780095,0x18a4005e,0x04320204}},	//   _kanganyi, _kahanan_, _немишқим, _naapurin_, 
   {{0xd846005b,0x79c80340,0x02c7053e,0xe1230078}},	//   _glamorou, _motoreta_, _enslige_, _неименов, 
   {{0xa9f60653,0xee990315,0x00000000,0x00000000}},	//   _altán_, _kubukiwe_, --, --, 
   {{0xb3f404bb,0x821d0125,0xf21b01af,0xc60c011a}},	//   _tustub_, _мабуд_, _alaymaly_, _unconsti, 
   {{0x2200020e,0xb2ce03b2,0x5b610025,0x5f2001e5}},	//   _bilika_, _acclaim_, _देवने_, _okitipup, 
   {{0x9225029c,0x2f08016e,0x82ca0092,0xe527027f}},	//   _alakwa_, _numarası, _floden_, _cinyegez, 
   {{0xd2ec0035,0xf0200335,0xbed402fe,0x737200fa}},	// [1930] _алмам_, _aṣṭīr_, _خبرنه_, _gilagid_, 
   {{0x720001fe,0xdb950212,0x234600ed,0x8fe902fe}},	//   _wilika_, _ecritoir, _gliders_, _تحقیقاتو_, 
   {{0x32ca01c6,0x221200b6,0xfc5300ba,0x9dee0156}},	//   _hynder_, _subhi_, _گۆڵچی_, _טשעכישער_, 
   {{0xe200024a,0xd2ca0098,0x165d0178,0x7fad0153}},	//   _griiki_, _kloden_, _bāliśāḥ_, _検索結果が実際の, 
   {{0x13f4002c,0x5ed9012c,0xa2e301bf,0xb24a0035}},	//   _laster_, _ndayamba, _mediene_, _gosman_, 
   {{0x426c02b9,0x925b02d8,0x4c69018d,0x98470420}},	//   _dolog_, _कालावधीत_, _ምምስሳል_, _магацин_, 
   {{0x891e0205,0x096d0187,0xf2fe0014,0x36800052}},	//   _جلریز_, _директна_, _deshire_, _खेतान_, 
   {{0x9f4e0013,0x7b6c009e,0x64e10024,0x74f7004a}},	//   _сайланди_, _imprensa_, _ঘটনাত_, _билләһи_, 
   {{0x8daa0212,0xf2240109,0x90ee02ac,0xbe930338}},	//   _hovnanya, _venku_, _لأجهزه_, _capturat_, 
   {{0x62010058,0xe13a0144,0x029a0222,0x8a1502c2}},	//   _breina_, _cordiall, _changé_, _mosambie, 
   {{0xaf5602bf,0x2fbd0629,0xcd870282,0x00000000}},	//   _emapasip, _atentsto, _turekore_, --, 
   {{0xa35f0359,0xaf28034a,0x12da0005,0x226c00e1}},	//   _leegste_, _recoller_, _viseta_, _bolog_, 
   {{0x14290037,0x359e0177,0x3b4401f2,0x96270347}},	//   _እንዲነሳ_, _арендази_, _сүний_, _koolstof, 
   {{0xb9ea0415,0x712d02ac,0x63f901ce,0xeda20052}},	//   _folgende, _كتيييييي, _asyur_, _पूर्वस्थ, 
   {{0x874100c5,0x3bad036d,0xf37f025b,0xd670004d}},	//   _政治交接学习教育, _atmhorac, _penasta_, _射手男最偏愛肉感, 
   {{0x131a015d,0xd2490288,0x7d110145,0x6ad00014}},	//   _wózki_, _mwamwe_, _устаноў_, _kultivue, 
   {{0xc2cb0125,0x4b8a00b7,0xaffc019b,0x8ebd05af}},	// [1940] _mesihiň_, _adenowir, _спосаб_, _autobusn, 
   {{0x2b610387,0x8201002c,0x03f40181,0x33fd0196}},	//   _emeliter, _eraiki_, _kaster_, _akungodz, 
   {{0x0dca015e,0x93f80082,0xb516020f,0x627e0082}},	//   _июлда_, _kaduna_, _akazifez, _izinin_, 
   {{0x03860148,0x542b0457,0x6c17019b,0x0387013a}},	//   _conroe_, _agnatimo_, _forumuos, _waaren_, 
   {{0x62000067,0x8c2a0037,0x62ef022c,0xf6320111}},	//   _aziiz_, _መኢአድን_, _bilihna_, _binidizi, 
   {{0xb2650194,0xd29001ac,0x59ee0177,0x7c340231}},	//   _conformm, _sheal_, _jurupegu, _perceper, 
   {{0xf3160611,0xdcdf00bb,0x51fc0191,0x240d02fe}},	//   _amize_, _negatív_, _polisanm, _الصحې_, 
   {{0x52480289,0x7daa0193,0x9b9a01b9,0x52da0020}},	//   _aboma_, _pariwisa, _kominalo_, _iupeli_, 
   {{0x7b9301b9,0x9db2005e,0x25eb0187,0x0f4702f3}},	//   _meritokr, _كەنتىدە_, _докторит, _passande_, 
   {{0xe20103d5,0x8a35005e,0x825a00cf,0xd9ef00e6}},	//   _plying_, _ئۆرنەكلە, _boolla_, _arrivera_, 
   {{0x12da049c,0x02e602ea,0x92a60100,0xd2d8005b}},	//   _buhleix_, _pianeta_, _probio_, _aplee_, 
   {{0xb32503f4,0x7b95006d,0xf15d0076,0x13f800ca}},	//   _стиральн, _альендэ_, _новинска, _caduna_, 
   {{0xf3f80571,0xea0901d1,0xa8fd01cf,0xd2b2013b}},	//   _maluna_, _combinat, _disagrad, _acedera_, 
   {{0x331600f9,0x185f02d4,0xbf2400ac,0xe3f800c0}},	//   _imaze_, _dumandar_, _loših_, _laluna_, 
   {{0x53aa0140,0x83550373,0x934901b2,0xb3870243}},	//   _darating_, _necesas_, _avidity_, _raaren_, 
   {{0x0e83014c,0x153a02c1,0xc3870204,0xdcf30206}},	//   _ndawonye_, _inzibacy, _saaren_, _faktorov_, 
   {{0xfe0100d1,0x7d940291,0x920001ac,0x4fe201b5}},	// [1950] _armenara, _meallaca, _phlimp_, _mudiyako, 
   {{0x02f300a4,0xfa3a0405,0x0d370287,0x77ca01f4}},	//   _dedicat_, _майданчи, _odlišit_, _қаратилм, 
   {{0x027f0244,0xca07051a,0x2b5000e2,0x5a2003b4}},	//   _fianco_, _ramainya_, _folchlis, _chichait, 
   {{0x1ae101ef,0x8cb900ed,0xcce4019b,0x8e5104e6}},	//   _projektą_, _binalaod_, _grupių_, _masasama, 
   {{0xf641028a,0xbf250220,0xe1380040,0x085f00cd}},	//   _kusimami, _aspettan, _בתחבורה_, _cumandar_, 
   {{0x42010450,0xa22402a3,0x902e0423,0x426d04da}},	//   _gebiet_, _suiker_, _kolemjdo, _hrvoje_, 
   {{0xaaef0075,0x0bf20334,0xa470004a,0x63040120}},	//   _adressub, _amatsuts, _balezino_, _nabanum_, 
   {{0xa4a500a2,0x7ad000a6,0xf2e50455,0xcd1e0424}},	//   _فنڪارن_, _ورایه_, _alinéa_, _vândute_, 
   {{0xc68301c9,0x4642032e,0x11dd0360,0xa2e300ea}},	//   _रूमाल_, _askiraki, _aplikací_, _sabotsy_, 
   {{0x6e0102da,0xef640184,0x635e00e6,0x00000000}},	//   _comemora, _kanatsin, _上海东川交通科技, --, 
   {{0xe36e026c,0x4dbc0315,0xe2000383,0x00000000}},	//   _centesim, _bonisana, _uzair_, --, 
   {{0x98180076,0xe98f032d,0x00000000,0x00000000}},	//   _предрасу, _khakanye, --, --, 
   {{0x48470244,0x429000fd,0x06d001c5,0x0fb000c5}},	//   _заради_, _sheas_, _macalimi, _secteurs_, 
   {{0x5b9f05e1,0x82e70450,0xb962020e,0xc39d02c0}},	//   _शंभुनाथ_, _moannen_, _ithobale, _посочува, 
   {{0x7b820253,0xc27f0388,0xa3790072,0x92910356}},	//   _nuannaar, _bianco_, _patacha_, _payata_, 
   {{0x4b900302,0xfa0a019b,0xa2ce0625,0x00000000}},	//   _ezinjalo_, _kompensu, _kreditmi_, --, 
   {{0x047702da,0x569500bf,0xd375023d,0xd3550319}},	// [1960] _проекти_, _службы_, _окончате, _recetas_, 
   {{0x71550092,0x627f016e,0x0b6c00f0,0x526c019a}},	//   _その他ベルカディ, _uzanan_, _netopier, _modoc_, 
   {{0x69af02b6,0x926c0008,0x5d9f0159,0x17880097}},	//   _құйып_, _colom_, _geležies_, _tíórì_, 
   {{0x43f40119,0x6c550066,0x840e02a2,0x54d5052b}},	//   _sarthe_, _baitute_, _kaarawan_, _सबसिडी_, 
   {{0xfd260338,0xb5ba0147,0x8f180012,0x226300aa}},	//   _dignitat_, _архаикал, _पुंजौलीउ, _manumbal, 
   {{0x940d0289,0x00000000,0x00000000,0x00000000}},	//   _adandiuz, --, --, --, 
   {{0xa6030132,0x1ea7001e,0x984503c7,0xe495004d}},	//   _frissült_, _tantance_, _uciążliw, _國民旅遊卡網站_, 
   {{0xa4280092,0xcfc60486,0xf3ea01bf,0x165a0137}},	//   _御神楽温泉_, _uspokojo, _rykter_, _логиктой_, 
   {{0xb2ae03d0,0x425a0250,0xb50200d7,0xf9d000d9}},	//   _kazališt, _sjelle_, _снарядта, _летия_, 
   {{0x6202052e,0x5dce031c,0x9e310156,0x7b7e0326}},	//   _druida_, _prohíbe_, _נדברו_, _akangoer, 
   {{0xc35f035a,0x3ead03ac,0x115b01aa,0xbec40587}},	//   _yengere_, _berorien, _annoncay_, _assetèt_, 
   {{0x33d20207,0xc26c01ec,0x5740025f,0xd6f10397}},	//   _عبدالحسي, _volom_, _bokolong, _исхоков_, 
   {{0xc20000c9,0xb4fc0156,0x5c6d02aa,0x0b6300d1}},	//   _syaib_, _ספישיס_, _netusim_, _শঙ্কৰোত্, 
   {{0xa26c0408,0x8aee0396,0xbd8b041e,0x00000000}},	//   _tolom_, _kontijie, _agettivu_, --, 
   {{0x8cff028a,0x93720255,0x0b8801c7,0x8041023a}},	//   _خصوصن_, _tahavad_, _sebitler, _odpusten, 
   {{0x1bf20128,0x7b6802a5,0x5e52001c,0x00000000}},	//   _تینگلب_, _kateřina_, _nakataka, --, 
   {{0x574604e9,0xcd5300d6,0x21550568,0x9386011a}},	// [1970] _maliglug, _daichead_, _leseoppl, _poorer_, 
   {{0xc0b80044,0xce6701bd,0xe7af0034,0x398e03c4}},	//   _בתאונה_, _саммиті_, _algerleg, _таҗик_, 
   {{0xa1030564,0x53fa00ae,0xf97b0094,0xf0f60178}},	//   _bulgarän_, _bituga_, _سالستىرا, _bhyāgata, 
   {{0x33cf00ac,0xa24801df,0x227e0455,0x00000000}},	//   _krevet_, _acome_, _evene_, --, 
   {{0xceba0220,0xa3130521,0xaebd0287,0xc2ec02c2}},	//   _топло_, _serbët_, _litujeme_, _libiese_, 
   {{0xc9fc0333,0x6225022b,0x43ea029b,0xc1240156}},	//   _incalcat, _stakur_, _djitou_, _שטיפּן_, 
   {{0x52ff0250,0xf9e002a4,0x72b3005b,0x748b0077}},	//   _arritur_, _beatitud, _chiduko_, _lakrimoj, 
   {{0xb7ba0343,0x99fa015b,0x5f4a0315,0x7584000c}},	//   _schuylki, _intanase, _bangakun, _haorusuk, 
   {{0xd68e00dd,0xb3f80397,0xb381012c,0x39e40322}},	//   _proffesi, _kalula_, _سرگرميون_, _abandura_, 
   {{0xd2ce01db,0xb1ac0309,0x00000000,0x00000000}},	//   _формулан, _allahsız, --, --, 
   {{0x739505c2,0x49860106,0x933b0074,0x9e54033f}},	//   _amusi_, _एमएमएस_, _способом_, _hinaekia, 
   {{0xd14a02b0,0xdc1e0286,0x48db0227,0xd8720013}},	//   _kostenlo, _ahintasɛ, _diketahu, _endilikd, 
   {{0x4e3603a1,0x35a2007e,0xf68101a6,0x8dd20178}},	//   _красив_, _anarthik, _ripekati, _dantoṣṭh, 
   {{0xc17b0220,0xa9340255,0x15990055,0xc51d00ef}},	//   _автори_, _kaamerat, _abastanz, _elinqaty, 
   {{0x138705b3,0x92c503db,0x53f400ec,0xb3950476}},	//   _daarin_, _bahlole_, _justas_, _emusi_, 
   {{0x7f070022,0x00000000,0x00000000,0x00000000}},	//   _насармы_, --, --, --, 
   {{0x04960300,0xee6b00c4,0x23f80022,0x420000d2}},	// [1980] _obrazovk, _پيشڪش_, _balula_, _ahlina_, 
   {{0xfb090130,0x29aa017a,0xc3640226,0xce740105}},	//   _gresiane, _кодир_, _akagula_, _procesie_, 
   {{0x413000c5,0xcab30545,0xe2e700e2,0x00000000}},	//   _基本比萨汁_, _norheims, _soannen_, --, 
   {{0x92480348,0x253900f4,0x9ba10060,0x72100052}},	//   _abomu_, _abretañ_, _بىزدىكىن_, _महाप्रबन, 
   {{0x461b0178,0x44f40037,0x8d8f0196,0xb265046f}},	//   _anantavi, _ለማርካት_, _chilinga, _fierstel, 
   {{0x3f26008a,0xfca400f5,0x9d050392,0x7ebe00e6}},	//   _amituana, _муртуны_, _cultarac, _广西壮族自治区_, 
   {{0x427f012c,0xf2900084,0x521800de,0x0a96017e}},	//   _chanzo_, _pamali_, _ayakuham, _barilojn_, 
   {{0x626c006e,0x03c20040,0xc44e035d,0x17bb0005}},	//   _bolok_, _ובראשונה_, _prijatno_, _linguatg, 
   {{0x22a0003a,0x726c010d,0x961103b5,0xbc7e0059}},	//   _shubha_, _colok_, _berendam_, _умерен_, 
   {{0x1ab703c7,0x9d150192,0x2b02011a,0xeeae00b3}},	//   _स्टडीज_, _elastisc, _astrocyt, _bellisin, 
   {{0xdc460205,0xf2920269,0x1c030292,0xc2ca000d}},	//   _کریمه_, _verano_, _bempong_, _loodan_, 
   {{0x72e804c3,0x3b6d02ba,0x3865004b,0xb3100227}},	//   _hoangtu_, _abathola_, _dimoleku, _bernaung_, 
   {{0x02710372,0x42fe026c,0x803f0257,0xbf5d0043}},	//   _llanelli_, _auribus_, _endurmen, _arrahman, 
   {{0x366f0168,0xe30400da,0x00000000,0x00000000}},	//   _hundrevi, _barajul_, --, --, 
   {{0x63f40294,0x00000000,0x00000000,0x00000000}},	//   _custis_, --, --, --, 
   {{0x438702c2,0x8341000b,0xb2900258,0xac2602e1}},	//   _waarin_, _aepeita_, _benaud_, _سامراء_, 
   {{0xad9f022d,0xc802034c,0x46d002ba,0x00000000}},	// [1990] _tedesche_, _гектогра, _azwakali, --, 
   {{0xe2fe0587,0x21f50297,0xa2dd00fc,0x53f40046}},	//   _cargue_, _слайдта_, _luqoydi_, _tastar_, 
   {{0xc2900018,0x0d8502ea,0x9f22037c,0xe32002e2}},	//   _namaki_, _finestre_, _pertinea, _bwoyid_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x757005e7,0xdbf000e4,0xbf54047d,0xa26c01ed}},	//   _elawulak, _internec, _gespaant_, _holoi_, 
   {{0x91ff02c4,0x1d3f005b,0x2d3b010b,0xc2910242}},	//   _здравје_, _seahorse_, _dijitale_, _yükün_, 
   {{0xc84e045f,0xe8f50032,0x726c00c1,0xd0e7004a}},	//   _hittills_, _chinadaq_, _solok_, _iqtisadl, 
   {{0xbc7f00c5,0xb2900082,0x08800153,0xd1680135}},	//   _返回黑龙江主站_, _mamaki_, _この記事は_, _kitergä_, 
   {{0xdc3203be,0xbed60133,0xc25b0111,0x9b560052}},	//   _ababarir, _bidiruun, _moglia_, _सिद्धिपु, 
   {{0x72eb0051,0x698c02c1,0x1f650050,0xfb1800f1}},	//   _bizness_, _imihanda_, _hidrogén_, _legalman_, 
   {{0x53b000d6,0x29f9001c,0xb26503e6,0x60a70291}},	//   _ahbqs_, _valadare, _vierstel, _يعتزم_, 
   {{0x091e0128,0x12250117,0xcfcf01da,0xf26d0407}},	//   _السین_, _erakor_, _dedikuar_, _petog_, 
   {{0x9f280497,0xd9fb01be,0xb6110654,0x899a0045}},	//   _dogmatic_, _असहमति_, _terendam_, _струју_, 
   {{0xd6010300,0xed150166,0xd81500d6,0xa0e100a6}},	//   _cyklisti, _klassisc, _ابنتي_, _ayonakal, 
   {{0xed0c0103,0xd7c30126,0xfdbe02c9,0x32fe00e6}},	//   _aikumbir, _металеви, _radiatoa, _habiter_, 
   {{0x0b9e01fb,0xa660004d,0x4a8e00d1,0x8bbe0513}},	//   _jachetto_, _汶川大地震抗震救, _ক্ষেত্ৰা, _khokholo_, 
   {{0x955100c5,0xee4602c0,0x95c1012a,0x00000000}},	// [19a0] _山重水复疑无路_, _агенциит, _minerały_, --, 
   {{0x82d700a9,0x635b0101,0x407401d1,0xe911007e}},	//   _gitondo_, _singura_, _processo, _anabhiyu, 
   {{0xbf2f0402,0xce4d0516,0xd3bb0064,0xde9001cc}},	//   _kewujuda, _pegatina, _اسلان_, _ahamanen, 
   {{0xd723031c,0x324102d5,0x99cd0176,0xfcb70089}},	//   _represió, _भेजले_, _kufferte, _illyustr, 
   {{0x054600ba,0x3804019e,0xd26c02d9,0x426c001c}},	//   _بریماکۆف_, _агрэсіі_, _soloa_, _molon_, 
   {{0x4eb002ca,0xe2b20270,0x65190125,0x379e0510}},	//   _farraige_, _obedira_, _azaldyly, _пробе_, 
   {{0xe75e025b,0xb343029f,0x58690059,0x96a801de}},	//   _umsiting, _opatrení_, _книгите_, _гидрогра, 
   {{0x5e38030f,0x54890187,0x2a910153,0x53a20211}},	//   _maramata, _програме, _詳しくはこちらか, _leipä_, 
   {{0x3caf00d1,0xb2a7061d,0x6c00002b,0x363700ba}},	//   _উপন্যাসি, _натоға_, _শিক্ষাবর, _خاکێکدا_, 
   {{0x0c0b03f2,0x826d033f,0x173c002c,0x00000000}},	//   _egyptin_, _ketoe_, _albokaeg, --, 
   {{0xe59b013c,0xfcf50086,0xee1e009a,0x56fb0244}},	//   _kiloqram_, _partnerc, _bangagqa, _отделят_, 
   {{0xc76f00bf,0xe2a60655,0xfc210202,0xcb5900cb}},	//   _изображе, _osobno_, _bunijẹ_, _себзор_, 
   {{0x9278030d,0xc9790028,0x60260044,0x49fa027b}},	//   _olundu_, _طریقتس_, _פיקסלים_, _क्षमते_, 
   {{0xeff101d3,0xd469033b,0xa1c30262,0xc6bb00c4}},	//   _miljoner_, _tshelago_, _клублары_, _kusafiri, 
   {{0xbc7c0212,0x710000d9,0xbd9b0013,0x68750080}},	//   _smartor_, _merkitty_, _atrofida, _allisigu, 
   {{0x67d701aa,0xd27801cd,0x3e4e04b2,0xa2fe03ad}},	//   _ariablev, _abhidani_, _napatuna, _harget_, 
   {{0xd2fe0130,0x316c005a,0xe26c00bd,0xd2fd01be}},	// [19b0] _karget_, _dabijmeh_, _allou_, _muzikus_, 
   {{0x2b710095,0xfdaa028e,0xaeaa0180,0xc3670264}},	//   _berlumur, _kontiniu_, _kontinie_, _irignom_, 
   {{0x076402fd,0xc7820193,0x37c8003a,0x00000000}},	//   _chaitlig, _प्रातिनि, _asoslani, --, 
   {{0xe7e501b7,0x0a79023b,0x5386023a,0x526d0176}},	//   _संचरति_, _lapalapa_, _cukrom_, _baboom_, 
   {{0xec450148,0x1290012c,0x3a1500ec,0x2a9701a3}},	//   _使用者端程式_, _samaki_, _jasaitie, _چوڏھن_, 
   {{0xba070309,0x530303a8,0x00000000,0x00000000}},	//   _aviasiya_, _bakarst_, --, --, 
   {{0xa04700d9,0xd26c03d9,0x026c01f7,0x00000000}},	//   _салонов_, _folon_, _conois_, --, 
   {{0xe26c0564,0xb7070039,0x16bb0092,0xde01027b}},	//   _golon_, _камерыг_, _ブライダル_, _antataḥ_, 
   {{0x0b8300d1,0x00000000,0x00000000,0x00000000}},	//   _অমিতা_, --, --, --, 
   {{0x527e01d9,0x8e52004f,0x085a038f,0xa5a70255}},	//   _shingo_, _angalika, _digoradu, _गावतो_, 
   {{0x3d200133,0xb41c03d8,0x026c0318,0xe80302ba}},	//   _ribosome_, _pregazio_, _holoo_, _гулдаста_, 
   {{0xb31800fa,0xa26c01c2,0x67530065,0xdd9e02af}},	//   _ganitong_, _ollos_, _spannung, _bukebuke_, 
   {{0xd26c0183,0x00000000,0x00000000,0x00000000}},	//   _volon_, --, --, --, 
   {{0x426c0515,0xc2fc0255,0xf2b20456,0x398b0061}},	//   _illos_, _allikas_, _banduan_, _부서별표준서식_, 
   {{0xf1b502da,0x203600d1,0x338700ee,0xcf49027b}},	//   _стандард, _আঁহতগুৰি_, _oparoa_, _व्यधात्_, 
   {{0x322401d9,0x42000404,0x00000000,0x00000000}},	//   _lenks_, _rejine_, --, --, 
   {{0xca14064d,0x724a000e,0x2d2900ad,0x266700c7}},	// [19c0] _eliakima_, _cosman_, _permanén_, _бакиров_, 
   {{0xf5bc00a6,0x5387004b,0xf629034b,0xc0380195}},	//   _بيانيه_, _aparoa_, _havirisi, _carthann, 
   {{0x026c024b,0xb31c0656,0xfe3803be,0xd74f0092}},	//   _ellos_, _preciza_, _barabata, _printerv, 
   {{0xa26c006e,0x575a0144,0x13670040,0x00000000}},	//   _boloo_, _mionlaig, _וכשמדדתי_, --, 
   {{0x7d6f0294,0x2c5c013d,0x12900627,0x4f1404ca}},	//   _animalta, _partojn_, _ikmat_, _calcaris_, 
   {{0x39330144,0x1e8602ea,0x8ae1002b,0x46d30287}},	//   _بإرسال_, _conviene_, _বইপাগল_, _बोरिङ_, 
   {{0x9224006e,0xb26c01f7,0xcb670195,0x6afc027e}},	//   _penku_, _tolon_, _bileagan_, _поздрављ, 
   {{0x3f82026f,0xa04e0040,0xe29e04d7,0x12d6034d}},	//   _اۋىتقىعا, _טורניר_, _neitaði_, _berliku_, 
   {{0x0efe020e,0x1107003c,0xac0f016e,0x47920110}},	//   _barwetsa, _سرزرد_, _körfez_, _centīsie, 
   {{0xa26c0403,0x337c02be,0xc2240594,0xe2ab023e}},	//   _solon_, _detalye_, _tenkt_, _kondang_, 
   {{0x92b403ae,0x9fee0040,0x47b60374,0x3c250011}},	//   _jødisk_, _פולשנית_, _adresing, _basaalir, 
   {{0x0b7f000c,0xc8eb00d9,0xa8fe01d4,0x75b001f5}},	//   _asunción_, _обладате, _parapend, _dinginny, 
   {{0x8c270483,0x8dbe0148,0x2b88050a,0xb26c03ad}},	//   _estímulo_, _上一篇主題_, _terimler, _folol_, 
   {{0xef4e04c7,0xf2d8054f,0x739502ca,0x00f80242}},	//   _политичк, _nplej_, _seasta_, _topladığ, 
   {{0xf37f0188,0x8d320270,0xe2fe0478,0xb224013a}},	//   _namanga_, _maritage_, _variats_, _denks_, 
   {{0x020d014e,0xd2480362,0x71790629,0x930603bf}},	//   _спомен_, _abomi_, _adridmay_, _dirobeng_, 
   {{0x72b8002c,0xac0b0193,0x7ade00e2,0xb2c504cf}},	// [19d0] _handiak_, _ngapain_, _fertocht, _bahlale_, 
   {{0x52900113,0x3e3902d4,0x971d0137,0x1c000012}},	//   _theas_, _finamira, _хомрогло, _हमरॆँ_, 
   {{0x42bc0605,0x437f01ad,0xe2c30003,0xe9b900e6}},	//   _mondyal_, _camanga_, _spellen_, _paramédi, 
   {{0xd03b0238,0xab90002b,0xc57d0128,0x00000000}},	//   _очистити_, _অনুমতিতে_, _дармонга_, --, 
   {{0xdf32020b,0xc6800523,0x33f4003d,0x87ae0088}},	//   _barutaba, _कोलाज_, _barthe_, _бийге_, 
   {{0x739f0301,0x80ab0220,0xb860009a,0xb2eb02f9}},	//   _dövrdə_, _стомана_, _alinamqu, _bizniss_, 
   {{0xb31600f9,0x165e0354,0xdd00014d,0x82910053}},	//   _amaze_, _бизму_, _verliebt_, _revand_, 
   {{0x78390297,0xc93d00dd,0x340000e6,0x22db0203}},	//   _afrikağa_, _anymarfe, _中国兽医药品监察, _suposir_, 
   {{0x726c0201,0x47300071,0x0c65044d,0x02bb005f}},	//   _bolol_, _airlangg, _daytalu_, _novedad_, 
   {{0xb31902e2,0xe063009b,0x53f401f1,0x986d00a4}},	//   _chaining_, _голлох_, _paster_, _ocasions_, 
   {{0x826c0193,0x2e0b01d1,0x915c004a,0x8dd10214}},	//   _lolos_, _elements_, _сулап_, _anokunga, 
   {{0x826c03d8,0xa4f4018d,0x9d8403eb,0xb30702be}},	//   _vodom_, _መዛሙራት_, _leidende_, _hambing_, 
   {{0xa37302c3,0xe200006e,0xa16e00a4,0xf4a10127}},	//   _dodanie_, _ayiir_, _тармагын_, _ahendall_, 
   {{0x124803de,0x73780221,0x123c0003,0x83830009}},	//   _ubomi_, _fahaman_, _normaal_, _pripravi_, 
   {{0xa29202bd,0x652e045e,0xa4a101eb,0x7e350047}},	//   _straen_, _принуден_, _mbaysyvo_, _utilises_, 
   {{0xf3f4018b,0xf9fc00f9,0xe63901ac,0xf30704b2}},	//   _martie_, _kwandika_, _dinimici, _lambing_, 
   {{0x7dc30040,0x7069009e,0xe1510137,0xa398036e}},	// [19e0] _האנטי_, _compreen, _стоус_, _chuymiq_, 
   {{0x53fa00ad,0x03f90095,0x45c0002b,0x021200bf}},	//   _kituna_, _apyun_, _সোপর্দ_, _адамалли, 
   {{0x39d3036e,0x0af5029a,0x0eac01cf,0x829002f6}},	//   _distritu, _larestas, _jerraise_, _munang_, 
   {{0xb25f02bf,0x80960040,0xa26c015e,0x6864004d}},	//   _balungel, _ושלושה_, _celoni_, _我們的故事_, 
   {{0xf316037a,0x001a016d,0x5d1b02c2,0xd38003ec}},	//   _umaze_, _ﺋﯩﻠﺘﯩﻤﺎﺱ_, _avonture_, _revistë_, 
   {{0x3f690121,0x00000000,0x00000000,0x00000000}},	//   _salarios_, --, --, --, 
   {{0xc201027b,0xeba50125,0x663901db,0x426c0205}},	//   _apaiti_, _хысырдыс, _палатаны, _holos_, 
   {{0x1e550333,0x7f5d022e,0x62da00d7,0x8d9d0084}},	//   _arrabbia, _ottavian, _botebo_, _bluefame_, 
   {{0xca1d0147,0x629000d2,0x34350184,0xe38d01b5}},	//   _comença_, _kunang_, _arajabuk, _edeskini_, 
   {{0xeb72023d,0x6e7a0046,0x999300bb,0x6a0200f7}},	//   _стана_, _мандатын, _بھڑکا_, _ambrotiu, 
   {{0xd3780294,0x57620314,0x4a770107,0xe6f60012}},	//   _achawan_, _геройҙар, _بايستي_, _सुझवलन_, 
   {{0xc41201f5,0x0e1b0546,0x13d40181,0x763201d7}},	//   _diingink, _उल्लिखित_, _landbrug_, _habitazi, 
   {{0xe20001e5,0xac460425,0x49c10181,0xa303012a}},	//   _apiiri_, _بریمه_, _aflevere, _finału_, 
   {{0x129201b7,0x88c101db,0x82920240,0x0e3f00e6}},	//   _agrato_, _студиясы_, _saqata_, _手机电子书_, 
   {{0xd95002fd,0x05150287,0xf8340210,0x49340090}},	//   _aislinge, _एकैदिन_, _chemukad, _chemukat, 
   {{0xf3050198,0xa386018e,0x68860349,0x23f302ac}},	//   _članek_, _ebazini_, _alghurid, _تطوان_, 
   {{0x9ffd01bd,0xc6f6034c,0x927f0331,0xbd780161}},	// [19f0] _ءﺑﻮﻟﯩﻤﻰ_, _муллалар, _fegnir_, _наноситс, 
   {{0x26c701a7,0x22ef0055,0x4ec603b1,0xd27800e2}},	//   _tilantei, _turnati_, _citoyens_, _fernim_, 
   {{0xee54043d,0x637303c7,0xa35405e0,0x6320038a}},	//   _kesalaha, _podanie_, _relevos_, _chichas_, 
   {{0x00340139,0x026c05e0,0x526c0115,0x01d70187}},	//   _abhedeno, _tolos_, _hodoh_, _најлош_, 
   {{0xefc300cc,0x93f40194,0xc2a000d6,0x925a0513}},	//   _regioner_, _hastar_, _تنومه_, _kholwa_, 
   {{0xe26c0217,0x726c0386,0xb4640040,0xf2d9000d}},	//   _rolos_, _jodoh_, _באפסטור_, _ostes_, 
   {{0x626c02e7,0xcc5a0241,0xb3f80119,0xe2da0244}},	//   _kolor_, _feeteti_, _naduma_, _inteso_, 
   {{0x92d9001d,0x52e202d8,0xf41a0429,0x00000000}},	//   _istes_, _लॉगीन_, _diandaik, --, 
   {{0xf26c00c3,0x429101da,0x426c0518,0xd3f401f6}},	//   _dolor_, _thuaj_, _xolos_, _lastar_, 
   {{0x8b9e045c,0x226c0016,0x83f80255,0x645d00b4}},	//   _zaciatoc, _volos_, _kaduma_, _completă_, 
   {{0x9f5501c2,0x19430638,0x026201d4,0x87820299}},	//   _despraza, _spillere, _allonghi_, _دەۋزەخ_, 
   {{0x721c0019,0x64f50037,0x8d9b055a,0xf25a01cd}},	//   _ئيىتكەن_, _ለማሰራት_, _atrocida, _aholwa_, 
   {{0x6a100101,0x52d902f1,0x1b100101,0xf26c0227}},	//   _consiliu, _estes_, _consilie, _bodoh_, 
   {{0xf29105fd,0xdeb60238,0x2387001d,0x41390088}},	//   _skuad_, _системі_, _aversi_, _найманба, 
   {{0x32010125,0x7b8d0372,0x16e40287,0x95230361}},	//   _wezipe_, _anonestr, _servisní, _мордва_, 
   {{0xc26c04a7,0xf38603b6,0x510c00d1,0xf8cd00f6}},	//   _polos_, _abirun_, _ইম্পিৰিয, _bayramov, 
   {{0x52380467,0xc3f80333,0xbc1b008e,0xafbe0066}},	// [1a00] _sarmiah_, _padula_, _dieumé_, _koalizio, 
   {{0xc8370192,0x73f40378,0x4c9003a2,0x237c0407}},	//   _반갑습니다_, _fastar_, _लाभों_, _bacanje_, 
   {{0xc3890003,0x38540102,0x126c014b,0x8023009b}},	//   _vergelij, _موديز_, _goloq_, _berdinak_, 
   {{0x72900657,0x29aa0037,0xd3b60532,0xe2af019b}},	//   _ijmak_, _መለዋወጥ_, _stavlja_, _karališk, 
   {{0xd1520349,0xfb6a02d9,0x43f8040b,0x10e10109}},	//   _evelslay_, _amatalia_, _talula_, _odinstal, 
   {{0xa746000a,0x431005a5,0xd2da0244,0x63e100d3}},	//   _malillug, _verziu_, _intero_, _भर्त्सना_, 
   {{0x82d903cf,0xbe52030f,0x7f690141,0x00000000}},	//   _ister_, _takataka, _apparatn, --, 
   {{0xac5901fc,0x9b170235,0x1a06027f,0xd69b0420}},	//   _baktaah_, _प्रणवं_, _biradege, _скриени_, 
   {{0x2e5c0037,0x18fd0209,0xe31e0315,0x12d90051}},	//   _ከማመልከቻ_, _sodavand, _edictal_, _astes_, 
   {{0x58ba0119,0xf3f40257,0x6c6d008e,0x23200156}},	//   _göttinge, _fastir_, _delusik_, _שמוגלער_, 
   {{0x69d001a7,0xc6aa0276,0x4a0c0209,0x1250011b}},	//   _hakemist, _گرامدىن_, _ammaanne, _dicernem, 
   {{0x1ec90083,0xfc58018d,0x098001fb,0xd2f30050}},	//   _politecn, _ንዘኽታማት_, _legierme, _kaliwat_, 
   {{0x63ea01af,0xc6ac00e4,0x3bf00005,0x238800cf}},	//   _soltan_, _intensyw, _surfatsc, _baayina_, 
   {{0x694c0360,0x96b4006e,0xfa590149,0xcb8703b7}},	//   _uplatněn, _defukaay, _ọghara_, _annister, 
   {{0xf3870377,0xaa610479,0x6e6e01f4,0x8e9b007b}},	//   _scurt_, _kovács_, _chaqaloq, _covetous_, 
   {{0x02d90230,0x33f801c0,0x2d0603ad,0x93ea0429}},	//   _aster_, _salula_, _kwartier, _voltan_, 
   {{0x97100192,0xa6c2015d,0x031d002f,0x5242036e}},	// [1a10] _고객센터의_, _धन्यवाद्_, _amachan_, _bibliapi_, 
   {{0x0d99016e,0x8eb9001d,0xe2fe0180,0x83f8019f}},	//   _reklamla, _profanes_, _larises_, _maduka_, 
   {{0xf31605f1,0x44ec00d1,0x2d8f02cb,0x1806002b}},	//   _amazi_, _নিজান_, _skidanje_, _নীরবতা_, 
   {{0xac5c037c,0xc2910111,0x9c5502ef,0x00000000}},	//   _footbal_, _affaru_, _lestrad_, --, 
   {{0x02d80258,0x99da02a0,0xd157052b,0x4bed0061}},	//   _ommers_, _alábahun_, _पल्लवी_, _네비게이토_, 
   {{0x6aa203bf,0x7928016d,0x28c100d7,0xc30e0050}},	//   _авторлыҡ_, _еливатим, _мәкерле_, _saratus_, 
   {{0xcad70163,0x4623013a,0xa2d80003,0x930e026c}},	//   _کاربند_, _homonymi, _immers_, _paratus_, 
   {{0x9c76008f,0x6eaa02a1,0x63f8019d,0x1f1100a6}},	//   _निम्नो_, _naburige_, _kaduka_, _دريابونه_, 
   {{0x163d015e,0xe9c103a2,0xce9b004d,0xf26c0258}},	//   _sobirani, _एसएचओ_, _中國經濟網有權在, _folop_, 
   {{0xa3f8024f,0x34a80127,0x00000000,0x00000000}},	//   _yaluma_, _dizingal_, --, --, 
   {{0x926c040b,0xa2900165,0xf2480061,0x00000000}},	//   _goloi_, _akeai_, _vakman_, --, 
   {{0xd9b50308,0x7bdf00ae,0x23860096,0x637c0100}},	//   _mendapat, _bahenger, _abasindi_, _ostatke_, 
   {{0xc6d20012,0xb3f40108,0x46a50510,0x126c0395}},	//   _तिसिए_, _awutan_, _улсенче_, _poloh_, 
   {{0xb2900562,0xea0702d8,0xbb5b0095,0x426c01e9}},	//   _renaud_, _kamarnya_, _delengen_, _boloi_, 
   {{0x9355031c,0xbae70089,0x00000000,0x00000000}},	//   _decenas_, _диварга_, --, --, 
   {{0x626c02bc,0x5e8f0420,0x0fd4004d,0x0f2f019b}},	//   _doloi_, _projetos_, _內含天使的祝福_, _instalia, 
   {{0x72720134,0x43f80369,0x991200aa,0x00000000}},	// [1a20] _gidigidi_, _saluma_, _mamatahu, --, 
   {{0x1f3e0025,0x9987017d,0xb26c01c5,0x2b620272}},	//   _राष्ट्रे_, _厚生労働省_, _hodon_, _amuleter, 
   {{0x234100ca,0x627e04b4,0x024d0381,0x71e70366}},	//   _ciceron_, _dannet_, _anifestm, _пысăк_, 
   {{0x72da01b9,0x4c7505a4,0xfd750206,0xea880061}},	//   _disela_, _formátu_, _formáte_, _전문가들이_, 
   {{0x777301eb,0xab5b003c,0xf8c00218,0x0c060226}},	//   _аҭыҧантә, _celengen_, _attended, _kansalu_, 
   {{0xf21201c5,0xc2f70239,0xbc71016f,0x9d6002bf}},	//   _dhihi_, _kairīwhi_, _tipsene_, _elicembu_, 
   {{0xd3eb003c,0x908c048a,0x1e90018b,0xcc3601f6}},	//   _cipta_, _мамандар_, _единтелу, _দীঘলীয়া_, 
   {{0x5a1501eb,0xf30d0312,0x681500f2,0x17360291}},	//   _coactiva_, _bisousig_, _meteorīt, _عالمرور_, 
   {{0x26910261,0x78f70094,0x4d8f0196,0x0c740365}},	//   _normalaj_, _تۋراسىنا_, _chilunga, _आबस्यक_, 
   {{0x3cb301a6,0x04780374,0xaee20061,0x3f150153}},	//   _manawatu_, _усама_, _우주선발사_, _デン蓮池公園_, 
   {{0xf2fc00a7,0x21840315,0xc7b40006,0xec690244}},	//   _entitat_, _awabhadl, _penebang, _ritrovo_, 
   {{0xf311012f,0x93f40013,0x73650272,0x64f50350}},	//   _baibait_, _dastur_, _abeegunj, _ለማሠራት_, 
   {{0x2b1d0061,0x73f804bd,0xa9090372,0x7abd03ce}},	//   _결과적으로_, _kaluha_, _benbalad, _میندا_, 
   {{0xa94d00d1,0x298e0041,0x44340320,0x00000000}},	//   _দুজনা_, _аҧшыхәра, _mapakelo_, --, 
   {{0x7e3b0069,0x32900092,0xd29104b2,0x791200aa}},	//   _biragara, _menard_, _niyaon_, _kamatahu, 
   {{0xaa1f01a7,0x13f8025f,0xb3f80247,0xb2d8024c}},	//   _основные_, _baluka_, _paduka_, _aqleb_, 
   {{0xd5c80037,0xa524005e,0x94bd0185,0x42b4007e}},	// [1a30] _ሥልጣኑን_, _ﺳﺎﺑﯩﻖ_, _başların_, _avocan_, 
   {{0x7eaf03b9,0xeda7005a,0x739401df,0x0274020f}},	//   _parlawin, _holoycha, _dunse_, _پريږدی_, 
   {{0x7555017a,0xcc650240,0xfbe302eb,0x18880040}},	//   _abakutsh, _ikatolu_, _жорлон_, _הפרמטרים_, 
   {{0xc12900c7,0xb15c051b,0x037102a2,0x91110125}},	//   _germaniä_, _florbalo, _malamig_, _berkidil, 
   {{0xb373001e,0x995202a0,0xd9fa0343,0x9ca70213}},	//   _magance_, _fasorant, _gililala_, _деветкка_, 
   {{0x1b1f01d2,0x4232002e,0xa129038f,0x028c0100}},	//   _allaukan_, _brojevim, _dermeniñ_, _vlakana_, 
   {{0x77ad03a7,0x1987031d,0x78fd02f3,0x0dfd061c}},	//   _trpezliv, _innkeepe, _skrattad, _podesava, 
   {{0x9fd503c7,0x69a80211,0x495c00a2,0x00000000}},	//   _prezyden, _верхней_, _theonest, --, 
   {{0xc30501c5,0x49090173,0x14ea00d9,0x8c0b0658}},	//   _اوراد_, _স্বীকার_, _закончил, _egipcio_, 
   {{0x827f02e8,0x81b50111,0x226c03a1,0xf7e700c1}},	//   _mhando_, _palmieri_, _veloci_, _सुखरूप_, 
   {{0x32f004aa,0x58de024c,0x52120096,0x43370161}},	//   _debitsi_, _perfectd, _akiha_, _николая_, 
   {{0x6e0c02f6,0x32d4003a,0xc29202ea,0xa8fb0037}},	//   _lisensya, _birdek_, _teramo_, _በባለስልጣኑ_, 
   {{0x10d90475,0x62fe0193,0xec0302ba,0xa26c004f}},	//   _заболева, _target_, _asefranc, _lolou_, 
   {{0x44ed00c8,0x76ab0041,0x82cc003b,0x00000000}},	//   _күмелде_, _рбаталио, _ineliso_, --, 
   {{0x35ff04f9,0x5d40020f,0x00000000,0x00000000}},	//   _bergstrø, _خرابوالي_, --, --, 
   {{0xc9850157,0x56b900ea,0xa95b028b,0x3e3a00ae}},	//   _polityka_, _manamari, _butoride, _baragasa, 
   {{0x72250292,0x637e012a,0x00000000,0x00000000}},	// [1a40] _isakar_, _trafić_, --, --, 
   {{0xa1750277,0x738700c3,0x488e0098,0x3d7102da}},	//   _propesyo, _exerci_, _råvarer_, _palmeira, 
   {{0x4c0502fe,0x94d700f5,0xee900196,0x494b0210}},	//   _abarhweb, _ваканы_, _akamanen, _akamushe, 
   {{0xd27e0025,0xe81a0089,0xf2b40151,0xb9780223}},	//   _svena_, _тәрбиялә, _saddled_, _настнууд, 
   {{0x92da033b,0x68ba0040,0xd2560352,0xd2da012e}},	//   _potego_, _בכרמיאל_, _সদস্যক_, _viseli_, 
   {{0xbb270074,0xd2910129,0xd37900b3,0x00c2004a}},	//   _внимания_, _mobail_, _aydaryn_, _атамасын_, 
   {{0xb3160285,0x85e901ef,0x1ad500f2,0xe18a004a}},	//   _amazu_, _valančiū, _arhibīsk, _аюдан_, 
   {{0x8a600107,0xb2010342,0xb6b90286,0x8313027b}},	//   _اخرين_, _mezire_, _nanabari, _आनुशंसाः_, 
   {{0x0c150052,0xbf3901ab,0xf24a011d,0x138603b6}},	//   _कुर्कुच्, _दितियैक_, _cosmin_, _obirin_, 
   {{0x08d600c1,0xcf630025,0xdc9f00b5,0xb26c0013}},	//   _गोगटे_, _विश्वासं_, _kusepuku_, _eldor_, 
   {{0x426c04a7,0x4fee0401,0x535400dc,0x4212005b}},	//   _lodos_, _क्षारीय_, _leseiau_, _chiho_, 
   {{0x80e90094,0x3b360472,0xe27c01f4,0xa8f1032c}},	//   _ءتاپسىرى_, _membikin_, _topiladi_, _ilusilig, 
   {{0x89040235,0xb25a01e9,0xc3eb01c1,0x936f02cb}},	//   _adinnādā, _beelwe_, _cipto_, _tehničko, 
   {{0xd2b20659,0x255303db,0xc8430299,0xb27a04b2}},	//   _panduan_, _abakheth, _ئوقەتچىل, _bumibili_, 
   {{0xa788012c,0x336f02cb,0xa3800075,0xdc520198}},	//   _نوجوانن_, _tehnički, _spurdi_, _svetila_, 
   {{0xe6c700ee,0x19930359,0x2201033d,0x00000000}},	//   _eleberri, _boekefee, _dezire_, --, 
   {{0xaaf70039,0x9d9e00fe,0xb6970065,0xe27f03b4}},	// [1a50] _нандин_, _hukehuke_, _bedenkli, _chando_, 
   {{0x12b800ff,0x15b9012a,0x026c032d,0xbf5f02bb}},	//   _פעקעטע_, _posiadam_, _bolou_, _demontaż, 
   {{0xc5a80044,0xa9e30013,0x46d8032d,0x00000000}},	//   _לגידול_, _хонага_, _харрасов, --, 
   {{0x71aa00da,0xf21d0023,0x8e460113,0x6638015e}},	//   _дискуцие, _самую_, _كائنات_, _mediambi, 
   {{0x2f3900e4,0xeaf80173,0x99f80173,0xb94f00cd}},	//   _तिमिलाई_, _asesinat, _asesinad, _approvar_, 
   {{0x12e500a6,0x683e00da,0x900e03fb,0x785b0131}},	//   _amoniya_, _чирка_, _razveden, _autoaxud, 
   {{0x79130062,0x3bf0003d,0xf6990374,0x6e4c0482}},	//   _dalajchu, _adressec, _байтулло, _siyaasaa, 
   {{0xca1e00c5,0x8a0402e1,0x5e360017,0x2cdb007e}},	//   _亿元人民币_, _cumasait, _zasahova, _atulāṃ_, 
   {{0x826c022c,0x4212005b,0x030f065a,0x8f4900be}},	//   _kolot_, _shiho_, _akubona_, _байчечек, 
   {{0xa2d801e1,0x6ae20320,0x58ec01b3,0xc26c0030}},	//   _baheso_, _emaritwe, _районних_, _dodos_, 
   {{0xc2cb031a,0x096a008d,0x9c74065b,0x397a00b3}},	//   _aisde_, _самарадо, _शिप्रा_, _aktiwist, 
   {{0xc1f6017d,0xb06d0027,0xb3640162,0x30ff065c}},	//   _ejendomm, _nedabino, _ئويما_, _atshabal, 
   {{0x86ce003a,0x32ca03db,0x343e0366,0x73360025}},	//   _balandli, _behleli_, _парне_, _स्थापिता_, 
   {{0xe44a0299,0xb2fc0079,0xb9cc0092,0xa26c029e}},	//   _индәккә_, _polijas_, _外部サイト_, _deloof_, 
   {{0x83900216,0x8dd50099,0x72d90008,0x5afe0127}},	//   _ahiyeni_, _akakamba, _esteu_, _diframme, 
   {{0x628702ac,0x66b20193,0xd3fa0074,0x927e012c}},	//   _مفتاح_, _मस्तं_, _sipuli_, _ukingo_, 
   {{0x6e5a0297,0x00000000,0x00000000,0x00000000}},	// [1a60] _ciñgäç_, --, --, --, 
   {{0x562401aa,0x00000000,0x00000000,0x00000000}},	//   _appliesw, --, --, --, 
   {{0x52e7042b,0x73420029,0xc7b902bf,0x57fd00c5}},	//   _kornera_, _پێشخستنی_, _amsukumi, _深入贯彻落实科学, 
   {{0xc26c016c,0x59e60203,0xe2d8065d,0x964001c0}},	//   _todos_, _correctu, _epler_, _hikimomi, 
   {{0xf2f30040,0x69f90403,0x1a7300b9,0x00000000}},	//   _inhibit_, _dadanare, _indojilb, --, 
   {{0x9ec801ef,0xcded0182,0x7431027b,0x00000000}},	//   _staigmen, _ukālā_, _नावबुध्य, --, 
   {{0x5f6e0148,0xe7b404a4,0x1c72007f,0x43530510}},	//   _家電安裝小貼士_, _correigi, _ceirios_, _декъашхо, 
   {{0x42e80478,0xac560156,0x262a00e5,0x00000000}},	//   _aplican_, _ישראלס_, _макарони, --, 
   {{0x4c0d00dc,0x93dd003f,0x92d8019f,0x6f5e0040}},	//   _apopole_, _chawbe_, _bahero_, _simplest_, 
   {{0x226c02f3,0xb5bb039e,0xcadf004c,0x7b850425}},	//   _annons_, _গৱেষণা_, _agateege, _خورماتوو_, 
   {{0x27240259,0x0b59026a,0x8605032d,0x8f0b03d5}},	//   _aneurysm_, _basulawa_, _именлеге_, _commoner_, 
   {{0x9c50002b,0x00000000,0x00000000,0x00000000}},	//   _গুচ্ছ_, --, --, --, 
   {{0x02780428,0x35b901a3,0xb2f003ad,0x97b5000b}},	//   _zurnal_, _سوغاتون_, _estiżi_, _saleutog, 
   {{0xc22b005b,0x7f1b0213,0x00000000,0x00000000}},	//   _formand_, _звания_, --, --, 
   {{0x039402b7,0x926c0050,0xfab90132,0xad910061}},	//   _teisha_, _bodor_, _paraméte, _동영상천국_, 
   {{0x81430473,0x419502a7,0x78710371,0xea79023b}},	//   _innerhal, _peaceabl, _устата_, _kapakapa_, 
   {{0x1beb0124,0x13d2006f,0x52e800ff,0xa2d9008f}},	// [1a70] _hollengo_, _عبدالحڪي, _armilon_, _istet_, 
   {{0x2ae3065e,0xde97013f,0x089304ca,0xaea602a2}},	//   _overhove, _dastumet_, _magistèr, _alalahan, 
   {{0x5b1a018d,0xa9a20040,0xc2ca02ee,0x59210326}},	//   _ሓንጎሎም_, _בקטלוג_, _hedded_, _chichagu, 
   {{0x5fbe02bb,0x23fe03de,0xf25b01be,0x6727002b}},	//   _znalezio, _ayaziwa_, _udelat_, _আরোহী_, 
   {{0x9d0001d5,0x7b570008,0xc56d0238,0x3dc403ec}},	//   _گھونٹ_, _балалуу_, _форматув, _dobishme_, 
   {{0x126c0429,0x950301e8,0xa26c031d,0x627e0117}},	//   _dilog_, _freefall_, _sodor_, _ivent_, 
   {{0x4ede040f,0x62f1042f,0x6283043a,0x72d501b2}},	//   _dienomis_, _qitiani_, _frikopa_, _afflict_, 
   {{0x63fe05e7,0x53fa0275,0x72f500e4,0xc913005e}},	//   _eyaziwa_, _fatuga_, _सम्बन्धो, _قذرذلذشع, 
   {{0x22360230,0x8dd1065f,0x631601da,0xde490003}},	//   _bhojpu_, _službama_, _imazh_, _betaalba, 
   {{0x5d6f05c9,0x403203a4,0x02fc010a,0x00000000}},	//   _niamhlua, _partapen, _golgaa_, --, 
   {{0xa15c03bf,0xad34027b,0xfc050312,0xb27e03f3}},	//   _тулап_, _समारुह्य_, _barrouz_, _ovens_, 
   {{0x8756002b,0xf26c02f6,0xe581004b,0xe9b20107}},	//   _বীরশ্রেষ, _bilog_, _европала_, _candrase, 
   {{0x2655017a,0xe6be01db,0xedbe026a,0xc23300a6}},	//   _abangelw, _بۇحاردىڭ_, _matasere_, _ekuvakal, 
   {{0xa6ef0040,0xedc10010,0xa7af0081,0x00000000}},	//   _ומכאן_, _betinema, _barnaföt_, --, 
   {{0xa25a0036,0xba6c01db,0xe5a1027b,0xc3730222}},	//   _giolla_, _тоңазытқ, _दिशतु_, _bagarre_, 
   {{0x4c7c004f,0x630c0359,0x32ab0472,0x32ea0372}},	//   _emisyon_, _draacht_, _bondong_, _heintus_, 
   {{0x2e950056,0x621f036f,0xf3c8028b,0xfc23021c}},	// [1a80] _шурави_, _značajno_, _ианрылаг, _japonsku_, 
   {{0x142b00e6,0x72c800d9,0x00000000,0x00000000}},	//   _本文仅代表作者个, _настенны, --, --, 
   {{0x14b300c5,0x2321002f,0x1b9e0513,0x20e60361}},	//   _中国科学院_, _chachas_, _makhotso_, _аьрби_, 
   {{0xc0c90046,0x329102e7,0xe2f10085,0x5ab4039e}},	//   _мелдеш_, _biyaan_, _kitioni_, _frukostb, 
   {{0xeb48045c,0xf91801f2,0x72070105,0xe3ce0151}},	//   _šampión_, _фейшуң_, _kosiarki_, _calved_, 
   {{0xc56402ac,0xb69700a0,0xd3ea0204,0x4fe80486}},	//   _shamhlaí, _bajekoli, _boltin_, _संघारमा_, 
   {{0x8ae4048e,0xa52c0029,0xf26401b4,0x3c51011f}},	//   _beduinat, _چاوێک_, _beplan_, _apotaha_, 
   {{0x952c0029,0x1c2504ec,0x566d0291,0x55e1041e}},	//   _ناوێک_, _araborer, _الكسل_, _appacià_, 
   {{0xd016004b,0x0d8d03d4,0x639c0529,0x991a02eb}},	//   _хатында_, _demolira, _pomaganj, _нимбэгни, 
   {{0x68e60011,0xd0e802f3,0xc6e600bb,0x827e00e2}},	//   _abafuumu, _nationel, _پاسباں_, _muonts_, 
   {{0x3aa10288,0x1fcd00bb,0x7c6800f4,0xa0ea01f3}},	//   _sechzehn_, _پاؤڈر_, _bourmen_, _stanovil, 
   {{0x8213008d,0x82d903ab,0x1b5b0192,0x9c740110}},	//   _shahri_, _trhliny_, _afleggen_, _mirušu_, 
   {{0xc2020225,0xf20100ba,0x32f30055,0x333f00d1}},	//   _meriot_, _خورێنیدا_, _acciaru_, _জন্মোৱা_, 
   {{0x22b50256,0xcedc0162,0x426c0062,0x62c40203}},	//   _preces_, _مۇراسىمى_, _boloy_, _geoland_, 
   {{0x928d014f,0x986f0547,0xc80e014e,0xcc10003b}},	//   _направио_, _causados_, _либерали_, _fasítelo_, 
   {{0xe9fc01d2,0xbc1a0044,0xe95d01b6,0x8eea012e}},	//   _allamant, _launched_, _elongate, _وسکون_, 
   {{0x803b0370,0xf36503a2,0x03950370,0xb3f103dc}},	// [1a90] _wewengko, _एलआईसी_, _beasna_, _eitrandi_, 
   {{0x62c700c5,0x720202fd,0x7bc400f5,0x7388006c}},	//   _任何单位和个人不, _heriot_, _лесбиянл, _abayona_, 
   {{0x821f042c,0xa202004b,0xc9a400d1,0x00000000}},	//   _značajna_, _ditima_, _গণ্ডীৰ_, --, 
   {{0x6db40362,0x43070195,0x00000000,0x00000000}},	//   _odongola, _shiaigh_, --, --, 
   {{0x19f2019c,0xf2da023e,0x33870075,0xc27e00ae}},	//   _atehinwa_, _adangme_, _sverri_, _bwena_, 
   {{0xb03101fb,0x026c04c0,0x0aa60023,0xaef6014e}},	//   _protegen, _dodow_, _прочие_, _разумом_, 
   {{0x2200005b,0x369b00bb,0x52120285,0x461c0204}},	//   _kimiko_, _شریانوں_, _akahe_, _joillaki, 
   {{0xe3dc00da,0x2ec903d5,0xab170235,0x64070291}},	//   _ачестор_, _disingen, _प्रणवः_, _ياااارب_, 
   {{0x182d0129,0xde2f00cf,0xb26d00f1,0x65e802ff}},	//   _agumakwu, _aangawaa, _divors_, _alontèm_, 
   {{0x5d4a02b6,0x60fd000f,0xf2fc01ad,0x00000000}},	//   _боларсың_, _iltihapl, _polinas_, --, 
   {{0x5d4001ac,0xf5670185,0x12e80158,0x469f0153}},	//   _molaimid_, _бинаның_, _pobiera_, _養魚場から発生す, 
   {{0x1d0502e9,0x04c30357,0x8ad00163,0xc3a70349}},	//   _adelante_, _laubasik, _آرایس_, _ammysay_, 
   {{0xadc700a6,0xe8980188,0xc86101c9,0xad9001d7}},	//   _داعدام_, _шавқу_, _meenutad, _chalanda, 
   {{0x926d0049,0x4c2c0195,0x8c3c0416,0x7d740073}},	//   _kotoa_, _albannac, _circualr, _promisse_, 
   {{0x7af00144,0x8202036a,0x42e90414,0x4c240322}},	//   _chluinst, _sitila_, _lipinga_, _bahambir, 
   {{0xdc9f0287,0xce6d0078,0x727f00cb,0x0ec801cd}},	//   _veletrhu_, _компенза, _avune_, _куркурон, 
   {{0x63b700ff,0xa26d05d0,0x5c090046,0x7a0401dd}},	// [1aa0] _מײַקל_, _lotoa_, _formatiu_, _bakambit, 
   {{0x076b0102,0xde3a001c,0x1c76015f,0x72020216}},	//   _برتاءُ_, _babayara, _cherddi_, _lerise_, 
   {{0xb40e00ce,0x437a004f,0xc66d0153,0xcde70137}},	//   _lagreman_, _ismayil_, _きっこのブログ_, _самнах_, 
   {{0x11bc00d1,0x1ddb00e7,0x36a600af,0x542804a5}},	//   _নেকেড_, _adikwema, _istedenf, _enokwenz, 
   {{0x7c7401d2,0x94940153,0x2b350433,0x283f003b}},	//   _awarank_, _宜しくお願い致し, _mapartis, _indlomvu, 
   {{0x92fc005b,0xf2bd0132,0x026d0066,0x3c500053}},	//   _guigui_, _mondtam_, _botoa_, _कॅसेट_, 
   {{0xfbe40076,0xf26c0026,0xdb0303f7,0x652e01b3}},	//   _engenhar, _volop_, _byggðin_, _спотворе, 
   {{0x7ac7027d,0x8e950660,0x30570307,0xe2020198}},	//   _zahvalje, _tiltaket_, _bengakho, _berite_, 
   {{0xcd7e0039,0x930300db,0x00000000,0x00000000}},	//   _шамбарам_, _jumalat_, --, --, 
   {{0x22020004,0xc04500af,0x895b015c,0x6c030259}},	//   _verite_, _anerkjen, _hellegke, _fuelband_, 
   {{0xd26c05b1,0x850c002f,0x5fb001b2,0x00000000}},	//   _bodov_, _alemaniy, _buttress_, --, 
   {{0xee3602df,0xac35028b,0x00000000,0x00000000}},	//   _kongsika, _japartic, --, --, 
   {{0x72ce00cb,0x1c6d026b,0xfe3200c1,0xfd960178}},	//   _узтрансг, _sonrisa_, _दुग्धशाळ, _doṣasya_, 
   {{0x22f20287,0x4d3700b4,0x912d0444,0x263d017e}},	//   _milionu_, _латинэ_, _барта_, _albigani, 
   {{0x3e3a0140,0xfdf60661,0xe40202c7,0xabf700c7}},	//   _karanasa, _nordeste_, _verraten_, _аллаһыда, 
   {{0x22bc02c5,0x3387011d,0x00000000,0x00000000}},	//   _chedoro_, _livrat_, --, --, 
   {{0x2998014f,0x825c02e4,0xe70a0162,0x54cf0064}},	// [1ab0] _унутар_, _avultuni_, _بارالايت, _иштиктүү_, 
   {{0xb73102b9,0x8c10052c,0x0ce70013,0x4e5200d2}},	//   _کھوسو_, _مایکرۆ_, _дангал_, _cacaraka, 
   {{0x827e00af,0xe25a003f,0x98d7010f,0x183c036d}},	//   _vannet_, _cholta_, _милали_, _chambrid, 
   {{0x5071013d,0x6e3a02f6,0x88d1004d,0x8c7603a2}},	//   _malamiko, _naranasa, _較新的文章_, _भुल्लर_, 
   {{0xaef100d9,0x02a102f3,0x0807004d,0x4cf900a2}},	//   _оставил_, _dödade_, _尊重網路道德_, _walemavu_, 
   {{0x53e5010b,0x3b03029f,0xc3a2005f,0xfe63034c}},	//   _baathudi_, _preprava_, _limpia_, _инсультн, 
   {{0xf1fd0036,0x06420240,0x4a6502f4,0x44960429}},	//   _soladach_, _mokimoki, _asombros, _difarduk, 
   {{0x7a57027e,0x7bfb00d8,0xff6602ce,0x9a2100cb}},	//   _динара_, _intonaco_, _nitrogén_, _akabophe, 
   {{0xf2b4005b,0xbe6a0159,0xbc6701a3,0x5d97012b}},	//   _zucca_, _дождж_, _سرٻاٽ_, _najdrożs, 
   {{0x62120662,0x36c305a6,0xe2b4005b,0xace5005e}},	//   _ikihi_, _programf, _yucca_, _مائىدە_, 
   {{0x137a00ad,0x34a802f7,0x00000000,0x00000000}},	//   _kapanan_, _bosaitek, --, --, 
   {{0xc27e01d9,0x526d023d,0x72f202a0,0x5af70167}},	//   _owend_, _impianti_, _bilionu_, _aberport, 
   {{0x3aeb00ee,0x802903f4,0x47ec0253,0x72fe0261}},	//   _entrenat, _мальчико, _allaanng, _altiras_, 
   {{0x748602d5,0xad28002b,0xf2ad02ac,0x6389012c}},	//   _मोहाला_, _নেপালের_, _ألغاز_, _upasuaji_, 
   {{0x73560101,0x8dd200ba,0x620200ea,0x8bb601b5}},	//   _necesar_, _ئیمێڵه_, _bitika_, _mathlelo_, 
   {{0xf3a30353,0xe90a0013,0xf3d40158,0x727e0219}},	//   _nadpis_, _малакаси, _झालावाड़_, _eveni_, 
   {{0xa2e800e1,0xe407011e,0x64f501c8,0xa3040075}},	// [1ac0] _madiina_, _groupman_, _kapitál_, _abbanum_, 
   {{0x497700ee,0x436f0257,0x57210073,0xa8680371}},	//   _orrialde, _tengist_, _affligev, _conosciu, 
   {{0x6060018b,0xf72a00c7,0x2a50018b,0x3c8c01c8}},	//   _presedin, _bersennä, _prietena_, _hladinou_, 
   {{0x026c0342,0xd1630217,0x5dec0153,0x00000000}},	//   _vodou_, _ultragio, _引きこもり狩り_, --, 
   {{0xe39601b8,0x92d4005b,0x1f390119,0x00000000}},	//   _ilusti_, _aikowin_, _harumama, --, 
   {{0xa5780156,0xa92a00a5,0x0eb60025,0xe7200187}},	//   _טעללער_, _loomatua_, _bandhanā, _импресив, 
   {{0xd2010050,0x32e60061,0x4394000d,0x00000000}},	//   _ngaing_, _입찰보증금_, _seisma_, --, 
   {{0x4e2d01b3,0x73f80119,0x275a00f7,0x163603ae}},	//   _колисков, _namuno_, _budhanaj_, _vernepli, 
   {{0xd2fe0448,0x79ff00f2,0x654e00e6,0x1a250109}},	//   _skrives_, _nesaprot, _公安民警与您相约_, _क्लबका_, 
   {{0x428c02fe,0x833d0029,0xe6b900ea,0xbb89005e}},	//   _مقدماتي_, _نیوان_, _fanamari, _ئۇشتۇمتۇ, 
   {{0xddff007a,0xf80800e4,0x3a10017a,0xe2630400}},	//   _kelewata, _गद्दारी_, _akubanga_, _allungal, 
   {{0x35ac0157,0x8d260160,0xdc260449,0x00000000}},	//   _आत्मघाती_, _uspomene_, _uspomenu_, --, 
   {{0x1d80003d,0x3f5502f4,0x06b903d9,0xf9770396}},	//   _tenement_, _desplaza, _hanamari, _diminutt, 
   {{0x9aee0125,0xe0460178,0x2365029e,0xdf3204ac}},	//   _билдирен_, _anairyāṇ, _abugida_, _костей_, 
   {{0x7f150366,0x82db0040,0xcb88030a,0x1d8900da}},	//   _блогов_, _פליקס_, _novoneyr, _povestit_, 
   {{0x7838015d,0x31110159,0x50a00019,0xc4bf01ab}},	//   _स्प्रिंग_, _surengė_, _тезирээк_, _गँवइऽऽह_, 
   {{0x527800fe,0xf27f0292,0xeb590217,0x29fa04f8}},	// [1ad0] _nounou_, _akanfo_, _accusava_, _database, 
   {{0xa396022d,0x62a60193,0x290100e6,0xdfb8011a}},	//   _flussi_, _sumbar_, _郭晓冬做客_, _אתאיסט_, 
   {{0xb8fc03d9,0xc1650125,0x62ad02ac,0x78d90128}},	//   _tolakand, _aralaşma, _بتطبيق_, _бекжон_, 
   {{0x121201c5,0x83cf03c2,0x9ebe045f,0x00000000}},	//   _dhaho_, _adsvn_, _datorern, --, 
   {{0x726d00db,0xea5d00bf,0xb7f503fd,0x9fae00af}},	//   _fotod_, _последую, _fetalaig, _байки_, 
   {{0x12d8018f,0xe37900a2,0x3e7400c8,0xc27e0663}},	//   _aqleh_, _kitaifa_, _күмер_, _nwene_, 
   {{0x92130544,0x2711014a,0x0c550219,0x58360053}},	//   _ahahui_, _جنازے_, _aketame_, _एन्जॉय_, 
   {{0xaadb002b,0x22f10085,0x72910304,0x739500d6}},	//   _গোলাপী_, _mitiani_, _akuan_, _deasca_, 
   {{0xb30501ec,0xb2c301e6,0x65140193,0x7b7800d6}},	//   _جوراب_, _doslova_, _गर्दीत_, _achomair, 
   {{0xe4ec0169,0xd2ab0487,0xcc22009a,0xab4f005b}},	//   _নাগাদ_, _bonding_, _ayesakub, _dramater, 
   {{0x62d801d9,0xbec10040,0x035e0188,0x7cd5015e}},	//   _immens_, _פרוטוקול_, _лахза_, _تىزگەن_, 
   {{0xd9ab0014,0x32d4001e,0x6cf00664,0xda5d035d}},	//   _መዘናግዒ_, _dokokin_, _नीलकंठ_, _putevima_, 
   {{0x92b40294,0x298e032d,0xe278002f,0x00000000}},	//   _arcce_, _сабит_, _hurnal_, --, 
   {{0x47ee02b2,0x5cee04c7,0x67f500e5,0x416c0291}},	//   _нідерлан, _броду_, _passará_, _للأكل_, 
   {{0x4eb20099,0x16e9004d,0x92d20307,0x324200a6}},	//   _akazokwa, _截止收件期限_, _lasemini_, _دنشتوالي_, 
   {{0xeaea0148,0x33a80022,0x67f90060,0x780c0022}},	//   _claritat, _dikateng_, _شامالاۋع, _поездарҙ, 
   {{0x525a032e,0x0dd1021c,0xb0870162,0x9f66027b}},	// [1ae0] _qullan_, _službami_, _ﺳﺎﻳﺎﮬﻪﺕ_, _बालचन्द्, 
   {{0x39d60177,0x5cbd005b,0x527e00cf,0x0e27008e}},	//   _ироуртә_, _covayasu_, _gannat_, _liggeeya, 
   {{0xe29104c3,0x720000bc,0x364b00d6,0xbebb0148}},	//   _thuat_, _exail_, _maghribi, _文化資產類_, 
   {{0x5386001b,0x3ece0044,0x6b4f0101,0x2e7b0262}},	//   _seera_, _decision, _trimiter, _antakýan, 
   {{0x7a830373,0x32b50203,0x063101aa,0x79eb0053}},	//   _grandajn_, _grecos_, _athletew, _supriyad, 
   {{0x826d015c,0x640e031a,0x827e0013,0x9ced0082}},	//   _fotoe_, _beirsinn_, _jannat_, _kanjamau_, 
   {{0x92010077,0xf65e011b,0x995e01a0,0x8875059a}},	//   _deziye_, _kiekieki, _khunyete, _telemóve, 
   {{0x7d1a018d,0xe2910079,0x82020028,0x3e3a02cd}},	//   _ኣዒንተይ_, _edgars_, _weriye_, _garabasa, 
   {{0x00da0153,0x00000000,0x00000000,0x00000000}},	//   _クリスティ_, --, --, --, 
   {{0xf0f90008,0xe3fa012c,0x6b7200ee,0x39f20299}},	//   _بووبەك_, _hatuna_, _стенк_, _ئەجدات_, 
   {{0x9d8f018d,0x7e3a02af,0x47ce027f,0xb42202d4}},	//   _ፑንትላንድ_, _karabasa, _abatumiw, _segirezz, 
   {{0xa39400a0,0x312c0040,0x48db0151,0x7a0c009a}},	//   _kunsa_, _צלצולים_, _altrooag, _راستنيدو_, 
   {{0x826c00f1,0x96c5012e,0xe6e804eb,0x540b0291}},	//   _dilon_, _تونسہ_, _जलाभिषेक_, _وفواكه_, 
   {{0x597802ac,0x884b021b,0x20a70388,0x55bb042a}},	//   _موآضيع_, _kokoontu, _виновни_, _bekangah, 
   {{0xe9f70294,0x72c30527,0x2d9c005f,0x90c10224}},	//   _anankuna_, _poslova_, _homenaje_, _fagfólk_, 
   {{0xa27e00bd,0x727a0240,0xc2e802f9,0x2e3a01ad}},	//   _winnie_, _kilikili_, _aplikan_, _nababara, 
   {{0xe2dc03ad,0x48e601be,0x62550139,0xb35602ed}},	// [1af0] _notevoli_, _न्यूयोर्, _विशेषा_, _desexas_, 
   {{0xd2910291,0xa1380092,0x02690157,0x1d080239}},	//   _thuas_, _続きをよむ_, _emerytal, _koronete_, 
   {{0x97e703dc,0xa9830080,0xee3a0322,0x00000000}},	//   _samanleg, _fleisvhe, _barabasa, --, 
   {{0xa9b000b0,0xe8fc04df,0xd37a010e,0x00000000}},	//   _fardowsa_, _dolanand, _hilahil_, --, 
   {{0xa0ef0281,0x7a120198,0x00000000,0x00000000}},	//   _atsiirol, _povablje, --, --, 
   {{0x72ea01f7,0xc35e02a3,0xeff70309,0xd75900b9}},	//   _estiman_, _wingerd_, _kadrları, _आवर्जुन_, 
   {{0xa26c0261,0xe41d0107,0x15e80242,0x427f0102}},	//   _filon_, _مانگا_, _memarlıq_, _chanjo_, 
   {{0x929b0036,0x9e4100a7,0x6e24026c,0x897c0159}},	//   _أكياس_, _repartit_, _sermones_, _азерны_, 
   {{0x3d430040,0x0c5d04c8,0x03cf03b0,0x00000000}},	//   _סטייק_, _mhuwiex_, _krevje_, --, 
   {{0x00dd001a,0xb27301ab,0x46d9028b,0x42f10291}},	//   _تیاری_, _tänan_, _ихҵоуп_, _تجربتك_, 
   {{0xb61f025b,0x3a71012c,0x2395012c,0xc30c0396}},	//   _dronguri, _watakiwa_, _ngassa_, _ispazju_, 
   {{0x1db30101,0x02500128,0x716e01cd,0xc2e900d2}},	//   _sanatate_, _десам_, _abashoko, _batinna_, 
   {{0x4ed3014e,0x43860243,0x8df50121,0xe3950055}},	//   _негодова, _deero_, _garantía, _anessi_, 
   {{0xc386030b,0xfd170075,0xeffe0029,0x23fa01fa}},	//   _leero_, _ivaleyst_, _ستتێوه_, _natula_, 
   {{0xfc6b02be,0xd91700c7,0xe9e50092,0xeff60488}},	//   _malupit_, _ливанда_, _おめでとうござい, _deklarāc, 
   {{0xf2ca00b4,0x9f4001a7,0x972f03ee,0xe3a80022}},	//   _acelasi_, _amerikka, _isplativ, _bokaneng_, 
   {{0x6f1f0217,0x4c53034e,0xd8d90153,0x326c0202}},	// [1b00] _misdemin, _castapa_, _本ウェブサイトで, _niloo_, 
   {{0xd9c302ca,0xa63e034c,0x00000000,0x00000000}},	//   _يالبى_, _galiulli, --, --, 
   {{0x080903cc,0x32da00f3,0xee4a000d,0x238602ec}},	//   _বেপরোয়া_, _bawela_, _detailne_, _beero_, 
   {{0xd7250018,0x35da01cd,0x1a0f00d9,0xfb120258}},	//   _guilecav, _абармард, _uskaltaa_, _oergeuns, 
   {{0x137d002b,0xf0dc0125,0x6304029d,0x00000000}},	//   _ফলোআপ_, _bisowatl, _ecranul_, --, 
   {{0x1da4023d,0xdf0f01a9,0xf3700040,0x15070022}},	//   _очила_, _marcados_, _גזעיים_, _буласағы, 
   {{0x4e180021,0x430f0047,0x8e3a00b0,0xec030144}},	//   _unregula, _essayer_, _tababara, _bruscar_, 
   {{0xf8800092,0xe47b0057,0xa6590220,0xdcaf0177}},	//   _この記事の_, _dihebahk, _прозорец, _кәрченко_, 
   {{0x1a88003b,0x76e9018d,0xd1290320,0x2ff6033c}},	//   _tinyatse, _ኣእትዮም_, _darwenfo, _archebio, 
   {{0x7e3a0084,0xf2e702f3,0x42e90448,0x5c9c02fe}},	//   _sababara, _chansen_, _blandet_, _anezipor, 
   {{0x2d9d0076,0x9c60000f,0x00000000,0x00000000}},	//   _прецизни_, _soyunma_, --, --, 
   {{0x23fa0281,0x1a680094,0x838300ef,0xb8670222}},	//   _matuma_, _باقتاشىل, _ayoyise_, _monstres_, 
   {{0x327f00d5,0xb79a00c5,0x0eb002dc,0x6dd50210}},	//   _akanjo_, _中国储备粮管理总, _cárcere_, _akakomba, 
   {{0xf26e0288,0xfdb80527,0xf291010d,0x00000000}},	//   _daroom_, _potrebnu_, _skuat_, --, 
   {{0x02d8006a,0xe19a01c8,0xed860090,0x817503b7}},	//   _maheno_, _nerezová_, _aswedere_, _aronsbay_, 
   {{0x5ee900c5,0x0af10142,0x4c7c0014,0x00000000}},	//   _江规建字江海_, _bahukirt, _emision_, --, 
   {{0xa25a0202,0xc6310147,0x47ab0333,0xc200019c}},	// [1b10] _abilé_, _جلۇۇلۇق_, _acquazzi, _kinium_, 
   {{0xa3a301bb,0xb36a03f5,0xc7070135,0xea580403}},	//   _sarpa_, _aluguer_, _gaetennä, _haleloia_, 
   {{0x46490342,0xf1660238,0x02010178,0xc68f0421}},	//   _machandi, _футболіс, _apaihi_, _urgestei, 
   {{0x7b740128,0xe39403fd,0xc7140159,0xcc6100c3}},	//   _اورمانزا, _ashsrb_, _balticum_, _uterque_, 
   {{0x3c7403c7,0x154500f6,0xd96300da,0xcd3602b4}},	//   _वृध्दि_, _aktivliy, _imunitat, _iphindze_, 
   {{0xe43b0037,0x7b620260,0xe25a0003,0xa27d0037}},	//   _መንግስታዊና_, _estreita_, _vullen_, _በማለታቸው_, 
   {{0x2615016f,0xc0480311,0x44790178,0x2f640043}},	//   _атлантич, _ኣጋጢሙዋ_, _caiṣo_, _banaasin, 
   {{0x32ff02a4,0x405601f2,0x615c0162,0xd2d801db}},	//   _pariter_, _ﺋﻪﻧﮕﯩﻠﯩﻴ, _қулан_, _турнирле, 
   {{0xd8fc0243,0x37150212,0x426c0120,0x1bc9007e}},	//   _antafaqu, _platnium_, _bilol_, _apakṛṣṭa, 
   {{0x83ea0342,0xbf270025,0x12d800ea,0x103104c7}},	//   _achte_, _ahoratra, _naheno_, _непримет, 
   {{0x225a01a1,0xcc61005c,0xaddd04a6,0xff6601ef}},	//   _zullen_, _butumwa_, _projekat_, _умела_, 
   {{0x373c0092,0x4ad0013a,0xd2aa0665,0xc86a0196}},	//   _マイクロソフト_, _beetebue, _geocellm, _atangofu, 
   {{0x7e0100e4,0x3eb80008,0x726d023e,0x36b60291}},	//   _rejestra, _incendis_, _botoh_, _malartui, 
   {{0x33380297,0x4d3602f0,0xd386024a,0x7afc00e6}},	//   _жанрлары, _aphindze_, _geere_, _第二代身份证_, 
   {{0xab1f01d2,0x53fa024f,0x03950206,0xcc7c0279}},	//   _allankan_, _katuba_, _klesli_, _boisson_, 
   {{0x09d50044,0xdc770342,0x5dd3032d,0x1e320227}},	//   _מוצלח_, _dansite_, _гуашь_, _panggila, 
   {{0x83860202,0xd394005b,0x327d0142,0x45b502d4}},	// [1b20] _beere_, _junsu_, _प्रयुञ्ज, _cumposiz, 
   {{0x2db30330,0xfb780009,0x526c012c,0x164d01c2}},	//   _saniraya, _železoce, _ondoa_, _apróbase_, 
   {{0xea1d0398,0xc38600f7,0xb2f60206,0xa8c70109}},	//   _començar_, _veere_, _farizej_, _धूमपान_, 
   {{0x7249026b,0x12ca01b6,0x038003dd,0xd3860129}},	//   _llamar_, _orodha_, _revistës_, _weere_, 
   {{0xc832015e,0xffbf0174,0x726c01d2,0x12a60059}},	//   _نازىر_, _feleletš, _andoa_, _debba_, 
   {{0x526e03e8,0xe7300024,0xb0410177,0x7a7302f6}},	//   _šport_, _নাহৰকটীয, _рзыҟанаҵ, _dalagita_, 
   {{0xc2fd0068,0x63160044,0xfa5d0008,0xc21f042c}},	//   _aragti_, _pointing_, _расизмге_, _značajne_, 
   {{0x02910082,0x42fe02c7,0xcf170184,0x326d0009}},	//   _ayyana_, _sichere_, _igodomon, _motoi_, 
   {{0x60ce0276,0x5d010115,0xf394000e,0xc67b0212}},	//   _تەكەببۇر, _pertutur, _munst_, _adventum_, 
   {{0x02910440,0x2d2d0040,0x8a3800e6,0xed64019c}},	//   _ntware_, _משלהם_, _睡前不能吃的五种, _ikasilẹ_, 
   {{0xeeea003a,0x42e701fb,0xb19a01c8,0x4d8f00cb}},	//   _тилларид, _fornira_, _nerezový_, _akalinga, 
   {{0x1ccc0205,0xbd130095,0xcbdd0059,0x00000000}},	//   _میوند_, _abdurrac, _николова_, --, 
   {{0xb4d10193,0x18c701e9,0xe14f00fc,0x32d800ab}},	//   _मालिका_, _buitemog, _mamodmeh_, _paheno_, 
   {{0x707d00c7,0x7341006f,0x001700e6,0x3a130078}},	//   _барсы_, _kupenda_, _广西自治区_, _духовног_, 
   {{0x9deb012c,0x20360176,0xac7c00df,0x6a8a0400}},	//   _سڃاتو_, _lovesick_, _poisson_, _arridoss, 
   {{0x9386008e,0x3dbb01cf,0xe6fa0086,0xd7400279}},	//   _seere_, _archaisa, _شہوانی_, _endommag, 
   {{0x5dbc0072,0x73a301ea,0xc7b801b5,0x0c45026b}},	// [1b30] _arkirina, _barpo_, _arhwaliw, _desconec, 
   {{0xd2d50233,0x72b4008c,0xe2490005,0x513a01d1}},	//   _afollat_, _bucca_, _clamar_, _hardball, 
   {{0x084a0287,0xb052046b,0x46bf040f,0xa2e80116}},	//   _detailů_, _allgello, _ўдалося_, _forfar_, 
   {{0x32910184,0xe9670003,0xe09b02ac,0x238601c2}},	//   _atware_, _schoonhe, _تراخيص_, _aforas_, 
   {{0x7595022c,0x517d01ee,0x434100c4,0x126d0275}},	//   _kapercay, _барамехь_, _hupenda_, _sotoa_, 
   {{0xf5380071,0x49770244,0x00000000,0x00000000}},	//   _اواتار_, _addiritt, --, --, 
   {{0x437a0402,0xf7a7021c,0xf3eb012b,0x37ca00af}},	//   _capaian_, _integrov, _klimatyz, _motsetni, 
   {{0x77850053,0xbbee028a,0x1679014e,0xce24015e}},	//   _प्रागैति, _chimbuko_, _вартолом, _germanes_, 
   {{0x3b1b0132,0xc58c04ca,0xc706033e,0x83030085}},	//   _funkció_, _angiospè, _hivralté, _suvavou_, 
   {{0x2ad702c2,0x7e0200d2,0xd26c02c6,0x7c730223}},	//   _verwikke, _bebenera, _diloc_, _толины_, 
   {{0x63730414,0x960103a2,0x3e240156,0xb38003dd}},	//   _maladie_, _हिनदी_, _אָנטון_, _revistën_, 
   {{0x587a020a,0x767201f3,0x00000000,0x00000000}},	//   _табандыл, _kruhová_, --, --, 
   {{0x4b1f034c,0xa3710564,0xbb6300e9,0x137c03e7}},	//   _sanalgan_, _tatalif_, _obsesyon_, _jipapad_, 
   {{0xa6950310,0x030504dc,0x727e03fb,0x97b00291}},	//   _capercai, _دوعام_, _jednih_, _سلحفاة_, 
   {{0x825b0287,0x5eb603ac,0x30520061,0x62d901c4}},	//   _omylem_, _menolakn, _부과됩니다_, _optel_, 
   {{0x926d0192,0x9e010164,0xfd8d039d,0x7dcd00a4}},	//   _noton_, _исмаил_, _demokira, _азабын_, 
   {{0xa3f003c2,0x0252018e,0xabd10193,0x92fa02aa}},	// [1b40] _scheming_, _etilweni_, _सदियो_, _deformuj, 
   {{0xd38703f0,0x52ad02b2,0x326d016b,0x6852001c}},	//   _hvergi_, _нововвед, _hoton_, _awardees_, 
   {{0x0aa1023c,0x426400b6,0xd21201a6,0x075a0060}},	//   _پريږدۍچې_, _bisleh_, _akihi_, _دالالارد, 
   {{0xfd0302ee,0xec5904b2,0xedae021b,0xc30e0159}},	//   _applikat_, _malusog_, _vertailu_, _rizikuoj, 
   {{0x38f90184,0xfdbd0015,0x4b0a005b,0x71fd0077}},	//   _badaharu, _arrinkaa, _bunsyoka_, _lilavach_, 
   {{0x10af0513,0xdc5d0311,0x00000000,0x00000000}},	//   _khomelel, _ኣተኣሳስራ_, --, --, 
   {{0x0d5e0025,0x5656019d,0x237901a9,0xe1130021}},	//   _कार्यसिद, _akukambi, _tomando_, _alikeway_, 
   {{0xdc6f0285,0xaf57029f,0x624800c3,0x43940363}},	//   _itorero_, _uplatnen, _summam_, _lunsj_, 
   {{0xc02e056e,0xa23b041b,0x01f40381,0x2f5c032c}},	//   _referido, _suklang_, _amageday_, _angalaan, 
   {{0xd2b40113,0x221204bd,0x8d8e02f3,0xee2b01d3}},	//   _pucci_, _ikahi_, _engelskt_, _morgonda, 
   {{0xfb030437,0x1415003c,0x1f4f0311,0xa29103ef}},	//   _webstede, _پسردلفین_, _መንፈሳዊት_, _atwaye_, 
   {{0xa38600cf,0xee6803ea,0x02ee0103,0xfc0903d9}},	//   _heera_, _concerna, _nyanzvi_, _sampana_, 
   {{0xc231015e,0x4408024a,0x534300af,0xe979022f}},	//   _límits_, _lokunrin_, _володар_, _баптысцк, 
   {{0x43ea0113,0xdb090073,0x226c0211,0x31dc003c}},	//   _achta_, _campinet, _kiloa_, _alkitabé_, 
   {{0xc3ea0250,0x826d0295,0xe2910077,0x69f60096}},	//   _flitet_, _lotoo_, _etwaye_, _babizeza_, 
   {{0x6c2600ff,0x821201ed,0x5a8b014d,0xb0dd0122}},	//   _אינטימע_, _okahi_, _planungs, _نیمرو_, 
   {{0x6d4704f9,0x028e0334,0xb5ee0564,0xd2c7003c}},	// [1b50] _kalaaleq, _amakono_, _pamenodö, _asumber_, 
   {{0x72b5026c,0x1f5d0154,0x9d9e0359,0x98840148}},	//   _fusce_, _краковия_, _sitearje_, _dilithiu, 
   {{0xe2fe028d,0x40cf014a,0xf2da010b,0xa02103e6}},	//   _kishore_, _baloldal, _kwantle_, _hanergro, 
   {{0x5ea202a4,0xe99801bb,0x00000000,0x00000000}},	//   _contione_, _bolšy_, --, --, 
   {{0xa7f30025,0xac69017e,0x8c04024a,0x18b20217}},	//   _सामान्यं_, _intrigo_, _beesini_, _destruev, 
   {{0x411004dc,0xb8550350,0x02a301e5,0x00000000}},	//   _میکرۆبه_, _ማስታገሻ_, _tétété_, --, 
   {{0xabca015e,0xb35f037c,0xa02001f0,0xb05a019d}},	//   _بارماقتا, _fingere_, _direkoto, _atesalon, 
   {{0x3c0f0192,0x538b0073,0xa3560041,0x0d88003e}},	//   _오피스텔분양권_, _beryllo_, _иҵаҧжәеи, _dinerefe_, 
   {{0x8c55007b,0x00000000,0x00000000,0x00000000}},	//   _moothie_, --, --, --, 
   {{0x13860482,0x031d0073,0xb9ca04ec,0x72120133}},	//   _geeri_, _functio_, _botorera_, _dhahu_, 
   {{0x19f602e3,0x5ae50262,0xafae01cd,0xf05a0216}},	//   _truân_, _bellenen_, _халку_, _etesalon, 
   {{0x1a7f0162,0x00000000,0x00000000,0x00000000}},	//   _ساپاسىغا_, --, --, --, 
   {{0x33030040,0xfe86026b,0xfb030138,0x513a03c2}},	//   _רנטגן_, _proviene_, _kürdista, _barelagh_, 
   {{0xda830003,0xba2a0092,0xd9cf0041,0xe40201f1}},	//   _genieten_, _エンジェル_, _аҟәҕара_, _rezulton_, 
   {{0x1c5f0666,0x9f010148,0xe22b02de,0x0d8f0011}},	//   _obitelj_, _中國圖書分類法查, _प्राब्लम_, _akalunga, 
   {{0x322b00be,0x9d050038,0xc25a01df,0xa396005b}},	//   _ئيگەرسىن_, _populyar, _pullin_, _bousui_, 
   {{0x48800224,0xd2d80230,0x426d02c3,0x9b19038b}},	// [1b60] _hamingju, _komers_, _kotol_, _lepaskan_, 
   {{0x8110027b,0xa3de0211,0x7a0a024c,0x00000000}},	//   _डुकृञ्_, _подобран, _gensillu, --, 
   {{0xebe20297,0x4a8d0192,0x7f0f03b7,0x00000000}},	//   _белогорс, _전문가들은_, _austiewa, --, 
   {{0x2f9b00a8,0x697f05f4,0x90e801c9,0xd6900135}},	//   _scherrer_, _alphapat, _अनुकूला_, _амперлар, 
   {{0x496a010f,0xa73101d5,0xf73f01a3,0x00000000}},	//   _самарано, _پھنسے_, _ڀوڏيسر_, --, 
   {{0x8f980192,0xf26d0101,0x43ea0176,0xbc290358}},	//   _기타레포트_, _altor_, _amitie_, _angletè_, 
   {{0x31c60177,0x2ea80039,0x00000000,0x00000000}},	//   _клубқәа_, _юнител_, --, --, 
   {{0x527f0500,0x026d02f6,0xb2d500e3,0xfc6f0064}},	//   _mwenzi_, _totoo_, _bibliku_, _daurada_, 
   {{0x627e0245,0xada5012c,0xfece009b,0x97920178}},	//   _tynnad_, _takukuru_, _хагарсан_, _कौटिल्ये_, 
   {{0x33eb01ba,0xe25d03b2,0x82ea0279,0x93ea045f}},	//   _alatet_, _fiveprim, _pointes_, _slitet_, 
   {{0x6e940127,0x66a902f6,0xeb6a00e6,0xa2c50155}},	//   _statique_, _pangingi, _土豆客服说_, _bromsar_, 
   {{0x730f021a,0xf26c01c5,0x47550223,0xffe70100}},	//   _barbada_, _bilow_, _путинд_, _knjižicu_, 
   {{0x43f60513,0x7d5a0235,0x7c2500e6,0x638600b4}},	//   _avelanak, _प्रभावः_, _未持有本公司股票_, _ofere_, 
   {{0x031004df,0x52d90235,0xc3fa0083,0x01dc0351}},	//   _agraldy_, _भारतीयसं, _actura_, _малтанхи_, 
   {{0xe60b02b2,0xe320004e,0xef4a00c5,0x4c560077}},	//   _вчора_, _tanyag_, _régions_, _apatide_, 
   {{0xb2d900b9,0xf2d9010d,0x003c03a2,0x8e1805d5}},	//   _भारतीयां, _iptek_, _बेकहम_, _inregula, 
   {{0x0be9018d,0xa3160161,0x4e3503a4,0x99690602}},	// [1b70] _መልክዑን_, _занятие_, _berghama, _komikere, 
   {{0xc7e3006c,0x89830041,0xa407038b,0x515300ff}},	//   _комили_, _añoitént, _dibolehk, _abortigo, 
   {{0xc51900a6,0x75850082,0x00000000,0x00000000}},	//   _یوناني_, _ishtirak, --, --, 
   {{0xb38603da,0x53c80667,0x02f00341,0x23940226}},	//   _efere_, _houver_, _limitli_, _kunsi_, 
   {{0x437b0130,0x83c8047a,0xbd8d0067,0xb74503a8}},	//   _dispakañ_, _kouver_, _beeljiya, _arkivavg, 
   {{0x5c59019e,0xa27f0447,0x130c02b2,0x2a7d0464}},	//   _запамята, _bwenzi_, _россійсь, _kumarira_, 
   {{0x62120464,0x719a01e6,0xd2120285,0x6e430296}},	//   _shahu_, _nerezové_, _nkaho_, _orsakade_, 
   {{0xfdd00061,0xa2a6006e,0xea8a0060,0x8e4600ed}},	//   _회원에게만_, _cumbur_, _атышулы_, _mapanuga, 
   {{0x37b501ef,0x336d01f1,0x6df0040a,0x00000000}},	//   _tobulini, _largimi_, _söderut_, --, 
   {{0x09f602fa,0x72f800be,0x52fd0194,0x426d03d1}},	//   _habineza_, _جاعراپىي, _oldijar_, _dotos_, 
   {{0xaece04fe,0x8dc801bb,0x3b0d022c,0x226c00bc}},	//   _decizion, _усулы_, _alesanna_, _didol_, 
   {{0xfff90052,0xc642004a,0xacbc0133,0xda1b0037}},	//   _अस्थायी_, _alınğaç_, _baradhuu_, _puncanya_, 
   {{0x3d4800c7,0xcaf70213,0x10e00188,0xc696017c}},	//   _ибсен_, _наречия_, _педагогӣ_, _anteckni, 
   {{0x0af903fc,0xc291021a,0x34840013,0x7b2d0183}},	//   _tunnelen_, _argate_, _учинчиси_, _damaskos, 
   {{0x72900301,0xf1450199,0x92f10342,0x432702a9}},	//   _idman_, _yesmoney_, _strikti_, _paramą_, 
   {{0x226d001c,0x628d00f4,0x584b03de,0x3cdc0061}},	//   _botos_, _blakenn_, _kwamathu, _아잉루나는_, 
   {{0x1c630372,0xb99c00d1,0xe3b7008a,0xcc0100c5}},	// [1b80] _astudio_, _বাইন্ডিং_, _atuvasa_, _ressort_, 
   {{0x838701d2,0xc2fe016a,0x00000000,0x00000000}},	//   _avaroa_, _altigas_, --, --, 
   {{0x6e530108,0xe339018d,0x69e5013b,0xb26e008a}},	//   _masaraka, _እትሕተም_, _barumbad, _petoni_, 
   {{0xcc5200d6,0x70ef0139,0x426d01cf,0xc60a0037}},	//   _godthla_, _adhaḥśir, _totos_, _ከሚያዚያ_, 
   {{0x8b80027b,0x3ec90040,0x1c5a0005,0x11a20276}},	//   _विषमं_, _polymera, _arduond_, _ئۆلەي_, 
   {{0x726e0145,0x49d0004c,0xf291033f,0x00000000}},	//   _netoli_, _balewube, _sevalu_, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xc0ec02f0,0xf290004e,0xa2c20334,0xbc470024}},	//   _amendlul, _adman_, _amaliza_, _সৰ্গিত_, 
   {{0x92bf01ec,0xa343028d,0xde3a02f6,0x00e203c2}},	//   _گمنام_, _altermo_, _karahasa, _beanstal, 
   {{0x626d026b,0x53f40181,0xc9ee0013,0x0c220008}},	//   _votos_, _tastic_, _tortishu, _жемкорду, 
   {{0xd2000578,0xa68c0668,0xaea8040f,0xa2d801c5}},	//   _txais_, _सुवास_, _анатоль_, _sideed_, 
   {{0x649f002b,0x465200ba,0xbeba0350,0xb2b3014e}},	//   _দৃশ্যপট_, _ڕیخۆڵه_, _ለማሰለፍ_, _menjač_, 
   {{0x83730222,0xdf5c01b2,0xf26e033f,0x7a890175}},	//   _demande_, _sulphide_, _fetoli_, _linivers, 
   {{0xc3ea0263,0xd29000dc,0xc38e01dd,0x1e4c001b}},	//   _echte_, _aviata_, _agustini_, _fafakkaa, 
   {{0xa4ad01f6,0xcda203ce,0x126d021a,0xf0660085}},	//   _ছাত্ৰীৰ_, _زامنی_, _botor_, _tamamudo, 
   {{0xc6800235,0x92300239,0xba1b00e2,0x7791023d}},	//   _विशां_, _itamara_, _kampeard, _protetti, 
   {{0x23440187,0x2017005e,0x053c0272,0xa34900f2}},	// [1b90] _недостиг, _ئىچرە_, _anzizaay, _baseini_, 
   {{0x628d02c1,0x9f370193,0x7cae0193,0xd26c00bc}},	//   _imikino_, _persyara, _bersaing_, _bilou_, 
   {{0x689100ae,0x00000000,0x00000000,0x00000000}},	//   _akikangu, --, --, --, 
   {{0x65180377,0xa2d704c0,0xbea204c7,0xb2ab04c9}},	//   _profilul_, _soronko_, _инсистир, _aprikã_, 
   {{0xb2a70024,0xc38602d8,0x72f1002a,0xa25b0414}},	//   _verba_, _geert_, _striiti_, _ebalé_, 
   {{0xa2eb0564,0xe6ba0478,0x9a43048a,0xe9d5026f}},	//   _espinho_, _cavalari, _торпақ_, _قاۋقار_, 
   {{0xa8fe02e5,0x00000000,0x00000000,0x00000000}},	//   _иреиуоуп_, --, --, --, 
   {{0x23780294,0xad0002fc,0xb5d7015d,0xc34800bd}},	//   _achalan_, _abitegur, _plebiscy, _enyeuch_, 
   {{0xd3fa0669,0x03f20163,0xa2ca00b7,0x353b02bb}},	//   _yatula_, _manuális_, _bakdy_, _marynarz, 
   {{0x12ca00d7,0xa301003f,0x22d70390,0xdd1000a4}},	//   _bolebedi_, _duraddi_, _bitlcus_, _كيمەشەكت, 
   {{0x415d0244,0xeeba0037,0xb15603d5,0x42d800e4}},	//   _assunzio, _ለማሳለፍ_, _baillesh_, _biletu_, 
   {{0x2250029d,0x30530059,0xde94006e,0xf51001c9}},	//   _чебан_, _носител_, _kampañu_, _koolijuh, 
   {{0x17be00a4,0x284e01e1,0x53470008,0x1d4e032d}},	//   _استنعى_, _проектын_, _calella_, _докладын, 
   {{0x40c104d2,0xd291023b,0xe3a90148,0xc2b5013a}},	//   _verktøy_, _augate_, _solvere_, _drecks_, 
   {{0xf87d019b,0x0d260219,0xb3a90220,0xb2ef01ec}},	//   _кампанія_, _ashonele_, _polvere_, _chafid_, 
   {{0xc0730159,0xf2fd003a,0x13a20074,0xc09600bc}},	//   _papasako, _bolalari_, _инфракра, _جاسازی_, 
   {{0x9794004d,0x94d500de,0xd5710334,0x25fa0307}},	// [1ba0] _你就渾渾噩噩的過, _انصافه_, _anatuluk, _esemanzi, 
   {{0xe36c017d,0x871b038f,0x73fa0328,0x0df704ae}},	//   _byggeri_, _akordeoñ, _batuma_, _развила_, 
   {{0x45730037,0xf4da014e,0x00000000,0x00000000}},	//   _በዚምባብዌ_, _поена_, --, --, 
   {{0x627f0359,0xc7470281,0x4fd70354,0xa5f30022}},	//   _eigner_, _katillug, _рамалла_, _доценты_, 
   {{0xd38702b1,0xa2910541,0x2f1400ba,0x63bd0093}},	//   _kwarya_, _pevaju_, _مێستاکه_, _шайхи_, 
   {{0x88620662,0xa6c401c5,0xf322004d,0xeb1700c1}},	//   _takathur_, _argagaxi, _不能說的秘密_, _दणदणीत_, 
   {{0x34c103ac,0x061400c5,0x5d9c0242,0xb22500c7}},	//   _memberik, _经络锻炼法_, _üstündə_, _bersenä_, 
   {{0xe0dd0163,0x4bfe053b,0xb7f803ce,0xb2a700f7}},	//   _ہیلری_, _colocado_, _سانترالی, _herbo_, 
   {{0xfa0102c2,0x48d90107,0x5d05011d,0xb2d60567}},	//   _verskeid, _گمرکی_, _preluate_, _сынаулар, 
   {{0x1c580162,0x1899006c,0x5302039d,0xb39000be}},	//   _قاتارىدى, _abakhanu, _wahashu_, _تويبودۇڭ_, 
   {{0x816902f5,0xf8dd02ac,0x0f090022,0x00000000}},	//   _completo, _الحظر_, _бюджетҡа_, --, 
   {{0xb305019f,0x0ae200cb,0x00000000,0x00000000}},	//   _رولاڪ_, _колхозу_, --, --, 
   {{0x63560203,0xf9d70332,0x43790022,0xaaff01ad}},	//   _decelar_, _vegetale, _furalla_, _kansilye, 
   {{0x334803c7,0x826d0014,0xb347024a,0x2ff3066a}},	//   _klienci_, _botoi_, _kujenra_, _milyones_, 
   {{0x10410005,0x31fa019d,0x22e60297,0x2c740148}},	//   _requiren, _alinkuim, _gimnın_, _intulit_, 
   {{0x53ba0059,0xa27603b7,0x726a004f,0xbc750012}},	//   _преместв, _alladium, _disaaynë_, _होख्बा_, 
   {{0x42240342,0xc2f0040a,0xc7ee02c2,0x82130119}},	// [1bb0] _manke_, _höger_, _bepaling, _ngahaw_, 
   {{0x03fa001e,0xdb320010,0xcaa400bf,0xd907015a}},	//   _matuka_, _athazeks, _гласных_, _dabaluud, 
   {{0xd2a604cb,0xb36c02ba,0xb0130222,0x5ed5004b}},	//   _bumbac_, _amagoli_, _survivan, _булгас_, 
   {{0x9e3a022a,0x3119018d,0x125a018f,0x789b0185}},	//   _angatura, _ኣንጻሮም_, _choldi_, _burjanad, 
   {{0x2d01066b,0xb2e9010f,0x13eb01ba,0xd2d90045}},	//   _སྒྲུབས_, _силоҳбад, _rapti_, _dodelu_, 
   {{0xb24a0150,0x43160206,0xbef10388,0xe39b0416}},	//   _jasmen_, _zmizli_, _оставим_, _simplicm, 
   {{0xc2f203d8,0xe46502ea,0xa3860144,0x00000000}},	//   _napominj, _superato_, _éirne_, --, 
   {{0x1531012a,0x2d0b0415,0x3ced002e,0xfc41020f}},	//   _चम्बल_, _explizit_, _rođeno_, _راوکښه_, 
   {{0x626c02cb,0xaa730223,0x13050207,0xc9fe0139}},	//   _silom_, _bidalita_, _سوراج_, _antavant, 
   {{0xd394000e,0x3c73022f,0x2adf0265,0x96f503dd}},	//   _afisha_, _сценку_, _maatrege, _partnerë, 
   {{0x33eb01ef,0x4c5702a4,0xd2240258,0xddab0155}},	//   _tapti_, _vestrae_, _fanke_, _forumgud_, 
   {{0xa2020034,0x9c6a0397,0x6d5a03d4,0x8f80040f}},	//   _gerist_, _komuntu_, _корен_, _specifin, 
   {{0x129200b0,0x010300f2,0x2f2d0308,0x2264023a}},	//   _qoraal_, _kristieš, _diperbin, _kotlov_, 
   {{0x10af0374,0x03120415,0x59fb0090,0xfe24017e}},	//   _استحضا_, _verbaut_, _andakape, _פרופייל_, 
   {{0x0af90444,0xe2c505a6,0x6a8804d4,0x126c02e2}},	//   _начальны, _reglane_, _infomeis, _endow_, 
   {{0x1c8201f2,0x3e7c05fc,0xc26c028e,0xa3a20420}},	//   _قەيسەر_, _भाद्र_, _kilok_, _secretár, 
   {{0xb4a00192,0xcc6a01cd,0x598e019d,0xe30103b5}},	// [1bc0] _wedstrij, _nomuntu_, _amakonze, _sayangi_, 
   {{0x1865014e,0x4c1f00ad,0x7e1d01ff,0x526c003c}},	//   _близини_, _alisyahb, _odvetvia, _dilok_, 
   {{0x52d70152,0x317e01a3,0xb3f9001d,0xf9450244}},	//   _графикас, _ريگيوليٽ, _liausu_, _omologat, 
   {{0x52bd0132,0xd541026f,0xe3bb020f,0xc81c0008}},	//   _mondjam_, _كومگەنىن_, _بسلان_, _камкорчу_, 
   {{0xe508066c,0x00000000,0x00000000,0x00000000}},	//   _doktorko_, --, --, --, 
   {{0x4a060464,0x02cc0321,0xa73102f3,0xa1fd064f}},	//   _bababuza_, _razliko_, _troligtv, _antispam, 
   {{0xee780051,0x68c7002b,0xe2000077,0x5f2d0044}},	//   _aktivitā, _ঠিকঠাক_, _amhiti_, _expectin, 
   {{0x326c0120,0x0c5b003d,0x2201048f,0xa3930297}},	//   _bilok_, _abstrai_, _buzitu_, _camaliev_, 
   {{0x426c01b0,0x1c030230,0xb4bb0311,0xc7870162}},	//   _cilok_, _tersyer_, _ንምልከት_, _تالانىت_, 
   {{0x9d0d014a,0x0ea00008,0x6c7c0251,0xf1400086}},	//   _آزادانہ_, _facultat_, _geesiga_, _kitermel, 
   {{0x6e68013d,0xde010022,0x194f04a4,0x367d0037}},	//   _koncerna, _имтиханы, _boillsge, _ተፈፃሚነት_, 
   {{0x17b8066d,0x7c6a006c,0x57c603a0,0x22db016d}},	//   _sikudumi, _yomuntu_, _aperetsw, _достилир, 
   {{0xc52803ad,0x026c0120,0x8266026f,0x8709015e}},	//   _vassallo_, _biloh_, _بوگەت_, _бейити_, 
   {{0x7c090264,0x03eb0225,0xd30c01ec,0x2e5800ba}},	//   _campina_, _flatte_, _bapakku_, _بسڕێته_, 
   {{0xec6a066e,0xb2a701d9,0xa4e600ff,0x3a7f0139}},	//   _pluriel_, _berbe_, _ריטעיל_, _alpatara_, 
   {{0x46a9001c,0x120004ee,0xa44d0061,0x23850122}},	//   _nangingi, _kajite_, _고객님에게_, _brastagi_, 
   {{0x07c10076,0xcdaa00b5,0x0ed50095,0x6a6303ac}},	// [1bd0] _passagem_, _bibiogra, _انصافا_, _muttafaq_, 
   {{0xaf93066f,0x051c027b,0xcf23030b,0x2d850195}},	//   _vendedor_, _ananyadh, _akatyaba, _geamanna, 
   {{0x92120544,0x52fc0129,0x22ea0047,0xcea00279}},	//   _akahi_, _iziga_, _jointes_, _amatrice_, 
   {{0x02390354,0x7bec00ac,0x7183049d,0x3e68020a}},	//   _торус_, _mehaničk, _absorção_, _сатылмай, 
   {{0x16100670,0xbde60008,0x2ed90269,0x141a0170}},	//   _ukulungi, _بولمويۇن_, _antiguas_, _chinafik, 
   {{0x9b97005c,0x29200276,0xa8370026,0xa26c04bd}},	//   _komisiyo_, _аппарати, _하겠습니다_, _kiloi_, 
   {{0x7290053a,0x73860243,0xd21204bd,0xaf42032b}},	//   _odmah_, _meeri_, _ekahi_, _идиологи, 
   {{0x44b10076,0x9fcc00e6,0x5d9c02f0,0xfee803b4}},	//   _inscriçã, _年度新世纪小学数, _besevele_, _chakatan, 
   {{0xedee0141,0xc12003f1,0x327902b2,0x0c2301df}},	//   _کمپوز_, _podvozok_, _довелось_, _famished_, 
   {{0xe68a041e,0x449c0230,0x426e0020,0x7a2501ac}},	//   _spiegazi, _dezangaz, _fetoai_, _arabacha_, 
   {{0x7c6100b4,0x8f6303c8,0x38cd015f,0x80fb0153}},	//   _oferite_, _tempatka, _academyd, _ツショップ_, 
   {{0x93ea0013,0x52900288,0xd2fc02fa,0x2387038e}},	//   _uchta_, _memag_, _aziga_, _ajarin_, 
   {{0xbe960030,0x543301f6,0x12fc016a,0x10060366}},	//   _čempionā, _লাচিত_, _indikas_, _кальци_, 
   {{0xc3eb03b0,0xc2a701da,0x234100ab,0x89f30483}},	//   _flytte_, _serbe_, _kawenga_, _pluralid, 
   {{0x03860016,0xfec2016d,0x9ceb0040,0xf3eb025b}},	//   _ofero_, _достиму_, _להטיל_, _taptu_, 
   {{0xf26c000b,0x4302008d,0x399900e6,0x00000000}},	//   _fidow_, _kuzatuv_, _你说得有道理_, --, 
   {{0x09a0002b,0x1f5f0061,0x00000000,0x00000000}},	// [1be0] _পন্ডিত_, _레스토랑을_, --, --, 
   {{0xffb901c2,0x23860656,0x19e702fe,0x1506007e}},	//   _títulos_, _afero_, _abaomdla_, _आन्ध्रप्, 
   {{0xee3b001b,0xc2120369,0xddd70177,0xfa9100cb}},	//   _barabara, _haihai_, _ишәыҭатә, _akayanga_, 
   {{0x308103c7,0x5c8501d1,0x06d70117,0x926c022a}},	//   _opubliko, _appeared_, _kamautim_, _silop_, 
   {{0x726d03dd,0x79c3026c,0x503b0059,0x4cb801f4}},	//   _fotot_, _delectat, _станали_, _келсам_, 
   {{0x62cb030f,0x13670277,0xe5bd0113,0x2a730040}},	//   _kokonga_, _abugado_, _archwium_, _פרארי_, 
   {{0xba9900d7,0x99ad026c,0x5386013f,0x745d0037}},	//   _babylona_, _conventu, _ufern_, _መዛሙርቱን_, 
   {{0x5e93015e,0x4d4e003a,0xa2f00457,0xb9e302a4}},	//   _келишимд, _палатаси_, _bayisuh_, _ordinata_, 
   {{0x175c0145,0xfd9a0557,0xcba0001a,0x52020135}},	//   _нобелеўс, _abangawa, _بیچارہ_, _baqiev_, 
   {{0x6efb0360,0x43720528,0x1d420094,0xb2d80313}},	//   _prevence_, _fallaing_, _коасано_, _luqoplu_, 
   {{0xd9c30027,0xd2f4028e,0x26ba02cd,0x0f2b00d1}},	//   _beleseat, _bihinim_, _bagarori, _austroma, 
   {{0x329002d5,0x899d004b,0x4c61004e,0x516a018f}},	//   _nemad_, _тайыр_, _katunga_, _mubitmoh_, 
   {{0x1df603cf,0xb3ea01b9,0x9d8702ac,0x89fe01d2}},	//   _kuruluşl, _doitet_, _وازالة_, _antarant, 
   {{0x8d8b02c2,0x0624014e,0x6da40113,0x63220260}},	//   _gereelde_, _влашка_, _منتشرة_, _lúcido_, 
   {{0xb3fc00ee,0x4281028e,0x4e8a00bb,0x1e0c0141}},	//   _antolatz, _namanggi_, _ہونہار_, _алданган_, 
   {{0xb45c02b2,0x596a0181,0xccd90024,0x33eb03ae}},	//   _участі_, _araicoct, _triveleg_, _klatre_, 
   {{0xad3501ef,0x62da0288,0x6e80005e,0x735f05dc}},	// [1bf0] _кулаком_, _kapero_, _ﺋﻪﻧﺌﻪﻧﯩﯟ, _ringere_, 
   {{0xaf5f0249,0x43860016,0xf2a70181,0x230c0279}},	//   _envairon, _sfero_, _chocolam, _romains_, 
   {{0xceac014e,0xc5fd03e2,0x425b0189,0x626c0165}},	//   _користит, _inserció, _edelim_, _yalovi_, 
   {{0x3285020f,0xbc61027f,0x22910326,0x507a0361}},	//   _alubavum, _batunga_, _arware_, _мироново, 
   {{0x0e3b01ad,0xee0b0046,0x11ee004d,0x00000000}},	//   _caracara, _premiats_, _七十五年十月_, --, 
   {{0xeefb0094,0xa1fc00b6,0x26c102bf,0x00000000}},	//   _سىپاتاي_, _sidicaam, _kulandzi, --, 
   {{0x1ed9051a,0x1b8a00ec,0x00000000,0x00000000}},	//   _ditindas_, _leidinių_, --, --, 
   {{0xf3a20199,0xfc6102f8,0xd05e0238,0x8319010d}},	//   _mcipty_, _fatunga_, _дорожньо, _cibitung_, 
   {{0x0bb20244,0x07b501d9,0x0cd00234,0x32640009}},	//   _archivio_, _onbeding, _kalẹ̀_, _mislih_, 
   {{0x69c300b4,0xe8d60071,0x2974020f,0x0e1c0281}},	//   _selectat, _مارتیک_, _andinixe, _anigaasa, 
   {{0xc0d4016d,0x22900322,0xb396018d,0x760003a8}},	//   _يوققۇ_, _akabindi_, _blushi_, _সপ্তাহলৈ_, 
   {{0xec7e0076,0x029100b6,0xe26c0165,0xcfd301a3}},	//   _adesivo_, _kibaal_, _qalovi_, _ٽئنڪر_, 
   {{0xc6250209,0x5aaf0061,0xb287041c,0x43b50322}},	//   _europami, _자체적으로_, _daniouy_, _akivuka_, 
   {{0x82780250,0x12e10062,0x45d300d1,0x2f890420}},	//   _besnik_, _dimuvmoh_, _ফঁহিয়াই_, _мераци_, 
   {{0x34f600c5,0x4a0b018e,0xdcd4021c,0x72c80077}},	//   _一年赚一生工资_, _ambalela_, _regulačn, _debouye_, 
   {{0xb2910318,0xf7230420,0x7b920169,0x617e0147}},	//   _avaava_, _costumam_, _tornillo_, _كۅپكۅ_, 
  
   {{0x154a027e,0xc72a018b,0x06320381,0xd51c0164}},	// [1c00] _половини_, _multumim_, _airlinew, _тәрбийил, 
   {{0x99ba0040,0xb29000e2,0x02d80282,0x92da0204}},	//   _ודגמים_, _froast_, _paheko_, _akseli_, 
   {{0xc2240184,0x6fa401d1,0x96600360,0xb9fb0018}},	//   _yanka_, _moreover_, _दिवसका_, _kadinala_, 
   {{0x9c610340,0x11470022,0x152402bd,0xaf95048a}},	//   _patunga_, _aparetso, _annisgwy, _этнопеда, 
   {{0x5f0202bb,0xa387041e,0xefd003d1,0x12a70128}},	//   _रहस्यमयी_, _peura_, _pastaigā, _masjidi_, 
   {{0x3e560671,0x10360043,0x00000000,0x00000000}},	//   _cubanske_, _baateran, --, --, 
   {{0xc7a00217,0xf24a0013,0xc1fd01b2,0xcc5a04e5}},	//   _ascendev, _rasman_, _aleatory_, _amatabi_, 
   {{0x8b950220,0x326c0049,0x4fd700f2,0x32da028b}},	//   _столицат, _haloti_, _pretrunī, _japepo_, 
   {{0x76a2026f,0x5efe015e,0xb2da013d,0xb2d604b9}},	//   _احەمەن_, _الاعۇشوۋ_, _papero_, _gunless_, 
   {{0x429d01af,0x725a023b,0x2caa0255,0x0d4001a3}},	//   _ahalyñ_, _maklia_, _पूर्वाँच, _ڄنگهه_, 
   {{0x3224032e,0xaed801ac,0x22c50271,0xa2f1053f}},	//   _panka_, _مزدوج_, _reglene_, _purinti_, 
   {{0xd13d011e,0xf36a0181,0x899d0089,0x424a0117}},	//   _ezitasyo, _slugger_, _височная_, _wasman_, 
   {{0x020201ec,0x820b0031,0x92ac0147,0xc36a01b3}},	//   _pesiar_, _syahrini_, _دەسڭەر_, _plugger_, 
   {{0x9cf20490,0x3438006c,0x627804c7,0xbed80151}},	//   _cantábri, _напазиру, _pesnik_, _biliousn, 
   {{0x88450052,0x30aa01a3,0x2345012b,0xe2f100ec}},	//   _स्मृतिमा_, _سرسوتي_, _weselne_, _turinti_, 
   {{0xe3960141,0xeec90008,0xbf5b00ea,0x326d0396}},	//   _ulushi_, _amenaces_, _fakampan, _intom_, 
   {{0x23950204,0x42000005,0xc80003b6,0x27fc02d3}},	// [1c10] _viesti_, _avain_, _adirẹsi_, _улога_, 
   {{0xe7e8012b,0x67b50166,0x831f0040,0xdc6a013f}},	//   _कामकाजी_, _unbeding, _biochem_, _bourdel_, 
   {{0x19d00518,0x730500aa,0x50470365,0x00000000}},	//   _лекин_, _humapak_, _देउलेक_, --, 
   {{0x39b90368,0xb2020450,0xa301020b,0xd3940020}},	//   _материја, _striid_, _arabiwe_, _faisua_, 
   {{0xd291030f,0x406702c0,0x937f0059,0x0c73030b}},	//   _kuware_, _краткотр, _останаха_, _alisala_, 
   {{0x32b5036b,0xfee50013,0x56fc003c,0x034304c7}},	//   _fusca_, _sarhisob_, _لغتنامه_, _хорова_, 
   {{0xd5b70262,0xe5a40142,0xd5b60102,0xd49e0297}},	//   _senagaty, _anyonyam_, _chipukiz, _архивтан_, 
   {{0xf6b90261,0x72b5008c,0x626d003f,0xc27b0318}},	//   _ensaluti, _susch_, _hitod_, _pilikimi_, 
   {{0xb290008a,0x400602da,0xb26d0408,0x9e21004d}},	//   _manatu_, _енергија_, _antom_, _買方付運費_, 
   {{0xdee6032e,0x8300003b,0xe39402c1,0x5a75009f}},	//   _suchurin, _babanti_, _agisha_, _prične_, 
   {{0xe2240183,0x76110226,0x0a9a0322,0x75e8016e}},	//   _manko_, _akulandi, _abanyais, _zamanlı_, 
   {{0x43940074,0xb1ba0061,0x00000000,0x00000000}},	//   _naista_, _민주화운동_, --, --, 
   {{0xa2f000db,0x4ef90142,0x842a0061,0x00000000}},	//   _वक्री_, _anavadya, _인상적이다_, --, 
   {{0x9b8803cf,0xbb380213,0x934e0179,0xb2eb0359}},	//   _tarifler, _жертвы_, _negebik_, _flinter_, 
   {{0xd12203ff,0x8c5000e2,0xcf5a0086,0x1a850028}},	//   _životnos, _prachtic, _tápanyag, _arintaan_, 
   {{0xf2cd046d,0x9224005b,0x746f0099,0x43910147}},	//   _khuliso_, _hanko_, _ainetsek, _جىرعاتىپ_, 
   {{0xf2260003,0x026d0032,0x3ae200ff,0x92300298}},	// [1c20] _merken_, _bitod_, _אָבאַמאַ_, _atamira_, 
   {{0x1224004a,0x66770335,0xb2600087,0xc26d008e}},	//   _barasıñ_, _asāṅkary, _ikhonomi_, _fotoy_, 
   {{0x99120148,0x137300e4,0xf35e02ac,0xf4af0024}},	//   _波羅僧揭諦_, _badanie_, _وسيطات_, _মুক্তিৰ_, 
   {{0xbfc70287,0x1af70381,0x4d950040,0x22010100}},	//   _सहसचिव_, _ampshire, _מובטח_, _dubinu_, 
   {{0x42ef01d8,0x54930147,0x00000000,0x00000000}},	//   _hangamei_, _بووزوقان, --, --, 
   {{0x1d8a0026,0xc38604b7,0x5ae90037,0x8b34000a}},	//   _conditie_, _heers_, _ስለኢትዮጵያ_, _annaffis, 
   {{0xbe270173,0x126c0319,0x9a0b0153,0x56cb0381}},	//   _primeras_, _hilos_, _商品の追加_, _asophary, 
   {{0x9c300354,0x47c700d1,0xa9330377,0xfad90097}},	//   _яврупаға_, _জাউৰী_, _promovat, _olumusin_, 
   {{0xa89102e8,0x6226050a,0x7c5b0407,0x3535009b}},	//   _chikungu, _derken_, _nastupi_, _akusazio_, 
   {{0xa7c700da,0xd26c00fc,0x804e00d1,0x67cd002b}},	//   _фамилие_, _dilos_, _অসমজুৰি_, _হেনরি_, 
   {{0x96ab00b5,0x17b601df,0x9cbc001b,0x3d1a0222}},	//   _абатальо, _forefing, _barachuu_, _chinoise_, 
   {{0x33cf04cd,0x9af603c2,0xf2fc0005,0x4b7d0407}},	//   _posve_, _abruptne, _rumians_, _dopunama_, 
   {{0xa6b901b8,0x2200030b,0xd290007f,0x00000000}},	//   _seisukoh, _addira_, _amlach_, --, 
   {{0xc93d0060,0xa2260347,0x54d700be,0x53c402bb}},	//   _اتاعىڭمە, _herken_, _بايسەركە, _ज्यामिति_, 
   {{0x7131025b,0xd226018c,0x5328024c,0x126d0005}},	//   _landsfel, _kerken_, _emikranj, _antoc_, 
   {{0x43a003cc,0x3c7c0203,0xc47e02c0,0x62ea02d3}},	//   _মহিলাদের_, _elision_, _офицери_, _isentos_, 
   {{0x23860101,0xa2240375,0x32fe0257,0x210c0092}},	// [1c30] _ofera_, _yanko_, _akranesi_, _ドキュメンタリ_, 
   {{0xe8600257,0x937304d6,0x11f30280,0x539602f6}},	//   _raunveru, _zadanie_, _बलूचिस्त, _intsik_, 
   {{0x72000033,0x74750661,0x26ab0145,0x0c76019d}},	//   _ovais_, _balanço_, _азеры_, _gwirani_, 
   {{0x256c0254,0xb61003db,0x831602bc,0xd26c0132}},	//   _promoció, _okulungi, _kalbari_, _tilos_, 
   {{0x8c750022,0x515505dd,0x526c01fc,0x6301009a}},	//   _atisang_, _अम्लीय_, _kidoh_, _egranti_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2000222,0x7c8a0060,0x5905005d,0xdc0503ba}},	//   _avait_, _اققۇم_, _armadagu, _sterday_, 
   {{0x941301e0,0x4c2601c9,0x6bfb051f,0xa6d50010}},	//   _شاندی_, _चुनौटी_, _مکارێم_, _emlandvw, 
   {{0x05250265,0x54250014,0xef1c01e8,0x32e70290}},	//   _verzendk, _personin_, _hamugawa, _abandun_, 
   {{0xf26c0062,0x623704f4,0x00000000,0x00000000}},	//   _vilos_, _trajes_, --, --, 
   {{0x58f800b0,0x426c015d,0x2d900011,0x0a7003a2}},	//   _dabadeed, _widok_, _akalinda, _फ़ुरसतिय, 
   {{0xd9aa0013,0xa25a018f,0xb7d700bb,0x55d40205}},	//   _шокир_, _cholli_, _راجائوں_, _zelandiy, 
   {{0x79d80287,0x0d760107,0x0fc302c2,0xd09702e5}},	//   _desetile, _گرسنه_, _redigeer_, _франциа_, 
   {{0x0f2400da,0xcaf90055,0x5387002c,0xc213038f}},	//   _админист_, _riassunt, _geure_, _diehan_, 
   {{0xa2010073,0x4c74015f,0x83540047,0x3be30159}},	//   _habite_, _bapurau_, _atteint_, _готланд_, 
   {{0x1e9c005e,0x00000000,0x00000000,0x00000000}},	//   _جاسۇس_, --, --, --, 
   {{0x0387029e,0x1395020d,0xe9490337,0x52020014}},	// [1c40] _beure_, _ifasha_, _ortadoğu_, _perime_, 
   {{0x779b0253,0xec9304fd,0x84c302e6,0xa34b013a}},	//   _chemnitz_, _विभोर_, _netbutik, _gedeelt_, 
   {{0x43870147,0xc3540007,0xbaf6009a,0xcc7602ef}},	//   _veure_, _etteint_, _اواسلامي_, _gwarani_, 
   {{0x24f50285,0x33870200,0x32910672,0xb7a50220}},	//   _itumanah, _eduru_, _avyara_, _centinai, 
   {{0xe2fc03b9,0x4467019b,0x92c90037,0x62d80240}},	//   _oblitas_, _чакаюць_, _በጥራትና_, _meketi_, 
   {{0x31fc00ea,0x920000df,0x446e00a7,0xe3020177}},	//   _malagasy_, _avais_, _арамы_, _jahayhu_, 
   {{0x6344011e,0xf355055a,0xd61005db,0xe2360159}},	//   _aprepre_, _facetas_, _akulungi, _stojo_, 
   {{0x0c8b005e,0xb78a02a0,0x31d60112,0x41b2026b}},	//   _يەرتەۋرە, _iyanilẹn, _kaffarah_, _শ্বেত_, 
   {{0x96440421,0x32760344,0x81b50109,0x326d003e}},	//   _vernünft, _allamium, _generací_, _entoa_, 
   {{0xe2240082,0x1d65019e,0xf4a803a8,0x00000000}},	//   _wanke_, _алюмнаў_, _পছন্দলৈ_, --, 
   {{0x73870145,0xa26c004b,0xdfbf0174,0x23e70257}},	//   _tvarka_, _ammone_, _tshebotš, _bætur_, 
   {{0xe5c80480,0xa0c502d3,0x675303a8,0xd201015e}},	//   _intaneth, _евровизи, _উভয়সহ_, _enviem_, 
   {{0x8a7c01b5,0x82000005,0x9a5f033a,0xdcd100d1}},	//   _ahlayisa_, _avair_, _bloggata_, _খনিকৰ_, 
   {{0x470f0061,0xd12d0076,0x8d22005b,0x0dca0311}},	//   _겨울스포츠_, _саати_, _birilove_, _ምፍራህን_, 
   {{0xd16600ff,0xb570015e,0xb40c016d,0x02240082}},	//   _עירובין_, _берилген_, _алданған_, _yanke_, 
   {{0xf3870292,0x49760021,0x79530142,0x12fe00d9}},	//   _aduru_, _undivide, _चतुस्त्र, _potilas_, 
   {{0xd6b90133,0x0863014c,0x77cc0156,0x8ea50008}},	// [1c50] _aspaalti, _kwenkund, _פלאנסט_, _vallesan, 
   {{0xffb40034,0x4a7302dd,0x00000000,0x00000000}},	//   _lesendur_, _kalamita_, --, --, 
   {{0x05e80088,0xe2870010,0x4d5d02cf,0xb9a2011a}},	//   _сулайман, _ibekiwe_, _цигарата_, _הקטלוג_, 
   {{0x828d0410,0x97fb04a5,0x2fe80193,0x3a0d0369}},	//   _boikano_, _amabhung, _सुधारित_, _kapaakea_, 
   {{0x7ee4003c,0x32d8030a,0xbae100e6,0x0e9201a3}},	//   _خویشاوند, _mamede_, _maquette, _گاڏهي_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x9db401a4,0x351900c4,0xd772004b,0xb26e024f}},	//   _afongola, _چوپائي_, _перфилье, _setoki_, 
   {{0xa226004a,0x63fc00d2,0x6ecf01d2,0x96270185}},	//   _diskı_, _boeldozz, _echinops_, _kaxovski, 
   {{0xb1da01b7,0xe51501d5,0x524901da,0x8f5d0344}},	//   _क्रयादिग, _پروڈکشن_, _flamur_, _angalann, 
   {{0x48160145,0xe67b02c9,0x69c700e4,0xae9e019c}},	//   _pareigūn, _атримис_, _चुंचे_, _ojúde_, 
   {{0x67910218,0x52ce00d9,0x53f4009b,0x22a6007b}},	//   _isotreti, _бразилии_, _antton_, _glibly_, 
   {{0xe2c2023b,0xd28301b5,0x62870559,0xd8ef01e4}},	//   _amaleka_, _atekiwa_, _abekiwe_, _propojov, 
   {{0xd9c90176,0xac6000ad,0x533a0311,0x9f5800de}},	//   _plumeria_, _sumuhun_, _ዝድምደም_, _ekwakwen, 
   {{0xb33d00bb,0x79fb0478,0xa26c0456,0xe0bc027e}},	//   _سیلاب_, _radicala_, _paloh_, _promenil, 
   {{0x3b0e0158,0x5a8e031d,0xc1c300e6,0x845803b6}},	//   _krystyna_, _blandnes, _imprimez_, _tíìfù_, 
   {{0x02df0197,0xf26c005b,0x7dba03f2,0x00000000}},	//   _kokorat_, _eblog_, _прелестн, --, 
   {{0xf26c01d8,0x12fd0654,0xef8c04ca,0x93790403}},	// [1c60] _daloi_, _didasari_, _aquifèr_, _efraima_, 
   {{0xea7a0204,0x53210262,0xd4920025,0x9dbe03d0}},	//   _гарантий, _ajayyp_, _आत्मन_, _kukuriku_, 
   {{0x12fc0056,0x6290029b,0x8ef4002b,0xa8850178}},	//   _izaga_, _almaa_, _কারফিউ_, _avaśasya_, 
   {{0x83eb01c6,0xcecd0022,0xc38600fe,0x6040013c}},	//   _moatte_, _ausinyan, _eferu_, _statusun, 
   {{0x103602c1,0x3fdb00ba,0x5f200005,0xe6800235}},	//   _abateran, _تۆتنهام_, _adattada, _विधाः_, 
   {{0x3de300c4,0x33c70017,0x82fe00c1,0xc61d000b}},	//   _چنبڙي_, _तिरस्कृत_, _antasari_, _noanoati, 
   {{0x777902ac,0xcb0202b0,0x00000000,0x00000000}},	//   _جورجيا_, _versiege, --, --, 
   {{0xf0d30013,0xb5260040,0xd291029e,0x00000000}},	//   _takomill, _ניחוחות_, _argant_, --, 
   {{0x550d0059,0xb7e301ce,0x6376023c,0x666a0137}},	//   _подготвя, _چمستان_, _راځينه_, _горилсон_, 
   {{0xb3a3034f,0x9361047d,0xa31d0418,0xe3eb00d2}},	//   _phepha_, _stemmung_, _onaylanm, _saptu_, 
   {{0xd27f02b7,0x21da0276,0x59e201fe,0x77ce0216}},	//   _omenë_, _жамаъәтк, _kidomoka_, _enetisiw, 
   {{0x5386015d,0xa26c014b,0x74610347,0x0a1b0477}},	//   _ofert_, _aalow_, _samewerk, _kuncinya_, 
   {{0x72c6003e,0x504700bf,0xd2490157,0xeb05004c}},	//   _pauluse_, _перси_, _kremem_, _beesanga_, 
   {{0xb72300d9,0x499c01e9,0xab78028f,0x2b8002aa}},	//   _победы_, _gonkgona_, _panuitia_, _autosklo_, 
   {{0xc1de02e1,0x0d0501fb,0xefc2028a,0x870900c4}},	//   _chinntiú_, _stellate_, _باجوڙ_, _فرڊننڊ_, 
   {{0x4a72016d,0xa18a03db,0x7c0e0400,0x7dfa01f1}},	//   _айғичә_, _ababenal, _rispose_, _mendimit_, 
   {{0xcee5020e,0x8fa700c7,0x00000000,0x00000000}},	// [1c70] _агентлығ, _isleytar_, --, --, 
   {{0x13870108,0xa59900b5,0x4c030138,0x79af0211}},	//   _geura_, _chehaité, _dersler_, _извращен, 
   {{0x600003d1,0x2d620354,0x00000000,0x00000000}},	//   _informāc, _кесингир, --, --, 
   {{0x2c49027c,0x2224004f,0xef93025d,0x1387012a}},	//   _داعلانات, _cafka_, _fordelar_, _twarda_, 
   {{0xe26d01e1,0xd9b70022,0x7c1d0203,0x2a7c0365}},	//   _sitoa_, _призер_, _adoptet_, _प्रेरणाक, 
   {{0x7e9a0092,0x83800064,0x33ea00bd,0x5c770135}},	//   _このエリア_, _carril_, _blithe_, _проброс_, 
   {{0x62ca00b3,0xc9110427,0x824903d7,0xec610585}},	//   _milleti_, _kivalliq_, _vremem_, _prerade_, 
   {{0x237900ed,0x83eb03f1,0x00000000,0x00000000}},	//   _gimando_, _platbe_, --, --, 
   {{0x4c7c007f,0x5a960156,0x00000000,0x00000000}},	//   _blismon_, _meritojn_, --, --, 
   {{0x1a7204ac,0xf35502a4,0x12260138,0x724a007a}},	//   _акции_, _angelis_, _serkan_, _jasman_, 
   {{0xc2480618,0x12cb00bd,0x1dea0160,0x00000000}},	//   _veoma_, _colorea_, _paljenje_, --, 
   {{0x1af302c2,0x00000000,0x00000000,0x00000000}},	//   _indringe, --, --, --, 
   {{0xa248037c,0x4387004f,0x4cc80037,0x0a8d0044}},	//   _teoma_, _beuri_, _የመቁሰል_, _agencies, 
   {{0xcd01028b,0x78d70012,0x1b92005e,0x460b004a}},	//   _curtidur, _जमघट्_, _لەغمەن_, _blagoveç, 
   {{0xb29001a7,0xa6f5012e,0xddf0023c,0x738603dd}},	//   _ilman_, _partnerü, _ځنډوي_, _afert_, 
   {{0x9c6101d9,0xa02a00a4,0xfdc700bb,0x026c0251}},	//   _cadrage_, _tecnològ, _دعوؤں_, _walow_, 
   {{0xe57c03ab,0x326d0342,0x52f70227,0x7e1603e0}},	// [1c80] _anglické, _antou_, _belilah_, _benevola, 
   {{0x026d013b,0x6dff02dd,0xf3200082,0x52a700f6}},	//   _hiton_, _allegata, _adiyya_, _herbi_, 
   {{0x0bdd00e7,0xe9f402c1,0x4c910012,0xd29000d0}},	//   _adientgr, _uturingu, _किलोल_, _temati_, 
   {{0x53f402f3,0x02b5047d,0xbeae0242,0x126c0342}},	//   _mitten_, _lusch_, _millisin, _jalou_, 
   {{0x43f40450,0xa2fd0223,0xa5c300c7,0x763b0385}},	//   _litten_, _dragoi_, _массалар_, _varijaci, 
   {{0xa364014c,0xab7c0090,0xc7470188,0xd2b40053}},	//   _amagama_, _abhurama_, _милливу_, _tancap_, 
   {{0x0ddf03ad,0xe26d0311,0xd26c009e,0x726c00d2}},	//   _birkirka, _fiton_, _falou_, _lolong_, 
   {{0xc2900233,0x4551046f,0xf2370031,0x00000000}},	//   _demasi_, _evoluéie, _diejek_, --, 
   {{0x08790066,0xa518016f,0x3a2301d2,0xe7130137}},	//   _замбараа, _забрудне, _chaqnayu, _медалиуд, 
   {{0xe3640010,0x72fd0066,0xabf30310,0x00000000}},	//   _emagama_, _aragoi_, _oileanac, --, 
   {{0xc38602c1,0x05200036,0x126c04ef,0x82b502f3}},	//   _igera_, _glantach, _lidos_, _dusch_, 
   {{0x538700ad,0x626c00d2,0x5e3b036a,0x55a904e5}},	//   _seuri_, _kolong_, _parakara, _amussaak, 
   {{0x226c04ea,0x42da033d,0xef0b0040,0x326c00ec}},	//   _lalot_, _tranble_, _תפסיק_, _nidos_, 
   {{0x6860031c,0xc2900018,0x63860008,0x00000000}},	//   _difícile, _semati_, _afers_, --, 
   {{0x026c010b,0xe86900ce,0xe8e90274,0x62de016a}},	//   _badirisi_, _konparab_, _borgarfu, _ankorau_, 
   {{0x620e0125,0x0c9802e2,0x3290050b,0xe26c0230}},	//   _чанак_, _courting_, _lemari_, _galou_, 
   {{0xe2940369,0x13cf001c,0x42b501e6,0xe2bd0142}},	// [1c90] _anakoni_, _nieves_, _stojany_, _aindram_, 
   {{0x726c03fd,0xf2910046,0xe29003c5,0x24c8002c}},	//   _malosi_, _legals_, _gemari_, _витамину, 
   {{0x89aa01cd,0x76bf02da,0xa26c0131,0x43a2006e}},	//   _полис_, _порталот_, _eidos_, _boopam_, 
   {{0x8ae801ce,0xe6190052,0x9ea50067,0xa3f800bd}},	//   _شوماخر_, _profilem_, _callisan, _dwaum_, 
   {{0x126c0032,0xbfb901f0,0xdc7d005b,0x1cc70340}},	//   _arloqh_, _bagologo, _tatsuya_, _matikuku_, 
   {{0xf6a20673,0x04690420,0x16ad0147,0x29aa0164}},	//   _okuthath, _conforto_, _ايۇۇنۇ_, _пойиз_, 
   {{0x629100f4,0xb2fd0057,0x962500c4,0xa3e70163}},	//   _bugale_, _dilayari_, _انشاءَ_, _hátra_, 
   {{0xdea9052c,0x531601dc,0x182f0200,0x526c0318}},	//   _رژمێری_, _balzer_, _ngosipụt, _kalosi_, 
   {{0x16a203db,0x875f0037,0xbcda00d1,0x52e902c8}},	//   _akuthath, _ባህላችንን_, _দাঁতেৰে_, _apuntou_, 
   {{0xd26c02f6,0x4f4e0037,0xbdb100d4,0x126c0674}},	//   _ondoy_, _diasaska, _belgyske_, _kalot_, 
   {{0x040e055a,0x82d4015e,0xdf480039,0x00000000}},	//   _alegando_, _ajudes_, _эйлерийн_, --, 
   {{0x495f0184,0x29ea0091,0xae6b01a3,0xb38603ae}},	//   _ahengere, _ngutillu, _اينڪر_, _leiren_, 
   {{0xc17700fc,0x9290015a,0x52fd0063,0x5b470162}},	//   _bangheyl, _ammas_, _araibis_, _бардим_, 
   {{0xa18f02fe,0xe3780233,0x505f0156,0x00000000}},	//   _bioassay_, _nelatin_, _akuzitaj_, --, 
   {{0x126d0343,0xda10004a,0x9c7e046b,0xe3ea0172}},	//   _antos_, _ansamble, _arestio_, _tuntum_, 
   {{0x440f036d,0x16d600d1,0x521c0211,0xf56a0237}},	//   _fearainn_, _ভাইভেক্স_, _kauhea_, _미생물자원을_, 
   {{0x975e01e4,0x13540191,0xd0d900ec,0xc3e70052}},	// [1ca0] _जलप्रलय_, _baserat_, _распраца, _játra_, 
   {{0xe9e905ba,0xb2420255,0x84b30040,0x7ca20322}},	//   _आशावादी_, _मंगले_, _גרילה_, _abazayir, 
   {{0x22260373,0x27f40026,0x131701da,0x3386013a}},	//   _verkon_, _사업계획서_, _plazhi_, _deiren_, 
   {{0x41c70122,0x4c5b02e4,0x06a500c4,0x040a0246}},	//   _باستانی_, _buttuni_, _مخواهه_, _наднорме, 
   {{0xbb3b00be,0xd9780312,0xcc520415,0xd34500af}},	//   _ئشتەمەكچ, _vanifest, _dritten_, _leserne_, 
   {{0x023603cf,0x026d01b9,0x628d03b9,0xc21300ea}},	//   _proje_, _antor_, _patakkam, _mpahay_, 
   {{0xe651022a,0x7e7f0092,0x025a0079,0xbbac01db}},	//   _wilhelmi, _さん更新しました_, _skolai_, _كەزەڭىن_, 
   {{0xf26c0227,0xc65c000c,0x738603e6,0xeb130538}},	//   _tolong_, _апошта_, _heiren_, _herredøm, 
   {{0x3759060e,0xdd730059,0xf3950074,0x347c03b5}},	//   _पुत्रों_, _войната_, _maasta_, _dipecahk, 
   {{0xb26c013d,0x926c00ac,0xa3870455,0xcb6c02e5}},	//   _vidos_, _maloj_, _meurt_, _lottigna_, 
   {{0x44d70141,0x561604f9,0x0c8700fc,0xff780158}},	//   _футболчи, _aallarni, _boleghpu_, _ज़रदारी_, 
   {{0xc82a02eb,0x79c100a7,0xe7da01db,0x340a0127}},	//   _хийлгүүл, _تەركۅۅ_, _جىڭىشكە_, _diziverk, 
   {{0xe437002c,0x12900044,0x6fcf00cb,0x58690347}},	//   _bezalako_, _ideal_, _abanombo, _besighed, 
   {{0xf29e0247,0xfa89022a,0xc6370205,0x022d044b}},	//   _تمامی_, _anniston_, _блоглард, _forvandl, 
   {{0x127f0016,0x02900039,0x001f0515,0x14370675}},	//   _atenti_, _banatu_, _alienato, _conceito_, 
   {{0x62da013a,0x442a03d8,0x02ff034e,0xc26c022d}},	//   _poteau_, _detaljno_, _allampax_, _calori_, 
   {{0x5eb102f7,0x00000000,0x00000000,0x00000000}},	// [1cb0] _hutsitse_, --, --, --, 
   {{0xc29001c0,0x8af70168,0xfd490060,0x6f1900da}},	//   _ummar_, _aftenpos, _балдырға, _цэраний_, 
   {{0xe99704ab,0xc2a00272,0x0ea20176,0x04de0350}},	//   _ubojstva_, _amubba_, _felterne_, _ኩባኒያዎች_, 
   {{0xbd4e02fe,0xe9c7026f,0xac7601fe,0x987005ce}},	//   _محکمی_, _далада_, _iwirini_, _getirild, 
   {{0x527f023d,0x3fc0033b,0x72be0149,0xd15101b3}},	//   _utenti_, _feteletš, _nwayọọ_, _струм_, 
   {{0x0394002e,0x726c02f3,0x70a90188,0x24b4000a}},	//   _zaista_, _sidor_, _мекнан_, _annannik, 
   {{0x726d0141,0xfd1d00c4,0x926d02f6,0xe3000344}},	//   _kitob_, _سيٺارجا_, _antok_, _allatai_, 
   {{0xe2480118,0x59f901fe,0xc2fc0194,0xf800002b}},	//   _edomu_, _kamakore, _fatigat_, _পাশবিক_, 
   {{0xf26c022e,0xa3860377,0x81540204,0xf37f0223}},	//   _valori_, _oferi_, _hakusano, _ardanza_, 
   {{0x92260003,0x226c0374,0x776d0060,0x42eb0098}},	//   _werken_, _salom_, _қазпочта_, _blandes_, 
   {{0x17c90055,0xaed5031d,0x2248019e,0x6420004d}},	//   _soustrai, _shriekin, _idomu_, _般若波羅密多心經, 
   {{0xe3770162,0x826e04e7,0x122401c6,0x7cb30061}},	//   _ۋىسال_, _maroš_, _nynke_, _이산화탄소_, 
   {{0xc26c01f0,0x779f0281,0xbc8900d9,0x7c8000bb}},	//   _nomore_, _mittarfi, _заключит, _ٹائیٹل_, 
   {{0x27b1004d,0x59b1034e,0x6373033f,0x73940338}},	//   _上海第八屆國際攝, _bigdelet, _kihaane_, _baissa_, 
   {{0xf6a301b5,0x493802eb,0x639400d9,0xcb750109}},	//   _cheddarf, _сайтууда, _paista_, _formátů_, 
   {{0xbc56023d,0x526c01f4,0x02eb0238,0xf270051f}},	//   _partire_, _halok_, _sminker_, _ڵقورتاند, 
   {{0x83bb0429,0x5fca00e6,0x38d3010d,0x7da301e4}},	// [1cc0] _arowana_, _促进社会和谐_, _tulungag, _ležící_, 
   {{0xd2fe0445,0x803701b5,0x00000000,0x00000000}},	//   _antigas_, _khutazan, --, --, 
   {{0x33950578,0x9291036e,0x13ea02e9,0x126c014a}},	//   _huvsi_, _ajuaq_, _faltan_, _dalok_, 
   {{0x4300025b,0xdc17016a,0x20c103f0,0x00000000}},	//   _lisberg_, _abcajedr, _fagfólki_, --, 
   {{0xa51f0178,0xead50047,0x8db8044d,0xeae30434}},	//   _anantabh, _histoire, _defaraat_, _requiere, 
   {{0x026e0287,0x31b80455,0x62e60676,0x9d3c0039}},	//   _autory_, _remercié_, _sjenila_, _обьектий, 
   {{0x88d90074,0x3e520465,0x42d80168,0xb870013c}},	//   _сервисы_, _potaplja, _damene_, _yetirild, 
   {{0xe26c02a2,0x07a300be,0x4201003b,0xf2da0222}},	//   _aalok_, _بەيعام_, _babite_, _entend_, 
   {{0xd8960147,0xdf5c00f2,0x105400e2,0x962c01d5}},	//   _максаты_, _apraksts_, _betsjoen, _pornófil, 
   {{0xe2d80198,0x2c2701b9,0x9616011f,0x334b0176}},	//   _namene_, _fristras, _суверент, _futenou_, 
   {{0x02da017e,0x65380397,0x00000000,0x00000000}},	//   _kapelo_, _angikush, --, --, 
   {{0xb3870396,0x13160306,0x61110002,0xe2cc032d}},	//   _dwarna_, _balzar_, _prašina_, _ebeliso_, 
   {{0x5e0c0245,0x726d0074,0x0b9e033f,0x66e10058}},	//   _tendulka, _antoi_, _foungaho_, _rebbachi, 
   {{0xad3200c7,0x57190361,0x69d001f2,0xd29000ad}},	//   _корсак_, _михалков, _шеһид_, _somad_, 
   {{0x226c0028,0x724902cb,0x525b0455,0x02fc00dd}},	//   _madow_, _kremom_, _appli_, _drigai_, 
   {{0xcf4c0432,0x00000000,0x00000000,0x00000000}},	//   _tinglysn, --, --, --, 
   {{0x294600c5,0x247b001e,0x49fc00a8,0x99d80612}},	// [1cd0] _国家外国专家局_, _littafin_, _excursiu, _forenkle, 
   {{0x937f0031,0x631300d6,0x68780272,0x00000000}},	//   _bedanya_, _saibhir_, _banneeku, --, 
   {{0x6341018f,0x568d003a,0x7520018a,0x00000000}},	//   _bilesmo_, _ekofesti, _llanfach, --, 
   {{0xd7dd01cf,0x3e9c0020,0x126e0541,0x03560162}},	//   _displaci, _maimoain, _varoš_, _بىرما_, 
   {{0x02900125,0xd63504d6,0x851f01cc,0xb30e0141}},	//   _almak_, _वविद्याल, _anantasy, _arabcha_, 
   {{0xfc1000c1,0x2c170343,0x53860282,0x1a2100ec}},	//   _kesukses, _aliadier, _ngere_, _skandalą_, 
   {{0x626c009d,0x3c0304b7,0xfb1800f4,0xbe3a0499}},	//   _kaloi_, _versier_, _bakadenn_, _masalosa, 
   {{0x34030094,0xbe4b02f9,0xe6720133,0x18b00109}},	//   _بىرگەمىن_, _casaonca, _daddafsi, _धितोपत्र_, 
   {{0xd22502b0,0x73870107,0xeb680040,0x3c480156}},	//   _deckel_, _awarna_, _מתקשרים_, _טעלפאן_, 
   {{0xd2fc0233,0xb41d019b,0x726c028d,0x8c93034c}},	//   _cadidas_, _meningok, _laloi_, _аңлатучы_, 
   {{0x529f0510,0x062c0260,0x529001a6,0x3889015e}},	//   _очевидны, _reciclax, _kanapu_, _даназала, 
   {{0x5f030677,0x72ab01b0,0xa2d8050e,0xe2c40075}},	//   _निर्मोही_, _gandeng_, _zamene_, _eineiasi_, 
   {{0xb2d8032d,0x02d80226,0x0af70085,0x72e303db}},	//   _mamele_, _pamene_, _nabukele, _ishiywe_, 
   {{0xd2900231,0x826c0028,0x82eb007b,0x8da900bc}},	//   _romae_, _cadow_, _glances_, _بواسیر_, 
   {{0x825d0148,0x22ab023e,0xf46600c5,0x530f0119}},	//   _鍾永豐客語詩歌_, _bandeng_, _下属管道防腐施工, _dzierå_, 
   {{0x531f0416,0x57a5019a,0x29ec003c,0x4388012e}},	//   _glacial_, _affronti, _artikata_, _ennyien_, 
   {{0x295900c6,0x7c2b041c,0x522f0452,0x5e93015e}},	// [1ce0] _семеро_, _karbonar, _जाईचिया_, _келишинд, 
   {{0x6aad0278,0x0d2c0436,0x3a1601e0,0xc4f501c8}},	//   _berkawan_, _zavirite_, _دانشگای_, _kapitálu_, 
   {{0x2da30040,0x7f6401a0,0x84230103,0xc348050e}},	//   _הנופש_, _hakanyin, _chibharo_, _spreči_, 
   {{0x728b000c,0x1f6402af,0x3cbf033f,0x56af03a2}},	//   _адраматә_, _bakanyin, _konatapu_, _एस्तोनिय, 
   {{0x172502da,0x22d80085,0x526c033d,0xe2530184}},	//   _montagem_, _damele_, _salop_, _buhengam, 
   {{0xfc54028d,0xf2e3003b,0xefef01be,0xe9f501eb}},	//   _disteng_, _ashiywe_, _जनभावना_, _ipeón_, 
   {{0x8c07001d,0x2f120219,0x2c280107,0x8ab2004d}},	//   _atestat_, _akutenta, _بوانات_, _遠流出版股份有限, 
   {{0xd3350097,0x71f30126,0xe2c3016a,0x3290008e}},	//   _hanghó_, _критерії_, _anglion_, _jemadi_, 
   {{0xb31701d1,0x19d00143,0xad0b0376,0xf3410053}},	//   _planning_, _петия_, _forritar, _gebetan_, 
   {{0x737f01c5,0x13fa01b2,0xbfc200bb,0x626c0179}},	//   _kulanka_, _piqued_, _یاجوج_, _talop_, 
   {{0x92010030,0x930e04ec,0x92d80347,0x00000000}},	//   _diviem_, _arabaha_, _kamele_, --, 
   {{0xdfe6002e,0x82fe0242,0x49fa046f,0x984d0256}},	//   _povrijeđ, _intizar_, _dorausse, _pavadzīm, 
   {{0x52b40037,0x8f2a021b,0xc37f0077,0x2b0c0478}},	//   _lancap_, _martinla, _gedalya_, _bengalin_, 
   {{0xe51b0148,0xcd180393,0xae3c03b9,0x1c1800ac}},	//   _skinligh, _izložbe_, _saranaqa, _izložbu_, 
   {{0xfb8d02e8,0xb6970188,0x1c6103e0,0x255e02fe}},	//   _mamiriro_, _микдори_, _kadrage_, _استرلیا_, 
   {{0xbfe1008d,0xcc7e0035,0x764d0095,0xe3f8007f}},	//   _ибратли_, _barsın_, _يزداني_, _gwaun_, 
   {{0x626c03ff,0xb2eb02a3,0x68410259,0xce9601db}},	// [1cf0] _pomoct_, _blankes_, _realkred, _وگەيىستۋ, 
   {{0x926d0250,0x99e400a0,0x02bf0102,0xeeaf00a3}},	//   _fitoi_, _aikomana_, _شمشان_, _akkordan, 
   {{0x2290033f,0xb30f024a,0x1140038b,0x82aa017a}},	//   _aleaa_, _amubina_, _mendahul, _саховатм, 
   {{0xa9b9003e,0x00000000,0x00000000,0x00000000}},	//   _hotetswa_, --, --, --, 
   {{0xe0ab00c1,0x3230056c,0x00000000,0x00000000}},	//   _चिमुरी_, _kremlja_, --, --, 
   {{0xa2d8048d,0x1d0f01b4,0x4e03020d,0x5d9302e1}},	//   _prnews_, _inkomste_, _zerekera, _محترفات_, 
   {{0x3fae00a4,0x4faf00e6,0xbf370128,0xd9ef00d0}},	//   _convenis_, _大家可以自由转载, _улуғми_, _бялдаржу, 
   {{0x12fc026b,0xf3790016,0xb3f80488,0xbe4e0167}},	//   _salidas_, _israela_, _cukurs_, _drobwynt_, 
   {{0xd24b0044,0xb23704bb,0xb99c006c,0x089c006c}},	//   _בהיקף_, _tsimtsa_, _abakwame, _abakwamu, 
   {{0x185d011d,0x22bd022f,0xdb2700e6,0x086d0325}},	//   _минерале_, _спробах_, _内容的真实性_, _vadisind, 
   {{0xc3f8033a,0x035201e6,0x0ba600f6,0xc5f70153}},	//   _veduta_, _stručný_, _benzinin_, _タイに持ち出そう_, 
   {{0x626c0377,0xe2d00240,0x302501a3,0x3c4f012c}},	//   _cadou_, _mekesini_, _موٽرن_, _thawabu_, 
   {{0x43fe03ad,0x28540102,0x083e0211,0x4ea000d8}},	//   _kwalifik, _سوويت_, _диски_, _alertaue_, 
   {{0x24a80037,0x3f2e014e,0x22ff01d3,0x6a8d00e7}},	//   _ተገንዝቦ_, _мисле_, _skriker_, _arenthes, 
   {{0x63ce049e,0xe8780157,0xb30c012d,0x338600f2}},	//   _slovan_, _शब्दलेख_, _breakas_, _aborts_, 
   {{0xbc1101da,0x110200e6,0x496d012d,0xc95101d4}},	//   _sarandë_, _各级人民政府应当, _patisipe, _grillett, 
   {{0xc06003ba,0xd2ff034e,0x06f000e6,0x7dae016f}},	// [1d00] _aussöhne, _allanapi_, _中国建设银行_, _бориспол, 
   {{0x69e403f6,0xa387005b,0x3e740299,0x9c8a0037}},	//   _solomona_, _afuro_, _ئىتوتلىر, _ማግኘቷን_, 
   {{0x3f5d002c,0xadca0435,0xb2f401a6,0xcf5b0029}},	//   _erlazion, _upoznaju_, _käinga_, _هێمفێر_, 
   {{0xc35300a7,0x82e0038f,0x4b0405dc,0x128c00ee}},	//   _تۇرات_, _skinwel_, _prishist, _gurasoei_, 
   {{0xe31c031a,0x9f21025b,0xc22604d7,0x3eca04e3}},	//   _chabair_, _vanligar_, _verkin_, _spoznaje_, 
   {{0x17d402ec,0x40da0164,0x94b500e6,0x00000000}},	//   _کھاسى۪ن_, _чөмүлгән_, _农民专业合作社应, --, 
   {{0x4c7f046d,0x9e80033d,0x00000000,0x00000000}},	//   _mutsiko_, _jilbrèt_, --, --, 
   {{0x2f9a0125,0x1ea501b4,0x1d89015e,0x8b7a002c}},	//   _билишими, _omstrede_, _divertit_, _товлосон_, 
   {{0xc201033d,0x1070024a,0x0b74004b,0x497c04ae}},	//   _egzije_, _ketadilo, _hlaselwa_, _капиталу_, 
   {{0x7eb102ca,0x91b00208,0xe3940558,0x42ab02a2}},	//   _كلاسيك_, _مناله_, _ikesa_, _handang_, 
   {{0x8366003a,0x92e50285,0x02fc008d,0x929101dd}},	//   _бердилар_, _iminota_, _talabasi_, _arwaye_, 
   {{0x138702af,0x0ddc00bb,0x36310333,0x8b65023d}},	//   _atarya_, _زلغوط_, _itinerai, _collegar, 
   {{0xd8d40091,0x3963032d,0x32a703eb,0x47270095}},	//   _hakuging, _akgohale, _verby_, _مداخلات_, 
   {{0x59f80564,0x02f50229,0x4f0a043b,0x658000db}},	//   _delagase, _satiram_, _clàir_, _paberleh, 
   {{0x336a0047,0x00000000,0x00000000,0x00000000}},	//   _bougies_, --, --, --, 
   {{0x1f6d01cc,0x43eb00ac,0x32ab04b2,0x00000000}},	//   _संस्कृतं_, _slatke_, _gandang_, --, 
   {{0x027f0663,0x47dd0212,0x290b0038,0xef07029a}},	// [1d10] _amanfo_, _supplici, _уянып_, _temwanya, 
   {{0x93860272,0x4f5b0281,0xe27e0067,0x0ade0220}},	//   _ngeri_, _qularnan, _aminoo_, _лампи_, 
   {{0x63940240,0xe2ab02f6,0xe6530343,0x1da003bd}},	//   _akesa_, _bandang_, _anthelmi, _almorana, 
   {{0x4b7e033a,0xe56d0156,0x763e0316,0x93cd019b}},	//   _fruntier, _סימפאטיע_, _biritani, _бярнова_, 
   {{0x4f470024,0xa48a0025,0x42d9011a,0x637900ed}},	//   _ভাওনাত_, _प्रतिकाङ, _wrinkle_, _kayahon_, 
   {{0x52900190,0x39500590,0xea8e00be,0x99ec018b}},	//   _glean_, _negoziat, _رەۋئزىيا, _estimata_, 
   {{0xa394002a,0x95bd0299,0xab16007f,0xb3eb0453}},	//   _ekesa_, _ئەلرايىن, _gampwait, _kretao_, 
   {{0x6b5a04ae,0x7e410253,0xf290009b,0xc2ca0274}},	//   _прокомен, _sapaatit_, _alean_, _andliti_, 
   {{0xb9cd01cf,0x7a810371,0x7a3f03ad,0x62380128}},	//   _impellit, _убеден_, _ikkawżat_, _atamasi_, 
   {{0x03eb0265,0xf5de0235,0xa26d0165,0x32330145}},	//   _flythe_, _adhruvā_, _kitou_, _выпускам_, 
   {{0x52f10416,0x70530078,0x30b60334,0xc1cc036e}},	//   _seriosi_, _логике_, _chamakol, _coloresm, 
   {{0x73170333,0x65ff03fc,0x8997004c,0x88610092}},	//   _puzza_, _framtidi, _abojjere, _国立教育政策研究, 
   {{0x5e10036d,0x22fc04bb,0x574d01e6,0xd53e0303}},	//   _chreidea, _ualicas_, _vanilkov, _dirisany, 
   {{0x527f0039,0xcd850122,0x3bdf00aa,0xb2b70101}},	//   _emango_, _prambana, _firetruc, _bendeac_, 
   {{0x93670109,0x548600c7,0x7a040328,0x1c6b0350}},	//   _protirom, _смсны_, _kahashit, _የተምታታ_, 
   {{0xd6c9009b,0x8ddf0291,0xf146021b,0x00000000}},	//   _жавзанда, _أسعدني_, _saaristo, --, 
   {{0x23f40003,0x33940134,0xba760524,0x58d50119}},	// [1d20] _zitten_, _aheso_, _zračne_, _kagurang, 
   {{0x826c04b2,0xe84b0311,0x00000000,0x00000000}},	//   _balot_, _ክንሰግር_, --, --, 
   {{0x4cba0036,0x82b9003a,0x7b1d02ba,0x585200e0}},	//   _عراقنا_, _норасмий_, _бодияниш, _prysters_, 
   {{0xc26c00d9,0x00000000,0x00000000,0x00000000}},	//   _valot_, --, --, --, 
   {{0x40590213,0xe9e40308,0x9cde010f,0x00000000}},	//   _черкес_, _dikumand, _ayikhulu_, --, 
   {{0x129002c2,0xce290087,0x155f0061,0x7c03042e}},	//   _almal_, _choosers_, _개인정보취급방침, _hersker_, 
   {{0x7a340169,0xac6800b6,0xd30e04ec,0x2e720061}},	//   _জানিনা_, _abuuruh_, _arabuha_, _생로병사의_, 
   {{0x27c500dd,0xd26c02f6,0xce570037,0x119603c1}},	//   _aberystw, _halos_, _የተዘረዘሩት_, _хуманост, 
   {{0xb3f4021b,0x835600c3,0x9a4d00da,0x5dc7045e}},	//   _sitten_, _impetus_, _нациуний_, _дебелина_, 
   {{0x83f4019a,0xc51c031a,0xdf35004a,0x725a0097}},	//   _pitten_, _chinnidh, _avtorlar_, _imole_, 
   {{0x0fbf033e,0x6b670200,0xbdbd0067,0xd635032c}},	//   _amondoro, _juputara_, _barichaa, _annikigi, 
   {{0x39b900b5,0x09b801ed,0x73870258,0xe21802ba}},	//   _adjetiva_, _halelewa_, _learen_, _аблах_, 
   {{0x226c0245,0xdd060156,0x6c6a046f,0x9c53025c}},	//   _nalor_, _עירובֿ_, _biergem_, _mütter_, 
   {{0x62ee0059,0x3aa701a3,0x73010018,0x2a8f0307}},	//   _шоколадо, _انشاءَال, _kurabui_, _bemicimb, 
   {{0x03940516,0x56a2056d,0xc26c0245,0xe6b70058}},	//   _sensed_, _ukuthath, _halor_, _cenamati, 
   {{0x6ed9015e,0x82010235,0xe35c001d,0x00000000}},	//   _создорду_, _avaimi_, _págine_, --, 
   {{0x726c00aa,0x7e03027b,0x926c02be,0x6292001d}},	// [1d30] _balos_, _surendra, _salot_, _neways_, 
   {{0x3b6f0148,0x1d79002b,0xf05b02e7,0x126c009d}},	//   _受想行識亦復如是_, _দ্বিগুণ_, _kakakapo, _malor_, 
   {{0x5f230233,0x853504b2,0xc35702d3,0xe05b000c}},	//   _deplorar_, _binibigy, _desejar_, _jakakapo, 
   {{0xeb3702c6,0x2c6100e9,0x08d701cd,0xd3950059}},	//   _herblain_, _degutan_, _шиками_, _riesci_, 
   {{0x953200bf,0x67160148,0x723100ae,0xbc5a04b2}},	//   _многочис, _此篇留言為私密留, _amumuha_, _matulog_, 
   {{0x2a6c0224,0x62910488,0xec6b0426,0x116b0260}},	//   _heimilis, _segals_, _चेल्सी_, _agasallo, 
   {{0xb247016d,0x4fac00bb,0xf65301c4,0x15b9012e}},	//   _ﺋﻮﭼﯘﻕ_, _کتابچے_, _wiskundi, _اولادوں_, 
   {{0x2c0501aa,0xd03e0135,0xd2900170,0x3291007d}},	//   _userway_, _ekaterin, _binamu_, _aduan_, 
   {{0xc5a80069,0x63870258,0x559701e6,0x02f80149}},	//   _amashyak, _kearen_, _alergick, _ọhere_, 
   {{0x83870047,0xc2ab013a,0xeabb00ff,0x32d10024}},	//   _leurs_, _landung_, _provinca_, _মাইক্ৰ_, 
   {{0xe3eb0453,0xcd8b0008,0x23d00397,0xe6d800bb}},	//   _zlatne_, _joventut_, _abamemez, _کووسعت_, 
   {{0x2386004f,0x0aeb0073,0x01bd023e,0xdade01f0}},	//   _amerig_, _clarment, _طلائی_, _bosenagb, 
   {{0xfc7600b9,0x66f60153,0x00000000,0x00000000}},	//   _मित्रा_, _ム周辺機器_, --, --, 
   {{0x3f060368,0x9a370187,0x00000000,0x00000000}},	//   _титулом_, _ризаов_, --, --, 
   {{0x4dcf006c,0x72010181,0xaf000516,0xe3f8030b}},	//   _abahambe_, _viviam_, _discards_, _adduka_, 
   {{0x23170058,0xf38702c2,0x626c013b,0xb328048a}},	//   _kurze_, _beurt_, _balor_, _تومپاق_, 
   {{0x2cfd02e5,0x53290037,0x70330189,0xff640120}},	// [1d40] _aimesẽgu, _ኃጢአተኞች_, _listelen, _makaayin, 
   {{0xe2900418,0x4aba037f,0xdcae02fd,0x5bac0256}},	//   _olmak_, _kanadalı_, _farsuing_, _sadursmē_, 
   {{0x139400ea,0xac610036,0xc56000e4,0xef260166}},	//   _anisan_, _taquila_, _अभ्यर्थि, _berliner_, 
   {{0x2eea01c7,0x12620374,0xf290033f,0xe26d0290}},	//   _залларын, _умуминсо, _lemani_, _antop_, 
   {{0x32b602da,0x00a30276,0xcf5c0403,0x60d1019d}},	//   _планирањ, _سەلبىي_, _dadatoan, _kalondol, 
   {{0x17e7026c,0xff26003c,0x00000000,0x00000000}},	//   _auspicii, _پاتختی_, --, --, 
   {{0x92e900ec,0xc304004b,0x74760013,0x00000000}},	//   _француза, _homolong_, _мурсийни, --, 
   {{0xa9df0479,0xe200011f,0x73780285,0xd3fa033a}},	//   _augusztu, _bolita_, _rugamba_, _inqumu_, 
   {{0xc29101ed,0x83c40169,0x6526016d,0x03870003}},	//   _awaawa_, _ব্যতিক্র, _ﻧﻪﺷﯩﺮ_, _deurs_, 
   {{0xd236002e,0x533c017e,0x7290011c,0xd2900202}},	//   _broja_, _גלובאָק_, _domam_, _jemani_, 
   {{0x3f2d02f3,0xb2a0013c,0x8f5703db,0xf16c020a}},	//   _inrednin, _bildirə_, _emgaqwen, _ғибратты_, 
   {{0xb2900449,0x561a0056,0x92900027,0xd9c402b0}},	//   _sinaju_, _доғистон_, _fomam_, _gelegent, 
   {{0xe4c30024,0x023603f4,0x6b760193,0x5e17007f}},	//   _ৰক্তক্ষৰ, _eroja_, _आवश्यकते, _cadeirla, 
   {{0x675a005c,0xfc1e018d,0x11ac013c,0x320000c8}},	//   _igenamig, _መንግስትኻ_, _balansın, _holisa_, 
   {{0x03870127,0xe3870265,0x62000362,0x8d130211}},	//   _seurt_, _beurs_, _kolisa_, _нынче_, 
   {{0xa2000100,0xe2900172,0x9f230079,0x5378034e}},	//   _dodira_, _komam_, _iniciatī, _allatin_, 
   {{0xda89035b,0x1c5c0352,0xb2010184,0x0c6e0445}},	// [1d50] _ministrs, _পচন্দ_, _buzimu_, _amarela_, 
   {{0xf3b4017e,0x4294023b,0x23cf0145,0x635400ee}},	//   _הריגות_, _inikini_, _dievas_, _diseinu_, 
   {{0x62900390,0xc6370057,0xc2730211,0xac6a0064}},	//   _almaq_, _peribadi, _сувениры_, _гардизин, 
   {{0x82900016,0x138d0281,0xa4be0064,0x8e36038e}},	//   _homaj_, _asasaani_, _баянынын_, _tinggika, 
   {{0xde510321,0xa11f042c,0xf17d0040,0xd3f403d5}},	//   _pomanjka, _raspolaž, _טיעון_, _aittin_, 
   {{0xc37a0067,0xa290001f,0x761b03b4,0x62240259}},	//   _abaaboo_, _gemani_, _akandivi, _synke_, 
   {{0xfc1400bc,0x36810126,0xd200004b,0xef3900c1}},	//   _مومنی_, _церемоні, _bolisa_, _कानिटकर_, 
   {{0xc20000ee,0x626c03f8,0xfbae0147,0x47fa0311}},	//   _polita_, _dalop_, _تكەلەي_, _ጋብሪኤል_, 
   {{0x995f02c5,0xdeeb036d,0x00000000,0x00000000}},	//   _chenjere, _mathanas_, --, --, 
   {{0x8b7b0373,0x83010013,0x57b70233,0xaa230294}},	//   _originan_, _turardi_, _hyperlog, _hampiyku, 
   {{0x96f003b7,0x726c01f4,0x79c0013a,0x22cb05ad}},	//   _acebookf, _taloq_, _berechte, _podosta_, 
   {{0x83ea0587,0x6ed00192,0xcdd30359,0x9246023d}},	//   _unitat_, _없으신가요_, _bakkefea, _едвам_, 
   {{0xeb30018b,0xb2000040,0x9c7d00cf,0x12ca025e}},	//   _невой_, _במפורש_, _aidsiin_, _tilliti_, 
   {{0x175b007d,0x227f035d,0x33f9027f,0xbe0d02fe}},	//   _menyukai, _stenci_, _habuze_, _حیاتي_, 
   {{0xac5305f5,0x7318010b,0x42900342,0x6c4300be}},	//   _पैकेज_, _bakileng_, _domaj_, _بىلبەستى, 
   {{0x12da033d,0x2fe802ec,0x7c4c006c,0x173702ba}},	//   _asanble_, _یتیٖم_, _abawisi_, _урунбой_, 
   {{0xc5a804e1,0xd269005e,0x47b501b2,0xfd130148}},	// [1d60] _preporuk, _ئىلھاملا, _anveanag, _consuler, 
   {{0xc2fd0061,0xec040220,0x7379004d,0x00000000}},	//   _kregen_, _consumi_, _交通及地理位置_, --, 
   {{0x22720273,0xe03e0265,0x6c0e02a8,0x130a03f3}},	//   _dónde_, _huwelijk_, _aluminju_, _mannelij, 
   {{0xe27f04bd,0xdc0b015c,0xf6b0002b,0xb00f002c}},	//   _atenai_, _zampano_, _পপুলার_, _омголон_, 
   {{0x537300b3,0xe03e0023,0x6b1902ff,0x1d62028a}},	//   _sungaty_, _proteiin, _akwasman_, _قديمھ_, 
   {{0x31c305cf,0x334c0042,0x5290026c,0x482e0074}},	//   _nastavak_, _futebol_, _romam_, _tammikuu, 
   {{0x62900025,0x38dd0092,0xc29103f5,0x02fe01aa}},	//   _somam_, _プロジェクト_, _legais_, _awardway_, 
   {{0xe2900527,0x626c0678,0xb06d0241,0xb6850187}},	//   _momak_, _pomoze_, _bakakkoo, _нудиме_, 
   {{0x42e700b0,0x637a00b4,0x6f2d00e6,0x00000000}},	//   _marnaba_, _romanul_, _人民法院应予支持_, --, 
   {{0xe218027e,0xe3fa0133,0xe14901a3,0x12bc00da}},	//   _елементи, _boruus_, _وزٽرن_, _handbal_, 
   {{0x878c007e,0xf3070095,0x72900049,0x5d8f0170}},	//   _भाषार्थः_, _rembang_, _femali_, _amalinga, 
   {{0x03070057,0x620002e0,0x27b50074,0x3290018b}},	//   _sembang_, _bodipa_, _panssari, _somaj_, 
   {{0x56480462,0xcc4601ce,0x039400cf,0x3226021b}},	//   _againstw, _جریمه_, _ciisan_, _merkin_, 
   {{0x5a0701f5,0x53f902fa,0x939500ee,0x0c6500ac}},	//   _temannya_, _kabuye_, _abesti_, _vrhunac_, 
   {{0x920001f4,0xdaea0092,0xd6520299,0xcaa70142}},	//   _oldiga_, _前記スキャナヘッ, _ئىۋەرتىپ_, _महर्षिणा_, 
   {{0x73f900a9,0xe3f902af,0x5b180306,0x12bb02f7}},	//   _mabuye_, _cabuze_, _cemplade, _itheile_, 
   {{0x1307023e,0x07c20388,0x6f510192,0x59290147}},	// [1d70] _tembang_, _passaggi, _유념하시기_, _تىلوۋات_, 
   {{0xda8a01b9,0x7f7e0153,0x58dd0012,0x55fe007e}},	//   _dividenn_, _二世帯住宅の間取, _बाँटस_, _cedipāñc, 
   {{0x09f800f7,0x4d0a009b,0x637905df,0xb41d01e8}},	//   _metadate, _ikaragar, _kafafen_, _kausahan_, 
   {{0xa3860176,0x92e603b1,0x4b8d01d7,0xf3b60184}},	//   _ugers_, _génial_, _genituor, _ikavuza_, 
   {{0x59b70045,0x820201b9,0x62c30418,0xb9c50019}},	//   _прозор_, _larive_, _toplama_, _detectat, 
   {{0x880804af,0xf2d90097,0x8629018b,0x2655013f}},	//   _dabqhuas_, _nbeere_, _ingineri, _dudjenti, 
   {{0xb2150094,0xccf10281,0xe9fc0375,0xf5170105}},	//   _ءناپسىنى, _akitsuer, _balabant, _nadzorcz, 
   {{0xc0c6042a,0x7c1501db,0x7fcc0347,0xda27004d}},	//   _abelibal, _берешегі_, _motiveer_, _請作者在兩周內速, 
   {{0x5c1b00b4,0x0fd400d9,0xc3f7019d,0x4e0204ca}},	//   _vanatoar, _автокрес, _awerengi_, _arrefusa, 
   {{0xcc040328,0xb9cc0059,0x720201eb,0x00000000}},	//   _amosozi_, _allestit, _karive_, --, 
   {{0xa29000fe,0x02260211,0x08260040,0x13010235}},	//   _aleai_, _purkaa_, _בשבתות_, _caranti_, 
   {{0x63e60011,0x129000dd,0x32900014,0xe96e01ac}},	//   _amamotok, _comah_, _romak_, _lánghaei, 
   {{0xffe805e5,0x41790177,0xf04904f9,0x2dbf000a}},	//   _लावारिस_, _дшыгьежь, _akorngan, _annavaat_, 
   {{0x43ea0120,0x1ba900c1,0x00000000,0x00000000}},	//   _siitat_, _polytron_, --, --, 
   {{0xbaf7053e,0xe2fc01ef,0x1db703f5,0x3a3100ba}},	//   _selskape, _galimas_, _mobilida, _هیکرسن_, 
   {{0x22d90118,0xe200033f,0x48c50192,0xe9d003d5}},	//   _abeere_, _folipa_, _ingezond, _auberjee, 
   {{0x8fae02d3,0xdc6b03d1,0xa2e10177,0xe8cc00e0}},	// [1d80] _новогоди, _braucot_, _ибзиоуп_, _allebeid, 
   {{0xfe5600c7,0x70790109,0xc3fa00b4,0x32b901b2}},	//   _урысча_, _propustn, _porumb_, _boddash_, 
   {{0x729000a1,0xe3dd0475,0x6e36012c,0x19aa0435}},	//   _homai_, _способст, _اورنگزيب_, _водич_, 
   {{0xa2900082,0xd2e800cf,0x6eb70278,0x3da401d1}},	//   _komai_, _addigna_, _menziara, _resulted_, 
   {{0x198b01e9,0x53010350,0x7ee90060,0x02fc02f6}},	//   _baakanya_, _waranti_, _زامانىمز, _aligid_, 
   {{0x2236002e,0x8f58004a,0x8fc9015e,0x5f2d01f6}},	//   _broju_, _lukaşenk, _بالبانىن, _foreinin, 
   {{0x4f5200b7,0x83870200,0xd25b036e,0x33f80079}},	//   _алышмагы_, _ifuru_, _amalas_, _sajust_, 
   {{0x4f320180,0x760a00ea,0xe2900318,0x459400fb}},	//   _depresya, _torohevi, _oomai_, _nobuhlak, 
   {{0x5d0c022a,0xc00b01c5,0xce37043d,0x32c40497}},	//   _albufeir, _دربارٕ_, _kejahata, _bellied_, 
   {{0xb9df0037,0xe3010084,0x120102c9,0xf2de0206}},	//   _ጥቃቅንና_, _paranti_, _parintii_, _motorov_, 
   {{0xecb90162,0x662300e2,0x2f660344,0xd14302f7}},	//   _пәхәс_, _behoarli, _allangun, _groenwal, 
   {{0xd26c01a9,0xa3670233,0x7d8501eb,0x22ca0311}},	//   _lados_, _geprintm, _hendatee_, _ምውሓስን_, 
   {{0xf306035a,0x5fc20063,0x42fd02f6,0x33a002ee}},	//   _humazah_, _عاشور_, _alagad_, _akkademj, 
   {{0x495101b8,0x6d9d0049,0xf26c034a,0x87eb048c}},	//   _realisee, _faingata, _nados_, _aalaanag, 
   {{0xc95003dd,0x779f015e,0xf2690127,0xdef100e4}},	//   _negociat, _homenatg, _romantoù_, _तरिके_, 
   {{0x0379015d,0xa2f3002b,0x2a8b01f3,0xe31f044a}},	//   _telewizj, _স্রোত_, _nestojí_, _chegué_, 
   {{0x13010356,0x6c060190,0xd5e8050a,0xf2e5027f}},	// [1d90] _saranti_, _oturiay_, _mimarlık_, _iminuta_, 
   {{0xdd6e0354,0x426e0160,0x1300017f,0x626c03eb}},	//   _гирамдин_, _satovi_, _allagai_, _sadou_, 
   {{0x1290038d,0x88060046,0xe26c01ef,0x795e0037}},	//   _moman_, _клеткала, _mados_, _በየሳምንቱ_, 
   {{0xcc9a02e5,0x02900211,0x3c5302a0,0x00000000}},	//   _аверсиа_, _loman_, _olutaja_, --, 
   {{0x2e180177,0x0dde00c8,0xeb35036a,0x012d0188}},	//   _ахысра_, _башланыҡ_, _paratais, _шарту_, 
   {{0x826c0051,0x45f203b2,0x46670153,0x2a010322}},	//   _gados_, _permissi, _出版社の皆さまへ_, _babarega_, 
   {{0x1200037c,0xb25901fe,0xe2900172,0xbbca015e}},	//   _godiva_, _amonaiti_, _womaa_, _تارماقتا, 
   {{0x90140188,0x00000000,0x00000000,0x00000000}},	//   _вусъати_, --, --, --, 
   {{0xf29000f1,0xc26c0095,0xeeae0349,0x32fd0202}},	//   _koman_, _kados_, _abilizin, _ategun_, 
   {{0x89ca0440,0x59f9014f,0x3f4e0074,0xb347024c}},	//   _bitorera_, _medisana_, _mansikka, _iqaddes_, 
   {{0x526c003c,0xb0750126,0x13f90247,0x86c402fc}},	//   _dados_, _чудовий_, _babune_, _barashyi, 
   {{0x32fc01d9,0xd2e602c1,0xc3860066,0xf23f023a}},	//   _dengem_, _amanota_, _ageri_, _kalkulác, 
   {{0x42ca0271,0xc01000a2,0x925b00fa,0x855202dd}},	//   _bildet_, _ڳجھولفظ_, _umalis_, _gravitaz, 
   {{0x6d1f0503,0x19df0313,0x2290001e,0x10e80120}},	//   _planlagt_, _biroprup_, _noman_, _sabaabak_, 
   {{0x127f0016,0x31190023,0x5edb0488,0xc527005e}},	//   _atendi_, _keittiö_, _nolikums_, _ﺋﺎﺷﯩﻖ_, 
   {{0xc2900416,0x16d40140,0x33f8034f,0x83c00143}},	//   _homan_, _sasabihi, _adlula_, _сватбата_, 
   {{0xe29001ac,0xb212028b,0x63170107,0x03f80067}},	// [1da0] _plean_, _ndaha_, _ananging_, _adduma_, 
   {{0x74370282,0x0200038a,0x8f0200d1,0xf5c00297}},	//   _kaikarak, _boliva_, _কুচকাৱাজ_, _elektriç, 
   {{0xfdd103ad,0xe0f900d1,0x29240099,0xcfd1030d}},	//   _deskritt_, _গ্ৰাউণ্ড_, _chichabu, _batildir_, 
   {{0xe7590299,0xaecd00bb,0x00000000,0x00000000}},	//   _ئۈندەپ_, _bepillan, --, --, 
   {{0xec6800cb,0x8eb90055,0xe3f804a7,0xd96701a3}},	//   _wokuthi_, _disordin, _reduza_, _ڪلھوڙا_, 
   {{0xb2900197,0x4a0700b9,0x794e018d,0xc2b4005f}},	//   _goman_, _idealnya_, _ብዝወልዕዎ_, _rincon_, 
   {{0x435f01aa,0xb4cf0003,0xc22300bb,0x7c070101}},	//   _angeray_, _beschikk, _احساسِ_, _arestat_, 
   {{0x2b950242,0xbe050041,0xf26c003c,0x06880010}},	//   _sevindir, _ахаҧшьга, _ablok_, _bandluli, 
   {{0xcc4e0102,0xca7c0022,0x06f4015d,0xb7490059}},	//   _آمدني_, _ahlamisa_, _कारवां_, _ripostig, 
   {{0x938705d7,0x459e00ff,0x2ac3022a,0xd2d80051}},	//   _ngura_, _סודילקאו, _meropön_, _pamest_, 
   {{0x8f27019b,0xe2120015,0x228d00fe,0xe76901c8}},	//   _paprasta, _adaha_, _inukava_, _konkurov, 
   {{0xbdb10184,0xaeab0062,0x57570013,0x99ec02ac}},	//   _intambwe_, _danehnes_, _йерро_, _scriosta_, 
   {{0xc45e00ec,0xf2dc005a,0x93f80499,0x6cf90012}},	//   _народным_, _bolondi_, _ataua_, _आदिमियो_, 
   {{0xee9200c7,0xbd5803f1,0x182303fe,0xae0f020e}},	//   _protsent_, _reguláci, _нейтралл, _уставына_, 
   {{0x329000c5,0x034505b9,0x6a77017f,0xc485038e}},	//   _nomao_, _meddelt_, _illuliaq_, _रहदारी_, 
   {{0x9a8f034d,0x626c0633,0xd29801a3,0x3b2b005e}},	//   _demikian_, _almost_, _غزالا_, _ئىنئام_, 
   {{0x99e900b1,0x126c0107,0x42e700b0,0x226d0342}},	// [1db0] _mainidea_, _pados_, _doonayo_, _sitou_, 
   {{0x321201fa,0x92000275,0x00000000,0x00000000}},	//   _meihe_, _molita_, --, --, 
   {{0xf3ea004b,0xe5a90158,0x59480382,0x00000000}},	//   _diitse_, _trenerem_, _nononhwe, --, 
   {{0xd95901bb,0x02900358,0xc387005c,0xbc520241}},	//   _tekliple, _nomal_, _agura_, _briteen_, 
   {{0x58c90019,0xcc8000af,0x93c80079,0x05380296}},	//   _базалард, _дебет_, _latvju_, _brandsky, 
   {{0x4a8801ee,0x53ea0139,0x56240326,0x82a000f6}},	//   _основном_, _anitye_, _akamupaw, _klubda_, 
   {{0x93eb00c3,0x39780065,0x00000000,0x00000000}},	//   _pretio_, _polizist, --, --, 
   {{0x826d0145,0xb1f60241,0x7172023c,0x62cb0150}},	//   _kitos_, _amantumm, _ددښمنانو_, _stadim_, 
   {{0xb2e303ef,0xad9900b7,0xea0b01e1,0xadf9011a}},	//   _ishimwe_, _adalgala, _bosberat, _cohesive_, 
   {{0x62cb0271,0x626c0176,0x72eb0212,0x126d02dc}},	//   _gleder_, _vador_, _ioannes_, _ditos_, 
   {{0xb1cc00b7,0xa2d90527,0x457f0297,0xbe6a00e6}},	//   _хытая_, _poceti_, _birmäyäç, _卫生部关于印发_, 
   {{0x03f80171,0x62fd0242,0x8f4600bf,0x53f8031a}},	//   _odluka_, _yadigar_, _отличали, _duiue_, 
   {{0x79ad0095,0x6ba7013d,0x4fe500d0,0x47c20388}},	//   _تجربی_, _venkinto_, _авлигата, _passeggi, 
   {{0x4341033c,0x04050148,0x2c7300aa,0xce700157}},	//   _offeryn_, _網路申領電子謄本_, _kalsafa_, _dominują, 
   {{0xdb9903a1,0x9fa90203,0x8f2d01d5,0xc6de0119}},	//   _заплатит, _preferer_, _testalka, _pagpahay, 
   {{0x526c0176,0x7fa40180,0xa3940044,0x6adc02eb}},	//   _pylori_, _resepter_, _chest_, _нотлогдс, 
   {{0x03870257,0x026d0256,0xdbcd0046,0x5ef0032d}},	// [1dc0] _starfa_, _citos_, _кармалды_, _көрсөк_, 
   {{0xbf4703b0,0xb9f800d9,0x0a1e019d,0x83770088}},	//   _nærmast_, _varastet, _chibwana_, _فىلاش_, 
   {{0xb3650397,0x50d90092,0x00000000,0x00000000}},	//   _imigomo_, _地域ガイドとは_, --, --, 
   {{0xecd30159,0xcb9c0156,0x32c1018e,0x126d03ec}},	//   _сценах_, _אפעלאט_, _hahlula_, _titos_, 
   {{0x2301030f,0x07810053,0x021d02c5,0x92560178}},	//   _hararei_, _विधानपरि, _chakaini_, _bāhyāñ_, 
   {{0xb851001d,0x86a20220,0x5386030f,0xb9180099}},	//   _eforties_, _решеният, _ngeru_, _emichind, 
   {{0xef780211,0x726d043a,0x08e10620,0xdc3c0089}},	//   _женская_, _zitos_, _交通十分便利_, _bozunı_, 
   {{0xf276040f,0x72480499,0x2aa5016e,0x52d8044a}},	//   _moterišk, _afoma_, _kesintis, _bokeyi_, 
   {{0x026d0230,0x6f390679,0x023f001a,0x2b7000cf}},	//   _ditor_, _terutama, _kalkulát, _abbummaa_, 
   {{0x77330057,0x629b0004,0x7f8f002e,0xdc73028a}},	//   _አስነብበኝ_, _abichayi_, _teškim_, _falsafa_, 
   {{0xf3c305ac,0x7290013d,0x52a602ff,0x43fa023e}},	//   _dávid_, _nomas_, _kalbas_, _deputi_, 
   {{0x62020219,0x6153011f,0xf3410264,0xe077005e}},	//   _abakavum, _морель_, _doberan_, _ﻗﯩﻠﭽﻪ_, 
   {{0x54bb01cd,0x5eb80455,0x1dab0021,0xa3860119}},	//   _истаравш, _lorraine_, _ansittra, _kaoras_, 
   {{0x1a9200e1,0x5b150603,0x7386067a,0xc26c010b}},	//   _awantaas, _पत्रव्यव, _camra_, _dilong_, 
   {{0x16420409,0xacb70045,0x026d01fb,0x7f3a00b9}},	//   _最近の記事一覧_, _границу_, _sitos_, _विकिकरण_, 
   {{0x42d90227,0x6b1902a2,0xea0201f4,0xb89b0291}},	//   _segera_, _masaktan_, _кобулга_, _فأكثر_, 
   {{0xd9f701b3,0x8278027c,0x18a701ab,0x00000000}},	// [1dd0] _органу_, _awasenal, _मलेछवा_, --, 
   {{0xeef6027e,0x2a8901fc,0xf34504a8,0x830300be}},	//   _затреба_, _winiston_, _nijemac_, _كۅۅدۅك_, 
   {{0xb2640181,0xfdab03dc,0x026c012d,0xb2a600ed}},	//   _outlaw_, _kanninga, _hilong_, _balbas_, 
   {{0x2e960374,0x8067002b,0x629102c2,0xa607019a}},	//   _chempion, _মাসআলা_, _nogals_, _seeminli, 
   {{0x1dab0331,0xc301030f,0x7c27003d,0x00000000}},	//   _manninga, _karaati_, _aubadaur, --, 
   {{0x5ab900d6,0x63900074,0x358000da,0xceb40279}},	//   _sağyaşar_, _maksimim, _терминэм_, _attentes_, 
   {{0x61630162,0xfe1601fd,0x329000f2,0x803600b4}},	//   _бузуш_, _venezola, _jomas_, _tinerilo, 
   {{0x93070084,0xd2900079,0x9f470075,0xc2900013}},	//   _lembang_, _domas_, _nærkast_, _olmay_, 
   {{0xc03302d3,0x63890013,0xb94200d1,0xdc5500e6}},	//   _поточно_, _сезган_, _চোমনি_, _比去年同期减少_, 
   {{0x29f60479,0x1d240172,0x38270132,0xa03a0066}},	//   _روایت_, _nhankare_, _munkaügy, _genetiko, 
   {{0x22fc0225,0xe2900342,0x92020286,0xa96200bf}},	//   _apago_, _almay_, _ketiwa_, _неудобст, 
   {{0x4387067b,0xb2fd00ca,0x73470108,0x019a021c}},	//   _afuri_, _pregon_, _bekelna_, _kazetové_, 
   {{0x4edf0195,0x126c067c,0x4819004d,0xb6020211}},	//   _lochlann, _aeiohl_, _台中縣大里市東勢, _tabletti, 
   {{0x474e0411,0x32d501d1,0xaaf30372,0x96d901c2}},	//   _принесли_, _violent_, _achubiae, _psicolox, 
   {{0xba80000e,0x00000000,0x00000000,0x00000000}},	//   _atention_, --, --, --, 
   {{0x0d5e0193,0x325c026f,0x96b801db,0x1971014c}},	//   _कार्याबद, _جازلىعان_, _казросга, _kunikeze, 
   {{0x72da015c,0xf9d80092,0xda0e0255,0x5909027e}},	// [1de0] _zereck_, _日までです_, _maastiku, _сходно_, 
   {{0xcaf500f1,0x28a903b1,0x32fc0130,0xcc3c0135}},	//   _enternas, _stratégi, _spagn_, _forumı_, 
   {{0x63880306,0x9c6d01db,0x4df801a0,0x00000000}},	//   _atispanm, _قۇلچا_, _onheriwe_, --, 
   {{0x49d605db,0x04880289,0x827d00da,0xb29000ec}},	//   _ngothand, _adaganiz, _партикул_, _romas_, 
   {{0xeb3e01f6,0x4fd7013d,0xdd870226,0xccad005d}},	//   _নাস্তিকত, _fortikaĵ, _atambala, _mundopýr, 
   {{0x79e60211,0x2ae60204,0x22900119,0x376f0178}},	//   _harrastu, _harraste, _jomar_, _ariṃdamā, 
   {{0x7b9700ba,0x926e012b,0x376c011a,0x00000000}},	//   _داخرانی_, _istoty_, _והבנתי_, --, 
   {{0x4f3f0462,0xd69b0233,0xc569038a,0xfc2f02a0}},	//   _affrayja, _congluti, _chijilay, _rinpọ_, 
   {{0xac760062,0xdb9c020f,0xcf5c0170,0x6c170092}},	//   _antumir_, _abangako_, _angakwan, _balancer, 
   {{0x1cf101c9,0x747701b7,0xd37800f0,0x927900ec}},	//   _पाठकजी_, _प्रियाप्, _dodacia_, _visiskai_, 
   {{0xfc0003c2,0x58fc0064,0xb2700299,0x0b460158}},	//   _dissect_, _calamand, _تۇڭگۇز_, _atrakcją_, 
   {{0x626d02a7,0x903800fe,0xa6490022,0x2290034b}},	//   _gatoi_, _fietokon, _легаль_, _zomar_, 
   {{0xc7090301,0xc2900256,0xab0000af,0x72d904bd}},	//   _gündüz_, _somas_, _озеленен, _maeele_, 
   {{0x5fdf020b,0xc71d00be,0x0d3000d1,0x326c01e9}},	//   _bodipolo, _арасынын_, _দুটুকুৰা_, _iphora_, 
   {{0xe2000205,0x22ec02a3,0x835600b4,0x92ec034c}},	//   _moliya_, _kliniek_, _fetelor_, _олпат_, 
   {{0x838700c7,0xb0000178,0xf38700b4,0xd27f0016}},	//   _andrey_, _adhobhāg, _starea_, _planto_, 
   {{0x3d3b030c,0xc29005ca,0xf175030c,0x39f90303}},	// [1df0] _angayuqq, _tomar_, _kalaligl, _babalese, 
   {{0x97060360,0x1ea60148,0xf51f0139,0xdc270014}},	//   _kulturní, _台中市文化局_, _ananyabh, _serbinë_, 
   {{0x72b40227,0xeaf301db,0x07e302c0,0x706d0094}},	//   _cincin_, _بايپاعىن_, _морков_, _تارتاتىن_, 
   {{0x17570573,0x62000128,0xc248003b,0x9290005a}},	//   _مارتورٕ_, _oldida_, _agome_, _bomaq_, 
   {{0x5d720173,0xfab1028b,0x9edb0269,0x695a0177}},	//   _ভিত্তিতে_, _акритика_, _antiguos_, _палатаҟн, 
   {{0xcaef0166,0x8c73031c,0xdf690370,0x20090061}},	//   _geholfen_, _pensaba_, _akibalan, _룸싸롱업소_, 
   {{0x7627012a,0x1ae3048c,0x00000000,0x00000000}},	//   _terminow, _billioon_, --, --, 
   {{0x52da04b7,0xc4ed0444,0x43ff01d4,0x8db40208}},	//   _bereik_, _хранятся_, _andreani_, _شوکور_, 
   {{0xb26c00e2,0x02f60156,0x00000000,0x00000000}},	//   _gleone_, _batitaj_, --, --, 
   {{0x72fc00ca,0x6a130420,0x031f0060,0x22ca0212}},	//   _activat_, _descubra_, _بەرمەكشى_, _cuidam_, 
   {{0x33410309,0x4225067d,0x9ae20123,0xfe650308}},	//   _yunesko_, _kiakia_, _fritidst, _tempatmu_, 
   {{0xde4e02d2,0x703803f2,0xe7c70249,0x461f02ec}},	//   _дарди_, _tietokon, _aburusim_, _پون٘پر_, 
   {{0xf20204b8,0x1387019a,0xe52000b7,0xaf4400d1}},	//   _pariat_, _bearin_, _alanlary, _কামনাৰ_, 
   {{0xf3960656,0x83fe0036,0x329001e5,0x1430005e}},	//   _versio_, _قصيمي_, _ayoade_, _ﺋﺎﻗﯩﻞ_, 
   {{0x9be9047f,0x4506046d,0x88c6021d,0x00000000}},	//   _अमेरिकी_, _tselopah, _øresunds, --, 
   {{0x9f7004c8,0xa9dc002c,0xd6dd00c1,0x9b6a0188}},	//   _agħti_, _alderdie, _पुढिल_, _саҳланго, 
   {{0x5fe50309,0xe4500206,0x02460025,0x17b50075}},	// [1e00] _dostları, _uplatniť_, _केवले_, _teksturi, 
   {{0x7b6b02ea,0x32fd0333,0x8202013d,0x400e004d}},	//   _conoscer, _omagiu_, _metita_, _事後經公安交通管, 
   {{0x7fbc01d5,0x3390036e,0x3a2003d1,0xf98c0276}},	//   _تقاضوں_, _amayani_, _precizit, _ойнавати, 
   {{0xd3180402,0xb2e600e3,0xd31704a8,0xd9f400de}},	//   _gemilang_, _umanita_, _burzi_, _ebhaliwe, 
   {{0x87f00334,0x22fc019b,0x00000000,0x00000000}},	//   _akasidiw, _radijas_, --, --, 
   {{0x937802a6,0xac0d007e,0x00000000,0x00000000}},	//   _andaria_, _caruṃ_, --, --, 
   {{0xdf21002e,0xc2260127,0x5ae30089,0x00000000}},	//   _određeni, _turkia_, _kaplagan_, --, 
   {{0x785b04a0,0xa202006c,0x62cb018f,0x366700c1}},	//   _agrícola, _abakuvum, _heydaj_, _भरमसाठ_, 
   {{0x4fc302c1,0xe89d006c,0xcf0c00a7,0xdeb301d4}},	//   _erlinder_, _abakwaju, _funcions_, _anguille_, 
   {{0x2fa10270,0x82670188,0x436c0153,0x9c040153}},	//   _interrar_, _залонд_, _送料込み価格_, _みんなのクチコミ, 
   {{0xeff402a0,0xf2e10077,0xb2cb018f,0x62190013}},	//   _arikogbo, _chandel_, _meydaj_, _халокатг, 
   {{0xeacb00af,0x1202018b,0xf12000bb,0x1290016b}},	//   _sommeren_, _fetita_, _الاٹمنٹ_, _bomai_, 
   {{0x3f21002e,0xb3eb00b4,0xf39503fb,0x2d5c005e}},	//   _određeno, _спиритул_, _izasla_, _سۇكۇت_, 
   {{0xc3f8005b,0xdcf104b8,0x8ee402b4,0xb264023b}},	//   _staub_, _mantomer, _alukamen, _luuluu_, 
   {{0xe27f01b9,0xb3790054,0x961c00e3,0xa6360203}},	//   _prensi_, _nuwamba_, _bhalliki, _maritagi, 
   {{0x939401f1,0xc158008d,0x99f4020f,0x327e02b0}},	//   _pjese_, _агентлик, _abhaliwe, _szene_, 
   {{0x4e75008d,0xf6b80145,0x627401ec,0xd2ca02f0}},	// [1e10] _اندونیزی, _разраста, _توسلی_, _bahlali_, 
   {{0x7e90000c,0x430700bc,0xe2fd0428,0x0be70233}},	//   _hectárea_, _cembung_, _salonarj, _sutempor, 
   {{0xae690008,0x2deb019e,0xa38600e2,0x07dc0089}},	//   _تياتر_, _страшны_, _waerd_, _гавайлар_, 
   {{0xc2df012d,0x29b702ac,0xed850538,0x1fc3010f}},	//   _kokonat_, _جاكسون_, _referere_, _бебозгаш, 
   {{0x43790391,0xf26d0240,0xc2fd013b,0x82c70159}},	//   _mananeo_, _datou_, _alagid_, _засталас, 
   {{0x538702f3,0x89f4023c,0xbaf20166,0x13950216}},	//   _starka_, _achaziwe, _forumsbe, _mhusi_, 
   {{0xdd2c0220,0x214800f4,0xa9700066,0x00000000}},	//   _paziente_, _destenno, _akuikult, --, 
   {{0xebea0185,0xa7be0013,0xdf3300ff,0x00000000}},	//   _оркестрл, _jarrohli, _בייסבאָל_, --, 
   {{0xacf603d1,0x22f70389,0x63790046,0x214101b3}},	//   _studentu_, _fixixik_, _votaria_, _tallulah_, 
   {{0x2c6800cb,0xc2cb037c,0x260901ff,0x43410084}},	//   _kokuthi_, _quadam_, _artforum_, _ambekan_, 
   {{0x360f0462,0x02d8022c,0x00000000,0x00000000}},	//   _elementw, _buled_, --, --, 
   {{0x138700ee,0x1aa301df,0xb85b0046,0xf95a0216}},	//   _ataria_, _getherin_, _agrícole, _madokode, 
   {{0x424a0320,0x339500d8,0x4225001b,0xe27e002e}},	//   _brummm_, _liason_, _dhakaa_, _sumnji_, 
   {{0xb2cb0240,0xe5c9005a,0x82c702a4,0x0e9e03b8}},	//   _domodra_, _jorbehch, _equestri_, _сарлы_, 
   {{0xf4b101cd,0x56f5028c,0xebe701ac,0xa94200d1}},	//   _umnyango_, _आशावान_, _bardasac, _দুধনৈ_, 
   {{0x329000a5,0x486b020e,0x00000000,0x00000000}},	//   _tomai_, _указын_, --, --, 
   {{0x0b0a01c4,0x16b100e4,0x9c1c01a4,0x1ad801ac}},	// [1e20] _kanselle, _सत्तू_, _kobundis, _سواليف_, 
   {{0xc9b00075,0x06600334,0xb26e0145,0x03940367}},	//   _ongantíð_, _akukuthi, _matosi_, _pensou_, 
   {{0xa3f4037c,0x7e8c0223,0x92640343,0x887503f2}},	//   _certus_, _комменту, _itulod_, _отбелива, 
   {{0x0c630140,0x2bae002c,0x53920107,0x00000000}},	//   _patungo_, _сибирийн_, _banyadu_, --, 
   {{0xf2d402b1,0x761f0347,0xe2fd015e,0x326e014b}},	//   _wakokin_, _avonturi, _oblidar_, _tatoti_, 
   {{0xe2e90119,0x13870591,0xbe7d0023,0x569d00d9}},	//   _hainaut_, _styrka_, _придётся_, _appelsii, 
   {{0xf26d067e,0x19c60035,0xf213016b,0x02c90158}},	//   _tatou_, _перчатка_, _shehun_, _लखोटिया_, 
   {{0x2bde0040,0x926e0211,0x82480152,0xf207028a}},	//   _רוזמרין_, _katosi_, _filmı_, _wakiishi_, 
   {{0x239602a9,0xc0f6067f,0xaeb30455,0xabc3019e}},	//   _verslo_, _maliraul, _aiguille_, _алюмінія_, 
   {{0x0eae0057,0x898302c9,0x82d10145,0x1f5f01d4}},	//   _syarikat_, _модерне_, _neseniai_, _mutazion, 
   {{0xfa27050b,0x586d01da,0xf6cb030a,0x4801012a}},	//   _bercanda_, _kombetar_, _comarcai, _inspirow, 
   {{0x916302ea,0x727e021c,0x00000000,0x00000000}},	//   _correzio, _clingo_, --, --, 
   {{0x22ca0212,0x03e70479,0xd27f012c,0x1eb200d9}},	//   _pridem_, _hátha_, _mlango_, _академии_, 
   {{0x62390276,0x756001dd,0xf5a3012b,0xf57c006d}},	//   _норуз_, _abakiliy, _रश्मिरथी_, _асваеньн, 
   {{0x92c60160,0xb2830021,0x00000000,0x00000000}},	//   _poslove_, _adostray_, --, --, 
   {{0x23170300,0x72900359,0x62ec029a,0x626f00b4}},	//   _kurzu_, _bleau_, _aplikab_, _mediafax_, 
   {{0x96c70594,0x25fc03e2,0xf3170096,0x7d160374}},	// [1e30] _samarbei, _ascensió, _ahazwi_, _тарсаки_, 
   {{0x231600c2,0xfe4d008b,0x81390276,0x789700b9}},	//   _ikiza_, _boxarest_, _قابىليىت, _berkoord, 
   {{0x326e0082,0xb29002fc,0x226301a7,0xec670207}},	//   _fatori_, _amabandi_, _герметич, _kanumba_, 
   {{0xdebe0439,0x82d00059,0x529000b9,0xf9ec0241}},	//   _eukraine_, _здравнат, _pemaaf_, _galiinsa_, 
   {{0x8c680197,0x829100fd,0x9ba503d2,0x9dcd0395}},	//   _reprann_, _cogais_, _desiatic, _riskovat_, 
   {{0x17ae03c4,0x02ec007b,0xb75a0354,0x5dc302e7}},	//   _биргә_, _blithely_, _ئاچالايد, _kasingka, 
   {{0xd20201fc,0x3df5002b,0x32900049,0x1665014f}},	//   _sarite_, _চাইছেন_, _homau_, _аферу_, 
   {{0x22ca0680,0xa202038d,0xe3bc0147,0x62900318}},	//   _abodin_, _parite_, _الۇنۇ_, _komau_, 
   {{0xd2ef00e4,0x126e0079,0xb20000de,0x8e390203}},	//   _पदार्थों_, _datori_, _andiva_, _raportes_, 
   {{0xd3ea018b,0x1e740060,0x39f90603,0x735102cd}},	//   _suntem_, _сүзек_, _निर्मूलन_, _dauwamam, 
   {{0x2f640268,0xfb670681,0xa316005c,0x1c7e0047}},	//   _embarkin, _ईरानी_, _akiza_, _mensuel_, 
   {{0xf3870264,0x05710335,0x00000000,0x00000000}},	//   _styria_, _bhūsurot, --, --, 
   {{0xf38600e3,0x35b80074,0x0b14026c,0x4a1900be}},	//   _kamra_, _позволит_, _consilia_, _جىشقىچ_, 
   {{0x636d0256,0x18150013,0xb291056e,0x81400218}},	//   _intervij, _тураман_, _vogais_, _ahamgray_, 
   {{0xc9fc0420,0x23eb0210,0xbb8b000a,0xfe77020a}},	//   _задникот_, _apetro_, _annittar, _раббым_, 
   {{0x21fb024a,0x33eb00bd,0x7cb00040,0x7c660147}},	//   _fidimulẹ_, _coatie_, _האלמנטים_, _شاشكەدە_, 
   {{0xe2900033,0xd29005ce,0xa7c20040,0xdc0d00cc}},	// [1e40] _domat_, _olmaz_, _חחחחחח_, _kampene_, 
   {{0x9290007b,0xb9f801d1,0x92910203,0xed430311}},	//   _fleas_, _paramete, _efectivm, _ኣይልወጥን_, 
   {{0xd4690212,0x72490583,0x9974034c,0xe9960137}},	//   _profecto_, _čemer_, _defitsit, _вакцинд_, 
   {{0x535300ef,0xc29100f2,0x22ca0037,0x244301db}},	//   _مهمات_, _aigars_, _የድርድሩ_, _زىعىردان, 
   {{0x522402bb,0xbf250194,0x13f901e6,0xe341048a}},	//   _rynku_, _regretta, _tabule_, _انسار_, 
   {{0x820002e0,0xa202027f,0x6fc2028a,0xfb00034a}},	//   _bodiba_, _barire_, _بانور_, _pavillón_, 
   {{0xe2cb0237,0xebfe0334,0xd566029d,0x61c402a5}},	//   _moeder_, _alendowo_, _прочесе_, _nemožné_, 
   {{0xaf57029d,0xc20001f7,0xd25a0074,0x226402af}},	//   _армате_, _polida_, _kallio_, _ifunderi_, 
   {{0x526d0160,0xddad0007,0x00000000,0x00000000}},	//   _ratom_, _mangenge_, --, --, 
   {{0x3f080009,0x8ef30193,0x06da0014,0x276701b7}},	//   _ustvarja, _perkebun, _zëvendës, _तप्तखल्व, 
   {{0x4c670243,0xec0503eb,0x00000000,0x00000000}},	//   _ammunta_, _verteerb, --, --, 
   {{0xf7580682,0x62b403ea,0x12ee003a,0xedc401b3}},	//   _संस्मरण_, _débit_, _gapirib_, _пустелі_, 
   {{0xf9f6033f,0xcd140019,0x00000000,0x00000000}},	//   _palupalu, _жууркан_, --, --, 
   {{0x72900450,0x62fe00a0,0x1dc5021e,0x00000000}},	//   _sleat_, _fitinar_, _marklyft_, --, 
   {{0x6290031a,0xa4060130,0x429003d5,0x41c70107}},	//   _cleas_, _grennamz, _pleat_, _براندازی_, 
   {{0x2fd303ee,0x4a8300ef,0x87e70393,0x327e00f7}},	//   _trenutno, _ezazinge, _tajanstv, _alineo_, 
   {{0x832001ce,0x396b0486,0x13560155,0xb4580397}},	// [1e50] _دعوتنامه_, _filmovéh, _baseras_, _angesiwo_, 
   {{0xf696002b,0x427f00b9,0x537f02bf,0x096b03e0}},	//   _একাডেমীর_, _esensi_, _bemanga_, _aneneege, 
   {{0x0f320013,0x64f0017a,0xddf7004d,0x59d4025f}},	//   _عنوانیده_, _варорӯд_, _與我們聯絡_, _ekolanda_, 
   {{0x7471001a,0x730900ff,0x329000e0,0xe2b800ee}},	//   _pontosan_, _פיליפינע, _alear_, _mendiak_, 
   {{0x33ce002e,0x0c6103d5,0xf1fd031a,0x921200cd}},	//   _kakvu_, _churned_, _fadalach_, _amihs_, 
   {{0xe395020e,0xe4770074,0x338d0094,0x22fe02be}},	//   _thuso_, _проекте_, _اشسام_, _matigas_, 
   {{0xa85d0223,0x826d010d,0xe20201b5,0x7213005a}},	//   _голланды, _jatoh_, _kuriku_, _muchbe_, 
   {{0xf39604ea,0x9b580320,0xd50402c1,0xbe6d0188}},	//   _yousuf_, _anguriwa_, _abamugay, _ниёзманд_, 
   {{0x737b026c,0x3e98008f,0x32d700b4,0x42300322}},	//   _romanum_, _खोजताने_, _biserici_, _azamara_, 
   {{0x557f013f,0x53c100d1,0xb2fe008d,0x32fd0250}},	//   _kumuniez, _কবিতাবোৰ, _mitalari_, _bregun_, 
   {{0x1e9202f5,0x85050074,0xbcd700bb,0x69e0025f}},	//   _líderes_, _отказать, _کھڑکیوں_, _kokomama_, 
   {{0xda580212,0x22ce02d0,0x53b30071,0xd20f00fb}},	//   _scientia_, _alloued_, _مصادیق_, _baphakam, 
   {{0xc4df0092,0xdac70045,0xa636004d,0x92200527}},	//   _改善要望の掲示板_, _fašiste_, _保健營養食品館_, _tenkovim, 
   {{0x026d021c,0xb7b302d8,0xfdce03d5,0x02e603d4}},	//   _batoh_, _kelembag, _anchovee_, _smenama_, 
   {{0xbed60386,0x620002cb,0x93f903db,0x6f8e00ca}},	//   _melindun, _kolica_, _bazuze_, _apuprètz_, 
   {{0x73df03a4,0x43fd0192,0x7387021e,0xa9df038e}},	//   _týdning_, _hypothek, _lagras_, _चक्रीवाद, 
   {{0x2f830683,0x2c18014a,0x6c7c00df,0x925f04cf}},	// [1e60] _redigér_, _bográcso, _caisson_, _nelungel, 
   {{0x3ccd01a7,0xa5c0036d,0x83f801df,0x58e704ca}},	//   _последне, _ionadail_, _staun_, _dérapage, 
   {{0xeb96006a,0x6c1d00d9,0x76f402e0,0x39bf0331}},	//   _anananao_, _hampaat_, _meratshw, _hæddina_, 
   {{0xd25f03db,0x44c000d1,0x42fe00a0,0x90110184}},	//   _belungel, _উত্তৰপাৰ, _fitilar_, _kwivayan, 
   {{0xf33d01e0,0xc63a01b8,0xdf6a0187,0x00000000}},	//   _میزاد_, _printsii, _симпсоно, --, 
   {{0x8e1800e7,0x2e7c02d8,0x432f01b6,0x3ab2000c}},	//   _aguedpla, _फुल्ल_, _בויקיפדי, _рфолькло, 
   {{0x6387035a,0x157f013f,0xb7d300d7,0xf9dc0127}},	//   _starla_, _gumuniez, _фурсенко_, _adreizhe, 
   {{0x982c038f,0x22020390,0x0ea400a3,0xe28800d3}},	//   _སྦྱིས_, _imtina_, _vestlege_, _krystaly_, 
   {{0x63f900ac,0xb2900264,0x1c7101ab,0xe06d01b7}},	//   _jabuke_, _aimag_, _पूछ्कर_, _बन्धुभिः_, 
   {{0x62e20013,0xb2c501cd,0x6da90091,0x9248028a}},	//   _وطالب_, _ingelosi_, _takulugu_, _ngome_, 
   {{0x706d0594,0x937a0057,0x2294004a,0x5465014f}},	//   _kompetan, _lepasan_, _avgustın, _односима_, 
   {{0x569800bf,0x0ebd005c,0xbd150130,0xe0930061}},	//   _продвину, _yibukije_, _berradur, _논술지도교사_, 
   {{0x0cd80244,0x624801f0,0xd05700bd,0x28c30326}},	//   _разнообр, _kgome_, _rooshian, _hakungav, 
   {{0xe43300d1,0x7d0600c5,0xf37a009f,0x00000000}},	//   _থেচিচ_, _cycliste_, _navaden_, --, 
   {{0x429001b9,0x6285012c,0xb303023c,0xfacb005b}},	//   _domaz_, _mathayo_, _دليکنو_, _dommeren_, 
   {{0xb2d8000b,0x4cd3014f,0xe3f9042a,0xf27f0059}},	//   _pulea_, _помоћу_, _babuke_, _prendi_, 
   {{0xef270684,0xd3170140,0xe9c70128,0xa27f00f4}},	// [1e70] _orrespon, _mamatay_, _харажат_, _brenux_, 
   {{0x7ea4048b,0x12d80430,0xd4d1008f,0x2f3c02ac}},	//   _giftcode_, _vulea_, _भूमिजा_, _لتحفيظ_, 
   {{0x13ff0125,0xd83a018d,0x5f5c0132,0xb2a603cc}},	//   _ядамады_, _ክንዕቅቦ_, _balatonn, _aprobó_, 
   {{0xe3170433,0x764900ef,0x7387007b,0xcef9013b}},	//   _namatay_, _نتيجې_, _hearin_, _maswerte_, 
   {{0x0ce202fe,0x7a90002b,0xb38601a6,0x4e4d0041}},	//   _کیمیاوي_, _বায়তুল_, _maero_, _mymbápe_, 
   {{0x5edc00a7,0x37c70115,0x00000000,0x00000000}},	//   _botigues_, _nirrahim_, --, --, 
   {{0x945d0076,0xa202021d,0x22020009,0x51e900cb}},	//   _alteraçã, _skridt_, _skrite_, _бадоҳата, 
   {{0xfb620404,0x07c900c5,0x5cb501b8,0xe2e2000d}},	//   _leotwana_, _销售的专业化公司_, _उदारचरित_, _tekivad_, 
   {{0x183c017d,0x429004b3,0x24570299,0xd77302eb}},	//   _産学官連携リンク, _tomaz_, _ئابروي_, _доллор_, 
   {{0x62fe037f,0x813503ee,0x1a12037c,0x63860212}},	//   _intihar_, _prodaval, _discussa_, _haero_, 
   {{0xfc0e031f,0xca2b0273,0x2b6a0499,0x4f160226}},	//   _ventelis, _alegría_, _faitalia_, _asadayan, 
   {{0xe3bf00bc,0x9378013c,0x6c0300bd,0x32900230}},	//   _arcveiw_, _allahin_, _cursour_, _somaz_, 
   {{0x6a1402ee,0xeed603b5,0x426400a5,0x1a700268}},	//   _benefiċċ, _pelindun, _itulau_, _amplings, 
   {{0xaa8000ca,0x037c0118,0xc6a2027f,0x7312021c}},	//   _atencion_, _kitaawe_, _atatekey, _tábora_, 
   {{0xe65903db,0xc6010320,0x0bef004d,0xc3fa01e5}},	//   _abayitsh, _diklarex, _九評共產黨_, _laruge_, 
   {{0xf2580256,0xf3190321,0x925700c1,0x13f1004d}},	//   _publiski_, _seminarj, _आकुंचन_, _請選擇貼紙尺寸_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [1e80] --, --, --, --, 
   {{0xf2d801f6,0xe278009d,0x42e80084,0x00000000}},	//   _gulen_, _fisnik_, _bedilna_, --, 
   {{0x82130203,0x22ca0305,0xed900016,0xdb770088}},	//   _archit_, _fridom_, _alilanda, _аркасын_, 
   {{0xbc03037e,0xc4850096,0x158503ef,0x00000000}},	//   _lympung_, _ageragej, _ageragez, --, 
   {{0xbf2a0372,0xf3030037,0x4797034c,0xa3cf0198}},	//   _dystiola, _melawat_, _алманияг, _nisva_, 
   {{0x697a01cc,0x1c0d022d,0x66440297,0x67460092}},	//   _विस्तरेण_, _campane_, _пхеньянн, _無修正動画_, 
   {{0x330402b1,0x928c01fc,0x2ffa02da,0xe2250067}},	//   _suratul_, _maakina_, _сварете_, _dhakka_, 
   {{0x6c7c0047,0xe27d047d,0x32f9012e,0x5c7e0344}},	//   _贴子相关图片_, _versamml, _hetilap_, _amerlup_, 
   {{0x1d8602d5,0x8d1703be,0x979103b6,0xf01a0097}},	//   _प्रोटोका, _imishwar, _olutọju_, _pẹlupẹlu_, 
   {{0x7afa02d5,0x347302d8,0x13ea03dd,0xcc0f0194}},	//   _tingimus, _penembak, _lehta_, _plutonis, 
   {{0x50e6027b,0x336c0479,0x1afa0211,0x098000d3}},	//   _किरीटी_, _dögös_, _файлообм, _špindler, 
   {{0x727e00dd,0x7bea0177,0x0fc502aa,0x6ba20139}},	//   _alinio_, _рыцҵараз, _celistvo, _dukkhudr, 
   {{0x1a3903f4,0xf2ef04a7,0x79f6008a,0x7e600297}},	//   _девайс_, _adafad_, _talutalu, _интеккән_, 
   {{0x3a8903e3,0x4337017a,0x21fd01ac,0x00000000}},	//   _solisyon_, _диловар_, _radacach_, --, 
   {{0x135601d1,0x730200f3,0x0200041e,0xc106027b}},	//   _depends_, _ixubene_, _aldila_, _कृतशः_, 
   {{0xd679008a,0x32c30043,0x39040013,0xc2a6038e}},	//   _bankstow, _atulaba_, _dekabrid, _ghibah_, 
   {{0x3f6a00ea,0x2291006c,0x72c80125,0x23f800fe}},	// [1e90] _ohabolan, _amaconsi_, _begjanow_, _pelula_, 
   {{0x53d101a3,0xd28e01dd,0x2fc200ef,0x6b8703a0}},	//   _اَمان_, _agakono_, _قانوي_, _dilither, 
   {{0x6e6c008d,0xabd20061,0x38c9004f,0x9aa40156}},	//   _ایرور_, _가능하다는_, _guënë_, _כּפֿר_, 
   {{0xdf5d0140,0x93a1005e,0xbe1503b8,0x00000000}},	//   _kasamaan, _ﻧﯩﺴﺒﯩﺘﻰ_, _атаңнан_, --, 
   {{0xc2000499,0x4eac0008,0x9776002b,0x395e0462}},	//   _moliga_, _албастык_, _নিভৃতে_, _artoonst, 
   {{0xcb67053f,0xc5b202b2,0xc7430038,0x8dc50685}},	//   _amulatar, _якими_, _русск_, _opskrift_, 
   {{0xd3f80033,0x79cb0004,0x73eb032e,0xd67f033e}},	//   _staus_, _entelekt, _khatat_, _anhelati, 
   {{0x637b0261,0x49d00211,0x6aeb0148,0xb34200c1}},	//   _israelo_, _tekemist, _中國民用機場協會, _goresan_, 
   {{0xf5f301db,0x33010128,0x3a7d01af,0x58c001d1}},	//   _доценті_, _qavatli_, _bahalara_, _extended, 
   {{0x5aa401db,0xae5700de,0x7ab50205,0x85a20012}},	//   _ءبىرتۇتا, _دريشي_, _beshyuzb, _जीअता_, 
   {{0xdd180343,0x22da03d4,0x0878026c,0xe3f80079}},	//   _glasswar, _poseti_, _militibu, _draud_, 
   {{0xd2d4029e,0xd2250082,0xf9bd005b,0x22c60357}},	//   _brudet_, _shakka_, _bandcamp_, _meteresi_, 
   {{0x02d80130,0xa2e802c6,0x7207048a,0xcab00206}},	//   _erlec_, _delienn_, _شىرقىمدى_, _tradičný_, 
   {{0xf3be0073,0x72a60274,0x1eb902ea,0xc2ca037f}},	//   _proveni_, _labba_, _послание_, _analoji_, 
   {{0xb39102b6,0xaa61004d,0x494d0066,0x7a0902ce}},	//   _импортта, _千萬人民幣_, _eskolare, _babakuna_, 
   {{0xc2d80300,0x9c7f00f0,0x00000000,0x00000000}},	//   _hokeji_, _kreslil_, --, --, 
   {{0x0c660056,0x12530220,0xc9b1025b,0xb8950053}},	// [1ea0] _сентябри_, _orientam, _fiskidøg, _शरीरशास्, 
   {{0xc2a600b2,0xaf64031a,0xf2f302ec,0x24a4010d}},	//   _aabba_, _breatuin, _arrintu_, _अर्थपूर्, 
   {{0x23030304,0x12000259,0x034c0013,0x32da00fe}},	//   _pelawat_, _boliga_, _istemol_, _haueee_, 
   {{0x52a6001b,0x3fc901e1,0xf9e40328,0x2eb2024a}},	//   _jabba_, _белгес_, _atangura_, _kerosinn, 
   {{0xbb5a0238,0xd5c70024,0x0fc60217,0xf2a602b1}},	//   _проектув, _হামৰেণ_, _delictuo, _dabba_, 
   {{0x02ff03c6,0xfb5600ae,0x00000000,0x00000000}},	//   _feroverj, _rwamator, --, --, 
   {{0xcc9a0211,0x6bf60142,0x55ab0059,0x411c0242}},	//   _аварии_, _atatsvab, _гърдата_, _alışı_, 
   {{0xfe050041,0x63fa0362,0x02120182,0x92fd0257}},	//   _ихаҧшьга, _bopusi_, _olaha_, _dregin_, 
   {{0x214800f4,0x22da0085,0xe90c042f,0x362f0356}},	//   _testenno, _boseri_, _tamainnu, _sorianox, 
   {{0x9ee90226,0xe2c80342,0x83fa05d5,0xe39402e0}},	//   _akukulan, _anboche_, _letura_, _ijesa_, 
   {{0x427e002c,0x24930334,0xbb6202f3,0x32c80147}},	//   _izena_, _akazinso_, _korrekta_, _بەيكۉنۅۅ_, 
   {{0xf19101f1,0x6b7201dd,0x526d0256,0x00000000}},	//   _hardkorë_, _abashora_, _latos_, --, 
   {{0xef4500d1,0xd88b00a2,0x520001fe,0x00000000}},	//   _কিডনীৰ_, _kuchambu, _voliga_, --, 
   {{0x51030169,0xdb20003e,0xee3902e1,0x97d50065}},	//   _ষড়যন্ত্র, _пхана_, _abhantra, _doppelzi, 
   {{0xed3d01b2,0x23b50320,0x626e0190,0xef600040}},	//   _assignee_, _alovola_, _patiriri_, _nowadays_, 
   {{0xa0590686,0xa4d40142,0x430002dd,0x720000db}},	//   _okuseman, _उत्तरपश्, _bagalji_, _kolida_, 
   {{0x2ea10180,0xb6ae0397,0x23130320,0xd3c80333}},	// [1eb0] _akseptab_, _abadakiw, _cincela_, _fauves_, 
   {{0xfd0e00ca,0xd25b0386,0xa3dd0372,0xe0dd00de}},	//   _gentilic, _reflek_, _huawdl_, _ریفري_, 
   {{0xc3160200,0x437803c7,0x529e017a,0x595c0216}},	//   _ahazi_, _podania_, _милат_, _madorobe, 
   {{0x94fb0157,0x29980653,0xfeef0037,0x6f2c0009}},	//   _क्वारी_, _ploše_, _ተችሎዋል_, _najemnin, 
   {{0x74bf0522,0xbe5d017d,0xf26d01da,0xf5a20212}},	//   _अवहेलना_, _セキュリティ_, _fatos_, _filiorum_, 
   {{0x7c0e03d9,0x404300b7,0xac470039,0x420001b5}},	//   _jentilis, _bilinmez_, _тарган_, _enliwa_, 
   {{0x93ea0277,0x22ec0173,0x16680061,0x05ec0030}},	//   _duktor_, _obtiene_, _이야기하고_, _pensijā_, 
   {{0x8202033d,0x7c5500cc,0x81590418,0xffe60022}},	//   _dirije_, _bistand_, _bursaspo, _табыуға_, 
   {{0xefc9001d,0x5296005e,0xc2000362,0xe3400461}},	//   _inrichar_, _ظعككع_, _kodima_, _argeria_, 
   {{0xa3160328,0xf40a006d,0x4290030f,0xfd120237}},	//   _ikizi_, _абцяжарв, _moeau_, _보고서에서_, 
   {{0x6fda00ee,0x226e0304,0x332202ac,0xb29202e2}},	//   _positibo, _sotong_, _glactar_, _assail_, 
   {{0x7a1200ff,0x32fc0269,0x43870181,0xeb08004d}},	//   _אקסלען_, _caminos_, _aguri_, _僅能於到期日行使, 
   {{0x9e38043d,0xfd3700c2,0x626d02eb,0x00000000}},	//   _peralata, _yifitiye_, _nator_, --, 
   {{0x721203fb,0x5f4405d2,0x7d780148,0x00000000}},	//   _vlaha_, _rikshosp, _promisit_, --, 
   {{0x13a200ca,0x97af018b,0x93e20288,0xfa8f0116}},	//   _compta_, _апаратул, _bairatsi_, _crunchin_, 
   {{0xaacb044c,0x7cc80255,0x77740163,0xbdab0253}},	//   _sommaren_, _कर्पूरी_, _پروزیراع, _misilera, 
   {{0x300702d6,0x23fa03dd,0x038f02ba,0x2cf5020f}},	// [1ec0] _парижда_, _vetura_, _aliyona_, _وریښمو_, 
   {{0x63940377,0xef570340,0x3d190479,0xe5b50366}},	//   _exista_, _takawaen, _gipszkar, _дуккха_, 
   {{0xd2a7025c,0x846b0234,0x899b01ab,0x00000000}},	//   _farbe_, _imuṣiṣẹp, _seljakot, --, 
   {{0x83e101ce,0x539401f1,0x2bf4021a,0xb41703f3}},	//   _عضلات_, _pjesa_, _murteess, _pensioen_, 
   {{0x206103e8,0x9200046d,0x72020541,0x529001ed}},	//   _enostavn, _miliwa_, _sirije_, _noeau_, 
   {{0xf2a70082,0x787d03b5,0xe1da032d,0x25450110}},	//   _harbe_, _tercemar_, _митингыл, _krištopa, 
   {{0x143a02af,0xc31000f4,0x22a700a0,0x7a5d0035}},	//   _agakorok, _aluzen_, _karbe_, _башларга_, 
   {{0x429001d2,0x3a340024,0x2c57041c,0x7e830019}},	//   _anman_, _জানিবৰ_, _bétani_, _تاڭشى_, 
   {{0x7c360478,0x3af201e9,0x1433018e,0x1a130303}},	//   _circonsc, _akaredit, _etikerek, _difatlhe, 
   {{0xc26d045f,0xe618028e,0x820001ad,0xf2d90529}},	//   _dator_, _acceptim_, _colima_, _vojnike_, 
   {{0x82ee036f,0x63160069,0xc20203eb,0x1ff80040}},	//   _stanovi_, _akaza_, _visier_, _התערובת_, 
   {{0x03870687,0x9c0d0292,0xc9d9021b,0xfc550385}},	//   _ararya_, _wampene_, _tunnista_, _smetnje_, 
   {{0xdb0c013d,0x2a1d0338,0x830303db,0x1b9203e2}},	//   _אלימלך_, _cambiame, _labantu_, _remitido_, 
   {{0xe0dd018e,0x82000240,0x59c701db,0xbaac01aa}},	//   _etindlel, _liliwa_, _таратылғ, _ansheesb, 
   {{0xdab90061,0xf5d30241,0x439d0405,0xd2d8027f}},	//   _다우메디텍_, _armaatiy, _гарантія_, _inkezi_, 
   {{0xc89c015e,0x22490108,0x9a060198,0x4dd80378}},	//   _ازايات_, _agamis_, _terapevt, _bankarna, 
   {{0xce2401d5,0x129401f1,0xa2e904fe,0x1e9c00c7}},	// [1ed0] _بریگیڈ_, _shikoni_, _impiega_, _польшаны, 
   {{0x02c00040,0x36770029,0x8c760064,0xbed10041}},	//   _nucleic_, _رچوارپار, _جاپپاسا_, _нанҳәа_, 
   {{0x1844021e,0x72fe0145,0x82e80048,0x00000000}},	//   _reagerar_, _katinas_, _bazimba_, --, 
   {{0xd38f0414,0x8387042d,0xba050178,0x419b011a}},	//   _balyaka_, _afaran_, _dayanvit, _לפענח_, 
   {{0xa321034c,0xdf59013a,0x831b003f,0xc2e800ea}},	//   _alayda_, _gespaart_, _danchoh_, _vazimba_, 
   {{0x23210073,0x779302d2,0x62480122,0xd27f000d}},	//   _cliccar_, _курбонов_, _agomo_, _trenni_, 
   {{0x049d004c,0x283b01a6,0x43860084,0x00000000}},	//   _amwambaz, _pepamārō_, _daera_, --, 
   {{0x62d80430,0xec5b00e3,0x8f590265,0xc81f00e6}},	//   _kulea_, _brutali_, _bespaart_, _造成损失的_, 
   {{0x42020437,0x353a0013,0x3316006a,0xb07100ac}},	//   _skrive_, _frantsiy, _ahazo_, _dinarsko, 
   {{0xa2b30245,0x6200008a,0xa2480103,0x00000000}},	//   _buddien_, _kiliva_, _egomo_, --, 
   {{0x1fde01d5,0xe3e102cb,0x9cd60094,0x72c900ae}},	//   _کمنٹس_, _postupci_, _تاريحىن_, _boroshe_, 
   {{0xe5550125,0x490d04ca,0x00000000,0x00000000}},	//   _мурдар_, _absorbís_, --, --, 
   {{0xf2b30191,0x05c0007f,0x00000000,0x00000000}},	//   _studera_, _cofadail_, --, --, 
   {{0x22c2006f,0xf2900028,0x02cb0036,0x24d300ff}},	//   _usalama_, _niman_, _gradam_, _אטראקציע_, 
   {{0xcd9d006c,0xa63c0019,0x9af400ef,0x28b6039e}},	//   _abalupha, _египетке_, _aneeklas, _austover_, 
   {{0xbc0f0200,0x5b9a01ce,0x9d13020d,0xcd660035}},	//   _agamnihu_, _سفارشی_, _bukomeye_, _крутяк_, 
   {{0x6c67000e,0xec9d0061,0xc3950394,0x83b00163}},	// [1ee0] _ametter_, _컴퓨터에서_, _akuso_, _المائدہ_, 
   {{0xacbd00ff,0x59f70360,0x2481003a,0x5c6b01c1}},	//   _ליביע_, _zadavate, _усулда_, _tubuhmu_, 
   {{0x429100d6,0x1b840369,0xe21e01e5,0x00000000}},	//   _fouad_, _henoheno_, _lóhun_, --, 
   {{0x982c02dd,0x381d0148,0x22d40453,0xe1fd0195}},	//   _འདྲིལ_, _得阿耨多羅三藐三, _okolinu_, _dadamach_, 
   {{0x2290030c,0xf35f01aa,0x4c600195,0xf2d80429}},	//   _inmat_, _aigepay_, _giorrad_, _kuden_, 
   {{0xe2d8005b,0xd2fe0427,0xa7130047,0x429000ee}},	//   _juden_, _maligaq_, _consulté, _unean_, 
   {{0x229002a9,0x8941012a,0xe3f80290,0x9a7e0021}},	//   _šiame_, _plbloadt, _criua_, _edroomsb, 
   {{0x43f102c3,0x49c70034,0xe31002ff,0x24280188}},	//   _poštovné, _samvisku, _bouzen_, _таракиёт, 
   {{0x63030307,0x56b7012c,0x462e022a,0x3c0701da}},	//   _zabantu_, _yanapati, _stralanä, _taksist_, 
   {{0x2eac0059,0xfb76015e,0x3d1c01af,0xad0d003c}},	//   _sostiene_, _ырахат_, _başlanso, _biyungir, 
   {{0x1202007b,0x16d900c4,0x72550688,0x6c5a000b}},	//   _thrice_, _ڪينسر_, _कमसेकम_, _laititi_, 
   {{0x8b1a0057,0xc2d800af,0xa4da00be,0xc11400bb}},	//   _በመጪዎቹ_, _huden_, _биргелик, _پيشرﻓﺘﻪ_, 
   {{0x09fa0663,0x727f014c,0x325b03db,0xf7e203ec}},	//   _mbrantse, _asenzi_, _azalwe_, _propozim_, 
   {{0x9d130285,0x9202013e,0x220000f2,0x9b600263}},	//   _rukomeye_, _kotira_, _polija_, _ongedaan_, 
   {{0xa39402e8,0x368e03a0,0x91af0092,0xf60c0037}},	//   _ajesu_, _bonesedi, _最高の人生の見つ, _እንቁጣጣሽ_, 
   {{0x72db0044,0x13ac0041,0x75bf02e2,0xd21e01e5}},	//   _הלהקה_, _арццакра_, _archaism_, _kóhun_, 
   {{0x134a018e,0x59210102,0xd7d9009c,0xc9fe0016}},	// [1ef0] _esydney_, _alichagu, _chirimaw, _batalant, 
   {{0x07bb0114,0xe28701e6,0xbaed0315,0xb2900028}},	//   _לפועל_, _bylinky_, _balulnge, _calankii_, 
   {{0x52000007,0x77c400c5,0xb9fc00c8,0xea380092}},	//   _lilita_, _大兴区教师进修学, _машинаһы_, _この版への固定リ, 
   {{0xf39402b2,0x33f00281,0x1dc40204,0x00000000}},	//   _gjest_, _illuanni_, _hygienia, --, 
   {{0x965e03d4,0x9c0d0024,0x5da60163,0xfa390213}},	//   _фирме_, _kampane_, _ناراضگی_, _ведении_, 
   {{0x0147032d,0x63f40151,0xf200033f,0x00000000}},	//   _фатима_, _burtit_, _tiliva_, --, 
   {{0xf2d8000c,0x65390135,0x8eed00d9,0x89e601e9}},	//   _judeo_, _gimnaziy, _valvonta, _gololola_, 
   {{0x429000b0,0xda5c013b,0x3438036a,0x235601ba}},	//   _siman_, _meißen_, _isakisak, _lisenns_, 
   {{0x3290011e,0x14370361,0xec68005b,0xa9ed0178}},	//   _dimal_, _включают_, _kikuchi_, _apanīya_, 
   {{0x0a4e05c7,0xc37f03cf,0x596e01d2,0xa329065b}},	//   _kohereza_, _malatya_, _aspimant, _शेखपुरा_, 
   {{0xa27f013d,0x832c0040,0xaf1b00e6,0x4781004d}},	//   _flanko_, _ולבדוק_, _高级经济师_, _一個像偶像劇的夢_, 
   {{0x48dc0141,0x72d800a5,0x68370192,0x22500420}},	//   _истайсиз, _tulei_, _되겠습니다_, _мерак_, 
   {{0x929000f1,0xc12e00be,0xd43e01f4,0xb2d801b9}},	//   _anmas_, _اسلدىعى_, _оавни_, _kulev_, 
   {{0x57890076,0x62000183,0x43940455,0x53a303d5}},	//   _месото_, _solika_, _brosse_, _bedstraw_, 
   {{0x226c0277,0xce5f0092,0xa29001fc,0xfacb0276}},	//   _bahoin_, _ご当地グルメ_, _kimal_, _усуллири, 
   {{0xe2e101a3,0x93be0014,0xc30c0265,0x0f4901c4}},	//   _بگاڙيو_, _provoni_, _elkaars_, _lessenaa, 
   {{0x52900092,0x3b5b0359,0xfcfa0094,0xfcbf00d1}},	// [1f00] _simao_, _beferzen_, _تۇراعىڭد, _আমন্ত্ৰি, 
   {{0xa514017a,0x43860079,0xc502008f,0x98680076}},	//   _abashiwo_, _ezers_, _परितिष्ठ, _градовит, 
   {{0xdeaf01fc,0x524a01c2,0x2b0900e6,0x985101c2}},	//   _curriyat_, _durmir_, _竞猜场次的通知_, _enquisas_, 
   {{0x72d80258,0x8316013d,0x22920230,0x6fb5028b}},	//   _suden_, _okaze_, _lasanm_, _gríngo_, 
   {{0xf0750030,0x468c0689,0xc50800c7,0xc98d00ff}},	//   _materiāl, _बोलाव_, _başınnan_, _ביאלא_, 
   {{0xefa201a3,0x0e3c00d1,0xdd9901f4,0xc969030a}},	//   _جهڪيل_, _নাইটছ_, _muhlisla, _asoparar_, 
   {{0x469f012a,0x44f800e6,0x7aa50096,0x00000000}},	//   _pneumaty, _第六十二条_, _atsindis, --, 
   {{0x3c0b00fb,0x010902e4,0xc29000bb,0x77b30457}},	//   _abelungu_, _amikevol, _kalauz_, _masruufi, 
   {{0x805000bf,0x2b530075,0x3f69028b,0x5abe00cf}},	//   _оформляю, _heimsbar, _isoberan, _hankaaks, 
   {{0x8b5a00f5,0x33ea01d3,0x22320009,0x5e48028a}},	//   _башланян, _luktar_, _prevajal, _kukaraba, 
   {{0x161a042f,0xc2a700eb,0x52000090,0xc687068a}},	//   _toyotigi, _yarba_, _andipa_, _gradjani, 
   {{0xfe6c0416,0x13210241,0x015c01cd,0x0c000148}},	//   _concerne_, _alayka_, _дусад_, _tristis_, 
   {{0xcbf2046d,0x2b070040,0x727f01c7,0xb8d80178}},	//   _khathuts, _מתקשר_, _ozune_, _aprakṛti, 
   {{0xe96b011d,0x231600c2,0x6b5600b4,0x6c8300fa}},	//   _dimineat, _ikaze_, _instanta_, _ikatlong_, 
   {{0x390901cb,0x038301cc,0x2258007b,0xf3eb02db}},	//   _bazakubu, _manyate_, _boothill, _taetel_, 
   {{0x927a0056,0x479f0311,0x4fd90037,0x325a0452}},	//   _daniyeli_, _ብትግርኛን_, _እናከብራለን_, _pailit_, 
   {{0xcf570536,0x5c0f0265,0x205d01a6,0x52fe02f4}},	// [1f10] _baýram_, _maaltijd_, _matapopo, _matizar_, 
   {{0x63560132,0x825a02ef,0x32d800cd,0x00000000}},	//   _مرحلہ_, _abilte_, _audel_, --, 
   {{0x5294004c,0xed850073,0xb9960115,0x8985021c}},	//   _akabanzi_, _fenestre_, _anakanda_, _tenistka_, 
   {{0x520201fc,0xc5c60366,0x504000ba,0x72da025d}},	//   _akriye_, _вручную_, _بیتوێن_, _sauene_, 
   {{0x453000d1,0x08b60217,0x4edc015e,0x7d4702ac}},	//   _স্নানাগা, _destruer_, _antigues_, _عارضات_, 
   {{0x344c0035,0xe3860405,0xfa1a01ef,0xb23601be}},	//   _элтон_, _nyere_, _раздробл, _projev_, 
   {{0x5e5a0011,0xea2f01c9,0x56890039,0xcdf80041}},	//   _ababataa, _उन्हनीं_, _тормосны_, _рҳьақьым, 
   {{0xce4803ef,0x5b1f0057,0xf9610192,0xf80c00d1}},	//   _rukaraba, _penangan_, _woonoppe, _চিকৰপতি_, 
   {{0x23ea0120,0xab470056,0x1e7104ae,0x00250156}},	//   _abittu_, _гандум_, _rečnik_, _קאָסמעטי, 
   {{0xb6ba00c4,0xffd402c8,0x364b018d,0x117b008a}},	//   _ريسٽورنٽ_, _vacación, _ንደለይቲ_, _simanual, 
   {{0xc2d80107,0x6c6901cd,0x8c02018c,0x27720365}},	//   _audee_, _барчидан, _vissers_, _हरिसिद्ध, 
   {{0x4e550285,0x827e01d9,0xd2d8004f,0x57200128}},	//   _bagamije_, _grenz_, _budee_, _японияни, 
   {{0x127e0286,0xc3950195,0x00000000,0x00000000}},	//   _aseni_, _chasan_, --, --, 
   {{0x456c0075,0xb2ef0011,0x425a0318,0x520101eb}},	//   _heimalið, _alafat_, _mailee_, _iraiti_, 
   {{0xb2d50410,0xa20000db,0x83f8013b,0xf27f0178}},	//   _tlhotlo_, _kriisi_, _traun_, _ananto_, 
   {{0x83fd01a4,0x255c03e9,0xef670137,0xe31000f6}},	//   _balukaki_, _paýdarla, _батгыг_, _fouzan_, 
   {{0x73fa0243,0x3e3700a7,0xf379042c,0xe9840224}},	// [1f20] _barule_, _finalita, _dolazio_, _hamingja_, 
   {{0x286c014f,0xaded045b,0x03f90033,0x4eb30445}},	//   _павловић_, _позичаль, _arcuns_, _baseados_, 
   {{0x232101fb,0xf394005b,0x8243031e,0x3be603e6}},	//   _placias_, _akisan_, _rahmetli_, _dageshor, 
   {{0x054a03a3,0x93fa0240,0x836603c6,0x6ad70255}},	//   _prevençã, _narube_, _deugden_, _tuttavat, 
   {{0xcc1c0518,0xe87501cb,0x00000000,0x00000000}},	//   _organlar, _neenkulu, --, --, 
   {{0x6c77012a,0x00000000,0x00000000,0x00000000}},	//   _potrafi_, --, --, --, 
   {{0x8200009f,0x6c35043e,0x3387007b,0x124a0229}},	//   _hodila_, _valcárce, _haurd_, _durmur_, 
   {{0xf8c20225,0x92a70082,0x573c01cd,0x029101e5}},	//   _liederbu, _harbo_, _найранги_, _nouah_, 
   {{0x972302e5,0x17c20132,0x12bd0139,0xfbed039e}},	//   _expresió, _کمپوزنگ_, _bandham_, _bladstyr, 
   {{0x587603cf,0x63870119,0xd20201fe,0xc45f0159}},	//   _olabilir_, _ngaran_, _kotiva_, _buteliuk, 
   {{0x52a7022f,0xf8a10409,0x75fc0156,0x42fc0241}},	//   _darbo_, _お気に入り_, _פּרנסות_, _fiqiruu_, 
   {{0x418f00d1,0x4bfe0410,0x0a10048f,0x00000000}},	//   _শোচনীয়_, _latolago_, _bombanda_, --, 
   {{0x7c7c03b9,0xbe770455,0x7876055f,0xf1840289}},	//   _apasina_, _demandé_, _alabilir_, _chiphoko, 
   {{0x87290246,0x98c7017d,0x571f000c,0x825b01fc}},	//   _добре_, _知恵袋に投稿され, _дбари_, _maalut_, 
   {{0x094e02dc,0x52120028,0x6f2d0028,0xe9750272}},	//   _escolare, _llahi_, _tartanka, _azinsome, 
   {{0x427e042d,0x770f068b,0x2200003e,0x339401da}},	//   _dreny_, _kommunev, _bodila_, _gjesh_, 
   {{0xf28c04f2,0x32a70119,0xde2403b8,0xb06e0279}},	// [1f30] _tinhyeu_, _barbo_, _альянсы_, _comprenn, 
   {{0x338603ef,0x7063009a,0x26b7042a,0x9ebb018d}},	//   _nzeri_, _abaselun, _bangaphi, _መለሰለይ_, 
   {{0xa21202fb,0x77eb025b,0x12d802ee,0x0387001e}},	//   _alahi_, _samanlag, _mulej_, _daure_, 
   {{0x125a0245,0xa26400a5,0x73f803b0,0x938700fa}},	//   _bailut_, _atulou_, _draum_, _agaran_, 
   {{0xd8ce0092,0x3654012a,0x35ce01de,0x588b0226}},	//   _ハンドメイド_, _granatow, _шалма_, _kuchimbu, 
   {{0x82a70120,0x02000043,0x8b9b0007,0x517d00ff}},	//   _garbo_, _endiga_, _babikolo_, _דינוב_, 
   {{0xcb0a02fd,0x6a340206,0x032201e8,0xf2bb0185}},	//   _barscune, _dizajnér, _ituyok_, _cimeşe_, 
   {{0xd61f0091,0x15850148,0x17820013,0x4387016b}},	//   _piinnari, _精彩內容推薦_, _акага_, _haure_, 
   {{0x0e1c0067,0x5502015c,0x86cf0281,0x0b4d01a4}},	//   _aangoosa, _allefall_, _ethanoli, _bakwanga_, 
   {{0x5aea03f7,0xa5bf0322,0x00000000,0x00000000}},	//   _austurle, _bararyoh, --, --, 
   {{0x0a7501b6,0x17ca0206,0x730301cc,0xadab0264}},	//   _حبيبة_, _spusteni, _carantu_, _masigura, 
   {{0x431e0307,0xf2e702a0,0x36b700b4,0x3c710287}},	//   _namhlanj, _adunola_, _sanatati, _पुच्छर_, 
   {{0xce010369,0xa2ca0107,0xf994020e,0x25fd0276}},	//   _aldebara, _bunder_, _brokrest, _соливәтт, 
   {{0x701b01f4,0xec13005b,0xaebe035d,0x129001e5}},	//   _محرومیتل, _hverdags, _sagovorn, _mimaa_, 
   {{0x623f034f,0x8ae4002b,0xbbd80185,0x4a2c0037}},	//   _دجګړې_, _কোলাহল_, _агрегатл, _በመምሪያው_, 
   {{0xb38600f4,0x02ca0421,0x73050125,0xc9680065}},	//   _agereg_, _wunder_, _aklamak_, _ansichte, 
   {{0x9d9a0164,0x685700b4,0xe3800277,0x8dab01ad}},	// [1f40] _پاراڭلىش, _фражиле_, _istrok_, _kasigura, 
   {{0xce3700ad,0x52900225,0x72bb0279,0x00000000}},	//   _manggiha, _kamawi_, _galette_, --, 
   {{0x4c130583,0x234401f4,0xc40d02af,0x2316005c}},	//   _skupini_, _قبرستاند, _bobigenz, _akizi_, 
   {{0x42d9014e,0x6290029b,0x9fea0157,0x60fb00d9}},	//   _ocenite_, _bimaa_, _विषाक्त_, _участием_, 
   {{0x51c9006c,0x430501af,0x6d1c03a4,0x22fe0420}},	//   _сойти_, _aklajak_, _børsskrá, _obtidas_, 
   {{0x718902ec,0x02d801ed,0x73f80166,0x8040005e}},	//   _jawaabay_, _iudea_, _traum_, _ﻣﯘﻻﺯﯨﻤﻪﺕ_, 
   {{0x86280225,0x3c5a022d,0xf9d90220,0x5ef80287}},	//   _jubilati, _abitati_, _inserime, _अर्गनाइज, 
   {{0x831d02d3,0x93f80145,0xa9d8009b,0x79f40211}},	//   _torcida_, _nemuno_, _манзушир, _selän_, 
   {{0x02e9021b,0x8213003f,0x108d017a,0xfec300a8}},	//   _parissa_, _jichus_, _сиеси_, _ambizius_, 
   {{0x288a0309,0x2c800060,0xd1c60120,0x81b00342}},	//   _tamamilə_, _белең_, _ossotinâ_, _konmansm, 
   {{0xfd9d02af,0xef290047,0x32d80369,0xda8d0184}},	//   _abanyata, _apporter_, _ludea_, _binywera_, 
   {{0x23eb026c,0x6ca60008,0x37420239,0x7ab601b5}},	//   _auctor_, _салсын_, _korotang, _muchavis, 
   {{0x32ea055a,0x73010294,0xe72d0092,0xe2e60160}},	//   _eventos_, _altarpi_, _わかんねぇだろ_, _imenima_, 
   {{0xa3160438,0x8c530588,0xcece0287,0xa66f0148}},	//   _mkazi_, _igitabo_, _voliteln, _每個漢字相當於兩, 
   {{0xf2d900ac,0xe607034c,0x2ad70235,0x4a8602fd}},	//   _vicevi_, _классикл, _अञ्चु_, _doinionn_, 
   {{0x9f25048a,0xd93401ad,0x9f6402ea,0x8cd902a8}},	//   _اقداريعا_, _itamarat, _affascin, _bankarju_, 
   {{0x77cc00ff,0x99e505e0,0x9e4100a4,0xce620033}},	// [1f50] _פלאנעט_, _testícul, _expandit_, _bloccada, 
   {{0x9213007b,0x426d00ee,0xd3a1027e,0xe84502cf}},	//   _lichts_, _datoz_, _украшена_, _leitores_, 
   {{0x4a54027f,0xcea3029b,0xdaaa008f,0xd0bb018d}},	//   _aramutab, _bañata_, _मुरलिया_, _ፍሬዘርን_, 
   {{0xc27f0039,0xc2ed01be,0x1f5d05c3,0x67e40012}},	//   _joango_, _निरीह_, _dépendan, _झटकरले_, 
   {{0x7edc0200,0x491f034e,0xa79b0311,0x629001e8}},	//   _ịzachana, _chacrayu, _መስተንክራዊ_, _limaw_, 
   {{0xfb8e0279,0xc963034e,0x5ae10258,0x38d2032d}},	//   _première, _akunatat, _blokhúsp, _мутлашыу_, 
   {{0x8db0026c,0x029e0475,0x6a0302c1,0x00000000}},	//   _consensu_, _низам_, _baraseze, --, 
   {{0x5c4a027b,0x0b70004d,0xdf920039,0x300f0163}},	//   _विशन्ति_, _不得轉載使用_, _гурилаар_, _اورنبی_, 
   {{0x724e01e6,0xff61012a,0x70db03a8,0x1213007b}},	//   _autorovi_, _zapoznał, _উদ্যোগীক, _dichts_, 
   {{0x539601ba,0x9248046d,0x4e480099,0xca800545}},	//   _morsel_, _ngomu_, _achakuba, _planfors, 
   {{0xb3eb0279,0xaae803e6,0x5ecb00a3,0x3a110015}},	//   _chatte_, _betounen_, _bilistan, _ammaanke, 
   {{0x025501b7,0x294900d9,0xa1510244,0x03950198}},	//   _बिभेति_, _водителя_, _оттук_, _okusu_, 
   {{0xb25a01f0,0x23b8030b,0x1e3c0334,0x9cb90205}},	//   _abilwe_, _akaweke_, _angamupa, _аралашиш, 
   {{0x5b3b0144,0xd291011d,0x00000000,0x00000000}},	//   _dolcáin_, _aluat_, --, --, 
   {{0xf2d8012c,0xde99027f,0x00000000,0x00000000}},	//   _tiketi_, _ugitwaye_, --, --, 
   {{0x84e6015e,0x3c0e00f2,0x090603e6,0x9b970107}},	//   _بولالباي_, _cenuklub, _verbreed, _حاضران_, 
   {{0x3b8b03c3,0xd21200a1,0x0bd200ba,0x53940286}},	// [1f60] _ministar, _hoiho_, _ئۆزێل_, _nyisia_, 
   {{0xc32401ca,0x6c750158,0x49fa0340,0xef150041}},	//   _birchoh_, _हार्ले_, _marikena_, _itúaep_, 
   {{0x06110043,0xf09003d5,0x00000000,0x00000000}},	//   _amulindi, _avocatio, --, --, 
   {{0xff1f033f,0x52490102,0xc9060237,0x00000000}},	//   _lautohip, _mpambe_, _데살로니가전서_, --, 
   {{0xc33d0247,0x632504cb,0x837f0064,0x33030241}},	//   _میراث_, _stradă_, _астанага_, _furamuu_, 
   {{0xc2fc0058,0xbfc200bc,0x7dae02a3,0x2e420022}},	//   _bungil_, _راهور_, _hangende_, _өҙөлдө_, 
   {{0x21fa068c,0x79da042d,0xc4860553,0x430304f9}},	//   _umphefum, _adoniasa_, _prevziať_, _allatat_, 
   {{0x4e960181,0xdc5a02af,0x9117045e,0x00000000}},	//   _fortalte_, _bintazi_, _дисплеи_, --, 
   {{0x02ca01f6,0x72ef0282,0x301b0153,0x45080030}},	//   _kundar_, _pahitia_, _日本麻酔科学会認, _faktisko_, 
   {{0xf213056e,0x66a70313,0xd5da0386,0x4bfb0203}},	//   _rochas_, _chirghch, _rambutny, _borgesuc, 
   {{0x42900278,0x97ad0478,0xf395034b,0x024d02bb}},	//   _limau_, _insectiv, _okust_, _मंडला_, 
   {{0x6317021c,0x32d801fe,0x537b0119,0x537f018f}},	//   _kurzy_, _tudei_, _nienburg_, _dalanha_, 
   {{0x9f7801f7,0x572d0205,0x1da9021e,0x94b50322}},	//   _adicionn, _farmonig, _splittra, _baratwik, 
   {{0x031301b5,0xc9fa0226,0x0e000107,0x00000000}},	//   _mincila_, _keliyala_, _dilepasa, --, 
   {{0x1230005c,0xd3730003,0x74d903ed,0x52de0449}},	//   _nyamara_, _relatie_, _direção_, _duhovnu_, 
   {{0x60d300ec,0x02d802f1,0x137a051a,0xbe95025b}},	//   _класы_, _ordem_, _sepadan_, _nordplus_, 
   {{0x83a303a4,0x442d0192,0x07720193,0xc3170096}},	// [1f70] _sleppa_, _여러분들의_, _प्रायव्ह, _abazwi_, 
   {{0x426201d5,0x42da00dc,0x739502a5,0xab8c0109}},	//   _ذائقہ_, _asuelu_, _vkusu_, _संघमा_, 
   {{0xd3170119,0x7a790148,0x637f0342,0x934b02c2}},	//   _liezen_, _這樣的發言參考價, _dilatwa_, _krieket_, 
   {{0xb4da015e,0xd30d0005,0x43b5037f,0x9bdc0061}},	//   _образдар, _spezialm, _əlvida_, _가능하다면_, 
   {{0x727e05d0,0x112103d8,0x46210281,0x06cd0170}},	//   _apena_, _raspolož, _ilimmarf, _ankangoi, 
   {{0xb16d0255,0x2316013d,0xc364002e,0xb2cb0079}},	//   _गोपालीचक_, _okazo_, _snagama_, _lidosta_, 
   {{0x2290006f,0x931902ac,0x4b0201ec,0x62d80189}},	//   _kamati_, _فيسات_, _نورپرداز, _erdem_, 
   {{0xda0804b2,0x43060077,0x2f05007e,0x9309068d}},	//   _gumagana_, _grangwav_, _श्रीवत्स_, _blindveg_, 
   {{0xf2b603f9,0xb9e4005d,0xedb500e7,0x5a7702eb}},	//   _parchi_, _arandura_, _alonylma, _видеон_, 
   {{0x90c702c4,0xd5e20076,0xb2a700a0,0x3290000e}},	//   _рамките_, _железнич, _harba_, _limat_, 
   {{0xe2a7001e,0x94f300c7,0x1a0800b0,0x313a0211}},	//   _karba_, _торамы_, _rasaasee, _калорийн, 
   {{0x636e012b,0x910c02bb,0x9ba4012c,0x25620061}},	//   _komentuj, _उच्चायुक, _wakiwemo_, _안내입니다_, 
   {{0x02a700b0,0xc5bb02fe,0x0202025f,0xe54e03fe}},	//   _marba_, _سیاستوال, _kotiya_, _тигна_, 
   {{0x1b9702ac,0x82ff0077,0xc26301bb,0xb38700cd}},	//   _agritour, _andikap_, _ahmiyeti_, _caura_, 
   {{0x72d403b0,0xb0ed0255,0xc8f5019b,0x0059017a}},	//   _trudde_, _optimaal, _складана, _akusiman, 
   {{0x866a018b,0xf9ae00be,0x93f4019b,0x00000000}},	//   _скицате_, _تۇپتۇۇرا_, _vertas_, --, 
   {{0x92d900f4,0x53730305,0x805701e8,0xb533068e}},	// [1f80] _attek_, _skuledag_, _makapato, _nenasiel_, 
   {{0x8261042a,0xcc4900e6,0xcaa803b8,0xb526011a}},	//   _acatulul, _讨厌干妹妹_, _логотипі_, _לְשׁוֹנְ, 
   {{0x429102a0,0x84da0187,0xc27e023b,0x02d803ff}},	//   _alakans_, _воена_, _upena_, _prdel_, 
   {{0xc290033c,0x00000000,0x00000000,0x00000000}},	//   _timau_, --, --, --, 
   {{0x72a70030,0xa23500a6,0x22fc00b4,0xb2e80119}},	//   _darba_, _پاسورډ_, _lungul_, _buligan_, 
   {{0x68ce01c6,0x62d8000e,0xf607032d,0x00000000}},	//   _allegedu, _ludet_, _ditlhapi, --, 
   {{0x92a70206,0x43fa001d,0xa2020271,0xc86101ef}},	//   _farba_, _casuar_, _skritt_, _autoriau, 
   {{0x499100ac,0xf93200de,0x9dcf01bd,0x0bdf0378}},	//   _klijenta_, _انتیک_, _оптикалы, _ellender, 
   {{0xc3870357,0x254d0040,0xe20102ff,0xca6c0161}},	//   _taura_, _ובלבד_, _ekzije_, _россияна, 
   {{0xcc010053,0x5ea302a4,0x43eb01fb,0xa966020b}},	//   _drastis_, _litterae_, _sexte_, _diporoje, 
   {{0x7e6c013d,0x56c601db,0x3eaf0322,0x00000000}},	//   _koncerne_, _шрифтің_, _baburiye_, --, 
   {{0xc71800ff,0xad2703d4,0x396f0282,0x1cb7003c}},	//   _מעקסטו_, _произвођ, _kotingot, _bangsamu_, 
   {{0xe2900422,0x42d90321,0x62ec029b,0x52900144}},	//   _nimam_, _poceni_, _diineek_, _aneas_, 
   {{0x39e30318,0x0a0a0082,0x668901da,0x59f60028}},	//   _tokotaha_, _sarakuna_, _graduali, _idinkuna_, 
   {{0xaf970410,0xd7f000bc,0x63070037,0x849a0105}},	//   _dithekiš, _میمونه_, _silalah_, _kawalerk, 
   {{0xc5650244,0x29fa0082,0xd632034c,0x00000000}},	//   _сложете_, _babakere, _акциясен_, --, 
   {{0x06b404f9,0xf7c50076,0xe30001eb,0x2c70020f}},	// [1f90] _atugarli, _passagei, _bilampi_, _amasele_, 
   {{0x1c02015c,0x497a022e,0x2b0302c2,0x00000000}},	//   _histores, _antivist, _narratie, --, 
   {{0x89fb0235,0x7d3e006d,0x48d40153,0xc2fd007f}},	//   _क्रमशो_, _арэлі_, _クチコミブログを, _gregyn_, 
   {{0xdb9704ce,0x0599018d,0x86090037,0x6da2003b}},	//   _dzangano_, _መሃንዘል_, _በሚያዚያ_, _alenkapa, 
   {{0xcb1f0157,0x9e3402d6,0x5b910373,0x7b25003e}},	//   _samadhan_, _بوجاغیند, _cionismo_, _булашыу_, 
   {{0x5a7700ed,0xc667030b,0x9a4800c1,0x8fab00d1}},	//   _flagella_, _amajambi, _resepnya_, _বিনন্দিয়, 
   {{0xbe830204,0x76b402f6,0xa20000cf,0x129000d8}},	//   _подарок_, _makatuwi, _bilisa_, _aimam_, 
   {{0x95b90113,0x8290068f,0x14e20071,0xaa490022}},	//   _ballstát_, _enear_, _هیچکدام_, _финанста, 
   {{0x82d802c6,0xe27f00ec,0x7036007e,0x9d860408}},	//   _ardec_, _aplinkai_, _avataran, _enimbola, 
   {{0x527e028d,0x0ce5023a,0x631c005b,0xea07022c}},	//   _apenn_, _serveroc, _dosyusei_, _cilamaya_, 
   {{0xb2d90211,0xc821026c,0x4b6b0119,0xa3260040}},	//   _ettei_, _為民服務白皮書_, _enforcer, _מילפית_, 
   {{0x19650255,0x91cb00d9,0x43f8005f,0x5eba0060}},	//   _प्रवेशला, _sitoutum, _temuco_, _قىسقاشا_, 
   {{0x084a008d,0x43f403f5,0x2e860156,0x4eaf018c}},	//   _борки_, _certos_, _הייראטן_, _parttime_, 
   {{0x73860151,0x326c01e5,0x3a5d0135,0x30a400a6}},	//   _gyere_, _aimoye_, _сайлагыз_, _پروردګار, 
   {{0xa6d402ec,0x7891004c,0x037f027b,0x82fd007f}},	//   _salaadii, _amakungu, _balasya_, _cregyn_, 
   {{0x9224002a,0xef0b018d,0xa41c0162,0x9ab20040}},	//   _adikwa_, _ግዳማዉን_, _буюми_, _חילוניים_, 
   {{0xf2ca03f0,0x22cb012a,0x92a0013c,0x1ed9026c}},	// [1fa0] _fundur_, _kredyt_, _bildirən_, _insidias_, 
   {{0xbfcb0148,0xc501027f,0xfefc0325,0xdb3900be}},	//   _大家最想要的網誌, _aramwish, _balaxanı, _نۇرجىگىت, 
   {{0x1da300af,0x52e90067,0xb34a0242,0x1e8901f3}},	//   _болить_, _ertiraa_, _bilgilər_, _cirkulač, 
   {{0xd2620247,0x45a30147,0x3bc9012a,0xa184005b}},	//   _téori_, _بەرشىن_, _kredytów_, _ayapanko, 
   {{0x1c210046,0xec5201a4,0x52690128,0xa2cb0433}},	//   _ايگەرىمد, _apetola_, _ییملیکلر, _tesda_, 
   {{0xb60e034e,0xf1340088,0x291302fc,0x527f0192}},	//   _albostri, _алдылай_, _babasuhu, _tranen_, 
   {{0x3c6f03ee,0xa9470128,0x4a8400e6,0x4bf400a7}},	//   _potraga_, _шаҳват_, _新规定明确_, _subestac, 
   {{0x6a7c0109,0x0868020a,0x8201010d,0x61f30062}},	//   _प्रेरितक, _بايرىننى, _praktisi_, _danaymeh_, 
   {{0xfe00022a,0xc8eb0037,0xe6b80399,0xb4b90311}},	//   _literata, _ፔንታጎን_, _manavasi, _ትምልከት_, 
   {{0xfc6f03b3,0x13fa012c,0xf6030153,0xa25b0265}},	//   _entrava_, _karume_, _させていただきま, _haalde_, 
   {{0xd2d8025c,0xbeb80037,0x839402ff,0x00000000}},	//   _zudem_, _በማሳለፍ_, _nevyèm_, --, 
   {{0x42d800ee,0x8c62048c,0xf140025c,0x91a100a4}},	//   _ordea_, _mcardle_, _zugleich_, _cercavil, 
   {{0x437800fe,0xdc07038b,0x02670135,0x3d8d0037}},	//   _ataaina_, _persatu_, _алтынсым, _ለማቀላጠፍ_, 
   {{0x02a2047f,0x5743012e,0xfed4022b,0x245d0420}},	//   _उच्चस्तर, _آزمودہ_, _freistin, _interaçã, 
   {{0x829002df,0x43070278,0xb387007b,0x93eb03f8}},	//   _jimak_, _bilakah_, _haurl_, _pepta_, 
   {{0xdc070212,0x0f3f028f,0xa2fd02a0,0xc2780272}},	//   _grisoft_, _hangahan, _isegun_, _amuntu_, 
   {{0x3e0e03b0,0xf08b03ce,0xb20204f8,0x4c130372}},	// [1fb0] _forfatta, _براتان_, _shrine_, _carpedi_, 
   {{0x938703b4,0xe5ff02fe,0x7472035e,0x228b0139}},	//   _sauro_, _ټلویزیون_, _zelenilo_, _dayitā_, 
   {{0x63870103,0xb39502ff,0x63860068,0x2316036c}},	//   _pauro_, _akasan_, _fiirso_, _akizy_, 
   {{0x46040231,0x030d0513,0x0f9603c9,0x5316013a}},	//   _imperium_, _hambana_, _fordeler_, _skizz_, 
   {{0x330d03d9,0xc36c0040,0xec61022b,0x00000000}},	//   _kambana_, _והתחלתי_, _gudurin_, --, 
   {{0x0278017a,0xff090094,0xed790089,0x72900053}},	//   _umuntu_, _ادامشىلد, _наркозда, _limah_, 
   {{0x5388018d,0x8f8e023e,0xaec4023e,0xdf3501f4}},	//   _ትካላቱን_, _تیتانیوم_, _blangkon, _misollar_, 
   {{0x59b600af,0xe85902dc,0x2c610082,0x5f2e023d}},	//   _meddebat, _marrocos_, _kudurin_, _титла_, 
   {{0x33f40005,0xadfd0149,0xe2d800a4,0xc49300d1}},	//   _surtut_, _kọmunist_, _aules_, _এখেতৰ_, 
   {{0xa7c80128,0xf387015e,0x12d80033,0xe9bb01fe}},	//   _اصطلاحلر_, _caure_, _sulet_, _galeleta_, 
   {{0x51820420,0xf3f80082,0x00000000,0x00000000}},	//   _niterói_, _haduwa_, --, --, 
   {{0x52d80016,0x561901d8,0x5394022c,0x02900072}},	//   _dudek_, _ballarmi, _nangtung_, _rimak_, 
   {{0x03f8015e,0x6997042c,0xb2dc0128,0x372502d3}},	//   _graus_, _svojstva_, _лобановс, _vantagem_, 
   {{0x4fc2004a,0x10f600f7,0xbb550026,0x6afd038d}},	//   _konovalo, _אברומי_, _middelen_, _siperfis, 
   {{0x4a5e00ea,0xf22a0244,0xc30d02be,0x7641020f}},	//   _takelaka_, _кораб_, _dambana_, _بارکوال_, 
   {{0x42d9007b,0x760b0237,0xd27e0044,0xd2d804b9}},	//   _favours_, _afkomsti, _spend_, _auler_, 
   {{0xb27e0286,0x8b0900be,0xe387009c,0xcb7d028a}},	// [1fc0] _apene_, _кирешеле, _baure_, _زيارتون_, 
   {{0xd3f8047d,0x69c201db,0x62900227,0xeecf01f3}},	//   _draus_, _تەرسكە_, _samapi_, _postavím, 
   {{0x02d801b9,0x41f5022f,0x2ec702be,0x00000000}},	//   _duler_, _суботах_, _abrolhos_, --, 
   {{0x93f801fc,0xd26d0282,0x00000000,0x00000000}},	//   _baduwa_, _iraoho_, --, --, 
   {{0x230d005b,0x6d290044,0x129002d8,0xad870013}},	//   _bambina_, _substanc, _simak_, _bilmayma, 
   {{0x93b600d7,0x82a701ef,0x92f602be,0x9d190142}},	//   _хайран_, _часовая_, _tahimik_, _anindite_, 
   {{0x343e00ac,0xb61a003c,0x650404b9,0x494e04f9}},	//   _slobodno_, _فرزندم_, _fareweel_, _biologit, 
   {{0xd3f8004d,0xc2c60334,0x615c0145,0xabd9005e}},	//   _prius_, _amalize_, _думах_, _كورېيە_, 
   {{0x027e00a9,0x186f01be,0x93fa00d3,0xacbc01fe}},	//   _ngingo_, _filmový_, _varuje_, _tawalotu_, 
   {{0x92390056,0xe2010373,0x73f400c5,0xf3a30176}},	//   _номус_, _trairi_, _pertes_, _amepia_, 
   {{0xb2d801c7,0x034400f4,0xd2d80362,0xcf2401b4}},	//   _irden_, _antelme_, _bikedi_, _anderkan, 
   {{0x03f8016b,0x871b01da,0x4b630062,0xaeec0153}},	//   _yaduwa_, _gjermanë, _gheritra_, _クショントップ_, 
   {{0xef77017e,0x9293019a,0x7a2003a2,0x4270017a}},	//   _demandis_, _bankrup_, _नवाबों_, _amagilam, 
   {{0x3140020e,0xaed700c6,0x663700d0,0x9b1f018e}},	//   _dibelael, _значного_, _дардас_, _namafamb, 
   {{0x727e00d0,0x62bb024c,0x64b40142,0x53a900db}},	//   _egingo_, _valette_, _अन्तर्_, _munasarj, 
   {{0xb6a50370,0x4e2000cd,0x00000000,0x00000000}},	//   _barungah, _cunmeins_, --, --, 
   {{0xc3870338,0xdb6102d8,0x7c7402ee,0x86cd0291}},	// [1fd0] _paure_, _sinetron_, _affresk_, _antartai, 
   {{0xbf250501,0x3b27024d,0x13b602c3,0x41aa00ff}},	//   _अभिजीत_, _yamaphes, _možnosťo, _אַמסטערד, 
   {{0xe39503b9,0x1212059f,0xa3f80082,0x2b380153}},	//   _ajusa_, _llahu_, _saduwa_, _コシャマインの戦, 
   {{0x427e01f2,0xd3860286,0xd9c700b7,0x619300ff}},	//   _компарти, _ayera_, _балажа_, _פאלקס_, 
   {{0x23fa0282,0x30bd0089,0x7f2b0311,0x00000000}},	//   _petuha_, _броун_, _ከይደቀሰ_, --, 
   {{0x48630016,0xc3090583,0x31c10291,0xff4000a6}},	//   _akuzativ, _prebral_, _دجيتال_, _ayisosip, 
   {{0xa200014c,0x1067002a,0x731c00de,0xf2d90163}},	//   _indima_, _akwarado, _awayeham, _ettem_, 
   {{0x2aa503db,0x00000000,0x00000000,0x00000000}},	//   _kusindis, --, --, --, 
   {{0x2486014e,0x1e000408,0x7c020044,0x00000000}},	//   _смене_, _andefasa, _pictures, --, 
   {{0x03b60238,0x0216001a,0x269a00f6,0x741a0049}},	//   _значення_, _bonyolul, _tikilməs, _ikonimik, 
   {{0xfdb90170,0x4b0d0211,0x00000000,0x00000000}},	//   _chinakha, _потихонь, --, --, 
   {{0x6df70342,0x4a3b00e6,0x11b502c8,0xaee60299}},	//   _bilyonè_, _无锡工商红盾信息, _caramiña, _بۇھايات_, 
   {{0xd9f702a5,0x5758060e,0x90f5017f,0x79630344}},	//   _vydavate, _संग्रहक_, _aktianil, _cafésemi, 
   {{0xd2cd0312,0xa9c3031a,0x06a7013a,0x122b00d1}},	//   _poloneg_, _cilemeat, _mayerhof, _দণ্ডাধিক, 
   {{0xb27e0321,0xa03800c5,0x4a760143,0x5815020e}},	//   _žensk_, _gestionn, _филтъра_, _бумала_, 
   {{0x2200025f,0x72fc0452,0x3afe02ee,0x870d014e}},	//   _andima_, _mungil_, _deframme, _каира_, 
   {{0xa26e0140,0xc340014e,0x2b9a0310,0x2e360399}},	// [1fe0] _nitong_, _nijedan_, _beannaic, _tavaliva, 
   {{0x23dd03ba,0xfc7201e7,0x4ff904c7,0x700900be}},	//   _drawal_, _betreit_, _трансилв, _кичипейи, 
   {{0x5db30195,0x058e0179,0xe2000085,0xc2b60220}},	//   _colaiste_, _baitonik, _biliga_, _marchi_, 
   {{0xd2d50333,0x3ed70060,0x73190079,0xc7fa0137}},	//   _cipolla_, _текше_, _kāzas_, _жинлүүри, 
   {{0x43f900ad,0x1e5400aa,0x466c024a,0x9f3a00d5}},	//   _tuyul_, _bahandia, _birasíìl, _arafesin, 
   {{0x1dbb030c,0x89da01a7,0x368e0101,0xe2940313}},	//   _maliktaa, _kunnossa_, _conditii, _hiratlhm, 
   {{0x37580157,0x7c100061,0xa0e7012a,0x631801e9}},	//   _संग्रहण_, _수소에너지_, _protokoł, _gamiwang_, 
   {{0x6d800115,0x02650024,0xb2090213,0x14080097}},	//   _wallahua, _ত্ৰিপুৰা_, _названия, _laapọn_, 
   {{0xaae80077,0xab1f006e,0xa3ea00a5,0x93e60282}},	//   _retounen_, _damadaan_, _maitau_, _mōtai_, 
   {{0x5667000c,0x6584023d,0x72d803dd,0x6cc40055}},	//   _валико_, _manutenz, _eulex_, _articulu_, 
   {{0x8d1b0091,0x64a30373,0x52000013,0x527800a9}},	//   _amigaitq, _anstataŭ_, _yiliga_, _umunyu_, 
   {{0xbf3b0193,0x12eb015a,0x038700a0,0xb37a02f9}},	//   _kerusaka, _baannus_, _haura_, _depaman_, 
   {{0x338702b1,0x79d801f4,0xcc57039f,0xe61003eb}},	//   _kaura_, _misolida_, _histone_, _noemensw, 
   {{0x62b601f4,0xeaa9008f,0x0c7000a1,0xad030080}},	//   _garchi_, _salvesta_, _kāraha_, _illutaar, 
   {{0x9ebb014e,0x47a200be,0x74b40464,0x294501cf}},	//   _maloletn, _بۅلسۅڭ_, _bakandik, _requirer_, 
   {{0x12d90120,0xfc5c0045,0xc1ca00af,0xe9ca04a7}},	//   _ittek_, _pretilo_, _установч, _saudable, 
   {{0x5248019b,0x12450036,0x9b050109,0x00000000}},	// [1ff0] _kaimas_, _bímid_, _cyklistů_, --, 
   {{0x1ae9035b,0xeb3d0148,0xed5b01b7,0xcdb80034}},	//   _sprememb, _台北市松山區民生, _प्रभृति_, _rannsaka, 
   {{0x77be016d,0x99e60408,0x3f2d00aa,0xd27e0234}},	//   _ھەرقاندا, _antonona_, _kabuanga, _npeni_, 
   {{0xce9c00ff,0x8b1101e8,0xc26e00fa,0x38dc02cf}},	//   _והארות_, _kompanya_, _pitong_, _судии_, 
   {{0xfa9f02ac,0x937a00a5,0x8c670049,0xf29102aa}},	//   _يحفظك_, _augaaso_, _lohuloa_, _steaky_, 
   {{0x408400c9,0x62d8034a,0x0eae0291,0xa42f0265}},	//   _stockbiz_, _ordes_, _stormont_, _afspelen_, 
   {{0xc387001e,0x196603dd,0x1263008c,0x02000013}},	//   _daura_, _denigrue, _schurnal, _tiliga_, 
   {{0xc27e019d,0x69970029,0x41c4005d,0xfd0600be}},	//   _mpeni_, _ڵگاێکی_, _alamikam, _توبۇۇ_, 
   {{0xf3eb00a4,0x8e370217,0x16370075,0x9c58005e}},	//   _repte_, _mananita, _megindei, _تاماكىنى, 
   {{0x26a803f8,0x42020216,0x025a002f,0xa3ea04ca}},	//   _charghch, _entisa_, _asillu_, _abitud_, 
   {{0x296d0203,0xf06d0220,0x42da0193,0xc65e01ee}},	//   _compleer_, _complean, _bosedi_, _жимма_, 
   {{0xcb0704fe,0xd2e901c0,0xf2d901db,0x0b0d0294}},	//   _rimprove, _barinsa_, _سۇيمەدىڭ, _hampinat, 
   {{0x2b8702c7,0xa847017a,0xe2a0021a,0x72f10055}},	//   _gefilter, _масали_, _durbii_, _altiani_, 
   {{0x863701eb,0xf26602c9,0x83020690,0x82000568}},	//   _мариан_, _ансамблу_, _tuhanku_, _feiing_, 
   {{0x22be0040,0x9da00144,0x3287013f,0x5321002f}},	//   _סוכריות_, _chuntasa, _creirwy_, _coayla_, 
   {{0xb26d0121,0x22480145,0x00000000,0x00000000}},	//   _actos_, _žemyn_, --, --, 
  
   {{0x9b7d01ad,0x3463004d,0x02a7033d,0x3ecc03d3}},	// [2000] _sonneber, _睇紫微斗數可唔可, _chebna_, _feriehus_, 
   {{0x3c710025,0xd2d805a9,0x82f20024,0xdea4005b}},	//   _मार्गे_, _mikeyi_, _সহযোগ_, _returret_, 
   {{0xc27f0288,0x2f5f000b,0x470903c4,0x9bda03a2}},	//   _aranon_, _autaunon, _учрушиду_, _भदौरिया_, 
   {{0xe3870149,0x93a901b2,0xfe2b0148,0x12e70122}},	//   _ezuru_, _crevice_, _政府採購資訊公告_, _awangun_, 
   {{0x72d90211,0x08b700c4,0x1678018a,0x43410016}},	//   _kuten_, _لامحدود_, _mileniwm_, _liberan_, 
   {{0x4c5701d4,0x28cc03a1,0x7d7e0081,0x827f01bf}},	//   _pistone_, _осветлен, _framunda, _usunt_, 
   {{0x02d900ee,0xa31600a9,0x76c60006,0xa26d0040}},	//   _duten_, _akazu_, _membersi, _actor_, 
   {{0x62c10321,0xd41a0318,0xc8530126,0x425b03ab}},	//   _želiva_, _ikonomik, _площу_, _povlak_, 
   {{0x38530074,0x8a3e0189,0xc9fb02f7,0x711c0229}},	//   _рекламны, _haritası_, _bukatsat, _alışıb_, 
   {{0x53b900a4,0xca9701b4,0x22320211,0xd4fd0350}},	//   _previst_, _namibies, _многодет, _የአብዮታዊ_, 
   {{0x4290043a,0x0ea702fe,0x90f8018d,0x204404b3}},	//   _nimas_, _پیامها_, _ኮንቴነራትን_, _diduaman, 
   {{0x5f5c00aa,0x6ae601be,0x2e540372,0x00000000}},	//   _alyansan, _अन्योल_, _asiantia, --, 
   {{0xd386001a,0x9da000d6,0xbf62017a,0xd23902d6}},	//   _nyert_, _shuntasa, _akuphela, _зобул_, 
   {{0xecce0047,0x92fa00e9,0xd0fa030a,0x2e380427}},	//   _县级以上地方人民, _bachara_, _bacharel, _turaaqta, 
   {{0x729000ed,0xf177040f,0x930400da,0x7c4e0216}},	//   _pamati_, _месты_, _curajul_, _makwenu_, 
   {{0x030c00f4,0x12900082,0x9a12022d,0xea53014a}},	//   _dibabet_, _lamari_, _riscossa_, _idióta_, 
   {{0x32020005,0xa96700e4,0x15530320,0x22d90014}},	// [2010] _entira_, _skontakt, _eyakweth, _futen_, 
   {{0xa29001fa,0x32d90166,0x371800ff,0xc7bc0040}},	//   _tamasi_, _guten_, _צעלסיוס_, _גלידות_, 
   {{0x22490457,0x52da013b,0xf41d00ab,0xc3fa0270}},	//   _daamis_, _abueme_, _kiripuak, _vetula_, 
   {{0xb27f01da,0xb51a0192,0x920003f5,0x73eb0270}},	//   _pranon_, _관광안내책자_, _comigo_, _nepta_, 
   {{0x02900108,0xb6800255,0xf53e002e,0x52d8022c}},	//   _kamari_, _रुलाई_, _održavaj, _ludes_, 
   {{0xf45501b7,0x1fb0014e,0x8f46031a,0xf25d00dd}},	//   _रसेन्द्र, _имунизац, _deirdrie_, _calonogi_, 
   {{0x543e0223,0x57e7004a,0xa52001d2,0xac6703ac}},	//   _хасна_, _başıña_, _chantach, _lakunya_, 
   {{0xf27f00ea,0x5c0902df,0x14a8032d,0x39dd02f4}},	//   _tranon_, _sempena_, _байдәүлә, _entendie, 
   {{0x690700c4,0x663902c9,0x00000000,0x00000000}},	//   _kitamadu, _invizibi, --, --, 
   {{0x53eb0203,0xb2d80212,0x1c2a0350,0x8e4701a4}},	//   _lepta_, _audet_, _አርእስተ_, _sibakaye_, 
   {{0xf34400c2,0xbdc3007a,0x69e203c4,0x28c0019c}},	//   _ubwenge_, _meriahka, _ئاسيا_, _olodoodu, 
   {{0x62d90590,0x72740593,0xc98c004c,0x3f1e0117}},	//   _zuten_, _forskjel, _abahinda_, _sandroin, 
   {{0xdb76024a,0x628e0043,0x120e00af,0x478d0137}},	//   _àyọkà_, _kaakano_, _гадаю_, _цогзолма, 
   {{0xa29100bd,0xc49e02af,0x8340031a,0xc9ea011a}},	//   _preach_, _barasonz, _cirdeas_, _overload, 
   {{0x644a005e,0x33a00156,0xa5a801de,0x00000000}},	//   _ظعلضعرع_, _ספּיידער, _мазалайт, --, 
   {{0x93fa0179,0x42f00067,0x00000000,0x00000000}},	//   _setula_, _godinni_, --, --, 
   {{0xd3fa0620,0x91cc00f5,0x0f22009a,0xb5ce010d}},	// [2020] _populi_, _лылар_, _alithaba, _bawaanny, 
   {{0x636002c2,0xa2900373,0x1a440157,0xfd8f0295}},	//   _liggaam_, _timas_, _adresata_, _ngalinga, 
   {{0x42f5035b,0x0d000212,0x12b802c2,0x00000000}},	//   _turizem_, _occurrer, _handsak_, --, 
   {{0x8290001e,0x12a7006e,0x231002ff,0xd69a04b3}},	//   _samari_, _caabiy_, _bouzin_, _boutailh, 
   {{0x72d80237,0x3c390096,0x7ed401ce,0x34b60109}},	//   _ouder_, _abaperes, _agungbbs_, _टाँडी_, 
   {{0xd4770452,0xb348007f,0x5e0702eb,0xdfbc015d}},	//   _प्रिलिम्, _adleoli_, _бичвэл_, _अलिकांते_, 
   {{0x837a0115,0x26b8005c,0x996900e6,0xb54100ae}},	//   _sepakan_, _babafiti, _aspirate, _kizigamy, 
   {{0xf972020f,0x825b0120,0xae530054,0xb200008b}},	//   _عبدالروو, _naalle_, _bambamce_, _indina_, 
   {{0x2000007e,0xdd9f009a,0x71330032,0x62000691}},	//   _aghoryād, _abangasa, _chowodmo, _comido_, 
   {{0x221c0325,0x00000000,0x00000000,0x00000000}},	//   _dəmirəl_, --, --, --, 
   {{0x0fad028d,0x8dba0268,0x9a6c025c,0xdf0300c5}},	//   _enkontro, _acticesp, _thematis, _inspiré_, 
   {{0x42d80416,0xa7370137,0xb6b40308,0x826400ca}},	//   _luder_, _урангоо_, _meluasny, _caulet_, 
   {{0x0ccc03ce,0x9e01003f,0xa34804d7,0x103200c7}},	//   _میونخ_, _dapeghta, _algengi_, _болында_, 
   {{0x1f4002fa,0x92e80499,0x4fad01b9,0xf395024e}},	//   _nyagasan, _amanatu_, _inkontro, _svasta_, 
   {{0x225a00df,0x72d9009d,0x827c0333,0x034205fb}},	//   _taille_, _lutem_, _gênes_, _pobegao_, 
   {{0xa20000c7,0x5d9a01a9,0x856700b6,0x62d40311}},	//   _liliya_, _comodida, _koomaamí, _lubonja_, 
   {{0x82cc0124,0x929003b0,0x1ad202db,0x8cab00e6}},	// [2030] _kualimo_, _timar_, _niuteste, _更多该播客的视频_, 
   {{0xb2ec0692,0xda7d03b4,0x2666008d,0x6c9802c0}},	//   _алмай_, _achafara_, _гуруҳини, _концепти_, 
   {{0x52020088,0xcf3004b4,0xe34b0350,0x827e00e0}},	//   _botiga_, _wesenlun, _የተሸከርካሪ_, _speno_, 
   {{0x574603f4,0x7fb700dd,0x8f78004d,0xd0f80153}},	//   _аккаунто, _diflanno, _財政部臺灣省南區, _ル条約登録_, 
   {{0xedf5029f,0x276901b8,0x05050137,0xdc7400fd}},	//   _atraktív, _हिम्मते_, _энергиэр_, _samradh_, 
   {{0x5e670488,0x1a0100a5,0xfea903a2,0x20be02ba}},	//   _autorizē, _asiasiga_, _फ़ीडबैक_, _шиква_, 
   {{0x6a3100de,0x721201a6,0xd88802d5,0xd1980152}},	//   _مشترکه_, _anahe_, _isikuand, _органнар, 
   {{0x137c025f,0x291e00bb,0x8e29026c,0x2ecc02c6}},	//   _israele_, _المیے_, _sermonis_, _dilinenn, 
   {{0x52ee00bc,0x94d3043a,0xb15600c1,0xecc40012}},	//   _madranah_, _filipuän, _आपुलकी_, _पराइलउभा, 
   {{0xb76901b8,0x125a01ac,0xffc900cd,0x00000000}},	//   _हिम्मती_, _saille_, _aquistar_, --, 
   {{0xea7d02c5,0xec2b02ea,0x22d8014a,0xe4460162}},	//   _achagara_, _apparecc, _erdei_, _ماڭىلا_, 
   {{0x3e5d0088,0xc20000d5,0xb8510405,0x9200000a}},	//   _treballa, _midina_, _обрали_, _asiip_, 
   {{0x29f5026f,0xed1b018d,0xee3500ce,0x61e0011a}},	//   _ءﺍﻧﺸﻰ_, _ንክኽተቡ_, _reponsab_, _הנישואים_, 
   {{0x262d02a9,0xf9880590,0x768b03d1,0x6f2d001c}},	//   _лінгвіст, _театрт_, _paverdzi, _kabutnga, 
   {{0x2bd101b7,0xa2d80176,0xbf7d004b,0xc9ed002b}},	//   _योऽयं_, _ruder_, _камераға_, _ইউনূসের_, 
   {{0x984e004c,0x466201cd,0x4d060099,0xa2e70258}},	//   _amalirid, _angisakw, _haareger, _teannen_, 
   {{0x99ac048a,0xc6a1017d,0x1902032d,0x2a950096}},	// [2040] _бюджетті, _ご了承ください_, _бульвары_, _akiyonge, 
   {{0x454a0148,0xd31600bb,0x6e3902a2,0x5d96004d}},	//   _本部落所刊登之內, _konzol_, _mabawasa, _世界請看著我_, 
   {{0x4c16012b,0xb213005b,0x063b036d,0xa15600dd}},	//   _ofertę_, _lychee_, _chliamai, _brastero, 
   {{0x8ae1045f,0xf3170272,0x320000ec,0x61fa00d1}},	//   _kostnade, _abazzi_, _didina_, _কোৰোণা_, 
   {{0xbc1c002a,0x63fd00a6,0x28b80153,0x2f4b0693}},	//   _uzopulu_, _aziziva_, _子犬の飼い方_, _fotosluž, 
   {{0xb7e001c9,0x89f901e4,0xcf3e0139,0xe3ea0358}},	//   _hispaani, _nadstand, _ambarānt, _abitid_, 
   {{0x724904ca,0xeb18038e,0x50990181,0x5bb200be}},	//   _acamps_, _bebatuan_, _auとwimax_, _سەپلدى_, 
   {{0x1a760335,0x2f3b01d8,0xd36502ac,0x345d0078}},	//   _नमोनमः_, _kongwien, _صناديق_, _проповед_, 
   {{0xb93d0169,0x3cd7022b,0xf8e901be,0xa224013e}},	//   _সভায়_, _dávavirk, _balónky_, _edikta_, 
   {{0x43020313,0xcfad0053,0x9c7d0120,0x4060063d}},	//   _bodanpu_, _dikontro, _onusida_, _vulkansk_, 
   {{0x367f0087,0x334300d9,0x00000000,0x00000000}},	//   _ehlekiti, _ходовая_, --, --, 
   {{0x83700192,0x92900326,0x735f0021,0x9c7504eb}},	//   _톡톡궁금증_, _aamai_, _aacenay_, _सिप्पी_, 
   {{0xa2900082,0x32900032,0xe0f00187,0x73a50464}},	//   _bamai_, _mamaw_, _статусот_, _narangij, 
   {{0x22900338,0x371400b5,0x62d90211,0x375f028b}},	//   _jamai_, _cherendá, _ettet_, _официалт, 
   {{0x0462002b,0xbe3b0331,0x2af700d7,0x4dba02e0}},	//   _মেহদী_, _limaskap, _гарегин_, _diritiba, 
   {{0xb2900120,0xb3a502c1,0x390200b3,0xbe39010e}},	//   _tamah_, _barangij, _aldamakd, _babawasa, 
   {{0x321300d6,0xb26c0147,0xc20202c3,0x0200042d}},	// [2050] _nagham_, _ئللپاللا, _skrine_, _aidina_, 
   {{0xb387030e,0xe27f01d9,0x5d7d011d,0xf21203f6}},	//   _nzuri_, _fruny_, _марторий_, _iniha_, 
   {{0x9e9e02b0,0x32d8004b,0xc395015d,0xb9c300ba}},	//   _erstellt_, _pehelo_, _skazany_, _ناڤبه_, 
   {{0x1c7c014a,0x88c003c2,0x225a0369,0x32da04b9}},	//   _forrás_, _deserved, _plolei_, _direck_, 
   {{0xf202014b,0x12900082,0xd27f0418,0xffad02e7}},	//   _fotima_, _yamai_, _aranan_, _gikontro, 
   {{0x6a7a017d,0xfc8b0192,0x0e4305fc,0x197e00b4}},	//   _エグザイル_, _저작권정책_, _मुद्दाहर, _echivale, 
   {{0x8bf5003d,0xdaf503eb,0x338000dd,0x351b02fd}},	//   _arrestac, _arrestas, _meurig_, _slanuigh, 
   {{0x23a502c1,0x2cbd013d,0x054200de,0x00000000}},	//   _yarangij, _ensalutu_, _azikabuy, --, 
   {{0x5d860359,0x2004034f,0xb2000369,0x1c570036}},	//   _tegearre_, _اندازې_, _hilina_, _cistine_, 
   {{0xbb620052,0x171d039c,0x1cef0026,0x6b540059}},	//   _भयानक_, _actuació, _plattegr, _esemplar, 
   {{0xa29005fd,0xf3ff0414,0x57b0002b,0x7212005c}},	//   _ramai_, _batunaki_, _রোকেয়া_, _aniha_, 
   {{0x421300df,0x10c900c7,0x3e6703d1,0x625b0448}},	//   _fiches_, _тарихыбы, _autorizā, _kabler_, 
   {{0x7f2303f5,0x7dea0583,0xc21301b6,0x9a330177}},	//   _semelhan, _deljenje_, _niches_, _hogakuér, 
   {{0xca7f0147,0x7b8d0152,0x46240170,0x133c0188}},	//   _ئيمەگىرە, _tariflar, _athimbwi, _маъзарат_, 
   {{0x9c540263,0xedc40059,0x02a500e6,0x92c300f3}},	//   _prachtig_, _comincia, _用户收藏管理_, _isilimo_, 
   {{0x1a4f009a,0x68c00448,0xa04502f9,0x52d8012d}},	//   _abamiseb, _reserved, _ameriken, _oslem_, 
   {{0xc29000fe,0x93ea0278,0xa37800b2,0x5423034f}},	// [2060] _tamai_, _baitku_, _bahatan_, _amabhaso_, 
   {{0x0c1d01af,0xa310037c,0x34e50452,0x00000000}},	//   _arwahlar, _mercede_, _एलिझाबेथ_, --, 
   {{0x643800c5,0x125b0249,0x02d40037,0x2ecb03bd}},	//   _警惕高仿真的古币, _skelem_, _ለድርድሩ_, _kalisdan, 
   {{0x598a002e,0xc2ee0359,0x2e8400f0,0xe030020f}},	//   _sviđa_, _moandei_, _letovísk_, _banesibo, 
   {{0x1e770222,0x5b8303b7,0xec760005,0x6f660109}},	//   _salariés_, _acrobloc, _anquals_, _patrové_, 
   {{0x937f01bd,0xe4ec002b,0x5e4d00ec,0x23720130}},	//   _астанада_, _নাদান_, _спробы_, _bellaing_, 
   {{0x1c610384,0x63160694,0x39bf0151,0xfd3c00e0}},	//   _siguran_, _ejizi_, _abnegate, _drintske_, 
   {{0x0a07020d,0x9bd90434,0xf2c5027c,0x6acf026e}},	//   _gerageza_, _posesión_, _avelise_, _शंकरपुर_, 
   {{0xa3f900ad,0xd20003f1,0x56d70322,0x00000000}},	//   _buyut_, _zilina_, _bakabitw, --, 
   {{0x238700c4,0x67860208,0x9e3b03ac,0x3200023b}},	//   _uzuri_, _داننان_, _berlapis_, _pilina_, 
   {{0xec550371,0x3f9500cd,0xc1ae0144,0x4da501aa}},	//   _esitate_, _aventüra_, _ومالي_, _earingwa, 
   {{0x52020256,0x92da023b,0xf8bb009a,0x5baa04cf}},	//   _notika_, _lepero_, _ميرکی_, _lenkonzo_, 
   {{0x1082022f,0x9f0c0040,0xdabd03ce,0xb567003e}},	//   _бенгальс, _בהולנד_, _میشدا_, _англияла_, 
   {{0x03e40362,0x529100bd,0x2c970013,0xa54a02b6}},	//   _akamatak, _aready_, _турғун_, _ماڭدايىڭ, 
   {{0xe8fd0695,0x4c3000f8,0x31fc010d,0xd2020439}},	//   _yuvarlad, _নরওয়ের_, _अर्जुनान, _nitiva_, 
   {{0xa2590388,0x02d90098,0x92da0047,0x738c00fa}},	//   _particol, _atter_, _faveur_, _karylle_, 
   {{0x220e0088,0xf3ff03b9,0xbbaa04cf,0x06c200e6}},	// [2070] _тамак_, _ratunaki_, _benkonzo_, _主要表现在_, 
   {{0xfccc015e,0x42d8009b,0x99110147,0x43e4011b}},	//   _миссияны_, _beheko_, _تۅۅلۅر_, _ekamatak, 
   {{0xa9f303d8,0x30e903bf,0xe022002e,0xc714005d}},	//   _prosvjed, _башлаяса, _predizbo, _cherendú, 
   {{0x42d9047c,0x4dd901bd,0x32d80245,0x94d700c7}},	//   _etter_, _дәрменсі, _shken_, _талкан_, 
   {{0xf5080163,0x526c0373,0xc25a0113,0x3a8604b3}},	//   _freemail_, _celon_, _mbille_, _bennaenn_, 
   {{0x285a0068,0x82c900dd,0x2dfb0311,0x06a200fb}},	//   _دعوادار_, _camlesi_, _ክነጻጸር_, _oluthath, 
   {{0xb3940527,0x0a1a04dc,0x136d007a,0xfa0602b0}},	//   _prosle_, _رزایی_, _bergaji_, _verbiete, 
   {{0xcea80125,0xa0f003b7,0xee290212,0xaa1400c4}},	//   _аладасын, _asticall, _germanis_, _kusamehe, 
   {{0x593f0311,0x00000000,0x00000000,0x00000000}},	//   _ክጥርነፉ_, --, --, --, 
   {{0x72900372,0x1f350478,0x7a350128,0x73f802ea}},	//   _camau_, _suportar_, _حساسیتلر_, _caduta_, 
   {{0xa39400ce,0xf200019f,0x3d2e00d1,0x722a00af}},	//   _asosye_, _milima_, _চুদাংফা_, _комах_, 
   {{0xf2e103d8,0x1231026a,0x449d0092,0x8b6c00d1}},	//   _kolovoz_, _daumaka_, _コンスタンティン_, _সংখ্যাৰপ, 
   {{0x52a00309,0x637f05c9,0x12900243,0x3145006c}},	//   _qurban_, _hahaaaa_, _namat_, _душманӣ_, 
   {{0xd03f01ac,0x826c0183,0x798100ac,0xc3780291}},	//   _cartlain, _velon_, _prekrive, _eteanga_, 
   {{0x9202011b,0x3a5001d5,0xd3a10109,0x33fa00a1}},	//   _botika_, _الیقین_, _sekretář, _topuni_, 
   {{0xcdb70269,0x720002e0,0x43460026,0x4e180134}},	//   _vivienda, _didiba_, _leiders_, _owóye_, 
   {{0xd3f80025,0xef0d02d3,0x19700065,0xdb6200de}},	// [2080] _yaduta_, _dormitór, _standort, _elothana_, 
   {{0x9290010b,0xd4ad0059,0x7290000f,0xa37c0194}},	//   _bomang_, _цитиране_, _damat_, _marasme_, 
   {{0x940d0562,0x39f6014a,0x659c0040,0x12620299}},	//   _bibigenz, _netán_, _ולהעביר_, _ئاققۇ_, 
   {{0x68c800e6,0x0d2e00d1,0xd51601e9,0x00000000}},	//   _国家保护知识产权, _দোকানখন_, _khuranyo_, --, 
   {{0x8c760696,0x8b1f00b0,0xdbdf03e0,0x19ac0262}},	//   _actuais_, _ramadaan_, _alleguer, _amatlyş_, 
   {{0xbdef012a,0xa3f80082,0x520004e5,0x00000000}},	//   _studiowa, _hadura_, _bidiba_, --, 
   {{0x1a0d008c,0x72c2053a,0xd90d01d9,0xadca0184}},	//   _aviatica_, _čelika_, _aviatiou, _iyihamba, 
   {{0xfa4303ff,0x68f70210,0xebe40274,0xa2020205}},	//   _konkrétn, _achatitu, _úrvinnsl, _fotiha_, 
   {{0x92d9008c,0xb28100c1,0x00000000,0x00000000}},	//   _fageva_, _semanggi_, --, --, 
   {{0xa104000c,0x72020240,0x00000000,0x00000000}},	//   _адержава_, _tuqiri_, --, --, 
   {{0x9fee0502,0x02900235,0x00000000,0x00000000}},	//   _greyhoon, _damam_, --, --, 
   {{0xef350035,0x5b7e0291,0xf2ec0212,0xf3f802bb}},	//   _bertuğan, _تكبيرات_, _actione_, _waluta_, 
   {{0xb37f023d,0x3a0a0301,0x28b603f0,0xd2d80066}},	//   _domanda_, _başlıca_, _myndband, _ordez_, 
   {{0x21ad0102,0xb8b90045,0x7a350046,0x22000102}},	//   _بيابانن_, _наставил, _fiscalia_, _kiliba_, 
   {{0xe7ad01e1,0x926c0403,0xf5ea019b,0xd16301d5}},	//   _премияһы_, _veloo_, _поймы_, _ٹارزن_, 
   {{0x49ec01a0,0x20460220,0xcfa10312,0x39b602b4}},	//   _anyiketa_, _altrimen, _berengar_, _fundísa_, 
   {{0x007e003c,0x2b8101fe,0x92ef037b,0x313a0151}},	// [2090] _مسافرت_, _phonecar, _semilla_, _berehagh_, 
   {{0x9454016d,0x6b070044,0xa6b20164,0xb57201a3}},	//   _ﺑﯩﺨﻪﺗﻪﺭﻟ, _consumpt, _мураҗиәт_, _رائٽر_, 
   {{0xe386021a,0xdb080096,0x755b01bd,0x00000000}},	//   _biiroo_, _arishima_, _ەتۋگە_, --, 
   {{0xa37f0377,0x8a22006c,0xc394006e,0xbae80109}},	//   _comanda_, _аттор_, _feese_, _odstínec, 
   {{0xf27f0306,0x158101ca,0xdde4001e,0x2b4e0226}},	//   _apuna_, _daleghch, _murkushe_, _bakwenda_, 
   {{0xa379001f,0x8a590121,0x1673004b,0x00000000}},	//   _papaapa_, _carencia_, _болотҡа_, --, 
   {{0xe29002d5,0x1fbd0060,0x2a430163,0x33d30092}},	//   _samal_, _ايتماتوۆ, _konkréta, _個人情報保護のた, 
   {{0x890a0089,0x28960244,0xe5150012,0x958401c8}},	//   _alabugad, _таксата_, _उरीदवे_, _rodinám_, 
   {{0x8e4e010f,0xb2eb02bc,0xc90403b4,0xbafe03f0}},	//   _панду_, _saindur_, _adhavhid, _aðfinnsl, 
   {{0xda2b0294,0x02d80418,0x00000000,0x00000000}},	//   _cuicocha_, _dikey_, --, --, 
   {{0xc27a017d,0x8b81052b,0xe85e046b,0x00000000}},	//   _氏名又は名称_, _सुरमई_, _llanystu, --, 
   {{0xf28701a0,0x7202019b,0xc3860132,0xde7d01b3}},	//   _atekiwe_, _motina_, _nyers_, _вареники_, 
   {{0x71280092,0x959a008f,0xe32501ef,0x62000101}},	//   _発明の名称_, _energiak, _адкрытым_, _ridica_, 
   {{0x725b02fb,0x8c170343,0x9a62034a,0xa27e0574}},	//   _ipalau_, _jailbird_, _amplious, _openu_, 
   {{0xe3940095,0x7bb00086,0x42180369,0x8a2a0153}},	//   _ndeso_, _الزبتھ_, _wiekanam, _エンジョイ_, 
   {{0x75a7012b,0x90e50376,0xa9fb01c9,0x52dd0390}},	//   _झूमते_, _avriksfl, _kajastat, _finişə_, 
   {{0x0ff40193,0x8b7c00ab,0x798a019d,0x0d28004b}},	// [20a0] _प्राकृत_, _mehurama_, _idakonza_, _ахырҙа_, 
   {{0x98940155,0x03380145,0xf68e007f,0x821c0318}},	//   _råvaror_, _арнамент, _bontnewy, _mashee_, 
   {{0xa2d9037c,0x32a00141,0x742200ba,0x77c100e7}},	//   _artem_, _qurbon_, _قاسپه_, _annularw, 
   {{0x5dfc01aa,0x5646022b,0xe45604da,0x6aef0004}},	//   _objectwa, _leikarum_, _prijetio_, _kalonnen_, 
   {{0x0d9a01f4,0xd15c0008,0x9a4c006f,0x767c0220}},	//   _tomonida, _сурап_, _تجزيا_, _evidenzi, 
   {{0x25b5019e,0x809300be,0x661f0090,0xb380012b}},	//   _пунктам_, _ابىيىرىڭ, _akandisi, _potraw_, 
   {{0xaaa9034c,0xc31702cb,0x23660156,0xd09700e5}},	//   _князева_, _emocije_, _דיקדוק_, _премин_, 
   {{0xf29001b7,0x13ce00e3,0x93f80055,0x00000000}},	//   _samam_, _solvit_, _calura_, --, 
   {{0xfc68000a,0xf28600e6,0x6d3c01c6,0x00000000}},	//   _buhrkal_, _affinez_, _tryntsje_, --, 
   {{0x62cb0313,0xd2000320,0x8fd60697,0x00000000}},	//   _chadaj_, _ehlisa_, _atendemo, --, 
   {{0xf76702eb,0x60440390,0x169900c4,0x00000000}},	//   _банкаар_, _abdullan, _nimesiki, --, 
   {{0xc30e0210,0x32e801f1,0x4bdf02bb,0xdb0a00be}},	//   _akabava_, _abonohu_, _holender, _قالۇۇسۇن, 
   {{0xd2910113,0xc2900016,0xaa3c03f2,0x927e0026}},	//   _anuas_, _samaj_, _зубов_, _opent_, 
   {{0xa3a300fe,0x8f080037,0x229004b2,0x3981019a}},	//   _alepea_, _የሚለዉን_, _hamak_, _adviseme, 
   {{0xb14e00d8,0xa8910272,0xf5060204,0xf29102ca}},	//   _imitacio, _alikungu, _maalivah, _cnuas_, 
   {{0x48b70169,0xfaba0135,0x7e720664,0xf8060361}},	//   _দেশগুলোর_, _talantlı_, _सुज्ञ_, _кратера_, 
   {{0xc27e033e,0x2aef033d,0xbafe002b,0x03c40188}},	// [20b0] _apenu_, _galonnen_, _ইশতেহার_, _дӯзах_, 
   {{0x0b9b02ec,0x8ca20184,0xe9f7038b,0x0bd40122}},	//   _ژھێپِتھ_, _arazakir, _miliknya_, _تألیف_, 
   {{0x5af50527,0x2ea70333,0x3d980139,0x09ff028a}},	//   _dovoljan_, _parlavan, _anyoanya, _watakaot, 
   {{0xc2910057,0xb29e00f5,0x04c1000c,0x52270137}},	//   _anuar_, _дивар_, _гәндарс_, _парист_, 
   {{0x0188038d,0x61b90064,0x190b0205,0xd3ff002c}},	//   _levantay_, _деймин_, _уйланама, _anplifik, 
   {{0x429000ad,0x7cf001ab,0x00000000,0x00000000}},	//   _mamah_, _भाएकेँ_, --, --, 
   {{0x1a0402ca,0x5357034b,0x3e2c0064,0x8203022f}},	//   _polasait, _sotfala_, _جانشەرىك_, _алкалоід_, 
   {{0x605e0060,0x725101e6,0xc9f80022,0x6d3500c7}},	//   _айдарлар_, _poslanci_, _balisana_, _рудаков_, 
   {{0x9891006d,0x529000d2,0x7be80085,0xe539029b}},	//   _афганска, _namah_, _kotokoto_, _farataal_, 
   {{0x82010073,0xd37a000c,0x18c80185,0xfc150222}},	//   _debite_, _астандар, _betereld, _désert_, 
   {{0x2fcc048f,0x93eb03ab,0xcfae0445,0xb26c018b}},	//   _fatiguer_, _texty_, _encontro, _deloc_, 
   {{0xcd1c040d,0xcb55022b,0x00000000,0x00000000}},	//   _semorafe_, _feitasta_, --, --, 
   {{0xf5630148,0x3f3b02b4,0xf7d50043,0x00000000}},	//   _命中注定我愛你_, _esigaben, _batundaw, --, 
   {{0x187f0266,0xf2aa0037,0x05aa03f2,0x00000000}},	//   _perhimpu, _አፈጉባኤ_, _опасения_, --, 
   {{0x39ee0257,0xd13e0064,0x5a0d029b,0xe6c50083}},	//   _borgarst, _التووبۇز_, _axaaliba_, _calantgi, 
   {{0x03860439,0xeb78018d,0xc20202d3,0xca990122}},	//   _axere_, _ናይብሓቂ_, _rotina_, _دوردست_, 
   {{0xc5710170,0xe37b02cb,0x22d90166,0x12250331}},	// [20c0] _amatuluk, _dolazim_, _gutem_, _fjakka_, 
   {{0x6290022f,0xdc9600ff,0xafe000b2,0x7866015e}},	//   _namai_, _ישראלדיג, _eksipilo, _pèrdues_, 
   {{0xc2d902a4,0xcbe00217,0x04b502c3,0xdc62010d}},	//   _autem_, _disesper, _cudzieho_, _mutusin_, 
   {{0xc21303cc,0xa51c0096,0xa4b30137,0xe2020360}},	//   _dichos_, _bakuyemo_, _үлгэрлэн_, _fotila_, 
   {{0xd15c0035,0x32900245,0xa2da000f,0xd05a014a}},	//   _турап_, _kamai_, _lisesi_, _parancso, 
   {{0x92e9003f,0xd29001ec,0xacd40162,0x422502c3}},	//   _biwihha_, _samak_, _гурридә_, _nickom_, 
   {{0xa053013b,0x5315040e,0x036402b0,0xd4e703c4}},	//   _geoscien, _sinnelag_, _fingern_, _دارىلتام, 
   {{0x86570067,0x105901e8,0x7f5b0193,0xf2980126}},	//   _bishanii, _igkakaro, _kekayaan, _програмі, 
   {{0x3709063d,0x9e4d03d9,0xf8820361,0x00000000}},	//   _kulturmø, _ambarana, _кохтла_, --, 
   {{0xf200030c,0xebdf0127,0x49fb00b4,0xa21302cf}},	//   _kihimi_, _pagesper, _medicala_, _bichos_, 
   {{0x89d901da,0xbc2c01a1,0xe27f02e4,0x17cd0022}},	//   _bisedime, _toebehor, _elenku_, _фоторәсс, 
   {{0xc83900b4,0x00000000,0x00000000,0x00000000}},	//   _политикэ_, --, --, --, 
   {{0x72d80212,0xa00d042c,0x0b44002b,0xe70301ee}},	//   _iudex_, _pokvaren, _ফোটোগ্রা, _йоккха_, 
   {{0x8379000c,0x07b10160,0xe2e0024a,0x1280020e}},	//   _hilario_, _obilazak_, _idanimo_, _drakone_, 
   {{0x520e061d,0x1d540318,0xa27e0055,0x00000000}},	//   _қарап_, _kapapulu_, _apens_, --, 
   {{0xe27e0342,0xdae10079,0xc28d00a6,0xc0c60170}},	//   _osinon_, _projektā_, _akukuva_, _amalakal, 
   {{0xa8f6008d,0xd1cc00ff,0x936e033e,0xa3ed0318}},	// [20d0] _لایتهد_, _אלקהאל_, _mongaru_, _tautoloi_, 
   {{0x403800bf,0xdc720026,0x99c800bb,0x126c0039}},	//   _особенно_, _betreft_, _lendület, _leloa_, 
   {{0xdc51023b,0x027e0343,0x524a0189,0xc248048f}},	//   _ahituba_, _asinon_, _resmen_, _dzomi_, 
   {{0xa35603ba,0x58900139,0x79800065,0xd34203ac}},	//   _stiffen_, _anekavid, _maximale, _torehan_, 
   {{0xc06f0061,0x423e0061,0x326c0190,0x2934004d}},	//   _무시무시한_, _우선합니다_, _redoa_, _市府新聞稿_, 
   {{0xf43203a8,0xa96e02eb,0xb13d0243,0xa5bb01d5}},	//   _পোলিং_, _ломбардн, _tellemmô_, _diplomát_, 
   {{0x8ae60265,0x4fb801e6,0x3fc101b6,0xdc010434}},	//   _verloren_, _naplánov, _minneapo, _asistir_, 
   {{0xa2ea0639,0x7f4200d1,0x6fe40056,0x0d6f0144}},	//   _butiran_, _torsdaga, _супурд_, _أحزان_, 
   {{0xd14a0177,0x32f701ec,0x8280012e,0x25320227}},	//   _australo, _مازیار_, _الوحیشی_, _sunnahny, 
   {{0x82f5008c,0x4179036c,0x15e400ff,0x721201a6}},	//   _turnier_, _andininy_, _לטובֿת_, _inihi_, 
   {{0xb2fc012a,0xb25a0544,0x12d60181,0x9d3a01c4}},	//   _uwaga_, _hoolei_, _skolens_, _afrikane_, 
   {{0x77bd000d,0xf2ce03c2,0x06b202a3,0x02e70203}},	//   _खड़गपुर_, _piloted_, _vergifni, _duantun_, 
   {{0xd14002e0,0x93f402f2,0x754f0028,0x77070381}},	//   _babelael, _cortos_, _tashanay, _bahyayá_, 
   {{0x1b0700af,0xc2000085,0x33a200b4,0x8e270024}},	//   _тиждень_, _daliga_, _scopul_, _হেঁপাহ_, 
   {{0xf9c502ee,0x92a2038a,0x021e0158,0x322d00cb}},	//   _valletta_, _chantá_, _naśladow, _мантикро_, 
   {{0x503f03a4,0x0c2601a3,0x572e0653,0x00000000}},	//   _bloggupo, _ڪاريڊور_, _nazvaná_, --, 
   {{0x6e3802be,0x106d00c5,0xff41031a,0x22c400bd}},	// [20e0] _karapata, _生命的艳遇狂奔_, _bharicha, _timmers_, 
   {{0x55280170,0x6580056b,0x35eb02b9,0x00000000}},	//   _chingakh, _dilukisk, _beregszá, --, 
   {{0xb2820013,0xd8d20599,0xf37800e4,0x1e4e05b1}},	//   _کنفرانسی_, _बाँटे_, _badania_, _vacsinou_, 
   {{0xeb7900ab,0x75100153,0x477301b8,0x00000000}},	//   _kapowair, _個人情報保護_, _सुतावऽता, --, 
   {{0x3e33042f,0xf7a3068e,0xbcb9028b,0x62780128}},	//   _halummaq, _zriedkav, _ҕәҕәа_, _matnni_, 
   {{0x4d81035e,0x1c150255,0xbf2502a6,0x52c80184}},	//   _trudnice_, _haruldas, _aggrutta, _kabonye_, 
   {{0xc2de0390,0xca6d0044,0x727d0059,0xf2d400b9}},	//   _dilində_, _לשדרג_, _ъплоуди_, _kalopun_, 
   {{0x5466006f,0x20510040,0xec8d00cf,0x00000000}},	//   _بازمير_, _בדרגת_, _hindeemu_, --, 
   {{0xfe3803b9,0x92d90065,0x89f500a4,0xdaf500d8}},	//   _saraqata, _orten_, _aparegud, _aparegut, 
   {{0x52fa02ea,0x5d580019,0x00000000,0x00000000}},	//   _bacheca_, _айлардын_, --, --, 
   {{0xf2f501a2,0xd6c802f6,0x42de021c,0xe94a03b2}},	//   _valodā_, _kinakabi, _stimuluj, _tectonic_, 
   {{0x63f40608,0x32b40321,0xc889025b,0x3fd801d5}},	//   _portos_, _mojca_, _frakland, _جوناتھن_, 
   {{0x4f3f000c,0x691f038a,0xb099005b,0xe9400126}},	//   _bgcolour_, _cambiaku, _auのwimax_, _firmaatt, 
   {{0xba05026a,0xc4a4040e,0x24bf00e6,0x60e801e8}},	//   _kurabuit, _bomstasj, _今日宏观经济要闻_, _maganyak_, 
   {{0x6c12023b,0x464200fb,0x6bff02f7,0x00000000}},	//   _elepani_, _ekholelw, _ikhudits, --, 
   {{0x724a04f2,0x291203a1,0x0a11013c,0xb3c50045}},	//   _hesman_, _достига_, _klubunda_, _турниру_, 
   {{0x627f0101,0xff2601d7,0x12eb0220,0x24800046}},	// [20f0] _spune_, _mantegna, _impiego_, _جانۇۇعا_, 
   {{0x52d7008d,0x737803a2,0x3c52023b,0x104300c5}},	//   _ayollar_, _zadania_, _okatoba_, _affichez_, 
   {{0x17d302da,0xa9960099,0xa25a00e0,0xc3560020}},	//   _доплата_, _akakanda_, _einlik_, _luafata_, 
   {{0x8a1d00c4,0xa26c0026,0x8f23036e,0xde23036e}},	//   _ڀينرون_, _schoon_, _anqusara, _anqusarq, 
   {{0xeade0049,0x43d50321,0xd339018d,0x16d1010d}},	//   _huatolit, _ureditev_, _ዝወስደሉ_, _गिरिश_, 
   {{0x2b6f0250,0xda01033a,0xa7e7038e,0x004500fa}},	//   _momentin_, _trasfigu, _सुपर्ब_, _papuntan, 
   {{0x9a6f03ae,0x22480176,0x435f00bc,0xb3860159}},	//   _tilleggs, _ryoma_, _anggawe_, _tvoros_, 
   {{0x1c2d0054,0xc2000499,0xbea10192,0xb04c00aa}},	//   _masallac, _taliga_, _인권단체연석회의_, _aparaton, 
   {{0x8c680072,0xf37b0249,0xc02a0037,0x98db0092}},	//   _yakushi_, _manajem_, _ጂዎግራፊ_, _banebryd, 
   {{0x026c0130,0xf34100c9,0xe213011d,0x323003da}},	//   _redon_, _pokezoo_, _inchis_, _shemaya_, 
   {{0x064200f3,0x0699011d,0x4d640255,0x6de30109}},	//   _akholelw, _некларэ_, _उद्वीप्त_, _projekce_, 
   {{0xb2e80006,0x6394028d,0x0b6f01f1,0x401b029e}},	//   _baginya_, _komsa_, _komentin_, _balearez_, 
   {{0xb31705c9,0x33490179,0x720c0206,0x82d5011b}},	//   _concile_, _bukemav_, _užite_, _batonda_, 
   {{0x12f8008b,0xf2b803da,0x12ef023a,0x00000000}},	//   _andarnax_, _zubeghị_, _trendov_, --, 
   {{0xac230025,0x93730206,0x7aa30137,0x9de20061}},	//   _सुरेश्वर, _sedacie_, _bilkuran_, _한나라당은_, 
   {{0x348c0192,0xcee20052,0xf200003a,0xe27f02f8}},	//   _예정입니다_, _स्त्रीला, _zalida_, _moenau_, 
   {{0x93950103,0xd8fd0255,0x12c50333,0xa28d0046}},	// [2100] _ajason_, _samamood, _ballate_, _maquinàr, 
   {{0x9364002a,0xe1dc00db,0x79f9000d,0x3c620014}},	//   _murukwuọ_, _miinimum, _meeskond, _letrave_, 
   {{0xb22c04dc,0x82ef01eb,0x43870428,0x1879030d}},	//   _قیبله_, _anhinga_, _dobrem_, _bilinird, 
   {{0x52bc00bc,0x7a0400f5,0xbc2e019c,0x95390322}},	//   _jendral_, _беденими, _mọgbọnwa_, _babisaby, 
   {{0x1a330177,0x1e9003ae,0xbefe050a,0x00000000}},	//   _angakuér, _permalen, _salatalı, --, 
   {{0xf9ce0117,0xf3940113,0xe3820208,0x00000000}},	//   _indepede, _domsa_, _قاقله_, --, 
   {{0xc2950012,0x818c0444,0x00000000,0x00000000}},	//   _probleem, _трофимов_, --, --, 
   {{0xa27c018d,0xf6d901ac,0x7d6f02a4,0xe52003b4}},	//   _ድኽመታትን_, _ميرسي_, _committa, _chandich, 
   {{0xd26c0117,0xdb4b0278,0x02d803e0,0x00000000}},	//   _aedol_, _bertaqwa_, _geleed_, --, 
   {{0xe2900230,0x8f450216,0xcb26005d,0xd9820061}},	//   _lamas_, _entsomba, _ijudaísm, _마이리스트에_, 
   {{0xbf1d01e6,0xa287029b,0xc844013b,0x62da0279}},	//   _nafukova, _fenkkee_, _inagurar_, _saveur_, 
   {{0xd3000082,0x029001ef,0x24d601c1,0xc2240116}},	//   _malamai_, _namas_, _निकिता_, _chokit_, 
   {{0xbbe8028a,0xa434005e,0x6e9f01e7,0x28c5001c}},	//   _motomoto_, _ﻧﯧﻔﯩﺖ_, _gestemmt_, _nadepend, 
   {{0xad2f01f1,0x42390244,0x1e3302f8,0x00000000}},	//   _arsimore_, _дотук_, _tengaima, --, 
   {{0xcffb029b,0x924a0189,0x03300188,0x59da0239}},	//   _jakkarlo, _resmin_, _бензинро_, _tiketike, 
   {{0xd37b0414,0x1e9f047d,0xa59002e0,0x128b0082}},	//   _saleté_, _bestemmt_, _bonetesh, _muharram, 
   {{0x431602fe,0x629002ce,0x65170148,0xc2950285}},	// [2110] _ndiza_, _camat_, _consulto_, _bavandim, 
   {{0xc5a3016f,0x5e080050,0x5e9700c5,0x00000000}},	//   _tilstrek, _ngadagoa, _vendeurs_, --, 
   {{0xc1eb014f,0xfc180265,0xd30c0476,0x98fb0028}},	//   _европе_, _verander, _dynamos_, _aflagaad, 
   {{0xff3c0053,0xbd6001e0,0x42e80261,0x2561015e}},	//   _perusaha, _باسیان_, _militon_, _кейиштүү_, 
   {{0x0abd01b8,0xf4860178,0xbb7b012a,0x127a0207}},	//   _likvidee, _बीजानि_, _podopiec, _pilipili_, 
   {{0x33800004,0x173003ce,0x4260025f,0xaf840159}},	//   _bourad_, _میزاجی_, _makomami_, _miniatiū, 
   {{0xc9e300a1,0xc27f0176,0x0e1c00d9,0x91660040}},	//   _tokomaha_, _spunk_, _pakettia, _גידולי_, 
   {{0xc3f80091,0xdc070461,0xc2900332,0x841d0085}},	//   _akhut_, _apareiss, _jamas_, _vavakoso_, 
   {{0xc8ed0088,0x020200f7,0x92d801fc,0xee4401c5}},	//   _experièn, _citita_, _ikkel_, _ambabaxa, 
   {{0xcbfc02d0,0xf1250156,0x00000000,0x00000000}},	//   _majestic, _ינדוסטרי, --, --, 
   {{0x43a901c5,0xf29002bc,0x12a80292,0x8d120322}},	//   _پٲغام_, _namar_, _yayaayaw_, _arirahir, 
   {{0xc2a601ea,0xfea301aa,0x50aa008f,0xeda200e6}},	//   _автоҳало, _upplemen, _केहुना_, _辖市区人才工作新, 
   {{0xe2d80206,0x827f0182,0x825003a2,0x2646026f}},	//   _chcem_, _apuni_, _सीनेटर_, _داۋدىڭ_, 
   {{0xe2130338,0x59c1002f,0x0e7700df,0x547301d2}},	//   _dichas_, _deletere, _demandée_, _iglesiak, 
   {{0x62900074,0x09950103,0x72020007,0x72880109}},	//   _samat_, _akakunga_, _kitisa_, _spustily_, 
   {{0xcade01b9,0x89a30148,0xaf5702f7,0x5c320562}},	//   _britalit, _地震發生後_, _bolailen, _iyibarir, 
   {{0xd27e0007,0xf4b300ff,0x9c590039,0x02ab034d}},	// [2120] _baindo_, _גאַבי_, _gastuak_, _rendang_, 
   {{0x12d800b6,0x836403db,0x930d022c,0x1baf011e}},	//   _akkel_, _abagula_, _dibales_, _enkyetan_, 
   {{0x026c0461,0x62ca018d,0xde960089,0xf4780041}},	//   _medoc_, _ንምርድኡ_, _azakları, _харадҵар, 
   {{0x220001c2,0x426c0206,0x728c0289,0x9eaf00ea}},	//   _galiza_, _celom_, _adakana_, _fokontan, 
   {{0x698302cf,0xd2d90155,0xbd7b0139,0x17e20022}},	//   _модерна_, _orter_, _avamanya, _декабрҙә, 
   {{0xc06a01e8,0x00f001b4,0x9def0524,0xcb890311}},	//   _adapalen, _gemaklik_, _vrednova, _ዝኸፈለሉ_, 
   {{0x072a0137,0x48780595,0x6e9c00a8,0xf7cc006c}},	//   _байлгүйд, _आजैदेखि_, _adimmain, _asethekw, 
   {{0x79fa01fe,0xa20000bc,0xa2900013,0xbb4d01ac}},	//   _tatawase, _dadiya_, _xamas_, _slavacha_, 
   {{0x620201df,0x6f480307,0x821c0278,0x38370022}},	//   _adrift_, _bangayin, _atthos_, _ҡуяһың_, 
   {{0x6ffc011c,0xab180032,0x4b67017a,0xe90c0153}},	//   _barkeelo, _cubangan_, _далеле_, _コルビュジエ_, 
   {{0xcaa800a2,0x36080421,0x9d0c00da,0xfdaa00de}},	//   _نياپو_, _vermutli, _ingrijor, _emsintsa, 
   {{0x07020139,0x7aef0342,0xf2fd0456,0xf4a602cf}},	//   _वर्णग्रह, _padonnen_, _selipar_, _авантури, 
   {{0x93f9001d,0x4b1b03ea,0xc2020099,0xc21c03e5}},	//   _esque_, _remplace, _aitira_, _washoe_, 
   {{0x5290008f,0x520002ec,0x32d80009,0x95f1003c}},	//   _samas_, _kaliya_, _telesu_, _alamatsi, 
   {{0xaf760276,0xf2d90424,0x93870139,0x7ed500c0}},	//   _инглизчә_, _astea_, _amarā_, _matindin, 
   {{0x93870662,0xcc5500ac,0xc200017f,0xfede00bc}},	//   _ayuru_, _pratite_, _amiilu_, _brahalan, 
   {{0x0301032e,0x4d38018d,0xa23102fe,0x02b103a4}},	// [2130] _pitampi_, _ክትወድቕ_, _اخیری_, _hondina_, 
   {{0xb5e9013c,0x2c5503ee,0x82960297,0xfea304a8}},	//   _yararsız_, _vratite_, _basuçıla, _zaplijen, 
   {{0x1200004a,0x22fc024c,0x32d901c2,0xdd050107}},	//   _galiya_, _metadati_, _estea_, _inframer, 
   {{0xc20100d3,0x1a17015e,0x9f0f0044,0x2ee0014f}},	//   _emailu_, _descobre, _specials_, _рекли_, 
   {{0x42900119,0x92a002ac,0x069b0390,0x3a8d01d5}},	//   _samar_, _الأئمة_, _antiazər, _kinyitot, 
   {{0xa4900050,0x5df900b9,0x385a0040,0x339402a0}},	//   _ngagunak, _शर्मिला_, _bedrooms_, _ilese_, 
   {{0x4290005a,0x5f6301c8,0x9c0a030a,0x0e3d0390}},	//   _damaq_, _mimozemš, _cumpran_, _astroloq, 
   {{0x1c6d04ac,0xc66d0063,0x24860420,0xc76d0269}},	//   _постоянн, _سلاسل_, _имено_, _convirti, 
   {{0x7239025f,0x3dc80013,0x147b028b,0x10570119}},	//   _akumaki_, _پغانه_, _икалам_, _gagamito, 
   {{0x22b200e9,0x458d01ac,0x111900b9,0x00000000}},	//   _kondann_, _daingneá, _berjodoh_, --, 
   {{0x47bb04d8,0x4f780147,0xbd2a0064,0x6af900e5}},	//   _gumeesig, _جەتشىنچە_, _arribant_, _faturame, 
   {{0xa2900249,0x9383019b,0xe2d900f2,0x30190126}},	//   _kamap_, _sutrikim, _mutes_, _боксу_, 
   {{0xf73b0145,0x12d8021b,0xda3e0297,0xcb9000cb}},	//   _акуляры_, _pakeni_, _garizası_, _asinjalo_, 
   {{0x85000028,0xf838033e,0x3201023e,0x14ad02c3}},	//   _ballaadh, _думазаро, _asyir_, _legálne_, 
   {{0x82d90166,0x0b2c0192,0xcc600082,0xb39402c9}},	//   _gutes_, _찾아오시는_, _dakunan_, _alese_, 
   {{0xc3940197,0x52f20209,0x004504eb,0xeea60497}},	//   _blese_, _ammillu_, _आउटलेट_, _angloman, 
   {{0x82d9005b,0xa2d9012c,0xac5c00c8,0xb5eb012e}},	// [2140] _artek_, _kagera_, _bootril_, _agresszí, 
   {{0xb2c001cd,0x427f01c5,0xd27e0288,0x4a4e0184}},	//   _андар_, _maanso_, _tsinin_, _bihereza_, 
   {{0x535b02cb,0x1ebc0128,0xbe1b0113,0xc3fa00e6}},	//   _najgora_, _advokatn, _halgarta, _占查处价格举报案, 
   {{0x726e0265,0x520000d2,0xfbb602eb,0x522400e1}},	//   _stroom_, _jadina_, _стрессий, _diokhe_, 
   {{0x18b70071,0xd291013d,0x2fec0092,0x12b50017}},	//   _نامحدود_, _arbaro_, _の商品となります_, _herce_, 
   {{0x896d00cb,0xf61b0205,0x32ab038e,0xb224019f}},	//   _akanalut, _muttasil_, _gendong_, _alikua_, 
   {{0xa380007a,0x6d8800bd,0x83ea0257,0xdb4c03b8}},	//   _umurmu_, _defeatit_, _beltin_, _хақназар_, 
   {{0xb9800101,0xf2d80481,0x04970227,0xe6ba027f}},	//   _echipame, _beleid_, _menakutk, _biragisi, 
   {{0x12d900f9,0xa476014f,0xc3d5035b,0x166f003c}},	//   _bagera_, _процеса_, _sredstev_, _دوقلوی_, 
   {{0x226c04e7,0xcd4e0203,0xc6b2033f,0x08790260}},	//   _celok_, _elaborad_, _kaafakaf, _tempadas_, 
   {{0xd2d90247,0x1ec70396,0x7a5e00bb,0x998200cb}},	//   _muter_, _attitudn, _کےبجائےن, _amakhora_, 
   {{0xbe280060,0xb290004f,0x5e9f0166,0x3b590147}},	//   _كەلدىڭىز_, _samay_, _bestimmt_, _جىلچىقتا, 
   {{0x5d8f02a2,0x72bf014a,0xd9a4045f,0x28a400f2}},	//   _kailanga, _لمحات_, _miljarde, _miljardu, 
   {{0xb20000ea,0x5262054a,0x72d90166,0xbf470024}},	//   _lalina_, _istoriji_, _guter_, _ভাওনাৰ_, 
   {{0x4d5f05a2,0xf46902ac,0x00000000,0x00000000}},	//   _वीरभद्र_, _مباركه_, --, --, 
   {{0xec070223,0xb3a90262,0x12d90005,0xc71201f2}},	//   _oneshot_, _янында_, _auter_, _достиға_, 
   {{0x700d03e8,0x899b00ac,0x00000000,0x00000000}},	// [2150] _življenj, _najniža_, --, --, 
   {{0x70f70106,0x8c710139,0xa24b004d,0x1d0701da}},	//   _मद्रास_, _मार्च्_, _權釋設計小老師_, _diellore_, 
   {{0xc84705aa,0x33a20122,0x22eb019d,0x62da02ba}},	//   _rollemod, _kripik_, _ampingo_, _agwema_, 
   {{0x19f60562,0x78670658,0x028d005b,0xa8b700de}},	//   _agashuru, _sensores_, _ayukawa_, _کلینټڼ_, 
   {{0x3e380255,0x136c00b4,0x69cb0025,0x1200019b}},	//   _kanalisa, _droguri_, _ज्योतिषि_, _vadina_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2b8202ec,0xa25a0294,0xf29e014f,0x2fc90185}},	//   _مۅکلُن_, _ashla_, _низак_, _cäühärlä, 
   {{0x794600ff,0x33000119,0x2b6701b8,0x226c0115}},	//   _טשעפטער_, _dadayaw_, _जियनी_, _selok_, 
   {{0xe05501bd,0x44b20052,0xfdb20156,0x0571029c}},	//   _اتاۋىنىڭ_, _सत्यताहर, _זימערמאן_, _idatuluk, 
   {{0x12d902a4,0x5a5f01a4,0x793002d4,0x8b8a016d}},	//   _putes_, _basekaka_, _execuziu, _таранчил, 
   {{0x12000043,0xc25a0241,0xa2dc0045,0x81f2006c}},	//   _balina_, _boolli_, _posetili_, _агарчанд_, 
   {{0xec19002c,0x520103e6,0x3d050345,0x09b90139}},	//   _gainditu_, _dreien_, _exelente_, _candraya_, 
   {{0xedbc024f,0xd2a60177,0xfa4f03c8,0x83800193}},	//   _matabete_, _аланарҵә, _jaketnya_, _umurku_, 
   {{0xbe3801d7,0xf2920286,0x72010415,0xa711009a}},	//   _canalisa, _aguadi_, _freien_, _ننوزه_, 
   {{0xaa9202fe,0xc34000d8,0xf20000d2,0x2dbb01ff}},	//   _محافظه_, _gardias_, _tadina_, _valentín, 
   {{0xbc65039f,0x04a901bb,0xf24a00ba,0xe00b0059}},	//   _contact_, _салынярм, _سرۆشتی_, _описа_, 
   {{0x230d00a4,0xda7a0583,0xf0410244,0x0ec8019d}},	// [2160] _cavalls_, _zračni_, _acquiren, _atsibwen, 
   {{0xc20101d9,0xd2a602ae,0x85710289,0x4c5e00c5}},	//   _kreien_, _seljaci_, _adatuluk, _蛮儿初遇天赐_, 
   {{0xa6d5001d,0x32fc012a,0x322602f3,0x9bcc018e}},	//   _descriti, _uwagi_, _kyrkan_, _dzivamus, 
   {{0xf39400a5,0x7c5c0359,0xf01202ec,0x60a00335}},	//   _toese_, _bestean_, _پھسہِ_, _ahaṣṭasa, 
   {{0xf775010d,0x3e560238,0x337a02af,0xc2240256}},	//   _संभाजीरा, _частин_, _ataranam, _slikta_, 
   {{0x239401e6,0xe95d0225,0x178800ba,0x620001c5}},	//   _blesk_, _hatohobe, _ئوزوون_, _walina_, 
   {{0xe2ea0428,0xb67b0008,0x2586005a,0x8c9100ee}},	//   _varnost_, _بىرەلە_, _dibeqmoh, _амидрала, 
   {{0x72000077,0x565200bc,0x06b6020b,0xfc6803f3}},	//   _apaid_, _فعالیتها_, _bulegelw, _beurzen_, 
   {{0x9e7c0287,0x3dfc00c1,0x2133023a,0xb4360465}},	//   _बिम्ब_, _kelelawa, _reflexné_, _mehansko_, 
   {{0x5ee30210,0x225a0242,0xa5e9055f,0x4379016b}},	//   _akakuten, _minlik_, _tarafsız_, _hadafin_, 
   {{0x127f00ac,0x877d00be,0x54e200be,0x8c60003c}},	//   _neznam_, _الىزا_, _بىلبەيىت_, _bakulan_, 
   {{0xb3cf0273,0xad2d0092,0xcbee00af,0x943105f7}},	//   _llevar_, _デジタルコンテン, _шаром_, _cwlcymro_, 
   {{0x2c48014f,0xf30f0102,0x6d180153,0xaa7c01ad}},	//   _петром_, _pambano_, _いずれにせよ_, _motavita_, 
   {{0x37b7016d,0xe6f800bf,0x325f01ed,0x52e9005a}},	//   _ئاخشام_, _предшест, _kumuolel, _dawivha_, 
   {{0x32000118,0x727a000b,0xdc5c0553,0xae0102fd}},	//   _talina_, _silisili_, _neptún_, _meidigea, 
   {{0x62d902e9,0x15a2009a,0x85e30213,0x924801ec}},	//   _usted_, _asisokuz, _джулиан_, _ayomi_, 
   {{0x7c070175,0xaad603c2,0x62bb055d,0x2d07013d}},	// [2170] _restoras, _creditab, _saudari_, _restorac, 
   {{0x65fc0434,0x00000000,0x00000000,0x00000000}},	//   _recepció, --, --, --, 
   {{0xa3ea01f8,0x9870052e,0x53d80056,0x62130359}},	//   _imitwe_, _quandocu, _боадолат_, _rychje_, 
   {{0x43cf040e,0x75c80220,0xfc9e0040,0xf3870155}},	//   _elevar_, _предимст, _סודיות_, _segrar_, 
   {{0x99b2001a,0x996e0166,0x9b070178,0x2306011a}},	//   _انتظامیہ_, _donnerst, _बहुभिः_, _imposing_, 
   {{0xd34804ad,0xa2a7022f,0xc6e20441,0xb2c20126}},	//   _bafenyi_, _народаў_, _provozní, _платника_, 
   {{0xf2d900a7,0xf7270163,0xc9fc0055,0xda36002b}},	//   _estem_, _کریسی_, _abbastat, _ভূমিতে_, 
   {{0x830501e0,0xf2900231,0x6e9b026e,0xbf490052}},	//   _فورات_, _donare_, _उल्लेख्य_, _जसमध्ये_, 
   {{0xc20001b4,0xec1d05fb,0x00000000,0x00000000}},	//   _madiba_, _neprikos, --, --, 
   {{0x43800148,0xf61a01c5,0x80b5015e,0xb3f300e6}},	//   _terram_, _گرفتارس_, _تىزىمىند, _胶南市水利局_, 
   {{0xf3940170,0x466e01b9,0x0b2400f3,0x89fe0086}},	//   _alesi_, _konversy, _bempahla_, _megalkot, 
   {{0xd7200040,0xedc500ee,0x1efe016e,0x039402f9}},	//   _במזומן_, _baliteke_, _kalabalı, _blesi_, 
   {{0x42d80372,0x61330287,0x8b2f035b,0x203d00c1}},	//   _deledu_, _reflexní_, _naravnos, _दरमहा_, 
   {{0x3f130124,0x0e7a00e6,0x73940243,0x4d06008c}},	//   _leithira, _影音娱乐意见反馈, _maksam_, _currider, 
   {{0x023f05f3,0x2c6101bc,0x02d902c3,0xfc84003c}},	//   _célula_, _bedrige_, _istej_, _نظرماهنا, 
   {{0xf3860371,0x439401b9,0x389802a8,0x61270045}},	//   _avere_, _flesi_, _brawżer_, _законик_, 
   {{0x91e8005b,0x06580382,0xe25b00bc,0xf21204bd}},	// [2180] _kagoshim, _etikweni, _asalè_, _unahi_, 
   {{0xf27e02f2,0xae6d023a,0x00000000,0x00000000}},	//   _opinan_, _abecedne_, --, --, 
   {{0x81cc00f2,0x9a5a0484,0x00000000,0x00000000}},	//   _finansēš, _मधुसुदन_, --, --, 
   {{0x2b1a0037,0xe39400e9,0xa2120339,0x82ef0108}},	//   _በማረሚያ_, _komsi_, _kiaha_, _dalilna_, 
   {{0x8dbf026c,0x976d0255,0xe12b0024,0x895001c8}},	//   _台北旅遊飯店住宿, _धन्धा_, _কেৰিয়াৰ_, _nedoplat, 
   {{0x45f801b1,0x833b0587,0x3d570041,0x819e0039}},	//   _सुशोभित_, _canadà_, _далгеит_, _томилгоо, 
   {{0x3c9601e0,0x4c760139,0xc30e00e6,0xc38a01a7}},	//   _دانلۆدی_, _निम्नं_, _tirages_, _хромиров, 
   {{0xca310177,0x841600a4,0x929002e2,0xc2ab010d}},	//   _бџьаршьҭ, _تاقمازا_, _abeam_, _nendang_, 
   {{0xa6af052f,0x57f9006c,0xcc060224,0x00000000}},	//   _wokuleth, _баландиҳ, _bærust_, --, 
   {{0xad440211,0xb96402a9,0x831204ca,0xa99f01cd}},	//   _уникальн, _мудрая_, _bombons_, _abakhala_, 
   {{0x95050299,0xd7b50075,0x92ab00d2,0xbffe0128}},	//   _буддист_, _raksturi, _kendang_, _газетани_, 
   {{0x01ae0122,0x7e000027,0x1ecc020e,0x65a90274}},	//   _کمالی_, _matemata, _коньякта, _vellíðan_, 
   {{0xa1c80420,0x3c5a0258,0x34470022,0x48fd056b}},	//   _востание_, _hartoch_, _китапх_, _betapapu, 
   {{0xc6af01cb,0x6c650066,0xf08001dc,0xe2c50016}},	//   _yokuleth, _hautatu_, _dübendor, _aliloke_, 
   {{0x42d800dd,0xa380024a,0xea7e036c,0xc2fc0014}},	//   _teledu_, _aburú_, _novambra_, _gabimet_, 
   {{0x52ab0402,0x31c6003b,0x12d90138,0xafe4005a}},	//   _gendang_, _alamakom, _istek_, _jiriqcho, 
   {{0x5c4b0269,0xa9e20403,0x4da602d9,0xf3790046}},	// [2190] _desconoc, _ankolaka_, _musumusu_, _ratafia_, 
   {{0x021c0087,0x728d014a,0xf66c0040,0x836a0361}},	//   _mather_, _joghurt_, _ההשוואה_, _гимназин, 
   {{0xecd60039,0x5ce6010f,0x148f00bf,0x4a0d0028}},	//   _задрал_, _биёянд_, _обновите_, _labaduba_, 
   {{0xf84700cb,0xbc13001d,0xb7a80120,0xa2ce01b2}},	//   _задании_, _disposi_, _caamiyik_, _exclaim_, 
   {{0xf5410029,0x8c5c01b4,0x20ec004f,0xa146046f}},	//   _لیزاده_, _gestaan_, _budiwaal, _amnevill, 
   {{0x020201f7,0xeaa60023,0x2f650087,0x9d950179}},	//   _antica_, _прочее_, _ebibelen, _numavöd_, 
   {{0x9e87013b,0x155a01bd,0x6a9c01a0,0x04a20144}},	//   _kroměříž_, _ұжымы_, _komitins, _garáistí_, 
   {{0x3c5c02c2,0xad5f0044,0xd2ab022c,0x29d40025}},	//   _bestaan_, _תמשיך_, _gending_, _सर्वाधार, 
   {{0x203500c5,0x4e1b01f9,0xc3160102,0x1c00036e}},	//   _推荐给好友_, _balencha, _ndizi_, _efesios_, 
   {{0x0e3b0462,0x1dbb025e,0x2b130074,0x97de021c}},	//   _ogrampra, _palestín, _ilmainen_, _nebankov, 
   {{0x339501ba,0xd65e017a,0x821c02ee,0x64860142}},	//   _adusi_, _зимма_, _eather_, _युवाम्_, 
   {{0x72fb0250,0xcfbe02ed,0x0d2f00e6,0x0bf8002e}},	//   _dashura_, _abondoso, _省食品药品监督管, _viđenja_, 
   {{0x894d0035,0x00000000,0x00000000,0x00000000}},	//   _ашуын_, --, --, --, 
   {{0x2a390088,0x4a390368,0x0b170244,0x11600158}},	//   _береби_, _беседи_, _разделя_, _paliwowy_, 
   {{0xd27a00a5,0x7ad501b6,0xe3eb0271,0x525b0117}},	//   _filifili_, _restrict, _kjetil_, _skelim_, 
   {{0x5d1703ad,0x63940189,0x7c26038b,0x9b810111}},	//   _konsular, _taksim_, _kehancur, _scontrar, 
   {{0x89960272,0x7bb2017a,0xdb180147,0x53940397}},	// [21a0] _akakonda_, _abazazis, _حوپكىنس_, _aleso_, 
   {{0xa2000015,0x9fa0019b,0x8ac10113,0xbc4702d4}},	//   _waliba_, _reklamuo, _تنادي_, _dischocc, 
   {{0x406c01a3,0x58d30244,0x39e90310,0xb67f035d}},	//   _بيخودي_, _подаде_, _dhorchad, _pomenuti, 
   {{0x43780054,0x29cd00be,0xe2fc0499,0xc23e03b0}},	//   _malamin_, _اۋتومات_, _itaga_, _følgja_, 
   {{0x95f20047,0x22fc0518,0xf3250235,0x23a80151}},	//   _获取免费代码_, _atigi_, _atsyāmi_, _annalong_, 
   {{0x430000fe,0xdbd70698,0x7ae70169,0xe520029c}},	//   _talamai_, _ntumbero_, _বিকালে_, _akandich, 
   {{0x82c301e5,0x2a3e00c8,0x42230095,0x629201a6}},	//   _ailootọ_, _әсәҙулли, _تدارج_, _kauati_, 
   {{0x2be500d6,0x00000000,0x00000000,0x00000000}},	//   _paidreac, --, --, --, 
   {{0x1f5200b3,0xef58009b,0x226c043a,0x4b2f00e5}},	//   _бельгияд, _нефтийн_, _kelos_, _основите_, 
   {{0xb395057f,0x42fc00dc,0x42f1054c,0xeab601b3}},	//   _meuse_, _otaga_, _høgmo_, _капусти_, 
   {{0x4d1203be,0x4fa4019a,0x0502012f,0xa3000240}},	//   _ararahir, _kilmarno, _tsitsino_, _lalakai_, 
   {{0x9156048a,0x42f00242,0x3b910119,0xfdd00126}},	//   _басына_, _temirli_, _dominggo_, _острові_, 
   {{0x62fc03fd,0x92ee0230,0x8a710010,0xc2d901b2}},	//   _ataga_, _inifye_, _awuligub, _dwindle_, 
   {{0x42900089,0x32da0138,0x09830220,0x54e2002b}},	//   _kamaz_, _liseli_, _генерира, _নিমাই_, 
   {{0x080401ad,0x7c2d00a4,0x8e3c0147,0x45e9019b}},	//   _nièvre_, _esportiu_, _تئيئشسىڭ_, _падабаец, 
   {{0x04070285,0xf27e02cf,0x7a1e0475,0xc2da02b1}},	//   _ruzinduk, _saindo_, _финик_, _dawowar_, 
   {{0xf3f80591,0x626c022c,0xa4a40156,0x2ce70244}},	// [21b0] _bomull_, _kedok_, _נעווזלין_, _решаване_, 
   {{0xb3000165,0x2395030a,0xa3ee00ee,0x00000000}},	//   _malakai_, _deuse_, _динза_, --, 
   {{0x438604b9,0x56580387,0xe364006f,0x339505b3}},	//   _exert_, _etinyekw, _مھندار_, _eeuse_, 
   {{0x5e0301aa,0x89ce05bd,0x13940249,0x38ce017d}},	//   _interpra, _videreut, _olesm_, _videreud, 
   {{0x9ac801ea,0x329002f6,0x195301bd,0x149e0192}},	//   _маслаҳат, _kamay_, _сырын_, _업그레이드_, 
   {{0x5ef301c9,0xbfae02ba,0x880402a6,0x79bf00bb}},	//   _अधिका_, _макка_, _fièvre_, _بیکٹیریا_, 
   {{0x8ba6002c,0x00000000,0x00000000,0x00000000}},	//   _jakiteko_, --, --, --, 
   {{0x939501b4,0xb1b90276,0xea7300c8,0xaf2e0188}},	//   _keuse_, _берилсә_, _тхэквонд, _тифли_, 
   {{0xd38b0074,0x656d010f,0x2f9601af,0x089703cd}},	//   _станет_, _бармеояд_, _girdiler_, _हेरफेर_, 
   {{0xf29002e7,0xa3f8022a,0x7a17031c,0x85b903fd}},	//   _gamay_, _fiduin_, _descubre, _olopelek, 
   {{0xdeaf00b7,0x53960222,0x22da00ac,0xa2fc000b}},	//   _birligin, _abusif_, _kiseli_, _utaga_, 
   {{0x52d10109,0x9eae0466,0xf6d70372,0x72fc008d}},	//   _motorem_, _podržati_, _bregethw, _rtaga_, 
   {{0xfef0003e,0xc31a01d5,0x00000000,0x00000000}},	//   _balkonin, _józan_, --, --, 
   {{0x32d90228,0xe628033e,0x914002d3,0x3290000b}},	//   _urter_, _ahecháma_, _верба_, _osiana_, 
   {{0x12d704ca,0x42d80107,0xc290004f,0x146f039e}},	//   _evoluar_, _mudeng_, _damay_, _lydeffek, 
   {{0x2270024d,0x826c0338,0x00000000,0x00000000}},	//   _elungeni_, _belor_, --, --, 
   {{0x926c00b4,0x726c00e5,0x0eb8019b,0xc00b022f}},	// [21c0] _celor_, _pelos_, _rekordin, _эпосе_, 
   {{0x3ee7032e,0x3ead045e,0x8e400699,0x5b7e00d3}},	//   _luphiwin, _средната_, _harabaye_, _beruška_, 
   {{0x0d0f00e6,0xe06d0148,0x00000000,0x00000000}},	//   _新型共聚乙烯防腐, _properan, --, --, 
   {{0xfb4a030b,0x82a7006c,0xd70800d9,0xdf31000d}},	//   _abatubwa_, _сабоҳат_, _brittilä, _roosteva, 
   {{0xf202036c,0x520001fb,0x2c7c003c,0x72880156}},	//   _entina_, _oblida_, _awasana_, _װעמענס_, 
   {{0xdf070360,0x43a300d0,0x620f0237,0x2c61029b}},	//   _कृष्णहरी_, _булангаа_, _고객님들께_, _masumaa_, 
   {{0x2316029c,0x3fb001f2,0x4adc04d1,0x8d6d00f7}},	//   _ndizo_, _ﺋﻮﺭﺗﺎﻕ_, _descoñec, _חיותו_, 
   {{0x320203b9,0x0bfc01bd,0x834000ae,0xf2bc02fd}},	//   _intina_, _аспектіл, _cogenda_, _iordain_, 
   {{0x7d9b028e,0x529003d9,0x17c200c4,0x62ef0049}},	//   _komunitu_, _asiana_, _ڪمپوزنگ_, _maliana_, 
   {{0xa290010b,0xce3600fe,0xb2a20156,0x49dc0127}},	//   _monate_, _fikaulua, _געפּײַני, _direizhe, 
   {{0x42d90163,0x10c702f3,0x60d2025f,0xae8d002b}},	//   _isten_, _redaktör_, _bakotiol, _ইয়াসমিন_, 
   {{0x597800db,0x438600ec,0xeeb70378,0x9de7021c}},	//   _valimist, _svoris_, _autotekn, _bylinné_, 
   {{0x6e39044a,0xe1c2014a,0xcb030420,0x22bc02fd}},	//   _bafalisa, _mentünk_, _болеше_, _lordain_, 
   {{0xcb030388,0x712d014f,0x6daa036e,0x95c20234}},	//   _пореден_, _напредак_, _chinchip, _níwọ̀n_, 
   {{0xa29001a6,0x42ab0304,0x92e1046b,0x00000000}},	//   _apiata_, _bendung_, _godidog_, --, 
   {{0x59dd0166,0xcb6d01f4,0x72dd00ab,0x00000000}},	//   _lizenzie, _саркарда_, _poroaki_, --, 
   {{0xf2e5020a,0xa2da00f1,0xd77c00de,0x13a800d7}},	// [21d0] _ءبىرى_, _anseki_, _awayenaw, _lekaleng_, 
   {{0x53f8033b,0xc3400454,0x12900044,0xfc700397}},	//   _bahumi_, _wogenda_, _donate_, _agasele_, 
   {{0xae64069a,0x36430024,0xb70d0061,0x73160039}},	//   _सूर्यवंश, _দ্ৰাঘিমা, _디아스포라_, _arkaitz_, 
   {{0x76bf0145,0xe78d04e5,0xecbc03b2,0x00000000}},	//   _удалося_, _awawaabi, _revamped_, --, 
   {{0x623a002a,0xc857014e,0x10c70046,0x27e60012}},	//   _abamuru_, _културно, _пландары, _बिचरले_, 
   {{0x2c6e0144,0x2d3a023e,0xf27e0312,0xf6c30184}},	//   _achrann_, _caritane_, _fonnus_, _nkurariy, 
   {{0x563f04bf,0x04120071,0x430e0044,0xe9c900dd}},	//   _poginuli, _احمقانه_, _phrases_, _beddgele, 
   {{0x695102d5,0x230d00d1,0x82900373,0x9ae705ab}},	//   _kvalitee, _অন্যথাই_, _konate_, _cuidados, 
   {{0x4f3e026b,0x6462004d,0x0f420040,0x8cf201ab}},	//   _estrella, _商品圖檔顏色因電, _נחמיאס_, _बंहेड़ु़, 
   {{0x49ce018b,0xd7a7021c,0x82d800dc,0xccf500da}},	//   _intelege, _zareagov, _mānava_, _protejar, 
   {{0x9e4002c1,0x672f00d3,0xc27e03ea,0x00000000}},	//   _yarabaye_, _karviná_, _connus_, --, 
   {{0xd8d203b6,0xdb7d0191,0x8a15021a,0xf53d0061}},	//   _alamọdaj, _kronober, _barbadde, _불가능하며_, 
   {{0xd2d900dc,0x2310002e,0xe19702ac,0x32020257}},	//   _asteo_, _poznatog_, _uasdátú_, _litina_, 
   {{0x2bd2051f,0x94d701e1,0xb2900200,0x81270185}},	//   _ڕۆژێک_, _сараның_, _isiala_, _валиева_, 
   {{0x53c50144,0x729002a5,0x286f00c5,0xe97500de}},	//   _comparái, _sklady_, _pompiers_, _ayincome, 
   {{0xbecf00f5,0xb35200d9,0x79c602c4,0x327f00be}},	//   _сүңклери, _postinum, _terapêut, _apunt_, 
   {{0x7a020198,0xab6f069b,0x00000000,0x00000000}},	// [21e0] _zdravega_, _sahutnya_, --, --, 
   {{0x320001d1,0xfcbf041e,0xa2b1037f,0xcc6e0204}},	//   _spain_, _lisandru_, _fonduna_, _saarela_, 
   {{0x1f1c00bc,0x64a70057,0xc0190258,0x12f001d4}},	//   _temulawa, _karnival_, _loadewyk_, _taliani_, 
   {{0x164a00fb,0x39d0028b,0xa95701af,0x998204d7}},	//   _abanesif, _бедиа_, _bilseler_, _dreifike, 
   {{0x121c0212,0xc3860476,0x930f0244,0x8e7301f6}},	//   _cathar_, _storrs_, _bambino_, _বনাওক_, 
   {{0x62480170,0x521c0194,0xb29001bb,0xca68030b}},	//   _nyomi_, _orthos_, _ahlaky_, _aligamba_, 
   {{0xe2de0134,0x34ed00d9,0xdc710100,0x56b80241}},	//   _idanimọ_, _подземны, _potragu_, _googilii, 
   {{0x92d90230,0xb24903f5,0xbeae0040,0x9e5700ef}},	//   _butey_, _exames_, _utilizin, _atyabeke_, 
   {{0x431d0111,0x3248005b,0xe26c0084,0x637f0244}},	//   _nascita_, _kyomi_, _afdol_, _rimanda_, 
   {{0xa3ea0138,0xc92901ef,0x2dbd02a5,0xa05c011a}},	//   _sahte_, _дональда_, _obraťte_, _urbanspo, 
   {{0x804c01ea,0x62570041,0xb861008d,0x30420361}},	//   _қурби_, _еицрыдыр, _bakalavr_, _султанов_, 
   {{0x1bab0125,0x12ba001d,0xf21c0245,0x803b0059}},	//   _акылына_, _bandsaw_, _pathar_, _станало_, 
   {{0x512d0093,0x62fa00ec,0xd3790373,0xdb4a02e0}},	//   _символов_, _vadovauj, _demando_, _dintshwa_, 
   {{0xe1530212,0x98a700ba,0x837a0183,0xe206031a}},	//   _chiefspl, _مولکی_, _entanin_, _lukiwski_, 
   {{0xb30d02ff,0xcf3e0206,0xb17900e7,0x5aa001d5}},	//   _danbala_, _najmladš, _aptichay_, _elemzésé, 
   {{0x120000c3,0x22fc03b6,0xd2df003f,0x9962013d}},	//   _veniam_, _itage_, _luyonlu_, _anoncant, 
   {{0xf6af024d,0x82ca0278,0xb9fc00ee,0x130a018c}},	// [21f0] _lokuleth, _takde_, _hasierea_, _kennelij, 
   {{0x57b300ff,0xce5b0079,0x852d00de,0x7641027f}},	//   _האוסט_, _dekoratī, _amanyath, _bariyami, 
   {{0x1202018e,0xe8de01b8,0x529501af,0x030d0064}},	//   _beriwe_, _फराटा_, _tematiki_, _escales_, 
   {{0xb9db03bf,0x77b3007d,0xe2970109,0x5a4f00c1}},	//   _съезда_, _ahlulbai, _fungován, _paketnya_, 
   {{0xb6c50003,0x39f90017,0xde7f015d,0x5e0700e6}},	//   _verschil_, _interní_, _घोषणाएं_, _智能模糊搜索_, 
   {{0x19d4002b,0xb301008a,0x517d0040,0xf65501ee}},	//   _বৌদ্ধধর্, _matagai_, _סילוק_, _пуçласа_, 
   {{0xd20005c9,0x3fc60207,0x21f80455,0xbc250077}},	//   _npaim_, _وفاداريء, _strictem, _bakoulou_, 
   {{0xcd1902e1,0xb4280244,0xa7ec0374,0x00000000}},	//   _cairdiac, _chiamano_, _қайрилиб_, --, 
   {{0x03f2042c,0x59f9018c,0x4c610155,0x585f008d}},	//   _modernog_, _capacite, _fastnar_, _tumanlar_, 
   {{0x7368022f,0x1b3900c7,0x2b190193,0xd273018f}},	//   _напрыкла, _больцман_, _keraguan_, _dutichdi_, 
   {{0xf87400a2,0x3a8b014d,0x3f7e003c,0x02da033e}},	//   _آبهوا_, _meinungs, _غیرطبیعی_, _jepeko_, 
   {{0x1ffe015e,0x1c2c0291,0xe2780042,0x64d80374}},	//   _подкасти, _بالاوراق_, _reuniu_, _яҳованин, 
   {{0xbc5a01c9,0x42ca00b9,0x03d703d4,0x00000000}},	//   _pakuvad_, _pakde_, _мембране_, --, 
   {{0xf2000272,0x5ecf069c,0x27d101c5,0x330e01f1}},	//   _hadija_, _viditeln, _گلستانس_, _tiranes_, 
   {{0xb20003d8,0x12ef00de,0x120003a0,0x8291019d}},	//   _radila_, _aljibra_, _gadima_, _dubayo_, 
   {{0xc41c0056,0xe0be01db,0xca5c0162,0x1a7d0136}},	//   _дуюми_, _бизнести_, _قاتىللىق_, _sanadera_, 
   {{0x8dd40163,0xc391038e,0x09f20299,0x2bd90035}},	// [2200] _technika, _berselim, _تەھدىتى_, _ватанынд, 
   {{0x140e02c1,0x99fd01b8,0xaa810035,0x7d6f01db}},	//   _ubugingo_, _varastat, _açıluga_, _تڭداۋ_, 
   {{0x4fb20071,0x5ca9010d,0x76180499,0x225a020e}},	//   _جداول_, _शिक्षकाच, _sailiili, _kelllo_, 
   {{0x83790244,0xfe8a0148,0x5d9001ea,0x7e3a0370}},	//   _catania_, _台北市立聯合醫院, _saylanga, _babasara, 
   {{0xb4b10076,0xe7a5000a,0x926d02cd,0x642f00e6}},	//   _descriçã, _amerlati, _ceton_, _国务院管理节能工, 
   {{0x92f0029c,0xa31d031c,0xc57d00d9,0xd25a018e}},	//   _ambiiri_, _afectan_, _комбинез, _kholwi_, 
   {{0x927a03c7,0x522b0014,0x5dad0061,0xe2fc021e}},	//   _zapisani_, _permend_, _소비자들의_, _stigs_, 
   {{0x36f40057,0x4cf6000a,0x68360257,0x39fd01b9}},	//   _መዋቅሮች_, _saattuar, _klárlega_, _parastat, 
   {{0x6200001e,0x14d90125,0xe6360439,0xed7b0307}},	//   _halima_, _ортарасы, _magondzw, _lwaminya, 
   {{0xd2d900ce,0xa1a80177,0x7395000d,0x7bb102fe}},	//   _aksed_, _идҵақәа_, _ilusa_, _lokhetho_, 
   {{0x3202029c,0xbcac02e1,0x4da701a3,0x00000000}},	//   _mitima_, _ملاهي_, _ڳوٺڙي_, --, 
   {{0xf7430420,0xf2fc011a,0x02ef00ad,0x329103a4}},	//   _годинка_, _abruptly_, _dalitna_, _grikkar_, 
   {{0x1eb401f7,0x2760027b,0xa4b00497,0x133501a7}},	//   _intenses_, _ववृधे_, _argidoil_, _halvempi_, 
   {{0xce010462,0x32fc0040,0x126c022a,0x75190119}},	//   _oblempra, _מפלסטיק_, _nedos_, _gerundio_, 
   {{0x5200040f,0x24ad045f,0x3e2902b2,0x3805066f}},	//   _galima_, _fullstän, _режимі_, _disparos_, 
   {{0x02000108,0x22fd0037,0xb37a0176,0x456703b8}},	//   _salila_, _melayari_, _papasan_, _фарабиді, 
   {{0xf2000067,0xb31902ac,0xaea20203,0x3c0a0269}},	// [2210] _aalima_, _شيلات_, _decretet_, _cumplan_, 
   {{0x42fc04bb,0x937f02df,0xe2ab01f6,0x21d70065}},	//   _melikas_, _didakwa_, _hending_, _stellenm, 
   {{0xf395046d,0x0379026a,0xe9f50390,0x3d730148}},	//   _alusa_, _matalia_, _debüt_, _生物科技研發人員_, 
   {{0x7408024a,0x039505d9,0x3ec60058,0xf4880447}},	//   _dekunrin_, _blusa_, _talopels_, _aziganiz, 
   {{0xcecb02ec,0x6291023b,0xc27f0050,0x32ab01d1}},	//   _aaminsan, _isaaka_, _apanan_, _mending_, 
   {{0x87010094,0x429104d8,0x00000000,0x00000000}},	//   _تىلدىلەر_, _usaama_, --, --, 
   {{0x43640286,0x5b5a0162,0x00000000,0x00000000}},	//   _koogyan_, _калламди, --, --, 
   {{0xa2c201c5,0x300000f2,0x00000000,0x00000000}},	//   _hablaha_, _nenormāl, --, --, 
   {{0x0a210168,0xa3000357,0xb6190014,0xf2000045}},	//   _forbruke, _mamaroi_, _perendim_, _dalija_, 
   {{0x1dbe00ab,0xbc740227,0x73010050,0x263a00a6}},	//   _rawakore_, _melukis_, _katampi_, _babhapti, 
   {{0x32d10061,0x7d3501a3,0x32f000e3,0x943a00e2}},	//   _상품판매를_, _اُگهاڙي_, _balieni_, _harksank, 
   {{0x2202022d,0x8c060272,0x84d60486,0x92790529}},	//   _ferite_, _abatagas, _युरिया_, _krugovim, 
   {{0xa2000107,0xbda20095,0x75960086,0xd2aa0040}},	//   _nalika_, _saandhap, _legrossz, _spectrom, 
   {{0x94730402,0x820202ee,0x09410163,0xee510203}},	//   _pastikan_, _antika_, _kellemet, _detallie_, 
   {{0xa37a0456,0xb26d00d2,0x030c0045,0x1afb017f}},	//   _paparan_, _getol_, _зарађују_, _imartune, 
   {{0x4c130192,0xff3903a2,0x19cd00ab,0x00000000}},	//   _생각되시면_, _बीवियों_, _matenuit, --, 
   {{0x1200029c,0x57840292,0xacea0061,0x278900d9}},	// [2220] _salima_, _amanfoɔ_, _슈퍼기억력_, _деловой_, 
   {{0x72fc00e0,0x02fc013a,0x426c00bc,0x82d80456}},	//   _krige_, _getippt_, _pedot_, _jelebu_, 
   {{0x086504f2,0x831701d1,0x73e801bd,0x17db0024}},	//   _phunutod, _finally_, _естен_, _বিনিময়ত_, 
   {{0x30350203,0xe9c304ad,0xc2020129,0x7c6f02c7}},	//   _centrian, _bonelape, _nkpiri_, _vierten_, 
   {{0xb23c017a,0x792800cb,0xd42301df,0x98f801db}},	//   _abawucel, _фисқу_, _forsworn_, _قارلىعاش, 
   {{0x66260101,0x02da03a0,0x126d0465,0xd6490151}},	//   _sistemul_, _basegi_, _letom_, _anchoodi, 
   {{0x42000662,0x06220306,0xfc630156,0xc32c0153}},	//   _halika_, _chantapi, _asturio_, _鍼灸で甦る身体_, 
   {{0x1c08008d,0x0c44001e,0x9288038a,0x1a060464}},	//   _буддавий, _shawara_, _akhamani_, _bazatege, 
   {{0xf31600c4,0x8316025a,0x1200008f,0x52d00287}},	//   _uliza_, _ndazi_, _valija_, _litovel_, 
   {{0xe2fc042c,0x626d0456,0x58ba0311,0x7e840156}},	//   _brige_, _betol_, _ብምፍሳስ_, _אָרנטלעכ, 
   {{0x9b1602d5,0x9c1201e5,0x67b304a4,0xa5e601de}},	//   _majandus, _akasọ_, _chluasai, _حايلۇن_, 
   {{0x43870672,0x866d01ac,0x289402eb,0x7132017e}},	//   _akaryo_, _إليسا_, _өвөлжилт, _mortinto, 
   {{0x2c34007e,0xfdbf0184,0x736403a4,0xe0640361}},	//   _नियोजयेत, _bisature_, _bloggan_, _автоçулс, 
   {{0x1d7d00d6,0x2342060b,0x5afc00b3,0x32120015}},	//   _نجران_, _सारंग_, _askorbin_, _dhaha_, 
   {{0xe9960476,0x2e3b006a,0xdb6400bb,0xb9cb015a}},	//   _akakunda_, _baravara, _مضائقہ_, _dameesit, 
   {{0xe20001ad,0xc394033d,0x822603f1,0xc2120176}},	//   _balika_, _blesu_, _ziskom_, _haihu_, 
   {{0xa3860177,0x4f400034,0x388500ec,0x0e0e007f}},	// [2230] _overa_, _næringar, _varikliu, _fandalia, 
   {{0x2dd103de,0x82e202f6,0xb90d004d,0xe2900144}},	//   _ngokunga, _kwantum_, _笑望來時路_, _pcman_, 
   {{0xd4fc02fe,0xea6a02ac,0x8e3b03b9,0xe23a003c}},	//   _نامعلومو_, _اعتذار_, _warawara, _گرايشها_, 
   {{0xf85d0144,0x43a804b2,0x225e00a5,0x5426019b}},	//   _cairdeas_, _tinanong_, _faititil, _баяцца_, 
   {{0x184201d1,0xd69001eb,0x2212000c,0x5a9800cf}},	//   _proteins_, _anafóric, _chaha_, _chayinaa_, 
   {{0x06eb0092,0x408a02ac,0x640f02e5,0x61e101b7}},	//   _ドラゴンボ_, _معقوله_, _avogádo_, _वातपित्त, 
   {{0xc3fa0096,0x44270184,0x8e1c0281,0xf19c020f}},	//   _batura_, _banyegej, _aniguisa, _اتڼونه_, 
   {{0xa61a00b5,0xaebe040f,0x734e0452,0x00000000}},	//   _kuaapyré, _patogesn, _घराघरात_, --, 
   {{0x6e3b036c,0x5a090148,0x42d901f7,0xde3b00c5}},	//   _varavara, _perpetuu, _accesi_, _警惕高血压高血脂_, 
   {{0x3b3f012a,0x2a160044,0x40e000f5,0x76ca003f}},	//   _ponieważ_, _discusse, _мүңкүрли, _dibahhom_, 
   {{0x6c6f013b,0x32eb0274,0x2e4a01f9,0x138701cc}},	//   _viersen_, _barnabæt, _bucakaca, _bhargo_, 
   {{0x19c4000b,0x329000a4,0x32000393,0xfd6b00be}},	//   _apamemea_, _donant_, _zaliha_, _مەلدەشتە, 
   {{0x83170513,0xfc28018d,0x367a0212,0x63f400bd}},	//   _cincile_, _ስብከትን_, _fidelium_, _eyster_, 
   {{0xd3fa0079,0xd6990206,0xc2ea01f7,0x56f90135}},	//   _satura_, _centrumh, _aminats_, _bombalaw, 
   {{0x12d9018c,0x5ea200c7,0xd3ea0178,0xe2d60008}},	//   _tweede_, _berlegen, _amitre_, _orelles_, 
   {{0xc2000544,0x6e3b0139,0x0abe0053,0xa930034e}},	//   _palika_, _agrahara, _diajukan_, _carmenqa_, 
   {{0x52ef02ce,0x5aaf0014,0xef2d02f0,0xc2ca035c}},	// [2240] _balikna_, _diskuton_, _irifaren, _bokdag_, 
   {{0xd0940134,0x625b02a0,0x4d8d018f,0x62ef022c}},	//   _albáníà_, _baalé_, _hologhra, _calikna_, 
   {{0xc9c30071,0x5da300af,0x4cab0467,0x19f9027c}},	//   _جالبه_, _колись_, _yenyinar, _beyifuna_, 
   {{0x0101051a,0xb27a0544,0xccf50109,0x33f40153}},	//   _radhiall, _milimili_, _अनिकाल_, _ウイニングイレブ, 
   {{0xf021041a,0x33fa01fa,0x9e3d051e,0x028e00ff}},	//   _квартири_, _katupa_, _azulejos_, _bajkalo_, 
   {{0xbf350192,0xf82303b0,0xb86e04df,0x93790053}},	//   _공급면적당_, _প্রজন্মই_, _akabalar_, _sumargo_, 
   {{0xc1f500d7,0x1c140170,0xfd2f002b,0x6bc500d1}},	//   _смотр_, _amulungu_, _মোজাফফর_, _ওচৰিকৈ_, 
   {{0x0be90059,0x07590255,0x6fd00147,0x1c6202be}},	//   _apposito_, _पुत्रीक_, _شاۋچئڭ_, _gutumin_, 
   {{0xa378004e,0x9b5b01b4,0x81d901c4,0xa26c006e}},	//   _salamin_, _ingedien_, _stelselm, _meloy_, 
   {{0x10b202ac,0x027b0368,0xe71c0142,0x30fd001d}},	//   _هاتفك_, _склоне_, _नन्दन_, _farbierz_, 
   {{0xd64a0037,0x39740080,0xd82e00a7,0xfe4600be}},	//   _የክርክር_, _ajungune, _арбир_, _دوشتورعو_, 
   {{0x89c70013,0x99c20255,0x405b0183,0x42f0041e}},	//   _қарамай_, _kindlast, _ampandro, _galiani_, 
   {{0xec25037c,0x573d00e4,0x939403d5,0x62900119}},	//   _lionhead_, _आर्यभट्ट_, _aless_, _baeay_, 
   {{0x4c4f0052,0xe2260017,0x00000000,0x00000000}},	//   _जमानामा_, _ziskem_, --, --, 
   {{0xa65f023c,0xb3940116,0x7ef6002b,0x7e0a002b}},	//   _amakishi, _cless_, _শরিফুল_, _নায়িকার_, 
   {{0x79f8034f,0xb2d8012a,0x8292045b,0x8ee6036e}},	//   _abhalise, _ojcem_, _колядки_, _chikitus_, 
   {{0x038603f0,0x72ca011b,0x0b630005,0xd27e002c}},	// [2250] _hvern_, _macdo_, _avertura_, _jainko_, 
   {{0xb4b90501,0x0df70023,0xc7c7038a,0xc57b047b}},	//   _मंगेशकर_, _заявил_, _castigaw, _fuglabjø, 
   {{0x1dab04d7,0x081c0162,0x4c620135,0xf170002b}},	//   _kenninga, _سانائىتى_, _basudan_, _বন্দুকের_, 
   {{0x234703ed,0x2379042c,0x14b001ab,0x92030156}},	//   _começa_, _nalazio_, _तिनडोरिय, _פענאמענע, 
   {{0x3dab03f0,0xc3b300e6,0xd2d900ec,0x00000000}},	//   _menninga, _编辑好友列表_, _metodus_, --, 
   {{0x2c6702fe,0xb9f800fb,0x00000000,0x00000000}},	//   _malunga_, _ubhalise, --, --, 
   {{0xf38604c8,0xb5b00006,0x7a8b0024,0x327803f6}},	//   _gvern_, _tanganny, _meinings, _malihini_, 
   {{0x1acb0335,0x53790062,0xa2f00196,0x6185000a}},	//   _भरतर्षभ_, _astalya_, _qadiani_, _assammil, 
   {{0x220401e6,0x12fc03a6,0x12910118,0xadfd02cf}},	//   _hodinami_, _ntago_, _asaana_, _предците_, 
   {{0xc2fc004e,0xd49d0092,0x2d44036e,0x5bde00ba}},	//   _itago_, _メッセンジャ_, _chiqirir, _چاوبکرێت_, 
   {{0x52d900d6,0x29a1010d,0xa68203a2,0x25a10077}},	//   _ligean_, _स्वीकारण, _अबराम_, _dominikà, 
   {{0xc30304e2,0x021c0528,0xda57027e,0x3e420445}},	//   _pndapat_, _bathar_, _писана_, _sinaliza, 
   {{0xb34000b9,0x625b0101,0x92ec0169,0xbe4e0038}},	//   _अथांग_, _cuplu_, _detiene_, _ааҗдә_, 
   {{0x41bd01a7,0x52ab0166,0x86ba00c5,0x92ea0277}},	//   _развития_, _sendung_, _caradisi, _kutihan_, 
   {{0x527a0165,0x3c610050,0x637800c0,0x79c10067}},	//   _bilibili_, _butuhna_, _dalahin_, _gandaatt, 
   {{0xb28c0285,0xbddc0176,0x68ba006d,0xfe1c008c}},	//   _adakuna_, _tankerne_, _абясцэнь, _datescha, 
   {{0x637f01e9,0x0af00094,0x7ae4000d,0xb283000d}},	// [2260] _bonatsa_, _بىزدەردى_, _postkast, _pakkuja_, 
   {{0x0c650534,0x22610340,0x526d0020,0xf56a00c5}},	//   _vietjet_, _kiwikiwi_, _letoa_, _médaille_, 
   {{0x0f4802e7,0xdfa7019a,0x3aad004d,0x77800092}},	//   _diksyona, _belvaros_, _若不記錄可不填寫_, _レシピブログに参, 
   {{0xf867065e,0x38fe069d,0x22120049,0xcc2202fd}},	//   _venstres_, _baragend, _ohahe_, _pharrais, 
   {{0x09e401cb,0x2a100285,0x57830013,0x97110291}},	//   _nokuband, _kambanda_, _серазетд, _منتزه_, 
   {{0xa26d01fa,0x9c620292,0x7c6f047d,0xe7b3017e}},	//   _aetoa_, _awurade_, _dierfen_, _konsenti, 
   {{0xe29403db,0x00000000,0x00000000,0x00000000}},	//   _elibanzi_, --, --, --, 
   {{0x9dac00ba,0x7ae400da,0x12cb0034,0x0a90014a}},	//   _باهۆز_, _inculpat, _saedis_, _kivitelb, 
   {{0x5cf80037,0xa2c201a4,0x9e820301,0xcd8801aa}},	//   _የአስፋልት_, _apelisa_, _osеyə_, _effortwa, 
   {{0x07830255,0x827e0288,0xf3940109,0xeb8d0043}},	//   _पारामारि, _ibingo_, _चिरन्जीव, _awangayo_, 
   {{0xd71c028b,0x82450162,0x346d0024,0xb27e0183}},	//   _reducció, _ماڭىمۇ_, _বিপদৰ_, _connes_, 
   {{0xb20003ba,0x5164004f,0xb2080163,0x9dbf0116}},	//   _epait_, _jogomaay_, _lebontás, _polissma, 
   {{0xc281054f,0x5bb10024,0x534d0374,0xeeed032d}},	//   _hahhaah_, _ইউৰেছিয়, _парфи_, _һѳнәр_, 
   {{0xac6500c9,0x913f0122,0x0a2001db,0x5c00000d}},	//   _biethet_, _angendel, _جانۇيا_, _unistus_, 
   {{0xa39401b8,0xe2d70418,0xc29f0082,0xcee60040}},	//   _poest_, _oteller_, _ajujuwa_, _בסטייל_, 
   {{0xd9e402bf,0xc2040300,0x00000000,0x00000000}},	//   _kokuband, _rodinami_, --, --, 
   {{0xb225006c,0x7e1c007f,0x32da0118,0x00000000}},	// [2270] _amakha_, _gadeiria, _basezi_, --, 
   {{0xa27e00df,0x734100bc,0x702d00d4,0x4719032d}},	//   _bonnes_, _مندان_, _stadicho, _приборҙа, 
   {{0xd25a02a0,0x62cc0265,0x039401c9,0xe2c400c5}},	//   _akole_, _spullen_, _enese_, _mondiaux_, 
   {{0x72d90117,0x20ad03ce,0xc7e40163,0x429102fb}},	//   _aksen_, _بشاره_, _عضلاتی_, _hauai_, 
   {{0x6e3a042f,0x2c09069e,0x7a490060,0x95ab012c}},	//   _kinaliqa, _permitiu_, _بايقالات, _menginey, 
   {{0x1df102b6,0x43940079,0xc2e501cd,0xf73f0037}},	//   _ءبىراقتا_, _inese_, _adoniya_, _በመደበኛው_, 
   {{0xb5850004,0x92fe00a4,0x69c601e9,0xf2910118}},	//   _barselòn_, _tarifes_, _ditement, _asaala_, 
   {{0x720004aa,0x456c00d8,0xb97805a6,0x03030282}},	//   _apait_, _chamaliè, _grunngje, _mitarau_, 
   {{0xc67d0147,0x3b8500ec,0x90eb00d1,0x00000000}},	//   _اكۇنوۋا_, _агулам_, _চাবোনৰ_, --, 
   {{0x22e60090,0x6212028f,0x00000000,0x00000000}},	//   _akaneta_, _naihi_, --, --, 
   {{0xa969020a,0x153100f8,0x064d02b9,0x00000000}},	//   _аралдары, _নয়নাভিরা, _vitorlás_, --, 
   {{0xc2c4035b,0x8dba0113,0x0225025e,0x1224004c}},	//   _povedati_, _mbunacha, _smakka_, _alikka_, 
   {{0x19f1007c,0x3212023b,0x84210244,0x6b6c01c4}},	//   _elandela_, _kaihi_, _cambiato_, _navorser, 
   {{0xa42803de,0x2b6a008a,0xa2ef029b,0x737a02a2}},	//   _ngokwenz, _tupulaga_, _diaffe_, _patayin_, 
   {{0xf386008c,0x52120340,0xc17a01ca,0x834102ac}},	//   _avert_, _maihi_, _blahblah_, _انقاص_, 
   {{0xae3900f5,0x077201b7,0x7f2e01f7,0xce7f015d}},	//   _биологла, _प्रसारित, _castelha, _घोषणाएँ_, 
   {{0x0ea600a3,0xc2ea03b5,0xfb940170,0xd6b50007}},	// [2280] _fastsett_, _bisikan_, _choimbir, _litambwi, 
   {{0x82950329,0x6ae6002c,0x59be00d1,0x517a0237}},	//   _efektiv_, _extranet, _andersdt, _박사학위를_, 
   {{0x0dd6002c,0xf76e0060,0x70e8005b,0xf6180223}},	//   _deskriba, _ايالاعىس, _akkinabl, _бадамгэр, 
   {{0x12d603ea,0x6262017d,0xa202043a,0x23860363}},	//   _quelles_, _takoyaki_, _tipiki_, _tvert_, 
   {{0x8a020499,0xce250220,0x89fc005f,0x8afc034f}},	//   _matafaga_, _отключва, _relajant, _eedomain_, 
   {{0x53860224,0xa3a20233,0x93aa0092,0xd3f40256}},	//   _hvers_, _simpli_, _この人と友達にな, _pirtis_, 
   {{0x7bc001f2,0x69d1000c,0xe8f70103,0x35ff0037}},	//   _ﭼﺎﻏﺪﺍ_, _абраҟа_, _achaswed, _shamsudi, 
   {{0xf00000f2,0xc7cf0153,0xba8c0077,0x00000000}},	//   _neformāl, _ジのトップへ戻る_, _kotidyen_, --, 
   {{0xd9f101cb,0x0d1e0212,0x523b024c,0x3d390321}},	//   _alandela_, _dealtime_, _riferiti_, _socialne_, 
   {{0x72fc0180,0x77570257,0x93860172,0x7c9e0258}},	//   _dedikas_, _yndisleg, _nwera_, _leeftiid_, 
   {{0x62120399,0x3224011c,0x596b041e,0x82c30187}},	//   _hhhhhh_, _fenkug_, _ammintat, _desliga_, 
   {{0x5b8400b4,0x337a0201,0x75ad0311,0xf4a40311}},	//   _женераци, _naharal_, _ንሰብኡተን_, _ንሶማላውያን_, 
   {{0xc4880092,0xbc7503f5,0x1a35030a,0xa26d0085}},	//   _おすすめ商品_, _reduzir_, _establéc, _metou_, 
   {{0x9f3c0193,0x5290037c,0xb2640273,0xcc6d0220}},	//   _perumaha, _bonart_, _amplio_, _storica_, 
   {{0xa2d7019d,0x5039019f,0x42ca01c5,0x98660144}},	//   _matondo_, _پيچرا_, _orodka_, _pairilis_, 
   {{0xd67a025e,0x36de0040,0xabd100cc,0x927f02eb}},	//   _nemendum_, _מוסקבה_, _soldater, _abando_, 
   {{0x665d00e7,0xd230025b,0x5c030003,0x3da2014f}},	// [2290] _addisonw, _marjun_, _grappig_, _свуда_, 
   {{0xdd5a0061,0x8304010e,0x40970156,0x00000000}},	//   _서해그랑블_, _antagal_, _לייַדנשא, --, 
   {{0x3294043a,0xe56000c7,0x322602f6,0x227f0172}},	//   _alikani_, _kullanuç, _paskil_, _npanin_, 
   {{0xadb804f9,0xb27e02af,0xc386030b,0xb3f901a6}},	//   _angallat_, _icinyo_, _awera_, _ngauru_, 
   {{0x5212032d,0x563e023b,0x7e2600c7,0x795d00e2}},	//   _baahi_, _beritani, _алыштыры, _taalbehe, 
   {{0xb53e050b,0x097a001d,0x5615014f,0x8f8c0158}},	//   _ceritany, _latinist, _русији_, _बेशकीमती_, 
   {{0x049c0238,0xf2b4018c,0x52f20374,0x00000000}},	//   _плани_, _verblijf_, _яккаю_, --, 
   {{0x18dd019b,0xc27b009a,0xab34022f,0xda0601dd}},	//   _poreikiu, _andilili_, _будучыя_, _baratege, 
   {{0x225a005a,0x5b8c037a,0x921202fb,0x36380163}},	//   _choli_, _itangazo_, _faahi_, _legendás_, 
   {{0xae4a0013,0xe2910007,0x4394024c,0xcf6b0090}},	//   _наширнин, _movate_, _inmsa_, _emubatan, 
   {{0x9a1300bc,0x4ed00052,0x826d0085,0xa7b20053}},	//   _comconte, _policejn, _ketou_, _khalayak_, 
   {{0xbc490013,0xe2c40338,0xe17f002b,0x926d01b0}},	//   _безовта_, _enemics_, _লজিষ্টিক_, _metot_, 
   {{0x6f5004c3,0x7c260019,0x53fa00fe,0x4a0e030d}},	//   _sohanews_, _temeràri, _mapuni_, _aviabile, 
   {{0x238a0139,0x2279045e,0x3d5a0012,0x00000000}},	//   _प्रदापये, _магьосни, _ाधुन्हि_, --, 
   {{0x7b6204a9,0xbaed003a,0xe395001f,0xf2fc0077}},	//   _अभिनव_, _тилларда_, _seesei_, _belgja_, 
   {{0xfaa901ad,0xaccb018d,0x2395006a,0xed7101cf}},	//   _mecklenb, _ሓሳባተይ_, _imason_, _commatra, 
   {{0x9afb038b,0x646d00e6,0xa3950016,0x029202ef}},	// [22a0] _diperiks, _不能立即改正的_, _amason_, _jerall_, 
   {{0xecd7023e,0xed06015e,0x09770258,0x42d70184}},	//   _اعلام_, _carreter, _tennisje, _gatondo_, 
   {{0x33fa030f,0xe2f3012a,0x2316027c,0x45b902ac}},	//   _kapuni_, _metodą_, _alizi_, _موناكو_, 
   {{0xca5200ef,0xa2690013,0x98f30025,0x08760439}},	//   _تدريج_, _баробари, _पदार्थात, _khungulu, 
   {{0xfc4e02ec,0x13640046,0x363e026a,0x1da701a3}},	//   _زمانا_, _vulguin_, _peritani, _موچڙن_, 
   {{0x43870167,0x2c65041e,0x72fc00df,0x0342006a}},	//   _chario_, _acquale_, _orage_, _harenan_, 
   {{0x925a0011,0x28c601f6,0x4c7601ef,0x1317011a}},	//   _akola_, _noverand, _keturis_, _succeed_, 
   {{0xb2120298,0xc2910165,0x98ba028d,0xb2ef02ef}},	//   _waahi_, _kovate_, _mintenir_, _chafat_, 
   {{0xca730060,0x73ce023d,0xc9f9009b,0x00000000}},	//   _алдын_, _магазини_, _ангараг_, --, 
   {{0x964d0046,0x330801b4,0x00e40299,0xf1b5004d}},	//   _ايىتقانى, _simbool_, _تۈزگۈچىل, _促進教學發展研究_, 
   {{0xe85800a4,0x15d601dd,0x0b090359,0x9afc0054}},	//   _процесст, _abibumby, _terpstra_, _bakoncin_, 
   {{0x59770548,0x53dc02f7,0x8f3a0359,0x55e80229}},	//   _menneske, _bulwe_, _degradaa, _aldanmış_, 
   {{0x42c6004b,0x80140046,0xac07017c,0x926d023a}},	//   _ditekesi_, _دوكۇمەنت, _pinsamt_, _detom_, 
   {{0xe2fc02c7,0x025a03bf,0xa27d01d5,0x8eb800be}},	//   _frage_, _kholo_, _مقابلوں_, _ايعىر_, 
   {{0x70600126,0x482402a9,0xb3950609,0xc25401da}},	//   _апеляцій, _сувязь_, _lousa_, _mungojnë_, 
   {{0x92b503d5,0x38a80276,0x139003db,0x7b0700a7}},	//   _horch_, _бастурма, _abayeni_, _диндин_, 
   {{0xc3eb0253,0x423b00de,0x0ba203a2,0xe26d028d}},	// [22b0] _imatut_, _asiwisel, _बेबुनिया, _zetol_, 
   {{0xabc502ac,0x425a03f6,0xd2000084,0x92e80358}},	//   _بناطيل_, _oholo_, _abdina_, _dilibon_, 
   {{0x260e00ff,0x0a540464,0xd8700376,0x5741011b}},	//   _הורקנוס_, _akamusab, _uppihald, _bazobang, 
   {{0x5723003e,0x73aa0672,0xf4170313,0x84bf01ab}},	//   _советы_, _norvege_, _bingilmo_, _चहुँपनी_, 
   {{0x43b90060,0x64120061,0xb30d011a,0x054103ce}},	//   _мініп_, _문헌정보과_, _hazards_, _میزاده_, 
   {{0xd2fd0434,0xc6540037,0xf6f50350,0x632002d7}},	//   _útiles_, _ማስቀረት_, _ላቀረብንላቸው_, _cancros_, 
   {{0xdd2c0270,0x8fb40047,0xb9990244,0x3017027b}},	//   _arrivate_, _contenus_, _бележка_, _ददृशुः_, 
   {{0xb30603d8,0xcc7304ce,0xfc4401d2,0x82b30017}},	//   _podatak_, _imisela_, _akawara_, _द्रुत_, 
   {{0xb316002e,0x72b3022a,0x726d012d,0x026c00b6}},	//   _ulaza_, _saidiko_, _setol_, _othoga_, 
   {{0x65430061,0x62ec04a7,0x00000000,0x00000000}},	//   _가성소다의_, _abriuse_, --, --, 
   {{0x47b90060,0xc04701a3,0x52b50195,0x426c00ff}},	//   _мардымсы, _رئٽڪلف_, _dorch_, _aglon_, 
   {{0x26ba022f,0xebe3017f,0xead20061,0x24ec01c9}},	//   _pavasari, _tikeraar, _여주직사각_, _समैया_, 
   {{0xd26a00bf,0x80500052,0xb2fd00bc,0x5d30047b}},	//   _заморажи, _स्थितिको_, _anggak_, _busskoyr, 
   {{0x30340132,0xc2fc00b4,0x51fc00f5,0x22000423}},	//   _embernek_, _trage_, _aglabasy_, _lamino_, 
   {{0x5330005e,0x78150023,0x829200ec,0xde7303a2}},	//   _кәррий_, _думала_, _atrado_, _शख़्स_, 
   {{0xc3db034b,0x3df0028a,0x02e1009f,0x731a010b}},	//   _sikuriti_, _سندون_, _kupnino_, _itsiweng_, 
   {{0x9c14014a,0x527e012d,0xcd8c014f,0x224701b7}},	// [22c0] _سوچنے_, _apinun_, _фондациј, _केवलो_, 
   {{0x6b710108,0x331a0004,0x9c60013d,0xabf4026b}},	//   _indungna_, _anachik_, _saluton_, _follando_, 
   {{0xa9c30147,0x12000092,0xf2ba017d,0xb3e700ec}},	//   _باقبى_, _kamino_, _øjemed_, _сакратар, 
   {{0x6e27009c,0x7d8f0397,0x898204b3,0x7906000c}},	//   _cromadas_, _abalanga, _brizonid, _karapegu, 
   {{0x69f70287,0x2dbd069f,0x6204020f,0xa6e7014e}},	//   _ovladate, _rumunsku_, _andizami_, _заслуге_, 
   {{0x9b1100a7,0x020201a4,0xc0e601cd,0xdb7a0311}},	//   _campanya_, _batiya_, _anezimbo, _ምምቕቓል_, 
   {{0x6a4204dc,0x62120150,0x129100d9,0x4ce704c7}},	//   _نێزیک_, _raihu_, _kauas_, _електриц, 
   {{0x3325003f,0xd9d40211,0xbffa01c4,0x83b60161}},	//   _chobmey_, _tekemine, _roekeloo, _патроны_, 
   {{0x73940192,0x72a600f7,0xc6b4005e,0xebdf0193}},	//   _moest_, _nombra_, _ﮬﻪﺭﺧﯩﻞ_, _अग्रलेख_, 
   {{0x10310157,0x73f901de,0xe1c401be,0xea100156}},	//   _अनुगमनकर, _моцартты_, _milostné_, _antaŭler, 
   {{0x17be0208,0x526d0529,0x08670046,0xd2b501ac}},	//   _ئسرائیل_, _petom_, _fresques_, _corca_, 
   {{0xe855018d,0x6ecd032d,0x3d2c0044,0x7bfe01a4}},	//   _ዝሓቖፈት_, _borithan, _irritate_, _mukumbus, 
   {{0x724900d4,0xf906011f,0x31d500ca,0x2639004a}},	//   _keamer_, _carapegu, _amolonam, _заманасы, 
   {{0x2f780288,0xc8c5022a,0xc6580676,0x52e702c8}},	//   _diabolos_, _dimetrod, _crikveni, _asinado_, 
   {{0xf2d80005,0xaa1a0061,0x10d9018d,0x65cd0102}},	//   _mument_, _검색도움말_, _እምበእር_, _kugawany, 
   {{0xcfa102c2,0x17dd0040,0x929104ca,0x00000000}},	//   _beklemto, _היעדר_, _cauas_, --, 
   {{0x02a6014a,0xe26d00bc,0xc291033d,0xd6ed02cd}},	// [22d0] _gombra_, _ketok_, _anfave_, _garanbaw, 
   {{0x52ba00dd,0x4b8b0022,0xa8bf0092,0xb5df00e6}},	//   _garedig_, _dilithar, _allerbed, _新增社区好友_, 
   {{0x0d8c0152,0x444a0008,0x17940156,0x00000000}},	//   _awazdaşl, _كۇرۇستار, _יאָדער_, --, 
   {{0xe2ea015e,0x42c800a9,0xd7250071,0x81e20025}},	//   _ارقىلىق_, _rutonde_, _blambang, _नकारे_, 
   {{0x65f002a7,0x1e3603bf,0x625a01ac,0xc86a02fd}},	//   _inimatsi, _bengdika, _cholm_, _chonnaid, 
   {{0xd3860149,0x32fc022a,0x73eb018b,0xb6d00405}},	//   _nwere_, _kriga_, _lapte_, _antageli, 
   {{0x23f40516,0x374700b3,0x83860129,0x539400e0}},	//   _gotten_, _аңламагы, _iwere_, _koest_, 
   {{0x5dfd01aa,0x930500ac,0x37d1033f,0x33f4057c}},	//   _assetswa, _dolazak_, _apogipog, _ryster_, 
   {{0xa3170497,0x727e00a1,0xa38604ee,0x43f40191}},	//   _muscled_, _koinā_, _kwere_, _syster_, 
   {{0x765e01f2,0xd3f402f3,0xdaed0155,0xaeda0121}},	//   _қисми_, _botten_, _carlsson_, _mediados_, 
   {{0xcadd00e2,0x52cc0185,0x425702f7,0x225a0392}},	//   _akademys, _berlän_, _leitibol, _pholl_, 
   {{0x92cb03c7,0xaf970092,0x3d490153,0x92d40198}},	//   _żaden_, _周辺地図を表示す, _ソフトバレ_, _jabolka_, 
   {{0x8e5e0657,0xf34b0034,0x93030306,0x33050139}},	//   _uzubilla, _algengt_, _almabot_, _antaram_, 
   {{0xa317027d,0x7f2e0223,0xfbc302b6,0x12ba018a}},	//   _zvezda_, _библи_, _денешыны, _caredig_, 
   {{0x12300359,0xccfb0039,0x7c80015e,0x92900359}},	//   _blommen_, _kaleratu_, _сезет_, _jonkjes_, 
   {{0x8e5e0163,0x61a50008,0xe224053d,0xc58f003b}},	//   _ریستوران_, _алайкуу_, _anikwa_, _ekutivik, 
   {{0xf2fc028a,0x8200006a,0x6dcf0061,0x00000000}},	// [22e0] _alhamisi_, _ramino_, _투자자들은_, --, 
   {{0x7d3000be,0xe3b700ff,0x63ca0126,0xeead031e}},	//   _эмоциялы, _רייַזע_, _заворуше, _dovođenj, 
   {{0xe20202ee,0xc2cb010a,0x08670080,0x00000000}},	//   _katina_, _dugdaa_, _iffiortu, --, 
   {{0xe28a008d,0x98bc00d3,0x11c30076,0xfb8f01a0}},	//   _паспортл, _उत्साहजन, _бодови_, _marinlor, 
   {{0x3e47027f,0x21170553,0xad7b0011,0xb16100cb}},	//   _ashavuye_, _ťaháky_, _atamanya, _amarobho, 
   {{0x927f0286,0xddb80080,0x91de0035,0x42e903ec}},	//   _mienou_, _assingup, _бәрделәр_, _filologj, 
   {{0x12c7049e,0x4d880462,0x4dfd0218,0x00000000}},	//   _rádiu_, _arnoldwa, _assesswa, --, 
   {{0xe840013f,0x00000000,0x00000000,0x00000000}},	//   _digredus_, --, --, --, 
   {{0xb29102e5,0x5d5b03a4,0x92da000e,0xa2fc000a}},	//   _alvane_, _barnarím, _pasebi_, _atagu_, 
   {{0x2a7e01ec,0xd9bd0041,0xa9f006a0,0xcc3f0125}},	//   _بلندترین_, _азызуаз_, _pseudobu, _гүчленди, 
   {{0xf39502e2,0xff2501ab,0x7e6a015e,0x00000000}},	//   _louse_, _अँउजाइ_, _тойдо_, --, 
   {{0x32ca01b5,0x8a16015a,0x63d00405,0x00000000}},	//   _eindia_, _barbadee, _sommersk, --, 
   {{0x9a790264,0xc86f0097,0x79cd01a7,0x00000000}},	//   _dumangop_, _onísé_, _valokuva_, --, 
   {{0xb25a04c8,0xd3030031,0x53050453,0xb2b90243}},	//   _wkoll_, _didapat_, _polazak_, _fardiik_, 
   {{0x5379000c,0x199503ef,0x13a802f7,0x023102e7}},	//   _aguasua_, _amakenga_, _dinakong_, _kkumuha_, 
   {{0x925a024c,0x09710073,0x337900ad,0xe20e0223}},	//   _ukoll_, _compatir_, _sipatna_, _жанам_, 
   {{0xe354042c,0x926001a4,0x3d4a01ac,0xaf690134}},	// [22f0] _posebnu_, _batoboli_, _hisaronu_, _iwọle_, 
   {{0x015c00e3,0x95b80040,0xc3160414,0x00000000}},	//   _diffikul, _ועיבוד_, _moize_, --, 
   {{0xc3950195,0x2d0a03ef,0xbc7600e4,0x507d02ea}},	//   _amasan_, _igaragar, _माल्या_, _копиране, 
   {{0xe2910285,0x0e7201be,0xc40d0297,0x00000000}},	//   _kubaho_, _जिन्स_, _baruımnı_, --, 
   {{0x4d350056,0xbc01023c,0xac660478,0x093101d6}},	//   _вукалои_, _ګلبدين_, _pintors_, _blomstre, 
   {{0xfc530390,0xc3ea00c1,0xa2020018,0xf32b00e4}},	//   _dostuna_, _apotik_, _watina_, _spacery_, 
   {{0xa9b90145,0x27430061,0xa316004c,0x886c016a}},	//   _казанска, _업무혁신방_, _alaze_, _והבלים_, 
   {{0x33a3012d,0xc30e00fe,0xc120003c,0x31c400ba}},	//   _diepla_, _karalus_, _اینشتین_, _ڤێرشنی_, 
   {{0xa38c00f5,0x3637002c,0x0b3403c2,0x72480378}},	//   _душен_, _aisialdi, _albaanis, _filmum_, 
   {{0x427f02fe,0xcba2000c,0x3b640308,0x13bd004d}},	//   _ibango_, _аднакыле, _detergen_, _電子公佈欄_, 
   {{0x12b3013d,0xd2ee02e1,0xbaf70017,0x1e3900d5}},	//   _londono_, _taifid_, _spisovat, _manahira, 
   {{0x00570212,0xd6ce0039,0x239402bd,0xc2a9018d}},	//   _cuislean, _kataluni, _phosib_, _ንቁጠባዊ_, 
   {{0x89e300ca,0x39f302fd,0xfc580299,0x2ea10192}},	//   _wikidata_, _chriosda_, _تاماكىسى, _naarmate_, 
   {{0x8cea065b,0x883e045e,0x89c2001b,0xd2d40193}},	//   _पाठमाला_, _митко_, _firdiitt, _cheonsa_, 
   {{0x1a510204,0x1fdd002e,0x839501b5,0x2f920061}},	//   _lopettaa_, _ozbiljno, _emasin_, _출고예정일은_, 
   {{0xac6f032e,0xb3270008,0xb9eb009b,0x7eb30445}},	//   _churata_, _بالبان_, _estropad, _governos_, 
   {{0x1248036f,0x5b7000d7,0x0a7c0583,0x22250224}},	// [2300] _ovome_, _iphumana_, _zračno_, _flakka_, 
   {{0x3f27017e,0x8c6f02ae,0x7340025e,0x8b8a01ac}},	//   _interkon, _budući_, _eigenda_, _diantoir, 
   {{0xec660415,0x87af0040,0x42c6016e,0x8bcd00b4}},	//   _besteht_, _יציבה_, _siteleri_, _фарисеий_, 
   {{0x42250034,0xe3960076,0x8320005b,0x00000000}},	//   _hlakka_, _passam_, _dojyou_, --, 
   {{0xf316002e,0xb4340147,0x061a018d,0x5b7b0428}},	//   _ulaze_, _تئزمەسى_, _ዝሳቐዩን_, _staranja_, 
   {{0x4f1e0040,0x06540023,0x4c75005f,0x63fa01ed}},	//   _אורלנדו_, _непонятн, _reducir_, _kapuai_, 
   {{0xdfea0354,0x7f5d0209,0x22e7014e,0xc07d032d}},	//   _бринклни, _ungasinn, _pernica_, _сапрыкин_, 
   {{0xeb0500d6,0x02360541,0xa0300223,0x00000000}},	//   _colscart, _daljem_, _tabernak_, --, 
   {{0x97090013,0x6aef02d8,0x730d02be,0xb8470204}},	//   _назарида, _उर्वरित_, _pulbura_, _гадание_, 
   {{0x4292039d,0x66170024,0x995e0211,0x81eb00bb}},	//   _murado_, _কৰিহে_, _mainitse, _گنگوہی_, 
   {{0x546e0152,0x13ec015a,0x0f580594,0x340200aa}},	//   _юрама_, _barressi_, _kryptert_, _madulaon_, 
   {{0xc558004a,0xe2fa018b,0xc21200a1,0x89750431}},	//   _filialı_, _prahova_, _haahi_, _minnesme, 
   {{0xcf0b00ff,0xb2970180,0xcfdc003e,0xda3e0046}},	//   _מפקיר_, _bankrut_, _транпорт_, _байлаган_, 
   {{0xdee30226,0x83fa0005,0xe2b5022e,0x72fc0038}},	//   _adakaten, _anturn_, _porcu_, _buaga_, 
   {{0x4ff10135,0x83890128,0x2e96015e,0x00000000}},	//   _buluları, _shayton_, _قىزىر_, --, 
   {{0x563200bf,0x4abb00e6,0xc6f0019e,0xeed8019b}},	//   _неоднокр, _上海长途汽车客运, _аздаблял, _greitesn, 
   {{0x5378012d,0x4bb70176,0x6c720047,0xd2fe001c}},	// [2310] _advaesa_, _esthetic, _alertes_, _bariles_, 
   {{0xd5430056,0xc3fa0005,0xb2fc03fd,0x116d0085}},	//   _бордюжа_, _enturn_, _fuaga_, _panitsch_, 
   {{0xbcf2009b,0xa2ec0011,0x027e018e,0x00000000}},	//   _болсоор_, _bazimbe_, _nweni_, --, 
   {{0x1e0a0057,0xe5500093,0x91ae037f,0xa7b0004d}},	//   _በማግስቱ_, _включать_, _yarandığ, _immutabi, 
   {{0x12360197,0x83f40257,0x929100d6,0x3a5301de}},	//   _sonje_, _systir_, _scuab_, _хорезм_, 
   {{0x903a0026,0xc2e8012a,0x5a9f004d,0x088501ab}},	//   _bijeenko, _jeziora_, _前往國軍北投_, _देतीदेल्, 
   {{0x027e0253,0xbd150399,0xa43e0374,0xe86b01c5}},	//   _nannut_, _emelinee_, _хатни_, _kaniisad, 
   {{0x52120544,0x0c6a0024,0xd31601e1,0x287601af}},	//   _abihu_, _দ্ৰব্যৰ_, _boaze_, _ahmaldyr_, 
   {{0x416702fd,0xedc204bd,0xea170178,0xe27e018e}},	//   _dianamnh_, _panihaka, _babandha_, _lweni_, 
   {{0x0e6b0268,0xf3060393,0xe2fc03c3,0xb2120285}},	//   _edicalma, _dodatak_, _brigu_, _abaho_, 
   {{0x2a1501c5,0x85b903e6,0xfabc0103,0x99940156}},	//   _ammaanka_, _gelausch, _chajakob, _אריזאנא_, 
   {{0x55ec0510,0xf3f20192,0x21460452,0xc2fa002f}},	//   _приведут_, _typering_, _आपसूकच_, _indhina_, 
   {{0xe0070008,0x29c7016d,0x9d5801eb,0x78470405}},	//   _душманда, _давалаш_, _османтәи_, _наради_, 
   {{0x2b8e0172,0x651a00b7,0x911202fe,0x72ea0279}},	//   _rwandafo_, _asyllyly, _nenkulul, _teintes_, 
   {{0x30d10564,0x0dbc01b9,0x53040183,0x33b30025}},	//   _realajul, _moralite_, _andalam_, _बालबुद्ध, 
   {{0x32fc024c,0xb6a700d1,0xc00003d1,0x00000000}},	//   _hrigt_, _সজোৱাৰ_, _deformāc, --, 
   {{0x719b04cb,0xb01e00e4,0xaa110217,0x2b81000a}},	// [2320] _консекут, _मन्दिरों_, _voraceme, _erininar, 
   {{0x3c7d0277,0x1c6f05da,0x79c4036c,0x00000000}},	//   _proseso_, _pierden_, _fonenant, --, 
   {{0x8d1e04b7,0x737a0573,0x0b72038a,0xbc190021}},	//   _deelname_, _matalin_, _cristoqa_, _ayesianb, 
   {{0x5248036f,0xe1d502c9,0x964f02f6,0xd204044a}},	//   _svome_, _инстигат_, _lathalai, _endimami_, 
   {{0xff410028,0x6eb90194,0x9b27002e,0x5346003c}},	//   _farshaxa, _desordin, _domaćina_, _ظاهرشدن_, 
   {{0xd56c0170,0x83370045,0x6fa402c2,0x78050235}},	//   _adawalek, _николај_, _vererger_, _लक्षयिष्, 
   {{0xb3790120,0x73fb0223,0x04ef01c3,0xe0eb04a5}},	//   _katarwa_, _baloratz, _badmynty, _nemidlal, 
   {{0xbbfe033b,0x4f09014e,0x2dad01a3,0x00000000}},	//   _fetogago_, _задовоља, _جهٽڪا_, --, 
   {{0xf292034a,0x5a85043f,0x67090064,0xb1ad0325}},	//   _xurado_, _okončana_, _terratrè, _bacardıq, 
   {{0xea8101f1,0x7fff0122,0x22900369,0x327201a6}},	//   _domosdos, _banyumas_, _konane_, _hōnea_, 
   {{0x4312018c,0x15d603de,0x83950077,0x87bc0244}},	//   _gunbros_, _ababemth, _boush_, _шотландс, 
   {{0x726d0198,0x025a035b,0x9d150203,0x3283044a}},	//   _letos_, _okoli_, _mikrostr, _azokisa_, 
   {{0x920200a2,0x6b030022,0xea020290,0xe9c7033a}},	//   _ratiba_, _торесен_, _adoraziu, _filliera_, 
   {{0xa3eb007e,0x29de0085,0xd68c0546,0xd92d003f}},	//   _sapta_, _daufeeee, _संजाल_, _hommeyve, 
   {{0x8212017a,0xc2e30258,0xe64300e7,0xa7530090}},	//   _abahl_, _alliade_, _alcoholw, _avanyeng, 
   {{0xd7090125,0xc3e60061,0x7c5a03b4,0x704a0365}},	//   _кесилип_, _바이올린과_, _bwititi_, _ब्लगरको_, 
   {{0xf26d0342,0x586202fa,0x537a0132,0xbcee0177}},	// [2330] _retou_, _basobanu, _katalin_, _нызқьҩык_, 
   {{0xf1ae0242,0x61b600da,0x026d00ce,0xa2e80198}},	//   _yaratdığ, _ниньдже_, _setou_, _milijon_, 
   {{0xd31601da,0x5c7c00b8,0xf3950318,0xd5730360}},	//   _plazh_, _utasana_, _housi_, _studoval_, 
   {{0x723600d5,0x456101fc,0x530c00fa,0x85af03ab}},	//   _monja_, _qellootá, _dumanas_, _pochutná, 
   {{0x478f0354,0xb2ca01f1,0x26ea0287,0xf144000d}},	//   _амбири_, _lindja_, _खतिवडा_, _liberaal, 
   {{0x3c29003e,0x739e0189,0x326201a4,0x00000000}},	//   _agosetos, _adaylar_, _makomaki_, --, 
   {{0x85600226,0x7e29000e,0xbaf00399,0x00000000}},	//   _amakasiy, _geoghega, _oiaueeee, --, 
   {{0xe27e0312,0x71470039,0xc2fc007b,0x672c0062}},	//   _gwenn_, _халимаг_, _brigs_, _germanyv, 
   {{0x79810024,0x25400218,0x00000000,0x00000000}},	//   _পৱিত্ৰ_, _artially, --, --, 
   {{0xb29401da,0xa225053f,0xd37a018b,0x471c0040}},	//   _klikoni_, _unaksa_, _catalin_, _שהכנסתי_, 
   {{0x2ad90211,0x00000000,0x00000000,0x00000000}},	//   _давление, --, --, --, 
   {{0x3394036e,0xd9b90429,0x0e9c018c,0x00000000}},	//   _kimsa_, _rindunya_, _vertoont_, --, 
   {{0x72fd03b0,0x2395034a,0xf8f602d6,0x7c1401e8}},	//   _trygd_, _cousa_, _تورتینچی_, _elepono_, 
   {{0x7c6601db,0xc43e02b6,0x4e6b05fb,0x00000000}},	//   _зайыбым_, _жарна_, _sočiva_, --, 
   {{0x025a0184,0xb3ea00d4,0x227f007f,0xcd6a0444}},	//   _akagisum, _reitse_, _rhentu_, _собаками_, 
   {{0xe24601cc,0xb2d502b6,0x00000000,0x00000000}},	//   _केवलः_, _аламын_, --, --, 
   {{0xb2f70052,0x362d025c,0x135e00fd,0xb79d03d4}},	// [2340] _उजुरी_, _frankrei, _clogaid_, _цифре_, 
   {{0x4b9c002c,0xf3010082,0x127e00f1,0x19d70416}},	//   _egindako_, _matakai_, _zwenn_, _greenele, 
   {{0x221c02fb,0x727e029a,0x929900e6,0x626d0194}},	//   _afuhia_, _pwenn_, _环氧煤沥青玻璃鳞, _letor_, 
   {{0xcf8f0281,0xc6b10012,0x2fc400c8,0x3f0903d1}},	//   _erhvervs_, _गढ़नारियल, _diforamo, _lidaparā, 
   {{0x8a3701f6,0x03eb0261,0x81ff0041,0x7eea0035}},	//   _বাহিৰত_, _kapto_, _ҕәынџьиа_, _башларын, 
   {{0x52240255,0xc28702fe,0x0cd40276,0xeb670193}},	//   _punkti_, _دفراه_, _пурридә_, _चीनने_, 
   {{0x2c1b0233,0x237900fa,0x00000000,0x00000000}},	//   _samquam_, _datapwa_, --, --, 
   {{0xc3ea0255,0x455602ba,0xd2e301c6,0x339501b9}},	//   _seitse_, _мукаррар, _ellinde_, _tousa_, 
   {{0x38ab0047,0xdc1e033e,0x94f70060,0x338c02c4}},	//   _第二十一条_, _elipsis_, _سالالارى, _јужен_, 
   {{0x2d8903dd,0x994001da,0x97b4028d,0xb67e0194}},	//   _kuvendit_, _siguruar_, _konsansi, _trovabil_, 
   {{0x82fb01f2,0x0aea003b,0x37cc01aa,0x754f010b}},	//   _явропа_, _awatfume, _airstyli, _diphaeph, 
   {{0x0d3a0037,0xfd8f03db,0xb95c0013,0x91560064}},	//   _ብንወስድ_, _abalinga, _бошкалар, _сабына_, 
   {{0x12fa0454,0x864f000b,0x92910217,0x02b5005b}},	//   _arahava_, _fatialof, _invase_, _bizcd_, 
   {{0x127e02f7,0x4bf40373,0x83eb026c,0x22c10184}},	//   _bannye_, _pollando_, _capto_, _frolina_, 
   {{0xda0d01cb,0x325b0287,0x03870493,0x179f03b7}},	//   _bazakuba_, _anglii_, _mvura_, _immuniti, 
   {{0x8e2a0099,0x92d901df,0x23960008,0x437902d9}},	//   _akagwada, _armorer_, _passem_, _mataafa_, 
   {{0xc05202ec,0xe43003d4,0xd7430211,0xa5820025}},	// [2350] _کٔٹھِش_, _objasnio_, _новички_, _अनुमोदना, 
   {{0x639502d5,0x511801b6,0x529102f4,0xaf6a014e}},	//   _elust_, _markedly_, _envase_, _латиницо, 
   {{0x22480253,0x14300061,0x70840162,0x92010185}},	//   _reimer_, _카드할인가격_, _херидарл, _обаманы_, 
   {{0xe26d01f1,0x025a0586,0x11d202e2,0xeb9a0388}},	//   _tetor_, _ikolo_, _enslavem, _финланди, 
   {{0x825a033f,0x330b0444,0x12fc031a,0x18090233}},	//   _akolo_, _подробну, _brigh_, _descorag, 
   {{0x71bd01cc,0x0c0b029f,0xe3fa0140,0x2342028d}},	//   _dhanaṃja, _najbližš, _bituin_, _kareman_, 
   {{0x3249027c,0xd26d02da,0xde95063e,0x798903bf}},	//   _swamps_, _setor_, _thompson, _diakaont, 
   {{0x5be0056e,0x6be90192,0x729001e9,0x2f5b0611}},	//   _entender, _엘리베이터_, _bonale_, _lakanpan, 
   {{0xc25a0007,0x66bb0325,0x00000000,0x00000000}},	//   _ekolo_, _aktrisay, --, --, 
   {{0x13020369,0x026d0076,0x768206a1,0x77670161}},	//   _kalamau_, _vetor_, _verdsmei, _проката_, 
   {{0x126c024c,0xc2a7003a,0xba0604f9,0x9be002ea}},	//   _ammont_, _otabek_, _allapput, _intender, 
   {{0x4f140241,0x77ec034c,0x6fe30147,0x83780161}},	//   _gaattira, _gabbasov, _كرەپوستن, _luvatta_, 
   {{0x739500a6,0x3b190035,0xd84b0290,0xf9b102c7}},	//   _ulusu_, _berazdan_, _arcunads_, _mandante, 
   {{0xb9b5045b,0x1ce90059,0x526c020e,0x728c0202}},	//   _bildespe, _показаха_, _ithoba_, _sunkún_, 
   {{0xa3410343,0x0e9f0375,0xc9c001db,0x00000000}},	//   _macedon_, _akumufun, _ەسكەرۋسى, --, 
   {{0x62d8011d,0x35bb00d5,0x1baf03e8,0x4395015f}},	//   _numele_, _manampah, _sovraštv, _clust_, 
   {{0x930d0108,0xeb74009a,0x6dd10139,0xa99400f7}},	// [2360] _dumasar_, _amiselwa_, _baleṣu_, _alikonst, 
   {{0x927e0230,0x639502ee,0x63f80294,0x02c8004a}},	//   _mwens_, _fluss_, _achuni_, _дастанны, 
   {{0x626d0409,0x01ca0035,0x521200f9,0x2f40002b}},	//   _netop_, _корвалол_, _ibaha_, _বিষন্ন_, 
   {{0x4394018b,0x522a01cd,0x5f6a0066,0xbf3a0121}},	//   _piesa_, _горат_, _явцтай_, _afortuna, 
   {{0x53050208,0x76a001d5,0xa01a0079,0x7a0900ef}},	//   _موتان_, _صفحہِ_, _kompensā, _مقتدي_, 
   {{0x2a090625,0x5040020a,0xdd0601b6,0x03eb0214}},	//   _nezamest, _الاتاۋ_, _collapse_, _amatye_, 
   {{0x0f5a00ba,0x3f4503a9,0x00000000,0x00000000}},	//   _مریشکدا_, _алхазов_, --, --, 
   {{0x839401a2,0x843d0193,0x98c4045f,0x72fe0203}},	//   _tiesa_, _धर्मनिरप, _inneband, _scrites_, 
   {{0x130c02a2,0xc3ea0147,0x137a018b,0x0ec300a2}},	//   _lumabas_, _meitat_, _valabil_, _فڪرمند_, 
   {{0x431602f4,0x88570086,0xd6dd0192,0x922403b2}},	//   _plazo_, _میانداد_, _풍림아이원_, _evoked_, 
   {{0x52dc0380,0xcb360401,0x13c30046,0x4c2e0047}},	//   _dangzrwi_, _वेश्यावृ, _коюптур_, _apparenc, 
   {{0xf2940103,0x1f2a023c,0x8b0c0071,0x3b1b0056}},	//   _bhokisi_, _کالهیندا, _رافیک_, _abaprist, 
   {{0xd3b7033f,0xeb9a058e,0xb5030241,0xd2ba014c}},	//   _ahovelo_, _रेणुकूट_, _billaach, _lindani_, 
   {{0x840502e4,0x1ab80219,0x4291031e,0xb36c01a4}},	//   _allokazz, _belweswe, _ubijene_, _sangisi_, 
   {{0xb2cb0585,0x626c00ac,0xb38e01e5,0xfbe40258}},	//   _poslovi_, _malog_, _aposteli_, _aldeboar, 
   {{0x5d1b00d6,0xb2d40138,0x06a400f3,0x65f100bd}},	//   _fianaise_, _bardak_, _bebengaf, _glimmeri, 
   {{0x5b6c0367,0xa2360358,0xd27e0197,0x88b500ff}},	// [2370] _estatíst, _lonje_, _pwent_, _ראכמסטרי, 
   {{0xd395001c,0x068000d8,0x190400d1,0x52bb011a}},	//   _pouso_, _arreflex, _ধ্বংসাৱশ, _והנפש_, 
   {{0xef4c0033,0x1a2a01b5,0xf5ef00aa,0xb2920076}},	//   _respunsa, _chichaka_, _anamneti, _errado_, 
   {{0x83940074,0xac7f035b,0xdf3a033a,0x7e8e00ff}},	//   _toisen_, _obiskom_, _sfortuna, _וואזנער_, 
   {{0x7c6202af,0x0c73019d,0xac0f0205,0xe9c20004}},	//   _amarobe_, _amisala_, _bostiris, _danmbala_, 
   {{0xe304013d,0x43030203,0x6404023d,0x4cae0083}},	//   _rilataj_, _balayat_, _traffico_, _passlung_, 
   {{0x726c0230,0xc2dd005b,0xe166011a,0x530d001c}},	//   _lanons_, _hiroaki_, _שיגידו_, _pumasar_, 
   {{0x6bdc0223,0x29540009,0x420001b5,0x6a09013a}},	//   _чармайлт_, _poslanst, _njhini_, _messbrau, 
   {{0x89ed01fe,0x8e40001c,0xee440573,0x00000000}},	//   _bulisara_, _nakakomp, _anbabaxa, --, 
   {{0xc31e03ba,0x4fe4004e,0xe3eb00b4,0xc9c7014f}},	//   _haschen_, _bisitaho, _sapte_, _таласа_, 
   {{0x9c26014e,0x49ef0335,0xec2d04a4,0x46e90227}},	//   _природе_, _amīṣāṃ_, _buanachd_, _percerai, 
   {{0x0d1e04b9,0x52910015,0xf26e002e,0x1f230171}},	//   _lemonade_, _hayaan_, _otpora_, _zamrzava, 
   {{0x1f050154,0x38e20244,0xaaab031c,0xc25a028e}},	//   _купате_, _получен_, _asesoría_, _unklin_, 
   {{0xd2330409,0x36dc01c1,0x1e260368,0xcd8803e6}},	//   _ショッピング_, _डेनिश_, _блокирањ, _geweecht_, 
   {{0x938701bc,0x00000000,0x00000000,0x00000000}},	//   _swurd_, --, --, --, 
   {{0xafdc069e,0x425b018a,0xe395041e,0xc6ed00a0}},	//   _ficheiro, _gwallt_, _mouss_, _garambaw, 
   {{0xfc12006f,0x220f0304,0x7d8800e2,0xe1e50126}},	// [2380] _kampeni_, _tanyalah_, _beweecht_, _сукупнос, 
   {{0xa2500211,0x5395047d,0xa96b0241,0x9c6f00cd}},	//   _темах_, _fresch_, _eshiyaat, _crousch_, 
   {{0xc39502aa,0x3acf0109,0xb36e03d0,0x00000000}},	//   _tresty_, _गुलरिया_, _trogiru_, --, 
   {{0x2dbe028d,0x6ed70033,0x6d4600be,0xccc6003f}},	//   _corizina, _decisiun, _تاشپاقا_, _jimischu_, 
   {{0x9f3f04d2,0xdb5c0172,0x5eb303bf,0x9f2e002e}},	//   _styresma, _wɔtsena_, _borokgon, _najvećem_, 
   {{0xec670034,0xa0e700a6,0xa8e00568,0x428f036d}},	//   _flottar_, _سازشونه_, _friskliv, _euphort_, 
   {{0x19e9003e,0x50970361,0xee4302bb,0x831700c5}},	//   _прокопье, _времен_, _मुख्यधार, _essayez_, 
   {{0x6cca0372,0x715c0064,0x67460092,0xf9e40184}},	//   _archifau_, _кумар_, _前記グレイチャ_, _bikorana_, 
   {{0x52ea00ce,0xc3ea0201,0x930102af,0x43e80397}},	//   _aksidan_, _afitte_, _inyandi_, _ваксинза, 
   {{0x43ea01a1,0xcc1202d9,0x87b70024,0xa3fa001c}},	//   _editie_, _anapogi_, _স্পেইন_, _bituun_, 
   {{0x7ece0138,0x1f700092,0x839402f6,0xea3003a2}},	//   _pozisyon, _を表示するために, _alisin_, _एशेजः_, 
   {{0x6396026c,0x715c020a,0xfd6901a3,0xf3800450}},	//   _passim_, _тумай_, _پينٽاگون_, _marrum_, 
   {{0xed49048a,0x5f500152,0x721206a2,0x9a510297}},	//   _кернеу_, _абруен_, _mbaho_, _бәялим_, 
   {{0xa2b201dd,0x6aa70188,0xb2cb04a4,0x34e3015e}},	//   _akaduha_, _парасту_, _gasda_, _кордоду_, 
   {{0xdaa60220,0x437f0235,0x895e0044,0x12a60396}},	//   _картофи_, _annassa_, _abilitie, _brijuzi_, 
   {{0xa395037f,0x8e9200df,0xc13b02e1,0xf34f003c}},	//   _olasan_, _montrent_, _prionsaí_, _dipenek_, 
   {{0x93410247,0xf3300026,0x33ec02e4,0x52ff033a}},	// [2390] _چندان_, _makkelij, _multipli_, _karattri_, 
   {{0x82900255,0x02000176,0xab7200ae,0x538f0244}},	//   _ennast_, _mamiko_, _indongor, _supporti_, 
   {{0x8c4602fe,0x07b4023f,0xa531002b,0x39aa0013}},	//   _کرامت_, _nonsensi, _ভোকাবুলা, _зокир_, 
   {{0xa2d50516,0x9d19021b,0xfc620299,0xca93014e}},	//   _becomin_, _прекраще, _جەمشېت_, _повери_, 
   {{0xdc4e01ea,0x9394025c,0xe87b002b,0xb1620397}},	//   _هملند_, _wieso_, _গণভবনে_, _amagobol, 
   {{0x6e92038d,0xc2310072,0x3fbb037c,0xaf12040f}},	//   _kontrent_, _warmina_, _secundus_, _portreta, 
   {{0xcfa40212,0x23eb0086,0xb90404a4,0xa11902eb}},	//   _adcenter_, _kapta_, _chlaraid, _техникч_, 
   {{0xc13e0041,0x72fb01da,0x3292000e,0x820801d5}},	//   _изыбзоур, _ንኣስቴር_, _rurano_, _informál, 
   {{0xf30e0095,0xa20200a2,0x7ed90033,0x0b1700db}},	//   _karimunj, _hatima_, _areisens_, _parandus, 
   {{0x52d90059,0xf2e7005b,0x827e0288,0x2d1302eb}},	//   _accedi_, _chancen_, _iteng_, _медальта, 
   {{0x2a8901aa,0x50b3019e,0x7fcf040e,0x6d1f046f}},	//   _officers, _аксэсуар, _bilistar_, _jéngste_, 
   {{0x96020091,0xd2020013,0x69fe0032,0x6395012b}},	//   _ilaliuti, _natija_, _dacherta_, _plusy_, 
   {{0xb2d50440,0xce4e0162,0x83e100bc,0x17730177}},	//   _baronka_, _барди_, _ditutupi_, _егырҭ_, 
   {{0x42900034,0xf503036d,0xcd7d0307,0x1c7d0307}},	//   _annast_, _galldach, _kwamanga, _kwamangq, 
   {{0xf5580072,0xb9170244,0xd5050144,0xac1702ea}},	//   _arakitay, _продан_, _intleach, _провал_, 
   {{0xa31601e4,0x2519017a,0xf19700c1,0xfb9700ef}},	//   _knize_, _семент_, _अनुयायां, _ماهران_, 
   {{0x03950402,0x1a8f0054,0x75c30040,0x576b02bb}},	// [23a0] _ulasan_, _ministan_, _גטסבי_, _odizolow, 
   {{0xc9fe03bf,0x8c1301db,0x437e02ee,0x947e0163}},	//   _parament, _ءبىراۋىز, _professj, _professz, 
   {{0xf20800f0,0xdce0034c,0x52a60331,0x72f2041e}},	//   _informác, _адмиралт, _tilber_, _talianu_, 
   {{0xf2e901f0,0xc3f80122,0x4b0f01a0,0x125b0098}},	//   _kapinga_, _adhuh_, _hangalas, _kvalme_, 
   {{0x3b480148,0x035f0334,0x38410220,0x02360267}},	//   _未找到關於_, _aongoke_, _екология_, _saljem_, 
   {{0x43dd030b,0x6b8e015e,0xbd3e0206,0x9c5c004f}},	//   _mutwe_, _اسمانسا_, _prinesie_, _bettoon_, 
   {{0xd2fc0633,0x429001b6,0x39da0054,0x65bd003c}},	//   _usage_, _kinase_, _anoninsa_, _campurak, 
   {{0x7a430279,0x3a0904dc,0x7f3b013f,0x439501d9}},	//   _cinquièm, _وتوبی_, _dibrenna, _duesch_, 
   {{0x26580014,0x7889006c,0xb87c0145,0x373d01f4}},	//   _trajneri, _гирандаг, _filipinu, _aralashg, 
   {{0x4df7027d,0xb202012c,0xa2fc0372,0x0b4300c8}},	//   _развили_, _yatima_, _bragu_, _йомарт_, 
   {{0xd87d0374,0x668d00db,0xb384020a,0xd1280109}},	//   _портлашл, _बनवास_, _аттандыр, _podvazko, 
   {{0x1e4f030c,0xbb9f02ac,0x01f9010d,0x93010229}},	//   _hunaukma, _رووووعه_, _merambah_, _namazov_, 
   {{0xd2fc0409,0x92960151,0xe740025f,0xcea10347}},	//   _fragt_, _stepchil, _bakolong, _gedrukte_, 
   {{0x32ff000f,0x1f5b02a2,0x1c0300bc,0x720300b0}},	//   _kariyer_, _nakaraan, _tumpeng_, _abdirahm, 
   {{0xfcad04d7,0x0a7c00a5,0x85190161,0xb29004e6}},	//   _tengingu_, _fitafita_, _десерты_, _binase_, 
   {{0x8394018b,0xca73005e,0xb7090008,0xd73001e0}},	//   _piese_, _خۇشپۇراق_, _меники_, _بیلادی_, 
   {{0x34850255,0x52020160,0x77a6026d,0x321500bb}},	// [23b0] _दिवाना_, _satima_, _akceptov, _سوچئے_, 
   {{0x972800af,0x53040006,0xe29000d1,0xd202030f}},	//   _продукці, _didalam_, _finare_, _matika_, 
   {{0x884d030a,0xe2ba046f,0xa19204cb,0x0c73024b}},	//   _destinos_, _mécht_, _clienţi_, _cuartos_, 
   {{0x226e0219,0x1847018b,0xd2570325,0x7b78019a}},	//   _lokukhul, _салариу_, _portuqal, _dauredna_, 
   {{0x6fb702c7,0xd90e011a,0xd5020183,0xf8c002ea}},	//   _vertrieb_, _hazardou, _aretinao_, _distrugg, 
   {{0xab9902b6,0x4bb4052b,0xd4760145,0x0e9b0198}},	//   _тарапына, _नामंजूर_, _гувернёр, _zamudite_, 
   {{0x08b50203,0x029e0162,0x12b6029d,0x3eb7009b}},	//   _contener_, _мизан_, _cercei_, _багажны_, 
   {{0xb27e02c7,0x59d201d1,0x89d300b7,0xc422012f}},	//   _kannst_, _interest, _веребиле, _kamamado_, 
   {{0x93940044,0x532001eb,0x43cf01cf,0x69870466}},	//   _choses_, _amayo_, _previe_, _ocekivat, 
   {{0x42020058,0xef9e00be,0x53670361,0xe5dc004a}},	//   _datika_, _жоокерле, _тематике_, _ayagıñ_, 
   {{0x845801bd,0x78cc03bf,0xb2f00061,0xbe830291}},	//   _орналасу, _athetoid, _마포자루를_, _عايشة_, 
   {{0x7d2c00b4,0xbf03039e,0xa28200a9,0x5f1e03b0}},	//   _ачестей_, _সমাজত_, _isahani_, _টিউটৰিয়, 
   {{0x239a0019,0x872500e6,0xb9f50005,0xfe3103f2}},	//   _تانگوودو, _中国第二次经济现, _allianza_, _marginaa, 
   {{0xb6af02ca,0xbbfe00e2,0x00000000,0x00000000}},	//   _fhoghlai, _eastfrys, --, --, 
   {{0x439400b3,0x53e7023a,0x2c580162,0xfd17047d}},	//   _enesi_, _kútik_, _باتارىيى, _erklaert_, 
   {{0x2202011b,0x69bf01d1,0xa89902d3,0x46ed014b}},	//   _batika_, _generate, _projetad, _faransaw, 
   {{0x7f1300d8,0xfc690260,0x995f028a,0x426201a4}},	// [23c0] _formator_, _morrazo_, _waingere, _nakomaki_, 
   {{0x2a7d0476,0x68f101db,0x8ae40303,0x0a0c0303}},	//   _aidavira_, _بولدىڭعو, _dikurant, _dumalane, 
   {{0xfab1045e,0xec7300e5,0xcb5400ae,0x6dba02ac}},	//   _област_, _quartos_, _akamubar, _تساهم_, 
   {{0x97dd0270,0x1387040e,0x4c52027a,0x81860235}},	//   _cavalcav, _angrar_, _amatera_, _cintitān, 
   {{0x95c400d1,0xc85f0109,0x0c080211,0x50bc02b6}},	//   _ঘোঁৰাৰ_, _symbolů_, _blogikir, _бозымбае, 
   {{0x54fb061b,0x3c1202a6,0x49440344,0x2e89023e}},	//   _ज्यादै_, _campani_, _akimorne, _اوزاوا_, 
   {{0x6a660016,0x9b6600ff,0x926501ef,0x1941013c}},	//   _טשעכיי_, _טשעכיש_, _autoriai_, _tutublar_, 
   {{0x32d80132,0x82fc04ad,0x62ec022d,0x34880145}},	//   _neked_, _brags_, _scrisse_, _каралеўс, 
   {{0xecf0018b,0x62fe0250,0x22cb019a,0x5c73013b}},	//   _андардул_, _vargje_, _beddit_, _juarros_, 
   {{0xe45e0037,0xe92b0282,0xa236006a,0x00000000}},	//   _በበላይነት_, _ahimaata_, _ponja_, --, 
   {{0x3e1700aa,0xc3f1024e,0xb107020f,0xa3950414}},	//   _gynecoma, _tenzije_, _دارزښت_, _sousi_, 
   {{0xa29002fd,0x92f20420,0x8262048f,0x886e00e6}},	//   _annait_, _украл_, _bakomaki_, _县工商行政管理局, 
   {{0x52fc05d0,0xa2ff04b9,0xb25a01a4,0x81c60321}},	//   _asaga_, _mariner_, _abongisi_, _odstavek_, 
   {{0x727a0024,0xeaee0288,0xbcde002b,0x1adf027f}},	//   _অনুস্থিত_, _ersteche, _বাঁকা_, _camenets, 
   {{0x829204ef,0x4a860607,0x4def0032,0x00000000}},	//   _buraco_, _amantomb, _pindajva, --, 
   {{0xefa400e9,0x0e2304a2,0x9c6f013d,0x32910044}},	//   _berenger_, _formados_, _librojn_, _infant_, 
   {{0x8a9b055d,0x220e015e,0x3c21024a,0x8d64019c}},	// [23d0] _penindas, _санай_, _banilẹru_, _gbasilẹ_, 
   {{0x4d7a0037,0x6b180264,0x4ade01de,0xe8bd039e}},	//   _ቅቅቅቅቅቅቅቅ_, _nabaruan_, _қашпа_, _bortafor_, 
   {{0x7c0300b9,0x0496028b,0x6de601db,0x7d7e0235}},	//   _numpang_, _бырзентә, _электрлі, _विस्तारत, 
   {{0xe29d03d4,0x330703c2,0x150b031c,0xa302018f}},	//   _biljaka_, _allayah_, _titulado_, _lunadlu_, 
   {{0xab130415,0x6af300b4,0x248704c7,0x12a6008d}},	//   _gefallen_, _numeroas, _бибера_, _dilbar_, 
   {{0x427e06a3,0x036c016e,0x92f1019f,0x56340012}},	//   _gwent_, _hangisi_, _hatiani_, _गिरहूं_, 
   {{0x89aa002c,0x225a023b,0x0c5101b7,0x3aac0126}},	//   _сонин_, _ekolu_, _मुनेः_, _розібрат, 
   {{0xc379019f,0xec840148,0x7c510108,0x00000000}},	//   _mataifa_, _的搜尋結果_, _waktuna_, --, 
   {{0xf6220437,0x23950281,0x726c0056,0xee2b0211}},	//   _forordni, _clasen_, _athola_, _hurghada, 
   {{0x637a0082,0xc5fa021e,0x625a02a0,0x19e7033f}},	//   _matakin_, _superhjä, _ikolu_, _pokotala_, 
   {{0xdc7105e3,0x8ee9034d,0x72d8013f,0x5fd9020f}},	//   _मान्छे_, _berkuran, _beked_, _beentsho, 
   {{0x83eb0088,0x81d203ab,0xc61000de,0x22b20012}},	//   _teatre_, _kyseliny_, _ebulungi, _सतजुग_, 
   {{0x91cc0089,0xd9c90018,0x5929004d,0x62e5008e}},	//   _барбарис_, _buloudra_, _公共工程主辦機關, _fotosop_, 
   {{0x92ca00bd,0x5595014e,0x9e2303a2,0xc2c900ef}},	//   _meddle_, _vlasinsk, _सनाउल्ला, _basonge_, 
   {{0xb22903fe,0x6c0b04e8,0xddd0000d,0x530d0296}},	//   _летнее_, _versatz_, _elektrip, _utmanar_, 
   {{0xf9460262,0x13950065,0x73ac002e,0xc2d8006e}},	//   _animirle, _blasen_, _natpis_, _fekee_, 
   {{0x99960289,0xc47a00ad,0x026c01f0,0x160b05b3}},	// [23e0] _amakonda_, _anifeliz, _ithoma_, _bykomsti, 
   {{0xf61d011d,0x92c40033,0x00000000,0x00000000}},	//   _nenoroci, _chemics_, --, --, 
   {{0xe25a023b,0xfd9f040b,0x675a018d,0xc74302eb}},	//   _akolu_, _milenzhe_, _ምዕባይን_, _курст_, 
   {{0x12d80544,0x09e40322,0x69730465,0x02910287}},	//   _kekee_, _avangura_, _omenjene, _invaze_, 
   {{0xc2780255,0x00000000,0x00000000,0x00000000}},	//   _saunad_, --, --, --, 
   {{0x9dba0062,0xd26c014b,0x027e02d4,0x80fa0309}},	//   _escargot_, _malon_, _gronds_, _ixtisasl, 
   {{0x7cb20031,0x09880132,0xf2fc0195,0xcc6504d7}},	//   _tanganku_, _meghirde, _dragh_, _bikarúrs, 
   {{0xe35b01ff,0x7a2800e6,0x2a9403bf,0x5ddb04e3}},	//   _biogaia_, _我的灌水记录_, _kenyedit, _vjekosla, 
   {{0x41450373,0xd23c008d,0x02d1038f,0x926c0211}},	//   _בושות_, _исомидди, _nilotek_, _valoa_, 
   {{0xd2b5033d,0x546906a4,0xdd040268,0x62ee00fe}},	//   _kondane_, _jordskok, _ailroadr, _laifau_, 
   {{0x918f02ec,0x727e0663,0x41840397,0x7c0700d9}},	//   _illaahay_, _ntena_, _amabhodl, _pistoras, 
   {{0x52fc04bb,0xb26c03ec,0xc71b00da,0xf4d70178}},	//   _iragi_, _kalon_, _оперэ_, _atreṣyat, 
   {{0x84c7010f,0x227e0516,0x499d00c8,0xb51d00d1}},	//   _тамдиди_, _sannie_, _табыр_, _গৰমকালি_, 
   {{0x426c043a,0x23940256,0xb23701d5,0x6f2a01cc}},	//   _dalon_, _viesi_, _بیوپاری_, _bhallair_, 
   {{0xc364012c,0x436901b3,0x6e5901a1,0x8bac00be}},	//   _فورمن_, _бразильц, _stabiele_, _كەلەرى_, 
   {{0xb3960147,0x36f0034f,0x0c7100a6,0xb5ce014e}},	//   _ئچىڭەر_, _ziyacelw, _aimssec_, _установу_, 
   {{0xab74053d,0x54a703bf,0x00000000,0x00000000}},	// [23f0] _amaselwa_, _didaerek, --, --, 
   {{0x40530045,0x8180005e,0xed0801d9,0x327e0347}},	//   _почиње_, _قامۇسى_, _geklickt_, _tannie_, 
   {{0xc1cd0041,0x09490064,0x5d31002b,0x227e016a}},	//   _рзымхои_, _requerir_, _পাঠকপ্রি, _avinon_, 
   {{0xc9c20321,0x138700a3,0x137b0100,0x2c7601be}},	//   _ugodnost, _sigrar_, _nalazim_, _टिष्टा_, 
   {{0x4c030050,0xf316002e,0xde4300ba,0xd2b10054}},	//   _sumping_, _ulazu_, _سێمیناره_, _dandana_, 
   {{0xa847048a,0xe2fc0274,0x1aa70060,0x7d00018c}},	//   _фараби_, _bragi_, _жайлап_, _forumber, 
   {{0x62980169,0x9b7701d7,0x288302bb,0xe26c06a5}},	//   _নতুনরাও_, _consista_, _विभूतियो, _maloo_, 
   {{0x30c6042a,0x738800f2,0x0c5201dd,0x55f000b6}},	//   _anelical, _tērpu_, _amatara_, _qammalsi, 
   {{0xd27e0025,0x09860052,0x2c24032e,0x8f1e0043}},	//   _etena_, _मौसममा_, _tamachir, _amatoffa, 
   {{0xda2e0092,0xe2b60301,0x92cb00d3,0xf2d803eb}},	//   _街遊びのスポット, _bircə_, _spadá_, _hemels_, 
   {{0xff3d0088,0xef300387,0x4b46010d,0x21b3028a}},	//   _التنچىسى_, _kwesikwa, _diajarin_, _ڪالرو_, 
   {{0x05d10184,0x6f0f02d9,0x4267003c,0x00000000}},	//   _aracumvy, _avetaava, _تیفوسی_, --, 
   {{0xc26c01c5,0x2a170147,0x9f9301f4,0xd61f0235}},	//   _kaloo_, _تاازىم_, _berdilar_, _ग्राहयेत, 
   {{0xf83e01ee,0x3e7a0148,0xb4bc012e,0xa27e040f}},	//   _диске_, _雙方各負其責_, _غیرجانبد, _duonos_, 
   {{0x02e90298,0x44370074,0xb2930194,0xf29002c2}},	//   _pounamu_, _включает_, _concretm, _inname_, 
   {{0xd26c037e,0x7e18012c,0x00000000,0x00000000}},	//   _laloo_, _wajeruma, --, --, 
  
   {{0xa2d8046d,0x5c730047,0xc062029c,0xe3950261}},	// [2400] _rumele_, _alerter_, _chosafun, _anuso_, 
   {{0xf26c00a6,0x3c79029b,0xbc35002b,0xebdf01df}},	//   _naloo_, _bëreek_, _দলিলসমূহ_, _kamester, 
   {{0xe27e005b,0x49af0040,0x9540050b,0xa26c028d}},	//   _utena_, _במילה_, _लोंढे_, _zalon_, 
   {{0xac0300bc,0x70990040,0x3907008d,0x596a00f7}},	//   _mumpung_, _מחשוף_, _tavallud, _alinomit, 
   {{0x630b01d5,0x9c850040,0x0052015e,0x4b430099}},	//   _ڈکٹیٹر_, _מושיק_, _كىچىنەكە, _ekubikis, 
   {{0xfd9b0626,0x62ef044d,0xc2fc0422,0xc379053b}},	//   _fungovat_, _awliyaa_, _pragi_, _aguarda_, 
   {{0x631901cd,0x0df5030d,0x59fc0348,0x09d30145}},	//   _бозрасии_, _goldenpa, _baliraba_, _біржавы_, 
   {{0xb47e0058,0x121f01fc,0x3c510403,0xc7ba0120}},	//   _aldeliko_, _bakkeeli_, _alitara_, _mellebik_, 
   {{0x4394029f,0xf00e002e,0xe2fc0141,0xa8800061}},	//   _miest_, _ostvaren, _palatasi_, _페이스리모델링_, 
   {{0xc2c106a6,0xc2e301f7,0xc27e01d8,0x2d9c0435}},	//   _kuhlala_, _altitud_, _kumne_, _словачки_, 
   {{0x4cbf04ac,0x01ff01be,0xdead03ec,0xcc780309}},	//   _спецпред, _obrazech_, _kallashn, _getsəm_, 
   {{0x53fb0464,0x595e0272,0x60050161,0xf34102d7}},	//   _intsinzi_, _abanneet, _амурской_, _artella_, 
   {{0xacb70080,0xfc8f042c,0xf3d10153,0x00000000}},	//   _bilitseq, _svidjaju_, _ぶっ生き返す_, --, 
   {{0xb27e0004,0xb2bf02e1,0x00000000,0x00000000}},	//   _etenn_, _تمتاز_, --, --, 
   {{0xe2ed0243,0x92d5048f,0xe7540235,0x06b8020f}},	//   _kooriyah_, _ekulusu_, _अभिषवे_, _basendlw, 
   {{0x8c74026c,0xf0450371,0xfeba04ad,0x430600b3}},	//   _salutis_, _sperimen, _difounun, _aldamak_, 
   {{0x120d0163,0x8289018e,0x626c0013,0x449f014a}},	// [2410] _بالترتیب_, _diyakoni_, _halol_, _vitatkoz, 
   {{0xe3940256,0xd9ed044b,0x2b67004d,0x026d01b3}},	//   _viesu_, _overhold, _不含週六日及國定, _нормаліз, 
   {{0xf320029c,0xa1420128,0x722401c8,0x2f7005ce}},	//   _amayi_, _ўтмас_, _unikla_, _buçuk_, 
   {{0x29c5001d,0x49f300b5,0xe39403c6,0x65e600be}},	//   _diferant, _choreygu, _giest_, _فاشىستتە, 
   {{0x3304004f,0x13060125,0x057501c5,0x00000000}},	//   _bataxal_, _aldajak_, _hindisah, --, 
   {{0xc63701ab,0xda6c02ac,0x2a5d0396,0x8ae60041}},	//   _धिरहीं_, _آلمشآركآ, _ungerija_, _рыцәкны_, 
   {{0x23940026,0x04ca01cd,0x775d00fa,0x00000000}},	//   _kiest_, _anochoko_, _gigising, --, 
   {{0xdc010017,0x527f012e,0xe2f703ad,0xf2fc00b4}},	//   _तुलसीपुर_, _ajanlo_, _bilanċja, _calarasi_, 
   {{0x10350034,0xd2a40037,0x7d5701ab,0xb6f30025}},	//   _samtakan, _መሥፈርት_, _पलँगरी_, _श्रद्धया, 
   {{0xb7aa01b4,0x727e01b9,0x13b6014e,0xf2250268}},	//   _letterli, _atenn_, _obaveza_, _agekay_, 
   {{0xa30402ef,0x7a030015,0x00000000,0x00000000}},	//   _katafal_, _badanaye, --, --, 
   {{0x7d0b00ee,0xced30061,0xb2d80216,0x425a0255}},	//   _herritar, _교환및반품_, _dumeke_, _tollal_, 
   {{0x6d3b01bd,0x374303b8,0x13990258,0x7634004d}},	//   _атанды_, _долинка_, _húske_, _明清之中國歷史人, 
   {{0x7e62007d,0x4b2203b0,0x7c7d021c,0xb780000a}},	//   _mencukup, _forboden_, _naostro_, _bankitig, 
   {{0x327e0288,0x7c7c04ca,0x0ee10212,0x1375023e}},	//   _eteng_, _agisson_, _antiquis_, _cakrakem, 
   {{0x939501da,0x9843005b,0x851102e5,0x00000000}},	//   _flasin_, _mellemru, _laurindo_, --, 
   {{0x23fa01cc,0x00000000,0x00000000,0x00000000}},	// [2420] _kurute_, --, --, --, 
   {{0xd2240129,0x5e30027a,0xf6d006a7,0x09ff00d9}},	//   _chikwa_, _imigrana, _antakeli, _varastot, 
   {{0x6a730217,0x0c4d02eb,0xab1b0066,0x729004d7}},	//   _almafeta_, _түшмэл_, _durangon_, _einatt_, 
   {{0x17c7015e,0xaab803a2,0x6c980019,0x02ae01a3}},	//   _بارلاردى, _मोटोकॉर्, _جۇپتايسى, _لسٻيلي_, 
   {{0xd7a70344,0x3bc600e6,0xe2e603e8,0x00000000}},	//   _amerlari, _任何组织和个人不, _ribnica_, --, 
   {{0xd3040140,0xbb2f0192,0xeaa2017a,0xd4690143}},	//   _matagal_, _추천해주세요_, _abahlamb, _горивата_, 
   {{0x53d5016d,0x22f100c5,0xfa5900b7,0x99520344}},	//   _شىۋېتسىي, _小时内送达_, _arafatda_, _biologst, 
   {{0xc03c0264,0x7d2e0148,0x9f1300e7,0xf3ac00d1}},	//   _liveliho, _dubitare_, _anitegra, _গিটাৰবাদ, 
   {{0xc9ef002b,0x622f0061,0x38930061,0xc9720024}},	//   _সুসংবাদ_, _부동산중개소_, _정책홍보관리실_, _সংস্থাটো, 
   {{0x430e0043,0x00000000,0x00000000,0x00000000}},	//   _amaboga_, --, --, --, 
   {{0x675c0429,0x227e015c,0x8d8e02ac,0x3248012a}},	//   _kakitang, _steng_, _استكمال_, _dwoma_, 
   {{0x67e503a2,0x10610247,0x6037007e,0x2341002c}},	//   _आतंरिक_, _دنیرو_, _dattaman, _angelun_, 
   {{0x4a5e032d,0x025b0010,0xb3b60322,0xad310291}},	//   _малдарын_, _atalwe_, _abavuka_, _لووووووو, 
   {{0xd2a70127,0x0316006a,0x49ad008f,0x2a86015e}},	//   _arabek_, _moizy_, _salvestu, _барчын_, 
   {{0x42940320,0x058002df,0x6d2c031d,0x0262019f}},	//   _anakeni_, _televisy, _irrigate_, _wasomaji_, 
   {{0x63850338,0xb29100e9,0x9b670079,0x22cf0397}},	//   _prestigi_, _invant_, _koncertā_, _acloque_, 
   {{0x8fef0052,0xb3f800ab,0xc0400153,0xd5bb00fc}},	// [2430] _विवादित_, _kaiutu_, _クションの落札者_, _musangch, 
   {{0x829102c5,0x7bc402ac,0x7c8c0148,0xc5bb0313}},	//   _tifare_, _تنانير_, _臺北市政府地政處_, _lusangch, 
   {{0x0a5f024f,0x4fd302d5,0xb99600ae,0x1c0d014f}},	//   _besetaka_, _tehnoloo, _amakanda_, _признање_, 
   {{0xdb67019b,0xe316049e,0x453e0282,0x793a0037}},	//   _koncertą_, _plazy_, _maaharah, _የአንጎላ_, 
   {{0xbc120196,0x62010422,0x830c05ca,0x0d7f005b}},	//   _kampani_, _izbire_, _tomamos_, _aromabea, 
   {{0xa291007b,0xf3ea047d,0xddbb01fc,0x930c01a2}},	//   _invade_, _neitst_, _anninnaa, _rotaļu_, 
   {{0x259b0223,0x521202f6,0x0d700076,0x00000000}},	//   _horrelak, _damhin_, _инает_, --, 
   {{0xab08017d,0xdeb000ba,0xd9b10081,0x562800d0}},	//   _アルバイト_, _لاکێشه_, _landsnet, _aminoazi, 
   {{0x214c0199,0xd8590309,0xf2e702ff,0x320103ba}},	//   _cinephil, _kitablar_, _ajanten_, _speien_, 
   {{0xd26e04c1,0x37ed0235,0x261e0012,0xcb80004d}},	//   _reponn_, _वर्ण्यते_, _चारउफूस_, _如能提出交易時之, 
   {{0x72fd0155,0x14e900af,0xaa1f0223,0x8c5f037c}},	//   _drygt_, _почитати_, _alabaina_, _vestram_, 
   {{0x5c1a0044,0x13db0022,0x7a95007e,0x59e70289}},	//   _הכרזות_, _портретт, _हनुमता_, _dokotala_, 
   {{0xda310008,0x229e02da,0xbd980105,0x6df2027b}},	//   _استرولوع, _рибар_, _sugestie_, _नैष्कर्म, 
   {{0x32e5035d,0x443e0420,0xb436022a,0xd3eb0527}},	//   _hronika_, _разно_, _penamiko_, _odatle_, 
   {{0xc01a00f2,0x00000000,0x00000000,0x00000000}},	//   _kompensē, --, --, --, 
   {{0x44190147,0x09080296,0x75f90046,0x0b17046c}},	//   _теманы_, _populär_, _سالشىتىر, _leipzige, 
   {{0xd27e0662,0x77b90047,0x9d8b0181,0x5ad001cd}},	// [2440] _atene_, _signalez_, _leverede_, _ахлот_, 
   {{0x9d9e01a4,0x4eb303d1,0xae10002b,0x995a0311}},	//   _elendisa, _tendencē, _নবীজির_, _ዝቕበልን_, 
   {{0x237b0140,0x32960334,0xaf5f0133,0xbb2d0028}},	//   _malalim_, _amapanil, _baqatton, _israsaas, 
   {{0x894500de,0x8b620050,0xa3620299,0x00000000}},	//   _مناسبو_, _bentukna_, _سەيپۇل_, --, 
   {{0x10970074,0xc6ef0041,0x1b150046,0x02e80053}},	//   _франции_, _ззымҧшаа, _companye, _pekiwan_, 
   {{0xf2ed02e2,0x1f660010,0x886f051e,0x1dbb00e7}},	//   _arsnick_, _ekubuten, _acusados_, _ausingca, 
   {{0xc80700f2,0x53f904ca,0xb2590331,0x3db7031c}},	//   _vispirms_, _arbust_, _seinasti_, _debilida, 
   {{0xa30e0048,0xdfd90037,0x0320066f,0x8f40011d}},	//   _amabega_, _ሲተረጎም_, _ganchos_, _dragusan, 
   {{0xb2920698,0x7d0d000c,0xf225005d,0x00000000}},	//   _murako_, _amboveve_, _guerekõi_, --, 
   {{0x05400173,0x36a103db,0xf65903ee,0x7dae0052}},	//   _স্বাভাবি, _abathath, _stakleni, _पूर्णरुप, 
   {{0xfbee00bf,0x6303036a,0x3e32034c,0x00000000}},	//   _башкирии_, _matalau_, _barganna, --, 
   {{0x02900326,0xc6c8019d,0x290b0019,0xa95f03d5}},	//   _ainaye_, _asasemph, _айланада, _cainlere, 
   {{0x42d701cf,0xc26c023b,0x161002c5,0x00b7004d}},	//   _besonio_, _ialoa_, _avimbisw, _有效提升市民無恐, 
   {{0x026c00e9,0x5d9e044a,0xd3f10448,0x3e4c02b9}},	//   _demont_, _alendisa, _foredrag_, _mutatott_, 
   {{0x16d50068,0xac5c0312,0x8dae0052,0x62b20127}},	//   _saraakii, _listenn_, _पूर्णरूप, _bandenn_, 
   {{0x453d006e,0x8a0f0315,0xbc070135,0x2f86036b}},	//   _bariwaay, _babalule, _заводта_, _пророци_, 
   {{0x9aa90059,0x620e00c7,0xca9f036c,0x73f900fa}},	// [2450] _наречени, _хаман_, _antiokos, _drburt_, 
   {{0xc3ea0435,0x82d1043a,0xbae90368,0x88dd0157}},	//   _zahtev_, _ispodom_, _zgrožen_, _बाँटा_, 
   {{0x13950277,0x8c6001b5,0x6f77004b,0x5cc001e0}},	//   _seesaw_, _bubutsa_, _красноуф, _بیراند_, 
   {{0xfc0a0281,0x63a500ce,0xf7100111,0xea7c0020}},	//   _berthels, _konpromi_, _abuminev, _mitamita_, 
   {{0x82c8018d,0x029000b7,0x727e02a3,0xb3d80193}},	//   _ጸገማትና_, _adlary_, _hannie_, _बिहारमधी, 
   {{0xd2780093,0x81a7005e,0x9a8e0600,0x0e14018c}},	//   _правобер, _ﮔﯘﺭﯗﭘﭙﯩﺴ, _कपोलकल्प, _domeinna, 
   {{0x826c0245,0x18ef0144,0x8d6d011a,0x42020333}},	//   _ladon_, _ومعظم_, _איסתא_, _avvià_, 
   {{0x2d6f00d6,0xdd010111,0xc27e0116,0xf24806a8}},	//   _احزان_, _scultore_, _mannie_, _verovati_, 
   {{0x06f4015d,0x63940307,0x4303026a,0x89cf0169}},	//   _कारवाँ_, _aziswa_, _katalau_, _prefiere, 
   {{0xeb2d02f6,0x48c402da,0x21720299,0x83e7022b}},	//   _simbahan_, _televend, _ئۈندەيدى, _býtti_, 
   {{0xe8fb0071,0x89f90513,0x00000000,0x00000000}},	//   _bahanipu, _mubalese, --, --, 
   {{0x329001f7,0x42d30365,0x7303008a,0xfb1f0211}},	//   _deman_, _motorek_, _matamau_, _rakastan_, 
   {{0x3d3f01e6,0xb2f10163,0xf2e302a4,0x1db401ac}},	//   _zaplatít, _optikai_, _paginae_, _ووجود_, 
   {{0xd2a100ec,0x88390302,0x6225042d,0xe2fd0111}},	//   _менталіт, _сайфулло, _diakra_, _amagru_, 
   {{0xd29001c0,0xd8ef019b,0x225b0420,0x804700c1}},	//   _neman_, _tarpusav, _avalie_, _थायलंड_, 
   {{0x4342001c,0x72010231,0xfabe0156,0xa2d80466}},	//   _abrehan_, _impie_, _אקאמאדיר, _veceg_, 
   {{0x8d950190,0x930302be,0xdc030107,0x0394001c}},	// [2460] _wretched_, _salamat_, _lumping_, _tamsi_, 
   {{0x49f900b0,0x17c40040,0x331900c4,0x81640347}},	//   _arrintaa_, _הרגעים_, _ريڍار_, _liggaaml, 
   {{0x89e402c1,0xe8e300c8,0x3d7e0061,0x8b83027b}},	//   _ivangura_, _аңлашыла_, _길거리에서_, _संयुक्तस, 
   {{0xe26c0245,0x9ca5022e,0x9611005e,0x1290012c}},	//   _badon_, _longwood_, _ﺗﻪﺟﯩﺮﯨﺒﯩ, _minane_, 
   {{0xc33d03ce,0x2824026f,0x1ac1004d,0xc1b304b3}},	//   _میرات_, _ءىزدەگەن, _教育暨青年局_, _bevennoù_, 
   {{0xebfc026f,0xf4b5009b,0x92550235,0x2af70088}},	//   _تەحينكال, _konbentz, _विधेहि_, _дарегим_, 
   {{0x073b00f4,0xbeb2009a,0x596a0222,0x64630060}},	//   _alkooleg, _anzongon, _optimise, _قىرعىندا_, 
   {{0xc26e0476,0xe3dd0102,0x00000000,0x00000000}},	//   _kupora_, _kutwa_, --, --, 
   {{0x4d1b033d,0x5d9f0011,0x326c0082,0x7c7c0513}},	//   _surrogac, _abongera, _gadon_, _hlasela_, 
   {{0x42b60246,0x5dc50320,0x7373015c,0x2ba601c0}},	//   _cerchi_, _edliweke_, _rodange_, _arizikin_, 
   {{0x032e0044,0x6c530400,0xa86b0247,0xce47008a}},	//   _בוטוקס_, _mettila_, _aslinipu, _matailup, 
   {{0x966d0144,0x627e04ea,0x2a0801d4,0xf2ea01da}},	//   _اليسا_, _kumno_, _parapett, _mitologj, 
   {{0x47e301bb,0x80f405a2,0x38890223,0xad1e011d}},	//   _bolandyg, _ओबेरॉय_, _наранцэц, _inaltime_, 
   {{0x8aa502ec,0x69d00420,0xfee80326,0xdb19034c}},	//   _gurigiis, _решив_, _akakatan, _asralgan_, 
   {{0x52240179,0x995e0218,0x97770192,0x326c0095}},	//   _anikna_, _acilitie, _속성신고하기_, _wadon_, 
   {{0x03f402c3,0x03030005,0x8e350181,0x526e00a7}},	//   _hostí_, _mumaint_, _morgenma, _suposa_, 
   {{0x484e05f9,0xfc12012c,0x9290069c,0x5f55002f}},	// [2470] _publicid, _kampuni_, _zeman_, _chapashp, 
   {{0x92b10103,0x82d5033a,0xb2290333,0xc3c40156}},	//   _handina_, _barokka_, _ajaxiaul, _שראדער_, 
   {{0x8a4003ac,0x2e1400e3,0x5394005d,0x929000e9}},	//   _beberapa_, _བསྒྱེལ_, _ahesa_, _lemal_, 
   {{0xc26c0342,0x52120212,0xb7ec0128,0xa27e0165}},	//   _padon_, _jcaho_, _سیلشماقد, _iteni_, 
   {{0xb290029f,0x5a9b0420,0xb4340039,0x838302c5}},	//   _nemal_, _jornalis, _sorkuntz, _asiyane_, 
   {{0x32900193,0xf27800a9,0xb63605c5,0x76eb0166}},	//   _teman_, _ukuntu_, _ब्रहमा_, _beachtli, 
   {{0xa1620200,0xa20200d8,0x726f0102,0xf3ea0116}},	//   _websaịtị_, _actica_, _progaram, _peitie_, 
   {{0x22050085,0xf10a0272,0xb95900bf,0x6e4304d8}},	//   _bilitaki_, _abakugol, _венето_, _cabanaya, 
   {{0x07ac002b,0x98fc02a2,0x96830187,0x3acc004d}},	//   _শিউলি_, _palatand, _papelari, _申訴受理單位_, 
   {{0xcb5003d0,0x9a40034d,0x129000e1,0x8302005a}},	//   _النعمان_, _seberapa_, _demal_, _lunablu_, 
   {{0xb5d90192,0xb7660004,0xc66a006d,0x00000000}},	//   _크라운제이_, _ekstrèm_, _аўтобусе_, --, 
   {{0x52d80068,0x3a150255,0x127e02f7,0x79730347}},	//   _badeed_, _kombinee, _bueng_, _beinvloe, 
   {{0x635f03f3,0x62630085,0xae000053,0x739400a8}},	//   _laagste_, _kasonaki_, _pelepasa, _chesa_, 
   {{0xac3c0342,0x8c5a04d8,0x525a01f0,0x23f4023d}},	//   _segondè_, _کراماتھ_, _builwe_, _frutto_, 
   {{0x39760347,0x2a08008f,0xfaf3013f,0xf8cf0350}},	//   _geliefde, _garantee, _falsente, _በመሆንዋ_, 
   {{0xde4303b2,0x527e02b5,0x2f430166,0x2c5401d1}},	//   _password_, _fueng_, _passwort_, _posting_, 
   {{0x627e048f,0x11420265,0x729001af,0xfab70272}},	// [2480] _eteni_, _settimeo, _jemal_, _agikakas, 
   {{0x5344005d,0x8aca02ac,0x2dac02fe,0xa26e0066}},	//   _airespe_, _شراميط_, _ayinakup, _lepoan_, 
   {{0x6a0d046f,0x8e4300b2,0x20600307,0x5e430408}},	//   _rassismu, _barabade_, _esisidin, _hazakaza, 
   {{0x4dce02d3,0x9a7e0257,0x8d4601a3,0xfeea0297}},	//   _видеа_, _ragnarss, _ماسٽرس_, _балларын, 
   {{0x434206a2,0xa301005a,0x5e3402d3,0x139502aa}},	//   _ingendo_, _biyahdi_, _плетени_, _kresby_, 
   {{0x6dc3014e,0x73ea0358,0xc39500ae,0x00000000}},	//   _улици_, _atitid_, _inusu_, --, 
   {{0x8c3600a4,0x2b6100be,0x50f10459,0xf6d00157}},	//   _центерра_, _атындагы_, _कविवर_, _ग्रिड_, 
   {{0x17e30093,0x12e70449,0x2e48031a,0x97a00347}},	//   _полиции_, _ukinuto_, _anabarra, _ammunisi, 
   {{0xb9cb0439,0x23120273,0x02900418,0x6d5d03b0}},	//   _dzolonga_, _empezó_, _cemal_, _bagsværd, 
   {{0xd26c00ca,0x32d900bd,0x62900022,0x6aaa03a0}},	//   _demore_, _breest_, _dinale_, _letheres, 
   {{0xfc550217,0x77bf01a7,0x2f0302eb,0xed9d02e2}},	//   _evitate_, _обратная_, _соргог_, _ashlisha, 
   {{0x27bb019f,0x4cd5018d,0xbc1e0076,0x5d3b053d}},	//   _vinginev, _ጎረቤተይ_, _изборнат, _bafikile_, 
   {{0x432b041b,0x3a8900e9,0x1d83028e,0x427e0009}},	//   _shahlang_, _lanivers, _wapemaot_, _steni_, 
   {{0x5aa20041,0xaef400ff,0x5ef20235,0xec1803f3}},	//   _амҩатран, _יאָגאַ_, _anavatap, _garander, 
   {{0x631c01e1,0x1b3b03cc,0x77680156,0x2f6902c4}},	//   _аңлай_, _ছাত্রছাত, _געבײַדע_, _певаљки_, 
   {{0xb5eb0297,0xc49d03c2,0xba9601ad,0x27a00046}},	//   _испанияг, _aerofoil_, _madiskub, _poguessi, 
   {{0xeae60058,0x320b00c5,0xe27e000e,0x3a8301d9}},	// [2490] _bigikön_, _地质工程师_, _buend_, _entziffe, 
   {{0x15cd00f9,0x1c5c0036,0xf7780425,0xfd7c00ef}},	//   _kugabany, _miotail_, _قوناغی_, _سهولتونه_, 
   {{0x7d95017f,0xc26c0230,0xa53d0010,0x00000000}},	//   _aallakaa, _ladob_, _besiboph, --, 
   {{0xbf69019b,0x7a0203db,0xb517017e,0x00000000}},	//   _palangos_, _lamadoda_, _boksisto_, --, 
   {{0xbf440057,0x32480138,0xce4301e8,0xfb19008d}},	//   _የጽሕፈት_, _bilmem_, _kabalaya, _tarafdan_, 
   {{0xe378023e,0x4c260012,0x9566004d,0x8cf00109}},	//   _ornamen_, _कजरौटा_, _非複數決標_, _सूचकको_, 
   {{0x67d8006f,0xd3950405,0x39680040,0x1b8d012c}},	//   _سبزواري_, _knust_, _מתבייש_, _kilichor, 
   {{0xf6d30154,0x3c5d0321,0x78830227,0xdc8d05f8}},	//   _asociati, _kartico_, _rahimahu, _азимова_, 
   {{0x631604a5,0x8c1c005a,0x527e0564,0x36800120}},	//   _anazo_, _bimunnis, _huene_, _handeedi, 
   {{0x827e023b,0x86c20320,0xf201030f,0x85cd027f}},	//   _kuene_, _enkandzi, _hiainu_, _bugabany, 
   {{0x642402ec,0xc2b5019b,0xeb6c00cd,0xe5b8023c}},	//   _لى۪کھاں_, _londone_, _admonesc, _bakarubh, 
   {{0xb29d02c2,0x338602ae,0x73b9017d,0x62c403d5}},	//   _verkoop_, _sakrij_, _delvist_, _ainmeas_, 
   {{0xa31603de,0xe2b20274,0xd25a02e1,0x486d030a}},	//   _enazo_, _vandinn_, _muilte_, _ameixend, 
   {{0x233700c8,0xbae90410,0xeea80222,0x4e05019b}},	//   _бармай_, _kgathele, _pourtant_, _клубень_, 
   {{0xa3cd0074,0xd20100a5,0xfd2d03a8,0xfc4401d5}},	//   _предметы_, _fiainu_, _উপধানতা_, _hangkárt, 
   {{0xa394049e,0x3599053f,0xf47203a2,0x2e59015a}},	//   _ciest_, _phirunak, _नरेन्_, _bilbilaa, 
   {{0x53b20047,0xb22600bb,0x927d04d7,0x0f900291}},	// [24a0] _disque_, _حدیبیہ_, _andheiti_, _ألتراس_, 
   {{0x261c0074,0xb2d90265,0x51b200f8,0xee4000d1}},	//   _mielenki, _breekt_, _উসাইন_, _লটিঘটি_, 
   {{0x439604b9,0xd394047d,0x9f240065,0xaac7017a}},	//   _trusty_, _giess_, _aufeinan, _санадро_, 
   {{0x8dca018d,0xc37f0275,0xc27e015e,0x62780289}},	//   _መብርህን_, _manamea_, _troncs_, _khungu_, 
   {{0xbeb101da,0x1bea020e,0x1965004d,0x82ee03db}},	//   _evropian, _didemokr, _危險藥物條例_, _ijenali_, 
   {{0x12f10198,0x1e2500c7,0x964200d8,0x6c9a0153}},	//   _natisni_, _булгари_, _acabariá, _おごと温泉暖灯館, 
   {{0x75eb0192,0x1a1302b6,0x32500094,0x00000000}},	//   _공정거래위원회_, _تاڭسىڭدى_, _كىلەڭ_, --, 
   {{0x7afc0005,0x7a0e009b,0x6c0100b4,0x1eb90145}},	//   _indemnis, _prestaku, _acestor_, _спачатку_, 
   {{0xdcfb0211,0xe27e046d,0x386d00da,0xe38700bc}},	//   _операции_, _ndingo_, _констрын, _awerni_, 
   {{0x6379012c,0xe97f01b5,0xeed300a7,0xb78b004d}},	//   _matakwa_, _mafikele, _solistes_, _一匹馬的故事_, 
   {{0xd1e6006f,0x2e4300c0,0x8bea0102,0x89f9026a}},	//   _بارودي_, _kababaya, _kidemokr, _niusilad, 
   {{0x71560391,0x237f0172,0x22ba008d,0x97100193}},	//   _барыла_, _nanabea_, _muddati_, _वर्दे_, 
   {{0x3730019b,0x4555004d,0xef2d044c,0x00000000}},	//   _смяротна, _台灣壹週刊_, _bereknin, --, 
   {{0x3c6f023d,0x9c5b03b9,0x9c690037,0x6df500e1}},	//   _storico_, _mistuni_, _ኤልሻዳይ_, _boddante_, 
   {{0xa3160324,0x4c2c015c,0x915000c5,0x425a0498}},	//   _unazo_, _mojikosu_, _全国人民代表大会, _skoly_, 
   {{0x368c0052,0x2cac0041,0xcc120028,0xf2d80049}},	//   _देहाय_, _усҳәарҭа, _horreeys, _tokee_, 
   {{0x09550142,0xa59b032e,0x9bcf0061,0xbcf7019b}},	// [24b0] _agrahaṇa, _walinkañ, _어린이만화_, _электрыч, 
   {{0x3bd800bc,0x0f0d002b,0x00000000,0x00000000}},	//   _تحلیف_, _হিজড়া_, --, --, 
   {{0x07c800c9,0x5df5012e,0x838701f1,0x44da0205}},	//   _vietarow, _بوکوحرام_, _ministër_, _молни_, 
   {{0x64990141,0xf30503ac,0x6b1601f1,0x00000000}},	//   _birgalik, _ditanam_, _kompanit, --, 
   {{0x2fd00242,0x42b40466,0xfcbe0145,0x93b002ee}},	//   _malikdir_, _majci_, _макей_, _dejqa_, 
   {{0x2fee0360,0xc2010320,0x32ea012a,0xac680338}},	//   _किनारमा_, _empin_, _jezioro_, _annuari_, 
   {{0xe2d400c5,0x991301d7,0x00000000,0x00000000}},	//   _第四十六条_, _spectatu, --, --, 
   {{0xedb20247,0xab05024a,0x34f9023c,0xc3420288}},	//   _nannanna, _afasegbe, _مبارزين_, _übermo_, 
   {{0x3f930338,0x954f0075,0xf17e04f9,0xca9b00d9}},	//   _fondator_, _heimastý, _allamill, _kuningas, 
   {{0x027f00d2,0x92ff02d4,0xb6d500b0,0xafed0206}},	//   _itung_, _scriver_, _maraakii, _spáľňu_, 
   {{0xaae30162,0x4c170209,0x4a570013,0x731600ea}},	//   _июндики_, _ammaaner, _минага_, _hoazy_, 
   {{0x2771027b,0xcdb60361,0xd47301a4,0x245c06a9}},	//   _रूपसिद्ध, _царские_, _komentak, _federaçã, 
   {{0x73950534,0xd2900318,0x07ae0133,0x4eae0203}},	//   _giuse_, _kemaa_, _dentinii, _refrenat_, 
   {{0xe39401a7,0x895c02c3,0xb26d033a,0xdeb1006a}},	//   _voisin_, _vedomost, _ospitati_, _antoeran, 
   {{0xf30d06aa,0xb49f01d5,0x2a7700e6,0x037f00d9}},	//   _membina_, _مبالغہ_, _党的十六大以来_, _sanasta_, 
   {{0x537804a4,0x9a9202ba,0x79d401ef,0x00000000}},	//   _camarun_, _abayenze, _мужчын_, --, 
   {{0x298303be,0x9787015e,0xe1fe0320,0xdf42018a}},	// [24c0] _arahunga_, _بازاسى_, _dbcircom, _amhrisia, 
   {{0x929001d9,0x9be401a3,0x639506ab,0xc75c0011}},	//   _gemaa_, _بولٽن_, _viuse_, _bakisang, 
   {{0x2c6002b3,0x115f0153,0xcaf10041,0xc57a0040}},	//   _mestras_, _まちづくり_, _ҟалҵеит_, _הכתובות_, 
   {{0x805e012d,0x88d5013b,0x38ba004d,0xd7a80350}},	//   _ikenomik_, _jacuting, _主計處預估_, _ተቋርጧል_, 
   {{0x7ae200ad,0x92cf02bb,0x52910197,0x867f0223}},	//   _ngalaman_, _fundacji_, _divage_, _handiegi, 
   {{0x5e8d027e,0xc347028d,0xeec2022f,0x34f10476}},	//   _компонов, _talerla_, _коштам_, _chimwech, 
   {{0x09ed01e6,0xdf1300b4,0x665203f3,0x00000000}},	//   _doprovod, _dormitor_, _vakkundi, --, 
   {{0x082d018d,0x5d8500ee,0x2eb500c7,0x7394005b}},	//   _ኣይፈቅድን_, _мужаан_, _активлыг, _armsny_, 
   {{0xc2c50100,0x887006ac,0x3dbc0494,0x02ba033a}},	//   _obiluje_, _músicas_, _obratite_, _sudditi_, 
   {{0x3d8000e3,0x6dce0371,0x123b0156,0x00000000}},	//   _མགྱོཌ_, _фидер_, _פּיסק_, --, 
   {{0x92010246,0x83a30272,0xef1703b9,0xc29000d2}},	//   _ampio_, _abapya_, _sistaspa, _semah_, 
   {{0x642901cd,0x3dfa0399,0x92d80339,0x270a00c7}},	//   _абарқудр, _fureseve_, _āhewa_, _kerttelä, 
   {{0xe20e0159,0xac9402a0,0xaba40059,0x8ea305f2}},	//   _баках_, _honerebu_, _agricolo_, _condados_, 
   {{0x12fc0088,0xdea70025,0x49cc0382,0x96c90037}},	//   _milions_, _anulepan, _federexe, _ያተኩራል_, 
   {{0xaaba0076,0xc9dd00a5,0x93f80282,0x00000000}},	//   _предизви, _fagotaga_, _kaiuru_, --, 
   {{0x065c026c,0xc37a00d6,0xec090544,0xd2900198}},	//   _只看該作者_, _ebtahin_, _hoopuka_, _temah_, 
   {{0xaaaf04f0,0xce780101,0x65cc0315,0xe9fe0462}},	// [24d0] _bathobas, _activită, _angaboph, _acrament, 
   {{0x6380003f,0x5fc20040,0x4efc01cd,0x4d68006c}},	//   _beprup_, _טקסטיל_, _туркӣ_, _abamelwe_, 
   {{0xec1f01df,0x4f250113,0x330d0316,0x00000000}},	//   _templar_, _hiarrata, _dumamar_, --, 
   {{0xcc0a032e,0x7d1f0148,0xecb40039,0xfc530272}},	//   _arapiwa_, _經永靖到田尾_, _курсийн_, _atutuma_, 
   {{0x14b2037f,0x068f02a1,0xe3870573,0x00000000}},	//   _dolları_, _allerhei, _amarro_, --, 
   {{0x03ea0195,0x100905b2,0x00000000,0x00000000}},	//   _beithe_, _беркате_, --, --, 
   {{0x194100f6,0x8053023e,0x00000000,0x00000000}},	//   _tuturlar_, _daksenen, --, --, 
   {{0xd3da0368,0x43480528,0xdc88007f,0x00000000}},	//   _правилни, _aiteamh_, _helfeydd_, --, 
   {{0xed9000f5,0xc5bc0354,0x72d50396,0xcdc6033d}},	//   _сежде_, _бостанли, _karozza_, _anvizaje_, 
   {{0xc3160130,0xafc90060,0xa3720127,0x542201ab}},	//   _inizi_, _нәрселер, _romaned_, _करऽबऽ_, 
   {{0xbc60037c,0x9bd80157,0x19f206ad,0x00000000}},	//   _vestras_, _niedobor, _borgerne, --, 
   {{0x427e0190,0x42910451,0xf27e03f3,0xf29d0147}},	//   _mwinen_, _difane_, _breng_, _دااتىتار_, 
   {{0xe3b600bf,0x638400cf,0x77b601aa,0x45d800ec}},	//   _значения_, _aidsiifi_, _agreeing, _рэшткі_, 
   {{0x4db6004a,0x6c06011a,0xfaae00f7,0xe322005b}},	//   _камский_, _entropy_, _asekuron_, _foryou_, 
   {{0x90ca0187,0xf36600c4,0x227e01e9,0x417e0133}},	//   _можности_, _فائينل_, _ereng_, _dolphino, 
   {{0xf2dd0423,0x12900288,0xdb830318,0x696c04fc}},	//   _nikoliv_, _wemai_, _kahokaho_, _remitent, 
   {{0x527e015c,0x226d00a5,0x4bb105af,0x62db0147}},	// [24e0] _greng_, _ataoto_, _diskutir, _укмкнын_, 
   {{0x861d0003,0xc1a506ae,0x438601db,0x0f3202d5}},	//   _개인정보보호정책_, _comezará_, _сессиясы_, _चिल्लइने_, 
   {{0xa29103cf,0x604e004d,0xd39504ca,0x00000000}},	//   _linkler_, _中華民國刑法_, _coason_, --, 
   {{0x704a0121,0x06390184,0xe6230405,0xf7d80465}},	//   _edificio, _bagisubi, _плавання_, _označeva, 
   {{0xc27e026b,0xadfa0462,0x25c100d1,0xe2d8030a}},	//   _suena_, _aradigmp, _পথাৰখন_, _achego_, 
   {{0x32d5024e,0x03fa0384,0xbdc500a2,0x43eb0014}},	//   _razliku_, _struje_, _maridhia, _afatit_, 
   {{0x724e0643,0x7dc90037,0xc4a801d5,0x00000000}},	//   _plodovim, _አጥብቀን_, _elmarasz, --, 
   {{0x03ce0049,0x7c7c034e,0xb79d00d0,0x6a7d0109}},	//   _agkvi_, _alaslla_, _тиара_, _अमेरिकाब, 
   {{0x5c1e02eb,0x090401ad,0x14460040,0x62e1008b}},	//   _эмээлт_, _kalalawd, _ובשביל_, _indilug_, 
   {{0xe529011f,0xb959015e,0x7e0300de,0x712d027b}},	//   _уникалт_, _acollime, _beneempa, _प्रसन्ने_, 
   {{0x239406af,0xdad004dc,0x5b720220,0x439500ed}},	//   _mbese_, _کردیت_, _стени_, _hiusa_, 
   {{0x323f0417,0x0e18017a,0x927e0071,0xc7db03f0}},	//   _vermaak_, _охиста_, _mrene_, _baksviðs_, 
   {{0xa34d0120,0xd8210188,0x8fc20061,0x897f0418}},	//   _esseram_, _ҷанҷол_, _발명협회장상_, _indirile, 
   {{0x87c5047d,0xcf4a011d,0x59c70035,0xccfd011a}},	//   _warschei, _neaparat_, _басалар_, _שביתת_, 
   {{0x29ee0066,0xcdb901db,0x304c0053,0xdb65019d}},	//   _arduradu, _сатиралы, _dirumahn, _fulumira_, 
   {{0x227e040e,0x7d280169,0x798501db,0xb27e0347}},	//   _treng_, _ফরমালিন_, _اندورران, _arend_, 
   {{0x0a0003bf,0x2704023a,0x4d1f046f,0x00000000}},	// [24f0] _bajalefa_, _masturbá, _jéngsten_, --, 
   {{0xe20000e1,0x208a01cd,0xa29401dd,0x4eb7040f}},	//   _addina_, _саройкам, _agakoni_, _indeksas_, 
   {{0xc90902ba,0x7a0601f7,0x807b0089,0x69c100e6}},	//   _бетараф_, _nombrose, _elemtälä, _奥运圣火到我家_, 
   {{0xb6cd021a,0x6f430028,0x9fbe040e,0x2a850092}},	//   _argamani, _warshada, _grunnsto, _この作品は_, 
   {{0x3a3100d1,0x027e0282,0xc28c032f,0xbb3a04c7}},	//   _বাজিছে_, _erene_, _levantam, _запленил, 
   {{0xc3c5023e,0x4b8803e9,0xb179004d,0x339904d7}},	//   _جانوری_, _kabirler, _苗栗市廠商_, _dísar_, 
   {{0x024103b9,0x87b5053f,0x85b60089,0x14c801e1}},	//   _jallumpi_, _larusipx, _жванецки, _наградла, 
   {{0x1c6502ac,0x9b5a016d,0x00000000,0x00000000}},	//   _عواصم_, _сайламди, --, --, 
   {{0xe787004b,0x129000fe,0xc6c80350,0xc3160014}},	//   _уралды_, _kemau_, _የመከራው_, _unaza_, 
   {{0x727e03d8,0xacf90287,0x9da800e7,0x0eea0092}},	//   _krene_, _aktivně_, _almiyasa, _serveret_, 
   {{0x08db0462,0xf42c0161,0x1a3400ba,0xd8780156}},	//   _accruing, _огонь_, _خۆڕاگر_, _קעיפינג_, 
   {{0x5b4f018d,0x7c66003e,0x00000000,0x00000000}},	//   _ተታሒዝዎ_, _буровойҙ, --, --, 
   {{0xce4e018b,0x4e9e00b3,0x7d8e01db,0x6ca000f8}},	//   _дарде_, _маялы_, _قۋىپپىن_, _মৃত্তিকা, 
   {{0xd2900372,0x7316040b,0xe25a000d,0xb1b30371}},	//   _gemau_, _dombani_, _millel_, _боровец_, 
   {{0x122500ad,0x9a09014c,0xc31900d9,0x063e0271}},	//   _anakna_, _yabasebe, _приспосо, _innspill_, 
   {{0x189104e5,0x03860433,0xd76e007b,0xf747059f}},	//   _abakungu, _azores_, _canvassi, _familjev, 
   {{0xb04e06b0,0xbc530251,0x550c026b,0x228a03d4}},	// [2500] _emgungun, _kastana_, _নিয়ত_, _prateći_, 
   {{0x9290029e,0x05870317,0xdb880418,0x53030165}},	//   _demat_, _sastojak, _tabirler, _matakau_, 
   {{0x56ca02ac,0x2d9f0479,0x86d70219,0x1230042d}},	//   _أعلمني_, _gépjármű, _ebabambi, _dramora_, 
   {{0x7f6a019b,0xa27801bd,0xbfc000c7,0x63430184}},	//   _padangos_, _магнитті, _абыстай_, _impembo_, 
   {{0x4225036e,0x23680347,0x2764034c,0xc290015c}},	//   _chakra_, _vingers_, _рухында_, _gemat_, 
   {{0x027e0327,0x7f2d065e,0xaebc0291,0x1a090322}},	//   _trene_, _beretnin, _fabraice_, _babarebe, 
   {{0xd2900526,0xd87702af,0x2b6601ef,0xd2fc0179}},	//   _hemat_, _akunkumu, _autorių_, _leigod_, 
   {{0x42eb01bc,0xc2640156,0x23e10009,0xef4803f1}},	//   _reinder_, _עטיקעט_, _lestvici_, _rozprava, 
   {{0x474f0360,0x13d402c1,0xd38701bb,0x5b1901af}},	//   _designov, _kwamamaz, _itergi_, _barandan_, 
   {{0x79f6051f,0x8a09021b,0x7341035e,0x1ee2027b}},	//   _سوریا_, _parantaa_, _istekla_, _दोर्भ्या, 
   {{0x925a0416,0x455e0094,0xf3940116,0x00000000}},	//   _hillel_, _болмасад, _laest_, --, 
   {{0x96810525,0xc20001e1,0x129000db,0x9f7a002b}},	//   _क्रास_, _felisa_, _temal_, _সূত্রপাত_, 
   {{0x89e0030f,0x767b00d1,0xba150192,0x1e400178}},	//   _tokorima_, _অনুস্থান, _combinee, _इवर्णोवर, 
   {{0x8b95030b,0xad9501c8,0x9709015e,0x56050080}},	//   _katikkir, _dvojité_, _бетинин_, _grammini, 
   {{0xd39a014a,0xd9f20274,0xeef1026f,0xc43f0061}},	//   _مسامع_, _borgarne, _بەرنشام_, _가족문화센터_, 
   {{0x120002df,0x83600242,0x92c80117,0x32b80141}},	//   _kelisa_, _yaddaş_, _tovotae_, _агросано, 
   {{0xef3604d0,0x9290029b,0x00000000,0x00000000}},	// [2510] _hausaksa, _kemam_, --, --, 
   {{0x9292054f,0xaa7d0356,0xc27e0461,0x72310096}},	//   _ntsaim_, _mapasata_, _prene_, _atumiza_, 
   {{0x4f310108,0xa9e400e4,0xc35802d9,0x730501ac}},	//   _paguyuba, _dystrybu, _asefulu_, _جولات_, 
   {{0x69840461,0xcf4402c8,0xb37101d5,0xd64b0311}},	//   _maximala_, _división, _pihenő_, _ዘይቕየር_, 
   {{0x0e510147,0x127f044a,0xb3eb0085,0xd4690204}},	//   _ابئيىرسى, _atuna_, _itatau_, _мигранто, 
   {{0xf98e01cd,0xb92900f5,0x3d8301b8,0x9b80027b}},	//   _қадим_, _биохимик, _kriminaa, _विषमः_, 
   {{0x968e00d9,0xcdb30074,0x00000000,0x00000000}},	//   _прогулки_, _alkaneet_, --, --, 
   {{0x12d800a5,0xeb0b004c,0xb598008d,0x650401cc}},	//   _filemu_, _abagugub, _блоггерл, _अर्धमात्, 
   {{0xd3940212,0xd4d40148,0x4f280629,0x07b40037}},	//   _yaesu_, _看附近餐廳_, _imarypra, _ፊተኛይቱ_, 
   {{0xa11e0037,0x7c700366,0x2f6404b2,0x9c72013f}},	//   _ይመጣብሃል_, _сервером_, _aakalain, _bourlet_, 
   {{0x053e00f5,0xf2640085,0xc2d800f4,0x89810299}},	//   _afrikany, _lakoyani_, _boked_, _ئەگمەس_, 
   {{0x62d800e5,0x4eca02f8,0x3c700158,0x530e01f4}},	//   _homens_, _amanekin, _बुर्के_, _alabaga_, 
   {{0xf9600048,0xb201023d,0x63950292,0x305200af}},	//   _abangere, _ampia_, _presby_, _klarerin, 
   {{0x5f5d006e,0x33eb00a5,0x6c390037,0x1ee400aa}},	//   _nasaraan, _atatau_, _የበለፀጉ_, _diskuwen, 
   {{0x581b01ef,0x021d0177,0x559900bb,0xb9aa002c}},	//   _стремно_, _дануп_, _مفروضہ_, _садангий, 
   {{0x39c8017f,0xd87e0176,0x00000000,0x00000000}},	//   _anemaria_, _cityring, --, --, 
   {{0x8c5302ce,0x49f10303,0x32cb003f,0x00000000}},	// [2520] _pastina_, _khansela_, _relosta_, --, 
   {{0xa2d201ac,0x951f01a3,0x3b670109,0x09eb0284}},	//   _صداقه_, _چولياڻي_, _koncertě_, _webgarde, 
   {{0x3d9d0139,0x32d803e0,0xae540092,0x00000000}},	//   _anenaita, _yoked_, _detailha, --, 
   {{0x99a90397,0x422a0076,0x6959018d,0x0c5c0309}},	//   _қаламрав, _борат_, _ክንብልን_, _fikrinə_, 
   {{0x3dab041f,0xd2d901c4,0xf2020230,0x833700c1}},	//   _okungafa, _besef_, _korips_, _ड्राईव्ह_, 
   {{0xa3f80125,0x51bd0045,0x861f0158,0xbdc500b5}},	//   _tohum_, _ништа_, _इकनॉमिक_, _ателехәа, 
   {{0x8bb30342,0x0e4e00d9,0x8c970041,0xe33c008d}},	//   _rankontr, _opiskelu_, _еизоит_, _bankning_, 
   {{0xb7d30061,0x1953008d,0xd20004b8,0xf96803b2}},	//   _고려대학교_, _декабрда, _swait_, _infotrie, 
   {{0x92900288,0x36f5002b,0x299a0466,0x13e70071}},	//   _memak_, _সহসভাপতি_, _kruži_, _digatèka, 
   {{0x478700be,0x25c504e6,0x09e70486,0x00000000}},	//   _جاشايىم_, _binabagy, _neproved, --, 
   {{0x62d8014e,0xb3940155,0x427800c3,0x73f8037f}},	//   _izmene_, _friska_, _carnem_, _qohum_, 
   {{0xb5d7046c,0x005a02b9,0x9ddc0120,0xe06d04eb}},	//   _geschich, _عریانی_, _fakkiima, _बिरसा_, 
   {{0x5b0e0168,0x595d022a,0xe2780102,0x31cc026d}},	//   _passasje, _magodibe, _chungu_, _rovinatý_, 
   {{0xa27f0054,0x0f650247,0x00000000,0x00000000}},	//   _kwanan_, _diopname_, --, --, 
   {{0xf25a028b,0x427f00df,0x625d0020,0xe3730144}},	//   _otilde_, _gagner_, _fetolofi_, _bomaite_, 
   {{0xa2b90033,0xf81d00da,0x89f1002f,0x75360156}},	//   _tudestg_, _ратификэ_, _chenilla_, _טשעכקאסל, 
   {{0xb31904bd,0x82c60151,0x9e130100,0x2c5500c4}},	// [2530] _kamanā_, _beslave_, _poremeca, _bintiye_, 
   {{0x478000af,0x048500db,0x00000000,0x00000000}},	//   _управлін, _शिवाला_, --, --, 
   {{0x5c8d027b,0x00000000,0x00000000,0x00000000}},	//   _बोध्यङ्ग, --, --, --, 
   {{0xd292021c,0x727e038e,0xa85f0121,0xe26c012e}},	//   _vpravo_, _ironis_, _barreras_, _bakony_, 
   {{0x826c0599,0x027f00ed,0x578503b2,0x9b2a0156}},	//   _रक्षा_, _awanan_, _prevaili, _אדוניהו_, 
   {{0x929002ee,0x9fe30218,0x41f5010f,0x2dc300e7}},	//   _ideat_, _ommissio, _дубораи_, _amlinsha, 
   {{0x425a0144,0x649c0035,0x4b0602f2,0xf7ee0013}},	//   _tuilte_, _аланд_, _asistida_, _istasang, 
   {{0x1a1202af,0xa9510220,0xa97301f0,0x383800bf}},	//   _akabugit, _riportat, _boenjene, _илларион, 
   {{0xd73d0214,0x563e0052,0x507a019e,0x9b8a0374}},	//   _akunakug, _दुनियाँम, _апосталы_, _шодон_, 
   {{0xaaff03c4,0xa58103e6,0x7c720047,0x699500d6}},	//   _المفردات_, _ennersch, _extrait_, _imbhalla_, 
   {{0x44b20138,0xb2ca02ec,0x3394005c,0x827f0084}},	//   _kodları_, _muddadii_, _arisha_, _atung_, 
   {{0xd0e6014a,0xfa6500ef,0xaa520439,0x2c0e03ef}},	//   _نامنظور_, _طبیعي_, _bohelela_, _amatagis, 
   {{0x747d0107,0xe29002ff,0xeb2d00ec,0x28f90185}},	//   _interwik, _remak_, _subalans, _diñgezdä_, 
   {{0x427e02da,0x220101fc,0x6d7f014c,0xac9d0025}},	//   _itens_, _abbire_, _kwamanye_, _क्षेत्रस, 
   {{0x42f1030f,0x4e960052,0x088900ee,0x9e4c0585}},	//   _moriori_, _दुर्गाभव, _занабаза, _dijamana, 
   {{0xca9f012b,0xbd990076,0xd27e00b4,0x818504ad}},	//   _papieros, _комедија_, _atent_, _goyagoil, 
   {{0x277301cc,0x027e029f,0x799a0435,0x507600ba}},	// [2540] _प्रस्थित, _stenu_, _pruži_, _ناداتێ_, 
   {{0x025a01eb,0x52d80052,0x83800590,0x13a3022d}},	//   _atilde_, _rokem_, _prozesu_, _scappa_, 
   {{0x8f620051,0x426b015e,0xdc6500d1,0x2c3e005b}},	//   _katalogs_, _سۉرەتتى_, _প্ৰলোভিত_, _dayphras, 
   {{0xb9bc01f4,0x19c306b1,0x956c0279,0xde9b03ec}},	//   _بیداوسوا, _شامبو_, _autorité, _portalit_, 
   {{0xc278046d,0xe3940039,0x91c1038e,0x95cc0092}},	//   _thundu_, _krisia_, _disebuah_, _træpille, 
   {{0x127e02ee,0x3d0c0022,0xb143047d,0xa26c01fa}},	//   _utent_, _рылды_, _bettembo, _mohono_, 
   {{0x4199015d,0x53940362,0xc667034c,0xde4c0403}},	//   _problemy_, _priska_, _пикетта_, _ankapobe_, 
   {{0xc39c0171,0x6c090182,0xfc300060,0x123603df}},	//   _zakašnje, _alopeka_, _ازىرلەيد, _vinje_, 
   {{0x138f0037,0xfff9014a,0x8f19004b,0x00000000}},	//   _ለዘለቄታው_, _fűnyíró_, _яныбай_, --, 
   {{0xa2d90116,0x35c604b2,0x7231049e,0x3af4004f}},	//   _aesed_, _sinasady, _artmama_, _leeralut, 
   {{0x8a88021c,0xa27f047d,0xcd3a03a0,0xb2d90198}},	//   _moderáto, _stung_, _athikele_, _besed_, 
   {{0xa6d3010f,0x72900305,0x4bca00be,0x42550220}},	//   _роғиён_, _idear_, _تۉركۅي_, _insegnam, 
   {{0x2ee6031a,0x5274008d,0xbd3102ac,0x66f5025b}},	//   _lochlain, _یوزله_, _مووووووو, _partabræ, 
   {{0x629004cc,0xd3f80286,0x3f28020a,0x71330105}},	//   _golaeh_, _kohui_, _бөгде_, _zintegro, 
   {{0x00f30016,0x0bf20163,0xc2bc0170,0x220002f3}},	//   _נאטור_, _kattints, _goodall_, _lediga_, 
   {{0x8206044a,0x627e03ba,0x6fc200bb,0xe3100364}},	//   _andimaki_, _muena_, _باغوں_, _babalux_, 
   {{0x2864011d,0x19620153,0xfab100f6,0x00000000}},	// [2550] _poporulu, _を行っても_, _əhvalatl, --, 
   {{0xfb01014a,0xc5b001cd,0x4b4503f2,0x885301d9}},	//   _forraszt, _alisayik, _рунета_, _inhalter_, 
   {{0x526c04bd,0x873103ee,0x1d3d02af,0x08fc00b7}},	//   _hohono_, _ispostav, _babirabe_, _ashagynd, 
   {{0x52d90172,0x320001b5,0x06280307,0xd44d01b3}},	//   _kesee_, _bohiwi_, _elingazi, _поширюва, 
   {{0x027e0359,0x0278019b,0x827e0452,0x29f900ec}},	//   _utens_, _mediniai_, _jreng_, _nepasite, 
   {{0x127e0409,0x82090092,0x42fd000e,0xda88029e}},	//   _dreng_, _タッチタイピング, _klegal_, _binijenn_, 
   {{0xfb8a0440,0xe3470124,0xcd2f023d,0xd960023c}},	//   _vyananir, _tenesha_, _arrivare_, _akunamse, 
   {{0xe27f037c,0x1d1900d9,0x06e20025,0xc3ea0255}},	//   _itune_, _tekniset_, _उत्तरकाल, _suitsu_, 
   {{0x26820074,0x62f40434,0xd17e036c,0x3d9701db}},	//   _переключ, _asuntos_, _andamiol, _ساندال_, 
   {{0x727e023e,0x0f980368,0x02b203ec,0x92d20085}},	//   _ireng_, _сиромашт, _prodhon_, _siteseni_, 
   {{0x1d13025c,0xf2a3022f,0x984a0144,0x2200021e}},	//   _existier, _папараці_, _leithris_, _heliga_, 
   {{0x2292022d,0x52d8001f,0x022501f6,0x94fd0101}},	//   _impara_, _gokeh_, _snakka_, _локалитэ, 
   {{0xd57d0026,0x287a00f6,0x24e20024,0x43f802a0}},	//   _엔터테인먼트_, _xatirinə_, _চুপাৰ_, _mohun_, 
   {{0x0377032b,0x52ff0270,0x33f8019c,0x8c920094}},	//   _ھىلال_, _scriber_, _lohun_, _شىققانشا_, 
   {{0xb8590135,0x8cf50012,0x6e9c0375,0xf17e008d}},	//   _kitaplar_, _काजकेँ_, _anamunin, _intilish_, 
   {{0x8e350224,0x627f03fc,0x896900d6,0xd70d045b}},	//   _morgunma, _magnar_, _connacht, _жанри_, 
   {{0xa809018b,0xf440020e,0x862004e5,0xc8d3001c}},	// [2560] _бикамера, _atakisik, _alangiri, _pagrangg, 
   {{0x29f50035,0xc5bd01ed,0x33000326,0xdb4c0061}},	//   _хуплап_, _manaopoh, _anganzi_, _외국어학습_, 
   {{0xefbf012c,0xa8fe02a2,0xbb23002c,0x727e016a}},	//   _محنتي_, _matatand, _хэтчбеки, _areno_, 
   {{0x952800fb,0xdc6002d0,0xeade0188,0x3e720237}},	//   _elingakh, _cloutin_, _ботантан, _국가추념일_, 
   {{0x33ce002e,0x1f640006,0x1c29034c,0xb3f8024a}},	//   _kakve_, _masalahn, _adaptats, _dohun_, 
   {{0xa85a00e1,0x09e80253,0xf67b0212,0x21d600ba}},	//   _aydapoor_, _akigitit, _adversum_, _رکێفی_, 
   {{0x927e01b9,0x86f503dc,0xf69b0022,0x2307007a}},	//   _trenn_, _partabrø, _акцияны_, _tilawah_, 
   {{0x22da0511,0x2a550156,0x39c8015e,0xe3fc0100}},	//   _matewu_, _שאפליפטי, _سالماقتۇ, _napunili_, 
   {{0x01660156,0xd27e0226,0xf2c606ae,0x12000115}},	//   _גיהינום_, _greno_, _inclúe_, _geliga_, 
   {{0x47310384,0xb30d06b2,0x2f3300ff,0x3178027c}},	//   _uspostav, _ajoboja_, _סאָשע_, _babammel, 
   {{0xcb160073,0x926c0343,0x4dc80125,0x35ef00db}},	//   _componit, _aydon_, _хатырасы, _जूराउजूड, 
   {{0x37550092,0x76330128,0xe4b20309,0x00000000}},	//   _予めご了承下さい_, _tarannum_, _qolları_, --, 
   {{0x33000108,0xd1af0152,0x70bc00c7,0x38bf0037}},	//   _maraneh_, _banknıñ_, _арттыруы_, _የመፀዳጃ_, 
   {{0xe290031a,0x72780264,0x6c5c0405,0x6306010d}},	//   _aolach_, _barnim_, _подорожу, _ditopang_, 
   {{0x38e002e5,0x19c7004b,0x196001dd,0x12d801fe}},	//   _ahasamiv, _хаталар_, _abanyere, _moken_, 
   {{0xd9cc02f7,0xc5430325,0xadd204cf,0x4cd8011a}},	//   _etleedit, _badımcan, _sithathe_, _בתצוגת_, 
   {{0x2eb3023b,0x03460277,0x77d90145,0x52910258}},	// [2570] _hokuhele_, _eugenic_, _населены, _drokker_, 
   {{0xab8100ee,0x66280349,0x1e1d0227,0xd3ce02aa}},	//   _teknikar, _amilialf, _tengkora, _stovka_, 
   {{0x13ae00d1,0xb6a5031a,0x61c702fe,0x132700dd}},	//   _দ্বিতীয়ত, _burraidh, _سایتونه_, _clychau_, 
   {{0x29e70407,0x00000000,0x00000000,0x00000000}},	//   _nepraved, --, --, --, 
   {{0xa31d0478,0xdc0b00ac,0x127f004f,0x00000000}},	//   _cercada_, _približi, _geenë_, --, 
   {{0x3a7b01a7,0x41ed00c1,0x72c303db,0x432700dd}},	//   _kalliiks, _निचरा_, _kuhlelo_, _flychau_, 
   {{0xc2f901af,0xbdbe027f,0xa6cd0528,0x331602e8}},	//   _agressiw_, _birafise_, _obrachai, _enazi_, 
   {{0x88760076,0x41d1003b,0x82900052,0xa27e0220}},	//   _периодот_, _alelicem, _dolary_, _treno_, 
   {{0xdd90008d,0x241103a0,0xd6110013,0x26c80037}},	//   _тезда_, _bannelak, _fazliddi, _ይሞክራሉ_, 
   {{0x52fe0326,0xb1060678,0xc200003d,0x9236033a}},	//   _pashure_, _vecičky_, _religa_, _binja_, 
   {{0x54c800c7,0x1236005b,0xb9e900fd,0x2b6d00da}},	//   _тарафдар, _jinja_, _cairtead, _фронталэ_, 
   {{0xf26d00bc,0x1f4c02e2,0x92a000ec,0x15680059}},	//   _katon_, _disprove_, _klubai_, _растение, 
   {{0x62d80238,0x427e02c3,0xcb440066,0x4fcc00f1}},	//   _boken_, _steny_, _гүний_, _laribyer_, 
   {{0x826d0016,0x32e5011b,0x8f560061,0x32d50499}},	//   _daton_, _aponaka_, _대구광역시공보_, _sosooga_, 
   {{0x99c0008a,0x72da0685,0xd2900157,0xb3f8019c}},	//   _matelete, _truede_, _polach_, _tohun_, 
   {{0x864703e1,0xa20401a4,0x01c700cb,0x92da01c4}},	//   _forklari, _batikali_, _akumarom, _leuens_, 
   {{0x226d0277,0x668a00c5,0x105f00a7,0x81d10021}},	// [2580] _naton_, _中小企业服务月专, _сократес_, _arvercay_, 
   {{0x6e95048a,0x795c00d8,0xcd310263,0x1c7c0198}},	//   _рухани_, _abondiue, _anonieme_, _presega_, 
   {{0xb967005a,0xa9d104bb,0x735f03d8,0x33210334}},	//   _believet, _muitimed, _najgore_, _amayii_, 
   {{0x425a00d0,0x5866022b,0x6f780040,0x00000000}},	//   _odola_, _betongju, _להתעניין_, --, 
   {{0xd30102bb,0x82580139,0x826c019d,0x8fab0153}},	//   _सहशिक्षा_, _bhaiṣṭa_, _choona_, _ライトオン_, 
   {{0xafd60590,0x3a6a0059,0x122504df,0xef84021c}},	//   _профайл_, _горивото_, _chyksa_, _katolíci_, 
   {{0x1b4900db,0xb36701d5,0xa97602f0,0x226d0343}},	//   _रास्ट्री, _gluténme, _emiholwe, _matoo_, 
   {{0x5c6600f5,0xa9ed017e,0x22b50482,0x0eb202a4}},	//   _санынын_, _ordinara_, _garci_, _inceptos_, 
   {{0x9ba500f3,0x462b0244,0xd2b5001d,0x52d9016e}},	//   _abakwabr, _danneggi, _sarch_, _beceri_, 
   {{0xdbec03f1,0x44b8029f,0x86c403d9,0x00000000}},	//   _dodatočn, _podpisuj, _fanamafi, --, 
   {{0xd2b50082,0x1bf70244,0x49f302dd,0x12b801c6}},	//   _barci_, _сирене_, _bennejja_, _jiddysk_, 
   {{0xf26c037c,0x0d8f019d,0x0e510068,0xb7c10167}},	//   _mylot_, _adalinga, _walaalka, _dadrithi, 
   {{0x0fb3028b,0x0a000009,0x83bd0147,0x35ad0078}},	//   _anítei_, _mrežna_, _حۇيزۋلار_, _заборава_, 
   {{0xd3050243,0xe4a80453,0x81f400e0,0xdc1404dc}},	//   _katayam_, _pouzdano_, _feestlik_, _هوونه_, 
   {{0x60e70039,0x12b50220,0xe9dc0397,0x03200188}},	//   _агентлаг, _farci_, _amagajet, _имиҷи_, 
   {{0x23f4045f,0xc25b033c,0x3224022c,0x7341028f}},	//   _natten_, _ofalus_, _kunkun_, _kereopa_, 
   {{0x129501a6,0xe6970169,0xe04d0370,0xf3050053}},	// [2590] _tamariki_, _মানুষই_, _deproton, _dilacak_, 
   {{0xd24902fd,0x1ef6014f,0xe2570024,0xf697002b}},	//   _ciamar_, _настала_, _নৱগ্ৰহ_, _মানুষে_, 
   {{0x19510338,0xe26d001e,0x4a3300c8,0x8b640212}},	//   _burocrat, _zaton_, _поездан_, _occupata_, 
   {{0x92900157,0x530001ef,0x64f30213,0x4e55015e}},	//   _temat_, _nelabai_, _богатые_, _توپتۇ_, 
   {{0x726d001b,0xb71a02e1,0xbea801ef,0x3291031e}},	//   _batoo_, _cairdiné, _анатолю_, _uhvate_, 
   {{0xd887042f,0x826d0482,0x33a20129,0xab64041e}},	//   _atukkiru, _catoo_, _imepe_, _accupata_, 
   {{0x120501fe,0xf290007d,0x8e430241,0x2b0e0168}},	//   _bilicaki_, _kemas_, _gulaalee_, _massasje, 
   {{0xb980024d,0x12e80051,0x826d013b,0xddff03b5}},	//   _bavikele, _skaista_, _taton_, _kedekata, 
   {{0xe653029b,0x8290005f,0x42ea018d,0x39fc02a2}},	//   _bakkanam_, _demas_, _ግሃድኤን_, _kahalint, 
   {{0xe9d5003a,0xf29000ab,0xddcd0047,0x1b54018d}},	//   _mintaqad, _atiawa_, _associé_, _ዝተለምደ_, 
   {{0x4981024d,0xec5c0274,0xd9940468,0x153804b3}},	//   _belivike, _listinn_, _esihlala_, _beveziñ_, 
   {{0x5c170080,0xc2bd0142,0x927f02be,0x00000000}},	//   _ammarner, _candram_, _buung_, --, 
   {{0xa27f042f,0x4d4901bd,0x9b0e014b,0x284a0161}},	//   _atuni_, _бергей_, _kassisna_, _йорке_, 
   {{0xe1fe0161,0x52000429,0x83730455,0x41680453}},	//   _призы_, _heliza_, _vidange_, _luksuzno, 
   {{0xab0504d3,0x8394017a,0x53b602fa,0x1291002e}},	//   _grignion_, _esisha_, _abavoka_, _shvate_, 
   {{0x73f801b8,0x0290037f,0x729003ac,0x539401df}},	//   _kohus_, _memar_, _cemas_, _baest_, 
   {{0x39380052,0x0945048c,0xa26d02a2,0x5cd10255}},	// [25a0] _शुभेच्छु, _acquirer_, _hatol_, _tahvelar, 
   {{0x43820113,0xbd9d02c3,0x15bd0334,0x321300df}},	//   _تابلت_, _generuje_, _gabadinh, _cocher_, 
   {{0xa2900227,0x06ce0291,0xfd310333,0x4f4200ec}},	//   _gemar_, _بأكمله_, _amazzatu_, _аўстра_, 
   {{0x63860274,0xe7250333,0xe2000020,0x13700036}},	//   _skorar_, _fiamming, _itaia_, _múscraí_, 
   {{0x03ce025b,0xcd9c0297,0x318402f0,0x42f401fb}},	//   _stovna_, _биоценоз_, _asibandl, _planger_, 
   {{0xfcf10450,0xa394013a,0x337b0076,0x7f28020f}},	//   _spitiger, _haess_, _aguardo_, _نظرلرئ_, 
   {{0xb2e30262,0x4eb7023d,0x16220482,0x062b006f}},	//   _dilinde_, _consente_, _manoboli, _معنائن_, 
   {{0x5d6501d5,0x73410172,0xbb170271,0x21cb01f6}},	//   _بدسلوکی_, _merempa_, _bompenge, _tettleik_, 
   {{0x997e0264,0x6394047d,0xd7cf04f8,0x2213013f}},	//   _kapitane, _daess_, _drosophi, _bocher_, 
   {{0xea31012a,0x64d9019b,0x8c6003cf,0x123605bb}},	//   _दर्जे_, _праведзе, _saatler_, _finju_, 
   {{0x82d8007f,0x81a602e1,0x78580233,0x0c5a000d}},	//   _boced_, _يعتقل_, _reganiar_, _esitati_, 
   {{0x9ddc02ac,0xb2d80320,0x4a6b0022,0x394f01e7}},	//   _الغوص_, _hekeni_, _ikhopots, _geklonge, 
   {{0xd68d0372,0xfeb40194,0x92e301af,0xb67f00dc}},	//   _bendithi, _nocentes_, _bilinde_, _voleniti, 
   {{0x53940645,0x720002ec,0xf4a401d2,0xd15c002e}},	//   _često_, _keliya_, _agradoyk, _ispravno, 
   {{0xe2d80053,0xb7b4017d,0xc17f0381,0x00000000}},	//   _toket_, _forsigti, _allisway_, --, 
   {{0xdf30055f,0x59c104b7,0xf9be0169,0xbeb30544}},	//   _tarafınd, _verduide, _স্মৃতির_, _mokulele_, 
   {{0x658900b5,0x6975012a,0xb349040f,0x62250397}},	// [25b0] _refinerí, _bransole, _neretai_, _abekwa_, 
   {{0xaf7100e6,0x14a90436,0x42d801da,0xeb5100c1}},	//   _东方财富网_, _zaobilaz, _kokes_, _gundukan_, 
   {{0xe8150256,0x4f8c02d5,0x32d80044,0x6ec7013d}},	//   _sacensīb, _हक्का_, _jokes_, _kontraŭu, 
   {{0x2394014b,0xc7a7027c,0x6512004c,0x0c610274}},	//   _abesa_, _دفتره_, _abusinso_, _lestrar_, 
   {{0x629000bc,0x3bd20052,0xdb750061,0xf38f01ef}},	//   _semar_, _मनाये_, _시청하려면_, _адпускац, 
   {{0x1e4e0046,0x537b023d,0xf6cc01a3,0x0b41003c}},	//   _тарда_, _sguardo_, _ويھندي_, _آزادیخوا, 
   {{0x650b031c,0x4dee00d0,0x7a050499,0x06b20420}},	//   _recuerdo_, _далангүй_, _fatafait, _бестселе, 
   {{0x427f0288,0x39950094,0x12360079,0x0abc045d}},	//   _mwanin_, _بىلەگىمى, _vinju_, _medjusob, 
   {{0x63b10287,0xff2b00f4,0xa511004f,0x6f440139}},	//   _अभिबृद्ध, _distumma, _menuñoo_, _dvijaśār, 
   {{0x37e7004a,0x6419004a,0x33fa027f,0x4b000192}},	//   _başıñ_, _темасын_, _muruce_, _fabrieke, 
   {{0xa2d8034b,0x4f6c004b,0x2dd900c4,0xdc0b0016}},	//   _poket_, _вышка_, _ٻڪرار_, _vespera_, 
   {{0xcb1f00b0,0xba140024,0x9a51004b,0x42d80472}},	//   _balaaran_, _sambande, _balelloa_, _loker_, 
   {{0xe1b30374,0xc378023d,0x72d903bf,0x1d0002c5}},	//   _ژانری_, _vacanza_, _dientse_, _anotakur, 
   {{0x06d90066,0xacb400ae,0x9c2700ba,0xd2d8009d}},	//   _аравдуга, _akiyuhir, _ئیفلیجی_, _tokes_, 
   {{0x73ea0540,0x1395012a,0x7378023a,0xa27e0092}},	//   _þetta_, _biust_, _sedacia_, _crena_, 
   {{0x65070263,0x328f019c,0x26d3033e,0x83f506b3}},	//   _allemaal_, _adahuns_, _alegará_, _өңүнден_, 
   {{0x52a4017d,0xbf41013b,0xcef1014f,0x69fb023a}},	// [25c0] _広島県広島市中区, _sergipan, _оставио_, _modernéh, 
   {{0xa25a0255,0x6a4100ab,0x82000082,0x23fa0205}},	//   _millal_, _hererapa_, _alhini_, _durust_, 
   {{0xaf7402fe,0x756a0047,0x12f203b9,0xd9ed0107}},	//   _طرفداران, _第三十五条_, _camillu_, _ekstraku, 
   {{0xe9890065,0x6eb60271,0xf98e015c,0xe1a40156}},	//   _parkplat, _innsendt_, _heihinne, _ארעגאן_, 
   {{0x8c380193,0xc55700da,0x12000206,0xfe4b01cc}},	//   _उत्पादक_, _традусэ_, _dedina_, _ayamasyā, 
   {{0xd344013b,0x5e920047,0x1c6101a7,0xd30d039f}},	//   _lucerne_, _contient_, _turussa_, _rebates_, 
   {{0x3eaa0409,0xe23104fc,0xd3ce002e,0x72d8033f}},	//   _この回答内容が不, _primero_, _kakvo_, _fekeli_, 
   {{0x79f20103,0x00000000,0x00000000,0x00000000}},	//   _chiratid, --, --, --, 
   {{0x5eb90307,0x22c90287,0x86bc0004,0xdbfe0016}},	//   _entombin, _sklizeň_, _inoubliy, _balotado_, 
   {{0x9b0c001d,0xafad01b9,0x469f0044,0xa0e7031c}},	//   _jesperse, _dekontro, _coeffici, _olímpico, 
   {{0x531602a7,0x027e0312,0xf39504ec,0x6ece0137}},	//   _fainting_, _krenn_, _arasha_, _тасарсан_, 
   {{0x528e0294,0x4342027b,0xbf5b0461,0xc7c302c7}},	//   _arabyapi_, _शीलपारमि, _almanjan, _reisezei, 
   {{0x92780138,0xd29000d6,0x927e01b9,0x0a66021c}},	//   _okundu_, _folamh_, _drenn_, _gurmánsk, 
   {{0xb9b5021c,0x933d0061,0x06cd022c,0x0a180022}},	//   _neodolat, _스타크래프트_, _baranyai, _iqobella_, 
   {{0x26820051,0xc31c0079,0x3b2d04b2,0x320003ad}},	//   _novembri, _liecina_, _tambayan_, _fedina_, 
   {{0x9cd60094,0x34b7005d,0x97b201b4,0xf3a202ff}},	//   _تاريحىم_, _сухумпри, _volstrui, _monpè_, 
   {{0x528502f7,0x80a803d4,0x00f0002b,0xee0000ba}},	// [25d0] _arakeng_, _доступне_, _সুযোগে_, _بێچوه_, 
   {{0x287502e2,0x32c301b5,0x00000000,0x00000000}},	//   _bounteou, _muhlolo_, --, --, 
   {{0x4bd70013,0x67ab0110,0x00000000,0x00000000}},	//   _билдим_, _austrumi, --, --, 
   {{0x9dad031a,0x5a7e05ed,0x5adf00be,0x3c5200da}},	//   _gainmhea, _kitagira_, _كەزەگىند, _alatura_, 
   {{0x46c90009,0x026c0010,0x9a7e0455,0x00000000}},	//   _strankam_, _iployi_, _scolaris, --, 
   {{0x592c029d,0xf909018b,0x957e04ae,0x70170137}},	//   _конкомит, _сепара_, _конгресн, _тхштх_, 
   {{0xb27e013a,0xecb7021b,0x32f0023b,0xb14a006a}},	//   _frenn_, _границы_, _muliwai_, _eksodosy_, 
   {{0xc27e033d,0xca13027c,0x1f8903d4,0x93eb0122}},	//   _grenn_, _abebenge, _бежали_, _adaté_, 
   {{0x7200005b,0x0a5b0297,0x2d0b0037,0xd2d2013f}},	//   _hajime_, _объектны, _የአትክልትና_, _gidolek_, 
   {{0x9749034f,0x13eb0130,0xaef005db,0x7efb02cf}},	//   _عبداله_, _statud_, _abakudin, _ставови_, 
   {{0x422400a5,0x0235001b,0xd2000055,0x1395021c}},	//   _hunkin_, _boodatti_, _pedina_, _tryska_, 
   {{0x49080296,0x6045033e,0xad0f0515,0xec600488}},	//   _populärt_, _ejararen, _rumorate_, _tartars_, 
   {{0xf27c00b7,0x777002fe,0xa8fb01ac,0xbae800a3}},	//   _гарамалы_, _ebuhlung, _chlaonad, _postopne, 
   {{0xa96e02e4,0x65380312,0x6cf80037,0xde550203}},	//   _ospitant, _seveniñ_, _ከተረጋገጠ_, _detallia, 
   {{0x226d030f,0xb414041f,0x14290690,0x021300d6}},	//   _katoa_, _kungcono_, _tempahan_, _dochar_, 
   {{0xb84e0415,0xc5e40148,0x5291040e,0xff8e0205}},	//   _erstmals_, _屏東市自由路_, _asgaut_, _тарбиячи_, 
   {{0x426d00ea,0x13550273,0x738003e8,0xf20001b9}},	// [25e0] _matoa_, _escenas_, _potrdi_, _redina_, 
   {{0x8230027f,0x735e0144,0x020000bc,0x2a93027e}},	//   _aramira_, _marfach_, _sedina_, _лондону_, 
   {{0x5c0003c9,0xde0e00aa,0x5f20016e,0x4a7e00c2}},	//   _varslet_, _mendelia, _istersen, _zitagira_, 
   {{0x439506b4,0x7f4f01cd,0x4d0d0047,0xe2e60359}},	//   _thuse_, _abasebha, _titulair, _gjinien_, 
   {{0x22d30360,0x79440137,0xb9d9002b,0x8034007f}},	//   _potomek_, _анкараги, _শিশুটির_, _gynefino, 
   {{0x826d000b,0x88460253,0x82000028,0x231000cf}},	//   _aatoa_, _akimorlu, _welina_, _caccabe_, 
   {{0x89770184,0x33b800b9,0xf26f03b1,0x07bf027b}},	//   _cashizwe, _बाजारातू, _épicerie_, _सरसश्लोक, 
   {{0xf8c5017d,0xc34d0663,0x1ea505e6,0x12d80007}},	//   _の検索結果_, _pepepem_, _liedjies_, _bokei_, 
   {{0xc06905d6,0xe249046b,0x09f10397,0xdc6503ee}},	//   _vinparen, _siambr_, _abantula_, _nastupu_, 
   {{0xcd5100de,0x8ed8021b,0x5714028b,0x2355012d}},	//   _ویندوي_, _pariskun, _aserradé, _koperet_, 
   {{0x0c680371,0x38be00d1,0x28fd0071,0xc20000dc}},	//   _annunci_, _গাওঁবোৰ, _bapanipu, _melila_, 
   {{0x507302d7,0x4a160023,0xb49b012c,0x5c3e0264}},	//   _concerto, _отклонен, _افغانين_, _banskã_, 
   {{0x02d50205,0xb051001d,0x91b20017,0xbece01f0}},	//   _بخارست_, _fürstenf, _posezení_, _dibikhon, 
   {{0x1610000f,0xa2a6005a,0x9b2a0350,0x00000000}},	//   _nemlendi, _ngiboy_, _እውቀታቸውን_, --, 
   {{0x27b10040,0xc05a00bc,0x7d0f037c,0x717d02e4}},	//   _preservi, _فرمانیه_, _teutonic, _ikkalkol, 
   {{0x36db0384,0xec6001cf,0xaa940247,0xcae00307}},	//   _srebreni, _bestias_, _روسپی_, _kokuyise, 
   {{0x52e0023b,0xfbfe0434,0xbc1d03f0,0xd27e00ac}},	// [25f0] _nannerl_, _valorado_, _veraldar, _arenu_, 
   {{0x90ed011f,0x83800244,0x00000000,0x00000000}},	//   _колодиаж, _potrei_, --, --, 
   {{0x080a02fe,0x6ecd00f4,0xea0a038e,0xc305023e}},	//   _akuchong, _addilenn, _शिवकालीन_, _سولاخ_, 
   {{0x72b501d1,0xcdbe0495,0x82e3024a,0x8c6805b6}},	//   _march_, _unzanire_, _debosky_, _florbal_, 
   {{0x4b9803f5,0xddc5010f,0x52000275,0x96cd04cf}},	//   _feminino_, _олимов_, _felila_, _engaboni, 
   {{0xb84a02cf,0x137f0068,0x2d91026b,0x1dcf00c5}},	//   _фотки_, _ummadda_, _cantidad_, _在中华人民共和国, 
   {{0xa38603da,0xc5bc01b3,0x480a00a6,0xe8d50026}},	//   _izere_, _пострадя, _ekuchong, _enkelvou, 
   {{0x73370046,0x71fc045c,0x8e58017a,0x7ef1000c}},	//   _климатты, _spokojná_, _ободу_, _астатиа_, 
   {{0x3c1b0031,0x627e01b9,0x399c0156,0x3af903f3}},	//   _pekanbar, _krent_, _בלוטיקע_, _aannemen_, 
   {{0xc2b5018a,0x0c7502c2,0x4d250024,0x4ae60040}},	//   _barch_, _kleuter_, _মাধুৰীমা_, _encrypte, 
   {{0xb55000bb,0x5c260122,0x727f010d,0x00000000}},	//   _وکہانیاں_, _هاليوود_, _arung_, --, 
   {{0x9b550193,0xec05021b,0xed1400d1,0xc23600c1}},	//   _इंद्रधनु, _укладыва, _samlande_, _minji_, 
   {{0xb236024c,0x3f150430,0x15d70361,0xa9b3019e}},	//   _linji_, _tendelan, _криптон_, _андрэевi, 
   {{0x16fd0024,0xd16002f3,0xb8fc0210,0xcd0d042c}},	//   _সাহিত্যক_, _blogginl, _acharind, _rezultir, 
   {{0x5f2105c1,0x5394037c,0xe2260053,0xbf22022c}},	//   _diperken, _abest_, _taukah_, _dibubura, 
   {{0x138603b4,0xee7e0095,0x178500ec,0xe2d906b5}},	//   _azere_, _محسنی_, _kitokią_, _smser_, 
   {{0x66fe0162,0x1a0a0223,0x63950318,0x227d0094}},	// [2600] _болалмай, _garapena_, _fausi_, _садақаны_, 
   {{0xf498018d,0x92d80101,0x749d026b,0xc27e013d}},	//   _ጸሓፉልና_, _vocea_, _বহুতল_, _prenu_, 
   {{0x62b50482,0xaa63004c,0xf27e02a3,0x0ef1004b}},	//   _karci_, _alimusas, _erens_, _исрафил_, 
   {{0x52dd00ee,0xf679014e,0xe6540462,0x12ca0153}},	//   _баталлаа_, _региону_, _anxietyw, _kaldte_, 
   {{0x7ed403eb,0x127e01b4,0x227e034e,0x8300004e}},	//   _inligtin, _grens_, _atinan_, _iglaraw_, 
   {{0x430d0108,0x9379028f,0x00000000,0x00000000}},	//   _didahar_, _paraama_, --, --, 
   {{0x7aa8028e,0x44ec002b,0xdf5d022a,0x8add02c5}},	//   _alexnade, _মুশাফ_, _votaflan, _anotinye, 
   {{0x83ea0005,0x7c760053,0x00000000,0x00000000}},	//   _quitau_, _निम्मी_, --, --, 
   {{0x2316030d,0xb0450192,0x42d5018e,0xb37103f0}},	//   _faizi_, _rabobank_, _kwalamu_, _asnaleg_, 
   {{0xdc570300,0x637f0167,0xe9c701eb,0x69cc019d}},	//   _dostane_, _allanfa_, _мацара_, _khodzoke, 
   {{0xe8370244,0xaf3a0142,0x6fa1024c,0x6225019d}},	//   _уникална_, _परविवेश_, _interzar_, _khakhi_, 
   {{0x5b6d0306,0x976c00e6,0x00000000,0x00000000}},	//   _neumatic, _国务院台湾事务办, --, --, 
   {{0xb2da0402,0xadc103ba,0xf6a600c9,0x6dc30303}},	//   _resepi_, _boritima, _viethiph, _boditsha, 
   {{0xbd270076,0x638602e8,0x3d7e01db,0x9a440282}},	//   _знаци_, _uzere_, _اتاۋىنا_, _paremata_, 
   {{0xc85d009a,0xc9d80675,0xb9fe0277,0xad7c026f}},	//   _akalishu, _recebime, _katarant, _كۇنمەنەن_, 
   {{0xa27f0534,0xc27e0249,0xf3110045,0xfe52011f}},	//   _trung_, _brens_, _ljubinu_, _imbaraka, 
   {{0x62910230,0x1e440028,0xb27f0107,0x032000bd}},	// [2610] _aswafe_, _waramaya, _urung_, _culyes_, 
   {{0x7f30004a,0x59e40040,0xb95f0090,0x085f0090}},	//   _tarafınn, _חניכיים_, _anondire, _anondiru, 
   {{0x49aa02b2,0xcc5e02d4,0xd99a0160,0x00000000}},	//   _голих_, _mastral_, _sruši_, --, 
   {{0x31fc05b1,0xd21300cd,0x8a700235,0x72b101c8}},	//   _spokojný_, _locher_, _पत्नीं_, _chodila_, 
   {{0x525a0074,0xe2c90037,0xa2ca05d1,0xb20001df}},	//   _muille_, _የጥራትና_, _kaldet_, _duiin_, 
   {{0x23010229,0x68c402b4,0x7a070184,0x9d28021e}},	//   _babayev_, _banemand, _bitaraza_, _blandade_, 
   {{0xdc1b003c,0xcd140037,0x5b6700d9,0xd8fe005c}},	//   _mekarsar, _በአሸባሪነት_, _газете_, _batarand, 
   {{0xb3f40258,0x6c230298,0x53eb0025,0x7f390109}},	//   _gatten_, _horonuku_, _asatsu_, _बानियाँ_, 
   {{0xf3ce002e,0x45200172,0x01220314,0x202f0127}},	//   _kakva_, _akosombo_, _шешҡолаҡ_, _erbedado, 
   {{0x4ddf041b,0x72640362,0x91780019,0x037f01ed}},	//   _mankacha, _bakokani_, _бурмалан, _oikaika_, 
   {{0x1153003d,0xceaf0258,0x7163021b,0xf3790309}},	//   _micrófon, _baltyske_, _логина_, _yaranma_, 
   {{0x5ad70066,0xa29004f2,0x98fc0099,0x2a17048f}},	//   _partekat, _vodanh_, _achapind, _bombanga_, 
   {{0xb6190144,0x2964000c,0x1b2002cd,0x880a0390}},	//   _chreidim_, _latosole, _halascin_, _elsevər_, 
   {{0x5e47020a,0x92a101f7,0x194800d9,0x83050160}},	//   _جىلتا_, _agendà_, _normaale, _zalazak_, 
   {{0x7a05008c,0xa3f900a2,0x02ca0284,0x49f303a4}},	//   _cumainza_, _shauku_, _fandí_, _fornerma_, 
   {{0x2b7a01b7,0xe47b0046,0xe2020219,0x00000000}},	//   _संस्कृते, _سزدەردئن_, _iyakuvum, --, 
   {{0x6c660155,0xe6d20023,0xd7170041,0x36100017}},	// [2620] _vettigt_, _безупреч, _мышқәак_, _učiliště_, 
   {{0xc2000068,0x62e90129,0xa2000092,0x00000000}},	//   _weliba_, _chaiken_, _delica_, --, 
   {{0x92900051,0xccc1034e,0x44d6004b,0x1394005b}},	//   _nemaz_, _artikuiu_, _зарурлығ, _daisen_, 
   {{0xa8fe0663,0x9c1c0024,0x4c520272,0xd36f025e}},	//   _mbrantsɛ_, _কন্ঠদান_, _anatera_, _gangast_, 
   {{0x760302eb,0x0ead002e,0x9a180113,0x33fa01b8}},	//   _мобиком_, _navođenj, _clubanna_, _turule_, 
   {{0xb39401a7,0x437d004f,0x7e0f0092,0xc2120039}},	//   _naisen_, _boqaale_, _accessup, _leiho_, 
   {{0xc89e03bf,0xa6e30300,0x7c350529,0x03a80013}},	//   _командаһ, _podvodní, _igraonic, _махаллас, 
   {{0x105702bf,0x830d04df,0x00000000,0x00000000}},	//   _bangakho, _bahadyr_, --, --, 
   {{0xa74a0040,0x63f40155,0x73950051,0x1fe8007e}},	//   _חדשנית_, _ratten_, _kausu_, _विशारदः_, 
   {{0x3b8b00a4,0x3b670368,0x849000d1,0x49f300b4}},	//   _اماندىعى, _далеке_, _এখেতে_, _inaintea_, 
   {{0x43160544,0xa25a00d6,0x8a140039,0x73950274}},	//   _ahaza_, _buille_, _gorabehe, _laust_, 
   {{0x515c009b,0x73d70045,0x89ca00be,0x0f2e027f}},	//   _ууган_, _митровиц, _جۉربۅڭ_, _kurubaga, 
   {{0xccaf026c,0x578700be,0x9395055b,0x683e00c7}},	//   _收購存摺存簿是違, _جاشايىن_, _naust_, _бишкә_, 
   {{0x2b43029f,0x12d804bf,0xb5160242,0x529002fb}},	//   _futbalis, _poceo_, _mourinyo_, _nanamu_, 
   {{0xcc7504bb,0x72e60334,0x302e0038,0xa67f0085}},	//   _puasyog_, _adanama_, _каһвә_, _silesiti, 
   {{0x41fd021c,0xe98403f6,0xfc670195,0x92cb00ac}},	//   _kapacity_, _kapikala_, _cultair_, _sladak_, 
   {{0x2fcd0354,0xc292013f,0xf15000bf,0x926e0369}},	// [2630] _бағдадта_, _merañ_, _изложенн, _kopoko_, 
   {{0xd27e00cd,0x7a0b0058,0x952d0170,0xc26b0126}},	//   _quent_, _paravert, _chingath, _доброзич, 
   {{0x58680037,0x7a7d023e,0x1b0a03ae,0x65950025}},	//   _ቆርኔሌዎስ_, _badanira_, _innsamle, _धर्मचारि, 
   {{0x99a5015e,0xbc6e065a,0x7f0e0047,0xc9d601de}},	//   _алмаша_, _amaroma_, _bouchons_, _жанрдың_, 
   {{0x827d02aa,0x631602b4,0x08c606b6,0xcbc202c4}},	//   _materiál, _chaza_, _navegand, _авион_, 
   {{0x665003ce,0x6f34047b,0xb27e0100,0x476e01bd}},	//   _میانڕه_, _einligur_, _kreni_, _ولەڭدەرد, 
   {{0x339501f6,0xe2ca000b,0x5995009a,0x1db200e6}},	//   _haust_, _isilami_, _asahlala_, _其中的数据不会丢, 
   {{0x62ca0226,0x90bf0461,0x8bb600bb,0xce520061}},	//   _alaliki_, _agricòla, _عُکاشہ_, _플레이어가_, 
   {{0x8c000168,0x92900133,0x7c1a024f,0xb0e50012}},	//   _suksess_, _banamu_, _wabosucu_, _रिहीसे_, 
   {{0x67dc03b8,0x00000000,0x00000000,0x00000000}},	//   _тараулар_, --, --, --, 
   {{0x53e304ca,0x126d01fe,0xe6a40603,0xf653019d}},	//   _apprenti_, _semineri_, _अनुपलब्ध_, _machinji, 
   {{0x9f50002c,0x24b60255,0x576e0235,0x1324027e}},	//   _англи_, _कुंडी_, _गुप्तम्_, _турског_, 
   {{0x4fa8018d,0xe37f02c3,0xf2cb0308,0x72f9005b}},	//   _ብቐጥታዊ_, _volania_, _ovulasi_, _chihoda_, 
   {{0x9a68018d,0x5ef30444,0x62e60258,0x9c1c017c}},	//   _ዕልማናዊ_, _уличного_, _feinten_, _anfallar, 
   {{0xbfed0016,0x3fb101a4,0x6a68018d,0x61b30029}},	//   _כסליו_, _pasteurs_, _ዕልመናዊ_, _داخرا_, 
   {{0xe3940292,0x02d6033e,0xe98f04ad,0x426e0259}},	//   _ebesi_, _имаац_, _leakanye, _fotovv_, 
   {{0x4ad0000c,0xe6c70294,0x65710062,0x44c903ac}},	// [2640] _ахлор_, _ascaridi, _dirwijmo_, _percayak, 
   {{0x977b0037,0x37a601e6,0x0d98046b,0xb2e601d9}},	//   _ወንድሙን_, _rezervov, _imaginet_, _keinten_, 
   {{0x4c6900c9,0x406502f6,0x1dc900a7,0x878c0157}},	//   _vietkey_, _makabago, _саудияны, _विचारकों_, 
   {{0x92d804ef,0xc13a0371,0x26b600bc,0x628402f4}},	//   _doces_, _самоличн, _هاروارد_, _rechazo_, 
   {{0xb04301f0,0x2e470035,0x8dba00d8,0xf8bc0143}},	//   _bohutsan, _analarnı, _autament_, _преминат_, 
   {{0x8dea0040,0x177606a1,0x83f402df,0xaf2a03f2}},	//   _serviced_, _traktorv, _hattan_, _заплатил, 
   {{0x9c5a03ef,0xb3f40418,0x19fb058f,0x00000000}},	//   _agatabi_, _kattan_, _arrastre, --, 
   {{0xa290028a,0xe27f01e5,0x3c35002b,0x0f5e03b5}},	//   _sanamu_, _itunu_, _টিনটিন_, _sasarann, 
   {{0x5df501eb,0xd3f40155,0x4ec7013d,0x730f02be}},	//   _añekaram, _mattan_, _kontraŭs, _humanap_, 
   {{0xbf200203,0xab4d0161,0x1a4b0061,0x2e6004b9}},	//   _accepten, _топливны, _디모데전서_, _laichest_, 
   {{0x47ad01d1,0xac2800c4,0xfb70037f,0x3557017a}},	//   _extensiv, _شيڊنگ_, _tehranda_, _аралов_, 
   {{0xa51f0388,0xf9bb008d,0xe2fd0148,0x5dc800de}},	//   _giardino_, _muddatga_, _maximis_, _دغزنی_, 
   {{0x62e30212,0x98da00b0,0x49a80292,0x5ae80206}},	//   _undique_, _galgaduu, _yɛkenkan_, _dostupne, 
   {{0x4c720269,0x6cb40622,0x027e013d,0x9eaf00da}},	//   _viernes_, _akayuhir, _preni_, _exprimat_, 
   {{0x7b04046d,0x72d801df,0xa47e02af,0x2201018d}},	//   _matshaya_, _hokey_, _baherako_, _gabime_, 
   {{0xb00a0052,0xd30100ff,0x90fa020e,0x00000000}},	//   _यांत्रिक_, _barakti_, _itsherel, --, 
   {{0x627f000b,0xb5f90022,0x33f40033,0x529e0076}},	// [2650] _atunu_, _микрозай, _dattan_, _џихад_, 
   {{0x296601ac,0x853e010d,0x733f0287,0x451d004d}},	//   _chorsaic_, _resikony, _अञ्चलमा_, _租稅法律主義_, 
   {{0x7cef0212,0x9e460392,0x2b610011,0x82d80233}},	//   _dnowshac, _banachda, _abireeta_, _docer_, 
   {{0xf3f403ba,0xe51a0192,0x539401c2,0x37e503a2}},	//   _gattin_, _모르겠지만_, _amosar_, _जलभराव_, 
   {{0xf3ac00ac,0x4887006c,0xd3fa023e,0x632a06a0}},	//   _ukupna_, _набард_, _buruhe_, _maghatag_, 
   {{0x7c0705d7,0x95750177,0x1b810120,0x61890126}},	//   _soussou_, _ақәыҕәҕә, _mokookoc, _командою_, 
   {{0xe3940495,0xa3f400c9,0x82120415,0xd3ac0009}},	//   _icese_, _battin_, _reihe_, _skupna_, 
   {{0x5c9d0169,0xf4b30138,0x00000000,0x00000000}},	//   _চিন্তাভা, _notları_, --, --, 
   {{0xc7ae01f6,0x8d86025f,0x7300000e,0xc3f401c0}},	//   _মিহলি_, _elimbola, _macabri_, _dattin_, 
   {{0x3f3b0307,0x82be02d6,0x8619003e,0x81290089}},	//   _bangawen, _фотогалл, _антипов_, _garmoniä_, 
   {{0x336302fe,0xc7aa0206,0x794f0037,0xa1d10381}},	//   _کوندوليز, _zastreli, _ያጠዋልላል_, _arvedcay_, 
   {{0x5a050036,0x9b0b0455,0xb9880350,0x00000000}},	//   _matamait, _consomme, _የሰሞኑን_, --, 
   {{0x227e04d0,0x89c300bc,0xb3950066,0xf9840096}},	//   _buenx_, _داربی_, _ogasun_, _arazindu, 
   {{0x430100a1,0x1ed701ab,0xc2d80097,0x65ac0013}},	//   _karaiti_, _भेंटाई_, _dikee_, _mingbosh, 
   {{0x585f0113,0x589f0088,0x620106b7,0x73490222}},	//   _acariens_, _спортчул, _bazize_, _chiffre_, 
   {{0xcd2d0200,0xf379008a,0x9a580062,0xe2da0452}},	//   _megidere_, _pelasio_, _muweghha_, _resesi_, 
   {{0x73c80037,0xdaa10193,0x60e901fc,0x77da02ac}},	// [2660] _ከመነሻው_, _दृष्ट्या_, _diraarak_, _فعندما_, 
   {{0x6892026c,0x2ba801cc,0x6f1e00e6,0x42d802fb}},	//   _臺北市政府捷運工, _anekapar, _家企业上黑榜_, _sekeli_, 
   {{0x7a1e001b,0xf3010028,0xdb900173,0x03160408}},	//   _arabiyaa_, _carbeed_, _transacc, _anazy_, 
   {{0x31fc045c,0xa4be053c,0x326e044a,0xb1990395}},	//   _spokojní_, _martiño_, _bopono_, _kabelové_, 
   {{0xad9102e7,0x768a008d,0x85bc006c,0x7a2800a6}},	//   _kantidad_, _birdamli, _angamlah, _elichane, 
   {{0xdec70261,0xb9160179,0x118c067c,0xe46701d5}},	//   _kontraŭl, _belotädö, _newberry_, _سیٹنگز_, 
   {{0xd201037a,0xf66700c7,0x430500f6,0x00000000}},	//   _yazize_, _чистарту, _natamam_, --, 
   {{0x23c700c5,0x62b20073,0xf2a0005f,0xb3400026}},	//   _产品尤其在无溶剂, _credera_, _koubei_, _schepen_, 
   {{0x620201c5,0x397d01b7,0x3add0039,0xa3aa00fe}},	//   _wariye_, _antareṇā, _gasteize, _itavake_, 
   {{0x4def0163,0xb2b500cc,0x8d0a0003,0x8c5402f6}},	//   _اجتماعات_, _landene_, _geslacht_, _wastong_, 
   {{0x3aa10025,0x8a6d003f,0xc640019f,0xa2900125}},	//   _दृष्ट्वा_, _chollahb, _serikali, _allahy_, 
   {{0x021302e1,0xee0b002f,0xb2b4011d,0x0c7403ec}},	//   _sochar_, _ayudanma, _cancan_, _komunes_, 
   {{0x3d0a03c6,0x75dd0105,0xaed000ba,0x82de030d}},	//   _beslacht_, _कालाहांड, _ناوێرم_, _belində_, 
   {{0x348702a5,0x983802eb,0x86b9018d,0x2225003a}},	//   _उपशाखा_, _эсгий_, _በብጊዜኡ_, _shakli_, 
   {{0xbb0a0274,0x2ec7013d,0x43790005,0xe95a0350}},	//   _vinsamle, _kontraŭa, _attacha_, _ያለመኖር_, 
   {{0x23870049,0xec5a00ac,0xb20102bf,0x266c0064}},	//   _arerei_, _pratiti_, _babike_, _корейлер, 
   {{0x320e01e1,0xdf660091,0x1f4802bd,0x02a60371}},	// [2670] _тамам_, _qulaanun, _pensiyna, _регулира_, 
   {{0x4c5a03d8,0x8f6a00cb,0x5d270343,0x29ed03ef}},	//   _vratiti_, _ababelan, _aninipot_, _ashimira_, 
   {{0xb26200d8,0x408b0092,0x4371012a,0xeee0057a}},	//   _mesurabl, _お絵かきしりとり_, _trafił_, _векло_, 
   {{0x3237032d,0x839503b4,0x856e00df,0x127f04e6}},	//   _приставт, _hausi_, _autorisé, _krung_, 
   {{0x42300357,0xb3950211,0x7e450294,0x1177015d}},	//   _dramica_, _kausi_, _baratpip, _जस्सी_, 
   {{0xa3fa01d1,0xe3c801b9,0xf2b40054,0x197f01bb}},	//   _forums_, _ckuver_, _wancan_, _indikile, 
   {{0x83160328,0xf21206b8,0xee500222,0x79cd033e}},	//   _ahaze_, _meiha_, _descente_, _nopermit, 
   {{0xc2d902e2,0x7d900211,0x9e9e00a7,0x5ad90076}},	//   _nosed_, _везде_, _таала_, _намирниц, 
   {{0x614b0092,0x60e900c7,0x5935006c,0x7ff601b3}},	//   _の的中馬券_, _башлаяча, _akumphat, _дистриб_, 
   {{0xbd4b0120,0xb0c10059,0xf27f0108,0xf3eb0020}},	//   _ammakkaq, _основен_, _irung_, _luatau_, 
   {{0xbbef01be,0x8c1400ca,0x65780046,0x520202a3}},	//   _pardubic, _existiss, _ишмерлер, _harige_, 
   {{0x3f5d0400,0xa1f9035e,0x12ca0077,0x927f0446}},	//   _risponde_, _vanzemal, _gendwa_, _kruno_, 
   {{0x765e0184,0x72020003,0x932201f7,0x520101b9}},	//   _abokwiki, _jarige_, _nascuts_, _mazine_, 
   {{0x7e2c00af,0x22880060,0x32130052,0xa86c00b7}},	//   _влади_, _айтар_, _nichž_, _составыд, 
   {{0x327f04c4,0xb27c045e,0x82d8064d,0x52d90187}},	//   _juuni_, _играя_, _kekehi_, _recebi_, 
   {{0xd27f0241,0x1b60012b,0xe25a00c5,0x53790282}},	//   _duuni_, _burmistr, _grille_, _netania_, 
   {{0x79810130,0x6c77023c,0xce100349,0x00000000}},	// [2680] _bolitike, _amisele_, _eakerssp, --, 
   {{0xc07900b7,0xb571019d,0x152e0092,0x9b2000a6}},	//   _биринжид, _akatuluk, _プレジデント長崎, _aliphile, 
   {{0x36b700fd,0xa2000449,0x955a01b3,0x140300e5}},	//   _chlaisti, _jelima_, _самооцін, _limitaçã, 
   {{0x10cd0247,0x7e9002ea,0x65c800c4,0x0629020f}},	//   _ردصلاحیت_, _trattare_, _kukatish, _elingayi, 
   {{0xc68101c1,0x5e830532,0x3d54023c,0xf2360181}},	//   _एवढाच_, _spavanje_, _ورنژدې_, _danji_, 
   {{0xc395002a,0xd96e00b2,0xab1500a4,0xa65300da}},	//   _ebuso_, _amanamee, _campanye, _тоталэ_, 
   {{0x8372019a,0xc32b0012,0x339403a4,0xf2730102}},	//   _sheared_, _गमकउवा_, _innset_, _kienyeji_, 
   {{0xf9d401d3,0xcac803a2,0x253c03f8,0xf716003c}},	//   _östersun, _बेतरतीब_, _dichelch, _پانویس_, 
   {{0xdb1f0177,0xf3ff030b,0xa3210015,0xbf600153}},	//   _амҩаду_, _akozeko_, _ilayhi_, _は父の日です_, 
   {{0x791d0273,0xb200038b,0x16d801e9,0xce510206}},	//   _economía_, _kelima_, _diegisiw, _atrakcie_, 
   {{0x3c290386,0x79bf00ea,0x0b840015,0xc64c0097}},	//   _pembayar, _fanevate, _maandoor, _pilatinọ, 
   {{0x9d130096,0x863c0333,0x66d302c4,0xd0fa0314}},	//   _aburanir, _ancillai, _поплави_, _itshirel, 
   {{0x64c30265,0xb394005b,0x516a039e,0x00000000}},	//   _misbruik, _daison_, _bloggpul, --, 
   {{0xac7301d9,0x32020612,0x1413023e,0xc2c80037}},	//   _kierper_, _varige_, _هايده_, _በወልድና_, 
   {{0x2cfb02d8,0x52900158,0x9302037f,0xf37202c2}},	//   _प्रमाणे_, _polacy_, _qarayev_, _mamagud_, 
   {{0x6e4601b9,0x6b7401af,0xe97006b9,0x8f01020f}},	//   _dinamize_, _улашып_, _acuicult, _دخوشي_, 
   {{0x85ad004d,0x720e006c,0x0ede02ba,0xeeb702c8}},	// [2690] _值得注意的是_, _чаман_, _ҷилди_, _consonte_, 
   {{0x5f2700c5,0x720003ad,0xea8f038c,0xda4400dc}},	//   _经营许可证编号_, _medika_, _priznaje, _haserota_, 
   {{0xaf2a037b,0x20220359,0xc2120282,0xca020019}},	//   _pastilla, _needsaak_, _reihi_, _relaxada_, 
   {{0xcea8022f,0xa2d902a0,0xbeaa0060,0xfa34002b}},	//   _анатоля_, _kosee_, _سىزىقتى_, _জাজিরা_, 
   {{0xe27f004e,0x50fa04ad,0xcb060359,0x8b7900ec}},	//   _atanan_, _atshirel, _ditsoart, _medinių_, 
   {{0xbbb8019b,0x095702cf,0xe04000f3,0xfb61033e}},	//   _сейфах_, _прочисту, _emvuzwen, _florcita_, 
   {{0x2fe300bc,0x269d0405,0x843e0405,0xd14c021b}},	//   _کارتن_, _преси_, _сауни_, _molemmil, 
   {{0xc39505db,0x8c66015e,0x00000000,0x00000000}},	//   _ubuso_, _карытып_, --, --, 
   {{0x662b033e,0x1200007f,0x10e10125,0x00000000}},	//   _аморалтә_, _graig_, _якасы_, --, 
   {{0x865c00e4,0x4a5b00e2,0xa366014e,0xf27e0318}},	//   _vidyalay, _dramatys, _zasedanj, _oseni_, 
   {{0x8c6a0242,0x221c0234,0x73eb01c8,0x61e00541}},	//   _sonuncu_, _akuhan_, _mletá_, _žandarme, 
   {{0xd1cf00c3,0x74d3026c,0x7f63038e,0x22d90117}},	//   _檢視引用通告_, _目前顯示第_, _kumpulka, _kosem_, 
   {{0x34ac049f,0x19080155,0x8625012b,0xeea000ac}},	//   _kuzakwak, _populära_, _porozumi, _pokušati_, 
   {{0x225b029a,0xf2d902e7,0x5f5b00f6,0x2a390213}},	//   _realis_, _ulser_, _silahlan, _бердан_, 
   {{0x11d70177,0x22020216,0x6d0e0127,0x00000000}},	//   _агроаага, _hetisa_, _gomunour, --, 
   {{0xcce40212,0x87dd0040,0xb3c401bb,0x420101c2}},	//   _traveloc, _גינדי_, _aýyplaw_, _ducias_, 
   {{0xe00804c7,0xa2010640,0x1a090344,0x42490227}},	// [26a0] _рукописн, _razine_, _allanart, _khamar_, 
   {{0xaa090209,0x3eb803c1,0xbe9c01d1,0x92d9012d}},	//   _allagart, _владетел, _promotin, _sosel_, 
   {{0x62d90465,0xa20102f9,0xbe3304d7,0x1fb60040}},	//   _posel_, _dazile_, _boogiema, _מיוזיק_, 
   {{0xf6a80037,0x82500255,0x927f0241,0x49500421}},	//   _የሚይዘው_, _देखेके_, _duunu_, _schleude, 
   {{0xf2e802ef,0x83f80130,0x3dc101f2,0x72000005}},	//   _dokiman_, _dihun_, _ириңиз_, _duain_, 
   {{0xb25b0333,0xa90500d1,0x43800220,0x42d6001d}},	//   _francesi_, _বুদ্ধিদী, _potrai_, _collets_, 
   {{0x989a01bd,0x936c0132,0xe2d90172,0x580601b7}},	//   _мамандан, _tengeri_, _wosem_, _bhāsate_, 
   {{0xb9fa056d,0x332000bc,0xe20200fe,0x8200031a}},	//   _قزاقستان_, _palyer_, _setita_, _araid_, 
   {{0xb202015e,0xac1d0013,0xb236035e,0x63010333}},	//   _petita_, _tovarlar, _danju_, _baratti_, 
   {{0xc27e003e,0x0c4e01a3,0x2200029a,0x7e4800d9}},	//   _tsena_, _تمدني_, _delika_, _уголовно, 
   {{0x783000c3,0xdf1c0381,0x43ea0255,0xfc5d0220}},	//   _fermentu, _annualwa, _maitse_, _listino_, 
   {{0xe3ea043a,0xc26c010b,0x96ba0013,0x196d0067}},	//   _saitot_, _diholo_, _катнашчи, _geenyett, 
   {{0xdb4c00e0,0xd2d50054,0x00000000,0x00000000}},	//   _keamerfr, _hotonta_, --, --, 
   {{0x8e5a0162,0x1c990037,0xe8c601f6,0x538600f2}},	//   _дилдарли, _የአባቱን_, _innehald, _ģirts_, 
   {{0xd82903a2,0x8b7f0328,0x2236019c,0xaaba00d3}},	//   _सिअंगापु, _biturika_, _kanju_, _ukrajině_, 
   {{0x7d2101dd,0x6a110129,0x30d500c1,0xc916041a}},	//   _bakomeje_, _edebanye, _आपलमराठी, _судимост, 
   {{0x8ae1002f,0x23ea02d5,0x93f905d5,0xb76501ef}},	// [26b0] _chiliman_, _kaitse_, _popul_, _pasibaig, 
   {{0xc2490445,0x19d702c2,0xcb8a002c,0x00000000}},	//   _chamar_, _kwetsend, _тохож_, --, 
   {{0xa2d90163,0x63400223,0xee020108,0xe7cc02a4}},	//   _sosem_, _honekin_, _kabenera, _temporum_, 
   {{0x72d9015e,0xa2e302ac,0x6f0f00e6,0xeac40040}},	//   _posem_, _scornach_, _街拍明星睡姿看谁, _הנחשקים_, 
   {{0x2e9200bd,0x34e90125,0x0dc0003a,0x1c540040}},	//   _ointment_, _таквалыг, _kiritila, _fasting_, 
   {{0xc15104c7,0xb4a001ac,0xa9c104e5,0x985f004d}},	//   _струк_, _domnaill_, _balemere, _中央直接一次次撥, 
   {{0x330700d6,0x22d50087,0x00000000,0x00000000}},	//   _كوردستان_, _kwalomu_, --, --, 
   {{0x1386064d,0xed21005c,0xab850229,0x3407033e}},	//   _ezera_, _yakomeje_, _yalançı_, _ираклии_, 
   {{0x93ea020b,0xa6840152,0x425a0259,0xeccc016f}},	//   _baitse_, _күчмә_, _negle_, _наведені_, 
   {{0x5798013e,0x83ac0157,0x00000000,0x00000000}},	//   _mladenov, _skupia_, --, --, 
   {{0xcf74038e,0xd66b02c3,0xc6a100c9,0x13750099}},	//   _प्रकाशचि, _žurnál_, _baotheth, _aitungam, 
   {{0xe200041e,0xc62801c5,0x825000f5,0xb86a056e}},	//   _vraie_, _بولبوشا_, _девам_, _unanimid, 
   {{0x8c73046f,0x1e2e018d,0x4fa3022f,0xb61301c8}},	//   _bierger_, _ስለዝኰነ_, _корзун_, _postaral_, 
   {{0x283e032d,0xb4530053,0x62000144,0x9696027e}},	//   _киске_, _स्वयंचलि, _araib_, _povereni, 
   {{0xc2b40576,0xd34502bd,0xf4130060,0x720100ae}},	//   _pancen_, _gardiau_, _باندى_, _kazibe_, 
   {{0x299201cb,0xf04c025b,0xc25a02ec,0x7b97016d}},	//   _ngokobut, _amerikon, _olole_, _сайлими_, 
   {{0x23940281,0x3e830079,0x3866009a,0x406001ab}},	// [26c0] _tonsit_, _aktivizē, _akwisivu, _कैइसन_, 
   {{0xdab703bf,0xa0730092,0xc888018d,0xe2b501f6}},	//   _baikakas, _内閣総理大臣_, _ዘረጋገጽዎ_, _sandane_, 
   {{0x1742010d,0xa413014e,0x006100cb,0x62020362}},	//   _perorang, _поредак_, _akusemin, _farize_, 
   {{0x627f0233,0x6e1b02c2,0x79b104c8,0x70880177}},	//   _trunc_, _geselska, _bużżieqa_, _паспортқ, 
   {{0x741d01b2,0xc42205f2,0xbc5c025c,0xbd6200c5}},	//   _scission_, _rematado_, _drittel_, _symboliq, 
   {{0x707403d1,0x9c730359,0x29340090,0xd071032d}},	//   _komentār, _fierder_, _anomutsa_, _ынтылыус, 
   {{0x026c02f6,0x53950256,0xfbe1025c,0xa2ca0020}},	//   _lalong_, _kauss_, _inserier, _isalami_, 
   {{0x33010051,0x8200007b,0xc03b016f,0xf6e10178}},	//   _parasti_, _craib_, _абонента, _सूतपुत्र_, 
   {{0x98ed017d,0x30530040,0xc14901f0,0x563d0321}},	//   _よくあるご質問_, _הנתבע_, _borraaro, _socialni, 
   {{0xa2d803cf,0xca6d0303,0x527b03e2,0x93780057}},	//   _anket_, _bipolots, _eclesiás, _pelamin_, 
   {{0x9345033c,0x7b1c0375,0x32d903f3,0xd01a0024}},	//   _cardiau_, _akupanga_, _ineens_, _সন্দৰ্ভত_, 
   {{0xa2340148,0x026c04e5,0x08760334,0x5b5e0078}},	//   _carmine_, _ajooga_, _atangomu, _крсне_, 
   {{0xc2d80039,0xcdbb0125,0x9202005b,0x4b03006a}},	//   _mikel_, _bashtuta, _betipa_, _hampiova_, 
   {{0xd9d90030,0xc8350590,0x3dd802ba,0xb3bb0107}},	//   _dienesta_, _музейн_, _туркзабо, _فسفات_, 
   {{0xe48b061d,0x9e7d0147,0x6e6902ac,0xc3180022}},	//   _аталған_, _اتىبىزدى, _ويأتي_, _колхозсы_, 
   {{0x8bd501f6,0x7bd20065,0x1f740235,0xb39500f2}},	//   _soldatar, _wundersc, _प्रकाशयि, _paust_, 
   {{0x01860021,0x52d801c7,0xed7300d0,0xaa72005e}},	// [26d0] _unlawful, _tiken_, _конвенц_, _گەپكەن_, 
   {{0xec7f010e,0x48390037,0xcae8065d,0x5b420267}},	//   _mahusay_, _ባላውቅም_, _sjarmere, _isporuču, 
   {{0x11660047,0xbdab0257,0xc26c00c0,0x29aa0204}},	//   _第三十八条_, _kynninga, _halong_, _болит_, 
   {{0xa395019d,0xbdf1016d,0x626c00ad,0x674e018d}},	//   _abusa_, _ﻣﻪﺭﻛﯩﺰﻯ_, _balong_, _ብማዕርነት_, 
   {{0x22260200,0xf25b0437,0x9f520148,0x948700c7}},	//   _ebukwa_, _jubler_, _monachus_, _баглый_, 
   {{0xf5330286,0x03f80032,0x995c0450,0x00000000}},	//   _omanpany, _hihub_, _sydspoar_, --, 
   {{0x75230026,0x62ec03ec,0xf8c303b5,0x7b880176}},	//   _선택하세요_, _veriore_, _diseluru, _butikker, 
   {{0xea20000c,0x66a000bb,0x06ed0188,0x320200a0}},	//   _agaguápe_, _الہامی_, _задухӯрд_, _dariye_, 
   {{0x1533001f,0x5a1100be,0x52ff0381,0x7ba90594}},	//   _amanpany, _اجوسۇن_, _aturenay_, _merkevar, 
   {{0x3c1605bd,0x869402c9,0x00000000,0x00000000}},	//   _forurens, _bineveni, --, --, 
   {{0x5c190139,0x748e00d1,0x726e00d7,0xdc9301b8}},	//   _atirahas, _কালান্তৰ, _diposo_, _थ्रोन_, 
   {{0x406704fd,0x8a7e02c1,0x53160293,0x4a8901b9}},	//   _आईओसी_, _batagira_, _abiza_, _relizyon_, 
   {{0xbdd100c5,0x52b401d7,0xc2e40390,0x790f0050}},	//   _山东省人民政府门, _mancan_, _müellif_, _asmaramu, 
   {{0x58940022,0x42480197,0x907a0178,0x9b67003c}},	//   _спайс_, _chimer_, _avaśiṣya, _delengan_, 
   {{0x539402c9,0xc3960212,0xe8e1000e,0xa0c60040}},	//   _acest_, _mersal_, _acusativ, _השטויות_, 
   {{0xf3560056,0x9308002b,0xe2be02e2,0xdc610008}},	//   _abafisa_, _তথ্যাদি_, _bardoil_, _bestiar_, 
   {{0xc5c6054e,0x4287020f,0x03db002e,0x2fd30156}},	// [26e0] _hanayauh, _قفقاز_, _preuzeti_, _פראזע_, 
   {{0x02e90207,0x0a2402fe,0x8db20455,0x09ff014a}},	//   _kupitia_, _ليتوانيا_, _remarque_, _objektív_, 
   {{0xd75a0094,0x603e0051,0x9fd7004b,0xd9e6023c}},	//   _بالالارد, _girgenso, _танаулы_, _bawuland, 
   {{0xd34101f6,0x6c600066,0x1b4701bd,0x22d8009f}},	//   _verdiar_, _laburra_, _قاتستى_, _cikel_, 
   {{0x69cd0073,0xbc8701ca,0x8b6701ec,0x90f50092}},	//   _attendit, _daleghpu_, _celengan_, _藤本えみりのム_, 
   {{0x0c5503dd,0xf6c700ba,0xa35b021e,0xd42b0156}},	//   _amatore_, _بێوچان_, _framsteg_, _bagatelo_, 
   {{0xa3f8018f,0x61a10162,0x25220244,0x2c40005c}},	//   _bihub_, _بەرىكەت_, _classico_, _abaporos, 
   {{0xa5bd0074,0xf2d804b9,0xcb5e045e,0x2bef00d1}},	//   _построен, _pokey_, _броня_, _কেন্দ্ৰল, 
   {{0xe900021e,0x3d0501b7,0x46300130,0x5f110187}},	//   _koppling, _asurendr, _bersonel_, _ибраими_, 
   {{0x787305e3,0x2eb400c3,0x33c00145,0x93ea0211}},	//   _प्रकारको_, _dicentes_, _kambaryj, _laitat_, 
   {{0x1c0900f2,0x52d800dd,0x34e200d1,0x84ba01f4}},	//   _izbaudīt_, _biced_, _জাভাৰ_, _ғазнасин, 
   {{0x92020507,0xd20003ea,0xc93e0040,0x9fca0291}},	//   _ketiga_, _etait_, _מוסלמים_, _حريملاء_, 
   {{0xa2d900ad,0x42b400bd,0x13cb0004,0x7b300061}},	//   _bosen_, _dancin_, _dezakò_, _모두보기를_, 
   {{0x46950126,0x7291030b,0x810600ba,0x80f00009}},	//   _суворо_, _ataasa_, _نگلادیش_, _delavnik_, 
   {{0xc7c9047b,0x97ad009b,0x423003f0,0xfdae033e}},	//   _bjørgini_, _besteeki, _ferjan_, _omonamba, 
   {{0xe20e0398,0xaa050387,0xf5d70013,0xf4ac044a}},	//   _жаман_, _satalait, _турадига, _babangak, 
   {{0xa2000142,0xb2320090,0xcf3000c7,0x226c003a}},	// [26f0] _rohini_, _ishmael_, _bazasınd, _avlod_, 
   {{0xfa9402af,0xaed303d1,0x26970024,0x36e801db}},	//   _abanonos, _nomierin, _মানুহো_, _таластыр, 
   {{0x0e1b0360,0xd22901b4,0xd2d9024f,0x98c60161}},	//   _skupině_, _glimlag_, _peceli_, _экзамено, 
   {{0x025a006e,0x3b190211,0xd64b0350,0xc9f9023e}},	//   _boole_, _espanjan_, _በጭብጨባ_, _dijambre, 
   {{0x5200054f,0x82770590,0x36870527,0xc380009e}},	//   _ntais_, _батмөнх_, _kladioni, _entrei_, 
   {{0x908c008d,0xae960060,0xc37903f6,0x84460060}},	//   _шартнома_, _ءىشىپ_, _karaima_, _تارقان_, 
   {{0x526e02c1,0x12fd009c,0xb2b502ef,0xec620191}},	//   _siporo_, _achasiri_, _randone_, _sparade_, 
   {{0x22020245,0x94a401db,0x6a020066,0x93d702a5}},	//   _narine_, _ءبىرقاتا, _zabaltze, _वातावरणी, 
   {{0x50920060,0x1a080439,0x8f6502cb,0x814600ff}},	//   _мініңіз_, _cristinu, _rasplaka, _עבֿירה_, 
   {{0x89b90066,0xb37400a4,0xfc430369,0x12d50321}},	//   _өсвөрийн_, _oposició_, _kāwili_, _podoben_, 
   {{0x623600bd,0x92a70402,0x8909017f,0x62fd003c}},	//   _kanji_, _kaabah_, _allappoq_, _aragog_, 
   {{0xf6d40433,0x32b6007b,0xf3eb0120,0x7d5a045b}},	//   _lombardi, _cordage_, _gaatat_, _морем_, 
   {{0x3e570053,0x1394015b,0x4f9d0196,0xf69d0510}},	//   _मार्गशीर, _paisin_, _chimango, _прусс_, 
   {{0x92d901f1,0x083e02c4,0x27e802c3,0xf2fe0110}},	//   _qosen_, _мирка_, _rybarstv, _iztikas_, 
   {{0x0ed70265,0x35fc0434,0xa2020222,0x03f40203}},	//   _eveneens_, _excepció,