//
// UploadManagerUi.cs
//
// Author:
//   Neil Loknath <neil.loknath@gmail.com>
//
// Copyright (C) 2009 Neil Loknath
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using Banshee.Telepathy.Data;

namespace Banshee.Telepathy.Gui
{
    public class UploadManagerUi : TransferManagerUi
    {
        //private TelepathyService service = null;
        private readonly TransferManager<TelepathyUploadKey, TelepathyUpload> upload_manager = new TransferManager<TelepathyUploadKey, TelepathyUpload> ();

        public UploadManagerUi () : base ()
        {
            //this.service = service;
            upload_manager.Completed += OnCompleted;
            upload_manager.Updated += OnUpdated;
        }

        public TransferManager<TelepathyUploadKey, TelepathyUpload> UploadManager {
            get { return upload_manager; }
        }

        protected override void Dispose (bool disposing)
        {
            if (disposing) {
                upload_manager.Completed -= OnCompleted;
                upload_manager.Updated -= OnUpdated;
                upload_manager.Dispose ();
            }
        }

        public override void CancelAll ()
        {
            upload_manager.CancelAll ();
        }
    }
}
