/****************************************************************
**
** Attal : Lords of Doom
**
** engine.h
** the game engine !
**
** Version : $Id: engine.h,v 1.35 2008/03/03 22:50:11 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 03/10/2000
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef ENGINE_H
#define ENGINE_H


// generic include files
// include files for QT
#include <QObject>
#include <QList>
#include <QQueue>
#include <QThread>
// application specific includes
#include "libCommon/fightResultStatus.h"
#include "libCommon/gameData.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericMap.h"
#include "libCommon/genericLord.h"
#include "libCommon/genericPlayer.h"

#include "libServer/attalServer.h"
#include "libServer/fightEngine.h"

class Campaign;
class GenericBonus;
class GenericMapCreature;
class QuestionManager;
class ScenarioParser;
class TavernManager;

/*              ------------------------------
 *                         Engine
 *              ------------------------------ */


class Engine : public QThread, public GameData
{
	Q_OBJECT
public:
	/** Constructor */
	Engine( AttalServer * serv );
	
	~Engine();

	void run();

	/** Start game (scenario) */
	void startGame();
	
	/** Start game (scenario) */
	void startCampaign();
	
	void deleteCampaign();

	/** Load a game (scenario) */
	bool loadGame( const QString & filename , bool silent);
	
	/** Load a game (scenario) */
	bool loadCampaign( const QString & filename );

	/** Save the game */
	bool saveGame( const QString & filename );

	/** End the game */
	void endGame();

	/** Start a fight */
	void startFight();
	void startFight( int lordAttack, GenericLord *lordDefense );
	void startFight( int lordAttack, GenericMapCreature * creature );

	/** End the fight */
	void endFight();

	/** Reinit game engine */
	void reinit();
	
	int getNumFillPlayers() { return _tmpPlay > 0 ? _tmpPlay : 0 ; }
	
	bool checkGamePlayers( const QString & filename );

	Campaign * getCampaign() { return _campaign; }
	
	enum State {
		NOT_PLAYING,
		IN_GAME,
		IN_QUESTION,
		IN_FIGHT
	};

	State getState() { return _state; }

	void setGameId( int id ) { _gameId = id; }

	int getGameId() { return _gameId; }

	void appendPlayersList( QList<AttalPlayerSocket *> sockets );

	void addPlayer( AttalPlayerSocket * socket );

	void addPlayer( GenericPlayer * player );
	
	void removePlayer( GenericPlayer * player );
	
	void removePlayer( AttalPlayerSocket * socket );

public slots:
	/** Slot who reads socket */
	//void slot_readSocket( int );
	
	void slot_readData( int, AttalSocketData );

	/** Slot for managing new players */
	void slot_newPlayer( AttalPlayerSocket * player );

	/** Slot for removing a player disconnected */
	void slot_endConnection( QString name );

	/** Slot catching end of fight */
	void slot_endFight( FightResultStatus result );

signals:
	void sig_result( int, bool);
	
	void sig_endGame( int );

private:
	enum CreatureAction {
		CreatureJoin,
		CreatureMercenary,
		CreatureFlee,
		CreatureFight
	};

	CreatureAction computeCreatureAction( GenericMapCreature * creature, double ratio );

	void nextCurrentPlayer();
	/** Activate the next player */
	void nextPlayer();

	bool checkMainQuest();
	void updatePlayers();
	void checkPlayerShouldPlay();

	void manageSocketState( int num );
	void stateNotPlaying( int num );
	void stateInGame( int num );
	void stateInQuestion( uint num );
	void stateInFight( int num );
	
	void handleMessage( int num );
	void handleCommand( int num , const QString & cmd );

	void handleAnswer();
	void handleInGameMvt( int num );
	void handleInGameExchange();
	void handleInGameModif();
	void handleInGameModifBase();
	void handleInGameModifBaseBuilding();
	void handleInGameModifBaseUnit();
	void handleInGameModifBaseMarket();
	void handleInGameModifLord();
	void handleInGameModifLordGarrison();
	void handleInGameModifLordUnit();
	void handleInGameModifLordBuy();
	void handleInGameTurn();
	
	void handleGameTavern();
	void handleGameTavernInfo();
	void handleGameTavernLord();

	void newDay();
	void updateCreatures();
	void removeCreature( GenericMapCreature * creature );
	void updateProduction();
	void checkNewWeek();

	void handleAnswerCreatureJoin();
	void handleAnswerCreatureMercenary();
	void handleAnswerCreatureFlee();
	
	// enter into building (if return == true)
	bool handleBuildingEnter( GenericBuilding * building, GenericLord * lord );
	
	void handleAction( Action * action, GenericLord * lord );
	void handleAction( Action * action, GenericPlayer * player, GenericResourceList * rlist = NULL );
	void handleActionListDate( QList<Action *> list, GenericPlayer * player, GenericResourceList * rlist = NULL );

	void handleCreatTurn( GenericPlayer * player, GenericLord * lord );
	void handleBaseTurn( GenericPlayer * player, GenericBase * base );
	void handleBuildingTurn( GenericPlayer * player, GenericBuilding * building );
	//void handlePopulation( GenericPlayer * player );

	bool handleOneMove( GenericLord * movingLord, GenericCell * destCell, int num );
	void movingOnLord( GenericLord * movingLord, GenericCell * destCell );
	void movingOnEvent( GenericLord * movingLord, GenericCell * destCell );
	void movingOnArtefact( GenericLord * movingLord, GenericCell * destCell );
	void movingOnBonus( GenericLord * movingLord, GenericCell * destCell );
	void movingOnBonusResource( GenericBonus * bonus );
	void movingOnBonusPrimSkill( GenericLord * movingLord, GenericBonus * bonus );
	void movingOnChest( GenericLord * movingLord, GenericCell * destCell );
	void movingOnBuilding( GenericLord * movingLord, GenericCell * destCell );
	void movingOnBase( GenericLord * movingLord, GenericCell * destCell );
	void movingOnCreature( GenericLord * movingLord, GenericCell * destCell );
	void movingOnFreeCell( GenericLord * movingLord, GenericCell * destCell );

	void exchangeUnits();
	void exchangeArtefact();
	void exchangeBaseUnits();
	void exchangeUnitSplit();

	uint getAlivePlayersNumber();

	bool enoughPlayers();
	void checkResult();

	void updatePlayerPrices( GenericPlayer * player);

	void updateMapVision( QList<GenericCell *> & removed, QList<GenericCell *> & added );
	void updateCellVision( GenericCell * cell );

	void manageIncreaseExperience( GenericLord * lord, uint experience );
	void decreaseMove( GenericLord * movingLord, GenericCell * cell );
	void moveLord( GenericLord * movingLord, GenericCell * cell );
	
	/** Save a campaing **/
	bool saveCampaign( const QString & filename );

	int readInt();

	unsigned char readChar();

	uchar getCla1();
	uchar getCla2();
	uchar getCla3();

	bool _isCreature;
	bool _isProcessing;
	int _tmpPlay;
	int _num;
	int _gameId;

	AttalServer * _server;
	FightEngine * _fight;
	State _state;
	GenericPlayer * _currentPlayer;
	Campaign * _campaign;

	QuestionManager * _question;
	TavernManager * _tavern;
	QQueue<AttalSocketData> _dataQueue;
	AttalSocketData _currentData;

};

#endif //ENGINE_H
