!{\src2tex{textfont=tt}}
!!****f* ABINIT/testscr
!!
!! NAME
!! testscr
!!
!! FUNCTION
!! Test epsilon-twiddle**-1 file and return its dimension
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtfil=filenames (only dtfil%filscr is used)
!!
!! OUTPUT
!!  fform=file format
!!  nbndse=number of bands
!!  npwvece=number of planewaves for screening matrix
!!  npwwfne=number of planewaves for wavefunctions
!!  nomega=number of frequencies
!!  nq=number of q points
!!  titem1=title of the file
!!
!! PARENTS
!!      mrgscr,sigma
!!
!! CHILDREN
!!      hdr_clean,hdr_io
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine testscr(dtfil,nq,nomega,npwvece,npwwfne,nbndse,titem1,fform,mpi_enreg,nonlocal)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_13io_mpi
 use interfaces_14iowfdenpot
 use interfaces_15gw, except_this_one => testscr
 use interfaces_lib01hidempi
#else
 use defs_interfaces
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none
#if defined MPI || defined MPI_FFT
    include 'mpif.h'
#endif
    
!Arguments ------------------------------------
!scalars
 integer,intent(out) :: fform,nbndse,nomega,npwvece,npwwfne,nq
 type(datafiles_type),intent(in) :: dtfil
 type(MPI_type),intent(in) :: mpi_enreg
  
!arrays
 character(len=80),intent(out) :: titem1(2)
 logical,intent(in)::nonlocal
!Local variables-------------------------------
!scalars
 integer,parameter :: unitem1=24
 integer :: bantot,date,found_format,headform,ios,intxc,ixc,natom,nkpt,nspden
 integer :: nspinor,nsppol,nsym,rdwr,readnetcdf
 character(len=500) :: message
 type(hdr_type) :: hdr
!arrays
 integer :: ngfft(3)
 integer::spaceComm,me,master,ierr

! *************************************************************************

!start clock
 call pclock(0)
!Init mpi_comm
  call xcomm_init(mpi_enreg,spaceComm)
!Init me
  call xme_init(mpi_enreg,me)
!Init master
  call xmaster_init(mpi_enreg,master)

 if( mpi_enreg%nproc==1 .or. (.not.nonlocal) .or. me==0 )then

  write(message,'(2a)')' testscr : testing screening file ',trim(dtfil%filscr)
  call wrtout(6,message,'COLL')

! Try before em1 format
  found_format=0

  open(unit=unitem1,file=dtfil%filscr,status='unknown',form='unformatted',iostat=ios)
  if (ios/=0) then 
   write(message,'(4a)')&
&   ' testscr : ERROR -',ch10,&
&   ' opening file ',trim(dtfil%filscr)
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if  

! Read the header
  rdwr=1
  readnetcdf = 0 ! should make EM1 also a netcdf file
  if (readnetcdf == 0) then
   call hdr_io(fform,hdr,rdwr,unitem1)
  else if (readnetcdf == 1) then
   call hdr_io(fform,hdr,rdwr,unitem1)
  end if

  if(fform==1002)then
   call hdr_clean(hdr)
   read(unitem1,err=100) titem1
   read(unitem1,err=100) npwvece,npwwfne,nbndse,nq,nomega
   write(message,'(a)')   ' epsilon^-1 file in the format em1'
   call wrtout(6,message,'COLL')
   write(message,'(1x,a79,a,1x,a79)')titem1(1)(:79),ch10,titem1(2)(:79)
   call wrtout(6,message,'COLL')
   write(message,'(a,i8)')' dimension of epsilon^-1 matrix   ',npwvece
   call wrtout(6,message,'COLL')
   write(message,'(a,i8)')' number of planewaves used        ',npwwfne
   call wrtout(6,message,'COLL')
   write(message,'(a,i8)')' number of bands used             ',nbndse
   call wrtout(6,message,'COLL')
   write(message,'(a,i8)')' number of q-points               ',nq
   call wrtout(6,message,'COLL')
   write(message,'(a,i8,a)')' number of omega                  ',nomega,ch10
   call wrtout(6,message,'COLL')
   found_format=1
   100 continue
   close(unitem1)
  end if

  if(found_format==0)then
!  Now try old epsm1 format in single and double precision
   open(unitem1,status='unknown',form='unformatted')
   read(unitem1,err=200) titem1
   read(unitem1,err=200) nq
!  Skip q-points
   read(unitem1)
   read(unitem1,err=200) npwvece,npwwfne,nbndse
   write(6,*) 'epsilon^-1 file in the format epsm1'
   write(6,'(1x,a79/1x,a79)') titem1(1)(:79), titem1(2)(:79)
   write(6,*) 'dimension of epsm1 matrix ',npwvece
   write(6,*) 'number of planewaves used ',npwwfne
   write(6,*) 'number of bands used      ',nbndse
   write(6,*) 'number of q-points        ',nq
   write(6,*)
   found_format=1
   fform=1003
   200 continue
   close(unitem1)
  end if

  if(found_format==0)then
   write(message,'(3a)')&
&   ' testscr : ERROR - ',ch10,&
&   ' epsilon^-1 file format unknown'
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if

 end if ! parallelism condition

 if(mpi_enreg%nproc>1.and.nonlocal.and.me>0)then
  titem1(1)='not'
  titem1(2)='important'
 end if

 if(mpi_enreg%nproc>1.and.nonlocal)then       ! if is the first case cast the data to other proc
  call xcast_mpi(nq,master,spaceComm,ierr)
  call xcast_mpi(nomega,master,spaceComm,ierr)
  call xcast_mpi(npwvece,master,spaceComm,ierr)
  call xcast_mpi(npwwfne,master,spaceComm,ierr)
  call xcast_mpi(nbndse,master,spaceComm,ierr)
  call xcast_mpi(fform,master,spaceComm,ierr)
 end if
 end subroutine testscr
!!***
