#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hauma - A Detective Noir Story
# send your bug reports to contact@dotslashplay.it
###

script_version=20240229.4

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='hauma-a-detective-noir-story'
GAME_NAME='Hauma - A Detective Noir Story'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_0_NAME='setup_hauma_-_a_detective_noir_story_1.04_(69325).exe'
ARCHIVE_BASE_0_MD5='e6fc035ebe25667b38c3a2d7e4b37bb7'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_hauma_-_a_detective_noir_story_1.04_(69325)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='45212abd3511d32f07b5cd03a09ef370'
ARCHIVE_BASE_0_SIZE='2118754'
ARCHIVE_BASE_0_VERSION='1.04-gog69325'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/hauma_a_detective_noir_story'

ARCHIVE_BASE_DEMO_0_NAME='setup_hauma_-_a_detective_noir_story_demo_1.00_(67500).exe'
ARCHIVE_BASE_DEMO_0_MD5='1c227ca038d28e96d78d81f616536b62'
ARCHIVE_BASE_DEMO_0_TYPE='innosetup'
ARCHIVE_BASE_DEMO_0_PART1_NAME='setup_hauma_-_a_detective_noir_story_demo_1.00_(67500)-1.bin'
ARCHIVE_BASE_DEMO_0_PART1_MD5='a6a708237c1df4de6008862d9c92fc30'
ARCHIVE_BASE_DEMO_0_SIZE='2118728'
ARCHIVE_BASE_DEMO_0_VERSION='1.00-gog67500'
ARCHIVE_BASE_DEMO_0_URL='https://www.gog.com/game/hauma_a_detective_noir_story_demo'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
settings.cfg
fmod.dll
fmodstudio.dll
libgodotfmod.windows.release.64.dll
hauma.exe'
CONTENT_GAME_DATA_FILES='
hauma.pck'
## The game crashes on launch if the Steam libraries are not available.
CONTENT_GAME0_BIN_FILES='
godotsteam.dll
steam_api64.dll'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Godot/app_userdata/Hauma'

USER_PERSISTENT_FILES='
settings.cfg'

APP_MAIN_EXE='hauma.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_DEMO="$PKG_DATA_ID_DEMO"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
