/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.crypt;

import java.io.File;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.io.IOUtils;

public class CryptUtils {
    public static final int DEFAULT_KEY_LENGTH = 2048;
    public static final String DEFAULT_ENCRYPTION_ALGORITHM = "RSA";
    public static final String DEFAULT_RANDOM_NUMBER_GENERATION_ALGORITHM = "SHA1PRNG";
    public static final String GATK_DISTRIBUTED_PUBLIC_KEY_FILE_NAME = "GATK_public.key";
    public static final String GATK_MASTER_PRIVATE_KEY_FILE = "/humgen/gsa-hpprojects/GATK/data/gatk_master_keys/GATK_private.key";
    public static final String GATK_MASTER_PUBLIC_KEY_FILE = "/humgen/gsa-hpprojects/GATK/data/gatk_master_keys/GATK_public.key";
    public static final String GATK_USER_KEY_DIRECTORY = "/humgen/gsa-hpprojects/GATK/data/gatk_user_keys/";

    public static KeyPair generateKeyPair() {
        return CryptUtils.generateKeyPair(2048, DEFAULT_ENCRYPTION_ALGORITHM, DEFAULT_RANDOM_NUMBER_GENERATION_ALGORITHM);
    }

    public static KeyPair generateKeyPair(int keyLength, String encryptionAlgorithm, String randNumberAlgorithm) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(encryptionAlgorithm);
            SecureRandom randomnessSource = CryptUtils.createRandomnessSource(randNumberAlgorithm);
            keyGen.initialize(keyLength, randomnessSource);
            return keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ReviewedStingException(String.format("Could not find an implementation of the requested encryption algorithm %s", encryptionAlgorithm), e);
        }
        catch (Exception e) {
            throw new ReviewedStingException("Error while generating key pair", e);
        }
    }

    public static SecureRandom createRandomnessSource() {
        return CryptUtils.createRandomnessSource(DEFAULT_RANDOM_NUMBER_GENERATION_ALGORITHM);
    }

    public static SecureRandom createRandomnessSource(String randAlgorithm) {
        try {
            return SecureRandom.getInstance(randAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ReviewedStingException(String.format("Could not find an implementation of the requested random-number generation algorithm %s", randAlgorithm), e);
        }
    }

    public static void writeKeyPair(KeyPair keyPair, File privateKeyFile, File publicKeyFile) {
        CryptUtils.writeKey(keyPair.getPrivate(), privateKeyFile);
        CryptUtils.writeKey(keyPair.getPublic(), publicKeyFile);
    }

    public static void writeKey(Key key, File destination) {
        IOUtils.writeByteArrayToFile(key.getEncoded(), destination);
    }

    public static PublicKey readPublicKey(File source) {
        return CryptUtils.decodePublicKey(IOUtils.readFileIntoByteArray(source), DEFAULT_ENCRYPTION_ALGORITHM);
    }

    public static PublicKey readPublicKey(InputStream source) {
        return CryptUtils.decodePublicKey(IOUtils.readStreamIntoByteArray(source), DEFAULT_ENCRYPTION_ALGORITHM);
    }

    public static PublicKey decodePublicKey(byte[] rawKey, String encryptionAlgorithm) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(rawKey);
            KeyFactory keyFactory = KeyFactory.getInstance(encryptionAlgorithm);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ReviewedStingException(String.format("Could not find an implementation of the requested encryption algorithm %s", encryptionAlgorithm), e);
        }
        catch (InvalidKeySpecException e) {
            throw new ReviewedStingException("Unable to use X.509 key specification to decode the given key", e);
        }
    }

    public static PrivateKey readPrivateKey(File source) {
        return CryptUtils.decodePrivateKey(IOUtils.readFileIntoByteArray(source), DEFAULT_ENCRYPTION_ALGORITHM);
    }

    public static PrivateKey readPrivateKey(InputStream source) {
        return CryptUtils.decodePrivateKey(IOUtils.readStreamIntoByteArray(source), DEFAULT_ENCRYPTION_ALGORITHM);
    }

    public static PrivateKey decodePrivateKey(byte[] rawKey, String encryptionAlgorithm) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(rawKey);
            KeyFactory keyFactory = KeyFactory.getInstance(encryptionAlgorithm);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ReviewedStingException(String.format("Could not find an implementation of the requested encryption algorithm %s", encryptionAlgorithm), e);
        }
        catch (InvalidKeySpecException e) {
            throw new ReviewedStingException("Unable to use the PKCS #8 key specification to decode the given key", e);
        }
    }

    public static PublicKey loadGATKDistributedPublicKey() {
        InputStream publicKeyInputStream = ClassLoader.getSystemResourceAsStream(GATK_DISTRIBUTED_PUBLIC_KEY_FILE_NAME);
        if (publicKeyInputStream == null) {
            throw new ReviewedStingException(String.format("Could not locate the GATK public key %s in the classpath", GATK_DISTRIBUTED_PUBLIC_KEY_FILE_NAME));
        }
        return CryptUtils.readPublicKey(publicKeyInputStream);
    }

    public static PrivateKey loadGATKMasterPrivateKey() {
        return CryptUtils.readPrivateKey(new File(GATK_MASTER_PRIVATE_KEY_FILE));
    }

    public static PublicKey loadGATKMasterPublicKey() {
        return CryptUtils.readPublicKey(new File(GATK_MASTER_PUBLIC_KEY_FILE));
    }

    public static byte[] encryptData(byte[] data, Key encryptKey) {
        return CryptUtils.transformDataUsingCipher(data, encryptKey, 1);
    }

    public static byte[] decryptData(byte[] encryptedData, Key decryptKey) {
        return CryptUtils.transformDataUsingCipher(encryptedData, decryptKey, 2);
    }

    private static byte[] transformDataUsingCipher(byte[] data, Key key, int cipherMode) {
        try {
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            cipher.init(cipherMode, key);
            return cipher.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ReviewedStingException(String.format("Could not find an implementation of the requested algorithm %s", key.getAlgorithm()), e);
        }
        catch (InvalidKeyException e) {
            throw new ReviewedStingException("Key is invalid", e);
        }
        catch (GeneralSecurityException e) {
            throw new ReviewedStingException("Error during encryption", e);
        }
    }

    public static boolean keysDecryptEachOther(PrivateKey privateKey, PublicKey publicKey) {
        byte[] plainText = "Test PlainText".getBytes();
        byte[] dataEncryptedUsingPrivateKey = CryptUtils.encryptData(plainText, privateKey);
        byte[] dataEncryptedUsingPublicKey = CryptUtils.encryptData(plainText, publicKey);
        byte[] privateKeyDataDecryptedWithPublicKey = CryptUtils.decryptData(dataEncryptedUsingPrivateKey, publicKey);
        byte[] publicKeyDataDecryptedWithPrivateKey = CryptUtils.decryptData(dataEncryptedUsingPublicKey, privateKey);
        if (Arrays.equals(plainText, dataEncryptedUsingPrivateKey) || Arrays.equals(plainText, dataEncryptedUsingPublicKey) || Arrays.equals(dataEncryptedUsingPrivateKey, dataEncryptedUsingPublicKey)) {
            return false;
        }
        return Arrays.equals(plainText, privateKeyDataDecryptedWithPublicKey) && Arrays.equals(plainText, publicKeyDataDecryptedWithPrivateKey);
    }
}

