/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import net.sf.picard.reference.FastaSequenceIndex;
import net.sf.picard.reference.FastaSequenceIndexEntry;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class FastaSequenceIndexBuilder {
    public final File fastaFile;
    final boolean printProgress;
    long bytesRead;
    long endOfLastLine;
    long lastTimestamp;
    long fileLength;
    String contig;
    long location;
    long size;
    long bytesPerLine;
    long basesPerLine;
    long basesThisLine;
    int thisSequenceIndex = 0;
    byte lastByte = 0;
    byte currentByte = 0;
    byte nextByte = 0;
    Status status = Status.NONE;

    public FastaSequenceIndexBuilder(File fastaFile, boolean printProgress) {
        this.fastaFile = fastaFile;
        this.fileLength = fastaFile.length();
        this.printProgress = printProgress;
    }

    public FastaSequenceIndex createIndex() {
        DataInputStream in;
        this.bytesRead = -1L;
        this.endOfLastLine = -1L;
        this.contig = "";
        this.location = 0L;
        this.size = 0L;
        this.bytesPerLine = 0L;
        this.basesPerLine = 0L;
        this.basesThisLine = 0L;
        this.lastTimestamp = System.currentTimeMillis();
        FastaSequenceIndex sequenceIndex = new FastaSequenceIndex();
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fastaFile)));
        }
        catch (Exception e) {
            throw new UserException.CouldNotReadInputFile(this.fastaFile, "Could not read fasta file", e);
        }
        try {
            this.nextByte = in.readByte();
            this.currentByte = (byte)10;
            while (this.currentByte != -1) {
                ++this.bytesRead;
                this.lastByte = this.currentByte;
                this.currentByte = this.nextByte;
                try {
                    this.nextByte = in.readByte();
                }
                catch (EOFException e) {
                    this.nextByte = (byte)-1;
                }
                switch (this.status) {
                    case NONE: {
                        if (this.currentByte == 62) {
                            this.status = Status.CONTIG;
                            break;
                        }
                        if (this.currentByte != 59) break;
                        this.status = Status.COMMENT;
                        break;
                    }
                    case COMMENT: {
                        if (!this.isEol(this.currentByte) || this.isEol(this.nextByte)) break;
                        this.status = Status.NONE;
                        break;
                    }
                    case CONTIG: {
                        if (this.isEol(this.currentByte)) {
                            if (this.isEol(this.nextByte)) break;
                            this.status = Status.FIRST_SEQ_LINE;
                            this.location = this.bytesRead + 1L;
                            break;
                        }
                        this.contig = this.contig + (char)this.currentByte;
                        break;
                    }
                    case FIRST_SEQ_LINE: {
                        if (this.isEol(this.currentByte)) {
                            if (!this.isEol(this.lastByte)) {
                                this.basesThisLine = this.basesPerLine = this.bytesRead - this.location;
                                this.size += this.basesPerLine;
                            }
                            if (this.isEol(this.nextByte)) break;
                            this.bytesPerLine = this.bytesRead - this.location + 1L;
                            this.status = Status.SEQ_LINE;
                            this.endOfLastLine = this.bytesRead;
                            if (this.nextByte != 59 && this.nextByte != 62) break;
                            this.finishReadingContig(sequenceIndex);
                            break;
                        }
                        if (this.isValidBase(this.currentByte)) break;
                        throw new UserException.MalformedFile(this.fastaFile, String.format("An invalid base was found in the contig: %s", this.contig));
                    }
                    case SEQ_LINE: {
                        if (this.isEol(this.currentByte)) {
                            if (!this.isEol(this.lastByte)) {
                                this.basesThisLine = this.bytesRead - this.endOfLastLine - 1L;
                                this.size += this.basesThisLine;
                            }
                            if (this.isEol(this.nextByte)) break;
                            if (this.nextByte == 59 || this.nextByte == 62) {
                                this.finishReadingContig(sequenceIndex);
                            } else if (this.basesThisLine != this.basesPerLine || this.bytesPerLine != this.bytesRead - this.endOfLastLine) {
                                if (this.isValidBase(this.nextByte) && this.nextByte != -1) {
                                    throw new UserException.MalformedFile(this.fastaFile, String.format("An invalid line was found in the contig: %s", this.contig));
                                }
                                this.finishReadingContig(sequenceIndex);
                            }
                            this.endOfLastLine = this.bytesRead;
                            break;
                        }
                        if (this.isValidBase(this.currentByte)) break;
                        throw new UserException.MalformedFile(this.fastaFile, String.format("An invalid base was found in the contig: %s", this.contig));
                    }
                }
            }
            in.close();
            return sequenceIndex;
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(this.fastaFile, "Could not read fasta file", e);
        }
        catch (Exception e) {
            throw new ReviewedStingException(e.getMessage(), e);
        }
    }

    private boolean isEol(byte currentByte) {
        return currentByte == 10 || currentByte == 13;
    }

    private boolean isValidBase(byte currentByte) {
        return !Character.isWhitespace(currentByte) && currentByte != 59 && currentByte != 62;
    }

    private void finishReadingContig(FastaSequenceIndex sequenceIndex) {
        sequenceIndex.add(new FastaSequenceIndexEntry(FastaSequenceIndexBuilder.trimContigName(this.contig), this.location, this.size, (int)this.basesPerLine, (int)this.bytesPerLine, this.thisSequenceIndex++));
        this.status = Status.NONE;
        this.contig = "";
        this.size = 0L;
        if (System.currentTimeMillis() - this.lastTimestamp > 10000L) {
            int percentProgress = (int)(100L * this.bytesRead / this.fileLength);
            if (this.printProgress) {
                System.out.println(String.format("PROGRESS UPDATE: file is %d percent complete", percentProgress));
            }
            this.lastTimestamp = System.currentTimeMillis();
        }
    }

    private static String trimContigName(String contigName) {
        int whitespaceIndex = contigName.indexOf(32);
        return whitespaceIndex == -1 ? contigName : contigName.substring(0, whitespaceIndex);
    }

    public static void saveAsFaiFile(FastaSequenceIndex sequenceIndex, File faiFile) {
        BufferedWriter out;
        try {
            out = new BufferedWriter(new FileWriter(faiFile));
        }
        catch (Exception e) {
            throw new UserException.CouldNotCreateOutputFile(faiFile, e);
        }
        try {
            for (FastaSequenceIndexEntry entry : sequenceIndex) {
                out.write(FastaSequenceIndexBuilder.toIndexFileLine(entry));
                out.newLine();
            }
            out.close();
        }
        catch (Exception e) {
            throw new UserException.CouldNotCreateOutputFile(faiFile, e);
        }
    }

    private static String toIndexFileLine(FastaSequenceIndexEntry entry) {
        return String.format("%s\t%d\t%d\t%d\t%d", entry.getContig(), entry.getSize(), entry.getLocation(), entry.getBasesPerLine(), entry.getBytesPerLine());
    }

    public static enum Status {
        NONE,
        CONTIG,
        FIRST_SEQ_LINE,
        SEQ_LINE,
        COMMENT;

    }
}

