// Copyright 2021 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Old_Uyghur`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v14.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x010F70, 0x010F89]
  ]
});
testPropertyEscapes(
  /^\p{Script=Old_Uyghur}+$/u,
  matchSymbols,
  "\\p{Script=Old_Uyghur}"
);
testPropertyEscapes(
  /^\p{Script=Ougr}+$/u,
  matchSymbols,
  "\\p{Script=Ougr}"
);
testPropertyEscapes(
  /^\p{sc=Old_Uyghur}+$/u,
  matchSymbols,
  "\\p{sc=Old_Uyghur}"
);
testPropertyEscapes(
  /^\p{sc=Ougr}+$/u,
  matchSymbols,
  "\\p{sc=Ougr}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x010F6F],
    [0x010F8A, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Old_Uyghur}+$/u,
  nonMatchSymbols,
  "\\P{Script=Old_Uyghur}"
);
testPropertyEscapes(
  /^\P{Script=Ougr}+$/u,
  nonMatchSymbols,
  "\\P{Script=Ougr}"
);
testPropertyEscapes(
  /^\P{sc=Old_Uyghur}+$/u,
  nonMatchSymbols,
  "\\P{sc=Old_Uyghur}"
);
testPropertyEscapes(
  /^\P{sc=Ougr}+$/u,
  nonMatchSymbols,
  "\\P{sc=Ougr}"
);

reportCompare(0, 0);
