/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.AbstractInstrumentor;
import alt.jiapi.reflect.InstructionList;
import org.apache.log4j.Category;

public class TailInstrumentor
extends AbstractInstrumentor {
    private static Category log = Runtime.getLogCategory(TailInstrumentor.class);
    protected int instructionCount = 0;

    public TailInstrumentor() {
        this(0);
    }

    public TailInstrumentor(int instructionCount) {
        log.info((Object)("Instruction count " + instructionCount));
        if (instructionCount < 0) {
            throw new IllegalArgumentException(instructionCount + " < 0");
        }
        this.instructionCount = instructionCount;
    }

    public void instrument(InstructionList il) {
        InstructionList view;
        log.info((Object)("Instrumenting " + this.getCurrentClass().getName() + "." + il.getDeclaringMethod().getName()));
        if (this.instructionCount > il.size()) {
            log.warn((Object)("List size exceeded: instructions needed : " + this.instructionCount + ", available " + il.size() + ". Using all that is available."));
            view = il.createView(0, il.size());
        } else {
            view = il.createView(il.size() - this.instructionCount, il.size());
        }
        this.forward(view);
    }
}

