/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.event;

import alt.jiapi.event.EventProducer;
import java.util.EventObject;

public class JiapiEvent
extends EventObject {
    protected int id;
    protected Object sourceObject;
    protected Object target;
    protected String targetName;
    private boolean testProtection = false;

    public JiapiEvent(EventProducer ep, Object sourceObject, String targetName, int id) {
        this(ep, sourceObject, targetName, null, id);
    }

    public JiapiEvent(EventProducer ep, Object sourceObject, String targetName, Object target, int id) {
        super(ep);
        this.sourceObject = sourceObject;
        this.targetName = targetName;
        this.target = target;
        this.id = id;
    }

    public Object getSourceObject() {
        return this.sourceObject;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Object getTarget() {
        return this.target;
    }

    public void protect() {
        ((EventProducer)this.getSource()).protect(this);
    }

    public void release() {
        ((EventProducer)this.getSource()).release(this);
    }

    public String toString() {
        if (this.testProtection) {
            String s = null;
            if (this.sourceObject != null) {
                this.protect();
                s = this.sourceObject.toString();
                this.release();
            }
            return s;
        }
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(", source=");
        if (this.sourceObject instanceof String) {
            sb.append(this.sourceObject);
        } else if (this.sourceObject instanceof Class) {
            sb.append(this.sourceObject.toString());
        } else {
            sb.append(this.sourceObject.getClass().getName());
        }
        sb.append(", target name=");
        sb.append(this.targetName);
        sb.append(", target=");
        if (this.target != null) {
            sb.append(this.target.getClass().getName());
        } else {
            sb.append("null");
        }
        sb.append(", id=");
        sb.append(this.id);
        return sb.toString();
    }

    public void finalize() {
        try {
            ((EventProducer)this.getSource()).release(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

