; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefix=SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefix=AVX

; fold sextinreg(zext) -> sext
define <4 x i64> @sextinreg_zext_v16i8_4i64(<16 x i8> %a0) {
; SSE-LABEL: sextinreg_zext_v16i8_4i64:
; SSE:       # BB#0:
; SSE-NEXT:    pmovsxbq %xmm0, %xmm2
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    pmovsxbq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sextinreg_zext_v16i8_4i64:
; AVX:       # BB#0:
; AVX-NEXT:    vpmovsxbq %xmm0, %ymm0
; AVX-NEXT:    retq
  %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = zext <4 x i8> %1 to <4 x i64>
  %3 = shl <4 x i64> %2, <i64 56, i64 56, i64 56, i64 56>
  %4 = ashr <4 x i64> %3, <i64 56, i64 56, i64 56, i64 56>
  ret <4 x i64> %4
}

; fold sextinreg(zext(sext)) -> sext
define <4 x i64> @sextinreg_zext_sext_v16i8_4i64(<16 x i8> %a0) {
; SSE-LABEL: sextinreg_zext_sext_v16i8_4i64:
; SSE:       # BB#0:
; SSE-NEXT:    pmovsxbq %xmm0, %xmm2
; SSE-NEXT:    psrld $16, %xmm0
; SSE-NEXT:    pmovsxbq %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sextinreg_zext_sext_v16i8_4i64:
; AVX:       # BB#0:
; AVX-NEXT:    vpmovsxbq %xmm0, %ymm0
; AVX-NEXT:    retq
  %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = sext <4 x i8> %1 to <4 x i32>
  %3 = zext <4 x i32> %2 to <4 x i64>
  %4 = shl <4 x i64> %3, <i64 32, i64 32, i64 32, i64 32>
  %5 = ashr <4 x i64> %4, <i64 32, i64 32, i64 32, i64 32>
  ret <4 x i64> %5
}
