package machinelearning

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// WebServicesClient is the these APIs allow end users to operate on Azure
// Machine Learning Web Services resources. They support the following
// operations:<ul><li>Create or update a web service</li><li>Get a web
// service</li><li>Patch a web service</li><li>Delete a web
// service</li><li>Get All Web Services in a Resource Group </li><li>Get All
// Web Services in a Subscription</li><li>Get Web Services Keys</li></ul>
type WebServicesClient struct {
	ManagementClient
}

// NewWebServicesClient creates an instance of the WebServicesClient client.
func NewWebServicesClient(subscriptionID string) WebServicesClient {
	return NewWebServicesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWebServicesClientWithBaseURI creates an instance of the
// WebServicesClient client.
func NewWebServicesClientWithBaseURI(baseURI string, subscriptionID string) WebServicesClient {
	return WebServicesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or updates a new Azure ML web service or update an
// existing one. This method may poll for completion. Polling can be canceled
// by passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// createOrUpdatePayload is the payload to create or update the Azure ML web
// service. resourceGroupName is name of the resource group. webServiceName
// is the Azure ML web service name which you want to reach.
func (client WebServicesClient) CreateOrUpdate(createOrUpdatePayload WebService, resourceGroupName string, webServiceName string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.CreateOrUpdatePreparer(createOrUpdatePayload, resourceGroupName, webServiceName, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "CreateOrUpdate", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "CreateOrUpdate", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client WebServicesClient) CreateOrUpdatePreparer(createOrUpdatePayload WebService, resourceGroupName string, webServiceName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webServiceName":    autorest.Encode("path", webServiceName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}", pathParameters),
		autorest.WithJSON(createOrUpdatePayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client WebServicesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client WebServicesClient) CreateOrUpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get retrieve an Azure ML web service definition by its subscription,
// resource group and name.
//
// resourceGroupName is name of the resource group. webServiceName is the
// Azure ML web service name which you want to reach.
func (client WebServicesClient) Get(resourceGroupName string, webServiceName string) (result WebService, err error) {
	req, err := client.GetPreparer(resourceGroupName, webServiceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "Get", nil, "Failure preparing request")
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "Get", resp, "Failure sending request")
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client WebServicesClient) GetPreparer(resourceGroupName string, webServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webServiceName":    autorest.Encode("path", webServiceName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client WebServicesClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client WebServicesClient) GetResponder(resp *http.Response) (result WebService, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List retrieve all Azure ML web services in the current Azure subscription.
//
// skiptoken is continuation token for pagination.
func (client WebServicesClient) List(skiptoken string) (result PaginatedWebServicesList, err error) {
	req, err := client.ListPreparer(skiptoken)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "List", nil, "Failure preparing request")
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "List", resp, "Failure sending request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client WebServicesClient) ListPreparer(skiptoken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearning/webServices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client WebServicesClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client WebServicesClient) ListResponder(resp *http.Response) (result PaginatedWebServicesList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListInResourceGroup retrieve all Azure ML web services in a given resource
// group.
//
// resourceGroupName is name of the resource group. skiptoken is continuation
// token for pagination.
func (client WebServicesClient) ListInResourceGroup(resourceGroupName string, skiptoken string) (result PaginatedWebServicesList, err error) {
	req, err := client.ListInResourceGroupPreparer(resourceGroupName, skiptoken)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "ListInResourceGroup", nil, "Failure preparing request")
	}

	resp, err := client.ListInResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "ListInResourceGroup", resp, "Failure sending request")
	}

	result, err = client.ListInResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "ListInResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListInResourceGroupPreparer prepares the ListInResourceGroup request.
func (client WebServicesClient) ListInResourceGroupPreparer(resourceGroupName string, skiptoken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}
	if len(skiptoken) > 0 {
		queryParameters["$skiptoken"] = autorest.Encode("query", skiptoken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListInResourceGroupSender sends the ListInResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client WebServicesClient) ListInResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListInResourceGroupResponder handles the response to the ListInResourceGroup request. The method always
// closes the http.Response Body.
func (client WebServicesClient) ListInResourceGroupResponder(resp *http.Response) (result PaginatedWebServicesList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListKeys get the access keys of a particular Azure ML web service
//
// resourceGroupName is name of the resource group. webServiceName is the
// Azure ML web service name which you want to reach.
func (client WebServicesClient) ListKeys(resourceGroupName string, webServiceName string) (result WebServiceKeys, err error) {
	req, err := client.ListKeysPreparer(resourceGroupName, webServiceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "ListKeys", nil, "Failure preparing request")
	}

	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "ListKeys", resp, "Failure sending request")
	}

	result, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "ListKeys", resp, "Failure responding to request")
	}

	return
}

// ListKeysPreparer prepares the ListKeys request.
func (client WebServicesClient) ListKeysPreparer(resourceGroupName string, webServiceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webServiceName":    autorest.Encode("path", webServiceName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}/listKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListKeysSender sends the ListKeys request. The method will close the
// http.Response Body if it receives an error.
func (client WebServicesClient) ListKeysSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListKeysResponder handles the response to the ListKeys request. The method always
// closes the http.Response Body.
func (client WebServicesClient) ListKeysResponder(resp *http.Response) (result WebServiceKeys, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Patch patch an existing Azure ML web service resource. This method may poll
// for completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// patchPayload is the payload to patch the Azure ML web service with.
// resourceGroupName is name of the resource group. webServiceName is the
// Azure ML web service name which you want to reach.
func (client WebServicesClient) Patch(patchPayload WebService, resourceGroupName string, webServiceName string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.PatchPreparer(patchPayload, resourceGroupName, webServiceName, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "Patch", nil, "Failure preparing request")
	}

	resp, err := client.PatchSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "Patch", resp, "Failure sending request")
	}

	result, err = client.PatchResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "Patch", resp, "Failure responding to request")
	}

	return
}

// PatchPreparer prepares the Patch request.
func (client WebServicesClient) PatchPreparer(patchPayload WebService, resourceGroupName string, webServiceName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webServiceName":    autorest.Encode("path", webServiceName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}", pathParameters),
		autorest.WithJSON(patchPayload),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// PatchSender sends the Patch request. The method will close the
// http.Response Body if it receives an error.
func (client WebServicesClient) PatchSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// PatchResponder handles the response to the Patch request. The method always
// closes the http.Response Body.
func (client WebServicesClient) PatchResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Remove remove an existing Azure ML web service. This method may poll for
// completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is name of the resource group. webServiceName is the
// Azure ML web service name which you want to reach.
func (client WebServicesClient) Remove(resourceGroupName string, webServiceName string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.RemovePreparer(resourceGroupName, webServiceName, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "Remove", nil, "Failure preparing request")
	}

	resp, err := client.RemoveSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "Remove", resp, "Failure sending request")
	}

	result, err = client.RemoveResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearning.WebServicesClient", "Remove", resp, "Failure responding to request")
	}

	return
}

// RemovePreparer prepares the Remove request.
func (client WebServicesClient) RemovePreparer(resourceGroupName string, webServiceName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"webServiceName":    autorest.Encode("path", webServiceName),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// RemoveSender sends the Remove request. The method will close the
// http.Response Body if it receives an error.
func (client WebServicesClient) RemoveSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// RemoveResponder handles the response to the Remove request. The method always
// closes the http.Response Body.
func (client WebServicesClient) RemoveResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
