# Copyright (C) 2012 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

"""External tests of 'bzr ping'"""

import bzrlib
from bzrlib import tests


class TestSmartServerPing(tests.TestCaseWithTransport):

    def test_simple_ping(self):
        self.setup_smart_server_with_call_log()
        t = self.make_branch_and_tree('branch')
        self.build_tree_contents([('branch/foo', 'thecontents')])
        t.add("foo")
        t.commit("message")
        self.reset_smart_call_log()
        out, err = self.run_bzr(['ping', self.get_url('branch')])
        self.assertLength(1, self.hpss_calls)
        self.assertLength(1, self.hpss_connections)
        self.assertEquals(out,
            "Response: ('ok', '2')\n"
            "Headers: {'Software version': '%s'}\n" % (bzrlib.version_string,))
        self.assertEquals(err, "")
