/*****************************************************************************
 * yahoofxfer.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2006 Stefan Sikora
 *****************************************************************************/
#ifndef _YAHOOFXFER_H_
#define _YAHOOFXFER_H_

#define YAHOO_RELAYSERVER "relay.msg.yahoo.com"

typedef enum { INPROGRESS=1, SUCCESS, CANCELLED, RETRYING, UNKNOWN } STATUS;
typedef enum { Receiving=1, Sending } DIRECTION;
typedef struct fxfile {
	char  *fullfilename;
	char  *filename;
	char  *filekey;
	int    file_length;
	int    show_meter;
	time_t start_time;
	int    bytes_xfer;
	char  *hostname;
	char  *server;
	char  *who;
	char  *token;
	GtkTreeView *dl_tree;
	GtkTreeIter dl_manager_iter;
	STATUS status;
	int    cancel_transfer;

	void (*open_callback)(void *arg);
	void *open_arg;
	void (*finish_callback)(void *arg);
	void *finish_arg;
} FILE_INFO;

struct fxfile *create_fxfile_info(char *who, char *filename, char *filekey, int file_length);

GtkWidget *create_dl_manager(GtkWidget *pm_session);

void *yahoo_fxfer_getfile_thread(void *arg);
void *yahoo_fxfer_sendfile_thread(void *arg);

gboolean yahoo_relay_server_is_blacklisted(char *server);

void yahoo_start_fxfer(char *who, char *filename);
void yahoo_fxfer_offer_msg(char *who, char *filename, char *filekey, int filelength);
void yahoo_fxfer_decline_msg(char *who, char *filekey);
void yahoo_fxfer_prepsendfile(char *who, char *filekey);
void yahoo_fxfer_getfile_relay(char *who, char *server, char *filename, char *filekey, char *token);
void yahoo_fxfer_sendfile_relay(char *who, char *filekey, char *token);
void yahoo_fxfer_sendfile_relay_cancel(char *who, char *filekey);
void yahoo_fxfer_getfile_p2p(char *who, char *url, char *filename);
void yahoo_fxfer_show_file_selection(char *who, char *server, char *filename, char *filekey, char *token);
void yahoo_fxfer_getfile_cancel(char *who, char *filekey);

extern void append_char_pixmap_text( const char **pixy, GtkWidget *textw);

#endif //_YAHOOFXFER_H_
