/*****************************************************************************
 * animations.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * VERY preliminary code for handling animated smileys
 *****************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "config.h"

#include "animations.h"
#include "gyach.h"
#include "util.h"
#include "gyach_int_text.h"

#include "gy_config.h"


int running_animations=0;

extern GtkWidget *top_text;

typedef struct {
        GdkPixbuf          *static_image;
	GtkTextChildAnchor *tanch;
        GtkTextBuffer      *t_buffer;
} GYACHI_ANIMATION_INFO;

int stop_animation(GYACHI_ANIMATION_INFO *myinfo) {
	GdkPixbuf          *static_image=myinfo->static_image;
	GtkTextBuffer      *t_buffer=myinfo->t_buffer;
	GtkTextChildAnchor *tanch=myinfo->tanch;
	GtkTextIter        start_iter;
	GtkTextIter        end_iter;

	myinfo->static_image=NULL;
	myinfo->tanch=NULL;
	myinfo->t_buffer=NULL;
	free(myinfo);

	if (! GTK_IS_TEXT_CHILD_ANCHOR(tanch) ) {
		/* printf("tanch is destroyed!\n"); */
		tanch=0;
	}

	if (tanch) {
		gtk_text_buffer_get_iter_at_child_anchor(t_buffer, &start_iter, tanch);
		gtk_text_buffer_insert_pixbuf( t_buffer, &start_iter, static_image );
		gtk_text_buffer_get_iter_at_child_anchor(t_buffer, &start_iter, tanch);
		end_iter = start_iter;
		gtk_text_iter_forward_visible_cursor_position(&end_iter);
		gtk_text_buffer_delete(t_buffer, &start_iter, &end_iter);
	}
	g_object_unref(static_image);

	running_animations--;
	if (running_animations<0){
		running_animations=0;
	}

	return 0;
}

void ct_insert_animation( char *filename, GtkWidget *textbox) {
	GdkPixbufAnimation *anim = NULL;
	GdkPixbuf *static_image = NULL;
	GtkTextIter iter;
	GtkTextBuffer *t_buffer;
	int text_length;
	GtkTextView *chat_text = ct_widget();
	GtkTextView *pmst=NULL;
	GtkWidget *myimage=NULL;
	GtkTextChildAnchor *tanch=NULL;
	/* need a small gtk object to carry around data, seems easier, will be destroyed */
	GYACHI_ANIMATION_INFO *myinfo;
	int allow_anim=enable_animations;
	int scalepix=0;

	if (running_animations>=max_sim_animations) {allow_anim=0;}
	if (!show_emoticons) {return;}

	//printf("debug-a\n"); fflush(stdout);

	anim = gdk_pixbuf_animation_new_from_file(filename,NULL);
	static_image = gdk_pixbuf_new_from_file(filename,NULL);

	if ( !static_image) {
		/* we must have a static image. If we cannot load a
		 * static image, then the animation is useless to us
		 */
		/* printf("couldnt load at all!\n"); fflush(stdout);  */
		if (anim) g_object_unref(anim);
		return;
	}

	//printf("debug-b\n"); fflush(stdout);

	if (textbox != NULL) { /* something other than main chat window */
		t_buffer= g_object_get_data(G_OBJECT(textbox),"textbuffer");
		pmst=GTK_TEXT_VIEW(textbox);
	} else {
		t_buffer=text_buffer22; /* default to chat window itself */
	}

	if (t_buffer==NULL) { t_buffer=text_buffer22;  }

	text_length = gtk_text_buffer_get_char_count(t_buffer);
	gtk_text_buffer_get_iter_at_offset(t_buffer, &iter, text_length );

	if ((anim) && (! gdk_pixbuf_animation_is_static_image(anim))
			&& allow_anim) {

		if ( capture_fp ) {	
			fprintf(capture_fp,"\n[%s] ANIMATION RENDERED, File: %s\n", gyach_timestamp(), filename);
			fflush( capture_fp );
		}

		tanch=gtk_text_buffer_create_child_anchor(t_buffer, &iter);
		myimage=gtk_image_new_from_animation(anim);
		g_object_unref( anim );
		anim=NULL;

		if (pmst) {
			gtk_text_view_add_child_at_anchor(pmst, myimage, tanch);
		} else  {
			gtk_text_view_add_child_at_anchor(chat_text, myimage, tanch);
		}

		running_animations++;
		gtk_widget_show_all(myimage);

		myinfo=malloc(sizeof(GYACHI_ANIMATION_INFO));
		myinfo->static_image = static_image;
		myinfo->tanch        = tanch;
		myinfo->t_buffer     = t_buffer;
		static_image=NULL;
		tanch=NULL;
		t_buffer=NULL;
		/* auto-stop all animations after 10 seconds */
		g_timeout_add( 10000, (void *)stop_animation, myinfo );
	} else  {
		/* static gifs and all other images, also when animation is disabled */
		/* try to scale to a reasonable size, if necessary */
		int awidth=0;
		int aheight=0;
		int anim_mxsz=40;
		awidth = gdk_pixbuf_get_width( static_image );
		aheight = gdk_pixbuf_get_height( static_image );

		if (custom_scale_text) {
			if (strcmp(custom_scale_text, "1.0")) {
				anim_mxsz=(int) (anim_mxsz*atof(custom_scale_text));
				if (anim_mxsz>55) {anim_mxsz=55;}
				awidth=(int) (awidth*atof(custom_scale_text));
				aheight=(int) (aheight*atof(custom_scale_text));
				scalepix=1;
				/* printf("scale:  %d  %d   %d\n", anim_mxsz, awidth, aheight);
				   fflush(stdout); */ 
			}
		}

		if ((aheight>anim_mxsz) || scalepix ) {
			GdkPixbuf *spixbuf;
			if (aheight>anim_mxsz) {
				awidth = ( 1.0 * awidth / aheight ) * anim_mxsz;
				aheight = anim_mxsz;
			}
			spixbuf = gdk_pixbuf_scale_simple( static_image, awidth, aheight,
							   GDK_INTERP_BILINEAR );
			if (spixbuf) {
				gtk_text_buffer_insert_pixbuf( t_buffer, &iter, spixbuf ); 
				g_object_unref( spixbuf );
			}
		}
		else {
			gtk_text_buffer_insert_pixbuf( t_buffer, &iter, static_image ); 
		}
		if (anim) {
			g_object_unref( anim );
		}
		g_object_unref( static_image );
		return;
	}
}
