/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.parser;

import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.impl.Ref;
import com.sun.xml.xsom.impl.SchemaImpl;
import com.sun.xml.xsom.impl.UName;
import com.sun.xml.xsom.impl.parser.Messages;
import com.sun.xml.xsom.impl.parser.Patch;
import com.sun.xml.xsom.impl.parser.PatcherManager;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class DelayedRef
implements Patch {
    protected final XSSchemaSet schema;
    private PatcherManager manager;
    private UName name;
    private Locator source;
    private Object ref = null;

    DelayedRef(PatcherManager _manager, Locator _source, SchemaImpl _schema, UName _name) {
        this.schema = _schema.getParent();
        this.manager = _manager;
        this.name = _name;
        this.source = _source;
        if (this.name == null) {
            throw new InternalError();
        }
        this.manager.addPatcher(this);
    }

    public void run() throws SAXException {
        if (this.ref == null) {
            this.resolve();
        }
        this.manager = null;
        this.name = null;
        this.source = null;
    }

    protected abstract Object resolveReference(UName var1);

    protected abstract String getErrorProperty();

    protected final Object _get() {
        if (this.ref == null) {
            throw new InternalError("unresolved reference");
        }
        return this.ref;
    }

    private void resolve() throws SAXException {
        this.ref = this.resolveReference(this.name);
        if (this.ref == null) {
            this.manager.reportError(Messages.format(this.getErrorProperty(), this.name.getQualifiedName()), this.source);
        }
    }

    public void redefine(XSDeclaration d) {
        if (!d.getTargetNamespace().equals(this.name.getNamespaceURI()) || !d.getName().equals(this.name.getName())) {
            return;
        }
        this.ref = d;
        this.manager = null;
        this.name = null;
        this.source = null;
    }

    public static class IdentityConstraint
    extends DelayedRef
    implements Ref.IdentityConstraint {
        public IdentityConstraint(PatcherManager manager, Locator loc, SchemaImpl schema, UName name) {
            super(manager, loc, schema, name);
        }

        protected Object resolveReference(UName name) {
            return this.schema.getIdentityConstraint(name.getNamespaceURI(), name.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedIdentityConstraint";
        }

        public XSIdentityConstraint get() {
            return (XSIdentityConstraint)super._get();
        }
    }

    public static class Attribute
    extends DelayedRef
    implements Ref.Attribute {
        public Attribute(PatcherManager manager, Locator loc, SchemaImpl schema, UName name) {
            super(manager, loc, schema, name);
        }

        protected Object resolveReference(UName name) {
            return this.schema.getAttributeDecl(name.getNamespaceURI(), name.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedAttribute";
        }

        public XSAttributeDecl getAttribute() {
            return (XSAttributeDecl)super._get();
        }
    }

    public static class AttGroup
    extends DelayedRef
    implements Ref.AttGroup {
        public AttGroup(PatcherManager manager, Locator loc, SchemaImpl schema, UName name) {
            super(manager, loc, schema, name);
        }

        protected Object resolveReference(UName name) {
            return this.schema.getAttGroupDecl(name.getNamespaceURI(), name.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedAttributeGroup";
        }

        public XSAttGroupDecl get() {
            return (XSAttGroupDecl)super._get();
        }
    }

    public static class ModelGroup
    extends DelayedRef
    implements Ref.Term {
        public ModelGroup(PatcherManager manager, Locator loc, SchemaImpl schema, UName name) {
            super(manager, loc, schema, name);
        }

        protected Object resolveReference(UName name) {
            return this.schema.getModelGroupDecl(name.getNamespaceURI(), name.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedModelGroup";
        }

        public XSModelGroupDecl get() {
            return (XSModelGroupDecl)super._get();
        }

        public XSTerm getTerm() {
            return this.get();
        }
    }

    public static class Element
    extends DelayedRef
    implements Ref.Element {
        public Element(PatcherManager manager, Locator loc, SchemaImpl schema, UName name) {
            super(manager, loc, schema, name);
        }

        protected Object resolveReference(UName name) {
            return this.schema.getElementDecl(name.getNamespaceURI(), name.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedElement";
        }

        public XSElementDecl get() {
            return (XSElementDecl)super._get();
        }

        public XSTerm getTerm() {
            return this.get();
        }
    }

    public static class ComplexType
    extends DelayedRef
    implements Ref.ComplexType {
        public ComplexType(PatcherManager manager, Locator loc, SchemaImpl schema, UName name) {
            super(manager, loc, schema, name);
        }

        protected Object resolveReference(UName name) {
            return this.schema.getComplexType(name.getNamespaceURI(), name.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedCompplexType";
        }

        public XSComplexType getType() {
            return (XSComplexType)super._get();
        }
    }

    public static class SimpleType
    extends DelayedRef
    implements Ref.SimpleType {
        public SimpleType(PatcherManager manager, Locator loc, SchemaImpl schema, UName name) {
            super(manager, loc, schema, name);
        }

        public XSSimpleType getType() {
            return (XSSimpleType)this._get();
        }

        protected Object resolveReference(UName name) {
            return this.schema.getSimpleType(name.getNamespaceURI(), name.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedSimpleType";
        }
    }

    public static class Type
    extends DelayedRef
    implements Ref.Type {
        public Type(PatcherManager manager, Locator loc, SchemaImpl schema, UName name) {
            super(manager, loc, schema, name);
        }

        protected Object resolveReference(UName name) {
            XSSimpleType o = this.schema.getSimpleType(name.getNamespaceURI(), name.getName());
            if (o != null) {
                return o;
            }
            return this.schema.getComplexType(name.getNamespaceURI(), name.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedType";
        }

        public XSType getType() {
            return (XSType)super._get();
        }
    }
}

