from _typeshed import ReadableBuffer, SupportsNoArgReadline, SupportsRead, SupportsWrite
from typing import Protocol

__all__ = ["encode", "decode", "encodestring", "decodestring"]

class _Input(SupportsRead[bytes], SupportsNoArgReadline[bytes], Protocol): ...

def encode(input: _Input, output: SupportsWrite[bytes], quotetabs: int, header: int = ...) -> None: ...
def encodestring(s: ReadableBuffer, quotetabs: int = ..., header: int = ...) -> bytes: ...
def decode(input: _Input, output: SupportsWrite[bytes], header: int = ...) -> None: ...
def decodestring(s: str | ReadableBuffer, header: int = ...) -> bytes: ...
