#define XERR
#include "incidence.ih"

void Incidence::writeParameters(ostream &out) const
{
    out << "    Incidence:\n";

    auto simulationType = Globals::simulationType();

    for (
        size_t idx = 0, end = simulationType == BREAST ? 3 : 1; 
            idx != end;
                ++idx
    )
    {
        string label;
        switch (simulationType)
        {
            case BREAST:
                label = s_incidence[idx];
            break;

            case FEMALE:
            case MALE:
                label = Globals::label(simulationType);
            break;
        }

        auto &param = d_params[idx];

        Globals::setPrecision(out, 1) <<  
            setw(6) << ' ' << label << '\n' <<
               setw(8) << ' ' << "probability:   " << 
                    param.prob() << 
                    (
                        Globals::isZero(param.prob()) ? 
                            "     (carrier ignored)\n" 
                        : 
                            "\n"
                    );
        
        Globals::setPrecision(out, 2) << 
               setw(8) << ' ' << "std. dev.:    " << param.stdDev() << '\n';

        VSD::fmt(2, 3, 0, 4);
        out << setw(8) << ' ' << "lifetimeRisk: " << param.risk() << '\n';

        VSD::fmt(2, 1, 3, 3);
        out << setw(8) << ' ' << "mean age:     " << param.mean() << "\n\n";
    }
}





