# Test Data Attribution/Licenses

Attribution for the test data (in the `scrape_schema_recipe/test_data/` folder) included in this python package.
These are input for testing the software package.

I've tried to use recipes under Creative Commons Licenses that do not restrict derivation because
a unit test case could be considered a derivation.
I've sparingly using recipes that are licensed non-commercial.  I think unit testing
could constitute as a use that would not conflict with that.

These recipes and their HTML remain are licensed under their respective license, 
NOT the Apache 2.0 license that the software is licensed (except where noted).


## Examples


### Irish Coffee Recipe
* File:       bevvy-irish-coffee.html
* Author:     Bevvy
* Recipe URL: https://bevvy.co/cocktail/irish-coffee/smq
* License:    [Creative Commons Attribution-ShareAlike 3.0 License](https://creativecommons.org/licenses/by-sa/3.0/)
* Website:    [Bevvy](https://bevvy.co/)
* Format:     LD-JSON


### British Treacle Tart
* File:		foodista-british-treacle-tart.html
* Creator:	[Leah Rodrigues](http://foodista.com/profile/XYPGHGF4/leah-rodrigues)
* Recipe URL:	http://foodista.com/recipe/3LH62BBP/british-treacle-tart
* License:	[Creative Commons Attribution License](http://creativecommons.org/licenses/by/3.0/)
* Website:	[Foodista](http://foodista.com/)
* Format:	MicroData (note: this uses an older version of http://schema.org/Recipe)


### Rum & Tonka Bean Dark Chocolate Truffles 
* File:       sweetestkitchen-truffles.html
* Author:     [Jamieanne](http://www.sweetestkitchen.com/about/)
* Recipe URL: http://www.sweetestkitchen.com/2014/11/rum-tonka-bean-dark-chocolate-truffles/
* License:    [Creative Commons Attribution-NonCommercial 3.0 Unported License](http://creativecommons.org/licenses/by-nc/3.0/)
* Website:    [Sweetest Kitchen](http://www.sweetestkitchen.com/)
* Format:     Microdata (note: this uses an older version of http://schema.org/Recipe)


### Meyer Lemon Poppyseed Tea Cakes
* File:		crumb-meyer-lemon-poppyseed-tea-cakes.html
* Author:	[Isabell Boucher](http://www.crumbblog.com/about-isabelle/)
* Recipe URL:	http://www.crumbblog.com/meyer-lemon-poppyseed-tea-cakes/
* License:	[Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Canada License](http://creativecommons.org/licenses/by-nc-sa/2.5/ca/)
from http://www.crumbblog.com/about-the-recipes/
* Website:	[Crumb](http://www.crumbblog.com/)
* Format:	LD-JSON


### Google Example Party Cake
* File:		google-recipe-example.html
* Recipe URL:	https://developers.google.com/search/docs/data-types/recipe
* License:	[Apache 2.0](https://www.apache.org/licenses/LICENSE-2.0)
* Format:	LD-JSON


### Chicken Taco Salad with Chili Lime Chicken
* File:     mm-skinny-chicken-taco-salad.html
* Author:   [Lauren](https://www.midgetmomma.com/about/about-midgetmomma/)
* Recipe URL:  https://www.midgetmomma.com/skinny-chicken-taco-salad/
* License:  [Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License](https://creativecommons.org/licenses/by-nc-sa/3.0/)
* Website:  [Midget Momma](https://www.midgetmomma.com/)
* Format:   LD-JSON

### Flavorful Green Beans
* File:         flavorful-green-beans.html
* Author:       National Heart, Lung, and Blood Institute
* Recipe URL:   https://medlineplus.gov/recipes/flavorful-green-beans/
* License:      [Public Domain](https://medlineplus.gov/about/using/usingcontent/)
* Website:      [MedlinePlus](https://medlineplus.gov/)


## Unit Tests


### Simple Moscow Mule
* File:	      allrecipes-moscow-mule.html
* Author:     [Lorem Ipsum](https://www.allrecipes.com/cook/loremipsum/)
* Recipe URL: https://www.allrecipes.com/recipe/237874/simple-moscow-mule/
* License:    Proprietary
* Website:    [All Recipes](https://www.allrecipes.com/)
* Format:     LD-JSON
