#include <options.h>
#include "opt.h"
#include <helper.h>

#include <stdlib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


static struct args_t args;

#include "config.h"
void args_init () {
  args.system_charset = NULL;
  args.output = OUTPUT_TEXT;

  args.help = 0;
  args.version = 0;
}

static void arg_fill (int short_opt,
	       const char* long_opt,
	       char* argument)
{
  switch (short_opt) {
  case 'h':
    args.help=1;
    break;
  case 'V':
    args.version=1;
    break;
  case 0:
    if (str_len(long_opt)) {
      if (!strcmp(long_opt,"system-charset")) {
	args.system_charset = argument;
      } else if (!strcmp(long_opt,"text")) {
	args.output = OUTPUT_TEXT;
      } else if (!strcmp(long_opt,"csv")) {
	args.output = OUTPUT_CSV;
      }
    }
    break;
  }
}

//gettext workaround
#ifdef _
#undef _
#endif
#define _(s) s
struct args_def_type args_type_list[] = {
  { 0, _("options"), 0 },
  ARGS_DEF_TYPE_LAST
};

struct args_def args_list[] = {
  {"csv",0,NULL,ARGS_PARAM_NONE,NULL,0,
   "output as PDU in CSV format"},
  {"help",'h',NULL,ARGS_PARAM_NONE,NULL,0,
   "print this message"},
  {"system-charset",0,NULL,ARGS_PARAM_REQ,_("charset"),0,
   "use charset for input/output from/to system"},
  {"text",0,NULL,ARGS_PARAM_NONE,NULL,0,
   "output as text (default)"},
  {"version",'V',NULL,ARGS_PARAM_NONE,NULL,0,
   "print the version number"},
  ARGS_DEF_LAST
};

void smi_use_envvars () {
  use_envvars(args_list,arg_fill);
}

char** smi_args_parse (int argc, char** argv) {
  return args_parse(argc,argv,args_list,arg_fill);
}

struct args_t* smi_get_args () {
  return &args;
}
