AC_DEFUN(
MY_DECL_ICONV_CONST,
[
  AH_TEMPLATE(
      [ICONV_CAST],
      [Define as const if the declaration of iconv() needs const]
  )
  AC_MSG_CHECKING([if parameter 2 of iconv() is declared const])
  AC_LANG(C)
  AC_COMPILE_IFELSE(
      AC_LANG_PROGRAM(
	  [
#include <stdlib.h>
#include <iconv.h>
extern
#ifdef __cplusplus
"C"
#endif
#if defined(__STDC__) || defined(__cplusplus)
size_t iconv (iconv_t cd, char** inbuf, size_t* inbytesleft, char** outbuf, size_t* outbytesleft);
#else
size_t iconv();
#endif
          ],
          []
      ),
      [AC_MSG_RESULT(no)
       AC_DEFINE_UNQUOTED(ICONV_CAST,char**)],
      [AC_MSG_RESULT(yes)
       AC_DEFINE_UNQUOTED(ICONV_CAST,const char**)]
  )
]
)

AC_DEFUN(
MY_LIB_POPT,
[
  AC_SEARCH_LIBS(
      poptGetContext,
      popt,
      [AC_DEFINE_UNQUOTED(PARSELIB,2)],
      [AC_MSG_ERROR(You need getopt_long or libpopt.)]
  )
]
)

AC_DEFUN(
MY_HEADER_POPT,
[
  AC_CHECK_HEADERS(
      popt.h,
      [MY_LIB_POPT],
      [AC_MSG_ERROR(You need getopt_long or libpopt.)]
  )
]
)

AC_DEFUN(
MY_LIB_GETOPT,
[
  AC_SEARCH_LIBS(
      getopt_long,
      getopt,
      [AC_DEFINE_UNQUOTED(PARSELIB,1)],
      [MY_HEADER_POPT]
  )
]
)

AC_DEFUN(
MY_HEADER_GNUGETOPT_GETOPT,
[
  AC_CHECK_HEADERS(
      [gnugetopt/getopt.h],
      [MY_LIB_GETOPT],
      [MY_HEADER_POPT]
  )
]
)

AC_DEFUN(
MY_HEADER_GETOPT,
[
  AC_CHECK_HEADERS(
      getopt.h,
      [MY_LIB_GETOPT],
      [MY_HEADER_GNUGETOPT_GETOPT]
  )
]
)

AC_DEFUN(
MY_SEARCH_PARSELIB,
[
  AH_TEMPLATE(
      [PARSELIB],
      [Define as 1 to use getopt or as 2 to use libpopt]
  )
  MY_HEADER_GETOPT
]
)

