% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serializers-json.R
\name{JSON}
\alias{JSON}
\title{The JSON serializer}
\description{
class with methods for serializing via \pkg{jsonlite}
}
\keyword{internal}
\section{Super class}{
\code{\link[vcr:Serializer]{vcr::Serializer}} -> \code{JSON}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-JSON-new}{\code{JSON$new()}}
\item \href{#method-JSON-serialize}{\code{JSON$serialize()}}
\item \href{#method-JSON-deserialize}{\code{JSON$deserialize()}}
\item \href{#method-JSON-clone}{\code{JSON$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSON-new"></a>}}
\if{latex}{\out{\hypertarget{method-JSON-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{JSON} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSON$new(path = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(character) full path to the yaml file}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{JSON} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSON-serialize"></a>}}
\if{latex}{\out{\hypertarget{method-JSON-serialize}{}}}
\subsection{Method \code{serialize()}}{
Serializes the given hash using internal fxn write_json
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSON$serialize(x, path, bytes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(list) the object to serialize}

\item{\code{path}}{(character) the file path}

\item{\code{bytes}}{(logical) whether to preserve exact body bytes or not}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(character) the json string to write to disk
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSON-deserialize"></a>}}
\if{latex}{\out{\hypertarget{method-JSON-deserialize}{}}}
\subsection{Method \code{deserialize()}}{
Deserializes the content at the file path using
jsonlite::fromJSON
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSON$deserialize(cassette)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cassette}}{the current cassette object so it's properties can
be retrieved}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(list) the deserialized object, an R list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-JSON-clone"></a>}}
\if{latex}{\out{\hypertarget{method-JSON-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JSON$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
