% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_text.R
\name{parse_text}
\alias{parse_text}
\alias{parseText}
\title{Parse a character string as if it was a command entered at the command line}
\usage{
parse_text(text, firstline = 1, srcfilename = NULL, encoding = "unknown")

parseText(text, firstline = 1, srcfilename = NULL, encoding = "unknown")
}
\arguments{
\item{text}{The character string vector to parse into an R expression.}

\item{firstline}{The index of first line being parsed in the file. If this is
larger than \code{1}, empty lines are added in front of \code{text} in order to match
the correct position in the file.}

\item{srcfilename}{A character string with the name of the source file.}

\item{encoding}{Encoding of `text``, as in \code{\link[=parse]{parse()}}.}
}
\value{
Returns an expression with the parsed code or \code{NA} if the last
instruction is correct but incomplete, or an object of class 'try-error' with
the error message if the code is incorrect.
}
\description{
Parse R instructions provided as a string and return the
expression if it is correct, or an object of class 'try-error' if it is an
incorrect code, or \code{NA} if the (last) instruction is incomplete.
}
\note{
On the contrary to \code{parse()}, \code{parse_text()} recovers from incorrect
code and also detects incomplete code. It is also easier to use in case you
pass a character string to it, because you don't have to name the argument
explicitly (\code{text = ...}).
}
\examples{
parse_text("1 + 1")
parse_text("1 + 1; log(10)")
parse_text(c("1 + 1", "log(10)"))

# Incomplete instruction
parse_text("log(")

# Incomplete strings
parse_text("text <- \"some string")
parse_text("text <- 'some string")

# Incomplete names (don't write backtick quoted names on several lines!)
# ...but just in case
parse_text("`myvar")

# Incorrect expression
parse_text("log)")
}
\seealso{
\code{\link[=parse]{parse()}}, \code{\link[=capture_all]{capture_all()}}
}
\keyword{IO}
