% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbern.R
\name{dbern}
\alias{dbern}
\alias{qbern}
\alias{pbern}
\alias{rbern}
\title{The Bernoulli distribution}
\usage{
dbern(x, prob, log = FALSE)

qbern(p, prob, lower.tail = TRUE, log.p = FALSE)

pbern(q, prob, lower.tail = TRUE, log.p = FALSE)

rbern(n, prob)
}
\arguments{
\item{x}{numeric. Vector of quantiles.}

\item{prob}{Probability of success on each trial.}

\item{log}{logical. If \code{TRUE}, probabilities \code{p} are given as \code{log(p)}.}

\item{p}{numeric in \code{[0, 1]}. Vector of probabilities.}

\item{lower.tail}{logical. If \code{TRUE} (default), 
probabilities are \code{P[X <= x]}, otherwise, \code{P[X > x]}.}

\item{log.p}{logical. If \code{TRUE}, probabilities \code{p} are given as \code{log(p)}.}

\item{q}{numeric. Vector of quantiles.}

\item{n}{number of observations. 
If \code{length(n) > 1}, the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and 
random generation for the Bernoulli distribution.
}
\seealso{
See the help page of the \code{\link{Binomial}} distribution.
}
