% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R, R/convenience.R
\name{ReadAkoya}
\alias{ReadAkoya}
\alias{LoadAkoya}
\title{Read and Load Akoya CODEX data}
\usage{
ReadAkoya(
  filename,
  type = c("inform", "processor", "qupath"),
  filter = "DAPI|Blank|Empty",
  inform.quant = c("mean", "total", "min", "max", "std")
)

LoadAkoya(
  filename,
  type = c("inform", "processor", "qupath"),
  fov,
  assay = "Akoya",
  ...
)
}
\arguments{
\item{filename}{Path to matrix generated by upstream processing.}

\item{type}{Specify which type matrix is being provided.
\itemize{
 \item \dQuote{\code{processor}}: matrix generated by CODEX Processor
 \item \dQuote{\code{inform}}: matrix generated by inForm
 \item \dQuote{\code{qupath}}: matrix generated by QuPath
}}

\item{filter}{A pattern to filter features by; pass \code{NA} to
skip feature filtering}

\item{inform.quant}{When \code{type} is \dQuote{\code{inform}}, the
quantification level to read in}

\item{fov}{Name to store FOV as}

\item{assay}{Name to store expression matrix as}

\item{...}{
  Arguments passed on to \code{\link[=ReadAkoya]{ReadAkoya}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
\code{ReadAkoya}: A list with some combination of the following values
\itemize{
 \item \dQuote{\code{matrix}}: a
 \link[Matrix:dgCMatrix-class]{sparse matrix} with expression data; cells
  are columns and features are rows
 \item \dQuote{\code{centroids}}: a data frame with cell centroid
  coordinates in three columns: \dQuote{x}, \dQuote{y}, and \dQuote{cell}
 \item \dQuote{\code{metadata}}: a data frame with cell-level meta data;
  includes all columns in \code{filename} that aren't in
  \dQuote{\code{matrix}} or \dQuote{\code{centroids}}
}
When \code{type} is \dQuote{\code{inform}}, additional expression matrices
are returned and named using their segmentation type (eg.
\dQuote{nucleus}, \dQuote{membrane}). The \dQuote{Entire Cell} segmentation
type is returned in the \dQuote{\code{matrix}} entry of the list

\code{LoadAkoya}: A \code{\link[SeuratObject]{Seurat}} object
}
\description{
Read and Load Akoya CODEX data
}
\note{
This function requires the
\href{https://cran.r-project.org/package=data.table}{\pkg{data.table}} package
to be installed
}
\section{Progress Updates with \pkg{progressr}}{

This function uses
\href{https://cran.r-project.org/package=progressr}{\pkg{progressr}} to
render status updates and progress bars. To enable progress updates, wrap
the function call in \code{\link[progressr]{with_progress}} or run
\code{\link[progressr:handlers]{handlers(global = TRUE)}} before running
this function. For more details about \pkg{progressr}, please read
\href{https://progressr.futureverse.org/articles/progressr-intro.html}{\code{vignette("progressr-intro")}}
}

\concept{preprocessing}
