% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev-example.R
\name{dev_example}
\alias{dev_example}
\alias{run_example}
\title{Run a examples for an in-development function.}
\usage{
dev_example(topic, quiet = FALSE)

run_example(
  path,
  run_donttest = FALSE,
  run_dontrun = FALSE,
  env = new.env(parent = globalenv()),
  quiet = FALSE,
  macros = NULL,
  run,
  test
)
}
\arguments{
\item{topic}{Name or topic (or name of Rd) file to run examples for}

\item{quiet}{If \code{TRUE}, does not echo code to console.}

\item{path}{Path to \code{.Rd} file}

\item{run_donttest}{if \code{TRUE}, do run \verb{\donttest} sections in the Rd files.}

\item{run_dontrun}{if \code{TRUE}, do run \verb{\dontrun} sections in the Rd files.}

\item{env}{Environment in which code will be run.}

\item{macros}{Custom macros to use to parse the \code{.Rd} file. See the
\code{macros} argument of \code{\link[tools:parse_Rd]{tools::parse_Rd()}}. If \code{NULL}, then the
\code{\link[tools:Rd2HTML]{tools::Rd2ex()}} (and \code{\link[tools:parse_Rd]{tools::parse_Rd()}}) default is used.}

\item{run, test}{Deprecated, see \code{run_dontrun} and \code{run_donttest} above.}
}
\description{
\code{dev_example} is a replacement for \code{example}. \code{run_example}
is a low-level function that takes a path to an Rd file.
}
\examples{
\dontrun{
# Runs installed example:
library("ggplot2")
example("ggplot")

# Runs develoment example:
dev_example("ggplot")
}
}
\concept{example functions}
