% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_model.R
\name{bootstrap_model}
\alias{bootstrap_model}
\title{Model bootstrapping}
\usage{
bootstrap_model(model, iterations = 1000, verbose = FALSE, ...)
}
\arguments{
\item{model}{Statistical model.}

\item{iterations}{The number of draws to simulate/bootstrap.}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame.
}
\description{
Bootstrap a statistical model n times to return a data frame of estimates.
}
\examples{
\donttest{
if (require("boot")) {
  model <- lm(mpg ~ wt + cyl, data = mtcars)
  head(bootstrap_model(model))
}
}
}
\seealso{
\code{\link{bootstrap_parameters}}, \code{\link{simulate_model}}, \code{\link{simulate_parameters}}
}
