% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posixt.R
\name{date_time_info}
\alias{date_time_info}
\title{Info: date-time}
\usage{
date_time_info(x)
}
\arguments{
\item{x}{\verb{[POSIXct / POSIXlt]}

A date-time.}
}
\value{
A data frame of low level information.
}
\description{
\code{date_time_info()} retrieves a set of low-level information generally not
required for most date-time manipulations. It returns a data frame with the
same columns as \code{\link[=sys_time_info]{sys_time_info()}}, but the \code{begin} and \code{end} columns are
date-times with the same time zone as \code{x}, and the \code{offset} column is an
integer rather than a second based \link[=duration_seconds]{duration} column
since this is part of the high-level API.
}
\examples{
x <- date_time_build(
  2021, 03, 14, c(01, 03), c(59, 00), c(59, 00),
  zone = "America/New_York"
)

# x[1] is in EST, x[2] is in EDT
x

info <- date_time_info(x)
info

# `end` can be used to iterate through daylight saving time transitions
date_time_info(info$end)
}
