% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/averageParallelStats.R
\name{averageParallelStats}
\alias{averageParallelStats}
\title{Average parallel statistics}
\usage{
averageParallelStats(values, weights = NULL)
}
\arguments{
\item{values}{A list of numeric vectors of the same length, containing statistics from parallel tests.}

\item{weights}{A numeric vector of positive weights, with one value per vector in \code{...}.
Each weight is applied to all entries of itscorresponding vector, i.e., all p-values in that vector receive the same weight.

Alternatively, a list of numeric vectors of weights with the same structure as \code{p.values}.
Each p-value is then assigned the weight in the corresponding entry of \code{weights}.

Alternatively \code{NULL}, in which case all p-values are assigned equal weight.}
}
\value{
A numeric vector of (weighted) averages, of length equal to the lengths of the vectors in \code{values}.
}
\description{
Average parallel statistics with consideration of weights and protection from missing values.
}
\details{
If \code{weights} is supplied, a weighted average is computed for each parallel set of tests.
If \code{values} contains missing values, they are ignored and will not contribute to the average.
}
\examples{
averageParallelStats(list(1:10, 2:11))
averageParallelStats(list(1:10, 2:11), weights=c(2:1))
averageParallelStats(list(1:10, rep(NA, 10)))

}
\seealso{
\code{\link{averageParallelStats}}, for the parallel counterpart.
}
\author{
Aaron Lun
}
