/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var isAnagram = require( './../lib' );

var bool = isAnagram( 'I am a weakish speller', 'William Shakespeare' );
console.log( bool );
// => true

bool = isAnagram( 'bat', 'tab' );
console.log( bool );
// => true

bool = isAnagram( 'bat', 'TAB' );
console.log( bool );
// => true

bool = isAnagram( 'bat', 't a b' );
console.log( bool );
// => true

bool = isAnagram( 'bat 321', 'tab 123' );
console.log( bool );
// => true

bool = isAnagram( 'bat', 'tabba' );
console.log( bool );
// => false

bool = isAnagram( 'bat', 5 );
console.log( bool );
// => false

bool = isAnagram( '123', 321 );
console.log( bool );
// => false
