/* $Id: Blast_def_line.hpp 610969 2020-06-26 12:56:10Z grichenk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast_def_line.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'blastdb.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Blast_def_line_.hpp


#ifndef OBJECTS_BLASTDB_BLAST_DEF_LINE_HPP
#define OBJECTS_BLASTDB_BLAST_DEF_LINE_HPP


// generated includes
#include <objects/blastdb/Blast_def_line_.hpp>
#include <set>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTDB_EXPORT CBlast_def_line : public CBlast_def_line_Base
{
    typedef CBlast_def_line_Base Tparent;
public:
    // constructor
    CBlast_def_line(void);
    // destructor
    ~CBlast_def_line(void);

    /// Set of leaf-node taxonomy IDs associated with this entry in the
    // BLAST database
    typedef set<TTaxId> TTaxIds;
    TTaxIds GetTaxIds() const;          // DEPRECATED, use GetLeafTaxIds
    void SetTaxIds(const TTaxIds& t);   // DEPRECATED, use SetLeafTaxIds
    TTaxIds GetLeafTaxIds() const;
    void SetLeafTaxIds(const TTaxIds& t);

private:
    // Prohibit copy constructor and assignment operator
    CBlast_def_line(const CBlast_def_line& value);
    CBlast_def_line& operator=(const CBlast_def_line& value);

};

/////////////////// CBlast_def_line inline methods

// constructor
inline
CBlast_def_line::CBlast_def_line(void)
{
}


/////////////////// end of CBlast_def_line inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTDB_BLAST_DEF_LINE_HPP
/* Original file checksum: lines: 86, chars: 2511, CRC32: a649bca9 */
