.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetICValues __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetICValues, XGetICValues \- set and obtain XIC values
.SH SYNTAX
.HP
char * XSetICValues\^(\^XIC \fIic\fP, ...\^);
.HP
char * XGetICValues\^(\^XIC \fIic\fP, ...\^);
.SH ARGUMENTS
.IP \fIic\fP 1i
Specifies the input context.
.IP ... 1i
Specifies the variable length argument list to set or get XIC values.
.SH DESCRIPTION
The
.B XSetICValues
function returns NULL if no error occurred;
otherwise,
it returns the name of the first argument that could not be set.
An argument might not be set for any of the following reasons:
.IP \(bu 5
The argument is read-only (for example,
.BR XNFilterEvents ).
.IP \(bu 5
The argument name is not recognized.
.IP \(bu 5
An implementation-dependent error occurs.
.LP
Each value to be set must be an appropriate datum,
matching the data type imposed by the semantics of the argument.
.LP
The
.B XSetICValues
can generate
.BR BadAtom ,
.BR BadColor ,
.BR BadCursor ,
.BR BadPixmap ,
and
.B BadWindow
errors.
.LP
The
.B XGetICValues
function returns NULL if no error occurred; otherwise,
it returns the name of the first argument that could not be obtained.
An argument could not be obtained for any of the following reasons:
.IP \(bu 5
The argument name is not recognized.
.IP \(bu 5
The input method encountered an implementation-dependent error.
.LP
Each IC attribute value argument (following a name) must point to
a location where the IC value is to be stored.
That is, if the IC value is of type T,
the argument must be of type T*.
If T itself is a pointer type,
then
.B XGetICValues
allocates memory to store the actual data,
and the client is responsible for freeing this data by calling
.B XFree
with the returned pointer.
The exception to this rule is for an IC value of type
.B XNVaNestedList
(for preedit and status attributes).
In this case,  the argument must also be of type
.BR XVaNestedList .
Then, the rule of changing type T to T* and freeing the allocated data
applies to each element of the nested list.
.SH DIAGNOSTICS
.TP 1i
.B BadAtom
A value for an Atom argument does not name a defined Atom.
.TP 1i
.B BadColor
A value for a Colormap argument does not name a defined Colormap.
.TP 1i
.B BadCursor
A value for a Cursor argument does not name a defined Cursor.
.TP 1i
.B BadPixmap
A value for a Pixmap argument does not name a defined Pixmap.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XCreateIC(__libmansuffix__),
XOpenIM(__libmansuffix__),
XSetICFocus(__libmansuffix__),
XmbResetIC(__libmansuffix__)
.br
\fI\*(xL\fP
