# This file contains lists of files and defines used in the legacy G3 build, that is, the G3 build
# that is not derived from our Bazel rules.

SKIA_PUBLIC_HDRS = [
    "include/android/SkAndroidFrameworkUtils.h",
    "include/android/SkAnimatedImage.h",
    "include/codec/SkAndroidCodec.h",
    "include/codec/SkAvifDecoder.h",
    "include/codec/SkBmpDecoder.h",
    "include/codec/SkCodecAnimation.h",
    "include/codec/SkCodec.h",
    "include/codec/SkEncodedImageFormat.h",
    "include/codec/SkEncodedOrigin.h",
    "include/codec/SkGifDecoder.h",
    "include/codec/SkIcoDecoder.h",
    "include/codec/SkJpegDecoder.h",
    "include/codec/SkJpegxlDecoder.h",
    "include/codec/SkPixmapUtils.h",
    "include/codec/SkPngChunkReader.h",
    "include/codec/SkPngDecoder.h",
    "include/codec/SkRawDecoder.h",
    "include/codec/SkWbmpDecoder.h",
    "include/codec/SkWebpDecoder.h",
    "include/config/SkUserConfig.h",
    "include/core/SkAlphaType.h",
    "include/core/SkAnnotation.h",
    "include/core/SkBBHFactory.h",
    "include/core/SkBitmap.h",
    "include/core/SkBlendMode.h",
    "include/core/SkBlender.h",
    "include/core/SkBlurTypes.h",
    "include/core/SkCanvas.h",
    "include/core/SkCanvasVirtualEnforcer.h",
    "include/core/SkCapabilities.h",
    "include/core/SkClipOp.h",
    "include/core/SkColor.h",
    "include/core/SkColorFilter.h",
    "include/core/SkColorPriv.h",
    "include/core/SkColorSpace.h",
    "include/core/SkColorTable.h",
    "include/core/SkColorType.h",
    "include/core/SkContourMeasure.h",
    "include/core/SkCoverageMode.h",
    "include/core/SkCubicMap.h",
    "include/core/SkData.h",
    "include/core/SkDataTable.h",
    "include/core/SkDocument.h",
    "include/core/SkDrawLooper.h",
    "include/core/SkDrawable.h",
    "include/core/SkEncodedImageFormat.h",  # TODO(kjlubick) remove this shim
    "include/core/SkExecutor.h",
    "include/core/SkFlattenable.h",
    "include/core/SkFont.h",
    "include/core/SkFontArguments.h",
    "include/core/SkFontMetrics.h",
    "include/core/SkFontMgr.h",
    "include/core/SkFontParameters.h",
    "include/core/SkFontStyle.h",
    "include/core/SkFontTypes.h",
    "include/core/SkGraphics.h",
    "include/core/SkImage.h",
    "include/core/SkImageFilter.h",
    "include/core/SkImageGenerator.h",
    "include/core/SkImageInfo.h",
    "include/core/SkM44.h",
    "include/core/SkMallocPixelRef.h",
    "include/core/SkMaskFilter.h",
    "include/core/SkMatrix.h",
    "include/core/SkMesh.h",
    "include/core/SkMilestone.h",
    "include/core/SkOverdrawCanvas.h",
    "include/core/SkPaint.h",
    "include/core/SkPath.h",
    "include/core/SkPathBuilder.h",
    "include/core/SkPathEffect.h",
    "include/core/SkPathMeasure.h",
    "include/core/SkPathTypes.h",
    "include/core/SkPathUtils.h",
    "include/core/SkPicture.h",
    "include/core/SkPictureRecorder.h",
    "include/core/SkPixelRef.h",
    "include/core/SkPixmap.h",
    "include/core/SkPoint.h",
    "include/core/SkPoint3.h",
    "include/core/SkPromiseImageTexture.h",  # TODO(kjlubick) remove this shim
    "include/core/SkRRect.h",
    "include/core/SkRSXform.h",
    "include/core/SkRasterHandleAllocator.h",
    "include/core/SkRect.h",
    "include/core/SkRefCnt.h",
    "include/core/SkRegion.h",
    "include/core/SkSamplingOptions.h",
    "include/core/SkScalar.h",
    "include/core/SkSerialProcs.h",
    "include/core/SkShader.h",
    "include/core/SkSize.h",
    "include/core/SkSpan.h",
    "include/core/SkStream.h",
    "include/core/SkString.h",
    "include/core/SkStrokeRec.h",
    "include/core/SkSurface.h",
    "include/core/SkSurfaceProps.h",
    "include/core/SkSwizzle.h",
    "include/core/SkTextBlob.h",
    "include/core/SkTextureCompressionType.h",
    "include/core/SkTiledImageUtils.h",
    "include/core/SkTileMode.h",
    "include/core/SkTime.h",
    "include/core/SkTraceMemoryDump.h",
    "include/core/SkTypeface.h",
    "include/core/SkTypes.h",
    "include/core/SkUnPreMultiply.h",
    "include/core/SkVertices.h",
    "include/core/SkYUVAInfo.h",
    "include/core/SkYUVAPixmaps.h",
    "include/docs/SkPDFDocument.h",
    "include/docs/SkXPSDocument.h",
    "include/effects/Sk1DPathEffect.h",
    "include/effects/Sk2DPathEffect.h",
    "include/effects/SkBlenders.h",
    "include/effects/SkBlurDrawLooper.h",
    "include/effects/SkBlurMaskFilter.h",
    "include/effects/SkColorMatrixFilter.h",
    "include/effects/SkColorMatrix.h",
    "include/effects/SkCornerPathEffect.h",
    "include/effects/SkDashPathEffect.h",
    "include/effects/SkDiscretePathEffect.h",
    "include/effects/SkGradientShader.h",
    "include/effects/SkHighContrastFilter.h",
    "include/effects/SkImageFilters.h",
    "include/effects/SkLayerDrawLooper.h",
    "include/effects/SkLumaColorFilter.h",
    "include/effects/SkOpPathEffect.h",
    "include/effects/SkOverdrawColorFilter.h",
    "include/effects/SkPerlinNoiseShader.h",
    "include/effects/SkRuntimeEffect.h",
    "include/effects/SkShaderMaskFilter.h",
    "include/effects/SkStrokeAndFillPathEffect.h",
    "include/effects/SkTableMaskFilter.h",
    "include/effects/SkTrimPathEffect.h",
    "include/encode/SkEncoder.h",
    "include/encode/SkICC.h",
    "include/encode/SkJpegEncoder.h",
    "include/encode/SkPngEncoder.h",
    "include/encode/SkWebpEncoder.h",
    "include/gpu/d3d/GrD3DBackendContext.h",
    "include/gpu/d3d/GrD3DTypes.h",
    "include/gpu/dawn/GrDawnTypes.h",
    "include/gpu/ganesh/GrExternalTextureGenerator.h",
    "include/gpu/ganesh/SkImageGanesh.h",
    "include/gpu/ganesh/SkSurfaceGanesh.h",
    "include/gpu/ganesh/mtl/SkSurfaceMetal.h",
    "include/gpu/gl/egl/GrGLMakeEGLInterface.h",
    "include/gpu/gl/glx/GrGLMakeGLXInterface.h",
    "include/gpu/gl/GrGLAssembleHelpers.h",
    "include/gpu/gl/GrGLAssembleInterface.h",
    "include/gpu/gl/GrGLConfig.h",
    "include/gpu/gl/GrGLConfig_chrome.h",
    "include/gpu/GpuTypes.h",
    "include/gpu/GrBackendDrawableInfo.h",
    "include/gpu/GrBackendSemaphore.h",
    "include/gpu/GrBackendSurface.h",
    "include/gpu/GrBackendSurfaceMutableState.h",
    "include/gpu/GrContextOptions.h",
    "include/gpu/GrContextThreadSafeProxy.h",
    "include/gpu/GrDirectContext.h",
    "include/gpu/GrDriverBugWorkarounds.h",
    "include/gpu/GrDriverBugWorkaroundsAutogen.h",
    "include/gpu/GrRecordingContext.h",
    "include/gpu/GrSurfaceInfo.h",
    "include/gpu/GrTypes.h",
    "include/gpu/GrYUVABackendTextures.h",
    "include/gpu/MutableTextureState.h",
    "include/gpu/ShaderErrorHandler.h",
    "include/gpu/gl/GrGLExtensions.h",
    "include/gpu/gl/GrGLFunctions.h",
    "include/gpu/gl/GrGLInterface.h",
    "include/gpu/gl/GrGLTypes.h",
    "include/gpu/mock/GrMockTypes.h",
    "include/gpu/mtl/GrMtlBackendContext.h",
    "include/gpu/mtl/GrMtlTypes.h",
    "include/gpu/mtl/MtlMemoryAllocator.h",
    "include/gpu/vk/GrVkBackendContext.h",
    "include/gpu/vk/GrVkExtensions.h",
    "include/gpu/vk/GrVkMemoryAllocator.h",
    "include/gpu/vk/GrVkTypes.h",
    "include/gpu/vk/VulkanExtensions.h",
    "include/gpu/vk/VulkanMemoryAllocator.h",
    "include/gpu/vk/VulkanTypes.h",
    "include/pathops/SkPathOps.h",
    "include/ports/SkCFObject.h",
    "include/ports/SkFontMgr_android.h",
    "include/ports/SkFontMgr_data.h",
    "include/ports/SkFontMgr_directory.h",
    "include/ports/SkFontMgr_empty.h",
    "include/ports/SkFontMgr_fontconfig.h",
    "include/ports/SkFontMgr_fuchsia.h",
    "include/ports/SkFontMgr_indirect.h",
    "include/ports/SkFontMgr_mac_ct.h",
    "include/ports/SkImageGeneratorCG.h",
    "include/ports/SkImageGeneratorNDK.h",
    "include/ports/SkImageGeneratorWIC.h",
    "include/ports/SkRemotableFontMgr.h",
    "include/ports/SkTypeface_mac.h",
    "include/ports/SkTypeface_win.h",
    # We do not want clients to directly include our private headers, so we exclude include/private
    "include/sksl/SkSLDebugTrace.h",
    "include/sksl/SkSLVersion.h",
    "include/utils/SkAnimCodecPlayer.h",
    "include/utils/SkBase64.h",
    "include/utils/SkCanvasStateUtils.h",
    "include/utils/SkCustomTypeface.h",
    "include/utils/SkEventTracer.h",
    "include/utils/SkNoDrawCanvas.h",
    "include/utils/SkNullCanvas.h",
    "include/utils/SkNWayCanvas.h",
    "include/utils/SkOrderedFontMgr.h",
    "include/utils/SkPaintFilterCanvas.h",
    "include/utils/SkParse.h",
    "include/utils/SkParsePath.h",
    "include/utils/SkShadowUtils.h",
    "include/utils/SkTextUtils.h",
    "include/utils/SkTraceEventPhase.h",
    "include/utils/mac/SkCGUtils.h",
]

################################################################################
## BASE_SRCS
################################################################################

# All platform-independent sources and private headers.
BASE_SRCS_ALL = [
    "include/android/SkImageAndroid.h",
    "include/android/SkCanvasAndroid.h",
    "include/core/SkOpenTypeSVGDecoder.h",
    "include/private/SkBitmaskEnum.h",
    "include/private/SkColorData.h",
    "include/private/SkEncodedInfo.h",
    "include/private/SkGainmapInfo.h",
    "include/private/SkGainmapShader.h",
    "include/private/SkIDChangeListener.h",
    "include/private/SkJpegMetadataDecoder.h",
    "include/private/SkPathRef.h",
    "include/private/SkSLDefines.h",
    "include/private/SkSLSampleUsage.h",
    "include/private/SkShadowFlags.h",
    "include/private/SkWeakRefCnt.h",
    "include/private/SkXmp.h",
    "include/private/base/SingleOwner.h",
    "include/private/base/SkAPI.h",
    "include/private/base/SkAlign.h",
    "include/private/base/SkAlignedStorage.h",
    "include/private/base/SkAssert.h",
    "include/private/base/SkAttributes.h",
    "include/private/base/SkCPUTypes.h",
    "include/private/base/SkContainers.h",
    "include/private/base/SkDebug.h",
    "include/private/base/SkDeque.h",
    "include/private/base/SkFeatures.h",
    "include/private/base/SkFixed.h",
    "include/private/base/SkFloatBits.h",
    "include/private/base/SkFloatingPoint.h",
    "include/private/base/SkLoadUserConfig.h",
    "include/private/base/SkMacros.h",
    "include/private/base/SkMalloc.h",
    "include/private/base/SkMath.h",
    "include/private/base/SkMutex.h",
    "include/private/base/SkNoncopyable.h",
    "include/private/base/SkOnce.h",
    "include/private/base/SkPathEnums.h",
    "include/private/base/SkPoint_impl.h",
    "include/private/base/SkSafe32.h",
    "include/private/base/SkSemaphore.h",
    "include/private/base/SkSpan_impl.h",
    "include/private/base/SkTArray.h",
    "include/private/base/SkTDArray.h",
    "include/private/base/SkTFitsIn.h",
    "include/private/base/SkTLogic.h",
    "include/private/base/SkTPin.h",
    "include/private/base/SkTemplates.h",
    "include/private/base/SkThreadAnnotations.h",
    "include/private/base/SkThreadID.h",
    "include/private/base/SkTo.h",
    "include/private/base/SkTypeTraits.h",
    "include/private/chromium/GrDeferredDisplayList.h",
    "include/private/chromium/GrDeferredDisplayListRecorder.h",
    "include/private/chromium/GrPromiseImageTexture.h",
    "include/private/chromium/GrSurfaceCharacterization.h",
    "include/private/chromium/SkChromeRemoteGlyphCache.h",
    "include/private/chromium/SkDiscardableMemory.h",
    "include/private/chromium/SkImageChromium.h",
    "include/private/chromium/Slug.h",
    "include/private/gpu/ganesh/GrContext_Base.h",
    "include/private/gpu/ganesh/GrGLTypesPriv.h",
    "include/private/gpu/ganesh/GrImageContext.h",
    "include/private/gpu/ganesh/GrMockTypesPriv.h",
    "include/private/gpu/ganesh/GrMtlTypesPriv.h",
    "include/private/gpu/ganesh/GrTextureGenerator.h",
    "include/private/gpu/ganesh/GrTypesPriv.h",
    "include/private/gpu/vk/VulkanTypesPriv.h",
    "src/android/SkAndroidFrameworkUtils.cpp",
    "src/android/SkAnimatedImage.cpp",
    "src/base/SkASAN.h",
    "src/base/SkArenaAlloc.cpp",
    "src/base/SkArenaAlloc.h",
    "src/base/SkArenaAllocList.h",
    "src/base/SkAutoMalloc.h",
    "src/base/SkBezierCurves.cpp",
    "src/base/SkBezierCurves.h",
    "src/base/SkBlockAllocator.cpp",
    "src/base/SkBlockAllocator.h",
    "src/base/SkBuffer.cpp",
    "src/base/SkBuffer.h",
    "src/base/SkContainers.cpp",
    "src/base/SkCubics.cpp",
    "src/base/SkCubics.h",
    "src/base/SkDeque.cpp",
    "src/base/SkEndian.h",
    "src/base/SkFloatingPoint.cpp",
    "src/base/SkHalf.cpp",
    "src/base/SkHalf.h",
    "src/base/SkLeanWindows.h",
    "src/base/SkMSAN.h",
    "src/base/SkMalloc.cpp",
    "src/base/SkMathPriv.cpp",
    "src/base/SkMathPriv.h",
    "src/base/SkNoDestructor.h",
    "src/base/SkQuads.cpp",
    "src/base/SkQuads.h",
    "src/base/SkRandom.h",
    "src/base/SkRectMemcpy.h",
    "src/base/SkSafeMath.cpp",
    "src/base/SkSafeMath.h",
    "src/base/SkScopeExit.h",
    "src/base/SkSemaphore.cpp",
    "src/base/SkSharedMutex.cpp",
    "src/base/SkSharedMutex.h",
    "src/base/SkSpinlock.cpp",
    "src/base/SkSpinlock.h",
    "src/base/SkStringView.h",
    "src/base/SkTBlockList.h",
    "src/base/SkTDArray.cpp",
    "src/base/SkTDPQueue.h",
    "src/base/SkTInternalLList.h",
    "src/base/SkTLazy.h",
    "src/base/SkTSearch.cpp",
    "src/base/SkTSearch.h",
    "src/base/SkTSort.h",
    "src/base/SkThreadID.cpp",
    "src/base/SkUTF.cpp",
    "src/base/SkUTF.h",
    "src/base/SkUtils.cpp",
    "src/base/SkUtils.h",
    "src/base/SkVx.h",
    "src/base/SkZip.h",
    "src/codec/SkJpegConstants.h",
    "src/codec/SkPixmapUtils.cpp",
    "src/codec/SkPixmapUtilsPriv.h",  # TODO(kjlubick) delete
    "src/codec/SkStubHeifDecoderAPI.h",  # TODO(kjlubick) delete
    "src/core/Sk4px.h",
    "src/core/SkAAClip.cpp",
    "src/core/SkAAClip.h",
    "src/core/SkATrace.cpp",
    "src/core/SkATrace.h",
    "src/core/SkAdvancedTypefaceMetrics.h",
    "src/core/SkAlphaRuns.cpp",
    "src/core/SkAlphaRuns.h",
    "src/core/SkAnalyticEdge.cpp",
    "src/core/SkAnalyticEdge.h",
    "src/core/SkAnnotation.cpp",
    "src/core/SkAnnotationKeys.h",
    "src/core/SkAutoBlitterChoose.h",
    "src/core/SkAutoPixmapStorage.cpp",
    "src/core/SkAutoPixmapStorage.h",
    "src/core/SkBBHFactory.cpp",
    "src/core/SkBigPicture.cpp",
    "src/core/SkBigPicture.h",
    "src/core/SkBitmap.cpp",
    "src/core/SkBitmapCache.cpp",
    "src/core/SkBitmapCache.h",
    "src/core/SkBitmapDevice.cpp",
    "src/core/SkBitmapDevice.h",
    "src/core/SkBitmapProcState.h",  # needed for src/opts/SkBitmapProcState_opts.h
    "src/core/SkBlendMode.cpp",
    "src/core/SkBlendModeBlender.cpp",
    "src/core/SkBlendModeBlender.h",
    "src/core/SkBlendModePriv.h",
    "src/core/SkBlenderBase.h",
    "src/core/SkBlitBWMaskTemplate.h",
    "src/core/SkBlitRow.h",
    "src/core/SkBlitRow_D32.cpp",
    "src/core/SkBlitter.cpp",
    "src/core/SkBlitter.h",
    "src/core/SkBlitter_A8.cpp",
    "src/core/SkBlitter_A8.h",
    "src/core/SkBlitter_ARGB32.cpp",
    "src/core/SkBlitter_Sprite.cpp",
    "src/core/SkBlurMask.cpp",
    "src/core/SkBlurMask.h",
    "src/core/SkBlurMaskFilterImpl.cpp",
    "src/core/SkBlurMaskFilterImpl.h",
    "src/core/SkCachedData.cpp",
    "src/core/SkCachedData.h",
    "src/core/SkCanvas.cpp",
    "src/core/SkCanvasPriv.cpp",
    "src/core/SkCanvasPriv.h",
    "src/core/SkCanvas_Raster.cpp",
    "src/core/SkCapabilities.cpp",
    "src/core/SkChecksum.cpp",
    "src/core/SkChecksum.h",
    "src/core/SkChromeRemoteGlyphCache.cpp",
    "src/core/SkClipStack.cpp",
    "src/core/SkClipStack.h",
    "src/core/SkClipStackDevice.cpp",
    "src/core/SkClipStackDevice.h",
    "src/core/SkColor.cpp",
    "src/core/SkColorFilter.cpp",
    "src/core/SkColorFilterPriv.h",
    "src/core/SkColorSpace.cpp",
    "src/core/SkColorSpacePriv.h",
    "src/core/SkColorSpaceXformSteps.cpp",
    "src/core/SkColorSpaceXformSteps.h",
    "src/core/SkColorTable.cpp",
    "src/core/SkCompressedDataUtils.cpp",
    "src/core/SkCompressedDataUtils.h",
    "src/core/SkContourMeasure.cpp",
    "src/core/SkConvertPixels.cpp",
    "src/core/SkConvertPixels.h",
    "src/core/SkCoreBlitters.h",
    "src/core/SkCpu.cpp",
    "src/core/SkCpu.h",
    "src/core/SkCubicClipper.cpp",
    "src/core/SkCubicClipper.h",
    "src/core/SkCubicMap.cpp",
    "src/core/SkData.cpp",
    "src/core/SkDataTable.cpp",
    "src/core/SkDebug.cpp",
    "src/core/SkDebugUtils.h",
    "src/core/SkDescriptor.cpp",
    "src/core/SkDescriptor.h",
    "src/core/SkDevice.cpp",
    "src/core/SkDevice.h",
    "src/core/SkDistanceFieldGen.cpp",
    "src/core/SkDistanceFieldGen.h",
    "src/core/SkDocument.cpp",
    "src/core/SkDraw.cpp",
    "src/core/SkDraw.h",
    "src/core/SkDrawBase.cpp",
    "src/core/SkDrawBase.h",
    "src/core/SkDrawLooper.cpp",
    "src/core/SkDrawProcs.h",
    "src/core/SkDrawShadowInfo.cpp",
    "src/core/SkDrawShadowInfo.h",
    "src/core/SkDraw_atlas.cpp",
    "src/core/SkDraw_text.cpp",
    "src/core/SkDraw_vertices.cpp",
    "src/core/SkDrawable.cpp",
    "src/core/SkEdge.cpp",
    "src/core/SkEdge.h",
    "src/core/SkEdgeBuilder.cpp",
    "src/core/SkEdgeBuilder.h",
    "src/core/SkEdgeClipper.cpp",
    "src/core/SkEdgeClipper.h",
    "src/core/SkEffectPriv.h",
    "src/core/SkEnumBitMask.h",
    "src/core/SkEnumerate.h",
    "src/core/SkExecutor.cpp",
    "src/core/SkFDot6.h",
    "src/core/SkFilterColorProgram.cpp",
    "src/core/SkFilterColorProgram.h",
    "src/core/SkFlattenable.cpp",
    "src/core/SkFont.cpp",
    "src/core/SkFontDescriptor.cpp",
    "src/core/SkFontDescriptor.h",
    "src/core/SkFontMetricsPriv.cpp",
    "src/core/SkFontMetricsPriv.h",
    "src/core/SkFontMgr.cpp",
    "src/core/SkFontMgrPriv.h",
    "src/core/SkFontPriv.h",
    "src/core/SkFontStream.cpp",
    "src/core/SkFontStream.h",
    "src/core/SkFont_serial.cpp",
    "src/core/SkFuzzLogging.h",
    "src/core/SkGaussFilter.cpp",
    "src/core/SkGaussFilter.h",
    "src/core/SkGeometry.cpp",
    "src/core/SkGeometry.h",
    "src/core/SkGlobalInitialization_core.cpp",
    "src/core/SkGlyph.cpp",
    "src/core/SkGlyph.h",
    "src/core/SkGlyphRunPainter.cpp",
    "src/core/SkGlyphRunPainter.h",
    "src/core/SkGpuBlurUtils.cpp",
    "src/core/SkGpuBlurUtils.h",
    "src/core/SkGraphics.cpp",
    "src/core/SkIDChangeListener.cpp",
    "src/core/SkIPoint16.h",
    "src/core/SkImageFilter.cpp",
    "src/core/SkImageFilterCache.cpp",
    "src/core/SkImageFilterCache.h",
    "src/core/SkImageFilterTypes.cpp",
    "src/core/SkImageFilterTypes.h",
    "src/core/SkImageFilter_Base.h",
    "src/core/SkImageGenerator.cpp",
    "src/core/SkImageInfo.cpp",
    "src/core/SkImageInfoPriv.h",
    "src/core/SkImagePriv.h",
    "src/core/SkLRUCache.h",
    "src/core/SkLatticeIter.cpp",
    "src/core/SkLatticeIter.h",
    "src/core/SkLineClipper.cpp",
    "src/core/SkLineClipper.h",
    "src/core/SkLocalMatrixImageFilter.cpp",
    "src/core/SkLocalMatrixImageFilter.h",
    "src/core/SkM44.cpp",
    "src/core/SkMD5.cpp",
    "src/core/SkMD5.h",
    "src/core/SkMallocPixelRef.cpp",
    "src/core/SkMask.cpp",
    "src/core/SkMask.h",
    "src/core/SkMaskBlurFilter.cpp",
    "src/core/SkMaskBlurFilter.h",
    "src/core/SkMaskCache.cpp",
    "src/core/SkMaskCache.h",
    "src/core/SkMaskFilter.cpp",
    "src/core/SkMaskFilterBase.h",
    "src/core/SkMaskGamma.cpp",
    "src/core/SkMaskGamma.h",
    "src/core/SkMatrix.cpp",
    "src/core/SkMatrixInvert.cpp",
    "src/core/SkMatrixInvert.h",
    "src/core/SkMatrixPriv.h",
    "src/core/SkMatrixProvider.h",
    "src/core/SkMatrixUtils.h",
    "src/core/SkMesh.cpp",
    "src/core/SkMeshPriv.h",
    "src/core/SkMessageBus.h",
    "src/core/SkMipmap.cpp",
    "src/core/SkMipmap.h",
    "src/core/SkMipmapAccessor.cpp",
    "src/core/SkMipmapAccessor.h",
    "src/core/SkMipmapBuilder.cpp",
    "src/core/SkMipmapBuilder.h",
    "src/core/SkNextID.h",
    "src/core/SkOSFile.h",
    "src/core/SkOpts.cpp",
    "src/core/SkOpts.h",
    "src/core/SkOpts_erms.cpp",
    "src/core/SkOrderedReadBuffer.h",
    "src/core/SkOverdrawCanvas.cpp",
    "src/core/SkPaint.cpp",
    "src/core/SkPaintDefaults.h",
    "src/core/SkPaintPriv.cpp",
    "src/core/SkPaintPriv.h",
    "src/core/SkPath.cpp",
    "src/core/SkPathBuilder.cpp",
    "src/core/SkPathEffect.cpp",
    "src/core/SkPathEffectBase.h",
    "src/core/SkPathMakers.h",
    "src/core/SkPathMeasure.cpp",
    "src/core/SkPathMeasurePriv.h",
    "src/core/SkPathPriv.h",
    "src/core/SkPathRef.cpp",
    "src/core/SkPathUtils.cpp",
    "src/core/SkPath_serial.cpp",
    "src/core/SkPicture.cpp",
    "src/core/SkPictureData.cpp",
    "src/core/SkPictureData.h",
    "src/core/SkPictureFlat.cpp",
    "src/core/SkPictureFlat.h",
    "src/core/SkPicturePlayback.cpp",
    "src/core/SkPicturePlayback.h",
    "src/core/SkPicturePriv.h",
    "src/core/SkPictureRecord.cpp",
    "src/core/SkPictureRecord.h",
    "src/core/SkPictureRecorder.cpp",
    "src/core/SkPixelRef.cpp",
    "src/core/SkPixelRefPriv.h",
    "src/core/SkPixmap.cpp",
    "src/core/SkPixmapDraw.cpp",
    "src/core/SkPoint.cpp",
    "src/core/SkPoint3.cpp",
    "src/core/SkPointPriv.h",
    "src/core/SkPtrRecorder.cpp",
    "src/core/SkPtrRecorder.h",
    "src/core/SkQuadClipper.cpp",
    "src/core/SkQuadClipper.h",
    "src/core/SkRRect.cpp",
    "src/core/SkRRectPriv.h",
    "src/core/SkRSXform.cpp",
    "src/core/SkRTree.cpp",
    "src/core/SkRTree.h",
    "src/core/SkRasterClip.cpp",
    "src/core/SkRasterClip.h",
    "src/core/SkRasterClipStack.h",
    "src/core/SkRasterPipeline.cpp",
    "src/core/SkRasterPipeline.h",
    "src/core/SkRasterPipelineBlitter.cpp",
    "src/core/SkRasterPipelineContextUtils.h",
    "src/core/SkRasterPipelineOpContexts.h",
    "src/core/SkRasterPipelineOpList.h",
    "src/core/SkReadBuffer.cpp",
    "src/core/SkReadBuffer.h",
    "src/core/SkReadPixelsRec.cpp",
    "src/core/SkReadPixelsRec.h",
    "src/core/SkRecord.cpp",
    "src/core/SkRecord.h",
    "src/core/SkRecordDraw.cpp",
    "src/core/SkRecordDraw.h",
    "src/core/SkRecordOpts.cpp",
    "src/core/SkRecordOpts.h",
    "src/core/SkRecordPattern.h",
    "src/core/SkRecordedDrawable.cpp",
    "src/core/SkRecordedDrawable.h",
    "src/core/SkRecorder.cpp",
    "src/core/SkRecorder.h",
    "src/core/SkRecords.cpp",
    "src/core/SkRecords.h",
    "src/core/SkRect.cpp",
    "src/core/SkRectPriv.h",
    "src/core/SkRegion.cpp",
    "src/core/SkRegionPriv.h",
    "src/core/SkRegion_path.cpp",
    "src/core/SkResourceCache.cpp",
    "src/core/SkResourceCache.h",
    "src/core/SkRuntimeBlender.cpp",
    "src/core/SkRuntimeBlender.h",
    "src/core/SkRuntimeEffect.cpp",
    "src/core/SkRuntimeEffectPriv.h",
    "src/core/SkSLTypeShared.cpp",
    "src/core/SkSLTypeShared.h",
    "src/core/SkSafeRange.h",
    "src/core/SkSamplingPriv.h",
    "src/core/SkScalar.cpp",
    "src/core/SkScaleToSides.h",
    "src/core/SkScalerContext.cpp",
    "src/core/SkScalerContext.h",
    "src/core/SkScan.cpp",
    "src/core/SkScan.h",
    "src/core/SkScanPriv.h",
    "src/core/SkScan_AAAPath.cpp",
    "src/core/SkScan_AntiPath.cpp",
    "src/core/SkScan_Antihair.cpp",
    "src/core/SkScan_Hairline.cpp",
    "src/core/SkScan_Path.cpp",
    "src/core/SkScan_SAAPath.cpp",
    "src/core/SkSpecialImage.cpp",
    "src/core/SkSpecialImage.h",
    "src/core/SkSpecialSurface.cpp",
    "src/core/SkSpecialSurface.h",
    "src/core/SkSpriteBlitter.h",
    "src/core/SkSpriteBlitter_ARGB32.cpp",
    "src/core/SkStream.cpp",
    "src/core/SkStreamPriv.h",
    "src/core/SkStrike.cpp",
    "src/core/SkStrike.h",
    "src/core/SkStrikeCache.cpp",
    "src/core/SkStrikeCache.h",
    "src/core/SkStrikeSpec.cpp",
    "src/core/SkStrikeSpec.h",
    "src/core/SkString.cpp",
    "src/core/SkStringUtils.cpp",
    "src/core/SkStringUtils.h",
    "src/core/SkStroke.cpp",
    "src/core/SkStroke.h",
    "src/core/SkStrokeRec.cpp",
    "src/core/SkStrokerPriv.cpp",
    "src/core/SkStrokerPriv.h",
    "src/core/SkSurfacePriv.h",
    "src/core/SkSwizzle.cpp",
    "src/core/SkSwizzlePriv.h",
    "src/core/SkTDynamicHash.h",
    "src/core/SkTHash.h",
    "src/core/SkTMultiMap.h",
    "src/core/SkTaskGroup.cpp",
    "src/core/SkTaskGroup.h",
    "src/core/SkTextBlob.cpp",
    "src/core/SkTextBlobPriv.h",
    "src/core/SkTextBlobTrace.cpp",
    "src/core/SkTextBlobTrace.h",
    "src/core/SkTextFormatParams.h",
    "src/core/SkTime.cpp",
    "src/core/SkTraceEvent.h",
    "src/core/SkTraceEventCommon.h",
    "src/core/SkTypeface.cpp",
    "src/core/SkTypefaceCache.cpp",
    "src/core/SkTypefaceCache.h",
    "src/core/SkTypeface_remote.cpp",
    "src/core/SkTypeface_remote.h",
    "src/core/SkUnPreMultiply.cpp",
    "src/core/SkVM.cpp",
    "src/core/SkVM.h",
    "src/core/SkVMBlitter.cpp",
    "src/core/SkVMBlitter.h",
    "src/core/SkVM_fwd.h",
    "src/core/SkValidationUtils.h",
    "src/core/SkVertState.cpp",
    "src/core/SkVertState.h",
    "src/core/SkVertices.cpp",
    "src/core/SkVerticesPriv.h",
    "src/core/SkWriteBuffer.cpp",
    "src/core/SkWriteBuffer.h",
    "src/core/SkWritePixelsRec.cpp",
    "src/core/SkWritePixelsRec.h",
    "src/core/SkWriter32.cpp",
    "src/core/SkWriter32.h",
    "src/core/SkYUVAInfo.cpp",
    "src/core/SkYUVAInfoLocation.h",
    "src/core/SkYUVAPixmaps.cpp",
    "src/core/SkYUVMath.cpp",
    "src/core/SkYUVMath.h",
    "src/core/SkYUVPlanesCache.cpp",
    "src/core/SkYUVPlanesCache.h",
    "src/effects/Sk1DPathEffect.cpp",
    "src/effects/Sk2DPathEffect.cpp",
    "src/effects/SkBlenders.cpp",
    "src/effects/SkColorMatrix.cpp",
    "src/effects/SkColorMatrixFilter.cpp",
    "src/effects/SkCornerPathEffect.cpp",
    "src/effects/SkDashImpl.h",
    "src/effects/SkDashPathEffect.cpp",
    "src/effects/SkDiscretePathEffect.cpp",
    "src/effects/SkEmbossMask.cpp",
    "src/effects/SkEmbossMask.h",
    "src/effects/SkEmbossMaskFilter.cpp",
    "src/effects/SkEmbossMaskFilter.h",
    "src/effects/SkHighContrastFilter.cpp",
    "src/effects/SkLayerDrawLooper.cpp",
    "src/effects/SkOpPE.h",
    "src/effects/SkOpPathEffect.cpp",
    "src/effects/SkShaderMaskFilterImpl.cpp",
    "src/effects/SkShaderMaskFilterImpl.h",
    "src/effects/SkTableMaskFilter.cpp",
    "src/effects/SkTrimPE.h",
    "src/effects/SkTrimPathEffect.cpp",
    "src/effects/colorfilters/SkBlendModeColorFilter.cpp",
    "src/effects/colorfilters/SkBlendModeColorFilter.h",
    "src/effects/colorfilters/SkColorFilterBase.cpp",
    "src/effects/colorfilters/SkColorFilterBase.h",
    "src/effects/colorfilters/SkColorSpaceXformColorFilter.cpp",
    "src/effects/colorfilters/SkColorSpaceXformColorFilter.h",
    "src/effects/colorfilters/SkComposeColorFilter.cpp",
    "src/effects/colorfilters/SkComposeColorFilter.h",
    "src/effects/colorfilters/SkGaussianColorFilter.cpp",
    "src/effects/colorfilters/SkGaussianColorFilter.h",
    "src/effects/colorfilters/SkMatrixColorFilter.cpp",
    "src/effects/colorfilters/SkMatrixColorFilter.h",
    "src/effects/colorfilters/SkRuntimeColorFilter.cpp",
    "src/effects/colorfilters/SkRuntimeColorFilter.h",
    "src/effects/colorfilters/SkTableColorFilter.cpp",
    "src/effects/colorfilters/SkTableColorFilter.h",
    "src/effects/colorfilters/SkWorkingFormatColorFilter.cpp",
    "src/effects/colorfilters/SkWorkingFormatColorFilter.h",
    "src/effects/imagefilters/SkBlendImageFilter.cpp",
    "src/effects/imagefilters/SkBlurImageFilter.cpp",
    "src/effects/imagefilters/SkColorFilterImageFilter.cpp",
    "src/effects/imagefilters/SkComposeImageFilter.cpp",
    "src/effects/imagefilters/SkCropImageFilter.cpp",
    "src/effects/imagefilters/SkCropImageFilter.h",
    "src/effects/imagefilters/SkDisplacementMapImageFilter.cpp",
    "src/effects/imagefilters/SkDropShadowImageFilter.cpp",
    "src/effects/imagefilters/SkImageImageFilter.cpp",
    "src/effects/imagefilters/SkLightingImageFilter.cpp",
    "src/effects/imagefilters/SkMagnifierImageFilter.cpp",
    "src/effects/imagefilters/SkMatrixConvolutionImageFilter.cpp",
    "src/effects/imagefilters/SkMatrixTransformImageFilter.cpp",
    "src/effects/imagefilters/SkMergeImageFilter.cpp",
    "src/effects/imagefilters/SkMorphologyImageFilter.cpp",
    "src/effects/imagefilters/SkPictureImageFilter.cpp",
    "src/effects/imagefilters/SkRuntimeImageFilter.cpp",
    "src/effects/imagefilters/SkShaderImageFilter.cpp",
    "src/effects/imagefilters/SkTileImageFilter.cpp",
    "src/fonts/SkFontMgr_indirect.cpp",
    "src/fonts/SkRemotableFontMgr.cpp",
    "src/gpu/AsyncReadTypes.h",
    "src/gpu/AtlasTypes.cpp",
    "src/gpu/AtlasTypes.h",
    "src/gpu/Blend.cpp",
    "src/gpu/Blend.h",
    "src/gpu/BlendFormula.cpp",
    "src/gpu/BlendFormula.h",
    "src/gpu/BufferWriter.h",
    "src/gpu/DitherUtils.cpp",
    "src/gpu/DitherUtils.h",
    "src/gpu/GpuTypesPriv.h",
    "src/gpu/GrAHardwareBufferUtils.h",
    "src/gpu/KeyBuilder.h",
    "src/gpu/MutableTextureStateRef.h",
    "src/gpu/PipelineUtils.cpp",
    "src/gpu/PipelineUtils.h",
    "src/gpu/Rectanizer.h",
    "src/gpu/RectanizerPow2.cpp",
    "src/gpu/RectanizerPow2.h",
    "src/gpu/RectanizerSkyline.cpp",
    "src/gpu/RectanizerSkyline.h",
    "src/gpu/RefCntedCallback.h",
    "src/gpu/ResourceKey.cpp",
    "src/gpu/ResourceKey.h",
    "src/gpu/ShaderErrorHandler.cpp",
    "src/gpu/SkBackingFit.h",
    "src/gpu/SkRenderEngineAbortf.h",
    "src/gpu/Swizzle.cpp",
    "src/gpu/Swizzle.h",
    "src/gpu/TiledTextureUtils.cpp",
    "src/gpu/TiledTextureUtils.h",
    # We include the ganesh files, but leave out any specific backend (e.g. GL, Vulkan)
    "src/gpu/ganesh/ClipStack.cpp",
    "src/gpu/ganesh/ClipStack.h",
    "src/gpu/ganesh/Device.cpp",
    "src/gpu/ganesh/Device_drawTexture.cpp",
    "src/gpu/ganesh/Device.h",
    "src/gpu/ganesh/GrAHardwareBufferImageGenerator.cpp",
    "src/gpu/ganesh/GrAHardwareBufferImageGenerator.h",
    "src/gpu/ganesh/GrAHardwareBufferUtils.cpp",
    "src/gpu/ganesh/GrAHardwareBufferUtils_impl.h",
    "src/gpu/ganesh/GrAppliedClip.h",
    "src/gpu/ganesh/GrAttachment.cpp",
    "src/gpu/ganesh/GrAttachment.h",
    "src/gpu/ganesh/GrAuditTrail.cpp",
    "src/gpu/ganesh/GrAuditTrail.h",
    "src/gpu/ganesh/GrAutoLocaleSetter.h",
    "src/gpu/ganesh/GrBackendSemaphore.cpp",
    "src/gpu/ganesh/GrBackendSurface.cpp",
    "src/gpu/ganesh/GrBackendTextureImageGenerator.cpp",
    "src/gpu/ganesh/GrBackendTextureImageGenerator.h",
    "src/gpu/ganesh/GrBackendUtils.cpp",
    "src/gpu/ganesh/GrBackendUtils.h",
    "src/gpu/ganesh/GrBaseContextPriv.h",
    "src/gpu/ganesh/GrBlurUtils.cpp",
    "src/gpu/ganesh/GrBlurUtils.h",
    "src/gpu/ganesh/GrBuffer.h",
    "src/gpu/ganesh/GrBufferAllocPool.cpp",
    "src/gpu/ganesh/GrBufferAllocPool.h",
    "src/gpu/ganesh/GrBufferTransferRenderTask.cpp",
    "src/gpu/ganesh/GrBufferTransferRenderTask.h",
    "src/gpu/ganesh/GrBufferUpdateRenderTask.cpp",
    "src/gpu/ganesh/GrBufferUpdateRenderTask.h",
    "src/gpu/ganesh/GrCaps.cpp",
    "src/gpu/ganesh/GrCaps.h",
    "src/gpu/ganesh/GrCanvas.cpp",
    "src/gpu/ganesh/GrCanvas.h",
    "src/gpu/ganesh/GrClientMappedBufferManager.cpp",
    "src/gpu/ganesh/GrClientMappedBufferManager.h",
    "src/gpu/ganesh/GrClip.h",
    "src/gpu/ganesh/GrColor.h",
    "src/gpu/ganesh/GrColorInfo.cpp",
    "src/gpu/ganesh/GrColorInfo.h",
    "src/gpu/ganesh/GrColorSpaceXform.cpp",
    "src/gpu/ganesh/GrColorSpaceXform.h",
    "src/gpu/ganesh/GrContextThreadSafeProxy.cpp",
    "src/gpu/ganesh/GrContextThreadSafeProxyPriv.h",
    "src/gpu/ganesh/GrContext_Base.cpp",
    "src/gpu/ganesh/GrCopyRenderTask.cpp",
    "src/gpu/ganesh/GrCopyRenderTask.h",
    "src/gpu/ganesh/GrCpuBuffer.h",
    "src/gpu/ganesh/GrDDLContext.cpp",
    "src/gpu/ganesh/GrDDLTask.cpp",
    "src/gpu/ganesh/GrDDLTask.h",
    "src/gpu/ganesh/GrDataUtils.cpp",
    "src/gpu/ganesh/GrDataUtils.h",
    "src/gpu/ganesh/GrDefaultGeoProcFactory.cpp",
    "src/gpu/ganesh/GrDefaultGeoProcFactory.h",
    "src/gpu/ganesh/GrDeferredDisplayList.cpp",
    "src/gpu/ganesh/GrDeferredDisplayListPriv.h",
    "src/gpu/ganesh/GrDeferredDisplayListRecorder.cpp",
    "src/gpu/ganesh/GrDeferredProxyUploader.h",
    "src/gpu/ganesh/GrDeferredUpload.h",
    "src/gpu/ganesh/GrDirectContext.cpp",
    "src/gpu/ganesh/GrDirectContextPriv.cpp",
    "src/gpu/ganesh/GrDirectContextPriv.h",
    "src/gpu/ganesh/GrDistanceFieldGenFromVector.cpp",
    "src/gpu/ganesh/GrDistanceFieldGenFromVector.h",
    "src/gpu/ganesh/GrDrawIndirectCommand.h",
    "src/gpu/ganesh/GrDrawOpAtlas.cpp",
    "src/gpu/ganesh/GrDrawOpAtlas.h",
    "src/gpu/ganesh/GrDrawOpTest.cpp",
    "src/gpu/ganesh/GrDrawOpTest.h",
    "src/gpu/ganesh/GrDrawingManager.cpp",
    "src/gpu/ganesh/GrDrawingManager.h",
    "src/gpu/ganesh/GrDriverBugWorkarounds.cpp",
    "src/gpu/ganesh/GrDstProxyView.h",
    "src/gpu/ganesh/GrDynamicAtlas.cpp",
    "src/gpu/ganesh/GrDynamicAtlas.h",
    "src/gpu/ganesh/GrEagerVertexAllocator.cpp",
    "src/gpu/ganesh/GrEagerVertexAllocator.h",
    "src/gpu/ganesh/GrFPArgs.h",
    "src/gpu/ganesh/GrFinishCallbacks.cpp",
    "src/gpu/ganesh/GrFinishCallbacks.h",
    "src/gpu/ganesh/GrFixedClip.cpp",
    "src/gpu/ganesh/GrFixedClip.h",
    "src/gpu/ganesh/GrFragmentProcessor.cpp",
    "src/gpu/ganesh/GrFragmentProcessor.h",
    "src/gpu/ganesh/GrFragmentProcessors.cpp",
    "src/gpu/ganesh/GrFragmentProcessors.h",
    "src/gpu/ganesh/GrGeometryProcessor.cpp",
    "src/gpu/ganesh/GrGeometryProcessor.h",
    "src/gpu/ganesh/GrGpu.cpp",
    "src/gpu/ganesh/GrGpu.h",
    "src/gpu/ganesh/GrGpuBuffer.cpp",
    "src/gpu/ganesh/GrGpuBuffer.h",
    "src/gpu/ganesh/GrGpuResource.cpp",
    "src/gpu/ganesh/GrGpuResource.h",
    "src/gpu/ganesh/GrGpuResourceCacheAccess.h",
    "src/gpu/ganesh/GrGpuResourcePriv.h",
    "src/gpu/ganesh/GrHashMapWithCache.h",
    "src/gpu/ganesh/GrImageContext.cpp",
    "src/gpu/ganesh/GrImageContextPriv.h",
    "src/gpu/ganesh/GrImageInfo.cpp",
    "src/gpu/ganesh/GrImageInfo.h",
    "src/gpu/ganesh/GrManagedResource.cpp",
    "src/gpu/ganesh/GrManagedResource.h",
    "src/gpu/ganesh/GrMemoryPool.cpp",
    "src/gpu/ganesh/GrMemoryPool.h",
    "src/gpu/ganesh/GrMeshDrawTarget.cpp",
    "src/gpu/ganesh/GrMeshDrawTarget.h",
    "src/gpu/ganesh/GrNativeRect.h",
    "src/gpu/ganesh/GrNonAtomicRef.h",
    "src/gpu/ganesh/GrOnFlushResourceProvider.cpp",
    "src/gpu/ganesh/GrOnFlushResourceProvider.h",
    "src/gpu/ganesh/GrOpFlushState.cpp",
    "src/gpu/ganesh/GrOpFlushState.h",
    "src/gpu/ganesh/GrOpsRenderPass.cpp",
    "src/gpu/ganesh/GrOpsRenderPass.h",
    "src/gpu/ganesh/GrOpsTypes.h",
    "src/gpu/ganesh/GrPaint.cpp",
    "src/gpu/ganesh/GrPaint.h",
    "src/gpu/ganesh/GrPersistentCacheUtils.cpp",
    "src/gpu/ganesh/GrPersistentCacheUtils.h",
    "src/gpu/ganesh/GrPipeline.cpp",
    "src/gpu/ganesh/GrPipeline.h",
    "src/gpu/ganesh/GrPixmap.h",
    "src/gpu/ganesh/GrProcessor.cpp",
    "src/gpu/ganesh/GrProcessor.h",
    "src/gpu/ganesh/GrProcessorAnalysis.cpp",
    "src/gpu/ganesh/GrProcessorAnalysis.h",
    "src/gpu/ganesh/GrProcessorSet.cpp",
    "src/gpu/ganesh/GrProcessorSet.h",
    "src/gpu/ganesh/GrProcessorUnitTest.cpp",
    "src/gpu/ganesh/GrProcessorUnitTest.h",
    "src/gpu/ganesh/GrProgramDesc.cpp",
    "src/gpu/ganesh/GrProgramDesc.h",
    "src/gpu/ganesh/GrProgramInfo.cpp",
    "src/gpu/ganesh/GrProgramInfo.h",
    "src/gpu/ganesh/GrPromiseImageTexture.cpp",
    "src/gpu/ganesh/GrProxyProvider.cpp",
    "src/gpu/ganesh/GrProxyProvider.h",
    "src/gpu/ganesh/GrRecordingContext.cpp",
    "src/gpu/ganesh/GrRecordingContextPriv.cpp",
    "src/gpu/ganesh/GrRecordingContextPriv.h",
    "src/gpu/ganesh/GrRefCnt.h",
    "src/gpu/ganesh/GrRenderTarget.cpp",
    "src/gpu/ganesh/GrRenderTarget.h",
    "src/gpu/ganesh/GrRenderTargetContext.h",
    "src/gpu/ganesh/GrRenderTargetProxy.cpp",
    "src/gpu/ganesh/GrRenderTargetProxy.h",
    "src/gpu/ganesh/GrRenderTask.cpp",
    "src/gpu/ganesh/GrRenderTask.h",
    "src/gpu/ganesh/GrRenderTaskCluster.cpp",
    "src/gpu/ganesh/GrRenderTaskCluster.h",
    "src/gpu/ganesh/GrResourceAllocator.cpp",
    "src/gpu/ganesh/GrResourceAllocator.h",
    "src/gpu/ganesh/GrResourceCache.cpp",
    "src/gpu/ganesh/GrResourceCache.h",
    "src/gpu/ganesh/GrResourceHandle.h",
    "src/gpu/ganesh/GrResourceProvider.cpp",
    "src/gpu/ganesh/GrResourceProvider.h",
    "src/gpu/ganesh/GrResourceProviderPriv.h",
    "src/gpu/ganesh/GrRingBuffer.cpp",
    "src/gpu/ganesh/GrRingBuffer.h",
    "src/gpu/ganesh/GrSPIRVUniformHandler.cpp",
    "src/gpu/ganesh/GrSPIRVUniformHandler.h",
    "src/gpu/ganesh/GrSPIRVVaryingHandler.cpp",
    "src/gpu/ganesh/GrSPIRVVaryingHandler.h",
    "src/gpu/ganesh/GrSWMaskHelper.cpp",
    "src/gpu/ganesh/GrSWMaskHelper.h",
    "src/gpu/ganesh/GrSamplerState.h",
    "src/gpu/ganesh/GrScissorState.h",
    "src/gpu/ganesh/GrSemaphore.h",
    "src/gpu/ganesh/GrShaderCaps.cpp",
    "src/gpu/ganesh/GrShaderCaps.h",
    "src/gpu/ganesh/GrShaderVar.cpp",
    "src/gpu/ganesh/GrShaderVar.h",
    "src/gpu/ganesh/GrSimpleMesh.h",
    "src/gpu/ganesh/GrStagingBufferManager.cpp",
    "src/gpu/ganesh/GrStagingBufferManager.h",
    "src/gpu/ganesh/GrStencilSettings.cpp",
    "src/gpu/ganesh/GrStencilSettings.h",
    "src/gpu/ganesh/GrStyle.cpp",
    "src/gpu/ganesh/GrStyle.h",
    "src/gpu/ganesh/GrSurface.cpp",
    "src/gpu/ganesh/GrSurface.h",
    "src/gpu/ganesh/GrSurfaceCharacterization.cpp",
    "src/gpu/ganesh/GrSurfaceInfo.cpp",
    "src/gpu/ganesh/GrSurfaceProxy.cpp",
    "src/gpu/ganesh/GrSurfaceProxy.h",
    "src/gpu/ganesh/GrSurfaceProxyPriv.h",
    "src/gpu/ganesh/GrSurfaceProxyView.cpp",
    "src/gpu/ganesh/GrSurfaceProxyView.h",
    "src/gpu/ganesh/GrTTopoSort.h",
    "src/gpu/ganesh/GrTestUtils.cpp",
    "src/gpu/ganesh/GrTestUtils.h",
    "src/gpu/ganesh/GrTexture.cpp",
    "src/gpu/ganesh/GrTexture.h",
    "src/gpu/ganesh/GrTextureProxy.cpp",
    "src/gpu/ganesh/GrTextureProxy.h",
    "src/gpu/ganesh/GrTextureProxyCacheAccess.h",
    "src/gpu/ganesh/GrTextureProxyPriv.h",
    "src/gpu/ganesh/GrTextureRenderTargetProxy.cpp",
    "src/gpu/ganesh/GrTextureRenderTargetProxy.h",
    "src/gpu/ganesh/GrTextureResolveManager.h",
    "src/gpu/ganesh/GrTextureResolveRenderTask.cpp",
    "src/gpu/ganesh/GrTextureResolveRenderTask.h",
    "src/gpu/ganesh/GrThreadSafeCache.cpp",
    "src/gpu/ganesh/GrThreadSafeCache.h",
    "src/gpu/ganesh/GrThreadSafePipelineBuilder.cpp",
    "src/gpu/ganesh/GrThreadSafePipelineBuilder.h",
    "src/gpu/ganesh/GrTracing.h",
    "src/gpu/ganesh/GrTransferFromRenderTask.cpp",
    "src/gpu/ganesh/GrTransferFromRenderTask.h",
    "src/gpu/ganesh/GrUniformDataManager.cpp",
    "src/gpu/ganesh/GrUniformDataManager.h",
    "src/gpu/ganesh/GrUserStencilSettings.h",
    "src/gpu/ganesh/GrUtil.cpp",
    "src/gpu/ganesh/GrUtil.h",
    "src/gpu/ganesh/GrVertexChunkArray.cpp",
    "src/gpu/ganesh/GrVertexChunkArray.h",
    "src/gpu/ganesh/GrWaitRenderTask.cpp",
    "src/gpu/ganesh/GrWaitRenderTask.h",
    "src/gpu/ganesh/GrWindowRectangles.h",
    "src/gpu/ganesh/GrWindowRectsState.h",
    "src/gpu/ganesh/GrWritePixelsRenderTask.cpp",
    "src/gpu/ganesh/GrWritePixelsRenderTask.h",
    "src/gpu/ganesh/GrXferProcessor.cpp",
    "src/gpu/ganesh/GrXferProcessor.h",
    "src/gpu/ganesh/GrYUVABackendTextures.cpp",
    "src/gpu/ganesh/GrYUVATextureProxies.cpp",
    "src/gpu/ganesh/GrYUVATextureProxies.h",
    "src/gpu/ganesh/PathRenderer.cpp",
    "src/gpu/ganesh/PathRenderer.h",
    "src/gpu/ganesh/PathRendererChain.cpp",
    "src/gpu/ganesh/PathRendererChain.h",
    "src/gpu/ganesh/SkGr.cpp",
    "src/gpu/ganesh/SkGr.h",
    "src/gpu/ganesh/StencilClip.h",
    "src/gpu/ganesh/StencilMaskHelper.cpp",
    "src/gpu/ganesh/StencilMaskHelper.h",
    "src/gpu/ganesh/SurfaceContext.cpp",
    "src/gpu/ganesh/SurfaceContext.h",
    "src/gpu/ganesh/SurfaceDrawContext.cpp",
    "src/gpu/ganesh/SurfaceDrawContext.h",
    "src/gpu/ganesh/SurfaceFillContext.cpp",
    "src/gpu/ganesh/SurfaceFillContext.h",
    "src/gpu/ganesh/TestFormatColorTypeCombination.h",
    "src/gpu/ganesh/effects/GrAtlasedShaderHelpers.h",
    "src/gpu/ganesh/effects/GrBezierEffect.cpp",
    "src/gpu/ganesh/effects/GrBezierEffect.h",
    "src/gpu/ganesh/effects/GrBicubicEffect.cpp",
    "src/gpu/ganesh/effects/GrBicubicEffect.h",
    "src/gpu/ganesh/effects/GrBitmapTextGeoProc.cpp",
    "src/gpu/ganesh/effects/GrBitmapTextGeoProc.h",
    "src/gpu/ganesh/effects/GrBlendFragmentProcessor.cpp",
    "src/gpu/ganesh/effects/GrBlendFragmentProcessor.h",
    "src/gpu/ganesh/effects/GrColorTableEffect.cpp",
    "src/gpu/ganesh/effects/GrColorTableEffect.h",
    "src/gpu/ganesh/effects/GrConvexPolyEffect.cpp",
    "src/gpu/ganesh/effects/GrConvexPolyEffect.h",
    "src/gpu/ganesh/effects/GrCoverageSetOpXP.cpp",
    "src/gpu/ganesh/effects/GrCoverageSetOpXP.h",
    "src/gpu/ganesh/effects/GrCustomXfermode.cpp",
    "src/gpu/ganesh/effects/GrCustomXfermode.h",
    "src/gpu/ganesh/effects/GrDisableColorXP.cpp",
    "src/gpu/ganesh/effects/GrDisableColorXP.h",
    "src/gpu/ganesh/effects/GrDistanceFieldGeoProc.cpp",
    "src/gpu/ganesh/effects/GrDistanceFieldGeoProc.h",
    "src/gpu/ganesh/effects/GrGaussianConvolutionFragmentProcessor.cpp",
    "src/gpu/ganesh/effects/GrGaussianConvolutionFragmentProcessor.h",
    "src/gpu/ganesh/effects/GrMatrixConvolutionEffect.cpp",
    "src/gpu/ganesh/effects/GrMatrixConvolutionEffect.h",
    "src/gpu/ganesh/effects/GrMatrixEffect.cpp",
    "src/gpu/ganesh/effects/GrMatrixEffect.h",
    "src/gpu/ganesh/effects/GrModulateAtlasCoverageEffect.cpp",
    "src/gpu/ganesh/effects/GrModulateAtlasCoverageEffect.h",
    "src/gpu/ganesh/effects/GrOvalEffect.cpp",
    "src/gpu/ganesh/effects/GrOvalEffect.h",
    "src/gpu/ganesh/effects/GrPerlinNoise2Effect.cpp",
    "src/gpu/ganesh/effects/GrPerlinNoise2Effect.h",
    "src/gpu/ganesh/effects/GrPorterDuffXferProcessor.cpp",
    "src/gpu/ganesh/effects/GrPorterDuffXferProcessor.h",
    "src/gpu/ganesh/effects/GrRRectEffect.cpp",
    "src/gpu/ganesh/effects/GrRRectEffect.h",
    "src/gpu/ganesh/effects/GrShadowGeoProc.cpp",
    "src/gpu/ganesh/effects/GrShadowGeoProc.h",
    "src/gpu/ganesh/effects/GrSkSLFP.cpp",
    "src/gpu/ganesh/effects/GrSkSLFP.h",
    "src/gpu/ganesh/effects/GrTextureEffect.cpp",
    "src/gpu/ganesh/effects/GrTextureEffect.h",
    "src/gpu/ganesh/effects/GrYUVtoRGBEffect.cpp",
    "src/gpu/ganesh/effects/GrYUVtoRGBEffect.h",
    "src/gpu/ganesh/geometry/GrAAConvexTessellator.cpp",
    "src/gpu/ganesh/geometry/GrAAConvexTessellator.h",
    "src/gpu/ganesh/geometry/GrAATriangulator.cpp",
    "src/gpu/ganesh/geometry/GrAATriangulator.h",
    "src/gpu/ganesh/geometry/GrInnerFanTriangulator.h",
    "src/gpu/ganesh/geometry/GrPathUtils.cpp",
    "src/gpu/ganesh/geometry/GrPathUtils.h",
    "src/gpu/ganesh/geometry/GrQuad.cpp",
    "src/gpu/ganesh/geometry/GrQuad.h",
    "src/gpu/ganesh/geometry/GrQuadBuffer.h",
    "src/gpu/ganesh/geometry/GrQuadUtils.cpp",
    "src/gpu/ganesh/geometry/GrQuadUtils.h",
    "src/gpu/ganesh/geometry/GrRect.h",
    "src/gpu/ganesh/geometry/GrShape.cpp",
    "src/gpu/ganesh/geometry/GrShape.h",
    "src/gpu/ganesh/geometry/GrStyledShape.cpp",
    "src/gpu/ganesh/geometry/GrStyledShape.h",
    "src/gpu/ganesh/geometry/GrTriangulator.cpp",
    "src/gpu/ganesh/geometry/GrTriangulator.h",
    "src/gpu/ganesh/glsl/GrGLSLBlend.cpp",
    "src/gpu/ganesh/glsl/GrGLSLBlend.h",
    "src/gpu/ganesh/glsl/GrGLSLColorSpaceXformHelper.h",
    "src/gpu/ganesh/glsl/GrGLSLFragmentShaderBuilder.cpp",
    "src/gpu/ganesh/glsl/GrGLSLFragmentShaderBuilder.h",
    "src/gpu/ganesh/glsl/GrGLSLProgramBuilder.cpp",
    "src/gpu/ganesh/glsl/GrGLSLProgramBuilder.h",
    "src/gpu/ganesh/glsl/GrGLSLProgramDataManager.cpp",
    "src/gpu/ganesh/glsl/GrGLSLProgramDataManager.h",
    "src/gpu/ganesh/glsl/GrGLSLShaderBuilder.cpp",
    "src/gpu/ganesh/glsl/GrGLSLShaderBuilder.h",
    "src/gpu/ganesh/glsl/GrGLSLUniformHandler.cpp",
    "src/gpu/ganesh/glsl/GrGLSLUniformHandler.h",
    "src/gpu/ganesh/glsl/GrGLSLVarying.cpp",
    "src/gpu/ganesh/glsl/GrGLSLVarying.h",
    "src/gpu/ganesh/glsl/GrGLSLVertexGeoBuilder.cpp",
    "src/gpu/ganesh/glsl/GrGLSLVertexGeoBuilder.h",
    "src/gpu/ganesh/gradients/GrGradientBitmapCache.cpp",
    "src/gpu/ganesh/gradients/GrGradientBitmapCache.h",
    "src/gpu/ganesh/gradients/GrGradientShader.cpp",
    "src/gpu/ganesh/gradients/GrGradientShader.h",
    "src/gpu/ganesh/image/GrImageUtils.cpp",
    "src/gpu/ganesh/image/GrImageUtils.h",
    "src/gpu/ganesh/image/GrTextureGenerator.cpp",
    "src/gpu/ganesh/image/SkImage_Ganesh.cpp",
    "src/gpu/ganesh/image/SkImage_Ganesh.h",
    "src/gpu/ganesh/image/SkImage_GaneshBase.cpp",
    "src/gpu/ganesh/image/SkImage_GaneshBase.h",
    "src/gpu/ganesh/image/SkImage_GaneshFactories.cpp",
    "src/gpu/ganesh/image/SkImage_GaneshYUVA.cpp",
    "src/gpu/ganesh/image/SkImage_GaneshYUVA.h",
    "src/gpu/ganesh/image/SkImage_LazyTexture.cpp",
    "src/gpu/ganesh/image/SkImage_LazyTexture.h",
    "src/gpu/ganesh/image/SkImage_RasterPinnable.cpp",
    "src/gpu/ganesh/image/SkImage_RasterPinnable.h",
    "src/gpu/ganesh/mock/GrMockAttachment.h",
    "src/gpu/ganesh/mock/GrMockBuffer.h",
    "src/gpu/ganesh/mock/GrMockCaps.cpp",
    "src/gpu/ganesh/mock/GrMockCaps.h",
    "src/gpu/ganesh/mock/GrMockGpu.cpp",
    "src/gpu/ganesh/mock/GrMockGpu.h",
    "src/gpu/ganesh/mock/GrMockOpTarget.h",
    "src/gpu/ganesh/mock/GrMockOpsRenderPass.h",
    "src/gpu/ganesh/mock/GrMockRenderTask.h",
    "src/gpu/ganesh/mock/GrMockSurfaceProxy.h",
    "src/gpu/ganesh/mock/GrMockTexture.h",
    "src/gpu/ganesh/mock/GrMockTypes.cpp",
    "src/gpu/ganesh/ops/AAConvexPathRenderer.cpp",
    "src/gpu/ganesh/ops/AAConvexPathRenderer.h",
    "src/gpu/ganesh/ops/AAHairLinePathRenderer.cpp",
    "src/gpu/ganesh/ops/AAHairLinePathRenderer.h",
    "src/gpu/ganesh/ops/AALinearizingConvexPathRenderer.cpp",
    "src/gpu/ganesh/ops/AALinearizingConvexPathRenderer.h",
    "src/gpu/ganesh/ops/AtlasInstancedHelper.cpp",
    "src/gpu/ganesh/ops/AtlasInstancedHelper.h",
    "src/gpu/ganesh/ops/AtlasPathRenderer.cpp",
    "src/gpu/ganesh/ops/AtlasPathRenderer.h",
    "src/gpu/ganesh/ops/AtlasRenderTask.cpp",
    "src/gpu/ganesh/ops/AtlasRenderTask.h",
    "src/gpu/ganesh/ops/AtlasTextOp.cpp",
    "src/gpu/ganesh/ops/AtlasTextOp.h",
    "src/gpu/ganesh/ops/ClearOp.cpp",
    "src/gpu/ganesh/ops/ClearOp.h",
    "src/gpu/ganesh/ops/DashLinePathRenderer.cpp",
    "src/gpu/ganesh/ops/DashLinePathRenderer.h",
    "src/gpu/ganesh/ops/DashOp.cpp",
    "src/gpu/ganesh/ops/DashOp.h",
    "src/gpu/ganesh/ops/DefaultPathRenderer.cpp",
    "src/gpu/ganesh/ops/DefaultPathRenderer.h",
    "src/gpu/ganesh/ops/DrawAtlasOp.cpp",
    "src/gpu/ganesh/ops/DrawAtlasOp.h",
    "src/gpu/ganesh/ops/DrawAtlasPathOp.cpp",
    "src/gpu/ganesh/ops/DrawAtlasPathOp.h",
    "src/gpu/ganesh/ops/DrawMeshOp.cpp",
    "src/gpu/ganesh/ops/DrawMeshOp.h",
    "src/gpu/ganesh/ops/DrawableOp.cpp",
    "src/gpu/ganesh/ops/DrawableOp.h",
    "src/gpu/ganesh/ops/FillPathFlags.h",
    "src/gpu/ganesh/ops/FillRRectOp.cpp",
    "src/gpu/ganesh/ops/FillRRectOp.h",
    "src/gpu/ganesh/ops/FillRectOp.cpp",
    "src/gpu/ganesh/ops/FillRectOp.h",
    "src/gpu/ganesh/ops/GrDrawOp.h",
    "src/gpu/ganesh/ops/GrMeshDrawOp.cpp",
    "src/gpu/ganesh/ops/GrMeshDrawOp.h",
    "src/gpu/ganesh/ops/GrOp.cpp",
    "src/gpu/ganesh/ops/GrOp.h",
    "src/gpu/ganesh/ops/GrOvalOpFactory.cpp",
    "src/gpu/ganesh/ops/GrOvalOpFactory.h",
    "src/gpu/ganesh/ops/GrPathStencilSettings.h",
    "src/gpu/ganesh/ops/GrSimpleMeshDrawOpHelper.cpp",
    "src/gpu/ganesh/ops/GrSimpleMeshDrawOpHelper.h",
    "src/gpu/ganesh/ops/GrSimpleMeshDrawOpHelperWithStencil.cpp",
    "src/gpu/ganesh/ops/GrSimpleMeshDrawOpHelperWithStencil.h",
    "src/gpu/ganesh/ops/LatticeOp.cpp",
    "src/gpu/ganesh/ops/LatticeOp.h",
    "src/gpu/ganesh/ops/OpsTask.cpp",
    "src/gpu/ganesh/ops/OpsTask.h",
    "src/gpu/ganesh/ops/PathInnerTriangulateOp.cpp",
    "src/gpu/ganesh/ops/PathInnerTriangulateOp.h",
    "src/gpu/ganesh/ops/PathStencilCoverOp.cpp",
    "src/gpu/ganesh/ops/PathStencilCoverOp.h",
    "src/gpu/ganesh/ops/PathTessellateOp.cpp",
    "src/gpu/ganesh/ops/PathTessellateOp.h",
    "src/gpu/ganesh/ops/QuadPerEdgeAA.cpp",
    "src/gpu/ganesh/ops/QuadPerEdgeAA.h",
    "src/gpu/ganesh/ops/RegionOp.cpp",
    "src/gpu/ganesh/ops/RegionOp.h",
    "src/gpu/ganesh/ops/ShadowRRectOp.cpp",
    "src/gpu/ganesh/ops/ShadowRRectOp.h",
    "src/gpu/ganesh/ops/SmallPathAtlasMgr.cpp",
    "src/gpu/ganesh/ops/SmallPathAtlasMgr.h",
    "src/gpu/ganesh/ops/SmallPathRenderer.cpp",
    "src/gpu/ganesh/ops/SmallPathRenderer.h",
    "src/gpu/ganesh/ops/SmallPathShapeData.cpp",
    "src/gpu/ganesh/ops/SmallPathShapeData.h",
    "src/gpu/ganesh/ops/SoftwarePathRenderer.cpp",
    "src/gpu/ganesh/ops/SoftwarePathRenderer.h",
    "src/gpu/ganesh/ops/StrokeRectOp.cpp",
    "src/gpu/ganesh/ops/StrokeRectOp.h",
    "src/gpu/ganesh/ops/StrokeTessellateOp.cpp",
    "src/gpu/ganesh/ops/StrokeTessellateOp.h",
    "src/gpu/ganesh/ops/TessellationPathRenderer.cpp",
    "src/gpu/ganesh/ops/TessellationPathRenderer.h",
    "src/gpu/ganesh/ops/TextureOp.cpp",
    "src/gpu/ganesh/ops/TextureOp.h",
    "src/gpu/ganesh/ops/TriangulatingPathRenderer.cpp",
    "src/gpu/ganesh/ops/TriangulatingPathRenderer.h",
    "src/gpu/ganesh/surface/SkSurface_Ganesh.cpp",
    "src/gpu/ganesh/surface/SkSurface_Ganesh.h",
    "src/gpu/ganesh/tessellate/GrPathTessellationShader.cpp",
    "src/gpu/ganesh/tessellate/GrPathTessellationShader.h",
    "src/gpu/ganesh/tessellate/GrStrokeTessellationShader.cpp",
    "src/gpu/ganesh/tessellate/GrStrokeTessellationShader.h",
    "src/gpu/ganesh/tessellate/GrTessellationShader.cpp",
    "src/gpu/ganesh/tessellate/GrTessellationShader.h",
    "src/gpu/ganesh/tessellate/PathTessellator.cpp",
    "src/gpu/ganesh/tessellate/PathTessellator.h",
    "src/gpu/ganesh/tessellate/StrokeTessellator.cpp",
    "src/gpu/ganesh/tessellate/StrokeTessellator.h",
    "src/gpu/ganesh/tessellate/VertexChunkPatchAllocator.h",
    "src/gpu/ganesh/text/GrAtlasManager.cpp",
    "src/gpu/ganesh/text/GrAtlasManager.h",
    "src/gpu/tessellate/AffineMatrix.h",
    "src/gpu/tessellate/CullTest.h",
    "src/gpu/tessellate/FixedCountBufferUtils.cpp",
    "src/gpu/tessellate/FixedCountBufferUtils.h",
    "src/gpu/tessellate/LinearTolerances.h",
    "src/gpu/tessellate/MiddleOutPolygonTriangulator.h",
    "src/gpu/tessellate/MidpointContourParser.h",
    "src/gpu/tessellate/PatchWriter.h",
    "src/gpu/tessellate/StrokeIterator.h",
    "src/gpu/tessellate/Tessellation.cpp",
    "src/gpu/tessellate/Tessellation.h",
    "src/gpu/tessellate/WangsFormula.h",
    "src/image/SkImage.cpp",
    "src/image/SkImageGeneratorPriv.h",
    "src/image/SkImage_Base.cpp",
    "src/image/SkImage_Base.h",
    "src/image/SkImage_Lazy.cpp",
    "src/image/SkImage_Lazy.h",
    "src/image/SkImage_LazyFactories.cpp",
    "src/image/SkImage_Picture.cpp",
    "src/image/SkImage_Picture.h",
    "src/image/SkImage_Raster.cpp",
    "src/image/SkImage_Raster.h",
    "src/image/SkImage_RasterFactories.cpp",
    "src/image/SkPictureImageGenerator.cpp",
    "src/image/SkPictureImageGenerator.h",
    "src/image/SkRescaleAndReadPixels.cpp",
    "src/image/SkRescaleAndReadPixels.h",
    "src/image/SkSurface.cpp",
    "src/image/SkSurface_Base.cpp",
    "src/image/SkSurface_Base.h",
    "src/image/SkSurface_Null.cpp",
    "src/image/SkSurface_Raster.cpp",
    "src/image/SkSurface_Raster.h",
    "src/image/SkTiledImageUtils.cpp",
    "src/opts/SkBitmapProcState_opts.h",
    "src/opts/SkBlitMask_opts.h",
    "src/opts/SkBlitRow_opts.h",
    "src/opts/SkRasterPipeline_opts.h",
    "src/opts/SkSwizzler_opts.h",
    "src/opts/SkUtils_opts.h",
    "src/opts/SkVM_opts.h",
    "src/pathops/SkAddIntersections.cpp",
    "src/pathops/SkAddIntersections.h",
    "src/pathops/SkDConicLineIntersection.cpp",
    "src/pathops/SkDCubicLineIntersection.cpp",
    "src/pathops/SkDCubicToQuads.cpp",
    "src/pathops/SkDLineIntersection.cpp",
    "src/pathops/SkDQuadLineIntersection.cpp",
    "src/pathops/SkIntersectionHelper.h",
    "src/pathops/SkIntersections.cpp",
    "src/pathops/SkIntersections.h",
    "src/pathops/SkLineParameters.h",
    "src/pathops/SkOpAngle.cpp",
    "src/pathops/SkOpAngle.h",
    "src/pathops/SkOpBuilder.cpp",
    "src/pathops/SkOpCoincidence.cpp",
    "src/pathops/SkOpCoincidence.h",
    "src/pathops/SkOpContour.cpp",
    "src/pathops/SkOpContour.h",
    "src/pathops/SkOpCubicHull.cpp",
    "src/pathops/SkOpEdgeBuilder.cpp",
    "src/pathops/SkOpEdgeBuilder.h",
    "src/pathops/SkOpSegment.cpp",
    "src/pathops/SkOpSegment.h",
    "src/pathops/SkOpSpan.cpp",
    "src/pathops/SkOpSpan.h",
    "src/pathops/SkPathOpsAsWinding.cpp",
    "src/pathops/SkPathOpsBounds.h",
    "src/pathops/SkPathOpsCommon.cpp",
    "src/pathops/SkPathOpsCommon.h",
    "src/pathops/SkPathOpsConic.cpp",
    "src/pathops/SkPathOpsConic.h",
    "src/pathops/SkPathOpsCubic.cpp",
    "src/pathops/SkPathOpsCubic.h",
    "src/pathops/SkPathOpsCurve.cpp",
    "src/pathops/SkPathOpsCurve.h",
    "src/pathops/SkPathOpsDebug.cpp",
    "src/pathops/SkPathOpsDebug.h",
    "src/pathops/SkPathOpsLine.cpp",
    "src/pathops/SkPathOpsLine.h",
    "src/pathops/SkPathOpsOp.cpp",
    "src/pathops/SkPathOpsPoint.h",
    "src/pathops/SkPathOpsQuad.cpp",
    "src/pathops/SkPathOpsQuad.h",
    "src/pathops/SkPathOpsRect.cpp",
    "src/pathops/SkPathOpsRect.h",
    "src/pathops/SkPathOpsSimplify.cpp",
    "src/pathops/SkPathOpsTCurve.h",
    "src/pathops/SkPathOpsTSect.cpp",
    "src/pathops/SkPathOpsTSect.h",
    "src/pathops/SkPathOpsTightBounds.cpp",
    "src/pathops/SkPathOpsTypes.cpp",
    "src/pathops/SkPathOpsTypes.h",
    "src/pathops/SkPathOpsWinding.cpp",
    "src/pathops/SkPathWriter.cpp",
    "src/pathops/SkPathWriter.h",
    "src/pathops/SkReduceOrder.cpp",
    "src/pathops/SkReduceOrder.h",
    "src/pdf/SkBitmapKey.h",
    "src/pdf/SkClusterator.cpp",
    "src/pdf/SkClusterator.h",
    "src/pdf/SkDeflate.cpp",
    "src/pdf/SkDeflate.h",
    "src/pdf/SkJpegInfo.h",
    "src/pdf/SkJpegInfo_none.cpp",
    "src/pdf/SkKeyedImage.cpp",
    "src/pdf/SkKeyedImage.h",
    "src/pdf/SkPDFBitmap.cpp",
    "src/pdf/SkPDFBitmap.h",
    "src/pdf/SkPDFDevice.cpp",
    "src/pdf/SkPDFDevice.h",
    "src/pdf/SkPDFDocument.cpp",
    "src/pdf/SkPDFDocumentPriv.h",
    "src/pdf/SkPDFFont.cpp",
    "src/pdf/SkPDFFont.h",
    "src/pdf/SkPDFFormXObject.cpp",
    "src/pdf/SkPDFFormXObject.h",
    "src/pdf/SkPDFGlyphUse.h",
    "src/pdf/SkPDFGradientShader.cpp",
    "src/pdf/SkPDFGradientShader.h",
    "src/pdf/SkPDFGraphicStackState.cpp",
    "src/pdf/SkPDFGraphicStackState.h",
    "src/pdf/SkPDFGraphicState.cpp",
    "src/pdf/SkPDFGraphicState.h",
    "src/pdf/SkPDFMakeCIDGlyphWidthsArray.cpp",
    "src/pdf/SkPDFMakeCIDGlyphWidthsArray.h",
    "src/pdf/SkPDFMakeToUnicodeCmap.cpp",
    "src/pdf/SkPDFMakeToUnicodeCmap.h",
    "src/pdf/SkPDFMetadata.cpp",
    "src/pdf/SkPDFMetadata.h",
    "src/pdf/SkPDFResourceDict.cpp",
    "src/pdf/SkPDFResourceDict.h",
    "src/pdf/SkPDFShader.cpp",
    "src/pdf/SkPDFShader.h",
    "src/pdf/SkPDFSubsetFont.cpp",
    "src/pdf/SkPDFSubsetFont.h",
    "src/pdf/SkPDFTag.cpp",
    "src/pdf/SkPDFTag.h",
    "src/pdf/SkPDFType1Font.cpp",
    "src/pdf/SkPDFType1Font.h",
    "src/pdf/SkPDFTypes.cpp",
    "src/pdf/SkPDFTypes.h",
    "src/pdf/SkPDFUnion.h",
    "src/pdf/SkPDFUtils.cpp",
    "src/pdf/SkPDFUtils.h",
    "src/pdf/SkUUID.h",
    "src/sfnt/SkIBMFamilyClass.h",
    "src/sfnt/SkOTTableTypes.h",
    "src/sfnt/SkOTTable_EBDT.h",
    "src/sfnt/SkOTTable_EBLC.h",
    "src/sfnt/SkOTTable_EBSC.h",
    "src/sfnt/SkOTTable_OS_2.h",
    "src/sfnt/SkOTTable_OS_2_V0.h",
    "src/sfnt/SkOTTable_OS_2_V1.h",
    "src/sfnt/SkOTTable_OS_2_V2.h",
    "src/sfnt/SkOTTable_OS_2_V3.h",
    "src/sfnt/SkOTTable_OS_2_V4.h",
    "src/sfnt/SkOTTable_OS_2_VA.h",
    "src/sfnt/SkOTTable_fvar.h",
    "src/sfnt/SkOTTable_gasp.h",
    "src/sfnt/SkOTTable_glyf.h",
    "src/sfnt/SkOTTable_head.h",
    "src/sfnt/SkOTTable_hhea.h",
    "src/sfnt/SkOTTable_hmtx.h",
    "src/sfnt/SkOTTable_loca.h",
    "src/sfnt/SkOTTable_maxp.h",
    "src/sfnt/SkOTTable_maxp_CFF.h",
    "src/sfnt/SkOTTable_maxp_TT.h",
    "src/sfnt/SkOTTable_name.cpp",
    "src/sfnt/SkOTTable_name.h",
    "src/sfnt/SkOTTable_post.h",
    "src/sfnt/SkOTUtils.cpp",
    "src/sfnt/SkOTUtils.h",
    "src/sfnt/SkPanose.h",
    "src/sfnt/SkSFNTHeader.h",
    "src/sfnt/SkTTCFHeader.h",
    "src/shaders/SkBlendShader.cpp",
    "src/shaders/SkBlendShader.h",
    "src/shaders/SkColorFilterShader.cpp",
    "src/shaders/SkColorFilterShader.h",
    "src/shaders/SkColorShader.cpp",
    "src/shaders/SkColorShader.h",
    "src/shaders/SkCoordClampShader.cpp",
    "src/shaders/SkCoordClampShader.h",
    "src/shaders/SkEmptyShader.cpp",
    "src/shaders/SkEmptyShader.h",
    "src/shaders/SkGainmapShader.cpp",
    "src/shaders/SkImageShader.cpp",
    "src/shaders/SkImageShader.h",
    "src/shaders/SkLocalMatrixShader.cpp",
    "src/shaders/SkLocalMatrixShader.h",
    "src/shaders/SkPerlinNoiseShaderImpl.cpp",
    "src/shaders/SkPerlinNoiseShaderImpl.h",
    "src/shaders/SkPictureShader.cpp",
    "src/shaders/SkPictureShader.h",
    "src/shaders/SkRuntimeShader.cpp",
    "src/shaders/SkRuntimeShader.h",
    "src/shaders/SkShaderBase.cpp",
    "src/shaders/SkShaderBase.h",
    "src/shaders/SkShader.cpp",
    "src/shaders/SkTransformShader.cpp",
    "src/shaders/SkTransformShader.h",
    "src/shaders/SkTriColorShader.cpp",
    "src/shaders/SkTriColorShader.h",
    "src/shaders/gradients/SkConicalGradient.cpp",
    "src/shaders/gradients/SkConicalGradient.h",
    "src/shaders/gradients/SkGradientBaseShader.cpp",
    "src/shaders/gradients/SkGradientBaseShader.h",
    "src/shaders/gradients/SkLinearGradient.cpp",
    "src/shaders/gradients/SkLinearGradient.h",
    "src/shaders/gradients/SkRadialGradient.cpp",
    "src/shaders/gradients/SkRadialGradient.h",
    "src/shaders/gradients/SkSweepGradient.cpp",
    "src/shaders/gradients/SkSweepGradient.h",
    "src/sksl/GLSL.std.450.h",
    "src/sksl/SkSLAnalysis.cpp",
    "src/sksl/SkSLAnalysis.h",
    "src/sksl/SkSLBuiltinTypes.cpp",
    "src/sksl/SkSLBuiltinTypes.h",
    "src/sksl/SkSLCompiler.cpp",
    "src/sksl/SkSLCompiler.h",
    "src/sksl/SkSLConstantFolder.cpp",
    "src/sksl/SkSLConstantFolder.h",
    "src/sksl/SkSLContext.cpp",
    "src/sksl/SkSLContext.h",
    "src/sksl/SkSLErrorReporter.cpp",
    "src/sksl/SkSLErrorReporter.h",
    "src/sksl/SkSLFileOutputStream.h",
    "src/sksl/SkSLGLSL.h",
    "src/sksl/SkSLInliner.cpp",
    "src/sksl/SkSLInliner.h",
    "src/sksl/SkSLIntrinsicList.cpp",
    "src/sksl/SkSLIntrinsicList.h",
    "src/sksl/SkSLLexer.cpp",
    "src/sksl/SkSLLexer.h",
    "src/sksl/SkSLMangler.cpp",
    "src/sksl/SkSLMangler.h",
    "src/sksl/SkSLMemoryLayout.h",
    "src/sksl/SkSLMemoryPool.h",
    "src/sksl/SkSLModifiersPool.h",
    "src/sksl/SkSLModuleLoader.cpp",
    "src/sksl/SkSLModuleLoader.h",
    "src/sksl/SkSLOperator.cpp",
    "src/sksl/SkSLOperator.h",
    "src/sksl/SkSLOutputStream.cpp",
    "src/sksl/SkSLOutputStream.h",
    "src/sksl/SkSLParser.cpp",
    "src/sksl/SkSLParser.h",
    "src/sksl/SkSLPool.cpp",
    "src/sksl/SkSLPool.h",
    "src/sksl/SkSLPosition.cpp",
    "src/sksl/SkSLPosition.h",
    "src/sksl/SkSLProgramKind.h",
    "src/sksl/SkSLProgramSettings.h",
    "src/sksl/SkSLSampleUsage.cpp",
    "src/sksl/SkSLString.cpp",
    "src/sksl/SkSLString.h",
    "src/sksl/SkSLStringStream.h",
    "src/sksl/SkSLThreadContext.cpp",
    "src/sksl/SkSLThreadContext.h",
    "src/sksl/SkSLUtil.cpp",
    "src/sksl/SkSLUtil.h",
    "src/sksl/analysis/SkSLCanExitWithoutReturningValue.cpp",
    "src/sksl/analysis/SkSLCheckProgramStructure.cpp",
    "src/sksl/analysis/SkSLFinalizationChecks.cpp",
    "src/sksl/analysis/SkSLGetLoopControlFlowInfo.cpp",
    "src/sksl/analysis/SkSLGetLoopUnrollInfo.cpp",
    "src/sksl/analysis/SkSLGetReturnComplexity.cpp",
    "src/sksl/analysis/SkSLHasSideEffects.cpp",
    "src/sksl/analysis/SkSLIsConstantExpression.cpp",
    "src/sksl/analysis/SkSLIsDynamicallyUniformExpression.cpp",
    "src/sksl/analysis/SkSLIsSameExpressionTree.cpp",
    "src/sksl/analysis/SkSLIsTrivialExpression.cpp",
    "src/sksl/analysis/SkSLNoOpErrorReporter.h",
    "src/sksl/analysis/SkSLProgramUsage.cpp",
    "src/sksl/analysis/SkSLProgramUsage.h",
    "src/sksl/analysis/SkSLProgramVisitor.h",
    "src/sksl/analysis/SkSLReturnsInputAlpha.cpp",
    "src/sksl/analysis/SkSLSwitchCaseContainsExit.cpp",
    "src/sksl/analysis/SkSLSymbolTableStackBuilder.cpp",
    "src/sksl/codegen/SkSLCodeGenerator.h",
    "src/sksl/codegen/SkSLGLSLCodeGenerator.cpp",
    "src/sksl/codegen/SkSLGLSLCodeGenerator.h",
    "src/sksl/codegen/SkSLMetalCodeGenerator.cpp",
    "src/sksl/codegen/SkSLMetalCodeGenerator.h",
    "src/sksl/codegen/SkSLPipelineStageCodeGenerator.cpp",
    "src/sksl/codegen/SkSLPipelineStageCodeGenerator.h",
    "src/sksl/codegen/SkSLRasterPipelineCodeGenerator.cpp",
    "src/sksl/codegen/SkSLRasterPipelineCodeGenerator.h",
    "src/sksl/codegen/SkSLSPIRVCodeGenerator.cpp",
    "src/sksl/codegen/SkSLSPIRVCodeGenerator.h",
    "src/sksl/codegen/SkSLSPIRVtoHLSL.cpp",
    "src/sksl/codegen/SkSLSPIRVtoHLSL.h",
    "src/sksl/codegen/SkSLRasterPipelineBuilder.cpp",
    "src/sksl/codegen/SkSLRasterPipelineBuilder.h",
    "src/sksl/codegen/SkSLVMCodeGenerator.cpp",
    "src/sksl/codegen/SkSLVMCodeGenerator.h",
    "src/sksl/codegen/SkSLWGSLCodeGenerator.cpp",
    "src/sksl/codegen/SkSLWGSLCodeGenerator.h",
    "src/sksl/dsl/DSLExpression.cpp",
    "src/sksl/dsl/DSLExpression.h",
    "src/sksl/dsl/DSLModifiers.h",
    "src/sksl/dsl/DSLStatement.cpp",
    "src/sksl/dsl/DSLStatement.h",
    "src/sksl/dsl/DSLType.cpp",
    "src/sksl/dsl/DSLType.h",
    "src/sksl/ir/SkSLBinaryExpression.cpp",
    "src/sksl/ir/SkSLBinaryExpression.h",
    "src/sksl/ir/SkSLBlock.cpp",
    "src/sksl/ir/SkSLBlock.h",
    "src/sksl/ir/SkSLBreakStatement.h",
    "src/sksl/ir/SkSLChildCall.cpp",
    "src/sksl/ir/SkSLChildCall.h",
    "src/sksl/ir/SkSLConstructor.cpp",
    "src/sksl/ir/SkSLConstructor.h",
    "src/sksl/ir/SkSLConstructorArray.cpp",
    "src/sksl/ir/SkSLConstructorArray.h",
    "src/sksl/ir/SkSLConstructorArrayCast.cpp",
    "src/sksl/ir/SkSLConstructorArrayCast.h",
    "src/sksl/ir/SkSLConstructorCompound.cpp",
    "src/sksl/ir/SkSLConstructorCompound.h",
    "src/sksl/ir/SkSLConstructorCompoundCast.cpp",
    "src/sksl/ir/SkSLConstructorCompoundCast.h",
    "src/sksl/ir/SkSLConstructorDiagonalMatrix.cpp",
    "src/sksl/ir/SkSLConstructorDiagonalMatrix.h",
    "src/sksl/ir/SkSLConstructorMatrixResize.cpp",
    "src/sksl/ir/SkSLConstructorMatrixResize.h",
    "src/sksl/ir/SkSLConstructorScalarCast.cpp",
    "src/sksl/ir/SkSLConstructorScalarCast.h",
    "src/sksl/ir/SkSLConstructorSplat.cpp",
    "src/sksl/ir/SkSLConstructorSplat.h",
    "src/sksl/ir/SkSLConstructorStruct.cpp",
    "src/sksl/ir/SkSLConstructorStruct.h",
    "src/sksl/ir/SkSLContinueStatement.h",
    "src/sksl/ir/SkSLDiscardStatement.cpp",
    "src/sksl/ir/SkSLDiscardStatement.h",
    "src/sksl/ir/SkSLDoStatement.cpp",
    "src/sksl/ir/SkSLDoStatement.h",
    "src/sksl/ir/SkSLExpression.cpp",
    "src/sksl/ir/SkSLExpression.h",
    "src/sksl/ir/SkSLExpressionStatement.cpp",
    "src/sksl/ir/SkSLExpressionStatement.h",
    "src/sksl/ir/SkSLExtension.cpp",
    "src/sksl/ir/SkSLExtension.h",
    "src/sksl/ir/SkSLFieldAccess.cpp",
    "src/sksl/ir/SkSLFieldAccess.h",
    "src/sksl/ir/SkSLFieldSymbol.h",
    "src/sksl/ir/SkSLForStatement.cpp",
    "src/sksl/ir/SkSLForStatement.h",
    "src/sksl/ir/SkSLFunctionCall.cpp",
    "src/sksl/ir/SkSLFunctionCall.h",
    "src/sksl/ir/SkSLFunctionDeclaration.cpp",
    "src/sksl/ir/SkSLFunctionDeclaration.h",
    "src/sksl/ir/SkSLFunctionDefinition.cpp",
    "src/sksl/ir/SkSLFunctionDefinition.h",
    "src/sksl/ir/SkSLFunctionPrototype.h",
    "src/sksl/ir/SkSLFunctionReference.h",
    "src/sksl/ir/SkSLIfStatement.cpp",
    "src/sksl/ir/SkSLIfStatement.h",
    "src/sksl/ir/SkSLIndexExpression.cpp",
    "src/sksl/ir/SkSLIndexExpression.h",
    "src/sksl/ir/SkSLInterfaceBlock.cpp",
    "src/sksl/ir/SkSLInterfaceBlock.h",
    "src/sksl/ir/SkSLIRHelpers.h",
    "src/sksl/ir/SkSLIRNode.h",
    "src/sksl/ir/SkSLLayout.cpp",
    "src/sksl/ir/SkSLLayout.h",
    "src/sksl/ir/SkSLLiteral.cpp",
    "src/sksl/ir/SkSLLiteral.h",
    "src/sksl/ir/SkSLMethodReference.h",
    "src/sksl/ir/SkSLModifiers.cpp",
    "src/sksl/ir/SkSLModifiers.h",
    "src/sksl/ir/SkSLModifiersDeclaration.cpp",
    "src/sksl/ir/SkSLModifiersDeclaration.h",
    "src/sksl/ir/SkSLNop.h",
    "src/sksl/ir/SkSLPoison.h",
    "src/sksl/ir/SkSLPostfixExpression.cpp",
    "src/sksl/ir/SkSLPostfixExpression.h",
    "src/sksl/ir/SkSLPrefixExpression.cpp",
    "src/sksl/ir/SkSLPrefixExpression.h",
    "src/sksl/ir/SkSLProgram.cpp",
    "src/sksl/ir/SkSLProgram.h",
    "src/sksl/ir/SkSLProgramElement.h",
    "src/sksl/ir/SkSLReturnStatement.h",
    "src/sksl/ir/SkSLSetting.cpp",
    "src/sksl/ir/SkSLSetting.h",
    "src/sksl/ir/SkSLStatement.h",
    "src/sksl/ir/SkSLStructDefinition.cpp",
    "src/sksl/ir/SkSLStructDefinition.h",
    "src/sksl/ir/SkSLSwitchCase.cpp",
    "src/sksl/ir/SkSLSwitchCase.h",
    "src/sksl/ir/SkSLSwitchStatement.cpp",
    "src/sksl/ir/SkSLSwitchStatement.h",
    "src/sksl/ir/SkSLSwizzle.cpp",
    "src/sksl/ir/SkSLSwizzle.h",
    "src/sksl/ir/SkSLSymbol.h",
    "src/sksl/ir/SkSLSymbolTable.cpp",
    "src/sksl/ir/SkSLSymbolTable.h",
    "src/sksl/ir/SkSLTernaryExpression.cpp",
    "src/sksl/ir/SkSLTernaryExpression.h",
    "src/sksl/ir/SkSLType.cpp",
    "src/sksl/ir/SkSLType.h",
    "src/sksl/ir/SkSLTypeReference.cpp",
    "src/sksl/ir/SkSLTypeReference.h",
    "src/sksl/ir/SkSLVarDeclarations.cpp",
    "src/sksl/ir/SkSLVarDeclarations.h",
    "src/sksl/ir/SkSLVariable.cpp",
    "src/sksl/ir/SkSLVariable.h",
    "src/sksl/ir/SkSLVariableReference.cpp",
    "src/sksl/ir/SkSLVariableReference.h",
    # We do not include src/sksl/lex/* because that is only needed to regenerate the lexer.
    "src/sksl/spirv.h",
    "src/sksl/tracing/SkSLTraceHook.cpp",
    "src/sksl/tracing/SkSLTraceHook.h",
    "src/sksl/tracing/SkSLDebugTracePriv.cpp",
    "src/sksl/tracing/SkSLDebugTracePriv.h",
    "src/sksl/tracing/SkSLDebugTracePlayer.cpp",
    "src/sksl/tracing/SkSLDebugTracePlayer.h",
    "src/sksl/transform/SkSLAddConstToVarModifiers.cpp",
    "src/sksl/transform/SkSLEliminateDeadFunctions.cpp",
    "src/sksl/transform/SkSLEliminateDeadGlobalVariables.cpp",
    "src/sksl/transform/SkSLEliminateDeadLocalVariables.cpp",
    "src/sksl/transform/SkSLEliminateEmptyStatements.cpp",
    "src/sksl/transform/SkSLEliminateUnreachableCode.cpp",
    "src/sksl/transform/SkSLFindAndDeclareBuiltinFunctions.cpp",
    "src/sksl/transform/SkSLFindAndDeclareBuiltinVariables.cpp",
    "src/sksl/transform/SkSLHoistSwitchVarDeclarationsAtTopLevel.cpp",
    "src/sksl/transform/SkSLProgramWriter.h",
    "src/sksl/transform/SkSLRenamePrivateSymbols.cpp",
    "src/sksl/transform/SkSLReplaceConstVarsWithLiterals.cpp",
    "src/sksl/transform/SkSLRewriteIndexedSwizzle.cpp",
    "src/sksl/transform/SkSLTransform.h",
    "src/text/GlyphRun.cpp",
    "src/text/GlyphRun.h",
    "src/text/gpu/DistanceFieldAdjustTable.cpp",
    "src/text/gpu/DistanceFieldAdjustTable.h",
    "src/text/gpu/Glyph.h",
    "src/text/gpu/GlyphVector.cpp",
    "src/text/gpu/GlyphVector.h",
    "src/text/gpu/SDFMaskFilter.cpp",
    "src/text/gpu/SDFMaskFilter.h",
    "src/text/gpu/SDFTControl.cpp",
    "src/text/gpu/SDFTControl.h",
    "src/text/gpu/Slug.cpp",
    "src/text/gpu/SlugImpl.cpp",
    "src/text/gpu/SlugImpl.h",
    "src/text/gpu/StrikeCache.cpp",
    "src/text/gpu/StrikeCache.h",
    "src/text/gpu/SubRunAllocator.cpp",
    "src/text/gpu/SubRunAllocator.h",
    "src/text/gpu/SubRunContainer.cpp",
    "src/text/gpu/SubRunContainer.h",
    "src/text/gpu/TextBlob.cpp",
    "src/text/gpu/TextBlob.h",
    "src/text/gpu/TextBlobRedrawCoordinator.cpp",
    "src/text/gpu/TextBlobRedrawCoordinator.h",
    "src/text/gpu/VertexFiller.cpp",
    "src/text/gpu/VertexFiller.h",
    "src/text/StrikeForGPU.cpp",
    "src/text/StrikeForGPU.h",
    "src/utils/SkAnimCodecPlayer.cpp",
    "src/utils/SkBase64.cpp",
    "src/utils/SkBitSet.h",
    "src/utils/SkCallableTraits.h",
    "src/utils/SkCanvasStack.cpp",
    "src/utils/SkCanvasStack.h",
    "src/utils/SkCanvasStateUtils.cpp",
    "src/utils/SkCharToGlyphCache.cpp",
    "src/utils/SkCharToGlyphCache.h",
    "src/utils/SkClipStackUtils.cpp",
    "src/utils/SkClipStackUtils.h",
    "src/utils/SkCustomTypeface.cpp",
    "src/utils/SkDashPath.cpp",
    "src/utils/SkDashPathPriv.h",
    "src/utils/SkEventTracer.cpp",
    "src/utils/SkFloatToDecimal.cpp",
    "src/utils/SkFloatToDecimal.h",
    "src/utils/SkFloatUtils.h",
    "src/utils/SkJSON.cpp",
    "src/utils/SkJSON.h",
    "src/utils/SkJSONWriter.cpp",
    "src/utils/SkJSONWriter.h",
    "src/utils/SkMatrix22.cpp",
    "src/utils/SkMatrix22.h",
    "src/utils/SkMultiPictureDocument.cpp",
    "src/utils/SkMultiPictureDocument.h",
    "src/utils/SkMultiPictureDocumentPriv.h",
    "src/utils/SkNullCanvas.cpp",
    "src/utils/SkNWayCanvas.cpp",
    "src/utils/SkOrderedFontMgr.cpp",
    "src/utils/SkOSPath.cpp",
    "src/utils/SkOSPath.h",
    "src/utils/SkPaintFilterCanvas.cpp",
    "src/utils/SkParse.cpp",
    "src/utils/SkParseColor.cpp",
    "src/utils/SkParsePath.cpp",
    "src/utils/SkPatchUtils.cpp",
    "src/utils/SkPatchUtils.h",
    "src/utils/SkPolyUtils.cpp",
    "src/utils/SkPolyUtils.h",
    "src/utils/SkShaderUtils.cpp",
    "src/utils/SkShaderUtils.h",
    "src/utils/SkShadowTessellator.cpp",
    "src/utils/SkShadowTessellator.h",
    "src/utils/SkShadowUtils.cpp",
    "src/utils/SkTestCanvas.h",
    "src/utils/SkTextUtils.cpp",
    "src/xps/SkXPSDevice.cpp",
    "src/xps/SkXPSDevice.h",
    "src/xps/SkXPSDocument.cpp",
]

ENCODE_SRCS = [
    "src/encode/SkEncoder.cpp",
    "src/encode/SkICCPriv.h",
    "src/encode/SkICC.cpp",
    "src/encode/SkImageEncoderFns.h",
    "src/encode/SkImageEncoderPriv.h",
]

ENCODE_JPEG_SRCS = [
    "src/encode/SkJpegEncoderImpl.h",
    "src/encode/SkJpegEncoderImpl.cpp",
    "src/encode/SkJPEGWriteUtility.cpp",
    "src/encode/SkJPEGWriteUtility.h",
]

NO_ENCODE_JPEG_SRCS = [
    "src/encode/SkJpegEncoder_none.cpp",
]

ENCODE_PNG_SRCS = [
    "src/encode/SkPngEncoderImpl.cpp",
    "src/encode/SkPngEncoderImpl.h",
]

NO_ENCODE_PNG_SRCS = [
    "src/encode/SkPngEncoder_none.cpp",
]

ENCODE_WEBP_SRCS = [
    "src/encode/SkWebpEncoderImpl.cpp",
]

NO_ENCODE_WEBP_SRCS = [
    "src/encode/SkWebpEncoder_none.cpp",
]

CODEC_SRCS_LIMITED = [
    "src/codec/SkAndroidCodec.cpp",
    "src/codec/SkAndroidCodecAdapter.cpp",
    "src/codec/SkAndroidCodecAdapter.h",
    "src/codec/SkBmpBaseCodec.cpp",
    "src/codec/SkBmpBaseCodec.h",
    "src/codec/SkBmpCodec.cpp",
    "src/codec/SkBmpCodec.h",
    "src/codec/SkBmpMaskCodec.cpp",
    "src/codec/SkBmpMaskCodec.h",
    "src/codec/SkBmpRLECodec.cpp",
    "src/codec/SkBmpRLECodec.h",
    "src/codec/SkBmpStandardCodec.cpp",
    "src/codec/SkBmpStandardCodec.h",
    "src/codec/SkCodec.cpp",
    "src/codec/SkCodecImageGenerator.cpp",
    "src/codec/SkCodecImageGenerator.h",
    "src/codec/SkCodecPriv.h",
    "src/codec/SkColorPalette.cpp",
    "src/codec/SkColorPalette.h",
    "src/codec/SkEncodedInfo.cpp",
    "src/codec/SkFrameHolder.h",
    "src/codec/SkJpegCodec.cpp",
    "src/codec/SkJpegCodec.h",
    "src/codec/SkJpegDecoderMgr.cpp",
    "src/codec/SkJpegDecoderMgr.h",
    "src/codec/SkJpegPriv.h",
    "src/codec/SkJpegSourceMgr.cpp",
    "src/codec/SkJpegSourceMgr.h",
    "src/codec/SkJpegUtility.cpp",
    "src/codec/SkJpegUtility.h",
    "src/codec/SkMasks.cpp",
    "src/codec/SkMasks.h",
    "src/codec/SkMaskSwizzler.cpp",
    "src/codec/SkMaskSwizzler.h",
    "src/codec/SkParseEncodedOrigin.cpp",
    "src/codec/SkParseEncodedOrigin.h",
    "src/codec/SkPngPriv.h",
    "src/codec/SkSampledCodec.cpp",
    "src/codec/SkSampledCodec.h",
    "src/codec/SkScalingCodec.h",
    "src/codec/SkSampler.cpp",
    "src/codec/SkSampler.h",
    "src/codec/SkSwizzler.cpp",
    "src/codec/SkSwizzler.h",
    "src/codec/SkWbmpCodec.cpp",
    "src/codec/SkWbmpCodec.h",
    "src/codec/SkWuffsCodec.cpp",
    "src/codec/SkWuffsCodec.h",
]

CODEC_SRCS_ALL = CODEC_SRCS_LIMITED + [
    "src/codec/SkIcoCodec.cpp",
    "src/codec/SkIcoCodec.h",
    "src/codec/SkPngCodec.cpp",
    "src/codec/SkPngCodec.h",
    "src/codec/SkWebpCodec.cpp",
    "src/codec/SkWebpCodec.h",
]

TEXTUAL_HDRS = [
    "src/sksl/generated/sksl_compute.minified.sksl",
    "src/sksl/generated/sksl_compute.unoptimized.sksl",
    "src/sksl/generated/sksl_frag.minified.sksl",
    "src/sksl/generated/sksl_frag.unoptimized.sksl",
    "src/sksl/generated/sksl_gpu.minified.sksl",
    "src/sksl/generated/sksl_gpu.unoptimized.sksl",
    "src/sksl/generated/sksl_graphite_frag.minified.sksl",
    "src/sksl/generated/sksl_graphite_frag.unoptimized.sksl",
    "src/sksl/generated/sksl_graphite_vert.minified.sksl",
    "src/sksl/generated/sksl_graphite_vert.unoptimized.sksl",
    "src/sksl/generated/sksl_public.minified.sksl",
    "src/sksl/generated/sksl_public.unoptimized.sksl",
    "src/sksl/generated/sksl_rt_shader.minified.sksl",
    "src/sksl/generated/sksl_rt_shader.unoptimized.sksl",
    "src/sksl/generated/sksl_shared.minified.sksl",
    "src/sksl/generated/sksl_shared.unoptimized.sksl",
    "src/sksl/generated/sksl_vert.minified.sksl",
    "src/sksl/generated/sksl_vert.unoptimized.sksl",
    # Included by GrGLMakeNativeInterface_android.cpp
    "src/gpu/ganesh/gl/egl/GrGLMakeEGLInterface.cpp",
    "src/gpu/ganesh/gl/egl/GrGLMakeNativeInterface_egl.cpp",
]

base_gl_srcs = [
    "src/gpu/ganesh/gl/builders/GrGLProgramBuilder.cpp",
    "src/gpu/ganesh/gl/builders/GrGLProgramBuilder.h",
    "src/gpu/ganesh/gl/builders/GrGLShaderStringBuilder.cpp",
    "src/gpu/ganesh/gl/builders/GrGLShaderStringBuilder.h",
    "src/gpu/ganesh/gl/GrGLAssembleGLESInterfaceAutogen.cpp",
    "src/gpu/ganesh/gl/GrGLAssembleGLInterfaceAutogen.cpp",
    "src/gpu/ganesh/gl/GrGLAssembleHelpers.cpp",
    "src/gpu/ganesh/gl/GrGLAssembleInterface.cpp",
    "src/gpu/ganesh/gl/GrGLAssembleWebGLInterfaceAutogen.cpp",
    "src/gpu/ganesh/gl/GrGLAttachment.cpp",
    "src/gpu/ganesh/gl/GrGLAttachment.h",
    "src/gpu/ganesh/gl/GrGLBuffer.cpp",
    "src/gpu/ganesh/gl/GrGLBuffer.h",
    "src/gpu/ganesh/gl/GrGLCaps.cpp",
    "src/gpu/ganesh/gl/GrGLCaps.h",
    "src/gpu/ganesh/gl/GrGLContext.cpp",
    "src/gpu/ganesh/gl/GrGLContext.h",
    "src/gpu/ganesh/gl/GrGLDefines.h",
    "src/gpu/ganesh/gl/GrGLExtensions.cpp",
    "src/gpu/ganesh/gl/GrGLGLSL.cpp",
    "src/gpu/ganesh/gl/GrGLGLSL.h",
    "src/gpu/ganesh/gl/GrGLGpu.cpp",
    "src/gpu/ganesh/gl/GrGLGpu.h",
    "src/gpu/ganesh/gl/GrGLGpuProgramCache.cpp",
    "src/gpu/ganesh/gl/GrGLInterfaceAutogen.cpp",
    "src/gpu/ganesh/gl/GrGLOpsRenderPass.cpp",
    "src/gpu/ganesh/gl/GrGLOpsRenderPass.h",
    "src/gpu/ganesh/gl/GrGLProgram.cpp",
    "src/gpu/ganesh/gl/GrGLProgramDataManager.cpp",
    "src/gpu/ganesh/gl/GrGLProgramDataManager.h",
    "src/gpu/ganesh/gl/GrGLProgram.h",
    "src/gpu/ganesh/gl/GrGLRenderTarget.cpp",
    "src/gpu/ganesh/gl/GrGLRenderTarget.h",
    "src/gpu/ganesh/gl/GrGLSemaphore.cpp",
    "src/gpu/ganesh/gl/GrGLSemaphore.h",
    "src/gpu/ganesh/gl/GrGLTexture.cpp",
    "src/gpu/ganesh/gl/GrGLTexture.h",
    "src/gpu/ganesh/gl/GrGLTextureRenderTarget.cpp",
    "src/gpu/ganesh/gl/GrGLTextureRenderTarget.h",
    "src/gpu/ganesh/gl/GrGLTypesPriv.cpp",
    "src/gpu/ganesh/gl/GrGLUniformHandler.cpp",
    "src/gpu/ganesh/gl/GrGLUniformHandler.h",
    "src/gpu/ganesh/gl/GrGLUtil.cpp",
    "src/gpu/ganesh/gl/GrGLUtil.h",
    "src/gpu/ganesh/gl/GrGLVaryingHandler.h",
    "src/gpu/ganesh/gl/GrGLVertexArray.cpp",
    "src/gpu/ganesh/gl/GrGLVertexArray.h",
]

GL_SRCS_UNIX = base_gl_srcs + [
    "src/gpu/ganesh/gl/GrGLMakeNativeInterface_none.cpp",
]

GL_SRCS_UNIX_EGL = base_gl_srcs + [
    "src/gpu/ganesh/gl/egl/GrGLMakeEGLInterface.cpp",
    "src/gpu/ganesh/gl/egl/GrGLMakeNativeInterface_egl.cpp",
]

PORTS_SRCS_UNIX = [
    "src/ports/SkDebug_stdio.cpp",
    "src/ports/SkFontHost_FreeType_common.cpp",
    "src/ports/SkFontHost_FreeType_common.h",
    "src/ports/SkFontHost_FreeType.cpp",
    "src/ports/SkFontMgr_custom.cpp",
    "src/ports/SkFontMgr_custom_directory.cpp",
    "src/ports/SkFontMgr_custom_embedded.cpp",
    "src/ports/SkFontMgr_custom_empty.cpp",
    "src/ports/SkFontMgr_custom.h",
    "src/ports/SkFontMgr_fontconfig_factory.cpp",
    "src/ports/SkFontMgr_fontconfig.cpp",
    "src/ports/SkGlobalInitialization_default.cpp",
    "src/ports/SkImageGenerator_skia.cpp",
    "src/ports/SkMemory_malloc.cpp",
    "src/ports/SkOSFile_posix.cpp",
    "src/ports/SkOSFile_stdio.cpp",
    "src/ports/SkOSLibrary.h",
    "src/ports/SkOSLibrary_posix.cpp",
]

GL_SRCS_ANDROID = base_gl_srcs + [
    "src/gpu/ganesh/gl/android/GrGLMakeNativeInterface_android.cpp",
]

PORTS_SRCS_ANDROID = [
    "src/ports/SkDebug_android.cpp",
    "src/ports/SkFontHost_FreeType_common.cpp",
    "src/ports/SkFontHost_FreeType_common.h",
    "src/ports/SkFontHost_FreeType.cpp",
    "src/ports/SkFontMgr_android.cpp",
    "src/ports/SkFontMgr_android_factory.cpp",
    "src/ports/SkFontMgr_android_parser.cpp",
    "src/ports/SkFontMgr_android_parser.h",
    "src/ports/SkFontMgr_custom.cpp",
    "src/ports/SkFontMgr_custom_directory.cpp",
    "src/ports/SkFontMgr_custom_embedded.cpp",
    "src/ports/SkFontMgr_custom_empty.cpp",
    "src/ports/SkFontMgr_custom.h",
    "src/ports/SkGlobalInitialization_default.cpp",
    "src/ports/SkImageGenerator_skia.cpp",
    "src/ports/SkMemory_malloc.cpp",
    "src/ports/SkOSFile_posix.cpp",
    "src/ports/SkOSFile_stdio.cpp",
    "src/ports/SkOSLibrary.h",
    "src/ports/SkOSLibrary_posix.cpp",
]

PORTS_SRCS_ANDROID_NO_FONT = [
    "src/ports/SkDebug_android.cpp",
    "src/ports/SkFontMgr_empty_factory.cpp",
    "src/ports/SkGlobalInitialization_default.cpp",
    "src/ports/SkImageGenerator_skia.cpp",
    "src/ports/SkMemory_malloc.cpp",
    "src/ports/SkOSFile_posix.cpp",
    "src/ports/SkOSFile_stdio.cpp",
    "src/ports/SkOSLibrary.h",
    "src/ports/SkOSLibrary_posix.cpp",
]

GL_SRCS_IOS = base_gl_srcs + [
    "src/gpu/ganesh/gl/iOS/GrGLMakeNativeInterface_iOS.cpp",
]

PORTS_SRCS_IOS = [
    "src/ports/SkDebug_stdio.cpp",
    "src/ports/SkFontMgr_custom.h",
    "src/ports/SkFontMgr_mac_ct.cpp",
    "src/ports/SkFontMgr_mac_ct_factory.cpp",
    "src/ports/SkGlobalInitialization_default.cpp",
    "src/ports/SkImageGenerator_skia.cpp",
    "src/ports/SkImageGeneratorCG.cpp",
    "src/ports/SkMemory_malloc.cpp",
    "src/ports/SkOSFile_ios.h",
    "src/ports/SkOSFile_posix.cpp",
    "src/ports/SkOSFile_stdio.cpp",
    "src/ports/SkOSLibrary.h",
    "src/ports/SkOSLibrary_posix.cpp",
    "src/ports/SkScalerContext_mac_ct.cpp",
    "src/ports/SkScalerContext_mac_ct.h",
    "src/ports/SkTypeface_mac_ct.cpp",
    "src/ports/SkTypeface_mac_ct.h",
    "src/utils/mac/SkCGBase.h",
    "src/utils/mac/SkCGGeometry.h",
    "src/utils/mac/SkCreateCGImageRef.cpp",
    "src/utils/mac/SkCTFont.cpp",
    "src/utils/mac/SkCTFont.h",
    "src/utils/mac/SkUniqueCFRef.h",
]

PORTS_SRCS_FUCHSIA = [
    "src/ports/SkDebug_stdio.cpp",
    "src/ports/SkFontHost_FreeType_common.cpp",
    "src/ports/SkFontHost_FreeType_common.h",
    "src/ports/SkFontHost_FreeType.cpp",
    "src/ports/SkFontMgr_custom.cpp",
    "src/ports/SkFontMgr_custom.h",
    "src/ports/SkFontMgr_empty_factory.cpp",
    "src/ports/SkFontMgr_fuchsia.cpp",
    "src/ports/SkGlobalInitialization_default.cpp",
    "src/ports/SkImageGenerator_skia.cpp",
    "src/ports/SkMemory_malloc.cpp",
    "src/ports/SkOSFile_posix.cpp",
    "src/ports/SkOSFile_stdio.cpp",
    "src/ports/SkOSLibrary.h",
    "src/ports/SkOSLibrary_posix.cpp",
]

GL_SRCS_MACOS = base_gl_srcs + [
    "src/gpu/ganesh/gl/mac/GrGLMakeNativeInterface_mac.cpp",
]

PORTS_SRCS_MACOS = PORTS_SRCS_IOS

PORTS_SRCS_WASM = [
    "src/ports/SkDebug_stdio.cpp",
    "src/ports/SkFontHost_FreeType_common.cpp",
    "src/ports/SkFontHost_FreeType_common.h",
    "src/ports/SkFontHost_FreeType.cpp",
    "src/ports/SkFontMgr_custom.cpp",
    "src/ports/SkFontMgr_custom.h",
    "src/ports/SkFontMgr_custom_embedded.cpp",
    "src/ports/SkFontMgr_empty_factory.cpp",
    "src/ports/SkGlobalInitialization_default.cpp",
    "src/ports/SkImageGenerator_skia.cpp",
    "src/ports/SkMemory_malloc.cpp",
    "src/ports/SkOSFile_posix.cpp",
    "src/ports/SkOSFile_stdio.cpp",
    "src/ports/SkOSLibrary.h",
    "src/ports/SkOSLibrary_posix.cpp",
]
GL_SRCS_WASM = GL_SRCS_UNIX_EGL

MTL_HDRS = [
    "src/gpu/ganesh/mtl/GrMtlAttachment.h",
    "src/gpu/ganesh/mtl/GrMtlBuffer.h",
    "src/gpu/ganesh/mtl/GrMtlCaps.h",
    "src/gpu/ganesh/mtl/GrMtlCommandBuffer.h",
    "src/gpu/ganesh/mtl/GrMtlCppUtil.h",
    "src/gpu/ganesh/mtl/GrMtlDepthStencil.h",
    "src/gpu/ganesh/mtl/GrMtlFramebuffer.h",
    "src/gpu/ganesh/mtl/GrMtlGpu.h",
    "src/gpu/ganesh/mtl/GrMtlOpsRenderPass.h",
    "src/gpu/ganesh/mtl/GrMtlPipeline.h",
    "src/gpu/ganesh/mtl/GrMtlPipelineState.h",
    "src/gpu/ganesh/mtl/GrMtlPipelineStateBuilder.h",
    "src/gpu/ganesh/mtl/GrMtlPipelineStateDataManager.h",
    "src/gpu/ganesh/mtl/GrMtlRenderCommandEncoder.h",
    "src/gpu/ganesh/mtl/GrMtlRenderTarget.h",
    "src/gpu/ganesh/mtl/GrMtlResourceProvider.h",
    "src/gpu/ganesh/mtl/GrMtlSampler.h",
    "src/gpu/ganesh/mtl/GrMtlSemaphore.h",
    "src/gpu/ganesh/mtl/GrMtlTexture.h",
    "src/gpu/ganesh/mtl/GrMtlTextureRenderTarget.h",
    "src/gpu/ganesh/mtl/GrMtlTrampoline.h",
    "src/gpu/ganesh/mtl/GrMtlUniformHandler.h",
    "src/gpu/ganesh/mtl/GrMtlUtil.h",
    "src/gpu/ganesh/mtl/GrMtlVaryingHandler.h",
    "src/gpu/mtl/MtlMemoryAllocatorImpl.h",
]

MTL_SRCS = [
    "src/gpu/ganesh/mtl/GrMtlAttachment.mm",
    "src/gpu/ganesh/mtl/GrMtlBuffer.mm",
    "src/gpu/ganesh/mtl/GrMtlCaps.mm",
    "src/gpu/ganesh/mtl/GrMtlCommandBuffer.mm",
    "src/gpu/ganesh/mtl/GrMtlDepthStencil.mm",
    "src/gpu/ganesh/mtl/GrMtlFramebuffer.mm",
    "src/gpu/ganesh/mtl/GrMtlGpu.mm",
    "src/gpu/ganesh/mtl/GrMtlOpsRenderPass.mm",
    "src/gpu/ganesh/mtl/GrMtlPipelineState.mm",
    "src/gpu/ganesh/mtl/GrMtlPipelineStateBuilder.mm",
    "src/gpu/ganesh/mtl/GrMtlPipelineStateDataManager.mm",
    "src/gpu/ganesh/mtl/GrMtlRenderTarget.mm",
    "src/gpu/ganesh/mtl/GrMtlResourceProvider.mm",
    "src/gpu/ganesh/mtl/GrMtlSampler.mm",
    "src/gpu/ganesh/mtl/GrMtlSemaphore.mm",
    "src/gpu/ganesh/mtl/GrMtlTexture.mm",
    "src/gpu/ganesh/mtl/GrMtlTextureRenderTarget.mm",
    "src/gpu/ganesh/mtl/GrMtlTrampoline.mm",
    "src/gpu/ganesh/mtl/GrMtlTypesPriv.mm",
    "src/gpu/ganesh/mtl/GrMtlUniformHandler.mm",
    "src/gpu/ganesh/mtl/GrMtlUtil.mm",
    "src/gpu/ganesh/mtl/GrMtlVaryingHandler.mm",
    "src/gpu/ganesh/surface/SkSurface_GaneshMtl.mm",
    "src/gpu/mtl/MtlMemoryAllocatorImpl.mm",
    "src/gpu/mtl/MtlUtils.mm",
    "src/gpu/mtl/MtlUtilsPriv.h",
]

VULKAN_SRCS = [
    "src/gpu/ganesh/vk/GrVkBuffer.cpp",
    "src/gpu/ganesh/vk/GrVkBuffer.h",
    "src/gpu/ganesh/vk/GrVkCaps.cpp",
    "src/gpu/ganesh/vk/GrVkCaps.h",
    "src/gpu/ganesh/vk/GrVkCommandBuffer.cpp",
    "src/gpu/ganesh/vk/GrVkCommandBuffer.h",
    "src/gpu/ganesh/vk/GrVkCommandPool.cpp",
    "src/gpu/ganesh/vk/GrVkCommandPool.h",
    "src/gpu/ganesh/vk/GrVkDescriptorPool.cpp",
    "src/gpu/ganesh/vk/GrVkDescriptorPool.h",
    "src/gpu/ganesh/vk/GrVkDescriptorSet.cpp",
    "src/gpu/ganesh/vk/GrVkDescriptorSet.h",
    "src/gpu/ganesh/vk/GrVkDescriptorSetManager.cpp",
    "src/gpu/ganesh/vk/GrVkDescriptorSetManager.h",
    "src/gpu/ganesh/vk/GrVkFramebuffer.cpp",
    "src/gpu/ganesh/vk/GrVkFramebuffer.h",
    "src/gpu/ganesh/vk/GrVkGpu.cpp",
    "src/gpu/ganesh/vk/GrVkGpu.h",
    "src/gpu/ganesh/vk/GrVkImage.cpp",
    "src/gpu/ganesh/vk/GrVkImage.h",
    "src/gpu/ganesh/vk/GrVkImageLayout.h",
    "src/gpu/ganesh/vk/GrVkImageView.cpp",
    "src/gpu/ganesh/vk/GrVkImageView.h",
    "src/gpu/ganesh/vk/GrVkManagedResource.h",
    "src/gpu/ganesh/vk/GrVkMSAALoadManager.cpp",
    "src/gpu/ganesh/vk/GrVkMSAALoadManager.h",
    "src/gpu/ganesh/vk/GrVkOpsRenderPass.cpp",
    "src/gpu/ganesh/vk/GrVkOpsRenderPass.h",
    "src/gpu/ganesh/vk/GrVkPipeline.cpp",
    "src/gpu/ganesh/vk/GrVkPipeline.h",
    "src/gpu/ganesh/vk/GrVkPipelineStateBuilder.cpp",
    "src/gpu/ganesh/vk/GrVkPipelineStateBuilder.h",
    "src/gpu/ganesh/vk/GrVkPipelineStateCache.cpp",
    "src/gpu/ganesh/vk/GrVkPipelineState.cpp",
    "src/gpu/ganesh/vk/GrVkPipelineStateDataManager.cpp",
    "src/gpu/ganesh/vk/GrVkPipelineStateDataManager.h",
    "src/gpu/ganesh/vk/GrVkPipelineState.h",
    "src/gpu/ganesh/vk/GrVkRenderPass.cpp",
    "src/gpu/ganesh/vk/GrVkRenderPass.h",
    "src/gpu/ganesh/vk/GrVkRenderTarget.cpp",
    "src/gpu/ganesh/vk/GrVkRenderTarget.h",
    "src/gpu/ganesh/vk/GrVkResourceProvider.cpp",
    "src/gpu/ganesh/vk/GrVkResourceProvider.h",
    "src/gpu/ganesh/vk/GrVkSampler.cpp",
    "src/gpu/ganesh/vk/GrVkSampler.h",
    "src/gpu/ganesh/vk/GrVkSamplerYcbcrConversion.cpp",
    "src/gpu/ganesh/vk/GrVkSamplerYcbcrConversion.h",
    "src/gpu/ganesh/vk/GrVkSemaphore.cpp",
    "src/gpu/ganesh/vk/GrVkSemaphore.h",
    "src/gpu/ganesh/vk/GrVkTexture.cpp",
    "src/gpu/ganesh/vk/GrVkTexture.h",
    "src/gpu/ganesh/vk/GrVkTextureRenderTarget.cpp",
    "src/gpu/ganesh/vk/GrVkTextureRenderTarget.h",
    "src/gpu/ganesh/vk/GrVkTypesPriv.cpp",
    "src/gpu/ganesh/vk/GrVkUniformHandler.cpp",
    "src/gpu/ganesh/vk/GrVkUniformHandler.h",
    "src/gpu/ganesh/vk/GrVkUtil.cpp",
    "src/gpu/ganesh/vk/GrVkUtil.h",
    "src/gpu/ganesh/vk/GrVkVaryingHandler.cpp",
    "src/gpu/ganesh/vk/GrVkVaryingHandler.h",
    "src/gpu/vk/VulkanExtensions.cpp",
    "src/gpu/vk/VulkanInterface.cpp",
    "src/gpu/vk/VulkanInterface.h",
    "src/gpu/vk/VulkanMemory.cpp",
    "src/gpu/vk/VulkanMemory.h",
    "src/gpu/vk/VulkanUtilsPriv.h",
]

################################################################################
## DEFINES
################################################################################

BASE_DEFINES = [
    # Our legacy G3 rule *always* has the ganesh backend enabled.
    "SK_GANESH",
    # Chrome DEFINES.
    "SK_USE_FREETYPE_EMBOLDEN",
    # Turn on a few Google3-specific build fixes.
    "SK_BUILD_FOR_GOOGLE3",
    # Required for building dm.
    "GR_TEST_UTILS",
    # Should remove after we update golden images
    "SK_WEBP_ENCODER_USE_DEFAULT_METHOD",
    # Experiment to diagnose image diffs in Google3
    "SK_DISABLE_LOWP_RASTER_PIPELINE",

    # JPEG is in codec_limited and is included in all
    # builds except the no_codec android build
]
UNIX_DEFINES = [
    "PNG_SKIP_SETJMP_CHECK",
    "SK_BUILD_FOR_UNIX",
    "SK_CODEC_DECODES_PNG",
    "SK_CODEC_DECODES_WEBP",
    "SK_R32_SHIFT=16",
    "SK_GL",
    "SK_CODEC_DECODES_JPEG",
]
ANDROID_DEFINES = [
    "SK_BUILD_FOR_ANDROID",
    "SK_CODEC_DECODES_PNG",
    "SK_CODEC_DECODES_WEBP",
    "SK_GL",
    "SK_CODEC_DECODES_JPEG",
]
IOS_DEFINES = [
    "SK_BUILD_FOR_IOS",
    "SK_GL",
    "SK_CODEC_DECODES_JPEG",
]
WASM_DEFINES = [
    "SK_DISABLE_LEGACY_SHADERCONTEXT",
    "SK_DISABLE_TRACING",
    "SK_GL",
    "SK_FORCE_AAA",
    "SK_DISABLE_EFFECT_DESERIALIZATION",
    "SK_FORCE_8_BYTE_ALIGNMENT",
    "SKNX_NO_SIMD",
    "SK_CODEC_DECODES_JPEG",
]
FUCHSIA_DEFINES = [
    "SK_BUILD_FOR_UNIX",
    "SK_CODEC_DECODES_PNG",
    "SK_CODEC_DECODES_WEBP",
    "SK_R32_SHIFT=16",
    "SK_VULKAN",
    "SK_CODEC_DECODES_JPEG",
]
MACOS_DEFINES = [
    "SK_BUILD_FOR_MAC",
    "SK_GL",
    "SK_CODEC_DECODES_JPEG",
]
ANDROID_NO_CODECS_DEFINES = [
    "SK_BUILD_FOR_ANDROID",
    "SK_GL",
]

################################################################################
## sksg_lib
################################################################################

SKSG_LIB_HDRS = [
    "modules/sksg/include/SkSGClipEffect.h",
    "modules/sksg/include/SkSGColorFilter.h",
    "modules/sksg/include/SkSGDraw.h",
    "modules/sksg/include/SkSGEffectNode.h",
    "modules/sksg/include/SkSGGeometryEffect.h",
    "modules/sksg/include/SkSGGeometryNode.h",
    "modules/sksg/include/SkSGGradient.h",
    "modules/sksg/include/SkSGGroup.h",
    "modules/sksg/include/SkSGImage.h",
    "modules/sksg/include/SkSGInvalidationController.h",
    "modules/sksg/include/SkSGMaskEffect.h",
    "modules/sksg/include/SkSGMerge.h",
    "modules/sksg/include/SkSGNode.h",
    "modules/sksg/include/SkSGOpacityEffect.h",
    "modules/sksg/include/SkSGPaint.h",
    "modules/sksg/include/SkSGPath.h",
    "modules/sksg/include/SkSGPlane.h",
    "modules/sksg/include/SkSGRect.h",
    "modules/sksg/include/SkSGRenderEffect.h",
    "modules/sksg/include/SkSGRenderNode.h",
    "modules/sksg/include/SkSGScene.h",
    "modules/sksg/include/SkSGText.h",
    "modules/sksg/include/SkSGTransform.h",
]

SKSG_LIB_SRCS = [
    "modules/sksg/src/SkSGClipEffect.cpp",
    "modules/sksg/src/SkSGColorFilter.cpp",
    "modules/sksg/src/SkSGDraw.cpp",
    "modules/sksg/src/SkSGEffectNode.cpp",
    "modules/sksg/src/SkSGGeometryEffect.cpp",
    "modules/sksg/src/SkSGGeometryNode.cpp",
    "modules/sksg/src/SkSGGradient.cpp",
    "modules/sksg/src/SkSGGroup.cpp",
    "modules/sksg/src/SkSGImage.cpp",
    "modules/sksg/src/SkSGInvalidationController.cpp",
    "modules/sksg/src/SkSGMaskEffect.cpp",
    "modules/sksg/src/SkSGMerge.cpp",
    "modules/sksg/src/SkSGNode.cpp",
    "modules/sksg/src/SkSGNodePriv.h",
    "modules/sksg/src/SkSGOpacityEffect.cpp",
    "modules/sksg/src/SkSGPaint.cpp",
    "modules/sksg/src/SkSGPath.cpp",
    "modules/sksg/src/SkSGPlane.cpp",
    "modules/sksg/src/SkSGRect.cpp",
    "modules/sksg/src/SkSGRenderEffect.cpp",
    "modules/sksg/src/SkSGRenderNode.cpp",
    "modules/sksg/src/SkSGScene.cpp",
    "modules/sksg/src/SkSGText.cpp",
    "modules/sksg/src/SkSGTransform.cpp",
    "modules/sksg/src/SkSGTransformPriv.h",
]

################################################################################
## skparagraph_lib
################################################################################

SKPARAGRAPH_LIB_HDRS = [
    "modules/skparagraph/include/DartTypes.h",
    "modules/skparagraph/include/FontArguments.h",
    "modules/skparagraph/include/FontCollection.h",
    "modules/skparagraph/include/Metrics.h",
    "modules/skparagraph/include/ParagraphBuilder.h",
    "modules/skparagraph/include/ParagraphCache.h",
    "modules/skparagraph/include/Paragraph.h",
    "modules/skparagraph/include/ParagraphPainter.h",
    "modules/skparagraph/include/ParagraphStyle.h",
    "modules/skparagraph/include/TextShadow.h",
    "modules/skparagraph/include/TextStyle.h",
    "modules/skparagraph/include/TypefaceFontProvider.h",
]

SKPARAGRAPH_LIB_SRCS = [
    "modules/skparagraph/src/Decorations.cpp",
    "modules/skparagraph/src/Decorations.h",
    "modules/skparagraph/src/FontArguments.cpp",
    "modules/skparagraph/src/FontCollection.cpp",
    "modules/skparagraph/src/Iterators.h",
    "modules/skparagraph/src/OneLineShaper.cpp",
    "modules/skparagraph/src/OneLineShaper.h",
    "modules/skparagraph/src/ParagraphBuilderImpl.cpp",
    "modules/skparagraph/src/ParagraphBuilderImpl.h",
    "modules/skparagraph/src/ParagraphCache.cpp",
    "modules/skparagraph/src/ParagraphImpl.cpp",
    "modules/skparagraph/src/ParagraphImpl.h",
    "modules/skparagraph/src/ParagraphPainterImpl.cpp",
    "modules/skparagraph/src/ParagraphPainterImpl.h",
    "modules/skparagraph/src/ParagraphStyle.cpp",
    "modules/skparagraph/src/Run.cpp",
    "modules/skparagraph/src/Run.h",
    "modules/skparagraph/src/TextLine.cpp",
    "modules/skparagraph/src/TextLine.h",
    "modules/skparagraph/src/TextShadow.cpp",
    "modules/skparagraph/src/TextStyle.cpp",
    "modules/skparagraph/src/TextWrapper.cpp",
    "modules/skparagraph/src/TextWrapper.h",
    "modules/skparagraph/src/TypefaceFontProvider.cpp",
]

################################################################################
## skresources_lib
################################################################################

SKRESOURCES_LIB_HDRS = ["modules/skresources/include/SkResources.h"]

SKRESOURCES_LIB_SRCS = ["modules/skresources/src/SkResources.cpp"]

################################################################################
## skottie_lib
################################################################################

SKOTTIE_LIB_HDRS = [
    "modules/skottie/include/ExternalLayer.h",
    "modules/skottie/include/Skottie.h",
    "modules/skottie/include/SkottieProperty.h",
    "modules/skottie/include/SlotManager.h",
]

# We omit SkottieTool and SkottieTest as they are not needed for production code.
SKOTTIE_LIB_SRCS = [
    "modules/skottie/src/Adapter.h",
    "modules/skottie/src/animator/Animator.cpp",
    "modules/skottie/src/animator/Animator.h",
    "modules/skottie/src/animator/KeyframeAnimator.cpp",
    "modules/skottie/src/animator/KeyframeAnimator.h",
    "modules/skottie/src/animator/ScalarKeyframeAnimator.cpp",
    "modules/skottie/src/animator/ShapeKeyframeAnimator.cpp",
    "modules/skottie/src/animator/TextKeyframeAnimator.cpp",
    "modules/skottie/src/animator/Vec2KeyframeAnimator.cpp",
    "modules/skottie/src/animator/VectorKeyframeAnimator.cpp",
    "modules/skottie/src/animator/VectorKeyframeAnimator.h",
    "modules/skottie/src/BlendModes.cpp",
    "modules/skottie/src/Camera.cpp",
    "modules/skottie/src/Camera.h",
    "modules/skottie/src/Composition.cpp",
    "modules/skottie/src/Composition.h",
    "modules/skottie/src/effects/BlackAndWhiteEffect.cpp",
    "modules/skottie/src/effects/BrightnessContrastEffect.cpp",
    "modules/skottie/src/effects/BulgeEffect.cpp",
    "modules/skottie/src/effects/CCTonerEffect.cpp",
    "modules/skottie/src/effects/CornerPinEffect.cpp",
    "modules/skottie/src/effects/DirectionalBlur.cpp",
    "modules/skottie/src/effects/DisplacementMapEffect.cpp",
    "modules/skottie/src/effects/DropShadowEffect.cpp",
    "modules/skottie/src/effects/Effects.cpp",
    "modules/skottie/src/effects/Effects.h",
    "modules/skottie/src/effects/FillEffect.cpp",
    "modules/skottie/src/effects/FractalNoiseEffect.cpp",
    "modules/skottie/src/effects/GaussianBlurEffect.cpp",
    "modules/skottie/src/effects/GlowStyles.cpp",
    "modules/skottie/src/effects/GradientEffect.cpp",
    "modules/skottie/src/effects/HueSaturationEffect.cpp",
    "modules/skottie/src/effects/InvertEffect.cpp",
    "modules/skottie/src/effects/LevelsEffect.cpp",
    "modules/skottie/src/effects/LinearWipeEffect.cpp",
    "modules/skottie/src/effects/MotionBlurEffect.cpp",
    "modules/skottie/src/effects/MotionBlurEffect.h",
    "modules/skottie/src/effects/MotionTileEffect.cpp",
    "modules/skottie/src/effects/RadialWipeEffect.cpp",
    "modules/skottie/src/effects/ShadowStyles.cpp",
    "modules/skottie/src/effects/SharpenEffect.cpp",
    "modules/skottie/src/effects/ShiftChannelsEffect.cpp",
    "modules/skottie/src/effects/SkSLEffect.cpp",
    "modules/skottie/src/effects/SphereEffect.cpp",
    "modules/skottie/src/effects/ThresholdEffect.cpp",
    "modules/skottie/src/effects/TintEffect.cpp",
    "modules/skottie/src/effects/TransformEffect.cpp",
    "modules/skottie/src/effects/TritoneEffect.cpp",
    "modules/skottie/src/effects/VenetianBlindsEffect.cpp",
    "modules/skottie/src/Layer.cpp",
    "modules/skottie/src/Layer.h",
    "modules/skottie/src/layers/AudioLayer.cpp",
    "modules/skottie/src/layers/FootageLayer.cpp",
    "modules/skottie/src/layers/NullLayer.cpp",
    "modules/skottie/src/layers/PrecompLayer.cpp",
    "modules/skottie/src/layers/shapelayer/Ellipse.cpp",
    "modules/skottie/src/layers/shapelayer/FillStroke.cpp",
    "modules/skottie/src/layers/shapelayer/Gradient.cpp",
    "modules/skottie/src/layers/shapelayer/MergePaths.cpp",
    "modules/skottie/src/layers/shapelayer/OffsetPaths.cpp",
    "modules/skottie/src/layers/shapelayer/Polystar.cpp",
    "modules/skottie/src/layers/shapelayer/PuckerBloat.cpp",
    "modules/skottie/src/layers/shapelayer/Rectangle.cpp",
    "modules/skottie/src/layers/shapelayer/Repeater.cpp",
    "modules/skottie/src/layers/shapelayer/RoundCorners.cpp",
    "modules/skottie/src/layers/shapelayer/ShapeLayer.cpp",
    "modules/skottie/src/layers/shapelayer/ShapeLayer.h",
    "modules/skottie/src/layers/shapelayer/TrimPaths.cpp",
    "modules/skottie/src/layers/SolidLayer.cpp",
    "modules/skottie/src/layers/TextLayer.cpp",
    "modules/skottie/src/Path.cpp",
    "modules/skottie/src/Skottie.cpp",
    "modules/skottie/src/SkottieJson.cpp",
    "modules/skottie/src/SkottieJson.h",
    "modules/skottie/src/SkottiePriv.h",
    "modules/skottie/src/SkottieProperty.cpp",
    "modules/skottie/src/SkottieValue.h",
    "modules/skottie/src/SlotManager.cpp",
    "modules/skottie/src/text/Font.cpp",
    "modules/skottie/src/text/Font.h",
    "modules/skottie/src/text/RangeSelector.cpp",
    "modules/skottie/src/text/RangeSelector.h",
    "modules/skottie/src/text/SkottieShaper.cpp",
    "modules/skottie/src/text/SkottieShaper.h",
    "modules/skottie/src/text/TextAdapter.cpp",
    "modules/skottie/src/text/TextAdapter.h",
    "modules/skottie/src/text/TextAnimator.cpp",
    "modules/skottie/src/text/TextAnimator.h",
    "modules/skottie/src/text/TextValue.cpp",
    "modules/skottie/src/text/TextValue.h",
    "modules/skottie/src/Transform.cpp",
    "modules/skottie/src/Transform.h",
]

################################################################################
## skottie_utils
################################################################################

SKOTTIE_UTILS_HDRS = [
    "modules/skottie/utils/SkottieUtils.h",
]

SKOTTIE_UTILS_SRCS = [
    "modules/skottie/utils/SkottieUtils.cpp",
]

################################################################################
## skottie_shaper
################################################################################

SKOTTIE_SHAPER_HDRS = [
    "modules/skottie/src/text/SkottieShaper.h",
]

SKOTTIE_SHAPER_SRCS = [
    "modules/skottie/src/text/SkottieShaper.cpp",
]

################################################################################
## SkShaper
################################################################################

# Stubs, pending SkUnicode fission
SKUNICODE_ICU_BUILTIN_SRCS = [
    "modules/skunicode/src/SkUnicode.cpp",
    "modules/skunicode/src/SkUnicode_icu.cpp",
    "modules/skunicode/src/SkUnicode_icu.h",
    "modules/skunicode/src/SkUnicode_icu_bidi.cpp",
    "modules/skunicode/src/SkUnicode_icu_bidi.h",
    "modules/skunicode/src/SkUnicode_icu_builtin.cpp",
]

SKUNICODE_ICU_RUNTIME_SRCS = [
    "modules/skunicode/src/SkUnicode.cpp",
    "modules/skunicode/src/SkUnicode_icu.cpp",
    "modules/skunicode/src/SkUnicode_icu.h",
    "modules/skunicode/src/SkUnicode_icu_bidi.cpp",
    "modules/skunicode/src/SkUnicode_icu_bidi.h",
    "modules/skunicode/src/SkUnicode_icu_runtime.cpp",
]

SKUNICODE_CLIENT_SRCS = [
    "modules/skunicode/src/SkUnicode.cpp",
    "modules/skunicode/src/SkUnicode_client.cpp",
    "modules/skunicode/src/SkUnicode_icu_bidi.cpp",
    "modules/skunicode/src/SkUnicode_icu_bidi.h",
]

SKUNICODE_HDRS = [
    "modules/skunicode/include/SkUnicode.h",
]

SKSHAPER_HDRS = [
    "modules/skshaper/include/SkShaper.h",
]

SKSHAPER_HARFBUZZ_SRCS = [
    "modules/skshaper/src/SkShaper.cpp",
    "modules/skshaper/src/SkShaper_harfbuzz.cpp",
    "modules/skshaper/src/SkShaper_primitive.cpp",
]

SKSHAPER_CORETEXT_SRCS = [
    "modules/skshaper/src/SkShaper.cpp",
    "modules/skshaper/src/SkShaper_coretext.cpp",
    "modules/skshaper/src/SkShaper_primitive.cpp",
]

SKSHAPER_PRIMITIVE_SRCS = [
    "modules/skshaper/src/SkShaper.cpp",
    "modules/skshaper/src/SkShaper_primitive.cpp",
]

################################################################################
## skottie_ios_lib
################################################################################

SKOTTIE_IOS_LIB_SRCS = [
    "tools/skottie_ios_app/SkiaContext.mm",
    "tools/skottie_ios_app/SkiaUIContext.mm",
    "tools/skottie_ios_app/SkiaViewController.mm",
    "tools/skottie_ios_app/SkottieViewController.mm",
]

SKOTTIE_IOS_LIB_HDRS = [
    "tools/skottie_ios_app/SkiaContext.h",
    "tools/skottie_ios_app/SkiaViewController.h",
    "tools/skottie_ios_app/SkottieViewController.h",
]

SKOTTIE_IOS_LIB_SDK_FRAMEWORKS = [
    "Foundation",
    "UIKit",
]

################################################################################
## svg_lib
################################################################################

SVG_LIB_HDRS = [
    "modules/svg/include/SkSVGAttribute.h",
    "modules/svg/include/SkSVGAttributeParser.h",
    "modules/svg/include/SkSVGCircle.h",
    "modules/svg/include/SkSVGClipPath.h",
    "modules/svg/include/SkSVGContainer.h",
    "modules/svg/include/SkSVGDefs.h",
    "modules/svg/include/SkSVGDOM.h",
    "modules/svg/include/SkSVGEllipse.h",
    "modules/svg/include/SkSVGFeBlend.h",
    "modules/svg/include/SkSVGFeColorMatrix.h",
    "modules/svg/include/SkSVGFeComposite.h",
    "modules/svg/include/SkSVGFeDisplacementMap.h",
    "modules/svg/include/SkSVGFeFlood.h",
    "modules/svg/include/SkSVGFeGaussianBlur.h",
    "modules/svg/include/SkSVGFe.h",
    "modules/svg/include/SkSVGFeImage.h",
    "modules/svg/include/SkSVGFeLighting.h",
    "modules/svg/include/SkSVGFeLightSource.h",
    "modules/svg/include/SkSVGFeMorphology.h",
    "modules/svg/include/SkSVGFeOffset.h",
    "modules/svg/include/SkSVGFeTurbulence.h",
    "modules/svg/include/SkSVGFilterContext.h",
    "modules/svg/include/SkSVGFilter.h",
    "modules/svg/include/SkSVGG.h",
    "modules/svg/include/SkSVGGradient.h",
    "modules/svg/include/SkSVGHiddenContainer.h",
    "modules/svg/include/SkSVGIDMapper.h",
    "modules/svg/include/SkSVGImage.h",
    "modules/svg/include/SkSVGLinearGradient.h",
    "modules/svg/include/SkSVGLine.h",
    "modules/svg/include/SkSVGMask.h",
    "modules/svg/include/SkSVGNode.h",
    "modules/svg/include/SkSVGOpenTypeSVGDecoder.h",
    "modules/svg/include/SkSVGPath.h",
    "modules/svg/include/SkSVGPattern.h",
    "modules/svg/include/SkSVGPoly.h",
    "modules/svg/include/SkSVGRadialGradient.h",
    "modules/svg/include/SkSVGRect.h",
    "modules/svg/include/SkSVGRenderContext.h",
    "modules/svg/include/SkSVGShape.h",
    "modules/svg/include/SkSVGStop.h",
    "modules/svg/include/SkSVGSVG.h",
    "modules/svg/include/SkSVGText.h",
    "modules/svg/include/SkSVGTransformableNode.h",
    "modules/svg/include/SkSVGTypes.h",
    "modules/svg/include/SkSVGUse.h",
    "modules/svg/include/SkSVGValue.h",
]

SVG_LIB_SRCS = [
    "modules/svg/src/SkSVGAttribute.cpp",
    "modules/svg/src/SkSVGAttributeParser.cpp",
    "modules/svg/src/SkSVGCircle.cpp",
    "modules/svg/src/SkSVGClipPath.cpp",
    "modules/svg/src/SkSVGContainer.cpp",
    "modules/svg/src/SkSVGDOM.cpp",
    "modules/svg/src/SkSVGEllipse.cpp",
    "modules/svg/src/SkSVGFeBlend.cpp",
    "modules/svg/src/SkSVGFeColorMatrix.cpp",
    "modules/svg/src/SkSVGFeComposite.cpp",
    "modules/svg/src/SkSVGFe.cpp",
    "modules/svg/src/SkSVGFeDisplacementMap.cpp",
    "modules/svg/src/SkSVGFeFlood.cpp",
    "modules/svg/src/SkSVGFeGaussianBlur.cpp",
    "modules/svg/src/SkSVGFeImage.cpp",
    "modules/svg/src/SkSVGFeLighting.cpp",
    "modules/svg/src/SkSVGFeLightSource.cpp",
    "modules/svg/src/SkSVGFeMorphology.cpp",
    "modules/svg/src/SkSVGFeOffset.cpp",
    "modules/svg/src/SkSVGFeTurbulence.cpp",
    "modules/svg/src/SkSVGFilterContext.cpp",
    "modules/svg/src/SkSVGFilter.cpp",
    "modules/svg/src/SkSVGGradient.cpp",
    "modules/svg/src/SkSVGImage.cpp",
    "modules/svg/src/SkSVGLine.cpp",
    "modules/svg/src/SkSVGLinearGradient.cpp",
    "modules/svg/src/SkSVGMask.cpp",
    "modules/svg/src/SkSVGNode.cpp",
    "modules/svg/src/SkSVGOpenTypeSVGDecoder.cpp",
    "modules/svg/src/SkSVGPath.cpp",
    "modules/svg/src/SkSVGPattern.cpp",
    "modules/svg/src/SkSVGPoly.cpp",
    "modules/svg/src/SkSVGRadialGradient.cpp",
    "modules/svg/src/SkSVGRect.cpp",
    "modules/svg/src/SkSVGRenderContext.cpp",
    "modules/svg/src/SkSVGShape.cpp",
    "modules/svg/src/SkSVGStop.cpp",
    "modules/svg/src/SkSVGSVG.cpp",
    "modules/svg/src/SkSVGText.cpp",
    "modules/svg/src/SkSVGTextPriv.h",
    "modules/svg/src/SkSVGTransformableNode.cpp",
    "modules/svg/src/SkSVGUse.cpp",
    "modules/svg/src/SkSVGValue.cpp",
]

################################################################################
## xml_lib
################################################################################

XML_SRCS = [
    "src/xml/SkDOM.cpp",
    "src/xml/SkXMLParser.cpp",
    "src/xml/SkXMLWriter.cpp",
]
XML_HDRS = [
    "src/xml/SkDOM.h",
    "src/xml/SkXMLParser.h",
    "src/xml/SkXMLWriter.h",
]

################################################################################
## EGL support
################################################################################

SKIA_EGL_HDRS = ["include/gpu/gl/egl/GrGLMakeEGLInterface.h"]
SKIA_EGL_SRCS = ["src/gpu/ganesh/gl/egl/GrGLMakeEGLInterface.cpp"]
