/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class NewVmSpec {
    private final ImmutableMap<String, String> properties;
    private final ImmutableMap<String, String> options;

    private NewVmSpec(Builder builder) {
        this.properties = builder.propertiesBuilder.build();
        this.options = builder.optionsBuilder.build();
    }

    public ImmutableMap<String, String> options() {
        return this.options;
    }

    public ImmutableMap<String, String> properties() {
        return this.properties;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NewVmSpec) {
            NewVmSpec that = (NewVmSpec)obj;
            return this.properties.equals(that.properties) && this.options.equals(that.options);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.properties, this.options});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("properties", this.properties).add("options", this.options).toString();
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, String> propertiesBuilder = ImmutableMap.builder();
        private final ImmutableMap.Builder<String, String> optionsBuilder = ImmutableMap.builder();

        public Builder addOption(String optionName, String value) {
            this.optionsBuilder.put((Object)optionName, (Object)value);
            return this;
        }

        public Builder addAllOptions(Map<String, String> options) {
            this.optionsBuilder.putAll(options);
            return this;
        }

        public Builder addProperty(String property, String value) {
            this.optionsBuilder.put((Object)property, (Object)value);
            return this;
        }

        public Builder addAllProperties(Map<String, String> properties) {
            this.optionsBuilder.putAll(properties);
            return this;
        }

        public NewVmSpec build() {
            return new NewVmSpec(this);
        }
    }
}

