/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class UpToDate
extends Task
implements Condition {
    private String _property;
    private String _value;
    private File _sourceFile;
    private File _targetFile;
    private Vector sourceFileSets = new Vector();
    protected Mapper mapperElement = null;

    public void setProperty(String property) {
        this._property = property;
    }

    public void setValue(String value) {
        this._value = value;
    }

    private String getValue() {
        return this._value != null ? this._value : "true";
    }

    public void setTargetFile(File file) {
        this._targetFile = file;
    }

    public void setSrcfile(File file) {
        this._sourceFile = file;
    }

    public void addSrcfiles(FileSet fs) {
        this.sourceFileSets.addElement(fs);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public boolean eval() {
        if (this.sourceFileSets.size() == 0 && this._sourceFile == null) {
            throw new BuildException("At least one srcfile or a nested <srcfiles> element must be set.");
        }
        if (this.sourceFileSets.size() > 0 && this._sourceFile != null) {
            throw new BuildException("Cannot specify both the srcfile attribute and a nested <srcfiles> element.");
        }
        if (this._targetFile == null && this.mapperElement == null) {
            throw new BuildException("The targetfile attribute or a nested mapper element must be set.");
        }
        if (this._targetFile != null && !this._targetFile.exists()) {
            this.log("The targetfile \"" + this._targetFile.getAbsolutePath() + "\" does not exist.", 3);
            return false;
        }
        if (this._sourceFile != null && !this._sourceFile.exists()) {
            throw new BuildException(this._sourceFile.getAbsolutePath() + " not found.");
        }
        Enumeration e = this.sourceFileSets.elements();
        boolean upToDate = true;
        while (upToDate && e.hasMoreElements()) {
            FileSet fs = (FileSet)e.nextElement();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            boolean bl = upToDate = upToDate && this.scanDir(fs.getDir(this.getProject()), ds.getIncludedFiles());
        }
        if (this._sourceFile != null) {
            if (this.mapperElement == null) {
                upToDate = upToDate && this._targetFile.lastModified() >= this._sourceFile.lastModified();
            } else {
                SourceFileScanner sfs = new SourceFileScanner(this);
                upToDate = upToDate && sfs.restrict(new String[]{this._sourceFile.getAbsolutePath()}, null, null, this.mapperElement.getImplementation()).length == 0;
            }
        }
        return upToDate;
    }

    public void execute() throws BuildException {
        if (this._property == null) {
            throw new BuildException("property attribute is required.", this.getLocation());
        }
        boolean upToDate = this.eval();
        if (upToDate) {
            this.getProject().setNewProperty(this._property, this.getValue());
            if (this.mapperElement == null) {
                this.log("File \"" + this._targetFile.getAbsolutePath() + "\" is up-to-date.", 3);
            } else {
                this.log("All target files are up-to-date.", 3);
            }
        }
    }

    protected boolean scanDir(File srcDir, String[] files) {
        SourceFileScanner sfs = new SourceFileScanner(this);
        FileNameMapper mapper = null;
        File dir = srcDir;
        if (this.mapperElement == null) {
            MergingMapper mm = new MergingMapper();
            mm.setTo(this._targetFile.getAbsolutePath());
            mapper = mm;
            dir = null;
        } else {
            mapper = this.mapperElement.getImplementation();
        }
        return sfs.restrict(files, srcDir, dir, mapper).length == 0;
    }
}

