; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=ipsccp -S %s | FileCheck %s

define i8 @range_from_lshr(i8 %a) {
; CHECK-LABEL: @range_from_lshr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_SHR:%.*]] = lshr i8 [[A:%.*]], 1
; CHECK-NEXT:    [[SUB_1:%.*]] = sub nsw i8 [[A_SHR]], 1
; CHECK-NEXT:    [[SUB_2:%.*]] = sub i8 [[A_SHR]], -128
; CHECK-NEXT:    [[SUB_3:%.*]] = sub i8 [[A_SHR]], -127
; CHECK-NEXT:    [[SUB_4:%.*]] = sub i8 [[A_SHR]], -1
; CHECK-NEXT:    [[RES_1:%.*]] = xor i8 [[SUB_1]], [[SUB_2]]
; CHECK-NEXT:    [[RES_2:%.*]] = xor i8 [[RES_1]], [[SUB_3]]
; CHECK-NEXT:    [[RES_3:%.*]] = xor i8 [[RES_2]], [[SUB_4]]
; CHECK-NEXT:    ret i8 [[RES_3]]
;
entry:
  %a.shr = lshr i8 %a, 1
  %sub.1 = sub i8 %a.shr, 1
  %sub.2 = sub i8 %a.shr, 128
  %sub.3 = sub i8 %a.shr, 129
  %sub.4 = sub i8 %a.shr, -1
  %res.1 = xor i8 %sub.1, %sub.2
  %res.2 = xor i8 %res.1, %sub.3
  %res.3 = xor i8 %res.2, %sub.4
  ret i8 %res.3
}


define i8 @sub_zero(i8 %a) {
; CHECK-LABEL: @sub_zero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SUB_1:%.*]] = sub i8 0, [[A:%.*]]
; CHECK-NEXT:    [[SUB_2:%.*]] = sub nuw nsw i8 -1, [[A]]
; CHECK-NEXT:    [[SUB_3:%.*]] = sub i8 1, [[A]]
; CHECK-NEXT:    [[SUB_4:%.*]] = sub i8 [[A]], -1
; CHECK-NEXT:    [[RES_1:%.*]] = xor i8 [[SUB_1]], [[SUB_2]]
; CHECK-NEXT:    [[RES_2:%.*]] = xor i8 [[RES_1]], [[SUB_3]]
; CHECK-NEXT:    [[RES_3:%.*]] = xor i8 [[RES_2]], [[SUB_4]]
; CHECK-NEXT:    ret i8 [[RES_3]]
;
entry:
  %sub.1 = sub i8 0, %a
  %sub.2 = sub i8 -1, %a
  %sub.3 = sub i8 1, %a
  %sub.4 = sub i8 %a, -1
  %res.1 = xor i8 %sub.1, %sub.2
  %res.2 = xor i8 %res.1, %sub.3
  %res.3 = xor i8 %res.2, %sub.4
  ret i8 %res.3
}
