program intrinsics_210
    use lcompilers_test_module
    use, intrinsic :: iso_fortran_env, only: dp => real64, sp => real32
    integer(4) :: n(40)
    real(dp) :: x(40)
    real(dp) :: expected(40)
    real(dp) :: expected_res(32)
    integer :: i

    real :: y(28)
    real :: expected_y(28)

    real(dp), parameter :: res(32) = bessel_jn( [0, 1, 2, 3, &
        4, 5, 6, 7, &
        8, 9, 10, 11, &
        12, 13, 14, 15, &
        16, 17, 18, 19, &
        20, 21, 22, 23, &
        24, 25, 26, 27, &
        28, 29, 30, 31], [9.98600559790084e307_dp,9.98800479820072e307_dp,9.9900039985006e307_dp, &
        9.99200319880048e307_dp, 1036.462826483388272_dp, 1.7197292882018389_dp, & 
        10.2368267382872828_dp, 0.17197292882018389_dp, 152.67283628_dp, &
        632.92729728_dp, 1.2728272919_dp, 1.265228272919_dp, &
        29.82407037185126_dp, 35.2459016393_dp, 46.2634946_dp, 24.7740903638_dp, &
        15.8978408636372_dp, 8.801468212714914_dp, 8.798080767692923_dp, 8.791287884846061575_dp, &
        0.6635324560331525_dp, 0.6633115808685429_dp, 0.6630906573122884_dp, 0.6628696853957159_dp, &
        0.5042349934053336_dp, 0.5041796815747646_dp, 0.5041242821300232_dp, 0.50401322049655_dp, &
        499.19032387045183_dp, 499.2802878848461_dp, 499.3702518992403_dp, 499.5501799280288_dp])

    expected_res = [ 1.1242697836494344E-156_dp, -7.0751499885966521E-155_dp, 6.6185432736853706E-155_dp, &
        7.7717941781117294E-156_dp, 1.2534227302224874E-002_dp, 3.4591630672860707E-003_dp, &
        -6.6635959548975512E-002_dp, 6.8893572859763076E-012_dp, 1.7296961499438702E-002_dp, &
        -2.1516112626678387E-002_dp, 2.8947852994014139E-009_dp, 1.5735107612153680E-010_dp, &
        0.15234385509729706_dp, -0.10168238671155572_dp, 0.10624777824227472_dp, 6.9944761409615891E-002_dp, &
        0.17105291318716473_dp, 8.0781549836989616E-005_dp, 2.0878989572444657E-005_dp, 5.0408349875562356E-006_dp, &
        1.0671913964996569E-028_dp, 1.6746487669899214E-030_dp, 2.5066961782596647E-032_dp, 3.5865372175913752E-034_dp, &
        6.9929712255690990E-039_dp, 7.0335789790577674E-041_dp, 6.8007546900796684E-043_dp, 6.3118158714187534E-045_dp, &
        -3.3890445848758326E-002_dp, 6.2626337984015854E-003_dp, 3.5724011188705031E-002_dp, 7.5701847451948119E-003_dp]

    call lcompilers_test(res, expected_res)

    n = [0, 1, 2, 3, &
        4, 5, 6, 7, &
        8, 9, 10, 11, &
        12, 13, 14, 15, &
        16, 17, 18, 19, &
        20, 21, 22, 23, &
        24, 25, 26, 27, &
        28, 29, 30, 31, &
        32, 33, 34, 35, &
        36, 37, 38, 39]

    x = [9.98600559790084e307_dp, 9.98800479820072e307_dp, 9.9900039985006e307_dp, 9.99200319880048e307_dp, &
        1036.462826483388272_dp, 1.7197292882018389_dp, 10.2368267382872828_dp, 0.17197292882018389_dp, &
        152.67283628_dp, 632.92729728_dp, 1.2728272919_dp, 1.265228272919_dp, &
        3.229995504589554d-153, 1.9201212555874555d-153, 6.809537363878625d-155, 5.690181373063991d-154, &
        29.82407037185126_dp, 35.2459016393_dp, 46.2634946_dp, 24.7740903638_dp, &
        15.8978408636372_dp, 8.801468212714914_dp, 8.798080767692923_dp, 8.791287884846061575_dp, &
        0.6635324560331525_dp, 0.6633115808685429_dp, 0.6630906573122884_dp, 0.6628696853957159_dp, &
        0.5042349934053336_dp, 0.5041796815747646_dp, 0.5041242821300232_dp, 0.50401322049655_dp, &
        1.3994502099160337d-303, 1.199530179928029d-303, 9.99610149940024d-304, 5.9977008996401444d-304, &
        499.19032387045183_dp, 499.2802878848461_dp, 499.3702518992403_dp, 499.5501799280288_dp]

    expected = [1.1242697836494346E-156_dp, -7.0751499885966513E-155_dp, 6.6185432736853698E-155_dp, &
        7.7717941781117305E-156_dp, 1.2534227302224872E-002_dp, 3.4591630672860703E-003_dp, &
        -6.6635959548975499E-002_dp, 6.8893572859763092E-012_dp, 1.7296961499438702E-002_dp, &
        -2.1516112626678383E-002_dp, 2.8947852994014131E-009_dp, 1.5735107612153680E-010_dp, &
        0.0000000000000000_dp, 0.0000000000000000_dp, 0.0000000000000000_dp, 0.0000000000000000_dp, &
        -6.8962897404005893E-002_dp, 0.11600081741700101_dp, -3.9325959159357701E-002_dp, -5.4809072994286029E-002_dp, &
        1.5966478032830803E-002_dp, 2.6042180275774077E-007_dp, 5.3826197741831827E-008_dp, 1.0507745589842931E-008_dp, &
        5.0740445951464912E-036_dp, 6.6789232767890394E-038_dp, 8.4475056518481737E-040_dp, 1.0281670110849426E-041_dp, &
        5.7516289094274354E-047_dp, 4.9847818101108337E-049_dp, 4.1752109811469430E-051_dp, 3.3719895152572157E-053_dp, &
        0.0000000000000000_dp, 0.0000000000000000_dp, 0.0000000000000000_dp, 0.0000000000000000_dp, &
        -3.5113774172006770E-002_dp, -1.2362051018001158E-002_dp, 3.1067922823692470E-002_dp, 2.5002750863701195E-002_dp] 

    call lcompilers_test(bessel_jn(n, x), expected)


    y = [1036.462826483388272_sp, 1.7197292882018389_sp, 10.2368267382872828_sp, 0.17197292882018389_sp, &
        152.67283628_sp, 632.92729728_sp, 1.2728272919_sp, 1.2828272919_sp, &
        29.82407037185126_sp, 35.2459016393_sp, 46.2634946_sp, 24.7740903638_sp, &
        15.8978408636372_sp, 8.801468212714914_sp, 8.798080767692923_sp, 8.791287884846061575_sp, &
        0.6635324560331525_sp, 0.6633115808685429_sp, 0.6630906573122884_sp, 0.6628696853957159_sp, &
        0.5042349934053336_sp, 0.5041796815747646_sp, 0.5041242821300232_sp, 0.50401322049655_sp, &
        499.19032387045183_sp, 499.2802878848461_sp, 499.3702518992403_sp, 499.5501799280288_sp]
    
    expected_y = [1.23675410E-02_sp, 0.578831732_sp, 0.246125504_sp, 1.05763575E-04_sp, &
        2.68192869E-02_sp, -2.04640366E-02_sp, 8.70731674E-05_sp, 8.41663041E-06_sp, &
        3.94373797E-02_sp, -0.118844219_sp, 0.100343116_sp, -0.164519981_sp, &
        0.127764359_sp, 8.69522523E-03_sp, 3.02742911E-03_sp, 9.63504543E-04_sp, &
        1.02301633E-21_sp, 1.98594108E-23_sp, 3.63846685E-25_sp, 6.31080674E-27_sp, &
        4.41184424E-31_sp, 5.28522317E-33_sp, 6.04228548E-35_sp, 6.58917622E-37_sp, &
        -3.08027826E-02_sp, 1.36694657E-02_sp, 3.46039571E-02_sp, -6.74327370E-04_sp]

    call lcompilers_test(bessel_jn(n(1:size(y)), y), expected_y, 10.0_sp)
end program
