/*===================== begin_copyright_notice ==================================

Copyright (c) 2017 Intel Corporation

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


======================= end_copyright_notice ==================================*/

#ifndef __IA32E_TAN_D_G_DATA_CL__
#define __IA32E_TAN_D_G_DATA_CL__

typedef struct
{
  VUINT32 _dInvPI_uisa[2];
  VUINT32 _dPI1_uisa[2];
  VUINT32 _dPI2_uisa[2];
  VUINT32 _dPI3_uisa[2];
  VUINT32 _dPI2_ha_uisa[2];
  VUINT32 _dPI3_ha_uisa[2];
  VUINT32 Th_tbl_uisa[16][2];
  VUINT32 Tl_tbl_uisa[16][2];
  VUINT32 _dPC3_uisa[2];
  VUINT32 _dPC5_uisa[2];
  VUINT32 _dPC7_uisa[2];
  VUINT32 _dPC9_uisa[2];
  VUINT32 _dPC11_uisa[2];
  VUINT32 _dOne_uisa[2];

  VUINT32 _dAbsMask[2];
  VUINT32 _dRangeVal[2];
  VUINT32 _dRShift[2];
  VUINT32 _dPIoHi[2];
  VUINT32 _dPIoLo[2];
  VUINT32 _dPIoTail[2];
  VUINT32 _lIndexMask[2];
  VUINT32 _dPIu[2];
  VUINT32 _dCoeffs[256][13][2];
  VUINT32 _dReductionRangeVal[2];

  VUINT32 _dSignMask[2];
  VUINT32 _dInvPi[2];

  VUINT32 _dPI1[2];
  VUINT32 _dPI2[2];
  VUINT32 _dPI3[2];
  VUINT32 _dPI4[2];
  VUINT32 _dPI1_FMA[2];
  VUINT32 _dPI2_FMA[2];
  VUINT32 _dPI3_FMA[2];

  VUINT32 _dP0[2];
  VUINT32 _dP1[2];
  VUINT32 _dP2[2];
  VUINT32 _dP3[2];
  VUINT32 _dQ0[2];
  VUINT32 _dQ1[2];
  VUINT32 _dQ2[2];
  VUINT32 _dQ3[2];

} dTan_Table_Type;

__constant dTan_Table_Type __ocl_svml_dtan_data = {

  {(VUINT32) ((0x40145F306DC9C883uLL) >> 0),
   (VUINT32) ((0x40145F306DC9C883uLL) >> 32)},
  {(VUINT32) ((0x3fc921fb54442d18uLL) >> 0),
   (VUINT32) ((0x3fc921fb54442d18uLL) >> 32)},
  {(VUINT32) ((0x3c61a62633145c06uLL) >> 0),
   (VUINT32) ((0x3c61a62633145c06uLL) >> 32)},
  {(VUINT32) ((0x391c1cd129024e09uLL) >> 0),
   (VUINT32) ((0x391c1cd129024e09uLL) >> 32)},
  {(VUINT32) ((0x3c61a62633000000uLL) >> 0),
   (VUINT32) ((0x3c61a62633000000uLL) >> 32)},
  {(VUINT32) ((0x3a645c06e0e68948uLL) >> 0),
   (VUINT32) ((0x3a645c06e0e68948uLL) >> 32)},

  {
   {(VUINT32) ((0x8000000000000000uLL) >> 0),
    (VUINT32) ((0x8000000000000000uLL) >> 32)},
   {(VUINT32) ((0x3fc975f5e0553158uLL) >> 0),
    (VUINT32) ((0x3fc975f5e0553158uLL) >> 32)},
   {(VUINT32) ((0x3fda827999fcef32uLL) >> 0),
    (VUINT32) ((0x3fda827999fcef32uLL) >> 32)},
   {(VUINT32) ((0x3fe561b82ab7f990uLL) >> 0),
    (VUINT32) ((0x3fe561b82ab7f990uLL) >> 32)},
   {(VUINT32) ((0x3ff0000000000000uLL) >> 0),
    (VUINT32) ((0x3ff0000000000000uLL) >> 32)},
   {(VUINT32) ((0x3ff7f218e25a7461uLL) >> 0),
    (VUINT32) ((0x3ff7f218e25a7461uLL) >> 32)},
   {(VUINT32) ((0x4003504f333f9de6uLL) >> 0),
    (VUINT32) ((0x4003504f333f9de6uLL) >> 32)},
   {(VUINT32) ((0x40141bfee2424771uLL) >> 0),
    (VUINT32) ((0x40141bfee2424771uLL) >> 32)},
   {(VUINT32) ((0xffefffffffffffffuLL) >> 0),
    (VUINT32) ((0xffefffffffffffffuLL) >> 32)},
   {(VUINT32) ((0xc0141bfee2424771uLL) >> 0),
    (VUINT32) ((0xc0141bfee2424771uLL) >> 32)},
   {(VUINT32) ((0xc003504f333f9de6uLL) >> 0),
    (VUINT32) ((0xc003504f333f9de6uLL) >> 32)},
   {(VUINT32) ((0xbff7f218e25a7461uLL) >> 0),
    (VUINT32) ((0xbff7f218e25a7461uLL) >> 32)},
   {(VUINT32) ((0xbff0000000000000uLL) >> 0),
    (VUINT32) ((0xbff0000000000000uLL) >> 32)},
   {(VUINT32) ((0xbfe561b82ab7f990uLL) >> 0),
    (VUINT32) ((0xbfe561b82ab7f990uLL) >> 32)},
   {(VUINT32) ((0xbfda827999fcef32uLL) >> 0),
    (VUINT32) ((0xbfda827999fcef32uLL) >> 32)},
   {(VUINT32) ((0xbfc975f5e0553158uLL) >> 0),
    (VUINT32) ((0xbfc975f5e0553158uLL) >> 32)},
   },
  {
   {(VUINT32) ((0x8000000000000000uLL) >> 0),
    (VUINT32) ((0x8000000000000000uLL) >> 32)},
   {(VUINT32) ((0x3c2ef5d367441946uLL) >> 0),
    (VUINT32) ((0x3c2ef5d367441946uLL) >> 32)},
   {(VUINT32) ((0x3c708b2fb1366ea9uLL) >> 0),
    (VUINT32) ((0x3c708b2fb1366ea9uLL) >> 32)},
   {(VUINT32) ((0x3c87a8c52172b675uLL) >> 0),
    (VUINT32) ((0x3c87a8c52172b675uLL) >> 32)},
   {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
   {(VUINT32) ((0x3c9419fa6954928fuLL) >> 0),
    (VUINT32) ((0x3c9419fa6954928fuLL) >> 32)},
   {(VUINT32) ((0x3ca21165f626cdd5uLL) >> 0),
    (VUINT32) ((0x3ca21165f626cdd5uLL) >> 32)},
   {(VUINT32) ((0x3c810706fed37f0euLL) >> 0),
    (VUINT32) ((0x3c810706fed37f0euLL) >> 32)},
   {(VUINT32) ((0xfca0000000000000uLL) >> 0),
    (VUINT32) ((0xfca0000000000000uLL) >> 32)},
   {(VUINT32) ((0xbc810706fed37f0euLL) >> 0),
    (VUINT32) ((0xbc810706fed37f0euLL) >> 32)},
   {(VUINT32) ((0xbca21165f626cdd5uLL) >> 0),
    (VUINT32) ((0xbca21165f626cdd5uLL) >> 32)},
   {(VUINT32) ((0xbc9419fa6954928fuLL) >> 0),
    (VUINT32) ((0xbc9419fa6954928fuLL) >> 32)},
   {(VUINT32) ((0x0000000000000000uLL) >> 0),
    (VUINT32) ((0x0000000000000000uLL) >> 32)},
   {(VUINT32) ((0xbc87a8c52172b675uLL) >> 0),
    (VUINT32) ((0xbc87a8c52172b675uLL) >> 32)},
   {(VUINT32) ((0xbc708b2fb1366ea9uLL) >> 0),
    (VUINT32) ((0xbc708b2fb1366ea9uLL) >> 32)},
   {(VUINT32) ((0xbc2ef5d367441946uLL) >> 0),
    (VUINT32) ((0xbc2ef5d367441946uLL) >> 32)},
   },
  {(VUINT32) ((0x3fd55555555555dcuLL) >> 0),
   (VUINT32) ((0x3fd55555555555dcuLL) >> 32)},
  {(VUINT32) ((0x3fc11111110b0802uLL) >> 0),
   (VUINT32) ((0x3fc11111110b0802uLL) >> 32)},
  {(VUINT32) ((0x3faba1ba489d25cauLL) >> 0),
   (VUINT32) ((0x3faba1ba489d25cauLL) >> 32)},
  {(VUINT32) ((0x3f9664ab664efba9uLL) >> 0),
   (VUINT32) ((0x3f9664ab664efba9uLL) >> 32)},
  {(VUINT32) ((0x3f825cccc7c9fa5duLL) >> 0),
   (VUINT32) ((0x3f825cccc7c9fa5duLL) >> 32)},
  {(VUINT32) ((0x3ff0000000000000uLL) >> 0),
   (VUINT32) ((0x3ff0000000000000uLL) >> 32)},

  {(VUINT32) ((0x7FFFFFFFFFFFFFFFuLL) >> 0),
   (VUINT32) ((0x7FFFFFFFFFFFFFFFuLL) >> 32)},
  {(VUINT32) ((0x7FF0000000000000uLL) >> 0),
   (VUINT32) ((0x7FF0000000000000uLL) >> 32)},
  {(VUINT32) ((0x4338000000000000uLL) >> 0),
   (VUINT32) ((0x4338000000000000uLL) >> 32)},
  {(VUINT32) ((0x3F8921FB54400000uLL) >> 0),
   (VUINT32) ((0x3F8921FB54400000uLL) >> 32)},
  {(VUINT32) ((0x3D60B4611A600000uLL) >> 0),
   (VUINT32) ((0x3D60B4611A600000uLL) >> 32)},
  {(VUINT32) ((0x3B33198A2E037073uLL) >> 0),
   (VUINT32) ((0x3B33198A2E037073uLL) >> 32)},
  {(VUINT32) ((0x00000000000001FFuLL) >> 0),
   (VUINT32) ((0x00000000000001FFuLL) >> 32)},
  {(VUINT32) ((0x40545F306DC9C883uLL) >> 0),
   (VUINT32) ((0x40545F306DC9C883uLL) >> 32)},

  {

   {
    {(VUINT32) ((0x3FF921FB54442D18uLL) >> 0),
     (VUINT32) ((0x3FF921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0x3C91A62633145C07uLL) >> 0),
     (VUINT32) ((0x3C91A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD5555555555559uLL) >> 0),
     (VUINT32) ((0x3FD5555555555559uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC1111110FE825DuLL) >> 0),
     (VUINT32) ((0x3FC1111110FE825DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FABA1EEC0271523uLL) >> 0),
     (VUINT32) ((0x3FABA1EEC0271523uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF8EFB75D9BA4BEuLL) >> 0),
     (VUINT32) ((0x3FF8EFB75D9BA4BEuLL) >> 32)},
    {(VUINT32) ((0x3C760B679AB8CD3BuLL) >> 0),
     (VUINT32) ((0x3C760B679AB8CD3BuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F89224E047E368EuLL) >> 0),
     (VUINT32) ((0x3F89224E047E368EuLL) >> 32)},
    {(VUINT32) ((0xBC1A268EB2C67108uLL) >> 0),
     (VUINT32) ((0xBC1A268EB2C67108uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F23BDBEAD8CF800uLL) >> 0),
     (VUINT32) ((0x3F23BDBEAD8CF800uLL) >> 32)},
    {(VUINT32) ((0x3F8923461AE96D62uLL) >> 0),
     (VUINT32) ((0x3F8923461AE96D62uLL) >> 32)},
    {(VUINT32) ((0x3FD5589FB822D5EEuLL) >> 0),
     (VUINT32) ((0x3FD5589FB822D5EEuLL) >> 32)},
    {(VUINT32) ((0x3F80C326DCDCFCD0uLL) >> 0),
     (VUINT32) ((0x3F80C326DCDCFCD0uLL) >> 32)},
    {(VUINT32) ((0x3FC116A999125B7FuLL) >> 0),
     (VUINT32) ((0x3FC116A999125B7FuLL) >> 32)},
    {(VUINT32) ((0x3F7300CC26596ADAuLL) >> 0),
     (VUINT32) ((0x3F7300CC26596ADAuLL) >> 32)},
    {(VUINT32) ((0x3FAB7B6F1DE289A8uLL) >> 0),
     (VUINT32) ((0x3FAB7B6F1DE289A8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF8BD7366F31C64uLL) >> 0),
     (VUINT32) ((0x3FF8BD7366F31C64uLL) >> 32)},
    {(VUINT32) ((0xBC7A81C996DFD5A5uLL) >> 0),
     (VUINT32) ((0xBC7A81C996DFD5A5uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F992346247A91F0uLL) >> 0),
     (VUINT32) ((0x3F992346247A91F0uLL) >> 32)},
    {(VUINT32) ((0xBBF126D920C15240uLL) >> 0),
     (VUINT32) ((0xBBF126D920C15240uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F43BF447B091000uLL) >> 0),
     (VUINT32) ((0x3F43BF447B091000uLL) >> 32)},
    {(VUINT32) ((0x3F992726F0F98D7FuLL) >> 0),
     (VUINT32) ((0x3F992726F0F98D7FuLL) >> 32)},
    {(VUINT32) ((0x3FD5628108EFA55CuLL) >> 0),
     (VUINT32) ((0x3FD5628108EFA55CuLL) >> 32)},
    {(VUINT32) ((0x3F90C8A60639C114uLL) >> 0),
     (VUINT32) ((0x3F90C8A60639C114uLL) >> 32)},
    {(VUINT32) ((0x3FC127789EC0BD38uLL) >> 0),
     (VUINT32) ((0x3FC127789EC0BD38uLL) >> 32)},
    {(VUINT32) ((0x3F830BA6F46C58B7uLL) >> 0),
     (VUINT32) ((0x3F830BA6F46C58B7uLL) >> 32)},
    {(VUINT32) ((0x3FABBEE2C1E62B81uLL) >> 0),
     (VUINT32) ((0x3FABBEE2C1E62B81uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF88B2F704A940AuLL) >> 0),
     (VUINT32) ((0x3FF88B2F704A940AuLL) >> 32)},
    {(VUINT32) ((0xBC92C3BEB21E1E21uLL) >> 0),
     (VUINT32) ((0xBC92C3BEB21E1E21uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA2DBAAE9A05DB0uLL) >> 0),
     (VUINT32) ((0x3FA2DBAAE9A05DB0uLL) >> 32)},
    {(VUINT32) ((0xBC4371F88E84877CuLL) >> 0),
     (VUINT32) ((0xBC4371F88E84877CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F563A086B860B00uLL) >> 0),
     (VUINT32) ((0x3F563A086B860B00uLL) >> 32)},
    {(VUINT32) ((0x3FA2E23785EEB488uLL) >> 0),
     (VUINT32) ((0x3FA2E23785EEB488uLL) >> 32)},
    {(VUINT32) ((0x3FD572FFC353B741uLL) >> 0),
     (VUINT32) ((0x3FD572FFC353B741uLL) >> 32)},
    {(VUINT32) ((0x3F993ABD2276BF6AuLL) >> 0),
     (VUINT32) ((0x3F993ABD2276BF6AuLL) >> 32)},
    {(VUINT32) ((0x3FC1439260886581uLL) >> 0),
     (VUINT32) ((0x3FC1439260886581uLL) >> 32)},
    {(VUINT32) ((0x3F8CAC359DCF5E16uLL) >> 0),
     (VUINT32) ((0x3F8CAC359DCF5E16uLL) >> 32)},
    {(VUINT32) ((0x3FAB56F9A068D4C5uLL) >> 0),
     (VUINT32) ((0x3FAB56F9A068D4C5uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF858EB79A20BB0uLL) >> 0),
     (VUINT32) ((0x3FF858EB79A20BB0uLL) >> 32)},
    {(VUINT32) ((0xBC9EE70AFE8446D9uLL) >> 0),
     (VUINT32) ((0xBC9EE70AFE8446D9uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA927278A3B1162uLL) >> 0),
     (VUINT32) ((0x3FA927278A3B1162uLL) >> 32)},
    {(VUINT32) ((0x3BFB01BD7A51D5C0uLL) >> 0),
     (VUINT32) ((0x3BFB01BD7A51D5C0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F63C55DB08E1680uLL) >> 0),
     (VUINT32) ((0x3F63C55DB08E1680uLL) >> 32)},
    {(VUINT32) ((0x3FA936B1EC652161uLL) >> 0),
     (VUINT32) ((0x3FA936B1EC652161uLL) >> 32)},
    {(VUINT32) ((0x3FD58A26BD6CCCCDuLL) >> 0),
     (VUINT32) ((0x3FD58A26BD6CCCCDuLL) >> 32)},
    {(VUINT32) ((0x3FA0DEB5445B4098uLL) >> 0),
     (VUINT32) ((0x3FA0DEB5445B4098uLL) >> 32)},
    {(VUINT32) ((0x3FC16B146127E154uLL) >> 0),
     (VUINT32) ((0x3FC16B146127E154uLL) >> 32)},
    {(VUINT32) ((0x3F9336A98365D094uLL) >> 0),
     (VUINT32) ((0x3F9336A98365D094uLL) >> 32)},
    {(VUINT32) ((0x3FAC19302EB1C4A9uLL) >> 0),
     (VUINT32) ((0x3FAC19302EB1C4A9uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF826A782F98355uLL) >> 0),
     (VUINT32) ((0x3FF826A782F98355uLL) >> 32)},
    {(VUINT32) ((0x3C94F5A8B515906FuLL) >> 0),
     (VUINT32) ((0x3C94F5A8B515906FuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FAF7495EA3F3783uLL) >> 0),
     (VUINT32) ((0x3FAF7495EA3F3783uLL) >> 32)},
    {(VUINT32) ((0xBC407F10D50F4C0AuLL) >> 0),
     (VUINT32) ((0xBC407F10D50F4C0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F6EEB8B377B1A00uLL) >> 0),
     (VUINT32) ((0x3F6EEB8B377B1A00uLL) >> 32)},
    {(VUINT32) ((0x3FAF92FABFD0B7B3uLL) >> 0),
     (VUINT32) ((0x3FAF92FABFD0B7B3uLL) >> 32)},
    {(VUINT32) ((0x3FD5A805341437FFuLL) >> 0),
     (VUINT32) ((0x3FD5A805341437FFuLL) >> 32)},
    {(VUINT32) ((0x3FA52B295E2DCF92uLL) >> 0),
     (VUINT32) ((0x3FA52B295E2DCF92uLL) >> 32)},
    {(VUINT32) ((0x3FC19E2C59B8C033uLL) >> 0),
     (VUINT32) ((0x3FC19E2C59B8C033uLL) >> 32)},
    {(VUINT32) ((0x3F982CF88466EFECuLL) >> 0),
     (VUINT32) ((0x3F982CF88466EFECuLL) >> 32)},
    {(VUINT32) ((0x3FAD27509D6C3FEAuLL) >> 0),
     (VUINT32) ((0x3FAD27509D6C3FEAuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF7F4638C50FAFBuLL) >> 0),
     (VUINT32) ((0x3FF7F4638C50FAFBuLL) >> 32)},
    {(VUINT32) ((0x3C81A4B8D15ECF6DuLL) >> 0),
     (VUINT32) ((0x3C81A4B8D15ECF6DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB2E239CCFF3831uLL) >> 0),
     (VUINT32) ((0x3FB2E239CCFF3831uLL) >> 32)},
    {(VUINT32) ((0x3C5879ED3FF4EEAEuLL) >> 0),
     (VUINT32) ((0x3C5879ED3FF4EEAEuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F764980AEEE3740uLL) >> 0),
     (VUINT32) ((0x3F764980AEEE3740uLL) >> 32)},
    {(VUINT32) ((0x3FB2FC879C81123CuLL) >> 0),
     (VUINT32) ((0x3FB2FC879C81123CuLL) >> 32)},
    {(VUINT32) ((0x3FD5CCAEDC1DC96EuLL) >> 0),
     (VUINT32) ((0x3FD5CCAEDC1DC96EuLL) >> 32)},
    {(VUINT32) ((0x3FA98599B71D86B1uLL) >> 0),
     (VUINT32) ((0x3FA98599B71D86B1uLL) >> 32)},
    {(VUINT32) ((0x3FC1DD150D55E5CEuLL) >> 0),
     (VUINT32) ((0x3FC1DD150D55E5CEuLL) >> 32)},
    {(VUINT32) ((0x3F9D3EB9450DBD01uLL) >> 0),
     (VUINT32) ((0x3F9D3EB9450DBD01uLL) >> 32)},
    {(VUINT32) ((0x3FADD6CFBE9AA234uLL) >> 0),
     (VUINT32) ((0x3FADD6CFBE9AA234uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF7C21F95A872A1uLL) >> 0),
     (VUINT32) ((0x3FF7C21F95A872A1uLL) >> 32)},
    {(VUINT32) ((0xBC6A877F1DB6080CuLL) >> 0),
     (VUINT32) ((0xBC6A877F1DB6080CuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB60B9F7597FDECuLL) >> 0),
     (VUINT32) ((0x3FB60B9F7597FDECuLL) >> 32)},
    {(VUINT32) ((0x3C3D1E3FBF3B4E18uLL) >> 0),
     (VUINT32) ((0x3C3D1E3FBF3B4E18uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F7E5FFEF4D8DFC0uLL) >> 0),
     (VUINT32) ((0x3F7E5FFEF4D8DFC0uLL) >> 32)},
    {(VUINT32) ((0x3FB6357984E124B6uLL) >> 0),
     (VUINT32) ((0x3FB6357984E124B6uLL) >> 32)},
    {(VUINT32) ((0x3FD5F83BF8B56900uLL) >> 0),
     (VUINT32) ((0x3FD5F83BF8B56900uLL) >> 32)},
    {(VUINT32) ((0x3FADF0F50CAA06C2uLL) >> 0),
     (VUINT32) ((0x3FADF0F50CAA06C2uLL) >> 32)},
    {(VUINT32) ((0x3FC2281476904258uLL) >> 0),
     (VUINT32) ((0x3FC2281476904258uLL) >> 32)},
    {(VUINT32) ((0x3FA138F0F640FD68uLL) >> 0),
     (VUINT32) ((0x3FA138F0F640FD68uLL) >> 32)},
    {(VUINT32) ((0x3FAF8D1BCDD8D11FuLL) >> 0),
     (VUINT32) ((0x3FAF8D1BCDD8D11FuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF78FDB9EFFEA47uLL) >> 0),
     (VUINT32) ((0x3FF78FDB9EFFEA47uLL) >> 32)},
    {(VUINT32) ((0xBC8EE8786039D373uLL) >> 0),
     (VUINT32) ((0xBC8EE8786039D373uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB936BB8C5B2DA2uLL) >> 0),
     (VUINT32) ((0x3FB936BB8C5B2DA2uLL) >> 32)},
    {(VUINT32) ((0x3C587D23392C2BA2uLL) >> 0),
     (VUINT32) ((0x3C587D23392C2BA2uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F83DDE2A8935DE0uLL) >> 0),
     (VUINT32) ((0x3F83DDE2A8935DE0uLL) >> 32)},
    {(VUINT32) ((0x3FB97558DC230BA8uLL) >> 0),
     (VUINT32) ((0x3FB97558DC230BA8uLL) >> 32)},
    {(VUINT32) ((0x3FD62AC976FBC1B8uLL) >> 0),
     (VUINT32) ((0x3FD62AC976FBC1B8uLL) >> 32)},
    {(VUINT32) ((0x3FB1381EB60159F6uLL) >> 0),
     (VUINT32) ((0x3FB1381EB60159F6uLL) >> 32)},
    {(VUINT32) ((0x3FC27F84438D5029uLL) >> 0),
     (VUINT32) ((0x3FC27F84438D5029uLL) >> 32)},
    {(VUINT32) ((0x3FA3E63B3A462E45uLL) >> 0),
     (VUINT32) ((0x3FA3E63B3A462E45uLL) >> 32)},
    {(VUINT32) ((0x3FAF0AE614B2D473uLL) >> 0),
     (VUINT32) ((0x3FAF0AE614B2D473uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF75D97A85761EDuLL) >> 0),
     (VUINT32) ((0x3FF75D97A85761EDuLL) >> 32)},
    {(VUINT32) ((0xBC9B97887C831272uLL) >> 0),
     (VUINT32) ((0xBC9B97887C831272uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBC63CE377FC802uLL) >> 0),
     (VUINT32) ((0x3FBC63CE377FC802uLL) >> 32)},
    {(VUINT32) ((0xBC543F7D42DBAC49uLL) >> 0),
     (VUINT32) ((0xBC543F7D42DBAC49uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F892FE02A47EFA0uLL) >> 0),
     (VUINT32) ((0x3F892FE02A47EFA0uLL) >> 32)},
    {(VUINT32) ((0x3FBCBD3001C956C5uLL) >> 0),
     (VUINT32) ((0x3FBCBD3001C956C5uLL) >> 32)},
    {(VUINT32) ((0x3FD664790F293C47uLL) >> 0),
     (VUINT32) ((0x3FD664790F293C47uLL) >> 32)},
    {(VUINT32) ((0x3FB38345DE7C4B0BuLL) >> 0),
     (VUINT32) ((0x3FB38345DE7C4B0BuLL) >> 32)},
    {(VUINT32) ((0x3FC2E3C4C02FFDFBuLL) >> 0),
     (VUINT32) ((0x3FC2E3C4C02FFDFBuLL) >> 32)},
    {(VUINT32) ((0x3FA6AA7F0C13520BuLL) >> 0),
     (VUINT32) ((0x3FA6AA7F0C13520BuLL) >> 32)},
    {(VUINT32) ((0x3FAFE3C754A9F092uLL) >> 0),
     (VUINT32) ((0x3FAFE3C754A9F092uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF72B53B1AED992uLL) >> 0),
     (VUINT32) ((0x3FF72B53B1AED992uLL) >> 32)},
    {(VUINT32) ((0x3C98452B3716C4D6uLL) >> 0),
     (VUINT32) ((0x3C98452B3716C4D6uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBF93183A8DB9E9uLL) >> 0),
     (VUINT32) ((0x3FBF93183A8DB9E9uLL) >> 32)},
    {(VUINT32) ((0xBC4124AC452772E2uLL) >> 0),
     (VUINT32) ((0xBC4124AC452772E2uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F8F27A3181EE680uLL) >> 0),
     (VUINT32) ((0x3F8F27A3181EE680uLL) >> 32)},
    {(VUINT32) ((0x3FC00707549D7ECCuLL) >> 0),
     (VUINT32) ((0x3FC00707549D7ECCuLL) >> 32)},
    {(VUINT32) ((0x3FD6A5716B500730uLL) >> 0),
     (VUINT32) ((0x3FD6A5716B500730uLL) >> 32)},
    {(VUINT32) ((0x3FB5DB89BB6B245FuLL) >> 0),
     (VUINT32) ((0x3FB5DB89BB6B245FuLL) >> 32)},
    {(VUINT32) ((0x3FC3554867F59648uLL) >> 0),
     (VUINT32) ((0x3FC3554867F59648uLL) >> 32)},
    {(VUINT32) ((0x3FA98919BF6D176AuLL) >> 0),
     (VUINT32) ((0x3FA98919BF6D176AuLL) >> 32)},
    {(VUINT32) ((0x3FB1AF9A1823147BuLL) >> 0),
     (VUINT32) ((0x3FB1AF9A1823147BuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF6F90FBB065138uLL) >> 0),
     (VUINT32) ((0x3FF6F90FBB065138uLL) >> 32)},
    {(VUINT32) ((0x3C8843BDD561383DuLL) >> 0),
     (VUINT32) ((0x3C8843BDD561383DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC1626D85A91E70uLL) >> 0),
     (VUINT32) ((0x3FC1626D85A91E70uLL) >> 32)},
    {(VUINT32) ((0xBC50084844291CB4uLL) >> 0),
     (VUINT32) ((0xBC50084844291CB4uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F92E3863C9A69E0uLL) >> 0),
     (VUINT32) ((0x3F92E3863C9A69E0uLL) >> 32)},
    {(VUINT32) ((0x3FC1B4854BB2B147uLL) >> 0),
     (VUINT32) ((0x3FC1B4854BB2B147uLL) >> 32)},
    {(VUINT32) ((0x3FD6EDDE5416DFFBuLL) >> 0),
     (VUINT32) ((0x3FD6EDDE5416DFFBuLL) >> 32)},
    {(VUINT32) ((0x3FB8429341CCA17AuLL) >> 0),
     (VUINT32) ((0x3FB8429341CCA17AuLL) >> 32)},
    {(VUINT32) ((0x3FC3D49AC2C9F46FuLL) >> 0),
     (VUINT32) ((0x3FC3D49AC2C9F46FuLL) >> 32)},
    {(VUINT32) ((0x3FAC85843914CF90uLL) >> 0),
     (VUINT32) ((0x3FAC85843914CF90uLL) >> 32)},
    {(VUINT32) ((0x3FB1B1DC3FA33DDDuLL) >> 0),
     (VUINT32) ((0x3FB1B1DC3FA33DDDuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF6C6CBC45DC8DEuLL) >> 0),
     (VUINT32) ((0x3FF6C6CBC45DC8DEuLL) >> 32)},
    {(VUINT32) ((0xBBD6D61B58C99C43uLL) >> 0),
     (VUINT32) ((0xBBD6D61B58C99C43uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC2FCAC73A60640uLL) >> 0),
     (VUINT32) ((0x3FC2FCAC73A60640uLL) >> 32)},
    {(VUINT32) ((0x3C52CF95F70B55BAuLL) >> 0),
     (VUINT32) ((0x3C52CF95F70B55BAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F96881A43B33590uLL) >> 0),
     (VUINT32) ((0x3F96881A43B33590uLL) >> 32)},
    {(VUINT32) ((0x3FC367A033B52F5EuLL) >> 0),
     (VUINT32) ((0x3FC367A033B52F5EuLL) >> 32)},
    {(VUINT32) ((0x3FD73DF0E3CC557AuLL) >> 0),
     (VUINT32) ((0x3FD73DF0E3CC557AuLL) >> 32)},
    {(VUINT32) ((0x3FBABA1CAC4F18CDuLL) >> 0),
     (VUINT32) ((0x3FBABA1CAC4F18CDuLL) >> 32)},
    {(VUINT32) ((0x3FC4624C36BE941BuLL) >> 0),
     (VUINT32) ((0x3FC4624C36BE941BuLL) >> 32)},
    {(VUINT32) ((0x3FAFA38B2F8876EFuLL) >> 0),
     (VUINT32) ((0x3FAFA38B2F8876EFuLL) >> 32)},
    {(VUINT32) ((0x3FB215B1F404D921uLL) >> 0),
     (VUINT32) ((0x3FB215B1F404D921uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF69487CDB54084uLL) >> 0),
     (VUINT32) ((0x3FF69487CDB54084uLL) >> 32)},
    {(VUINT32) ((0xBC8849735C376AA4uLL) >> 0),
     (VUINT32) ((0xBC8849735C376AA4uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC4986A74CF4E57uLL) >> 0),
     (VUINT32) ((0x3FC4986A74CF4E57uLL) >> 32)},
    {(VUINT32) ((0x3C69AB0A24392F72uLL) >> 0),
     (VUINT32) ((0x3C69AB0A24392F72uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F9A82B60D75F5C0uLL) >> 0),
     (VUINT32) ((0x3F9A82B60D75F5C0uLL) >> 32)},
    {(VUINT32) ((0x3FC520EA2BA6A0AEuLL) >> 0),
     (VUINT32) ((0x3FC520EA2BA6A0AEuLL) >> 32)},
    {(VUINT32) ((0x3FD795DFBFFEE39EuLL) >> 0),
     (VUINT32) ((0x3FD795DFBFFEE39EuLL) >> 32)},
    {(VUINT32) ((0x3FBD43F3A7862CC7uLL) >> 0),
     (VUINT32) ((0x3FBD43F3A7862CC7uLL) >> 32)},
    {(VUINT32) ((0x3FC4FF04247D700AuLL) >> 0),
     (VUINT32) ((0x3FC4FF04247D700AuLL) >> 32)},
    {(VUINT32) ((0x3FB1739726786F4FuLL) >> 0),
     (VUINT32) ((0x3FB1739726786F4FuLL) >> 32)},
    {(VUINT32) ((0x3FB2FAC67533455BuLL) >> 0),
     (VUINT32) ((0x3FB2FAC67533455BuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF66243D70CB82AuLL) >> 0),
     (VUINT32) ((0x3FF66243D70CB82AuLL) >> 32)},
    {(VUINT32) ((0xBC984805FA81DE0AuLL) >> 0),
     (VUINT32) ((0xBC984805FA81DE0AuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC635C990CE0D36uLL) >> 0),
     (VUINT32) ((0x3FC635C990CE0D36uLL) >> 32)},
    {(VUINT32) ((0xBC59DFC0C48C1978uLL) >> 0),
     (VUINT32) ((0xBC59DFC0C48C1978uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F9ED49F1F8144C0uLL) >> 0),
     (VUINT32) ((0x3F9ED49F1F8144C0uLL) >> 32)},
    {(VUINT32) ((0x3FC6E0F98ED00C32uLL) >> 0),
     (VUINT32) ((0x3FC6E0F98ED00C32uLL) >> 32)},
    {(VUINT32) ((0x3FD7F5E75A2DD66EuLL) >> 0),
     (VUINT32) ((0x3FD7F5E75A2DD66EuLL) >> 32)},
    {(VUINT32) ((0x3FBFE1FBA10F6B0EuLL) >> 0),
     (VUINT32) ((0x3FBFE1FBA10F6B0EuLL) >> 32)},
    {(VUINT32) ((0x3FC5AB7CD1905EB8uLL) >> 0),
     (VUINT32) ((0x3FC5AB7CD1905EB8uLL) >> 32)},
    {(VUINT32) ((0x3FB32A57A4FAE3F9uLL) >> 0),
     (VUINT32) ((0x3FB32A57A4FAE3F9uLL) >> 32)},
    {(VUINT32) ((0x3FB4BA60BA656817uLL) >> 0),
     (VUINT32) ((0x3FB4BA60BA656817uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF62FFFE0642FCFuLL) >> 0),
     (VUINT32) ((0x3FF62FFFE0642FCFuLL) >> 32)},
    {(VUINT32) ((0x3C9B94ADB917F93EuLL) >> 0),
     (VUINT32) ((0x3C9B94ADB917F93EuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC7D4EC54FB5968uLL) >> 0),
     (VUINT32) ((0x3FC7D4EC54FB5968uLL) >> 32)},
    {(VUINT32) ((0x3C4FB65648F8ABF4uLL) >> 0),
     (VUINT32) ((0x3C4FB65648F8ABF4uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA1BF9C7C60B940uLL) >> 0),
     (VUINT32) ((0x3FA1BF9C7C60B940uLL) >> 32)},
    {(VUINT32) ((0x3FC8A86964A1796BuLL) >> 0),
     (VUINT32) ((0x3FC8A86964A1796BuLL) >> 32)},
    {(VUINT32) ((0x3FD85E4A37F23352uLL) >> 0),
     (VUINT32) ((0x3FD85E4A37F23352uLL) >> 32)},
    {(VUINT32) ((0x3FC14B181F5BF6AEuLL) >> 0),
     (VUINT32) ((0x3FC14B181F5BF6AEuLL) >> 32)},
    {(VUINT32) ((0x3FC66888E3A5D3B3uLL) >> 0),
     (VUINT32) ((0x3FC66888E3A5D3B3uLL) >> 32)},
    {(VUINT32) ((0x3FB4F84D7AC0F5DAuLL) >> 0),
     (VUINT32) ((0x3FB4F84D7AC0F5DAuLL) >> 32)},
    {(VUINT32) ((0x3FB62BA6F082700CuLL) >> 0),
     (VUINT32) ((0x3FB62BA6F082700CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF5FDBBE9BBA775uLL) >> 0),
     (VUINT32) ((0x3FF5FDBBE9BBA775uLL) >> 32)},
    {(VUINT32) ((0x3C8EE2C2D963A10CuLL) >> 0),
     (VUINT32) ((0x3C8EE2C2D963A10CuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC975F5E0553158uLL) >> 0),
     (VUINT32) ((0x3FC975F5E0553158uLL) >> 32)},
    {(VUINT32) ((0x3C2EEEA31ABB0A10uLL) >> 0),
     (VUINT32) ((0x3C2EEEA31ABB0A10uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA4420303DEC550uLL) >> 0),
     (VUINT32) ((0x3FA4420303DEC550uLL) >> 32)},
    {(VUINT32) ((0x3FCA77D9D62CA610uLL) >> 0),
     (VUINT32) ((0x3FCA77D9D62CA610uLL) >> 32)},
    {(VUINT32) ((0x3FD8CF5143323608uLL) >> 0),
     (VUINT32) ((0x3FD8CF5143323608uLL) >> 32)},
    {(VUINT32) ((0x3FC2B15401455507uLL) >> 0),
     (VUINT32) ((0x3FC2B15401455507uLL) >> 32)},
    {(VUINT32) ((0x3FC7370FF0965570uLL) >> 0),
     (VUINT32) ((0x3FC7370FF0965570uLL) >> 32)},
    {(VUINT32) ((0x3FB6DFEACA56EACBuLL) >> 0),
     (VUINT32) ((0x3FB6DFEACA56EACBuLL) >> 32)},
    {(VUINT32) ((0x3FB6B75DF89DE1ECuLL) >> 0),
     (VUINT32) ((0x3FB6B75DF89DE1ECuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF5CB77F3131F1BuLL) >> 0),
     (VUINT32) ((0x3FF5CB77F3131F1BuLL) >> 32)},
    {(VUINT32) ((0x3C6A70A9025D3E70uLL) >> 0),
     (VUINT32) ((0x3C6A70A9025D3E70uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCB1909EFD8B762uLL) >> 0),
     (VUINT32) ((0x3FCB1909EFD8B762uLL) >> 32)},
    {(VUINT32) ((0x3C5843049E1321E0uLL) >> 0),
     (VUINT32) ((0x3C5843049E1321E0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA6F2545C478E00uLL) >> 0),
     (VUINT32) ((0x3FA6F2545C478E00uLL) >> 32)},
    {(VUINT32) ((0x3FCC4FF0A9D74F70uLL) >> 0),
     (VUINT32) ((0x3FCC4FF0A9D74F70uLL) >> 32)},
    {(VUINT32) ((0x3FD9494C22EF2A54uLL) >> 0),
     (VUINT32) ((0x3FD9494C22EF2A54uLL) >> 32)},
    {(VUINT32) ((0x3FC424CB909A6722uLL) >> 0),
     (VUINT32) ((0x3FC424CB909A6722uLL) >> 32)},
    {(VUINT32) ((0x3FC8180A481D5934uLL) >> 0),
     (VUINT32) ((0x3FC8180A481D5934uLL) >> 32)},
    {(VUINT32) ((0x3FB8E3D90C36FA83uLL) >> 0),
     (VUINT32) ((0x3FB8E3D90C36FA83uLL) >> 32)},
    {(VUINT32) ((0x3FB8D27EAFF0DF70uLL) >> 0),
     (VUINT32) ((0x3FB8D27EAFF0DF70uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF59933FC6A96C1uLL) >> 0),
     (VUINT32) ((0x3FF59933FC6A96C1uLL) >> 32)},
    {(VUINT32) ((0xBC81AA6E583501D4uLL) >> 0),
     (VUINT32) ((0xBC81AA6E583501D4uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCCBE4CEB4B4CF2uLL) >> 0),
     (VUINT32) ((0x3FCCBE4CEB4B4CF2uLL) >> 32)},
    {(VUINT32) ((0x3C64A514F790E428uLL) >> 0),
     (VUINT32) ((0x3C64A514F790E428uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA9D1724DE6C940uLL) >> 0),
     (VUINT32) ((0x3FA9D1724DE6C940uLL) >> 32)},
    {(VUINT32) ((0x3FCE3159C5ED3A4EuLL) >> 0),
     (VUINT32) ((0x3FCE3159C5ED3A4EuLL) >> 32)},
    {(VUINT32) ((0x3FD9CC919D4271B2uLL) >> 0),
     (VUINT32) ((0x3FD9CC919D4271B2uLL) >> 32)},
    {(VUINT32) ((0x3FC5A6A9489AA7F4uLL) >> 0),
     (VUINT32) ((0x3FC5A6A9489AA7F4uLL) >> 32)},
    {(VUINT32) ((0x3FC90C961E2B49F6uLL) >> 0),
     (VUINT32) ((0x3FC90C961E2B49F6uLL) >> 32)},
    {(VUINT32) ((0x3FBB06EE7CFA3693uLL) >> 0),
     (VUINT32) ((0x3FBB06EE7CFA3693uLL) >> 32)},
    {(VUINT32) ((0x3FB9E9447AB1D521uLL) >> 0),
     (VUINT32) ((0x3FB9E9447AB1D521uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF566F005C20E67uLL) >> 0),
     (VUINT32) ((0x3FF566F005C20E67uLL) >> 32)},
    {(VUINT32) ((0xBC94F8837880A9A2uLL) >> 0),
     (VUINT32) ((0xBC94F8837880A9A2uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCE65E3F27C9F2AuLL) >> 0),
     (VUINT32) ((0x3FCE65E3F27C9F2AuLL) >> 32)},
    {(VUINT32) ((0x3C6F62A8B8B40082uLL) >> 0),
     (VUINT32) ((0x3C6F62A8B8B40082uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FACE04FD3EC1C90uLL) >> 0),
     (VUINT32) ((0x3FACE04FD3EC1C90uLL) >> 32)},
    {(VUINT32) ((0x3FD00E63DD639A45uLL) >> 0),
     (VUINT32) ((0x3FD00E63DD639A45uLL) >> 32)},
    {(VUINT32) ((0x3FDA598003751442uLL) >> 0),
     (VUINT32) ((0x3FDA598003751442uLL) >> 32)},
    {(VUINT32) ((0x3FC73829AC409F93uLL) >> 0),
     (VUINT32) ((0x3FC73829AC409F93uLL) >> 32)},
    {(VUINT32) ((0x3FCA15E3A26F9D65uLL) >> 0),
     (VUINT32) ((0x3FCA15E3A26F9D65uLL) >> 32)},
    {(VUINT32) ((0x3FBD4C4574E0CB34uLL) >> 0),
     (VUINT32) ((0x3FBD4C4574E0CB34uLL) >> 32)},
    {(VUINT32) ((0x3FBB9C5881865EC1uLL) >> 0),
     (VUINT32) ((0x3FBB9C5881865EC1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF534AC0F19860CuLL) >> 0),
     (VUINT32) ((0x3FF534AC0F19860CuLL) >> 32)},
    {(VUINT32) ((0x3C9EE4303B192DA6uLL) >> 0),
     (VUINT32) ((0x3C9EE4303B192DA6uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD007FA758626AEuLL) >> 0),
     (VUINT32) ((0x3FD007FA758626AEuLL) >> 32)},
    {(VUINT32) ((0x3C65A5EB9CA505B6uLL) >> 0),
     (VUINT32) ((0x3C65A5EB9CA505B6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB00FF8E583BEBCuLL) >> 0),
     (VUINT32) ((0x3FB00FF8E583BEBCuLL) >> 32)},
    {(VUINT32) ((0x3FD1097A2AA570F5uLL) >> 0),
     (VUINT32) ((0x3FD1097A2AA570F5uLL) >> 32)},
    {(VUINT32) ((0x3FDAF07DA8CAEBA7uLL) >> 0),
     (VUINT32) ((0x3FDAF07DA8CAEBA7uLL) >> 32)},
    {(VUINT32) ((0x3FC8DA9D107525ADuLL) >> 0),
     (VUINT32) ((0x3FC8DA9D107525ADuLL) >> 32)},
    {(VUINT32) ((0x3FCB3545F2ADC1D6uLL) >> 0),
     (VUINT32) ((0x3FCB3545F2ADC1D6uLL) >> 32)},
    {(VUINT32) ((0x3FBFB739DB465891uLL) >> 0),
     (VUINT32) ((0x3FBFB739DB465891uLL) >> 32)},
    {(VUINT32) ((0x3FBDA2C23752D365uLL) >> 0),
     (VUINT32) ((0x3FBDA2C23752D365uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF502681870FDB2uLL) >> 0),
     (VUINT32) ((0x3FF502681870FDB2uLL) >> 32)},
    {(VUINT32) ((0x3C92C0E3EEB304EEuLL) >> 0),
     (VUINT32) ((0x3C92C0E3EEB304EEuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD0DE53475F3B3CuLL) >> 0),
     (VUINT32) ((0x3FD0DE53475F3B3CuLL) >> 32)},
    {(VUINT32) ((0x3C67B2CC0A83B8D0uLL) >> 0),
     (VUINT32) ((0x3C67B2CC0A83B8D0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB1C8B7D76C7EE0uLL) >> 0),
     (VUINT32) ((0x3FB1C8B7D76C7EE0uLL) >> 32)},
    {(VUINT32) ((0x3FD20A509D4BB6C1uLL) >> 0),
     (VUINT32) ((0x3FD20A509D4BB6C1uLL) >> 32)},
    {(VUINT32) ((0x3FDB91F96510DF38uLL) >> 0),
     (VUINT32) ((0x3FDB91F96510DF38uLL) >> 32)},
    {(VUINT32) ((0x3FCA8F698D62832EuLL) >> 0),
     (VUINT32) ((0x3FCA8F698D62832EuLL) >> 32)},
    {(VUINT32) ((0x3FCC6C340829132AuLL) >> 0),
     (VUINT32) ((0x3FCC6C340829132AuLL) >> 32)},
    {(VUINT32) ((0x3FC125B6D8F6980AuLL) >> 0),
     (VUINT32) ((0x3FC125B6D8F6980AuLL) >> 32)},
    {(VUINT32) ((0x3FBE80E8F3AEF448uLL) >> 0),
     (VUINT32) ((0x3FBE80E8F3AEF448uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF4D02421C87558uLL) >> 0),
     (VUINT32) ((0x3FF4D02421C87558uLL) >> 32)},
    {(VUINT32) ((0x3C7A765E893370D7uLL) >> 0),
     (VUINT32) ((0x3C7A765E893370D7uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD1B6103D3597E9uLL) >> 0),
     (VUINT32) ((0x3FD1B6103D3597E9uLL) >> 32)},
    {(VUINT32) ((0x3C6CBCB5FED7BFB0uLL) >> 0),
     (VUINT32) ((0x3C6CBCB5FED7BFB0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB39AFA3392E164uLL) >> 0),
     (VUINT32) ((0x3FB39AFA3392E164uLL) >> 32)},
    {(VUINT32) ((0x3FD3114C46E2AEF3uLL) >> 0),
     (VUINT32) ((0x3FD3114C46E2AEF3uLL) >> 32)},
    {(VUINT32) ((0x3FDC3E6B23EF73B5uLL) >> 0),
     (VUINT32) ((0x3FDC3E6B23EF73B5uLL) >> 32)},
    {(VUINT32) ((0x3FCC580D1B42EE7FuLL) >> 0),
     (VUINT32) ((0x3FCC580D1B42EE7FuLL) >> 32)},
    {(VUINT32) ((0x3FCDBC3D6E14D1FFuLL) >> 0),
     (VUINT32) ((0x3FCDBC3D6E14D1FFuLL) >> 32)},
    {(VUINT32) ((0x3FC28671B66B7EBDuLL) >> 0),
     (VUINT32) ((0x3FC28671B66B7EBDuLL) >> 32)},
    {(VUINT32) ((0x3FC0BFBCFE643140uLL) >> 0),
     (VUINT32) ((0x3FC0BFBCFE643140uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF49DE02B1FECFEuLL) >> 0),
     (VUINT32) ((0x3FF49DE02B1FECFEuLL) >> 32)},
    {(VUINT32) ((0xBC7616D2A8653209uLL) >> 0),
     (VUINT32) ((0xBC7616D2A8653209uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD28F459ECAD74DuLL) >> 0),
     (VUINT32) ((0x3FD28F459ECAD74DuLL) >> 32)},
    {(VUINT32) ((0x3C302C86D50F5140uLL) >> 0),
     (VUINT32) ((0x3C302C86D50F5140uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5875F92EDBDF4uLL) >> 0),
     (VUINT32) ((0x3FB5875F92EDBDF4uLL) >> 32)},
    {(VUINT32) ((0x3FD41ED6D05A0010uLL) >> 0),
     (VUINT32) ((0x3FD41ED6D05A0010uLL) >> 32)},
    {(VUINT32) ((0x3FDCF65481FC5BEBuLL) >> 0),
     (VUINT32) ((0x3FDCF65481FC5BEBuLL) >> 32)},
    {(VUINT32) ((0x3FCE361FE028368DuLL) >> 0),
     (VUINT32) ((0x3FCE361FE028368DuLL) >> 32)},
    {(VUINT32) ((0x3FCF2728B941710DuLL) >> 0),
     (VUINT32) ((0x3FCF2728B941710DuLL) >> 32)},
    {(VUINT32) ((0x3FC3FFF67496086BuLL) >> 0),
     (VUINT32) ((0x3FC3FFF67496086BuLL) >> 32)},
    {(VUINT32) ((0x3FC1A12109F041C7uLL) >> 0),
     (VUINT32) ((0x3FC1A12109F041C7uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF46B9C347764A4uLL) >> 0),
     (VUINT32) ((0x3FF46B9C347764A4uLL) >> 32)},
    {(VUINT32) ((0xBC91A900F67F753AuLL) >> 0),
     (VUINT32) ((0xBC91A900F67F753AuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD36A08355C63DCuLL) >> 0),
     (VUINT32) ((0x3FD36A08355C63DCuLL) >> 32)},
    {(VUINT32) ((0xBC6D7145B6A0EB84uLL) >> 0),
     (VUINT32) ((0xBC6D7145B6A0EB84uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB78E922B82AB64uLL) >> 0),
     (VUINT32) ((0x3FB78E922B82AB64uLL) >> 32)},
    {(VUINT32) ((0x3FD5335ED87AB0D5uLL) >> 0),
     (VUINT32) ((0x3FD5335ED87AB0D5uLL) >> 32)},
    {(VUINT32) ((0x3FDDBA417913D89CuLL) >> 0),
     (VUINT32) ((0x3FDDBA417913D89CuLL) >> 32)},
    {(VUINT32) ((0x3FD015AB59BD876BuLL) >> 0),
     (VUINT32) ((0x3FD015AB59BD876BuLL) >> 32)},
    {(VUINT32) ((0x3FD0576D1EF5DB86uLL) >> 0),
     (VUINT32) ((0x3FD0576D1EF5DB86uLL) >> 32)},
    {(VUINT32) ((0x3FC594A6DD2CA170uLL) >> 0),
     (VUINT32) ((0x3FC594A6DD2CA170uLL) >> 32)},
    {(VUINT32) ((0x3FC2F51FBC1D0708uLL) >> 0),
     (VUINT32) ((0x3FC2F51FBC1D0708uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF439583DCEDC4AuLL) >> 0),
     (VUINT32) ((0x3FF439583DCEDC4AuLL) >> 32)},
    {(VUINT32) ((0xBC9DCC4D42E59DF2uLL) >> 0),
     (VUINT32) ((0xBC9DCC4D42E59DF2uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD4466D542BAC92uLL) >> 0),
     (VUINT32) ((0x3FD4466D542BAC92uLL) >> 32)},
    {(VUINT32) ((0xBC705073A04E3471uLL) >> 0),
     (VUINT32) ((0xBC705073A04E3471uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB9B14751F8BA20uLL) >> 0),
     (VUINT32) ((0x3FB9B14751F8BA20uLL) >> 32)},
    {(VUINT32) ((0x3FD64F58590170A2uLL) >> 0),
     (VUINT32) ((0x3FD64F58590170A2uLL) >> 32)},
    {(VUINT32) ((0x3FDE8AC91D15CFCFuLL) >> 0),
     (VUINT32) ((0x3FDE8AC91D15CFCFuLL) >> 32)},
    {(VUINT32) ((0x3FD11CC2EF09C664uLL) >> 0),
     (VUINT32) ((0x3FD11CC2EF09C664uLL) >> 32)},
    {(VUINT32) ((0x3FD12AB5AB65B965uLL) >> 0),
     (VUINT32) ((0x3FD12AB5AB65B965uLL) >> 32)},
    {(VUINT32) ((0x3FC7471C9AC8155BuLL) >> 0),
     (VUINT32) ((0x3FC7471C9AC8155BuLL) >> 32)},
    {(VUINT32) ((0x3FC4826BA97C3E62uLL) >> 0),
     (VUINT32) ((0x3FC4826BA97C3E62uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF40714472653EFuLL) >> 0),
     (VUINT32) ((0x3FF40714472653EFuLL) >> 32)},
    {(VUINT32) ((0x3C96106670B43955uLL) >> 0),
     (VUINT32) ((0x3C96106670B43955uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD5248AE1701B17uLL) >> 0),
     (VUINT32) ((0x3FD5248AE1701B17uLL) >> 32)},
    {(VUINT32) ((0x3C7BE8CC944DBC57uLL) >> 0),
     (VUINT32) ((0x3C7BE8CC944DBC57uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBBF04005723CCCuLL) >> 0),
     (VUINT32) ((0x3FBBF04005723CCCuLL) >> 32)},
    {(VUINT32) ((0x3FD7733D1300258AuLL) >> 0),
     (VUINT32) ((0x3FD7733D1300258AuLL) >> 32)},
    {(VUINT32) ((0x3FDF688E6ACC7DF5uLL) >> 0),
     (VUINT32) ((0x3FDF688E6ACC7DF5uLL) >> 32)},
    {(VUINT32) ((0x3FD231520EA793C8uLL) >> 0),
     (VUINT32) ((0x3FD231520EA793C8uLL) >> 32)},
    {(VUINT32) ((0x3FD20E93C5183A32uLL) >> 0),
     (VUINT32) ((0x3FD20E93C5183A32uLL) >> 32)},
    {(VUINT32) ((0x3FC91A331D55B3EEuLL) >> 0),
     (VUINT32) ((0x3FC91A331D55B3EEuLL) >> 32)},
    {(VUINT32) ((0x3FC651721E153056uLL) >> 0),
     (VUINT32) ((0x3FC651721E153056uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF3D4D0507DCB95uLL) >> 0),
     (VUINT32) ((0x3FF3D4D0507DCB95uLL) >> 32)},
    {(VUINT32) ((0x3C83DA34489C213BuLL) >> 0),
     (VUINT32) ((0x3C83DA34489C213BuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD604775FBB27DFuLL) >> 0),
     (VUINT32) ((0x3FD604775FBB27DFuLL) >> 32)},
    {(VUINT32) ((0x3C6AC647C9CF38D0uLL) >> 0),
     (VUINT32) ((0x3C6AC647C9CF38D0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBE4C49866D2D78uLL) >> 0),
     (VUINT32) ((0x3FBE4C49866D2D78uLL) >> 32)},
    {(VUINT32) ((0x3FD89F8D033946D5uLL) >> 0),
     (VUINT32) ((0x3FD89F8D033946D5uLL) >> 32)},
    {(VUINT32) ((0x3FE02A20954EE23AuLL) >> 0),
     (VUINT32) ((0x3FE02A20954EE23AuLL) >> 32)},
    {(VUINT32) ((0x3FD35466F88C5ABCuLL) >> 0),
     (VUINT32) ((0x3FD35466F88C5ABCuLL) >> 32)},
    {(VUINT32) ((0x3FD3044BAC5DC8C8uLL) >> 0),
     (VUINT32) ((0x3FD3044BAC5DC8C8uLL) >> 32)},
    {(VUINT32) ((0x3FCB110C3D6FEB5EuLL) >> 0),
     (VUINT32) ((0x3FCB110C3D6FEB5EuLL) >> 32)},
    {(VUINT32) ((0x3FC7761A8DBF67E9uLL) >> 0),
     (VUINT32) ((0x3FC7761A8DBF67E9uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF3A28C59D5433BuLL) >> 0),
     (VUINT32) ((0x3FF3A28C59D5433BuLL) >> 32)},
    {(VUINT32) ((0xBC61B19140C0C0D5uLL) >> 0),
     (VUINT32) ((0xBC61B19140C0C0D5uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD6E649F7D78649uLL) >> 0),
     (VUINT32) ((0x3FD6E649F7D78649uLL) >> 32)},
    {(VUINT32) ((0x3C678D2AC032531AuLL) >> 0),
     (VUINT32) ((0x3C678D2AC032531AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC0631EFCBE0D16uLL) >> 0),
     (VUINT32) ((0x3FC0631EFCBE0D16uLL) >> 32)},
    {(VUINT32) ((0x3FD9D4CEDF38DFCDuLL) >> 0),
     (VUINT32) ((0x3FD9D4CEDF38DFCDuLL) >> 32)},
    {(VUINT32) ((0x3FE0A74F7488C3A6uLL) >> 0),
     (VUINT32) ((0x3FE0A74F7488C3A6uLL) >> 32)},
    {(VUINT32) ((0x3FD487249EA3BD6CuLL) >> 0),
     (VUINT32) ((0x3FD487249EA3BD6CuLL) >> 32)},
    {(VUINT32) ((0x3FD40D3A9BDEFA27uLL) >> 0),
     (VUINT32) ((0x3FD40D3A9BDEFA27uLL) >> 32)},
    {(VUINT32) ((0x3FCD2F1CBD1B58BDuLL) >> 0),
     (VUINT32) ((0x3FCD2F1CBD1B58BDuLL) >> 32)},
    {(VUINT32) ((0x3FC98CBDCEBDACE8uLL) >> 0),
     (VUINT32) ((0x3FC98CBDCEBDACE8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF37048632CBAE1uLL) >> 0),
     (VUINT32) ((0x3FF37048632CBAE1uLL) >> 32)},
    {(VUINT32) ((0xBC8CB2FCE8FC81A5uLL) >> 0),
     (VUINT32) ((0xBC8CB2FCE8FC81A5uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD7CA1A832D0F84uLL) >> 0),
     (VUINT32) ((0x3FD7CA1A832D0F84uLL) >> 32)},
    {(VUINT32) ((0xBC7EE5A71208FD7EuLL) >> 0),
     (VUINT32) ((0xBC7EE5A71208FD7EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC1AF828B5ED674uLL) >> 0),
     (VUINT32) ((0x3FC1AF828B5ED674uLL) >> 32)},
    {(VUINT32) ((0x3FDB13909C0269A2uLL) >> 0),
     (VUINT32) ((0x3FDB13909C0269A2uLL) >> 32)},
    {(VUINT32) ((0x3FE12C3A0394B7FAuLL) >> 0),
     (VUINT32) ((0x3FE12C3A0394B7FAuLL) >> 32)},
    {(VUINT32) ((0x3FD5CAC4A421216CuLL) >> 0),
     (VUINT32) ((0x3FD5CAC4A421216CuLL) >> 32)},
    {(VUINT32) ((0x3FD52AE625505253uLL) >> 0),
     (VUINT32) ((0x3FD52AE625505253uLL) >> 32)},
    {(VUINT32) ((0x3FCF7831018A6159uLL) >> 0),
     (VUINT32) ((0x3FCF7831018A6159uLL) >> 32)},
    {(VUINT32) ((0x3FCB98AB42F54A08uLL) >> 0),
     (VUINT32) ((0x3FCB98AB42F54A08uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF33E046C843287uLL) >> 0),
     (VUINT32) ((0x3FF33E046C843287uLL) >> 32)},
    {(VUINT32) ((0xBC9A7CCAC0E4698BuLL) >> 0),
     (VUINT32) ((0xBC9A7CCAC0E4698BuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD8B00196B3D022uLL) >> 0),
     (VUINT32) ((0x3FD8B00196B3D022uLL) >> 32)},
    {(VUINT32) ((0xBC67341EE3041CF4uLL) >> 0),
     (VUINT32) ((0xBC67341EE3041CF4uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC30BCA73878656uLL) >> 0),
     (VUINT32) ((0x3FC30BCA73878656uLL) >> 32)},
    {(VUINT32) ((0x3FDC5C67FF403B73uLL) >> 0),
     (VUINT32) ((0x3FDC5C67FF403B73uLL) >> 32)},
    {(VUINT32) ((0x3FE1B94E72981059uLL) >> 0),
     (VUINT32) ((0x3FE1B94E72981059uLL) >> 32)},
    {(VUINT32) ((0x3FD7209990BAE1F6uLL) >> 0),
     (VUINT32) ((0x3FD7209990BAE1F6uLL) >> 32)},
    {(VUINT32) ((0x3FD65EF72AC3A4FAuLL) >> 0),
     (VUINT32) ((0x3FD65EF72AC3A4FAuLL) >> 32)},
    {(VUINT32) ((0x3FD0F83D8377C340uLL) >> 0),
     (VUINT32) ((0x3FD0F83D8377C340uLL) >> 32)},
    {(VUINT32) ((0x3FCD97555AF455A0uLL) >> 0),
     (VUINT32) ((0x3FCD97555AF455A0uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF30BC075DBAA2CuLL) >> 0),
     (VUINT32) ((0x3FF30BC075DBAA2CuLL) >> 32)},
    {(VUINT32) ((0x3C995FE8F2B56DBDuLL) >> 0),
     (VUINT32) ((0x3C995FE8F2B56DBDuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD998188E816BF0uLL) >> 0),
     (VUINT32) ((0x3FD998188E816BF0uLL) >> 32)},
    {(VUINT32) ((0x3C73DB2BD13E24E8uLL) >> 0),
     (VUINT32) ((0x3C73DB2BD13E24E8uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC478794806DE66uLL) >> 0),
     (VUINT32) ((0x3FC478794806DE66uLL) >> 32)},
    {(VUINT32) ((0x3FDDAFF33BF96274uLL) >> 0),
     (VUINT32) ((0x3FDDAFF33BF96274uLL) >> 32)},
    {(VUINT32) ((0x3FE24F039543C659uLL) >> 0),
     (VUINT32) ((0x3FE24F039543C659uLL) >> 32)},
    {(VUINT32) ((0x3FD88A113E071D2DuLL) >> 0),
     (VUINT32) ((0x3FD88A113E071D2DuLL) >> 32)},
    {(VUINT32) ((0x3FD7AB3E661E65FAuLL) >> 0),
     (VUINT32) ((0x3FD7AB3E661E65FAuLL) >> 32)},
    {(VUINT32) ((0x3FD24E4E1B8DC6C3uLL) >> 0),
     (VUINT32) ((0x3FD24E4E1B8DC6C3uLL) >> 32)},
    {(VUINT32) ((0x3FD01ED5FCAC1031uLL) >> 0),
     (VUINT32) ((0x3FD01ED5FCAC1031uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0x3FF2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0x3C8A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0x3C8A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDA827999FCEF32uLL) >> 0),
     (VUINT32) ((0x3FDA827999FCEF32uLL) >> 32)},
    {(VUINT32) ((0x3C708A11019E58E9uLL) >> 0),
     (VUINT32) ((0x3C708A11019E58E9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC5F619980C4336uLL) >> 0),
     (VUINT32) ((0x3FC5F619980C4336uLL) >> 32)},
    {(VUINT32) ((0x3FDF0ED99BED9B65uLL) >> 0),
     (VUINT32) ((0x3FDF0ED99BED9B65uLL) >> 32)},
    {(VUINT32) ((0x3FE2EDD996C1BBEBuLL) >> 0),
     (VUINT32) ((0x3FE2EDD996C1BBEBuLL) >> 32)},
    {(VUINT32) ((0x3FDA08B785C6EA59uLL) >> 0),
     (VUINT32) ((0x3FDA08B785C6EA59uLL) >> 32)},
    {(VUINT32) ((0x3FD911BC7B12902DuLL) >> 0),
     (VUINT32) ((0x3FD911BC7B12902DuLL) >> 32)},
    {(VUINT32) ((0x3FD3C0DA5B1130BAuLL) >> 0),
     (VUINT32) ((0x3FD3C0DA5B1130BAuLL) >> 32)},
    {(VUINT32) ((0x3FD1B590151E4269uLL) >> 0),
     (VUINT32) ((0x3FD1B590151E4269uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF2A738888A9978uLL) >> 0),
     (VUINT32) ((0x3FF2A738888A9978uLL) >> 32)},
    {(VUINT32) ((0x3C5195059E91C4D2uLL) >> 0),
     (VUINT32) ((0x3C5195059E91C4D2uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDB6F3FC8C61E5BuLL) >> 0),
     (VUINT32) ((0x3FDB6F3FC8C61E5BuLL) >> 32)},
    {(VUINT32) ((0xBC6A1CC48267E6BEuLL) >> 0),
     (VUINT32) ((0xBC6A1CC48267E6BEuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC7853E65CE5524uLL) >> 0),
     (VUINT32) ((0x3FC7853E65CE5524uLL) >> 32)},
    {(VUINT32) ((0x3FE03CE61B6A9E63uLL) >> 0),
     (VUINT32) ((0x3FE03CE61B6A9E63uLL) >> 32)},
    {(VUINT32) ((0x3FE3965ABF5C8FABuLL) >> 0),
     (VUINT32) ((0x3FE3965ABF5C8FABuLL) >> 32)},
    {(VUINT32) ((0x3FDB9E3938F261E9uLL) >> 0),
     (VUINT32) ((0x3FDB9E3938F261E9uLL) >> 32)},
    {(VUINT32) ((0x3FDA94A771ED6FE6uLL) >> 0),
     (VUINT32) ((0x3FDA94A771ED6FE6uLL) >> 32)},
    {(VUINT32) ((0x3FD552B7D4636639uLL) >> 0),
     (VUINT32) ((0x3FD552B7D4636639uLL) >> 32)},
    {(VUINT32) ((0x3FD2F58F20A08A92uLL) >> 0),
     (VUINT32) ((0x3FD2F58F20A08A92uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF274F491E2111EuLL) >> 0),
     (VUINT32) ((0x3FF274F491E2111EuLL) >> 32)},
    {(VUINT32) ((0xBC8613F7E4FA18D6uLL) >> 0),
     (VUINT32) ((0xBC8613F7E4FA18D6uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDC5E87185E67B6uLL) >> 0),
     (VUINT32) ((0x3FDC5E87185E67B6uLL) >> 32)},
    {(VUINT32) ((0x3C4FEBA1F149DF00uLL) >> 0),
     (VUINT32) ((0x3C4FEBA1F149DF00uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC92683A68EB5D0uLL) >> 0),
     (VUINT32) ((0x3FC92683A68EB5D0uLL) >> 32)},
    {(VUINT32) ((0x3FE0F8C35C7247C7uLL) >> 0),
     (VUINT32) ((0x3FE0F8C35C7247C7uLL) >> 32)},
    {(VUINT32) ((0x3FE4491C4DCA262EuLL) >> 0),
     (VUINT32) ((0x3FE4491C4DCA262EuLL) >> 32)},
    {(VUINT32) ((0x3FDD4C67683395D6uLL) >> 0),
     (VUINT32) ((0x3FDD4C67683395D6uLL) >> 32)},
    {(VUINT32) ((0x3FDC3667C15EBF94uLL) >> 0),
     (VUINT32) ((0x3FDC3667C15EBF94uLL) >> 32)},
    {(VUINT32) ((0x3FD7070B7FE443C4uLL) >> 0),
     (VUINT32) ((0x3FD7070B7FE443C4uLL) >> 32)},
    {(VUINT32) ((0x3FD4805841782C0CuLL) >> 0),
     (VUINT32) ((0x3FD4805841782C0CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF242B09B3988C4uLL) >> 0),
     (VUINT32) ((0x3FF242B09B3988C4uLL) >> 32)},
    {(VUINT32) ((0xBC972D483EE33523uLL) >> 0),
     (VUINT32) ((0xBC972D483EE33523uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDD506C82A2C800uLL) >> 0),
     (VUINT32) ((0x3FDD506C82A2C800uLL) >> 32)},
    {(VUINT32) ((0x3C6E169413E029AEuLL) >> 0),
     (VUINT32) ((0x3C6E169413E029AEuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCADA8ECCC42C48uLL) >> 0),
     (VUINT32) ((0x3FCADA8ECCC42C48uLL) >> 32)},
    {(VUINT32) ((0x3FE1BB681D0BE8A7uLL) >> 0),
     (VUINT32) ((0x3FE1BB681D0BE8A7uLL) >> 32)},
    {(VUINT32) ((0x3FE506BF662527D3uLL) >> 0),
     (VUINT32) ((0x3FE506BF662527D3uLL) >> 32)},
    {(VUINT32) ((0x3FDF153B07CB2306uLL) >> 0),
     (VUINT32) ((0x3FDF153B07CB2306uLL) >> 32)},
    {(VUINT32) ((0x3FDDF9A636394DC9uLL) >> 0),
     (VUINT32) ((0x3FDDF9A636394DC9uLL) >> 32)},
    {(VUINT32) ((0x3FD8E153A4A78673uLL) >> 0),
     (VUINT32) ((0x3FD8E153A4A78673uLL) >> 32)},
    {(VUINT32) ((0x3FD6937B3797DBB1uLL) >> 0),
     (VUINT32) ((0x3FD6937B3797DBB1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF2106CA4910069uLL) >> 0),
     (VUINT32) ((0x3FF2106CA4910069uLL) >> 32)},
    {(VUINT32) ((0x3C9CAF6B74B6A225uLL) >> 0),
     (VUINT32) ((0x3C9CAF6B74B6A225uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDE450E0D273E7AuLL) >> 0),
     (VUINT32) ((0x3FDE450E0D273E7AuLL) >> 32)},
    {(VUINT32) ((0x3C74138BBC424A0DuLL) >> 0),
     (VUINT32) ((0x3C74138BBC424A0DuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCCA20F5D4879EAuLL) >> 0),
     (VUINT32) ((0x3FCCA20F5D4879EAuLL) >> 32)},
    {(VUINT32) ((0x3FE2853E13FBB7C7uLL) >> 0),
     (VUINT32) ((0x3FE2853E13FBB7C7uLL) >> 32)},
    {(VUINT32) ((0x3FE5CFF21905E477uLL) >> 0),
     (VUINT32) ((0x3FE5CFF21905E477uLL) >> 32)},
    {(VUINT32) ((0x3FE07D6C7D0DAC66uLL) >> 0),
     (VUINT32) ((0x3FE07D6C7D0DAC66uLL) >> 32)},
    {(VUINT32) ((0x3FDFE1550F550216uLL) >> 0),
     (VUINT32) ((0x3FDFE1550F550216uLL) >> 32)},
    {(VUINT32) ((0x3FDAE570CE7F6BD7uLL) >> 0),
     (VUINT32) ((0x3FDAE570CE7F6BD7uLL) >> 32)},
    {(VUINT32) ((0x3FD89328A3ABE601uLL) >> 0),
     (VUINT32) ((0x3FD89328A3ABE601uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF1DE28ADE8780FuLL) >> 0),
     (VUINT32) ((0x3FF1DE28ADE8780FuLL) >> 32)},
    {(VUINT32) ((0x3C908C1F2850796DuLL) >> 0),
     (VUINT32) ((0x3C908C1F2850796DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDF3C8AD985D9EEuLL) >> 0),
     (VUINT32) ((0x3FDF3C8AD985D9EEuLL) >> 32)},
    {(VUINT32) ((0x3C455C31F5355658uLL) >> 0),
     (VUINT32) ((0x3C455C31F5355658uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCE7DBF907D8618uLL) >> 0),
     (VUINT32) ((0x3FCE7DBF907D8618uLL) >> 32)},
    {(VUINT32) ((0x3FE356B5A1D9CA5AuLL) >> 0),
     (VUINT32) ((0x3FE356B5A1D9CA5AuLL) >> 32)},
    {(VUINT32) ((0x3FE6A57085697F99uLL) >> 0),
     (VUINT32) ((0x3FE6A57085697F99uLL) >> 32)},
    {(VUINT32) ((0x3FE17FCB46BE280BuLL) >> 0),
     (VUINT32) ((0x3FE17FCB46BE280BuLL) >> 32)},
    {(VUINT32) ((0x3FE0F858275BAA48uLL) >> 0),
     (VUINT32) ((0x3FE0F858275BAA48uLL) >> 32)},
    {(VUINT32) ((0x3FDD17B47CA8A83BuLL) >> 0),
     (VUINT32) ((0x3FDD17B47CA8A83BuLL) >> 32)},
    {(VUINT32) ((0x3FDA9B369A707A32uLL) >> 0),
     (VUINT32) ((0x3FDA9B369A707A32uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF1ABE4B73FEFB5uLL) >> 0),
     (VUINT32) ((0x3FF1ABE4B73FEFB5uLL) >> 32)},
    {(VUINT32) ((0x3C71A34B6FA942D3uLL) >> 0),
     (VUINT32) ((0x3C71A34B6FA942D3uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE01B819B5A7CF7uLL) >> 0),
     (VUINT32) ((0x3FE01B819B5A7CF7uLL) >> 32)},
    {(VUINT32) ((0x3C80BED996FBB65FuLL) >> 0),
     (VUINT32) ((0x3C80BED996FBB65FuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD03732803B2A4CuLL) >> 0),
     (VUINT32) ((0x3FD03732803B2A4CuLL) >> 32)},
    {(VUINT32) ((0x3FE430465B55C6C0uLL) >> 0),
     (VUINT32) ((0x3FE430465B55C6C0uLL) >> 32)},
    {(VUINT32) ((0x3FE78806185ACF72uLL) >> 0),
     (VUINT32) ((0x3FE78806185ACF72uLL) >> 32)},
    {(VUINT32) ((0x3FE292FF3DF61A34uLL) >> 0),
     (VUINT32) ((0x3FE292FF3DF61A34uLL) >> 32)},
    {(VUINT32) ((0x3FE215A449967BC2uLL) >> 0),
     (VUINT32) ((0x3FE215A449967BC2uLL) >> 32)},
    {(VUINT32) ((0x3FDF7CEF2946D3A8uLL) >> 0),
     (VUINT32) ((0x3FDF7CEF2946D3A8uLL) >> 32)},
    {(VUINT32) ((0x3FDD0F4FF3CD442FuLL) >> 0),
     (VUINT32) ((0x3FDD0F4FF3CD442FuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF179A0C097675BuLL) >> 0),
     (VUINT32) ((0x3FF179A0C097675BuLL) >> 32)},
    {(VUINT32) ((0xBC7EE9E5C1EF600DuLL) >> 0),
     (VUINT32) ((0xBC7EE9E5C1EF600DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE09A4C59BD0D4DuLL) >> 0),
     (VUINT32) ((0x3FE09A4C59BD0D4DuLL) >> 32)},
    {(VUINT32) ((0xBC451D94A7B70320uLL) >> 0),
     (VUINT32) ((0xBC451D94A7B70320uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD13A68B2A5E855uLL) >> 0),
     (VUINT32) ((0x3FD13A68B2A5E855uLL) >> 32)},
    {(VUINT32) ((0x3FE5126F9FD8D89FuLL) >> 0),
     (VUINT32) ((0x3FE5126F9FD8D89FuLL) >> 32)},
    {(VUINT32) ((0x3FE8788EEDC53F19uLL) >> 0),
     (VUINT32) ((0x3FE8788EEDC53F19uLL) >> 32)},
    {(VUINT32) ((0x3FE3B86B3E883B76uLL) >> 0),
     (VUINT32) ((0x3FE3B86B3E883B76uLL) >> 32)},
    {(VUINT32) ((0x3FE34A881E7F09C9uLL) >> 0),
     (VUINT32) ((0x3FE34A881E7F09C9uLL) >> 32)},
    {(VUINT32) ((0x3FE10D3EF07D106AuLL) >> 0),
     (VUINT32) ((0x3FE10D3EF07D106AuLL) >> 32)},
    {(VUINT32) ((0x3FDFEBFE6AA0C4E7uLL) >> 0),
     (VUINT32) ((0x3FDFEBFE6AA0C4E7uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF1475CC9EEDF01uLL) >> 0),
     (VUINT32) ((0x3FF1475CC9EEDF01uLL) >> 32)},
    {(VUINT32) ((0xBC93DDC5BCE200BBuLL) >> 0),
     (VUINT32) ((0xBC93DDC5BCE200BBuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE11AB7190834ECuLL) >> 0),
     (VUINT32) ((0x3FE11AB7190834ECuLL) >> 32)},
    {(VUINT32) ((0xBC8E577A07DB7162uLL) >> 0),
     (VUINT32) ((0xBC8E577A07DB7162uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD248F1B07217E3uLL) >> 0),
     (VUINT32) ((0x3FD248F1B07217E3uLL) >> 32)},
    {(VUINT32) ((0x3FE5FDB93DD01D06uLL) >> 0),
     (VUINT32) ((0x3FE5FDB93DD01D06uLL) >> 32)},
    {(VUINT32) ((0x3FE977F956462152uLL) >> 0),
     (VUINT32) ((0x3FE977F956462152uLL) >> 32)},
    {(VUINT32) ((0x3FE4F192BE91E40AuLL) >> 0),
     (VUINT32) ((0x3FE4F192BE91E40AuLL) >> 32)},
    {(VUINT32) ((0x3FE49932EEB2A51BuLL) >> 0),
     (VUINT32) ((0x3FE49932EEB2A51BuLL) >> 32)},
    {(VUINT32) ((0x3FE27B305435DE1BuLL) >> 0),
     (VUINT32) ((0x3FE27B305435DE1BuLL) >> 32)},
    {(VUINT32) ((0x3FE176C2BDD3B0A4uLL) >> 0),
     (VUINT32) ((0x3FE176C2BDD3B0A4uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF11518D34656A6uLL) >> 0),
     (VUINT32) ((0x3FF11518D34656A6uLL) >> 32)},
    {(VUINT32) ((0x3C9FFEEDF6B7D68DuLL) >> 0),
     (VUINT32) ((0x3C9FFEEDF6B7D68DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE19CD3FE8E405DuLL) >> 0),
     (VUINT32) ((0x3FE19CD3FE8E405DuLL) >> 32)},
    {(VUINT32) ((0xBC84E5C1D482FB99uLL) >> 0),
     (VUINT32) ((0xBC84E5C1D482FB99uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD36343ADCAF866uLL) >> 0),
     (VUINT32) ((0x3FD36343ADCAF866uLL) >> 32)},
    {(VUINT32) ((0x3FE6F2B4260FF6A8uLL) >> 0),
     (VUINT32) ((0x3FE6F2B4260FF6A8uLL) >> 32)},
    {(VUINT32) ((0x3FEA8747864942E1uLL) >> 0),
     (VUINT32) ((0x3FEA8747864942E1uLL) >> 32)},
    {(VUINT32) ((0x3FE6401D47362936uLL) >> 0),
     (VUINT32) ((0x3FE6401D47362936uLL) >> 32)},
    {(VUINT32) ((0x3FE6040F50A52FBFuLL) >> 0),
     (VUINT32) ((0x3FE6040F50A52FBFuLL) >> 32)},
    {(VUINT32) ((0x3FE40BA6192CC669uLL) >> 0),
     (VUINT32) ((0x3FE40BA6192CC669uLL) >> 32)},
    {(VUINT32) ((0x3FE302E7DAB9BDE8uLL) >> 0),
     (VUINT32) ((0x3FE302E7DAB9BDE8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF0E2D4DC9DCE4CuLL) >> 0),
     (VUINT32) ((0x3FF0E2D4DC9DCE4CuLL) >> 32)},
    {(VUINT32) ((0x3C93DBA1AA51ADD5uLL) >> 0),
     (VUINT32) ((0x3C93DBA1AA51ADD5uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE220B5EF047825uLL) >> 0),
     (VUINT32) ((0x3FE220B5EF047825uLL) >> 32)},
    {(VUINT32) ((0x3C5AE1F6C713C510uLL) >> 0),
     (VUINT32) ((0x3C5AE1F6C713C510uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD489DC399ADDECuLL) >> 0),
     (VUINT32) ((0x3FD489DC399ADDECuLL) >> 32)},
    {(VUINT32) ((0x3FE7F1FB2FEBE8C6uLL) >> 0),
     (VUINT32) ((0x3FE7F1FB2FEBE8C6uLL) >> 32)},
    {(VUINT32) ((0x3FEBA791734D6CCEuLL) >> 0),
     (VUINT32) ((0x3FEBA791734D6CCEuLL) >> 32)},
    {(VUINT32) ((0x3FE7A5DA56BAB9DAuLL) >> 0),
     (VUINT32) ((0x3FE7A5DA56BAB9DAuLL) >> 32)},
    {(VUINT32) ((0x3FE78DC9A17C17D7uLL) >> 0),
     (VUINT32) ((0x3FE78DC9A17C17D7uLL) >> 32)},
    {(VUINT32) ((0x3FE5C262725357A1uLL) >> 0),
     (VUINT32) ((0x3FE5C262725357A1uLL) >> 32)},
    {(VUINT32) ((0x3FE4D1FE58052A33uLL) >> 0),
     (VUINT32) ((0x3FE4D1FE58052A33uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF0B090E5F545F2uLL) >> 0),
     (VUINT32) ((0x3FF0B090E5F545F2uLL) >> 32)},
    {(VUINT32) ((0x3C7EE15577AE1472uLL) >> 0),
     (VUINT32) ((0x3C7EE15577AE1472uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE2A6709A74F289uLL) >> 0),
     (VUINT32) ((0x3FE2A6709A74F289uLL) >> 32)},
    {(VUINT32) ((0x3C76E3B98C26B440uLL) >> 0),
     (VUINT32) ((0x3C76E3B98C26B440uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD5BD40BF249496uLL) >> 0),
     (VUINT32) ((0x3FD5BD40BF249496uLL) >> 32)},
    {(VUINT32) ((0x3FE8FC33EFCF6F3AuLL) >> 0),
     (VUINT32) ((0x3FE8FC33EFCF6F3AuLL) >> 32)},
    {(VUINT32) ((0x3FECDA06E4CFC822uLL) >> 0),
     (VUINT32) ((0x3FECDA06E4CFC822uLL) >> 32)},
    {(VUINT32) ((0x3FE924C5BA1C7515uLL) >> 0),
     (VUINT32) ((0x3FE924C5BA1C7515uLL) >> 32)},
    {(VUINT32) ((0x3FE9395A86CEDBCCuLL) >> 0),
     (VUINT32) ((0x3FE9395A86CEDBCCuLL) >> 32)},
    {(VUINT32) ((0x3FE7A39B6931C7C5uLL) >> 0),
     (VUINT32) ((0x3FE7A39B6931C7C5uLL) >> 32)},
    {(VUINT32) ((0x3FE6D875BED7333EuLL) >> 0),
     (VUINT32) ((0x3FE6D875BED7333EuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF07E4CEF4CBD98uLL) >> 0),
     (VUINT32) ((0x3FF07E4CEF4CBD98uLL) >> 32)},
    {(VUINT32) ((0xBC71ABDBB9EA8E6EuLL) >> 0),
     (VUINT32) ((0xBC71ABDBB9EA8E6EuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE32E1889047FFDuLL) >> 0),
     (VUINT32) ((0x3FE32E1889047FFDuLL) >> 32)},
    {(VUINT32) ((0xBC810D08F0134DCFuLL) >> 0),
     (VUINT32) ((0xBC810D08F0134DCFuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD6FDFF12A4297BuLL) >> 0),
     (VUINT32) ((0x3FD6FDFF12A4297BuLL) >> 32)},
    {(VUINT32) ((0x3FEA120FA25B9D83uLL) >> 0),
     (VUINT32) ((0x3FEA120FA25B9D83uLL) >> 32)},
    {(VUINT32) ((0x3FEE1FF1BF27E6ABuLL) >> 0),
     (VUINT32) ((0x3FEE1FF1BF27E6ABuLL) >> 32)},
    {(VUINT32) ((0x3FEABF0C6E045EA0uLL) >> 0),
     (VUINT32) ((0x3FEABF0C6E045EA0uLL) >> 32)},
    {(VUINT32) ((0x3FEB0A0E2CDCAB88uLL) >> 0),
     (VUINT32) ((0x3FEB0A0E2CDCAB88uLL) >> 32)},
    {(VUINT32) ((0x3FE9B40D41660E8EuLL) >> 0),
     (VUINT32) ((0x3FE9B40D41660E8EuLL) >> 32)},
    {(VUINT32) ((0x3FE92FCC1848D932uLL) >> 0),
     (VUINT32) ((0x3FE92FCC1848D932uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF04C08F8A4353EuLL) >> 0),
     (VUINT32) ((0x3FF04C08F8A4353EuLL) >> 32)},
    {(VUINT32) ((0xBC908E433AE0CC54uLL) >> 0),
     (VUINT32) ((0xBC908E433AE0CC54uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE3B7C3289ED6F3uLL) >> 0),
     (VUINT32) ((0x3FE3B7C3289ED6F3uLL) >> 32)},
    {(VUINT32) ((0xBC8C4CF3D327FEECuLL) >> 0),
     (VUINT32) ((0xBC8C4CF3D327FEECuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD84CAE0A06DE7CuLL) >> 0),
     (VUINT32) ((0x3FD84CAE0A06DE7CuLL) >> 32)},
    {(VUINT32) ((0x3FEB344C2E4C0F47uLL) >> 0),
     (VUINT32) ((0x3FEB344C2E4C0F47uLL) >> 32)},
    {(VUINT32) ((0x3FEF7AB88F5F820CuLL) >> 0),
     (VUINT32) ((0x3FEF7AB88F5F820CuLL) >> 32)},
    {(VUINT32) ((0x3FEC771219A99E98uLL) >> 0),
     (VUINT32) ((0x3FEC771219A99E98uLL) >> 32)},
    {(VUINT32) ((0x3FED0390B144EACBuLL) >> 0),
     (VUINT32) ((0x3FED0390B144EACBuLL) >> 32)},
    {(VUINT32) ((0x3FEBF90A32A17503uLL) >> 0),
     (VUINT32) ((0x3FEBF90A32A17503uLL) >> 32)},
    {(VUINT32) ((0x3FEBAC50A2912BE1uLL) >> 0),
     (VUINT32) ((0x3FEBAC50A2912BE1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FF019C501FBACE4uLL) >> 0),
     (VUINT32) ((0x3FF019C501FBACE4uLL) >> 32)},
    {(VUINT32) ((0xBC9CB18F8746F50CuLL) >> 0),
     (VUINT32) ((0xBC9CB18F8746F50CuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE44386DB9CE5DBuLL) >> 0),
     (VUINT32) ((0x3FE44386DB9CE5DBuLL) >> 32)},
    {(VUINT32) ((0xBC8A7F79AD342CDEuLL) >> 0),
     (VUINT32) ((0xBC8A7F79AD342CDEuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD9A9EE22E82AF2uLL) >> 0),
     (VUINT32) ((0x3FD9A9EE22E82AF2uLL) >> 32)},
    {(VUINT32) ((0x3FEC63B53FACFD1BuLL) >> 0),
     (VUINT32) ((0x3FEC63B53FACFD1BuLL) >> 32)},
    {(VUINT32) ((0x3FF075F0B010F1C9uLL) >> 0),
     (VUINT32) ((0x3FF075F0B010F1C9uLL) >> 32)},
    {(VUINT32) ((0x3FEE4F7738A37AC1uLL) >> 0),
     (VUINT32) ((0x3FEE4F7738A37AC1uLL) >> 32)},
    {(VUINT32) ((0x3FEF29F7068A6E02uLL) >> 0),
     (VUINT32) ((0x3FEF29F7068A6E02uLL) >> 32)},
    {(VUINT32) ((0x3FEE78912F3E4890uLL) >> 0),
     (VUINT32) ((0x3FEE78912F3E4890uLL) >> 32)},
    {(VUINT32) ((0x3FEE7DE5AD19FDA8uLL) >> 0),
     (VUINT32) ((0x3FEE7DE5AD19FDA8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEFCF0216A64913uLL) >> 0),
     (VUINT32) ((0x3FEFCF0216A64913uLL) >> 32)},
    {(VUINT32) ((0xBC81A9B7A75A3B87uLL) >> 0),
     (VUINT32) ((0xBC81A9B7A75A3B87uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE4D17B087B265DuLL) >> 0),
     (VUINT32) ((0x3FE4D17B087B265DuLL) >> 32)},
    {(VUINT32) ((0xBC788AAC4AE1F0D0uLL) >> 0),
     (VUINT32) ((0xBC788AAC4AE1F0D0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDB166A3723839CuLL) >> 0),
     (VUINT32) ((0x3FDB166A3723839CuLL) >> 32)},
    {(VUINT32) ((0x3FEDA1257F3D5E87uLL) >> 0),
     (VUINT32) ((0x3FEDA1257F3D5E87uLL) >> 32)},
    {(VUINT32) ((0x3FF13A8A70704F6BuLL) >> 0),
     (VUINT32) ((0x3FF13A8A70704F6BuLL) >> 32)},
    {(VUINT32) ((0x3FF025900612C493uLL) >> 0),
     (VUINT32) ((0x3FF025900612C493uLL) >> 32)},
    {(VUINT32) ((0x3FF0C0E778680DE8uLL) >> 0),
     (VUINT32) ((0x3FF0C0E778680DE8uLL) >> 32)},
    {(VUINT32) ((0x3FF09CB2B02DFCCBuLL) >> 0),
     (VUINT32) ((0x3FF09CB2B02DFCCBuLL) >> 32)},
    {(VUINT32) ((0x3FF0D681147681D3uLL) >> 0),
     (VUINT32) ((0x3FF0D681147681D3uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEF6A7A2955385EuLL) >> 0),
     (VUINT32) ((0x3FEF6A7A2955385EuLL) >> 32)},
    {(VUINT32) ((0x3C860FAFBFD97309uLL) >> 0),
     (VUINT32) ((0x3C860FAFBFD97309uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE561B82AB7F990uLL) >> 0),
     (VUINT32) ((0x3FE561B82AB7F990uLL) >> 32)},
    {(VUINT32) ((0x3C87A5FA3E37FD12uLL) >> 0),
     (VUINT32) ((0x3C87A5FA3E37FD12uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDC92D84170BCC6uLL) >> 0),
     (VUINT32) ((0x3FDC92D84170BCC6uLL) >> 32)},
    {(VUINT32) ((0x3FEEED87E934644CuLL) >> 0),
     (VUINT32) ((0x3FEEED87E934644CuLL) >> 32)},
    {(VUINT32) ((0x3FF20C10F4D7D072uLL) >> 0),
     (VUINT32) ((0x3FF20C10F4D7D072uLL) >> 32)},
    {(VUINT32) ((0x3FF1369E37DA5741uLL) >> 0),
     (VUINT32) ((0x3FF1369E37DA5741uLL) >> 32)},
    {(VUINT32) ((0x3FF20816F61AB3EEuLL) >> 0),
     (VUINT32) ((0x3FF20816F61AB3EEuLL) >> 32)},
    {(VUINT32) ((0x3FF221953D8712EFuLL) >> 0),
     (VUINT32) ((0x3FF221953D8712EFuLL) >> 32)},
    {(VUINT32) ((0x3FF29CA76CD561F8uLL) >> 0),
     (VUINT32) ((0x3FF29CA76CD561F8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEF05F23C0427AAuLL) >> 0),
     (VUINT32) ((0x3FEF05F23C0427AAuLL) >> 32)},
    {(VUINT32) ((0xBC51B746C796F33CuLL) >> 0),
     (VUINT32) ((0xBC51B746C796F33CuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE5F457E4F4812EuLL) >> 0),
     (VUINT32) ((0x3FE5F457E4F4812EuLL) >> 32)},
    {(VUINT32) ((0x3C8F6EE06A43F015uLL) >> 0),
     (VUINT32) ((0x3C8F6EE06A43F015uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDE1FFA33ABCB2DuLL) >> 0),
     (VUINT32) ((0x3FDE1FFA33ABCB2DuLL) >> 32)},
    {(VUINT32) ((0x3FF024ECA3857FDFuLL) >> 0),
     (VUINT32) ((0x3FF024ECA3857FDFuLL) >> 32)},
    {(VUINT32) ((0x3FF2EB80B3E2C969uLL) >> 0),
     (VUINT32) ((0x3FF2EB80B3E2C969uLL) >> 32)},
    {(VUINT32) ((0x3FF25CA858ECE33EuLL) >> 0),
     (VUINT32) ((0x3FF25CA858ECE33EuLL) >> 32)},
    {(VUINT32) ((0x3FF36D6159DB2BC3uLL) >> 0),
     (VUINT32) ((0x3FF36D6159DB2BC3uLL) >> 32)},
    {(VUINT32) ((0x3FF3CF427530AFA1uLL) >> 0),
     (VUINT32) ((0x3FF3CF427530AFA1uLL) >> 32)},
    {(VUINT32) ((0x3FF4914D16BF30D2uLL) >> 0),
     (VUINT32) ((0x3FF4914D16BF30D2uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEEA16A4EB316F6uLL) >> 0),
     (VUINT32) ((0x3FEEA16A4EB316F6uLL) >> 32)},
    {(VUINT32) ((0xBC8A7D8171BF2FD8uLL) >> 0),
     (VUINT32) ((0xBC8A7D8171BF2FD8uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE6897514751DB6uLL) >> 0),
     (VUINT32) ((0x3FE6897514751DB6uLL) >> 32)},
    {(VUINT32) ((0x3C7432E08569C822uLL) >> 0),
     (VUINT32) ((0x3C7432E08569C822uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDFBE9EE099229DuLL) >> 0),
     (VUINT32) ((0x3FDFBE9EE099229DuLL) >> 32)},
    {(VUINT32) ((0x3FF0DB94E83152C9uLL) >> 0),
     (VUINT32) ((0x3FF0DB94E83152C9uLL) >> 32)},
    {(VUINT32) ((0x3FF3D9ED602549D9uLL) >> 0),
     (VUINT32) ((0x3FF3D9ED602549D9uLL) >> 32)},
    {(VUINT32) ((0x3FF3999FCB35B63CuLL) >> 0),
     (VUINT32) ((0x3FF3999FCB35B63CuLL) >> 32)},
    {(VUINT32) ((0x3FF4F3F4BB18D34DuLL) >> 0),
     (VUINT32) ((0x3FF4F3F4BB18D34DuLL) >> 32)},
    {(VUINT32) ((0x3FF5AA9FE2712A89uLL) >> 0),
     (VUINT32) ((0x3FF5AA9FE2712A89uLL) >> 32)},
    {(VUINT32) ((0x3FF6B61F156D157EuLL) >> 0),
     (VUINT32) ((0x3FF6B61F156D157EuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEE3CE261620641uLL) >> 0),
     (VUINT32) ((0x3FEE3CE261620641uLL) >> 32)},
    {(VUINT32) ((0x3C7A77CBEAE8FD71uLL) >> 0),
     (VUINT32) ((0x3C7A77CBEAE8FD71uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE7212BE621BE6DuLL) >> 0),
     (VUINT32) ((0x3FE7212BE621BE6DuLL) >> 32)},
    {(VUINT32) ((0x3C8AD14CAC5AE1D4uLL) >> 0),
     (VUINT32) ((0x3C8AD14CAC5AE1D4uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDE905D04D13F70uLL) >> 0),
     (VUINT32) ((0xBFDE905D04D13F70uLL) >> 32)},
    {(VUINT32) ((0x3FF19B4F7BD63206uLL) >> 0),
     (VUINT32) ((0x3FF19B4F7BD63206uLL) >> 32)},
    {(VUINT32) ((0x3FF4D8845C8EEC38uLL) >> 0),
     (VUINT32) ((0x3FF4D8845C8EEC38uLL) >> 32)},
    {(VUINT32) ((0x3FF4EFAAD70924AAuLL) >> 0),
     (VUINT32) ((0x3FF4EFAAD70924AAuLL) >> 32)},
    {(VUINT32) ((0x3FF69F610EDFA788uLL) >> 0),
     (VUINT32) ((0x3FF69F610EDFA788uLL) >> 32)},
    {(VUINT32) ((0x3FF7B93C8525966AuLL) >> 0),
     (VUINT32) ((0x3FF7B93C8525966AuLL) >> 32)},
    {(VUINT32) ((0x3FF928F49138F1A9uLL) >> 0),
     (VUINT32) ((0x3FF928F49138F1A9uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEDD85A7410F58DuLL) >> 0),
     (VUINT32) ((0x3FEDD85A7410F58DuLL) >> 32)},
    {(VUINT32) ((0xBC76156546AFA570uLL) >> 0),
     (VUINT32) ((0xBC76156546AFA570uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE7BB99ED2990CFuLL) >> 0),
     (VUINT32) ((0x3FE7BB99ED2990CFuLL) >> 32)},
    {(VUINT32) ((0xBC8AABB1289366EEuLL) >> 0),
     (VUINT32) ((0xBC8AABB1289366EEuLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDCCC0DD257FE9FuLL) >> 0),
     (VUINT32) ((0xBFDCCC0DD257FE9FuLL) >> 32)},
    {(VUINT32) ((0x3FF264BAB3E8C3FCuLL) >> 0),
     (VUINT32) ((0x3FF264BAB3E8C3FCuLL) >> 32)},
    {(VUINT32) ((0x3FF5E88F7CC1F7BCuLL) >> 0),
     (VUINT32) ((0x3FF5E88F7CC1F7BCuLL) >> 32)},
    {(VUINT32) ((0x3FF6612B1AE228E1uLL) >> 0),
     (VUINT32) ((0x3FF6612B1AE228E1uLL) >> 32)},
    {(VUINT32) ((0x3FF873A64164BF00uLL) >> 0),
     (VUINT32) ((0x3FF873A64164BF00uLL) >> 32)},
    {(VUINT32) ((0x3FFA016987C44E2AuLL) >> 0),
     (VUINT32) ((0x3FFA016987C44E2AuLL) >> 32)},
    {(VUINT32) ((0x3FFBFCA608E41B3AuLL) >> 0),
     (VUINT32) ((0x3FFBFCA608E41B3AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FED73D286BFE4D8uLL) >> 0),
     (VUINT32) ((0x3FED73D286BFE4D8uLL) >> 32)},
    {(VUINT32) ((0x3C8CAEB4C3DBDBD8uLL) >> 0),
     (VUINT32) ((0x3C8CAEB4C3DBDBD8uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE858DE3B716571uLL) >> 0),
     (VUINT32) ((0x3FE858DE3B716571uLL) >> 32)},
    {(VUINT32) ((0x3C8C6340D74EFAEEuLL) >> 0),
     (VUINT32) ((0x3C8C6340D74EFAEEuLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDAF377B50F3DE8uLL) >> 0),
     (VUINT32) ((0xBFDAF377B50F3DE8uLL) >> 32)},
    {(VUINT32) ((0x3FF338819C6A585BuLL) >> 0),
     (VUINT32) ((0x3FF338819C6A585BuLL) >> 32)},
    {(VUINT32) ((0x3FF70B781BB3F9F8uLL) >> 0),
     (VUINT32) ((0x3FF70B781BB3F9F8uLL) >> 32)},
    {(VUINT32) ((0x3FF7F0C4DC952BEEuLL) >> 0),
     (VUINT32) ((0x3FF7F0C4DC952BEEuLL) >> 32)},
    {(VUINT32) ((0x3FFA75444794B0BEuLL) >> 0),
     (VUINT32) ((0x3FFA75444794B0BEuLL) >> 32)},
    {(VUINT32) ((0x3FFC8A58AEEA152DuLL) >> 0),
     (VUINT32) ((0x3FFC8A58AEEA152DuLL) >> 32)},
    {(VUINT32) ((0x3FFF1509C3EC473FuLL) >> 0),
     (VUINT32) ((0x3FFF1509C3EC473FuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FED0F4A996ED424uLL) >> 0),
     (VUINT32) ((0x3FED0F4A996ED424uLL) >> 32)},
    {(VUINT32) ((0x3C61A070AC3E29A0uLL) >> 0),
     (VUINT32) ((0x3C61A070AC3E29A0uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE8F9197BF85EEBuLL) >> 0),
     (VUINT32) ((0x3FE8F9197BF85EEBuLL) >> 32)},
    {(VUINT32) ((0xBC77971D706288A0uLL) >> 0),
     (VUINT32) ((0xBC77971D706288A0uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD9058D62BBB98DuLL) >> 0),
     (VUINT32) ((0xBFD9058D62BBB98DuLL) >> 32)},
    {(VUINT32) ((0x3FF4175D31199B0CuLL) >> 0),
     (VUINT32) ((0x3FF4175D31199B0CuLL) >> 32)},
    {(VUINT32) ((0x3FF842CA948070CEuLL) >> 0),
     (VUINT32) ((0x3FF842CA948070CEuLL) >> 32)},
    {(VUINT32) ((0x3FF9A1675E6F2233uLL) >> 0),
     (VUINT32) ((0x3FF9A1675E6F2233uLL) >> 32)},
    {(VUINT32) ((0x3FFCA94A75D1DF36uLL) >> 0),
     (VUINT32) ((0x3FFCA94A75D1DF36uLL) >> 32)},
    {(VUINT32) ((0x3FFF5C3EE98CB77CuLL) >> 0),
     (VUINT32) ((0x3FFF5C3EE98CB77CuLL) >> 32)},
    {(VUINT32) ((0x4001549BBD7761F7uLL) >> 0),
     (VUINT32) ((0x4001549BBD7761F7uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FECAAC2AC1DC370uLL) >> 0),
     (VUINT32) ((0x3FECAAC2AC1DC370uLL) >> 32)},
    {(VUINT32) ((0xBC83DE7C6DBCC708uLL) >> 0),
     (VUINT32) ((0xBC83DE7C6DBCC708uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FE99C6E0F634394uLL) >> 0),
     (VUINT32) ((0x3FE99C6E0F634394uLL) >> 32)},
    {(VUINT32) ((0x3C81A125C4B0D75FuLL) >> 0),
     (VUINT32) ((0x3C81A125C4B0D75FuLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7012EAAC8A987uLL) >> 0),
     (VUINT32) ((0xBFD7012EAAC8A987uLL) >> 32)},
    {(VUINT32) ((0x3FF50215B95FD940uLL) >> 0),
     (VUINT32) ((0x3FF50215B95FD940uLL) >> 32)},
    {(VUINT32) ((0x3FF9903A2B193F49uLL) >> 0),
     (VUINT32) ((0x3FF9903A2B193F49uLL) >> 32)},
    {(VUINT32) ((0x3FFB7656607D37C1uLL) >> 0),
     (VUINT32) ((0x3FFB7656607D37C1uLL) >> 32)},
    {(VUINT32) ((0x3FFF156F461C0EE0uLL) >> 0),
     (VUINT32) ((0x3FFF156F461C0EE0uLL) >> 32)},
    {(VUINT32) ((0x4001403E48F2741BuLL) >> 0),
     (VUINT32) ((0x4001403E48F2741BuLL) >> 32)},
    {(VUINT32) ((0x40034ACD8D38409AuLL) >> 0),
     (VUINT32) ((0x40034ACD8D38409AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEC463ABECCB2BBuLL) >> 0),
     (VUINT32) ((0x3FEC463ABECCB2BBuLL) >> 32)},
    {(VUINT32) ((0x3C83DAEAF976E788uLL) >> 0),
     (VUINT32) ((0x3C83DAEAF976E788uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEA43002AE42850uLL) >> 0),
     (VUINT32) ((0x3FEA43002AE42850uLL) >> 32)},
    {(VUINT32) ((0xBC7A7C0406D92972uLL) >> 0),
     (VUINT32) ((0xBC7A7C0406D92972uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4E526E33345B8uLL) >> 0),
     (VUINT32) ((0xBFD4E526E33345B8uLL) >> 32)},
    {(VUINT32) ((0x3FF5F9844B626284uLL) >> 0),
     (VUINT32) ((0x3FF5F9844B626284uLL) >> 32)},
    {(VUINT32) ((0x3FFAF5A574C2F3BFuLL) >> 0),
     (VUINT32) ((0x3FFAF5A574C2F3BFuLL) >> 32)},
    {(VUINT32) ((0x3FFD7334FD198D13uLL) >> 0),
     (VUINT32) ((0x3FFD7334FD198D13uLL) >> 32)},
    {(VUINT32) ((0x4000E01251879DC7uLL) >> 0),
     (VUINT32) ((0x4000E01251879DC7uLL) >> 32)},
    {(VUINT32) ((0x400300E6F5213CC2uLL) >> 0),
     (VUINT32) ((0x400300E6F5213CC2uLL) >> 32)},
    {(VUINT32) ((0x40058BA67D3A054AuLL) >> 0),
     (VUINT32) ((0x40058BA67D3A054AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEBE1B2D17BA207uLL) >> 0),
     (VUINT32) ((0x3FEBE1B2D17BA207uLL) >> 32)},
    {(VUINT32) ((0xBC61AEB67D55A7A1uLL) >> 0),
     (VUINT32) ((0xBC61AEB67D55A7A1uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEAECF5F9BA35A6uLL) >> 0),
     (VUINT32) ((0x3FEAECF5F9BA35A6uLL) >> 32)},
    {(VUINT32) ((0x3C4535083409FF20uLL) >> 0),
     (VUINT32) ((0x3C4535083409FF20uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD2B02B2D565D55uLL) >> 0),
     (VUINT32) ((0xBFD2B02B2D565D55uLL) >> 32)},
    {(VUINT32) ((0x3FF6FE947B408BACuLL) >> 0),
     (VUINT32) ((0x3FF6FE947B408BACuLL) >> 32)},
    {(VUINT32) ((0x3FFC751B52A83938uLL) >> 0),
     (VUINT32) ((0x3FFC751B52A83938uLL) >> 32)},
    {(VUINT32) ((0x3FFF9C12181CFBBAuLL) >> 0),
     (VUINT32) ((0x3FFF9C12181CFBBAuLL) >> 32)},
    {(VUINT32) ((0x4002585B4421C075uLL) >> 0),
     (VUINT32) ((0x4002585B4421C075uLL) >> 32)},
    {(VUINT32) ((0x4004F6412119D9F1uLL) >> 0),
     (VUINT32) ((0x4004F6412119D9F1uLL) >> 32)},
    {(VUINT32) ((0x400814BACED69AF1uLL) >> 0),
     (VUINT32) ((0x400814BACED69AF1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEB7D2AE42A9153uLL) >> 0),
     (VUINT32) ((0x3FEB7D2AE42A9153uLL) >> 32)},
    {(VUINT32) ((0xBC8CB2463821BB58uLL) >> 0),
     (VUINT32) ((0xBC8CB2463821BB58uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEB9A77C18C1AF2uLL) >> 0),
     (VUINT32) ((0x3FEB9A77C18C1AF2uLL) >> 32)},
    {(VUINT32) ((0x3C76EA194A3B7D14uLL) >> 0),
     (VUINT32) ((0x3C76EA194A3B7D14uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD060D88DF903DFuLL) >> 0),
     (VUINT32) ((0xBFD060D88DF903DFuLL) >> 32)},
    {(VUINT32) ((0x3FF812463C417D93uLL) >> 0),
     (VUINT32) ((0x3FF812463C417D93uLL) >> 32)},
    {(VUINT32) ((0x3FFE10E093E6DE8DuLL) >> 0),
     (VUINT32) ((0x3FFE10E093E6DE8DuLL) >> 32)},
    {(VUINT32) ((0x4000FABB50DD022EuLL) >> 0),
     (VUINT32) ((0x4000FABB50DD022EuLL) >> 32)},
    {(VUINT32) ((0x4003F7B45B053F76uLL) >> 0),
     (VUINT32) ((0x4003F7B45B053F76uLL) >> 32)},
    {(VUINT32) ((0x4007275FB67DBBCCuLL) >> 0),
     (VUINT32) ((0x4007275FB67DBBCCuLL) >> 32)},
    {(VUINT32) ((0x400B02CB76CD8FDBuLL) >> 0),
     (VUINT32) ((0x400B02CB76CD8FDBuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEB18A2F6D9809EuLL) >> 0),
     (VUINT32) ((0x3FEB18A2F6D9809EuLL) >> 32)},
    {(VUINT32) ((0x3C760E425E23E66FuLL) >> 0),
     (VUINT32) ((0x3C760E425E23E66FuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEC4BB009E77983uLL) >> 0),
     (VUINT32) ((0x3FEC4BB009E77983uLL) >> 32)},
    {(VUINT32) ((0xBC5346B6895525B8uLL) >> 0),
     (VUINT32) ((0xBC5346B6895525B8uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCBEB63A6D04570uLL) >> 0),
     (VUINT32) ((0xBFCBEB63A6D04570uLL) >> 32)},
    {(VUINT32) ((0x3FF935AFFA8DCC1DuLL) >> 0),
     (VUINT32) ((0x3FF935AFFA8DCC1DuLL) >> 32)},
    {(VUINT32) ((0x3FFFCB7657D15F0BuLL) >> 0),
     (VUINT32) ((0x3FFFCB7657D15F0BuLL) >> 32)},
    {(VUINT32) ((0x4002423AFCE75F54uLL) >> 0),
     (VUINT32) ((0x4002423AFCE75F54uLL) >> 32)},
    {(VUINT32) ((0x4005C2CF61AD4B89uLL) >> 0),
     (VUINT32) ((0x4005C2CF61AD4B89uLL) >> 32)},
    {(VUINT32) ((0x40099C675A298F48uLL) >> 0),
     (VUINT32) ((0x40099C675A298F48uLL) >> 32)},
    {(VUINT32) ((0x400E49F38B657F73uLL) >> 0),
     (VUINT32) ((0x400E49F38B657F73uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEAB41B09886FEAuLL) >> 0),
     (VUINT32) ((0x3FEAB41B09886FEAuLL) >> 32)},
    {(VUINT32) ((0xBC7A7EEED374BC71uLL) >> 0),
     (VUINT32) ((0xBC7A7EEED374BC71uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FED00CBC7384D2EuLL) >> 0),
     (VUINT32) ((0x3FED00CBC7384D2EuLL) >> 32)},
    {(VUINT32) ((0x3C78C4FC635D2596uLL) >> 0),
     (VUINT32) ((0x3C78C4FC635D2596uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC6DA3A87611EA6uLL) >> 0),
     (VUINT32) ((0xBFC6DA3A87611EA6uLL) >> 32)},
    {(VUINT32) ((0x3FFA6A00F50D3A6FuLL) >> 0),
     (VUINT32) ((0x3FFA6A00F50D3A6FuLL) >> 32)},
    {(VUINT32) ((0x4000D3D0A6ABBD46uLL) >> 0),
     (VUINT32) ((0x4000D3D0A6ABBD46uLL) >> 32)},
    {(VUINT32) ((0x4003A760672280D0uLL) >> 0),
     (VUINT32) ((0x4003A760672280D0uLL) >> 32)},
    {(VUINT32) ((0x4007BF026C103550uLL) >> 0),
     (VUINT32) ((0x4007BF026C103550uLL) >> 32)},
    {(VUINT32) ((0x400C5EBD23F4E2D6uLL) >> 0),
     (VUINT32) ((0x400C5EBD23F4E2D6uLL) >> 32)},
    {(VUINT32) ((0x4011024DB7867574uLL) >> 0),
     (VUINT32) ((0x4011024DB7867574uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FEA4F931C375F35uLL) >> 0),
     (VUINT32) ((0x3FEA4F931C375F35uLL) >> 32)},
    {(VUINT32) ((0x3C8A79EFFD795057uLL) >> 0),
     (VUINT32) ((0x3C8A79EFFD795057uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEDB9FA89953FCFuLL) >> 0),
     (VUINT32) ((0x3FEDB9FA89953FCFuLL) >> 32)},
    {(VUINT32) ((0x3C286C68F5592C40uLL) >> 0),
     (VUINT32) ((0x3C286C68F5592C40uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC18AC418849A6EuLL) >> 0),
     (VUINT32) ((0xBFC18AC418849A6EuLL) >> 32)},
    {(VUINT32) ((0x3FFBB083E02786D7uLL) >> 0),
     (VUINT32) ((0x3FFBB083E02786D7uLL) >> 32)},
    {(VUINT32) ((0x4001D438F8A20402uLL) >> 0),
     (VUINT32) ((0x4001D438F8A20402uLL) >> 32)},
    {(VUINT32) ((0x40052D5D6FF7A4BDuLL) >> 0),
     (VUINT32) ((0x40052D5D6FF7A4BDuLL) >> 32)},
    {(VUINT32) ((0x4009F262067BAA5AuLL) >> 0),
     (VUINT32) ((0x4009F262067BAA5AuLL) >> 32)},
    {(VUINT32) ((0x400F793DA8608BD3uLL) >> 0),
     (VUINT32) ((0x400F793DA8608BD3uLL) >> 32)},
    {(VUINT32) ((0x401328BFC5F60A12uLL) >> 0),
     (VUINT32) ((0x401328BFC5F60A12uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE9EB0B2EE64E81uLL) >> 0),
     (VUINT32) ((0x3FE9EB0B2EE64E81uLL) >> 32)},
    {(VUINT32) ((0x3C519ABB2567F739uLL) >> 0),
     (VUINT32) ((0x3C519ABB2567F739uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEE776EAFC91706uLL) >> 0),
     (VUINT32) ((0x3FEE776EAFC91706uLL) >> 32)},
    {(VUINT32) ((0x3C890664EDC679F9uLL) >> 0),
     (VUINT32) ((0x3C890664EDC679F9uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB7F295AD658764uLL) >> 0),
     (VUINT32) ((0xBFB7F295AD658764uLL) >> 32)},
    {(VUINT32) ((0x3FFD0AA1DB7F5E58uLL) >> 0),
     (VUINT32) ((0x3FFD0AA1DB7F5E58uLL) >> 32)},
    {(VUINT32) ((0x4002E8A6F9693556uLL) >> 0),
     (VUINT32) ((0x4002E8A6F9693556uLL) >> 32)},
    {(VUINT32) ((0x4006D7CA16B298C6uLL) >> 0),
     (VUINT32) ((0x4006D7CA16B298C6uLL) >> 32)},
    {(VUINT32) ((0x400C63DFCAA3FB6CuLL) >> 0),
     (VUINT32) ((0x400C63DFCAA3FB6CuLL) >> 32)},
    {(VUINT32) ((0x40117C3EE50D7733uLL) >> 0),
     (VUINT32) ((0x40117C3EE50D7733uLL) >> 32)},
    {(VUINT32) ((0x401599932C96B999uLL) >> 0),
     (VUINT32) ((0x401599932C96B999uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE9868341953DCDuLL) >> 0),
     (VUINT32) ((0x3FE9868341953DCDuLL) >> 32)},
    {(VUINT32) ((0xBC861341341F5289uLL) >> 0),
     (VUINT32) ((0xBC861341341F5289uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FEF395D9F0E3C92uLL) >> 0),
     (VUINT32) ((0x3FEF395D9F0E3C92uLL) >> 32)},
    {(VUINT32) ((0xBC550BEC65673F08uLL) >> 0),
     (VUINT32) ((0xBC550BEC65673F08uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA8873C53BE0540uLL) >> 0),
     (VUINT32) ((0xBFA8873C53BE0540uLL) >> 32)},
    {(VUINT32) ((0x3FFE79E5C65202DEuLL) >> 0),
     (VUINT32) ((0x3FFE79E5C65202DEuLL) >> 32)},
    {(VUINT32) ((0x400412FD76797C7DuLL) >> 0),
     (VUINT32) ((0x400412FD76797C7DuLL) >> 32)},
    {(VUINT32) ((0x4008AAB30DC82D37uLL) >> 0),
     (VUINT32) ((0x4008AAB30DC82D37uLL) >> 32)},
    {(VUINT32) ((0x400F1B6C68B4AEA4uLL) >> 0),
     (VUINT32) ((0x400F1B6C68B4AEA4uLL) >> 32)},
    {(VUINT32) ((0x4013758CE9BD9EE9uLL) >> 0),
     (VUINT32) ((0x4013758CE9BD9EE9uLL) >> 32)},
    {(VUINT32) ((0x40186872A06858F5uLL) >> 0),
     (VUINT32) ((0x40186872A06858F5uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE921FB54442D18uLL) >> 0),
     (VUINT32) ((0x3FE921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0x3C81A62633145C07uLL) >> 0),
     (VUINT32) ((0x3C81A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD17CC1B727220BuLL) >> 0),
     (VUINT32) ((0xBFD17CC1B727220BuLL) >> 32)},
    {(VUINT32) ((0x3C7AC07996DF1E94uLL) >> 0),
     (VUINT32) ((0x3C7AC07996DF1E94uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBF02F6222C71FBuLL) >> 0),
     (VUINT32) ((0xBFBF02F6222C71FBuLL) >> 32)},
    {(VUINT32) ((0xBFB068BD68BAEFC3uLL) >> 0),
     (VUINT32) ((0xBFB068BD68BAEFC3uLL) >> 32)},
    {(VUINT32) ((0x3FA3C0213E30B2A4uLL) >> 0),
     (VUINT32) ((0x3FA3C0213E30B2A4uLL) >> 32)},
    {(VUINT32) ((0xBF8A5494A0DD32B3uLL) >> 0),
     (VUINT32) ((0xBF8A5494A0DD32B3uLL) >> 32)},
    {(VUINT32) ((0x3F7940CD1D8E923EuLL) >> 0),
     (VUINT32) ((0x3F7940CD1D8E923EuLL) >> 32)},
    {(VUINT32) ((0xBF63CC1BE5088783uLL) >> 0),
     (VUINT32) ((0xBF63CC1BE5088783uLL) >> 32)},
    {(VUINT32) ((0x3F3FA4A6A27659EEuLL) >> 0),
     (VUINT32) ((0x3F3FA4A6A27659EEuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE8BD7366F31C64uLL) >> 0),
     (VUINT32) ((0x3FE8BD7366F31C64uLL) >> 32)},
    {(VUINT32) ((0xBC6A81C996DFD5A5uLL) >> 0),
     (VUINT32) ((0xBC6A81C996DFD5A5uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD130BD396BB4A9uLL) >> 0),
     (VUINT32) ((0xBFD130BD396BB4A9uLL) >> 32)},
    {(VUINT32) ((0x3C657D8592EA0982uLL) >> 0),
     (VUINT32) ((0x3C657D8592EA0982uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBF68ED595308D6uLL) >> 0),
     (VUINT32) ((0xBFBF68ED595308D6uLL) >> 32)},
    {(VUINT32) ((0xBFB00C6BF6A673E6uLL) >> 0),
     (VUINT32) ((0xBFB00C6BF6A673E6uLL) >> 32)},
    {(VUINT32) ((0x3FA36E9DA9556AA6uLL) >> 0),
     (VUINT32) ((0x3FA36E9DA9556AA6uLL) >> 32)},
    {(VUINT32) ((0xBF8991120C7D4BB9uLL) >> 0),
     (VUINT32) ((0xBF8991120C7D4BB9uLL) >> 32)},
    {(VUINT32) ((0x3F7889ABD600821AuLL) >> 0),
     (VUINT32) ((0x3F7889ABD600821AuLL) >> 32)},
    {(VUINT32) ((0xBF630EE40468887BuLL) >> 0),
     (VUINT32) ((0xBF630EE40468887BuLL) >> 32)},
    {(VUINT32) ((0x3F52CAD75A194915uLL) >> 0),
     (VUINT32) ((0x3F52CAD75A194915uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE858EB79A20BB0uLL) >> 0),
     (VUINT32) ((0x3FE858EB79A20BB0uLL) >> 32)},
    {(VUINT32) ((0xBC8EE70AFE8446D9uLL) >> 0),
     (VUINT32) ((0xBC8EE70AFE8446D9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD0E507EE8B93D7uLL) >> 0),
     (VUINT32) ((0xBFD0E507EE8B93D7uLL) >> 32)},
    {(VUINT32) ((0xBC679F09CDD5D366uLL) >> 0),
     (VUINT32) ((0xBC679F09CDD5D366uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBFCCA52E2AE201uLL) >> 0),
     (VUINT32) ((0xBFBFCCA52E2AE201uLL) >> 32)},
    {(VUINT32) ((0xBFAF632A1681FD0BuLL) >> 0),
     (VUINT32) ((0xBFAF632A1681FD0BuLL) >> 32)},
    {(VUINT32) ((0x3FA31F7794BDF922uLL) >> 0),
     (VUINT32) ((0x3FA31F7794BDF922uLL) >> 32)},
    {(VUINT32) ((0xBF88D31259E30525uLL) >> 0),
     (VUINT32) ((0xBF88D31259E30525uLL) >> 32)},
    {(VUINT32) ((0x3F77D97B728544D6uLL) >> 0),
     (VUINT32) ((0x3F77D97B728544D6uLL) >> 32)},
    {(VUINT32) ((0xBF62591A3A2B69D8uLL) >> 0),
     (VUINT32) ((0xBF62591A3A2B69D8uLL) >> 32)},
    {(VUINT32) ((0x3F3605B3887E1AF3uLL) >> 0),
     (VUINT32) ((0x3F3605B3887E1AF3uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE7F4638C50FAFBuLL) >> 0),
     (VUINT32) ((0x3FE7F4638C50FAFBuLL) >> 32)},
    {(VUINT32) ((0x3C71A4B8D15ECF6DuLL) >> 0),
     (VUINT32) ((0x3C71A4B8D15ECF6DuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD099A0163BCD3FuLL) >> 0),
     (VUINT32) ((0xBFD099A0163BCD3FuLL) >> 32)},
    {(VUINT32) ((0xBC7A7F11D963D761uLL) >> 0),
     (VUINT32) ((0xBC7A7F11D963D761uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBFD1D937A1F094uLL) >> 0),
     (VUINT32) ((0x3FBFD1D937A1F094uLL) >> 32)},
    {(VUINT32) ((0xBFAEB05B52EFB4C0uLL) >> 0),
     (VUINT32) ((0xBFAEB05B52EFB4C0uLL) >> 32)},
    {(VUINT32) ((0x3FA2D29E032A57DBuLL) >> 0),
     (VUINT32) ((0x3FA2D29E032A57DBuLL) >> 32)},
    {(VUINT32) ((0xBF881A60F7D38723uLL) >> 0),
     (VUINT32) ((0xBF881A60F7D38723uLL) >> 32)},
    {(VUINT32) ((0x3F772FBBF1BFA292uLL) >> 0),
     (VUINT32) ((0x3F772FBBF1BFA292uLL) >> 32)},
    {(VUINT32) ((0xBF61AA745B27BAF7uLL) >> 0),
     (VUINT32) ((0xBF61AA745B27BAF7uLL) >> 32)},
    {(VUINT32) ((0x3F51CC1913635CA5uLL) >> 0),
     (VUINT32) ((0x3F51CC1913635CA5uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE78FDB9EFFEA47uLL) >> 0),
     (VUINT32) ((0x3FE78FDB9EFFEA47uLL) >> 32)},
    {(VUINT32) ((0xBC7EE8786039D373uLL) >> 0),
     (VUINT32) ((0xBC7EE8786039D373uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD04E83F7474877uLL) >> 0),
     (VUINT32) ((0xBFD04E83F7474877uLL) >> 32)},
    {(VUINT32) ((0xBC73B117AC20AD03uLL) >> 0),
     (VUINT32) ((0xBC73B117AC20AD03uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBF7284F47C0E61uLL) >> 0),
     (VUINT32) ((0x3FBF7284F47C0E61uLL) >> 32)},
    {(VUINT32) ((0xBFAE0056458FCED5uLL) >> 0),
     (VUINT32) ((0xBFAE0056458FCED5uLL) >> 32)},
    {(VUINT32) ((0x3FA28800992AEEE6uLL) >> 0),
     (VUINT32) ((0x3FA28800992AEEE6uLL) >> 32)},
    {(VUINT32) ((0xBF8766CB6439B11DuLL) >> 0),
     (VUINT32) ((0xBF8766CB6439B11DuLL) >> 32)},
    {(VUINT32) ((0x3F768C54DBB3684BuLL) >> 0),
     (VUINT32) ((0x3F768C54DBB3684BuLL) >> 32)},
    {(VUINT32) ((0xBF610297B13942A7uLL) >> 0),
     (VUINT32) ((0xBF610297B13942A7uLL) >> 32)},
    {(VUINT32) ((0x3F5536BD1C2C92E8uLL) >> 0),
     (VUINT32) ((0x3F5536BD1C2C92E8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE72B53B1AED992uLL) >> 0),
     (VUINT32) ((0x3FE72B53B1AED992uLL) >> 32)},
    {(VUINT32) ((0x3C88452B3716C4D6uLL) >> 0),
     (VUINT32) ((0x3C88452B3716C4D6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD003B1DF5A0F86uLL) >> 0),
     (VUINT32) ((0xBFD003B1DF5A0F86uLL) >> 32)},
    {(VUINT32) ((0xBC716CEB71FB7130uLL) >> 0),
     (VUINT32) ((0xBC716CEB71FB7130uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBF155566FA6884uLL) >> 0),
     (VUINT32) ((0x3FBF155566FA6884uLL) >> 32)},
    {(VUINT32) ((0xBFAD530628A37C7AuLL) >> 0),
     (VUINT32) ((0xBFAD530628A37C7AuLL) >> 32)},
    {(VUINT32) ((0x3FA23F8F96E80A99uLL) >> 0),
     (VUINT32) ((0x3FA23F8F96E80A99uLL) >> 32)},
    {(VUINT32) ((0xBF86B82113BDC04EuLL) >> 0),
     (VUINT32) ((0xBF86B82113BDC04EuLL) >> 32)},
    {(VUINT32) ((0x3F75EF0B9C9DF1C1uLL) >> 0),
     (VUINT32) ((0x3F75EF0B9C9DF1C1uLL) >> 32)},
    {(VUINT32) ((0xBF60613421CB6A8BuLL) >> 0),
     (VUINT32) ((0xBF60613421CB6A8BuLL) >> 32)},
    {(VUINT32) ((0x3F48E48E9081596FuLL) >> 0),
     (VUINT32) ((0x3F48E48E9081596FuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE6C6CBC45DC8DEuLL) >> 0),
     (VUINT32) ((0x3FE6C6CBC45DC8DEuLL) >> 32)},
    {(VUINT32) ((0xBBC6D61B58C99C43uLL) >> 0),
     (VUINT32) ((0xBBC6D61B58C99C43uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCF7250459C1976uLL) >> 0),
     (VUINT32) ((0xBFCF7250459C1976uLL) >> 32)},
    {(VUINT32) ((0xBC40B5B081F067D4uLL) >> 0),
     (VUINT32) ((0xBC40B5B081F067D4uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBEBA422E0FE0E5uLL) >> 0),
     (VUINT32) ((0x3FBEBA422E0FE0E5uLL) >> 32)},
    {(VUINT32) ((0xBFACA856C815D042uLL) >> 0),
     (VUINT32) ((0xBFACA856C815D042uLL) >> 32)},
    {(VUINT32) ((0x3FA1F93BD218DCE9uLL) >> 0),
     (VUINT32) ((0x3FA1F93BD218DCE9uLL) >> 32)},
    {(VUINT32) ((0xBF860E335AB42933uLL) >> 0),
     (VUINT32) ((0xBF860E335AB42933uLL) >> 32)},
    {(VUINT32) ((0x3F75578EEA5D18CCuLL) >> 0),
     (VUINT32) ((0x3F75578EEA5D18CCuLL) >> 32)},
    {(VUINT32) ((0xBF5F8BFBAD564EB5uLL) >> 0),
     (VUINT32) ((0xBF5F8BFBAD564EB5uLL) >> 32)},
    {(VUINT32) ((0x3F434A80D203FDB7uLL) >> 0),
     (VUINT32) ((0x3F434A80D203FDB7uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE66243D70CB82AuLL) >> 0),
     (VUINT32) ((0x3FE66243D70CB82AuLL) >> 32)},
    {(VUINT32) ((0xBC884805FA81DE0AuLL) >> 0),
     (VUINT32) ((0xBC884805FA81DE0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCEDDCA38F25FECuLL) >> 0),
     (VUINT32) ((0xBFCEDDCA38F25FECuLL) >> 32)},
    {(VUINT32) ((0x3C65AACB9E8B4E8CuLL) >> 0),
     (VUINT32) ((0x3C65AACB9E8B4E8CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBE6143274A35BFuLL) >> 0),
     (VUINT32) ((0x3FBE6143274A35BFuLL) >> 32)},
    {(VUINT32) ((0xBFAC00347C15ABB2uLL) >> 0),
     (VUINT32) ((0xBFAC00347C15ABB2uLL) >> 32)},
    {(VUINT32) ((0x3FA1B4F6B03A62C8uLL) >> 0),
     (VUINT32) ((0x3FA1B4F6B03A62C8uLL) >> 32)},
    {(VUINT32) ((0xBF8568D557225239uLL) >> 0),
     (VUINT32) ((0xBF8568D557225239uLL) >> 32)},
    {(VUINT32) ((0x3F74C5A8346B014EuLL) >> 0),
     (VUINT32) ((0x3F74C5A8346B014EuLL) >> 32)},
    {(VUINT32) ((0xBF5E61680C7E3887uLL) >> 0),
     (VUINT32) ((0xBF5E61680C7E3887uLL) >> 32)},
    {(VUINT32) ((0x3F45A81E03A2004AuLL) >> 0),
     (VUINT32) ((0x3F45A81E03A2004AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE5FDBBE9BBA775uLL) >> 0),
     (VUINT32) ((0x3FE5FDBBE9BBA775uLL) >> 32)},
    {(VUINT32) ((0x3C7EE2C2D963A10CuLL) >> 0),
     (VUINT32) ((0x3C7EE2C2D963A10CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCE49CE5AF9DC29uLL) >> 0),
     (VUINT32) ((0xBFCE49CE5AF9DC29uLL) >> 32)},
    {(VUINT32) ((0x3C382336F1C6B420uLL) >> 0),
     (VUINT32) ((0x3C382336F1C6B420uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBE0A506D218F3CuLL) >> 0),
     (VUINT32) ((0x3FBE0A506D218F3CuLL) >> 32)},
    {(VUINT32) ((0xBFAB5A8C23E49FEAuLL) >> 0),
     (VUINT32) ((0xBFAB5A8C23E49FEAuLL) >> 32)},
    {(VUINT32) ((0x3FA172B22117D625uLL) >> 0),
     (VUINT32) ((0x3FA172B22117D625uLL) >> 32)},
    {(VUINT32) ((0xBF84C7DBDBF304B9uLL) >> 0),
     (VUINT32) ((0xBF84C7DBDBF304B9uLL) >> 32)},
    {(VUINT32) ((0x3F74391DF553E941uLL) >> 0),
     (VUINT32) ((0x3F74391DF553E941uLL) >> 32)},
    {(VUINT32) ((0xBF5D4211231EF20FuLL) >> 0),
     (VUINT32) ((0xBF5D4211231EF20FuLL) >> 32)},
    {(VUINT32) ((0x3F52AB1CCD6F9451uLL) >> 0),
     (VUINT32) ((0x3F52AB1CCD6F9451uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE59933FC6A96C1uLL) >> 0),
     (VUINT32) ((0x3FE59933FC6A96C1uLL) >> 32)},
    {(VUINT32) ((0xBC71AA6E583501D4uLL) >> 0),
     (VUINT32) ((0xBC71AA6E583501D4uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCDB6597A2E1B61uLL) >> 0),
     (VUINT32) ((0xBFCDB6597A2E1B61uLL) >> 32)},
    {(VUINT32) ((0x3C6CB71A947AAB6BuLL) >> 0),
     (VUINT32) ((0x3C6CB71A947AAB6BuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBDB56255580CA4uLL) >> 0),
     (VUINT32) ((0x3FBDB56255580CA4uLL) >> 32)},
    {(VUINT32) ((0xBFAAB74B20D856E7uLL) >> 0),
     (VUINT32) ((0xBFAAB74B20D856E7uLL) >> 32)},
    {(VUINT32) ((0x3FA1326099896038uLL) >> 0),
     (VUINT32) ((0x3FA1326099896038uLL) >> 32)},
    {(VUINT32) ((0xBF842B1D5CF84F74uLL) >> 0),
     (VUINT32) ((0xBF842B1D5CF84F74uLL) >> 32)},
    {(VUINT32) ((0x3F73B1CC2C4E32E8uLL) >> 0),
     (VUINT32) ((0x3F73B1CC2C4E32E8uLL) >> 32)},
    {(VUINT32) ((0xBF5C2D7D75B7FBCEuLL) >> 0),
     (VUINT32) ((0xBF5C2D7D75B7FBCEuLL) >> 32)},
    {(VUINT32) ((0x3F53DB94CE05D10AuLL) >> 0),
     (VUINT32) ((0x3F53DB94CE05D10AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE534AC0F19860CuLL) >> 0),
     (VUINT32) ((0x3FE534AC0F19860CuLL) >> 32)},
    {(VUINT32) ((0x3C8EE4303B192DA6uLL) >> 0),
     (VUINT32) ((0x3C8EE4303B192DA6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCD236870E769B5uLL) >> 0),
     (VUINT32) ((0xBFCD236870E769B5uLL) >> 32)},
    {(VUINT32) ((0xBC523CE78218C3F0uLL) >> 0),
     (VUINT32) ((0xBC523CE78218C3F0uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBD62716F68B5FEuLL) >> 0),
     (VUINT32) ((0x3FBD62716F68B5FEuLL) >> 32)},
    {(VUINT32) ((0xBFAA165F518C38ABuLL) >> 0),
     (VUINT32) ((0xBFAA165F518C38ABuLL) >> 32)},
    {(VUINT32) ((0x3FA0F3F50E789484uLL) >> 0),
     (VUINT32) ((0x3FA0F3F50E789484uLL) >> 32)},
    {(VUINT32) ((0xBF839271DC18DB75uLL) >> 0),
     (VUINT32) ((0xBF839271DC18DB75uLL) >> 32)},
    {(VUINT32) ((0x3F732F8BAC4C5496uLL) >> 0),
     (VUINT32) ((0x3F732F8BAC4C5496uLL) >> 32)},
    {(VUINT32) ((0xBF5B23248F865BB8uLL) >> 0),
     (VUINT32) ((0xBF5B23248F865BB8uLL) >> 32)},
    {(VUINT32) ((0x3F36E307E32E173BuLL) >> 0),
     (VUINT32) ((0x3F36E307E32E173BuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE4D02421C87558uLL) >> 0),
     (VUINT32) ((0x3FE4D02421C87558uLL) >> 32)},
    {(VUINT32) ((0x3C6A765E893370D7uLL) >> 0),
     (VUINT32) ((0x3C6A765E893370D7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCC90F8250157F7uLL) >> 0),
     (VUINT32) ((0xBFCC90F8250157F7uLL) >> 32)},
    {(VUINT32) ((0xBC657D8312BFEA16uLL) >> 0),
     (VUINT32) ((0xBC657D8312BFEA16uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBD117683053E13uLL) >> 0),
     (VUINT32) ((0x3FBD117683053E13uLL) >> 32)},
    {(VUINT32) ((0xBFA977B70D411C29uLL) >> 0),
     (VUINT32) ((0xBFA977B70D411C29uLL) >> 32)},
    {(VUINT32) ((0x3FA0B762F022F359uLL) >> 0),
     (VUINT32) ((0x3FA0B762F022F359uLL) >> 32)},
    {(VUINT32) ((0xBF82FDB2D7324A8FuLL) >> 0),
     (VUINT32) ((0xBF82FDB2D7324A8FuLL) >> 32)},
    {(VUINT32) ((0x3F72B2030A36AAE0uLL) >> 0),
     (VUINT32) ((0x3F72B2030A36AAE0uLL) >> 32)},
    {(VUINT32) ((0xBF5A22A22953FC15uLL) >> 0),
     (VUINT32) ((0xBF5A22A22953FC15uLL) >> 32)},
    {(VUINT32) ((0x3F473A2F09CB1310uLL) >> 0),
     (VUINT32) ((0x3F473A2F09CB1310uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE46B9C347764A4uLL) >> 0),
     (VUINT32) ((0x3FE46B9C347764A4uLL) >> 32)},
    {(VUINT32) ((0xBC81A900F67F753AuLL) >> 0),
     (VUINT32) ((0xBC81A900F67F753AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCBFF05878394D3uLL) >> 0),
     (VUINT32) ((0xBFCBFF05878394D3uLL) >> 32)},
    {(VUINT32) ((0xBC486912F813DEBCuLL) >> 0),
     (VUINT32) ((0xBC486912F813DEBCuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBCC26A8EA2077FuLL) >> 0),
     (VUINT32) ((0x3FBCC26A8EA2077FuLL) >> 32)},
    {(VUINT32) ((0xBFA8DB411F68EE69uLL) >> 0),
     (VUINT32) ((0xBFA8DB411F68EE69uLL) >> 32)},
    {(VUINT32) ((0x3FA07C9E25737218uLL) >> 0),
     (VUINT32) ((0x3FA07C9E25737218uLL) >> 32)},
    {(VUINT32) ((0xBF826CBB3713A292uLL) >> 0),
     (VUINT32) ((0xBF826CBB3713A292uLL) >> 32)},
    {(VUINT32) ((0x3F72392A32F26712uLL) >> 0),
     (VUINT32) ((0x3F72392A32F26712uLL) >> 32)},
    {(VUINT32) ((0xBF592B76EEB6E333uLL) >> 0),
     (VUINT32) ((0xBF592B76EEB6E333uLL) >> 32)},
    {(VUINT32) ((0x3F39BADB57E2A4EBuLL) >> 0),
     (VUINT32) ((0x3F39BADB57E2A4EBuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE40714472653EFuLL) >> 0),
     (VUINT32) ((0x3FE40714472653EFuLL) >> 32)},
    {(VUINT32) ((0x3C86106670B43955uLL) >> 0),
     (VUINT32) ((0x3C86106670B43955uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCB6D8D944D0371uLL) >> 0),
     (VUINT32) ((0xBFCB6D8D944D0371uLL) >> 32)},
    {(VUINT32) ((0x3C6CDD9D6EA4B883uLL) >> 0),
     (VUINT32) ((0x3C6CDD9D6EA4B883uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBC7546C60FE5C7uLL) >> 0),
     (VUINT32) ((0x3FBC7546C60FE5C7uLL) >> 32)},
    {(VUINT32) ((0xBFA840ECC35C53FDuLL) >> 0),
     (VUINT32) ((0xBFA840ECC35C53FDuLL) >> 32)},
    {(VUINT32) ((0x3FA0439B07C380F3uLL) >> 0),
     (VUINT32) ((0x3FA0439B07C380F3uLL) >> 32)},
    {(VUINT32) ((0xBF81DF673F038AB5uLL) >> 0),
     (VUINT32) ((0xBF81DF673F038AB5uLL) >> 32)},
    {(VUINT32) ((0x3F71C4B3C36B8A2BuLL) >> 0),
     (VUINT32) ((0x3F71C4B3C36B8A2BuLL) >> 32)},
    {(VUINT32) ((0xBF583D44FA2FB1ACuLL) >> 0),
     (VUINT32) ((0xBF583D44FA2FB1ACuLL) >> 32)},
    {(VUINT32) ((0x3F52EE3E6107070CuLL) >> 0),
     (VUINT32) ((0x3F52EE3E6107070CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE3A28C59D5433BuLL) >> 0),
     (VUINT32) ((0x3FE3A28C59D5433BuLL) >> 32)},
    {(VUINT32) ((0xBC51B19140C0C0D5uLL) >> 0),
     (VUINT32) ((0xBC51B19140C0C0D5uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCADC8D51C0FA5BuLL) >> 0),
     (VUINT32) ((0xBFCADC8D51C0FA5BuLL) >> 32)},
    {(VUINT32) ((0xBC54B350B5D39454uLL) >> 0),
     (VUINT32) ((0xBC54B350B5D39454uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBC2A04912319A8uLL) >> 0),
     (VUINT32) ((0x3FBC2A04912319A8uLL) >> 32)},
    {(VUINT32) ((0xBFA7A8A9A038608EuLL) >> 0),
     (VUINT32) ((0xBFA7A8A9A038608EuLL) >> 32)},
    {(VUINT32) ((0x3FA00C4E5E972915uLL) >> 0),
     (VUINT32) ((0x3FA00C4E5E972915uLL) >> 32)},
    {(VUINT32) ((0xBF8155947D4C5C83uLL) >> 0),
     (VUINT32) ((0xBF8155947D4C5C83uLL) >> 32)},
    {(VUINT32) ((0x3F7154A7B149DA51uLL) >> 0),
     (VUINT32) ((0x3F7154A7B149DA51uLL) >> 32)},
    {(VUINT32) ((0xBF5757960EDFC478uLL) >> 0),
     (VUINT32) ((0xBF5757960EDFC478uLL) >> 32)},
    {(VUINT32) ((0x3F3F895707140B54uLL) >> 0),
     (VUINT32) ((0x3F3F895707140B54uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE33E046C843287uLL) >> 0),
     (VUINT32) ((0x3FE33E046C843287uLL) >> 32)},
    {(VUINT32) ((0xBC8A7CCAC0E4698BuLL) >> 0),
     (VUINT32) ((0xBC8A7CCAC0E4698BuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCA4C01D0769648uLL) >> 0),
     (VUINT32) ((0xBFCA4C01D0769648uLL) >> 32)},
    {(VUINT32) ((0xBC4DDC96CAE4A560uLL) >> 0),
     (VUINT32) ((0xBC4DDC96CAE4A560uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBBE09D8A670D72uLL) >> 0),
     (VUINT32) ((0x3FBBE09D8A670D72uLL) >> 32)},
    {(VUINT32) ((0xBFA71267C4E29753uLL) >> 0),
     (VUINT32) ((0xBFA71267C4E29753uLL) >> 32)},
    {(VUINT32) ((0x3F9FAD5AB78BB764uLL) >> 0),
     (VUINT32) ((0x3F9FAD5AB78BB764uLL) >> 32)},
    {(VUINT32) ((0xBF80CF21BC414F68uLL) >> 0),
     (VUINT32) ((0xBF80CF21BC414F68uLL) >> 32)},
    {(VUINT32) ((0x3F70E8AC1DCF4364uLL) >> 0),
     (VUINT32) ((0x3F70E8AC1DCF4364uLL) >> 32)},
    {(VUINT32) ((0xBF567A14C0530821uLL) >> 0),
     (VUINT32) ((0xBF567A14C0530821uLL) >> 32)},
    {(VUINT32) ((0x3F4F621D6DA2AD4CuLL) >> 0),
     (VUINT32) ((0x3F4F621D6DA2AD4CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0x3FE2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0x3C7A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0x3C7A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC9BBE82AEA0D12uLL) >> 0),
     (VUINT32) ((0xBFC9BBE82AEA0D12uLL) >> 32)},
    {(VUINT32) ((0x3C62D116CA770BB7uLL) >> 0),
     (VUINT32) ((0x3C62D116CA770BB7uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBB990B7DDE5BFCuLL) >> 0),
     (VUINT32) ((0x3FBB990B7DDE5BFCuLL) >> 32)},
    {(VUINT32) ((0xBFA67E17A4317C6CuLL) >> 0),
     (VUINT32) ((0xBFA67E17A4317C6CuLL) >> 32)},
    {(VUINT32) ((0x3F9F455B2F170454uLL) >> 0),
     (VUINT32) ((0x3F9F455B2F170454uLL) >> 32)},
    {(VUINT32) ((0xBF804BEEF437A2B3uLL) >> 0),
     (VUINT32) ((0xBF804BEEF437A2B3uLL) >> 32)},
    {(VUINT32) ((0x3F7080CEADF2974DuLL) >> 0),
     (VUINT32) ((0x3F7080CEADF2974DuLL) >> 32)},
    {(VUINT32) ((0xBF55A44E3A71E98CuLL) >> 0),
     (VUINT32) ((0xBF55A44E3A71E98CuLL) >> 32)},
    {(VUINT32) ((0xBF039F9468E5AC7CuLL) >> 0),
     (VUINT32) ((0xBF039F9468E5AC7CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE274F491E2111EuLL) >> 0),
     (VUINT32) ((0x3FE274F491E2111EuLL) >> 32)},
    {(VUINT32) ((0xBC7613F7E4FA18D6uLL) >> 0),
     (VUINT32) ((0xBC7613F7E4FA18D6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC92C3D852FEDF2uLL) >> 0),
     (VUINT32) ((0xBFC92C3D852FEDF2uLL) >> 32)},
    {(VUINT32) ((0xBC20F5E7403E63E0uLL) >> 0),
     (VUINT32) ((0xBC20F5E7403E63E0uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBB534867CEB1CBuLL) >> 0),
     (VUINT32) ((0x3FBB534867CEB1CBuLL) >> 32)},
    {(VUINT32) ((0xBFA5EBAA113813D4uLL) >> 0),
     (VUINT32) ((0xBFA5EBAA113813D4uLL) >> 32)},
    {(VUINT32) ((0x3F9EE08A1A202CC5uLL) >> 0),
     (VUINT32) ((0x3F9EE08A1A202CC5uLL) >> 32)},
    {(VUINT32) ((0xBF7F97BA7BA1301AuLL) >> 0),
     (VUINT32) ((0xBF7F97BA7BA1301AuLL) >> 32)},
    {(VUINT32) ((0x3F701CAD7F191E00uLL) >> 0),
     (VUINT32) ((0x3F701CAD7F191E00uLL) >> 32)},
    {(VUINT32) ((0xBF54D60D132212FEuLL) >> 0),
     (VUINT32) ((0xBF54D60D132212FEuLL) >> 32)},
    {(VUINT32) ((0x3F45F5FE99746255uLL) >> 0),
     (VUINT32) ((0x3F45F5FE99746255uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE2106CA4910069uLL) >> 0),
     (VUINT32) ((0x3FE2106CA4910069uLL) >> 32)},
    {(VUINT32) ((0x3C8CAF6B74B6A225uLL) >> 0),
     (VUINT32) ((0x3C8CAF6B74B6A225uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC89CFF0CAA3CB4uLL) >> 0),
     (VUINT32) ((0xBFC89CFF0CAA3CB4uLL) >> 32)},
    {(VUINT32) ((0x3C6A8D50D06FC30EuLL) >> 0),
     (VUINT32) ((0x3C6A8D50D06FC30EuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBB0F4E73981D4BuLL) >> 0),
     (VUINT32) ((0x3FBB0F4E73981D4BuLL) >> 32)},
    {(VUINT32) ((0xBFA55B103BB2BD6DuLL) >> 0),
     (VUINT32) ((0xBFA55B103BB2BD6DuLL) >> 32)},
    {(VUINT32) ((0x3F9E7ED42D91EC8DuLL) >> 0),
     (VUINT32) ((0x3F9E7ED42D91EC8DuLL) >> 32)},
    {(VUINT32) ((0xBF7E9D9D8AAE7B14uLL) >> 0),
     (VUINT32) ((0xBF7E9D9D8AAE7B14uLL) >> 32)},
    {(VUINT32) ((0x3F6F78B5039EFACAuLL) >> 0),
     (VUINT32) ((0x3F6F78B5039EFACAuLL) >> 32)},
    {(VUINT32) ((0xBF540EDBA3A7865EuLL) >> 0),
     (VUINT32) ((0xBF540EDBA3A7865EuLL) >> 32)},
    {(VUINT32) ((0x3F3AA2CB5E8CB7D1uLL) >> 0),
     (VUINT32) ((0x3F3AA2CB5E8CB7D1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE1ABE4B73FEFB5uLL) >> 0),
     (VUINT32) ((0x3FE1ABE4B73FEFB5uLL) >> 32)},
    {(VUINT32) ((0x3C61A34B6FA942D3uLL) >> 0),
     (VUINT32) ((0x3C61A34B6FA942D3uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC80E29F7BF5633uLL) >> 0),
     (VUINT32) ((0xBFC80E29F7BF5633uLL) >> 32)},
    {(VUINT32) ((0xBC67F8F06ACC6DE1uLL) >> 0),
     (VUINT32) ((0xBC67F8F06ACC6DE1uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBACD17FA976786uLL) >> 0),
     (VUINT32) ((0x3FBACD17FA976786uLL) >> 32)},
    {(VUINT32) ((0xBFA4CC3BAC93F075uLL) >> 0),
     (VUINT32) ((0xBFA4CC3BAC93F075uLL) >> 32)},
    {(VUINT32) ((0x3F9E2026D6967836uLL) >> 0),
     (VUINT32) ((0x3F9E2026D6967836uLL) >> 32)},
    {(VUINT32) ((0xBF7DA94D7C694B78uLL) >> 0),
     (VUINT32) ((0xBF7DA94D7C694B78uLL) >> 32)},
    {(VUINT32) ((0x3F6EBF4F14B98A4DuLL) >> 0),
     (VUINT32) ((0x3F6EBF4F14B98A4DuLL) >> 32)},
    {(VUINT32) ((0xBF534E7211F8744BuLL) >> 0),
     (VUINT32) ((0xBF534E7211F8744BuLL) >> 32)},
    {(VUINT32) ((0xBF2290D134413454uLL) >> 0),
     (VUINT32) ((0xBF2290D134413454uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE1475CC9EEDF01uLL) >> 0),
     (VUINT32) ((0x3FE1475CC9EEDF01uLL) >> 32)},
    {(VUINT32) ((0xBC83DDC5BCE200BBuLL) >> 0),
     (VUINT32) ((0xBC83DDC5BCE200BBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC77FBB85928D2DuLL) >> 0),
     (VUINT32) ((0xBFC77FBB85928D2DuLL) >> 32)},
    {(VUINT32) ((0x3C6121F4E1AC8205uLL) >> 0),
     (VUINT32) ((0x3C6121F4E1AC8205uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBA8C9F83131391uLL) >> 0),
     (VUINT32) ((0x3FBA8C9F83131391uLL) >> 32)},
    {(VUINT32) ((0xBFA43F1E42AF6970uLL) >> 0),
     (VUINT32) ((0xBFA43F1E42AF6970uLL) >> 32)},
    {(VUINT32) ((0x3F9DC4703433CA75uLL) >> 0),
     (VUINT32) ((0x3F9DC4703433CA75uLL) >> 32)},
    {(VUINT32) ((0xBF7CBA92AE7FE396uLL) >> 0),
     (VUINT32) ((0xBF7CBA92AE7FE396uLL) >> 32)},
    {(VUINT32) ((0x3F6E0CB6D0475CBFuLL) >> 0),
     (VUINT32) ((0x3F6E0CB6D0475CBFuLL) >> 32)},
    {(VUINT32) ((0xBF529491FB8790F1uLL) >> 0),
     (VUINT32) ((0xBF529491FB8790F1uLL) >> 32)},
    {(VUINT32) ((0x3F37152AFD512A19uLL) >> 0),
     (VUINT32) ((0x3F37152AFD512A19uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE0E2D4DC9DCE4CuLL) >> 0),
     (VUINT32) ((0x3FE0E2D4DC9DCE4CuLL) >> 32)},
    {(VUINT32) ((0x3C83DBA1AA51ADD5uLL) >> 0),
     (VUINT32) ((0x3C83DBA1AA51ADD5uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC6F1B0FDBE6EDEuLL) >> 0),
     (VUINT32) ((0xBFC6F1B0FDBE6EDEuLL) >> 32)},
    {(VUINT32) ((0xBC614F63025E350FuLL) >> 0),
     (VUINT32) ((0xBC614F63025E350FuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBA4DDFBF32A727uLL) >> 0),
     (VUINT32) ((0x3FBA4DDFBF32A727uLL) >> 32)},
    {(VUINT32) ((0xBFA3B3AA2F826E47uLL) >> 0),
     (VUINT32) ((0xBFA3B3AA2F826E47uLL) >> 32)},
    {(VUINT32) ((0x3F9D6B9F112A3CA9uLL) >> 0),
     (VUINT32) ((0x3F9D6B9F112A3CA9uLL) >> 32)},
    {(VUINT32) ((0xBF7BD1375F2B326EuLL) >> 0),
     (VUINT32) ((0xBF7BD1375F2B326EuLL) >> 32)},
    {(VUINT32) ((0x3F6D60EF002A5944uLL) >> 0),
     (VUINT32) ((0x3F6D60EF002A5944uLL) >> 32)},
    {(VUINT32) ((0xBF51E0E0E3E64206uLL) >> 0),
     (VUINT32) ((0xBF51E0E0E3E64206uLL) >> 32)},
    {(VUINT32) ((0x3F32BFA3B8DB7E72uLL) >> 0),
     (VUINT32) ((0x3F32BFA3B8DB7E72uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE07E4CEF4CBD98uLL) >> 0),
     (VUINT32) ((0x3FE07E4CEF4CBD98uLL) >> 32)},
    {(VUINT32) ((0xBC61ABDBB9EA8E6EuLL) >> 0),
     (VUINT32) ((0xBC61ABDBB9EA8E6EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC66407B0109FA6uLL) >> 0),
     (VUINT32) ((0xBFC66407B0109FA6uLL) >> 32)},
    {(VUINT32) ((0xBC55C3EC26D04386uLL) >> 0),
     (VUINT32) ((0xBC55C3EC26D04386uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBA10D38BFFE319uLL) >> 0),
     (VUINT32) ((0x3FBA10D38BFFE319uLL) >> 32)},
    {(VUINT32) ((0xBFA329D1F417DBD6uLL) >> 0),
     (VUINT32) ((0xBFA329D1F417DBD6uLL) >> 32)},
    {(VUINT32) ((0x3F9D15A2DE544C7CuLL) >> 0),
     (VUINT32) ((0x3F9D15A2DE544C7CuLL) >> 32)},
    {(VUINT32) ((0xBF7AED07977D3236uLL) >> 0),
     (VUINT32) ((0xBF7AED07977D3236uLL) >> 32)},
    {(VUINT32) ((0x3F6CBBAD3C53FDBFuLL) >> 0),
     (VUINT32) ((0x3F6CBBAD3C53FDBFuLL) >> 32)},
    {(VUINT32) ((0xBF513318B342B4E5uLL) >> 0),
     (VUINT32) ((0xBF513318B342B4E5uLL) >> 32)},
    {(VUINT32) ((0x3F1AF93D1229A6F6uLL) >> 0),
     (VUINT32) ((0x3F1AF93D1229A6F6uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FE019C501FBACE4uLL) >> 0),
     (VUINT32) ((0x3FE019C501FBACE4uLL) >> 32)},
    {(VUINT32) ((0xBC8CB18F8746F50CuLL) >> 0),
     (VUINT32) ((0xBC8CB18F8746F50CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC5D6BCF447403EuLL) >> 0),
     (VUINT32) ((0xBFC5D6BCF447403EuLL) >> 32)},
    {(VUINT32) ((0x3C6C6C662876B222uLL) >> 0),
     (VUINT32) ((0x3C6C6C662876B222uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB9D575F071964AuLL) >> 0),
     (VUINT32) ((0x3FB9D575F071964AuLL) >> 32)},
    {(VUINT32) ((0xBFA2A1885E06BEACuLL) >> 0),
     (VUINT32) ((0xBFA2A1885E06BEACuLL) >> 32)},
    {(VUINT32) ((0x3F9CC26BAD1B38B8uLL) >> 0),
     (VUINT32) ((0x3F9CC26BAD1B38B8uLL) >> 32)},
    {(VUINT32) ((0xBF7A0DD116DA5229uLL) >> 0),
     (VUINT32) ((0xBF7A0DD116DA5229uLL) >> 32)},
    {(VUINT32) ((0x3F6C1C921E809C9EuLL) >> 0),
     (VUINT32) ((0x3F6C1C921E809C9EuLL) >> 32)},
    {(VUINT32) ((0xBF508B03CEF8B07AuLL) >> 0),
     (VUINT32) ((0xBF508B03CEF8B07AuLL) >> 32)},
    {(VUINT32) ((0x3F4BCE57D03F879AuLL) >> 0),
     (VUINT32) ((0x3F4BCE57D03F879AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FDF6A7A2955385EuLL) >> 0),
     (VUINT32) ((0x3FDF6A7A2955385EuLL) >> 32)},
    {(VUINT32) ((0x3C760FAFBFD97309uLL) >> 0),
     (VUINT32) ((0x3C760FAFBFD97309uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC549CE29CFCCBEuLL) >> 0),
     (VUINT32) ((0xBFC549CE29CFCCBEuLL) >> 32)},
    {(VUINT32) ((0x3C69881846E0C1CCuLL) >> 0),
     (VUINT32) ((0x3C69881846E0C1CCuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB99BC21C7FB9B2uLL) >> 0),
     (VUINT32) ((0x3FB99BC21C7FB9B2uLL) >> 32)},
    {(VUINT32) ((0xBFA21AC0848A46C5uLL) >> 0),
     (VUINT32) ((0xBFA21AC0848A46C5uLL) >> 32)},
    {(VUINT32) ((0x3F9C71EA2A16819DuLL) >> 0),
     (VUINT32) ((0x3F9C71EA2A16819DuLL) >> 32)},
    {(VUINT32) ((0xBF7933633F8F0072uLL) >> 0),
     (VUINT32) ((0xBF7933633F8F0072uLL) >> 32)},
    {(VUINT32) ((0x3F6B83D1C55099C3uLL) >> 0),
     (VUINT32) ((0x3F6B83D1C55099C3uLL) >> 32)},
    {(VUINT32) ((0xBF4FD088727B159EuLL) >> 0),
     (VUINT32) ((0xBF4FD088727B159EuLL) >> 32)},
    {(VUINT32) ((0xBF2306C94816B8C4uLL) >> 0),
     (VUINT32) ((0xBF2306C94816B8C4uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FDEA16A4EB316F6uLL) >> 0),
     (VUINT32) ((0x3FDEA16A4EB316F6uLL) >> 32)},
    {(VUINT32) ((0xBC7A7D8171BF2FD8uLL) >> 0),
     (VUINT32) ((0xBC7A7D8171BF2FD8uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC4BD38B7876716uLL) >> 0),
     (VUINT32) ((0xBFC4BD38B7876716uLL) >> 32)},
    {(VUINT32) ((0xBC5504069A91A9E0uLL) >> 0),
     (VUINT32) ((0xBC5504069A91A9E0uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB963B368408780uLL) >> 0),
     (VUINT32) ((0x3FB963B368408780uLL) >> 32)},
    {(VUINT32) ((0xBFA1956DC5B1F35AuLL) >> 0),
     (VUINT32) ((0xBFA1956DC5B1F35AuLL) >> 32)},
    {(VUINT32) ((0x3F9C240F984C07DCuLL) >> 0),
     (VUINT32) ((0x3F9C240F984C07DCuLL) >> 32)},
    {(VUINT32) ((0xBF785D8F0388F11CuLL) >> 0),
     (VUINT32) ((0xBF785D8F0388F11CuLL) >> 32)},
    {(VUINT32) ((0x3F6AF0B073DF1CCAuLL) >> 0),
     (VUINT32) ((0x3F6AF0B073DF1CCAuLL) >> 32)},
    {(VUINT32) ((0xBF4E9580D70D34E0uLL) >> 0),
     (VUINT32) ((0xBF4E9580D70D34E0uLL) >> 32)},
    {(VUINT32) ((0x3F4571315C44A425uLL) >> 0),
     (VUINT32) ((0x3F4571315C44A425uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FDDD85A7410F58DuLL) >> 0),
     (VUINT32) ((0x3FDDD85A7410F58DuLL) >> 32)},
    {(VUINT32) ((0xBC66156546AFA570uLL) >> 0),
     (VUINT32) ((0xBC66156546AFA570uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC430FA0B7C7F15uLL) >> 0),
     (VUINT32) ((0xBFC430FA0B7C7F15uLL) >> 32)},
    {(VUINT32) ((0xBC63115D3C69C624uLL) >> 0),
     (VUINT32) ((0xBC63115D3C69C624uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB92D45530E4319uLL) >> 0),
     (VUINT32) ((0x3FB92D45530E4319uLL) >> 32)},
    {(VUINT32) ((0xBFA11183C3A8DFF6uLL) >> 0),
     (VUINT32) ((0xBFA11183C3A8DFF6uLL) >> 32)},
    {(VUINT32) ((0x3F9BD8CDCC073185uLL) >> 0),
     (VUINT32) ((0x3F9BD8CDCC073185uLL) >> 32)},
    {(VUINT32) ((0xBF778C26D2F52E9AuLL) >> 0),
     (VUINT32) ((0xBF778C26D2F52E9AuLL) >> 32)},
    {(VUINT32) ((0x3F6A638650FB676DuLL) >> 0),
     (VUINT32) ((0x3F6A638650FB676DuLL) >> 32)},
    {(VUINT32) ((0xBF4D6420527BDB5BuLL) >> 0),
     (VUINT32) ((0xBF4D6420527BDB5BuLL) >> 32)},
    {(VUINT32) ((0xBF2DA5A645CA3434uLL) >> 0),
     (VUINT32) ((0xBF2DA5A645CA3434uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FDD0F4A996ED424uLL) >> 0),
     (VUINT32) ((0x3FDD0F4A996ED424uLL) >> 32)},
    {(VUINT32) ((0x3C51A070AC3E29A0uLL) >> 0),
     (VUINT32) ((0x3C51A070AC3E29A0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC3A50F9AB1CA91uLL) >> 0),
     (VUINT32) ((0xBFC3A50F9AB1CA91uLL) >> 32)},
    {(VUINT32) ((0xBC50CA3B48D907FAuLL) >> 0),
     (VUINT32) ((0xBC50CA3B48D907FAuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB8F87382B56ACBuLL) >> 0),
     (VUINT32) ((0x3FB8F87382B56ACBuLL) >> 32)},
    {(VUINT32) ((0xBFA08EF662132882uLL) >> 0),
     (VUINT32) ((0xBFA08EF662132882uLL) >> 32)},
    {(VUINT32) ((0x3F9B901726A3CD1CuLL) >> 0),
     (VUINT32) ((0x3F9B901726A3CD1CuLL) >> 32)},
    {(VUINT32) ((0xBF76BEFE8A4461A2uLL) >> 0),
     (VUINT32) ((0xBF76BEFE8A4461A2uLL) >> 32)},
    {(VUINT32) ((0x3F69DBAE42D8A416uLL) >> 0),
     (VUINT32) ((0x3F69DBAE42D8A416uLL) >> 32)},
    {(VUINT32) ((0xBF4C3C52357BF011uLL) >> 0),
     (VUINT32) ((0xBF4C3C52357BF011uLL) >> 32)},
    {(VUINT32) ((0x3F32456D9E7FA4E8uLL) >> 0),
     (VUINT32) ((0x3F32456D9E7FA4E8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FDC463ABECCB2BBuLL) >> 0),
     (VUINT32) ((0x3FDC463ABECCB2BBuLL) >> 32)},
    {(VUINT32) ((0x3C73DAEAF976E788uLL) >> 0),
     (VUINT32) ((0x3C73DAEAF976E788uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC31976E0E280B3uLL) >> 0),
     (VUINT32) ((0xBFC31976E0E280B3uLL) >> 32)},
    {(VUINT32) ((0x3C667516EE4F26F2uLL) >> 0),
     (VUINT32) ((0x3C667516EE4F26F2uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB8C539C2AB0F89uLL) >> 0),
     (VUINT32) ((0x3FB8C539C2AB0F89uLL) >> 32)},
    {(VUINT32) ((0xBFA00DB9C3806462uLL) >> 0),
     (VUINT32) ((0xBFA00DB9C3806462uLL) >> 32)},
    {(VUINT32) ((0x3F9B49DE91DB8E44uLL) >> 0),
     (VUINT32) ((0x3F9B49DE91DB8E44uLL) >> 32)},
    {(VUINT32) ((0xBF75F5EB6258C838uLL) >> 0),
     (VUINT32) ((0xBF75F5EB6258C838uLL) >> 32)},
    {(VUINT32) ((0x3F695952C6BEE603uLL) >> 0),
     (VUINT32) ((0x3F695952C6BEE603uLL) >> 32)},
    {(VUINT32) ((0xBF4B1D691B1E9F12uLL) >> 0),
     (VUINT32) ((0xBF4B1D691B1E9F12uLL) >> 32)},
    {(VUINT32) ((0xBEFC715673917907uLL) >> 0),
     (VUINT32) ((0xBEFC715673917907uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FDB7D2AE42A9153uLL) >> 0),
     (VUINT32) ((0x3FDB7D2AE42A9153uLL) >> 32)},
    {(VUINT32) ((0xBC7CB2463821BB58uLL) >> 0),
     (VUINT32) ((0xBC7CB2463821BB58uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC28E2D6047CBC8uLL) >> 0),
     (VUINT32) ((0xBFC28E2D6047CBC8uLL) >> 32)},
    {(VUINT32) ((0x3C0CEAB2537EA300uLL) >> 0),
     (VUINT32) ((0x3C0CEAB2537EA300uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB89394034B11CFuLL) >> 0),
     (VUINT32) ((0x3FB89394034B11CFuLL) >> 32)},
    {(VUINT32) ((0xBF9F1B848DE48876uLL) >> 0),
     (VUINT32) ((0xBF9F1B848DE48876uLL) >> 32)},
    {(VUINT32) ((0x3F9B06177BDD3821uLL) >> 0),
     (VUINT32) ((0x3F9B06177BDD3821uLL) >> 32)},
    {(VUINT32) ((0xBF7530C3E0150AA0uLL) >> 0),
     (VUINT32) ((0xBF7530C3E0150AA0uLL) >> 32)},
    {(VUINT32) ((0x3F68DBF62FBA70ECuLL) >> 0),
     (VUINT32) ((0x3F68DBF62FBA70ECuLL) >> 32)},
    {(VUINT32) ((0xBF4A0736C860B400uLL) >> 0),
     (VUINT32) ((0xBF4A0736C860B400uLL) >> 32)},
    {(VUINT32) ((0x3F50A3F1D92A1F47uLL) >> 0),
     (VUINT32) ((0x3F50A3F1D92A1F47uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FDAB41B09886FEAuLL) >> 0),
     (VUINT32) ((0x3FDAB41B09886FEAuLL) >> 32)},
    {(VUINT32) ((0xBC6A7EEED374BC71uLL) >> 0),
     (VUINT32) ((0xBC6A7EEED374BC71uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC20330A15F6568uLL) >> 0),
     (VUINT32) ((0xBFC20330A15F6568uLL) >> 32)},
    {(VUINT32) ((0xBC61BB4F210EA632uLL) >> 0),
     (VUINT32) ((0xBC61BB4F210EA632uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB8637E591E05FEuLL) >> 0),
     (VUINT32) ((0x3FB8637E591E05FEuLL) >> 32)},
    {(VUINT32) ((0xBF9E1E090AECCE81uLL) >> 0),
     (VUINT32) ((0xBF9E1E090AECCE81uLL) >> 32)},
    {(VUINT32) ((0x3F9AC4B5D3090946uLL) >> 0),
     (VUINT32) ((0x3F9AC4B5D3090946uLL) >> 32)},
    {(VUINT32) ((0xBF746F5FC5C316BAuLL) >> 0),
     (VUINT32) ((0xBF746F5FC5C316BAuLL) >> 32)},
    {(VUINT32) ((0x3F686400E51F5377uLL) >> 0),
     (VUINT32) ((0x3F686400E51F5377uLL) >> 32)},
    {(VUINT32) ((0xBF48F8EADC3DBAD1uLL) >> 0),
     (VUINT32) ((0xBF48F8EADC3DBAD1uLL) >> 32)},
    {(VUINT32) ((0xBF320AB3DE6FDA08uLL) >> 0),
     (VUINT32) ((0xBF320AB3DE6FDA08uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD9EB0B2EE64E81uLL) >> 0),
     (VUINT32) ((0x3FD9EB0B2EE64E81uLL) >> 32)},
    {(VUINT32) ((0x3C419ABB2567F739uLL) >> 0),
     (VUINT32) ((0x3C419ABB2567F739uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC1787E32B35112uLL) >> 0),
     (VUINT32) ((0xBFC1787E32B35112uLL) >> 32)},
    {(VUINT32) ((0x3C5D2D85EBE7CEA8uLL) >> 0),
     (VUINT32) ((0x3C5D2D85EBE7CEA8uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB834F4FC268515uLL) >> 0),
     (VUINT32) ((0x3FB834F4FC268515uLL) >> 32)},
    {(VUINT32) ((0xBF9D22EA9FA50E7DuLL) >> 0),
     (VUINT32) ((0xBF9D22EA9FA50E7DuLL) >> 32)},
    {(VUINT32) ((0x3F9A85AE02819BA3uLL) >> 0),
     (VUINT32) ((0x3F9A85AE02819BA3uLL) >> 32)},
    {(VUINT32) ((0xBF73B19803AB2B21uLL) >> 0),
     (VUINT32) ((0xBF73B19803AB2B21uLL) >> 32)},
    {(VUINT32) ((0x3F67F0B8C64045E8uLL) >> 0),
     (VUINT32) ((0x3F67F0B8C64045E8uLL) >> 32)},
    {(VUINT32) ((0xBF47F293167B415AuLL) >> 0),
     (VUINT32) ((0xBF47F293167B415AuLL) >> 32)},
    {(VUINT32) ((0xBF198BF45BBDE600uLL) >> 0),
     (VUINT32) ((0xBF198BF45BBDE600uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD921FB54442D18uLL) >> 0),
     (VUINT32) ((0x3FD921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0x3C71A62633145C07uLL) >> 0),
     (VUINT32) ((0x3C71A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC0EE13A8A2A9C6uLL) >> 0),
     (VUINT32) ((0xBFC0EE13A8A2A9C6uLL) >> 32)},
    {(VUINT32) ((0x3C5830A63DDC3262uLL) >> 0),
     (VUINT32) ((0x3C5830A63DDC3262uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB807F44735B1A4uLL) >> 0),
     (VUINT32) ((0x3FB807F44735B1A4uLL) >> 32)},
    {(VUINT32) ((0xBF9C2A135884458AuLL) >> 0),
     (VUINT32) ((0xBF9C2A135884458AuLL) >> 32)},
    {(VUINT32) ((0x3F9A48F4EE376E9DuLL) >> 0),
     (VUINT32) ((0x3F9A48F4EE376E9DuLL) >> 32)},
    {(VUINT32) ((0xBF72F746AAC73A47uLL) >> 0),
     (VUINT32) ((0xBF72F746AAC73A47uLL) >> 32)},
    {(VUINT32) ((0x3F678215824701EAuLL) >> 0),
     (VUINT32) ((0x3F678215824701EAuLL) >> 32)},
    {(VUINT32) ((0xBF46F3C719FB6619uLL) >> 0),
     (VUINT32) ((0xBF46F3C719FB6619uLL) >> 32)},
    {(VUINT32) ((0x3F4BA88D5E69B64EuLL) >> 0),
     (VUINT32) ((0x3F4BA88D5E69B64EuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD858EB79A20BB0uLL) >> 0),
     (VUINT32) ((0x3FD858EB79A20BB0uLL) >> 32)},
    {(VUINT32) ((0xBC7EE70AFE8446D9uLL) >> 0),
     (VUINT32) ((0xBC7EE70AFE8446D9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC063EE9D2B777CuLL) >> 0),
     (VUINT32) ((0xBFC063EE9D2B777CuLL) >> 32)},
    {(VUINT32) ((0xBC4E1787D8B78D9CuLL) >> 0),
     (VUINT32) ((0xBC4E1787D8B78D9CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB7DC78B746BB2FuLL) >> 0),
     (VUINT32) ((0x3FB7DC78B746BB2FuLL) >> 32)},
    {(VUINT32) ((0xBF9B336DA889AC7DuLL) >> 0),
     (VUINT32) ((0xBF9B336DA889AC7DuLL) >> 32)},
    {(VUINT32) ((0x3F9A0E7FEF8737D6uLL) >> 0),
     (VUINT32) ((0x3F9A0E7FEF8737D6uLL) >> 32)},
    {(VUINT32) ((0xBF724046DF328844uLL) >> 0),
     (VUINT32) ((0xBF724046DF328844uLL) >> 32)},
    {(VUINT32) ((0x3F67185639AB9961uLL) >> 0),
     (VUINT32) ((0x3F67185639AB9961uLL) >> 32)},
    {(VUINT32) ((0xBF45FBD25ACB3AEDuLL) >> 0),
     (VUINT32) ((0xBF45FBD25ACB3AEDuLL) >> 32)},
    {(VUINT32) ((0x3F0E765A16190A6DuLL) >> 0),
     (VUINT32) ((0x3F0E765A16190A6DuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD78FDB9EFFEA47uLL) >> 0),
     (VUINT32) ((0x3FD78FDB9EFFEA47uLL) >> 32)},
    {(VUINT32) ((0xBC6EE8786039D373uLL) >> 0),
     (VUINT32) ((0xBC6EE8786039D373uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBFB4195F6B0333uLL) >> 0),
     (VUINT32) ((0xBFBFB4195F6B0333uLL) >> 32)},
    {(VUINT32) ((0xBC47DB89E27050CEuLL) >> 0),
     (VUINT32) ((0xBC47DB89E27050CEuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB7B27EEAE12CDBuLL) >> 0),
     (VUINT32) ((0x3FB7B27EEAE12CDBuLL) >> 32)},
    {(VUINT32) ((0xBF9A3EE464F938D9uLL) >> 0),
     (VUINT32) ((0xBF9A3EE464F938D9uLL) >> 32)},
    {(VUINT32) ((0x3F99D644D21E7AE8uLL) >> 0),
     (VUINT32) ((0x3F99D644D21E7AE8uLL) >> 32)},
    {(VUINT32) ((0xBF718C74CAAA7BA1uLL) >> 0),
     (VUINT32) ((0xBF718C74CAAA7BA1uLL) >> 32)},
    {(VUINT32) ((0x3F66B2F778B94CFDuLL) >> 0),
     (VUINT32) ((0x3F66B2F778B94CFDuLL) >> 32)},
    {(VUINT32) ((0xBF450AB96EF7378BuLL) >> 0),
     (VUINT32) ((0xBF450AB96EF7378BuLL) >> 32)},
    {(VUINT32) ((0x3F1412EF7D22C6CAuLL) >> 0),
     (VUINT32) ((0x3F1412EF7D22C6CAuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD6C6CBC45DC8DEuLL) >> 0),
     (VUINT32) ((0x3FD6C6CBC45DC8DEuLL) >> 32)},
    {(VUINT32) ((0xBBB6D61B58C99C43uLL) >> 0),
     (VUINT32) ((0xBBB6D61B58C99C43uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBEA0D709BC27CAuLL) >> 0),
     (VUINT32) ((0xBFBEA0D709BC27CAuLL) >> 32)},
    {(VUINT32) ((0xBC48928D103E7F70uLL) >> 0),
     (VUINT32) ((0xBC48928D103E7F70uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB78A03A181D6ACuLL) >> 0),
     (VUINT32) ((0x3FB78A03A181D6ACuLL) >> 32)},
    {(VUINT32) ((0xBF994C62C1366C88uLL) >> 0),
     (VUINT32) ((0xBF994C62C1366C88uLL) >> 32)},
    {(VUINT32) ((0x3F99A039D09A41ADuLL) >> 0),
     (VUINT32) ((0x3F99A039D09A41ADuLL) >> 32)},
    {(VUINT32) ((0xBF70DBAD90C6529AuLL) >> 0),
     (VUINT32) ((0xBF70DBAD90C6529AuLL) >> 32)},
    {(VUINT32) ((0x3F66520A2F7F4662uLL) >> 0),
     (VUINT32) ((0x3F66520A2F7F4662uLL) >> 32)},
    {(VUINT32) ((0xBF441FF58F223C4FuLL) >> 0),
     (VUINT32) ((0xBF441FF58F223C4FuLL) >> 32)},
    {(VUINT32) ((0xBF357CCF18E00FA5uLL) >> 0),
     (VUINT32) ((0xBF357CCF18E00FA5uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD5FDBBE9BBA775uLL) >> 0),
     (VUINT32) ((0x3FD5FDBBE9BBA775uLL) >> 32)},
    {(VUINT32) ((0x3C6EE2C2D963A10CuLL) >> 0),
     (VUINT32) ((0x3C6EE2C2D963A10CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBD8E118C89577FuLL) >> 0),
     (VUINT32) ((0xBFBD8E118C89577FuLL) >> 32)},
    {(VUINT32) ((0xBC3344F06C36BFACuLL) >> 0),
     (VUINT32) ((0xBC3344F06C36BFACuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB76303BB0A22C5uLL) >> 0),
     (VUINT32) ((0x3FB76303BB0A22C5uLL) >> 32)},
    {(VUINT32) ((0xBF985BD44ABC0416uLL) >> 0),
     (VUINT32) ((0xBF985BD44ABC0416uLL) >> 32)},
    {(VUINT32) ((0x3F996C5591BA6DFAuLL) >> 0),
     (VUINT32) ((0x3F996C5591BA6DFAuLL) >> 32)},
    {(VUINT32) ((0xBF702DCF4265B5B3uLL) >> 0),
     (VUINT32) ((0xBF702DCF4265B5B3uLL) >> 32)},
    {(VUINT32) ((0x3F65F52766DBD146uLL) >> 0),
     (VUINT32) ((0x3F65F52766DBD146uLL) >> 32)},
    {(VUINT32) ((0xBF433B879649EE5CuLL) >> 0),
     (VUINT32) ((0xBF433B879649EE5CuLL) >> 32)},
    {(VUINT32) ((0x3F47C67A932EC95BuLL) >> 0),
     (VUINT32) ((0x3F47C67A932EC95BuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD534AC0F19860CuLL) >> 0),
     (VUINT32) ((0x3FD534AC0F19860CuLL) >> 32)},
    {(VUINT32) ((0x3C7EE4303B192DA6uLL) >> 0),
     (VUINT32) ((0x3C7EE4303B192DA6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBC7BC444B10758uLL) >> 0),
     (VUINT32) ((0xBFBC7BC444B10758uLL) >> 32)},
    {(VUINT32) ((0x3C511540B2268E0EuLL) >> 0),
     (VUINT32) ((0x3C511540B2268E0EuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB73D7C3735AA80uLL) >> 0),
     (VUINT32) ((0x3FB73D7C3735AA80uLL) >> 32)},
    {(VUINT32) ((0xBF976D24E52F1F79uLL) >> 0),
     (VUINT32) ((0xBF976D24E52F1F79uLL) >> 32)},
    {(VUINT32) ((0x3F993A8F25560FF4uLL) >> 0),
     (VUINT32) ((0x3F993A8F25560FF4uLL) >> 32)},
    {(VUINT32) ((0xBF6F0571A586F6F3uLL) >> 0),
     (VUINT32) ((0xBF6F0571A586F6F3uLL) >> 32)},
    {(VUINT32) ((0x3F659C8E8181F3F0uLL) >> 0),
     (VUINT32) ((0x3F659C8E8181F3F0uLL) >> 32)},
    {(VUINT32) ((0xBF425CCABE1033EAuLL) >> 0),
     (VUINT32) ((0xBF425CCABE1033EAuLL) >> 32)},
    {(VUINT32) ((0x3F4D59CA0EE986DFuLL) >> 0),
     (VUINT32) ((0x3F4D59CA0EE986DFuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD46B9C347764A4uLL) >> 0),
     (VUINT32) ((0x3FD46B9C347764A4uLL) >> 32)},
    {(VUINT32) ((0xBC71A900F67F753AuLL) >> 0),
     (VUINT32) ((0xBC71A900F67F753AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBB69EA984DE6EFuLL) >> 0),
     (VUINT32) ((0xBFBB69EA984DE6EFuLL) >> 32)},
    {(VUINT32) ((0x3C573CB7437F1792uLL) >> 0),
     (VUINT32) ((0x3C573CB7437F1792uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB7196A3515E12EuLL) >> 0),
     (VUINT32) ((0x3FB7196A3515E12EuLL) >> 32)},
    {(VUINT32) ((0xBF968040C68C8FE8uLL) >> 0),
     (VUINT32) ((0xBF968040C68C8FE8uLL) >> 32)},
    {(VUINT32) ((0x3F990ADE01D185E6uLL) >> 0),
     (VUINT32) ((0x3F990ADE01D185E6uLL) >> 32)},
    {(VUINT32) ((0xBF6DB49417B3E65CuLL) >> 0),
     (VUINT32) ((0xBF6DB49417B3E65CuLL) >> 32)},
    {(VUINT32) ((0x3F6548393E856BDBuLL) >> 0),
     (VUINT32) ((0x3F6548393E856BDBuLL) >> 32)},
    {(VUINT32) ((0xBF418353F782833AuLL) >> 0),
     (VUINT32) ((0xBF418353F782833AuLL) >> 32)},
    {(VUINT32) ((0xBF36489E03176323uLL) >> 0),
     (VUINT32) ((0xBF36489E03176323uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD3A28C59D5433BuLL) >> 0),
     (VUINT32) ((0x3FD3A28C59D5433BuLL) >> 32)},
    {(VUINT32) ((0xBC41B19140C0C0D5uLL) >> 0),
     (VUINT32) ((0xBC41B19140C0C0D5uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBA587FF6553726uLL) >> 0),
     (VUINT32) ((0xBFBA587FF6553726uLL) >> 32)},
    {(VUINT32) ((0x3C5559CFE8366BA8uLL) >> 0),
     (VUINT32) ((0x3C5559CFE8366BA8uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB6F6CAF293AC7FuLL) >> 0),
     (VUINT32) ((0x3FB6F6CAF293AC7FuLL) >> 32)},
    {(VUINT32) ((0xBF959514736F007FuLL) >> 0),
     (VUINT32) ((0xBF959514736F007FuLL) >> 32)},
    {(VUINT32) ((0x3F98DD3A019E14EBuLL) >> 0),
     (VUINT32) ((0x3F98DD3A019E14EBuLL) >> 32)},
    {(VUINT32) ((0xBF6C68C706B3D0FBuLL) >> 0),
     (VUINT32) ((0xBF6C68C706B3D0FBuLL) >> 32)},
    {(VUINT32) ((0x3F64F779DB6C50F9uLL) >> 0),
     (VUINT32) ((0x3F64F779DB6C50F9uLL) >> 32)},
    {(VUINT32) ((0xBF40AF7CD7497BC1uLL) >> 0),
     (VUINT32) ((0xBF40AF7CD7497BC1uLL) >> 32)},
    {(VUINT32) ((0x3F4AD3B98213250EuLL) >> 0),
     (VUINT32) ((0x3F4AD3B98213250EuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0x3FD2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0x3C6A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0x3C6A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB9477FD636A4D8uLL) >> 0),
     (VUINT32) ((0xBFB9477FD636A4D8uLL) >> 32)},
    {(VUINT32) ((0x3C5063C8B22C4842uLL) >> 0),
     (VUINT32) ((0x3C5063C8B22C4842uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB6D59BCBF6C48BuLL) >> 0),
     (VUINT32) ((0x3FB6D59BCBF6C48BuLL) >> 32)},
    {(VUINT32) ((0xBF94AB8CBB6CBB16uLL) >> 0),
     (VUINT32) ((0xBF94AB8CBB6CBB16uLL) >> 32)},
    {(VUINT32) ((0x3F98B19B6070D56DuLL) >> 0),
     (VUINT32) ((0x3F98B19B6070D56DuLL) >> 32)},
    {(VUINT32) ((0xBF6B21CD22DB24B2uLL) >> 0),
     (VUINT32) ((0xBF6B21CD22DB24B2uLL) >> 32)},
    {(VUINT32) ((0x3F64AAE4575F07CBuLL) >> 0),
     (VUINT32) ((0x3F64AAE4575F07CBuLL) >> 32)},
    {(VUINT32) ((0xBF3FC08B3806F47FuLL) >> 0),
     (VUINT32) ((0xBF3FC08B3806F47FuLL) >> 32)},
    {(VUINT32) ((0xBF00E427650BA68AuLL) >> 0),
     (VUINT32) ((0xBF00E427650BA68AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD2106CA4910069uLL) >> 0),
     (VUINT32) ((0x3FD2106CA4910069uLL) >> 32)},
    {(VUINT32) ((0x3C7CAF6B74B6A225uLL) >> 0),
     (VUINT32) ((0x3C7CAF6B74B6A225uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB836E5B77D959AuLL) >> 0),
     (VUINT32) ((0xBFB836E5B77D959AuLL) >> 32)},
    {(VUINT32) ((0xBC51BDCEFF6925ECuLL) >> 0),
     (VUINT32) ((0xBC51BDCEFF6925ECuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB6B5DA3B72B738uLL) >> 0),
     (VUINT32) ((0x3FB6B5DA3B72B738uLL) >> 32)},
    {(VUINT32) ((0xBF93C396B58BD74AuLL) >> 0),
     (VUINT32) ((0xBF93C396B58BD74AuLL) >> 32)},
    {(VUINT32) ((0x3F9887FAB9649830uLL) >> 0),
     (VUINT32) ((0x3F9887FAB9649830uLL) >> 32)},
    {(VUINT32) ((0xBF69DF6A8A7C820CuLL) >> 0),
     (VUINT32) ((0xBF69DF6A8A7C820CuLL) >> 32)},
    {(VUINT32) ((0x3F6461D2011761C1uLL) >> 0),
     (VUINT32) ((0x3F6461D2011761C1uLL) >> 32)},
    {(VUINT32) ((0xBF3E2C1220D97FBEuLL) >> 0),
     (VUINT32) ((0xBF3E2C1220D97FBEuLL) >> 32)},
    {(VUINT32) ((0x3F49F3B20EDA3AFFuLL) >> 0),
     (VUINT32) ((0x3F49F3B20EDA3AFFuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD1475CC9EEDF01uLL) >> 0),
     (VUINT32) ((0x3FD1475CC9EEDF01uLL) >> 32)},
    {(VUINT32) ((0xBC73DDC5BCE200BBuLL) >> 0),
     (VUINT32) ((0xBC73DDC5BCE200BBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB726AD2173D50EuLL) >> 0),
     (VUINT32) ((0xBFB726AD2173D50EuLL) >> 32)},
    {(VUINT32) ((0xBC1FCEC90C8BEF70uLL) >> 0),
     (VUINT32) ((0xBC1FCEC90C8BEF70uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB69783D8B96CDFuLL) >> 0),
     (VUINT32) ((0x3FB69783D8B96CDFuLL) >> 32)},
    {(VUINT32) ((0xBF92DD1FBCCBA937uLL) >> 0),
     (VUINT32) ((0xBF92DD1FBCCBA937uLL) >> 32)},
    {(VUINT32) ((0x3F986051045C3883uLL) >> 0),
     (VUINT32) ((0x3F986051045C3883uLL) >> 32)},
    {(VUINT32) ((0xBF68A164B9409BD2uLL) >> 0),
     (VUINT32) ((0xBF68A164B9409BD2uLL) >> 32)},
    {(VUINT32) ((0x3F641CB77D330F8FuLL) >> 0),
     (VUINT32) ((0x3F641CB77D330F8FuLL) >> 32)},
    {(VUINT32) ((0xBF3C9FE910D9CBC2uLL) >> 0),
     (VUINT32) ((0xBF3C9FE910D9CBC2uLL) >> 32)},
    {(VUINT32) ((0xBF302CCA98190297uLL) >> 0),
     (VUINT32) ((0xBF302CCA98190297uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FD07E4CEF4CBD98uLL) >> 0),
     (VUINT32) ((0x3FD07E4CEF4CBD98uLL) >> 32)},
    {(VUINT32) ((0xBC51ABDBB9EA8E6EuLL) >> 0),
     (VUINT32) ((0xBC51ABDBB9EA8E6EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB616D1A2C591A8uLL) >> 0),
     (VUINT32) ((0xBFB616D1A2C591A8uLL) >> 32)},
    {(VUINT32) ((0x3C2EF832FD935ED0uLL) >> 0),
     (VUINT32) ((0x3C2EF832FD935ED0uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB67A9658930D84uLL) >> 0),
     (VUINT32) ((0x3FB67A9658930D84uLL) >> 32)},
    {(VUINT32) ((0xBF91F8156CC25284uLL) >> 0),
     (VUINT32) ((0xBF91F8156CC25284uLL) >> 32)},
    {(VUINT32) ((0x3F983A9794563574uLL) >> 0),
     (VUINT32) ((0x3F983A9794563574uLL) >> 32)},
    {(VUINT32) ((0xBF67678272C8ECDDuLL) >> 0),
     (VUINT32) ((0xBF67678272C8ECDDuLL) >> 32)},
    {(VUINT32) ((0x3F63DAE696E3A38CuLL) >> 0),
     (VUINT32) ((0x3F63DAE696E3A38CuLL) >> 32)},
    {(VUINT32) ((0xBF3B1CDBB342EE5DuLL) >> 0),
     (VUINT32) ((0xBF3B1CDBB342EE5DuLL) >> 32)},
    {(VUINT32) ((0x3F49E00A3B463CAFuLL) >> 0),
     (VUINT32) ((0x3F49E00A3B463CAFuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FCF6A7A2955385EuLL) >> 0),
     (VUINT32) ((0x3FCF6A7A2955385EuLL) >> 32)},
    {(VUINT32) ((0x3C660FAFBFD97309uLL) >> 0),
     (VUINT32) ((0x3C660FAFBFD97309uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB5074ED126983EuLL) >> 0),
     (VUINT32) ((0xBFB5074ED126983EuLL) >> 32)},
    {(VUINT32) ((0x3C516E0EB4132D8CuLL) >> 0),
     (VUINT32) ((0x3C516E0EB4132D8CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB65F0F8C7B2809uLL) >> 0),
     (VUINT32) ((0x3FB65F0F8C7B2809uLL) >> 32)},
    {(VUINT32) ((0xBF9114659E4D5E41uLL) >> 0),
     (VUINT32) ((0xBF9114659E4D5E41uLL) >> 32)},
    {(VUINT32) ((0x3F9816C815084CDAuLL) >> 0),
     (VUINT32) ((0x3F9816C815084CDAuLL) >> 32)},
    {(VUINT32) ((0xBF66318BB353364DuLL) >> 0),
     (VUINT32) ((0xBF66318BB353364DuLL) >> 32)},
    {(VUINT32) ((0x3F639CED9C49E6E4uLL) >> 0),
     (VUINT32) ((0x3F639CED9C49E6E4uLL) >> 32)},
    {(VUINT32) ((0xBF39A0F6E494228EuLL) >> 0),
     (VUINT32) ((0xBF39A0F6E494228EuLL) >> 32)},
    {(VUINT32) ((0xBF2EBBDA5946D8F5uLL) >> 0),
     (VUINT32) ((0xBF2EBBDA5946D8F5uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FCDD85A7410F58DuLL) >> 0),
     (VUINT32) ((0x3FCDD85A7410F58DuLL) >> 32)},
    {(VUINT32) ((0xBC56156546AFA570uLL) >> 0),
     (VUINT32) ((0xBC56156546AFA570uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB3F82048F8BE00uLL) >> 0),
     (VUINT32) ((0xBFB3F82048F8BE00uLL) >> 32)},
    {(VUINT32) ((0xBC4AFD1EBA1D1F08uLL) >> 0),
     (VUINT32) ((0xBC4AFD1EBA1D1F08uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB644ED6242FE19uLL) >> 0),
     (VUINT32) ((0x3FB644ED6242FE19uLL) >> 32)},
    {(VUINT32) ((0xBF9031FE64545C32uLL) >> 0),
     (VUINT32) ((0xBF9031FE64545C32uLL) >> 32)},
    {(VUINT32) ((0x3F97F4DC89754A8CuLL) >> 0),
     (VUINT32) ((0x3F97F4DC89754A8CuLL) >> 32)},
    {(VUINT32) ((0xBF64FF499B056453uLL) >> 0),
     (VUINT32) ((0xBF64FF499B056453uLL) >> 32)},
    {(VUINT32) ((0x3F636226CB0F9286uLL) >> 0),
     (VUINT32) ((0x3F636226CB0F9286uLL) >> 32)},
    {(VUINT32) ((0xBF382D35D5867708uLL) >> 0),
     (VUINT32) ((0xBF382D35D5867708uLL) >> 32)},
    {(VUINT32) ((0x3F3E29EBBEAD3F41uLL) >> 0),
     (VUINT32) ((0x3F3E29EBBEAD3F41uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FCC463ABECCB2BBuLL) >> 0),
     (VUINT32) ((0x3FCC463ABECCB2BBuLL) >> 32)},
    {(VUINT32) ((0x3C63DAEAF976E788uLL) >> 0),
     (VUINT32) ((0x3C63DAEAF976E788uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB2E941ACF368E6uLL) >> 0),
     (VUINT32) ((0xBFB2E941ACF368E6uLL) >> 32)},
    {(VUINT32) ((0x3C28FF4CA630E160uLL) >> 0),
     (VUINT32) ((0x3C28FF4CA630E160uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB62C2DE3B8D982uLL) >> 0),
     (VUINT32) ((0x3FB62C2DE3B8D982uLL) >> 32)},
    {(VUINT32) ((0xBF8EA19C1138E963uLL) >> 0),
     (VUINT32) ((0xBF8EA19C1138E963uLL) >> 32)},
    {(VUINT32) ((0x3F97D4CF49C89DB5uLL) >> 0),
     (VUINT32) ((0x3F97D4CF49C89DB5uLL) >> 32)},
    {(VUINT32) ((0xBF63D0865FBE1BACuLL) >> 0),
     (VUINT32) ((0xBF63D0865FBE1BACuLL) >> 32)},
    {(VUINT32) ((0x3F632AE80D59D97DuLL) >> 0),
     (VUINT32) ((0x3F632AE80D59D97DuLL) >> 32)},
    {(VUINT32) ((0xBF36C01A5963B74DuLL) >> 0),
     (VUINT32) ((0xBF36C01A5963B74DuLL) >> 32)},
    {(VUINT32) ((0x3F2F2207CBA79A42uLL) >> 0),
     (VUINT32) ((0x3F2F2207CBA79A42uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FCAB41B09886FEAuLL) >> 0),
     (VUINT32) ((0x3FCAB41B09886FEAuLL) >> 32)},
    {(VUINT32) ((0xBC5A7EEED374BC71uLL) >> 0),
     (VUINT32) ((0xBC5A7EEED374BC71uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB1DAAEA5CC26DDuLL) >> 0),
     (VUINT32) ((0xBFB1DAAEA5CC26DDuLL) >> 32)},
    {(VUINT32) ((0x3C51577CBB7A4D94uLL) >> 0),
     (VUINT32) ((0x3C51577CBB7A4D94uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB614CF365450F4uLL) >> 0),
     (VUINT32) ((0x3FB614CF365450F4uLL) >> 32)},
    {(VUINT32) ((0xBF8CE1861157F322uLL) >> 0),
     (VUINT32) ((0xBF8CE1861157F322uLL) >> 32)},
    {(VUINT32) ((0x3F97B69B01FB3B26uLL) >> 0),
     (VUINT32) ((0x3F97B69B01FB3B26uLL) >> 32)},
    {(VUINT32) ((0xBF62A50D3A3C528BuLL) >> 0),
     (VUINT32) ((0xBF62A50D3A3C528BuLL) >> 32)},
    {(VUINT32) ((0x3F62F6E9071D40DBuLL) >> 0),
     (VUINT32) ((0x3F62F6E9071D40DBuLL) >> 32)},
    {(VUINT32) ((0xBF3559C86E0B83FEuLL) >> 0),
     (VUINT32) ((0xBF3559C86E0B83FEuLL) >> 32)},
    {(VUINT32) ((0x3F41AFC8FEE8B00AuLL) >> 0),
     (VUINT32) ((0x3F41AFC8FEE8B00AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FC921FB54442D18uLL) >> 0),
     (VUINT32) ((0x3FC921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0x3C61A62633145C07uLL) >> 0),
     (VUINT32) ((0x3C61A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB0CC62E1E04467uLL) >> 0),
     (VUINT32) ((0xBFB0CC62E1E04467uLL) >> 32)},
    {(VUINT32) ((0xBC47805D7AE2B26CuLL) >> 0),
     (VUINT32) ((0xBC47805D7AE2B26CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5FECF9AE763EAuLL) >> 0),
     (VUINT32) ((0x3FB5FECF9AE763EAuLL) >> 32)},
    {(VUINT32) ((0xBF8B23982579F8E5uLL) >> 0),
     (VUINT32) ((0xBF8B23982579F8E5uLL) >> 32)},
    {(VUINT32) ((0x3F979A3AB01644F9uLL) >> 0),
     (VUINT32) ((0x3F979A3AB01644F9uLL) >> 32)},
    {(VUINT32) ((0xBF617CAA57838224uLL) >> 0),
     (VUINT32) ((0xBF617CAA57838224uLL) >> 32)},
    {(VUINT32) ((0x3F62C658DCA7F4ABuLL) >> 0),
     (VUINT32) ((0x3F62C658DCA7F4ABuLL) >> 32)},
    {(VUINT32) ((0xBF33F9251280A953uLL) >> 0),
     (VUINT32) ((0xBF33F9251280A953uLL) >> 32)},
    {(VUINT32) ((0xBF2D5C4E17766D5AuLL) >> 0),
     (VUINT32) ((0xBF2D5C4E17766D5AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FC78FDB9EFFEA47uLL) >> 0),
     (VUINT32) ((0x3FC78FDB9EFFEA47uLL) >> 32)},
    {(VUINT32) ((0xBC5EE8786039D373uLL) >> 0),
     (VUINT32) ((0xBC5EE8786039D373uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFAF7CB429BEA72CuLL) >> 0),
     (VUINT32) ((0xBFAF7CB429BEA72CuLL) >> 32)},
    {(VUINT32) ((0xBC3FFC35F2771324uLL) >> 0),
     (VUINT32) ((0xBC3FFC35F2771324uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5EA2D6D5456CAuLL) >> 0),
     (VUINT32) ((0x3FB5EA2D6D5456CAuLL) >> 32)},
    {(VUINT32) ((0xBF8967B0057BF87EuLL) >> 0),
     (VUINT32) ((0xBF8967B0057BF87EuLL) >> 32)},
    {(VUINT32) ((0x3F977FA9A2ED4D75uLL) >> 0),
     (VUINT32) ((0x3F977FA9A2ED4D75uLL) >> 32)},
    {(VUINT32) ((0xBF60572AC7A74374uLL) >> 0),
     (VUINT32) ((0xBF60572AC7A74374uLL) >> 32)},
    {(VUINT32) ((0x3F6298E78AA42A2CuLL) >> 0),
     (VUINT32) ((0x3F6298E78AA42A2CuLL) >> 32)},
    {(VUINT32) ((0xBF329E8594822820uLL) >> 0),
     (VUINT32) ((0xBF329E8594822820uLL) >> 32)},
    {(VUINT32) ((0xBF37DBAE80B80EC8uLL) >> 0),
     (VUINT32) ((0xBF37DBAE80B80EC8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FC5FDBBE9BBA775uLL) >> 0),
     (VUINT32) ((0x3FC5FDBBE9BBA775uLL) >> 32)},
    {(VUINT32) ((0x3C5EE2C2D963A10CuLL) >> 0),
     (VUINT32) ((0x3C5EE2C2D963A10CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFAD611FEEED2925uLL) >> 0),
     (VUINT32) ((0xBFAD611FEEED2925uLL) >> 32)},
    {(VUINT32) ((0xBC2C094544F37630uLL) >> 0),
     (VUINT32) ((0xBC2C094544F37630uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5D6E7244839E4uLL) >> 0),
     (VUINT32) ((0x3FB5D6E7244839E4uLL) >> 32)},
    {(VUINT32) ((0xBF87ADABBEBF7F7FuLL) >> 0),
     (VUINT32) ((0xBF87ADABBEBF7F7FuLL) >> 32)},
    {(VUINT32) ((0x3F9766E378A69DCAuLL) >> 0),
     (VUINT32) ((0x3F9766E378A69DCAuLL) >> 32)},
    {(VUINT32) ((0xBF5E68B8DEC46BCDuLL) >> 0),
     (VUINT32) ((0xBF5E68B8DEC46BCDuLL) >> 32)},
    {(VUINT32) ((0x3F626E6BF47FF36DuLL) >> 0),
     (VUINT32) ((0x3F626E6BF47FF36DuLL) >> 32)},
    {(VUINT32) ((0xBF3149F4C32A02B4uLL) >> 0),
     (VUINT32) ((0xBF3149F4C32A02B4uLL) >> 32)},
    {(VUINT32) ((0x3F4B764BFF26FBAFuLL) >> 0),
     (VUINT32) ((0x3F4B764BFF26FBAFuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FC46B9C347764A4uLL) >> 0),
     (VUINT32) ((0x3FC46B9C347764A4uLL) >> 32)},
    {(VUINT32) ((0xBC61A900F67F753AuLL) >> 0),
     (VUINT32) ((0xBC61A900F67F753AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFAB46008DFA625DuLL) >> 0),
     (VUINT32) ((0xBFAB46008DFA625DuLL) >> 32)},
    {(VUINT32) ((0x3C1CFC71261A7FB0uLL) >> 0),
     (VUINT32) ((0x3C1CFC71261A7FB0uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5C4FB50FA0748uLL) >> 0),
     (VUINT32) ((0x3FB5C4FB50FA0748uLL) >> 32)},
    {(VUINT32) ((0xBF85F569AE5EF4C9uLL) >> 0),
     (VUINT32) ((0xBF85F569AE5EF4C9uLL) >> 32)},
    {(VUINT32) ((0x3F974FE41D60092FuLL) >> 0),
     (VUINT32) ((0x3F974FE41D60092FuLL) >> 32)},
    {(VUINT32) ((0xBF5C281BF4A7A8E8uLL) >> 0),
     (VUINT32) ((0xBF5C281BF4A7A8E8uLL) >> 32)},
    {(VUINT32) ((0x3F62476FB6177831uLL) >> 0),
     (VUINT32) ((0x3F62476FB6177831uLL) >> 32)},
    {(VUINT32) ((0xBF2FF1DE9AA130D5uLL) >> 0),
     (VUINT32) ((0xBF2FF1DE9AA130D5uLL) >> 32)},
    {(VUINT32) ((0xBF3D841C7D3057BCuLL) >> 0),
     (VUINT32) ((0xBF3D841C7D3057BCuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FC2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0x3FC2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0x3C5A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0x3C5A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA92B4D8A427A5EuLL) >> 0),
     (VUINT32) ((0xBFA92B4D8A427A5EuLL) >> 32)},
    {(VUINT32) ((0xBC48D0F742399A2EuLL) >> 0),
     (VUINT32) ((0xBC48D0F742399A2EuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5B4689EEE44C8uLL) >> 0),
     (VUINT32) ((0x3FB5B4689EEE44C8uLL) >> 32)},
    {(VUINT32) ((0xBF843EC87B78BC83uLL) >> 0),
     (VUINT32) ((0xBF843EC87B78BC83uLL) >> 32)},
    {(VUINT32) ((0x3F973AA7CA62B764uLL) >> 0),
     (VUINT32) ((0x3F973AA7CA62B764uLL) >> 32)},
    {(VUINT32) ((0xBF59EC1D907A7E74uLL) >> 0),
     (VUINT32) ((0xBF59EC1D907A7E74uLL) >> 32)},
    {(VUINT32) ((0x3F62232304CE0BCBuLL) >> 0),
     (VUINT32) ((0x3F62232304CE0BCBuLL) >> 32)},
    {(VUINT32) ((0xBF2D5C019E5C9327uLL) >> 0),
     (VUINT32) ((0xBF2D5C019E5C9327uLL) >> 32)},
    {(VUINT32) ((0x3F4A5742B30D6EA4uLL) >> 0),
     (VUINT32) ((0x3F4A5742B30D6EA4uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FC1475CC9EEDF01uLL) >> 0),
     (VUINT32) ((0x3FC1475CC9EEDF01uLL) >> 32)},
    {(VUINT32) ((0xBC63DDC5BCE200BBuLL) >> 0),
     (VUINT32) ((0xBC63DDC5BCE200BBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA710FE6F2ADA79uLL) >> 0),
     (VUINT32) ((0xBFA710FE6F2ADA79uLL) >> 32)},
    {(VUINT32) ((0x3C47FCD1AF1BC88CuLL) >> 0),
     (VUINT32) ((0x3C47FCD1AF1BC88CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5A52DD3BF1903uLL) >> 0),
     (VUINT32) ((0x3FB5A52DD3BF1903uLL) >> 32)},
    {(VUINT32) ((0xBF8289A7118F8015uLL) >> 0),
     (VUINT32) ((0xBF8289A7118F8015uLL) >> 32)},
    {(VUINT32) ((0x3F97272B048B0CB6uLL) >> 0),
     (VUINT32) ((0x3F97272B048B0CB6uLL) >> 32)},
    {(VUINT32) ((0xBF57B45DC9402B07uLL) >> 0),
     (VUINT32) ((0xBF57B45DC9402B07uLL) >> 32)},
    {(VUINT32) ((0x3F620239A251E2D3uLL) >> 0),
     (VUINT32) ((0x3F620239A251E2D3uLL) >> 32)},
    {(VUINT32) ((0xBF2ACB87C59ED9B1uLL) >> 0),
     (VUINT32) ((0xBF2ACB87C59ED9B1uLL) >> 32)},
    {(VUINT32) ((0xBF314F7BD600B48CuLL) >> 0),
     (VUINT32) ((0xBF314F7BD600B48CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FBF6A7A2955385EuLL) >> 0),
     (VUINT32) ((0x3FBF6A7A2955385EuLL) >> 32)},
    {(VUINT32) ((0x3C560FAFBFD97309uLL) >> 0),
     (VUINT32) ((0x3C560FAFBFD97309uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA4F70ACF7EED25uLL) >> 0),
     (VUINT32) ((0xBFA4F70ACF7EED25uLL) >> 32)},
    {(VUINT32) ((0xBC36D383618823A2uLL) >> 0),
     (VUINT32) ((0xBC36D383618823A2uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB59749CEE8C351uLL) >> 0),
     (VUINT32) ((0x3FB59749CEE8C351uLL) >> 32)},
    {(VUINT32) ((0xBF80D5E49AFDF8A4uLL) >> 0),
     (VUINT32) ((0xBF80D5E49AFDF8A4uLL) >> 32)},
    {(VUINT32) ((0x3F97156A9BCB4ECEuLL) >> 0),
     (VUINT32) ((0x3F97156A9BCB4ECEuLL) >> 32)},
    {(VUINT32) ((0xBF55807DE55737F7uLL) >> 0),
     (VUINT32) ((0xBF55807DE55737F7uLL) >> 32)},
    {(VUINT32) ((0x3F61E4232793575AuLL) >> 0),
     (VUINT32) ((0x3F61E4232793575AuLL) >> 32)},
    {(VUINT32) ((0xBF28440F1D68D5AEuLL) >> 0),
     (VUINT32) ((0xBF28440F1D68D5AEuLL) >> 32)},
    {(VUINT32) ((0xBF29FA204333F00CuLL) >> 0),
     (VUINT32) ((0xBF29FA204333F00CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FBC463ABECCB2BBuLL) >> 0),
     (VUINT32) ((0x3FBC463ABECCB2BBuLL) >> 32)},
    {(VUINT32) ((0x3C53DAEAF976E788uLL) >> 0),
     (VUINT32) ((0x3C53DAEAF976E788uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA2DD6A44CE1394uLL) >> 0),
     (VUINT32) ((0xBFA2DD6A44CE1394uLL) >> 32)},
    {(VUINT32) ((0xBC4BFF776DACC8B5uLL) >> 0),
     (VUINT32) ((0xBC4BFF776DACC8B5uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB58ABB899A6815uLL) >> 0),
     (VUINT32) ((0x3FB58ABB899A6815uLL) >> 32)},
    {(VUINT32) ((0xBF7E46C0F6F92ADFuLL) >> 0),
     (VUINT32) ((0xBF7E46C0F6F92ADFuLL) >> 32)},
    {(VUINT32) ((0x3F970563A9ED840FuLL) >> 0),
     (VUINT32) ((0x3F970563A9ED840FuLL) >> 32)},
    {(VUINT32) ((0xBF53502047076AB7uLL) >> 0),
     (VUINT32) ((0xBF53502047076AB7uLL) >> 32)},
    {(VUINT32) ((0x3F61C8E9B000D23FuLL) >> 0),
     (VUINT32) ((0x3F61C8E9B000D23FuLL) >> 32)},
    {(VUINT32) ((0xBF25C4A8BD148199uLL) >> 0),
     (VUINT32) ((0xBF25C4A8BD148199uLL) >> 32)},
    {(VUINT32) ((0x3F4131449FFC5A0CuLL) >> 0),
     (VUINT32) ((0x3F4131449FFC5A0CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FB921FB54442D18uLL) >> 0),
     (VUINT32) ((0x3FB921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0x3C51A62633145C07uLL) >> 0),
     (VUINT32) ((0x3C51A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA0C4146ECAB658uLL) >> 0),
     (VUINT32) ((0xBFA0C4146ECAB658uLL) >> 32)},
    {(VUINT32) ((0x3C0F927420EB8C00uLL) >> 0),
     (VUINT32) ((0x3C0F927420EB8C00uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB57F82168B23ECuLL) >> 0),
     (VUINT32) ((0x3FB57F82168B23ECuLL) >> 32)},
    {(VUINT32) ((0xBF7AE3F4956ED507uLL) >> 0),
     (VUINT32) ((0xBF7AE3F4956ED507uLL) >> 32)},
    {(VUINT32) ((0x3F96F71391CF9DFEuLL) >> 0),
     (VUINT32) ((0x3F96F71391CF9DFEuLL) >> 32)},
    {(VUINT32) ((0xBF5122E851208A87uLL) >> 0),
     (VUINT32) ((0xBF5122E851208A87uLL) >> 32)},
    {(VUINT32) ((0x3F61B0E12D5FF408uLL) >> 0),
     (VUINT32) ((0x3F61B0E12D5FF408uLL) >> 32)},
    {(VUINT32) ((0xBF23485E9450F437uLL) >> 0),
     (VUINT32) ((0xBF23485E9450F437uLL) >> 32)},
    {(VUINT32) ((0xBF3CE0F3BAD9A7CFuLL) >> 0),
     (VUINT32) ((0xBF3CE0F3BAD9A7CFuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FB5FDBBE9BBA775uLL) >> 0),
     (VUINT32) ((0x3FB5FDBBE9BBA775uLL) >> 32)},
    {(VUINT32) ((0x3C4EE2C2D963A10CuLL) >> 0),
     (VUINT32) ((0x3C4EE2C2D963A10CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF9D5601E554ACE4uLL) >> 0),
     (VUINT32) ((0xBF9D5601E554ACE4uLL) >> 32)},
    {(VUINT32) ((0x3BF1725D940FAE40uLL) >> 0),
     (VUINT32) ((0x3BF1725D940FAE40uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5759CA1D35995uLL) >> 0),
     (VUINT32) ((0x3FB5759CA1D35995uLL) >> 32)},
    {(VUINT32) ((0xBF7783239DE5AD22uLL) >> 0),
     (VUINT32) ((0xBF7783239DE5AD22uLL) >> 32)},
    {(VUINT32) ((0x3F96EA77FED69EC2uLL) >> 0),
     (VUINT32) ((0x3F96EA77FED69EC2uLL) >> 32)},
    {(VUINT32) ((0xBF4DF0F48A9F5DD6uLL) >> 0),
     (VUINT32) ((0xBF4DF0F48A9F5DD6uLL) >> 32)},
    {(VUINT32) ((0x3F619B9AD4B4F692uLL) >> 0),
     (VUINT32) ((0x3F619B9AD4B4F692uLL) >> 32)},
    {(VUINT32) ((0xBF20D3375495B3AFuLL) >> 0),
     (VUINT32) ((0xBF20D3375495B3AFuLL) >> 32)},
    {(VUINT32) ((0xBF3C5F6BDA9649C1uLL) >> 0),
     (VUINT32) ((0xBF3C5F6BDA9649C1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FB2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0x3FB2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0x3C4A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0x3C4A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF99244EF50D08B4uLL) >> 0),
     (VUINT32) ((0xBF99244EF50D08B4uLL) >> 32)},
    {(VUINT32) ((0xBBF5D43FBFA6A650uLL) >> 0),
     (VUINT32) ((0xBBF5D43FBFA6A650uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB56D0A70CA2FAEuLL) >> 0),
     (VUINT32) ((0x3FB56D0A70CA2FAEuLL) >> 32)},
    {(VUINT32) ((0xBF74240DEF7AA427uLL) >> 0),
     (VUINT32) ((0xBF74240DEF7AA427uLL) >> 32)},
    {(VUINT32) ((0x3F96DF8EE40AD931uLL) >> 0),
     (VUINT32) ((0x3F96DF8EE40AD931uLL) >> 32)},
    {(VUINT32) ((0xBF49A0F663CD9CEDuLL) >> 0),
     (VUINT32) ((0xBF49A0F663CD9CEDuLL) >> 32)},
    {(VUINT32) ((0x3F61892DA49A01B1uLL) >> 0),
     (VUINT32) ((0x3F61892DA49A01B1uLL) >> 32)},
    {(VUINT32) ((0xBF1CC6A5F5CD8613uLL) >> 0),
     (VUINT32) ((0xBF1CC6A5F5CD8613uLL) >> 32)},
    {(VUINT32) ((0xBF2979EF025F5A5DuLL) >> 0),
     (VUINT32) ((0xBF2979EF025F5A5DuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FAF6A7A2955385EuLL) >> 0),
     (VUINT32) ((0x3FAF6A7A2955385EuLL) >> 32)},
    {(VUINT32) ((0x3C460FAFBFD97309uLL) >> 0),
     (VUINT32) ((0x3C460FAFBFD97309uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF94F2FF697D458FuLL) >> 0),
     (VUINT32) ((0xBF94F2FF697D458FuLL) >> 32)},
    {(VUINT32) ((0xBC2D47EE0D8639CCuLL) >> 0),
     (VUINT32) ((0xBC2D47EE0D8639CCuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB565CAE1E73473uLL) >> 0),
     (VUINT32) ((0x3FB565CAE1E73473uLL) >> 32)},
    {(VUINT32) ((0xBF70C673B159CE1DuLL) >> 0),
     (VUINT32) ((0xBF70C673B159CE1DuLL) >> 32)},
    {(VUINT32) ((0x3F96D6567B9EC32EuLL) >> 0),
     (VUINT32) ((0x3F96D6567B9EC32EuLL) >> 32)},
    {(VUINT32) ((0xBF455521A900DE57uLL) >> 0),
     (VUINT32) ((0xBF455521A900DE57uLL) >> 32)},
    {(VUINT32) ((0x3F6179A180C97DC6uLL) >> 0),
     (VUINT32) ((0x3F6179A180C97DC6uLL) >> 32)},
    {(VUINT32) ((0xBF17EE9A1A2093ECuLL) >> 0),
     (VUINT32) ((0xBF17EE9A1A2093ECuLL) >> 32)},
    {(VUINT32) ((0xBF0F289C23A5BE3DuLL) >> 0),
     (VUINT32) ((0xBF0F289C23A5BE3DuLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FA921FB54442D18uLL) >> 0),
     (VUINT32) ((0x3FA921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0x3C41A62633145C07uLL) >> 0),
     (VUINT32) ((0x3C41A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF90C202A6B4B69CuLL) >> 0),
     (VUINT32) ((0xBF90C202A6B4B69CuLL) >> 32)},
    {(VUINT32) ((0x3C232719F8027342uLL) >> 0),
     (VUINT32) ((0x3C232719F8027342uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB55FDD6CA81EFBuLL) >> 0),
     (VUINT32) ((0x3FB55FDD6CA81EFBuLL) >> 32)},
    {(VUINT32) ((0xBF6AD42A909B3D64uLL) >> 0),
     (VUINT32) ((0xBF6AD42A909B3D64uLL) >> 32)},
    {(VUINT32) ((0x3F96CECD466E9161uLL) >> 0),
     (VUINT32) ((0x3F96CECD466E9161uLL) >> 32)},
    {(VUINT32) ((0xBF410CC300A993C8uLL) >> 0),
     (VUINT32) ((0xBF410CC300A993C8uLL) >> 32)},
    {(VUINT32) ((0x3F616CF28C1A20ADuLL) >> 0),
     (VUINT32) ((0x3F616CF28C1A20ADuLL) >> 32)},
    {(VUINT32) ((0xBF131CA14234B209uLL) >> 0),
     (VUINT32) ((0xBF131CA14234B209uLL) >> 32)},
    {(VUINT32) ((0xBF0575725B2F6BD2uLL) >> 0),
     (VUINT32) ((0xBF0575725B2F6BD2uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3FA2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0x3FA2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0x3C3A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0x3C3A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF8922902DB2AC11uLL) >> 0),
     (VUINT32) ((0xBF8922902DB2AC11uLL) >> 32)},
    {(VUINT32) ((0xBC23466BF961968DuLL) >> 0),
     (VUINT32) ((0xBC23466BF961968DuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB55B41A17AA68CuLL) >> 0),
     (VUINT32) ((0x3FB55B41A17AA68CuLL) >> 32)},
    {(VUINT32) ((0xBF641D6698BEFAD5uLL) >> 0),
     (VUINT32) ((0xBF641D6698BEFAD5uLL) >> 32)},
    {(VUINT32) ((0x3F96C8F20B94D936uLL) >> 0),
     (VUINT32) ((0x3F96C8F20B94D936uLL) >> 32)},
    {(VUINT32) ((0xBF398E50110336DCuLL) >> 0),
     (VUINT32) ((0xBF398E50110336DCuLL) >> 32)},
    {(VUINT32) ((0x3F61630EF83C40BEuLL) >> 0),
     (VUINT32) ((0x3F61630EF83C40BEuLL) >> 32)},
    {(VUINT32) ((0xBF0CA4CD1D39A327uLL) >> 0),
     (VUINT32) ((0xBF0CA4CD1D39A327uLL) >> 32)},
    {(VUINT32) ((0x3F2D88AA4542B2A9uLL) >> 0),
     (VUINT32) ((0x3F2D88AA4542B2A9uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3F9921FB54442D18uLL) >> 0),
     (VUINT32) ((0x3F9921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0x3C31A62633145C07uLL) >> 0),
     (VUINT32) ((0x3C31A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF80C17E51DDB68FuLL) >> 0),
     (VUINT32) ((0xBF80C17E51DDB68FuLL) >> 32)},
    {(VUINT32) ((0xBC2BCDF2CE757F58uLL) >> 0),
     (VUINT32) ((0xBC2BCDF2CE757F58uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB557F729AA69CBuLL) >> 0),
     (VUINT32) ((0x3FB557F729AA69CBuLL) >> 32)},
    {(VUINT32) ((0xBF5AD039FA1B06A9uLL) >> 0),
     (VUINT32) ((0xBF5AD039FA1B06A9uLL) >> 32)},
    {(VUINT32) ((0x3F96C4C3D80DF7DBuLL) >> 0),
     (VUINT32) ((0x3F96C4C3D80DF7DBuLL) >> 32)},
    {(VUINT32) ((0xBF31073E4843262FuLL) >> 0),
     (VUINT32) ((0xBF31073E4843262FuLL) >> 32)},
    {(VUINT32) ((0x3F615BF0FBDD75F6uLL) >> 0),
     (VUINT32) ((0x3F615BF0FBDD75F6uLL) >> 32)},
    {(VUINT32) ((0xBF032668F6EE96B2uLL) >> 0),
     (VUINT32) ((0xBF032668F6EE96B2uLL) >> 32)},
    {(VUINT32) ((0x3F4AB2BDCBD5B586uLL) >> 0),
     (VUINT32) ((0x3F4AB2BDCBD5B586uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x3F8921FB54442D18uLL) >> 0),
     (VUINT32) ((0x3F8921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0x3C21A62633145C07uLL) >> 0),
     (VUINT32) ((0x3C21A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF70C15D3E7A6D22uLL) >> 0),
     (VUINT32) ((0xBF70C15D3E7A6D22uLL) >> 32)},
    {(VUINT32) ((0xBC031AD41335B3D2uLL) >> 0),
     (VUINT32) ((0xBC031AD41335B3D2uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB555FDC752E0B2uLL) >> 0),
     (VUINT32) ((0x3FB555FDC752E0B2uLL) >> 32)},
    {(VUINT32) ((0xBF4ACF3DF3195D30uLL) >> 0),
     (VUINT32) ((0xBF4ACF3DF3195D30uLL) >> 32)},
    {(VUINT32) ((0x3F96C241FE6B7D5FuLL) >> 0),
     (VUINT32) ((0x3F96C241FE6B7D5FuLL) >> 32)},
    {(VUINT32) ((0xBF2105DD68706FD9uLL) >> 0),
     (VUINT32) ((0xBF2105DD68706FD9uLL) >> 32)},
    {(VUINT32) ((0x3F6157CCAEE0E30BuLL) >> 0),
     (VUINT32) ((0x3F6157CCAEE0E30BuLL) >> 32)},
    {(VUINT32) ((0xBEF320E95C86AAB5uLL) >> 0),
     (VUINT32) ((0xBEF320E95C86AAB5uLL) >> 32)},
    {(VUINT32) ((0x3F36CC59FF7E57F3uLL) >> 0),
     (VUINT32) ((0x3F36CC59FF7E57F3uLL) >> 32)},
    },

   {
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5555555555555uLL) >> 0),
     (VUINT32) ((0x3FB5555555555555uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F96C16C16C4A87EuLL) >> 0),
     (VUINT32) ((0x3F96C16C16C4A87EuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F615658C88FB22BuLL) >> 0),
     (VUINT32) ((0x3F615658C88FB22BuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F45FEB9DABEDDC8uLL) >> 0),
     (VUINT32) ((0x3F45FEB9DABEDDC8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBF8921FB54442D18uLL) >> 0),
     (VUINT32) ((0xBF8921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0xBC21A62633145C07uLL) >> 0),
     (VUINT32) ((0xBC21A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F70C15D3E7A6D22uLL) >> 0),
     (VUINT32) ((0x3F70C15D3E7A6D22uLL) >> 32)},
    {(VUINT32) ((0x3C031AD4127D9F3EuLL) >> 0),
     (VUINT32) ((0x3C031AD4127D9F3EuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB555FDC752E0B2uLL) >> 0),
     (VUINT32) ((0x3FB555FDC752E0B2uLL) >> 32)},
    {(VUINT32) ((0x3F4ACF3DF3195D30uLL) >> 0),
     (VUINT32) ((0x3F4ACF3DF3195D30uLL) >> 32)},
    {(VUINT32) ((0x3F96C241FE6B7D5FuLL) >> 0),
     (VUINT32) ((0x3F96C241FE6B7D5FuLL) >> 32)},
    {(VUINT32) ((0x3F2105DD68707011uLL) >> 0),
     (VUINT32) ((0x3F2105DD68707011uLL) >> 32)},
    {(VUINT32) ((0x3F6157CCAEE0E445uLL) >> 0),
     (VUINT32) ((0x3F6157CCAEE0E445uLL) >> 32)},
    {(VUINT32) ((0x3EF320E95BE3603DuLL) >> 0),
     (VUINT32) ((0x3EF320E95BE3603DuLL) >> 32)},
    {(VUINT32) ((0x3F36CC59FB2A5B52uLL) >> 0),
     (VUINT32) ((0x3F36CC59FB2A5B52uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBF9921FB54442D18uLL) >> 0),
     (VUINT32) ((0xBF9921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0xBC31A62633145C07uLL) >> 0),
     (VUINT32) ((0xBC31A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F80C17E51DDB68FuLL) >> 0),
     (VUINT32) ((0x3F80C17E51DDB68FuLL) >> 32)},
    {(VUINT32) ((0x3C2BCDF2CE751153uLL) >> 0),
     (VUINT32) ((0x3C2BCDF2CE751153uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB557F729AA69CBuLL) >> 0),
     (VUINT32) ((0x3FB557F729AA69CBuLL) >> 32)},
    {(VUINT32) ((0x3F5AD039FA1B06A9uLL) >> 0),
     (VUINT32) ((0x3F5AD039FA1B06A9uLL) >> 32)},
    {(VUINT32) ((0x3F96C4C3D80DF7DBuLL) >> 0),
     (VUINT32) ((0x3F96C4C3D80DF7DBuLL) >> 32)},
    {(VUINT32) ((0x3F31073E4843262EuLL) >> 0),
     (VUINT32) ((0x3F31073E4843262EuLL) >> 32)},
    {(VUINT32) ((0x3F615BF0FBDD7613uLL) >> 0),
     (VUINT32) ((0x3F615BF0FBDD7613uLL) >> 32)},
    {(VUINT32) ((0x3F032668F6F21096uLL) >> 0),
     (VUINT32) ((0x3F032668F6F21096uLL) >> 32)},
    {(VUINT32) ((0x3F4AB2BDCBA34188uLL) >> 0),
     (VUINT32) ((0x3F4AB2BDCBA34188uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFA2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0xBFA2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0xBC3A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0xBC3A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F8922902DB2AC11uLL) >> 0),
     (VUINT32) ((0x3F8922902DB2AC11uLL) >> 32)},
    {(VUINT32) ((0x3C23466BF9645874uLL) >> 0),
     (VUINT32) ((0x3C23466BF9645874uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB55B41A17AA68CuLL) >> 0),
     (VUINT32) ((0x3FB55B41A17AA68CuLL) >> 32)},
    {(VUINT32) ((0x3F641D6698BEFAD5uLL) >> 0),
     (VUINT32) ((0x3F641D6698BEFAD5uLL) >> 32)},
    {(VUINT32) ((0x3F96C8F20B94D936uLL) >> 0),
     (VUINT32) ((0x3F96C8F20B94D936uLL) >> 32)},
    {(VUINT32) ((0x3F398E50110336D4uLL) >> 0),
     (VUINT32) ((0x3F398E50110336D4uLL) >> 32)},
    {(VUINT32) ((0x3F61630EF83C4025uLL) >> 0),
     (VUINT32) ((0x3F61630EF83C4025uLL) >> 32)},
    {(VUINT32) ((0x3F0CA4CD1D548C70uLL) >> 0),
     (VUINT32) ((0x3F0CA4CD1D548C70uLL) >> 32)},
    {(VUINT32) ((0x3F2D88AA497F5A74uLL) >> 0),
     (VUINT32) ((0x3F2D88AA497F5A74uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFA921FB54442D18uLL) >> 0),
     (VUINT32) ((0xBFA921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0xBC41A62633145C07uLL) >> 0),
     (VUINT32) ((0xBC41A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F90C202A6B4B69CuLL) >> 0),
     (VUINT32) ((0x3F90C202A6B4B69CuLL) >> 32)},
    {(VUINT32) ((0xBC232719F82E8E78uLL) >> 0),
     (VUINT32) ((0xBC232719F82E8E78uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB55FDD6CA81EFBuLL) >> 0),
     (VUINT32) ((0x3FB55FDD6CA81EFBuLL) >> 32)},
    {(VUINT32) ((0x3F6AD42A909B3D64uLL) >> 0),
     (VUINT32) ((0x3F6AD42A909B3D64uLL) >> 32)},
    {(VUINT32) ((0x3F96CECD466E9161uLL) >> 0),
     (VUINT32) ((0x3F96CECD466E9161uLL) >> 32)},
    {(VUINT32) ((0x3F410CC300A993FBuLL) >> 0),
     (VUINT32) ((0x3F410CC300A993FBuLL) >> 32)},
    {(VUINT32) ((0x3F616CF28C1A27D9uLL) >> 0),
     (VUINT32) ((0x3F616CF28C1A27D9uLL) >> 32)},
    {(VUINT32) ((0x3F131CA1418B03D0uLL) >> 0),
     (VUINT32) ((0x3F131CA1418B03D0uLL) >> 32)},
    {(VUINT32) ((0xBF0575732696DF46uLL) >> 0),
     (VUINT32) ((0xBF0575732696DF46uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFAF6A7A2955385EuLL) >> 0),
     (VUINT32) ((0xBFAF6A7A2955385EuLL) >> 32)},
    {(VUINT32) ((0xBC460FAFBFD97309uLL) >> 0),
     (VUINT32) ((0xBC460FAFBFD97309uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F94F2FF697D458FuLL) >> 0),
     (VUINT32) ((0x3F94F2FF697D458FuLL) >> 32)},
    {(VUINT32) ((0x3C2D47EE0D83F132uLL) >> 0),
     (VUINT32) ((0x3C2D47EE0D83F132uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB565CAE1E73473uLL) >> 0),
     (VUINT32) ((0x3FB565CAE1E73473uLL) >> 32)},
    {(VUINT32) ((0x3F70C673B159CE1DuLL) >> 0),
     (VUINT32) ((0x3F70C673B159CE1DuLL) >> 32)},
    {(VUINT32) ((0x3F96D6567B9EC32EuLL) >> 0),
     (VUINT32) ((0x3F96D6567B9EC32EuLL) >> 32)},
    {(VUINT32) ((0x3F455521A900DE58uLL) >> 0),
     (VUINT32) ((0x3F455521A900DE58uLL) >> 32)},
    {(VUINT32) ((0x3F6179A180C97E50uLL) >> 0),
     (VUINT32) ((0x3F6179A180C97E50uLL) >> 32)},
    {(VUINT32) ((0x3F17EE9A1A1D88C1uLL) >> 0),
     (VUINT32) ((0x3F17EE9A1A1D88C1uLL) >> 32)},
    {(VUINT32) ((0xBF0F289C329281E6uLL) >> 0),
     (VUINT32) ((0xBF0F289C329281E6uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFB2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0xBFB2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0xBC4A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0xBC4A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F99244EF50D08B4uLL) >> 0),
     (VUINT32) ((0x3F99244EF50D08B4uLL) >> 32)},
    {(VUINT32) ((0x3BF5D43FBF890B40uLL) >> 0),
     (VUINT32) ((0x3BF5D43FBF890B40uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB56D0A70CA2FAEuLL) >> 0),
     (VUINT32) ((0x3FB56D0A70CA2FAEuLL) >> 32)},
    {(VUINT32) ((0x3F74240DEF7AA427uLL) >> 0),
     (VUINT32) ((0x3F74240DEF7AA427uLL) >> 32)},
    {(VUINT32) ((0x3F96DF8EE40AD931uLL) >> 0),
     (VUINT32) ((0x3F96DF8EE40AD931uLL) >> 32)},
    {(VUINT32) ((0x3F49A0F663CD9CEEuLL) >> 0),
     (VUINT32) ((0x3F49A0F663CD9CEEuLL) >> 32)},
    {(VUINT32) ((0x3F61892DA49A0241uLL) >> 0),
     (VUINT32) ((0x3F61892DA49A0241uLL) >> 32)},
    {(VUINT32) ((0x3F1CC6A5F5CAD66BuLL) >> 0),
     (VUINT32) ((0x3F1CC6A5F5CAD66BuLL) >> 32)},
    {(VUINT32) ((0xBF2979EF063C00F3uLL) >> 0),
     (VUINT32) ((0xBF2979EF063C00F3uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFB5FDBBE9BBA775uLL) >> 0),
     (VUINT32) ((0xBFB5FDBBE9BBA775uLL) >> 32)},
    {(VUINT32) ((0xBC4EE2C2D963A10CuLL) >> 0),
     (VUINT32) ((0xBC4EE2C2D963A10CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F9D5601E554ACE4uLL) >> 0),
     (VUINT32) ((0x3F9D5601E554ACE4uLL) >> 32)},
    {(VUINT32) ((0xBBF1725D944B6FF0uLL) >> 0),
     (VUINT32) ((0xBBF1725D944B6FF0uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5759CA1D35995uLL) >> 0),
     (VUINT32) ((0x3FB5759CA1D35995uLL) >> 32)},
    {(VUINT32) ((0x3F7783239DE5AD22uLL) >> 0),
     (VUINT32) ((0x3F7783239DE5AD22uLL) >> 32)},
    {(VUINT32) ((0x3F96EA77FED69EC2uLL) >> 0),
     (VUINT32) ((0x3F96EA77FED69EC2uLL) >> 32)},
    {(VUINT32) ((0x3F4DF0F48A9F5DD8uLL) >> 0),
     (VUINT32) ((0x3F4DF0F48A9F5DD8uLL) >> 32)},
    {(VUINT32) ((0x3F619B9AD4B4F72FuLL) >> 0),
     (VUINT32) ((0x3F619B9AD4B4F72FuLL) >> 32)},
    {(VUINT32) ((0x3F20D33754930861uLL) >> 0),
     (VUINT32) ((0x3F20D33754930861uLL) >> 32)},
    {(VUINT32) ((0xBF3C5F6BDCAA4F14uLL) >> 0),
     (VUINT32) ((0xBF3C5F6BDCAA4F14uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFB921FB54442D18uLL) >> 0),
     (VUINT32) ((0xBFB921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0xBC51A62633145C07uLL) >> 0),
     (VUINT32) ((0xBC51A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA0C4146ECAB658uLL) >> 0),
     (VUINT32) ((0x3FA0C4146ECAB658uLL) >> 32)},
    {(VUINT32) ((0xBC0F9274210C3E30uLL) >> 0),
     (VUINT32) ((0xBC0F9274210C3E30uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB57F82168B23ECuLL) >> 0),
     (VUINT32) ((0x3FB57F82168B23ECuLL) >> 32)},
    {(VUINT32) ((0x3F7AE3F4956ED507uLL) >> 0),
     (VUINT32) ((0x3F7AE3F4956ED507uLL) >> 32)},
    {(VUINT32) ((0x3F96F71391CF9DFEuLL) >> 0),
     (VUINT32) ((0x3F96F71391CF9DFEuLL) >> 32)},
    {(VUINT32) ((0x3F5122E851208A88uLL) >> 0),
     (VUINT32) ((0x3F5122E851208A88uLL) >> 32)},
    {(VUINT32) ((0x3F61B0E12D5FF46BuLL) >> 0),
     (VUINT32) ((0x3F61B0E12D5FF46BuLL) >> 32)},
    {(VUINT32) ((0x3F23485E944E645FuLL) >> 0),
     (VUINT32) ((0x3F23485E944E645FuLL) >> 32)},
    {(VUINT32) ((0xBF3CE0F3BC206D6AuLL) >> 0),
     (VUINT32) ((0xBF3CE0F3BC206D6AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFBC463ABECCB2BBuLL) >> 0),
     (VUINT32) ((0xBFBC463ABECCB2BBuLL) >> 32)},
    {(VUINT32) ((0xBC53DAEAF976E788uLL) >> 0),
     (VUINT32) ((0xBC53DAEAF976E788uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA2DD6A44CE1394uLL) >> 0),
     (VUINT32) ((0x3FA2DD6A44CE1394uLL) >> 32)},
    {(VUINT32) ((0x3C4BFF776DAE2ACCuLL) >> 0),
     (VUINT32) ((0x3C4BFF776DAE2ACCuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB58ABB899A6815uLL) >> 0),
     (VUINT32) ((0x3FB58ABB899A6815uLL) >> 32)},
    {(VUINT32) ((0x3F7E46C0F6F92ADFuLL) >> 0),
     (VUINT32) ((0x3F7E46C0F6F92ADFuLL) >> 32)},
    {(VUINT32) ((0x3F970563A9ED840FuLL) >> 0),
     (VUINT32) ((0x3F970563A9ED840FuLL) >> 32)},
    {(VUINT32) ((0x3F53502047076AB6uLL) >> 0),
     (VUINT32) ((0x3F53502047076AB6uLL) >> 32)},
    {(VUINT32) ((0x3F61C8E9B000D225uLL) >> 0),
     (VUINT32) ((0x3F61C8E9B000D225uLL) >> 32)},
    {(VUINT32) ((0x3F25C4A8BD17699AuLL) >> 0),
     (VUINT32) ((0x3F25C4A8BD17699AuLL) >> 32)},
    {(VUINT32) ((0x3F413144A024F67FuLL) >> 0),
     (VUINT32) ((0x3F413144A024F67FuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFBF6A7A2955385EuLL) >> 0),
     (VUINT32) ((0xBFBF6A7A2955385EuLL) >> 32)},
    {(VUINT32) ((0xBC560FAFBFD97309uLL) >> 0),
     (VUINT32) ((0xBC560FAFBFD97309uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA4F70ACF7EED25uLL) >> 0),
     (VUINT32) ((0x3FA4F70ACF7EED25uLL) >> 32)},
    {(VUINT32) ((0x3C36D38361835224uLL) >> 0),
     (VUINT32) ((0x3C36D38361835224uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB59749CEE8C351uLL) >> 0),
     (VUINT32) ((0x3FB59749CEE8C351uLL) >> 32)},
    {(VUINT32) ((0x3F80D5E49AFDF8A4uLL) >> 0),
     (VUINT32) ((0x3F80D5E49AFDF8A4uLL) >> 32)},
    {(VUINT32) ((0x3F97156A9BCB4ECEuLL) >> 0),
     (VUINT32) ((0x3F97156A9BCB4ECEuLL) >> 32)},
    {(VUINT32) ((0x3F55807DE55737F9uLL) >> 0),
     (VUINT32) ((0x3F55807DE55737F9uLL) >> 32)},
    {(VUINT32) ((0x3F61E42327935766uLL) >> 0),
     (VUINT32) ((0x3F61E42327935766uLL) >> 32)},
    {(VUINT32) ((0x3F28440F1D62D6E1uLL) >> 0),
     (VUINT32) ((0x3F28440F1D62D6E1uLL) >> 32)},
    {(VUINT32) ((0xBF29FA20436AFB73uLL) >> 0),
     (VUINT32) ((0xBF29FA20436AFB73uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFC1475CC9EEDF01uLL) >> 0),
     (VUINT32) ((0xBFC1475CC9EEDF01uLL) >> 32)},
    {(VUINT32) ((0x3C63DDC5BCE200BBuLL) >> 0),
     (VUINT32) ((0x3C63DDC5BCE200BBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA710FE6F2ADA79uLL) >> 0),
     (VUINT32) ((0x3FA710FE6F2ADA79uLL) >> 32)},
    {(VUINT32) ((0xBC47FCD1AF1E5F81uLL) >> 0),
     (VUINT32) ((0xBC47FCD1AF1E5F81uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5A52DD3BF1903uLL) >> 0),
     (VUINT32) ((0x3FB5A52DD3BF1903uLL) >> 32)},
    {(VUINT32) ((0x3F8289A7118F8015uLL) >> 0),
     (VUINT32) ((0x3F8289A7118F8015uLL) >> 32)},
    {(VUINT32) ((0x3F97272B048B0CB6uLL) >> 0),
     (VUINT32) ((0x3F97272B048B0CB6uLL) >> 32)},
    {(VUINT32) ((0x3F57B45DC9402B09uLL) >> 0),
     (VUINT32) ((0x3F57B45DC9402B09uLL) >> 32)},
    {(VUINT32) ((0x3F620239A251E2C5uLL) >> 0),
     (VUINT32) ((0x3F620239A251E2C5uLL) >> 32)},
    {(VUINT32) ((0x3F2ACB87C598F86BuLL) >> 0),
     (VUINT32) ((0x3F2ACB87C598F86BuLL) >> 32)},
    {(VUINT32) ((0xBF314F7BD5BDC85CuLL) >> 0),
     (VUINT32) ((0xBF314F7BD5BDC85CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFC2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0xBFC2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0xBC5A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0xBC5A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA92B4D8A427A5EuLL) >> 0),
     (VUINT32) ((0x3FA92B4D8A427A5EuLL) >> 32)},
    {(VUINT32) ((0x3C48D0F7423D245AuLL) >> 0),
     (VUINT32) ((0x3C48D0F7423D245AuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5B4689EEE44C8uLL) >> 0),
     (VUINT32) ((0x3FB5B4689EEE44C8uLL) >> 32)},
    {(VUINT32) ((0x3F843EC87B78BC83uLL) >> 0),
     (VUINT32) ((0x3F843EC87B78BC83uLL) >> 32)},
    {(VUINT32) ((0x3F973AA7CA62B764uLL) >> 0),
     (VUINT32) ((0x3F973AA7CA62B764uLL) >> 32)},
    {(VUINT32) ((0x3F59EC1D907A7E71uLL) >> 0),
     (VUINT32) ((0x3F59EC1D907A7E71uLL) >> 32)},
    {(VUINT32) ((0x3F62232304CE0BF5uLL) >> 0),
     (VUINT32) ((0x3F62232304CE0BF5uLL) >> 32)},
    {(VUINT32) ((0x3F2D5C019E659382uLL) >> 0),
     (VUINT32) ((0x3F2D5C019E659382uLL) >> 32)},
    {(VUINT32) ((0x3F4A5742B2B8EFA5uLL) >> 0),
     (VUINT32) ((0x3F4A5742B2B8EFA5uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFC46B9C347764A4uLL) >> 0),
     (VUINT32) ((0xBFC46B9C347764A4uLL) >> 32)},
    {(VUINT32) ((0x3C61A900F67F753AuLL) >> 0),
     (VUINT32) ((0x3C61A900F67F753AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FAB46008DFA625DuLL) >> 0),
     (VUINT32) ((0x3FAB46008DFA625DuLL) >> 32)},
    {(VUINT32) ((0xBC1CFC712619CB40uLL) >> 0),
     (VUINT32) ((0xBC1CFC712619CB40uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5C4FB50FA0748uLL) >> 0),
     (VUINT32) ((0x3FB5C4FB50FA0748uLL) >> 32)},
    {(VUINT32) ((0x3F85F569AE5EF4C9uLL) >> 0),
     (VUINT32) ((0x3F85F569AE5EF4C9uLL) >> 32)},
    {(VUINT32) ((0x3F974FE41D60092FuLL) >> 0),
     (VUINT32) ((0x3F974FE41D60092FuLL) >> 32)},
    {(VUINT32) ((0x3F5C281BF4A7A8E8uLL) >> 0),
     (VUINT32) ((0x3F5C281BF4A7A8E8uLL) >> 32)},
    {(VUINT32) ((0x3F62476FB617789EuLL) >> 0),
     (VUINT32) ((0x3F62476FB617789EuLL) >> 32)},
    {(VUINT32) ((0x3F2FF1DE9AA127B2uLL) >> 0),
     (VUINT32) ((0x3F2FF1DE9AA127B2uLL) >> 32)},
    {(VUINT32) ((0xBF3D841C7EAC9D16uLL) >> 0),
     (VUINT32) ((0xBF3D841C7EAC9D16uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFC5FDBBE9BBA775uLL) >> 0),
     (VUINT32) ((0xBFC5FDBBE9BBA775uLL) >> 32)},
    {(VUINT32) ((0xBC5EE2C2D963A10CuLL) >> 0),
     (VUINT32) ((0xBC5EE2C2D963A10CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FAD611FEEED2925uLL) >> 0),
     (VUINT32) ((0x3FAD611FEEED2925uLL) >> 32)},
    {(VUINT32) ((0x3C2C094544F32A78uLL) >> 0),
     (VUINT32) ((0x3C2C094544F32A78uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5D6E7244839E4uLL) >> 0),
     (VUINT32) ((0x3FB5D6E7244839E4uLL) >> 32)},
    {(VUINT32) ((0x3F87ADABBEBF7F7FuLL) >> 0),
     (VUINT32) ((0x3F87ADABBEBF7F7FuLL) >> 32)},
    {(VUINT32) ((0x3F9766E378A69DCAuLL) >> 0),
     (VUINT32) ((0x3F9766E378A69DCAuLL) >> 32)},
    {(VUINT32) ((0x3F5E68B8DEC46BCDuLL) >> 0),
     (VUINT32) ((0x3F5E68B8DEC46BCDuLL) >> 32)},
    {(VUINT32) ((0x3F626E6BF47FF315uLL) >> 0),
     (VUINT32) ((0x3F626E6BF47FF315uLL) >> 32)},
    {(VUINT32) ((0x3F3149F4C32A0685uLL) >> 0),
     (VUINT32) ((0x3F3149F4C32A0685uLL) >> 32)},
    {(VUINT32) ((0x3F4B764BFFC07D27uLL) >> 0),
     (VUINT32) ((0x3F4B764BFFC07D27uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFC78FDB9EFFEA47uLL) >> 0),
     (VUINT32) ((0xBFC78FDB9EFFEA47uLL) >> 32)},
    {(VUINT32) ((0x3C5EE8786039D373uLL) >> 0),
     (VUINT32) ((0x3C5EE8786039D373uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FAF7CB429BEA72CuLL) >> 0),
     (VUINT32) ((0x3FAF7CB429BEA72CuLL) >> 32)},
    {(VUINT32) ((0x3C3FFC35F277313AuLL) >> 0),
     (VUINT32) ((0x3C3FFC35F277313AuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5EA2D6D5456CAuLL) >> 0),
     (VUINT32) ((0x3FB5EA2D6D5456CAuLL) >> 32)},
    {(VUINT32) ((0x3F8967B0057BF87EuLL) >> 0),
     (VUINT32) ((0x3F8967B0057BF87EuLL) >> 32)},
    {(VUINT32) ((0x3F977FA9A2ED4D75uLL) >> 0),
     (VUINT32) ((0x3F977FA9A2ED4D75uLL) >> 32)},
    {(VUINT32) ((0x3F60572AC7A74374uLL) >> 0),
     (VUINT32) ((0x3F60572AC7A74374uLL) >> 32)},
    {(VUINT32) ((0x3F6298E78AA42A95uLL) >> 0),
     (VUINT32) ((0x3F6298E78AA42A95uLL) >> 32)},
    {(VUINT32) ((0x3F329E8594822508uLL) >> 0),
     (VUINT32) ((0x3F329E8594822508uLL) >> 32)},
    {(VUINT32) ((0xBF37DBAE822657B7uLL) >> 0),
     (VUINT32) ((0xBF37DBAE822657B7uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFC921FB54442D18uLL) >> 0),
     (VUINT32) ((0xBFC921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0xBC61A62633145C07uLL) >> 0),
     (VUINT32) ((0xBC61A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB0CC62E1E04467uLL) >> 0),
     (VUINT32) ((0x3FB0CC62E1E04467uLL) >> 32)},
    {(VUINT32) ((0x3C47805D7AE2BD94uLL) >> 0),
     (VUINT32) ((0x3C47805D7AE2BD94uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5FECF9AE763EAuLL) >> 0),
     (VUINT32) ((0x3FB5FECF9AE763EAuLL) >> 32)},
    {(VUINT32) ((0x3F8B23982579F8E5uLL) >> 0),
     (VUINT32) ((0x3F8B23982579F8E5uLL) >> 32)},
    {(VUINT32) ((0x3F979A3AB01644F9uLL) >> 0),
     (VUINT32) ((0x3F979A3AB01644F9uLL) >> 32)},
    {(VUINT32) ((0x3F617CAA57838224uLL) >> 0),
     (VUINT32) ((0x3F617CAA57838224uLL) >> 32)},
    {(VUINT32) ((0x3F62C658DCA7F4F9uLL) >> 0),
     (VUINT32) ((0x3F62C658DCA7F4F9uLL) >> 32)},
    {(VUINT32) ((0x3F33F9251280A70AuLL) >> 0),
     (VUINT32) ((0x3F33F9251280A70AuLL) >> 32)},
    {(VUINT32) ((0xBF2D5C4E19969DC6uLL) >> 0),
     (VUINT32) ((0xBF2D5C4E19969DC6uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFCAB41B09886FEAuLL) >> 0),
     (VUINT32) ((0xBFCAB41B09886FEAuLL) >> 32)},
    {(VUINT32) ((0x3C5A7EEED374BC71uLL) >> 0),
     (VUINT32) ((0x3C5A7EEED374BC71uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB1DAAEA5CC26DDuLL) >> 0),
     (VUINT32) ((0x3FB1DAAEA5CC26DDuLL) >> 32)},
    {(VUINT32) ((0xBC51577CBB7A50E2uLL) >> 0),
     (VUINT32) ((0xBC51577CBB7A50E2uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB614CF365450F4uLL) >> 0),
     (VUINT32) ((0x3FB614CF365450F4uLL) >> 32)},
    {(VUINT32) ((0x3F8CE1861157F322uLL) >> 0),
     (VUINT32) ((0x3F8CE1861157F322uLL) >> 32)},
    {(VUINT32) ((0x3F97B69B01FB3B26uLL) >> 0),
     (VUINT32) ((0x3F97B69B01FB3B26uLL) >> 32)},
    {(VUINT32) ((0x3F62A50D3A3C528BuLL) >> 0),
     (VUINT32) ((0x3F62A50D3A3C528BuLL) >> 32)},
    {(VUINT32) ((0x3F62F6E9071D40ACuLL) >> 0),
     (VUINT32) ((0x3F62F6E9071D40ACuLL) >> 32)},
    {(VUINT32) ((0x3F3559C86E0B8558uLL) >> 0),
     (VUINT32) ((0x3F3559C86E0B8558uLL) >> 32)},
    {(VUINT32) ((0x3F41AFC8FF3AAA17uLL) >> 0),
     (VUINT32) ((0x3F41AFC8FF3AAA17uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFCC463ABECCB2BBuLL) >> 0),
     (VUINT32) ((0xBFCC463ABECCB2BBuLL) >> 32)},
    {(VUINT32) ((0xBC63DAEAF976E788uLL) >> 0),
     (VUINT32) ((0xBC63DAEAF976E788uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB2E941ACF368E6uLL) >> 0),
     (VUINT32) ((0x3FB2E941ACF368E6uLL) >> 32)},
    {(VUINT32) ((0xBC28FF4CA630E010uLL) >> 0),
     (VUINT32) ((0xBC28FF4CA630E010uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB62C2DE3B8D982uLL) >> 0),
     (VUINT32) ((0x3FB62C2DE3B8D982uLL) >> 32)},
    {(VUINT32) ((0x3F8EA19C1138E963uLL) >> 0),
     (VUINT32) ((0x3F8EA19C1138E963uLL) >> 32)},
    {(VUINT32) ((0x3F97D4CF49C89DB5uLL) >> 0),
     (VUINT32) ((0x3F97D4CF49C89DB5uLL) >> 32)},
    {(VUINT32) ((0x3F63D0865FBE1BACuLL) >> 0),
     (VUINT32) ((0x3F63D0865FBE1BACuLL) >> 32)},
    {(VUINT32) ((0x3F632AE80D59D97FuLL) >> 0),
     (VUINT32) ((0x3F632AE80D59D97FuLL) >> 32)},
    {(VUINT32) ((0x3F36C01A5963B73CuLL) >> 0),
     (VUINT32) ((0x3F36C01A5963B73CuLL) >> 32)},
    {(VUINT32) ((0x3F2F2207CB99A5D3uLL) >> 0),
     (VUINT32) ((0x3F2F2207CB99A5D3uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFCDD85A7410F58DuLL) >> 0),
     (VUINT32) ((0xBFCDD85A7410F58DuLL) >> 32)},
    {(VUINT32) ((0x3C56156546AFA570uLL) >> 0),
     (VUINT32) ((0x3C56156546AFA570uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB3F82048F8BE00uLL) >> 0),
     (VUINT32) ((0x3FB3F82048F8BE00uLL) >> 32)},
    {(VUINT32) ((0x3C4AFD1EBA1D1ABAuLL) >> 0),
     (VUINT32) ((0x3C4AFD1EBA1D1ABAuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB644ED6242FE19uLL) >> 0),
     (VUINT32) ((0x3FB644ED6242FE19uLL) >> 32)},
    {(VUINT32) ((0x3F9031FE64545C32uLL) >> 0),
     (VUINT32) ((0x3F9031FE64545C32uLL) >> 32)},
    {(VUINT32) ((0x3F97F4DC89754A8CuLL) >> 0),
     (VUINT32) ((0x3F97F4DC89754A8CuLL) >> 32)},
    {(VUINT32) ((0x3F64FF499B056453uLL) >> 0),
     (VUINT32) ((0x3F64FF499B056453uLL) >> 32)},
    {(VUINT32) ((0x3F636226CB0F9266uLL) >> 0),
     (VUINT32) ((0x3F636226CB0F9266uLL) >> 32)},
    {(VUINT32) ((0x3F382D35D58677E8uLL) >> 0),
     (VUINT32) ((0x3F382D35D58677E8uLL) >> 32)},
    {(VUINT32) ((0x3F3E29EBBF1CE01EuLL) >> 0),
     (VUINT32) ((0x3F3E29EBBF1CE01EuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFCF6A7A2955385EuLL) >> 0),
     (VUINT32) ((0xBFCF6A7A2955385EuLL) >> 32)},
    {(VUINT32) ((0xBC660FAFBFD97309uLL) >> 0),
     (VUINT32) ((0xBC660FAFBFD97309uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5074ED126983EuLL) >> 0),
     (VUINT32) ((0x3FB5074ED126983EuLL) >> 32)},
    {(VUINT32) ((0xBC516E0EB4132866uLL) >> 0),
     (VUINT32) ((0xBC516E0EB4132866uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB65F0F8C7B2809uLL) >> 0),
     (VUINT32) ((0x3FB65F0F8C7B2809uLL) >> 32)},
    {(VUINT32) ((0x3F9114659E4D5E41uLL) >> 0),
     (VUINT32) ((0x3F9114659E4D5E41uLL) >> 32)},
    {(VUINT32) ((0x3F9816C815084CDAuLL) >> 0),
     (VUINT32) ((0x3F9816C815084CDAuLL) >> 32)},
    {(VUINT32) ((0x3F66318BB353364DuLL) >> 0),
     (VUINT32) ((0x3F66318BB353364DuLL) >> 32)},
    {(VUINT32) ((0x3F639CED9C49E72FuLL) >> 0),
     (VUINT32) ((0x3F639CED9C49E72FuLL) >> 32)},
    {(VUINT32) ((0x3F39A0F6E4942078uLL) >> 0),
     (VUINT32) ((0x3F39A0F6E4942078uLL) >> 32)},
    {(VUINT32) ((0xBF2EBBDA5B521AEEuLL) >> 0),
     (VUINT32) ((0xBF2EBBDA5B521AEEuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD07E4CEF4CBD98uLL) >> 0),
     (VUINT32) ((0xBFD07E4CEF4CBD98uLL) >> 32)},
    {(VUINT32) ((0x3C51ABDBB9EA8E6EuLL) >> 0),
     (VUINT32) ((0x3C51ABDBB9EA8E6EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB616D1A2C591A8uLL) >> 0),
     (VUINT32) ((0x3FB616D1A2C591A8uLL) >> 32)},
    {(VUINT32) ((0xBC2EF832FD938898uLL) >> 0),
     (VUINT32) ((0xBC2EF832FD938898uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB67A9658930D84uLL) >> 0),
     (VUINT32) ((0x3FB67A9658930D84uLL) >> 32)},
    {(VUINT32) ((0x3F91F8156CC25284uLL) >> 0),
     (VUINT32) ((0x3F91F8156CC25284uLL) >> 32)},
    {(VUINT32) ((0x3F983A9794563574uLL) >> 0),
     (VUINT32) ((0x3F983A9794563574uLL) >> 32)},
    {(VUINT32) ((0x3F67678272C8ECDDuLL) >> 0),
     (VUINT32) ((0x3F67678272C8ECDDuLL) >> 32)},
    {(VUINT32) ((0x3F63DAE696E3A33FuLL) >> 0),
     (VUINT32) ((0x3F63DAE696E3A33FuLL) >> 32)},
    {(VUINT32) ((0x3F3B1CDBB342F07AuLL) >> 0),
     (VUINT32) ((0x3F3B1CDBB342F07AuLL) >> 32)},
    {(VUINT32) ((0x3F49E00A3BCC8A23uLL) >> 0),
     (VUINT32) ((0x3F49E00A3BCC8A23uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD1475CC9EEDF01uLL) >> 0),
     (VUINT32) ((0xBFD1475CC9EEDF01uLL) >> 32)},
    {(VUINT32) ((0x3C73DDC5BCE200BBuLL) >> 0),
     (VUINT32) ((0x3C73DDC5BCE200BBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB726AD2173D50EuLL) >> 0),
     (VUINT32) ((0x3FB726AD2173D50EuLL) >> 32)},
    {(VUINT32) ((0x3C1FCEC90C8C4150uLL) >> 0),
     (VUINT32) ((0x3C1FCEC90C8C4150uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB69783D8B96CDFuLL) >> 0),
     (VUINT32) ((0x3FB69783D8B96CDFuLL) >> 32)},
    {(VUINT32) ((0x3F92DD1FBCCBA937uLL) >> 0),
     (VUINT32) ((0x3F92DD1FBCCBA937uLL) >> 32)},
    {(VUINT32) ((0x3F986051045C3883uLL) >> 0),
     (VUINT32) ((0x3F986051045C3883uLL) >> 32)},
    {(VUINT32) ((0x3F68A164B9409BD2uLL) >> 0),
     (VUINT32) ((0x3F68A164B9409BD2uLL) >> 32)},
    {(VUINT32) ((0x3F641CB77D330FDAuLL) >> 0),
     (VUINT32) ((0x3F641CB77D330FDAuLL) >> 32)},
    {(VUINT32) ((0x3F3C9FE910D9C9B2uLL) >> 0),
     (VUINT32) ((0x3F3C9FE910D9C9B2uLL) >> 32)},
    {(VUINT32) ((0xBF302CCA991EA2A4uLL) >> 0),
     (VUINT32) ((0xBF302CCA991EA2A4uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD2106CA4910069uLL) >> 0),
     (VUINT32) ((0xBFD2106CA4910069uLL) >> 32)},
    {(VUINT32) ((0xBC7CAF6B74B6A225uLL) >> 0),
     (VUINT32) ((0xBC7CAF6B74B6A225uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB836E5B77D959AuLL) >> 0),
     (VUINT32) ((0x3FB836E5B77D959AuLL) >> 32)},
    {(VUINT32) ((0x3C51BDCEFF692111uLL) >> 0),
     (VUINT32) ((0x3C51BDCEFF692111uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB6B5DA3B72B738uLL) >> 0),
     (VUINT32) ((0x3FB6B5DA3B72B738uLL) >> 32)},
    {(VUINT32) ((0x3F93C396B58BD74AuLL) >> 0),
     (VUINT32) ((0x3F93C396B58BD74AuLL) >> 32)},
    {(VUINT32) ((0x3F9887FAB9649830uLL) >> 0),
     (VUINT32) ((0x3F9887FAB9649830uLL) >> 32)},
    {(VUINT32) ((0x3F69DF6A8A7C820CuLL) >> 0),
     (VUINT32) ((0x3F69DF6A8A7C820CuLL) >> 32)},
    {(VUINT32) ((0x3F6461D201176179uLL) >> 0),
     (VUINT32) ((0x3F6461D201176179uLL) >> 32)},
    {(VUINT32) ((0x3F3E2C1220D981B3uLL) >> 0),
     (VUINT32) ((0x3F3E2C1220D981B3uLL) >> 32)},
    {(VUINT32) ((0x3F49F3B20F57CFA8uLL) >> 0),
     (VUINT32) ((0x3F49F3B20F57CFA8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0xBFD2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0xBC6A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0xBC6A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB9477FD636A4D8uLL) >> 0),
     (VUINT32) ((0x3FB9477FD636A4D8uLL) >> 32)},
    {(VUINT32) ((0xBC5063C8B22C4544uLL) >> 0),
     (VUINT32) ((0xBC5063C8B22C4544uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB6D59BCBF6C48BuLL) >> 0),
     (VUINT32) ((0x3FB6D59BCBF6C48BuLL) >> 32)},
    {(VUINT32) ((0x3F94AB8CBB6CBB16uLL) >> 0),
     (VUINT32) ((0x3F94AB8CBB6CBB16uLL) >> 32)},
    {(VUINT32) ((0x3F98B19B6070D56DuLL) >> 0),
     (VUINT32) ((0x3F98B19B6070D56DuLL) >> 32)},
    {(VUINT32) ((0x3F6B21CD22DB24B2uLL) >> 0),
     (VUINT32) ((0x3F6B21CD22DB24B2uLL) >> 32)},
    {(VUINT32) ((0x3F64AAE4575F07F6uLL) >> 0),
     (VUINT32) ((0x3F64AAE4575F07F6uLL) >> 32)},
    {(VUINT32) ((0x3F3FC08B3806F34CuLL) >> 0),
     (VUINT32) ((0x3F3FC08B3806F34CuLL) >> 32)},
    {(VUINT32) ((0xBF00E42769BBA67AuLL) >> 0),
     (VUINT32) ((0xBF00E42769BBA67AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD3A28C59D5433BuLL) >> 0),
     (VUINT32) ((0xBFD3A28C59D5433BuLL) >> 32)},
    {(VUINT32) ((0x3C41B19140C0C0D5uLL) >> 0),
     (VUINT32) ((0x3C41B19140C0C0D5uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBA587FF6553726uLL) >> 0),
     (VUINT32) ((0x3FBA587FF6553726uLL) >> 32)},
    {(VUINT32) ((0xBC5559CFE8367078uLL) >> 0),
     (VUINT32) ((0xBC5559CFE8367078uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB6F6CAF293AC7FuLL) >> 0),
     (VUINT32) ((0x3FB6F6CAF293AC7FuLL) >> 32)},
    {(VUINT32) ((0x3F959514736F007FuLL) >> 0),
     (VUINT32) ((0x3F959514736F007FuLL) >> 32)},
    {(VUINT32) ((0x3F98DD3A019E14EBuLL) >> 0),
     (VUINT32) ((0x3F98DD3A019E14EBuLL) >> 32)},
    {(VUINT32) ((0x3F6C68C706B3D0FBuLL) >> 0),
     (VUINT32) ((0x3F6C68C706B3D0FBuLL) >> 32)},
    {(VUINT32) ((0x3F64F779DB6C50B2uLL) >> 0),
     (VUINT32) ((0x3F64F779DB6C50B2uLL) >> 32)},
    {(VUINT32) ((0x3F40AF7CD7497CB8uLL) >> 0),
     (VUINT32) ((0x3F40AF7CD7497CB8uLL) >> 32)},
    {(VUINT32) ((0x3F4AD3B9828EFAF2uLL) >> 0),
     (VUINT32) ((0x3F4AD3B9828EFAF2uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD46B9C347764A4uLL) >> 0),
     (VUINT32) ((0xBFD46B9C347764A4uLL) >> 32)},
    {(VUINT32) ((0x3C71A900F67F753AuLL) >> 0),
     (VUINT32) ((0x3C71A900F67F753AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBB69EA984DE6EFuLL) >> 0),
     (VUINT32) ((0x3FBB69EA984DE6EFuLL) >> 32)},
    {(VUINT32) ((0xBC573CB7437F11CAuLL) >> 0),
     (VUINT32) ((0xBC573CB7437F11CAuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB7196A3515E12EuLL) >> 0),
     (VUINT32) ((0x3FB7196A3515E12EuLL) >> 32)},
    {(VUINT32) ((0x3F968040C68C8FE8uLL) >> 0),
     (VUINT32) ((0x3F968040C68C8FE8uLL) >> 32)},
    {(VUINT32) ((0x3F990ADE01D185E6uLL) >> 0),
     (VUINT32) ((0x3F990ADE01D185E6uLL) >> 32)},
    {(VUINT32) ((0x3F6DB49417B3E65CuLL) >> 0),
     (VUINT32) ((0x3F6DB49417B3E65CuLL) >> 32)},
    {(VUINT32) ((0x3F6548393E856C2FuLL) >> 0),
     (VUINT32) ((0x3F6548393E856C2FuLL) >> 32)},
    {(VUINT32) ((0x3F418353F7828212uLL) >> 0),
     (VUINT32) ((0x3F418353F7828212uLL) >> 32)},
    {(VUINT32) ((0xBF36489E043C6801uLL) >> 0),
     (VUINT32) ((0xBF36489E043C6801uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD534AC0F19860CuLL) >> 0),
     (VUINT32) ((0xBFD534AC0F19860CuLL) >> 32)},
    {(VUINT32) ((0xBC7EE4303B192DA6uLL) >> 0),
     (VUINT32) ((0xBC7EE4303B192DA6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBC7BC444B10758uLL) >> 0),
     (VUINT32) ((0x3FBC7BC444B10758uLL) >> 32)},
    {(VUINT32) ((0xBC511540B2269343uLL) >> 0),
     (VUINT32) ((0xBC511540B2269343uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB73D7C3735AA80uLL) >> 0),
     (VUINT32) ((0x3FB73D7C3735AA80uLL) >> 32)},
    {(VUINT32) ((0x3F976D24E52F1F79uLL) >> 0),
     (VUINT32) ((0x3F976D24E52F1F79uLL) >> 32)},
    {(VUINT32) ((0x3F993A8F25560FF4uLL) >> 0),
     (VUINT32) ((0x3F993A8F25560FF4uLL) >> 32)},
    {(VUINT32) ((0x3F6F0571A586F6F3uLL) >> 0),
     (VUINT32) ((0x3F6F0571A586F6F3uLL) >> 32)},
    {(VUINT32) ((0x3F659C8E8181F3A3uLL) >> 0),
     (VUINT32) ((0x3F659C8E8181F3A3uLL) >> 32)},
    {(VUINT32) ((0x3F425CCABE1034F4uLL) >> 0),
     (VUINT32) ((0x3F425CCABE1034F4uLL) >> 32)},
    {(VUINT32) ((0x3F4D59CA0F6FD35DuLL) >> 0),
     (VUINT32) ((0x3F4D59CA0F6FD35DuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD5FDBBE9BBA775uLL) >> 0),
     (VUINT32) ((0xBFD5FDBBE9BBA775uLL) >> 32)},
    {(VUINT32) ((0xBC6EE2C2D963A10CuLL) >> 0),
     (VUINT32) ((0xBC6EE2C2D963A10CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBD8E118C89577FuLL) >> 0),
     (VUINT32) ((0x3FBD8E118C89577FuLL) >> 32)},
    {(VUINT32) ((0x3C3344F06C36B16CuLL) >> 0),
     (VUINT32) ((0x3C3344F06C36B16CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB76303BB0A22C5uLL) >> 0),
     (VUINT32) ((0x3FB76303BB0A22C5uLL) >> 32)},
    {(VUINT32) ((0x3F985BD44ABC0416uLL) >> 0),
     (VUINT32) ((0x3F985BD44ABC0416uLL) >> 32)},
    {(VUINT32) ((0x3F996C5591BA6DFAuLL) >> 0),
     (VUINT32) ((0x3F996C5591BA6DFAuLL) >> 32)},
    {(VUINT32) ((0x3F702DCF4265B5B3uLL) >> 0),
     (VUINT32) ((0x3F702DCF4265B5B3uLL) >> 32)},
    {(VUINT32) ((0x3F65F52766DBD111uLL) >> 0),
     (VUINT32) ((0x3F65F52766DBD111uLL) >> 32)},
    {(VUINT32) ((0x3F433B879649EF12uLL) >> 0),
     (VUINT32) ((0x3F433B879649EF12uLL) >> 32)},
    {(VUINT32) ((0x3F47C67A938B39B9uLL) >> 0),
     (VUINT32) ((0x3F47C67A938B39B9uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD6C6CBC45DC8DEuLL) >> 0),
     (VUINT32) ((0xBFD6C6CBC45DC8DEuLL) >> 32)},
    {(VUINT32) ((0x3BB6D61B58C99C43uLL) >> 0),
     (VUINT32) ((0x3BB6D61B58C99C43uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBEA0D709BC27CAuLL) >> 0),
     (VUINT32) ((0x3FBEA0D709BC27CAuLL) >> 32)},
    {(VUINT32) ((0x3C48928D103E8AACuLL) >> 0),
     (VUINT32) ((0x3C48928D103E8AACuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB78A03A181D6ACuLL) >> 0),
     (VUINT32) ((0x3FB78A03A181D6ACuLL) >> 32)},
    {(VUINT32) ((0x3F994C62C1366C88uLL) >> 0),
     (VUINT32) ((0x3F994C62C1366C88uLL) >> 32)},
    {(VUINT32) ((0x3F99A039D09A41ADuLL) >> 0),
     (VUINT32) ((0x3F99A039D09A41ADuLL) >> 32)},
    {(VUINT32) ((0x3F70DBAD90C6529AuLL) >> 0),
     (VUINT32) ((0x3F70DBAD90C6529AuLL) >> 32)},
    {(VUINT32) ((0x3F66520A2F7F46B3uLL) >> 0),
     (VUINT32) ((0x3F66520A2F7F46B3uLL) >> 32)},
    {(VUINT32) ((0x3F441FF58F223B31uLL) >> 0),
     (VUINT32) ((0x3F441FF58F223B31uLL) >> 32)},
    {(VUINT32) ((0xBF357CCF19FA9D15uLL) >> 0),
     (VUINT32) ((0xBF357CCF19FA9D15uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD78FDB9EFFEA47uLL) >> 0),
     (VUINT32) ((0xBFD78FDB9EFFEA47uLL) >> 32)},
    {(VUINT32) ((0x3C6EE8786039D373uLL) >> 0),
     (VUINT32) ((0x3C6EE8786039D373uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBFB4195F6B0333uLL) >> 0),
     (VUINT32) ((0x3FBFB4195F6B0333uLL) >> 32)},
    {(VUINT32) ((0x3C47DB89E2705528uLL) >> 0),
     (VUINT32) ((0x3C47DB89E2705528uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB7B27EEAE12CDBuLL) >> 0),
     (VUINT32) ((0x3FB7B27EEAE12CDBuLL) >> 32)},
    {(VUINT32) ((0x3F9A3EE464F938D9uLL) >> 0),
     (VUINT32) ((0x3F9A3EE464F938D9uLL) >> 32)},
    {(VUINT32) ((0x3F99D644D21E7AE8uLL) >> 0),
     (VUINT32) ((0x3F99D644D21E7AE8uLL) >> 32)},
    {(VUINT32) ((0x3F718C74CAAA7BA1uLL) >> 0),
     (VUINT32) ((0x3F718C74CAAA7BA1uLL) >> 32)},
    {(VUINT32) ((0x3F66B2F778B94D1CuLL) >> 0),
     (VUINT32) ((0x3F66B2F778B94D1CuLL) >> 32)},
    {(VUINT32) ((0x3F450AB96EF7371CuLL) >> 0),
     (VUINT32) ((0x3F450AB96EF7371CuLL) >> 32)},
    {(VUINT32) ((0x3F1412EF7B7239D9uLL) >> 0),
     (VUINT32) ((0x3F1412EF7B7239D9uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD858EB79A20BB0uLL) >> 0),
     (VUINT32) ((0xBFD858EB79A20BB0uLL) >> 32)},
    {(VUINT32) ((0x3C7EE70AFE8446D9uLL) >> 0),
     (VUINT32) ((0x3C7EE70AFE8446D9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC063EE9D2B777CuLL) >> 0),
     (VUINT32) ((0x3FC063EE9D2B777CuLL) >> 32)},
    {(VUINT32) ((0x3C4E1787D8B79264uLL) >> 0),
     (VUINT32) ((0x3C4E1787D8B79264uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB7DC78B746BB2FuLL) >> 0),
     (VUINT32) ((0x3FB7DC78B746BB2FuLL) >> 32)},
    {(VUINT32) ((0x3F9B336DA889AC7DuLL) >> 0),
     (VUINT32) ((0x3F9B336DA889AC7DuLL) >> 32)},
    {(VUINT32) ((0x3F9A0E7FEF8737D6uLL) >> 0),
     (VUINT32) ((0x3F9A0E7FEF8737D6uLL) >> 32)},
    {(VUINT32) ((0x3F724046DF328844uLL) >> 0),
     (VUINT32) ((0x3F724046DF328844uLL) >> 32)},
    {(VUINT32) ((0x3F67185639AB9983uLL) >> 0),
     (VUINT32) ((0x3F67185639AB9983uLL) >> 32)},
    {(VUINT32) ((0x3F45FBD25ACB3A74uLL) >> 0),
     (VUINT32) ((0x3F45FBD25ACB3A74uLL) >> 32)},
    {(VUINT32) ((0x3F0E765A126439F7uLL) >> 0),
     (VUINT32) ((0x3F0E765A126439F7uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD921FB54442D18uLL) >> 0),
     (VUINT32) ((0xBFD921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0xBC71A62633145C07uLL) >> 0),
     (VUINT32) ((0xBC71A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC0EE13A8A2A9C6uLL) >> 0),
     (VUINT32) ((0x3FC0EE13A8A2A9C6uLL) >> 32)},
    {(VUINT32) ((0xBC5830A63DDC366CuLL) >> 0),
     (VUINT32) ((0xBC5830A63DDC366CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB807F44735B1A4uLL) >> 0),
     (VUINT32) ((0x3FB807F44735B1A4uLL) >> 32)},
    {(VUINT32) ((0x3F9C2A135884458AuLL) >> 0),
     (VUINT32) ((0x3F9C2A135884458AuLL) >> 32)},
    {(VUINT32) ((0x3F9A48F4EE376E9DuLL) >> 0),
     (VUINT32) ((0x3F9A48F4EE376E9DuLL) >> 32)},
    {(VUINT32) ((0x3F72F746AAC73A47uLL) >> 0),
     (VUINT32) ((0x3F72F746AAC73A47uLL) >> 32)},
    {(VUINT32) ((0x3F678215824701AFuLL) >> 0),
     (VUINT32) ((0x3F678215824701AFuLL) >> 32)},
    {(VUINT32) ((0x3F46F3C719FB66E6uLL) >> 0),
     (VUINT32) ((0x3F46F3C719FB66E6uLL) >> 32)},
    {(VUINT32) ((0x3F4BA88D5ED09DD1uLL) >> 0),
     (VUINT32) ((0x3F4BA88D5ED09DD1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFD9EB0B2EE64E81uLL) >> 0),
     (VUINT32) ((0xBFD9EB0B2EE64E81uLL) >> 32)},
    {(VUINT32) ((0xBC419ABB2567F739uLL) >> 0),
     (VUINT32) ((0xBC419ABB2567F739uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC1787E32B35112uLL) >> 0),
     (VUINT32) ((0x3FC1787E32B35112uLL) >> 32)},
    {(VUINT32) ((0xBC5D2D85EBE7CAE6uLL) >> 0),
     (VUINT32) ((0xBC5D2D85EBE7CAE6uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB834F4FC268515uLL) >> 0),
     (VUINT32) ((0x3FB834F4FC268515uLL) >> 32)},
    {(VUINT32) ((0x3F9D22EA9FA50E7DuLL) >> 0),
     (VUINT32) ((0x3F9D22EA9FA50E7DuLL) >> 32)},
    {(VUINT32) ((0x3F9A85AE02819BA3uLL) >> 0),
     (VUINT32) ((0x3F9A85AE02819BA3uLL) >> 32)},
    {(VUINT32) ((0x3F73B19803AB2B21uLL) >> 0),
     (VUINT32) ((0x3F73B19803AB2B21uLL) >> 32)},
    {(VUINT32) ((0x3F67F0B8C640461DuLL) >> 0),
     (VUINT32) ((0x3F67F0B8C640461DuLL) >> 32)},
    {(VUINT32) ((0x3F47F293167B409BuLL) >> 0),
     (VUINT32) ((0x3F47F293167B409BuLL) >> 32)},
    {(VUINT32) ((0xBF198BF45EA16C3AuLL) >> 0),
     (VUINT32) ((0xBF198BF45EA16C3AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFDAB41B09886FEAuLL) >> 0),
     (VUINT32) ((0xBFDAB41B09886FEAuLL) >> 32)},
    {(VUINT32) ((0x3C6A7EEED374BC71uLL) >> 0),
     (VUINT32) ((0x3C6A7EEED374BC71uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC20330A15F6568uLL) >> 0),
     (VUINT32) ((0x3FC20330A15F6568uLL) >> 32)},
    {(VUINT32) ((0x3C61BB4F210EA8D1uLL) >> 0),
     (VUINT32) ((0x3C61BB4F210EA8D1uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB8637E591E05FEuLL) >> 0),
     (VUINT32) ((0x3FB8637E591E05FEuLL) >> 32)},
    {(VUINT32) ((0x3F9E1E090AECCE81uLL) >> 0),
     (VUINT32) ((0x3F9E1E090AECCE81uLL) >> 32)},
    {(VUINT32) ((0x3F9AC4B5D3090946uLL) >> 0),
     (VUINT32) ((0x3F9AC4B5D3090946uLL) >> 32)},
    {(VUINT32) ((0x3F746F5FC5C316BAuLL) >> 0),
     (VUINT32) ((0x3F746F5FC5C316BAuLL) >> 32)},
    {(VUINT32) ((0x3F686400E51F53C2uLL) >> 0),
     (VUINT32) ((0x3F686400E51F53C2uLL) >> 32)},
    {(VUINT32) ((0x3F48F8EADC3DB9C7uLL) >> 0),
     (VUINT32) ((0x3F48F8EADC3DB9C7uLL) >> 32)},
    {(VUINT32) ((0xBF320AB3DF7578B7uLL) >> 0),
     (VUINT32) ((0xBF320AB3DF7578B7uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFDB7D2AE42A9153uLL) >> 0),
     (VUINT32) ((0xBFDB7D2AE42A9153uLL) >> 32)},
    {(VUINT32) ((0x3C7CB2463821BB58uLL) >> 0),
     (VUINT32) ((0x3C7CB2463821BB58uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC28E2D6047CBC8uLL) >> 0),
     (VUINT32) ((0x3FC28E2D6047CBC8uLL) >> 32)},
    {(VUINT32) ((0xBC0CEAB2537F4380uLL) >> 0),
     (VUINT32) ((0xBC0CEAB2537F4380uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB89394034B11CFuLL) >> 0),
     (VUINT32) ((0x3FB89394034B11CFuLL) >> 32)},
    {(VUINT32) ((0x3F9F1B848DE48876uLL) >> 0),
     (VUINT32) ((0x3F9F1B848DE48876uLL) >> 32)},
    {(VUINT32) ((0x3F9B06177BDD3821uLL) >> 0),
     (VUINT32) ((0x3F9B06177BDD3821uLL) >> 32)},
    {(VUINT32) ((0x3F7530C3E0150AA0uLL) >> 0),
     (VUINT32) ((0x3F7530C3E0150AA0uLL) >> 32)},
    {(VUINT32) ((0x3F68DBF62FBA70A3uLL) >> 0),
     (VUINT32) ((0x3F68DBF62FBA70A3uLL) >> 32)},
    {(VUINT32) ((0x3F4A0736C860B4FEuLL) >> 0),
     (VUINT32) ((0x3F4A0736C860B4FEuLL) >> 32)},
    {(VUINT32) ((0x3F50A3F1D969C867uLL) >> 0),
     (VUINT32) ((0x3F50A3F1D969C867uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFDC463ABECCB2BBuLL) >> 0),
     (VUINT32) ((0xBFDC463ABECCB2BBuLL) >> 32)},
    {(VUINT32) ((0xBC73DAEAF976E788uLL) >> 0),
     (VUINT32) ((0xBC73DAEAF976E788uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC31976E0E280B3uLL) >> 0),
     (VUINT32) ((0x3FC31976E0E280B3uLL) >> 32)},
    {(VUINT32) ((0xBC667516EE4F2544uLL) >> 0),
     (VUINT32) ((0xBC667516EE4F2544uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB8C539C2AB0F89uLL) >> 0),
     (VUINT32) ((0x3FB8C539C2AB0F89uLL) >> 32)},
    {(VUINT32) ((0x3FA00DB9C3806462uLL) >> 0),
     (VUINT32) ((0x3FA00DB9C3806462uLL) >> 32)},
    {(VUINT32) ((0x3F9B49DE91DB8E44uLL) >> 0),
     (VUINT32) ((0x3F9B49DE91DB8E44uLL) >> 32)},
    {(VUINT32) ((0x3F75F5EB6258C838uLL) >> 0),
     (VUINT32) ((0x3F75F5EB6258C838uLL) >> 32)},
    {(VUINT32) ((0x3F695952C6BEE632uLL) >> 0),
     (VUINT32) ((0x3F695952C6BEE632uLL) >> 32)},
    {(VUINT32) ((0x3F4B1D691B1E9E68uLL) >> 0),
     (VUINT32) ((0x3F4B1D691B1E9E68uLL) >> 32)},
    {(VUINT32) ((0xBEFC71567DD0AC40uLL) >> 0),
     (VUINT32) ((0xBEFC71567DD0AC40uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFDD0F4A996ED424uLL) >> 0),
     (VUINT32) ((0xBFDD0F4A996ED424uLL) >> 32)},
    {(VUINT32) ((0xBC51A070AC3E29A0uLL) >> 0),
     (VUINT32) ((0xBC51A070AC3E29A0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC3A50F9AB1CA91uLL) >> 0),
     (VUINT32) ((0x3FC3A50F9AB1CA91uLL) >> 32)},
    {(VUINT32) ((0x3C50CA3B48D90906uLL) >> 0),
     (VUINT32) ((0x3C50CA3B48D90906uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB8F87382B56ACBuLL) >> 0),
     (VUINT32) ((0x3FB8F87382B56ACBuLL) >> 32)},
    {(VUINT32) ((0x3FA08EF662132882uLL) >> 0),
     (VUINT32) ((0x3FA08EF662132882uLL) >> 32)},
    {(VUINT32) ((0x3F9B901726A3CD1CuLL) >> 0),
     (VUINT32) ((0x3F9B901726A3CD1CuLL) >> 32)},
    {(VUINT32) ((0x3F76BEFE8A4461A2uLL) >> 0),
     (VUINT32) ((0x3F76BEFE8A4461A2uLL) >> 32)},
    {(VUINT32) ((0x3F69DBAE42D8A424uLL) >> 0),
     (VUINT32) ((0x3F69DBAE42D8A424uLL) >> 32)},
    {(VUINT32) ((0x3F4C3C52357BEFDCuLL) >> 0),
     (VUINT32) ((0x3F4C3C52357BEFDCuLL) >> 32)},
    {(VUINT32) ((0x3F32456D9E4ECEE8uLL) >> 0),
     (VUINT32) ((0x3F32456D9E4ECEE8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFDDD85A7410F58DuLL) >> 0),
     (VUINT32) ((0xBFDDD85A7410F58DuLL) >> 32)},
    {(VUINT32) ((0x3C66156546AFA570uLL) >> 0),
     (VUINT32) ((0x3C66156546AFA570uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC430FA0B7C7F15uLL) >> 0),
     (VUINT32) ((0x3FC430FA0B7C7F15uLL) >> 32)},
    {(VUINT32) ((0x3C63115D3C69C8ABuLL) >> 0),
     (VUINT32) ((0x3C63115D3C69C8ABuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB92D45530E4319uLL) >> 0),
     (VUINT32) ((0x3FB92D45530E4319uLL) >> 32)},
    {(VUINT32) ((0x3FA11183C3A8DFF6uLL) >> 0),
     (VUINT32) ((0x3FA11183C3A8DFF6uLL) >> 32)},
    {(VUINT32) ((0x3F9BD8CDCC073185uLL) >> 0),
     (VUINT32) ((0x3F9BD8CDCC073185uLL) >> 32)},
    {(VUINT32) ((0x3F778C26D2F52E9AuLL) >> 0),
     (VUINT32) ((0x3F778C26D2F52E9AuLL) >> 32)},
    {(VUINT32) ((0x3F6A638650FB67B4uLL) >> 0),
     (VUINT32) ((0x3F6A638650FB67B4uLL) >> 32)},
    {(VUINT32) ((0x3F4D6420527BDA5CuLL) >> 0),
     (VUINT32) ((0x3F4D6420527BDA5CuLL) >> 32)},
    {(VUINT32) ((0xBF2DA5A647B98994uLL) >> 0),
     (VUINT32) ((0xBF2DA5A647B98994uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFDEA16A4EB316F6uLL) >> 0),
     (VUINT32) ((0xBFDEA16A4EB316F6uLL) >> 32)},
    {(VUINT32) ((0x3C7A7D8171BF2FD8uLL) >> 0),
     (VUINT32) ((0x3C7A7D8171BF2FD8uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC4BD38B7876716uLL) >> 0),
     (VUINT32) ((0x3FC4BD38B7876716uLL) >> 32)},
    {(VUINT32) ((0x3C5504069A91A838uLL) >> 0),
     (VUINT32) ((0x3C5504069A91A838uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB963B368408780uLL) >> 0),
     (VUINT32) ((0x3FB963B368408780uLL) >> 32)},
    {(VUINT32) ((0x3FA1956DC5B1F35AuLL) >> 0),
     (VUINT32) ((0x3FA1956DC5B1F35AuLL) >> 32)},
    {(VUINT32) ((0x3F9C240F984C07DCuLL) >> 0),
     (VUINT32) ((0x3F9C240F984C07DCuLL) >> 32)},
    {(VUINT32) ((0x3F785D8F0388F11CuLL) >> 0),
     (VUINT32) ((0x3F785D8F0388F11CuLL) >> 32)},
    {(VUINT32) ((0x3F6AF0B073DF1CB2uLL) >> 0),
     (VUINT32) ((0x3F6AF0B073DF1CB2uLL) >> 32)},
    {(VUINT32) ((0x3F4E9580D70D3533uLL) >> 0),
     (VUINT32) ((0x3F4E9580D70D3533uLL) >> 32)},
    {(VUINT32) ((0x3F4571315C6E8041uLL) >> 0),
     (VUINT32) ((0x3F4571315C6E8041uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFDF6A7A2955385EuLL) >> 0),
     (VUINT32) ((0xBFDF6A7A2955385EuLL) >> 32)},
    {(VUINT32) ((0xBC760FAFBFD97309uLL) >> 0),
     (VUINT32) ((0xBC760FAFBFD97309uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC549CE29CFCCBEuLL) >> 0),
     (VUINT32) ((0x3FC549CE29CFCCBEuLL) >> 32)},
    {(VUINT32) ((0xBC69881846E0BF86uLL) >> 0),
     (VUINT32) ((0xBC69881846E0BF86uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB99BC21C7FB9B2uLL) >> 0),
     (VUINT32) ((0x3FB99BC21C7FB9B2uLL) >> 32)},
    {(VUINT32) ((0x3FA21AC0848A46C5uLL) >> 0),
     (VUINT32) ((0x3FA21AC0848A46C5uLL) >> 32)},
    {(VUINT32) ((0x3F9C71EA2A16819DuLL) >> 0),
     (VUINT32) ((0x3F9C71EA2A16819DuLL) >> 32)},
    {(VUINT32) ((0x3F7933633F8F0072uLL) >> 0),
     (VUINT32) ((0x3F7933633F8F0072uLL) >> 32)},
    {(VUINT32) ((0x3F6B83D1C5509A03uLL) >> 0),
     (VUINT32) ((0x3F6B83D1C5509A03uLL) >> 32)},
    {(VUINT32) ((0x3F4FD088727B14B9uLL) >> 0),
     (VUINT32) ((0x3F4FD088727B14B9uLL) >> 32)},
    {(VUINT32) ((0xBF2306C949D5376CuLL) >> 0),
     (VUINT32) ((0xBF2306C949D5376CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE019C501FBACE4uLL) >> 0),
     (VUINT32) ((0xBFE019C501FBACE4uLL) >> 32)},
    {(VUINT32) ((0x3C8CB18F8746F50CuLL) >> 0),
     (VUINT32) ((0x3C8CB18F8746F50CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC5D6BCF447403EuLL) >> 0),
     (VUINT32) ((0x3FC5D6BCF447403EuLL) >> 32)},
    {(VUINT32) ((0xBC6C6C662876B393uLL) >> 0),
     (VUINT32) ((0xBC6C6C662876B393uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB9D575F071964AuLL) >> 0),
     (VUINT32) ((0x3FB9D575F071964AuLL) >> 32)},
    {(VUINT32) ((0x3FA2A1885E06BEACuLL) >> 0),
     (VUINT32) ((0x3FA2A1885E06BEACuLL) >> 32)},
    {(VUINT32) ((0x3F9CC26BAD1B38B8uLL) >> 0),
     (VUINT32) ((0x3F9CC26BAD1B38B8uLL) >> 32)},
    {(VUINT32) ((0x3F7A0DD116DA5229uLL) >> 0),
     (VUINT32) ((0x3F7A0DD116DA5229uLL) >> 32)},
    {(VUINT32) ((0x3F6C1C921E809C74uLL) >> 0),
     (VUINT32) ((0x3F6C1C921E809C74uLL) >> 32)},
    {(VUINT32) ((0x3F508B03CEF8B0C3uLL) >> 0),
     (VUINT32) ((0x3F508B03CEF8B0C3uLL) >> 32)},
    {(VUINT32) ((0x3F4BCE57D088C848uLL) >> 0),
     (VUINT32) ((0x3F4BCE57D088C848uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE07E4CEF4CBD98uLL) >> 0),
     (VUINT32) ((0xBFE07E4CEF4CBD98uLL) >> 32)},
    {(VUINT32) ((0x3C61ABDBB9EA8E6EuLL) >> 0),
     (VUINT32) ((0x3C61ABDBB9EA8E6EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC66407B0109FA6uLL) >> 0),
     (VUINT32) ((0x3FC66407B0109FA6uLL) >> 32)},
    {(VUINT32) ((0x3C55C3EC26D04666uLL) >> 0),
     (VUINT32) ((0x3C55C3EC26D04666uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBA10D38BFFE319uLL) >> 0),
     (VUINT32) ((0x3FBA10D38BFFE319uLL) >> 32)},
    {(VUINT32) ((0x3FA329D1F417DBD6uLL) >> 0),
     (VUINT32) ((0x3FA329D1F417DBD6uLL) >> 32)},
    {(VUINT32) ((0x3F9D15A2DE544C7CuLL) >> 0),
     (VUINT32) ((0x3F9D15A2DE544C7CuLL) >> 32)},
    {(VUINT32) ((0x3F7AED07977D3236uLL) >> 0),
     (VUINT32) ((0x3F7AED07977D3236uLL) >> 32)},
    {(VUINT32) ((0x3F6CBBAD3C53FDE7uLL) >> 0),
     (VUINT32) ((0x3F6CBBAD3C53FDE7uLL) >> 32)},
    {(VUINT32) ((0x3F513318B342B49DuLL) >> 0),
     (VUINT32) ((0x3F513318B342B49DuLL) >> 32)},
    {(VUINT32) ((0x3F1AF93D0FFB8A50uLL) >> 0),
     (VUINT32) ((0x3F1AF93D0FFB8A50uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE0E2D4DC9DCE4CuLL) >> 0),
     (VUINT32) ((0xBFE0E2D4DC9DCE4CuLL) >> 32)},
    {(VUINT32) ((0xBC83DBA1AA51ADD5uLL) >> 0),
     (VUINT32) ((0xBC83DBA1AA51ADD5uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC6F1B0FDBE6EDEuLL) >> 0),
     (VUINT32) ((0x3FC6F1B0FDBE6EDEuLL) >> 32)},
    {(VUINT32) ((0x3C614F63025E35DCuLL) >> 0),
     (VUINT32) ((0x3C614F63025E35DCuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBA4DDFBF32A727uLL) >> 0),
     (VUINT32) ((0x3FBA4DDFBF32A727uLL) >> 32)},
    {(VUINT32) ((0x3FA3B3AA2F826E47uLL) >> 0),
     (VUINT32) ((0x3FA3B3AA2F826E47uLL) >> 32)},
    {(VUINT32) ((0x3F9D6B9F112A3CA9uLL) >> 0),
     (VUINT32) ((0x3F9D6B9F112A3CA9uLL) >> 32)},
    {(VUINT32) ((0x3F7BD1375F2B326EuLL) >> 0),
     (VUINT32) ((0x3F7BD1375F2B326EuLL) >> 32)},
    {(VUINT32) ((0x3F6D60EF002A5959uLL) >> 0),
     (VUINT32) ((0x3F6D60EF002A5959uLL) >> 32)},
    {(VUINT32) ((0x3F51E0E0E3E641DEuLL) >> 0),
     (VUINT32) ((0x3F51E0E0E3E641DEuLL) >> 32)},
    {(VUINT32) ((0x3F32BFA3B8923D31uLL) >> 0),
     (VUINT32) ((0x3F32BFA3B8923D31uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE1475CC9EEDF01uLL) >> 0),
     (VUINT32) ((0xBFE1475CC9EEDF01uLL) >> 32)},
    {(VUINT32) ((0x3C83DDC5BCE200BBuLL) >> 0),
     (VUINT32) ((0x3C83DDC5BCE200BBuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC77FBB85928D2DuLL) >> 0),
     (VUINT32) ((0x3FC77FBB85928D2DuLL) >> 32)},
    {(VUINT32) ((0xBC6121F4E1AC8166uLL) >> 0),
     (VUINT32) ((0xBC6121F4E1AC8166uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBA8C9F83131391uLL) >> 0),
     (VUINT32) ((0x3FBA8C9F83131391uLL) >> 32)},
    {(VUINT32) ((0x3FA43F1E42AF6970uLL) >> 0),
     (VUINT32) ((0x3FA43F1E42AF6970uLL) >> 32)},
    {(VUINT32) ((0x3F9DC4703433CA75uLL) >> 0),
     (VUINT32) ((0x3F9DC4703433CA75uLL) >> 32)},
    {(VUINT32) ((0x3F7CBA92AE7FE396uLL) >> 0),
     (VUINT32) ((0x3F7CBA92AE7FE396uLL) >> 32)},
    {(VUINT32) ((0x3F6E0CB6D0475CCFuLL) >> 0),
     (VUINT32) ((0x3F6E0CB6D0475CCFuLL) >> 32)},
    {(VUINT32) ((0x3F529491FB8790D2uLL) >> 0),
     (VUINT32) ((0x3F529491FB8790D2uLL) >> 32)},
    {(VUINT32) ((0x3F37152AFD195A10uLL) >> 0),
     (VUINT32) ((0x3F37152AFD195A10uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE1ABE4B73FEFB5uLL) >> 0),
     (VUINT32) ((0xBFE1ABE4B73FEFB5uLL) >> 32)},
    {(VUINT32) ((0xBC61A34B6FA942D3uLL) >> 0),
     (VUINT32) ((0xBC61A34B6FA942D3uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC80E29F7BF5633uLL) >> 0),
     (VUINT32) ((0x3FC80E29F7BF5633uLL) >> 32)},
    {(VUINT32) ((0x3C67F8F06ACC7061uLL) >> 0),
     (VUINT32) ((0x3C67F8F06ACC7061uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBACD17FA976786uLL) >> 0),
     (VUINT32) ((0x3FBACD17FA976786uLL) >> 32)},
    {(VUINT32) ((0x3FA4CC3BAC93F075uLL) >> 0),
     (VUINT32) ((0x3FA4CC3BAC93F075uLL) >> 32)},
    {(VUINT32) ((0x3F9E2026D6967836uLL) >> 0),
     (VUINT32) ((0x3F9E2026D6967836uLL) >> 32)},
    {(VUINT32) ((0x3F7DA94D7C694B78uLL) >> 0),
     (VUINT32) ((0x3F7DA94D7C694B78uLL) >> 32)},
    {(VUINT32) ((0x3F6EBF4F14B98A92uLL) >> 0),
     (VUINT32) ((0x3F6EBF4F14B98A92uLL) >> 32)},
    {(VUINT32) ((0x3F534E7211F873CEuLL) >> 0),
     (VUINT32) ((0x3F534E7211F873CEuLL) >> 32)},
    {(VUINT32) ((0xBF2290D13622948AuLL) >> 0),
     (VUINT32) ((0xBF2290D13622948AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE2106CA4910069uLL) >> 0),
     (VUINT32) ((0xBFE2106CA4910069uLL) >> 32)},
    {(VUINT32) ((0xBC8CAF6B74B6A225uLL) >> 0),
     (VUINT32) ((0xBC8CAF6B74B6A225uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC89CFF0CAA3CB4uLL) >> 0),
     (VUINT32) ((0x3FC89CFF0CAA3CB4uLL) >> 32)},
    {(VUINT32) ((0xBC6A8D50D06FC283uLL) >> 0),
     (VUINT32) ((0xBC6A8D50D06FC283uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBB0F4E73981D4BuLL) >> 0),
     (VUINT32) ((0x3FBB0F4E73981D4BuLL) >> 32)},
    {(VUINT32) ((0x3FA55B103BB2BD6DuLL) >> 0),
     (VUINT32) ((0x3FA55B103BB2BD6DuLL) >> 32)},
    {(VUINT32) ((0x3F9E7ED42D91EC8DuLL) >> 0),
     (VUINT32) ((0x3F9E7ED42D91EC8DuLL) >> 32)},
    {(VUINT32) ((0x3F7E9D9D8AAE7B14uLL) >> 0),
     (VUINT32) ((0x3F7E9D9D8AAE7B14uLL) >> 32)},
    {(VUINT32) ((0x3F6F78B5039EFAD8uLL) >> 0),
     (VUINT32) ((0x3F6F78B5039EFAD8uLL) >> 32)},
    {(VUINT32) ((0x3F540EDBA3A78643uLL) >> 0),
     (VUINT32) ((0x3F540EDBA3A78643uLL) >> 32)},
    {(VUINT32) ((0x3F3AA2CB5E5BE1EDuLL) >> 0),
     (VUINT32) ((0x3F3AA2CB5E5BE1EDuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE274F491E2111EuLL) >> 0),
     (VUINT32) ((0xBFE274F491E2111EuLL) >> 32)},
    {(VUINT32) ((0x3C7613F7E4FA18D6uLL) >> 0),
     (VUINT32) ((0x3C7613F7E4FA18D6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC92C3D852FEDF2uLL) >> 0),
     (VUINT32) ((0x3FC92C3D852FEDF2uLL) >> 32)},
    {(VUINT32) ((0x3C20F5E7403E5E20uLL) >> 0),
     (VUINT32) ((0x3C20F5E7403E5E20uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBB534867CEB1CBuLL) >> 0),
     (VUINT32) ((0x3FBB534867CEB1CBuLL) >> 32)},
    {(VUINT32) ((0x3FA5EBAA113813D4uLL) >> 0),
     (VUINT32) ((0x3FA5EBAA113813D4uLL) >> 32)},
    {(VUINT32) ((0x3F9EE08A1A202CC5uLL) >> 0),
     (VUINT32) ((0x3F9EE08A1A202CC5uLL) >> 32)},
    {(VUINT32) ((0x3F7F97BA7BA1301AuLL) >> 0),
     (VUINT32) ((0x3F7F97BA7BA1301AuLL) >> 32)},
    {(VUINT32) ((0x3F701CAD7F191DFAuLL) >> 0),
     (VUINT32) ((0x3F701CAD7F191DFAuLL) >> 32)},
    {(VUINT32) ((0x3F54D60D13221310uLL) >> 0),
     (VUINT32) ((0x3F54D60D13221310uLL) >> 32)},
    {(VUINT32) ((0x3F45F5FE99894FC6uLL) >> 0),
     (VUINT32) ((0x3F45F5FE99894FC6uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0xBFE2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0xBC7A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0xBC7A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC9BBE82AEA0D12uLL) >> 0),
     (VUINT32) ((0x3FC9BBE82AEA0D12uLL) >> 32)},
    {(VUINT32) ((0xBC62D116CA77096BuLL) >> 0),
     (VUINT32) ((0xBC62D116CA77096BuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBB990B7DDE5BFCuLL) >> 0),
     (VUINT32) ((0x3FBB990B7DDE5BFCuLL) >> 32)},
    {(VUINT32) ((0x3FA67E17A4317C6CuLL) >> 0),
     (VUINT32) ((0x3FA67E17A4317C6CuLL) >> 32)},
    {(VUINT32) ((0x3F9F455B2F170454uLL) >> 0),
     (VUINT32) ((0x3F9F455B2F170454uLL) >> 32)},
    {(VUINT32) ((0x3F804BEEF437A2B3uLL) >> 0),
     (VUINT32) ((0x3F804BEEF437A2B3uLL) >> 32)},
    {(VUINT32) ((0x3F7080CEADF2976DuLL) >> 0),
     (VUINT32) ((0x3F7080CEADF2976DuLL) >> 32)},
    {(VUINT32) ((0x3F55A44E3A71E919uLL) >> 0),
     (VUINT32) ((0x3F55A44E3A71E919uLL) >> 32)},
    {(VUINT32) ((0xBF039F946FDF9BBBuLL) >> 0),
     (VUINT32) ((0xBF039F946FDF9BBBuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE33E046C843287uLL) >> 0),
     (VUINT32) ((0xBFE33E046C843287uLL) >> 32)},
    {(VUINT32) ((0x3C8A7CCAC0E4698BuLL) >> 0),
     (VUINT32) ((0x3C8A7CCAC0E4698BuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCA4C01D0769648uLL) >> 0),
     (VUINT32) ((0x3FCA4C01D0769648uLL) >> 32)},
    {(VUINT32) ((0x3C4DDC96CAE4A06CuLL) >> 0),
     (VUINT32) ((0x3C4DDC96CAE4A06CuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBBE09D8A670D72uLL) >> 0),
     (VUINT32) ((0x3FBBE09D8A670D72uLL) >> 32)},
    {(VUINT32) ((0x3FA71267C4E29753uLL) >> 0),
     (VUINT32) ((0x3FA71267C4E29753uLL) >> 32)},
    {(VUINT32) ((0x3F9FAD5AB78BB764uLL) >> 0),
     (VUINT32) ((0x3F9FAD5AB78BB764uLL) >> 32)},
    {(VUINT32) ((0x3F80CF21BC414F68uLL) >> 0),
     (VUINT32) ((0x3F80CF21BC414F68uLL) >> 32)},
    {(VUINT32) ((0x3F70E8AC1DCF4352uLL) >> 0),
     (VUINT32) ((0x3F70E8AC1DCF4352uLL) >> 32)},
    {(VUINT32) ((0x3F567A14C053085FuLL) >> 0),
     (VUINT32) ((0x3F567A14C053085FuLL) >> 32)},
    {(VUINT32) ((0x3F4F621D6DE176C4uLL) >> 0),
     (VUINT32) ((0x3F4F621D6DE176C4uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE3A28C59D5433BuLL) >> 0),
     (VUINT32) ((0xBFE3A28C59D5433BuLL) >> 32)},
    {(VUINT32) ((0x3C51B19140C0C0D5uLL) >> 0),
     (VUINT32) ((0x3C51B19140C0C0D5uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCADC8D51C0FA5BuLL) >> 0),
     (VUINT32) ((0x3FCADC8D51C0FA5BuLL) >> 32)},
    {(VUINT32) ((0x3C54B350B5D39570uLL) >> 0),
     (VUINT32) ((0x3C54B350B5D39570uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBC2A04912319A8uLL) >> 0),
     (VUINT32) ((0x3FBC2A04912319A8uLL) >> 32)},
    {(VUINT32) ((0x3FA7A8A9A038608EuLL) >> 0),
     (VUINT32) ((0x3FA7A8A9A038608EuLL) >> 32)},
    {(VUINT32) ((0x3FA00C4E5E972915uLL) >> 0),
     (VUINT32) ((0x3FA00C4E5E972915uLL) >> 32)},
    {(VUINT32) ((0x3F8155947D4C5C83uLL) >> 0),
     (VUINT32) ((0x3F8155947D4C5C83uLL) >> 32)},
    {(VUINT32) ((0x3F7154A7B149DA58uLL) >> 0),
     (VUINT32) ((0x3F7154A7B149DA58uLL) >> 32)},
    {(VUINT32) ((0x3F5757960EDFC45CuLL) >> 0),
     (VUINT32) ((0x3F5757960EDFC45CuLL) >> 32)},
    {(VUINT32) ((0x3F3F895706E3352BuLL) >> 0),
     (VUINT32) ((0x3F3F895706E3352BuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE40714472653EFuLL) >> 0),
     (VUINT32) ((0xBFE40714472653EFuLL) >> 32)},
    {(VUINT32) ((0xBC86106670B43955uLL) >> 0),
     (VUINT32) ((0xBC86106670B43955uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCB6D8D944D0371uLL) >> 0),
     (VUINT32) ((0x3FCB6D8D944D0371uLL) >> 32)},
    {(VUINT32) ((0xBC6CDD9D6EA4BA41uLL) >> 0),
     (VUINT32) ((0xBC6CDD9D6EA4BA41uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBC7546C60FE5C7uLL) >> 0),
     (VUINT32) ((0x3FBC7546C60FE5C7uLL) >> 32)},
    {(VUINT32) ((0x3FA840ECC35C53FDuLL) >> 0),
     (VUINT32) ((0x3FA840ECC35C53FDuLL) >> 32)},
    {(VUINT32) ((0x3FA0439B07C380F3uLL) >> 0),
     (VUINT32) ((0x3FA0439B07C380F3uLL) >> 32)},
    {(VUINT32) ((0x3F81DF673F038AB5uLL) >> 0),
     (VUINT32) ((0x3F81DF673F038AB5uLL) >> 32)},
    {(VUINT32) ((0x3F71C4B3C36B8A12uLL) >> 0),
     (VUINT32) ((0x3F71C4B3C36B8A12uLL) >> 32)},
    {(VUINT32) ((0x3F583D44FA2FB203uLL) >> 0),
     (VUINT32) ((0x3F583D44FA2FB203uLL) >> 32)},
    {(VUINT32) ((0x3F52EE3E6132A151uLL) >> 0),
     (VUINT32) ((0x3F52EE3E6132A151uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE46B9C347764A4uLL) >> 0),
     (VUINT32) ((0xBFE46B9C347764A4uLL) >> 32)},
    {(VUINT32) ((0x3C81A900F67F753AuLL) >> 0),
     (VUINT32) ((0x3C81A900F67F753AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCBFF05878394D3uLL) >> 0),
     (VUINT32) ((0x3FCBFF05878394D3uLL) >> 32)},
    {(VUINT32) ((0x3C486912F813E2ECuLL) >> 0),
     (VUINT32) ((0x3C486912F813E2ECuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBCC26A8EA2077FuLL) >> 0),
     (VUINT32) ((0x3FBCC26A8EA2077FuLL) >> 32)},
    {(VUINT32) ((0x3FA8DB411F68EE69uLL) >> 0),
     (VUINT32) ((0x3FA8DB411F68EE69uLL) >> 32)},
    {(VUINT32) ((0x3FA07C9E25737218uLL) >> 0),
     (VUINT32) ((0x3FA07C9E25737218uLL) >> 32)},
    {(VUINT32) ((0x3F826CBB3713A292uLL) >> 0),
     (VUINT32) ((0x3F826CBB3713A292uLL) >> 32)},
    {(VUINT32) ((0x3F72392A32F26720uLL) >> 0),
     (VUINT32) ((0x3F72392A32F26720uLL) >> 32)},
    {(VUINT32) ((0x3F592B76EEB6E2FFuLL) >> 0),
     (VUINT32) ((0x3F592B76EEB6E2FFuLL) >> 32)},
    {(VUINT32) ((0x3F39BADB5780F9BEuLL) >> 0),
     (VUINT32) ((0x3F39BADB5780F9BEuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE4D02421C87558uLL) >> 0),
     (VUINT32) ((0xBFE4D02421C87558uLL) >> 32)},
    {(VUINT32) ((0xBC6A765E893370D7uLL) >> 0),
     (VUINT32) ((0xBC6A765E893370D7uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCC90F8250157F7uLL) >> 0),
     (VUINT32) ((0x3FCC90F8250157F7uLL) >> 32)},
    {(VUINT32) ((0x3C657D8312BFEA17uLL) >> 0),
     (VUINT32) ((0x3C657D8312BFEA17uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBD117683053E13uLL) >> 0),
     (VUINT32) ((0x3FBD117683053E13uLL) >> 32)},
    {(VUINT32) ((0x3FA977B70D411C29uLL) >> 0),
     (VUINT32) ((0x3FA977B70D411C29uLL) >> 32)},
    {(VUINT32) ((0x3FA0B762F022F359uLL) >> 0),
     (VUINT32) ((0x3FA0B762F022F359uLL) >> 32)},
    {(VUINT32) ((0x3F82FDB2D7324A8FuLL) >> 0),
     (VUINT32) ((0x3F82FDB2D7324A8FuLL) >> 32)},
    {(VUINT32) ((0x3F72B2030A36AADFuLL) >> 0),
     (VUINT32) ((0x3F72B2030A36AADFuLL) >> 32)},
    {(VUINT32) ((0x3F5A22A22953FC15uLL) >> 0),
     (VUINT32) ((0x3F5A22A22953FC15uLL) >> 32)},
    {(VUINT32) ((0x3F473A2F09CE8F95uLL) >> 0),
     (VUINT32) ((0x3F473A2F09CE8F95uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE534AC0F19860CuLL) >> 0),
     (VUINT32) ((0xBFE534AC0F19860CuLL) >> 32)},
    {(VUINT32) ((0xBC8EE4303B192DA6uLL) >> 0),
     (VUINT32) ((0xBC8EE4303B192DA6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCD236870E769B5uLL) >> 0),
     (VUINT32) ((0x3FCD236870E769B5uLL) >> 32)},
    {(VUINT32) ((0x3C523CE78218C6AAuLL) >> 0),
     (VUINT32) ((0x3C523CE78218C6AAuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBD62716F68B5FEuLL) >> 0),
     (VUINT32) ((0x3FBD62716F68B5FEuLL) >> 32)},
    {(VUINT32) ((0x3FAA165F518C38ABuLL) >> 0),
     (VUINT32) ((0x3FAA165F518C38ABuLL) >> 32)},
    {(VUINT32) ((0x3FA0F3F50E789484uLL) >> 0),
     (VUINT32) ((0x3FA0F3F50E789484uLL) >> 32)},
    {(VUINT32) ((0x3F839271DC18DB75uLL) >> 0),
     (VUINT32) ((0x3F839271DC18DB75uLL) >> 32)},
    {(VUINT32) ((0x3F732F8BAC4C54A8uLL) >> 0),
     (VUINT32) ((0x3F732F8BAC4C54A8uLL) >> 32)},
    {(VUINT32) ((0x3F5B23248F865B74uLL) >> 0),
     (VUINT32) ((0x3F5B23248F865B74uLL) >> 32)},
    {(VUINT32) ((0x3F36E307E2B0837CuLL) >> 0),
     (VUINT32) ((0x3F36E307E2B0837CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE59933FC6A96C1uLL) >> 0),
     (VUINT32) ((0xBFE59933FC6A96C1uLL) >> 32)},
    {(VUINT32) ((0x3C71AA6E583501D4uLL) >> 0),
     (VUINT32) ((0x3C71AA6E583501D4uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCDB6597A2E1B61uLL) >> 0),
     (VUINT32) ((0x3FCDB6597A2E1B61uLL) >> 32)},
    {(VUINT32) ((0xBC6CB71A947AACF6uLL) >> 0),
     (VUINT32) ((0xBC6CB71A947AACF6uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBDB56255580CA4uLL) >> 0),
     (VUINT32) ((0x3FBDB56255580CA4uLL) >> 32)},
    {(VUINT32) ((0x3FAAB74B20D856E7uLL) >> 0),
     (VUINT32) ((0x3FAAB74B20D856E7uLL) >> 32)},
    {(VUINT32) ((0x3FA1326099896038uLL) >> 0),
     (VUINT32) ((0x3FA1326099896038uLL) >> 32)},
    {(VUINT32) ((0x3F842B1D5CF84F74uLL) >> 0),
     (VUINT32) ((0x3F842B1D5CF84F74uLL) >> 32)},
    {(VUINT32) ((0x3F73B1CC2C4E32D2uLL) >> 0),
     (VUINT32) ((0x3F73B1CC2C4E32D2uLL) >> 32)},
    {(VUINT32) ((0x3F5C2D7D75B7FC1BuLL) >> 0),
     (VUINT32) ((0x3F5C2D7D75B7FC1BuLL) >> 32)},
    {(VUINT32) ((0x3F53DB94CE2C2FD8uLL) >> 0),
     (VUINT32) ((0x3F53DB94CE2C2FD8uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE5FDBBE9BBA775uLL) >> 0),
     (VUINT32) ((0xBFE5FDBBE9BBA775uLL) >> 32)},
    {(VUINT32) ((0xBC7EE2C2D963A10CuLL) >> 0),
     (VUINT32) ((0xBC7EE2C2D963A10CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCE49CE5AF9DC29uLL) >> 0),
     (VUINT32) ((0x3FCE49CE5AF9DC29uLL) >> 32)},
    {(VUINT32) ((0xBC382336F1C6BD90uLL) >> 0),
     (VUINT32) ((0xBC382336F1C6BD90uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBE0A506D218F3CuLL) >> 0),
     (VUINT32) ((0x3FBE0A506D218F3CuLL) >> 32)},
    {(VUINT32) ((0x3FAB5A8C23E49FEAuLL) >> 0),
     (VUINT32) ((0x3FAB5A8C23E49FEAuLL) >> 32)},
    {(VUINT32) ((0x3FA172B22117D625uLL) >> 0),
     (VUINT32) ((0x3FA172B22117D625uLL) >> 32)},
    {(VUINT32) ((0x3F84C7DBDBF304B9uLL) >> 0),
     (VUINT32) ((0x3F84C7DBDBF304B9uLL) >> 32)},
    {(VUINT32) ((0x3F74391DF553E930uLL) >> 0),
     (VUINT32) ((0x3F74391DF553E930uLL) >> 32)},
    {(VUINT32) ((0x3F5D4211231EF24AuLL) >> 0),
     (VUINT32) ((0x3F5D4211231EF24AuLL) >> 32)},
    {(VUINT32) ((0x3F52AB1CCD8D3AA9uLL) >> 0),
     (VUINT32) ((0x3F52AB1CCD8D3AA9uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE66243D70CB82AuLL) >> 0),
     (VUINT32) ((0xBFE66243D70CB82AuLL) >> 32)},
    {(VUINT32) ((0x3C884805FA81DE0AuLL) >> 0),
     (VUINT32) ((0x3C884805FA81DE0AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCEDDCA38F25FECuLL) >> 0),
     (VUINT32) ((0x3FCEDDCA38F25FECuLL) >> 32)},
    {(VUINT32) ((0xBC65AACB9E8B4DF8uLL) >> 0),
     (VUINT32) ((0xBC65AACB9E8B4DF8uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBE6143274A35BFuLL) >> 0),
     (VUINT32) ((0x3FBE6143274A35BFuLL) >> 32)},
    {(VUINT32) ((0x3FAC00347C15ABB2uLL) >> 0),
     (VUINT32) ((0x3FAC00347C15ABB2uLL) >> 32)},
    {(VUINT32) ((0x3FA1B4F6B03A62C8uLL) >> 0),
     (VUINT32) ((0x3FA1B4F6B03A62C8uLL) >> 32)},
    {(VUINT32) ((0x3F8568D557225239uLL) >> 0),
     (VUINT32) ((0x3F8568D557225239uLL) >> 32)},
    {(VUINT32) ((0x3F74C5A8346B0155uLL) >> 0),
     (VUINT32) ((0x3F74C5A8346B0155uLL) >> 32)},
    {(VUINT32) ((0x3F5E61680C7E386AuLL) >> 0),
     (VUINT32) ((0x3F5E61680C7E386AuLL) >> 32)},
    {(VUINT32) ((0x3F45A81E03899535uLL) >> 0),
     (VUINT32) ((0x3F45A81E03899535uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE6C6CBC45DC8DEuLL) >> 0),
     (VUINT32) ((0xBFE6C6CBC45DC8DEuLL) >> 32)},
    {(VUINT32) ((0x3BC6D61B58C99C43uLL) >> 0),
     (VUINT32) ((0x3BC6D61B58C99C43uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCF7250459C1976uLL) >> 0),
     (VUINT32) ((0x3FCF7250459C1976uLL) >> 32)},
    {(VUINT32) ((0x3C40B5B081F06BA0uLL) >> 0),
     (VUINT32) ((0x3C40B5B081F06BA0uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBEBA422E0FE0E5uLL) >> 0),
     (VUINT32) ((0x3FBEBA422E0FE0E5uLL) >> 32)},
    {(VUINT32) ((0x3FACA856C815D042uLL) >> 0),
     (VUINT32) ((0x3FACA856C815D042uLL) >> 32)},
    {(VUINT32) ((0x3FA1F93BD218DCE9uLL) >> 0),
     (VUINT32) ((0x3FA1F93BD218DCE9uLL) >> 32)},
    {(VUINT32) ((0x3F860E335AB42933uLL) >> 0),
     (VUINT32) ((0x3F860E335AB42933uLL) >> 32)},
    {(VUINT32) ((0x3F75578EEA5D18D8uLL) >> 0),
     (VUINT32) ((0x3F75578EEA5D18D8uLL) >> 32)},
    {(VUINT32) ((0x3F5F8BFBAD564E86uLL) >> 0),
     (VUINT32) ((0x3F5F8BFBAD564E86uLL) >> 32)},
    {(VUINT32) ((0x3F434A80D1DA21D1uLL) >> 0),
     (VUINT32) ((0x3F434A80D1DA21D1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE72B53B1AED992uLL) >> 0),
     (VUINT32) ((0xBFE72B53B1AED992uLL) >> 32)},
    {(VUINT32) ((0xBC88452B3716C4D6uLL) >> 0),
     (VUINT32) ((0xBC88452B3716C4D6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD003B1DF5A0F86uLL) >> 0),
     (VUINT32) ((0x3FD003B1DF5A0F86uLL) >> 32)},
    {(VUINT32) ((0x3C716CEB71FB716BuLL) >> 0),
     (VUINT32) ((0x3C716CEB71FB716BuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBF155566FA6884uLL) >> 0),
     (VUINT32) ((0x3FBF155566FA6884uLL) >> 32)},
    {(VUINT32) ((0x3FAD530628A37C7AuLL) >> 0),
     (VUINT32) ((0x3FAD530628A37C7AuLL) >> 32)},
    {(VUINT32) ((0x3FA23F8F96E80A99uLL) >> 0),
     (VUINT32) ((0x3FA23F8F96E80A99uLL) >> 32)},
    {(VUINT32) ((0x3F86B82113BDC04EuLL) >> 0),
     (VUINT32) ((0x3F86B82113BDC04EuLL) >> 32)},
    {(VUINT32) ((0x3F75EF0B9C9DF1C6uLL) >> 0),
     (VUINT32) ((0x3F75EF0B9C9DF1C6uLL) >> 32)},
    {(VUINT32) ((0x3F60613421CB6A80uLL) >> 0),
     (VUINT32) ((0x3F60613421CB6A80uLL) >> 32)},
    {(VUINT32) ((0x3F48E48E906FE806uLL) >> 0),
     (VUINT32) ((0x3F48E48E906FE806uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE78FDB9EFFEA47uLL) >> 0),
     (VUINT32) ((0xBFE78FDB9EFFEA47uLL) >> 32)},
    {(VUINT32) ((0x3C7EE8786039D373uLL) >> 0),
     (VUINT32) ((0x3C7EE8786039D373uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD04E83F7474877uLL) >> 0),
     (VUINT32) ((0x3FD04E83F7474877uLL) >> 32)},
    {(VUINT32) ((0x3C73B117AC20AC65uLL) >> 0),
     (VUINT32) ((0x3C73B117AC20AC65uLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBF7284F47C0E61uLL) >> 0),
     (VUINT32) ((0x3FBF7284F47C0E61uLL) >> 32)},
    {(VUINT32) ((0x3FAE0056458FCED5uLL) >> 0),
     (VUINT32) ((0x3FAE0056458FCED5uLL) >> 32)},
    {(VUINT32) ((0x3FA28800992AEEE6uLL) >> 0),
     (VUINT32) ((0x3FA28800992AEEE6uLL) >> 32)},
    {(VUINT32) ((0x3F8766CB6439B11DuLL) >> 0),
     (VUINT32) ((0x3F8766CB6439B11DuLL) >> 32)},
    {(VUINT32) ((0x3F768C54DBB36839uLL) >> 0),
     (VUINT32) ((0x3F768C54DBB36839uLL) >> 32)},
    {(VUINT32) ((0x3F610297B13942C6uLL) >> 0),
     (VUINT32) ((0x3F610297B13942C6uLL) >> 32)},
    {(VUINT32) ((0x3F5536BD1C4BF79EuLL) >> 0),
     (VUINT32) ((0x3F5536BD1C4BF79EuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE7F4638C50FAFBuLL) >> 0),
     (VUINT32) ((0xBFE7F4638C50FAFBuLL) >> 32)},
    {(VUINT32) ((0xBC71A4B8D15ECF6DuLL) >> 0),
     (VUINT32) ((0xBC71A4B8D15ECF6DuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD099A0163BCD3FuLL) >> 0),
     (VUINT32) ((0x3FD099A0163BCD3FuLL) >> 32)},
    {(VUINT32) ((0x3C7A7F11D963D72EuLL) >> 0),
     (VUINT32) ((0x3C7A7F11D963D72EuLL) >> 32)},
    {(VUINT32) ((0x3FD0000000000000uLL) >> 0),
     (VUINT32) ((0x3FD0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBFD1D937A1F094uLL) >> 0),
     (VUINT32) ((0x3FBFD1D937A1F094uLL) >> 32)},
    {(VUINT32) ((0x3FAEB05B52EFB4C0uLL) >> 0),
     (VUINT32) ((0x3FAEB05B52EFB4C0uLL) >> 32)},
    {(VUINT32) ((0x3FA2D29E032A57DBuLL) >> 0),
     (VUINT32) ((0x3FA2D29E032A57DBuLL) >> 32)},
    {(VUINT32) ((0x3F881A60F7D38723uLL) >> 0),
     (VUINT32) ((0x3F881A60F7D38723uLL) >> 32)},
    {(VUINT32) ((0x3F772FBBF1BFA28BuLL) >> 0),
     (VUINT32) ((0x3F772FBBF1BFA28BuLL) >> 32)},
    {(VUINT32) ((0x3F61AA745B27BB01uLL) >> 0),
     (VUINT32) ((0x3F61AA745B27BB01uLL) >> 32)},
    {(VUINT32) ((0x3F51CC19136F91C1uLL) >> 0),
     (VUINT32) ((0x3F51CC19136F91C1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE858EB79A20BB0uLL) >> 0),
     (VUINT32) ((0xBFE858EB79A20BB0uLL) >> 32)},
    {(VUINT32) ((0x3C8EE70AFE8446D9uLL) >> 0),
     (VUINT32) ((0x3C8EE70AFE8446D9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD0E507EE8B93D7uLL) >> 0),
     (VUINT32) ((0x3FD0E507EE8B93D7uLL) >> 32)},
    {(VUINT32) ((0x3C679F09CDD5D5B2uLL) >> 0),
     (VUINT32) ((0x3C679F09CDD5D5B2uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBFCCA52E2AE201uLL) >> 0),
     (VUINT32) ((0xBFBFCCA52E2AE201uLL) >> 32)},
    {(VUINT32) ((0x3FAF632A1681FD0BuLL) >> 0),
     (VUINT32) ((0x3FAF632A1681FD0BuLL) >> 32)},
    {(VUINT32) ((0x3FA31F7794BDF922uLL) >> 0),
     (VUINT32) ((0x3FA31F7794BDF922uLL) >> 32)},
    {(VUINT32) ((0x3F88D31259E30525uLL) >> 0),
     (VUINT32) ((0x3F88D31259E30525uLL) >> 32)},
    {(VUINT32) ((0x3F77D97B728544F5uLL) >> 0),
     (VUINT32) ((0x3F77D97B728544F5uLL) >> 32)},
    {(VUINT32) ((0x3F62591A3A2B699FuLL) >> 0),
     (VUINT32) ((0x3F62591A3A2B699FuLL) >> 32)},
    {(VUINT32) ((0x3F3605B387A5D7A0uLL) >> 0),
     (VUINT32) ((0x3F3605B387A5D7A0uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE8BD7366F31C64uLL) >> 0),
     (VUINT32) ((0xBFE8BD7366F31C64uLL) >> 32)},
    {(VUINT32) ((0x3C6A81C996DFD5A5uLL) >> 0),
     (VUINT32) ((0x3C6A81C996DFD5A5uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD130BD396BB4A9uLL) >> 0),
     (VUINT32) ((0x3FD130BD396BB4A9uLL) >> 32)},
    {(VUINT32) ((0xBC657D8592EA09D4uLL) >> 0),
     (VUINT32) ((0xBC657D8592EA09D4uLL) >> 32)},
    {(VUINT32) ((0x3FE0000000000000uLL) >> 0),
     (VUINT32) ((0x3FE0000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBF68ED595308D6uLL) >> 0),
     (VUINT32) ((0xBFBF68ED595308D6uLL) >> 32)},
    {(VUINT32) ((0x3FB00C6BF6A673E6uLL) >> 0),
     (VUINT32) ((0x3FB00C6BF6A673E6uLL) >> 32)},
    {(VUINT32) ((0x3FA36E9DA9556AA6uLL) >> 0),
     (VUINT32) ((0x3FA36E9DA9556AA6uLL) >> 32)},
    {(VUINT32) ((0x3F8991120C7D4BB9uLL) >> 0),
     (VUINT32) ((0x3F8991120C7D4BB9uLL) >> 32)},
    {(VUINT32) ((0x3F7889ABD6008215uLL) >> 0),
     (VUINT32) ((0x3F7889ABD6008215uLL) >> 32)},
    {(VUINT32) ((0x3F630EE404688883uLL) >> 0),
     (VUINT32) ((0x3F630EE404688883uLL) >> 32)},
    {(VUINT32) ((0x3F52CAD75A2201AFuLL) >> 0),
     (VUINT32) ((0x3F52CAD75A2201AFuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE921FB54442D18uLL) >> 0),
     (VUINT32) ((0xBFE921FB54442D18uLL) >> 32)},
    {(VUINT32) ((0xBC81A62633145C07uLL) >> 0),
     (VUINT32) ((0xBC81A62633145C07uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFF0000000000000uLL) >> 0),
     (VUINT32) ((0xBFF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3C0492B176DF0500uLL) >> 0),
     (VUINT32) ((0x3C0492B176DF0500uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xC00000000000010AuLL) >> 0),
     (VUINT32) ((0xC00000000000010AuLL) >> 32)},
    {(VUINT32) ((0x4005555555555614uLL) >> 0),
     (VUINT32) ((0x4005555555555614uLL) >> 32)},
    {(VUINT32) ((0xC00AAAAAA890EF4DuLL) >> 0),
     (VUINT32) ((0xC00AAAAAA890EF4DuLL) >> 32)},
    {(VUINT32) ((0x4011111110018C73uLL) >> 0),
     (VUINT32) ((0x4011111110018C73uLL) >> 32)},
    {(VUINT32) ((0xC015B108FB920A0BuLL) >> 0),
     (VUINT32) ((0xC015B108FB920A0BuLL) >> 32)},
    {(VUINT32) ((0x401BA285D6669571uLL) >> 0),
     (VUINT32) ((0x401BA285D6669571uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE9868341953DCDuLL) >> 0),
     (VUINT32) ((0xBFE9868341953DCDuLL) >> 32)},
    {(VUINT32) ((0x3C861341341F5289uLL) >> 0),
     (VUINT32) ((0x3C861341341F5289uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEF395D9F0E3C92uLL) >> 0),
     (VUINT32) ((0xBFEF395D9F0E3C92uLL) >> 32)},
    {(VUINT32) ((0x3C550BEC65726E28uLL) >> 0),
     (VUINT32) ((0x3C550BEC65726E28uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA8873C53BE0540uLL) >> 0),
     (VUINT32) ((0xBFA8873C53BE0540uLL) >> 32)},
    {(VUINT32) ((0xBFFE79E5C65202DEuLL) >> 0),
     (VUINT32) ((0xBFFE79E5C65202DEuLL) >> 32)},
    {(VUINT32) ((0x400412FD76797C7DuLL) >> 0),
     (VUINT32) ((0x400412FD76797C7DuLL) >> 32)},
    {(VUINT32) ((0xC008AAB30DC82D37uLL) >> 0),
     (VUINT32) ((0xC008AAB30DC82D37uLL) >> 32)},
    {(VUINT32) ((0x400F1B6C68B4AEA4uLL) >> 0),
     (VUINT32) ((0x400F1B6C68B4AEA4uLL) >> 32)},
    {(VUINT32) ((0xC013758CE9BD9EFAuLL) >> 0),
     (VUINT32) ((0xC013758CE9BD9EFAuLL) >> 32)},
    {(VUINT32) ((0x40186872A0685915uLL) >> 0),
     (VUINT32) ((0x40186872A0685915uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFE9EB0B2EE64E81uLL) >> 0),
     (VUINT32) ((0xBFE9EB0B2EE64E81uLL) >> 32)},
    {(VUINT32) ((0xBC519ABB2567F739uLL) >> 0),
     (VUINT32) ((0xBC519ABB2567F739uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEE776EAFC91706uLL) >> 0),
     (VUINT32) ((0xBFEE776EAFC91706uLL) >> 32)},
    {(VUINT32) ((0xBC890664EDC53F33uLL) >> 0),
     (VUINT32) ((0xBC890664EDC53F33uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB7F295AD658764uLL) >> 0),
     (VUINT32) ((0xBFB7F295AD658764uLL) >> 32)},
    {(VUINT32) ((0xBFFD0AA1DB7F5E58uLL) >> 0),
     (VUINT32) ((0xBFFD0AA1DB7F5E58uLL) >> 32)},
    {(VUINT32) ((0x4002E8A6F9693556uLL) >> 0),
     (VUINT32) ((0x4002E8A6F9693556uLL) >> 32)},
    {(VUINT32) ((0xC006D7CA16B298C6uLL) >> 0),
     (VUINT32) ((0xC006D7CA16B298C6uLL) >> 32)},
    {(VUINT32) ((0x400C63DFCAA3FB6CuLL) >> 0),
     (VUINT32) ((0x400C63DFCAA3FB6CuLL) >> 32)},
    {(VUINT32) ((0xC0117C3EE50D7742uLL) >> 0),
     (VUINT32) ((0xC0117C3EE50D7742uLL) >> 32)},
    {(VUINT32) ((0x401599932C96B9B6uLL) >> 0),
     (VUINT32) ((0x401599932C96B9B6uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEA4F931C375F35uLL) >> 0),
     (VUINT32) ((0xBFEA4F931C375F35uLL) >> 32)},
    {(VUINT32) ((0xBC8A79EFFD795057uLL) >> 0),
     (VUINT32) ((0xBC8A79EFFD795057uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEDB9FA89953FCFuLL) >> 0),
     (VUINT32) ((0xBFEDB9FA89953FCFuLL) >> 32)},
    {(VUINT32) ((0xBC286C68F514A640uLL) >> 0),
     (VUINT32) ((0xBC286C68F514A640uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC18AC418849A6EuLL) >> 0),
     (VUINT32) ((0xBFC18AC418849A6EuLL) >> 32)},
    {(VUINT32) ((0xBFFBB083E02786D7uLL) >> 0),
     (VUINT32) ((0xBFFBB083E02786D7uLL) >> 32)},
    {(VUINT32) ((0x4001D438F8A20402uLL) >> 0),
     (VUINT32) ((0x4001D438F8A20402uLL) >> 32)},
    {(VUINT32) ((0xC0052D5D6FF7A4BDuLL) >> 0),
     (VUINT32) ((0xC0052D5D6FF7A4BDuLL) >> 32)},
    {(VUINT32) ((0x4009F262067BAA5AuLL) >> 0),
     (VUINT32) ((0x4009F262067BAA5AuLL) >> 32)},
    {(VUINT32) ((0xC00F793DA8608BEDuLL) >> 0),
     (VUINT32) ((0xC00F793DA8608BEDuLL) >> 32)},
    {(VUINT32) ((0x401328BFC5F60A29uLL) >> 0),
     (VUINT32) ((0x401328BFC5F60A29uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEAB41B09886FEAuLL) >> 0),
     (VUINT32) ((0xBFEAB41B09886FEAuLL) >> 32)},
    {(VUINT32) ((0x3C7A7EEED374BC71uLL) >> 0),
     (VUINT32) ((0x3C7A7EEED374BC71uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFED00CBC7384D2EuLL) >> 0),
     (VUINT32) ((0xBFED00CBC7384D2EuLL) >> 32)},
    {(VUINT32) ((0xBC78C4FC635B4060uLL) >> 0),
     (VUINT32) ((0xBC78C4FC635B4060uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC6DA3A87611EA6uLL) >> 0),
     (VUINT32) ((0xBFC6DA3A87611EA6uLL) >> 32)},
    {(VUINT32) ((0xBFFA6A00F50D3A6FuLL) >> 0),
     (VUINT32) ((0xBFFA6A00F50D3A6FuLL) >> 32)},
    {(VUINT32) ((0x4000D3D0A6ABBD46uLL) >> 0),
     (VUINT32) ((0x4000D3D0A6ABBD46uLL) >> 32)},
    {(VUINT32) ((0xC003A760672280D0uLL) >> 0),
     (VUINT32) ((0xC003A760672280D0uLL) >> 32)},
    {(VUINT32) ((0x4007BF026C103550uLL) >> 0),
     (VUINT32) ((0x4007BF026C103550uLL) >> 32)},
    {(VUINT32) ((0xC00C5EBD23F4E2EDuLL) >> 0),
     (VUINT32) ((0xC00C5EBD23F4E2EDuLL) >> 32)},
    {(VUINT32) ((0x4011024DB786758BuLL) >> 0),
     (VUINT32) ((0x4011024DB786758BuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEB18A2F6D9809EuLL) >> 0),
     (VUINT32) ((0xBFEB18A2F6D9809EuLL) >> 32)},
    {(VUINT32) ((0xBC760E425E23E66FuLL) >> 0),
     (VUINT32) ((0xBC760E425E23E66FuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEC4BB009E77983uLL) >> 0),
     (VUINT32) ((0xBFEC4BB009E77983uLL) >> 32)},
    {(VUINT32) ((0x3C5346B6895BC358uLL) >> 0),
     (VUINT32) ((0x3C5346B6895BC358uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCBEB63A6D04570uLL) >> 0),
     (VUINT32) ((0xBFCBEB63A6D04570uLL) >> 32)},
    {(VUINT32) ((0xBFF935AFFA8DCC1DuLL) >> 0),
     (VUINT32) ((0xBFF935AFFA8DCC1DuLL) >> 32)},
    {(VUINT32) ((0x3FFFCB7657D15F0BuLL) >> 0),
     (VUINT32) ((0x3FFFCB7657D15F0BuLL) >> 32)},
    {(VUINT32) ((0xC002423AFCE75F54uLL) >> 0),
     (VUINT32) ((0xC002423AFCE75F54uLL) >> 32)},
    {(VUINT32) ((0x4005C2CF61AD4B89uLL) >> 0),
     (VUINT32) ((0x4005C2CF61AD4B89uLL) >> 32)},
    {(VUINT32) ((0xC0099C675A298F5CuLL) >> 0),
     (VUINT32) ((0xC0099C675A298F5CuLL) >> 32)},
    {(VUINT32) ((0x400E49F38B657F96uLL) >> 0),
     (VUINT32) ((0x400E49F38B657F96uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEB7D2AE42A9153uLL) >> 0),
     (VUINT32) ((0xBFEB7D2AE42A9153uLL) >> 32)},
    {(VUINT32) ((0x3C8CB2463821BB58uLL) >> 0),
     (VUINT32) ((0x3C8CB2463821BB58uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEB9A77C18C1AF2uLL) >> 0),
     (VUINT32) ((0xBFEB9A77C18C1AF2uLL) >> 32)},
    {(VUINT32) ((0xBC76EA194A3A10DEuLL) >> 0),
     (VUINT32) ((0xBC76EA194A3A10DEuLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD060D88DF903DFuLL) >> 0),
     (VUINT32) ((0xBFD060D88DF903DFuLL) >> 32)},
    {(VUINT32) ((0xBFF812463C417D93uLL) >> 0),
     (VUINT32) ((0xBFF812463C417D93uLL) >> 32)},
    {(VUINT32) ((0x3FFE10E093E6DE8DuLL) >> 0),
     (VUINT32) ((0x3FFE10E093E6DE8DuLL) >> 32)},
    {(VUINT32) ((0xC000FABB50DD022EuLL) >> 0),
     (VUINT32) ((0xC000FABB50DD022EuLL) >> 32)},
    {(VUINT32) ((0x4003F7B45B053F77uLL) >> 0),
     (VUINT32) ((0x4003F7B45B053F77uLL) >> 32)},
    {(VUINT32) ((0xC007275FB67DBBDDuLL) >> 0),
     (VUINT32) ((0xC007275FB67DBBDDuLL) >> 32)},
    {(VUINT32) ((0x400B02CB76CD2071uLL) >> 0),
     (VUINT32) ((0x400B02CB76CD2071uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEBE1B2D17BA207uLL) >> 0),
     (VUINT32) ((0xBFEBE1B2D17BA207uLL) >> 32)},
    {(VUINT32) ((0x3C61AEB67D55A7A1uLL) >> 0),
     (VUINT32) ((0x3C61AEB67D55A7A1uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEAECF5F9BA35A6uLL) >> 0),
     (VUINT32) ((0xBFEAECF5F9BA35A6uLL) >> 32)},
    {(VUINT32) ((0xBC45350833FF1F00uLL) >> 0),
     (VUINT32) ((0xBC45350833FF1F00uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD2B02B2D565D55uLL) >> 0),
     (VUINT32) ((0xBFD2B02B2D565D55uLL) >> 32)},
    {(VUINT32) ((0xBFF6FE947B408BACuLL) >> 0),
     (VUINT32) ((0xBFF6FE947B408BACuLL) >> 32)},
    {(VUINT32) ((0x3FFC751B52A83938uLL) >> 0),
     (VUINT32) ((0x3FFC751B52A83938uLL) >> 32)},
    {(VUINT32) ((0xBFFF9C12181CFBBAuLL) >> 0),
     (VUINT32) ((0xBFFF9C12181CFBBAuLL) >> 32)},
    {(VUINT32) ((0x4002585B4421C074uLL) >> 0),
     (VUINT32) ((0x4002585B4421C074uLL) >> 32)},
    {(VUINT32) ((0xC004F6412119DA02uLL) >> 0),
     (VUINT32) ((0xC004F6412119DA02uLL) >> 32)},
    {(VUINT32) ((0x400814BACED70A9AuLL) >> 0),
     (VUINT32) ((0x400814BACED70A9AuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEC463ABECCB2BBuLL) >> 0),
     (VUINT32) ((0xBFEC463ABECCB2BBuLL) >> 32)},
    {(VUINT32) ((0xBC83DAEAF976E788uLL) >> 0),
     (VUINT32) ((0xBC83DAEAF976E788uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFEA43002AE42850uLL) >> 0),
     (VUINT32) ((0xBFEA43002AE42850uLL) >> 32)},
    {(VUINT32) ((0x3C7A7C0406DA50C8uLL) >> 0),
     (VUINT32) ((0x3C7A7C0406DA50C8uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4E526E33345B8uLL) >> 0),
     (VUINT32) ((0xBFD4E526E33345B8uLL) >> 32)},
    {(VUINT32) ((0xBFF5F9844B626284uLL) >> 0),
     (VUINT32) ((0xBFF5F9844B626284uLL) >> 32)},
    {(VUINT32) ((0x3FFAF5A574C2F3BFuLL) >> 0),
     (VUINT32) ((0x3FFAF5A574C2F3BFuLL) >> 32)},
    {(VUINT32) ((0xBFFD7334FD198D13uLL) >> 0),
     (VUINT32) ((0xBFFD7334FD198D13uLL) >> 32)},
    {(VUINT32) ((0x4000E01251879DC7uLL) >> 0),
     (VUINT32) ((0x4000E01251879DC7uLL) >> 32)},
    {(VUINT32) ((0xC00300E6F5213CD0uLL) >> 0),
     (VUINT32) ((0xC00300E6F5213CD0uLL) >> 32)},
    {(VUINT32) ((0x40058BA67D3A0565uLL) >> 0),
     (VUINT32) ((0x40058BA67D3A0565uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFECAAC2AC1DC370uLL) >> 0),
     (VUINT32) ((0xBFECAAC2AC1DC370uLL) >> 32)},
    {(VUINT32) ((0x3C83DE7C6DBCC708uLL) >> 0),
     (VUINT32) ((0x3C83DE7C6DBCC708uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE99C6E0F634394uLL) >> 0),
     (VUINT32) ((0xBFE99C6E0F634394uLL) >> 32)},
    {(VUINT32) ((0xBC81A125C4B050B6uLL) >> 0),
     (VUINT32) ((0xBC81A125C4B050B6uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7012EAAC8A987uLL) >> 0),
     (VUINT32) ((0xBFD7012EAAC8A987uLL) >> 32)},
    {(VUINT32) ((0xBFF50215B95FD940uLL) >> 0),
     (VUINT32) ((0xBFF50215B95FD940uLL) >> 32)},
    {(VUINT32) ((0x3FF9903A2B193F49uLL) >> 0),
     (VUINT32) ((0x3FF9903A2B193F49uLL) >> 32)},
    {(VUINT32) ((0xBFFB7656607D37C1uLL) >> 0),
     (VUINT32) ((0xBFFB7656607D37C1uLL) >> 32)},
    {(VUINT32) ((0x3FFF156F461C0EDFuLL) >> 0),
     (VUINT32) ((0x3FFF156F461C0EDFuLL) >> 32)},
    {(VUINT32) ((0xC001403E48F27428uLL) >> 0),
     (VUINT32) ((0xC001403E48F27428uLL) >> 32)},
    {(VUINT32) ((0x40034ACD8D387876uLL) >> 0),
     (VUINT32) ((0x40034ACD8D387876uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFED0F4A996ED424uLL) >> 0),
     (VUINT32) ((0xBFED0F4A996ED424uLL) >> 32)},
    {(VUINT32) ((0xBC61A070AC3E29A0uLL) >> 0),
     (VUINT32) ((0xBC61A070AC3E29A0uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE8F9197BF85EEBuLL) >> 0),
     (VUINT32) ((0xBFE8F9197BF85EEBuLL) >> 32)},
    {(VUINT32) ((0x3C77971D70636FACuLL) >> 0),
     (VUINT32) ((0x3C77971D70636FACuLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD9058D62BBB98DuLL) >> 0),
     (VUINT32) ((0xBFD9058D62BBB98DuLL) >> 32)},
    {(VUINT32) ((0xBFF4175D31199B0CuLL) >> 0),
     (VUINT32) ((0xBFF4175D31199B0CuLL) >> 32)},
    {(VUINT32) ((0x3FF842CA948070CEuLL) >> 0),
     (VUINT32) ((0x3FF842CA948070CEuLL) >> 32)},
    {(VUINT32) ((0xBFF9A1675E6F2233uLL) >> 0),
     (VUINT32) ((0xBFF9A1675E6F2233uLL) >> 32)},
    {(VUINT32) ((0x3FFCA94A75D1DF36uLL) >> 0),
     (VUINT32) ((0x3FFCA94A75D1DF36uLL) >> 32)},
    {(VUINT32) ((0xBFFF5C3EE98CB792uLL) >> 0),
     (VUINT32) ((0xBFFF5C3EE98CB792uLL) >> 32)},
    {(VUINT32) ((0x4001549BBD776205uLL) >> 0),
     (VUINT32) ((0x4001549BBD776205uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFED73D286BFE4D8uLL) >> 0),
     (VUINT32) ((0xBFED73D286BFE4D8uLL) >> 32)},
    {(VUINT32) ((0xBC8CAEB4C3DBDBD8uLL) >> 0),
     (VUINT32) ((0xBC8CAEB4C3DBDBD8uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE858DE3B716571uLL) >> 0),
     (VUINT32) ((0xBFE858DE3B716571uLL) >> 32)},
    {(VUINT32) ((0xBC8C6340D74E9430uLL) >> 0),
     (VUINT32) ((0xBC8C6340D74E9430uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDAF377B50F3DE8uLL) >> 0),
     (VUINT32) ((0xBFDAF377B50F3DE8uLL) >> 32)},
    {(VUINT32) ((0xBFF338819C6A585BuLL) >> 0),
     (VUINT32) ((0xBFF338819C6A585BuLL) >> 32)},
    {(VUINT32) ((0x3FF70B781BB3F9F8uLL) >> 0),
     (VUINT32) ((0x3FF70B781BB3F9F8uLL) >> 32)},
    {(VUINT32) ((0xBFF7F0C4DC952BEEuLL) >> 0),
     (VUINT32) ((0xBFF7F0C4DC952BEEuLL) >> 32)},
    {(VUINT32) ((0x3FFA75444794B0BEuLL) >> 0),
     (VUINT32) ((0x3FFA75444794B0BEuLL) >> 32)},
    {(VUINT32) ((0xBFFC8A58AEEA1540uLL) >> 0),
     (VUINT32) ((0xBFFC8A58AEEA1540uLL) >> 32)},
    {(VUINT32) ((0x3FFF1509C3EC4766uLL) >> 0),
     (VUINT32) ((0x3FFF1509C3EC4766uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEDD85A7410F58DuLL) >> 0),
     (VUINT32) ((0xBFEDD85A7410F58DuLL) >> 32)},
    {(VUINT32) ((0x3C76156546AFA570uLL) >> 0),
     (VUINT32) ((0x3C76156546AFA570uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE7BB99ED2990CFuLL) >> 0),
     (VUINT32) ((0xBFE7BB99ED2990CFuLL) >> 32)},
    {(VUINT32) ((0x3C8AABB12893C19FuLL) >> 0),
     (VUINT32) ((0x3C8AABB12893C19FuLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDCCC0DD257FE9FuLL) >> 0),
     (VUINT32) ((0xBFDCCC0DD257FE9FuLL) >> 32)},
    {(VUINT32) ((0xBFF264BAB3E8C3FCuLL) >> 0),
     (VUINT32) ((0xBFF264BAB3E8C3FCuLL) >> 32)},
    {(VUINT32) ((0x3FF5E88F7CC1F7BCuLL) >> 0),
     (VUINT32) ((0x3FF5E88F7CC1F7BCuLL) >> 32)},
    {(VUINT32) ((0xBFF6612B1AE228E1uLL) >> 0),
     (VUINT32) ((0xBFF6612B1AE228E1uLL) >> 32)},
    {(VUINT32) ((0x3FF873A64164BF01uLL) >> 0),
     (VUINT32) ((0x3FF873A64164BF01uLL) >> 32)},
    {(VUINT32) ((0xBFFA016987C44E3BuLL) >> 0),
     (VUINT32) ((0xBFFA016987C44E3BuLL) >> 32)},
    {(VUINT32) ((0x3FFBFCA608E3ABD2uLL) >> 0),
     (VUINT32) ((0x3FFBFCA608E3ABD2uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEE3CE261620641uLL) >> 0),
     (VUINT32) ((0xBFEE3CE261620641uLL) >> 32)},
    {(VUINT32) ((0xBC7A77CBEAE8FD71uLL) >> 0),
     (VUINT32) ((0xBC7A77CBEAE8FD71uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE7212BE621BE6DuLL) >> 0),
     (VUINT32) ((0xBFE7212BE621BE6DuLL) >> 32)},
    {(VUINT32) ((0xBC8AD14CAC5A8A36uLL) >> 0),
     (VUINT32) ((0xBC8AD14CAC5A8A36uLL) >> 32)},
    {(VUINT32) ((0x4000000000000000uLL) >> 0),
     (VUINT32) ((0x4000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDE905D04D13F70uLL) >> 0),
     (VUINT32) ((0xBFDE905D04D13F70uLL) >> 32)},
    {(VUINT32) ((0xBFF19B4F7BD63206uLL) >> 0),
     (VUINT32) ((0xBFF19B4F7BD63206uLL) >> 32)},
    {(VUINT32) ((0x3FF4D8845C8EEC38uLL) >> 0),
     (VUINT32) ((0x3FF4D8845C8EEC38uLL) >> 32)},
    {(VUINT32) ((0xBFF4EFAAD70924AAuLL) >> 0),
     (VUINT32) ((0xBFF4EFAAD70924AAuLL) >> 32)},
    {(VUINT32) ((0x3FF69F610EDFA787uLL) >> 0),
     (VUINT32) ((0x3FF69F610EDFA787uLL) >> 32)},
    {(VUINT32) ((0xBFF7B93C8525967BuLL) >> 0),
     (VUINT32) ((0xBFF7B93C8525967BuLL) >> 32)},
    {(VUINT32) ((0x3FF928F491396159uLL) >> 0),
     (VUINT32) ((0x3FF928F491396159uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEEA16A4EB316F6uLL) >> 0),
     (VUINT32) ((0xBFEEA16A4EB316F6uLL) >> 32)},
    {(VUINT32) ((0x3C8A7D8171BF2FD8uLL) >> 0),
     (VUINT32) ((0x3C8A7D8171BF2FD8uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE6897514751DB6uLL) >> 0),
     (VUINT32) ((0xBFE6897514751DB6uLL) >> 32)},
    {(VUINT32) ((0xBC7432E085692DD0uLL) >> 0),
     (VUINT32) ((0xBC7432E085692DD0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDFBE9EE099229DuLL) >> 0),
     (VUINT32) ((0x3FDFBE9EE099229DuLL) >> 32)},
    {(VUINT32) ((0xBFF0DB94E83152C9uLL) >> 0),
     (VUINT32) ((0xBFF0DB94E83152C9uLL) >> 32)},
    {(VUINT32) ((0x3FF3D9ED602549D9uLL) >> 0),
     (VUINT32) ((0x3FF3D9ED602549D9uLL) >> 32)},
    {(VUINT32) ((0xBFF3999FCB35B63CuLL) >> 0),
     (VUINT32) ((0xBFF3999FCB35B63CuLL) >> 32)},
    {(VUINT32) ((0x3FF4F3F4BB18D34DuLL) >> 0),
     (VUINT32) ((0x3FF4F3F4BB18D34DuLL) >> 32)},
    {(VUINT32) ((0xBFF5AA9FE2712A98uLL) >> 0),
     (VUINT32) ((0xBFF5AA9FE2712A98uLL) >> 32)},
    {(VUINT32) ((0x3FF6B61F156D15A2uLL) >> 0),
     (VUINT32) ((0x3FF6B61F156D15A2uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEF05F23C0427AAuLL) >> 0),
     (VUINT32) ((0xBFEF05F23C0427AAuLL) >> 32)},
    {(VUINT32) ((0x3C51B746C796F33CuLL) >> 0),
     (VUINT32) ((0x3C51B746C796F33CuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE5F457E4F4812EuLL) >> 0),
     (VUINT32) ((0xBFE5F457E4F4812EuLL) >> 32)},
    {(VUINT32) ((0xBC8F6EE06A43AD15uLL) >> 0),
     (VUINT32) ((0xBC8F6EE06A43AD15uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDE1FFA33ABCB2DuLL) >> 0),
     (VUINT32) ((0x3FDE1FFA33ABCB2DuLL) >> 32)},
    {(VUINT32) ((0xBFF024ECA3857FDFuLL) >> 0),
     (VUINT32) ((0xBFF024ECA3857FDFuLL) >> 32)},
    {(VUINT32) ((0x3FF2EB80B3E2C969uLL) >> 0),
     (VUINT32) ((0x3FF2EB80B3E2C969uLL) >> 32)},
    {(VUINT32) ((0xBFF25CA858ECE33EuLL) >> 0),
     (VUINT32) ((0xBFF25CA858ECE33EuLL) >> 32)},
    {(VUINT32) ((0x3FF36D6159DB2BC3uLL) >> 0),
     (VUINT32) ((0x3FF36D6159DB2BC3uLL) >> 32)},
    {(VUINT32) ((0xBFF3CF427530AFAEuLL) >> 0),
     (VUINT32) ((0xBFF3CF427530AFAEuLL) >> 32)},
    {(VUINT32) ((0x3FF4914D16BF30E1uLL) >> 0),
     (VUINT32) ((0x3FF4914D16BF30E1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEF6A7A2955385EuLL) >> 0),
     (VUINT32) ((0xBFEF6A7A2955385EuLL) >> 32)},
    {(VUINT32) ((0xBC860FAFBFD97309uLL) >> 0),
     (VUINT32) ((0xBC860FAFBFD97309uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE561B82AB7F990uLL) >> 0),
     (VUINT32) ((0xBFE561B82AB7F990uLL) >> 32)},
    {(VUINT32) ((0xBC87A5FA3E37C2A5uLL) >> 0),
     (VUINT32) ((0xBC87A5FA3E37C2A5uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDC92D84170BCC6uLL) >> 0),
     (VUINT32) ((0x3FDC92D84170BCC6uLL) >> 32)},
    {(VUINT32) ((0xBFEEED87E934644CuLL) >> 0),
     (VUINT32) ((0xBFEEED87E934644CuLL) >> 32)},
    {(VUINT32) ((0x3FF20C10F4D7D072uLL) >> 0),
     (VUINT32) ((0x3FF20C10F4D7D072uLL) >> 32)},
    {(VUINT32) ((0xBFF1369E37DA5741uLL) >> 0),
     (VUINT32) ((0xBFF1369E37DA5741uLL) >> 32)},
    {(VUINT32) ((0x3FF20816F61AB3EEuLL) >> 0),
     (VUINT32) ((0x3FF20816F61AB3EEuLL) >> 32)},
    {(VUINT32) ((0xBFF221953D8712FAuLL) >> 0),
     (VUINT32) ((0xBFF221953D8712FAuLL) >> 32)},
    {(VUINT32) ((0x3FF29CA76CD56201uLL) >> 0),
     (VUINT32) ((0x3FF29CA76CD56201uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFEFCF0216A64913uLL) >> 0),
     (VUINT32) ((0xBFEFCF0216A64913uLL) >> 32)},
    {(VUINT32) ((0x3C81A9B7A75A3B87uLL) >> 0),
     (VUINT32) ((0x3C81A9B7A75A3B87uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE4D17B087B265DuLL) >> 0),
     (VUINT32) ((0xBFE4D17B087B265DuLL) >> 32)},
    {(VUINT32) ((0x3C788AAC4AE25B54uLL) >> 0),
     (VUINT32) ((0x3C788AAC4AE25B54uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FDB166A3723839CuLL) >> 0),
     (VUINT32) ((0x3FDB166A3723839CuLL) >> 32)},
    {(VUINT32) ((0xBFEDA1257F3D5E87uLL) >> 0),
     (VUINT32) ((0xBFEDA1257F3D5E87uLL) >> 32)},
    {(VUINT32) ((0x3FF13A8A70704F6BuLL) >> 0),
     (VUINT32) ((0x3FF13A8A70704F6BuLL) >> 32)},
    {(VUINT32) ((0xBFF025900612C493uLL) >> 0),
     (VUINT32) ((0xBFF025900612C493uLL) >> 32)},
    {(VUINT32) ((0x3FF0C0E778680DE8uLL) >> 0),
     (VUINT32) ((0x3FF0C0E778680DE8uLL) >> 32)},
    {(VUINT32) ((0xBFF09CB2B02DFCD5uLL) >> 0),
     (VUINT32) ((0xBFF09CB2B02DFCD5uLL) >> 32)},
    {(VUINT32) ((0x3FF0D681147681E0uLL) >> 0),
     (VUINT32) ((0x3FF0D681147681E0uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF019C501FBACE4uLL) >> 0),
     (VUINT32) ((0xBFF019C501FBACE4uLL) >> 32)},
    {(VUINT32) ((0x3C9CB18F8746F50CuLL) >> 0),
     (VUINT32) ((0x3C9CB18F8746F50CuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE44386DB9CE5DBuLL) >> 0),
     (VUINT32) ((0xBFE44386DB9CE5DBuLL) >> 32)},
    {(VUINT32) ((0x3C8A7F79AD345EDEuLL) >> 0),
     (VUINT32) ((0x3C8A7F79AD345EDEuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD9A9EE22E82AF2uLL) >> 0),
     (VUINT32) ((0x3FD9A9EE22E82AF2uLL) >> 32)},
    {(VUINT32) ((0xBFEC63B53FACFD1BuLL) >> 0),
     (VUINT32) ((0xBFEC63B53FACFD1BuLL) >> 32)},
    {(VUINT32) ((0x3FF075F0B010F1C9uLL) >> 0),
     (VUINT32) ((0x3FF075F0B010F1C9uLL) >> 32)},
    {(VUINT32) ((0xBFEE4F7738A37AC1uLL) >> 0),
     (VUINT32) ((0xBFEE4F7738A37AC1uLL) >> 32)},
    {(VUINT32) ((0x3FEF29F7068A6E01uLL) >> 0),
     (VUINT32) ((0x3FEF29F7068A6E01uLL) >> 32)},
    {(VUINT32) ((0xBFEE78912F3E48A3uLL) >> 0),
     (VUINT32) ((0xBFEE78912F3E48A3uLL) >> 32)},
    {(VUINT32) ((0x3FEE7DE5AD1A6D54uLL) >> 0),
     (VUINT32) ((0x3FEE7DE5AD1A6D54uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF04C08F8A4353EuLL) >> 0),
     (VUINT32) ((0xBFF04C08F8A4353EuLL) >> 32)},
    {(VUINT32) ((0x3C908E433AE0CC54uLL) >> 0),
     (VUINT32) ((0x3C908E433AE0CC54uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE3B7C3289ED6F3uLL) >> 0),
     (VUINT32) ((0xBFE3B7C3289ED6F3uLL) >> 32)},
    {(VUINT32) ((0x3C8C4CF3D3282C13uLL) >> 0),
     (VUINT32) ((0x3C8C4CF3D3282C13uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD84CAE0A06DE7CuLL) >> 0),
     (VUINT32) ((0x3FD84CAE0A06DE7CuLL) >> 32)},
    {(VUINT32) ((0xBFEB344C2E4C0F47uLL) >> 0),
     (VUINT32) ((0xBFEB344C2E4C0F47uLL) >> 32)},
    {(VUINT32) ((0x3FEF7AB88F5F820CuLL) >> 0),
     (VUINT32) ((0x3FEF7AB88F5F820CuLL) >> 32)},
    {(VUINT32) ((0xBFEC771219A99E98uLL) >> 0),
     (VUINT32) ((0xBFEC771219A99E98uLL) >> 32)},
    {(VUINT32) ((0x3FED0390B144EACAuLL) >> 0),
     (VUINT32) ((0x3FED0390B144EACAuLL) >> 32)},
    {(VUINT32) ((0xBFEBF90A32A17514uLL) >> 0),
     (VUINT32) ((0xBFEBF90A32A17514uLL) >> 32)},
    {(VUINT32) ((0x3FEBAC50A2919B8CuLL) >> 0),
     (VUINT32) ((0x3FEBAC50A2919B8CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF07E4CEF4CBD98uLL) >> 0),
     (VUINT32) ((0xBFF07E4CEF4CBD98uLL) >> 32)},
    {(VUINT32) ((0x3C71ABDBB9EA8E6EuLL) >> 0),
     (VUINT32) ((0x3C71ABDBB9EA8E6EuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE32E1889047FFDuLL) >> 0),
     (VUINT32) ((0xBFE32E1889047FFDuLL) >> 32)},
    {(VUINT32) ((0x3C810D08F013759CuLL) >> 0),
     (VUINT32) ((0x3C810D08F013759CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD6FDFF12A4297BuLL) >> 0),
     (VUINT32) ((0x3FD6FDFF12A4297BuLL) >> 32)},
    {(VUINT32) ((0xBFEA120FA25B9D83uLL) >> 0),
     (VUINT32) ((0xBFEA120FA25B9D83uLL) >> 32)},
    {(VUINT32) ((0x3FEE1FF1BF27E6ABuLL) >> 0),
     (VUINT32) ((0x3FEE1FF1BF27E6ABuLL) >> 32)},
    {(VUINT32) ((0xBFEABF0C6E045EA0uLL) >> 0),
     (VUINT32) ((0xBFEABF0C6E045EA0uLL) >> 32)},
    {(VUINT32) ((0x3FEB0A0E2CDCAB88uLL) >> 0),
     (VUINT32) ((0x3FEB0A0E2CDCAB88uLL) >> 32)},
    {(VUINT32) ((0xBFE9B40D41660E9DuLL) >> 0),
     (VUINT32) ((0xBFE9B40D41660E9DuLL) >> 32)},
    {(VUINT32) ((0x3FE92FCC1848D94BuLL) >> 0),
     (VUINT32) ((0x3FE92FCC1848D94BuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF0B090E5F545F2uLL) >> 0),
     (VUINT32) ((0xBFF0B090E5F545F2uLL) >> 32)},
    {(VUINT32) ((0xBC7EE15577AE1472uLL) >> 0),
     (VUINT32) ((0xBC7EE15577AE1472uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE2A6709A74F289uLL) >> 0),
     (VUINT32) ((0xBFE2A6709A74F289uLL) >> 32)},
    {(VUINT32) ((0xBC76E3B98C266662uLL) >> 0),
     (VUINT32) ((0xBC76E3B98C266662uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD5BD40BF249496uLL) >> 0),
     (VUINT32) ((0x3FD5BD40BF249496uLL) >> 32)},
    {(VUINT32) ((0xBFE8FC33EFCF6F3AuLL) >> 0),
     (VUINT32) ((0xBFE8FC33EFCF6F3AuLL) >> 32)},
    {(VUINT32) ((0x3FECDA06E4CFC822uLL) >> 0),
     (VUINT32) ((0x3FECDA06E4CFC822uLL) >> 32)},
    {(VUINT32) ((0xBFE924C5BA1C7515uLL) >> 0),
     (VUINT32) ((0xBFE924C5BA1C7515uLL) >> 32)},
    {(VUINT32) ((0x3FE9395A86CEDBCBuLL) >> 0),
     (VUINT32) ((0x3FE9395A86CEDBCBuLL) >> 32)},
    {(VUINT32) ((0xBFE7A39B6931C7D4uLL) >> 0),
     (VUINT32) ((0xBFE7A39B6931C7D4uLL) >> 32)},
    {(VUINT32) ((0x3FE6D875BED7A2F5uLL) >> 0),
     (VUINT32) ((0x3FE6D875BED7A2F5uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF0E2D4DC9DCE4CuLL) >> 0),
     (VUINT32) ((0xBFF0E2D4DC9DCE4CuLL) >> 32)},
    {(VUINT32) ((0xBC93DBA1AA51ADD5uLL) >> 0),
     (VUINT32) ((0xBC93DBA1AA51ADD5uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE220B5EF047825uLL) >> 0),
     (VUINT32) ((0xBFE220B5EF047825uLL) >> 32)},
    {(VUINT32) ((0xBC5AE1F6C712B338uLL) >> 0),
     (VUINT32) ((0xBC5AE1F6C712B338uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD489DC399ADDECuLL) >> 0),
     (VUINT32) ((0x3FD489DC399ADDECuLL) >> 32)},
    {(VUINT32) ((0xBFE7F1FB2FEBE8C6uLL) >> 0),
     (VUINT32) ((0xBFE7F1FB2FEBE8C6uLL) >> 32)},
    {(VUINT32) ((0x3FEBA791734D6CCEuLL) >> 0),
     (VUINT32) ((0x3FEBA791734D6CCEuLL) >> 32)},
    {(VUINT32) ((0xBFE7A5DA56BAB9DAuLL) >> 0),
     (VUINT32) ((0xBFE7A5DA56BAB9DAuLL) >> 32)},
    {(VUINT32) ((0x3FE78DC9A17C17D7uLL) >> 0),
     (VUINT32) ((0x3FE78DC9A17C17D7uLL) >> 32)},
    {(VUINT32) ((0xBFE5C262725357AEuLL) >> 0),
     (VUINT32) ((0xBFE5C262725357AEuLL) >> 32)},
    {(VUINT32) ((0x3FE4D1FE58052A5FuLL) >> 0),
     (VUINT32) ((0x3FE4D1FE58052A5FuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF11518D34656A6uLL) >> 0),
     (VUINT32) ((0xBFF11518D34656A6uLL) >> 32)},
    {(VUINT32) ((0xBC9FFEEDF6B7D68DuLL) >> 0),
     (VUINT32) ((0xBC9FFEEDF6B7D68DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE19CD3FE8E405DuLL) >> 0),
     (VUINT32) ((0xBFE19CD3FE8E405DuLL) >> 32)},
    {(VUINT32) ((0x3C84E5C1D4831B21uLL) >> 0),
     (VUINT32) ((0x3C84E5C1D4831B21uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD36343ADCAF866uLL) >> 0),
     (VUINT32) ((0x3FD36343ADCAF866uLL) >> 32)},
    {(VUINT32) ((0xBFE6F2B4260FF6A8uLL) >> 0),
     (VUINT32) ((0xBFE6F2B4260FF6A8uLL) >> 32)},
    {(VUINT32) ((0x3FEA8747864942E1uLL) >> 0),
     (VUINT32) ((0x3FEA8747864942E1uLL) >> 32)},
    {(VUINT32) ((0xBFE6401D47362936uLL) >> 0),
     (VUINT32) ((0xBFE6401D47362936uLL) >> 32)},
    {(VUINT32) ((0x3FE6040F50A52FBEuLL) >> 0),
     (VUINT32) ((0x3FE6040F50A52FBEuLL) >> 32)},
    {(VUINT32) ((0xBFE40BA6192CC675uLL) >> 0),
     (VUINT32) ((0xBFE40BA6192CC675uLL) >> 32)},
    {(VUINT32) ((0x3FE302E7DABA2D8EuLL) >> 0),
     (VUINT32) ((0x3FE302E7DABA2D8EuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF1475CC9EEDF01uLL) >> 0),
     (VUINT32) ((0xBFF1475CC9EEDF01uLL) >> 32)},
    {(VUINT32) ((0x3C93DDC5BCE200BBuLL) >> 0),
     (VUINT32) ((0x3C93DDC5BCE200BBuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE11AB7190834ECuLL) >> 0),
     (VUINT32) ((0xBFE11AB7190834ECuLL) >> 32)},
    {(VUINT32) ((0x3C8E577A07DB8B3EuLL) >> 0),
     (VUINT32) ((0x3C8E577A07DB8B3EuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD248F1B07217E3uLL) >> 0),
     (VUINT32) ((0x3FD248F1B07217E3uLL) >> 32)},
    {(VUINT32) ((0xBFE5FDB93DD01D06uLL) >> 0),
     (VUINT32) ((0xBFE5FDB93DD01D06uLL) >> 32)},
    {(VUINT32) ((0x3FE977F956462152uLL) >> 0),
     (VUINT32) ((0x3FE977F956462152uLL) >> 32)},
    {(VUINT32) ((0xBFE4F192BE91E40AuLL) >> 0),
     (VUINT32) ((0xBFE4F192BE91E40AuLL) >> 32)},
    {(VUINT32) ((0x3FE49932EEB2A51CuLL) >> 0),
     (VUINT32) ((0x3FE49932EEB2A51CuLL) >> 32)},
    {(VUINT32) ((0xBFE27B305435DE25uLL) >> 0),
     (VUINT32) ((0xBFE27B305435DE25uLL) >> 32)},
    {(VUINT32) ((0x3FE176C2BDD3411EuLL) >> 0),
     (VUINT32) ((0x3FE176C2BDD3411EuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF179A0C097675BuLL) >> 0),
     (VUINT32) ((0xBFF179A0C097675BuLL) >> 32)},
    {(VUINT32) ((0x3C7EE9E5C1EF600DuLL) >> 0),
     (VUINT32) ((0x3C7EE9E5C1EF600DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE09A4C59BD0D4DuLL) >> 0),
     (VUINT32) ((0xBFE09A4C59BD0D4DuLL) >> 32)},
    {(VUINT32) ((0x3C451D94A7B87B10uLL) >> 0),
     (VUINT32) ((0x3C451D94A7B87B10uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD13A68B2A5E855uLL) >> 0),
     (VUINT32) ((0x3FD13A68B2A5E855uLL) >> 32)},
    {(VUINT32) ((0xBFE5126F9FD8D89FuLL) >> 0),
     (VUINT32) ((0xBFE5126F9FD8D89FuLL) >> 32)},
    {(VUINT32) ((0x3FE8788EEDC53F19uLL) >> 0),
     (VUINT32) ((0x3FE8788EEDC53F19uLL) >> 32)},
    {(VUINT32) ((0xBFE3B86B3E883B76uLL) >> 0),
     (VUINT32) ((0xBFE3B86B3E883B76uLL) >> 32)},
    {(VUINT32) ((0x3FE34A881E7F09CAuLL) >> 0),
     (VUINT32) ((0x3FE34A881E7F09CAuLL) >> 32)},
    {(VUINT32) ((0xBFE10D3EF07D1073uLL) >> 0),
     (VUINT32) ((0xBFE10D3EF07D1073uLL) >> 32)},
    {(VUINT32) ((0x3FDFEBFE6A9FE5DDuLL) >> 0),
     (VUINT32) ((0x3FDFEBFE6A9FE5DDuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF1ABE4B73FEFB5uLL) >> 0),
     (VUINT32) ((0xBFF1ABE4B73FEFB5uLL) >> 32)},
    {(VUINT32) ((0xBC71A34B6FA942D3uLL) >> 0),
     (VUINT32) ((0xBC71A34B6FA942D3uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFE01B819B5A7CF7uLL) >> 0),
     (VUINT32) ((0xBFE01B819B5A7CF7uLL) >> 32)},
    {(VUINT32) ((0xBC80BED996FB9ED6uLL) >> 0),
     (VUINT32) ((0xBC80BED996FB9ED6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FD03732803B2A4CuLL) >> 0),
     (VUINT32) ((0x3FD03732803B2A4CuLL) >> 32)},
    {(VUINT32) ((0xBFE430465B55C6C0uLL) >> 0),
     (VUINT32) ((0xBFE430465B55C6C0uLL) >> 32)},
    {(VUINT32) ((0x3FE78806185ACF72uLL) >> 0),
     (VUINT32) ((0x3FE78806185ACF72uLL) >> 32)},
    {(VUINT32) ((0xBFE292FF3DF61A34uLL) >> 0),
     (VUINT32) ((0xBFE292FF3DF61A34uLL) >> 32)},
    {(VUINT32) ((0x3FE215A449967BC2uLL) >> 0),
     (VUINT32) ((0x3FE215A449967BC2uLL) >> 32)},
    {(VUINT32) ((0xBFDF7CEF2946D3BAuLL) >> 0),
     (VUINT32) ((0xBFDF7CEF2946D3BAuLL) >> 32)},
    {(VUINT32) ((0x3FDD0F4FF3CD4465uLL) >> 0),
     (VUINT32) ((0x3FDD0F4FF3CD4465uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF1DE28ADE8780FuLL) >> 0),
     (VUINT32) ((0xBFF1DE28ADE8780FuLL) >> 32)},
    {(VUINT32) ((0xBC908C1F2850796DuLL) >> 0),
     (VUINT32) ((0xBC908C1F2850796DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDF3C8AD985D9EEuLL) >> 0),
     (VUINT32) ((0xBFDF3C8AD985D9EEuLL) >> 32)},
    {(VUINT32) ((0xBC455C31F533FF68uLL) >> 0),
     (VUINT32) ((0xBC455C31F533FF68uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCE7DBF907D8618uLL) >> 0),
     (VUINT32) ((0x3FCE7DBF907D8618uLL) >> 32)},
    {(VUINT32) ((0xBFE356B5A1D9CA5AuLL) >> 0),
     (VUINT32) ((0xBFE356B5A1D9CA5AuLL) >> 32)},
    {(VUINT32) ((0x3FE6A57085697F99uLL) >> 0),
     (VUINT32) ((0x3FE6A57085697F99uLL) >> 32)},
    {(VUINT32) ((0xBFE17FCB46BE280BuLL) >> 0),
     (VUINT32) ((0xBFE17FCB46BE280BuLL) >> 32)},
    {(VUINT32) ((0x3FE0F858275BAA48uLL) >> 0),
     (VUINT32) ((0x3FE0F858275BAA48uLL) >> 32)},
    {(VUINT32) ((0xBFDD17B47CA8A84BuLL) >> 0),
     (VUINT32) ((0xBFDD17B47CA8A84BuLL) >> 32)},
    {(VUINT32) ((0x3FDA9B369A707A6BuLL) >> 0),
     (VUINT32) ((0x3FDA9B369A707A6BuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF2106CA4910069uLL) >> 0),
     (VUINT32) ((0xBFF2106CA4910069uLL) >> 32)},
    {(VUINT32) ((0xBC9CAF6B74B6A225uLL) >> 0),
     (VUINT32) ((0xBC9CAF6B74B6A225uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDE450E0D273E7AuLL) >> 0),
     (VUINT32) ((0xBFDE450E0D273E7AuLL) >> 32)},
    {(VUINT32) ((0xBC74138BBC4225C5uLL) >> 0),
     (VUINT32) ((0xBC74138BBC4225C5uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCCA20F5D4879EAuLL) >> 0),
     (VUINT32) ((0x3FCCA20F5D4879EAuLL) >> 32)},
    {(VUINT32) ((0xBFE2853E13FBB7C7uLL) >> 0),
     (VUINT32) ((0xBFE2853E13FBB7C7uLL) >> 32)},
    {(VUINT32) ((0x3FE5CFF21905E477uLL) >> 0),
     (VUINT32) ((0x3FE5CFF21905E477uLL) >> 32)},
    {(VUINT32) ((0xBFE07D6C7D0DAC66uLL) >> 0),
     (VUINT32) ((0xBFE07D6C7D0DAC66uLL) >> 32)},
    {(VUINT32) ((0x3FDFE1550F550217uLL) >> 0),
     (VUINT32) ((0x3FDFE1550F550217uLL) >> 32)},
    {(VUINT32) ((0xBFDAE570CE7F6BE5uLL) >> 0),
     (VUINT32) ((0xBFDAE570CE7F6BE5uLL) >> 32)},
    {(VUINT32) ((0x3FD89328A3AB7677uLL) >> 0),
     (VUINT32) ((0x3FD89328A3AB7677uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF242B09B3988C4uLL) >> 0),
     (VUINT32) ((0xBFF242B09B3988C4uLL) >> 32)},
    {(VUINT32) ((0x3C972D483EE33523uLL) >> 0),
     (VUINT32) ((0x3C972D483EE33523uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDD506C82A2C800uLL) >> 0),
     (VUINT32) ((0xBFDD506C82A2C800uLL) >> 32)},
    {(VUINT32) ((0xBC6E169413DFE956uLL) >> 0),
     (VUINT32) ((0xBC6E169413DFE956uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FCADA8ECCC42C48uLL) >> 0),
     (VUINT32) ((0x3FCADA8ECCC42C48uLL) >> 32)},
    {(VUINT32) ((0xBFE1BB681D0BE8A7uLL) >> 0),
     (VUINT32) ((0xBFE1BB681D0BE8A7uLL) >> 32)},
    {(VUINT32) ((0x3FE506BF662527D3uLL) >> 0),
     (VUINT32) ((0x3FE506BF662527D3uLL) >> 32)},
    {(VUINT32) ((0xBFDF153B07CB2306uLL) >> 0),
     (VUINT32) ((0xBFDF153B07CB2306uLL) >> 32)},
    {(VUINT32) ((0x3FDDF9A636394DCAuLL) >> 0),
     (VUINT32) ((0x3FDDF9A636394DCAuLL) >> 32)},
    {(VUINT32) ((0xBFD8E153A4A7867FuLL) >> 0),
     (VUINT32) ((0xBFD8E153A4A7867FuLL) >> 32)},
    {(VUINT32) ((0x3FD6937B37976C23uLL) >> 0),
     (VUINT32) ((0x3FD6937B37976C23uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF274F491E2111EuLL) >> 0),
     (VUINT32) ((0xBFF274F491E2111EuLL) >> 32)},
    {(VUINT32) ((0x3C8613F7E4FA18D6uLL) >> 0),
     (VUINT32) ((0x3C8613F7E4FA18D6uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDC5E87185E67B6uLL) >> 0),
     (VUINT32) ((0xBFDC5E87185E67B6uLL) >> 32)},
    {(VUINT32) ((0xBC4FEBA1F148ADA8uLL) >> 0),
     (VUINT32) ((0xBC4FEBA1F148ADA8uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC92683A68EB5D0uLL) >> 0),
     (VUINT32) ((0x3FC92683A68EB5D0uLL) >> 32)},
    {(VUINT32) ((0xBFE0F8C35C7247C7uLL) >> 0),
     (VUINT32) ((0xBFE0F8C35C7247C7uLL) >> 32)},
    {(VUINT32) ((0x3FE4491C4DCA262EuLL) >> 0),
     (VUINT32) ((0x3FE4491C4DCA262EuLL) >> 32)},
    {(VUINT32) ((0xBFDD4C67683395D6uLL) >> 0),
     (VUINT32) ((0xBFDD4C67683395D6uLL) >> 32)},
    {(VUINT32) ((0x3FDC3667C15EBF92uLL) >> 0),
     (VUINT32) ((0x3FDC3667C15EBF92uLL) >> 32)},
    {(VUINT32) ((0xBFD7070B7FE443D3uLL) >> 0),
     (VUINT32) ((0xBFD7070B7FE443D3uLL) >> 32)},
    {(VUINT32) ((0x3FD4805841790B6EuLL) >> 0),
     (VUINT32) ((0x3FD4805841790B6EuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF2A738888A9978uLL) >> 0),
     (VUINT32) ((0xBFF2A738888A9978uLL) >> 32)},
    {(VUINT32) ((0xBC5195059E91C4D2uLL) >> 0),
     (VUINT32) ((0xBC5195059E91C4D2uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDB6F3FC8C61E5BuLL) >> 0),
     (VUINT32) ((0xBFDB6F3FC8C61E5BuLL) >> 32)},
    {(VUINT32) ((0x3C6A1CC48268287AuLL) >> 0),
     (VUINT32) ((0x3C6A1CC48268287AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC7853E65CE5524uLL) >> 0),
     (VUINT32) ((0x3FC7853E65CE5524uLL) >> 32)},
    {(VUINT32) ((0xBFE03CE61B6A9E63uLL) >> 0),
     (VUINT32) ((0xBFE03CE61B6A9E63uLL) >> 32)},
    {(VUINT32) ((0x3FE3965ABF5C8FABuLL) >> 0),
     (VUINT32) ((0x3FE3965ABF5C8FABuLL) >> 32)},
    {(VUINT32) ((0xBFDB9E3938F261E9uLL) >> 0),
     (VUINT32) ((0xBFDB9E3938F261E9uLL) >> 32)},
    {(VUINT32) ((0x3FDA94A771ED6FE5uLL) >> 0),
     (VUINT32) ((0x3FDA94A771ED6FE5uLL) >> 32)},
    {(VUINT32) ((0xBFD552B7D4636646uLL) >> 0),
     (VUINT32) ((0xBFD552B7D4636646uLL) >> 32)},
    {(VUINT32) ((0x3FD2F58F20A0FA49uLL) >> 0),
     (VUINT32) ((0x3FD2F58F20A0FA49uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF2D97C7F3321D2uLL) >> 0),
     (VUINT32) ((0xBFF2D97C7F3321D2uLL) >> 32)},
    {(VUINT32) ((0xBC8A79394C9E8A0AuLL) >> 0),
     (VUINT32) ((0xBC8A79394C9E8A0AuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFDA827999FCEF32uLL) >> 0),
     (VUINT32) ((0xBFDA827999FCEF32uLL) >> 32)},
    {(VUINT32) ((0xBC708A11019E41CEuLL) >> 0),
     (VUINT32) ((0xBC708A11019E41CEuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC5F619980C4336uLL) >> 0),
     (VUINT32) ((0x3FC5F619980C4336uLL) >> 32)},
    {(VUINT32) ((0xBFDF0ED99BED9B65uLL) >> 0),
     (VUINT32) ((0xBFDF0ED99BED9B65uLL) >> 32)},
    {(VUINT32) ((0x3FE2EDD996C1BBEBuLL) >> 0),
     (VUINT32) ((0x3FE2EDD996C1BBEBuLL) >> 32)},
    {(VUINT32) ((0xBFDA08B785C6EA59uLL) >> 0),
     (VUINT32) ((0xBFDA08B785C6EA59uLL) >> 32)},
    {(VUINT32) ((0x3FD911BC7B12902FuLL) >> 0),
     (VUINT32) ((0x3FD911BC7B12902FuLL) >> 32)},
    {(VUINT32) ((0xBFD3C0DA5B1130C3uLL) >> 0),
     (VUINT32) ((0xBFD3C0DA5B1130C3uLL) >> 32)},
    {(VUINT32) ((0x3FD1B590151D6334uLL) >> 0),
     (VUINT32) ((0x3FD1B590151D6334uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF30BC075DBAA2CuLL) >> 0),
     (VUINT32) ((0xBFF30BC075DBAA2CuLL) >> 32)},
    {(VUINT32) ((0xBC995FE8F2B56DBDuLL) >> 0),
     (VUINT32) ((0xBC995FE8F2B56DBDuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD998188E816BF0uLL) >> 0),
     (VUINT32) ((0xBFD998188E816BF0uLL) >> 32)},
    {(VUINT32) ((0xBC73DB2BD13E0A0CuLL) >> 0),
     (VUINT32) ((0xBC73DB2BD13E0A0CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC478794806DE66uLL) >> 0),
     (VUINT32) ((0x3FC478794806DE66uLL) >> 32)},
    {(VUINT32) ((0xBFDDAFF33BF96274uLL) >> 0),
     (VUINT32) ((0xBFDDAFF33BF96274uLL) >> 32)},
    {(VUINT32) ((0x3FE24F039543C659uLL) >> 0),
     (VUINT32) ((0x3FE24F039543C659uLL) >> 32)},
    {(VUINT32) ((0xBFD88A113E071D2DuLL) >> 0),
     (VUINT32) ((0xBFD88A113E071D2DuLL) >> 32)},
    {(VUINT32) ((0x3FD7AB3E661E65F9uLL) >> 0),
     (VUINT32) ((0x3FD7AB3E661E65F9uLL) >> 32)},
    {(VUINT32) ((0xBFD24E4E1B8DC6CDuLL) >> 0),
     (VUINT32) ((0xBFD24E4E1B8DC6CDuLL) >> 32)},
    {(VUINT32) ((0x3FD01ED5FCAC7FDDuLL) >> 0),
     (VUINT32) ((0x3FD01ED5FCAC7FDDuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF33E046C843287uLL) >> 0),
     (VUINT32) ((0xBFF33E046C843287uLL) >> 32)},
    {(VUINT32) ((0x3C9A7CCAC0E4698BuLL) >> 0),
     (VUINT32) ((0x3C9A7CCAC0E4698BuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD8B00196B3D022uLL) >> 0),
     (VUINT32) ((0xBFD8B00196B3D022uLL) >> 32)},
    {(VUINT32) ((0x3C67341EE30455A6uLL) >> 0),
     (VUINT32) ((0x3C67341EE30455A6uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC30BCA73878656uLL) >> 0),
     (VUINT32) ((0x3FC30BCA73878656uLL) >> 32)},
    {(VUINT32) ((0xBFDC5C67FF403B73uLL) >> 0),
     (VUINT32) ((0xBFDC5C67FF403B73uLL) >> 32)},
    {(VUINT32) ((0x3FE1B94E72981059uLL) >> 0),
     (VUINT32) ((0x3FE1B94E72981059uLL) >> 32)},
    {(VUINT32) ((0xBFD7209990BAE1F6uLL) >> 0),
     (VUINT32) ((0xBFD7209990BAE1F6uLL) >> 32)},
    {(VUINT32) ((0x3FD65EF72AC3A4F8uLL) >> 0),
     (VUINT32) ((0x3FD65EF72AC3A4F8uLL) >> 32)},
    {(VUINT32) ((0xBFD0F83D8377C34BuLL) >> 0),
     (VUINT32) ((0xBFD0F83D8377C34BuLL) >> 32)},
    {(VUINT32) ((0x3FCD97555AF6144CuLL) >> 0),
     (VUINT32) ((0x3FCD97555AF6144CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF37048632CBAE1uLL) >> 0),
     (VUINT32) ((0xBFF37048632CBAE1uLL) >> 32)},
    {(VUINT32) ((0x3C8CB2FCE8FC81A5uLL) >> 0),
     (VUINT32) ((0x3C8CB2FCE8FC81A5uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD7CA1A832D0F84uLL) >> 0),
     (VUINT32) ((0xBFD7CA1A832D0F84uLL) >> 32)},
    {(VUINT32) ((0x3C7EE5A712091434uLL) >> 0),
     (VUINT32) ((0x3C7EE5A712091434uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC1AF828B5ED674uLL) >> 0),
     (VUINT32) ((0x3FC1AF828B5ED674uLL) >> 32)},
    {(VUINT32) ((0xBFDB13909C0269A2uLL) >> 0),
     (VUINT32) ((0xBFDB13909C0269A2uLL) >> 32)},
    {(VUINT32) ((0x3FE12C3A0394B7FAuLL) >> 0),
     (VUINT32) ((0x3FE12C3A0394B7FAuLL) >> 32)},
    {(VUINT32) ((0xBFD5CAC4A421216CuLL) >> 0),
     (VUINT32) ((0xBFD5CAC4A421216CuLL) >> 32)},
    {(VUINT32) ((0x3FD52AE625505252uLL) >> 0),
     (VUINT32) ((0x3FD52AE625505252uLL) >> 32)},
    {(VUINT32) ((0xBFCF7831018A616AuLL) >> 0),
     (VUINT32) ((0xBFCF7831018A616AuLL) >> 32)},
    {(VUINT32) ((0x3FCB98AB42F62940uLL) >> 0),
     (VUINT32) ((0x3FCB98AB42F62940uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF3A28C59D5433BuLL) >> 0),
     (VUINT32) ((0xBFF3A28C59D5433BuLL) >> 32)},
    {(VUINT32) ((0x3C61B19140C0C0D5uLL) >> 0),
     (VUINT32) ((0x3C61B19140C0C0D5uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD6E649F7D78649uLL) >> 0),
     (VUINT32) ((0xBFD6E649F7D78649uLL) >> 32)},
    {(VUINT32) ((0xBC678D2AC0322984uLL) >> 0),
     (VUINT32) ((0xBC678D2AC0322984uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FC0631EFCBE0D16uLL) >> 0),
     (VUINT32) ((0x3FC0631EFCBE0D16uLL) >> 32)},
    {(VUINT32) ((0xBFD9D4CEDF38DFCDuLL) >> 0),
     (VUINT32) ((0xBFD9D4CEDF38DFCDuLL) >> 32)},
    {(VUINT32) ((0x3FE0A74F7488C3A6uLL) >> 0),
     (VUINT32) ((0x3FE0A74F7488C3A6uLL) >> 32)},
    {(VUINT32) ((0xBFD487249EA3BD6CuLL) >> 0),
     (VUINT32) ((0xBFD487249EA3BD6CuLL) >> 32)},
    {(VUINT32) ((0x3FD40D3A9BDEFA27uLL) >> 0),
     (VUINT32) ((0x3FD40D3A9BDEFA27uLL) >> 32)},
    {(VUINT32) ((0xBFCD2F1CBD1B58CDuLL) >> 0),
     (VUINT32) ((0xBFCD2F1CBD1B58CDuLL) >> 32)},
    {(VUINT32) ((0x3FC98CBDCEBDAD19uLL) >> 0),
     (VUINT32) ((0x3FC98CBDCEBDAD19uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF3D4D0507DCB95uLL) >> 0),
     (VUINT32) ((0xBFF3D4D0507DCB95uLL) >> 32)},
    {(VUINT32) ((0xBC83DA34489C213BuLL) >> 0),
     (VUINT32) ((0xBC83DA34489C213BuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD604775FBB27DFuLL) >> 0),
     (VUINT32) ((0xBFD604775FBB27DFuLL) >> 32)},
    {(VUINT32) ((0xBC6AC647C9CF0A4CuLL) >> 0),
     (VUINT32) ((0xBC6AC647C9CF0A4CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBE4C49866D2D78uLL) >> 0),
     (VUINT32) ((0x3FBE4C49866D2D78uLL) >> 32)},
    {(VUINT32) ((0xBFD89F8D033946D5uLL) >> 0),
     (VUINT32) ((0xBFD89F8D033946D5uLL) >> 32)},
    {(VUINT32) ((0x3FE02A20954EE23AuLL) >> 0),
     (VUINT32) ((0x3FE02A20954EE23AuLL) >> 32)},
    {(VUINT32) ((0xBFD35466F88C5ABCuLL) >> 0),
     (VUINT32) ((0xBFD35466F88C5ABCuLL) >> 32)},
    {(VUINT32) ((0x3FD3044BAC5DC8C6uLL) >> 0),
     (VUINT32) ((0x3FD3044BAC5DC8C6uLL) >> 32)},
    {(VUINT32) ((0xBFCB110C3D6FEB70uLL) >> 0),
     (VUINT32) ((0xBFCB110C3D6FEB70uLL) >> 32)},
    {(VUINT32) ((0x3FC7761A8DC12688uLL) >> 0),
     (VUINT32) ((0x3FC7761A8DC12688uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF40714472653EFuLL) >> 0),
     (VUINT32) ((0xBFF40714472653EFuLL) >> 32)},
    {(VUINT32) ((0xBC96106670B43955uLL) >> 0),
     (VUINT32) ((0xBC96106670B43955uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD5248AE1701B17uLL) >> 0),
     (VUINT32) ((0xBFD5248AE1701B17uLL) >> 32)},
    {(VUINT32) ((0xBC7BE8CC944DAFEAuLL) >> 0),
     (VUINT32) ((0xBC7BE8CC944DAFEAuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FBBF04005723CCCuLL) >> 0),
     (VUINT32) ((0x3FBBF04005723CCCuLL) >> 32)},
    {(VUINT32) ((0xBFD7733D1300258AuLL) >> 0),
     (VUINT32) ((0xBFD7733D1300258AuLL) >> 32)},
    {(VUINT32) ((0x3FDF688E6ACC7DF5uLL) >> 0),
     (VUINT32) ((0x3FDF688E6ACC7DF5uLL) >> 32)},
    {(VUINT32) ((0xBFD231520EA793C8uLL) >> 0),
     (VUINT32) ((0xBFD231520EA793C8uLL) >> 32)},
    {(VUINT32) ((0x3FD20E93C5183A34uLL) >> 0),
     (VUINT32) ((0x3FD20E93C5183A34uLL) >> 32)},
    {(VUINT32) ((0xBFC91A331D55B3F7uLL) >> 0),
     (VUINT32) ((0xBFC91A331D55B3F7uLL) >> 32)},
    {(VUINT32) ((0x3FC651721E1371DDuLL) >> 0),
     (VUINT32) ((0x3FC651721E1371DDuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF439583DCEDC4AuLL) >> 0),
     (VUINT32) ((0xBFF439583DCEDC4AuLL) >> 32)},
    {(VUINT32) ((0x3C9DCC4D42E59DF2uLL) >> 0),
     (VUINT32) ((0x3C9DCC4D42E59DF2uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD4466D542BAC92uLL) >> 0),
     (VUINT32) ((0xBFD4466D542BAC92uLL) >> 32)},
    {(VUINT32) ((0x3C705073A04E444AuLL) >> 0),
     (VUINT32) ((0x3C705073A04E444AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB9B14751F8BA20uLL) >> 0),
     (VUINT32) ((0x3FB9B14751F8BA20uLL) >> 32)},
    {(VUINT32) ((0xBFD64F58590170A2uLL) >> 0),
     (VUINT32) ((0xBFD64F58590170A2uLL) >> 32)},
    {(VUINT32) ((0x3FDE8AC91D15CFCFuLL) >> 0),
     (VUINT32) ((0x3FDE8AC91D15CFCFuLL) >> 32)},
    {(VUINT32) ((0xBFD11CC2EF09C664uLL) >> 0),
     (VUINT32) ((0xBFD11CC2EF09C664uLL) >> 32)},
    {(VUINT32) ((0x3FD12AB5AB65B965uLL) >> 0),
     (VUINT32) ((0x3FD12AB5AB65B965uLL) >> 32)},
    {(VUINT32) ((0xBFC7471C9AC81567uLL) >> 0),
     (VUINT32) ((0xBFC7471C9AC81567uLL) >> 32)},
    {(VUINT32) ((0x3FC4826BA97C3E69uLL) >> 0),
     (VUINT32) ((0x3FC4826BA97C3E69uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF46B9C347764A4uLL) >> 0),
     (VUINT32) ((0xBFF46B9C347764A4uLL) >> 32)},
    {(VUINT32) ((0x3C91A900F67F753AuLL) >> 0),
     (VUINT32) ((0x3C91A900F67F753AuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD36A08355C63DCuLL) >> 0),
     (VUINT32) ((0xBFD36A08355C63DCuLL) >> 32)},
    {(VUINT32) ((0x3C6D7145B6A10D86uLL) >> 0),
     (VUINT32) ((0x3C6D7145B6A10D86uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB78E922B82AB64uLL) >> 0),
     (VUINT32) ((0x3FB78E922B82AB64uLL) >> 32)},
    {(VUINT32) ((0xBFD5335ED87AB0D5uLL) >> 0),
     (VUINT32) ((0xBFD5335ED87AB0D5uLL) >> 32)},
    {(VUINT32) ((0x3FDDBA417913D89CuLL) >> 0),
     (VUINT32) ((0x3FDDBA417913D89CuLL) >> 32)},
    {(VUINT32) ((0xBFD015AB59BD876BuLL) >> 0),
     (VUINT32) ((0xBFD015AB59BD876BuLL) >> 32)},
    {(VUINT32) ((0x3FD0576D1EF5DB85uLL) >> 0),
     (VUINT32) ((0x3FD0576D1EF5DB85uLL) >> 32)},
    {(VUINT32) ((0xBFC594A6DD2CA17DuLL) >> 0),
     (VUINT32) ((0xBFC594A6DD2CA17DuLL) >> 32)},
    {(VUINT32) ((0x3FC2F51FBC1DE653uLL) >> 0),
     (VUINT32) ((0x3FC2F51FBC1DE653uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF49DE02B1FECFEuLL) >> 0),
     (VUINT32) ((0xBFF49DE02B1FECFEuLL) >> 32)},
    {(VUINT32) ((0x3C7616D2A8653209uLL) >> 0),
     (VUINT32) ((0x3C7616D2A8653209uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD28F459ECAD74DuLL) >> 0),
     (VUINT32) ((0xBFD28F459ECAD74DuLL) >> 32)},
    {(VUINT32) ((0xBC302C86D50E46C0uLL) >> 0),
     (VUINT32) ((0xBC302C86D50E46C0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB5875F92EDBDF4uLL) >> 0),
     (VUINT32) ((0x3FB5875F92EDBDF4uLL) >> 32)},
    {(VUINT32) ((0xBFD41ED6D05A0010uLL) >> 0),
     (VUINT32) ((0xBFD41ED6D05A0010uLL) >> 32)},
    {(VUINT32) ((0x3FDCF65481FC5BEBuLL) >> 0),
     (VUINT32) ((0x3FDCF65481FC5BEBuLL) >> 32)},
    {(VUINT32) ((0xBFCE361FE028368DuLL) >> 0),
     (VUINT32) ((0xBFCE361FE028368DuLL) >> 32)},
    {(VUINT32) ((0x3FCF2728B941710BuLL) >> 0),
     (VUINT32) ((0x3FCF2728B941710BuLL) >> 32)},
    {(VUINT32) ((0xBFC3FFF674960878uLL) >> 0),
     (VUINT32) ((0xBFC3FFF674960878uLL) >> 32)},
    {(VUINT32) ((0x3FC1A12109F12125uLL) >> 0),
     (VUINT32) ((0x3FC1A12109F12125uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF4D02421C87558uLL) >> 0),
     (VUINT32) ((0xBFF4D02421C87558uLL) >> 32)},
    {(VUINT32) ((0xBC7A765E893370D7uLL) >> 0),
     (VUINT32) ((0xBC7A765E893370D7uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD1B6103D3597E9uLL) >> 0),
     (VUINT32) ((0xBFD1B6103D3597E9uLL) >> 32)},
    {(VUINT32) ((0xBC6CBCB5FED7AC2CuLL) >> 0),
     (VUINT32) ((0xBC6CBCB5FED7AC2CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB39AFA3392E164uLL) >> 0),
     (VUINT32) ((0x3FB39AFA3392E164uLL) >> 32)},
    {(VUINT32) ((0xBFD3114C46E2AEF3uLL) >> 0),
     (VUINT32) ((0xBFD3114C46E2AEF3uLL) >> 32)},
    {(VUINT32) ((0x3FDC3E6B23EF73B5uLL) >> 0),
     (VUINT32) ((0x3FDC3E6B23EF73B5uLL) >> 32)},
    {(VUINT32) ((0xBFCC580D1B42EE7FuLL) >> 0),
     (VUINT32) ((0xBFCC580D1B42EE7FuLL) >> 32)},
    {(VUINT32) ((0x3FCDBC3D6E14D202uLL) >> 0),
     (VUINT32) ((0x3FCDBC3D6E14D202uLL) >> 32)},
    {(VUINT32) ((0xBFC28671B66B7EC4uLL) >> 0),
     (VUINT32) ((0xBFC28671B66B7EC4uLL) >> 32)},
    {(VUINT32) ((0x3FC0BFBCFE62E275uLL) >> 0),
     (VUINT32) ((0x3FC0BFBCFE62E275uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF502681870FDB2uLL) >> 0),
     (VUINT32) ((0xBFF502681870FDB2uLL) >> 32)},
    {(VUINT32) ((0xBC92C0E3EEB304EEuLL) >> 0),
     (VUINT32) ((0xBC92C0E3EEB304EEuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD0DE53475F3B3CuLL) >> 0),
     (VUINT32) ((0xBFD0DE53475F3B3CuLL) >> 32)},
    {(VUINT32) ((0xBC67B2CC0A839654uLL) >> 0),
     (VUINT32) ((0xBC67B2CC0A839654uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB1C8B7D76C7EE0uLL) >> 0),
     (VUINT32) ((0x3FB1C8B7D76C7EE0uLL) >> 32)},
    {(VUINT32) ((0xBFD20A509D4BB6C1uLL) >> 0),
     (VUINT32) ((0xBFD20A509D4BB6C1uLL) >> 32)},
    {(VUINT32) ((0x3FDB91F96510DF38uLL) >> 0),
     (VUINT32) ((0x3FDB91F96510DF38uLL) >> 32)},
    {(VUINT32) ((0xBFCA8F698D62832EuLL) >> 0),
     (VUINT32) ((0xBFCA8F698D62832EuLL) >> 32)},
    {(VUINT32) ((0x3FCC6C3408291325uLL) >> 0),
     (VUINT32) ((0x3FCC6C3408291325uLL) >> 32)},
    {(VUINT32) ((0xBFC125B6D8F69817uLL) >> 0),
     (VUINT32) ((0xBFC125B6D8F69817uLL) >> 32)},
    {(VUINT32) ((0x3FBE80E8F3B35090uLL) >> 0),
     (VUINT32) ((0x3FBE80E8F3B35090uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF534AC0F19860CuLL) >> 0),
     (VUINT32) ((0xBFF534AC0F19860CuLL) >> 32)},
    {(VUINT32) ((0xBC9EE4303B192DA6uLL) >> 0),
     (VUINT32) ((0xBC9EE4303B192DA6uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFD007FA758626AEuLL) >> 0),
     (VUINT32) ((0xBFD007FA758626AEuLL) >> 32)},
    {(VUINT32) ((0xBC65A5EB9CA4F97AuLL) >> 0),
     (VUINT32) ((0xBC65A5EB9CA4F97AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FB00FF8E583BEBCuLL) >> 0),
     (VUINT32) ((0x3FB00FF8E583BEBCuLL) >> 32)},
    {(VUINT32) ((0xBFD1097A2AA570F5uLL) >> 0),
     (VUINT32) ((0xBFD1097A2AA570F5uLL) >> 32)},
    {(VUINT32) ((0x3FDAF07DA8CAEBA7uLL) >> 0),
     (VUINT32) ((0x3FDAF07DA8CAEBA7uLL) >> 32)},
    {(VUINT32) ((0xBFC8DA9D107525ADuLL) >> 0),
     (VUINT32) ((0xBFC8DA9D107525ADuLL) >> 32)},
    {(VUINT32) ((0x3FCB3545F2ADC1DBuLL) >> 0),
     (VUINT32) ((0x3FCB3545F2ADC1DBuLL) >> 32)},
    {(VUINT32) ((0xBFBFB739DB46589AuLL) >> 0),
     (VUINT32) ((0xBFBFB739DB46589AuLL) >> 32)},
    {(VUINT32) ((0x3FBDA2C2374E7733uLL) >> 0),
     (VUINT32) ((0x3FBDA2C2374E7733uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF566F005C20E67uLL) >> 0),
     (VUINT32) ((0xBFF566F005C20E67uLL) >> 32)},
    {(VUINT32) ((0x3C94F8837880A9A2uLL) >> 0),
     (VUINT32) ((0x3C94F8837880A9A2uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCE65E3F27C9F2AuLL) >> 0),
     (VUINT32) ((0xBFCE65E3F27C9F2AuLL) >> 32)},
    {(VUINT32) ((0xBC6F62A8B8B3F2A2uLL) >> 0),
     (VUINT32) ((0xBC6F62A8B8B3F2A2uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FACE04FD3EC1C90uLL) >> 0),
     (VUINT32) ((0x3FACE04FD3EC1C90uLL) >> 32)},
    {(VUINT32) ((0xBFD00E63DD639A45uLL) >> 0),
     (VUINT32) ((0xBFD00E63DD639A45uLL) >> 32)},
    {(VUINT32) ((0x3FDA598003751442uLL) >> 0),
     (VUINT32) ((0x3FDA598003751442uLL) >> 32)},
    {(VUINT32) ((0xBFC73829AC409F93uLL) >> 0),
     (VUINT32) ((0xBFC73829AC409F93uLL) >> 32)},
    {(VUINT32) ((0x3FCA15E3A26F9D69uLL) >> 0),
     (VUINT32) ((0x3FCA15E3A26F9D69uLL) >> 32)},
    {(VUINT32) ((0xBFBD4C4574E0CB3EuLL) >> 0),
     (VUINT32) ((0xBFBD4C4574E0CB3EuLL) >> 32)},
    {(VUINT32) ((0x3FBB9C588182E205uLL) >> 0),
     (VUINT32) ((0x3FBB9C588182E205uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF59933FC6A96C1uLL) >> 0),
     (VUINT32) ((0xBFF59933FC6A96C1uLL) >> 32)},
    {(VUINT32) ((0x3C81AA6E583501D4uLL) >> 0),
     (VUINT32) ((0x3C81AA6E583501D4uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCCBE4CEB4B4CF2uLL) >> 0),
     (VUINT32) ((0xBFCCBE4CEB4B4CF2uLL) >> 32)},
    {(VUINT32) ((0xBC64A514F790D588uLL) >> 0),
     (VUINT32) ((0xBC64A514F790D588uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA9D1724DE6C940uLL) >> 0),
     (VUINT32) ((0x3FA9D1724DE6C940uLL) >> 32)},
    {(VUINT32) ((0xBFCE3159C5ED3A4EuLL) >> 0),
     (VUINT32) ((0xBFCE3159C5ED3A4EuLL) >> 32)},
    {(VUINT32) ((0x3FD9CC919D4271B2uLL) >> 0),
     (VUINT32) ((0x3FD9CC919D4271B2uLL) >> 32)},
    {(VUINT32) ((0xBFC5A6A9489AA7F4uLL) >> 0),
     (VUINT32) ((0xBFC5A6A9489AA7F4uLL) >> 32)},
    {(VUINT32) ((0x3FC90C961E2B49F9uLL) >> 0),
     (VUINT32) ((0x3FC90C961E2B49F9uLL) >> 32)},
    {(VUINT32) ((0xBFBB06EE7CFA369EuLL) >> 0),
     (VUINT32) ((0xBFBB06EE7CFA369EuLL) >> 32)},
    {(VUINT32) ((0x3FB9E9447AAF378DuLL) >> 0),
     (VUINT32) ((0x3FB9E9447AAF378DuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF5CB77F3131F1BuLL) >> 0),
     (VUINT32) ((0xBFF5CB77F3131F1BuLL) >> 32)},
    {(VUINT32) ((0xBC6A70A9025D3E70uLL) >> 0),
     (VUINT32) ((0xBC6A70A9025D3E70uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFCB1909EFD8B762uLL) >> 0),
     (VUINT32) ((0xBFCB1909EFD8B762uLL) >> 32)},
    {(VUINT32) ((0xBC5843049E1318BCuLL) >> 0),
     (VUINT32) ((0xBC5843049E1318BCuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA6F2545C478E00uLL) >> 0),
     (VUINT32) ((0x3FA6F2545C478E00uLL) >> 32)},
    {(VUINT32) ((0xBFCC4FF0A9D74F70uLL) >> 0),
     (VUINT32) ((0xBFCC4FF0A9D74F70uLL) >> 32)},
    {(VUINT32) ((0x3FD9494C22EF2A54uLL) >> 0),
     (VUINT32) ((0x3FD9494C22EF2A54uLL) >> 32)},
    {(VUINT32) ((0xBFC424CB909A6722uLL) >> 0),
     (VUINT32) ((0xBFC424CB909A6722uLL) >> 32)},
    {(VUINT32) ((0x3FC8180A481D593BuLL) >> 0),
     (VUINT32) ((0x3FC8180A481D593BuLL) >> 32)},
    {(VUINT32) ((0xBFB8E3D90C36FA86uLL) >> 0),
     (VUINT32) ((0xBFB8E3D90C36FA86uLL) >> 32)},
    {(VUINT32) ((0x3FB8D27EAFEAC4D3uLL) >> 0),
     (VUINT32) ((0x3FB8D27EAFEAC4D3uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF5FDBBE9BBA775uLL) >> 0),
     (VUINT32) ((0xBFF5FDBBE9BBA775uLL) >> 32)},
    {(VUINT32) ((0xBC8EE2C2D963A10CuLL) >> 0),
     (VUINT32) ((0xBC8EE2C2D963A10CuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC975F5E0553158uLL) >> 0),
     (VUINT32) ((0xBFC975F5E0553158uLL) >> 32)},
    {(VUINT32) ((0xBC2EEEA31AB9D050uLL) >> 0),
     (VUINT32) ((0xBC2EEEA31AB9D050uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA4420303DEC550uLL) >> 0),
     (VUINT32) ((0x3FA4420303DEC550uLL) >> 32)},
    {(VUINT32) ((0xBFCA77D9D62CA610uLL) >> 0),
     (VUINT32) ((0xBFCA77D9D62CA610uLL) >> 32)},
    {(VUINT32) ((0x3FD8CF5143323608uLL) >> 0),
     (VUINT32) ((0x3FD8CF5143323608uLL) >> 32)},
    {(VUINT32) ((0xBFC2B15401455507uLL) >> 0),
     (VUINT32) ((0xBFC2B15401455507uLL) >> 32)},
    {(VUINT32) ((0x3FC7370FF096556FuLL) >> 0),
     (VUINT32) ((0x3FC7370FF096556FuLL) >> 32)},
    {(VUINT32) ((0xBFB6DFEACA56EADAuLL) >> 0),
     (VUINT32) ((0xBFB6DFEACA56EADAuLL) >> 32)},
    {(VUINT32) ((0x3FB6B75DF89EC13CuLL) >> 0),
     (VUINT32) ((0x3FB6B75DF89EC13CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF62FFFE0642FCFuLL) >> 0),
     (VUINT32) ((0xBFF62FFFE0642FCFuLL) >> 32)},
    {(VUINT32) ((0xBC9B94ADB917F93EuLL) >> 0),
     (VUINT32) ((0xBC9B94ADB917F93EuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC7D4EC54FB5968uLL) >> 0),
     (VUINT32) ((0xBFC7D4EC54FB5968uLL) >> 32)},
    {(VUINT32) ((0xBC4FB65648F8A4A0uLL) >> 0),
     (VUINT32) ((0xBC4FB65648F8A4A0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3FA1BF9C7C60B940uLL) >> 0),
     (VUINT32) ((0x3FA1BF9C7C60B940uLL) >> 32)},
    {(VUINT32) ((0xBFC8A86964A1796BuLL) >> 0),
     (VUINT32) ((0xBFC8A86964A1796BuLL) >> 32)},
    {(VUINT32) ((0x3FD85E4A37F23352uLL) >> 0),
     (VUINT32) ((0x3FD85E4A37F23352uLL) >> 32)},
    {(VUINT32) ((0xBFC14B181F5BF6AEuLL) >> 0),
     (VUINT32) ((0xBFC14B181F5BF6AEuLL) >> 32)},
    {(VUINT32) ((0x3FC66888E3A5D3BAuLL) >> 0),
     (VUINT32) ((0x3FC66888E3A5D3BAuLL) >> 32)},
    {(VUINT32) ((0xBFB4F84D7AC0F5DBuLL) >> 0),
     (VUINT32) ((0xBFB4F84D7AC0F5DBuLL) >> 32)},
    {(VUINT32) ((0x3FB62BA6F07C5587uLL) >> 0),
     (VUINT32) ((0x3FB62BA6F07C5587uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF66243D70CB82AuLL) >> 0),
     (VUINT32) ((0xBFF66243D70CB82AuLL) >> 32)},
    {(VUINT32) ((0x3C984805FA81DE0AuLL) >> 0),
     (VUINT32) ((0x3C984805FA81DE0AuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC635C990CE0D36uLL) >> 0),
     (VUINT32) ((0xBFC635C990CE0D36uLL) >> 32)},
    {(VUINT32) ((0x3C59DFC0C48C2B20uLL) >> 0),
     (VUINT32) ((0x3C59DFC0C48C2B20uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F9ED49F1F8144C0uLL) >> 0),
     (VUINT32) ((0x3F9ED49F1F8144C0uLL) >> 32)},
    {(VUINT32) ((0xBFC6E0F98ED00C32uLL) >> 0),
     (VUINT32) ((0xBFC6E0F98ED00C32uLL) >> 32)},
    {(VUINT32) ((0x3FD7F5E75A2DD66EuLL) >> 0),
     (VUINT32) ((0x3FD7F5E75A2DD66EuLL) >> 32)},
    {(VUINT32) ((0xBFBFE1FBA10F6B0EuLL) >> 0),
     (VUINT32) ((0xBFBFE1FBA10F6B0EuLL) >> 32)},
    {(VUINT32) ((0x3FC5AB7CD1905EBBuLL) >> 0),
     (VUINT32) ((0x3FC5AB7CD1905EBBuLL) >> 32)},
    {(VUINT32) ((0xBFB32A57A4FAE3FFuLL) >> 0),
     (VUINT32) ((0xBFB32A57A4FAE3FFuLL) >> 32)},
    {(VUINT32) ((0x3FB4BA60BA62CA68uLL) >> 0),
     (VUINT32) ((0x3FB4BA60BA62CA68uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF69487CDB54084uLL) >> 0),
     (VUINT32) ((0xBFF69487CDB54084uLL) >> 32)},
    {(VUINT32) ((0x3C8849735C376AA4uLL) >> 0),
     (VUINT32) ((0x3C8849735C376AA4uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC4986A74CF4E57uLL) >> 0),
     (VUINT32) ((0xBFC4986A74CF4E57uLL) >> 32)},
    {(VUINT32) ((0xBC69AB0A243914D0uLL) >> 0),
     (VUINT32) ((0xBC69AB0A243914D0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F9A82B60D75F5C0uLL) >> 0),
     (VUINT32) ((0x3F9A82B60D75F5C0uLL) >> 32)},
    {(VUINT32) ((0xBFC520EA2BA6A0AEuLL) >> 0),
     (VUINT32) ((0xBFC520EA2BA6A0AEuLL) >> 32)},
    {(VUINT32) ((0x3FD795DFBFFEE39EuLL) >> 0),
     (VUINT32) ((0x3FD795DFBFFEE39EuLL) >> 32)},
    {(VUINT32) ((0xBFBD43F3A7862CC7uLL) >> 0),
     (VUINT32) ((0xBFBD43F3A7862CC7uLL) >> 32)},
    {(VUINT32) ((0x3FC4FF04247D7006uLL) >> 0),
     (VUINT32) ((0x3FC4FF04247D7006uLL) >> 32)},
    {(VUINT32) ((0xBFB1739726786F64uLL) >> 0),
     (VUINT32) ((0xBFB1739726786F64uLL) >> 32)},
    {(VUINT32) ((0x3FB2FAC67536C2B7uLL) >> 0),
     (VUINT32) ((0x3FB2FAC67536C2B7uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF6C6CBC45DC8DEuLL) >> 0),
     (VUINT32) ((0xBFF6C6CBC45DC8DEuLL) >> 32)},
    {(VUINT32) ((0x3BD6D61B58C99C43uLL) >> 0),
     (VUINT32) ((0x3BD6D61B58C99C43uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC2FCAC73A60640uLL) >> 0),
     (VUINT32) ((0xBFC2FCAC73A60640uLL) >> 32)},
    {(VUINT32) ((0xBC52CF95F70D438CuLL) >> 0),
     (VUINT32) ((0xBC52CF95F70D438CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F96881A43B33590uLL) >> 0),
     (VUINT32) ((0x3F96881A43B33590uLL) >> 32)},
    {(VUINT32) ((0xBFC367A033B52F5EuLL) >> 0),
     (VUINT32) ((0xBFC367A033B52F5EuLL) >> 32)},
    {(VUINT32) ((0x3FD73DF0E3CC557AuLL) >> 0),
     (VUINT32) ((0x3FD73DF0E3CC557AuLL) >> 32)},
    {(VUINT32) ((0xBFBABA1CAC4F18CDuLL) >> 0),
     (VUINT32) ((0xBFBABA1CAC4F18CDuLL) >> 32)},
    {(VUINT32) ((0x3FC4624C36BE941DuLL) >> 0),
     (VUINT32) ((0x3FC4624C36BE941DuLL) >> 32)},
    {(VUINT32) ((0xBFAFA38B2F88747DuLL) >> 0),
     (VUINT32) ((0xBFAFA38B2F88747DuLL) >> 32)},
    {(VUINT32) ((0x3FB215B1F402C9E1uLL) >> 0),
     (VUINT32) ((0x3FB215B1F402C9E1uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF6F90FBB065138uLL) >> 0),
     (VUINT32) ((0xBFF6F90FBB065138uLL) >> 32)},
    {(VUINT32) ((0xBC8843BDD561383DuLL) >> 0),
     (VUINT32) ((0xBC8843BDD561383DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFC1626D85A91E70uLL) >> 0),
     (VUINT32) ((0xBFC1626D85A91E70uLL) >> 32)},
    {(VUINT32) ((0x3C50084844291A00uLL) >> 0),
     (VUINT32) ((0x3C50084844291A00uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F92E3863C9A69E0uLL) >> 0),
     (VUINT32) ((0x3F92E3863C9A69E0uLL) >> 32)},
    {(VUINT32) ((0xBFC1B4854BB2B147uLL) >> 0),
     (VUINT32) ((0xBFC1B4854BB2B147uLL) >> 32)},
    {(VUINT32) ((0x3FD6EDDE5416DFFBuLL) >> 0),
     (VUINT32) ((0x3FD6EDDE5416DFFBuLL) >> 32)},
    {(VUINT32) ((0xBFB8429341CCA17AuLL) >> 0),
     (VUINT32) ((0xBFB8429341CCA17AuLL) >> 32)},
    {(VUINT32) ((0x3FC3D49AC2C9F46EuLL) >> 0),
     (VUINT32) ((0x3FC3D49AC2C9F46EuLL) >> 32)},
    {(VUINT32) ((0xBFAC85843914CF63uLL) >> 0),
     (VUINT32) ((0xBFAC85843914CF63uLL) >> 32)},
    {(VUINT32) ((0x3FB1B1DC3FA41043uLL) >> 0),
     (VUINT32) ((0x3FB1B1DC3FA41043uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF72B53B1AED992uLL) >> 0),
     (VUINT32) ((0xBFF72B53B1AED992uLL) >> 32)},
    {(VUINT32) ((0xBC98452B3716C4D6uLL) >> 0),
     (VUINT32) ((0xBC98452B3716C4D6uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBF93183A8DB9E9uLL) >> 0),
     (VUINT32) ((0xBFBF93183A8DB9E9uLL) >> 32)},
    {(VUINT32) ((0x3C4124AC452DA622uLL) >> 0),
     (VUINT32) ((0x3C4124AC452DA622uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F8F27A3181EE680uLL) >> 0),
     (VUINT32) ((0x3F8F27A3181EE680uLL) >> 32)},
    {(VUINT32) ((0xBFC00707549D7ECCuLL) >> 0),
     (VUINT32) ((0xBFC00707549D7ECCuLL) >> 32)},
    {(VUINT32) ((0x3FD6A5716B500730uLL) >> 0),
     (VUINT32) ((0x3FD6A5716B500730uLL) >> 32)},
    {(VUINT32) ((0xBFB5DB89BB6B245FuLL) >> 0),
     (VUINT32) ((0xBFB5DB89BB6B245FuLL) >> 32)},
    {(VUINT32) ((0x3FC3554867F59647uLL) >> 0),
     (VUINT32) ((0x3FC3554867F59647uLL) >> 32)},
    {(VUINT32) ((0xBFA98919BF6D1AC0uLL) >> 0),
     (VUINT32) ((0xBFA98919BF6D1AC0uLL) >> 32)},
    {(VUINT32) ((0x3FB1AF9A18244AC2uLL) >> 0),
     (VUINT32) ((0x3FB1AF9A18244AC2uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF75D97A85761EDuLL) >> 0),
     (VUINT32) ((0xBFF75D97A85761EDuLL) >> 32)},
    {(VUINT32) ((0x3C9B97887C831272uLL) >> 0),
     (VUINT32) ((0x3C9B97887C831272uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFBC63CE377FC802uLL) >> 0),
     (VUINT32) ((0xBFBC63CE377FC802uLL) >> 32)},
    {(VUINT32) ((0x3C543F7D42D9FFC4uLL) >> 0),
     (VUINT32) ((0x3C543F7D42D9FFC4uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F892FE02A47EFA0uLL) >> 0),
     (VUINT32) ((0x3F892FE02A47EFA0uLL) >> 32)},
    {(VUINT32) ((0xBFBCBD3001C956C5uLL) >> 0),
     (VUINT32) ((0xBFBCBD3001C956C5uLL) >> 32)},
    {(VUINT32) ((0x3FD664790F293C47uLL) >> 0),
     (VUINT32) ((0x3FD664790F293C47uLL) >> 32)},
    {(VUINT32) ((0xBFB38345DE7C4B0BuLL) >> 0),
     (VUINT32) ((0xBFB38345DE7C4B0BuLL) >> 32)},
    {(VUINT32) ((0x3FC2E3C4C02FFDF9uLL) >> 0),
     (VUINT32) ((0x3FC2E3C4C02FFDF9uLL) >> 32)},
    {(VUINT32) ((0xBFA6AA7F0C135018uLL) >> 0),
     (VUINT32) ((0xBFA6AA7F0C135018uLL) >> 32)},
    {(VUINT32) ((0x3FAFE3C754ACF687uLL) >> 0),
     (VUINT32) ((0x3FAFE3C754ACF687uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF78FDB9EFFEA47uLL) >> 0),
     (VUINT32) ((0xBFF78FDB9EFFEA47uLL) >> 32)},
    {(VUINT32) ((0x3C8EE8786039D373uLL) >> 0),
     (VUINT32) ((0x3C8EE8786039D373uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB936BB8C5B2DA2uLL) >> 0),
     (VUINT32) ((0xBFB936BB8C5B2DA2uLL) >> 32)},
    {(VUINT32) ((0xBC587D23392D360CuLL) >> 0),
     (VUINT32) ((0xBC587D23392D360CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F83DDE2A8935DE0uLL) >> 0),
     (VUINT32) ((0x3F83DDE2A8935DE0uLL) >> 32)},
    {(VUINT32) ((0xBFB97558DC230BA8uLL) >> 0),
     (VUINT32) ((0xBFB97558DC230BA8uLL) >> 32)},
    {(VUINT32) ((0x3FD62AC976FBC1B8uLL) >> 0),
     (VUINT32) ((0x3FD62AC976FBC1B8uLL) >> 32)},
    {(VUINT32) ((0xBFB1381EB60159F6uLL) >> 0),
     (VUINT32) ((0xBFB1381EB60159F6uLL) >> 32)},
    {(VUINT32) ((0x3FC27F84438D5027uLL) >> 0),
     (VUINT32) ((0x3FC27F84438D5027uLL) >> 32)},
    {(VUINT32) ((0xBFA3E63B3A462D11uLL) >> 0),
     (VUINT32) ((0xBFA3E63B3A462D11uLL) >> 32)},
    {(VUINT32) ((0x3FAF0AE614B60705uLL) >> 0),
     (VUINT32) ((0x3FAF0AE614B60705uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF7C21F95A872A1uLL) >> 0),
     (VUINT32) ((0xBFF7C21F95A872A1uLL) >> 32)},
    {(VUINT32) ((0x3C6A877F1DB6080CuLL) >> 0),
     (VUINT32) ((0x3C6A877F1DB6080CuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB60B9F7597FDECuLL) >> 0),
     (VUINT32) ((0xBFB60B9F7597FDECuLL) >> 32)},
    {(VUINT32) ((0xBC3D1E3FBF349CC0uLL) >> 0),
     (VUINT32) ((0xBC3D1E3FBF349CC0uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F7E5FFEF4D8DFC0uLL) >> 0),
     (VUINT32) ((0x3F7E5FFEF4D8DFC0uLL) >> 32)},
    {(VUINT32) ((0xBFB6357984E124B6uLL) >> 0),
     (VUINT32) ((0xBFB6357984E124B6uLL) >> 32)},
    {(VUINT32) ((0x3FD5F83BF8B56900uLL) >> 0),
     (VUINT32) ((0x3FD5F83BF8B56900uLL) >> 32)},
    {(VUINT32) ((0xBFADF0F50CAA06C2uLL) >> 0),
     (VUINT32) ((0xBFADF0F50CAA06C2uLL) >> 32)},
    {(VUINT32) ((0x3FC228147690425DuLL) >> 0),
     (VUINT32) ((0x3FC228147690425DuLL) >> 32)},
    {(VUINT32) ((0xBFA138F0F640FF12uLL) >> 0),
     (VUINT32) ((0xBFA138F0F640FF12uLL) >> 32)},
    {(VUINT32) ((0x3FAF8D1BCDD067BDuLL) >> 0),
     (VUINT32) ((0x3FAF8D1BCDD067BDuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF7F4638C50FAFBuLL) >> 0),
     (VUINT32) ((0xBFF7F4638C50FAFBuLL) >> 32)},
    {(VUINT32) ((0xBC81A4B8D15ECF6DuLL) >> 0),
     (VUINT32) ((0xBC81A4B8D15ECF6DuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFB2E239CCFF3831uLL) >> 0),
     (VUINT32) ((0xBFB2E239CCFF3831uLL) >> 32)},
    {(VUINT32) ((0xBC5879ED3FF4D06CuLL) >> 0),
     (VUINT32) ((0xBC5879ED3FF4D06CuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F764980AEEE3740uLL) >> 0),
     (VUINT32) ((0x3F764980AEEE3740uLL) >> 32)},
    {(VUINT32) ((0xBFB2FC879C81123CuLL) >> 0),
     (VUINT32) ((0xBFB2FC879C81123CuLL) >> 32)},
    {(VUINT32) ((0x3FD5CCAEDC1DC96EuLL) >> 0),
     (VUINT32) ((0x3FD5CCAEDC1DC96EuLL) >> 32)},
    {(VUINT32) ((0xBFA98599B71D86B1uLL) >> 0),
     (VUINT32) ((0xBFA98599B71D86B1uLL) >> 32)},
    {(VUINT32) ((0x3FC1DD150D55E5CEuLL) >> 0),
     (VUINT32) ((0x3FC1DD150D55E5CEuLL) >> 32)},
    {(VUINT32) ((0xBF9D3EB9450DBD20uLL) >> 0),
     (VUINT32) ((0xBF9D3EB9450DBD20uLL) >> 32)},
    {(VUINT32) ((0x3FADD6CFBE9A9DDEuLL) >> 0),
     (VUINT32) ((0x3FADD6CFBE9A9DDEuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF826A782F98355uLL) >> 0),
     (VUINT32) ((0xBFF826A782F98355uLL) >> 32)},
    {(VUINT32) ((0xBC94F5A8B515906FuLL) >> 0),
     (VUINT32) ((0xBC94F5A8B515906FuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFAF7495EA3F3783uLL) >> 0),
     (VUINT32) ((0xBFAF7495EA3F3783uLL) >> 32)},
    {(VUINT32) ((0x3C407F10D50F8AC9uLL) >> 0),
     (VUINT32) ((0x3C407F10D50F8AC9uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F6EEB8B377B1A00uLL) >> 0),
     (VUINT32) ((0x3F6EEB8B377B1A00uLL) >> 32)},
    {(VUINT32) ((0xBFAF92FABFD0B7B3uLL) >> 0),
     (VUINT32) ((0xBFAF92FABFD0B7B3uLL) >> 32)},
    {(VUINT32) ((0x3FD5A805341437FFuLL) >> 0),
     (VUINT32) ((0x3FD5A805341437FFuLL) >> 32)},
    {(VUINT32) ((0xBFA52B295E2DCF92uLL) >> 0),
     (VUINT32) ((0xBFA52B295E2DCF92uLL) >> 32)},
    {(VUINT32) ((0x3FC19E2C59B8C033uLL) >> 0),
     (VUINT32) ((0x3FC19E2C59B8C033uLL) >> 32)},
    {(VUINT32) ((0xBF982CF88466F013uLL) >> 0),
     (VUINT32) ((0xBF982CF88466F013uLL) >> 32)},
    {(VUINT32) ((0x3FAD27509D6C3D7CuLL) >> 0),
     (VUINT32) ((0x3FAD27509D6C3D7CuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF858EB79A20BB0uLL) >> 0),
     (VUINT32) ((0xBFF858EB79A20BB0uLL) >> 32)},
    {(VUINT32) ((0x3C9EE70AFE8446D9uLL) >> 0),
     (VUINT32) ((0x3C9EE70AFE8446D9uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA927278A3B1162uLL) >> 0),
     (VUINT32) ((0xBFA927278A3B1162uLL) >> 32)},
    {(VUINT32) ((0xBBFB01BD7F1D4620uLL) >> 0),
     (VUINT32) ((0xBBFB01BD7F1D4620uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F63C55DB08E1680uLL) >> 0),
     (VUINT32) ((0x3F63C55DB08E1680uLL) >> 32)},
    {(VUINT32) ((0xBFA936B1EC652161uLL) >> 0),
     (VUINT32) ((0xBFA936B1EC652161uLL) >> 32)},
    {(VUINT32) ((0x3FD58A26BD6CCCCDuLL) >> 0),
     (VUINT32) ((0x3FD58A26BD6CCCCDuLL) >> 32)},
    {(VUINT32) ((0xBFA0DEB5445B4095uLL) >> 0),
     (VUINT32) ((0xBFA0DEB5445B4095uLL) >> 32)},
    {(VUINT32) ((0x3FC16B146127E0E0uLL) >> 0),
     (VUINT32) ((0x3FC16B146127E0E0uLL) >> 32)},
    {(VUINT32) ((0xBF9336A9836851D5uLL) >> 0),
     (VUINT32) ((0xBF9336A9836851D5uLL) >> 32)},
    {(VUINT32) ((0x3FAC19302F7F3ACCuLL) >> 0),
     (VUINT32) ((0x3FAC19302F7F3ACCuLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF88B2F704A940AuLL) >> 0),
     (VUINT32) ((0xBFF88B2F704A940AuLL) >> 32)},
    {(VUINT32) ((0x3C92C3BEB21E1E21uLL) >> 0),
     (VUINT32) ((0x3C92C3BEB21E1E21uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBFA2DBAAE9A05DB0uLL) >> 0),
     (VUINT32) ((0xBFA2DBAAE9A05DB0uLL) >> 32)},
    {(VUINT32) ((0x3C4371F88E195029uLL) >> 0),
     (VUINT32) ((0x3C4371F88E195029uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F563A086B860B00uLL) >> 0),
     (VUINT32) ((0x3F563A086B860B00uLL) >> 32)},
    {(VUINT32) ((0xBFA2E23785EEB488uLL) >> 0),
     (VUINT32) ((0xBFA2E23785EEB488uLL) >> 32)},
    {(VUINT32) ((0x3FD572FFC353B741uLL) >> 0),
     (VUINT32) ((0x3FD572FFC353B741uLL) >> 32)},
    {(VUINT32) ((0xBF993ABD2276BF58uLL) >> 0),
     (VUINT32) ((0xBF993ABD2276BF58uLL) >> 32)},
    {(VUINT32) ((0x3FC143926088643DuLL) >> 0),
     (VUINT32) ((0x3FC143926088643DuLL) >> 32)},
    {(VUINT32) ((0xBF8CAC359DDE7BCEuLL) >> 0),
     (VUINT32) ((0xBF8CAC359DDE7BCEuLL) >> 32)},
    {(VUINT32) ((0x3FAB56F9A2A6CD28uLL) >> 0),
     (VUINT32) ((0x3FAB56F9A2A6CD28uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF8BD7366F31C64uLL) >> 0),
     (VUINT32) ((0xBFF8BD7366F31C64uLL) >> 32)},
    {(VUINT32) ((0x3C7A81C996DFD5A5uLL) >> 0),
     (VUINT32) ((0x3C7A81C996DFD5A5uLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF992346247A91F0uLL) >> 0),
     (VUINT32) ((0xBF992346247A91F0uLL) >> 32)},
    {(VUINT32) ((0x3BF126D920C63160uLL) >> 0),
     (VUINT32) ((0x3BF126D920C63160uLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F43BF447B091000uLL) >> 0),
     (VUINT32) ((0x3F43BF447B091000uLL) >> 32)},
    {(VUINT32) ((0xBF992726F0F98D7FuLL) >> 0),
     (VUINT32) ((0xBF992726F0F98D7FuLL) >> 32)},
    {(VUINT32) ((0x3FD5628108EFA55CuLL) >> 0),
     (VUINT32) ((0x3FD5628108EFA55CuLL) >> 32)},
    {(VUINT32) ((0xBF90C8A60639C114uLL) >> 0),
     (VUINT32) ((0xBF90C8A60639C114uLL) >> 32)},
    {(VUINT32) ((0x3FC127789EC0BD38uLL) >> 0),
     (VUINT32) ((0x3FC127789EC0BD38uLL) >> 32)},
    {(VUINT32) ((0xBF830BA6F46C58D9uLL) >> 0),
     (VUINT32) ((0xBF830BA6F46C58D9uLL) >> 32)},
    {(VUINT32) ((0x3FABBEE2C1E62B03uLL) >> 0),
     (VUINT32) ((0x3FABBEE2C1E62B03uLL) >> 32)},
    },

   {
    {(VUINT32) ((0xBFF8EFB75D9BA4BEuLL) >> 0),
     (VUINT32) ((0xBFF8EFB75D9BA4BEuLL) >> 32)},
    {(VUINT32) ((0xBC760B679AB8CD3BuLL) >> 0),
     (VUINT32) ((0xBC760B679AB8CD3BuLL) >> 32)},
    {(VUINT32) ((0x0000000000000000uLL) >> 0),
     (VUINT32) ((0x0000000000000000uLL) >> 32)},
    {(VUINT32) ((0xBF89224E047E368EuLL) >> 0),
     (VUINT32) ((0xBF89224E047E368EuLL) >> 32)},
    {(VUINT32) ((0x3C1A268EB3BB9B7AuLL) >> 0),
     (VUINT32) ((0x3C1A268EB3BB9B7AuLL) >> 32)},
    {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
     (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
    {(VUINT32) ((0x3F23BDBEAD8CF800uLL) >> 0),
     (VUINT32) ((0x3F23BDBEAD8CF800uLL) >> 32)},
    {(VUINT32) ((0xBF8923461AE96D62uLL) >> 0),
     (VUINT32) ((0xBF8923461AE96D62uLL) >> 32)},
    {(VUINT32) ((0x3FD5589FB822D5EEuLL) >> 0),
     (VUINT32) ((0x3FD5589FB822D5EEuLL) >> 32)},
    {(VUINT32) ((0xBF80C326DCDCFCD2uLL) >> 0),
     (VUINT32) ((0xBF80C326DCDCFCD2uLL) >> 32)},
    {(VUINT32) ((0x3FC116A999125B8AuLL) >> 0),
     (VUINT32) ((0x3FC116A999125B8AuLL) >> 32)},
    {(VUINT32) ((0xBF7300CC26580304uLL) >> 0),
     (VUINT32) ((0xBF7300CC26580304uLL) >> 32)},
    {(VUINT32) ((0x3FAB7B6F1DCF22D1uLL) >> 0),
     (VUINT32) ((0x3FAB7B6F1DCF22D1uLL) >> 32)},
    },
   },

  {(VUINT32) ((0x40FF400000000000uLL) >> 0),
   (VUINT32) ((0x40FF400000000000uLL) >> 32)},

  {(VUINT32) ((0x8000000000000000uLL) >> 0),
   (VUINT32) ((0x8000000000000000uLL) >> 32)},
  {(VUINT32) ((0x3FE45F306DC9C883uLL) >> 0),
   (VUINT32) ((0x3FE45F306DC9C883uLL) >> 32)},

  {(VUINT32) ((0x3FF921FB40000000uLL) >> 0),
   (VUINT32) ((0x3FF921FB40000000uLL) >> 32)},
  {(VUINT32) ((0x3E74442D00000000uLL) >> 0),
   (VUINT32) ((0x3E74442D00000000uLL) >> 32)},
  {(VUINT32) ((0x3CF8469880000000uLL) >> 0),
   (VUINT32) ((0x3CF8469880000000uLL) >> 32)},
  {(VUINT32) ((0x3B78CC51701B839AuLL) >> 0),
   (VUINT32) ((0x3B78CC51701B839AuLL) >> 32)},

  {(VUINT32) ((0x3ff921fb54442d18uLL) >> 0),
   (VUINT32) ((0x3ff921fb54442d18uLL) >> 32)},
  {(VUINT32) ((0x3c91a62633145c06uLL) >> 0),
   (VUINT32) ((0x3c91a62633145c06uLL) >> 32)},
  {(VUINT32) ((0x394c1cd129024e09uLL) >> 0),
   (VUINT32) ((0x394c1cd129024e09uLL) >> 32)},
  {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
   (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
  {(VUINT32) ((0xBFC06B97BF03648AuLL) >> 0),
   (VUINT32) ((0xBFC06B97BF03648AuLL) >> 32)},
  {(VUINT32) ((0x3F66FC6FE2982A7BuLL) >> 0),
   (VUINT32) ((0x3F66FC6FE2982A7BuLL) >> 32)},
  {(VUINT32) ((0xBEDF637DEA7C0B2CuLL) >> 0),
   (VUINT32) ((0xBEDF637DEA7C0B2CuLL) >> 32)},
  {(VUINT32) ((0x3FF0000000000000uLL) >> 0),
   (VUINT32) ((0x3FF0000000000000uLL) >> 32)},
  {(VUINT32) ((0xBFDD8B2134D70767uLL) >> 0),
   (VUINT32) ((0xBFDD8B2134D70767uLL) >> 32)},
  {(VUINT32) ((0x3F97E7B68D9A55F3uLL) >> 0),
   (VUINT32) ((0x3F97E7B68D9A55F3uLL) >> 32)},
  {(VUINT32) ((0xBF2B525B10D0A168uLL) >> 0),
   (VUINT32) ((0xBF2B525B10D0A168uLL) >> 32)},

};

#endif
