#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-room-confroom@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"
echo 'never' > "$PREFS/$USER/organiser_replacement"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& ! grep -q '^FREEBUSY' out1.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=ACCEPTED' out2.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REPLY' out3.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T160000Z' out3.tmp \
&& echo "Success" \
|| echo "Failed"

# Try to change to an unrecognised organiser.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-imposter.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   ! grep -q 'METHOD:REPLY' out4.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out5.tmp

   grep -q 'METHOD:REPLY' out5.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T160000Z' out5.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T153000Z/20141126T160000Z' out5.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T151500Z/20141126T160000Z' out5.tmp \
&& echo "Success" \
|| echo "Failed"

# Try to change to an attendee as organiser.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-imposter-attendee.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out6.tmp

   ! grep -q 'METHOD:REPLY' out6.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out7.tmp

   grep -q 'METHOD:REPLY' out7.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T160000Z' out7.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T153000Z/20141126T160000Z' out7.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T151500Z/20141126T160000Z' out7.tmp \
&& echo "Success" \
|| echo "Failed"

# Change the policy.

echo 'attendee' > "$PREFS/$USER/organiser_replacement"

# Try to change to an attendee as organiser.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-imposter-attendee.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out8.tmp

   grep -q 'METHOD:REPLY' out8.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out9.tmp

   grep -q 'METHOD:REPLY' out9.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T160000Z' out9.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T153000Z/20141126T160000Z' out9.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T151500Z/20141126T160000Z' out9.tmp \
&& echo "Success" \
|| echo "Failed"

# Try to change to an unrecognised organiser.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-imposter.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out10.tmp

   ! grep -q 'METHOD:REPLY' out10.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out11.tmp

   grep -q 'METHOD:REPLY' out11.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T160000Z' out11.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T153000Z/20141126T160000Z' out11.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T151500Z/20141126T160000Z' out11.tmp \
&& echo "Success" \
|| echo "Failed"

# Change the policy.

echo 'any' > "$PREFS/$USER/organiser_replacement"

# Try to change to an unrecognised organiser.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-imposter.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out12.tmp

   grep -q 'METHOD:REPLY' out12.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out13.tmp

   grep -q 'METHOD:REPLY' out13.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T160000Z' out13.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T153000Z/20141126T160000Z' out13.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T151500Z/20141126T160000Z' out13.tmp \
&& echo "Success" \
|| echo "Failed"

# Try to change to an attendee as organiser.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-imposter-attendee.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out14.tmp

   grep -q 'METHOD:REPLY' out14.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out15.tmp

   grep -q 'METHOD:REPLY' out15.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T150000Z/20141126T160000Z' out15.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T153000Z/20141126T160000Z' out15.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141126T151500Z/20141126T160000Z' out15.tmp \
&& echo "Success" \
|| echo "Failed"
