package resourcehealth

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/resourcehealth/mgmt/2020-05-01/resourcehealth"

// AvailabilityStatus availabilityStatus of a resource.
type AvailabilityStatus struct {
	autorest.Response `json:"-"`
	// ID - Azure Resource Manager Identity for the availabilityStatuses resource.
	ID *string `json:"id,omitempty"`
	// Name - current.
	Name *string `json:"name,omitempty"`
	// Type - Microsoft.ResourceHealth/AvailabilityStatuses.
	Type *string `json:"type,omitempty"`
	// Location - Azure Resource Manager geo location of the resource.
	Location *string `json:"location,omitempty"`
	// Properties - Properties of availability state.
	Properties *AvailabilityStatusProperties `json:"properties,omitempty"`
}

// AvailabilityStatusListResult the List availabilityStatus operation response.
type AvailabilityStatusListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of availabilityStatuses.
	Value *[]AvailabilityStatus `json:"value,omitempty"`
	// NextLink - The URI to fetch the next page of availabilityStatuses. Call ListNext() with this URI to fetch the next page of availabilityStatuses.
	NextLink *string `json:"nextLink,omitempty"`
}

// AvailabilityStatusListResultIterator provides access to a complete listing of AvailabilityStatus values.
type AvailabilityStatusListResultIterator struct {
	i    int
	page AvailabilityStatusListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailabilityStatusListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailabilityStatusListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailabilityStatusListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailabilityStatusListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailabilityStatusListResultIterator) Response() AvailabilityStatusListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailabilityStatusListResultIterator) Value() AvailabilityStatus {
	if !iter.page.NotDone() {
		return AvailabilityStatus{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailabilityStatusListResultIterator type.
func NewAvailabilityStatusListResultIterator(page AvailabilityStatusListResultPage) AvailabilityStatusListResultIterator {
	return AvailabilityStatusListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aslr AvailabilityStatusListResult) IsEmpty() bool {
	return aslr.Value == nil || len(*aslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aslr AvailabilityStatusListResult) hasNextLink() bool {
	return aslr.NextLink != nil && len(*aslr.NextLink) != 0
}

// availabilityStatusListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aslr AvailabilityStatusListResult) availabilityStatusListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aslr.NextLink)))
}

// AvailabilityStatusListResultPage contains a page of AvailabilityStatus values.
type AvailabilityStatusListResultPage struct {
	fn   func(context.Context, AvailabilityStatusListResult) (AvailabilityStatusListResult, error)
	aslr AvailabilityStatusListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailabilityStatusListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailabilityStatusListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aslr)
		if err != nil {
			return err
		}
		page.aslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailabilityStatusListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailabilityStatusListResultPage) NotDone() bool {
	return !page.aslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailabilityStatusListResultPage) Response() AvailabilityStatusListResult {
	return page.aslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailabilityStatusListResultPage) Values() []AvailabilityStatus {
	if page.aslr.IsEmpty() {
		return nil
	}
	return *page.aslr.Value
}

// Creates a new instance of the AvailabilityStatusListResultPage type.
func NewAvailabilityStatusListResultPage(cur AvailabilityStatusListResult, getNextPage func(context.Context, AvailabilityStatusListResult) (AvailabilityStatusListResult, error)) AvailabilityStatusListResultPage {
	return AvailabilityStatusListResultPage{
		fn:   getNextPage,
		aslr: cur,
	}
}

// AvailabilityStatusProperties properties of availability state.
type AvailabilityStatusProperties struct {
	// AvailabilityState - Availability status of the resource. When it is null, this availabilityStatus object represents an availability impacting event. Possible values include: 'AvailabilityStateValuesAvailable', 'AvailabilityStateValuesUnavailable', 'AvailabilityStateValuesDegraded', 'AvailabilityStateValuesUnknown'
	AvailabilityState AvailabilityStateValues `json:"availabilityState,omitempty"`
	// Title - Title description of the availability status.
	Title *string `json:"title,omitempty"`
	// Summary - Summary description of the availability status.
	Summary *string `json:"summary,omitempty"`
	// DetailedStatus - Details of the availability status.
	DetailedStatus *string `json:"detailedStatus,omitempty"`
	// ReasonType - When the resource's availabilityState is Unavailable, it describes where the health impacting event was originated. Examples are planned, unplanned, user initiated or an outage etc.
	ReasonType *string `json:"reasonType,omitempty"`
	// RootCauseAttributionTime - When the resource's availabilityState is Unavailable, it provides the Timestamp for when the health impacting event was received.
	RootCauseAttributionTime *date.Time `json:"rootCauseAttributionTime,omitempty"`
	// HealthEventType - In case of an availability impacting event, it describes when the health impacting event was originated. Examples are Lifecycle, Downtime, Fault Analysis etc.
	HealthEventType *string `json:"healthEventType,omitempty"`
	// HealthEventCause - In case of an availability impacting event, it describes where the health impacting event was originated. Examples are PlatformInitiated, UserInitiated etc.
	HealthEventCause *string `json:"healthEventCause,omitempty"`
	// HealthEventCategory - In case of an availability impacting event, it describes the category of a PlatformInitiated health impacting event. Examples are Planned, Unplanned etc.
	HealthEventCategory *string `json:"healthEventCategory,omitempty"`
	// HealthEventID - It is a unique Id that identifies the event
	HealthEventID *string `json:"healthEventId,omitempty"`
	// ResolutionETA - When the resource's availabilityState is Unavailable and the reasonType is not User Initiated, it provides the date and time for when the issue is expected to be resolved.
	ResolutionETA *date.Time `json:"resolutionETA,omitempty"`
	// OccurredTime - Timestamp for when last change in health status occurred.
	OccurredTime *date.Time `json:"occurredTime,omitempty"`
	// ReasonChronicity - Chronicity of the availability transition. Possible values include: 'ReasonChronicityTypesTransient', 'ReasonChronicityTypesPersistent'
	ReasonChronicity ReasonChronicityTypes `json:"reasonChronicity,omitempty"`
	// ReportedTime - Timestamp for when the health was last checked.
	ReportedTime *date.Time `json:"reportedTime,omitempty"`
	// RecentlyResolved - An annotation describing a change in the availabilityState to Available from Unavailable with a reasonType of type Unplanned
	RecentlyResolved *AvailabilityStatusPropertiesRecentlyResolved `json:"recentlyResolved,omitempty"`
	// RecommendedActions - Lists actions the user can take based on the current availabilityState of the resource.
	RecommendedActions *[]RecommendedAction `json:"recommendedActions,omitempty"`
	// ServiceImpactingEvents - Lists the service impacting events that may be affecting the health of the resource.
	ServiceImpactingEvents *[]ServiceImpactingEvent `json:"serviceImpactingEvents,omitempty"`
}

// AvailabilityStatusPropertiesRecentlyResolved an annotation describing a change in the availabilityState
// to Available from Unavailable with a reasonType of type Unplanned
type AvailabilityStatusPropertiesRecentlyResolved struct {
	// UnavailableOccurredTime - Timestamp for when the availabilityState changed to Unavailable
	UnavailableOccurredTime *date.Time `json:"unavailableOccurredTime,omitempty"`
	// ResolvedTime - Timestamp when the availabilityState changes to Available.
	ResolvedTime *date.Time `json:"resolvedTime,omitempty"`
	// UnavailabilitySummary - Brief description of cause of the resource becoming unavailable.
	UnavailabilitySummary *string `json:"unavailabilitySummary,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse error details.
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorResponseError `json:"error,omitempty"`
}

// ErrorResponseError the error object.
type ErrorResponseError struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *string `json:"details,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponseError.
func (er ErrorResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ImpactedRegion object of impacted region.
type ImpactedRegion struct {
	// ID - The impacted region id.
	ID *string `json:"id,omitempty"`
	// Name - The impacted region name.
	Name *string `json:"name,omitempty"`
}

// ImpactedResourceStatus impactedResource with health status
type ImpactedResourceStatus struct {
	// ImpactedResourceStatusProperties - Properties of impacted resource status.
	*ImpactedResourceStatusProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImpactedResourceStatus.
func (irs ImpactedResourceStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if irs.ImpactedResourceStatusProperties != nil {
		objectMap["properties"] = irs.ImpactedResourceStatusProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImpactedResourceStatus struct.
func (irs *ImpactedResourceStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var impactedResourceStatusProperties ImpactedResourceStatusProperties
				err = json.Unmarshal(*v, &impactedResourceStatusProperties)
				if err != nil {
					return err
				}
				irs.ImpactedResourceStatusProperties = &impactedResourceStatusProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				irs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				irs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				irs.Type = &typeVar
			}
		}
	}

	return nil
}

// ImpactedResourceStatusProperties properties of impacted resource status.
type ImpactedResourceStatusProperties struct {
	// AvailabilityState - Impacted resource status of the resource. Possible values include: 'AvailabilityStateValuesAvailable', 'AvailabilityStateValuesUnavailable', 'AvailabilityStateValuesDegraded', 'AvailabilityStateValuesUnknown'
	AvailabilityState AvailabilityStateValues `json:"availabilityState,omitempty"`
	// Title - Title description of the impacted resource status.
	Title *string `json:"title,omitempty"`
	// Summary - Summary description of the impacted resource status.
	Summary *string `json:"summary,omitempty"`
	// ReasonType - When the resource's availabilityState is Unavailable, it describes where the health impacting event was originated. Possible values include: 'ReasonTypeValuesUnplanned', 'ReasonTypeValuesPlanned', 'ReasonTypeValuesUserInitiated'
	ReasonType ReasonTypeValues `json:"reasonType,omitempty"`
	// OccurredTime - Timestamp for when last change in health status occurred.
	OccurredTime *date.Time `json:"occurredTime,omitempty"`
}

// Operation operation available in the resourcehealth resource provider.
type Operation struct {
	// Name - Name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - Properties of the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay properties of the operation.
type OperationDisplay struct {
	// Provider - Provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation name.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult lists the operations response.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations available in the resourcehealth resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RecommendedAction lists actions the user can take based on the current availabilityState of the
// resource.
type RecommendedAction struct {
	// Action - Recommended action.
	Action *string `json:"action,omitempty"`
	// ActionURL - Link to the action
	ActionURL *string `json:"actionUrl,omitempty"`
	// ActionURLText - Substring of action, it describes which text should host the action url.
	ActionURLText *string `json:"actionUrlText,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServiceImpactingEvent lists the service impacting events that may be affecting the health of the
// resource.
type ServiceImpactingEvent struct {
	// EventStartTime - Timestamp for when the event started.
	EventStartTime *date.Time `json:"eventStartTime,omitempty"`
	// EventStatusLastModifiedTime - Timestamp for when event was submitted/detected.
	EventStatusLastModifiedTime *date.Time `json:"eventStatusLastModifiedTime,omitempty"`
	// CorrelationID - Correlation id for the event
	CorrelationID *string `json:"correlationId,omitempty"`
	// Status - Status of the service impacting event.
	Status *ServiceImpactingEventStatus `json:"status,omitempty"`
	// IncidentProperties - Properties of the service impacting event.
	IncidentProperties *ServiceImpactingEventIncidentProperties `json:"incidentProperties,omitempty"`
}

// ServiceImpactingEventIncidentProperties properties of the service impacting event.
type ServiceImpactingEventIncidentProperties struct {
	// Title - Title of the incident.
	Title *string `json:"title,omitempty"`
	// Service - Service impacted by the event.
	Service *string `json:"service,omitempty"`
	// Region - Region impacted by the event.
	Region *string `json:"region,omitempty"`
	// IncidentType - Type of Event.
	IncidentType *string `json:"incidentType,omitempty"`
}

// ServiceImpactingEventStatus status of the service impacting event.
type ServiceImpactingEventStatus struct {
	// Value - Current status of the event
	Value *string `json:"value,omitempty"`
}

// StatusBanner banner type of emerging issue.
type StatusBanner struct {
	// Title - The banner title.
	Title *string `json:"title,omitempty"`
	// Message - The details of banner.
	Message *string `json:"message,omitempty"`
	// Cloud - The cloud type of this banner.
	Cloud *string `json:"cloud,omitempty"`
	// LastModifiedTime - The last time modified on this banner.
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}
