// Code generated by smithy-go-codegen DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/storagegateway/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists custom tape pools. You specify custom tape pools to list by specifying
// one or more custom tape pool Amazon Resource Names (ARNs). If you don't specify
// a custom tape pool ARN, the operation lists all custom tape pools.
//
// This operation supports pagination. You can optionally specify the Limit
// parameter in the body to limit the number of tape pools in the response. If the
// number of tape pools returned in the response is truncated, the response
// includes a Marker element that you can use in your subsequent request to
// retrieve the next set of tape pools.
func (c *Client) ListTapePools(ctx context.Context, params *ListTapePoolsInput, optFns ...func(*Options)) (*ListTapePoolsOutput, error) {
	if params == nil {
		params = &ListTapePoolsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTapePools", params, optFns, c.addOperationListTapePoolsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTapePoolsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTapePoolsInput struct {

	// An optional number limit for the tape pools in the list returned by this call.
	Limit *int32

	// A string that indicates the position at which to begin the returned list of
	// tape pools.
	Marker *string

	// The Amazon Resource Name (ARN) of each of the custom tape pools you want to
	// list. If you don't specify a custom tape pool ARN, the response lists all custom
	// tape pools.
	PoolARNs []string

	noSmithyDocumentSerde
}

type ListTapePoolsOutput struct {

	// A string that indicates the position at which to begin the returned list of
	// tape pools. Use the marker in your next request to continue pagination of tape
	// pools. If there are no more tape pools to list, this element does not appear in
	// the response body.
	Marker *string

	// An array of PoolInfo objects, where each object describes a single custom tape
	// pool. If there are no custom tape pools, the PoolInfos is an empty array.
	PoolInfos []types.PoolInfo

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTapePoolsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListTapePools{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListTapePools{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTapePools"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTapePools(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTapePoolsPaginatorOptions is the paginator options for ListTapePools
type ListTapePoolsPaginatorOptions struct {
	// An optional number limit for the tape pools in the list returned by this call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTapePoolsPaginator is a paginator for ListTapePools
type ListTapePoolsPaginator struct {
	options   ListTapePoolsPaginatorOptions
	client    ListTapePoolsAPIClient
	params    *ListTapePoolsInput
	nextToken *string
	firstPage bool
}

// NewListTapePoolsPaginator returns a new ListTapePoolsPaginator
func NewListTapePoolsPaginator(client ListTapePoolsAPIClient, params *ListTapePoolsInput, optFns ...func(*ListTapePoolsPaginatorOptions)) *ListTapePoolsPaginator {
	if params == nil {
		params = &ListTapePoolsInput{}
	}

	options := ListTapePoolsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTapePoolsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTapePoolsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTapePools page.
func (p *ListTapePoolsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTapePoolsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTapePools(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.Marker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTapePoolsAPIClient is a client that implements the ListTapePools operation.
type ListTapePoolsAPIClient interface {
	ListTapePools(context.Context, *ListTapePoolsInput, ...func(*Options)) (*ListTapePoolsOutput, error)
}

var _ ListTapePoolsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTapePools(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTapePools",
	}
}
