// Code generated by smithy-go-codegen DO NOT EDIT.

package workmail

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/workmail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sets permissions for a user, group, or resource. This replaces any pre-existing
// permissions.
func (c *Client) PutMailboxPermissions(ctx context.Context, params *PutMailboxPermissionsInput, optFns ...func(*Options)) (*PutMailboxPermissionsOutput, error) {
	if params == nil {
		params = &PutMailboxPermissionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutMailboxPermissions", params, optFns, c.addOperationPutMailboxPermissionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutMailboxPermissionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutMailboxPermissionsInput struct {

	// The identifier of the user, group, or resource for which to update mailbox
	// permissions.
	//
	// This member is required.
	EntityId *string

	// The identifier of the user, group, or resource to which to grant the
	// permissions.
	//
	// This member is required.
	GranteeId *string

	// The identifier of the organization under which the user, group, or resource
	// exists.
	//
	// This member is required.
	OrganizationId *string

	// The permissions granted to the grantee. SEND_AS allows the grantee to send email
	// as the owner of the mailbox (the grantee is not mentioned on these emails).
	// SEND_ON_BEHALF allows the grantee to send email on behalf of the owner of the
	// mailbox (the grantee is not mentioned as the physical sender of these emails).
	// FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
	// folder-level permissions set on the mailbox.
	//
	// This member is required.
	PermissionValues []types.PermissionType

	noSmithyDocumentSerde
}

type PutMailboxPermissionsOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutMailboxPermissionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPutMailboxPermissions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPutMailboxPermissions{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpPutMailboxPermissionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutMailboxPermissions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutMailboxPermissions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "workmail",
		OperationName: "PutMailboxPermissions",
	}
}
