// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the specified verified destiona numbers.
func (c *Client) DescribeVerifiedDestinationNumbers(ctx context.Context, params *DescribeVerifiedDestinationNumbersInput, optFns ...func(*Options)) (*DescribeVerifiedDestinationNumbersOutput, error) {
	if params == nil {
		params = &DescribeVerifiedDestinationNumbersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeVerifiedDestinationNumbers", params, optFns, c.addOperationDescribeVerifiedDestinationNumbersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeVerifiedDestinationNumbersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeVerifiedDestinationNumbersInput struct {

	// An array of verified destination phone number, in E.164 format.
	DestinationPhoneNumbers []string

	// An array of VerifiedDestinationNumberFilter objects to filter the results.
	Filters []types.VerifiedDestinationNumberFilter

	// The maximum number of results to return per each request.
	MaxResults *int32

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	// An array of VerifiedDestinationNumberid to retreive.
	VerifiedDestinationNumberIds []string

	noSmithyDocumentSerde
}

type DescribeVerifiedDestinationNumbersOutput struct {

	// An array of VerifiedDestinationNumberInformation objects
	//
	// This member is required.
	VerifiedDestinationNumbers []types.VerifiedDestinationNumberInformation

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeVerifiedDestinationNumbersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeVerifiedDestinationNumbers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeVerifiedDestinationNumbers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeVerifiedDestinationNumbers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeVerifiedDestinationNumbersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeVerifiedDestinationNumbers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeVerifiedDestinationNumbersAPIClient is a client that implements the
// DescribeVerifiedDestinationNumbers operation.
type DescribeVerifiedDestinationNumbersAPIClient interface {
	DescribeVerifiedDestinationNumbers(context.Context, *DescribeVerifiedDestinationNumbersInput, ...func(*Options)) (*DescribeVerifiedDestinationNumbersOutput, error)
}

var _ DescribeVerifiedDestinationNumbersAPIClient = (*Client)(nil)

// DescribeVerifiedDestinationNumbersPaginatorOptions is the paginator options for
// DescribeVerifiedDestinationNumbers
type DescribeVerifiedDestinationNumbersPaginatorOptions struct {
	// The maximum number of results to return per each request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeVerifiedDestinationNumbersPaginator is a paginator for
// DescribeVerifiedDestinationNumbers
type DescribeVerifiedDestinationNumbersPaginator struct {
	options   DescribeVerifiedDestinationNumbersPaginatorOptions
	client    DescribeVerifiedDestinationNumbersAPIClient
	params    *DescribeVerifiedDestinationNumbersInput
	nextToken *string
	firstPage bool
}

// NewDescribeVerifiedDestinationNumbersPaginator returns a new
// DescribeVerifiedDestinationNumbersPaginator
func NewDescribeVerifiedDestinationNumbersPaginator(client DescribeVerifiedDestinationNumbersAPIClient, params *DescribeVerifiedDestinationNumbersInput, optFns ...func(*DescribeVerifiedDestinationNumbersPaginatorOptions)) *DescribeVerifiedDestinationNumbersPaginator {
	if params == nil {
		params = &DescribeVerifiedDestinationNumbersInput{}
	}

	options := DescribeVerifiedDestinationNumbersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeVerifiedDestinationNumbersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeVerifiedDestinationNumbersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeVerifiedDestinationNumbers page.
func (p *DescribeVerifiedDestinationNumbersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeVerifiedDestinationNumbersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeVerifiedDestinationNumbers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeVerifiedDestinationNumbers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeVerifiedDestinationNumbers",
	}
}
